/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.gantt.min",["kendo.data.min","kendo.resizable.min","kendo.switch.min","kendo.gantt.data.min","kendo.gantt.editors.min","kendo.gantt.list.min","kendo.gantt.timeline.min","kendo.pdf.min"],function(){var e={id:"gantt",name:"Gantt",category:"web",description:"The Gantt component.",depends:["data","resizable","switch","gantt.data","gantt.editors","gantt.list","gantt.timeline","pdf"]},a,w=window.kendo.jQuery,n=void 0,_=window.kendo,y=w.extend({F10:121},_.keys),v="matchMedia"in window,d=_.support.mobileOS,s=_.ui.Widget,f=_.data.ObservableObject,o=_.data.ObservableArray,p=_.data.Query,l=Array.isArray,u=w.inArray,g=_.isFunction,c=w.extend,h=w.isPlainObject,m=_._outerWidth,b=_._outerHeight,t=3,D=".kendoGantt",k="p0",x="tabIndex",R="click",H="string",r="aria-activedescendant",i,E="gantt_active_cell",T=".",B="Are you sure you want to delete this task?",W="Are you sure you want to delete this dependency?",I=_.template('<button class="k-button k-button-md k-rounded-md k-button-solid k-button-solid-base k-icon-button k-gantt-toggle" type="button" '+"aria-label"+'="Toggle"><span class="k-button-icon #=styles.iconToggle#"></span></button>'),A='<button aria-label="#=text#" class="#=styles.button# #=styles.buttonDefaults# #=className#" type="button" '+"#if (action) {#"+'data-action="#=action#"'+"#}#"+">"+'<span class="k-button-icon #=iconClass#"></span>'+'<span class="k-button-text">#=text#</span>'+"</button>",F='<a class="#=className#" #=attr# href="\\#"><span class="k-button-text">#=text#</span></a>',z=_.template('<select aria-label="#= label #" class="k-dropdown k-picker k-dropdown-list #= styles.viewsDropdown #">'+"#for(var view in views){#"+'<option value="#=view#">#=views[view].title#</option>'+"#}#"+"</select>"),P=_.template('<div class="#=styles.viewsWrapper#">'+'<span class="k-button-group #=styles.views#">'+"#for(var view in views){#"+'<button type="button" class="k-button k-button-md k-rounded-md k-button-solid k-button-solid-base k-view-#= view.toLowerCase() #" data-#=ns#name="#=view#">'+'<span class="k-button-text">#=views[view].title#</span>'+"</button>"+"#}#"+"</span>"+"</div>"),N={wrapper:"k-widget k-gantt",plannedTasks:"k-gantt-planned",rowHeight:"k-gantt-rowheight",content:"k-gantt-content",listWrapper:"k-gantt-treelist",list:"k-gantt-treelist",timelineWrapper:"k-gantt-timeline",timeline:"k-gantt-timeline",splitBarWrapper:"k-splitbar k-splitbar-horizontal k-splitbar-draggable-horizontal",splitBar:"k-splitbar",splitBarHover:"k-splitbar-horizontal-hover",popupWrapper:"k-list-container",popupList:"k-list k-reset",resizeHandle:"k-resize-handle",icon:"k-icon",item:"k-item",line:"k-gantt-line",buttonDelete:"k-gantt-delete",buttonCancel:"k-gantt-cancel",buttonSave:"k-gantt-update",buttonToggle:"k-gantt-toggle",buttonDefaults:"k-button-md k-rounded-md k-button-solid",primary:"k-button-solid-primary",hovered:"k-hover",selected:"k-selected",focused:"k-focus",focusedCell:"k-focus",gridHeader:"k-grid-header",gridHeaderWrap:"k-grid-header-wrap",gridContent:"k-grid-content",tasks:"k-gantt-tasks",popup:{form:"k-popup-edit-form",editForm:"k-gantt-edit-form",formContainer:"k-edit-form-container",resourcesFormContainer:"k-resources-form-container",message:"k-popup-message",buttonsContainer:"k-edit-buttons",button:"k-button",editField:"k-edit-field",editLabel:"k-edit-label",resourcesField:"k-gantt-resources"},toolbar:{headerWrapper:"k-gantt-header k-toolbar k-gantt-toolbar",footerWrapper:"k-gantt-footer k-toolbar k-gantt-toolbar",toolbar:"k-gantt-toolbar",views:"k-gantt-views",viewsWrapper:"k-gantt-views-wrapper",viewsDropdown:"k-views-dropdown",button:"k-button",buttonToggle:"k-gantt-toggle",buttonDefaults:"k-button-md k-rounded-md k-button-solid",iconPlus:"k-icon k-i-plus",iconPdf:"k-icon k-i-file-pdf",iconToggle:"k-icon k-i-layout-1-by-4",viewButton:"k-view",link:"k-link",pdfButton:"k-gantt-pdf",appendButton:"k-gantt-create"}};function S(e){return"["+_.attr("uid")+(e?"='"+e+"']":"]")}function L(e){delete e.name;delete e.prefix;delete e.remove;delete e.edit;delete e.add;delete e.navigate;return e}function U(t,e){var i=t.parents("["+_.attr("role")+'="gantt"]');var n=[];var s=V(i);t.attr(x,0);if(e)s.each(function(e,t){n[e]=w(t).scrollTop()});try{t[0].setActive()}catch(e){t[0].focus()}if(e)s.each(function(e,t){w(t).scrollTop(n[e])})}function V(e){return w(e).parentsUntil("body").filter(function(e,t){var i=_.getComputedStyles(t,["overflow"]);return i.overflow!="visible"}).add(window)}var C=s.extend({init:function(e,t,i){if(l(t))t={dataSource:t};a={append:{text:"Add Task",action:"add",className:C.styles.toolbar.appendButton+" k-button-solid-base",iconClass:C.styles.toolbar.iconPlus},pdf:{text:"Export to PDF",className:C.styles.toolbar.pdfButton+" k-button-solid-base",iconClass:C.styles.toolbar.iconPdf}};s.fn.init.call(this,e,t);if(i)this._events=i;this._wrapper();this._resources();if(!this.options.views||!this.options.views.length)this.options.views=["day","week","month"];this._timeline();this._toolbar();this._footer();this._adjustDimensions();this._preventRefresh=true;this.view(this.timeline._selectedViewName);this._preventRefresh=false;this._dataSource();this._assignments();this._dropDowns();this._list();this._dependencies();this._resizable();this._scrollable();this._dataBind();this._attachEvents();this._createEditor();_.notify(this)},events:["dataBinding","dataBound","add","edit","remove","cancel","save","change","navigate","moveStart","move","moveEnd","resizeStart","resize","resizeEnd","columnHide","columnReorder","columnResize","columnShow","togglePlannedTasks"],options:{name:"Gantt",autoBind:true,navigatable:false,selectable:true,editable:true,resizable:false,columnResizeHandleWidth:t,columns:[],views:[],dataSource:{},dependencies:{},resources:{},assignments:{},taskTemplate:null,messages:{save:"Save",cancel:"Cancel",destroy:"Delete",deleteTaskConfirmation:B,deleteDependencyConfirmation:W,deleteTaskWindowTitle:"Delete task",deleteDependencyWindowTitle:"Delete dependency",selectView:"Select view",views:{day:"Day",week:"Week",month:"Month",year:"Year",start:"Start",end:"End"},actions:{append:"Add Task",addChild:"Add Child",insertBefore:"Add Above",insertAfter:"Add Below",pdf:"Export to PDF"},editor:{editorTitle:"Task",resourcesEditorTitle:"Resources",title:"Title",start:"Start",end:"End",plannedStart:"Planned Start",plannedEnd:"Planned End",percentComplete:"Complete",resources:"Resources",assignButton:"Assign",resourcesHeader:"Resources",unitsHeader:"Units"},plannedTasks:{switchText:"Planned Tasks",offsetTooltipAdvanced:"Met deadline earlier",offsetTooltipDelay:"Delay",seconds:"seconds",minutes:"minutes",hours:"hours",days:"days"}},showWorkHours:true,showWorkDays:true,toolbar:null,workDayStart:new Date(1980,1,1,8,0,0),workDayEnd:new Date(1980,1,1,17,0,0),workWeekStart:1,workWeekEnd:5,hourSpan:1,snap:true,height:600,listWidth:"30%",rowHeight:null,showPlannedTasks:false},select:function(e){var t=this.list;if(!e)return t.select();if(typeof e===H)e=t.content.find(e);t.select(e);this._selectionUpdate();this.list.element.find("table[role=treegrid]").trigger("focus");return},clearSelection:function(){this.list.clearSelection();this.list.trigger("change")},destroy:function(){s.fn.destroy.call(this);if(this.dataSource){this.dataSource.unbind("change",this._refreshHandler);this.dataSource.unbind("progress",this._progressHandler);this.dataSource.unbind("error",this._errorHandler)}if(this.dependencies){this.dependencies.unbind("change",this._dependencyRefreshHandler);this.dependencies.unbind("error",this._dependencyErrorHandler)}if(this.timeline){this.timeline.unbind();this.timeline.destroy()}if(this.list){this.list.unbind();this.list.destroy()}if(this.footerDropDown)this.footerDropDown.destroy();if(this.headerDropDown)this.headerDropDown.destroy();if(this._editor)this._editor.destroy();if(this._resizeDraggable)this._resizeDraggable.destroy();this.toolbar.off(D);if(v){this._mediaQuery.removeListener(this._mediaQueryHandler);this._mediaQuery=null}w(window).off("resize"+D,this._resizeHandler);w(this.wrapper).off(D);this.toolbar=null;this.footer=null;_.destroy(this.element)},setOptions:function(e){var t=_.deepExtend({},this.options,e);var i=this._events;if(!e.views){var n=this.view().name;t.views=w.map(this.options.views,function(e){var t=h(e);var i=t?typeof e.type!=="string"?e.title:e.type:e;if(n===i)if(t)e.selected=true;else e={type:i,selected:true};else if(t)e.selected=false;return e})}if(!e.dataSource)t.dataSource=this.dataSource;if(!e.dependencies)t.dependencies=this.dependencies;if(!e.resources)t.resources=this.resources;if(!e.assignments)t.assignments=this.assignments;this.destroy();this.element.empty();this.options=null;this.init(this.element,t,i);s.fn._setEvents.call(this,t)},_attachEvents:function(){this._resizeHandler=this.resize.bind(this,false);w(window).on("resize"+D,this._resizeHandler);if(v&&this._mediaQuery.matches===true)this._mediaQueryHandler({matches:true})},_wrapper:function(){var e=C.styles;var t=[e.icon,e.resizeHandle].join(" ");var i=this.options;var n=i.height;var s=i.width;this.wrapper=this.element.addClass(e.wrapper);this.layout=w("<div class='"+e.content+"' />").appendTo(this.wrapper).append("<div class='"+e.listWrapper+"'><div></div></div>").append("<div class='"+e.splitBarWrapper+"'><div class='"+t+"'></div></div>").append("<div class='"+e.timelineWrapper+"'><div></div></div>");if(i.showPlannedTasks)this.wrapper.addClass(e.plannedTasks);if(n)this.wrapper.css("height",n);if(s)this.wrapper.css("width",s);if(i.rowHeight)this.wrapper.addClass(e.rowHeight);this.treelistWrapper=this.wrapper.find(T+e.list);this.splitbar=this.wrapper.find(T+e.splitBar);this.timelineWrapper=this.wrapper.find(T+e.timeline);this.treelistWrapper.css("width",i.listWidth);this.timelineWrapper.css("width",this.wrapper.width()-this.treelistWrapper.outerWidth()-this.splitbar.outerWidth())},_toolbar:function(){var n=this;var s=C.styles;var e=T+s.toolbar.views+" > button";var c=T+s.toolbar.viewsDropdown;var u=T+s.toolbar.pdfButton;var f=T+s.buttonToggle;var t=T+s.gridContent;var i=n.splitbar;var r=n.treelistWrapper;var a=n.timelineWrapper;var o=this.options.toolbar;var d;var l;var h;var p=function(e){if(e.matches){r.addClass("k-hidden");i.addClass("k-hidden");r.width("100%")}else{r.removeClass("k-hidden");i.removeClass("k-hidden");a.removeClass("k-hidden");r.width(r.outerWidth());n.refresh();a.find(t).scrollTop(n.scrollTop)}n._resize()};if(!g(o)){o=typeof o===H?o:this._actions(o);o=_.template(o).bind(this)}h=w(I({styles:s.toolbar}));l=w(P({ns:_.ns,views:this.timeline.views,styles:s.toolbar}));d=w("<div role='toolbar' class='"+s.toolbar.headerWrapper+"'>").append(h).append(o({})).append("<span class='k-spacer k-toolbar-spacer' />").append(l);if(l.find("button").length>1)l.prepend(z({ns:_.ns,views:this.timeline.views,styles:s.toolbar,label:this.options.messages.selectView}));if(this.toggeSwitchWrap)this.toggeSwitchWrap.insertBefore(l);this.wrapper.prepend(d);this.toolbar=d;if(v){this._mediaQueryHandler=p.bind(this);this._mediaQuery=window.matchMedia("(max-width: 480px)");this._mediaQuery.addListener(this._mediaQueryHandler)}d.on("change"+D,c,function(){var e=n.list;var t=w(this).val();if(e.editable&&e.editable.trigger("validate"))return;if(!n.trigger("navigate",{view:t}))n.view(t);n.toolbar.find(T+s.focused).removeClass(s.focused)}).on(R+D,e,function(e){e.preventDefault();var t=n.list;var i=w(this).attr(_.attr("name"));if(t.editor&&!t.editor.end())return;if(!n.trigger("navigate",{view:i}))n.view(i);n.toolbar.find(T+s.focused).removeClass(s.focused)}).on("keydown"+D,e,function(e){var t=w(T+s.toolbar.views).children(":not(.k-current-view)");var i=t.index(n._focusedView&&n._focusedView[0]||t.closest(T+s.selected)[0]);if(e.keyCode===y.RIGHT){w(n.toolbar.find(T+s.focused)).removeClass(s.focused);n._focusedView=i+1===t.length?w(t[0]):w(t[i+1]);n._focusedView.trigger("focus").addClass(s.focused);e.preventDefault()}else if(e.keyCode===y.LEFT){w(n.toolbar.find(T+s.focused)).removeClass(s.focused);n._focusedView=i===0?w(t[t.length-1]):w(t[i-1]);n._focusedView.trigger("focus").addClass(s.focused);e.preventDefault()}else if((e.keyCode===y.ENTER||e.keyCode===y.SPACEBAR)&&n._focusedView){n.view(n._focusedView.text().toLowerCase());e.preventDefault()}else if(e.keyCode>=49&&e.keyCode<=57)n.view(n.timeline._viewByIndex(e.keyCode-49))}).on(R+D,u,function(e){e.preventDefault();n.saveAsPDF()}).on(R+D,f,function(e){e.preventDefault();if(r.is(":visible")){r.addClass("k-hidden");a.removeClass("k-hidden");n.refresh();a.find(t).scrollTop(n.scrollTop)}else{r.removeClass("k-hidden");a.addClass("k-hidden");r.find(t).scrollTop(n.scrollTop)}n._resize()});this.wrapper.on("focusout"+D,function(e){if(!w(e.relatedTarget).closest(T+s.toolbar.toolbar).length)n.toolbar.find(T+s.focused).removeClass(s.focused);if(!w(e.relatedTarget).closest(T+s.toolbar.views).length)n.toolbar.find(T+s.toolbar.views).removeClass(s.toolbar.expanded)})},_actions:function(){var e=this.options;var t=e.editable;var i=e.toolbar;var n="";var s;if(!l(i))if(t&&t.create!==false)i=["append"];else return n;for(var r=0,a=i.length;r<a;r++){s=i[r];if(s==="plannedTasks"||s.name==="plannedTasks"){this._createPlannedTasksSwitch();continue}n+=this._createButton(s)}return n},_footer:function(){var e=this.options.editable;if(!e||e.create===false)return;var t=C.styles.toolbar;var i=this.options.messages.actions;var n=w(_.template(A)(c(true,{styles:t},a.append,{text:i.append})));var s=w("<div class='"+t.footerWrapper+"'>").append(n);this.wrapper.append(s);this.footer=s},_createButton:function(e){var t=e.template||A;var i=this.options.messages.actions;var n=typeof e===H?e:e.name||e.text;var s=a[n]?a[n].className:"k-gantt-"+(n||"").replace(/\s/g,"");var r={iconClass:"",action:"",text:n,className:s,styles:C.styles.toolbar};if(!r.className)r.className="k-button-solid-base";else if(r.className.indexOf("k-button-solid-primary")===-1)r.className+=" k-button-solid-base";if(!n&&!(h(e)&&e.template))throw new Error("Custom commands should have name specified");r=c(true,r,a[n],{text:i[n]});if(h(e)){if(e.className&&u(r.className,e.className.split(" "))<0)e.className+=" "+r.className;r=c(true,r,e)}return _.template(t)(r)},_adjustDimensions:function(){var e=this.element;var t=b(this.toolbar);var i=this.footer?b(this.footer):0;var n=e.height();var s=e.width();var r=this.splitbar.is(":visible")?m(this.splitbar):0;var a=this.treelistWrapper.is(":visible")?m(this.treelistWrapper):0;var o=s-(a+r);this.layout.children().height(n-(t+i));this.timelineWrapper.width(o);if(s<a+r)this.treelistWrapper.width(s-r)},_scrollTo:function(e){var t=this.timeline.view();var i=this.list;var n=_.attr("uid");var s=typeof e==="string"?e:e.closest("tr"+S()).attr(n);var r;var a;var o=function(){if(a.length!==0)r()};if(t.content.is(":visible")){a=t.content.find(S(s));r=function(){t._scrollTo(a)}}else{a=i.element.find(S(s));r=function(){a.get(0).scrollIntoView()}}o()},_dropDowns:function(){var c=this;var e=T+C.styles.toolbar.appendButton;var t=this.options.messages.actions;var u=this.timeline;var i=this.options.editable;var n=function(e){var t=e.type;var i;var n=c.dataSource;var s=n._createNewModel({});var r=c.dataItem(c.select());var a=n.taskParent(r);var o=u.view()._timeSlots()[0];var d=t==="add"?r:a;var l=c.list.editor;if(l&&l.trigger("validate"))return;s.set("title","New task");if(d){s.set("parentId",d.get("id"));s.set("start",d.get("start"));s.set("end",d.get("end"));s.set("plannedStart",d.get("plannedStart"));s.set("plannedEnd",d.get("plannedEnd"))}else{s.set("start",o.start);s.set("end",o.end)}if(t!=="add"){i=r.get("orderId");i=t==="insert-before"?i:i+1}c._createTask(s,i)};if(!i||i.create===false)return;this.footerDropDown=new _.gantt.TaskDropDown(this.footer.children(e).eq(0),{messages:{actions:t},direction:"up",animation:{open:{effects:"slideIn:up"}}});this.headerDropDown=new _.gantt.TaskDropDown(this.toolbar.children(e).eq(0),{messages:{actions:t}});this.footerDropDown.bind("command",n);this.headerDropDown.bind("command",n)},_getListEditable:function(){var e=false,t=this.options;if(t.editable!==false){e="incell";if(t.editable&&t.editable.update===false)e=false;else if(!t.editable||t.editable.reorder!==false)e={mode:"incell",move:{reorderable:true}}}return e},_getListOptions:function(){var e=this.options,t=this._getListEditable(),i=this.wrapper.find(T+N.list),n={columns:e.columns||[],dataSource:this.dataSource,selectable:e.selectable,reorderable:e.reorderable,editable:t,resizable:e.resizable,filterable:e.filterable,columnMenu:e.columnMenu,columnResizeHandleWidth:this.options.columnResizeHandleWidth,listWidth:m(i),resourcesField:this.resources.field,rowHeight:this.options.rowHeight};return n},_attachResourceEditor:function(e){var t;for(var i=0;i<e.length;i++){t=e[i];if(t.field===this.resources.field&&typeof t.editor!=="function")t.editor=this._createResourceEditor.bind(this)}},_attachListEvents:function(){var a=this,t=a.options.navigatable,o=function(){var e;if(t&&a._cachedCurrent){e=a.list.content.find("tr").eq(a._cachedCurrent.rowIndex).find("td").eq(a._cachedCurrent.columnIndex);a._current(e);U(a.list.content.find("table"),true)}delete a._cachedCurrent};a.list.bind("columnShow",function(e){a.trigger("columnShow",{column:e.column})}).bind("columnHide",function(e){a.trigger("columnHide",{column:e.column})}).bind("columnReorder",function(e){a.trigger("columnReorder",{column:e.column,oldIndex:e.oldIndex,newIndex:e.newIndex})}).bind("columnResize",function(e){a.trigger("columnResize",{column:e.column,oldWidth:e.oldWidth,newWidth:e.newWidth})}).bind("render",function(){a._navigatable()},true).bind("beforeEdit",function(e){a._cachedCurrent={rowIndex:e.container.closest("tr").index(),columnIndex:e.container.index()};if(a.trigger("edit",{task:e.model,container:e.container}))e.preventDefault()}).bind("cancel",function(e){if(a.trigger("cancel",{task:e.model,container:e.cell})){e.preventDefault();return}a._preventItemChange=true;a.list.closeCell(true);o()}).bind("save",function(e){var t=e.values,i;a.previousTask={};a._preventRefresh=true;if(a.updateDuration===null||a.updateDuration===n)a.updateDuration=e.model.duration();if(a.updatePlannedDuration===null||a.updatePlannedDuration===n)a.updatePlannedDuration=e.model.plannedDuration();if(t.hasOwnProperty("start"))t.end=new Date(t.start.getTime()+a.updateDuration);if(t.hasOwnProperty("plannedStart")&&t.plannedStart)t.plannedEnd=new Date(t.plannedStart.getTime()+a.updatePlannedDuration);for(i in t)if(t.hasOwnProperty(i))a.previousTask[i]=e.model.get(i);a.updatedValues=t}).bind("itemChange",function(e){var t=a.updatedValues,i=e.data,n=a.resources.field,s=a.previousTask,r;if(a._preventItemChange){a._preventItemChange=false;return}for(r in s)if(s.hasOwnProperty(r))i.set(r,s[r]);a.previousTask={};if(!a.trigger("save",{task:i,values:t})){if(t){a._preventRefresh=true;a.dataSource.update(i,t);if(t[n])a._updateAssignments(i.get("id"),t[n])}a._preventRefresh=false;a._requestStart();a.dataSource.sync().then(function(){o()})}else if(a.dataSource.hasChanges()){a.dataSource.cancelChanges(i);a._preventRefresh=false;a.refresh()}a.updatedValues=null;a.updateDuration=null}).bind("change",function(){a.trigger("change");a._selectionUpdate()}).bind("collapse",function(e){e.preventDefault();var t=a.list.element.find("tr[data-uid='"+e.model.uid+"']");e.model.set("expanded",false);a._cachedCurrent={rowIndex:t.index(),columnIndex:t.find(".k-focus").index()};o()}).bind("expand",function(e){e.preventDefault();var t=a.list.element.find("tr[data-uid='"+e.model.uid+"']");e.model.set("expanded",true);a._cachedCurrent={rowIndex:t.index(),columnIndex:t.find(".k-focus").index()};o()}).bind("dragend",function(e){var t=a.dataSource,i,n;if(e.position==="over"){t.cancelChanges();n={parentId:e.source.parentId};i=t.get(e.source.id);if(!a.trigger("save",{task:i,values:n}))t.update(i,n);t.sync()}}).bind("dataBound",function(){if(a.dataSource.sort().length===0)a.dataSource.sort([{field:"orderId",dir:"asc"}])}).bind("reorder",function(e){a._updateTask(e.task,e.updateInfo);o()})},_selectionUpdate:function(){var e=this,t=e.list.select(),i=this.wrapper.find(T+N.toolbar.toolbar+" "+T+N.toolbar.appendButton);if(t.length){i.removeAttr("data-action","add");e.timeline.select("[data-uid='"+t.attr("data-uid")+"']")}else{i.attr("data-action","add");e.timeline.clearSelection()}},_list:function(){var e=C.styles,t=this.wrapper.find(T+e.list),i=t.find("> div"),n=this._getListOptions();this._attachResourceEditor(n.columns);this.list=new _.ui.GanttList(i,n);this._attachListEvents()},_timeline:function(){var s=this;var i=C.styles;var e=L(c(true,{resourcesField:this.resources.field},this.options));var t=this.wrapper.find(T+i.timeline+" > div");this.timeline=new _.ui.GanttTimeline(t,e);this.timeline.bind("navigate",function(e){var t=e.view.replace(/\./g,"\\.").toLowerCase();s.toolbar.find(T+i.toolbar.views+" > button").removeClass(i.selected).end().find(T+i.toolbar.viewButton+"-"+t).addClass(i.selected);s.toolbar.find(T+i.toolbar.viewsDropdown).val(e.view);s.refresh()}).bind("moveStart",function(e){var t=s.list.editor;if(t&&!t.end()){e.preventDefault();return}if(s.trigger("moveStart",{task:e.task}))e.preventDefault()}).bind("move",function(e){var t=e.task;var i=e.start;var n=new Date(i.getTime()+t.duration());if(s.trigger("move",{task:t,start:i,end:n}))e.preventDefault()}).bind("moveEnd",function(e){var t=e.task;var i=e.start;var n=new Date(i.getTime()+t.duration());if(!s.trigger("moveEnd",{task:t,start:i,end:n}))s._updateTask(s.dataSource.getByUid(t.uid),{start:i,end:n})}).bind("resizeStart",function(e){var t=s.list.editor;if(t&&!t.end()){e.preventDefault();return}if(s.trigger("resizeStart",{task:e.task}))e.preventDefault()}).bind("resize",function(e){if(s.trigger("resize",{task:e.task,start:e.start,end:e.end}))e.preventDefault()}).bind("resizeEnd",function(e){var t=e.task;var i={};if(e.resizeStart)i.start=e.start;else i.end=e.end;if(!s.trigger("resizeEnd",{task:t,start:e.start,end:e.end}))s._updateTask(s.dataSource.getByUid(t.uid),i)}).bind("percentResizeStart",function(e){var t=s.list.editor;if(t&&!t.end())e.preventDefault()}).bind("percentResizeEnd",function(e){s._updateTask(s.dataSource.getByUid(e.task.uid),{percentComplete:e.percentComplete})}).bind("dependencyDragStart",function(e){var t=s.list.editor;if(t&&!t.end())e.preventDefault()}).bind("dependencyDragEnd",function(e){var t=s.dependencies._createNewModel({type:e.type,predecessorId:e.predecessor.id,successorId:e.successor.id});s._createDependency(t)}).bind("select",function(e){var t=s.list.editor;if(t)t.end();s.select("[data-uid='"+e.uid+"']")}).bind("editTask",function(e){var t=s.list.editor;if(t&&!t.end())return;s.editTask(e.uid)}).bind("clear",function(){s.clearSelection()}).bind("removeTask",function(e){var t=s.list.editor;if(t&&!t.end())return;s.removeTask(s.dataSource.getByUid(e.uid))}).bind("removeDependency",function(e){var t=s.list.editor;if(t&&!t.end())return;s.removeDependency(s.dependencies.getByUid(e.uid))})},_dataSource:function(){var e=this.options;var t=e.dataSource;t=l(t)?{data:t}:t;if(this.dataSource&&this._refreshHandler)this.dataSource.unbind("change",this._refreshHandler).unbind("progress",this._progressHandler).unbind("error",this._errorHandler);else{this._refreshHandler=this.refresh.bind(this);this._progressHandler=this._requestStart.bind(this);this._errorHandler=this._error.bind(this)}this.dataSource=_.data.GanttDataSource.create(t).bind("change",this._refreshHandler).bind("progress",this._progressHandler).bind("error",this._errorHandler)},_dependencies:function(){var e=this.options.dependencies||{};var t=l(e)?{data:e}:e;if(this.dependencies&&this._dependencyRefreshHandler)this.dependencies.unbind("change",this._dependencyRefreshHandler).unbind("error",this._dependencyErrorHandler);else{this._dependencyRefreshHandler=this.refreshDependencies.bind(this);this._dependencyErrorHandler=this._error.bind(this)}this.dependencies=_.data.GanttDependencyDataSource.create(t).bind("change",this._dependencyRefreshHandler).bind("error",this._dependencyErrorHandler)},_resources:function(){var e=this.options.resources;var t=e.dataSource||{};this.resources={field:"resources",dataTextField:"name",dataColorField:"color",dataFormatField:"format"};c(this.resources,e);this.resources.dataSource=_.data.DataSource.create(t)},_assignments:function(){var e=this.options.assignments;var t=e.dataSource||{};if(this.assignments)this.assignments.dataSource.unbind("change",this._assignmentsRefreshHandler);else this._assignmentsRefreshHandler=this.refresh.bind(this);this.assignments={dataTaskIdField:"taskId",dataResourceIdField:"resourceId",dataValueField:"value"};c(this.assignments,e);this.assignments.dataSource=_.data.DataSource.create(t);this.assignments.dataSource.bind("change",this._assignmentsRefreshHandler)},_createEditor:function(){var i=this;var e=this._editor=new _.gantt.PopupEditor(this.wrapper,c({},this.options,{target:this,resources:{field:this.resources.field,editor:this._createResourceEditor.bind(this)},createButton:this._createPopupButton.bind(this)}));e.bind("cancel",function(e){var t=i.dataSource.getByUid(e.model.uid);if(i.trigger("cancel",{container:e.container,task:t})){e.preventDefault();return}i.cancelTask()}).bind("edit",function(e){var t=i.dataSource.getByUid(e.model.uid);if(i.trigger("edit",{container:e.container,task:t}))e.preventDefault()}).bind("save",function(e){var t=i.dataSource.getByUid(e.model.uid);i.saveTask(t,e.updateInfo)}).bind("remove",function(e){i.removeTask(e.model.uid)}).bind("close",i._onDialogClose)},_onDialogClose:function(){},_createResourceEditor:function(e,t){var i=this;var n=t instanceof f?t:t.model;var s=n.get("id");var r=this.options.messages;var a=this.resources.field;var o={step:.01};var d=this.assignments.dataSource.options.schema.model;if(d&&d.fields.Units&&d.fields.Units.validation)c(true,o,d.fields.Units.validation);var l=this._resourceEditor=new _.gantt.ResourceEditor(e,{resourcesField:a,unitsValidation:o,data:this._wrapResourceData(s),model:n,messages:c({},r.editor),buttons:[{name:"update",text:r.save,className:C.styles.primary},{name:"cancel",text:r.cancel}],createButton:this._createPopupButton.bind(this),save:function(e){i._updateAssignments(e.model.get("id"),e.model.get(a))}});l.open()},_createPopupButton:function(e){var t=e.name||e.text;var i={className:C.styles.popup.button+" "+C.styles.buttonDefaults+" k-gantt-"+(t||"").replace(/\s/g,""),text:t,attr:""};if(!t&&!(h(e)&&e.template))throw new Error("Custom commands should have name specified");if(h(e)){if(e.className)e.className+=" "+i.className;i=c(true,i,e)}if(!i.className)i.className="k-button-solid-base";else if(i.className.indexOf("k-button-solid-primary")===-1)i.className+=" k-button-solid-base";return _.template(F)(i)},view:function(e){return this.timeline.view(e)},range:function(e){var t=this.dataSource;var i=this.view();var n=this.timeline;if(e){i.options.range={start:e.start,end:e.end};n._render(t.taskTree());n._renderDependencies(this.dependencies.view())}return{start:i.start,end:i.end}},date:function(e){var t=this.view();if(e){t.options.date=e;t._scrollToDate(e)}return t.options.date},dataItem:function(e){if(!e)return null;var t=this.list;var i=t.element.find(e);return t._modelFromElement(i)},setDataSource:function(e){this.options.dataSource=e;this._dataSource();this.list.setDataSource(this.dataSource);if(this.options.autoBind)e.fetch()},setDependenciesDataSource:function(e){this.options.dependencies=e;this._dependencies();if(this.options.autoBind)e.fetch()},items:function(){return this.wrapper.children(".k-task")},_updateAssignments:function(e,t){var i=this.assignments.dataSource;var c=this.assignments.dataTaskIdField;var u=this.assignments.dataResourceIdField;var n=false;var s=new p(i.view()).filter({field:c,operator:"eq",value:e}).toArray();var r;var a;var o;while(s.length){r=s[0];for(var d=0,f=t.length;d<f;d++){a=t[d];if(r.get(u)===a.get("id")){o=t[d].get("value");this._updateAssignment(r,o);t.splice(d,1);n=true;break}}if(!n)this._removeAssignment(r);n=false;s.shift()}for(var l=0,h=t.length;l<h;l++){a=t[l];this._createAssignment(a,e)}i.sync()},cancelTask:function(){var e=this._editor;var t=e.container;if(t)e.close()},editTask:function(e){var t=typeof e==="string"?this.dataSource.getByUid(e):e;if(!t)return;var i=this.dataSource._createNewModel(t.toJSON());i.uid=t.uid;this.cancelTask();this._editTask(i)},_editTask:function(e){this._editor.editTask(e,this.options.editable.plannedTasks)},saveTask:function(e,t){var i=this._editor;var n=i.container;var s=i.editable;if(n&&s&&s.end())this._updateTask(e,t)},_updateTask:function(e,t){var i=this;var n=i.resources.field;if(!i.trigger("save",{task:e,values:t})){if(t){i._preventRefresh=true;i.dataSource.update(e,t);if(t[n])i._updateAssignments(e.get("id"),t[n])}i._syncDataSource()}else if(e&&e.dirty){i.dataSource.cancelChanges(e);i._preventRefresh=false;i.refresh()}},_updateAssignment:function(e,t){var i=this.assignments.dataValueField;e.set(i,t)},removeTask:function(e){var t=this;var i=typeof e==="string"?this.dataSource.getByUid(e):e;if(!i)return;this._taskConfirm(function(e){if(!e)t._removeTask(i)},i)},_createTask:function(e,t){if(!this.trigger("add",{task:e,dependency:null})){var i=this.dataSource;this._preventRefresh=true;if(t===n)i.add(e);else i.insert(t,e);this._scrollToUid=e.uid;this._syncDataSource()}},_createDependency:function(e){if(!this.trigger("add",{task:null,dependency:e})){this._preventDependencyRefresh=true;this.dependencies.add(e);this._preventDependencyRefresh=false;this.dependencies.sync()}},_createAssignment:function(e,t){var i=this.assignments;var n=i.dataSource;var s=i.dataTaskIdField;var r=i.dataResourceIdField;var a=i.dataValueField;var o=n._createNewModel();o[s]=t;o[r]=e.get("id");o[a]=e.get("value");n.add(o)},removeDependency:function(e){var t=this;var i=typeof e==="string"?this.dependencies.getByUid(e):e;if(!i)return;this._dependencyConfirm(function(e){if(!e)t._removeDependency(i)},i)},_removeTaskDependencies:function(e,t){this._preventDependencyRefresh=true;for(var i=0,n=t.length;i<n;i++)this.dependencies.remove(t[i]);this._preventDependencyRefresh=false;this.dependencies.sync()},_removeTaskAssignments:function(e){var t=this.assignments.dataSource;var i=t.view();var n={field:this.assignments.dataTaskIdField,operator:"eq",value:e.get("id")};i=new p(i).filter(n).toArray();this._preventRefresh=true;for(var s=0,r=i.length;s<r;s++)t.remove(i[s]);this._preventRefresh=false;t.sync()},_removeTask:function(e){var t=this.dependencies.dependencies(e.id);if(!this.trigger("remove",{task:e,dependencies:t})){this._removeTaskDependencies(e,t);this._removeTaskAssignments(e);this._preventRefresh=true;if(this.dataSource.remove(e))this._syncDataSource();this._preventRefresh=false}},_removeDependency:function(e){if(!this.trigger("remove",{task:null,dependencies:[e]}))if(this.dependencies.remove(e))this.dependencies.sync()},_removeAssignment:function(e){this.assignments.dataSource.remove(e)},_taskConfirm:function(e,t){var i=this.options.messages;this._confirm(e,{model:t,text:i.deleteTaskConfirmation,title:i.deleteTaskWindowTitle})},_dependencyConfirm:function(e,t){var i=this.options.messages;this._confirm(e,{model:t,text:i.deleteDependencyConfirmation,title:i.deleteDependencyWindowTitle})},_confirm:function(e,t){var i=this.options.editable;var n;var s;if(i===true||i.confirmation!==false){n=this.options.messages;s=[{name:"delete",text:n.destroy,className:C.styles.primary,click:function(){e()}},{name:"cancel",text:n.cancel,click:function(){e(true)}}];this.showDialog(c(true,{},t,{buttons:s}))}else e()},showDialog:function(e){this._editor.showDialog(e)},refresh:function(){if(this._preventRefresh||!this.list||this.list.editor)return;this._progress(false);var e=this.dataSource;var t=e.taskTree();var i=this._scrollToUid;var n;var s;var r=-1;if(this.current){s=this.current.closest("tr").attr(_.attr("uid"));r=this.current.index()}if(this.trigger("dataBinding"))return;if(this.resources.dataSource.data().length!==0)this._assignResources(t);if(this._editor)this._editor.close();this.clearSelection();this.list._renderTree(t);this.timeline._render(t);this.timeline._renderDependencies(this.dependencies.view());if(i){this._scrollTo(i);this.select(S(i))}if((i||s)&&r>=0){n=this.list.element.find("tr"+S(i||s)+" > td").eq(r);this._current(n)}this._scrollToUid=null;this.trigger("dataBound")},refreshDependencies:function(){if(this._preventDependencyRefresh)return;if(this.trigger("dataBinding"))return;this.timeline._renderDependencies(this.dependencies.view());this.trigger("dataBound")},_assignResources:function(e){var c=this.resources;var u=this.assignments;var t=function(){var e=u.dataSource.view();var t={field:u.dataTaskIdField};e=new p(e).group(t).toArray();return e};var r=t();var i=function(e,t){var i=e.get("id");_.setter(c.field)(e,new o([]));for(var n=0,s=r.length;n<s;n++)if(r[n].value===i)t(e,r[n].items)};var n=function(e,t){for(var i=0,n=t.length;i<n;i++){var s=t[i];var r=c.dataSource.get(s.get(u.dataResourceIdField));var a=s.get(u.dataValueField);var o=s.get(u.dataResourceIdField);var d=r.get(c.dataFormatField)||k;var l=_.toString(a,d);e[c.field].push(new f({id:o,name:r.get(c.dataTextField),color:r.get(c.dataColorField),value:a,formatedValue:l}))}};for(var s=0,a=e.length;s<a;s++)i(e[s],n)},_wrapResourceData:function(e){var i=this;var t=[];var n;var s=this.resources.dataSource.view();var r=this.assignments.dataSource.view();var a=new p(r).filter({field:i.assignments.dataTaskIdField,operator:"eq",value:e}).toArray();var o=function(e){var t=null;new p(a).filter({field:i.assignments.dataResourceIdField,operator:"eq",value:e}).select(function(e){t+=e.get(i.assignments.dataValueField)});return t};for(var d=0,l=s.length;d<l;d++){n=s[d];t.push({id:n.get("id"),name:n.get(i.resources.dataTextField),format:n.get(i.resources.dataFormatField)||k,value:o(n.id)})}return t},_syncDataSource:function(){this._preventRefresh=false;this._requestStart();this.dataSource.sync()},_requestStart:function(){this._progress(true)},_error:function(){this._progress(false)},_progress:function(e){_.ui.progress(this.element,e)},_resizable:function(){var i=this;var n=this.wrapper;var e=C.styles;var s=T+e.gridContent;var r=n.find(T+e.list);var a=n.find(T+e.timeline);var o;var d;var l;this._resizeDraggable=n.find(T+e.splitBar).height(r.height()).hover(function(){w(this).addClass(e.splitBarHover)},function(){w(this).removeClass(e.splitBarHover)}).end().kendoResizable({orientation:"horizontal",handle:T+e.splitBar,start:function(){o=r.width();d=a.width();l=_.scrollLeft(a.find(s))},resize:function(e){var t=e.x.initialDelta;if(_.support.isRtl(n))t*=-1;if(o+t<0||d-t<0)return;r.width(o+t);a.width(d-t);_.scrollLeft(a.find(s),l+t);i.timeline.view()._renderCurrentTime()}}).data("kendoResizable")},_scrollable:function(){var e=this;var t=C.styles;var i=T+t.gridContent;var n=T+t.gridHeaderWrap;var s=this.timeline.element.find(n);var r=this.timeline.element.find(i);var a=this.list.element.find(n);var o=this.list.element.find(i);if(d)o.css("overflow-y","auto");r.on("scroll",function(){e.scrollTop=this.scrollTop;_.scrollLeft(s,this.scrollLeft);o.scrollTop(this.scrollTop)});o.on("scroll",function(){_.scrollLeft(a,this.scrollLeft)}).on("DOMMouseScroll"+D+" mousewheel"+D,function(e){var t=r.scrollTop();var i=_.wheelDeltaY(e);if(i){e.preventDefault();w(e.currentTarget).one("wheel"+D,false);r.scrollTop(t+-i)}})},_navigatable:function(){var s=this;var r=this.options.navigatable;var u=this.options.editable;var a=C.styles;var t=T+a.gridContent;var f=T+a.gridHeaderWrap;var o=this.list.element.find(f).find("table");var d=this.list.element.find(t).find("table");var n=_.support.isRtl(this.wrapper);var i=this.timeline.element.find(T+a.gridContent);var h=o.add(d);var e=S();var l;var c={collapse:false,expand:true};var p=function(e){var t=s.timeline.view()._timeSlots()[0].offsetWidth;_.scrollLeft(i,_.scrollLeft(i)+(e?-t:t))};var v=function(e){var t=s.timeline.view()._rowHeight;i.scrollTop(i.scrollTop()+(e?-t:t))};var g=function(e){var t=s.current.parent("tr"+S());var i=s.current.index();var n=t[e]("tr:visible").first();if(s.select().length!==0)s.clearSelection();if(n.length!==0){s._current(n.children("td").eq(i));s._scrollTo(s.current)}else if(s.current.is("td")&&e=="prevAll")U(o);else if(s.current.is("th")&&e=="nextAll")U(d)};var m=function(e){var t=s.current[e]();if(t.length!==0){s._current(t);l=s.current.index()}};var b=function(e){var t=s.dataItem(s.current);if(t.summary&&t.expanded!==e)t.set("expanded",e)};var k=function(){var e=s.options.editable;if(!e||e.destroy===false||s.list.editor)return;var t=s.select();var i=_.attr("uid");if(t.length)s.removeTask(t.attr(i))};w(this.wrapper).on("mousedown"+D,"tr"+e+", div"+e+":not("+T+a.line+")",function(e){var t=w(e.currentTarget);var i=w(e.target).is(":button,a,:input,a>.k-icon,textarea,span.k-icon:not(.k-i-none),span.k-link,.k-input,.k-multiselect-wrap,.k-input-value-text,.k-input-inner");var n;if(e.ctrlKey)return;if(r){if(t.is("tr"))n=w(e.target).closest("td");else n=s.list.content.find("tr"+S(t.attr(_.attr("uid")))+" > td").first();s._current(n)}if((r||u)&&!i)s._focusTimeout=setTimeout(function(){U(s.list.content.find("table"),true)},2)}).on("keydown"+D,function(e){var t=e.keyCode;var i=this;var n=w(i._getToolbarItems());var s=n.index(i.toolbar.find(T+a.focused)[0]);if(s===-1&&w(e.target).closest(T+a.toolbar.views).length)s=n.index(i.toolbar.find(".k-gantt-views > .k-selected:visible, .k-views-dropdown:visible")[0]);var r=e.shiftKey?n[s-1]:n[s+1];if(t===y.F10){i.toolbar.find(".k-button:visible").first().addClass(a.focused).trigger("focus");e.preventDefault()}else if(t==y.TAB&&w(e.target).closest(T+a.toolbar.toolbar).length){i.toolbar.find(T+a.focused).removeClass(a.focused).trigger("blur");if(r){w(r).addClass(a.focused).trigger("focus");e.preventDefault();return}if(this.list.element.is(":visible"))this.list.element.find("table[role=treegrid]").trigger("focus");else this.element.find(T+a.tasks)[0].focus();e.preventDefault()}}.bind(this));if(r!==true){d.on("keydown"+D,function(e){if(e.keyCode==y.DELETE)k()});return}h.on("focus"+D,function(){var e=this===d.get(0)?"td":"th";var t=s.select();var i=s.current||w(t.length?t:this).find(e).eq(l||0);s._current(i);w(s.toolbar.find(T+a.focused)).removeClass(a.focused)}).on("blur"+D,function(){s._current();if(this==o)w(this).attr(x,-1)}).on("keydown"+D,function(e){var t=e.keyCode;var i;if(!s.current)return;i=s.current.is("td");switch(t){case y.RIGHT:e.preventDefault();if(e.altKey)p();else if(e.ctrlKey)b(n?c.collapse:c.expand);else m(n?"prev":"next");break;case y.LEFT:e.preventDefault();if(e.altKey)p(true);else if(e.ctrlKey)b(n?c.expand:c.collapse);else m(n?"next":"prev");break;case y.UP:e.preventDefault();if(e.altKey)v(true);else g("prevAll");break;case y.DOWN:e.preventDefault();if(e.altKey)v();else g("nextAll");break;case y.SPACEBAR:e.preventDefault();if(i)s.select(s.current.closest("tr"));break;case y.ENTER:e.preventDefault();if(i){if(s.options.editable&&s.options.editable.update!==false){s.list._startEditHandler(s.current);w(this).one("keyup",function(e){e.stopPropagation()})}}else s.current.children("a.k-link").click();break;case y.DELETE:if(i)k();break;default:if(t>=49&&t<=57&&e.target.tagName.toLowerCase()!=="input")s.view(s.timeline._viewByIndex(t-49));break}})},_getToolbarItems:function(){return this.toolbar.find("> .k-button:visible").toArray().concat(this.toolbar.find(".k-views-dropdown:visible").toArray(),this.toolbar.find(".k-gantt-views > .k-selected:visible").toArray())},_current:function(e){var t=C.styles;var i;if(this.current&&this.current.length)this.current.removeClass(t.focusedCell).removeAttr("id");if(e&&e.length){this.current=e.addClass(t.focusedCell).attr("id",E);i=w(_._activeElement());if(i.is("table")&&this.wrapper.find(i).length>0)i.removeAttr(r).attr(r,E)}else this.current=null},_dataBind:function(){var e=this;if(e.options.autoBind){this._preventRefresh=true;this._preventDependencyRefresh=true;var t=w.map([this.dataSource,this.dependencies,this.resources.dataSource,this.assignments.dataSource],function(e){return e.fetch()});w.when.apply(null,t).done(function(){e._preventRefresh=false;e._preventDependencyRefresh=false;e.refresh()})}},_resize:function(){this._adjustDimensions();this.timeline.view()._adjustHeight();this.timeline.view()._renderCurrentTime();this.list._adjustHeight()},_createPlannedTasksSwitch:function(){var e=this;var t=e.options.messages.plannedTasks.switchText;var i=w("<span class='k-gantt-planned-wrap'><label>"+t+"</label></span>");var n=new _.ui.Switch(w("<input id='planned-switch' class='k-gantt-planned-switch'>"),{checked:e.options.showPlannedTasks,change:e._togglePlannedTasks.bind(e),messages:{checked:"",unchecked:""}});i.append(n.wrapper);e.toggeSwitchWrap=i;e.toggleSwitch=n},_togglePlannedTasks:function(e){var t=this.timeline;if(!this.trigger("togglePlannedTasks",{showPlannedTasks:!t.options.showPlannedTasks})){this.wrapper.toggleClass(N.plannedTasks);t._setPlanned(!t.options.showPlannedTasks);t._render(this.dataSource.taskTree());t._renderDependencies(this.dependencies.view())}else e.preventDefault()}});if(_.PDFMixin){_.PDFMixin.extend(C.fn);C.fn._drawPDF=function(){var e=C.styles;var t=this.wrapper.find(T+e.list+" "+T+e.gridContent+">table").width();var i=this.wrapper.clone();i.find(T+e.list).css("width",t);return this._drawPDFShadow({content:i},{avoidLinks:this.options.pdf.avoidLinks})}}return _.ui.plugin(C),c(true,C,{styles:N}),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,i){(i||t)()});
//# sourceMappingURL=kendo.gantt.min.js.map
