/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.listview.min",["kendo.data.min","kendo.editable.min","kendo.selectable.min","kendo.pager.min"],function(){var e={id:"listview",name:"ListView",category:"web",description:"The ListView widget offers rich support for interacting with data.",depends:["data"],features:[{id:"listview-editing",name:"Editing",description:"Support for record editing",depends:["editable"]},{id:"listview-selection",name:"Selection",description:"Support for selection",depends:["selectable"]},{id:"listview-paging",name:"Paging",description:"Support for paging",depends:["pager"]}]},m=window.kendo.jQuery,d=void 0,b=window.kendo,r="change",t,a="cancel",w="dataBound",S="dataBinding",n=b.ui.Widget,g=b.keys,s="",c=".",o="> *:not(.k-loading-mask)",u="progress",f="error",y="k-focus",p="k-selected",k="k-edit-item",h="k-listview-pager",E="k-listview-item",C="aria-setsize",x="aria-posinset",v="role",T="aria-label",H="aria-multiselectable",_="aria-activedescendant",P="edit",I="remove",A="save",D="mousedown",F="click",z="touchstart",l=".kendoListView",B=b._activeElement,i=b.ui.progress,L=b.data.DataSource,O=b.ui.DataBoundWidget.extend({init:function(e,t){var i=this;t=Array.isArray(t)?{dataSource:t}:t;n.fn.init.call(i,e,t);t=i.options;i.wrapper=e=i.element;if(e[0].id)i._itemId=e[0].id+"_lv_active";else i._itemId=b.guid()+"_lv_active";i._element();i._layout();i._dataSource();i._setContentHeight();i._templates();i._navigatable();i._selectable();i._pageable();i._crudHandlers();i._scrollable();if(i.options.autoBind)i.dataSource.fetch();b.notify(i)},events:[r,a,S,w,P,I,A,"kendoKeydown"],options:{name:"ListView",autoBind:true,selectable:false,navigatable:false,pageable:false,height:null,template:s,altTemplate:s,editTemplate:s,contentTemplate:"<div data-content='true' />",contentElement:"div",bordered:true,borders:"",layout:"",flex:{direction:"row",wrap:"nowrap"},grid:{},scrollable:false},setOptions:function(e){n.fn.setOptions.call(this,e);this._layout();this._templates();if(this.selectable){this.selectable.destroy();this.selectable=null}this._selectable()},_templates:function(){var e=this.options;this.template=b.template(e.template||s);this.altTemplate=b.template(e.altTemplate||e.template);this.editTemplate=b.template(e.editTemplate||s)},_item:function(e){return this.content.children()[e]()},items:function(){return this.content.children(":not(.k-loading-mask)")},dataItem:function(e){var t=b.attr("uid");var i=m(e).closest("["+t+"]").attr(t);return this.dataSource.getByUid(i)},setDataSource:function(e){this.options.dataSource=e;this._dataSource();if(this.options.autoBind)e.fetch();if(this.options.scrollable==="endless")this._bindScrollable()},_unbindDataSource:function(){var e=this;e.dataSource.unbind(r,e._refreshHandler).unbind(u,e._progressHandler).unbind(f,e._errorHandler)},_dataSource:function(){var e=this,t=e.options.pageable,i=e.options.dataSource;if(m.isPlainObject(t)&&t.pageSize!==d)i.pageSize=t.pageSize;if(e.dataSource&&e._refreshHandler)e._unbindDataSource();else{e._refreshHandler=e.refresh.bind(e);e._progressHandler=e._progress.bind(e);e._errorHandler=e._error.bind(e)}e.dataSource=L.create(i).bind(r,e._refreshHandler).bind(u,e._progressHandler).bind(f,e._errorHandler)},_progress:function(e){var t=this.wrapper;if(e&&this.content.height())t=this.content;i(t,e,{opacity:true})},_error:function(){i(this.content,false)},_element:function(){var e=this.options;var t=e.height;this.element.addClass("k-widget k-listview");if(e.contentElement)this.content=m(document.createElement(e.contentElement)).appendTo(this.element);else this.content=this.element;if(t)this.element.css("height",t)},_layout:function(){var e=this;var t=e.options;var i=t.flex;var n=t.grid;var a=e.element;var r=["k-widget","k-listview"];var o=e.content;var l=["k-listview-content"];a.add(o).removeClass(function(e,t){if(t.indexOf("k-")>=0)return true});if(t.bordered===true)r.push("k-listview-bordered");if(typeof t.borders==="string"&&t.borders!==s)r.push("k-listview-borders-"+t.borders);if(typeof t.contentPadding==="string"&&t.contentPadding!==s)l.push("k-listview-content-padding-"+t.contentPadding);if(typeof t.layout==="string"&&t.layout!==s)l.push("k-d-"+t.layout);if(t.layout==="flex"&&typeof i==="object"){if(typeof i.direction==="string"&&i.direction!=="")l.push("k-flex-"+i.direction);if(typeof i.wrap==="string"&&i.wrap!=="")l.push("k-flex-"+i.wrap)}if(t.layout==="grid"&&typeof n==="object"){if(typeof n.cols==="number")o.css("grid-template-columns","repeat("+n.cols+", 1fr)");else if(typeof n.cols==="string")o.css("grid-template-columns",n.cols);if(typeof n.rows==="number")o.css("grid-template-rows","repeat("+n.rows+", "+(n.rowHeight!==d?n.rowHeight:"1fr")+")");else if(typeof n.rows==="string")o.css("grid-template-rows",n.rows);if(typeof n.gutter==="number")o.css("grid-gap",n.gutter);else if(typeof n.gutter==="string")o.css("grid-gap",n.gutter)}e.element.addClass(r.join(" "));e.content.addClass(l.join(" "))},_setContentHeight:function(){var e=this,t=e.options,i;if(t.scrollable&&e.wrapper.is(":visible")){i=e.wrapper.innerHeight();e.content.height(i)}},refresh:function(e){var t=this,i=t.dataSource.view(),n,a,r,o="",l,s,c=t.template,u=t.altTemplate,f=t.options,p=f.selectable||f.navigatable?"option":"listitem",m=B(),d=t._endlessFetchInProgress,g=d?t._skipRerenderItemsCount:0,h=t.options.scrollable;e=e||{};if(e.action==="itemchange"){if(!t._hasBindingTarget()&&!t.editable){n=e.items[0];r=t.items().filter("["+b.attr("uid")+"="+n.uid+"]");if(r.length>0){l=r.index();t.angular("cleanup",function(){return{elements:[r]}});r.replaceWith(c(n));r=t.items().eq(l);r.attr(b.attr("uid"),n.uid);t.angular("compile",function(){return{elements:[r],data:[{dataItem:n}]}});t.trigger("itemChange",{item:r,data:n})}}return}if(t.trigger(S,{action:e.action||"rebind",items:e.items,index:e.index}))return;t._angularItems("cleanup");if(!d)t._destroyEditable();for(l=g,s=i.length;l<s;l++)if(l%2)o+=u(i[l]);else o+=c(i[l]);if(d)t.content.append(o);else t.content.html(o);a=t.items().not(".k-loading-mask");t._ariaAttributes(i.length);for(l=g,s=i.length;l<s;l++){r=a.eq(l);r.addClass(E);r.attr(b.attr("uid"),i[l].uid).attr(v,p);if(t.options.selectable)r.attr("aria-selected","false");if(t.options.pageable){r.attr(C,t.dataSource.total());r.attr(x,t.dataSource.indexOf(t.dataItem(r))+1)}}if(t.content[0]===m&&t.options.navigatable)if(t._focusNext)t.current(t.current().next());else if(!h)t.current(a.eq(0));if(t.element.attr(_)&&t.element.find("#"+t.element.attr(_)).length===0)t.element.removeAttr(_);t._setContentHeight();t._angularItems("compile");t._progress(false);t._endlessFetchInProgress=null;t.trigger(w,{action:e.action||"rebind",items:e.items,index:e.index})},_ariaAttributes:function(e){var t=this.element,i=this.options,n=i.selectable;if(e===0){t.removeAttr(v);t.removeAttr(H);if(t.attr(T)){this._ariaLabelValue=t.attr(T);t.removeAttr(T)}}else{t.attr(v,n||i.navigatable?"listbox":"list");if(n&&b.ui.Selectable.parseOptions(n).multiple)t.attr(H,true);if(this._ariaLabelValue)t.attr(T,this._ariaLabelValue)}},_pageable:function(){var e=this,t=e.options.pageable,i=e.options.navigatable,n,a;if(!t)return;n=e.wrapper.find(c+h);if(!n.length)n=m("<div />").addClass(h);if(t.position==="top")n.addClass(b.format("{0}-{1}",h,t.position)).prependTo(e.wrapper);else n.appendTo(e.wrapper);if(e.pager)e.pager.destroy();if(typeof t==="object"&&t instanceof b.ui.Pager)e.pager=t;else{n=t.pagerId?m("#"+t.pagerId):n;a=m.extend({},t,{dataSource:e.dataSource,navigatable:i,pagerId:null});e.pager=new b.ui.Pager(n,a)}},_selectable:function(){var t=this,i,n,e=t.options.selectable,a=t.options.navigatable;if(e){i=b.ui.Selectable.parseOptions(e).multiple;t.selectable=new b.ui.Selectable(t.element,{aria:true,multiple:i,filter:t.options.contentElement?".k-listview-content "+o:o,change:function(){t.trigger(r)}});if(a)t.element.on("keydown"+l,function(e){if(!m(e.target).is(t.element))return;if(e.keyCode===g.SPACEBAR){n=t.current();if(e.target==e.currentTarget)e.preventDefault();if(i){if(!e.ctrlKey)t.selectable.clear();else if(n&&n.hasClass(p)){n.removeClass(p);t.trigger(r);return}}else t.selectable.clear();t.selectable.value(n);t.trigger(r)}})}},_scrollable:function(){var e=this;var t=e.options.scrollable;if(t){e.content.css({"overflow-y":"scroll",position:"relative","-webkit-overflow-scrolling":"touch"});if(t==="endless")e._bindScrollable()}},_bindScrollable:function(){var e=this;var t=e._endlessPageSize=e.dataSource.options.pageSize;e.content.off("scroll"+l).on("scroll"+l,function(){if(this.scrollTop+this.clientHeight-this.scrollHeight>=-15&&!e._endlessFetchInProgress&&e._endlessPageSize<e.dataSource.total()){e._skipRerenderItemsCount=e._endlessPageSize;e._endlessPageSize=e._skipRerenderItemsCount+t;e.dataSource.options.endless=true;e._endlessFetchInProgress=true;e.dataSource.pageSize(e._endlessPageSize)}})},current:function(e){var t=this,i=t.element,n=t._current,a=t._itemId;if(e===d)return n;if(n&&n[0]){if(n[0].id===a)n.removeAttr("id");n.removeClass(y);i.removeAttr(_)}if(e&&e[0]){a=e[0].id||a;t._scrollTo(e[0]);i.attr(_,a);e.addClass(y).attr("id",a)}t._current=e},_scrollTo:function(o){var e=this,t=e.content,l,s=false,d="scroll";if(t.css("overflow")==="auto"||t.css("overflow")===d||t.css("overflow-y")===d)l=t[0];else{l=window;s=true}var i=function(e,t){var i=s?m(o).offset()[e.toLowerCase()]:o["offset"+e],n=o["client"+t],a=m(l)[d+e](),r=m(l)[t.toLowerCase()]();if(i+n>a+r)m(l)[d+e](i+n-r);else if(i<a)m(l)[d+e](i)};i("Top","Height");i("Left","Width")},_navigatable:function(){var f=this,e=f.options.navigatable,t=f.element,p=f.content,i=function(e){f.current(m(e.currentTarget));if(!m(e.target).is(":button, a, :input, a > .k-icon, textarea"))b.focusElement(t)};if(e){f._tabindex();t.on("focus"+l,function(){var e=f._current;if(!e||!e.is(":visible"))e=f._item("first");f.current(e)}).on("focusout"+l,function(){if(f._current)f._current.removeClass(y)}).on("keydown"+l,f,function(e){var t=e.keyCode,i=f.current(),n=m(e.target),a=!n.is(":button, textarea, a, a > .t-icon, input"),r=n.is(":text, :password"),o=b.preventDefault,l=p.find("."+k),s=B(),d,c=f.options.scrollable;if(n.hasClass(h)||!a&&!r&&t!==g.ESC||r&&t!==g.ESC&&t!==g.ENTER)return;if(t===g.UP||t===g.LEFT){if(i&&i[0])i=i.prev();if(i&&i[0])f.current(i);else if(!c)f.current(f._item("last"));o(e)}if(t===g.DOWN||t===g.RIGHT){if(c)if(f.options.scrollable==="endless"&&!i.next().length){f.content[0].scrollTop=f.content[0].scrollHeight;f._focusNext=true}else{i=i.next();if(i&&i[0])f.current(i)}else{i=i.next();f.current(!i||!i[0]?f._item("first"):i)}o(e)}if(t===g.PAGEUP){f.current(null);f.dataSource.page(f.dataSource.page()-1);o(e)}if(t===g.PAGEDOWN){f.current(null);f.dataSource.page(f.dataSource.page()+1);o(e)}if(t===g.HOME){f.current(f._item("first"));o(e)}if(t===g.END){f.current(f._item("last"));o(e)}if(t===g.ENTER)if(l.length!==0&&(a||r)){d=f.items().index(l);if(s)s.blur();f.save();var u=function(){f.element.trigger("focus");f.current(f.items().eq(d))};f.one("dataBound",u)}else if(f.options.editTemplate!=="")f.edit(i);if(t===g.ESC){l=p.find("."+k);if(l.length===0)return;d=f.items().index(l);f.cancel();f.element.trigger("focus");f.current(f.items().eq(d))}});t.on(D+l+" "+z+l,f.options.contentElement?".k-listview-content "+o:o,i.bind(f))}},clearSelection:function(){var e=this;e.selectable.clear()},select:function(e){var t=this,i=t.selectable;e=m(e);if(e.length){if(!i.options.multiple){i.clear();e=e.first()}i.value(e);return}return i.value()},_destroyEditable:function(){var e=this;if(e.editable){e.editable.destroy();delete e.editable}},_modelFromElement:function(e){var t=e.attr(b.attr("uid"));return this.dataSource.getByUid(t)},_closeEditable:function(){var e=this,t=e.editable,i=e.options,n=i.selectable||i.navigatable?"option":"listitem",a,r,o,l=e.template;if(t){if(t.element.index()%2)l=e.altTemplate;e.angular("cleanup",function(){return{elements:[t.element]}});a=e._modelFromElement(t.element);e._destroyEditable();o=t.element.index();t.element.replaceWith(l(a));r=e.items().eq(o);r.addClass(E);r.attr(b.attr("uid"),a.uid);r.attr(v,n);if(e._hasBindingTarget())b.bind(r,a);e.angular("compile",function(){return{elements:[r],data:[{dataItem:a}]}})}return true},edit:function(e){var t=this,i=t._modelFromElement(e),n,a=i.uid,r;t.cancel();e=t.items().filter("["+b.attr("uid")+"="+a+"]");r=e.index();e.replaceWith(t.editTemplate(i));n=t.items().eq(r).addClass(k).attr(b.attr("uid"),i.uid);t.editable=n.kendoEditable({model:i,clearContainer:false,errorTemplate:false,target:t}).data("kendoEditable");t.trigger(P,{model:i,item:n})},save:function(){var e=this,t=e.editable,i;if(!t)return;var n=t.element;i=e._modelFromElement(n);if(t.end()&&!e.trigger(A,{model:i,item:n})){e._closeEditable();e.dataSource.sync()}},remove:function(e){var t=this,i=t.dataSource,n=t._modelFromElement(e);if(t.editable){i.cancelChanges(t._modelFromElement(t.editable.element));t._closeEditable()}if(!t.trigger(I,{model:n,item:e})){if(e.attr("id")===t.element.attr(_))t.element.removeAttr(_);e.hide();i.remove(n);i.sync()}},add:function(){var e=this,t,i=e.dataSource,n=i.indexOf((i.view()||[])[0]);if(n<0)n=0;e.cancel();t=i.insert(n,{});e.edit(e.element.find("[data-uid='"+t.uid+"']"))},cancel:function(){var e=this,t=e.dataSource;if(e.editable){var i=e.editable.element;var n=e._modelFromElement(i);if(!e.trigger(a,{model:n,container:i})){t.cancelChanges(n);e._closeEditable()}}},_crudHandlers:function(){var i=this,e=z+l,t=F+l;i.content.on(e+" "+t,".k-edit-button",function(e){e.preventDefault();var t=m(this).closest("["+b.attr("uid")+"]");setTimeout(function(){i.edit(t)})});i.content.on(e+" "+t,".k-delete-button",function(e){e.preventDefault();var t=m(this).closest("["+b.attr("uid")+"]");setTimeout(function(){i.remove(t)})});i.content.on(t,".k-update-button",function(e){i.save();e.preventDefault()});i.content.on(t,".k-cancel-button",function(e){i.cancel();e.preventDefault()})},destroy:function(){var e=this;n.fn.destroy.call(e);e._unbindDataSource();e._destroyEditable();e.element.off(l);e.content.off(l);e._endlessFetchInProgress=e._endlessPageSize=e._skipRerenderItemsCount=e._focusNext=null;if(e.pager)e.pager.destroy();b.destroy(e.element)}});return b.ui.plugin(O),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,i){(i||t)()});
//# sourceMappingURL=kendo.listview.min.js.map
