﻿/// <reference path="jquery-3.6.1.min.js" />

function PageMethod(fn, paramArray, successFn, errorFn, page) {
    /// <summary>Calls a Page Method using Jquery</summary>
    /// <param type="String" name="fn">Name of the Page Method Function you wish to call</param>
    /// <param type="Array" name="paramArray" optional="true">Object Literal of parameter values that matches the functions paramters</param>
    /// <param type="Function" name="successFn" optional="true">(Optional) Function to call when the ajax call finishes</param>
    /// <param type="Function" name="errorFn" optional="true">(Optional) Function to call when the ajax call fails</param>
    /// <param type="String" name="page" optional="true">(Optional) Page the method belongs to, by default it goes to the current page from window.location.pathname</param>

    page = (page) ? page : window.location.pathname;

    // Create list of parameters in the form: {"paramName1":"paramValue1","paramName2":"paramValue2"}
    var paramList = '';
    if (paramArray.length > 0) {
        for (var i = 0; i < paramArray.length; i += 2) {
            if (paramList.length > 0) paramList += ',';
            paramList += '"' + paramArray[i] + '":"' + paramArray[i + 1] + '"';
        }
    }
    paramList = '{' + paramList + '}';

    $.ajax({
        type: "POST",
        url: page + "/" + fn,
        data: paramList,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: (successFn) ? successFn : null,
        error: (errorFn) ? errorFn : null
    });
}

//---------------------------------------------+
// jQuery AJAX Call Succeeded.                 |
//---------------------------------------------+
function AjaxSucceeded(result) {
    alert("Ajax OK : " + result.d);
}

//------------------------------------------------+
// jQuery AJAX Call FAILED.                       |
//------------------------------------------------+
function AjaxFailed(result) {
    alert("AJAX Failed : " + result.d);
}

function jAlert(message, messTitle) {
    /// <param type="String" name="message">Zpráva (nebo HTML kód), která se má zobrazit</param>
    /// <param type="String" name="messTitle" optional="true">(Optional) Titulek zprávy</param>
    $("<div>" + message + "</div>").dialog({
        modal: true,
        title: (messTitle) ? messTitle: "Oznámení"
    });
}