/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.scheduler.min",["kendo.dropdownlist.min","kendo.editable.min","kendo.multiselect.min","kendo.window.min","kendo.datetimepicker.min","kendo.scheduler.recurrence.min","kendo.scheduler.view.min","kendo.scheduler.dayview.min","kendo.scheduler.agendaview.min","kendo.scheduler.monthview.min","kendo.scheduler.timelineview.min","kendo.scheduler.yearview.min","kendo.dialog.min","kendo.pane.min","kendo.pdf.min","kendo.switch.min"],function(){var e={id:"scheduler",name:"Scheduler",category:"web",description:"The Scheduler is an event calendar.",depends:["dropdownlist","editable","multiselect","window","datepicker","datetimepicker","scheduler.recurrence","scheduler.view"],features:[{id:"scheduler-dayview",name:"Scheduler Day View",description:"Scheduler Day View",depends:["scheduler.dayview"]},{id:"scheduler-agendaview",name:"Scheduler Agenda View",description:"Scheduler Agenda View",depends:["scheduler.agendaview"]},{id:"scheduler-monthview",name:"Scheduler Month View",description:"Scheduler Month View",depends:["scheduler.monthview"]},{id:"scheduler-timelineview",name:"Scheduler Timeline View",description:"Scheduler Timeline View",depends:["scheduler.timelineview"]},{id:"scheduler-yearview",name:"Scheduler Year View",description:"Scheduler Year View",depends:["scheduler.yearview"]},{id:"scheduler-mobile",name:"Scheduler adaptive rendering",description:"Support for adaptive rendering",depends:["dialog","pane","switch"]},{id:"scheduler-pdf-export",name:"PDF export",description:"Export the scheduler events as PDF",depends:["pdf","drawing"]},{id:"scheduler-timezones",name:"Timezones",description:"Allow selecting timezones different than Etc/UTC",depends:["timezones"]}]},w=window.kendo.jQuery,h=void 0,y=window.kendo,r=y.date,d=r.MS_PER_DAY,z=r.getDate,f=y.date.getMilliseconds,o=y.recurrence,u=w.extend({F10:121},y.keys),t=y.ui,a=t.Widget,i=t.DataBoundWidget,v="string",s=t.Popup,l=t.Calendar,p=y.data.DataSource,m=w.isPlainObject,g=w.extend,n=Object.prototype.toString,T=Array.isArray,k=".kendoScheduler",b="click",D="mousedown",S=y.support.pointers?"pointerdown":"touchstart",x=y.support.pointers?"pointermove":"touchmove",E=y.support.pointers?"pointerup":"touchend",C=y.support.mousemove,_="change",R="progress",V="error",P="cancel",F="remove",O="resetSeries",A="save",I="add",M="edit",H="disabled",B="option",c="k-focus",N=".k-scheduler-views",W="k-event-inverse",L=/(?:value:start|value:end)(?:,|$)/,U=z(new Date),K=",",Y=/\;/g,q="recurrenceException",$="Are you sure you want to delete this event?",Q="Do you want to delete only this event occurrence or the whole series?",j="Do you want to edit only this event occurrence or the whole series?",J="Are you sure you want to delete this event occurrence?",G="Are you sure you want to reset the whole series?",X="Are you sure you want to delete the whole series?",Z='<button type="button" class="k-button k-button-md k-rounded-md k-button-solid #=className#" #=attr#><span class="k-button-text">#=text#</span></button>',ee=y.template(""+'<select aria-label="#= label #" class="k-picker k-dropdown-list k-dropdown k-views-dropdown" tabindex="-1">'+"#for (var view in views) {#"+'<option value="#= view #">${views[view].title}</option>'+"#}#"+"</select>"),te=y.template(""+'<div class="k-scheduler-toolbar k-toolbar" role="toolbar">'+"# if (pdf) { #"+'<button tabindex="-1" class="k-button k-button-md k-rounded-md k-button-solid k-button-solid-base k-pdf"><span class="k-button-icon k-icon k-i-file-pdf"></span><span class="k-button-text">${messages.pdf}</span></button>'+"# } #"+'<span class="k-scheduler-navigation k-button-group">'+'<button tabindex="-1" class="k-button k-button-md k-rounded-md k-button-solid k-button-solid-base k-nav-today" title="${messages.today}"><span class="k-button-text">${messages.today}</span></button>'+'<button tabindex="-1" class="k-button k-button-md k-rounded-md k-button-solid k-button-solid-base k-icon-button k-nav-prev" title="${messages.previous}" aria-label="${messages.previous}"><span class="k-button-icon k-icon k-i-arrow-60-left"></span></button>'+'<button tabindex="-1" class="k-button k-button-md k-rounded-md k-button-solid k-button-solid-base k-icon-button k-nav-next" title="${messages.next}" aria-label="${messages.next}"><span class="k-button-icon k-icon k-i-arrow-60-right"></span></button>'+"</span>"+'<a tabindex="-1" role="button" href="\\#" class="k-nav-current" aria-live="polite">'+'<span class="k-icon k-i-calendar"></span>'+'<span class="k-sm-date-format" data-#=ns#bind="text: formattedShortDate"></span>'+'<span class="k-lg-date-format" data-#=ns#bind="text: formattedDate"></span>'+"</a>"+'<span class="k-spacer k-toolbar-spacer"></span>'+"# if (search) { #"+'<span class="k-scheduler-search k-textbox k-input k-input-md k-rounded-md k-input-solid">'+'<input tabindex="-1" autocomplete="off" placeholder="${messages.search}" title="${messages.search}" class="k-input-inner k-scheduler-search-input k-input-inner" />'+'<span class="k-input-suffix"><span class="k-icon k-i-search"></span></span>'+"</span>"+"# } #"+"# if (viewsCount === 1) { #"+'<a role="button" tabindex="-1" data-#=ns#name="#=view#" href="\\#" class="k-button k-button-md k-rounded-md k-button-solid k-button-solid-base k-icon-button k-scheduler-refresh" aria-label="${messages.refresh}">'+'<span class="k-button-icon k-icon k-i-reload"></span>'+"</a>"+"# } else { #"+'<span class="k-scheduler-views-wrapper">'+'<span class="k-scheduler-views k-button-group">'+"# for (var view in views) { #"+'<button tabindex="-1" class="k-button k-button-md k-rounded-md k-button-solid k-button-solid-base k-view-#= view.toLowerCase() #" data-#=ns#name="#=view#"><span class="k-button-text">${views[view].title}</span></button>'+"# } #"+"</span>"+"</span>"+"# } #"+"</div>"),ie=y.template('<div class="k-scheduler-toolbar k-toolbar" role="toolbar">'+'<span class="k-scheduler-tools k-button-group">'+"# if (pdf) { #"+'<button tabindex="-1" class="k-button k-button-md k-rounded-md k-button-solid k-button-solid-base k-icon-button k-pdf"><span class="k-button-icon k-icon k-i-file-pdf"></span></button>'+"# } #"+'<button tabindex="-1" class="k-button k-button-md k-rounded-md k-button-solid k-button-solid-base k-icon-button k-nav-calendar"><span class="k-button-icon k-icon k-i-calendar"></span></button>'+"# if (editable) { #"+'<button tabindex="-1" class="k-button k-button-md k-rounded-md k-button-solid k-button-solid-base k-icon-button k-create-event"><span class="k-button-icon k-icon k-i-plus"></span></button>'+"# } #"+"</span>"+'<span class="k-spacer k-toolbar-spacer"></span>'+"# if (search) { #"+'<span class="k-scheduler-search k-textbox k-input k-input-md k-rounded-md k-input-solid">'+'<input tabindex="-1" autocomplete="off" placeholder="${messages.search}" title="${messages.search}" class="k-scheduler-search-input k-input-inner" />'+'<span class="k-input-suffix"><span class="k-icon k-i-search"></span></span>'+"</span>"+"# } #"+"#if(viewsCount === 1){#"+'<a role="button" tabindex="-1" data-#=ns#name="#=view#" href="\\#" class="k-button k-button-md k-rounded-md k-button-solid k-button-solid-base k-icon-button k-scheduler-refresh">'+'<span class="k-button-icon k-icon k-i-reload"></span>'+"</a>"+"#} else {#"+'<select tabindex="-1" class="k-picker k-dropdown-list k-dropdown k-scheduler-mobile-views">'+"#for(var view in views){#"+'<option class="k-view-#= view.toLowerCase() #" value="#=view#">${views[view].title}</option>'+"#}#"+"</select>"+"#}#"+"</div>"+'<div class="k-scheduler-toolbar k-toolbar" role="toolbar">'+'<span class="k-scheduler-navigation">'+'<button tabindex="-1" class="k-button k-button-md k-rounded-md k-button-solid k-button-solid-base k-icon-button k-nav-prev"><span class="k-button-icon k-icon k-i-arrow-chevron-left"></span></button>'+'<span class="k-nav-current">'+'<span class="k-m-date-format" data-#=ns#bind="text: formattedMobileDate"></span>'+'<span class="k-y-date-format" data-#=ns#bind="text: formattedYear"></span>'+"</span>"+'<button tabindex="-1" class="k-button k-button-md k-rounded-md k-button-solid k-button-solid-base k-icon-button k-nav-next"><span class="k-button-icon k-icon k-i-arrow-chevron-right"></span></button>'+"</span>"+"</div>"),ne=function(e,t){var i={name:t.field,title:t.title};var n=t.model.isAllDay;var a=y.attr("validate")+"='"+!n+"'";var r=y.attr("validate")+"='"+!!n+"'";pe(i,t);he(i,t);me(i,t);w('<input type="datetime-local" required '+y.attr("type")+'="datetime-local" '+y.attr("bind")+'="value:'+t.field+', invisible:isAllDay" '+a+"/>").attr(i).appendTo(e);w('<input type="date" required '+y.attr("type")+'="date" '+y.attr("bind")+'="value:'+t.field+',visible:isAllDay" '+r+"/>").attr(i).appendTo(e);w("<span "+y.attr("for")+'="'+t.field+'" class="k-invalid-msg"/>').hide().appendTo(e)},ae=function(e,t){var i={name:t.field,title:t.title},n=t.model.isAllDay,a=y.attr("validate")+"='"+!n+"' ",r=y.attr("validate")+"='"+!!n+"' ";pe(i,t);he(i,t);me(i,t);w('<input type="text" required '+y.attr("type")+'="date"'+" "+y.attr("role")+'="datetimepicker" '+y.attr("bind")+'="value:'+t.field+',invisible:isAllDay" '+a+"/>").attr(i).appendTo(e);w('<input type="text" required '+y.attr("type")+'="date"'+" "+y.attr("role")+'="datepicker" '+y.attr("bind")+'="value:'+t.field+',visible:isAllDay" '+r+"/>").attr(i).appendTo(e);w("<span "+y.attr("bind")+'="text: '+t.field+'Timezone"></span>').appendTo(e);if(t.field==="end")w("<span "+y.attr("bind")+'="text: startTimezone, invisible: endTimezone"></span>').appendTo(e);w("<span "+y.attr("for")+'="'+t.field+'" class="k-invalid-msg"/>').hide().appendTo(e)},re=function(e,t){w("<div "+y.attr("bind")+'="value:'+t.field+'" />').attr({name:t.field}).appendTo(e).kendoRecurrenceEditor({start:t.model.start,timezone:t.timezone,messages:t.messages})},oe=function(e,t){w("<div "+y.attr("bind")+'="value:'+t.field+'" />').attr({name:t.field}).appendTo(e).kendoMobileRecurrenceEditor({start:t.model.start,timezone:t.timezone,messages:t.messages,pane:t.pane,value:t.model[t.field]})},se=function(e,t){w('<input type="checkbox" data-role="switch"'+y.attr("bind")+'="value:'+t.field+'" />').appendTo(e)},le=function(e,t){w('<input type="checkbox" data-role="checkbox"'+y.attr("bind")+'="value:'+t.field+'" data-label="'+t.title+'" />').attr({id:t.field,name:t.field,title:t.title?t.title:t.field}).appendTo(e)},de=function(e,t){var i=ve(t.model,t.messages.noTimezone);w('<span class="k-timezone-label"></span>').text(i).appendTo(e);w('<span class="k-icon k-i-arrow-chevron-right"></span>').appendTo(e);e.closest("li.k-item label").on(b,t.click)},ce=function(e,t){w('<a href="#" class="k-button k-button-md k-rounded-md k-button-solid k-button-solid-base" data-bind="invisible:isAllDay"><span class="k-button-text">'+t.messages.timezoneEditorButton+"</span></a>").on(b,t.click).appendTo(e)},ue=function(e,t){w('<div class="k-mobiletimezoneeditor" '+y.attr("bind")+'="value:'+t.field+'" />').attr({name:t.field}).appendTo(e).kendoMobileTimezoneEditor({optionLabel:t.noTimezone})},fe=function(e,t){var i=t.visible||t.visible===h;w("<div "+y.attr("bind")+'="value:'+t.field+'" />').attr({name:t.field}).toggle(i).appendTo(e).kendoTimezoneEditor({optionLabel:t.noTimezone,title:t.title})};function ve(e,t){t=t||"";if(e.startTimezone){t=e.startTimezone;if(e.endTimezone)t+=" | "+e.endTimezone}return t}function pe(e,t){var i=t.timezone;if(i)e[y.attr("timezone")]=i}function he(e,t){var i=t.model.fields[t.field].validation;if(i){var n=i.validDateValidator;if(n&&m(n)&&n.message)e[y.attr("validDate-msg")]=n.message}}function me(e,t){var i=t.model.fields[t.field].validation;if(i){var n=i.dateCompare;if(n&&m(n)&&n.message)e[y.attr("dateCompare-msg")]=n.message}}function ge(t,i){return function(e){e=t(e);be(e,"apply",i);return e||[]}}function ke(t,i){return function(e){if(e)if(n.call(e)!=="[object Array]"&&!(e instanceof y.data.ObservableArray))e=[e];be(e,"remove",i,true);e=t(e);return e||[]}}function be(e,t,i,n){var a,r,o,s,l;e=e||[];for(r=0,o=e.length;r<o;r++){a=e[r];s=a.start?a.start.getTimezoneOffset():null;l=a.start?a.end.getTimezoneOffset():null;if(n){if(a.startTimezone||a.endTimezone)if(i){a.start=y.timezone.convert(a.start,a.startTimezone||a.endTimezone,i);a.end=y.timezone.convert(a.end,a.endTimezone||a.startTimezone,i);a.start=y.timezone[t](a.start,i);a.end=y.timezone[t](a.end,i)}else{a.start=y.timezone[t](a.start,a.startTimezone||a.endTimezone);a.end=y.timezone[t](a.end,a.endTimezone||a.startTimezone)}else if(i){a.start=y.timezone[t](a.start,i);a.end=y.timezone[t](a.end,i)}}else if(a.startTimezone||a.endTimezone){a.start=y.timezone[t](a.start,a.startTimezone||a.endTimezone);a.end=y.timezone[t](a.end,a.endTimezone||a.startTimezone);if(i){a.start=y.timezone.convert(a.start,a.startTimezone||a.endTimezone,i);a.end=y.timezone.convert(a.end,a.endTimezone||a.startTimezone,i)}}else if(i){a.start=y.timezone[t](a.start,i);a.end=y.timezone[t](a.end,i)}if(n)delete a.uid;if(t==="remove"&&a.start&&s&&s!==a.start.getTimezoneOffset())a.start=new Date(a.start.getTime()+(s-a.start.getTimezoneOffset())*6e4);if(t==="remove"&&a.end&&l&&l!==a.end.getTimezoneOffset())a.end=new Date(a.end.getTime()+(l-a.end.getTimezoneOffset())*6e4)}return e}function _e(e,t){var i=e.length,n=0,a;for(;n<i;n++){a=e[n];if(a.uid===t)return a}}var we=y.Class.extend({init:function(e,t){var i=e.timezone;this.reader=t;if(t.model)this.model=t.model;this.timezone=i;this.data=ge(this.data.bind(this),i);this.serialize=ke(this.serialize.bind(this),i)},errors:function(e){return this.reader.errors(e)},parse:function(e){return this.reader.parse(e)},data:function(e){return this.reader.data(e)},total:function(e){return this.reader.total(e)},groups:function(e){return this.reader.groups(e)},aggregates:function(e){return this.reader.aggregates(e)},serialize:function(e){return this.reader.serialize(e)}});function ye(e,t,i){if(i)e=y.timezone.convert(e,t,i);else e=y.timezone.remove(e,t);return e}function ze(e){if(e.filter("[name=start]").length&&e.filter("[title=Start]").length||e.filter("[name=end]").length&&e.filter("[title=End]").length||e.filter(".k-recur-until").length){var t;var i=y.widgetInstance(e,y.ui);if(i){t=y.parseDate(e.val(),i.options.format);return!!t&&i.value()}else{t=y.parseDate(e.val());return!!t}}return true}function Te(e){if(e.filter("[name=end]").length){var t=e.closest(".k-scheduler-edit-form");var i=t.find("[name=start]:visible");var n=t.find("[name=end]:visible");if(n[0]&&i[0]){var a,r;var o=y.widgetInstance(i,y.ui);var c=y.widgetInstance(n,y.ui);var u=t.data("kendoEditable");var s=u?u.options.model:null;if(o&&c){a=o.value();r=c.value()}else{a=y.parseDate(i.val());r=y.parseDate(n.val())}if(a&&r){if(s){var f=i.attr(y.attr("timezone"));var l=s.startTimezone;var d=s.endTimezone;l=l||d;d=d||l;if(l){a=ye(a,l,f);r=ye(r,d,f)}}return a<=r}}}return true}function De(e){var t,i,n,a,r,o;if(e.filter(".k-recur-until").length){t=y.widgetInstance(e,y.ui);i=t.value();n=e.closest(".k-scheduler-edit-form");a=n.find("[name=start]:visible");if(a[0]){o=y.widgetInstance(a,y.ui);if(o)r=o.value();else r=y.parseDate(a.val());if(r&&i)return r<=i}}return true}var Se=y.data.Model.define({init:function(e){var t=this;y.data.Model.fn.init.call(t,e);t._defaultId=t.defaults[t.idField]},_time:function(e){var t=this[e];var i="_"+e+"Time";if(this[i])return this[i]-y.date.toUtcTime(y.date.getDate(t));return f(t)},_date:function(e){var t="_"+e+"Time";if(this[t])return this[t]-this._time(e);return y.date.getDate(this[e])},clone:function(e,t){var i=this.uid,n=new this.constructor(w.extend({},this.toJSON(),e));if(!t)n.uid=i;return n},duration:function(){var e=this.end;var t=this.start;var i=(e.getTimezoneOffset()-t.getTimezoneOffset())*y.date.MS_PER_MINUTE;return e-t-i},expand:function(e,t,i){return o?o.expand(this,e,t,i):[this]},update:function(e){for(var t in e)this.set(t,e[t]);if(this._startTime)this.set("_startTime",y.date.toUtcTime(this.start));if(this._endTime)this.set("_endTime",y.date.toUtcTime(this.end))},isMultiDay:function(){return this.isAllDay||this.duration()>=y.date.MS_PER_DAY},isException:function(){return!this.isNew()&&this.recurrenceId},isOccurrence:function(){return this.isNew()&&this.recurrenceId},isRecurring:function(){return!!(this.recurrenceRule||this.recurrenceId)},isRecurrenceHead:function(){return!!(this.id&&this.recurrenceRule)},toOccurrence:function(e){e=w.extend(e,{recurrenceException:null,recurrenceRule:null,recurrenceId:this.id||this.recurrenceId});e[this.idField]=this.defaults[this.idField];return this.clone(e,true)},toJSON:function(){var e=y.data.Model.fn.toJSON.call(this);e.uid=this.uid;delete e._startTime;delete e._endTime;return e},shouldSerialize:function(e){return y.data.Model.fn.shouldSerialize.call(this,e)&&e!=="_defaultId"},set:function(e,t){var i=this.isAllDay||false;y.data.Model.fn.set.call(this,e,t);if(e=="isAllDay"&&t!=i){var n=y.date.getDate(this.start);var a=new Date(this.end);var r=y.date.getMilliseconds(a);if(r===0&&t)r=d;this.set("start",n);if(t===true){y.date.setTime(a,-r);if(a<n)a=n}else y.date.setTime(a,d-r);this.set("end",a)}},id:"id",fields:{id:{type:"number"},title:{defaultValue:"",type:"string"},start:{type:"date",validation:{required:true,validDate:{value:ze}}},startTimezone:{type:"string"},end:{type:"date",validation:{required:true,validDate:{value:ze},dateCompare:{value:Te}}},endTimezone:{type:"string"},recurrenceRule:{defaultValue:"",type:"string",validation:{validDate:{value:ze},untilDateCompare:{value:De}}},recurrenceException:{defaultValue:"",type:"string"},isAllDay:{type:"boolean",defaultValue:false},description:{type:"string"}}}),xe=p.extend({init:function(e){p.fn.init.call(this,g(true,{},{schema:{modelBase:Se,model:Se}},e));this.reader=new we(this.options.schema,this.reader)},expand:function(e,t){var i=this.view(),n={},a;if(e&&t){a=t.getTimezoneOffset();t=new Date(t.getTime()+d-1);if(t.getTimezoneOffset()!==a)t=y.timezone.apply(t,a);n={logic:"or",filters:[{logic:"and",filters:[{field:"start",operator:"gte",value:e},{field:"end",operator:"gte",value:e},{field:"start",operator:"lte",value:t}]},{logic:"and",filters:[{field:"start",operator:"lte",value:new Date(e.getTime()+d-1)},{field:"end",operator:"gte",value:e}]}]};i=new y.data.Query(Ee(i,e,t,this.reader.timezone)).filter(n).toArray()}return i},cancelChanges:function(e){if(e&&e.isOccurrence())this._removeExceptionDate(e);p.fn.cancelChanges.call(this,e)},insert:function(e,t){if(!t)return;if(!(t instanceof Se)){var i=t;t=this._createNewModel();t.accept(i)}if(!this._pushCreated&&t.isRecurrenceHead()||t.recurrenceId){t=t.recurrenceId?t:t.toOccurrence();this._addExceptionDate(t)}return p.fn.insert.call(this,e,t)},pushCreate:function(e){this._pushCreated=true;p.fn.pushCreate.call(this,e);this._pushCreated=false},remove:function(e){if(e.isRecurrenceHead())this._removeExceptions(e);else if(e.isRecurring())this._addExceptionDate(e);return p.fn.remove.call(this,e)},_removeExceptions:function(e){var t=this.data().slice(0),i=t.shift(),n=e.id;while(i){if(i.recurrenceId===n)p.fn.remove.call(this,i);i=t.shift()}e.set(q,"")},_removeExceptionDate:function(e){if(e.recurrenceId){var t=this.get(e.recurrenceId);if(t){var i=e.defaults.start;var n=new RegExp("(\\"+K+"?)"+o.toExceptionString(i,this.reader.timezone));var a=(t.recurrenceException||"").replace(Y,K).replace(/\,$/,"");if(n.test(a))t.set(q,a.replace(n,""));else{i=e.start;n=new RegExp("(\\"+K+"?)"+o.toExceptionString(i,this.reader.timezone));t.set(q,a.replace(n,""))}}}},_addExceptionDate:function(e){var t=e.start;var i=this.reader.timezone;var n=this.get(e.recurrenceId);var a=(n.recurrenceException||"").replace(Y,K).replace(/\,$/,"");if(!o.isException(a,t,i)){var r=o.toExceptionString(t,i);e.defaults.start=t;n.set(q,a+(a&&r?K:"")+r)}}});function Ee(e,t,i,n){var a=e.length,r=[],o=0;for(;o<a;o++)r=r.concat(e[o].expand(t,i,n));return r}xe.create=function(e){if(T(e)||e instanceof y.data.ObservableArray)e={data:e};var t=e||{},i=t.data;t.data=i;if(!(t instanceof xe)&&t instanceof y.data.DataSource)throw new Error("Incorrect DataSource type. Only SchedulerDataSource instances are supported");return t instanceof xe?t:new xe(t)},g(true,y.data,{SchedulerDataSource:xe,SchedulerDataReader:we,SchedulerEvent:Se});var Ce={update:{text:"Save",className:"k-button-solid-primary k-scheduler-update"},canceledit:{text:"Cancel",className:"k-scheduler-cancel"},destroy:{text:"Delete",imageClass:"k-i-close",className:"k-button-solid-primary k-scheduler-delete",iconClass:"k-icon"}};function Re(e,t){delete e.name;delete e.prefix;delete e.remove;delete e.edit;delete e.add;delete e.navigate;for(var i in t)e[i]=t[i];return e}function Ve(e){var i=Pe(e.model,e.field);return function(e,t){w('<textarea name="description" class="k-input-inner" title="'+t.title+'"/>').attr(i).appendTo(e).wrap('<span class="k-input k-textarea k-input-solid k-input-md k-rounded-md"></span>')}}function Pe(e,t){var i=(e.fields||e)[t];var n=["url","email","number","date","boolean"];var a=i?i.validation:{};var r=y.attr("type");var o=w.inArray;var s;var l;var d={};for(s in a){l=a[s];if(o(s,n)>=0)d[r]=s;else if(!y.isFunction(l))d[s]=m(l)?l.value||s:l;d[y.attr(s+"-msg")]=l.message}return d}function Fe(i,n,a,r){var e=i.value(),o=Array.isArray(e),s;if(o)s=JSON.parse(JSON.stringify(e));else s=[e.toString()];i.dataSource.data().forEach(function(e){if(e[a]===null||e[a]===h||e[a]==n)e.set(H,false);else{var t=e.get(r);e.set(H,true);if(s.indexOf(t)>=0||s.indexOf(t.toString())>=0)if(o)s.splice(s.indexOf(t),1);else{i.value(null);i.trigger(_)}}});if(o&&s.length<e.length){i.value(s);i.trigger(_)}}function Oe(e,i,n,t){var a=e.closest(".k-edit-form-container").find("[data-"+y.ns+"bind='value:"+t+"']");var r=a.getKendoDropDownList();if(r)r.bind(_,function(e){var t=e.sender.value();Fe(i,t,n.dataParentValueField,n.dataValueField)});else a.on(_,function(e){var t=e.target.value;Fe(i,t,n.dataParentValueField,n.dataValueField)})}function Ae(r,o,s){var l=o.find(B),e=o.val(),d=Array.isArray(e),c;if(d)c=JSON.parse(JSON.stringify(e));else c=[e];r.dataSource.view().forEach(function(e,t){var i=y.getter(r.dataParentValueField)(e);var n=i===null||i===h||i==s;if(n)l[t].removeAttribute(H);else{l[t].setAttribute(H,H);var a=""+e.get(r.dataValueField);if(c.indexOf(a)>=0)if(d)c.splice(c.indexOf(a),1);else{o.val(null);o.trigger(_)}}});if(d&&c.length<e.length){o.val(c);o.trigger(_)}}function Ie(i,n,a){var r=Pe(n,i.field);return function(e){var t;if(a)setTimeout(function(){Fe(t,n[a],i.dataParentValueField,i.dataValueField);Oe(e,t,i,a)});t=w(y.format('<select aria-labelledby="'+i.field+'_label" data-{0}bind="value:{1}" title="'+n.title+'">',y.ns,i.field)).appendTo(e).attr(r).kendoDropDownList({dataTextField:i.dataTextField,dataValueField:i.dataValueField,dataSource:i.dataSource.data(),valuePrimitive:i.valuePrimitive,optionLabel:"None",template:y.format('<span #= data.disabled ? "data-disabled": ""#><span class="k-scheduler-mark" style="background-color:#= data.{0}?{0}:"none" #"></span>#={1}#</span>',i.dataColorField,i.dataTextField),select:function(e){if(e.dataItem&&e.dataItem.disabled)e.preventDefault()},dataBound:function(e){var t=e.sender.list.find("li");t.each(function(e,t){var i=w(t);if(i.find("[data-disabled]").length>0)i.addClass("k-disabled")})}}).data("kendoDropDownList")}}function Me(o,s,l){var d=Pe(s,o.field);return function(i){var e="";var t=o.dataSource.view();for(var n=0,a=t.length;n<a;n++)e+=y.format('<option value="{0}">{1}</option>',y.getter(o.dataValueField)(t[n]),y.getter(o.dataTextField)(t[n]));var r=w(y.format('<select aria-labelledby="'+o.field+'_label" data-{0}bind="value:{1}">{2}</select>',y.ns,o.field,e)).appendTo(i).attr(d);if(l)setTimeout(function(){var e=i.closest(".k-stretched-view").find("[data-"+y.ns+"bind='value:"+l+"']");var t=s[l];Ae(o,r,t);e.on(_,function(e){var t=e.target.value;Ae(o,r,t)})})}}function He(i,n,a){var r=Pe(n,i.field);return function(e){var t;if(a)setTimeout(function(){Fe(t,n[a],i.dataParentValueField,i.dataValueField);Oe(e,t,i,a)});t=w(y.format('<select aria-labelledby="'+i.field+'_label" data-{0}bind="value:{1}">',y.ns,i.field)).appendTo(e).attr(r).kendoMultiSelect({dataTextField:i.dataTextField,dataValueField:i.dataValueField,dataSource:i.dataSource.data(),valuePrimitive:i.valuePrimitive,itemTemplate:y.format('<span #= data.disabled ? "data-disabled": "" #><span class="k-scheduler-mark" style="background-color:#= data.{0}?{0}:"none" #"></span>#={1}#</span>',i.dataColorField,i.dataTextField),tagTemplate:y.format('<span class="k-scheduler-mark" style="background-color:#= data.{0}?{0}:"none" #"></span>#={1}#',i.dataColorField,i.dataTextField),select:function(e){if(e.dataItem&&e.dataItem.disabled)e.preventDefault()},dataBound:function(e){var t=e.sender.list.find("li");t.each(function(e,t){var i=w(t);if(i.find("[data-disabled]").length>0)i.addClass("k-disabled")})}}).data("kendoMultiSelect")}}function Be(o,s,l){var d=Pe(s,o.field);return function(i){var e="";var t=o.dataSource.view();for(var n=0,a=t.length;n<a;n++)e+=y.format('<option value="{0}">{1}</option>',y.getter(o.dataValueField)(t[n]),y.getter(o.dataTextField)(t[n]));var r=w(y.format('<select aria-labelledby="'+o.field+'_label" data-{0}bind="value:{1}" multiple="multiple">{2}</select>',y.ns,o.field,e)).appendTo(i).attr(d);if(l)setTimeout(function(){var e=i.closest(".k-stretched-view").find("[data-"+y.ns+"bind='value:"+l+"']");var t=s[l];Ae(o,r,t);e.on(_,function(e){var t=e.target.value;Ae(o,r,t)})})}}function Ne(e,t){var i=e.end.getTime()-e.start.getTime();var n=new Date(e.start.getTime());y.date.setTime(n,t);var a=new Date(n.getTime());y.date.setTime(a,i,true);return{start:n,end:a}}var We={mobile:{dateRange:ne,timezonePopUp:de,timezone:ue,recurrence:oe,description:Ve,multipleResources:Be,resources:Me,isAllDay:se},desktop:{dateRange:ae,timezonePopUp:ce,timezone:fe,recurrence:re,description:Ve,multipleResources:He,resources:Ie,isAllDay:le}},Le=y.Observable.extend({init:function(e,t){y.Observable.fn.init.call(this);this.element=e;this.options=g(true,{},this.options,t);this.createButton=this.options.createButton;this.toggleDateValidationHandler=this._toggleDateValidation.bind(this)},_toggleDateValidation:function(e){if(e.field=="isAllDay"){var t=this.container,i=this.editable.options.model.isAllDay,n=y.attr("bind"),a,r,o;t.find("["+n+"*=end],["+n+"*=start]").each(function(){a=w(this);if(L.test(a.attr(n))){r=a.is("["+y.attr("role")+"=datetimepicker],[type*=datetime]");o=i!==r;a.attr(y.attr("validate"),o)}})}},fields:function(e,t){var i=this;var n=i.options.messages;var a=i.options.timezone;var c=function(e){e.preventDefault();i._initTimezoneEditor(t,this)};var r=[{field:"title",title:n.editor.title},{field:"start",title:n.editor.start,editor:e.dateRange,timezone:a},{field:"end",title:n.editor.end,editor:e.dateRange,timezone:a},{field:"isAllDay",title:n.editor.allDayEvent,editor:e.isAllDay}];var u=function(e){return!!e[s.dataParentValueField]};if(y.timezone.windows_zones){r.push({field:"timezone",title:n.editor.timezone,editor:e.timezonePopUp,click:c,messages:n.editor,model:t});r.push({field:"startTimezone",title:n.editor.startTimezone,editor:e.timezone,noTimezone:n.editor.noTimezone});r.push({field:"endTimezone",title:n.editor.endTimezone,editor:e.timezone,noTimezone:n.editor.noTimezone})}if(!t.recurrenceId)r.push({field:"recurrenceRule",title:n.editor.repeat,editor:e.recurrence,timezone:a,messages:n.recurrenceEditor,pane:this.pane});if("description"in t)r.push({field:"description",title:n.editor.description,editor:e.description({model:t,field:"description"})});for(var o=0;o<this.options.resources.length;o++){var s=this.options.resources[o];var f=s.dataSource.view();var v=f.some(u);var l,d;if(v){l=this.options.resources[o-1];if(l)d=l.field}r.push({field:s.field,title:s.title,editor:s.multiple?e.multipleResources(s,t,d):e.resources(s,t,d)})}return r},end:function(){return this.editable.end()},_buildDesktopEditTemplate:function(e,t,i){var n=this.options.messages;var a=g({},y.Template,this.options.templateSettings);var r=a.paramName;var o="";o+='<div class="k-form">';for(var s=0,c=t.length;s<c;s++){var l=t[s];if(l.field==="startTimezone"){o+='<div class="k-popup-edit-form k-scheduler-edit-form k-scheduler-timezones" style="display:none">';o+='<div class="k-form">';o+='<div class="k-form-field"><div class="k-form-field-wrap">'+y.html.renderCheckBox(w('<input class="k-timezone-toggle"/>'),{label:n.editor.separateTimezones})+"</div></div>"}if(e.fields[l.field]&&e.fields[l.field].type==="boolean")o+='<div class="k-form-field">';else o+='<div class="k-form-field"><label class="k-label k-form-label" for="'+l.field+'" id="'+l.field+'_label">'+(l.title||l.field||"")+"</label>";if(!e.editable||e.editable(l.field)){i.push(l);o+="<div "+y.attr("container-for")+'="'+l.field+'" class="k-form-field-wrap"></div>'}else{var d="#:";if(l.field){l=y.expr(l.field,r);d+=l+"==null?'':"+l}else d+="''";d+="#";d=y.template(d,a);o+='<div class="k-form-field-wrap">'+d(e)+"</div>"}o+="</div>";if(l.field==="endTimezone")o+=this._createEndTimezoneButton()}o+="</div>";return o},_buildMobileEditTemplate:function(e,t,i){var n=this.options.messages;var a=g({},y.Template,this.options.templateSettings);var r=a.paramName;var o="";o+='<ul class="k-listgroup k-listgroup-flush">';for(var s=0,c=t.length;s<c;s++){var l=t[s];if(l.field==="timezone"||l.field==="recurrenceRule")o+='</ul><ul class="k-listgroup k-listgroup-flush">';if(l.field==="startTimezone"){o+='<div class="k-popup-edit-form k-scheduler-edit-form k-scheduler-timezones" style="display:none">';o+='<ul class="k-listgroup k-listgroup-flush">';o+='<li class="k-item k-listgroup-item">';o+='<label class="k-label k-listgroup-form-row">';o+='<span class="k-item-title k-listgroup-form-row">'+n.editor.separateTimezones+"</span>";o+='<span class="k-listgroup-form-field-wrapper">';o+='<input class="k-timezone-toggle" data-role="switch" type="checkbox" />';o+="</span>";o+="</label>";o+="</li>"}if(!e.editable||e.editable(l.field)){o+='<li class="k-item k-listgroup-item">';if(l.field==="timezone")o+='<label class="k-label k-listgroup-form-row" data-bind="css: { k-disabled: isAllDay }">';else o+='<label class="k-label k-listgroup-form-row">';o+='<span class="k-item-title k-listgroup-form-field-label">'+(l.title||l.field||"")+"</span>";i.push(l);o+='<div class="k-listgroup-form-field-wrapper" '+y.attr("container-for")+'="'+l.field+'"></div>';o+="</label></li>"}else{var d="#:";o+='<li class="k-item k-listgroup-item">';o+='<label class="k-label k-no-click k-listgroup-form-row">';o+='<span class="k-item-title k-listgroup-form-field-label">'+(l.title||l.field||"")+"</span>";if(l.field){l=y.expr(l.field,r);d+=l+"==null?'':"+l}else d+="''";d+="#";d=y.template(d,a);o+='<span class="k-no-editor k-listgroup-form-field-wrapper">'+d(e)+"</span>";o+="</label></li>"}if(l.field==="recurrenceRule")o+='</ul><ul class="k-listgroup k-listgroup-flush">';if(l.field==="endTimezone")o+="</ul></div>"}o+="</ul>";return o},_buildEditTemplate:function(e,t,i,n){var a=g({},y.Template,this.options.templateSettings);var r=this.options.editable.template;var o="";if(r){if(typeof r===v)r=y.unescape(r);o+=y.template(r,a)(e)}else if(n)o+='<div data-role="content">'+this._buildMobileEditTemplate(e,t,i)+"</div>";else o+=this._buildDesktopEditTemplate(e,t,i);return o},_createEndTimezoneButton:function(){return"</ul></div>"},_revertTimezones:function(e){e.set("startTimezone",this._startTimezone);e.set("endTimezone",this._endTimezone);delete this._startTimezone;delete this._endTimezone}}),Ue=Le.extend({init:function(){Le.fn.init.apply(this,arguments);this.pane=y.Pane.wrap(this.element,{viewEngine:{viewOptions:{renderOnInit:true,wrap:false,wrapInSections:true,detachOnHide:false,detachOnDestroy:false}}});this.pane.element.parent().css("height",this.options.height);this.view=this.pane.view()},options:{animations:{left:"slide",right:"slide:right"}},destroy:function(){this.close();this.unbind();this.pane.destroy()},_initTimezoneEditor:function(n){var a=this;var r=a.pane;var o=a.options.messages;var e=a.timezoneView;var t=e?e.content.find(".k-scheduler-timezones"):a.container.find(".k-scheduler-timezones");var i=t.find("input.k-timezone-toggle").data("kendoSwitch");var s=t.find("li.k-item:not(.k-zonepicker)").last();var l=function(e){if(e.field==="startTimezone"){var t=n.startTimezone;i.enable(t);if(!t){s.hide();n.set("endTimezone","");i.value(false)}}};a._startTimezone=n.startTimezone||"";a._endTimezone=n.endTimezone||"";if(!e){var d='<div data-role="view" class="k-popup-edit-form k-scheduler-edit-form">'+'<div data-role="header" class="k-header">'+'<a href="\\#" class="k-header-cancel k-scheduler-cancel k-link" title="'+o.cancel+'"'+'aria-label="'+o.cancel+'"><span class="k-icon k-i-arrow-chevron-left"></span></a>'+o.editor.timezoneTitle+'<a href="\\#" class="k-header-done k-scheduler-update k-link" title="'+o.save+'" '+'aria-label="'+o.save+'"><span class="k-icon k-i-check"></span></a>'+'</div><div data-role="content"></div>';this.timezoneView=e=r.append(d);e.contentElement.append(t.show());e.element.on(b+k,".k-scheduler-cancel, .k-scheduler-update",function(e){e.preventDefault();e.stopPropagation();if(w(this).hasClass("k-scheduler-cancel"))a._revertTimezones(n);var t=a._editPane;var i=ve(n,o.editor.noTimezone);t.content.find(".k-timezone-label").text(i);r.navigate(t,a.options.animations.right)});i.bind(_,function(e){s.toggle(e.checked);n.set("endTimezone","")});n.bind(_,l)}i.value(!!n.endTimezone);i.enable(!!n.startTimezone);if(n.endTimezone)s.show();else s.hide();r.navigate(e,a.options.animations.left)},showDialog:function(e){var t=e.buttons.map(function(e){return{text:e.text,action:e.click}});t.push({text:this.options.messages.cancel,primary:true});w("<div />").appendTo(document.body).kendoDialog({close:function(){this.destroy()},modal:{preventScroll:true},closable:false,title:false,content:e.text,actions:t})},editEvent:function(n){var a=this.pane;var e="";var t=this.options.messages;var i=t.save;var r=t.destroy;var o=t.cancel;var c=t.editor.editorTitle;var u=t.resetSeries;e+='<div data-role="view" class="k-popup-edit-form k-scheduler-edit-form"'+y.attr("uid")+'="'+n.uid+'">'+'<div data-role="header" class="k-header">'+'<a href="\\#" class="k-header-cancel k-scheduler-cancel k-link" title="'+o+'"'+'aria-label="'+o+'"><span class="k-icon k-i-arrow-chevron-left"></span></a>'+c+'<a href="\\#" class="k-header-done k-scheduler-update k-link" title="'+i+'" '+'aria-label="'+i+'"><span class="k-icon k-i-check"></span></a>'+"</div>";var f=this.fields(We.mobile,n);var s=this;var v=[];e+=this._buildEditTemplate(n,f,v,true);e+="</div>";var l=a.append(e);if(!n.isNew()&&this.options.editable&&this.options.editable.destroy!==false&&n.isRecurrenceHead()&&n.recurrenceException){var p='<ul class="k-edit-buttons k-listgroup k-listgroup-flush"><li class="k-item k-listgroup-item"><span class="k-scheduler-resetSeries k-link k-label" aria-label="'+u+'">'+u+"</span></li></ul>";l.contentElement.append(p)}if(!n.isNew()&&this.options.editable&&this.options.editable.destroy!==false){var h='<ul class="k-edit-buttons k-listgroup k-listgroup-flush"><li class="k-item k-listgroup-item"><span class="k-scheduler-delete k-link k-label" aria-label="'+r+'">'+r+"</span></li></ul>";l.contentElement.append(h)}this._editPane=l;var d=this.container=l.element;this.editable=d.kendoEditable({fields:v,model:n,clearContainer:false,target:s.options.target,validateOnBlur:true}).data("kendoEditable");if(!this.trigger("edit",{container:d,model:n})){d.on(b+k,"a.k-scheduler-edit, a.k-scheduler-cancel, a.k-scheduler-update, span.k-scheduler-delete, span.k-scheduler-resetSeries",function(e){e.preventDefault();e.stopPropagation();var t=w(this);if(!t.hasClass("k-scheduler-edit")){var i="cancel";if(t.hasClass("k-scheduler-update"))i="save";else if(t.hasClass("k-scheduler-delete"))i="remove";else if(t.hasClass("k-scheduler-resetSeries"))i=O;s.trigger(i,{container:d,model:n})}else a.navigate(this._editPane,s.options.animations.right)});a.navigate(l,s.options.animations.left);n.bind(_,s.toggleDateValidationHandler)}else this.trigger("cancel",{container:d,model:n});return this.editable},_views:function(){return this.pane.element.find(y.roleSelector("view")).not(this.view.element)},close:function(){if(this.container){this.pane.navigate("",this.options.animations.right);var e=this._views();var t;for(var i=0,n=e.length;i<n;i++){t=e.eq(i).data("kendoView");if(t)t.purge()}e.remove();this.container=null;if(this.editable){this.editable.options.model.unbind(_,this.toggleDateValidationHandler);this.editable.destroy();this.editable=null}this.timezoneView=null}}}),Ke=Le.extend({destroy:function(){this.close();this.unbind()},editEvent:function(t){var i=this;var e=i.options.editable;var n="<div "+y.attr("uid")+'="'+t.uid+'" class="k-popup-edit-form k-scheduler-edit-form"><div class="k-edit-form-container">';var a=i.options.messages;var c=a.save;var u=a.cancel;var f=a.destroy;var v=a.resetSeries;var p=this.fields(We.desktop,t);var r=[];var o;n+=this._buildEditTemplate(t,p,r,false);var s;var h=m(e)?e.window:{};n+='<div class="k-edit-buttons">';n+=this.createButton({name:"update",text:c,attr:s})+this.createButton({name:"canceledit",text:u,attr:s});if(!t.isNew()&&e.destroy!==false&&t.isRecurrenceHead()&&t.recurrenceException)n+=this.createButton({name:"resetSeries",text:v,attr:s});if((!t.isNew()||t.isRecurring())&&e.destroy!==false)n+=this.createButton({name:"delete",text:f,attr:s});n+="</div></div></div>";var l=this.container=w(n).appendTo(i.element).eq(0).kendoWindow(g({modal:true,resizable:false,draggable:true,title:a.editor.editorTitle,visible:false,close:function(e){if(e.userTriggered)if(i.trigger(P,{container:l,model:t}))e.preventDefault()}},h));i.editable=l.kendoEditable({fields:r,model:t,clearContainer:false,validateOnBlur:true,target:i.options.target}).data("kendoEditable");for(var d in r){if(r[d].field!=="recurrenceRule"){o=r[d].field;l.find("[name='"+o+"']").attr("aria-labelledby",o+"_label")}if(r[d].field==="isAllDay")l.find("label[for='"+o+"']").attr("id",o+"_label")}if(!i.trigger(M,{container:l,model:t})){l.data("kendoWindow").center().open();l.on(b+k,"button.k-scheduler-cancel",function(e){e.preventDefault();e.stopPropagation();i.trigger(P,{container:l,model:t})});l.on(b+k,"button.k-scheduler-update",function(e){e.preventDefault();e.stopPropagation();i.trigger("save",{container:l,model:t})});l.on(b+k,"button.k-scheduler-delete",function(e){e.preventDefault();e.stopPropagation();i.trigger(F,{container:l,model:t})});l.on(b+k,"button.k-scheduler-resetSeries",function(e){e.preventDefault();e.stopPropagation();i.trigger(O,{container:l,model:t})});y.cycleForm(l);t.bind(_,i.toggleDateValidationHandler)}else i.trigger(P,{container:l,model:t});return i.editable},close:function(){var e=this;var t=function(){if(e.editable){e.editable.options.model.unbind(_,e.toggleDateValidationHandler);e.editable.destroy();e.editable=null;e.container=null}if(e.popup){e.popup.destroy();e.popup=null}};if(e.editable){if(e._timezonePopup&&e._timezonePopup.data("kendoWindow")){e._timezonePopup.data("kendoWindow").destroy();e._timezonePopup=null}if(e.container.is(":visible"))e.container.data("kendoWindow").bind("deactivate",t).close();else t()}else t()},_createEndTimezoneButton:function(){var e=this.options.messages;var t="";t+='<div class="k-edit-buttons">';t+=this.createButton({name:"savetimezone",text:e.save})+this.createButton({name:"canceltimezone",text:e.cancel});t+="</div></div></div>";return t},showDialog:function(i){var e=y.format("<div class='k-popup-edit-form'><div class='k-edit-form-container'><p class='k-popup-message'>{0}</p>",i.text);e+='<div class="k-edit-buttons">';for(var t=0;t<i.buttons.length;t++)e+=this.createButton(i.buttons[t]);e+="</div></div></div>";var n=this.element;if(this.popup)this.popup.destroy();var a=this.popup=w(e).appendTo(n).eq(0).on(b,".k-button",function(e){e.preventDefault();a.close();var t=w(e.currentTarget).index();i.buttons[t].click()}).kendoWindow({modal:true,resizable:false,draggable:false,title:i.title,visible:false,close:function(){this.destroy();n.trigger("focus")}}).getKendoWindow();a.center().open()},_initTimezoneEditor:function(i,t){var n=this;var e=n.container.find(".k-scheduler-timezones");var a=e.find("input.k-timezone-toggle");var r=e.find(".k-form-field").last();var o=e.find(".k-scheduler-savetimezone");var c=e.find(".k-scheduler-canceltimezone");var s=n._timezonePopup;var l=function(e){if(e.field==="startTimezone"){var t=i.startTimezone;a.prop(H,!t);if(!t){r.hide();i.set("endTimezone","");a.prop("checked",false)}}};var d;n._startTimezone=i.startTimezone;n._endTimezone=i.endTimezone;if(!s){n._timezonePopup=s=e.kendoWindow({modal:true,resizable:false,draggable:true,title:n.options.messages.editor.timezoneEditorTitle,visible:false,close:function(e){i.unbind(_,l);if(e.userTriggered)n._revertTimezones(i);if(t)t.focus()}});a.on(b,function(){r.toggle(a.prop("checked"));i.set("endTimezone","")});o.on(b,function(e){e.preventDefault();d.close()});c.on(b,function(e){e.preventDefault();n._revertTimezones(i);d.close()});i.bind(_,l)}a.prop("checked",i.endTimezone).prop(H,!i.startTimezone);if(i.endTimezone)r.show();else r.hide();d=s.data("kendoWindow");d.center().open()}}),Ye=i.extend({init:function(e,t){var i=this;a.fn.init.call(i,e,t);if(!i.options.views||!i.options.views.length)i.options.views=["day","week"];i.resources=[];i._initModel();i._wrapper();i._views();i._toolbar();i._dataSource();i._resources();i._resizeHandler=function(){i.resize()};i.wrapper.on(D+k+" selectstart"+k,function(e){if(!w(e.target).is(":kendoFocusable"))e.preventDefault()});if(i.options.editable&&i.options.editable.resize!==false)i._resizable();i._movable();i._bindResize();if(i.options.messages&&i.options.messages.recurrence)o.options=i.options.messages.recurrence;if(i.options.selectable)i._tabindex();i._navigation();i._selectable();i._touchHandlers();i._ariaId=y.guid();i._createEditor()},_bindResize:function(){w(window).on("resize"+k,this._resizeHandler)},_unbindResize:function(){w(window).off("resize"+k,this._resizeHandler)},dataItems:function(){var e=this;var t=e.items();var i=e._data;var n=w.map(t,function(e){return w(e).attr("data-uid")});var a;var r;var o={};var s=n.length;for(a=0;a<s;a++)o[n[a]]=null;var c=i.length;for(a=0;a<c;a++){var l=i[a];if(o[l.uid]!==h)o[l.uid]=l}var d=[];for(r in o)d.push(o[r]);return d},_isMobile:function(){var e=this.options;return e.mobile===true&&y.support.mobileOS||e.mobile==="phone"||e.mobile==="tablet"},_isTouch:function(e){return/touch/.test(e.type)||e.originalEvent&&/touch/.test(e.originalEvent.pointerType)},_isInverseColor:function(e){return e.hasClass(W)},_groupsByResource:function(e,t,i,n,a){if(!i)i=[];var r=e[0];if(r){var o;var s=r.dataSource.view();var l=0;for(var d=0;d<s.length;d++){var c=y.getter(r.dataValueField)(s[d]);var u=t+l+d;o=this._groupsByResource(e.slice(1),u,i,c,r.field);o[r.field]=c;l=o.groupIndex;if(a&&n)o[a]=n;if(e.length===1){o.groupIndex=t+d;i.push(o)}}return o}else return{}},data:function(){return this._data},select:function(e){var t=this;var i=t.view();var n=t._selection;var a=i.groups;var r;if(e===h){var o;var c=i._selectedSlots;if(!n)return[];if(n&&n.events)o=t._selectedEvents();return{start:n.start,end:n.end,events:o,slots:c,resources:i._resourceBySlot(n)}}if(!e){t._selection=null;t._old=null;i.clearSelection();return}if(Array.isArray(e))e={events:e.splice(0)};if(e.resources){var s;var u=[];var f=[];if(i.groupedResources)t._groupsByResource(i.groupedResources,0,f);for(s in e.resources)u.push({field:s,operator:"eq",value:e.resources[s]});r=new y.data.Query(f).filter(u).toArray()}if(e.events&&e.events.length){t._selectEvents(e.events,r);t._select();return}if(a&&(e.start&&e.end)){var v=z(i._startDate);var p=y.date.addDays(z(i._endDate),1);var l;var d;if(e.start<p&&v<=e.end){if(r&&r.length)l=a[r[0].groupIndex];else l=a[0];if(!l.timeSlotCollectionCount())e.isAllDay=true;d=l.ranges(e.start,e.end,e.isAllDay,false);if(d.length){t._selection={start:y.timezone.toLocalDate(d[0].start.start),end:y.timezone.toLocalDate(d[d.length-1].end.end),groupIndex:d[0].start.groupIndex,index:d[0].start.index,isAllDay:d[0].start.isDaySlot,events:[]};t._select()}}}},_selectEvents:function(e,t){var i=this;var n;var a=i.view();var r=a.groups;var c=e.length;var u=t&&t.length;var f=i._ctrlKey;i._ctrlKey=true;for(n=0;n<c;n++)if(r&&u){var o=r[t[0].groupIndex];var s=[];var v=o.timeSlotCollectionCount();var p=o.daySlotCollectionCount();for(var l=0;l<v;l++)s=s.concat(o.getTimeSlotCollection(l).events());for(var d=0;d<p;d++)s=s.concat(o.getDaySlotCollection(d).events());s=new y.data.Query(s).filter({field:"element[0].getAttribute('data-uid')",operator:"eq",value:e[n]}).toArray();if(s[0])i._createSelection(s[0].element)}else{var h=a.element.find(y.format(".k-event[data-uid={0}], .k-task[data-uid={0}]",e[n]));if(h.length)i._createSelection(h[0])}i._ctrlKey=f},_touchHandlers:function(){var a=this;var r;var o;var s;var l;var d;var c=a.wrapper;var u=a._touchMove.bind(a);c.on(S+k,".k-scheduler-header-all-day td, .k-scheduler-content td, .k-event",function(e){var t=a.wrapper.find(".k-scheduler-content");if(!a._isTouch(e))return;t.stop(true,false);a._touchPosX=r=a._tapPosition(e,"X");a._touchPosY=o=a._tapPosition(e,"Y");a._userTouched=true;a.view()._scrolling=false;d=Date.now();c.on(x+k,".k-scheduler-header-all-day td, .k-scheduler-content td, .k-event",u)});c.on("contextmenu"+k,".k-scheduler-header-all-day td, .k-scheduler-content td, .k-event",function(e){a._preventFocus=true});c.on(E+k,".k-scheduler-header-all-day td, .k-scheduler-content td, .k-event",function(e){if(!a._isTouch(e))return;var t=Date.now()-d;var i=a.wrapper.find(".k-scheduler-content");var n=-a._amplitude*(3e3/t);s=a._tapPosition(e,"X");l=a._tapPosition(e,"Y");if(a._dragging)return;if(a.options.selectable&&(Math.abs(s-r)<=10||Math.abs(l-o)<=10))a._mouseDownSelection(e);if(!y.support.kineticScrollNeeded&&t<200&&Math.abs(s-r)>10)i.animate({scrollTop:i[0].scrollTop+n});c.off(x+k,".k-scheduler-header-all-day td, .k-scheduler-content td",u)})},_navigation:function(){var t=this,i=t.wrapper;i.on("focus"+k,function(){var e=t._selection;setTimeout(function(){if(!t._preventFocus){if((!e||e.events.length>0&&i.find("[data-uid='"+e.events[0]+"']").length===0)&&!t._userTouched&&!t._mouseDown)t._initialFocus();else t._mouseDown=false;t._select()}else t._preventFocus=false},300)});i.on("focusout"+k,function(){t._ctrlKey=t._shiftKey=false});i.on("keydown"+k,t._keydown.bind(t));i.on("keyup"+k,function(e){t._ctrlKey=e.ctrlKey;t._shiftKey=e.shiftKey})},_selectable:function(){var a=this;var r=a.wrapper;if(!a.options.selectable)return;r.on(D+k,".k-scheduler-header-all-day td, .k-scheduler-content td, .k-event, .k-scheduler-body td .k-link",function(e){if(a._isTouch(e))return;a._mouseDownSelection(e)});var o=a._mouseMove.bind(a);r.on(D+k,".k-scheduler-header-all-day td, .k-scheduler-content td",function(e){var t=e.which;var i=e.button;var n=t&&t===3||i&&i==2;if(a._isTouch(e))return;if(!n)r.on(C+k,".k-scheduler-header-all-day td, .k-scheduler-content td",o)});r.on("mouseup"+k+" mousecancel"+k,function(){r.off(C+k,".k-scheduler-header-all-day td, .k-scheduler-content td",o)})},_mouseDownSelection:function(e){var t=e.which;var i=e.button;var n=t&&t===3||i&&i==2;if(!n){if(e.ctrlKey)this._ctrlKey=e.ctrlKey;if(e.shiftKey)this._shiftKey=e.shiftKey;this._mouseDown=true;this._createSelection(e.currentTarget);if(w(e.currentTarget).hasClass("k-event"))this._selection.eventElement=e.currentTarget}if(y._activeElement()!==this.wrapper.get(0))y.focusElement(this.wrapper);else this._select();if(this.toolbar)this.toolbar.find("."+c).removeClass(c)},_selectFirstSlot:function(){var e=this.wrapper.find(".k-scheduler-header-all-day").find("td").first(),t=this.wrapper.find(".k-scheduler-content").find("td").first(),i;if(e.length>0)i=e;else if(t.length>0)i=t;else i=this.wrapper.find(".k-scheduler-body").find(".k-link").first();this._createSelection(i)},_firstEvent:function(){var e=this.wrapper.find(".k-scheduler-header-wrap .k-event, .k-task").first(),t=this.wrapper.find(".k-scheduler-content .k-event").first(),i,n,a;if(e.length>0)if(t.length>0){n=this.occurrenceByUid(e.data("uid"));a=this.occurrenceByUid(t.data("uid"));i=n.start<=a.start?e:t}else i=e;else if(t)i=t;return i},_initialFocus:function(){var e=this._firstEvent(),t=this.view();if(t.name==="year")if(!t._preventCalendarFocus){t.calendar.element.find(".k-calendar-view").attr("tabindex",0);t.calendar.focus()}else t._preventCalendarFocus=false;else if(this.options.selectable)if(e&&e.length>0){this._createSelection(e);this._selection.eventElement=e[0]}else this._selectFirstSlot();else if(this.toolbar&&this.toolbar.find("."+c).length===0)this._focusToolbar();else if(this.toolbar)this.toolbar.find("."+c).removeClass(c)},_select:function(){var e=this;var t=e.view();var i=e.wrapper;var n=t.current();var a=e._selection;var r=e._old?e._old.selection:null;var o=e._old?e._old.eventsLength:null;if(!a)return;if(n){n.removeAttribute("id");i.removeAttr("aria-activedescendant")}t.select(a);e._selection.eventElement=null;n=t.current();if(n){n.setAttribute("id",e._ariaId);i.attr("aria-activedescendant",e._ariaId);if(r!==n||a.events&&o!==a.events.length){var s=w(n).data("uid");if(e._old&&s&&s===w(e._old.selection).data("uid")&&(a.events&&e._old.eventsLength===a.events.length))return;var l=e._selectedEvents();var d=t._selectedSlots;e._old={selection:n,eventsLength:l.length};e.trigger(_,{start:a.start,end:a.end,events:l,slots:d,resources:t._resourceBySlot(a)})}}},_selectedEvents:function(){var e=this._selection.events;var t=e.length;var i=0;var n;var a=[];for(;i<t;i++){n=this.occurrenceByUid(e[i]);if(n)a.push(n)}return a},_tapPosition:function(e,t){return/touch/.test(e.type)?(e.originalEvent||e).changedTouches[0]["page"+t]:e["page"+t]},_touchMove:function(e){var t=this;var i=t.wrapper.find(".k-scheduler-content");var n=i[0].scrollHeight>i[0].clientHeight;var a=i[0].scrollWidth>i[0].clientWidth;var r=t._tapPosition(e,"Y");var o=t._tapPosition(e,"X");var s=i[0].scrollTop-Math.round(r-t._touchPosY);var l=i[0].scrollLeft-Math.round(o-t._touchPosX);var d=n&&Math.abs(r-t._touchPosY)>10;var c=a&&Math.abs(r-t._touchPosY)>10;if(t._dragging||y.support.kineticScrollNeeded||!t._isTouch(e))return;if(d||c){t._amplitude=Math.round(r-t._touchPosY);t._touchPosY=r;t._touchPosX=o;i.animate({scrollTop:s,scrollLeft:l},0);t.view()._scrolling=true}},_mouseMove:function(r){var o=this;clearTimeout(o._moveTimer);if(o._isTouch(r))return;o._moveTimer=setTimeout(function(){var e=o.view();var t=o._selection;if(t){var i=e.selectionByElement(w(r.currentTarget));if(i&&t.groupIndex===i.groupIndex){var n=i.startDate();var a=i.endDate();if(n>=t.end)t.backward=false;else if(a<=t.start)t.backward=true;if(t.backward)t.start=n;else t.end=a;o._select()}}},5)},_viewByIndex:function(e){var t,i=this.views;for(t in i){if(!e)return t;e--}},_keydownToolbar:function(e){var t=e.keyCode,i="> .k-button,"+".k-scheduler-navigation > .k-button,"+".k-nav-current,"+".k-views-dropdown:visible,"+".k-scheduler-views:visible > .k-button,"+".k-scheduler-search-input,"+".k-scheduler-mobile-views,"+".k-button-group > .k-button",n=this.toolbar.find(i),a=w(e.target).closest(N).length||this.toolbar.find(".k-scheduler-views .k-focus").length,r=y.support.isRtl(this.element),o=this.toolbar.find("."+c+", :focus"),s=n.index(o),l;if(t===u.TAB&&(!e.shiftKey||this.options.selectable))this.toolbar.find("."+c).removeClass(c);else if(e.altKey&&t===u.DOWN&&this.toolbar.find(".k-nav-current").hasClass(c)){this._showCalendar();e.preventDefault();return}else if(t===u.RIGHT||t===u.LEFT){if(t===u.RIGHT&&!r||t===u.LEFT&&r){s=s+1;if(s===n.length){this.toolbar.find("."+c).removeClass(c);this.element.focus();return}}else if(t===u.LEFT&&!r||t===u.RIGHT&&r){s=s-1;if(s<0)return}l=n[s];this.toolbar.find("."+c).removeClass(c);w(l).addClass(c).attr("tabindex",0).focus().attr("tabindex",-1);this._focusedView=null;e.preventDefault();return}else if(t===u.ENTER||t===u.SPACEBAR){if(a&&this._focusedView&&!this._focusedView.hasClass("k-selected")){var d=this._focusedView.data().name;if(!this.trigger("navigate",{view:d,action:"changeView",date:this.date()}))this.view(d);e.preventDefault();return}this.toolbar.find("."+c+":visible").click();e.preventDefault();return}else if(t===u.DOWN&&!this.wrapper.find(".k-views-dropdown").hasClass("k-focus")){this.toolbar.find("."+c).removeClass(c);if(this._selectedViewName==="year"){this.view().calendar.element.find(".k-calendar-view").attr("tabindex",0);this.view().calendar.focus()}else if(document.activeElement!==this.element[0])this.element.focus();e.preventDefault();return}},_keydownView:function(e){var t=e.keyCode,i=t===16||t===18||t===17||t===91||t===92,n=this._selection,a=this.view(),r=a.options.editable,c=[u.LEFT,u.RIGHT,u.UP,u.DOWN],o=y.support.isRtl(this.element),s,l,d;if(i)return;if(!n)return;if(t===u.ENTER){if(n.events.length&&r)if(r.update!==false)this.editEvent(n.events[0])}else if((t===u.DELETE||t===u.BACKSPACE)&&r!==false&&r.destroy!==false)this.removeEvent(n.events[0]);else if(c.indexOf(t)>-1){s=t===u.UP||t===u.LEFT&&!o||t===u.RIGHT&&o;if(a.moveToEvent(n,s)){this._select();if(document.activeElement!==this.element[0])this.element.focus();e.preventDefault()}}else if(t===u.HOME||t===u.END){e.preventDefault();l=this.view().content.eq(0);if(t===u.HOME)d=l.find(".k-scheduler-table td").first();else d=l.find(".k-scheduler-table td").last();this.view()._scrollTo(d[0],l[0])}},_keydownShortcut:function(e){var t=new Date,i=this.options.timezone,n=this.view().options.editable;if(e===66&&!!this.view().toggleFullDay)this.view().toggleFullDay();else if(e===67&&n&&n.create!==false)this.addEvent(g({},{start:this.date(),end:this.date()}));else if(e===84){if(i){var a=y.timezone.offset(t,i);r=y.timezone.convert(t,t.getTimezoneOffset(),a)}else r=t;if(!this.trigger("navigate",{view:this._selectedViewName,action:"today",date:r}))this.date(r)}},_keydownYearView:function(e){var t=this.view(),i=this._selection,n=e.keyCode;if(n===u.TAB)return;if(n===u.F10){t.calendar.element.find(".k-calendar-view").removeAttr("tabindex");this._focusToolbar();e.preventDefault()}else{this.toolbar.find("."+c).removeClass(c);t.calendar.element.find(".k-calendar-view").attr("tabindex",0);t.calendar.focus()}if(i)this._adjustSelectedDate();e.preventDefault()},_keydownAgendaView:function(e){var t=e.keyCode,i=this.view(),n=this._selection,a,r;if(i.move(n,t)){e.preventDefault();this.toolbar.find("."+c).removeClass(c);this._select()}else if(t===u.HOME||t===u.END){e.preventDefault();a=this.view().content.eq(0);if(t===u.HOME)r=a.find(".k-scheduler-table td").first();else r=a.find(".k-scheduler-table td").last();this.view()._scrollTo(r[0],a[0])}},_keydownChangeView:function(e){var t=e-49,i;if(t===-1)t=9;i=this._viewByIndex(t);if(i&&!this.trigger("navigate",{view:i,action:"changeView",date:this.date()}))this.view(i)},_keydownChangeDate:function(e){var t=y.support.isRtl(this.element),i=t&&e===u.LEFT||!t&&e===u.RIGHT?"next":"previous";if(i==="next")r=this.view().nextDate();else r=this.view().previousDate();if(!this.trigger("navigate",{view:this._selectedViewName,action:i,date:r})){this.date(r);this._initialFocus();this._select()}},_keydown:function(e){var t=e.keyCode,i=[66,67,84],n=w(e.target).closest(".k-toolbar").length>0,a=e.altKey;this._ctrlKey=e.ctrlKey;this._shiftKey=e.shiftKey;if(t===u.ESC&&this.popup&&this.popup.visible()){this.popup.close();e.preventDefault();return}if((t===u.LEFT||t===u.RIGHT)&&this._shiftKey){this._keydownChangeDate(t);return}if(a&&t>=48&&t<=57){this._keydownChangeView(t);return}if(i.indexOf(t)>-1){this._keydownShortcut(t);return}if(n)this._keydownToolbar(e);else{if(this._selectedViewName==="year"){this._keydownYearView(e);return}if(t===u.F10){this._focusToolbar();e.preventDefault();return}if(this._selectedViewName==="agenda"){this._keydownAgendaView(e);return}this._keydownView(e)}},_focusToolbar:function(){this.toolbar.find(".k-button").first().trigger("focus").addClass(c)},_createSelection:function(e){var t=this._selection,i,n;e=w(e);if(e.is(".k-event")){i=e.attr(y.attr("uid"));if(t&&t.events.indexOf(i)!==-1&&!this._ctrlKey)return}if(!t||!this._ctrlKey&&!this._shiftKey)t=this._selection={events:[],groupIndex:0};n=this.view().selectionByElement(e);if(n)t.groupIndex=n.groupIndex||0;if(i)n=_e(this._data,i);if(n&&n.uid)i=[n.uid];this._updateSelection(n,i);this._adjustSelectedDate()},_updateSelection:function(e,t,i){var n=this._selection;if(e&&n){var a=this.view();if(e.uid)e=a._updateEventForSelection(e);if(this._shiftKey&&n.start&&n.end){var r=e.end<n.end;n.end=e.endDate?e.endDate():e.end;if(r&&a._timeSlotInterval)y.date.setTime(n.end,-a._timeSlotInterval())}else{n.start=e.startDate?e.startDate():e.start;n.end=e.endDate?e.endDate():e.end}if("isDaySlot"in e)n.isAllDay=e.isDaySlot;else n.isAllDay=e.isAllDay;if(i!==null&&i!==h)n.groupIndex=i;n.index=e.index;if(this._ctrlKey){var o=t&&t.length?n.events.indexOf(t[0]):-1;if(o>-1)n.events.splice(o,1);else n.events=n.events.concat(t||[])}else n.events=t||[]}},options:{name:"Scheduler",date:U,editable:true,autoBind:true,snap:true,mobile:false,timezone:"",allDaySlot:true,min:new Date(1900,0,1),max:new Date(2099,11,31),toolbar:null,workWeekStart:1,workWeekEnd:5,workDays:null,showWorkHours:false,startTime:U,endTime:U,currentTimeMarker:{updateInterval:1e4,useLocalTimezone:true},footer:{},messages:{today:"Today",pdf:"Export to PDF",save:"Save",cancel:"Cancel",destroy:"Delete",resetSeries:"Reset Series",deleteWindowTitle:"Delete event",next:"Next",previous:"Previous",refresh:"Refresh",selectView:"Select view",ariaSlotLabel:"Selected from {0:t} to {1:t}",ariaEventLabel:{on:"on",at:"at",to:"to",allDay:"(all day)",prefix:""},search:"Search...",views:{day:"Day",week:"Week",workWeek:"Work Week",agenda:"Agenda",month:"Month",timeline:"Timeline",timelineWeek:"Timeline Week",timelineWorkWeek:"Timeline Work Week",timelineMonth:"Timeline Month",year:"Year"},recurrenceMessages:{deleteWindowTitle:"Delete Recurring Item",resetSeriesWindowTitle:"Reset Series",deleteWindowOccurrence:"Delete current occurrence",deleteWindowSeries:"Delete the series",editWindowTitle:"Edit Recurring Item",editWindowOccurrence:"Edit current occurrence",editWindowSeries:"Edit the series"},editable:{confirmation:$},editor:{title:"Title",start:"Start",end:"End",allDayEvent:"All day event",description:"Description",repeat:"Repeat",timezone:"Timezone",startTimezone:"Start timezone",endTimezone:"End timezone",separateTimezones:"Use separate start and end time zones",timezoneEditorTitle:"Timezones",timezoneEditorButton:"Time zone",timezoneTitle:"Time zones",noTimezone:"No timezone",editorTitle:"Event"}},height:null,width:null,resources:[],group:{resources:[],orientation:"horizontal"},views:[],selectable:false},events:[F,M,P,A,"add","dataBinding","dataBound","moveStart","move","moveEnd","resizeStart","resize","resizeEnd","navigate",_],destroy:function(){var e=this,t;a.fn.destroy.call(e);if(e.dataSource){e.dataSource.unbind(_,e._refreshHandler);e.dataSource.unbind(R,e._progressHandler);e.dataSource.unbind(V,e._errorHandler)}if(e._resourceRefreshHandler)for(var i=0;i<e.resources.length;i++){var n=e.resources[i].dataSource;n.unbind(_,e._resourceRefreshHandler);n.unbind(R,e._resourceProgressHandler);n.unbind(V,e._resourceErrorHandler)}if(e.calendar){e.calendar.destroy();e.popup.destroy()}if(e.view())e.view().destroy();if(e._editor)e._editor.destroy();if(this._moveDraggable)this._moveDraggable.destroy();if(this._resizeDraggable)this._resizeDraggable.destroy();t=e.element.add(e.wrapper).add(e.toolbar).add(e.popup);t.off(k);clearTimeout(e._moveTimer);e._model=null;e.toolbar=null;e.element=null;w(window).off("resize"+k,e._resizeHandler);y.destroy(e.wrapper)},setDataSource:function(e){this.options.dataSource=e;this._dataSource();if(this.options.autoBind&&e.fetch)e.fetch();else if(T(e))this.view(this._selectedView)},items:function(){var e=this.wrapper.find(".k-scheduler-content");var t=this.view();if(t&&t.options.name==="agenda")return e.find(".k-task");else return e.find(".k-event").add(this.wrapper.find(".k-scheduler-header-wrap").find(".k-scheduler-header-all-day").siblings())},_movable:function(){var l;var u;var _;var f;var v;var p;var h;var m=this;var g;var d;var c;var e=0;var k=[];var b=[];var t=m._isMobile();var i=m.options.editable&&m.options.editable.move!==false;var n=m.options.editable&&m.options.editable.resize!==false;if(i||n&&t){m._dragging=false;if(t&&y.support.mobileOS.android)e=5;m._moveDraggable=new y.ui.Draggable(m.element,{distance:e,filter:".k-event",ignore:".k-resize-handle",holdToDrag:t,autoScroll:true});if(i)m._moveDraggable.bind("dragstart",function(e){var t=m.view();var i=e.currentTarget;var n=m._isTouch(e);m._dragging=true;if(!t.options.editable||t.options.editable.move===false){m._dragging=false;e.preventDefault();return}if(n&&!i.hasClass("k-event-active")){m._dragging=false;m.element.find(".k-event-active").removeClass("k-event-active");e.preventDefault();return}p=m.occurrenceByUid(i.attr(y.attr("uid")));h=p.clone();c=p.clone();h.update(t._eventOptionsForMove(h));h.inverseColor=m._isInverseColor(i);k=[];if(m._selection){var a=m._selection.events;for(var r=0;r<a.length;r++){var o=m.occurrenceByUid(a[r]).clone();var s=this.element.find('div.k-event[data-uid="'+o.uid+'"]').eq(0);o.update(t._eventOptionsForMove(o));if(s.length)o.inverseColor=m._isInverseColor(s);k.push(o)}}else k.push(h);l=t._slotByPosition(e.x.startLocation,e.y.startLocation);_=t._resourceBySlot(l);d=f=l.startOffset(e.x.startLocation,e.y.startLocation,m.options.snap);u=l;g=l;if(!l||m.trigger("moveStart",{event:p}))e.preventDefault()}).bind("drag",function(e){var t=m.view();var i=t._slotByPosition(e.x.location,e.y.location);var n;var a;var r;if(!i)return;v=i.startOffset(e.x.location,e.y.location,m.options.snap);if(i.isDaySlot!==l.isDaySlot)if(i.isDaySlot!==g.isDaySlot){var o=w(l.element).index();var s=w(i.element).parent().children().eq(o);l=t._slotByPosition(s.offset().left,s.offset().top);f=l.startOffset(e.x.location,e.y.location,true);b=k.map(function(e){return e.clone()});for(r=0;r<k.length;r++)if(k[r].isAllDay!=i.isDaySlot){k[r].isAllDay=i.isDaySlot;k[r].end=y.date.getDate(k[r].start);k[r].start=y.date.getDate(k[r].start);if(!i.isDaySlot){y.date.setTime(k[r].start,y.date.getMilliseconds(t.startTime()));y.date.setTime(k[r].end,y.date.getMilliseconds(t.startTime())+t._timeSlotInterval())}}}else{l=w.extend(true,{},g);f=d;k=b}n=v-f;for(r=0;r<k.length;r++)t._updateMoveHint(k[r],i.groupIndex,n);a=Ne(h,n);if(!m.trigger("move",{event:p,slot:{element:i.element,start:i.startDate(),end:i.endDate(),isDaySlot:i.isDaySlot},resources:t._resourceBySlot(i),start:a.start,end:a.end}))u=i;else for(r=0;r<k.length;r++)t._updateMoveHint(k[r],i.groupIndex,n)}).bind("dragend",function(e){m.view()._removeMoveHint();var t=v-f;var i=Ne(h,t);var n=i.start;var a=i.end;m._dragging=false;var r=m.view()._resourceBySlot(u);var o=m.trigger("moveEnd",{event:p,slot:{element:u.element,start:u.startDate(),end:u.endDate()},start:n,end:a,resources:r});if(!o&&(p.start.getTime()!==n.getTime()||p.end.getTime()!==a.getTime()||g.isDaySlot!==u.isDaySlot||y.stringify(r)!==y.stringify(_))){m._isMultiDrag=k.length>1;for(var s=0;s<k.length;s++){var l=k[s];i=Ne(l,t);var d=m.view()._eventOptionsForMove(l);var c=w.extend({isAllDay:l.isAllDay,start:i.start,end:i.end},d,r);m._updateEvent(null,l,c)}if(m._isMultiDrag){m.dataSource.sync();m._isMultiDrag=false}}e.currentTarget.removeClass("k-event-active");this.cancelHold();k=[];b=[]}).bind("dragcancel",function(){m.view()._removeMoveHint();this.cancelHold();k=[];b=[]});m._moveDraggable.bind("hold",function(e){if(m._isTouch(e)){m.element.find(".k-event-active").removeClass("k-event-active");if(m.options.selectable)m._createSelection(e.currentTarget);e.currentTarget.addClass("k-event-active")}})}},_resizable:function(){var s;var l;var d;var c;var u;var f=this;var e=0;function v(e){var t={"k-resize-e":"east","k-resize-w":"west","k-resize-n":"north","k-resize-s":"south"};for(var i in t)if(e.hasClass(i))return t[i]}if(f._isMobile()&&y.support.mobileOS.android)e=5;f._resizeDraggable=new y.ui.Draggable(f.element,{distance:e,filter:".k-resize-handle",autoScroll:true,dragstart:function(e){var t=w(e.currentTarget);var i=t.closest(".k-event");var n=i.attr(y.attr("uid"));var a=f.view();f._dragging=true;d=f.occurrenceByUid(n);c=d.clone();a._updateEventForResize(c);u=a._slotByPosition(e.x.startLocation,e.y.startLocation);if(f.trigger("resizeStart",{event:d}))e.preventDefault();s=y.date.toUtcTime(c.start);l=y.date.toUtcTime(c.end)},drag:function(e){if(!u)return;var t=w(e.currentTarget);var i=v(t);var n=f.view();var a=n._slotByPosition(e.x.location,e.y.location);if(!a||u.groupIndex!=a.groupIndex)return;u=a;var r=s;var o=l;if(i=="south"){if(!u.isDaySlot&&u.end-y.date.toUtcTime(c.start)>=n._timeSlotInterval())if(c.isAllDay)l=u.startOffset(e.x.location,e.y.location,f.options.snap);else l=u.endOffset(e.x.location,e.y.location,f.options.snap)}else if(i=="north"){if(!u.isDaySlot&&y.date.toUtcTime(c.end)-u.start>=n._timeSlotInterval())s=u.startOffset(e.x.location,e.y.location,f.options.snap)}else if(i=="east"){if(u.isDaySlot&&y.date.toUtcTime(y.date.getDate(u.endDate()))>=y.date.toUtcTime(y.date.getDate(c.start)))if(c.isAllDay)l=u.startOffset(e.x.location,e.y.location,f.options.snap);else l=u.endOffset(e.x.location,e.y.location,f.options.snap);else if(!u.isDaySlot&&u.end-y.date.toUtcTime(c.start)>=n._timeSlotInterval())l=u.endOffset(e.x.location,e.y.location,f.options.snap)}else if(i=="west")if(u.isDaySlot&&y.date.toUtcTime(y.date.getDate(c.end))>=y.date.toUtcTime(y.date.getDate(u.startDate())))s=u.startOffset(e.x.location,e.y.location,f.options.snap);else if(!u.isDaySlot&&y.date.toUtcTime(c.end)-u.start>=n._timeSlotInterval())s=u.startOffset(e.x.location,e.y.location,f.options.snap);if(!f.trigger("resize",{event:d,slot:{element:u.element,start:u.startDate(),end:u.endDate()},start:y.timezone.toLocalDate(s),end:y.timezone.toLocalDate(l),resources:n._resourceBySlot(u)}))n._updateResizeHint(c,u.groupIndex,s,l);else{s=r;l=o}},dragend:function(e){var t=w(e.currentTarget);var i=new Date(c.start.getTime());var n=new Date(c.end.getTime());var a=v(t);f._dragging=false;f.view()._removeResizeHint();if(a=="south")n=y.timezone.toLocalDate(l);else if(a=="north")i=y.timezone.toLocalDate(s);else if(a=="east")if(u.isDaySlot)n=y.date.getDate(y.timezone.toLocalDate(l));else n=y.timezone.toLocalDate(l);else if(a=="west")if(u.isDaySlot){i=new Date(y.timezone.toLocalDate(s));i.setHours(0);i.setMinutes(0)}else i=y.timezone.toLocalDate(s);var r=f.trigger("resizeEnd",{event:d,slot:{element:u.element,start:u.startDate(),end:u.endDate()},start:i,end:n,resources:f.view()._resourceBySlot(u)});if(!r&&n.getTime()>=i.getTime())if(c.start.getTime()!=i.getTime()||c.end.getTime()!=n.getTime()){f.view()._updateEventForResize(d);f._updateEvent(a,d,{start:i,end:n})}u=null;d=null},dragcancel:function(){f._dragging=false;f.view()._removeResizeHint();u=null;d=null}})},_updateEvent:function(n,a,r){var o=this;var s=function(e,t){var i;try{o._preventRefresh=true;e.update(r);o._convertDates(e);i=e.start;if(n&&e.duration()%d===0&&i.getHours()===0&&i.getMinutes()===0&&i.getSeconds()===0&&i.getMilliseconds()===0)e.set("isAllDay",true)}finally{o._preventRefresh=false}if(!o.trigger(A,{event:e})){if(t)t();if(!o._isMultiDrag)o.dataSource.sync()}};var l=function(e){if(e.recurrenceRule)return o.dataSource.getByUid(e.uid);else return o.dataSource.get(e.recurrenceId)};var e=function(){var e=l(a);if(n=="south"||n=="north"){if(r.start){var t=y.date.getDate(e.start);y.date.setTime(t,f(r.start));r.start=t}if(r.end){var i=y.date.getDate(e.end);y.date.setTime(i,f(r.end));r.end=i}}o.dataSource._removeExceptions(e);s(e)};var t=function(){var e=l(a);var t;var i=function(){o._convertDates(e);if(o._selection)o._selection.events.push(t)};var n=e.toOccurrence({start:a.start,end:a.end});t=n.uid;s(o.dataSource.add(n),i)};if(a.recurrenceRule||a.isOccurrence()){var i=o.options.messages.recurrenceMessages;o._showRecurringDialog(a,t,e,{title:i.editWindowTitle,text:i.editRecurring?i.editRecurring:j,occurrenceText:i.editWindowOccurrence,seriesText:i.editWindowSeries})}else s(o.dataSource.getByUid(a.uid))},_modelForContainer:function(e){e=w(e).closest("["+y.attr("uid")+"]");return this.dataSource.getByUid(e.attr(y.attr("uid")))},showDialog:function(e){this.toolbar.find("."+c).removeClass(c);this._editor.showDialog(e)},focus:function(){this.wrapper.trigger("focus")},_confirmation:function(e,t,i){var n=this.options.editable;if(n===true||n.confirmation!==false){var a=this.options.messages;var r=a.deleteWindowTitle;var o=typeof n.confirmation===v?n.confirmation:a.editable.confirmation;if(this._isEditorOpened()&&t.isRecurring()){var s=this.options.messages.recurrenceMessages;r=s.deleteWindowTitle;if(t.isException()||t.isNew())o=s.deleteRecurringConfirmation?s.deleteRecurringConfirmation:J;else o=s.deleteSeriesConfirmation?s.deleteSeriesConfirmation:X;if(i){r=s.resetSeriesWindowTitle;o=s.resetSeriesConfirmation?s.resetSeriesConfirmation:G}}var l=[{name:"destroy",text:i?a.resetSeries:a.destroy,click:function(){e()}}];if(!(this._isMobile()&&y.Pane))l.push({name:"canceledit",text:a.cancel,click:function(){e(true)}});this._unbindResize();this.showDialog({model:t,text:o,title:r,buttons:l});this._bindResize()}else e()},addEvent:function(e){var t=this._editor.editable;var i=this.dataSource;var n;e=e||{};var a=this.trigger("add",{event:e});if(!a&&(t&&t.end()||!t)){this.cancelEvent();if(e&&e.toJSON)e=e.toJSON();n=i.add(e);if(n){this.cancelEvent();this._editEvent(n)}}},saveEvent:function(){var e=this;var t=e._editor;var i=e.dataSource;if(!t)return;var n=t.editable;var a=t.container;var r=e._modelForContainer(a);var o,s,l;if(a&&n&&n.end()&&!e.trigger(A,{container:a,event:r})){if(!r.isOccurrence()&&!!r.recurrenceException&&!r.recurrenceRule){o=i.data();for(s=o.length-1;s>=0;s-=1){l=o[s];if(l&&l.recurrenceId===r.id)i.remove(l)}r.set("recurrenceException","")}if(!r.dirty&&!r.isOccurrence())e._convertDates(r,"remove");i.sync()}},cancelEvent:function(){var e=this._editor;var t=e.container;var i;if(t){i=this._modelForContainer(t);if(i&&i.isOccurrence()){this._convertDates(i,"remove");this._convertDates(this.dataSource.get(i.recurrenceId),"remove")}this.dataSource.cancelChanges(i);e.close()}},editEvent:function(e){var t=typeof e=="string"?this.occurrenceByUid(e):e;if(!t)return;this.cancelEvent();if(t.isRecurring())this._editRecurringDialog(t);else this._editEvent(t)},_editEvent:function(e){this._preventRefresh=true;this._unbindResize();this._createPopupEditor(e);this.toolbar.find("."+c).removeClass(c);this._bindResize()},_editRecurringDialog:function(e){var t=this;var i=function(){if(e.isException())t._editEvent(e);else t.addEvent(e)};var n=function(){if(e.recurrenceId)e=t.dataSource.get(e.recurrenceId);t._editEvent(e)};var a=t.options.messages.recurrenceMessages;t._showRecurringDialog(e,i,n,{title:a.editWindowTitle,text:a.editRecurring?a.editRecurring:j,occurrenceText:a.editWindowOccurrence,seriesText:a.editWindowSeries})},_showRecurringDialog:function(e,t,i,n){var a=this.options.editable;var r=m(a)?a.editRecurringMode:"dialog";if(r==="occurrence"||this._isMultiDrag)t();else if(r==="series")i();else{this._unbindResize();this.showDialog({model:e,title:n.title,text:n.text,buttons:[{text:n.occurrenceText,click:t},{text:n.seriesText,click:i}]});this._bindResize()}},_createButton:function(e){var t=e.template||Z,i=typeof e===v?e:e.name||e.text,n={className:"k-scheduler-"+(i||"").replace(/\s/g,""),text:i,attr:""};if(!i&&!(m(e)&&e.template))throw new Error("Custom commands should have name specified");if(m(e)){if(e.className)e.className+=" "+n.className;if(i==="edit"&&m(e.text)){e=g(true,{},e);e.text=e.text.edit}n=g(true,n,Ce[i],e)}else n=g(true,n,Ce[i]);if(!n.className)n.className="k-button-solid-base";else if(n.className.indexOf("k-button-solid-primary")===-1)n.className+=" k-button-solid-base";return y.template(t)(n)},_convertDates:function(e,t){var i=this.dataSource.reader.timezone;var n=e.startTimezone;var a=e.endTimezone;var r=e.start;var o=e.start;t=t||"apply";n=n||a;a=a||n;if(n){if(i)if(t==="apply"){r=y.timezone.convert(e.start,i,n);o=y.timezone.convert(e.end,i,a)}else{r=y.timezone.convert(e.start,n,i);o=y.timezone.convert(e.end,a,i)}else{r=y.timezone[t](e.start,n);o=y.timezone[t](e.end,a)}e._set("start",r);e._set("end",o)}},_createEditor:function(){var i=this;var e;if(this._isMobile()&&y.Pane)e=i._editor=new Ue(this.wrapper,g({},this.options,{target:this,timezone:i.dataSource.reader.timezone,resources:i.resources,createButton:this._createButton.bind(this)}));else e=i._editor=new Ke(this.wrapper,g({},this.options,{target:this,createButton:this._createButton.bind(this),timezone:i.dataSource.reader.timezone,resources:i.resources}));e.bind("cancel",function(e){if(i.trigger("cancel",{container:e.container,event:e.model})){e.preventDefault();return}i._preventRefresh=false;i.cancelEvent();if(i._attemptRefresh)i.refresh();i.focus()});e.bind("edit",function(e){if(i.trigger(M,{container:e.container,event:e.model}))e.preventDefault()});e.bind("save",function(){i._preventRefresh=false;i.saveEvent()});e.bind("remove",function(e){i._preventRefresh=false;i.removeEvent(e.model)});e.bind("resetSeries",function(t){i._confirmation(function(e){i._preventRefresh=false;if(!e){i.dataSource._removeExceptions(t.model);i.saveEvent()}},t.model,true)})},_createPopupEditor:function(e){var t=this._editor;if(!e.isNew()||e.isOccurrence()){if(e.isOccurrence())this._convertDates(e.recurrenceId?this.dataSource.get(e.recurrenceId):e);this._convertDates(e)}this.editable=t.editEvent(e)},removeEvent:function(e){var t=this,i=typeof e=="string"?t.occurrenceByUid(e):e;if(!i)return;if(i.isRecurring())t._deleteRecurringDialog(i);else t._confirmation(function(e){if(!e)t._removeEvent(i)},i)},occurrenceByUid:function(e){var t=this.dataSource.getByUid(e);if(!t)t=_e(this._data,e);return t},occurrencesInRange:function(e,t){return new y.data.Query(this._data).filter({logic:"or",filters:[{logic:"and",filters:[{field:"start",operator:"gte",value:e},{field:"end",operator:"gte",value:e},{field:"start",operator:"lt",value:t}]},{logic:"and",filters:[{field:"start",operator:"lte",value:e},{field:"end",operator:"gt",value:e}]}]}).toArray()},_removeEvent:function(e){if(!this.trigger(F,{event:e}))if(this.dataSource.remove(e))this.dataSource.sync()},_deleteRecurringDialog:function(e){var i=this;var n=e;var t=i.options.editable;var a;var r;var o;var s;var l;var c;var u=m(t)?t.editRecurringMode:"dialog";a=function(){var e=n.recurrenceId?n:n.toOccurrence();var t=i.dataSource.get(e.recurrenceId);i._convertDates(t);i._removeEvent(e)};r=function(){if(n.recurrenceId)n=i.dataSource.get(n.recurrenceId);i._removeEvent(n)};o=function(){i.dataSource.remove(n);i.dataSource.sync()};if(u!="dialog"||i._isEditorOpened()){s=function(){i._confirmation(function(e){if(!e)a()},n)};l=function(){i._confirmation(function(e){if(!e)r()},n)};c=function(){i._confirmation(function(e){if(!e)o()},n)}}var f=l||r;var v=s||a;var p=c||o;if(i._isEditorOpened())if(e.isException())v();else if(e.isNew())p();else f();else{var d=i.options.messages.recurrenceMessages;i._showRecurringDialog(e,v,f,{title:d.deleteWindowTitle,text:d.deleteRecurring?d.deleteRecurring:Q,occurrenceText:d.deleteWindowOccurrence,seriesText:d.deleteWindowSeries})}},_isEditorOpened:function(){return!!this._editor.container},_unbindView:function(e){var t=this;t.angular("cleanup",function(){return{elements:t.items()}});e.destroy()},_bindView:function(e){var n=this;if(n.options.editable){if(n._viewRemoveHandler)e.unbind(F,n._viewRemoveHandler);n._viewRemoveHandler=function(e){n.removeEvent(e.uid)};e.bind(F,n._viewRemoveHandler);if(n._viewAddHandler)e.unbind(I,n._viewAddHandler);n._viewAddHandler=function(e){n.addEvent(e.eventInfo)};e.bind(I,this._viewAddHandler);if(n._viewEditHandler)e.unbind(M,n._viewEditHandler);n._viewEditHandler=function(e){n.editEvent(e.uid)};e.bind(M,this._viewEditHandler)}if(n._viewNavigateHandler)e.unbind("navigate",n._viewNavigateHandler);n._viewNavigateHandler=function(e){if(e.action){if(!n.trigger("navigate",{view:e.view,isWorkDay:e.isWorkDay,action:e.action,date:e.date}))n.date(e.date)}else if(e.view){var t="isWorkDay"in e;var i=t?"changeWorkDay":"changeView";if(!n.trigger("navigate",{view:e.view,isWorkDay:e.isWorkDay,action:i,date:e.date})){if(t)n._workDayMode=e.isWorkDay;n._selectView(e.view);n.date(e.date)}}};e.bind("navigate",n._viewNavigateHandler);if(n._viewActivateHandler)e.unbind("activate",n._viewActivateHandler);n._viewActivateHandler=function(){var e=this;if(n._selection){e.constrainSelection(n._selection);if(w(document.activeElement).closest(".k-scheduler-toolbar").length===0)if(document.activeElement!==n.wrapper[0])n.element.focus();else n._select();n._adjustSelectedDate()}};e.bind("activate",n._viewActivateHandler)},_selectView:function(e){var t=this;if(e&&t.views[e]){if(t._selectedView)t._unbindView(t._selectedView);t._selectedView=t._renderView(e);t._selectedViewName=e;if(t._viewsCount>1&&!t._isMobile()){var i=t.toolbar.find(".k-views-dropdown");var n=t.toolbar.find(".k-scheduler-views > .k-button");if(t.toolbar.find(".k-views-dropdown").length===0){t.toolbar.find(".k-scheduler-views-wrapper").prepend(ee({views:t.views,view:e,ns:y.ns,label:t.options.messages.selectView}));i=t.toolbar.find(".k-views-dropdown")}i.val(e);n.removeClass("k-selected");n.filter(".k-view-"+e.replace(/\./g,"\\.").toLowerCase()).addClass("k-selected")}else{var a=t.toolbar.find(".k-scheduler-mobile-views");a.find("[value="+e.replace(/\./g,"\\.")+"]").prop("selected","selected")}}},view:function(e){var t=this;if(e){t._selectView(e);t.rebind();return}return t._selectedView},viewName:function(){return this.view().name},_renderView:function(e){var t=this._initializeView(e);this._bindView(t);if(y.support.mouseAndTouchPresent||y.support.pointers){t.content.css("-ms-touch-action","pinch-zoom");t.content.css("touch-action","pinch-zoom")}this._model.set("formattedDate",t.dateForTitle());this._model.set("formattedShortDate",t.shortDateForTitle());this._model.set("formattedMobileDate",t.mobileDateForTitle?t.mobileDateForTitle():t.shortDateForTitle());this._model.set("formattedYear",y.format("{0:yyyy}",t.startDate()));return t},resize:function(e){var t=this.getSize();var i=this._size;var n=this.view();if(!n||!n.groups)return;if(e||!i||t.width!==i.width||t.height!==i.height){this.refresh({action:"resize"});this._size=t}},_adjustSelectedDate:function(){var e=this._model.selectedDate,t=this._selection,i=t.start;if(i&&!y.date.isInDateRange(e,z(i),z(t.end)))e.setFullYear(i.getFullYear(),i.getMonth(),i.getDate())},_initializeView:function(e){var t=this.views[e];if(t){var i=m(t),n={},a=t.type;if(typeof a===v)a=y.getter(t.type)(window);if(i&&t.workDays&&t.workDays.length)n.workDays=t.workDays;if(a)t=new a(this.wrapper,Re(g(true,{},this.options,i?t:{},{resources:this.resources,date:this.date(),startTime:y.parseDate(t.startTime)||y.parseDate(this.options.startTime),endTime:y.parseDate(t.endTime)||y.parseDate(this.options.endTime),showWorkHours:this._workDayMode}),n));else throw new Error("There is no such view")}return t},_views:function(){var e=this.options.views;var t;var i;var n;var a;var r;var o;var s;var l;this.views={};this._viewsCount=0;for(s=0,l=e.length;s<l;s++){var d=false;t=e[s];a=m(t);if(a){o=r=t.type?t.type:t;if(typeof o!==v){r=t.name||t.title;d=true}}else o=r=t;i=qe[r];if(i&&!d){t.type=i.type;i.title=this.options.messages.views[r];if(i.type==="day")i.messages={allDay:this.options.messages.allDay};else if(i.type==="agenda")i.messages={event:this.options.messages.event,date:this.options.messages.date,time:this.options.messages.time}}t=g({title:r},i,a?t:{});if(r){this.views[r]=t;this._viewsCount++;if(!n||t.selected)n=r}}if(n)this._selectedViewName=n},rebind:function(){var t=this,e=t.resources,i=[];if(t._preventRebind){t._preventRebind=false;return}if(t.options.autoBind===false&&e&&e.length>0){e.forEach(function(e){if(e.dataSource.data().length===0){t._preventRebind=true;i.push(e.dataSource.fetch())}});w.when.apply(null,i).then(function(){t.dataSource.fetch();t._preventRebind=false})}else t.dataSource.fetch()},_dataSource:function(){var e=this,t=e.options,i=t.dataSource;i=T(i)?{data:i}:i;if(t.timezone&&!(i instanceof xe))i=g(true,i,{schema:{timezone:t.timezone}});else if(i instanceof xe)t.timezone=i.options.schema?i.options.schema.timezone:"";if(e.dataSource&&e._refreshHandler)e.dataSource.unbind(_,e._refreshHandler).unbind(R,e._progressHandler).unbind(V,e._errorHandler);else{e._refreshHandler=e.refresh.bind(e);e._progressHandler=e._requestStart.bind(e);e._errorHandler=e._error.bind(e)}e.dataSource=y.data.SchedulerDataSource.create(i).bind(_,e._refreshHandler).bind(R,e._progressHandler).bind(V,e._errorHandler);e.options.dataSource=e.dataSource},_error:function(){this._progress(false)},_requestStart:function(){this._progress(true)},_progress:function(e){var t=this.element.find(".k-scheduler-content");y.ui.progress(t,e)},_resources:function(){var e=this;var t=e.options.resources;var i=[];for(var n=0;n<t.length;n++){var a=t[n];var r=a.field;var o=a.name||r;var s=a.dataSource;if(!r||!s)throw new Error('The "field" and "dataSource" options of the scheduler resource are mandatory.');e.resources.push({field:r,name:o,title:a.title||r,dataTextField:a.dataTextField||"text",dataValueField:a.dataValueField||"value",dataColorField:a.dataColorField||"color",dataParentValueField:a.dataParentValueField||"parentValue",valuePrimitive:a.valuePrimitive!=null?a.valuePrimitive:true,multiple:a.multiple||false,dataSource:e._resourceDataSource(s,o,i)})}if(!e.options.autoBind)e._selectView(e._selectedViewName);else w.when.apply(null,i).then(function(){e.view(e._selectedViewName)})},_resourceDataSource:function(e,t,i){var n=this;var a=T(e)?{data:e}:e;var r=y.data.DataSource.create(a);if(n.options.autoBind)i.push(r.fetch(function(){n._bindResourceEvents(this,t)}));else n._bindResourceEvents(r,t);return r},_bindResourceEvents:function(e,t){var i=this;var n=i.options.group&&i.options.group.resources.length;var a=n&&i.options.group.resources.indexOf(t)>-1;if(!i._resourceRefreshHandler&&a){i._resourceRefreshHandler=i._refreshResource.bind(i);i._resourceErrorHandler=i._error.bind(i)}if(a)e.bind(_,i._resourceRefreshHandler).bind(V,i._resourceErrorHandler)},_refreshResource:function(){var e=this;var t=e._editor&&e._editor.editable||e._preventRefresh;if(!t)e.view(e._selectedViewName)},_initModel:function(){var t=this;t._model=y.observable({selectedDate:new Date(this.options.date),formattedDate:"",formattedShortDate:""});t._model.bind(_,function(e){if(e.field==="selectedDate")t.view(t._selectedViewName)})},_wrapper:function(){var e=this;var t=e.options;var i=t.height;var n=t.width;e.wrapper=e.element.addClass("k-widget k-scheduler k-floatwrap");if(e._isMobile())e.wrapper.addClass("k-scheduler-mobile");if(i)e.wrapper.height(i);if(n)e.wrapper.width(n)},date:function(e){if(e!=null&&z(e)>=z(this.options.min)&&z(e)<=z(this.options.max))this._model.set("selectedDate",e);return z(this._model.get("selectedDate"))},_toolbar:function(){var s=this;var e=s.options;var t=[];if(e.toolbar)t=Array.isArray(e.toolbar)?e.toolbar:[e.toolbar];var i=this._isMobile()?ie:te;var n=w(i({messages:e.messages,pdf:w.grep(t,function(e){return e=="pdf"||e.name=="pdf"}).length>0,search:w.grep(t,function(e){return e=="search"||e.name=="search"}).length>0,ns:y.ns,view:s._selectedViewName,views:s.views,viewsCount:s._viewsCount,editable:s.options.editable}));s.wrapper.append(n);s.toolbar=n;y.bind(s.toolbar,s._model);n.on(b+k,".k-pdf",function(e){e.preventDefault();s.saveAsPDF()});n.on("input"+k,".k-scheduler-search-input",y.throttle(function(e){s.dataSource.filter({logic:"or",filters:[{field:"title",operator:"contains",value:e.target.value},{field:"description",operator:"contains",value:e.target.value}]})},250));n.on(b+k,".k-create-event",function(e){e.preventDefault();s.addEvent()});n.on(b+k,".k-nav-calendar",function(e){e.preventDefault();s._showCalendar(e.target)});n.on(b+k,".k-scheduler-navigation > .k-button",function(e){var t=w(this);var i=new Date(s.date());var n="";var a=new Date;var r=s.options.timezone;s.toolbar.find("."+c).removeClass(c);t.addClass(c).attr("tabindex",0).trigger("focus").attr("tabindex",-1);if(w(e.target).is("input"))return;e.preventDefault();if(t.hasClass("k-nav-today")){n="today";if(r){var o=y.timezone.offset(a,r);i=y.timezone.convert(a,a.getTimezoneOffset(),o)}else i=a}else if(t.hasClass("k-nav-next")){n="next";i=s.view().nextDate()}else if(t.hasClass("k-nav-prev")){n="previous";i=s.view().previousDate()}if(!s.trigger("navigate",{view:s._selectedViewName,action:n,date:i}))s.date(i)});n.on(b+k,".k-nav-current",function(e){e.preventDefault();s.toolbar.find("."+c).removeClass(c);w(this).addClass(c);if(!s._isMobile())s._showCalendar()});n.on(b+k,".k-scheduler-views > .k-button, .k-scheduler-refresh",function(e){e.preventDefault();var t=w(this).attr(y.attr("name"));s.toolbar.find("."+c).removeClass(c);w(this).addClass(c).attr("tabindex",0).trigger("focus").attr("tabindex",-1);if(!s.trigger("navigate",{view:t,action:"changeView",date:s.date()}))s.view(t)});n.on(_+k,".k-views-dropdown, .k-scheduler-mobile-views",function(){var e=this.value;if(!s.trigger("navigate",{view:e,action:"changeView",date:s.date()}))s.view(e)})},_showCalendar:function(e){var t=this,i=e||t.toolbar.find(".k-nav-current"),n=w('<div class="k-calendar-container"><div class="k-scheduler-calendar"></div></div>');if(!t.popup)t.popup=new s(n,{anchor:i,activate:function(){if(t.popup&&t.calendar){t.popup._toggleResize(false);t.calendar.element.find("table").trigger("focus");t.popup._toggleResize(true)}},open:function(){if(!t.calendar)t.calendar=new l(this.element.find(".k-scheduler-calendar"),{change:function(){var e=this.value();if(!t.trigger("navigate",{view:t._selectedViewName,action:"changeDate",date:e})){t.date(e);t.popup.close()}if(!t._isMobile()){t._selectedView.element.trigger("focus");t.toolbar.find(".k-nav-current").trigger("focus").addClass(c)}},min:t.options.min,max:t.options.max});t.calendar.element.on("keydown"+k,function(e){if(e.keyCode===u.ESC||e.keyCode===u.TAB){t.popup.close();t._selectedView.element.trigger("focus");t.toolbar.find(".k-nav-current").trigger("focus").addClass(c)}});t.calendar.setOptions({start:t._selectedViewName==="year"?"decade":"month",depth:t._selectedViewName==="year"?"decade":"month"});t.calendar.value(t.date())},copyAnchorStyles:false});t.popup.open()},refresh:function(e){var t=this;var i=this.view();var n=e&&e.action==="itemchange"&&(this._editor.editable||this._preventRefresh)||this.dataSource.options.type==="signalr"&&this._preventRefresh;this._progress(false);this.angular("cleanup",function(){return{elements:t.items()}});e=e||{};if(!i)return;if(n){this._attemptRefresh=true&&this.dataSource.options.type==="signalr";return}if(this.trigger("dataBinding",{action:e.action||"rebind",index:e.index,items:e.items}))return;if(!(e&&e.action==="resize")&&this._editor)this._editor.close();this._data=this.dataSource.expand(i.startDate(),i.visibleEndDate());i.refreshLayout();i.render(this._data);this.trigger("dataBound");this._attemptRefresh=false},slotByPosition:function(e,t){var i=this.view();if(!i._slotByPosition)return null;var n=i._slotByPosition(e,t);if(!n)return null;return{startDate:n.startDate(),endDate:n.endDate(),groupIndex:n.groupIndex,element:n.element,isDaySlot:n.isDaySlot}},slotByElement:function(e){var t=w(e).offset();return this.slotByPosition(t.left,t.top)},resourcesBySlot:function(e){return this.view()._resourceBySlot(e)}}),qe={day:{type:"kendo.ui.DayView"},week:{type:"kendo.ui.WeekView"},workWeek:{type:"kendo.ui.WorkWeekView"},agenda:{type:"kendo.ui.AgendaView"},month:{type:"kendo.ui.MonthView"},timeline:{type:"kendo.ui.TimelineView"},timelineWeek:{type:"kendo.ui.TimelineWeekView"},timelineWorkWeek:{type:"kendo.ui.TimelineWorkWeekView"},timelineMonth:{type:"kendo.ui.TimelineMonthView"},year:{type:"kendo.ui.YearView"}};if(t.plugin(Ye),y.PDFMixin){y.PDFMixin.extend(Ye.prototype);var $e="k-scheduler-pdf-export";Ye.fn._drawPDF=function(i){var e=this.wrapper;var t=e[0].style.cssText;e.css({width:e.width(),height:e.height()});e.addClass($e);var n=this;var a=new w.Deferred;var r=e.find(".k-scheduler-content").find("table").css("table-layout","auto");setTimeout(function(){r.css("table-layout","fixed");n.resize(true);n._drawPDFShadow({},{avoidLinks:n.options.pdf.avoidLinks}).done(function(e){var t={page:e,pageNumber:1,progress:1,totalPages:1};i.notify(t);a.resolve(t.page)}).fail(function(e){a.reject(e)}).always(function(){e[0].style.cssText=t;e.removeClass($e);n.resize(true);n.resize(true)})});return a}}var Qe=a.extend({init:function(e,t){var i=this,n=y.timezone.windows_zones;if(!n||!y.timezone.zones_titles)throw new Error("kendo.timezones.min.js is not included.");a.fn.init.call(i,e,t);i.wrapper=i.element;i._zonesQuery=new y.data.Query(n);i._zoneTitleId=y.guid();i._zoneTitlePicker();i._zonePicker();i._zoneTitle.bind("cascade",function(){if(!this.value())i._zone.wrapper.hide()});i._zone.bind("cascade",function(){i._value=this.value();i.trigger(_)});i.value(i.options.value)},options:{name:"TimezoneEditor",value:"",optionLabel:"No timezone"},events:[_],_zoneTitlePicker:function(){var e=this,t=w('<input id="'+e._zoneTitleId+'" aria-label="'+e.options.title+'"/>').appendTo(e.wrapper);e._zoneTitle=new y.ui.DropDownList(t,{dataSource:y.timezone.zones_titles,dataValueField:"other_zone",dataTextField:"name",optionLabel:e.options.optionLabel})},_zonePicker:function(){var e=this,t=w('<input aria-label="'+e.options.title+'"/>').appendTo(this.wrapper);e._zone=new y.ui.DropDownList(t,{dataValueField:"zone",dataTextField:"territory",dataSource:e._zonesQuery.data,cascadeFrom:e._zoneTitleId,dataBound:function(){e._value=this.value();this.wrapper.toggle(this.dataSource.view().length>1)}});e._zone.wrapper.hide()},destroy:function(){a.fn.destroy.call(this);y.destroy(this.wrapper)},value:function(e){var t=this,i;if(e===h)return t._value;i=t._zonesQuery.filter({field:"zone",operator:"eq",value:e}).data[0];if(i){t._zoneTitle.value(i.other_zone);t._zone.value(i.zone)}else t._zoneTitle.select(0)}}),je=(t.plugin(Qe),y.template('<option value="#=other_zone#">#=name#</option>')),Je=y.template('<option value="#=zone#">#=territory#</option>'),Ge=a.extend({init:function(e,t){var i=this,n=y.timezone.windows_zones;if(!n||!y.timezone.zones_titles)throw new Error("kendo.timezones.min.js is not included.");a.fn.init.call(i,e,t);i.wrapper=i.element;i._zonesQuery=new y.data.Query(n);i._zoneTitlePicker();i._zonePicker();i.value(i.options.value)},options:{name:"MobileTimezoneEditor",optionLabel:"No timezone",value:""},events:[_],_bindZones:function(e){var t=e?this._filter(e):[];this._zone.html(this._options(t,Je))},_filter:function(e){return this._zonesQuery.filter({field:"other_zone",operator:"eq",value:e}).data},_options:function(e,t,i){var n=0;var a="";var r=e.length;if(i)a+=t({other_zone:"",name:i});for(;n<r;n++)a+=t(e[n]);return a},_zoneTitlePicker:function(){var n=this;var e=n._options(y.timezone.zones_titles,je,n.options.optionLabel);n._zoneTitle=w("<select>"+e+"</select>").appendTo(n.wrapper).on("change",function(){var e=this.value;var t=n._zonePickerLabel;var i=t.find("select");n._bindZones(e);if(e&&i.children().length>1)t.show();else t.hide();n._value=n._zone[0].value;n.trigger(_)})},_zonePicker:function(){var e=this;e._zonePickerLabel=w("<li class='k-item k-listgroup-item k-zonepicker' style='display:none'>"+"<label class='k-label k-listgroup-form-row'>"+"<span class='k-item-title k-listgroup-form-field-label'></span>"+"<div class='k-listgroup-form-field-wrapper'></div>"+"</label>"+"</li>");e._zone=w("<select></select>").appendTo(e._zonePickerLabel.find("div")).on("change",function(){e._value=this.value;e.trigger(_)});this.wrapper.closest(".k-item").after(e._zonePickerLabel);e._bindZones(e._zoneTitle.val());e._value=e._zone[0].value},destroy:function(){a.fn.destroy.call(this);y.destroy(this.wrapper)},value:function(e){var t=this;var i=t._zone;var n="";var a="";var r;if(e===h)return t._value;r=t._zonesQuery.filter({field:"zone",operator:"eq",value:e}).data[0];if(r){a=r.zone;n=r.other_zone}t._zoneTitle.val(n);t._bindZones(n);i.val(a);a=i[0].value;if(a&&i.children.length>1)t._zonePickerLabel.show();else t._zonePickerLabel.hide();t._value=a}});return t.plugin(Ge),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,i){(i||t)()});
//# sourceMappingURL=kendo.scheduler.min.js.map
