/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.dataviz.treemap.min",["kendo.data.min","kendo.userevents.min","kendo.dataviz.themes.min"],function(){var e={id:"dataviz.treeMap",name:"TreeMap",category:"dataviz",description:"The Kendo DataViz TreeMap",depends:["data","userevents","dataviz.themes"]},r=window.kendo.jQuery,o=void 0,d=Math,f=Array.isArray,s=window.kendo,v=s._outerHeight,l=s._outerWidth,t=s.Class,i=s.ui.Widget,h=s.template,n=s.deepExtend,p=s.data.HierarchicalDataSource,m=s.getter,g=s.dataviz,_=".kendoTreeMap",a="change",w="dataBound",y="itemCreated",k=Number.MAX_VALUE,z="mouseover"+_,C="mouseleave"+_,x="undefined",I=i.extend({init:function(t,e){s.destroy(t);r(t).empty();i.fn.init.call(this,t,e);this.wrapper=this.element;this._initTheme(this.options);this.element.addClass("k-widget k-treemap");this._setLayout();this._originalOptions=n({},this.options);this._initDataSource();this._attachEvents();s.notify(this,g.ui)},options:{name:"TreeMap",theme:"default",autoBind:true,textField:"text",valueField:"value",colorField:"color"},events:[w,y],_initTheme:function(t){var e=this,i=g.ui.themes||{},r=((t||{}).theme||"").toLowerCase(),a=(i[r]||{}).treeMap;e.options=n({},a,t)},_attachEvents:function(){this.element.on(z,this._mouseover.bind(this)).on(C,this._mouseleave.bind(this));this._resizeHandler=this.resize.bind(this,false);s.onResize(this._resizeHandler)},_setLayout:function(){if(this.options.type==="horizontal"){this._layout=new T(false);this._view=new H(this,this.options)}else if(this.options.type==="vertical"){this._layout=new T(true);this._view=new H(this,this.options)}else{this._layout=new S;this._view=new b(this,this.options)}},_initDataSource:function(){var t=this,e=t.options,i=e.dataSource;t._dataChangeHandler=t._onDataChange.bind(t);t.dataSource=p.create(i).bind(a,t._dataChangeHandler);if(i)if(t.options.autoBind)t.dataSource.fetch()},setDataSource:function(t){var e=this;e.dataSource.unbind(a,e._dataChangeHandler);e.dataSource=t.bind(a,e._dataChangeHandler);if(t)if(e.options.autoBind)e.dataSource.fetch()},_onDataChange:function(t){var e=t.node;var i=t.items;var r=this.options;var a,n;if(!e){this._cleanItems();this.element.empty();a=this._wrapItem(i[0]);this._layout.createRoot(a,l(this.element),v(this.element),this.options.type==="vertical");this._view.createRoot(a);this._root=a;this._colorIdx=0}else if(i.length){var o=this._getByUid(e.uid);o.children=[];i=new s.data.Query(i)._sortForGrouping(r.valueField,"desc");for(n=0;n<i.length;n++){a=i[n];o.children.push(this._wrapItem(a))}var h=this._view.htmlSize(o);this._layout.compute(o.children,o.coord,h);this._setColors(o.children);this._view.render(o)}for(n=0;n<i.length;n++)i[n].load();if(e)this.trigger(w,{node:e})},_cleanItems:function(){var t=this;t.angular("cleanup",function(){return{elements:t.element.find(".k-leaf div,.k-treemap-title,.k-treemap-title-vertical")}})},_setColors:function(t){var e=this.options.colors;var i=this._colorIdx;var r=e[i%e.length];var a,n;if(f(r))a=B(r[0],r[1],t.length);var o=false;for(var h=0;h<t.length;h++){n=t[h];if(!u(n.color))if(a)n.color=a[h];else n.color=r;if(!n.dataItem.hasChildren)o=true}if(o)this._colorIdx++},_contentSize:function(t){this.view.renderHeight(t)},_wrapItem:function(t){var e={};if(u(this.options.valueField))e.value=A(this.options.valueField,t);if(u(this.options.colorField))e.color=A(this.options.colorField,t);if(u(this.options.textField))e.text=A(this.options.textField,t);e.level=t.level();e.dataItem=t;return e},_getByUid:function(t){var e=[this._root];var i;while(e.length){i=e.pop();if(i.dataItem.uid===t)return i;if(i.children)e=e.concat(i.children)}},dataItem:function(t){var e=r(t).attr(s.attr("uid")),i=this.dataSource;return i&&i.getByUid(e)},findByUid:function(t){return this.element.find(".k-treemap-tile["+s.attr("uid")+"='"+t+"']")},_mouseover:function(t){var e=r(t.target);if(e.hasClass("k-leaf")){this._removeActiveState();e.removeClass("k-hover").addClass("k-hover")}},_removeActiveState:function(){this.element.find(".k-hover").removeClass("k-hover")},_mouseleave:function(){this._removeActiveState()},destroy:function(){i.fn.destroy.call(this);this.element.off(_);if(this.dataSource)this.dataSource.unbind(a,this._dataChangeHandler);this._root=null;s.unbindResize(this._resizeHandler);s.destroy(this.element)},items:function(){return r()},getSize:function(){return s.dimensions(this.element)},_resize:function(){var t=this._root;if(t){var e=this.element;var i=e.children();t.coord.width=l(e);t.coord.height=v(e);i.css({width:t.coord.width,height:t.coord.height});this._resizeItems(t,i)}},_resizeItems:function(t,e){if(t.children&&t.children.length){var i=e.children(".k-treemap-wrap").children();var r,a;this._layout.compute(t.children,t.coord,{text:this._view.titleSize(t,e)});for(var n=0;n<t.children.length;n++){r=t.children[n];a=i.filter("["+s.attr("uid")+"='"+r.dataItem.uid+"']");this._view.setItemSize(r,a);this._resizeItems(r,a)}}},setOptions:function(t){var e=t.dataSource;t.dataSource=o;this._originalOptions=n(this._originalOptions,t);this.options=n({},this._originalOptions);this._setLayout();this._initTheme(this.options);i.fn._setEvents.call(this,t);if(e)this.setDataSource(p.create(e));if(this.options.autoBind)this.dataSource.fetch()}}),S=t.extend({createRoot:function(t,e,i){t.coord={width:e,height:i,top:0,left:0}},leaf:function(t){return!t.children},layoutChildren:function(t,e){var i=e.width*e.height;var r=0,a=[],n;for(n=0;n<t.length;n++){a[n]=parseFloat(t[n].value);r+=a[n]}for(n=0;n<a.length;n++)t[n].area=i*a[n]/r;var o=this.layoutHorizontal()?e.height:e.width;var h=[t[0]];var s=t.slice(1);this.squarify(s,h,o,e)},squarify:function(t,e,i,r){this.computeDim(t,e,i,r)},computeDim:function(t,e,i,r){if(t.length+e.length==1){var a=t.length==1?t:e;this.layoutLast(a,i,r);return}if(t.length>=2&&e.length===0){e=[t[0]];t=t.slice(1)}if(t.length===0){if(e.length>0)this.layoutRow(e,i,r);return}var n=t[0];if(this.worstAspectRatio(e,i)>=this.worstAspectRatio([n].concat(e),i))this.computeDim(t.slice(1),e.concat([n]),i,r);else{var o=this.layoutRow(e,i,r);this.computeDim(t,[],o.dim,o)}},layoutLast:function(t,e,i){t[0].coord=i},layoutRow:function(t,e,i){if(this.layoutHorizontal())return this.layoutV(t,e,i);else return this.layoutH(t,e,i)},orientation:"h",layoutVertical:function(){return this.orientation==="v"},layoutHorizontal:function(){return this.orientation==="h"},layoutChange:function(){this.orientation=this.layoutVertical()?"h":"v"},worstAspectRatio:function(t,e){if(!t||t.length===0)return k;var i=0,r=0,a=k;for(var n=0;n<t.length;n++){var o=t[n].area;i+=o;a=a<o?a:o;r=r>o?r:o}return d.max(e*e*r/(i*i),i*i/(e*e*a))},compute:function(t,e,i){if(!(e.width>=e.height&&this.layoutHorizontal()))this.layoutChange();if(t&&t.length>0){var r={width:e.width,height:e.height-i.text,top:0,left:0};this.layoutChildren(t,r)}},layoutV:function(t,e,i){var r=this._totalArea(t),a=0;e=c(r/e);for(var n=0;n<t.length;n++){var o=c(t[n].area/e);t[n].coord={height:o,width:e,top:i.top+a,left:i.left};a+=o}var h={height:i.height,width:i.width-e,top:i.top,left:i.left+e};h.dim=d.min(h.width,h.height);if(h.dim!=h.height)this.layoutChange();return h},layoutH:function(t,e,i){var r=this._totalArea(t);var a=c(r/e),n=i.top,o=0;for(var h=0;h<t.length;h++){t[h].coord={height:a,width:c(t[h].area/a),top:n,left:i.left+o};o+=t[h].coord.width}var s={height:i.height-a,width:i.width,top:i.top+a,left:i.left};s.dim=d.min(s.width,s.height);if(s.dim!=s.width)this.layoutChange();return s},_totalArea:function(t){var e=0;for(var i=0;i<t.length;i++)e+=t[i].area;return e}}),b=t.extend({init:function(t,e){this.options=n({},this.options,e);this.treeMap=t;this.element=r(t.element);this.offset=0},titleSize:function(t,e){var i=e.children(".k-treemap-title");return i.height()||0},htmlSize:function(t){var e=this._getByUid(t.dataItem.uid);var i={text:0};if(t.children){this._clean(e);var r=this._getText(t);if(r){var a=this._createTitle(t);e.append(a);this._compile(a,t.dataItem);i.text=a.height()}e.append(this._createWrap());this.offset=(l(e)-e.innerWidth())/2}return i},_compile:function(t,e){this.treeMap.angular("compile",function(){return{elements:t,data:[{dataItem:e}]}})},_getByUid:function(t){return this.element.find(".k-treemap-tile["+s.attr("uid")+"='"+t+"']")},render:function(t){var e=this._getByUid(t.dataItem.uid);var i=t.children;if(i){var r=e.find(".k-treemap-wrap");for(var a=0;a<i.length;a++){var n=i[a];var o=this._createLeaf(n);r.append(o);this._compile(o.children(),n.dataItem);this.treeMap.trigger(y,{element:o})}}},createRoot:function(t){var e=this._createLeaf(t);this.element.append(e);this._compile(e.children(),t.dataItem);this.treeMap.trigger(y,{element:e})},_clean:function(t){this.treeMap.angular("cleanup",function(){return{elements:t.children(":not(.k-treemap-wrap)")}});t.css("background-color","");t.removeClass("k-leaf");t.removeClass("k-inverse");t.empty()},_createLeaf:function(t){return this._createTile(t).css("background-color",t.color).addClass("k-leaf").toggleClass("k-inverse",this._tileColorBrightness(t)>180).toggle(t.value!==0).append(r("<div></div>").html(this._getText(t)))},_createTile:function(t){var e=r("<div class='k-treemap-tile'></div>");this.setItemSize(t,e);if(u(t.dataItem)&&u(t.dataItem.uid))e.attr(s.attr("uid"),t.dataItem.uid);return e},_itemCoordinates:function(t){var e={width:t.coord.width,height:t.coord.height,left:t.coord.left,top:t.coord.top};if(e.left&&this.offset)e.width+=this.offset*2;else e.width+=this.offset;if(e.top)e.height+=this.offset*2;else e.height+=this.offset;return e},setItemSize:function(t,e){var i=this._itemCoordinates(t);e.css({width:i.width,height:i.height,left:i.left,top:i.top})},_getText:function(t){var e=t.text;if(this.options.template)e=this._renderTemplate(t);return e},_renderTemplate:function(t){var e=h(this.options.template);return e({dataItem:t.dataItem,text:t.text})},_createTitle:function(t){return r("<div class='k-treemap-title'></div>").append(r("<div></div>").html(this._getText(t)))},_createWrap:function(){return r("<div class='k-treemap-wrap'></div>")},_tileColorBrightness:function(t){return V(t.color)}}),T=t.extend({createRoot:function(t,e,i,r){t.coord={width:e,height:i,top:0,left:0};t.vertical=r},init:function(t){this.vertical=t;this.quotient=t?1:0},compute:function(t,e,i){if(t.length>0){var r=e.width;var a=e.height;if(this.vertical)a-=i.text;else r-=i.text;var n={width:r,height:a,top:0,left:0};this.layoutChildren(t,n)}},layoutChildren:function(t,e){var i=e.width*e.height;var r=0;var a=[];var n;for(n=0;n<t.length;n++){var o=t[n];a[n]=parseFloat(t[n].value);r+=a[n];o.vertical=this.vertical}for(n=0;n<a.length;n++)t[n].area=i*a[n]/r;this.sliceAndDice(t,e)},sliceAndDice:function(t,e){var i=this._totalArea(t);if(t[0].level%2===this.quotient)this.layoutHorizontal(t,e,i);else this.layoutVertical(t,e,i)},layoutHorizontal:function(t,e,i){var r=0;for(var a=0;a<t.length;a++){var n=t[a];var o=n.area/(i/e.width);n.coord={height:e.height,width:o,top:e.top,left:e.left+r};r+=o}},layoutVertical:function(t,e,i){var r=0;for(var a=0;a<t.length;a++){var n=t[a];var o=n.area/(i/e.height);n.coord={height:o,width:e.width,top:e.top+r,left:e.left};r+=o}},_totalArea:function(t){var e=0;for(var i=0;i<t.length;i++)e+=t[i].area;return e}}),H=b.extend({htmlSize:function(t){var e=this._getByUid(t.dataItem.uid);var i={text:0,offset:0};if(t.children){this._clean(e);var r=this._getText(t);if(r){var a=this._createTitle(t);e.append(a);this._compile(a,t.dataItem);if(t.vertical)i.text=a.height();else i.text=a.width()}e.append(this._createWrap());this.offset=(l(e)-e.innerWidth())/2}return i},titleSize:function(t,e){var i;if(t.vertical)i=e.children(".k-treemap-title").height();else i=e.children(".k-treemap-title-vertical").width();return i||0},_createTitle:function(t){var e;if(t.vertical)e=r("<div class='k-treemap-title'></div>");else e=r("<div class='k-treemap-title-vertical'></div>");return e.append(r("<div></div>").html(this._getText(t)))}});function A(t,e){if(e===null)return e;var i=m(t,true);return i(e)}function u(t){return typeof t!==x}function B(t,e,i){var r=M(t);var a=M(e);var n=V(t)-V(e)<0;var o=[];o.push(t);for(var h=0;h<i;h++){var s={r:D(r.r,a.r,h,i,n),g:D(r.g,a.g,h,i,n),b:D(r.b,a.b,h,i,n)};o.push(F(s))}o.push(e);return o}function D(t,e,i,r,a){var n=d.min(d.abs(t),d.abs(e));var o=d.max(d.abs(t),d.abs(e));var h=(o-n)/(r+1);var s=h*(i+1);var l;if(a)l=n+s;else l=o-s;return l}function F(t){return"#"+R(t.r)+R(t.g)+R(t.b)}function M(t){t=t.replace("#","");var e=L(t);return{r:U(e.r),g:U(e.g),b:U(e.b)}}function R(t){var e=d.round(t).toString(16).toUpperCase();if(e.length===1)e="0"+e;return e}function L(t){var e=t.length;var i={};if(e===3){i.r=t[0];i.g=t[1];i.b=t[2]}else{i.r=t.substring(0,2);i.g=t.substring(2,4);i.b=t.substring(4,6)}return i}function U(t){return parseInt(t.toString(16),16)}function V(t){var e=0;if(t){t=M(t);e=d.sqrt(.241*t.r*t.r+.691*t.g*t.g+.068*t.b*t.b)}return e}function c(t){var e=d.pow(10,4);return d.round(t*e)/e}return g.ui.plugin(I),window.kendo})}("function"==typeof define&&define.amd?define:function(t,e,i){(i||e)()});
//# sourceMappingURL=kendo.dataviz.treemap.min.js.map
