/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.datepicker.min",["kendo.calendar.min","kendo.popup.min","kendo.dateinput.min","kendo.html.button.min"],function(){var e={id:"datepicker",name:"DatePicker",category:"web",description:"The DatePicker widget allows the user to select a date from a calendar or by direct input.",depends:["calendar","popup","html.button"]},d=window.kendo.jQuery,i=void 0,u=window.kendo,r=u.ui,f=u.html,o=r.Widget,p=u.parseDate,l=u.keys,a=u.support,t=u.template,m=u._activeElement,_="<div />",v="<span />",s=".kendoDatePicker",h="click"+s,g=a.mouseAndTouchPresent?u.applyEventMap("up",s.slice(1)):h,b="open",w="close",y="change",k="disabled",D="readonly",I="k-focus",x="k-selected",C="k-disabled",A="k-hover",T="mouseenter"+s+" mouseleave"+s,V="mousedown"+s,P="navigate",O="id",H="min",R="max",E="month",z="aria-disabled",N="aria-readonly",F="aria-expanded",M="aria-hidden",n="aria-activedescendant",c=u.calendar,S=c.isInRange,W=c.restrictValue,q=c.isEqualDatePart,B=d.extend,K=Date;function j(e){var t=e.parseFormats,a=e.format;c.normalize(e);t=Array.isArray(t)?t:[t];if(!t.length)t.push("yyyy-MM-dd");if(d.inArray(a,t)===-1)t.splice(0,0,e.format);e.parseFormats=t}function Q(e){e.preventDefault()}var U=function(e){var t=this,a,n=document.body,i=d(_).attr(M,"true").addClass("k-calendar-container");t.options=e=e||{};a=e.id;if(!e.omitPopup){i.appendTo(n);t.popup=new r.Popup(i,B(e.popup,e,{name:"Popup",isRtl:u.support.isRtl(e.anchor)}))}else i=e.dateDiv;if(a){a+="_dateview";i.attr(O,a);t._dateViewID=a}t.div=i;t.value(e.value)},G=(U.prototype={_calendar:function(){var e=this;var t=e.calendar;var a=e.options;var n;if(!t){n=d(_).attr(O,u.guid()).appendTo(a.omitPopup?a.dateDiv:e.popup.element).on(V,Q).on(h,"td:has(.k-link)",e._click.bind(e));e.calendar=t=new r.Calendar(n,{componentType:a.componentType,size:a.size,messages:a.messages});e._setOptions(a);n.addClass(u.getValidCssClass("k-calendar-","size",a.size));t.navigate(e._value||e._current,a.start);e.value(e._value)}},_setOptions:function(e){this.calendar.setOptions({focusOnNav:false,change:e.change,culture:e.culture,dates:e.dates,depth:e.depth,footer:e.footer,format:e.format,max:e.max,min:e.min,month:e.month,weekNumber:e.weekNumber,start:e.start,messages:e.messages,disableDates:e.disableDates})},setOptions:function(e){var t=this.options;var a=e.disableDates;if(a)e.disableDates=c.disabled(a);this.options=B(t,e,{change:t.change,close:t.close,open:t.open});if(this.calendar)this._setOptions(this.options)},destroy:function(){if(this.popup)this.popup.destroy()},open:function(){var e=this;var t;e._calendar();t=e.popup._hovered;e.popup._hovered=true;e.popup.open();setTimeout(function(){e.popup._hovered=t},1)},close:function(){if(this.popup)this.popup.close()},min:function(e){this._option(H,e)},max:function(e){this._option(R,e)},toggle:function(){var e=this;e[e.popup.visible()?w:b]()},move:function(e){var t=this,a=e.keyCode,n=t.calendar,i=e.ctrlKey&&a==l.DOWN||a==l.ENTER,r=false;if(e.altKey){if(a==l.DOWN){t.open();e.preventDefault();r=true}else if(a==l.UP){t.close();e.preventDefault();r=true}}else if(t.popup&&t.popup.visible()){if(a==l.ESC||i&&n._cell.hasClass(x)){t.close();e.preventDefault();return true}if(a!=l.SPACEBAR)t._current=n._move(e);r=true}return r},current:function(e){this._current=e;if(this.calendar)this.calendar._focus(e)},value:function(e){var t=this,a=t.calendar,n=t.options,i=n.disableDates;if(i&&i(e))e=null;t._value=e;t._current=new K(+W(e,n.min,n.max));if(a)a.value(e)},_click:function(e){if(e.currentTarget.className.indexOf(x)!==-1){this.calendar.trigger("change");this.close()}},_option:function(e,t){var a=this;var n=a.calendar;a.options[e]=t;if(n)n[e](t)}},U.normalize=j,u.DateView=U,o.extend({init:function(n,e){var i=this,t,a,r;o.fn.init.call(i,n,e);n=i.element;e=i.options;e.disableDates=u.calendar.disabled(e.disableDates);e.min=p(n.attr("min"))||p(e.min);e.max=p(n.attr("max"))||p(e.max);j(e);i._initialOptions=B({},e);i._wrapper();i.dateView=new U(B({},e,{id:n.attr(O),anchor:i.wrapper,change:function(){i._change(this.value());i.close()},close:function(e){if(i.trigger(w))e.preventDefault();else{n.attr(F,false);r.attr(M,true);setTimeout(function(){n.removeAttr("aria-activedescendant")})}},open:function(e){var t=i.options,a;if(i.trigger(b))e.preventDefault();else{if(i.element.val()!==i._oldText){a=p(n.val(),t.parseFormats,t.culture);i.dateView[a?"current":"value"](a)}n.attr(F,true);r.attr(M,false);i._updateARIA(a)}}}));r=i.dateView.div;i._icon();try{n[0].setAttribute("type","text")}catch(e){n[0].type="text"}n.addClass("k-input-inner").attr({role:"combobox","aria-expanded":false,"aria-haspopup":"grid","aria-controls":i.dateView._dateViewID,autocomplete:"off"});i._reset();i._template();a=n.is("[disabled]")||d(i.element).parents("fieldset").is(":disabled");if(a)i.enable(false);else i.readonly(n.is("[readonly]"));t=p(e.value||i.element.val(),e.parseFormats,e.culture);i._createDateInput(e);i._old=i._update(t||i.element.val());i._oldText=n.val();i._applyCssClasses();u.notify(i)},events:[b,w,y],options:{name:"DatePicker",value:null,footer:"",format:"",culture:"",parseFormats:[],min:new Date(1900,0,1),max:new Date(2099,11,31),start:E,depth:E,animation:{},month:{},dates:[],disableDates:null,ARIATemplate:"Current focused #=data.valueType# is #=data.text#",dateInput:false,weekNumber:false,messages:{weekColumnHeader:""},componentType:"classic",size:"medium",fillMode:"solid",rounded:"medium"},setOptions:function(e){var t=this;var a=t._value;o.fn.setOptions.call(t,e);e=t.options;e.min=p(e.min);e.max=p(e.max);j(e);t._dateIcon.off(s);t._dateIcon.remove();t.dateView.setOptions(e);t._icon();t._editable(e);t._createDateInput(e);if(!t._dateInput)t.element.val(u.toString(a,e.format,e.culture));if(a)t._updateARIA(a)},_editable:function(e){var t=this,a=t._dateIcon.off(s),n=t.element.off(s),i=t.wrapper.off(s),r=e.readonly,o=e.disable;if(!r&&!o){i.removeClass(C).on(T,t._toggleHover);if(n&&n.length){n[0].removeAttribute(k);n[0].removeAttribute(D)}n.attr(z,false).attr(N,false).on("keydown"+s,t._keydown.bind(t)).on("focusout"+s,t._blur.bind(t)).on("focus"+s,function(){t.wrapper.addClass(I)});a.on(g,t._click.bind(t)).on(V,Q)}else{i.addClass(o?C:"").removeClass(o?"":C);n.attr(k,o).attr(D,r).attr(z,o).attr(N,r)}},readonly:function(e){this._editable({readonly:e===i?true:e,disable:false});if(this._dateInput)this._dateInput._editable({readonly:e===i?true:e,disable:false})},enable:function(e){this._editable({readonly:false,disable:!(e=e===i?true:e)});if(this._dateInput)this._dateInput._editable({readonly:false,disable:!(e=e===i?true:e)})},destroy:function(){var e=this;o.fn.destroy.call(e);if(e.dateView.calendar&&e._navigateCalendarHandler){e.dateView.calendar.unbind(P,e._navigateCalendarHandler);e._navigateCalendarHandler=null}e.dateView.destroy();e.element.off(s);e._dateIcon.off(s);if(e._form)e._form.off("reset",e._resetHandler)},open:function(){this.dateView.open();this._navigateCalendar()},close:function(){this.dateView.close()},min:function(e){return this._option(H,e)},max:function(e){return this._option(R,e)},value:function(e){var t=this;if(e===i)return t._value;t._old=t._update(e);if(t._old===null)if(t._dateInput)t._dateInput.value(t._old);else t.element.val("");t._oldText=t.element.val()},_toggleHover:function(e){d(e.currentTarget).toggleClass(A,e.type==="mouseenter")},_blur:function(){var e=this,t=e.element.val();e.close();if(t!==e._oldText){e._change(t);if(!t)e.dateView.current(u.calendar.getToday())}e.wrapper.removeClass(I)},_click:function(e){var t=this;t.dateView.toggle();t._navigateCalendar();t._focusElement(e.type)},_focusElement:function(e){var t=this.element;if((!a.touch||a.mouseAndTouchPresent&&!(e||"").match(/touch/i))&&t[0]!==m())t.trigger("focus")},_change:function(e){var t=this,a=t.element.val(),n;e=t._update(e);n=!u.calendar.isEqualDate(t._old,e);var i=n&&!t._typing;var r=a!==t.element.val();if(i||r)t.element.trigger(y);if(n){t._old=e;t._oldText=t.element.val();t.trigger(y)}t._typing=false},_keydown:function(e){var t=this,a=t.dateView,n=t.element.val(),i=false;if(!a.popup.visible()&&e.keyCode==l.ENTER&&n!==t._oldText)t._change(n);else{i=a.move(e);t._updateARIA(a._current);if(!i)t._typing=true;else if(t._dateInput&&e.stopImmediatePropagation)e.stopImmediatePropagation()}},_icon:function(){var e=this,t=e.element,a=e.options,n;n=t.next("button.k-input-button");if(!n[0])n=d(f.renderButton('<button aria-label="select" tabindex="-1" class="k-input-button k-button k-icon-button"></button>',{icon:"calendar",size:a.size,fillMode:a.fillMode,shape:"none",rounded:"none"})).insertAfter(t);e._dateIcon=n.attr({role:"button"})},_setCalendarAttribute:function(){var e=this;setTimeout(function(){e.element.attr(n,e.dateView.calendar._table.attr(n))})},_navigateCalendar:function(){var e=this;if(!e._navigateCalendarHandler)e._navigateCalendarHandler=e._setCalendarAttribute.bind(e);if(!!e.dateView.calendar)e.dateView.calendar.unbind(P,e._navigateCalendarHandler).bind(P,e._navigateCalendarHandler)},_option:function(e,t){var a=this,n=a.options;if(t===i)return n[e];t=p(t,n.parseFormats,n.culture);if(!t)return;n[e]=new K(+t);a.dateView[e](t)},_update:function(e){var t=this,a=t.options,n=a.min,i=a.max,r=t._value,o=p(e,a.parseFormats,a.culture),l=o===null&&r===null||o instanceof Date&&r instanceof Date,s;if(a.disableDates(o)){o=null;if(!t._old&&!t.element.val())e=null}if(+o===+r&&l){s=u.toString(o,a.format,a.culture);if(s!==e&&!(t._dateInput&&!o))t.element.val(o===null?e:s);return o}if(o!==null&&q(o,n))o=W(o,n,i);else if(!S(o,n,i))o=null;t._value=o;t.dateView.value(o);if(t._dateInput&&o)t._dateInput.value(o||e);else t.element.val(u.toString(o||e,a.format,a.culture));t._updateARIA(o);return o},_wrapper:function(){var e=this,t=e.element,a;a=t.parents(".k-datepicker");if(!a[0])a=t.wrap(v).parent();a[0].style.cssText=t[0].style.cssText;t.css({height:t[0].style.height});e.wrapper=a.addClass("k-datepicker k-input").addClass(t[0].className).removeClass("input-validation-error")},_reset:function(){var e=this,t=e.element,a=t.attr("form"),n=e.options,i=n.disableDates,r=n.parseFormats.length?n.parseFormats:null,o=e._initialOptions.value,l=a?d("#"+a):t.closest("form"),s=t[0].defaultValue;if(o&&(i&&i(o)))o=null;if((!s||!u.parseDate(s,r,n.culture))&&o)t.attr("value",u.toString(o,n.format,n.culture));if(l[0]){e._resetHandler=function(){e.value(o||t[0].defaultValue);e.max(e._initialOptions.max);e.min(e._initialOptions.min)};e._form=l.on("reset",e._resetHandler)}},_template:function(){this._ariaTemplate=t(this.options.ARIATemplate).bind(this)},_createDateInput:function(e){if(this._dateInput){this._dateInput.destroy();this._dateInput=null}if(e.dateInput)this._dateInput=new r.DateInput(this.element,{culture:e.culture,format:e.format,size:e.size,fillMode:e.fillMode,rounded:e.rounded,min:e.min,max:e.max})},_updateARIA:function(e){var t=this;var a=t.dateView.calendar;if(t.element&&t.element.length)t.element[0].removeAttribute(n);if(a)t.element.attr(n,a._updateAria(t._ariaTemplate,e))}}));return u.cssProperties.registerPrefix("DatePicker","k-input-"),u.cssProperties.registerValues("DatePicker",[{prop:"rounded",values:u.cssProperties.roundedValues.concat([["full","full"]])}]),r.plugin(G),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,a){(a||t)()});
//# sourceMappingURL=kendo.datepicker.min.js.map
