/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.mobile.scroller.min",["kendo.fx.min","kendo.draganddrop.min"],function(){var e={id:"mobile.scroller",name:"Scroller",category:"mobile",description:"The Kendo Mobile Scroller widget enables touch friendly kinetic scrolling for the contents of a given DOM element.",depends:["fx","draganddrop"]},u=window.kendo.jQuery,l=void 0,d=window.kendo,o,a=d.effects,r=d.mobile.ui,m=u.extend,p=r.Widget,c=d.Class,x=d.ui.Movable,y=d.ui.Pane,T=d.ui.PaneDimensions,h=a.Transition,n=a.Animation,v=Math.abs,f=500,g=.7,w=.96,_=10,s=55,E=.5,C=5,i="km-scroller-release",t="km-scroller-refresh",k="pull",b="change",S="resize",z="scroll",M=2,O=n.extend({init:function(e){var i=this;n.fn.init.call(i);m(i,e);i.userEvents.bind("gestureend",i.start.bind(i));i.tapCapture.bind("press",i.cancel.bind(i))},enabled:function(){return this.movable.scale<this.dimensions.minScale},done:function(){return this.dimensions.minScale-this.movable.scale<.01},tick:function(){var e=this.movable;e.scaleWith(1.1);this.dimensions.rescale(e.scale)},onEnd:function(){var e=this.movable;e.scaleTo(this.dimensions.minScale);this.dimensions.rescale(e.scale)}}),A=n.extend({init:function(e){var i=this;n.fn.init.call(i);m(i,e,{transition:new h({axis:e.axis,movable:e.movable,onEnd:function(){i._end()}})});i.tapCapture.bind("press",function(){i.cancel()});i.userEvents.bind("end",i.start.bind(i));i.userEvents.bind("gestureend",i.start.bind(i));i.userEvents.bind("tap",i.onEnd.bind(i))},onCancel:function(){this.transition.cancel()},freeze:function(e){var i=this;i.cancel();i._moveTo(e)},onEnd:function(){var e=this;if(e.paneAxis.outOfBounds())e._snapBack();else e._end()},done:function(){return v(this.velocity)<1},start:function(e){var i=this,t;if(!i.dimension.enabled)return;if(i.paneAxis.outOfBounds())if(i.transition._started){i.transition.cancel();i.velocity=Math.min(e.touch[i.axis].velocity*i.velocityMultiplier,s);n.fn.start.call(i)}else i._snapBack();else{t=e.touch.id===M?0:e.touch[i.axis].velocity;i.velocity=Math.max(Math.min(t*i.velocityMultiplier,s),-s);i.tapCapture.captureNext();n.fn.start.call(i)}},tick:function(){var e=this,i=e.dimension,t=e.paneAxis.outOfBounds()?E:e.friction,n=e.velocity*=t,s=e.movable[e.axis]+n;if(!e.elastic&&i.outOfBounds(s)){s=Math.max(Math.min(s,i.max),i.min);e.velocity=0}e.movable.moveAxis(e.axis,s)},_end:function(){this.tapCapture.cancelCapture();this.end()},_snapBack:function(){var e=this,i=e.dimension,t=e.movable[e.axis]>i.max?i.max:i.min;e._moveTo(t)},_moveTo:function(e){this.transition.moveTo({location:e,duration:f,ease:h.easeOutExpo})}}),H=n.extend({init:function(e){var i=this;d.effects.Animation.fn.init.call(this);m(i,e,{origin:{},destination:{},offset:{}})},tick:function(){this._updateCoordinates();this.moveTo(this.origin)},done:function(){return v(this.offset.y)<C&&v(this.offset.x)<C},onEnd:function(){this.moveTo(this.destination);if(this.callback)this.callback.call()},setCoordinates:function(e,i){this.offset={};this.origin=e;this.destination=i},setCallback:function(e){if(e&&d.isFunction(e))this.callback=e;else e=l},_updateCoordinates:function(){this.offset={x:(this.destination.x-this.origin.x)/4,y:(this.destination.y-this.origin.y)/4};this.origin={y:this.origin.y+this.offset.y,x:this.origin.x+this.offset.x}}}),B=c.extend({init:function(e){var i=this,t=e.axis==="x",n=u('<div role="scrollbar" aria-controls="'+e.controlsId+'" class="km-touch-scrollbar km-'+(t?"horizontal":"vertical")+'-scrollbar" />');if(t)n.attr("aria-orientation","horizontal");m(i,e,{element:n,elementSize:0,movable:new x(n),scrollMovable:e.movable,alwaysVisible:e.alwaysVisible,size:t?"width":"height"});i.scrollMovable.bind(b,i.refresh.bind(i));i.container.append(n);if(e.alwaysVisible)i.show()},refresh:function(){var e=this,i=e.axis,t=e.dimension,n=t.size,s=e.scrollMovable,l=n/t.total,o=Math.round(-s[i]*l),a=Math.round(n*l);if(l>=1)this.element.css("display","none");else this.element.css("display","");if(o+a>n)a=n-o;else if(o<0){a+=o;o=0}if(e.elementSize!=a){e.element.css(e.size,a+"px");e.elementSize=a}e._ariaValue(o,t.size-e.elementSize);e.movable.moveAxis(i,o)},show:function(){this.element.css({opacity:g,visibility:"visible"})},hide:function(){if(!this.alwaysVisible)this.element.css({opacity:0})},_ariaValue:function(e,i){var t=this.element;if(e>i)e=i;t.attr("aria-valuemax",i);t.attr("aria-valuenow",e)}}),R=p.extend({init:function(e,i){var o=this;p.fn.init.call(o,e,i);e=o.element;o._native=o.options.useNative&&d.support.hasNativeScrolling;if(o._native){e.addClass("km-native-scroller").prepend('<div class="km-scroll-header"/>');m(o,{scrollElement:e,fixedContainer:e.children().first()});return}e.css("overflow","hidden").addClass("km-scroll-wrapper").wrapInner('<div class="km-scroll-container"/>').prepend('<div class="km-scroll-header"/>');var t=e.children().eq(1),n=new d.TapCapture(e),s=new x(t),a=new T({element:t,container:e,forcedEnabled:o.options.zoom}),r=this.options.avoidScrolling,c=new d.UserEvents(e,{touchAction:"pan-y",fastTap:true,allowSelection:true,preventDragEvent:true,captureUpIfMoved:true,multiTouch:o.options.zoom,supportDoubleTap:o.options.supportDoubleTap,start:function(e){a.refresh();var i=v(e.x.velocity),t=v(e.y.velocity),n=i*2>=t,s=u.contains(o.fixedContainer[0],e.event.target),l=t*2>=i;if(!s&&!r(e)&&o.enabled&&(a.x.enabled&&n||a.y.enabled&&l))c.capture();else c.cancel()}}),l=new y({movable:s,dimensions:a,userEvents:c,elastic:o.options.elastic}),h=new O({movable:s,dimensions:a,userEvents:c,tapCapture:n}),f=new H({moveTo:function(e){o.scrollTo(e.x,e.y)}});s.bind(b,function(){o.scrollTop=-s.y;o.scrollLeft=-s.x;o.trigger(z,{scrollTop:o.scrollTop,scrollLeft:o.scrollLeft})});if(o.options.mousewheelScrolling)e.on("DOMMouseScroll mousewheel",this._wheelScroll.bind(this));m(o,{movable:s,dimensions:a,zoomSnapBack:h,animatedScroller:f,userEvents:c,pane:l,tapCapture:n,pulled:false,enabled:true,scrollElement:t,scrollTop:0,scrollLeft:0,fixedContainer:e.children().first()});o._initAxis("x");o._initAxis("y");o._wheelEnd=function(){o._wheel=false;o.userEvents.end(0,o._wheelY)};a.refresh();if(o.options.pullToRefresh)o._initPullToRefresh()},_wheelScroll:function(e){if(e.ctrlKey)return;if(!this._wheel){this._wheel=true;this._wheelY=0;this.userEvents.press(0,this._wheelY)}clearTimeout(this._wheelTimeout);this._wheelTimeout=setTimeout(this._wheelEnd,50);var i=d.wheelDeltaY(e);if(i){this._wheelY+=i;this.userEvents.move(0,this._wheelY)}e.preventDefault()},makeVirtual:function(){this.dimensions.y.makeVirtual()},virtualSize:function(e,i){this.dimensions.y.virtualSize(e,i)},height:function(){return this.dimensions.y.size},scrollHeight:function(){return this.scrollElement[0].scrollHeight},scrollWidth:function(){return this.scrollElement[0].scrollWidth},options:{name:"Scroller",zoom:false,pullOffset:140,visibleScrollHints:false,elastic:true,useNative:false,mousewheelScrolling:true,avoidScrolling:function(){return false},pullToRefresh:false,messages:{pullTemplate:"Pull to refresh",releaseTemplate:"Release to refresh",refreshTemplate:"Refreshing"}},events:[k,z,S],_resize:function(){if(!this._native)this.contentResized()},setOptions:function(e){var i=this;p.fn.setOptions.call(i,e);if(e.pullToRefresh)i._initPullToRefresh()},reset:function(){if(this._native)this.scrollElement.scrollTop(0);else{this.movable.moveTo({x:0,y:0});this._scale(1)}},contentResized:function(){this.dimensions.refresh();if(this.pane.x.outOfBounds())this.movable.moveAxis("x",this.dimensions.x.min);if(this.pane.y.outOfBounds())this.movable.moveAxis("y",this.dimensions.y.min)},zoomOut:function(){var e=this.dimensions;e.refresh();this._scale(e.fitScale);this.movable.moveTo(e.centerCoordinates())},enable:function(){this.enabled=true},disable:function(){this.enabled=false},scrollTo:function(e,i){if(this._native){d.scrollLeft(this.scrollElement,v(e));this.scrollElement.scrollTop(v(i))}else{this.dimensions.refresh();this.movable.moveTo({x:e,y:i})}},animatedScrollTo:function(e,i,t){var n,s;if(this._native)this.scrollTo(e,i);else{n={x:this.movable.x,y:this.movable.y};s={x:e,y:i};this.animatedScroller.setCoordinates(n,s);this.animatedScroller.setCallback(t);this.animatedScroller.start()}},pullHandled:function(){var e=this;e.refreshHint.removeClass(t);e.hintContainer.html(e.pullTemplate({}));e.yinertia.onEnd();e.xinertia.onEnd();e.userEvents.cancel()},destroy:function(){p.fn.destroy.call(this);if(this.userEvents)this.userEvents.destroy()},_scale:function(e){this.dimensions.rescale(e);this.movable.scaleTo(e)},_initPullToRefresh:function(){var e=this;e.dimensions.y.forceEnabled();e.pullTemplate=d.template(e.options.messages.pullTemplate);e.releaseTemplate=d.template(e.options.messages.releaseTemplate);e.refreshTemplate=d.template(e.options.messages.refreshTemplate);e.scrollElement.prepend('<span class="km-scroller-pull"><span class="km-icon"></span><span class="km-loading-left"></span><span class="km-loading-right"></span><span class="km-template">'+e.pullTemplate({})+"</span></span>");e.refreshHint=e.scrollElement.children().first();e.hintContainer=e.refreshHint.children(".km-template");e.pane.y.bind("change",e._paneChange.bind(e));e.userEvents.bind("end",e._dragEnd.bind(e))},_dragEnd:function(){var e=this;if(!e.pulled)return;e.pulled=false;e.refreshHint.removeClass(i).addClass(t);e.hintContainer.html(e.refreshTemplate({}));e.yinertia.freeze(e.options.pullOffset/2);e.trigger("pull")},_paneChange:function(){var e=this;if(e.movable.y/E>e.options.pullOffset){if(!e.pulled){e.pulled=true;e.refreshHint.removeClass(t).addClass(i);e.hintContainer.html(e.releaseTemplate({}))}}else if(e.pulled){e.pulled=false;e.refreshHint.removeClass(i);e.hintContainer.html(e.pullTemplate({}))}},_initAxis:function(e){var i=this,t=i.element.attr("id"),n=i.movable,s=i.dimensions[e],l=i.tapCapture,o=i.pane[e],a;if(!t){t=d.guid();i.element.attr("id",t)}a=new B({axis:e,movable:n,dimension:s,container:i.element,alwaysVisible:i.options.visibleScrollHints,controlsId:t});s.bind(b,function(){a.refresh()});o.bind(b,function(){a.show()});i[e+"inertia"]=new A({axis:e,paneAxis:o,movable:n,tapCapture:l,userEvents:i.userEvents,dimension:s,elastic:i.options.elastic,friction:i.options.friction||w,velocityMultiplier:i.options.velocityMultiplier||_,end:function(){a.hide();i.trigger("scrollEnd",{axis:e,scrollTop:i.scrollTop,scrollLeft:i.scrollLeft})}})}});return r.plugin(R),window.kendo})}("function"==typeof define&&define.amd?define:function(e,i,t){(t||i)()});
//# sourceMappingURL=kendo.mobile.scroller.min.js.map
