/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.numerictextbox.min",["kendo.core.min","kendo.userevents.min","kendo.floatinglabel.min","kendo.html.button.min"],function(){var e={id:"numerictextbox",name:"NumericTextBox",category:"web",description:"The NumericTextBox widget can format and display numeric, percentage or currency textbox.",depends:["core","userevents","floatinglabel","html.button"]},d=window.kendo.jQuery,p=void 0,f=window.kendo,c=f.caret,a=f.keys,r=f.html,t=f.ui,_=t.Widget,o=f._activeElement,x=f._extractFormat,i=f.parseFloat,s=f.support.placeholder,l=f.getCulture,n="change",u="disabled",b="readonly",g="k-input-inner",w="spin",m=".kendoNumericTextBox",y="touchend",k,T="mouseenter"+m+" "+("mouseleave"+m),C="k-focus",A="k-hover",E="focus",v=".",L="symbol",H="k-icon",S="k-label k-input-label",F="k-selected",O="k-disabled",I="k-invalid",P="aria-disabled",D=/^(-)?(\d*)$/,h=null,N=d.isPlainObject,B=d.extend,R=_.extend({init:function(e,t){var n=this,a=t&&t.step!==p,i,r,o,s,l;var u;_.fn.init.call(n,e,t);t=n.options;e=n.element.on("focusout"+m,n._focusout.bind(n)).attr("role","spinbutton");t.placeholder=t.placeholder||e.attr("placeholder");i=n.min(e.attr("min"));r=n.max(e.attr("max"));o=n._parse(e.attr("step"));if(t.min===h&&i!==h)t.min=i;if(t.max===h&&r!==h)t.max=r;if(!a&&o!==h)t.step=o;n._initialOptions=B({},t);u=e.attr("type");n._reset();n._wrapper();n._arrows();n._validation();n._input();if(!f.support.mobileOS)n._text.on(E+m,n._click.bind(n));else n._text.on(y+m+" "+E+m,function(){if(f.support.browser.edge)n._text.one(E+m,function(){n._focusin()});else n._focusin();n.selectValue()});e.attr("aria-valuemin",t.min!==h?t.min*t.factor:t.min).attr("aria-valuemax",t.max!==h?t.max*t.factor:t.max);t.format=x(t.format);s=t.value;if(s==h)if(u=="number")s=parseFloat(e.val());else s=e.val();n.value(s);l=!t.enable||e.is("[disabled]")||d(n.element).parents("fieldset").is(":disabled");if(l)n.enable(false);else n.readonly(e.is("[readonly]"));n.angular("compile",function(){return{elements:n._text.get()}});n._label();n._ariaLabel(n._text);n._applyCssClasses();f.notify(n)},options:{name:"NumericTextBox",decimals:h,enable:true,restrictDecimals:false,min:h,max:h,value:h,step:1,round:true,culture:"",format:"n",spinners:true,placeholder:"",selectOnFocus:false,factor:1,upArrowText:"Increase value",downArrowText:"Decrease value",label:null,size:"medium",fillMode:"solid",rounded:"medium"},events:[n,w],_editable:function(e){var t=this,n=t.element,a=e.disable,i=e.readonly,r=t._text.add(n),o=t.wrapper.off(T);t._toggleText(true);t._upArrowEventHandler.unbind("press");t._downArrowEventHandler.unbind("press");n.off("keydown"+m).off("keyup"+m).off("input"+m).off("paste"+m);if(t._inputLabel)t._inputLabel.off(m);if(!i&&!a){o.removeClass(O).on(T,t._toggleHover);r.prop(u,false).prop(b,false).attr(P,false);t._upArrowEventHandler.bind("press",function(e){e.preventDefault();t._spin(1);t._upArrow.addClass(F)});t._downArrowEventHandler.bind("press",function(e){e.preventDefault();t._spin(-1);t._downArrow.addClass(F)});t.element.on("keydown"+m,t._keydown.bind(t)).on("keyup"+m,t._keyup.bind(t)).on("paste"+m,t._paste.bind(t)).on("input"+m,t._inputHandler.bind(t));if(t._inputLabel)t._inputLabel.on("click"+m,t.focus.bind(t))}else{o.addClass(a?O:"").removeClass(a?"":O);r.attr(u,a).attr(b,i).attr(P,a)}},readonly:function(e){var t=this;this._editable({readonly:e===p?true:e,disable:false});if(t.floatingLabel)t.floatingLabel.readonly(e===p?true:e)},enable:function(e){var t=this;this._editable({readonly:false,disable:!(e=e===p?true:e)});if(t.floatingLabel)t.floatingLabel.enable(e=e===p?true:e)},setOptions:function(e){var t=this;_.fn.setOptions.call(t,e);t.wrapper.toggleClass("k-expand-padding",!t.options.spinners);t._text.prop("placeholder",t.options.placeholder);t._placeholder(t.options.placeholder);t.element.attr({"aria-valuemin":t.options.min!==h?t.options.min*t.options.factor:t.options.min,"aria-valuemax":t.options.max!==h?t.options.max*t.options.factor:t.options.max});t.options.format=x(t.options.format);t._upArrowEventHandler.destroy();t._downArrowEventHandler.destroy();t._arrowsWrap.remove();t._arrows();t._applyCssClasses();if(e.value!==p)t.value(e.value)},destroy:function(){var e=this;if(e._inputLabel){e._inputLabel.off(m);if(e.floatingLabel)e.floatingLabel.destroy()}e.element.add(e._text).add(e._upArrow).add(e._downArrow).off(m);e._upArrowEventHandler.destroy();e._downArrowEventHandler.destroy();if(e._form)e._form.off("reset",e._resetHandler);_.fn.destroy.call(e)},min:function(e){return this._option("min",e)},max:function(e){return this._option("max",e)},step:function(e){return this._option("step",e)},value:function(e){var t=this,n;if(e===p)return t._value;e=t._parse(e);n=t._adjust(e);if(e!==n)return;t._update(e);t._old=t._value},focus:function(){this._focusin()},_adjust:function(e){var t=this,n=t.options,a=n.min,i=n.max;if(e===h)return e;if(a!==h&&e<a)e=a;else if(i!==h&&e>i)e=i;return e},_arrows:function(){var e=this,t,n=function(){clearTimeout(e._spinning);t.removeClass(F)},a=e.options,i=a.spinners,r=e.element;t=r.siblings(".k-icon-button");if(!t[0]){t=d(j("increase",a.upArrowText,a)+j("decrease",a.downArrowText,a)).appendTo(e.wrapper);e._arrowsWrap=t.wrapAll('<span class="k-input-spinner k-spin-button"/>').parent()}if(!i){t.parent().toggle(i);e.wrapper.addClass("k-expand-padding")}e._upArrow=t.eq(0);e._upArrowEventHandler=new f.UserEvents(e._upArrow,{release:n});e._downArrow=t.eq(1);e._downArrowEventHandler=new f.UserEvents(e._downArrow,{release:n})},_validation:function(){var e=this;var t=e.element;e._validationIcon=d("<span class='k-input-validation-icon "+H+" k-i-warning k-hidden'></span>").insertAfter(t)},_blur:function(){var e=this;e._toggleText(true);e._change(e.element.val())},_click:function(u){var d=this;clearTimeout(d._focusing);d._focusing=setTimeout(function(){var e=u.target,t=c(e)[0],n=e.value.substring(0,t),a=d._format(d.options.format),i=a[","],r,o,s,l=0;if(i){o=new RegExp("\\"+i,"g");s=new RegExp("(-)?("+a[L]+")?([\\d\\"+i+"]+)(\\"+a[v]+")?(\\d+)?")}if(s)r=s.exec(n);if(r){l=r[0].replace(o,"").length;if(n.indexOf("(")!=-1&&d._value<0)l++}d._focusin();c(d.element[0],l);d.selectValue()})},selectValue:function(){if(this.options.selectOnFocus)this.element[0].select()},_getFactorValue:function(e){var t=this,n=t.options.factor;if(n&&n!==1){e=f.parseFloat(e);if(e!==null)e=e/n}return e},_change:function(e){var t=this;e=t._getFactorValue(e);t._update(e);e=t._value;if(t._old!=e){t._old=e;if(!t._typing)t.element.trigger(n);t.trigger(n)}t._typing=false},_culture:function(e){return e||l(this.options.culture)},_focusin:function(){var e=this;e.wrapper.addClass(C);e._toggleText(false);e.element[0].focus()},_focusout:function(){var e=this;clearTimeout(e._focusing);e.wrapper.removeClass(C).removeClass(A);e._blur();e._removeInvalidState()},_format:function(e,t){var n=this._culture(t).numberFormat;e=e.toLowerCase();if(e.indexOf("c")>-1)n=n.currency;else if(e.indexOf("p")>-1)n=n.percent;return n},_input:function(){var e=this,t=e.options,n=e.element.addClass(g).show()[0],a=n.accessKey,i=e.wrapper,r=i.find(v+g),o;o=r.first();if(o.length<2)o=d('<input type="text"/>').attr(f.attr("validate"),false).insertBefore(n);try{n.setAttribute("type","text")}catch(e){n.type="text"}o[0].title=n.title;o[0].tabIndex=n.tabIndex;o[0].style.cssText=n.style.cssText;o.prop("placeholder",t.placeholder);if(a){o.attr("accesskey",a);n.accessKey=""}e._text=o.addClass(n.className).attr({role:"spinbutton","aria-valuemin":t.min!==h?t.min*t.factor:t.min,"aria-valuemax":t.max!==h?t.max*t.factor:t.max,autocomplete:"off"})},_keydown:function(e){var t=this,n=e.keyCode;if(n===a.NUMPAD_DOT)t._numPadDot=true;if(n==a.DOWN){t._step(-1);return}else if(n==a.UP){t._step(1);return}else if(n==a.ENTER){t._change(t.element.val());return}if(n!=a.TAB)t._typing=true;t._cachedCaret=c(t.element)},_keyup:function(){this._removeInvalidState()},_inputHandler:function(){var e=this.element;var t=e.val();var n=this.options.min;var a=this._format(this.options.format);var i=a[v];var r=n!==null&&n>=0&&t.charAt(0)==="-";if(this._numPadDot&&i!==v){t=t.replace(v,i);this.element.val(t);this._numPadDot=false}if(this._isPasted&&this._parse(t))t=this._parse(t).toString().replace(v,a[v]);if(this._numericRegex(a).test(t)&&!r)this._oldText=t;else{this._blinkInvalidState();this.element.val(this._oldText);if(this._cachedCaret){c(e,this._cachedCaret[0]);this._cachedCaret=null}}this._isPasted=false},_blinkInvalidState:function(){var e=this;e._addInvalidState();clearTimeout(e._invalidStateTimeout);e._invalidStateTimeout=setTimeout(e._removeInvalidState.bind(e),100)},_addInvalidState:function(){var e=this;e.wrapper.addClass(I);e._validationIcon.removeClass("k-hidden")},_removeInvalidState:function(){var e=this;e.wrapper.removeClass(I);e._validationIcon.addClass("k-hidden");e._invalidStateTimeout=null},_numericRegex:function(e){var t=this;var n=e[v];var a=t.options.decimals;var i="*";if(n===v)n="\\"+n;if(a===h)a=e.decimals;if(a===0&&t.options.restrictDecimals)return D;if(t.options.restrictDecimals)i="{0,"+a+"}";if(t._separator!==n){t._separator=n;t._floatRegExp=new RegExp("^(-)?(((\\d+("+n+"\\d"+i+")?)|("+n+"\\d"+i+")))?$")}return t._floatRegExp},_paste:function(e){var t=this;var n=e.target;var a=n.value;var i=t._format(t.options.format);t._isPasted=true;setTimeout(function(){var e=t._parse(n.value);if(e===h)t._update(a);else{n.value=e.toString().replace(v,i[v]);if(t._adjust(e)!==e||!t._numericRegex(i).test(n.value)){a=t._getFactorValue(n.value);t._update(a)}}})},_option:function(e,t){var n=this,a=n.element,i=n.options;if(t===p)return i[e];t=n._parse(t);if(!t&&e==="step")return;i[e]=t;a.add(n._text).attr("aria-value"+e,t);a.attr(e,t)},_spin:function(e,t){var n=this;t=t||500;clearTimeout(n._spinning);n._spinning=setTimeout(function(){n._spin(e,50)},t);n._step(e)},_step:function(e){var t=this,n=t.element,a=t._value,i=t._parse(n.val())||0,r=t.options.decimals||2;if(o()!=n[0])t._focusin();if(t.options.factor&&i)i=i/t.options.factor;i=+(i+t.options.step*e).toFixed(r);i=t._adjust(i);t._update(i);t._typing=false;if(a!==i)t.trigger(w)},_toggleHover:function(e){d(e.currentTarget).toggleClass(A,e.type==="mouseenter")},_toggleText:function(e){var t=this;t._text.toggle(e);if(e)t._text.removeAttr("aria-hidden");else t._text.attr("aria-hidden","true");t.element.toggle(!e)},_parse:function(e,t){return i(e,this._culture(t),this.options.format)},_round:function(e,t){var n=this.options.round?f._round:V;return n(e,t)},_update:function(e){var t=this,n=t.options,a=n.factor,i=n.format,r=n.decimals,o=t._culture(),s=t._format(i,o),l,u;if(r===h)r=s.decimals;e=t._parse(e,o);u=e!==h;if(u)e=parseFloat(t._round(e,r),10);t._value=e=t._adjust(e);t._placeholder(f.toString(e,i,o));if(u){if(a)e=parseFloat(t._round(e*a,r),10);e=e.toString();if(e.indexOf("e")!==-1)e=t._round(+e,r);l=e;e=e.replace(v,s[v])}else{e=null;l=null}t.element.val(e);t._oldText=e;t.element.add(t._text).attr("aria-valuenow",l)},_placeholder:function(e){var t=this._text;t.val(e);if(!s&&!e)t.val(this.options.placeholder);t.attr("title",this.element.attr("title")||t.val())},_label:function(){var e=this;var t=e.element;var n=e.options;var a=t.attr("id");var i;var r;if(n.label!==null){i=N(n.label)?n.label.floating:false;r=N(n.label)?n.label.content:n.label;if(i){e._floatingLabelContainer=e.wrapper.wrap("<span></span>").parent();e.floatingLabel=new f.ui.FloatingLabel(e._floatingLabelContainer,{widget:e})}if(f.isFunction(r))r=r.call(e);if(!r)r="";if(!a){a=n.name+"_"+f.guid();t.attr("id",a)}e._inputLabel=d("<label class='"+S+"' for='"+a+"'>"+r+"</label>'").insertBefore(e.wrapper);if(e.element.attr("disabled")===p&&e.element.attr("readonly")===p)e._inputLabel.on("click"+m,e.focus.bind(e))}},_wrapper:function(){var e=this,t=e.element,n=t[0],a;a=t.parents(".k-numerictextbox");if(!a.is("span.k-numerictextbox"))a=t.hide().wrap("<span/>").parent();a[0].style.cssText=n.style.cssText;n.style.width="";e.wrapper=a.addClass("k-numerictextbox k-input").addClass(n.className).removeClass("input-validation-error").css("display","")},_reset:function(){var e=this,t=e.element,n=t.attr("form"),a=n?d("#"+n):t.closest("form");if(a[0]){e._resetHandler=function(){setTimeout(function(){e.value(t[0].value);e.max(e._initialOptions.max);e.min(e._initialOptions.min)})};e._form=a.on("reset",e._resetHandler)}}});function j(e,t,n){var a=e==="increase"?"arrow-n":"arrow-s";var i=e==="increase"?"increase":"decrease";return r.renderButton('<button role="button" tabindex="-1" unselectable="on" class="k-spinner-'+i+'" aria-label="'+t+'" title="'+t+'"></button>',B({},n,{icon:a,shape:null,rounded:null}))}function V(e,t){var n=parseFloat(e,10).toString().split(v);if(n[1])n[1]=n[1].substring(0,t);return n.join(v)}return f.cssProperties.registerPrefix("NumericTextBox","k-input-"),f.cssProperties.registerValues("NumericTextBox",[{prop:"rounded",values:f.cssProperties.roundedValues.concat([["full","full"]])}]),t.plugin(R),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,n){(n||t)()});
//# sourceMappingURL=kendo.numerictextbox.min.js.map
