/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.upload.min",["kendo.core.min"],function(){var e={id:"upload",name:"Upload",category:"web",description:"The Upload widget uses progressive enhancement to deliver the best possible uploading experience to users.",depends:["core"]},u=window.kendo.jQuery,a=void 0,f=window.kendo,n=f.ui.Widget,v=f.antiForgeryTokens,m=f.logToConsole,t=/\.([^\.]+)$/,s=".kendoUpload",k="select",g="upload",_="success",y="error",i="complete",p="cancel",r="clear",F="pause",w="resume",C="progress",c="remove",d="validationErrors",b="invalidMaxFileSize",S="invalidMinFileSize",z="invalidFileExtension",U=1e3,E=2e3,l="k-focus",o="tabindex",A={loading:"k-i-upload",warning:"k-i-warning",success:"k-i-check"},D=n.extend({init:function(e,a){var t=this;n.fn.init.call(t,e,a);t.name=e.name;t.multiple=t.options.multiple;t.directory=t.options.directory;t.localization=t.options.localization;var i=t.element;t.wrapper=i.closest(".k-upload");if(t.wrapper.length===0)t.wrapper=t._wrapInput(i);t._activeInput(i);t.toggle(t.options.enabled);var r=t._ns=s+"-"+f.guid();i.closest("form").on("submit"+r,t._onParentFormSubmit.bind(t)).on("reset"+r,t._onParentFormReset.bind(t));t._initUploadModule();t._toggleDropZone();t.wrapper.on("click",".k-upload-action",t._onFileAction.bind(t)).on("click",".k-clear-selected",t._onClearSelected.bind(t)).on("click",".k-upload-selected",t._onUploadSelected.bind(t)).on("keydown",t._onKeyDown.bind(t)).on("focusout",t._focusout.bind(t));if(t.element.val())t._onInputChange({target:t.element})},events:[k,g,_,y,i,p,r,C,c,F,w],options:{name:"Upload",enabled:true,multiple:true,directory:false,showFileList:true,template:"",files:[],async:{autoRetryAfter:0,bufferChunkSize:1e7,maxAutoRetries:1,removeVerb:"POST",autoUpload:true,withCredentials:true,accept:"*/*; q=0.5, application/json",useArrayBuffer:false},localization:{select:"Select files...",cancel:"Cancel",retry:"Retry",remove:"Remove",pause:"Pause",resume:"Resume",clearSelectedFiles:"Clear",uploadSelectedFiles:"Upload",dropFilesHere:"Drop files here to upload",invalidFiles:"Invalid file(s). Please check file upload requirements.",statusUploading:"uploading",statusUploaded:"uploaded",statusWarning:"warning",statusFailed:"failed",headerStatusUploading:"Uploading...",headerStatusPaused:"Paused",headerStatusUploaded:"Done",uploadSuccess:"File(s) uploaded successfully.",uploadFail:"File(s) failed to upload.",invalidMaxFileSize:"File size too large.",invalidMinFileSize:"File size too small.",invalidFileExtension:"File type not allowed."},validation:{allowedExtensions:[],maxFileSize:0,minFileSize:0},dropZone:""},_initUploadModule:function(){var e=this,a=e.options;if(a.async.saveUrl){e._module=e._supportsFormData()?new P(e):new R(e);e._async=true;var t=a.files;if(t.length>0)e._renderInitialFiles(t)}else e._module=new x(e)},setOptions:function(e){var a=this,t=a.element;u(a.options.dropZone).off(a._ns);n.fn.setOptions.call(a,e);a.multiple=a.options.multiple;a.directory=a.options.directory;t.attr("multiple",a._supportsMultiple()?a.multiple:false);if(a.directory){t.attr("webkitdirectory",a.directory);t.attr("directory",a.directory)}a.toggle(a.options.enabled);a._initUploadModule();a._toggleDropZone()},enable:function(e){e=typeof e==="undefined"?true:e;this.toggle(e)},disable:function(){this.toggle(false)},toggle:function(e){e=typeof e==="undefined"?e:!e;this.wrapper.toggleClass("k-disabled",e);this.element.prop("disabled",e)},focus:function(){this.element.trigger("focus")},destroy:function(){var e=this;var a=u(e.options.dropZone);u(document).add(u(".k-dropzone",e.wrapper)).add(e.wrapper.closest("form")).off(e._ns);if(a.length>0)a.off(e._ns);u(e.element).off(s);n.fn.destroy.call(e)},pause:function(e){this._module.onPause({target:u(e,this.wrapper)});var a=e.find(".k-i-pause-sm");a.removeClass("k-i-pause-sm").addClass("k-i-play-sm").attr("title",this.localization.resume);u(a).parent().attr("aria-label",this.localization.resume)},resume:function(e){this._module.onResume({target:u(e,this.wrapper)});var a=e.find(".k-i-play-sm");a.removeClass("k-i-play-sm").addClass("k-i-pause-sm").attr("title",this.localization.pause);u(a).parent().attr("aria-label",this.localization.pause)},upload:function(){var e=this;e._module.onSaveSelected()},getFiles:function(){var e=this;var a;var t=[];var i=e.wrapper.find(".k-file");for(var r=0;r<i.length;r++){a=u(i[r]).data("fileNames");if(a)for(var n=0;n<a.length;n++)t.push(a[n])}return t},clearAllFiles:function(){var t=this;var e=t.wrapper.find(".k-file");e.each(function(e,a){t._removeFileByDomElement(a,false)})},removeAllFiles:function(){var t=this;var e=t.wrapper.find(".k-file");e.each(function(e,a){t._removeFileByDomElement(a,true)})},removeFileByUid:function(e){this._removeFileByUid(e,true)},clearFileByUid:function(e){this._removeFileByUid(e,false)},_removeFileByUid:function(e,a){var t=this;var i;if(typeof e!=="string")return;i=u(".k-file["+f.attr("uid")+'="'+e+'"]',t.wrapper);if(i.length>0)t._removeFileByDomElement(i,a)},clearFile:function(e){this._removeFile(e,false)},removeFile:function(e){this._removeFile(e,true)},_removeFile:function(t,i){var r=this;var e=r.wrapper.find(".k-file");var n;if(typeof t==="function")e.each(function(e,a){n=u(a).data("fileNames");if(t(n))r._removeFileByDomElement(a,i)})},_removeFileByDomElement:function(e,a){var t=this;var i={target:u(e,t.wrapper)};var r;if(t.options.async.saveUrl){if(u(e).hasClass("k-file-progress"))t._module.onCancel(i);else t._module.onRemove(i,{},a);r=u(".k-file",t.wrapper);if(r.length===0)t._hideHeaderUploadstatus();else t._updateHeaderUploadStatus()}else t._module.onRemove(i,{},a)},_addInput:function(e){if(!e[0].nodeType)return;var a=this,t=e.clone().val("");t.insertAfter(a.element).data("kendo"+a.options.prefix+a.options.name,a);u(a.element).hide().attr(o,"-1").removeAttr("id").off(s);a._activeInput(t);a.element.trigger("focus")},_activeInput:function(e){var a=this,t=a.wrapper;a.element=e;if(a.directory){e.attr("webkitdirectory",a.directory);e.attr("directory",a.directory)}e.attr("multiple",a._supportsMultiple()?a.multiple:false).attr("autocomplete","off").on("click"+s,function(e){if(t.hasClass("k-disabled"))e.preventDefault()}).on("focus"+s,function(){u(this).parent().addClass(l)}).on("blur"+s,function(){u(this).parent().removeClass(l)}).on("change"+s,a._onInputChange.bind(a))},_adjustFocusState:function(e,a){e.removeClass(l);e.attr(o,-1);a.addClass(l);a.attr(o,0)},_arrowKeyNavigation:function(e,a,t){var i=this,r=f.keys,n;if(a===r.DOWN){e.preventDefault();e.stopPropagation();n=i.wrapper.find(".k-upload-files .k-file").first();if(t.length>0){if(t.hasClass("k-upload-action")){t.removeClass(l);t=t.closest(".k-file")}n=t.next()}i._adjustFocusState(t,n);if(!n||n.length===0)n=i.wrapper.find(".k-clear-selected")}else if(a===r.UP){e.preventDefault();e.stopPropagation();n=i.wrapper.find(".k-upload-files .k-file:last");if(t.length>0){if(t.hasClass("k-upload-action")){t.removeClass(l);t=t.closest(".k-file")}n=t.prev()}i._adjustFocusState(t,n)}else if(a===r.RIGHT){if(t.hasClass("k-upload-action")){n=t.next(".k-upload-action");if(!n||n.length===0)n=t.parent().find(".k-upload-action:first")}else if(t.length>0)n=t.find(".k-upload-action:first");if(n&&n.length>0){t.removeClass(l);n.addClass(l)}}else if(a===r.LEFT){if(t.hasClass("k-upload-action")){n=t.prev(".k-upload-action");if(!n||n.length===0)n=t.parent().find(".k-upload-action:last")}else if(t.length>0)n=t.find(".k-upload-action:last");if(n&&n.length>0){t.removeClass(l);n.addClass(l)}}if((!n||n.length===0)&&(a===r.UP||a===r.DOWN))n=i.element;if(n&&n.length>0){i._preventFocusRemove=true;n.trigger("focus")}},_asyncCommandKeyNavigation:function(e,a,t){var i=this,r=f.keys,n=u(a,i.wrapper);i._retryClicked=false;if(e===r.ESC&&a.find(".k-i-cancel").length>0){i.trigger(p,t);i._module.onCancel({target:n});i._checkAllComplete();i._updateHeaderUploadStatus();i._preventFocusRemove=true;i.element.trigger("focus")}else if(e===r.SPACEBAR){if(a.find(".k-i-pause-sm").length>0){i.trigger(F,t);i.pause(a);i._updateHeaderUploadStatus()}else if(a.find(".k-i-play-sm").length>0){i.trigger(w,t);i.resume(a)}}else if(e===r.ENTER&&!a.is(".k-file-progress, .k-file-success, .k-file-invalid")){if(i.options.async.chunkSize&&!i.options.async.concurrent&&u(".k-file-progress",i.wrapper).length>0)return;u(".k-i-warning",a).remove();u(".k-progressbar",a).finish().show();if(!i._module.metaData[n.data("uid")])i._module.prepareChunk(n);i._module.onRetry({target:n});i._retryClicked=true}},_commandKeyNavigation:function(e,a){var t=this,i=f.keys,r=a.data("fileNames"),n=t._filesContainValidationErrors(r),s={files:r,headers:{}};if(e===i.DELETE){if(!t.trigger(c,s)){t._module.onRemove({target:u(a,t.wrapper)},s,!n);t._preventFocusRemove=true;t.element.trigger("focus")}}else if(e===i.TAB){a.removeClass(l);a.attr(o,-1)}else if(!!t.options.async.saveUrl)t._asyncCommandKeyNavigation(e,a,s)},_focusout:function(){var e=this.wrapper.find(".k-upload-files .k-file."+l);if(!this._preventFocusRemove){e.removeClass(l);e.attr(o,-1)}else this._preventFocusRemove=false},_onKeyDown:function(e){var a=this,t=a.wrapper.find(".k-upload-files .k-file."+l+","+".k-upload-action."+l),i=f.keys,r=[i.DELETE,i.ESC,i.ENTER,i.SPACEBAR,i.TAB],n=e.keyCode;if(n===i.DOWN||n===i.UP||n===i.LEFT||n===i.RIGHT)a._arrowKeyNavigation(e,n,t);else if(t.length>0&&t.hasClass("k-file")&&r.indexOf(n)>-1&&!a.wrapper.hasClass("k-disabled")){if(n===i.SPACEBAR){e.preventDefault();e.stopPropagation()}a._commandKeyNavigation(n,t)}},_onInputChange:function(e){var a=this;var t=u(e.target);var i=M(a._inputFiles(t),a._isAsyncNonBatch());L(i,a.options.validation);var r=a.trigger(k,{files:i});if(r){a._addInput(t);t.remove()}else a._module.onSelect({target:t},i)},_readDirectory:function(e){var a=new u.Deferred;var t=e.createReader();var i=[];var r=function(){t.readEntries(function(e){if(!e.length)a.resolve(i);else{i=i.concat(e);r()}},a.reject)};r();return a.promise()},_readFile:function(e){var a=this;var t=e.fullPath;e.file(function(e){e.relativePath=t.slice(1);a.droppedFolderFiles.push(e);a.droppedFolderCounter--;if(a.droppedFolderCounter===0)setTimeout(function(){if(a.droppedFolderCounter===0)if(a.droppedFolderFiles.length){a._proceedDroppedItems(a.droppedFolderFiles);a.droppedFolderFiles=[]}},0)},function(){m("File error.")})},_traverseFileTree:function(e,a){var t=this;if(!a)t.droppedFolderCounter--;this._readDirectory(e).then(function(e){t.droppedFolderCounter+=e.length;for(var a=0;a<e.length;a++)if(e[a].isFile)t._readFile(e[a]);else if(e[a].isDirectory)t._traverseFileTree(e[a])})},_onDrop:function(e){var a=e.originalEvent.dataTransfer;var t=this;var i=a.files;var r;J(e);if(t.options.directoryDrop&&a.items){r=a.items.length;t.droppedFolderCounter=0;t.droppedFolderFiles=[];for(var n=0;n<r;n++)if(a.items[n].webkitGetAsEntry){var s=a.items[n].webkitGetAsEntry();if(s.isDirectory)t._traverseFileTree(s,true);else if(s.isFile)t.droppedFolderFiles.push(a.files[n])}else t._proceedDroppedItems(i)}else t._proceedDroppedItems(i)},_proceedDroppedItems:function(e){var a=this;var t=M(I(e),a._isAsyncNonBatch());if(e.length>0&&!a.wrapper.hasClass("k-disabled")){if(!a.multiple&&t.length>1)t.splice(1,t.length-1);L(t,a.options.validation);var i=a.trigger(k,{files:t});if(!i)a._module.onSelect({target:u(".k-dropzone",a.wrapper)},t)}},_filesContainValidationErrors:function(e){var t=false;u(e).each(function(e,a){if(a[d]&&a[d].length>0){t=true;return false}});return t},_isAsyncNonBatch:function(){return this._async&&!this.options.async.batch||false},_renderInitialFiles:function(e){var a=this;var t=0;e=M(e,true);for(t=0;t<e.length;t++){var i=e[t];var r=a._enqueueFile(i.name,{fileNames:[i]});r.addClass("k-file-success").data("files",[e[t]]);if(a._supportsRemove())a._fileAction(r,c)}},_prepareTemplateData:function(e,a){var t=a.fileNames,i={},r=0,n=0;for(n=0;n<t.length;n++)r+=t[n].size;i.name=e;i.size=r;i.files=a.fileNames;return i},_prepareDefaultSingleFileEntryTemplate:function(e){var a=this;var t=e.fileNames[0];var i=V(e.fileNames);var r=f.getFileGroup(t.extension,true);var n=t[d];var s="";if(n&&n.length>0)s+="<li class='k-file k-file-invalid'><div class='k-progressbar k-hidden'><span class='k-progress'></span></div>"+"<span class='k-file-invalid-group-wrapper'>"+"<span class='k-file-group k-icon k-i-"+r+"'></span>"+"<span class='k-file-state'></span>"+"</span>"+"<span class='k-file-name-size-wrapper'>"+"<span class='k-file-name k-file-name-invalid' title='"+t.name+"'>"+t.name+"</span>"+"<span class='k-file-validation-message k-text-error'>"+a.localization[n[0]]+"</span>"+"</span>";else s+="<li class='k-file'><div class='k-progressbar k-hidden'><span class='k-progress'></span></div>"+"<span class='k-file-group-wrapper'>"+"<span class='k-file-group k-icon k-i-"+r+"'></span>"+"<span class='k-file-state'></span>"+"</span>"+"<span class='k-file-name-size-wrapper'><span class='k-file-name' title='"+t.name+"'>"+t.name+"</span>"+"<span class='k-file-size'>"+i+"</span></span>";s+="<strong class='k-upload-status'></strong>";return u(s)},_prepareDefaultMultipleFileEntriesTemplate:function(e){var a=this;var t=e.fileNames;var i=a._filesContainValidationErrors(t);var r=V(t);var n="";var s,o;if(i)n+="<li class='k-file k-file-invalid'><div class='k-progressbar k-hidden'><span class='k-progress'></span></div>"+"<span class='k-multiple-files-invalid-group-wrapper'>"+"<span class='k-file-group k-icon k-i-files'></span>";else n+="<li class='k-file'><div class='k-progressbar k-hidden'><span class='k-progress'></span></div>"+"<span class='k-multiple-files-group-wrapper'>"+"<span class='k-file-group k-icon k-i-files'></span>";n+="<span class='k-file-state'></span></span>";t.sort(function(e,a){if(e[d])return-1;if(a[d])return 1;return 0});n+="<span class='k-multiple-files-wrapper'>";for(s=0;s<t.length;s++){o=t[s];var l=V([o]);n+="<span class='k-file-name-size-wrapper'>";if(o[d]&&o[d].length>0)n+="<span class='k-file-name k-file-name-invalid' title='"+o.name+"'>"+o.name+"</span>";else n+="<span class='k-file-name' title='"+o.name+"'>"+o.name+"</span>";n+="<span class='k-file-size'>"+l+"</span></span>"}if(i)n+="<span class='k-file-validation-message k-text-error'>"+a.localization.invalidFiles+"</span>";else n+="<span class='k-file-information'>Total: "+t.length+" files, "+r+"</span>";n+="</span><strong class='k-upload-status'></strong>";return u(n)},_enqueueFile:function(e,a){var t=this;var i;var r;var n=a.fileNames[0].uid;var s=u(".k-upload-files",t.wrapper);var p=t.options;var o=p.template;var l;var d;if(s.length===0){s=u("<ul class='k-upload-files k-reset'></ul>").appendTo(t.wrapper);if(!t.options.showFileList)s.hide();t.wrapper.removeClass("k-upload-empty")}i=u(".k-file",s);if(!o)if(a.fileNames.length===1)r=t._prepareDefaultSingleFileEntryTemplate(a);else r=t._prepareDefaultMultipleFileEntriesTemplate(a);else{l=t._prepareTemplateData(e,a);o=f.template(o);r=u("<li class='k-file'>"+o(l)+"</li>");r.find(".k-upload-action").addClass("k-button k-icon-button k-button-md k-rounded-md k-button-flat k-button-flat-base");t.angular("compile",function(){return{elements:r,data:[l]}})}r.attr(f.attr("uid"),n).appendTo(s).data(a);if(!t._async)u(".k-progress",r).width("100%");if(!t.multiple&&i.length>0){d={files:i.data("fileNames"),headers:{}};if(!t.trigger(c,d))t._module.onRemove({target:u(i,t.wrapper)},d)}return r},_removeFileEntry:function(e){var a=this;var t=e.closest(".k-upload-files");var i,r,n;e.remove();i=u(".k-file",t);r=u(".k-file-success, .k-file-error",t);n=u(".k-file-invalid",t);if(r.length===i.length||n.length===i.length)this._hideActionButtons();if(i.length===0){t.remove();a.wrapper.addClass("k-upload-empty");a._hideHeaderUploadstatus()}else a._updateHeaderUploadStatus()},_fileAction:function(e,a,t){var i={remove:"k-i-x",cancel:"k-i-cancel",retry:"k-i-retry",pause:"k-i-pause-sm"};var r={remove:"k-i-close",cancel:"k-i-cancel",retry:"k-i-reload-sm",pause:"k-i-pause-sm"};var n;if(!i.hasOwnProperty(a))return;if(!t)this._clearFileAction(e);if(!this.options.template){if(!t)e.find(".k-upload-status .k-upload-action").remove();e.find(".k-upload-status").append(this._renderAction(i[a],this.localization[a],r[a]))}else{n=e.find(".k-upload-action").first();if(!n.find(".k-icon").length)n.addClass("k-button k-button-md k-rounded-md k-button-solid k-button-solid-base k-icon-button").append("<span class='k-button-icon k-icon "+r[a]+" "+i[a]+"' title='"+this.localization[a]+"'"+"aria-label='"+this.localization[a]+"'></span>").show();else if(n.next(".k-upload-action").length)n.next(".k-upload-action").addClass("k-button k-button-md k-rounded-md k-button-solid k-button-solid-base k-icon-button").append("<span class='k-button-icon k-icon "+r[a]+" "+i[a]+"' title='"+this.localization[a]+"'"+"aria-label='"+this.localization[a]+"'></span>").show()}},_fileState:function(e,a){var t=this.localization,i={uploading:{text:t.statusUploading},uploaded:{text:t.statusUploaded},failed:{text:t.statusFailed}},r=i[a];if(r)u("span.k-file-state",e).text(r.text)},_renderAction:function(e,a,t){if(e!=="")return u("<button type='button' class='k-button k-icon-button k-button-md k-rounded-md k-button-flat k-button-flat-base k-upload-action' aria-label='"+a+"' tabindex='-1'>"+"<span class='k-button-icon k-icon "+t+" "+e+"' title='"+a+"'></span>"+"</button>").on("focus",function(){u(this).addClass(l)}).on("blur",function(){u(this).removeClass(l)});else return u("<button type='button' class='k-button k-button-md k-rounded-md k-button-solid k-button-solid-base'>"+'<span class="k-button-text">'+a+"</span>"+"</button>")},_clearFileAction:function(e){u(".k-upload-action",e).empty().hide()},_onFileAction:function(e){var a=this;if(!a.wrapper.hasClass("k-disabled")){var t=u(e.target).closest(".k-upload-action");var i=t.find(".k-icon");var r=t.closest(".k-file");var n=r.data("fileNames");var s=a._filesContainValidationErrors(n);var o={files:n,headers:{}};a._retryClicked=false;if(i.hasClass("k-i-x")){if(!a.trigger(c,o)){a._module.onRemove({target:u(r,a.wrapper)},o,!s);a.element.trigger("focus")}}else if(i.hasClass("k-i-cancel")){a.trigger(p,o);a._module.onCancel({target:u(r,a.wrapper)});a._checkAllComplete();a._updateHeaderUploadStatus();a.element.trigger("focus")}else if(i.hasClass("k-i-pause-sm")){a.trigger(F,o);a.pause(r);a._updateHeaderUploadStatus()}else if(i.hasClass("k-i-play-sm")){a.trigger(w,o);a.resume(r)}else if(i.hasClass("k-i-retry")){u(".k-i-warning",r).remove();u(".k-progressbar",r).finish().show();a._module.onRetry({target:u(r,a.wrapper)});a._retryClicked=true}r.addClass(l)}return false},_onUploadSelected:function(){var e=this;var a=e.wrapper;if(!a.hasClass("k-disabled"))this._module.onSaveSelected();return false},_onClearSelected:function(){var e=this;var a=e.wrapper;var t={};if(!a.hasClass("k-disabled")&&!e.trigger(r,t))e.clearAllFiles();return false},_onFileProgress:function(e,a){var t;if(a>100)a=100;u(".k-progressbar",e.target).removeClass("k-hidden");if(!this.options.template){t=u(".k-upload-pct",e.target);if(t.length===0)u(".k-upload-status",e.target).prepend("<span class='k-upload-pct'></span>");if(a!==100)u(".k-upload-pct",e.target).text(a+"%");else u(".k-upload-pct",e.target).remove();u(".k-progress",e.target).width(a+"%")}else u(".k-progress",e.target).width(a+"%");this.trigger(C,{files:h(e).data("fileNames"),percentComplete:a})},_onUploadSuccess:function(e,a,t){var i=this;var r=h(e);var n=r.data("fileNames");var s=r.find(".k-file-information");var o=r.find(".k-file-size");var l=i.trigger(_,{files:r.data("fileNames"),response:a,operation:"upload",XMLHttpRequest:t});if(l)i._setUploadErrorState(r);else{i._fileState(r,"uploaded");r.removeClass("k-file-progress").addClass("k-file-success");if(s.length>0)s.addClass("k-hidden").after('<span class="k-file-validation-message k-text-success">'+n.length+" "+i.localization.uploadSuccess+"</span>");else if(o.length>0)o.addClass("k-hidden").after('<span class="k-file-validation-message k-text-success">'+i.localization.uploadSuccess+"</span>");i._updateHeaderUploadStatus();if(i._supportsRemove())i._fileAction(r,c);else i._clearFileAction(r)}i._hideUploadProgress(r);i._checkAllComplete()},_onUploadError:function(e,a){var t=this;var i=t._module;var r=h(e);var n=r.data("uid");t._setUploadErrorState(r);t.trigger(y,{operation:"upload",files:r.data("fileNames"),XMLHttpRequest:a});m("Server response: "+a.responseText);if(!t.options.async.chunkSize)t._hideUploadProgress(r);else if(i._decreasePosition)i._decreasePosition(n);t._checkAllComplete();if(this.options.async.autoRetryAfter)this._autoRetryAfter(r)},_autoRetryAfter:function(e){var a=this;var t=this._module.retries;if(!t)return;if(!t[e.data("uid")])t[e.data("uid")]=1;if(t[e.data("uid")]<=this.options.async.maxAutoRetries){t[e.data("uid")]++;setTimeout(function(){a._module.performUpload(e)},this.options.async.autoRetryAfter)}},_setUploadErrorState:function(e){var a=this,t,i=e.data("fileNames"),r=e.find(".k-file-information"),n=e.find(".k-file-size");a._fileState(e,"failed");e.removeClass("k-file-progress").addClass("k-file-error");if(r.length>0)r.addClass("k-hidden").after('<span class="k-file-validation-message k-text-error">'+i.length+" "+a.localization.uploadFail+"</span>");else if(n.length>0)n.addClass("k-hidden").after('<span class="k-file-validation-message k-text-error">'+a.localization.uploadFail+"</span>");a._updateUploadProgress(e);t=u(".k-upload-pct",e);if(t.length>0)t.remove();this._updateHeaderUploadStatus();this._fileAction(e,"retry");this._fileAction(e,c,true);if(a._retryClicked)e.trigger("focus")},_updateUploadProgress:function(e){var a=this;if(!a.options.async.chunkSize)u(".k-progress",e).width("100%");else{var t=e.data("uid");if(a._module.metaData){var i=a._module.metaData[t];if(i){var r=i.totalChunks?Math.round(i.chunkIndex/i.totalChunks*100):100;a._onFileProgress({target:u(e,a.wrapper)},r)}}}},_hideUploadProgress:function(e){u(".k-progressbar",e).delay(U).fadeOut(E,function(){u(this).find(".k-progress").css("width","0%")})},_showActionButtons:function(){var e=this;var a=u(".k-action-buttons",e.wrapper);var t=u(".k-upload-selected",e.wrapper);var i=u(".k-clear-selected",e.wrapper);if(t.length===0){t=e._renderAction("",this.localization.uploadSelectedFiles).addClass("k-upload-selected").addClass("k-button-solid-primary").removeClass("k-button-solid-base");i=e._renderAction("",this.localization.clearSelectedFiles).addClass("k-clear-selected")}if(!a.length)a=u("<div />").addClass("k-action-buttons").append(i,t);this.wrapper.append(a)},_hideActionButtons:function(){u(".k-action-buttons",this.wrapper).remove()},_showHeaderUploadStatus:function(e){var a=this;var t=a.localization;var i=u(".k-dropzone",a.wrapper);var r=u(".k-upload-status-total",a.wrapper);if(r.length!==0)r.remove();u(".k-dropzone-hint",a.wrapper).addClass("k-hidden");r='<strong class="k-upload-status k-upload-status-total"><span class="k-icon"></span></strong>';if(e){r=u(r).append(t.headerStatusUploading);r.find(".k-icon").addClass(A.loading)}else{r=u(r).append(t.headerStatusUploaded);r.find(".k-icon").addClass(A.warning)}if(i.length>0)i.append(r);else u(".k-upload-button",a.wrapper).after(r)},_updateHeaderUploadStatus:function(){var e=this;var a=u(".k-upload-status-total",this.wrapper);var t=u(".k-file",e.wrapper).not(".k-file-success, .k-file-error, .k-file-invalid");var i=u(".k-file-invalid",e.wrapper);var r=u(".k-file-error",e.wrapper);var n=u(".k-file",e.wrapper).find(".k-i-play-sm");var s,o;if(n.length&&(n.length===t.length||!e.options.async.concurrent)){o=u(".k-icon",a).removeClass().addClass("k-icon").addClass("k-i-pause-sm");a.html(o).append(e.localization.headerStatusPaused)}else if(t.length===0||i.length>0||r.length>0){s=u(".k-file.k-file-error, .k-file.k-file-invalid",e.wrapper);a=u(".k-upload-status-total",e.wrapper);o=u(".k-icon",a).removeClass().addClass("k-icon").addClass(s.length!==0?A.warning:A.success);a.html(o).append(e.localization.headerStatusUploaded)}},_hideHeaderUploadstatus:function(){var e=this,a=e.options.dropZone;u(".k-upload-status-total",this.wrapper).remove();if(a==="")u(".k-dropzone-hint",e.wrapper).removeClass("k-hidden")},_onParentFormSubmit:function(){var e=this,a=e.element;if(typeof this._module.onAbort!=="undefined")this._module.onAbort();if(!a.value){var t=u(a);t.attr("disabled","disabled");window.setTimeout(function(){t.prop("disabled",false)},0)}},_onParentFormReset:function(){u(".k-upload-files",this.wrapper).remove()},_supportsFormData:function(){return typeof FormData!="undefined"},_supportsMultiple:function(){var e=this._userAgent().indexOf("Windows")>-1;return!f.support.browser.opera&&!(f.support.browser.safari&&e)},_supportsDrop:function(){var e=this._userAgent().toLowerCase();var a=/chrome/.test(e);var t=!a&&/safari/.test(e);var i=t&&/windows/.test(e);return!i&&this._supportsFormData()&&this.options.async.saveUrl},_userAgent:function(){return navigator.userAgent},_setupDropZone:function(){var e=this;var a=e._ns;var t=u(".k-dropzone",e.wrapper).on("dragenter"+a,J).on("dragover"+a,function(e){if(e.originalEvent)e.originalEvent.dataTransfer.dropEffect="copy";e.preventDefault()}).on("drop"+a,e._onDrop.bind(e));if(!t.find(".k-dropzone-hint").length)t.append(u("<em class='k-dropzone-hint'>"+e.localization.dropFilesHere+"</em>"));Q(t,a,function(){if(!t.closest(".k-upload").hasClass("k-disabled"))t.addClass("k-dropzone-hovered")},function(){t.removeClass("k-dropzone-hovered")});e._bindDocumentDragEventWrappers(t)},_setupCustomDropZone:function(){var a=this;var t=u(a.options.dropZone);if(!a.wrapper.find(".k-dropzone-hint").length)u(".k-dropzone",a.wrapper).append(u("<em class='k-dropzone-hint k-hidden'>"+a.localization.dropFilesHere+"</em>"));else u(".k-dropzone-hint",a.wrapper).addClass("k-hidden");var e=a._ns;t.on("dragenter"+e,J).on("dragover"+e,function(e){if(e.originalEvent)e.originalEvent.dataTransfer.dropEffect="copy";e.preventDefault()}).on("drop"+e,a._onDrop.bind(a));Q(t,e,function(e){if(!a.wrapper.hasClass("k-disabled")){t.removeClass("k-dropzone-hovered");t.addClass("k-dropzone-hovered");u(e.target).addClass("k-dropzone-hovered")}},function(){t.removeClass("k-dropzone-hovered");t.find(".k-dropzone-hovered").removeClass("k-dropzone-hovered")});a._bindDocumentDragEventWrappers(t)},_bindDocumentDragEventWrappers:function(e){var a=this;var t=a._ns;Q(u(document),t,function(){if(!a.wrapper.hasClass("k-disabled")){e.addClass("k-dropzone-active");e.closest(".k-upload").removeClass("k-upload-empty");e.find(".k-dropzone-hint").removeClass("k-hidden")}},function(){e.removeClass("k-dropzone-active");e.find(".k-dropzone-hint").addClass("k-hidden");if(u("li.k-file",e.closest(".k-upload")).length===0)e.closest(".k-upload").addClass("k-upload-empty")})},_toggleDropZone:function(){var e=this,a=e.options.dropZone;if(!e._supportsDrop())return;u(a).off(e._ns);u(".k-dropzone",e.wrapper).off(e._ns);if(a!=="")e._setupCustomDropZone();else e._setupDropZone()},_supportsRemove:function(){return!!this.options.async.removeUrl},_submitRemove:function(e,a,t,i){var r=this,n=r.options.async.removeField||"fileNames",s=u.extend(a.data,v());s[n]=e;jQuery.ajax({type:this.options.async.removeVerb,dataType:"json",dataFilter:G,url:this.options.async.removeUrl,traditional:true,data:s,headers:a.headers,success:t,error:i,xhrFields:{withCredentials:this.options.async.withCredentials}})},_wrapInput:function(e){var a=this;var t=a.options;var i=!!e.attr("id")&&u("[for='"+e.attr("id")+"']").length>0;e.wrap("<div class='k-widget k-upload'><div class='k-dropzone'><div class='k-button k-button-md k-rounded-md k-button-solid k-button-solid-base k-upload-button'></div></div></div>");if(!t.async.saveUrl)e.closest(".k-upload").addClass("k-upload-sync");else e.closest(".k-upload").addClass("k-upload-async");e.closest(".k-upload").addClass("k-upload-empty");e.closest(".k-button").append("<span>"+a.localization.select+"</span>");if(!i&&!e.attr("aria-label"))e.attr("aria-label",a.localization.select);return e.closest(".k-upload")},_checkAllComplete:function(){if(u(".k-file.k-file-progress",this.wrapper).length===0)this.trigger(i)},_inputFiles:function(e){return N(e)}}),x=function(e){this.name="syncUploadModule";this.element=e.wrapper;this.upload=e;this.element.closest("form").attr("enctype","multipart/form-data").attr("encoding","multipart/form-data")},R=(x.prototype={onSelect:function(e,a){var t=this.upload;var i=u(e.target);var r=t._filesContainValidationErrors(a);t._addInput(i);var n={fileNames:a};if(r)i.remove();else n.relatedInput=i;var s=t._enqueueFile(T(i),n);if(r)t._hideUploadProgress(s);t._fileAction(s,c)},onRemove:function(e){var a=h(e);var t=a.data("relatedInput");if(t)t.remove();this.upload._removeFileEntry(a)}},function(e){this.name="iframeUploadModule";this.element=e.wrapper;this.upload=e;this.iframes=[]}),P=(D._frameId=0,R.prototype={onSelect:function(e,a){var t=this.upload;var i=u(e.target);var r=t._filesContainValidationErrors(a);var n=this.prepareUpload(i,a,r);if(t.options.async.autoUpload)if(!r)this.performUpload(n);else{t._fileAction(n,c);t._showHeaderUploadStatus(false)}else{t._fileAction(n,c);if(!r)t._showActionButtons();else t._updateHeaderUploadStatus()}if(r)t._hideUploadProgress(n)},prepareUpload:function(e,a,t){var i=this.upload;var r=u(i.element);var n=i.options.async.saveField||e.attr("name");var s,o,l,d;i._addInput(e);e.attr("name",n);if(!t){l=this.createFrame(i.name+"_"+D._frameId++);this.registerFrame(l);d=this.createForm(i.options.async.saveUrl,l.attr("name")).append(r);o={frame:l,relatedInput:r,fileNames:a}}else{e.remove();o={fileNames:a}}s=i._enqueueFile(T(e),o);if(l)l.data({form:d,file:s});return s},performUpload:function(e){var a={files:e.data("fileNames")};var t=e.data("frame");var i=this.upload;var r=e.find(".k-file-validation-message");var n=e.find(".k-file-information");var s=e.find(".k-file-size");if(!i.trigger(g,a)){i._hideActionButtons();i._showHeaderUploadStatus(true);t.appendTo(document.body);var o=t.data("form").attr("action",i.options.async.saveUrl).appendTo(document.body);a.data=u.extend({},a.data,v());for(var l in a.data){var d=o.find("input[name='"+l+"']");if(d.length===0)d=u("<input>",{type:"hidden",name:l}).prependTo(o);d.val(a.data[l])}i._fileAction(e,p);i._fileState(e,"uploading");u(e).removeClass("k-file-error").addClass("k-file-progress");if(r.length>0)r.remove();if(n.length>0)n.removeClass("k-hidden");else if(s.length>0)s.removeClass("k-hidden");t.one("load",this.onIframeLoad.bind(this));o[0].submit()}else{i._removeFileEntry(t.data("file"));this.cleanupFrame(t);this.unregisterFrame(t)}},onSaveSelected:function(){var i=this;var r=i.upload;u(".k-file",this.element).each(function(){var e=u(this);var a=$(e);var t=r._filesContainValidationErrors(e.data("fileNames"));if(!a&&!t)i.performUpload(e)})},onIframeLoad:function(e){var a=u(e.target),t;try{t=a.contents().text()}catch(e){t="Error trying to get server response: "+e}this.processResponse(a,t)},processResponse:function(a,e){var t=a.data("file"),i=this,r={responseText:e};X(e,function(e){u.extend(r,{statusText:"OK",status:"200"});i.upload._onFileProgress({target:u(t,i.upload.wrapper)},100);i.upload._onUploadSuccess({target:u(t,i.upload.wrapper)},e,r);i.cleanupFrame(a);i.unregisterFrame(a)},function(){u.extend(r,{statusText:"error",status:"500"});i.upload._onUploadError({target:u(t,i.upload.wrapper)},r)})},onCancel:function(e){var a=u(e.target).data("frame");this.stopFrameSubmit(a);this.cleanupFrame(a);this.unregisterFrame(a);this.upload._removeFileEntry(a.data("file"))},onRetry:function(e){var a=h(e);this.performUpload(a)},onRemove:function(e,a,t){var i=this;var r=i.upload;var n=h(e);var s=n.data("frame");if(s){i.unregisterFrame(s);r._removeFileEntry(n);i.cleanupFrame(s)}else if(n.hasClass("k-file-success"))W(n,r,a,t);else r._removeFileEntry(n)},onAbort:function(){var e=this.element,a=this;u.each(this.iframes,function(){u("input",this.data("form")).appendTo(e);a.stopFrameSubmit(this[0]);this.data("form").remove();this.remove()});this.iframes=[]},createFrame:function(e){return u("<iframe"+" name='"+e+"'"+" id='"+e+"'"+" style='display:none;' />")},createForm:function(e,a){return u("<form enctype='multipart/form-data' method='POST'"+" action='"+e+"'"+" target='"+a+"'"+"/>")},stopFrameSubmit:function(e){if(typeof e.stop!="undefined")e.stop();else if(e.document)e.document.execCommand("Stop")},registerFrame:function(e){this.iframes.push(e)},unregisterFrame:function(a){this.iframes=u.grep(this.iframes,function(e){return e.attr("name")!=a.attr("name")})},cleanupFrame:function(e){var a=e.data("form");e.data("file").data("frame",null);setTimeout(function(){a.remove();e.remove()},1)}},function(e){this.name="formDataUploadModule";this.element=e.wrapper;this.upload=e;this.position={};this.metaData={};this.cancelled={};this.resume={};this.paused={};this.retries={}});function T(e){return u.map(N(e),function(e){return e.name}).join(", ")}function N(e){var a=e[0];if(a.files)return I(a.files);else return[{name:q(a.value),extension:H(a.value),size:null}]}function I(e){return u.map(e,function(e){return B(e)})}function B(e){var a=e.name||e.fileName;return{name:f.htmlEncode(a),extension:H(a),size:typeof e.size=="number"?e.size:e.fileSize,rawFile:e}}function H(e){var a=e.match(t);return a?a[0]:""}function q(e){var a=e.lastIndexOf("\\");return a!=-1?e.substr(a+1):e}function M(e,a){var t=f.guid();return u.map(e,function(e){e.uid=a?f.guid():t;return e})}function L(e,a){var t=O(a.allowedExtensions);var i=a.maxFileSize;var r=a.minFileSize;for(var n=0;n<e.length;n++){Z(e[n],t);j(e[n],r,i)}}function O(e){var a=u.map(e,function(e){var a=e.substring(0,1)==="."?e:"."+e;return a.toLowerCase()});return a}function Z(e,a){if(a.length>0)if(a.indexOf(e.extension.toLowerCase())<0){e.validationErrors=e.validationErrors||[];if(u.inArray(z,e.validationErrors)===-1)e.validationErrors.push(z)}}function j(e,a,t){if(a!==0&&e.size<a){e.validationErrors=e.validationErrors||[];if(u.inArray(S,e.validationErrors)===-1)e.validationErrors.push(S)}if(t!==0&&e.size>t){e.validationErrors=e.validationErrors||[];if(u.inArray(b,e.validationErrors)===-1)e.validationErrors.push(b)}}function V(e){var a=0;if(typeof e[0].size=="number"){for(var t=0;t<e.length;t++)if(e[t].size)a+=e[t].size}else return"";a/=1024;if(a<1024)return a.toFixed(2)+" KB";else return(a/1024).toFixed(2)+" MB"}function K(e){return!e.multiple&&u(".k-file",e.wrapper).length>1}function W(n,s,e,a){if(!s._supportsRemove()){if(K(s)||!a)s._removeFileEntry(n);return}var o=n.data("fileNames");var t=u.map(o,function(e){return e.name});if(a===false){s._removeFileEntry(n);return}s._submitRemove(t,e,function e(a,t,i){var r=s.trigger(_,{operation:"remove",files:o,response:a,XMLHttpRequest:i});if(!r)s._removeFileEntry(n)},function e(a){if(K(s))s._removeFileEntry(n);s.trigger(y,{operation:"remove",files:o,XMLHttpRequest:a});m("Server response: "+a.responseText)})}function X(e,a,t){var i=false,r="";try{r=JSON.parse(G(e));i=true}catch(e){t()}if(i)a(r)}function G(e){if(typeof e==="undefined"||e==="")e="{}";return e}function J(e){if(e.originalEvent)e.originalEvent.dataTransfer.dropEffect="copy";e.stopPropagation();e.preventDefault()}function Q(e,a,t,i){var r,n;e.on("dragenter"+a,function(e){t(e);n=new Date;if(!r)r=setInterval(function(){var e=new Date-n;if(e>100){i();clearInterval(r);r=null}},100)}).on("dragover"+a,function(){n=new Date})}function $(e){return e.is(".k-file-progress, .k-file-success, .k-file-error")}function h(e){return u(e.target).closest(".k-file")}return P.prototype={onSelect:function(e,a){var t=this.upload;var i=this;var r=u(e.target);var n=this.prepareUpload(r,a);var s;var o;u.each(n,function(e){s=t._filesContainValidationErrors(u(this.data("fileNames")));if(t.options.async.autoUpload)if(!s)if(t.options.async.chunkSize){i.prepareChunk(this);o=this.prev();if(t.options.async.concurrent||e===0&&!o.length||e===0&&o.hasClass("k-file-success"))i.performUpload(this)}else i.performUpload(this);else{t._fileAction(this,c);t._showHeaderUploadStatus(false)}else{t._fileAction(this,c);if(!s){t._showActionButtons();this.addClass("k-toupload")}else t._updateHeaderUploadStatus()}if(s)t._hideUploadProgress(this)})},prepareUpload:function(e,a){var t=this.enqueueFiles(a);if(e.is("input")){u.each(t,function(){u(this).data("relatedInput",e)});e.data("relatedFileEntries",t);this.upload._addInput(e)}return t},enqueueFiles:function(e){var a=this.upload;var t;var i;var r=e.length;var n;var s;var o=[];if(a.options.async.batch===true){t=u.map(e,function(e){return e.name}).join(", ");if(a.directory||a.options.directoryDrop)u(e).each(function(){if(this.rawFile.webkitRelativePath||this.rawFile.relativePath)this.name=this.rawFile.webkitRelativePath||this.rawFile.relativePath});s=a._enqueueFile(t,{fileNames:e});s.data("files",e);o.push(s)}else for(i=0;i<r;i++){n=e[i];t=n.name;if(a.directory||a.options.directoryDrop)if(n.rawFile.webkitRelativePath||n.rawFile.relativePath)n.name=n.rawFile.webkitRelativePath||n.rawFile.relativePath;s=a._enqueueFile(t,{fileNames:[n]});s.data("files",[n]);o.push(s)}return o},performUpload:function(e){var a=this.upload,t=this.createFormData(),i=this.createXHR(),r={files:e.data("fileNames"),XMLHttpRequest:i},n;var s=e.find(".k-file-validation-message");var o=e.find(".k-file-information");var l=e.find(".k-file-size");if(!a.trigger(g,r)){if(e.find(".k-i-cancel").length===0){if(a.options.async.chunkSize)a._fileAction(e,F);a._fileAction(e,p,a.options.async.chunkSize)}if(!a.wrapper.find(".k-toupload").length)a._hideActionButtons();a._showHeaderUploadStatus(true);if(r.formData)t=r.formData;else{r.data=u.extend({},r.data,v());for(var d in r.data)t.append(d,r.data[d]);n=e.data("files");if(n)this.populateFormData(t,n)}a._fileState(e,"uploading");u(e).removeClass("k-file-error").addClass("k-file-progress");if(s.length>0)s.remove();if(o.length>0)o.removeClass("k-hidden");else if(l.length>0)l.removeClass("k-hidden");if(a.options.async.useArrayBuffer&&window.FileReader)this._readFile(a.options.async.saveUrl,t,e,i);else this.postFormData(a.options.async.saveUrl,t,e,i)}else this.removeFileEntry(e)},_readFile:function(a,t,i,r){var n=this;var s=n.upload;var o=i.data("files")[0];var e=new FileReader;e.onload=function(e){try{if(!n.fileArrayBuffer)n.fileArrayBuffer=e.target.result;else n.fileArrayBuffer=n._appendBuffer(n.fileArrayBuffer,e.target.result)}catch(e){s._onUploadError({target:u(i,s.wrapper)},r);return}if(n.position[o.uid]>o.size){n.postFormData(s.options.async.saveUrl,n.fileArrayBuffer,i,r);n.fileArrayBuffer=null}else n._readFile(a,t,i,r)};e.onerror=function(){s._onUploadError({target:u(i,s.wrapper)},r)};e.readAsArrayBuffer(n._getCurrentChunk(o.rawFile,o.uid))},_appendBuffer:function(e,a){var t=new Uint8Array(e.byteLength+a.byteLength);t.set(new Uint8Array(e),0);t.set(new Uint8Array(a),e.byteLength);return t.buffer},onSaveSelected:function(){var i=this;var r=i.upload;u(".k-toupload",this.element).filter(function(){var e=u(this);var a=$(e);var t=r._filesContainValidationErrors(e.data("fileNames"));return!a&&!t}).each(function(e){var a=u(this);var t=a.prev();a.removeClass("k-toupload");if(r.options.async.chunkSize){i.prepareChunk(a);if(r.options.async.concurrent||e===0&&!t.length||(e===0&&t.hasClass("k-file-success")||t.hasClass("k-file-error")))i.performUpload(a)}else i.performUpload(a)})},onCancel:function(e){var a=h(e);if(this.upload.options.async.chunkSize)this.cancelled[a.data("uid")]=true;this.stopUploadRequest(a);this.removeFileEntry(a)},onPause:function(e){var a=h(e);var t=a.data("uid");var i=this.upload.options.async;if(i.chunkSize){this.retries[t]=i.maxAutoRetries+1;this.paused[t]=true;this.resume[t]=false}},onResume:function(e){var a=h(e);var t=a.data("uid");if(this.upload.options.async.chunkSize){delete this.paused[t];this.resume[t]=true;this.retries[a.data("uid")]=1;this._increaseChunkIndex(t);this.performUpload(a)}},onRetry:function(e){var a=h(e);var t=this.upload.options.async;if(t.chunkSize){this.retries[a.data("uid")]=t.maxAutoRetries+1;delete this.paused[a.data("uid")]}this.performUpload(a)},onRemove:function(e,a,t){var i=this;var r=i.upload;var n=h(e);var s=this.upload.options.async;if(s.chunkSize)this.retries[n.data("uid")]=s.maxAutoRetries+1;if(n.hasClass("k-file-success"))W(n,r,a,t);else i.removeFileEntry(n)},createXHR:function(){return new XMLHttpRequest},postFormData:function(e,a,t,i){var r=this;t.data("request",i);i.addEventListener("load",function(e){r.onRequestSuccess.call(r,e,t)},false);i.addEventListener(y,function(e){r.onRequestError.call(r,e,t)},false);i.upload.addEventListener("progress",function(e){r.onRequestProgress.call(r,e,t)},false);i.open("POST",e,true);i.withCredentials=this.upload.options.async.withCredentials;var n=this.upload.options.async.accept;if(n)i.setRequestHeader("Accept",n);i.send(a)},createFormData:function(){return new FormData},populateFormData:function(e,a){var t;var i;var r=a.length;var n;var s=this.upload;if(s.options.async.chunkSize){n=a[0].uid;t=this._getCurrentChunk(a[0].rawFile,n);e.append(s.options.async.saveField||s.name,t);var o=JSON.stringify(this.metaData[n]);e.append("metadata",o)}else for(i=0;i<r;i++)e.append(s.options.async.saveField||s.name,a[i].rawFile);return e},onRequestSuccess:function(e,n){var s=e.target,o=this;function a(){o.upload._onUploadError({target:u(n,o.upload.wrapper)},s)}function t(e){var a=o.upload.options.async.batch;var t=o.upload.options.async.chunkSize;var i=o.upload.options.async.concurrent;var r=e.fileUid;if(o.paused[r]||o.cancelled[r])return;delete o.retries[r];if(t&&!a&&!e.uploaded){o._increaseChunkIndex(r);o.performUpload(n)}else if(t&&!a&&!i&&n.next().length&&!n.next().hasClass("k-toupload")){o.upload._onFileProgress({target:u(n,o.upload.wrapper)},100);o._resetChunkIndex(r);o.upload._onUploadSuccess({target:u(n,o.upload.wrapper)},e,s);o.performUpload(n.next())}else{o.upload._onFileProgress({target:u(n,o.upload.wrapper)},100);o.upload._onUploadSuccess({target:u(n,o.upload.wrapper)},e,s);o.cleanupFileEntry(n)}}if(s.status>=200&&s.status<=299)X(s.responseText,t,a);else a()},onRequestError:function(e,a){var t=e.target;this.upload._onUploadError({target:u(a,this.upload.wrapper)},t)},cleanupFileEntry:function(e){var a=e.data("relatedInput"),t=true;if(a){u.each(a.data("relatedFileEntries")||[],function(){if(this.parent().length>0&&this[0]!=e[0])t=t&&this.hasClass("k-file-success")});if(t)a.remove()}},removeFileEntry:function(e){var a=this.upload.options.async.chunkSize;var t=this.upload.options.async.concurrent;var i=this.upload.wrapper.find(".k-upload-selected").length>0;this.cleanupFileEntry(e);if(a&&!t&&!i)if(e.next().length)this.performUpload(e.next());this.upload._removeFileEntry(e)},onRequestProgress:function(e,a){var t=Math.round(e.loaded*100/e.total);var i=a.data("uid");var r;if(this.upload.options.async.chunkSize){r=this.metaData[i];t=r&&r.totalChunks?Math.round(r.chunkIndex/r.totalChunks*100):100}this.upload._onFileProgress({target:u(a,this.upload.wrapper)},t)},stopUploadRequest:function(e){if(e.data("request"))e.data("request").abort()},prepareChunk:function(e){var a=e.data("files")[0];var t=a.rawFile;var i=a.uid;var r=this.upload.options.async.chunkSize;this.position[i]=0;this.metaData[i]={chunkIndex:0,contentType:t.type,fileName:t.name,relativePath:a.name,totalFileSize:t.size,totalChunks:Math.ceil(t.size/r),uploadUid:i}},_decreaseChunkIndex:function(e){this.metaData[e].chunkIndex--},_increaseChunkIndex:function(e){this.metaData[e].chunkIndex++},_resetChunkIndex:function(e){this.metaData[e].chunkIndex=0},_decreasePosition:function(e){this.position[e]-=this.upload.options.async.chunkSize},_getCurrentChunk:function(e,a){var t=this.position[a];var i;var r=this.upload.options.async;var n=r.chunkSize||r.bufferChunkSize;if(!this.position[a])this.position[a]=0;this.position[a]+=n;if(!!(i=this._getChunker(e)))return e[i](t,this.position[a]);else return e},_getChunker:function(e){if(e.slice)return"slice";else if(e.mozSlice)return"mozSlice";else if(e.webkitSlice)return"webkitSlice";else return null}},f.ui.plugin(D),window.kendo})}("function"==typeof define&&define.amd?define:function(e,a,t){(t||a)()});
//# sourceMappingURL=kendo.upload.min.js.map
