﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="LimityControl.ascx.cs"
    Inherits="KSPortal.Controls.LimityControl" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>

<telerik:RadAjaxManagerProxy ID="RAMP_c_limity" runat="server">
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="RG_lim">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="RG_lim" />
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>
<div>
    <asp:TextBox ID="HF_obdobi" runat="server" CssClass="hidden"></asp:TextBox>
    <kspwc:TRadGrid runat="server" ID="RG_lim" AutoGenerateColumns="False" AllowPaging="True"
        AllowSorting="True" OnNeedDataSource="RG_lim_NeedDataSource" PageSize="20" OnItemDataBound="RG_lim_ItemDataBound"
        PovolExport="True" OnItemCreated="RG_lim_ItemCreated">
        <MasterTableView Caption="[%Limity%]" CommandItemDisplay="Top" PageSize="10">
            <CommandItemTemplate>
                <div style="padding: 5px 5px;">
                    <table class="poor-table">
                        <tr>
                            <td>[%Období%]:&nbsp;
                            </td>
                            <td style="padding-right: 10px">
                                <kspwc:TRadMonthYearPicker ID="RadMonthYearPicker1" runat="server" AutoPostBack="True"
                                    OnSelectedDateChanged="RadMonthYearPicker1_SelectedDateChanged" ShowPopupOnFocus="True">
                                </kspwc:TRadMonthYearPicker>
                            </td>
                            <td style="padding-right: 10px">
                                <wc:TRadButton ID="TRB_ch" runat="server" OnCheckedChanged="TRB_ch_CheckedChanged"
                                    Text="[%Filtr%]" ToggleType="CheckBox">
                                </wc:TRadButton>
                            </td>
                            <td style="padding-right: 10px">
                                <wc:TRadButton ID="TRB_rebind" runat="server" CommandName="RebindGrid" Text="[%Obnovit%]">
                                </wc:TRadButton>
                            </td>
                        </tr>
                    </table>
                </div>
            </CommandItemTemplate>
            <CommandItemSettings ShowExportToCsvButton="True" ShowExportToExcelButton="True"
                ShowExportToPdfButton="True" ShowExportToWordButton="True" />
            <Columns>
                <telerik:GridNumericColumn DataField="id" DataType="System.Int32" DecimalDigits="0"
                    FilterControlAltText="Filter id column" HeaderText="ID" UniqueName="id" FilterControlWidth="50px">
                </telerik:GridNumericColumn>
                <telerik:GridBoundColumn DataField="nazev" FilterControlAltText="Filter nazev column"
                    HeaderText="[%Název%]" UniqueName="nazev">
                </telerik:GridBoundColumn>
                <telerik:GridDateTimeColumn DataField="plati_od" DataType="System.DateTime" FilterControlAltText="Filter plati_od column"
                    HeaderText="[%Platí od%]" UniqueName="plati_od" DataFormatString="{0:d.M.yyyy}"
                    FilterControlWidth="100px">
                </telerik:GridDateTimeColumn>
                <telerik:GridDateTimeColumn DataField="plati_do" DataType="System.DateTime" FilterControlAltText="Filter plati_do column"
                    HeaderText="[%Platí do%]" UniqueName="plati_do" DataFormatString="{0:d.M.yyyy}"
                    FilterControlWidth="100px">
                </telerik:GridDateTimeColumn>
                <telerik:GridNumericColumn DataField="limit_obd" DataType="System.Int16" DecimalDigits="0"
                    FilterControlAltText="Filter limit_obd column" HeaderText="[%Období%]" UniqueName="limit_obd"
                    FilterControlWidth="50px">
                </telerik:GridNumericColumn>
                <telerik:GridBoundColumn DataField="jednotka" FilterControlAltText="Filter jednotka column" HeaderText="[%Jednotka%]" UniqueName="jednotka">
                </telerik:GridBoundColumn>
                <telerik:GridNumericColumn DataField="min" DataType="System.Decimal" FilterControlAltText="Filter min column"
                    HeaderText="[%Min. limit%]" UniqueName="min">
                </telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="max" DataType="System.Decimal" FilterControlAltText="Filter max column"
                    HeaderText="[%Max. limit%]" UniqueName="max">
                </telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="cerpano" DataType="System.Decimal" FilterControlAltText="Filter cerpano column"
                    HeaderText="[%Čerpáno%]" UniqueName="cerpano">
                </telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="zbyva_do_min" DataType="System.Decimal" FilterControlAltText="Filter zbyva_do_min column"
                    HeaderText="[%Do min. lim. zbývá%]" UniqueName="zbyva_do_min">
                </telerik:GridNumericColumn>
                <telerik:GridNumericColumn DataField="zbyva_do_max" DataType="System.Decimal" FilterControlAltText="Filter zbyva_do_max column"
                    HeaderText="[%Do max. lim. zbývá%]" UniqueName="zbyva_do_max">
                </telerik:GridNumericColumn>
            </Columns>
        </MasterTableView>
    </kspwc:TRadGrid>
    <telerik:RadListView runat="server" ID="RLV_limity" ItemPlaceholderID="PH_limity_items" OnNeedDataSource="RLV_limity_NeedDataSource">
        <LayoutTemplate>
            <div style="width: fit-content;">
                <div class="rgCaption">[%Limity%]</div>
                <table class="KsBindTable" style="">
                    <tbody>
                        <tr>
                            <td colspan="2"></td>
                        </tr>
                        <asp:PlaceHolder ID="PH_limity_items" runat="server"></asp:PlaceHolder>
                    </tbody>
                </table>
            </div>
        </LayoutTemplate>
        <ItemTemplate>
            <tr>
                <td>
                    <%# Eval("nazev") %>
                </td>
                <td>
                    <%# Eval("limita_veta") %>
                </td>
            </tr>
        </ItemTemplate>
    </telerik:RadListView>
</div>
