﻿<%@ Control Language="C#" AutoEventWireup="true" Inherits="Controls_ZadostOrelev"
    CodeBehind="ZadostOrelev.ascx.cs" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<%--<telerik:RadFormDecorator ID="QsfFromDecorator" runat="server" DecoratedControls="Textbox" EnableRoundedCorners="false"  />--%>
<telerik:RadFormDecorator ID="RadFormDecorator1" runat="server" DecoratedControls="CheckBoxes,RadioButtons,Select,Textarea,Textbox" EnableRoundedCorners="false" DecorationZoneID="FormView1" />  

<asp:ObjectDataSource ID="ObjectDataSource1" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="Retrieve" TypeName="KSProgram.Pozadavky.Pozadavekrelev" InsertMethod="Insert"
    UpdateMethod="Update" OnUpdated="ObjectDataSource1_Updated" OnUpdating="ObjectDataSource1_Updating"
    OnInserting="ObjectDataSource1_Inserting" OnInserted="ObjectDataSource1_Inserted">
    <UpdateParameters>
        <asp:Parameter Name="id_poz" Type="Int32" />
        <asp:Parameter Name="datum_od" Type="DateTime" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
    </UpdateParameters>
    <SelectParameters>
        <asp:Parameter Name="id_pozadavku" Type="Int32" DefaultValue="" />
    </SelectParameters>
    <InsertParameters>
        <asp:Parameter DefaultValue="0" Name="id_poz" Type="Int32" Direction="InputOutput" />
        <asp:Parameter Name="datum_od" Type="DateTime" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
        <asp:Parameter Name="adresat" Type="Decimal" />
    </InsertParameters>
</asp:ObjectDataSource>
<asp:FormView ID="FormView1" runat="server" OnItemInserted="FormView1_ItemInserted"
    OnItemUpdated="FormView1_ItemUpdated" OnDataBound="FormView1_DataBound" DefaultMode="Edit" OnDataBinding="FormView1_DataBinding">
    <ItemTemplate>
           <%----%>
           <div style="width:800px; padding:7px; border-style:solid; border-color:Black; border-width:1px;">
             <table style="width: 100%; border-collapse: collapse">
                <tr>
                <td colspan="2">
                    <table width="100%" style="padding:10; font-size:2em;">
                    <tr>
                        <td align="left">
                            <asp:Label ID="Label7" runat="server" SkinID="TitleRowStyle"  Text="[%Přehled relevantních skutečností%]"></asp:Label>
                        </td>
                        <td align="right" style="padding-right:20px;">
                            <asp:Label runat="server" ID="lab_rok" SkinID="TitleRowStyle" Text='<%# Bind("rok") %>'></asp:Label>
                        </td>
                    </tr>
                    </table>
                </td>                   
                </tr>
                <tr>
                    <td>
                        <asp:Label runat="server" Font-Bold="true" ID="lab_jmeno_prijmeni" Text="Jméno a příjmení zaměstnance / Osobní číslo:"></asp:Label>
                    </td>
                    <td>
                        <asp:Label runat="server" ID="jmeno_prijmeni" Text='<%# Bind("jmeno_prijmeni") %>'></asp:Label>
                        <asp:Label runat="server" ID="Label10" Text=" / " ></asp:Label>
                        <asp:Label runat="server" ID="Label1" Text='<%# Bind("os_cislo") %>'></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label runat="server" Font-Bold="true" ID="lab_utvar" Text="Název útvaru:"></asp:Label>
                    </td>
                    <td>
                        <asp:Label runat="server" ID="utvar" Text='<%# KSProgram.Ciselniky.CisStredisko.Nazev(Convert.ToString(DataBinder.Eval(Container.DataItem, "stred"))) %>'></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label runat="server" Font-Bold="true" ID="Label11" Text="Pozice:"></asp:Label>
                    </td>
                    <td>
                        <asp:Label runat="server" ID="Label12" Text='<%# Bind(Container.DataItem, "prac_misto_nazev") %>'></asp:Label>
                    </td>
                </tr>
            </table>
            <div style="padding-top:15px;">
                "Přijal/a jste v roce <asp:Label runat="server" ID="Label2" Text='<%# Bind("rok") %>'></asp:Label> v souvislosti s vašim pracovním zařazením v RBCZ nějaké dary, výhody či pozvání (na oběd, kulturní, sportovní nebo společenskou akci) apod.,
                        jejichž hodnota převýšila částku 500 Kč?"
            </div>
            <div>
                <asp:Label runat="server" ID="lab_2b" Text="Pokud ano, uveďte prosím od koho(jméno fyzické osoby nebo název či firmu právnické osoby), kdy, jakého charakteru byl dar, výhoda, nebo pozvání a v jaké hodnotě."></asp:Label>
            </div>
             <table style="width: 100%; border-collapse: collapse">
                <tr>
                    <td>
                        <span style="font-weight: bold;">Ne, v roce</span> <asp:Label runat="server" ID="Label3" style="font-weight:bold;" Text='<%# Bind("rok") %>'></asp:Label> <span style="font-weight: bold;"> jsem nepřijal/a žádné takové dary, výhody ani pozvání.</span>
                    </td>
                    <td style="width:5px;">
                        <asp:CheckBox runat="server" ID="check_2a" Enabled="false" Checked='<%# Bind("2a") %>' />
                    </td>
                    <td class="zarkrt" style="width:110px;">
                        <span style="font-style:italic;">(zaškrtněte odpověď)</span>
                    </td>
                </tr>
                <tr>
                    <td>
                        <span style="font-weight: bold;">Ano, šlo o následující dary, výhody nebo pozvání:</span>
                    </td>
                    <td>
                        <asp:CheckBox runat="server" ID="check_2b" Enabled="false"  Checked='<%# Bind("2b") %>' />
                    </td>
                    <td ></td>
                </tr>
            </table>
            <div>
                <asp:ObjectDataSource runat="server" ID="ds_dary" TypeName="KSProgram.Pozadavky.Pozadavekrelev" SelectMethod="GetDary" InsertMethod="SaveDary" UpdateMethod="SaveDary" OnInserting="ds_dary_Inserting" >
                <SelectParameters>
                <asp:Parameter Type="Int32" Name="id_poz" DefaultValue='0' />
                <asp:Parameter Type="String" Name="klic" DefaultValue='dary' />
                </SelectParameters>
                <InsertParameters>
                    <asp:Parameter Type="Int32" Name="id" DefaultValue="0" />
                    <asp:Parameter Name="datum" Type="DateTime" />
                    <asp:Parameter Name="darce" Type="String" />
                    <asp:Parameter Name="firma" Type="String" />
                    <asp:Parameter Name="popis" Type="String" />
                    <asp:Parameter Name="hodnota" Type="String" />
                </InsertParameters>
                <UpdateParameters>
                    <asp:ControlParameter Name="id" ControlID="gv_dary" PropertyName="SelectedValue" />    
                    <asp:Parameter Name="datum" Type="DateTime" />                                
                    <asp:Parameter Name="darce" Type="String" />
                    <asp:Parameter Name="firma" Type="String" />
                    <asp:Parameter Name="popis" Type="String" />
                    <asp:Parameter Name="hodnota" Type="String" />
                </UpdateParameters>
                </asp:ObjectDataSource>
                 <kspwc:TRadGrid ID="gv_dary" runat="server" DataSourceID="ds_dary"
                    AllowPaging="False" OnItemCreated="RadGrid1_ItemCreated"
                    OnItemInserted="RadGrid1_ItemInserted" >
                     <MasterTableView DataSourceID="ds_dary" AutoGenerateColumns="False" 
                        DataKeyNames="id" >
                        <EditFormSettings>
                            <EditColumn ButtonType="ImageButton" />
                        </EditFormSettings>                       
                        <Columns>                                                            
                            <telerik:GridTemplateColumn HeaderText="Datum" UniqueName="datum"> 
                            <EditItemTemplate>
                            <table style=" border-collapse:collapse; border-width:0px;">
                                <tr>
                                    <td>
                                        <kspwc:TRadDatePicker runat="server" ID="rdp_datum" DbSelectedDate='<%# Bind("datum") %>' ></kspwc:TRadDatePicker>
                                    </td>
                                    <td>
                                        <kspwc:TRequiredValidator runat="server" ID="rv_datum" ControlToValidate="rdp_datum" ></kspwc:TRequiredValidator>
                                    </td>
                                </tr>                                    
                             </table>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_datum" runat="server" Text='<%# DateTime.Parse(Eval("datum").ToString()).ToString("d") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn HeaderText="Dárce (fyzická osoba)" UniqueName="darce"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_darce" runat="server" Text='<%# Bind("darce") %>'></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_darce" ControlToValidate="text_darce" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_darce" runat="server" Text='<%# Eval("darce") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn HeaderText="Firma / jméno dárce" UniqueName="firma"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_firma" runat="server" Text='<%# Bind("firma") %>'></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_firma" ControlToValidate="text_firma" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_firma" runat="server" Text='<%# Eval("firma") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn  HeaderText="Popis daru" UniqueName="popis"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_popis" runat="server" Text='<%# Bind("popis") %>'></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_popis" ControlToValidate="text_popis" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_popis" runat="server" Text='<%# Eval("popis") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn  HeaderText="Hodnota (CZK)" UniqueName="hodnota"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_hodnota" runat="server" Text='<%# Bind("hodnota") %>'></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_hodnota" ControlToValidate="text_hodnota" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_hodnota" runat="server" Text='<%# Eval("hodnota") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                        </Columns>
                      </MasterTableView>
                    </kspwc:TRadGrid>
                    
            </div>
             <div style="padding-top:30px;">
                Vykonával jste vedle své činnosti v RBCZ jinou výdělečnou činnost? Jakého druhu
                tato činnost byla(obor činnosti), intenzity (realizovaný obrat nebo přijaté plnění)
                a jaké bylo Vaše právní postavení při této výdělečné činnosti (zaměstnanec, živnostník,
                podílník právnické osoby, statutární nebo dozorčí orgán, atp.). Uveďte identifikaci
                subjektu, v jehož rámci jste takovou činnost vykonával/a.
            </div>
            <table style="width: 100%; border-collapse: collapse">
                <tr>
                    <td>
                        <span style="font-weight: bold;">Ne, žádnou takovou činnost jsem v roce <asp:Label runat="server" ID="Label4" Text='<%# Bind("rok") %>'></asp:Label> nevykonával/a.</span>
                    </td>
                    <td style="width:5px">
                        <asp:CheckBox runat="server" ID="check_3a" Enabled="false"  Checked='<%# Bind("3a") %>' />
                    </td>
                    <td class="zarkrt" style="width:110px;">
                        <span style="font-style:italic">(zaškrtněte odpověď)</span>
                    </td>
                </tr>
                <tr>
                    <td>
                        <span style="font-weight: bold;">Ano, šlo o tuto činnost nebo aktivitu.</span>
                    </td>
                    <td>
                        <asp:CheckBox runat="server" ID="check_3b" Enabled="false"  Checked='<%# Bind("3b") %>' />
                    </td>
                    <td></td>
                </tr>
            </table>
            <div>
                <asp:ObjectDataSource runat="server" ID="ds_prace" TypeName="KSProgram.Pozadavky.Pozadavekrelev" SelectMethod="GetPrace" InsertMethod="SavePrace" UpdateMethod="SavePrace"  >
                <SelectParameters>
                <asp:Parameter Type="Int32" Name="id_poz" DefaultValue='0' />
                <asp:Parameter Type="String" Name="klic" DefaultValue='prace' />
                </SelectParameters>
                <InsertParameters>
                    <asp:Parameter Type="Int32" Name="id" DefaultValue="0" />
                    <asp:Parameter Name="datum_od" Type="DateTime" />
                    <asp:Parameter Name="datum_do" Type="DateTime" />
                    <asp:Parameter Name="zamestnavatel" Type="String" />
                    <asp:Parameter Name="vztah" Type="String" />
                    <asp:Parameter Name="popis" Type="String" />
                </InsertParameters>
                <UpdateParameters>
                    <asp:ControlParameter Name="id" ControlID="grid_prace" PropertyName="SelectedValue" />    
                    <asp:Parameter Name="datum_od" Type="DateTime" />
                    <asp:Parameter Name="datum_do" Type="DateTime" />
                    <asp:Parameter Name="zamestnavatel" Type="String" />
                    <asp:Parameter Name="vztah" Type="String" />
                    <asp:Parameter Name="popis" Type="String" />
                </UpdateParameters>
                </asp:ObjectDataSource>
                 <kspwc:TRadGrid ID="grid_prace" runat="server" DataSourceID="ds_prace"
                    AllowPaging="False" >
                     <MasterTableView DataSourceID="ds_prace" AutoGenerateColumns="False"
                        DataKeyNames="id">
                        <EditFormSettings>
                            <EditColumn ButtonType="ImageButton" />
                        </EditFormSettings>                       
                        <Columns>                               
                            <telerik:GridTemplateColumn HeaderText="Datum od" UniqueName="datum_od"> 
                            <EditItemTemplate>
                                <table style=" border-collapse:collapse; border-width:0px;">
                                <tr>
                                    <td>
                                        <kspwc:TRadDatePicker runat="server" ID="rdp_datum_od" DbSelectedDate='<%# Bind("datum_od") %>' ></kspwc:TRadDatePicker>
                                    </td>
                                    <td>
                                        <kspwc:TRequiredValidator runat="server" ID="rv_datum_od" ControlToValidate="rdp_datum_od" ></kspwc:TRequiredValidator>
                                    </td>
                                 </tr>
                                 </table>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_datum" runat="server" Text='<%# DateTime.Parse(Eval("datum_od").ToString()).ToString("d") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn HeaderText="Datum do" UniqueName="datum_do"> 
                            <EditItemTemplate>
                                <table style=" border-collapse:collapse; border-width:0px;">
                                <tr>
                                    <td>
                                        <kspwc:TRadDatePicker runat="server" ID="rdp_datum_do" DbSelectedDate='<%# Bind("datum_do") %>' ></kspwc:TRadDatePicker>
                                    </td>
                                    <td>
                                        <kspwc:TRequiredValidator runat="server" ID="rv_datum_do" ControlToValidate="rdp_datum_do" ></kspwc:TRequiredValidator>
                                    </td>
                                </tr>
                                </table>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_datum_do" runat="server" Text='<%# DateTime.Parse(Eval("datum_do").ToString()).ToString("d") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn HeaderText="Zaměstnavatel / osoba, v jejímž rámci je činnost vykonávána" UniqueName="zamestnavatel"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_zamestnavatel" runat="server" Text='<%# Bind("zamestnavatel") %>'></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_zamestnavatel" ControlToValidate="text_zamestnavatel" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_zamestnavatel" runat="server" Text='<%# Eval("zamestnavatel") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>


                            <telerik:GridTemplateColumn HeaderText="Právní rámec (pracovněprávní vztah, obchodní vztah atd.)" UniqueName="vztah"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_vztah" runat="server" Text='<%# Bind("vztah") %>'></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_firma" ControlToValidate="text_vztah" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_vztah" runat="server" Text='<%# Eval("vztah") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn  HeaderText="Popis  činnosti oznamovatele" UniqueName="popis"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_popis" runat="server" Text='<%# Bind("popis") %>'></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_popis" ControlToValidate="text_popis" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_popis" runat="server" Text='<%# Eval("popis") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            
                        </Columns>
                      </MasterTableView>
                    </kspwc:TRadGrid>
            </div>
             <div style="padding-top:30px;">
                Byl/a jste společníkem (např. podílníkem, akcionářem, tichým společníkem) či jednatelem,
                členem představenstva, prokuristou, členem dozorčího orgánu nebo v jiné obdobné
                funkci obchodní splečnosti nebo jiné právnické osoby (např. družstva, občanského
                sdružení, obecně prospěšné společnosti atp.)? Uveďte identifikaci takové osoby,
                včetně uvedení způsobu vaší angažovanosti.
            </div>
            <table style="width: 100%; border-collapse: collapse">
                <tr>
                    <td>
                        <span style="font-weight: bold;">Ne, žádnou takovou činnost jsem v roce <asp:Label runat="server" ID="Label5" Text='<%# Bind("rok") %>'></asp:Label> nevykonával/a
                            a nebyl/a jsem v uvedeném nebo podobném postavení.</span>
                    </td>
                    <td style="width:5px;">
                        <asp:CheckBox runat="server" ID="check_4a" Enabled="false"  Checked='<%# Bind("4a") %>' />
                    </td>
                    <td class="zarkrt" style="width:110px;">
                        <span style="font-style:italic">(zaškrtněte odpověď)</span>
                    </td>
                </tr>
                <tr>
                    <td>
                        <span style="font-weight: bold;">Ano, šlo o tuto činnost nebo postavení.</span>
                    </td>
                    <td>
                        <asp:CheckBox runat="server" ID="check_4b" Enabled="false"  Checked='<%# Bind("4b") %>' />
                    </td>
                    <td></td>
                </tr>
            </table>
            <div>
               <asp:ObjectDataSource runat="server" ID="ds_cinnost" TypeName="KSProgram.Pozadavky.Pozadavekrelev" SelectMethod="GetCinnost" InsertMethod="SaveCinnost" UpdateMethod="SaveCinnost"  >
                <SelectParameters>
                <asp:Parameter Type="Int32" Name="id_poz" DefaultValue='0' />
                <asp:Parameter Type="String" Name="klic" DefaultValue='cinnost' />
                </SelectParameters>
                <InsertParameters>
                    <asp:Parameter Type="Int32" Name="id" DefaultValue="0" />                   
                    <asp:Parameter Name="firma" Type="String" />
                    <asp:Parameter Name="funkce" Type="String" />
                    <asp:Parameter Name="obor" Type="String" />
                </InsertParameters>
                <UpdateParameters>
                    <asp:ControlParameter Name="id" ControlID="grid_cinnost" PropertyName="SelectedValue" />    
                    <asp:Parameter Name="firma" Type="String" />
                    <asp:Parameter Name="funkce" Type="String" />
                    <asp:Parameter Name="obor" Type="String" />
                </UpdateParameters>
                </asp:ObjectDataSource>
                 <kspwc:TRadGrid ID="grid_cinnost" runat="server" DataSourceID="ds_cinnost"
                    AllowPaging="False" >
                     <MasterTableView DataSourceID="ds_cinnost" AutoGenerateColumns="False"
                        DataKeyNames="id" >
                        <EditFormSettings>
                            <EditColumn ButtonType="ImageButton" />
                        </EditFormSettings>                       
                        <Columns>                         
                            <telerik:GridTemplateColumn HeaderText="Firma nebo název osoby" UniqueName="firma"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_firma" runat="server" Text='<%# Bind("firma") %>'></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_firma" ControlToValidate="text_firma" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_firma" runat="server" Text='<%# Eval("firma") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn HeaderText="Funkce nebo postavení oznamovatele v rámci této osoby" UniqueName="funkce"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_funkce" runat="server" Text='<%# Bind("funkce") %>'></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_funkce" ControlToValidate="text_funkce" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_funkce" runat="server" Text='<%# Eval("funkce") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn  HeaderText="Obor, předmět činnosti této osoby" UniqueName="obor"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_obor" runat="server" Text='<%# Bind("obor") %>'></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_obor" ControlToValidate="text_obor" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_obor" runat="server" Text='<%# Eval("obor") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            
                        </Columns>
                      </MasterTableView>
                    </kspwc:TRadGrid>
            </div>
             <div style="padding-top:30px;">
                Prováděl/a jste v roce <asp:Label runat="server" ID="Label6" Text='<%# Bind("rok") %>'></asp:Label> osobní obchody s investičními nástroji (cennými papíry
                nebo jinými investičními nástroji) mimo obchodů zprostředkovaných RBCZ? Uveďte,
                prostřednictvím kakých subjektů a jaká byla intenzita této čínnosti. Uveďte otevřený
                účet u domácího nebo zahraničního obchodníka s cennými papíry, i pokud jste neprováděl/a
                v roce <asp:Label runat="server" ID="Label8" Text='<%# Bind("rok") %>'></asp:Label> žádné obchody.
            </div>
            <table style="width: 100%; border-collapse: collapse">
                <tr>
                    <td>
                        <span style="font-weight: bold;">Ne, neměl/a jsem otevřený účet investičních nástrojů
                            a obchody jsem neprováděl/a.</span>
                    </td>
                    <td style="width:5px;">
                        <asp:CheckBox runat="server" ID="check_5a" Enabled="false"  Checked='<%# Bind("5a") %>' />
                    </td>
                    <td class="zarkrt" style="width:110px;">
                        <span style="font-style:italic">(zaškrtněte odpověď)</span>
                    </td>
                </tr>
                <tr>
                    <td>
                        <span style="font-weight: bold;">Ano, šlo o účet nebo obchody prostřednictvím těchto
                            obchodníků a cennými papíry:</span>
                    </td>
                    <td>
                        <asp:CheckBox runat="server" ID="check_5b" Enabled="false"  Checked='<%# Bind("5b") %>' />
                    </td>
                    <td></td>
                </tr>
            </table>
            <div>
                <asp:ObjectDataSource runat="server" ID="ds_cenpap" TypeName="KSProgram.Pozadavky.Pozadavekrelev" SelectMethod="GetCenpap" InsertMethod="SaveCenpap" UpdateMethod="SaveCenpap"  >
                <SelectParameters>
                <asp:Parameter Type="Int32" Name="id_poz" DefaultValue='0' />
                <asp:Parameter Type="String" Name="klic" DefaultValue='cenpap' />
                </SelectParameters>
                <InsertParameters>
                    <asp:Parameter Type="Int32" Name="id" DefaultValue="0" />                   
                    <asp:Parameter Name="obchodnik" Type="String" />
                    <asp:Parameter Name="intenzita" Type="String" />
                    <asp:Parameter Name="objem" Type="String" />
                </InsertParameters>
                <UpdateParameters>
                    <asp:ControlParameter Name="id" ControlID="grid_cenpap" PropertyName="SelectedValue" />    
                    <asp:Parameter Name="obchodnik" Type="String" />
                    <asp:Parameter Name="intenzita" Type="String" />
                    <asp:Parameter Name="objem" Type="String" />
                </UpdateParameters>
                </asp:ObjectDataSource>
                 <kspwc:TRadGrid ID="grid_cenpap" runat="server" DataSourceID="ds_cenpap"
                    AllowPaging="False" >
                     <MasterTableView DataSourceID="ds_cenpap" AutoGenerateColumns="False"
                        DataKeyNames="id" >
                        <EditFormSettings>
                            <EditColumn ButtonType="ImageButton" />
                        </EditFormSettings>                       
                        <Columns>                     
                            <telerik:GridTemplateColumn HeaderText="Obchodník s cennými papíry" UniqueName="obchodnik"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_obchodnik" runat="server" Text='<%# Bind("obchodnik") %>'></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_obchodnik" ControlToValidate="text_obchodnik" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_obchodnik" runat="server" Text='<%# Eval("obchodnik") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn HeaderText="Intenzita" UniqueName="intenzita"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_intenzita" runat="server" Text='<%# Bind("intenzita") %>'></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_intenzita" ControlToValidate="text_intenzita" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_intenzita" runat="server" Text='<%# Eval("intenzita") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn  HeaderText="Objem" UniqueName="objem"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_objem" runat="server" Text='<%# Bind("objem") %>'></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_objem" ControlToValidate="text_objem" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_obor" runat="server" Text='<%# Eval("objem") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            
                        </Columns>
                      </MasterTableView>
                    </kspwc:TRadGrid>
            </div>
             <div style="padding-top:30px;">
                Máte s některým zaměstnancem RBCZ, případně s osobou spjatou s některým dodavatelem
                či subjektem spolupracujícím s RBCZ (zaměstnancem, podílníkem atp. takové osoby),
                příbuzenský či blízký osobní vztah? Za blízký osobní vztah se považuje takový vztah,
                ve kterém jsou dvě nebo více osob navzájem si blízké ve smyslu příslušné definice
                podle občanského zákoníku (příbuzní a osoby v poměru rodinném nebo obdobném, pokud
                by újmu, kterou utrpěla jedna z nich, druhá důvodně pociťovala jako újmu vlastní).
                Uveďte s kým?
            </div>
            <table style="width: 100%; border-collapse: collapse">
                <tr>
                    <td>
                        <span style="font-weight: bold;">Ne, žádnou takovou osobu neznám.</span>
                    </td>
                    <td style="width:5px;">
                        <asp:CheckBox runat="server" ID="check_6a" Enabled="false"  Checked='<%# Bind("6a") %>' />
                    </td>
                    <td class="zarkrt" style="width:110px;">
                        <span style="font-style:italic">(zaškrtněte odpověď)</span>
                    </td>
                </tr>
                <tr>
                    <td>
                        <span style="font-weight: bold;">Ano, jedná se o tyto osoby:</span>
                    </td>
                    <td>
                        <asp:CheckBox runat="server" ID="check_6b" Enabled="false"  Checked='<%# Bind("6b") %>' />
                    </td>
                    <td></td>
                </tr>
            </table>
            <div>
                <asp:ObjectDataSource runat="server" ID="ds_osoby" TypeName="KSProgram.Pozadavky.Pozadavekrelev" SelectMethod="GetOsoby" InsertMethod="SaveOsoby" UpdateMethod="SaveOsoby"  >
                <SelectParameters>
                <asp:Parameter Type="Int32" Name="id_poz" DefaultValue='0' />
                <asp:Parameter Type="String" Name="klic" DefaultValue='osoby' />
                </SelectParameters>
                <InsertParameters>
                    <asp:Parameter Type="Int32" Name="id" DefaultValue="0" />                   
                    <asp:Parameter Name="jmeno" Type="String" />
                    <asp:Parameter Name="utvar" Type="String" />
                    <asp:Parameter Name="vztah" Type="String" />
                </InsertParameters>
                <UpdateParameters>
                    <asp:ControlParameter Name="id" ControlID="grid_osoby" PropertyName="SelectedValue" />    
                    <asp:Parameter Name="jmeno" Type="String" />
                    <asp:Parameter Name="utvar" Type="String" />
                    <asp:Parameter Name="vztah" Type="String" />
                </UpdateParameters>
                </asp:ObjectDataSource>
                 <kspwc:TRadGrid ID="grid_osoby" runat="server" DataSourceID="ds_osoby" >
                     <MasterTableView DataSourceID="ds_osoby" AutoGenerateColumns="False"
                        DataKeyNames="id" >
                        <EditFormSettings>
                            <EditColumn ButtonType="ImageButton" />
                        </EditFormSettings>                       
                        <Columns>                         
                            <telerik:GridTemplateColumn HeaderText="Jméno a příjmení" UniqueName="jmeno"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_jmeno" runat="server" Text='<%# Bind("jmeno") %>'></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_jmeno" ControlToValidate="text_jmeno" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_jmeno" runat="server" Text='<%# Eval("jmeno") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn HeaderText="Útvar RBCZ nebo třetí osoba (např. dodavatel)" UniqueName="utvar"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_utvar" runat="server" Text='<%# Bind("utvar") %>'></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_utvar" ControlToValidate="text_utvar" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_utvar" runat="server" Text='<%# Eval("utvar") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn  HeaderText="Vztah k oznamovateli" UniqueName="vztah"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_vztah" runat="server" Text='<%# Bind("vztah") %>'></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_vztah" ControlToValidate="text_vztah" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_vztah" runat="server" Text='<%# Eval("vztah") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            
                        </Columns>
                      </MasterTableView>
                    </kspwc:TRadGrid>
            </div>
             <div style="padding-top:30px;">
                Byl/a jsem v roce <asp:Label runat="server" ID="Label9" Text='<%# Bind("rok") %>'></asp:Label> předvolán orgány činnými v trestním řízení (Policie ČR, státní
                zastupitelství, soud) k výslechu nebo k podání vysvětlení ve věci týkající se pracovněprávních
                povinností v rámci Raiffeisenbank a.s.
            </div>
            <table style="width: 100%; border-collapse: collapse">
                <tr>
                    <td>
                        <span style="font-weight: bold;">Ne.</span>
                    </td>
                    <td style="width:5px;">
                        <asp:CheckBox runat="server" ID="check_7a" Enabled="false"  Checked='<%# Bind("7a") %>' />
                    </td>
                    <td class="zarkrt" style="width:110px;">
                        <span style="font-style:italic">(zaškrtněte odpověď)</span>
                    </td>
                </tr>
                <tr>
                    <td>
                        <span style="font-weight: bold;">Ano (přiložte prosím kopii předvolání a výslechu)</span>
                    </td>
                    <td>
                        <asp:CheckBox runat="server" ID="check_7b" Enabled="false"  Checked='<%# Bind("7b") %>' />
                    </td>
                    <td></td>
                </tr>
            </table>
            <div>
                 <asp:ObjectDataSource runat="server" ID="ds_vyslechy" TypeName="KSProgram.Pozadavky.Pozadavekrelev" SelectMethod="GetVyslechy" InsertMethod="SaveVyslechy" UpdateMethod="SaveVyslechy" >
                <SelectParameters>
                <asp:Parameter Type="Int32" Name="id_poz" DefaultValue='0' />
                <asp:Parameter Type="String" Name="klic" DefaultValue='vyslechy' />
                </SelectParameters>
                <InsertParameters>
                    <asp:Parameter Type="Int32" Name="id" DefaultValue="0" />                   
                    <asp:Parameter Name="datum" Type="DateTime" />
                    <asp:Parameter Name="vec" Type="String" />
                    <asp:Parameter Name="osoba" Type="String" />
                </InsertParameters>
                <UpdateParameters>
                    <asp:ControlParameter Name="id" ControlID="grid_vyslechy" PropertyName="SelectedValue" />    
                    <asp:Parameter Name="datum" Type="DateTime" />
                    <asp:Parameter Name="vec" Type="String" />
                    <asp:Parameter Name="osoba" Type="String" />
                </UpdateParameters>
                </asp:ObjectDataSource>
                 <kspwc:TRadGrid ID="grid_vyslechy" runat="server" DataSourceID="ds_vyslechy" >
                     <MasterTableView DataSourceID="ds_vyslechy" AutoGenerateColumns="False" DataKeyNames="id" >
                        <EditFormSettings>
                            <EditColumn ButtonType="ImageButton" />
                        </EditFormSettings>                       
                        <Columns>                                                      
                            <telerik:GridTemplateColumn HeaderText="Datum" UniqueName="datum"> 
                            <EditItemTemplate>
                                <table style=" border-collapse:collapse; border-width:0px;">
                                <tr>
                                    <td>
                                        <kspwc:TRadDatePicker runat="server" ID="rdp_datum" DbSelectedDate='<%# Bind("datum") %>' ></kspwc:TRadDatePicker>
                                    </td>
                                    <td>
                                        <kspwc:TRequiredValidator runat="server" ID="rv_datum" ControlToValidate="rdp_datum" ></kspwc:TRequiredValidator>
                                    </td>
                                </tr>
                                </table>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_datum" runat="server" Text='<%# DateTime.Parse(Eval("datum").ToString()).ToString("d") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn HeaderText="Ve věci" UniqueName="vec"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_vec" runat="server" Text='<%# Bind("vec") %>'></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_vec" ControlToValidate="text_vec" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_utvar" runat="server" Text='<%# Eval("vec") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn  HeaderText="Kým jste byl/a předvolán/a (jméno a příjmení, telefonní číslo)" UniqueName="osoba"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_osoba" runat="server" Text='<%# Bind("osoba") %>'></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_osoba" ControlToValidate="text_osoba" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_osoba" runat="server" Text='<%# Eval("osoba") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            
                        </Columns>
                      </MasterTableView>
                    </kspwc:TRadGrid>
            </div>
            <div style="padding-top:15px;">
                Prohlašuji, že jsem se seznámil/a s inteními normami Compliance manuál a Prevence
                legalizace výnosů z trestné činnosti a financování terorismu a porozuměl/a jsem
                jejich obsahu. Údaje, které jsem výše uvedl/a, jsou pravdivé a úplné.
            </div>
            <table style="width: 100%; border-collapse: collapse; margin-top:5px;">
                <tr>
                    <td align="right">
                         <span style="font-weight: bold;">ANO</span>                        
                    </td>
                    <td style="width:5px;">
                        <asp:CheckBox runat="server" ID="check_souhlas" Enabled="false"  Checked='<%# Bind("souhlas") %>' />
                    </td>
                    <td class="zarkrt" style="width:110px;">
                        <span style="font-style:italic">(zaškrtněte odpověď)</span>
                    </td>
                </tr>                
            </table>
            <table style="width: 100%; border-collapse: collapse; margin-top:15px;">
                <tr>
                    <td style="padding:4px;">
                         <span style="font-weight: bold;">Datum:</span>
                    </td>
                    <td style="width:610px; border:1px solid gray">&nbsp;</td>
                </tr>
                <tr>
                    <td style="padding:4px;">
                         <span style="font-weight: bold;">Podpis:</span>
                    </td>
                    <td style="width:610px; height:30px; border:1px solid gray">&nbsp;</td>
                </tr>
            </table>
        </div>
    </ItemTemplate>
    <EditItemTemplate>
        <%-- background-color:#E5E5E5;--%>        
        <div style="width:800px; border-style:solid; border-color:Black; border-width:1px; padding:7px;">

     <asp:Label ID="Label7" runat="server" class="theme_title1" style="color:#4F4F4F;font-size:1.5em;font-weight:bold;"  Text="[%Přehled relevantních skutečností%]"></asp:Label>

    <div class="alert info">
        <%--<span class="label">upozornění</span><hr>--%>
        <blockquote>
        <p>Vyplňte prosím všechny záložky dokumentu.</p>
        </blockquote>
    </div>
    <%--"Web20"--%>
     <telerik:RadTabStrip ID="RadTabStrip1" runat="server"  MultiPageID="RadMultipage1" Align="Justify" SelectedIndex="0" Width="800px" CausesValidation="true" Skin="Telerik"  >
        <Tabs>
            <telerik:RadTab Text="Dary" PageViewID="RadPage_1"></telerik:RadTab>
            <telerik:RadTab Text="Práce mimo banku" PageViewID="RadPage_2"></telerik:RadTab>
            <telerik:RadTab Text="Statutární orgány mimo banku" PageViewID="RadPage_3"></telerik:RadTab>
            <telerik:RadTab Text="Investiční aktivity" PageViewID="RadPage_4" IsBreak="true"></telerik:RadTab>
            <telerik:RadTab Text="Blízké osoby" PageViewID="RadPage_5"></telerik:RadTab>
            <telerik:RadTab Text="Výslechy" PageViewID="RadPage_6"></telerik:RadTab>
            <telerik:RadTab Text="Souhlas" PageViewID="RadPage_7"></telerik:RadTab>            
        </Tabs>
    </telerik:RadTabStrip>  
   

    <telerik:RadMultiPage runat="server" ID="RadMultiPage1" SelectedIndex="0">
   <telerik:RadPageView runat="server" ID="RadPage_1" Height="500" >
          <div style="padding-top:15px;">
                "Přijal/a jste v roce <asp:Label runat="server" ID="Label2" Text='<%# Bind("rok") %>'></asp:Label> v souvislosti s vašim pracovním zařazením v RBCZ nějaké dary, výhody či pozvání (na oběd, kulturní, sportovní nebo společenskou akci) apod.,
                        jejichž hodnota převýšila částku 500 Kč?"
            </div>
            <div>
                <asp:Label runat="server" ID="lab_2b" Text="Pokud ano, uveďte prosím od koho(jméno fyzické osoby nebo název či firmu právnické osoby), kdy, jakého charakteru byl dar, výhoda, nebo pozvání a v jaké hodnotě."></asp:Label>
            </div>
            <br />
             <table style="width: 100%; border-collapse: collapse">
                <tr>
                    <td>
                        <span style="font-weight: bold;">Ne, v roce</span> <asp:Label runat="server" ID="Label3" style="font-weight:bold;" Text='<%# Bind("rok") %>'></asp:Label> <span style="font-weight: bold;"> jsem nepřijal/a žádné takové dary, výhody ani pozvání.</span>
                    </td>
                    <td style="width:5px;">
                        <asp:CheckBox runat="server" ID="check_2a" AutoPostBack="true" OnCheckedChanged="check_20_Check" />
                    </td>
                    <td class="zarkrt" style="width:110px;">
                        <span style="font-style:italic;">(zaškrtněte odpověď)</span>
                    </td>
                </tr>
                <tr>
                    <td>
                        <span style="font-weight: bold;">Ano, šlo o následující dary, výhody nebo pozvání:</span>
                    </td>
                    <td>
                        <asp:CheckBox runat="server" ID="check_2b" AutoPostBack="true" OnCheckedChanged="check_20_Check" />
                    </td>
                    <td></td>
                </tr>
            </table>
            <div>
                <asp:ObjectDataSource runat="server" ID="ds_dary" TypeName="KSProgram.Pozadavky.Pozadavekrelev" SelectMethod="GetTableMem" InsertMethod="SaveDary" UpdateMethod="SaveDary" OnInserting="ds_dary_Inserting" >
                <SelectParameters>
                <asp:Parameter Type="String" Name="klic" DefaultValue='dary' />
                </SelectParameters>
                <InsertParameters>
                    <asp:Parameter Type="Int32" Name="id" DefaultValue="0" />
                    <asp:Parameter Name="datum" Type="DateTime" />
                    <asp:Parameter Name="darce" Type="String" />
                    <asp:Parameter Name="firma" Type="String" />
                    <asp:Parameter Name="popis" Type="String" />
                    <asp:Parameter Name="hodnota" Type="String" />
                </InsertParameters>
                <UpdateParameters>
                    <asp:ControlParameter Name="id" ControlID="grid_dary" PropertyName="SelectedValue" />    
                    <asp:Parameter Name="datum" Type="DateTime" />                                
                    <asp:Parameter Name="darce" Type="String" />
                    <asp:Parameter Name="firma" Type="String" />
                    <asp:Parameter Name="popis" Type="String" />
                    <asp:Parameter Name="hodnota" Type="String" />
                </UpdateParameters>
                </asp:ObjectDataSource>
              
                 <kspwc:TRadGrid ID="grid_dary" runat="server" 
                    AllowPaging="False" AllowAutomaticUpdates="True" AllowAutomaticInserts="True" DataSourceID="ds_dary"
                    AllowAutomaticDeletes="true" OnItemCommand="grid_dary_ItemCommand" >
                  <ValidationSettings EnableValidation="true" CommandsToValidate="PefrormInsert" />                    
                     <MasterTableView DataSourceID="ds_dary" AutoGenerateColumns="False" DataKeyNames="id" CommandItemDisplay="Top" >
                        <EditFormSettings>
                            <EditColumn ButtonType="ImageButton" />
                        </EditFormSettings>                                         
                        <Columns>
                            <telerik:GridEditCommandColumn ButtonType="ImageButton" UniqueName="EditCommandColumn"/>                           
                            <telerik:GridButtonColumn CommandName="Delete" Text="Smazat" ButtonType="ImageButton" UniqueName="DeleteColumn" />                                  
                            <telerik:GridTemplateColumn HeaderText="Datum" UniqueName="datum"> 
                            <EditItemTemplate>
                            <table style=" border-collapse:collapse; border-width:0px;">
                                <tr>
                                    <td>
                                        <kspwc:TRadDatePicker runat="server" ID="rdp_datum" DbSelectedDate='<%# Bind("datum") %>' ></kspwc:TRadDatePicker>
                                    </td>
                                    <td>
                                        <kspwc:TRequiredValidator runat="server" ID="rv_datum" ControlToValidate="rdp_datum" ></kspwc:TRequiredValidator>
                                    </td>
                                </tr>                                    
                             </table>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_datum" runat="server" Text='<%# DateTime.Parse(Eval("datum").ToString()).ToString("d") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn HeaderText="Dárce (fyzická osoba)" UniqueName="darce"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_darce" runat="server" Text='<%# Bind("darce") %>' ValidationGroup="dary" MaxLength="50"></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_darce" ControlToValidate="text_darce" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_darce" runat="server" Text='<%# Eval("darce") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn HeaderText="Firma / jméno dárce" UniqueName="firma"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_firma" runat="server" Text='<%# Bind("firma") %>' ValidationGroup="dary" MaxLength="50"></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_firma" ControlToValidate="text_firma" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_firma" runat="server" Text='<%# Eval("firma") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn  HeaderText="Popis daru" UniqueName="popis"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_popis" runat="server" Text='<%# Bind("popis") %>' ValidationGroup="dary" MaxLength="100"></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_popis" ControlToValidate="text_popis" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_popis" runat="server" Text='<%# Eval("popis") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            <telerik:GridTemplateColumn  HeaderText="Hodnota (CZK)" UniqueName="hodnota"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_hodnota" runat="server" Text='<%# Bind("hodnota") %>' ValidationGroup="dary"></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_hodnota" ControlToValidate="text_hodnota" ></kspwc:TRequiredValidator>
                                 <kspwc:DecimalValidator runat="server" ID="nv_hodnota" ControlToValidate="text_hodnota" ></kspwc:DecimalValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_hodnota" runat="server" Text='<%# Eval("hodnota") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                        </Columns>
                      </MasterTableView>
                    </kspwc:TRadGrid> 
                    <br />                            
            </div>
    </telerik:RadPageView>
    <telerik:RadPageView runat="server" ID="RadPage_2" Height="500">
         <div style="padding-top:15px;">
                Vykonával jste vedle své činnosti v RBCZ jinou výdělečnou činnost? Jakého druhu
                tato činnost byla(obor činnosti), intenzity (realizovaný obrat nebo přijaté plnění)
                a jaké bylo Vaše právní postavení při této výdělečné činnosti (zaměstnanec, živnostník,
                podílník právnické osoby, statutární nebo dozorčí orgán, atp.). Uveďte identifikaci
                subjektu, v jehož rámci jste takovou činnost vykonával/a.
          </div>
             <br />
            <table style="width: 100%; border-collapse: collapse">
                <tr>
                    <td>
                        <span style="font-weight: bold;">Ne, žádnou takovou činnost jsem v roce <asp:Label runat="server" ID="Label4" Text='<%# Bind("rok") %>'></asp:Label> nevykonával/a.</span>
                    </td>
                    <td style="width:5px">
                        <asp:CheckBox runat="server" ID="check_3a" AutoPostBack="true" OnCheckedChanged="check_20_Check" />
                    </td>
                    <td class="zarkrt" style="width:110px;">
                        <span style="font-style:italic">(zaškrtněte odpověď)</span>
                    </td>
                </tr>
                <tr>
                    <td>
                        <span style="font-weight: bold;">Ano, šlo o tuto činnost nebo aktivitu.</span>
                    </td>
                    <td>
                        <asp:CheckBox runat="server" ID="check_3b" AutoPostBack="true" OnCheckedChanged="check_20_Check" />
                    </td>
                    <td></td>
                </tr>
            </table>
            <div>
                <asp:ObjectDataSource runat="server" ID="ds_prace" TypeName="KSProgram.Pozadavky.Pozadavekrelev" SelectMethod="GetTableMem" InsertMethod="SavePrace" UpdateMethod="SavePrace"  >
                <SelectParameters>
                <asp:Parameter Type="String" Name="klic" DefaultValue='prace' />
                </SelectParameters>
                <InsertParameters>
                    <asp:Parameter Type="Int32" Name="id" DefaultValue="0" />
                    <asp:Parameter Name="datum_od" Type="DateTime" />
                    <asp:Parameter Name="datum_do" Type="DateTime" />
                    <asp:Parameter Name="zamestnavatel" Type="String" />
                    <asp:Parameter Name="vztah" Type="String" />
                    <asp:Parameter Name="popis" Type="String" />
                </InsertParameters>
                <UpdateParameters>
                    <asp:ControlParameter Name="id" ControlID="grid_prace" PropertyName="SelectedValue" />    
                    <asp:Parameter Name="datum_od" Type="DateTime" />
                    <asp:Parameter Name="datum_do" Type="DateTime" />
                    <asp:Parameter Name="zamestnavatel" Type="String" />
                    <asp:Parameter Name="vztah" Type="String" />
                    <asp:Parameter Name="popis" Type="String" />
                </UpdateParameters>
                </asp:ObjectDataSource>
                 <kspwc:TRadGrid ID="grid_prace" runat="server" DataSourceID="ds_prace"
                    AllowPaging="False" AllowAutomaticUpdates="True" AllowAutomaticInserts="True" 
                    AllowAutomaticDeletes="true" AllowSorting="true" OnItemCommand="grid_prace_ItemCommand" >
                     <ValidationSettings EnableValidation="true" CommandsToValidate="PefrormInsert"  />  
                     <MasterTableView DataSourceID="ds_prace" AutoGenerateColumns="False"
                        DataKeyNames="id" CommandItemDisplay="Top">
                        <EditFormSettings>
                            <EditColumn ButtonType="ImageButton" />
                        </EditFormSettings>                       
                        <Columns>
                            <telerik:GridEditCommandColumn ButtonType="ImageButton" UniqueName="EditCommandColumn"/>                           
                            <telerik:GridButtonColumn CommandName="Delete" Text="Smazat" ButtonType="ImageButton" UniqueName="DeleteColumn" />                                  
                            <telerik:GridTemplateColumn HeaderText="Datum od" UniqueName="datum_od"> 
                            <EditItemTemplate>
                                <table style=" border-collapse:collapse; border-width:0px;">
                                <tr>
                                    <td>
                                        <kspwc:TRadDatePicker runat="server" ID="rdp_datum_od" DbSelectedDate='<%# Bind("datum_od") %>' ></kspwc:TRadDatePicker>
                                    </td>
                                    <td>
                                        <kspwc:TRequiredValidator runat="server" ID="rv_datum_od" ControlToValidate="rdp_datum_od" ></kspwc:TRequiredValidator>
                                    </td>
                                 </tr>
                                 </table>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_datum" runat="server" Text='<%# DateTime.Parse(Eval("datum_od").ToString()).ToString("d") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn HeaderText="Datum do" UniqueName="datum_do"> 
                            <EditItemTemplate>
                                <table style=" border-collapse:collapse; border-width:0px;">
                                <tr>
                                    <td>
                                        <kspwc:TRadDatePicker runat="server" ID="rdp_datum_do" DbSelectedDate='<%# Bind("datum_do") %>' ></kspwc:TRadDatePicker>
                                    </td>
                                    <td>
                                        <kspwc:TRequiredValidator runat="server" ID="rv_datum_do" ControlToValidate="rdp_datum_do" ></kspwc:TRequiredValidator>
                                    </td>
                                </tr>
                                </table>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_datum_do" runat="server" Text='<%# DateTime.Parse(Eval("datum_do").ToString()).ToString("d") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn HeaderText="Zaměstnavatel / osoba, v jejímž rámci je činnost vykonávána" UniqueName="zamestnavatel"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_zamestnavatel" runat="server" Text='<%# Bind("zamestnavatel") %>' MaxLength="50"></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_zamestnavatel" ControlToValidate="text_zamestnavatel" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_zamestnavatel" runat="server" Text='<%# Eval("zamestnavatel") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>


                            <telerik:GridTemplateColumn HeaderText="Právní rámec (pracovněprávní vztah, obchodní vztah atd.)" UniqueName="vztah"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_vztah" runat="server" Text='<%# Bind("vztah") %>' MaxLength="50"></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_firma" ControlToValidate="text_vztah" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_vztah" runat="server" Text='<%# Eval("vztah") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn  HeaderText="Popis  činnosti oznamovatele" UniqueName="popis"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_popis" runat="server" Text='<%# Bind("popis") %>' MaxLength="100"></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_popis" ControlToValidate="text_popis" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_popis" runat="server" Text='<%# Eval("popis") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            
                        </Columns>
                      </MasterTableView>
                    </kspwc:TRadGrid>
            </div>
    </telerik:RadPageView>  
    <telerik:RadPageView runat="server" ID="RadPage_3" Height="500">
         <div style="padding-top:15px;">
                Byl/a jste společníkem (např. podílníkem, akcionářem, tichým společníkem) či jednatelem,
                členem představenstva, prokuristou, členem dozorčího orgánu nebo v jiné obdobné
                funkci obchodní splečnosti nebo jiné právnické osoby (např. družstva, občanského
                sdružení, obecně prospěšné společnosti atp.)? Uveďte identifikaci takové osoby,
                včetně uvedení způsobu vaší angažovanosti.
            </div>
             <br />
            <table style="width: 100%; border-collapse: collapse">
                <tr>
                    <td>
                        <span style="font-weight: bold;">Ne, žádnou takovou činnost jsem v roce <asp:Label runat="server" ID="Label5" Text='<%# Bind("rok") %>'></asp:Label> nevykonával/a
                            a nebyl/a jsem v uvedeném nebo podobném postavení.</span>
                    </td>
                    <td style="width:5px;">
                        <asp:CheckBox runat="server" ID="check_4a" AutoPostBack="true" OnCheckedChanged="check_20_Check" />
                    </td>
                    <td class="zarkrt" style="width:110px;">
                        <span style="font-style:italic">(zaškrtněte odpověď)</span>
                    </td>
                </tr>
                <tr>
                    <td>
                        <span style="font-weight: bold;">Ano, šlo o tuto činnost nebo postavení.</span>
                    </td>
                    <td>
                        <asp:CheckBox runat="server" ID="check_4b" AutoPostBack="true" OnCheckedChanged="check_20_Check" />
                    </td>
                    <td></td>
                </tr>
            </table>
            <div>
               <asp:ObjectDataSource runat="server" ID="ds_cinnost" TypeName="KSProgram.Pozadavky.Pozadavekrelev" SelectMethod="GetTableMem" InsertMethod="SaveCinnost" UpdateMethod="SaveCinnost"  >
                <SelectParameters>
                <asp:Parameter Type="String" Name="klic" DefaultValue='cinnost' />
                </SelectParameters>
                <InsertParameters>
                    <asp:Parameter Type="Int32" Name="id" DefaultValue="0" />                   
                    <asp:Parameter Name="firma" Type="String" />
                    <asp:Parameter Name="funkce" Type="String" />
                    <asp:Parameter Name="obor" Type="String" />
                </InsertParameters>
                <UpdateParameters>
                    <asp:ControlParameter Name="id" ControlID="grid_cinnost" PropertyName="SelectedValue" />    
                    <asp:Parameter Name="firma" Type="String" />
                    <asp:Parameter Name="funkce" Type="String" />
                    <asp:Parameter Name="obor" Type="String" />
                </UpdateParameters>
                </asp:ObjectDataSource>
                 <kspwc:TRadGrid ID="grid_cinnost" runat="server" DataSourceID="ds_cinnost"
                    AllowPaging="False" AllowAutomaticUpdates="True" AllowAutomaticInserts="True" 
                    AllowAutomaticDeletes="true" AllowSorting="true" OnItemCommand="grid_cinnost_ItemCommand" >
                     <ValidationSettings EnableValidation="true" CommandsToValidate="PefrormInsert" />  
                     <MasterTableView DataSourceID="ds_cinnost" AutoGenerateColumns="False"
                        DataKeyNames="id" CommandItemDisplay="Top">
                        <EditFormSettings>
                            <EditColumn ButtonType="ImageButton" />
                        </EditFormSettings>                       
                        <Columns>
                            <telerik:GridEditCommandColumn ButtonType="ImageButton" UniqueName="EditCommandColumn"/>                           
                            <telerik:GridButtonColumn CommandName="Delete" Text="Smazat" ButtonType="ImageButton" UniqueName="DeleteColumn" />                            
                            <telerik:GridTemplateColumn HeaderText="Firma nebo název osoby" UniqueName="firma"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_firma" runat="server" Text='<%# Bind("firma") %>' MaxLength="50"></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_firma" ControlToValidate="text_firma" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_firma" runat="server" Text='<%# Eval("firma") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn HeaderText="Funkce nebo postavení oznamovatele v rámci této osoby" UniqueName="funkce"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_funkce" runat="server" Text='<%# Bind("funkce") %>' MaxLength="50"></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_funkce" ControlToValidate="text_funkce" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_funkce" runat="server" Text='<%# Eval("funkce") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn  HeaderText="Obor, předmět činnosti této osoby" UniqueName="obor"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_obor" runat="server" Text='<%# Bind("obor") %>' MaxLength="50"></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_obor" ControlToValidate="text_obor" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_obor" runat="server" Text='<%# Eval("obor") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            
                        </Columns>
                      </MasterTableView>
                    </kspwc:TRadGrid>
            </div>
    </telerik:RadPageView>  
    <telerik:RadPageView runat="server" ID="RadPage_4" Height="500">
         <div style="padding-top:15px;">
                Prováděl/a jste v roce <asp:Label runat="server" ID="Label6" Text='<%# Bind("rok") %>'></asp:Label> osobní obchody s investičními nástroji (cennými papíry
                nebo jinými investičními nástroji) mimo obchodů zprostředkovaných RBCZ? Uveďte,
                prostřednictvím kakých subjektů a jaká byla intenzita této čínnosti. Uveďte otevřený
                účet u domácího nebo zahraničního obchodníka s cennými papíry, i pokud jste neprováděl/a
                v roce <asp:Label runat="server" ID="Label8" Text='<%# Bind("rok") %>'></asp:Label> žádné obchody.
            </div>
             <br />
            <table style="width: 100%; border-collapse: collapse">
                <tr>
                    <td>
                        <span style="font-weight: bold;">Ne, neměl/a jsem otevřený účet investičních nástrojů
                            a obchody jsem neprováděl/a.</span>
                    </td>
                    <td style="width:5px;">
                        <asp:CheckBox runat="server" ID="check_5a" AutoPostBack="true" OnCheckedChanged="check_20_Check" />
                    </td>
                    <td class="zarkrt" style="width:110px;">
                        <span style="font-style:italic">(zaškrtněte odpověď)</span>
                    </td>
                </tr>
                <tr>
                    <td>
                        <span style="font-weight: bold;">Ano, šlo o účet nebo obchody prostřednictvím těchto
                            obchodníků a cennými papíry:</span>
                    </td>
                    <td>
                        <asp:CheckBox runat="server" ID="check_5b" AutoPostBack="true" OnCheckedChanged="check_20_Check" />
                    </td>
                    <td></td>
                </tr>
            </table>
            <div>
                <asp:ObjectDataSource runat="server" ID="ds_cenpap" TypeName="KSProgram.Pozadavky.Pozadavekrelev" SelectMethod="GetTableMem" InsertMethod="SaveCenpap" UpdateMethod="SaveCenpap"  >
                <SelectParameters>
                <asp:Parameter Type="String" Name="klic" DefaultValue='cenpap' />
                </SelectParameters>
                <InsertParameters>
                    <asp:Parameter Type="Int32" Name="id" DefaultValue="0" />                   
                    <asp:Parameter Name="obchodnik" Type="String" />
                    <asp:Parameter Name="intenzita" Type="String" />
                    <asp:Parameter Name="objem" Type="String" />
                </InsertParameters>
                <UpdateParameters>
                    <asp:ControlParameter Name="id" ControlID="grid_cenpap" PropertyName="SelectedValue" />    
                    <asp:Parameter Name="obchodnik" Type="String" />
                    <asp:Parameter Name="intenzita" Type="String" />
                    <asp:Parameter Name="objem" Type="String" />
                </UpdateParameters>
                </asp:ObjectDataSource>
                 <kspwc:TRadGrid ID="grid_cenpap" runat="server" DataSourceID="ds_cenpap"
                    AllowPaging="False" AllowAutomaticUpdates="True" AllowAutomaticInserts="True" 
                    AllowAutomaticDeletes="true" AllowSorting="true" OnItemCommand="grid_cenpap_ItemCommand" >
                     <ValidationSettings EnableValidation="true" CommandsToValidate="PefrormInsert" />  
                     <MasterTableView DataSourceID="ds_cenpap" AutoGenerateColumns="False"
                        DataKeyNames="id" CommandItemDisplay="Top">
                        <EditFormSettings>
                            <EditColumn ButtonType="ImageButton" />
                        </EditFormSettings>                       
                        <Columns>
                            <telerik:GridEditCommandColumn ButtonType="ImageButton" UniqueName="EditCommandColumn"/>                           
                            <telerik:GridButtonColumn CommandName="Delete" Text="Smazat" ButtonType="ImageButton" UniqueName="DeleteColumn" />                            
                            <telerik:GridTemplateColumn HeaderText="Obchodník s cennými papíry" UniqueName="obchodnik"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_obchodnik" runat="server" Text='<%# Bind("obchodnik") %>' MaxLength="50"></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_obchodnik" ControlToValidate="text_obchodnik" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_obchodnik" runat="server" Text='<%# Eval("obchodnik") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn HeaderText="Intenzita" UniqueName="intenzita"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_intenzita" runat="server" Text='<%# Bind("intenzita") %>' MaxLength="50"></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_intenzita" ControlToValidate="text_intenzita" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_intenzita" runat="server" Text='<%# Eval("intenzita") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn  HeaderText="Objem" UniqueName="objem"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_objem" runat="server" Text='<%# Bind("objem") %>' MaxLength="50"></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_objem" ControlToValidate="text_objem" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_obor" runat="server" Text='<%# Eval("objem") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            
                        </Columns>
                      </MasterTableView>
                    </kspwc:TRadGrid>
            </div>
    </telerik:RadPageView>  
    <telerik:RadPageView runat="server" ID="RadPage_5" Height="500">
        <div style="padding-top:15px;">
                Máte s některým zaměstnancem RBCZ, případně s osobou spjatou s některým dodavatelem
                či subjektem spolupracujícím s RBCZ (zaměstnancem, podílníkem atp. takové osoby),
                příbuzenský či blízký osobní vztah? Za blízký osobní vztah se považuje takový vztah,
                ve kterém jsou dvě nebo více osob navzájem si blízké ve smyslu příslušné definice
                podle občanského zákoníku (příbuzní a osoby v poměru rodinném nebo obdobném, pokud
                by újmu, kterou utrpěla jedna z nich, druhá důvodně pociťovala jako újmu vlastní).
                Uveďte s kým?
            </div>
             <br />
            <table style="width: 100%; border-collapse: collapse">
                <tr>
                    <td>
                        <span style="font-weight: bold;">Ne, žádnou takovou osobu neznám.</span>
                    </td>
                    <td style="width:5px;">
                        <asp:CheckBox runat="server" ID="check_6a" AutoPostBack="true" OnCheckedChanged="check_20_Check" />
                    </td>
                    <td class="zarkrt" style="width:110px;">
                        <span style="font-style:italic">(zaškrtněte odpověď)</span>
                    </td>
                </tr>
                <tr>
                    <td>
                        <span style="font-weight: bold;">Ano, jedná se o tyto osoby:</span>
                    </td>
                    <td>
                        <asp:CheckBox runat="server" ID="check_6b" AutoPostBack="true" OnCheckedChanged="check_20_Check" />
                    </td>
                    <td></td>
                </tr>
            </table>
            <div>
                <asp:ObjectDataSource runat="server" ID="ds_osoby" TypeName="KSProgram.Pozadavky.Pozadavekrelev" SelectMethod="GetTableMem" InsertMethod="SaveOsoby" UpdateMethod="SaveOsoby"  >
                <SelectParameters>
                <asp:Parameter Type="String" Name="klic" DefaultValue='osoby' />
                </SelectParameters>
                <InsertParameters>
                    <asp:Parameter Type="Int32" Name="id" DefaultValue="0" />                   
                    <asp:Parameter Name="jmeno" Type="String" />
                    <asp:Parameter Name="utvar" Type="String" />
                    <asp:Parameter Name="vztah" Type="String" />
                </InsertParameters>
                <UpdateParameters>
                    <asp:ControlParameter Name="id" ControlID="grid_osoby" PropertyName="SelectedValue" />    
                    <asp:Parameter Name="jmeno" Type="String" />
                    <asp:Parameter Name="utvar" Type="String" />
                    <asp:Parameter Name="vztah" Type="String" />
                </UpdateParameters>
                </asp:ObjectDataSource>
                 <kspwc:TRadGrid ID="grid_osoby" runat="server" DataSourceID="ds_osoby"
                    AllowPaging="False" AllowAutomaticUpdates="True" AllowAutomaticInserts="True" 
                    AllowAutomaticDeletes="true" AllowSorting="true" OnItemCommand="grid_osoby_ItemCommand" >
                     <ValidationSettings EnableValidation="true" CommandsToValidate="PefrormInsert" />  
                     <MasterTableView DataSourceID="ds_osoby" AutoGenerateColumns="False"
                        DataKeyNames="id" CommandItemDisplay="Top">
                        <EditFormSettings>
                            <EditColumn ButtonType="ImageButton" />
                        </EditFormSettings>                       
                        <Columns>
                            <telerik:GridEditCommandColumn ButtonType="ImageButton" UniqueName="EditCommandColumn"/>                           
                            <telerik:GridButtonColumn CommandName="Delete" Text="Smazat" ButtonType="ImageButton" UniqueName="DeleteColumn" />                            
                            <telerik:GridTemplateColumn HeaderText="Jméno a příjmení" UniqueName="jmeno"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_jmeno" runat="server" Text='<%# Bind("jmeno") %>' MaxLength="50"></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_jmeno" ControlToValidate="text_jmeno" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_jmeno" runat="server" Text='<%# Eval("jmeno") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn HeaderText="Útvar RBCZ nebo třetí osoba (např. dodavatel)" UniqueName="utvar"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_utvar" runat="server" Text='<%# Bind("utvar") %>' MaxLength="50"></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_utvar" ControlToValidate="text_utvar" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_utvar" runat="server" Text='<%# Eval("utvar") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn  HeaderText="Vztah k oznamovateli" UniqueName="vztah"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_vztah" runat="server" Text='<%# Bind("vztah") %>' MaxLength="50"></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_vztah" ControlToValidate="text_vztah" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_vztah" runat="server" Text='<%# Eval("vztah") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>
                            
                        </Columns>
                      </MasterTableView>
                    </kspwc:TRadGrid>
            </div>
   </telerik:RadPageView>  
    <telerik:RadPageView runat="server" ID="RadPage_6" Height="500">
         <div style="padding-top:15px;">
                Byl/a jsem v roce <asp:Label runat="server" ID="Label9" Text='<%# Bind("rok") %>'></asp:Label> předvolán orgány činnými v trestním řízení (Policie ČR, státní
                zastupitelství, soud) k výslechu nebo k podání vysvětlení ve věci týkající se pracovněprávních
                povinností v rámci Raiffeisenbank a.s.
            </div>
             <br />
            <table style="width: 100%; border-collapse: collapse">
                <tr>
                    <td>
                        <span style="font-weight: bold;">Ne.</span>
                    </td>
                    <td style="width:5px;">
                        <asp:CheckBox runat="server" ID="check_7a" AutoPostBack="true" OnCheckedChanged="check_20_Check" />
                    </td>
                    <td class="zarkrt" style="width:110px;">
                        <span style="font-style:italic">(zaškrtněte odpověď)</span>
                    </td>
                </tr>
                <tr>
                    <td>
                        <span style="font-weight: bold;">Ano (přiložte prosím kopii předvolání a výslechu)</span>
                    </td>
                    <td>
                        <asp:CheckBox runat="server" ID="check_7b" AutoPostBack="true" OnCheckedChanged="check_20_Check" />
                    </td>
                    <td></td>
                </tr>
            </table>
            <div>
                <asp:ObjectDataSource runat="server" ID="ds_vyslechy" TypeName="KSProgram.Pozadavky.Pozadavekrelev" SelectMethod="GetTableMem" InsertMethod="SaveVyslechy" UpdateMethod="SaveVyslechy" >
                <SelectParameters>
                <asp:Parameter Type="String" Name="klic" DefaultValue='vyslechy' />
                </SelectParameters>
                <InsertParameters>
                    <asp:Parameter Type="Int32" Name="id" DefaultValue="0" />                   
                    <asp:Parameter Name="datum" Type="DateTime" />
                    <asp:Parameter Name="vec" Type="String" />
                    <asp:Parameter Name="osoba" Type="String" />
                </InsertParameters>
                <UpdateParameters>
                    <asp:ControlParameter Name="id" ControlID="grid_vyslechy" PropertyName="SelectedValue" />    
                    <asp:Parameter Name="datum" Type="DateTime" />
                    <asp:Parameter Name="vec" Type="String" />
                    <asp:Parameter Name="osoba" Type="String" />
                </UpdateParameters>
                </asp:ObjectDataSource>
                 <kspwc:TRadGrid ID="grid_vyslechy" runat="server" DataSourceID="ds_vyslechy"
                    AllowPaging="False" AllowAutomaticUpdates="True" AllowAutomaticInserts="True" AllowAutomaticDeletes="true" AllowSorting="true" OnItemCommand="grid_vyslechy_ItemCommand" >
                    <ValidationSettings EnableValidation="true" CommandsToValidate="PefrormInsert"  />  
                     <MasterTableView DataSourceID="ds_vyslechy" AutoGenerateColumns="False" DataKeyNames="id" CommandItemDisplay="Top">
                        <EditFormSettings>
                            <EditColumn ButtonType="ImageButton" />
                        </EditFormSettings>                       
                        <Columns>
                            <telerik:GridEditCommandColumn ButtonType="ImageButton" UniqueName="EditCommandColumn"/>                           
                            <telerik:GridButtonColumn CommandName="Delete" Text="Smazat" ButtonType="ImageButton" UniqueName="DeleteColumn" />  
                                                      
                            <telerik:GridTemplateColumn HeaderText="Datum" UniqueName="datum"> 
                            <EditItemTemplate>
                                <table style=" border-collapse:collapse; border-width:0px;">
                                <tr>
                                    <td>
                                        <kspwc:TRadDatePicker runat="server" ID="rdp_datum" DbSelectedDate='<%# Bind("datum") %>' ></kspwc:TRadDatePicker>
                                    </td>
                                    <td>
                                        <kspwc:TRequiredValidator runat="server" ID="rv_datum" ControlToValidate="rdp_datum" ></kspwc:TRequiredValidator>
                                    </td>
                                </tr>
                                </table>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_datum" runat="server" Text='<%# DateTime.Parse(Eval("datum").ToString()).ToString("d") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn HeaderText="Ve věci" UniqueName="vec"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_vec" runat="server" Text='<%# Bind("vec") %>' MaxLength="50"></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_vec" ControlToValidate="text_vec" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_utvar" runat="server" Text='<%# Eval("vec") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>

                            <telerik:GridTemplateColumn  HeaderText="Kým jste byl/a předvolán/a (jméno a příjmení, telefonní číslo)" UniqueName="osoba"> 
                            <EditItemTemplate>
                                 <asp:TextBox ID="text_osoba" runat="server" Text='<%# Bind("osoba") %>' MaxLength="100"></asp:TextBox>
                                 <kspwc:TRequiredValidator runat="server" ID="rv_osoba" ControlToValidate="text_osoba" ></kspwc:TRequiredValidator>
                            </EditItemTemplate>
                            <ItemTemplate>
                                 <asp:Label ID="Label_osoba" runat="server" Text='<%# Eval("osoba") %>'></asp:Label>
                            </ItemTemplate> 
                            </telerik:GridTemplateColumn>                            
                        </Columns>
                      </MasterTableView>
                    </kspwc:TRadGrid>
            </div>
    </telerik:RadPageView>
    <telerik:RadPageView runat="server" ID="RadPage_7" Height="500">
        <div style="padding-top:15px;">
                Prohlašuji, že jsem se seznámil/a s inteními normami Compliance manuál a Prevence
                legalizace výnosů z trestné činnosti a financování terorismu a porozuměl/a jsem
                jejich obsahu. Údaje, které jsem výše uvedl/a, jsou pravdivé a úplné.
            </div>
            <table style="width: 100%; border-collapse: collapse">
                <tr>
                    <td align="right">
                         <span style="font-weight: bold;">ANO</span>                        
                    </td>
                    <td style="width:5px;">
                        <asp:CheckBox runat="server" ID="check_souhlas"  Checked='<%# Bind("souhlas") %>' />
                    </td>
                    <td class="zarkrt" style="width:110px;">
                        <span style="font-style:italic">(zaškrtněte odpověď)</span>
                    </td>
                </tr>                
            </table>
   </telerik:RadPageView>
    </telerik:RadMultiPage>
    
    <asp:CustomValidator ID="val_form" runat="server" ErrorMessage="CustomValidator" OnServerValidate="val_form_ServerValidator" Display="Dynamic"></asp:CustomValidator>
    <div style="padding-top:10px">
        <table>
            <tr>
            <td>
                <kspwc:TRadButton runat="server" ID="button_ulozit" CausesValidation="true" Text="[%Uložit%]" CommandName="Save" OnCommand="button_ulozit_OnCommand" Icon-PrimaryIconCssClass="fi fi-disk"></kspwc:TRadButton>
            </td>
            <td style="padding-left:20px">
                <kspwc:TRadButton ID="button_cancel" runat="server" Text="[%Zpět%]" CommandName="Cancel" OnCommand="button_ulozit_OnCommand" Icon-PrimaryIconCssClass="fi fi-ban" CausesValidation="False"/>
            </td>
            </tr>
        </table>
    </div>          
    </div>
    </EditItemTemplate>
    <InsertItemTemplate>
        <asp:Table runat="server" ID="TableInsert" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowInsert">
                <asp:TableCell runat="server" ColumnSpan="4" ID="TableCellItem14" SkinID="TitleRowStyle">
                   <%-- <asp:Label ID="Label7" runat="server" Text="[%Nový požadavek na náhradní volno%]"></asp:Label>--%>
                </asp:TableCell>
            </asp:TableHeaderRow>
        </asp:Table>
    </InsertItemTemplate>
</asp:FormView>


