﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="DashBoard.ascx.cs" Inherits="KSPortal.DashBoard.DashBoard" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
</telerik:RadAjaxManagerProxy>
<style type="text/css">
    div.rdTitleBar {
        color: white;
    }

    .P_dashboard {
        display: grid;
        grid-template-columns: 1fr 1fr 1fr;
        width: 100%;
    }

    .RadDockZone {
        padding: 10px;
        min-width: 100% -10px;
    }

    .RadDock {
        margin: auto;
        box-shadow: var(--stin);
        animation-name: RadDock;
        animation-duration: 2.5s;
        border-radius: var(--ksrohy);
        overflow: hidden;
        background: var(--kscolor2);
        color: var(--kscolor2text);
    }

    @keyframes RadDock {
        0% {
            opacity: 0%;
        }

        100% {
            opacity: 100%;
        }
    }

    @media only screen and (max-width: 1450px) { 
        .P_dashboard {
            grid-template-columns: 1fr 1fr;
        }
    }

    @media only screen and (max-width: 800px) {
        .P_dashboard {
            grid-template-columns: 1fr;
        }
    }
            @media only screen and (max-width: 830px) {
            .div-main, .table-main {
                width: 100% !important;

            }
            .master-table-td{
                padding-left: 10px !important;
                padding-right: 10px !important;
            }
        }
</style>
<script type="text/javascript">

    function ulozLayout() {

        var RDZ1 = $find("<%= RDZ1.ClientID %>");
        var RDZ2 = $find("<%= RDZ2.ClientID %>");
        var RDZ3 = $find("<%= RDZ3.ClientID %>");
        var RDZ4 = $find("<%= RDZ4.ClientID %>");
        var RDZ5 = $find("<%= RDZ5.ClientID %>");
        var RDZ6 = $find("<%= RDZ6.ClientID %>");

        var json = [];
        json.push(addToJson2("RDZ1", RDZ1._element.children));
        json.push(addToJson2("RDZ2", RDZ2._element.children));
        json.push(addToJson2("RDZ3", RDZ3._element.children));
        json.push(addToJson2("RDZ4", RDZ4._element.children));
        json.push(addToJson2("RDZ5", RDZ5._element.children));
        json.push(addToJson2("RDZ6", RDZ6._element.children));

        //var json = '{"RDL":[';

        //json = addToJson("RDZ1", RDZ1._element.children, json) + ',';
        //json = addToJson("RDZ2", RDZ2._element.children, json) + ',';
        //json = addToJson("RDZ3", RDZ3._element.children, json) + ',';
        //json = addToJson("RDZ4", RDZ4._element.children, json) + ',';
        //json = addToJson("RDZ5", RDZ5._element.children, json) + ',';
        //json = addToJson("RDZ6", RDZ6._element.children, json);

        //json = json + "]}";

        updateLayout(json);
    }

    function addToJson2(name, children) {
        var json = [];
        json.push({ "DZ": name });
        var arr = [];
        let index = 0;

        for (let i = 0; i < children.length; i++) {
            if (children[i].classList.contains("RadDock") && children[i].classList.contains("RadDock_Metro")) {
                var item = { "Name": children[i].id, "Position": index };
                arr.push(item);
                index++;
            }
        };

        json.push(arr);
        return json;
    }

    function addToJson(name, children, json) {
        json = json + '{ "' + name + '": [';
        let index = 0;

        for (let i = 0; i < children.length; i++) {
            if (children[i].classList.contains("RadDock") && children[i].classList.contains("RadDock_Metro")) {
                json = json + '{ "Name": "' + children[i].id + '", "Position": "' + index + '" },';
                index++;
            }
        };

        json = json + ']}';
        return json;
    }

    function updateLayout(json) {
        json = JSON.stringify(json);
        $.ajax({
            type: "POST",
            url: "./DashBoard/WebMethods.aspx/UlozLayout",
            data: "{obj: '~/DashBoard/DashBoardLayout1.ascx', data:'" + json + "'}",
            async: false,
            contentType: "application/json",
            dataType: "json",
            failure: function (response) {
                alert("Failure " + response.msg);
            },
            error: function (response) {
                alert("Error " + response.msg);
            },
            success: function (msg) {

            }
        });
    }

    Array.prototype.contains = function (obj) {
        var i = this.length;
        while (i--) {
            if (this[i] === obj) {
                return true;
            }
        }
        return false;
    }

</script>
<asp:Panel runat="server" ID="P_dashboard" CssClass="P_dashboard">
    <telerik:RadDockLayout ID="RDL" runat="server">

        <telerik:RadDockZone ID="RDZ1" runat="server" MinHeight="50" UniqueName="1" FitDocks="true" BorderStyle="None" CssClass="revertShadow">
        </telerik:RadDockZone>

        <telerik:RadDockZone ID="RDZ2" runat="server" MinHeight="50" UniqueName="2" FitDocks="true" BorderStyle="None">
        </telerik:RadDockZone>

        <telerik:RadDockZone ID="RDZ3" runat="server" MinHeight="50" UniqueName="3" FitDocks="true" BorderStyle="None">
        </telerik:RadDockZone>

        <telerik:RadDockZone ID="RDZ4" runat="server" MinHeight="50" UniqueName="4" FitDocks="true" BorderStyle="None">
        </telerik:RadDockZone>

        <telerik:RadDockZone ID="RDZ5" runat="server" MinHeight="50" UniqueName="5" FitDocks="true" BorderStyle="None">
        </telerik:RadDockZone>

        <telerik:RadDockZone ID="RDZ6" runat="server" MinHeight="50" UniqueName="6" FitDocks="true" BorderStyle="None">
        </telerik:RadDockZone>

    </telerik:RadDockLayout>
</asp:Panel>
