﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="PodpisDokumentu.aspx.cs" Inherits="KSPortal.Dokumenty.PodpisDokumentu" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="asp" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="kspwc" %>
<%@ Register Src="~/Dokumenty/PdfViewer.ascx" TagName="PdfViewer" TagPrefix="pdf" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <style type="text/css">
        .canvasSign {
            border: solid;
            border-color: lightgray;
            border-width: 0.5px;
            margin: auto;
            background-color: beige;
        }

        .podpisValidator {
            margin: auto;
            width: fit-content;
            display: block !important;
        }

        .pdbutton {
            background-color: var(--kscolor1) !important;
            border: none;
            color: var(--kscolor1text) !important;
            padding: 15px 32px !important;
            text-align: center;
            text-decoration: none;
            font-size: 16px !important;
            margin: 4px 2px;
            cursor: pointer !important;
        }

            .pdbutton:hover {
                box-shadow: 0 12px 16px 0 rgba(0,0,0,0.24),0 17px 50px 0 rgba(0,0,0,0.19);
            }

        .vyber1Div {
            padding-top: 25px;
            padding-bottom: 25px;
            text-align: center;
        }

        .podpisPole {
            margin: auto;
            width: fit-content;
            font-size: 10px;
        }

        .password-field {
            font-family: 'password' !important;
            -webkit-text-security: disc !important; /* Chrome, Safari */
            text-security: disc !important;      /* Neoficiální, Firefox nepodporuje */
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRB_DownloadClientService">
                <UpdatedControls></UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="B_CertSignStore">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadWindowPodpis" />
                    <telerik:AjaxUpdatedControl ControlID="P_HF" />
                    <telerik:AjaxUpdatedControl ControlID="PV_viewer" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_ClientSignComplete">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadWindowPodpis" />
                    <telerik:AjaxUpdatedControl ControlID="P_HF" />
                    <telerik:AjaxUpdatedControl ControlID="PV_viewer" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="certifikatBtn">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadWindowPodpis" />
                    <telerik:AjaxUpdatedControl ControlID="FileUpload1" />
                    <telerik:AjaxUpdatedControl ControlID="P_HF" />
                    <telerik:AjaxUpdatedControl ControlID="PV_viewer" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="handSing">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadWindowPodpis" />
                    <telerik:AjaxUpdatedControl ControlID="P_HF" />
                    <telerik:AjaxUpdatedControl ControlID="PV_viewer" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="signpadSign">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadWindowPodpis" />
                    <telerik:AjaxUpdatedControl ControlID="P_HF" />
                    <telerik:AjaxUpdatedControl ControlID="PV_viewer" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="ButtonSecurityCode">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadWindowPodpis" />
                    <telerik:AjaxUpdatedControl ControlID="secCode" />
                    <telerik:AjaxUpdatedControl ControlID="hashVal" />
                    <telerik:AjaxUpdatedControl ControlID="P_HF" />
                    <telerik:AjaxUpdatedControl ControlID="PV_viewer" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="dalsiKrokWf">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadWindowPodpis" />
                    <telerik:AjaxUpdatedControl ControlID="P_HF" />
                    <telerik:AjaxUpdatedControl ControlID="PV_viewer" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="Button2">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadWindowPodpis" />
                    <telerik:AjaxUpdatedControl ControlID="P_HF" />
                    <telerik:AjaxUpdatedControl ControlID="PV_viewer" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="Button1">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadWindowPodpis" />
                    <telerik:AjaxUpdatedControl ControlID="P_HF" />
                    <telerik:AjaxUpdatedControl ControlID="PV_viewer" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="btnOdmitnout">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="RadWindowPodpis" />
                <telerik:AjaxUpdatedControl ControlID="ErrorCert" />
                <telerik:AjaxUpdatedControl ControlID="P_HF" />
                <telerik:AjaxUpdatedControl ControlID="PV_viewer" />
            </UpdatedControls>
        </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="btnZpet">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadWindowPodpis" />
                    <telerik:AjaxUpdatedControl ControlID="P_HF" />
                    <telerik:AjaxUpdatedControl ControlID="PV_viewer" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="Button3">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="checkHashVal" />
                    <telerik:AjaxUpdatedControl ControlID="RadWindowPodpis" />
                    <telerik:AjaxUpdatedControl ControlID="P_HF" />
                    <telerik:AjaxUpdatedControl ControlID="P_main_btns" />
                    <telerik:AjaxUpdatedControl ControlID="PV_viewer" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_DownloadFiles">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRB_DownloadFiles" />
                    <telerik:AjaxUpdatedControl ControlID="PV_viewer" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="Button4">
                <UpdatedControls>
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>


    <asp:Label ID="Label2" runat="server" Text="[%Podpis dokumentu%]" CssClass="nadpis1"></asp:Label>
    <br />
    <asp:Panel ID="P_HF" runat="server">
        <asp:HiddenField runat="server" ID="HF_dokument" />
        <asp:HiddenField runat="server" ID="obrazekPodpisu" />
        <asp:HiddenField runat="server" ID="Podepsano" Value="n" />
        <asp:HiddenField runat="server" ID="jmenoPodepisovatele" Value="" />
        <asp:HiddenField runat="server" ID="referrerUrl" Value="" />
        <asp:HiddenField runat="server" ID="hashVal" Value="" />
        <asp:HiddenField runat="server" ID="checkHashVal" Value="" />
        <asp:HiddenField runat="server" ID="secCode" Value="" />
        <asp:HiddenField runat="server" ID="HF_Odmitnuto" />
    </asp:Panel>
    <table>
        <tr style="text-align: center;">
            <td>
                <pdf:PdfViewer runat="server" ID="PV_viewer" Height="750px" Width="800px" EnableDownload="false" EnablePrint="false"></pdf:PdfViewer>
            </td>

            <td style="padding: 20px;"></td>
            <td colspan="4" style="text-align: center;">
                <asp:Panel ID="P_main_btns" runat="server">
                    <%--<asp:Button ID="Button3" CssClass="button" runat="server" Text="[%Dokument zkontrolován%]" OnClick="btnPodpis_Click" Style="width: 100%" />--%>
                    <kspwc:TRadButton ID="Button3" CssClass="pdbutton" runat="server" Text="[%Dokument zkontrolován%]" OnClick="SecurityCode_Send" Style="width: 100%" />
                    <br />
                    <kspwc:TRadButton ID="btnOdmitnout" CssClass="pdbutton" runat="server" Text="[%Odmítnout podpis%]" Style="width: 100%" OnClick="btnOdmitnout_Click">
                        <ConfirmSettings UseRadConfirm="true" Title="[%Odmítnutí podpisu%]" ConfirmText="[%Tímto odmítnete podpis. Pokud máte vybráno více dokumentů, odmítnete podpis u všech.<br><br>Opravdu chcete odmítnout podpis?%]" />
                    </kspwc:TRadButton>
                    <br />
                    <kspwc:TRadButton ID="btnZpet" CssClass="pdbutton" runat="server" Text="[%Seznam dokumentů%]" Style="width: 100%" OnClick="btnZpet_Click" />
                    <br />
                    <kspwc:TRadButton ID="TRB_znovu" CssClass="pdbutton" runat="server" Text="[%Začít znovu%]" ValidationGroup="exit" Style="width: 100%" OnClick="TRB_znovu_Click" />
                </asp:Panel>
            </td>
        </tr>
    </table>


    <telerik:RadWindow ID="RadWindowPodpis" runat="server" Behaviors="Close,Move" Modal="false" OnClientShow="WindowAutosize"
        Title="[%Podepisování%]" VisibleOnPageLoad="false" OnItemCommand="WindowClosed" AutoSize="true">
        <ContentTemplate>
            <div runat="server" id="vyber1" visible="false" class="vyber1Div">
                <asp:Button CssClass="pdbutton" runat="server" ID="B_CertSignStore" OnClick="B_CertSignStore_Click" Text="[%Certifikátem v úložišti%]" />
                <asp:Button CssClass="pdbutton" runat="server" ID="certifikatBtn" OnClick="CertSign" Text="[%Certifikátem na disku%]" />
                <asp:Button CssClass="pdbutton" runat="server" ID="handSing" OnClick="HandSign" Text="[%Podepsat ručně%]" />
                <asp:Button CssClass="pdbutton" runat="server" ID="signpadSign" OnClick="SignPad" Text="[%Stáhnout k podpisu a nahrát zpět%]" />
                <asp:Button CssClass="pdbutton" runat="server" ID="B_bankID" OnClick="B_bankID_Click" Text="[%Podepsat Bank iD%]" />
            </div>
            <table>
                <div runat="server" id="vyberUdaje" visible="false">

                    <tr id="jmenoPole" runat="server">
                        <td>
                            <p>[%Podepsal%]:</p>
                        </td>
                        <td>
                            <telerik:RadTextBox runat="server" ID="jmenoTB" TextMode="SingleLine" autocomplete="off" Width="100%"></telerik:RadTextBox>
                            <asp:RequiredFieldValidator runat="server" ID="reqName" ControlToValidate="jmenoTB" ValidationGroup="vdisk" ErrorMessage="[%Vyplňte jméno%]!" />
                        </td>
                    </tr>
                    <tr>
                        <td><p style="width: fit-content">[%Místo podpisu%]:</p></td>
                        <td>
                            <div style="display: block ruby">
                                <telerik:RadTextBox runat="server" ID="mistoTB" TextMode="SingleLine" autocomplete="off" Width="100%"></telerik:RadTextBox>
                            </div>
                            <asp:RequiredFieldValidator runat="server" ID="RequiredFieldValidator1" CssClass="podpisValidator ksValidator" ValidationGroup="vdisk" ControlToValidate="mistoTB" Text="[%Vyplňte prosím místo podpisu%]" ErrorMessage="[%Vyplňte místo podpisu%]" Display="Dynamic" />
                        </td>
                    </tr>
                    <div runat="server" id="vyber2" visible="false">
                        <div runat="server" id="externiCertifikat" visible="false">
                            <tr>
                                <td>
                                    <p>[%Certifikát%]:</p>
                                </td>
                                <td>

                                    <telerik:RadAsyncUpload Skin="Metro" runat="server" ID="FileUpload1" MultipleFileSelection="Disabled" MaxFileInputsCount="1"
                                        Width="100%" AllowedFileExtensions="pfx,p12" data-clientFilter=".pfx,.p12" TemporaryFolder="~/Temp"
                                        OnClientAdded="OnClientAdded" OnClientFilesUploaded="rau_FilesUploaded" AutoAddFileInputs="true">
                                    </telerik:RadAsyncUpload>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <p>[%Heslo certifikátu%]:</p>
                                </td>
                                <td>
                                    <telerik:RadTextBox runat="server" ID="certTB" TextMode="SingleLine" autocomplete="off" CssClass="password-field" Width="100%"></telerik:RadTextBox>
                                </td>
                            </tr>
                        </div>
                        <tr>
                            <td colspan="2" style="text-align: center;">
                                <asp:Label runat="server" ID="errorLabel" Font-Size="Small" ForeColor="Red"></asp:Label>
                            </td>
                        </tr>

                        <tr>
                            <td colspan="2" style="text-align: center;">
                                <kspwc:TRadButton ID="Button1" runat="server" OnClick="PodepsatSoubor" Text="[%Podepsat soubor%]" ValidationGroup="vdisk" />
                        </tr>
                    </div>

                </div>
            </table>

            <div runat="server" id="vyberCertStore" visible="false">
                <kspwc:TRadComboBox ID="RCB_certificates" runat="server" Width="350" DropDownAutoWidth="Enabled" Label="[%Vyberte certifikát%]" AutoPostBack="false" OnClientLoad="RCB_certificates_Load">
                </kspwc:TRadComboBox>
                <telerik:RadLabel runat="server" ID="RL_InstalInfo" CssClass="hidden" Text="[%Na vašem počítači buď neběží služba pro zprostředkování certifikátů z místního úložiště, nebo je její verze neaktuální.<br><br><b>Jak postupovat:</b><br>1. <b>Stáhněte a spusťte instalátor služby.</b><br>2. <b>Zavřete všechna okna prohlížeče.</b><br>3. <b>Zkuste akci znovu.</b><br><br>Pokud problém přetrvává, ověřte, zda je služba <b>KS Client Service</b> správně nainstalovaná a spuštěná.%]"></telerik:RadLabel>
                <div>
                    <br />
                    <br />
                    <kspwc:TRadButton ID="RB_Sign" runat="server" Text="[%Podepsat%]" OnClientClicked="RB_Sign_Clicked" AutoPostBack="false" CssClass="kstlacitko"></kspwc:TRadButton>
                    <kspwc:TRadButton ID="TRB_DownloadClientService" runat="server" Text="[%Stáhnout instalátor služby%]" CssClass="no-block-ui hidden kstlacitko" OnClick="TRB_DownloadClientService_Click"></kspwc:TRadButton>
                    <kspwc:TRadButton ID="TRB_ClientSignComplete" runat="server" Text="complete" CssClass="hidden" OnClick="TRB_ClientSignComplete_Click"></kspwc:TRadButton>
                </div>
            </div>

            <div runat="server" id="vyber3" style="text-align: center;" visible="false">

                <br />
                <canvas id="podpisCanvas" class="canvasSign" width="600px" height="400px"></canvas>
                <p class="podpisPole">[%(podpisové pole)%]</p>
                <asp:CustomValidator runat="server" ID="VC_podpisValidator" Display="Dynamic" ErrorMessage="[%Podpisové pole nemůžete ponechat prázdné%]" ClientValidationFunction="isCanvasEmpty"></asp:CustomValidator>
                <br />
                <asp:Label runat="server" ID="ErrorCert" Font-Size="Small" ForeColor="Red" Text="[%Nemáte platný certifikát, dokument nelze podepsat%]" Visible="false"></asp:Label>
                <br />
                <kspwc:TRadButton ID="Button2" runat="server" OnClick="PodepsatSouborRucne" OnClientClicked="ulozPodpis" Text="[%Podepsat soubor%]" Width="100%" AutoPostBack="true" />

            </div>
            <div runat="server" id="div_Signpad" style="text-align: center;" visible="false">
                <br />
                <table>
                    <tr>
                        <td>
                            <kspwc:TLinkButton runat="server" ID="TRB_DownloadFiles" OnClick="TRB_DownloadFile_Click" DisableProgressBar="true"></kspwc:TLinkButton>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <p>[%Podepsaný dokument%]:</p>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <telerik:RadAsyncUpload Skin="Metro" runat="server" ID="RAU_FilesUpload" Width="100%" AllowedFileExtensions="pdf" data-clientFilter=".pdf"
                                OnClientAdded="OnClientAdded" MaxFileInputsCount="1" AutoAddFileInputs="true" OnClientFileUploaded="uploadEnabled" OnClientFilesUploaded="rau_FilesUploaded" TemporaryFolder="~/Temp">
                            </telerik:RadAsyncUpload>


                        </td>
                    </tr>
                </table>
                <label id="Label1" style="color: red">[%Nebyl vybrán soubor%]</label>
                <br />
                <kspwc:TRadButton ID="Button4" CssClass="Button4" runat="server" OnClick="ButtonUlozitSoubor_Click" Text="[%Uložit soubor%]" Enabled="false" />
                <br />
                <br />
                <br />
            </div>


            <div class="div4" runat="server" id="vyber4" visible="false" style="text-align: center">
                <p style="font-size: medium; width: 200px;">[%Bezpečnostní kód byl odeslán%].</p>
                <br>

                <telerik:RadTextBox runat="server" ID="securityCode" InputType="Text" MaxLength="6" Style="letter-spacing: 0.5em; height: 30px; font-size: large; text-align: center;"></telerik:RadTextBox>
                <br />
                <asp:Label runat="server" ID="platnostLbl" Text=""></asp:Label>
                <br />
                <asp:Label ID="FailureLabel2" Text="" runat="server" ForeColor="Red"></asp:Label>
                <br />
                <br />
                <kspwc:TRadButton ID="ButtonSecurityCode" runat="server" OnClick="ButtonSecurityCode_Click" Text="[%Potvrdit%]" Width="100%" />
            </div>

            <div runat="server" id="vyberWorkflow" visible="false">
                <br />
                <kspwc:TRadGrid ID="TRadGrid_Workflow" runat="server" ShowGroupPanel="False" AllowPaging="false" ShowFooter="false" ShowHeader="false"
                    AllowSorting="true" AutoGenerateColumns="false" AutoFilterControlWidth="false" MasterTableView-ShowFooter="False">

                    <%-- <GroupingSettings CaseSensitive="False" CollapseAllTooltip="Collapse all groups" ShowUnGroupButton="true"></GroupingSettings>--%>
                    <MasterTableView CommandItemDisplay="Top" Caption="[%Další krok workflow%]" DataKeyNames="id_poz,id_podpisu,kod_podpisu" ClientDataKeyNames="id_poz">
                        <Columns>
                            <telerik:GridBoundColumn DataField="nazevDokumentu" HeaderText="[%Název dokumentu%]" SortExpression="nazevDokumentu" />
                            <telerik:GridTemplateColumn UniqueName="DropDownStavy" HeaderText="[%Další krok%]">
                                <ItemTemplate>
                                    <kspwc:TRadComboBox ID="TRCB_stavy_pozad" runat="server" EnableLoadOnDemand="True"
                                        EnableVirtualScrolling="True" Height="150px" ShowMoreResultsBox="True" DropDownAutoWidth="Enabled" MarkFirstMatch="true"
                                        EmptyMessage="[%Další krok%]" AutoPostBack="false"
                                        CausesValidation="False" OnClientItemsRequesting="pozadavek_ItemsRequesting">
                                        <WebServiceSettings Method="GetStavyPozPodp" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                                    </kspwc:TRadComboBox>
                                </ItemTemplate>
                            </telerik:GridTemplateColumn>
                        </Columns>
                        <CommandItemTemplate>
                            <%--<kspwc:GridCommandItemControl ID="GcIc3" runat="server"></kspwc:GridCommandItemControl>--%>
                        </CommandItemTemplate>
                    </MasterTableView>
                    <%--<ClientSettings AllowDragToGroup="True" EnablePostBackOnRowClick="true">
                        <Selecting AllowRowSelect="true" />
                    </ClientSettings>--%>
                </kspwc:TRadGrid>
                <br />
                <asp:Button ID="dalsiKrokWf" runat="server" OnClick="dalsiKrokWf_Click" Text="[%Dokončit%]" Width="100%" />
                <br />
                <asp:Label runat="server" ID="errorLabel2" Font-Size="Small" ForeColor="Red"></asp:Label>
            </div>

        </ContentTemplate>
    </telerik:RadWindow>

    <telerik:RadScriptBlock ID="rsb_pd" runat="server">
        <script type="text/javascript" src="../Scripts/signature_pad.min.js"></script>
    </telerik:RadScriptBlock>

    <telerik:RadScriptBlock runat="server" ID="rcb_pd">
        <script type="text/javascript">

            const signApi = new KSClientSign();

            Sys.Application.add_load(function () {
            });

            function zobrazPodpis() {

                var canvas = document.getElementById("podpisCanvas");
                signaturePad = new SignaturePad(canvas);
            }
            function ulozPodpis(sender, args) {
                debugger;
                var dataURL = document.getElementById("podpisCanvas").toDataURL();
                document.getElementById('<%= obrazekPodpisu.ClientID%>').value = dataURL;

            }

            function OnClientAdded(sender, args) {
                var allowedMimeTypes = $telerik.$(sender.get_element()).attr("data-clientFilter");
                $telerik.$(args.get_row()).find(".ruFileInput").attr("accept", allowedMimeTypes);
            }

            function rau_FilesUploaded(sender, args) {
                WindowAutosize();
            }

            function pozadavek_ItemsRequesting(sender, args) {
                sender.clearItems();
                var context = args.get_context();
                var row = getParentRow(sender);
                if (row) {
                    context["id_poz"] = row.getDataKeyValue("id_poz");
                    context["odmitnuto"] = document.getElementById('<%= HF_Odmitnuto.ClientID %>').value;
                }

            }

            function getParentRow(sender) {
                var ret;
                var ownerGridElement = sender.get_element();
                var parentRowId = $(ownerGridElement).parents("tr").first()[0].id;
                var masterViewId = $(ownerGridElement).parents("table")[0].id
                if (parentRowId != "" && masterViewId != "") {
                    var tv = $find(masterViewId);
                    tv.get_dataItems();
                    ret = $find(parentRowId);
                }
                return ret;
            }

            function timeout() {
                setTimeout(function () {
                    document.getElementById('<%= checkHashVal.ClientID %>').value = "";
                }, timeForTimeout);

            }
            function setTimeoutTime(time) {
                timeForTimeout = Number(time) * 60000;

            }

            timeForTimeout = 150000;

            function zobrazChybu(chyba) {
                var label = document.getElementById("Label1");
                label.innerText = chyba;
            }

            function uploadEnabled() {
                var label = document.getElementById("Label1");
                label.innerText = "";
                var button = $find('<%= Button4.ClientID %>');
                button.set_enabled(true);

                WindowAutosize();
            }

            function isCanvasEmpty(sender, args) {
                var cnv = document.getElementById('podpisCanvas');
                const blank = document.createElement('canvas');

                blank.width = cnv.width;
                blank.height = cnv.height;

                var bool = cnv.toDataURL() === blank.toDataURL();

                args.IsValid = !bool;
                WindowAutosize();
            }
            function WindowAutosize() {
                setTimeout(function () {
                    var win = $find('<%= RadWindowPodpis.ClientID %>');
                    win.autoSize();
                }, 100);
            }
            async function RCB_certificates_Load(sender, args) {
                BindStoreCertificates();
            }

            var tsUrl = "<%= KSProgram.Parametry.ParametrCti("CasoveRazitkoHR").Trim() %>";
            var tsUser = "<%= KSProgram.Parametry.ParametrCti("CasoveRazLoginHR").Trim() %>";
            var tsPass = "<%= KSProgram.Parametry.ParametrCti("CasoveRazHesloHR").Trim() %>";

            function RB_Sign_Clicked(sender, args) {
                const rcbCertificates = $find("<%= RCB_certificates.ClientID %>");
                if (rcbCertificates) {
                    const selectedItem = rcbCertificates.get_selectedItem();
                    if (selectedItem) {
                        const thumb = selectedItem.get_value();

                        setCookie("selectedCertThumbprint", thumb, 365); // Uložíme na 1 rok

                        PageMethods.GetClientSignContract(function (data) {
                            if (data) {
                                // Seznam všech operací, které musíme dokončit
                                const signPromises = data.map(f =>
                                    new Promise((resolve, reject) => {
                                        PageMethods.GetClientSignContractFile(f.id, function (result) {
                                            if (result) {
                                                signApi.signPdf(result.file, result.znacka, thumb, result.id, tsUrl, tsUser, tsPass)
                                                    .then(signedfile => {
                                                        PageMethods.SaveClientSignContractFile(signedfile.file, signedfile.id, function () {
                                                            resolve(); // Označíme operaci jako hotovou
                                                        }, function (error) { 
                                                            reject(error);
                                                        });
                                                    })
                                                    .catch(error => {
                                                        console.error("Chyba při podpisu PDF:", error);
                                                        reject(error); // Označíme operaci jako neúspěšnou
                                                    });
                                            } else {
                                                console.error("Chyba při získávání souboru pro podpis");
                                                reject("Chyba při získávání souboru"); // Označíme operaci jako neúspěšnou
                                            }
                                        }, function (error) {
                                            console.error("Chyba při získávání souboru pro podpis:", error);
                                            reject(error); // Označíme operaci jako neúspěšnou
                                        });
                                    })
                                );

                                // Po dokončení všech podpisů klikneme na tlačítko
                                Promise.all(signPromises)
                                    .then(() => {
                                        const trbComplete = $find("<%= TRB_ClientSignComplete.ClientID %>");
                                        trbComplete.click();
                                    })
                                    .catch(error => {
                                        console.error("Chyba během procesu podepisování:", error);
                                    });
                            } else {
                                console.error("Chyba při získávání informací o podpisech");
                            }
                        }, function (error) {
                            console.error("Chyba při získávání informací o podpisech:", error);
                        });
                    }
                }
            }


            async function BindStoreCertificates() {
                const apiOk = await signApi.testApi();
                if (apiOk) {
                    const certificates = await signApi.getCertificates(); // Zajistěte, že getCertificates vrací Promise

                    // Najdeme RadComboBox
                    const rcbCertificates = $find("<%= RCB_certificates.ClientID %>");
                    if (!rcbCertificates) {
                        console.error("RadComboBox nebyl nalezen.");
                        return;
                    }

                    // Získáme naposledy vybraný certifikát z cookie
                    const lastSelectedThumbprint = getCookie("selectedCertThumbprint");

                    // Začneme sledovat změny
                    rcbCertificates.trackChanges();

                    // Vyčistíme existující položky
                    rcbCertificates.get_items().clear();

                    let selectedIndex = 0; // Defaultně vybereme první certifikát

                    // Přidáme certifikáty do RadComboBox
                    for (let i = 0; i < certificates.length; i++) {
                        const cert = certificates[i];
                        const comboItem = new Telerik.Web.UI.RadComboBoxItem();
                        comboItem.set_text(cert.name); // Zobrazovaný text
                        comboItem.set_value(cert.thumbprint); // Hodnota
                        rcbCertificates.get_items().add(comboItem);

                        // Pokud je certifikát v cookie, nastavíme jej jako vybraný
                        if (cert.thumbprint === lastSelectedThumbprint) {
                            selectedIndex = i;
                        }
                    }

                    // Nastavíme vybraný certifikát
                    if (certificates.length > 0) {
                        rcbCertificates.get_items().getItem(selectedIndex).select();
                    }

                    // Potvrdíme změny
                    rcbCertificates.commitChanges();
                }
                else { //služba neběží
                    const rcbCertificates = $find("<%= RCB_certificates.ClientID %>");
                    const rlInstalInfo = $get("<%= RL_InstalInfo.ClientID %>");
                    const rbSign = $find("<%= RB_Sign.ClientID %>");
                    const rbDownload = $find("<%= TRB_DownloadClientService.ClientID %>");
                    const wPodpis = $find("<%= RadWindowPodpis.ClientID %>");

                    if (rcbCertificates) {
                        rcbCertificates.get_element().classList.add("hidden");
                    }

                    if (rlInstalInfo) {
                        rlInstalInfo.classList.remove("hidden");
                    }

                    if (rbSign) {
                        rbSign.get_element().classList.add("hidden");
                    }

                    if (rbDownload) {
                        rbDownload.get_element().classList.remove("hidden");
                    }

                    if (wPodpis) {
                        wPodpis.setSize(280, 350);
                        wPodpis.center();
                    }
                }
            }
            // Funkce pro získání hodnoty cookie podle jména
            function getCookie(name) {
                const cookies = document.cookie.split("; ");
                for (let i = 0; i < cookies.length; i++) {
                    const [cookieName, cookieValue] = cookies[i].split("=");
                    if (cookieName === name) {
                        return decodeURIComponent(cookieValue);
                    }
                }
                return null;
            }

            // Funkce pro nastavení cookie
            function setCookie(name, value, days) {
                const d = new Date();
                d.setTime(d.getTime() + days * 24 * 60 * 60 * 1000);
                document.cookie = `${name}=${encodeURIComponent(value)}; expires=${d.toUTCString()}; path=/`;
            }
        </script>

    </telerik:RadScriptBlock>
</asp:Content>
