﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    Inherits="Sestavy_Hodnoceni_KUZK" Codebehind="Hodnoceni_KUZK.aspx.cs" %>

<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <asp:ObjectDataSource ID="DS_hlavicka" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="Hlavicka" TypeName="KSProgram.Hodnoceni.Hodnoceni">
        <SelectParameters>
            <asp:Parameter Name="Id" Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:FormView ID="FV_hlavicka" runat="server" DataSourceID="DS_hlavicka" OnDataBinding="FV_hlavicka_DataBinding"
        DataKeyNames="os_cislo,datum_od,datum_do">
        <ItemTemplate>
            <table style="border-color: #000000; border-collapse: collapse; border-style: solid;
                border-width: thin" width="640px">
                <tr style="border-color: #000000; border-collapse: collapse; border-style: solid;
                    border-width: thin">
                    <td style="padding: 5px; background-color: #C0C0C0;" align="center">
                        <asp:Label ID="LabelNazevAkce" runat="server" Font-Bold="True" Font-Size="Large"
                            Text="Záznamový list hodnocení"></asp:Label><br />
                        <asp:Label ID="LabelDbNazevAkce" runat="server" Font-Bold="True" Font-Size="Larger"
                            Text='<%# Bind("nazev_akce") %>'></asp:Label>
                    </td>
                </tr>
            </table>
            <br />
            <table style="border-color: #000000; border-collapse: collapse; border-style: solid;
                border-width: thin" width="640px">
                <tr style="border-color: #000000; border-collapse: collapse; border-style: solid;
                    border-width: thin">
                    <td style="padding: 5px">
                        <asp:Label ID="LabelJmeno" runat="server" Text="Hodnocený zaměstnanec: "></asp:Label>
                    </td>
                    <td style="padding: 5px">
                        <asp:Label ID="LabelDbJmeno" runat="server" Font-Bold="True" Font-Size="Larger" Text='<%# Bind("zamestnanec") %>'></asp:Label>
                    </td>
                    <td style="padding: 5px; border-left-style: solid; border-left-width: thin; border-left-color: #000000">
                        <asp:Label ID="LabelOsCislo" runat="server" Text="Os. číslo: "></asp:Label>
                    </td>
                    <td style="padding: 5px">
                        <asp:Label ID="LabelDbOsCislo" runat="server" Text='<%# Bind("os_cislo") %>'></asp:Label>
                    </td>
                </tr>
                <tr style="border-color: #000000; border-collapse: collapse; border-style: solid;
                    border-width: thin">
                    <td style="padding: 5px">
                        <asp:Label ID="LabelNazevMista" runat="server" Text="Název pracovního místa: "></asp:Label>
                    </td>
                    <td style="padding: 5px">
                        <asp:Label ID="LabelDbNazevMista" runat="server" Text='<%# Bind("prac_misto") %>'></asp:Label>
                    </td>
                    <td style="padding: 5px; border-left-style: solid; border-left-width: thin; border-left-color: #000000">
                        <asp:Label ID="LabelCisloMista" runat="server" Text="Číslo PM: "></asp:Label>
                    </td>
                    <td style="padding: 5px">
                        <asp:Label ID="LabelDbCisloMista" runat="server" Text='<%# Bind("cislo_PM") %>'></asp:Label>
                    </td>
                </tr>
                <tr style="border-color: #000000; border-collapse: collapse; border-style: solid;
                    border-width: thin">
                    <td style="padding: 5px">
                        <asp:Label ID="LabelOdbor" runat="server" Text="Odbor: "></asp:Label>
                    </td>
                    <td style="padding: 5px" colspan="3">
                        <asp:Label ID="LabelDbOdbor" runat="server" Text='<%# Bind("stredisko") %>'></asp:Label>
                    </td>
                </tr>
                <tr style="border-color: #000000; border-collapse: collapse; border-style: solid;
                    border-width: thin">
                    <td style="padding: 5px">
                        <asp:Label ID="LabelObdobi" runat="server" Text="Hodnocené období: "></asp:Label>
                    </td>
                    <td style="padding: 5px" colspan="3">
                        <asp:Label ID="LabelDbObdobiOd" runat="server" Text='<%# Eval("datum_od", "{0:d}") %>'></asp:Label>
                        -
                        <asp:Label ID="LabelDbObdobiDo" runat="server" Text='<%# Eval("datum_do", "{0:d}") %>'></asp:Label>
                    </td>
                </tr>
            </table>
        </ItemTemplate>
    </asp:FormView>
    <br />
    <div runat="server" id="DIV_kompetence">
        <table style="border-collapse: collapse; border-style: none;" width="640px">
            <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                <td style="background-color: #C0C0C0" align="left">
                    <asp:Label ID="LabelNadpisKompetence" runat="server" Font-Bold="True" Font-Size="Larger"
                        Text="A. Kompetenční profil"></asp:Label><br />
                </td>
            </tr>
        </table>
        <br />
        <asp:ObjectDataSource ID="ODS_typy_kompetenci" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="Typy_kompetenci" TypeName="KSProgram.Hodnoceni.Hodnoceni">
            <SelectParameters>
                <asp:Parameter Name="Id" Type="Int32" />
                <asp:Parameter Name="sta_edt" Type="Int16" DefaultValue="2" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <asp:Repeater ID="REP_typy_kompetenci" runat="server" DataSourceID="ODS_typy_kompetenci"
            OnDataBinding="REP_typy_kompetenci_DataBinding" OnItemDataBound="REP_typy_kompetenci_ItemDataBound">
            <ItemTemplate>
                <asp:ObjectDataSource ID="ODS_kompetence" runat="server" SelectMethod="Kompetence"
                    TypeName="KSProgram.Hodnoceni.Hodnoceni">
                    <SelectParameters>
                        <asp:Parameter Name="Id" Type="Int32" />
                        <asp:Parameter Name="typ_kompetenci" Type="Int32" />
                        <asp:Parameter Name="sta_edt" Type="Int16" DefaultValue="2" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <wc:TGridView ID="TGV_kompetence" runat="server" ShowTitleRow="False" DataKeyNames="idp,sta_edt,pozadavek"
                    Width="640px" AllowSorting="False" OnRowDataBound="TGV_kompetence_RowDataBound"
                    HeaderStyle-BackColor="#F2DBDB" CssClass="pageBreakInsideAvoid">
                    <Columns>
                        <asp:BoundField DataField="vyznam" HeaderText="[%Kompetence%]" HeaderStyle-HorizontalAlign="Left"
                            ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                            ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                            HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" />
                        <asp:TemplateField HeaderText="[%Hodnocení%]" ItemStyle-Width="110px" ItemStyle-HorizontalAlign="Center"
                            HeaderStyle-HorizontalAlign="Center" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                            ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                            HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black">
                            <ItemTemplate>
                                <asp:Label ID="LabelDbHodnoceni" runat="server"></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Požadavky na úroveň kompetence" ItemStyle-Width="110px"
                            ItemStyle-HorizontalAlign="Center" HeaderStyle-HorizontalAlign="Center" ItemStyle-BackColor="White"
                            ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                            ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                            HeaderStyle-ForeColor="Black">
                            <ItemTemplate>
                                <asp:Label ID="LabelDbPozadavek" runat="server"></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                    <TitleRowStyle BackColor="LightGray" BorderColor="Black" BorderWidth="1px" BorderStyle="Solid"
                        Font-Bold="True" Font-Size="13px" ForeColor="Black" />
                    <FooterStyle BackColor="LightGray" />
                </wc:TGridView>
                <br />
            </ItemTemplate>
        </asp:Repeater>
    </div>
    <table style="border-collapse: collapse; border-style: none;" width="640px" class="pageBreakInsideAvoid">
        <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
            <td style="background-color: #C0C0C0" align="left">
                <asp:Label ID="Label1" runat="server" Font-Bold="True" Font-Size="Larger" Text="B. Závěr hodnotícího rozhovoru"></asp:Label><br />
            </td>
        </tr>
    </table>
    <br />
    <div runat="server" id="DIV_VzdeAkce" class="pageBreakInsideAvoid">
        <asp:ObjectDataSource ID="ODS_Skoleni" runat="server" TypeName="KSProgram.Hodnoceni.Hodnoceni"
            SelectMethod="Skoleni">
            <SelectParameters>
                <asp:Parameter Name="Id" Type="Int32" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <wc:TGridView ID="TGV_Skoleni" runat="server" ShowTitleRow="True" Width="640px" AllowSorting="False"
            DataSourceID="ODS_Skoleni" TitleText="Vyhodnocení rozvojových aktivit z minulého období:"
            OnDataBinding="TGV_Skoleni_DataBinding" HeaderStyle-BackColor="#F2DBDB" OnRowDataBound="TGV_Skoleni_RowDataBound">
            <Columns>
                <asp:BoundField DataField="nazev" HeaderText="Rozvojová aktivita" ItemStyle-BackColor="White"
                    ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                    ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                    HeaderStyle-ForeColor="Black" />
                <asp:TemplateField HeaderText="Splněno (datum)" ItemStyle-Width="120px" HeaderStyle-HorizontalAlign="Center"
                    ItemStyle-HorizontalAlign="Center" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                    ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                    HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black">
                    <ItemTemplate>
                        <asp:Label ID="LabelDbSplneno" runat="server"></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="doporuceni" HeaderText="Poznámky" ItemStyle-Width="200px"
                    ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                    ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                    HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" />
            </Columns>
        </wc:TGridView>
        <br />
        <table style="border-color: #000000; border-collapse: collapse; border-style: solid;
            border-width: thin" width="640px">
            <tr style="border-color: #000000; border-collapse: collapse; border-style: solid;
                border-width: thin">
                <td style="padding: 5px; height: 150px; vertical-align: top;">
                    <asp:Label ID="Label3" runat="server" Text="Komentář k plnění/neplnění rozvojových aktivit:"
                        Font-Bold="True"></asp:Label>
                </td>
            </tr>
        </table>
        <br />
    </div>
    <div runat="server" id="DIV_DopVzde" class="pageBreakInsideAvoid">
        <asp:ObjectDataSource ID="ODS_Vzdelavani" runat="server" TypeName="KSProgram.Hodnoceni.Hodnoceni"
            SelectMethod="Vzdelavani">
            <SelectParameters>
                <asp:Parameter Name="Id" Type="Int32" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <wc:TGridView ID="TGV_DopVzde" runat="server" ShowTitleRow="True" Width="640px" AllowSorting="False"
            DataSourceID="ODS_Vzdelavani" TitleText="Rozvojové aktivity do nastávajícího období:"
            OnDataBinding="TGV_DopVzde_DataBinding" HeaderStyle-BackColor="#F2DBDB">
            <Columns>
                <asp:BoundField DataField="nazev" HeaderText="Rozvojová aktivita" ItemStyle-BackColor="White"
                    ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                    ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                    HeaderStyle-ForeColor="Black" />
                <asp:BoundField DataField="termin" HeaderText="Termín" ItemStyle-Width="120px" DataFormatString="{0:d/M/yyyy}"
                    HtmlEncode="False" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center"
                    ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                    ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                    HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" />
                <asp:TemplateField HeaderText="Poznámky" ItemStyle-Width="200px" ItemStyle-BackColor="White"
                    ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                    ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                    HeaderStyle-ForeColor="Black"></asp:TemplateField>
            </Columns>
        </wc:TGridView>
        <br />
    </div>
    <div runat="server" id="DIV_Slovni">
        <table style="border-collapse: collapse; border-style: none;" width="640px">
            <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                <td style="background-color: #C0C0C0" align="left">
                    <asp:Label ID="Label2" runat="server" Font-Bold="True" Font-Size="Larger" Text="C. Doplňující komentáře"></asp:Label><br />
                </td>
            </tr>
        </table>
        <br />
        <asp:ObjectDataSource ID="ODS_slovni" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="Slovni" TypeName="KSProgram.Hodnoceni.Hodnoceni">
            <SelectParameters>
                <asp:Parameter Name="Id" Type="Int32" />
                <asp:Parameter DefaultValue="2" Name="sta_edt" Type="Int16" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <asp:Repeater ID="REP_slovni" runat="server" DataSourceID="ODS_slovni" 
            OnDataBinding="REP_slovni_DataBinding" 
            onitemdatabound="REP_slovni_ItemDataBound">
            <ItemTemplate>
                <table style="border-color: #000000; border-collapse: collapse; border-style: solid;
                    border-width: thin" width="640px" class="pageBreakInsideAvoid">
                    <tr style="border-color: #000000; border-collapse: collapse; border-style: solid;
                        border-width: thin">
                        <td style="padding: 5px; height: 150px; vertical-align: top;">
                            <asp:Label ID="Label1" runat="server" Text='<%# Bind("vyznam") %>' Font-Bold="True"></asp:Label><br />
                            <asp:Label ID="L_slovni_popis" runat="server" Text='<%# Bind("popis") %>'></asp:Label><br />
                            <asp:Label ID="TB_poznamka" runat="server" BorderWidth="1px" BorderStyle="Solid"
                                BorderColor="#666666" BackColor="White" Font-Size="Larger"></asp:Label>
                        </td>
                    </tr>
                </table>
                <br />
            </ItemTemplate>
        </asp:Repeater>
    </div>
    <table style="border-color: #000000; border-collapse: collapse; border-style: solid;
        border-width: thin" width="640px" class="pageBreakInsideAvoid">
        <tr style="border-color: #000000; border-collapse: collapse; border-style: solid;
            border-width: thin">
            <td style="padding: 5px">
                <asp:Label ID="LabelPodpisHodnoceneho" runat="server" Text="Datum a podpis hodnoceného:"></asp:Label>
            </td>
        </tr>
        <tr style="border-color: #000000; border-collapse: collapse; border-style: solid;
            border-width: thin">
            <td style="padding: 5px">
                <asp:Label ID="LabelPodpisHodnotitele" runat="server" Text="Datum a podpis hodnotitele:"></asp:Label>
            </td>
        </tr>
    </table>
    <%--<br />
    <asp:Label ID="LabelRozdelovnik" runat="server" Text="Rozdělovník: 1x hodnotitel, 1x hodnocený, 1x odbor ŘLZ/OPVV"
        Font-Size="Smaller"></asp:Label>--%>
</asp:Content>
