﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="Hodnoceni_Sebehodnoceni.aspx.cs" Inherits="Sestavy_Hodnoceni_Sebehodnoceni" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<%@ Register Src="~/Hodnoceni/Controls/HodnCile.ascx" TagName="HodnCile" TagPrefix="wc" %>
    
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <style type="text/css">
        .nadpis-bold {
            font-weight: bold;
        }

            .nadpis-bold > td {
                border: 1px solid black !important;
            }

        table.hla-table-body > tbody > tr > td:first-of-type  {
            white-space: nowrap;
        }

        .k-pdf-export .nadpis-bold {
            font-weight: normal;
            font-family: Segoe UI Bold !important;
        }

        .ksLegendWrapper {
            text-align: center;
            padding-top: 15px;
        }

            .ksLegendWrapper div {
                display: inline-grid;
            }

        .ksLegend {
            background-color: white;
            color: black;
            display: inline-block !important;
            *display: inline !important;
            zoom: 1;
            padding: 0px 5px 20px 5px;
        }

            .ksLegend div {
                display: inline-block;
                *display: inline;
                zoom: 1;
                margin: 0px 5px;
                height: 20px;
            }

                .ksLegend div div {
                    width: 10px;
                    height: 10px;
                    vertical-align: -1px;
                    _vertical-align: middle;
                }

        .ksLegendKomp {
            background-color: white;
            color: black;
            display: block !important;
            *display: inline;
            zoom: 1;
            padding: 0px 5px 20px 5px;
            text-align: left;
        }

            .ksLegendKomp div {
                text-align: center;
            }

                .ksLegendKomp div div {
                    display: inline-block;
                    *display: inline;
                    zoom: 1;
                    margin: 0px 5px;
                    height: 20px;
                    text-align: left;
                }

                    .ksLegendKomp div div div {
                        width: 17px;
                        height: 17px;
                        vertical-align: -1px;
                        _vertical-align: middle;
                        display: inline-block;
                        text-align: center;
                    }

        .ksLegendSelected {
            font-weight: bold;
        }
        .ksChart {

        }

        .HodnCile_footer {
            font-size: larger !important;
        }

        .HodnCile_footer, .HodnCile_item > td {
            font-weight: bold !important;
            background-color: lightgray !important;
        }
        .HodnCile_header a {

        }

        .HodnCile_detail_header a {
            font-weight: normal !important;
        }

        .ksPrint .rgCaption {
            display: none !important;
        }

        .k-pdf-export .HodnCile_footer,
        .k-pdf-export .HodnCile_item > td,
        .k-pdf-export .HodnCile_header a {
            font-weight: normal !important;
            font-family: Segoe UI Bold !important;
        }

        .HodnCile_detail_textRow{
            width: 250px !important;
        }

        table.theme_gridview {
            border: 1px solid black !important;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadCodeBlock ID="RadScriptBlock1" runat="server">
        <script type="text/javascript" id="telerikClientEvents1">
            //<![CDATA[

            var oldPageLoad1 = !oldPageLoad1 ? KSMaster.onPageLoad : oldPageLoad1;
            KSMaster.onPageLoad = function () {
                oldPageLoad1.apply();
                setEvents();
                setWidthOfAutosizeElements();
            };
            KSMaster.onPageLoad.prototype = oldPageLoad1.prototype;

            function setEvents() {
                $("div.legenda")
                    .mouseout(function (event) {
                        var shortcut = getShortCut(event);
                        deboldLegend(shortcut);
                        toggleSeries(false, shortcut);
                    })
                    .mouseover(function (event) {
                        var shortcut = getShortCut(event);
                        boldLegend(shortcut);
                        toggleSeries(true, shortcut);
                    });
                $("div.ksChart")
                    .mouseout(function (event) {
                        deboldAll();
                    });
            }
            function getShortCut(event) {
                return event.target.id.split("_")[1];
            }
            function boldLegend(shortcut) {
                $get("legenda_" + shortcut).classList.add("ksLegendSelected");
            }

            function deboldLegend(shortcut) {
                $get("legenda_" + shortcut).classList.remove("ksLegendSelected");
            }

            function SeriesHower(sender, args) {
                deboldAll();
                boldLegend(sender.dataItem.short);
            }

            function deboldAll()
            {
                var ch = getChart();
                if (ch) {
                    var labels = ch.getAxis("kompetence")._axis.labels;
                    for (var i = 0; i < labels.length; i++) {
                        deboldLegend(labels[i].dataItem.short);
                    }
                }
            }

            function toggleSeries(value, shortcut) {
                var ch = getChart();
                if (ch) {
                    for (var i = 0; i < 3; i++) {
                        var series = ch.findSeriesByIndex(i);
                        if (series) {
                            series.toggleHighlight(value, function (point) {
                                return point.dataItem.short == shortcut;
                            });
                        }
                    }
                }
            }
            function getChart() {
                var ch = $("div.ksChart");
                return ch[0] ? $find(ch[0].id).get_kendoWidget() : null;
            }

            function exportToPdf(sender, args) {
                var cem = $find("<%=RadClientExportManager1.ClientID%>");
                var printPanel = $telerik.$(".printPanel");
                var blocks = $telerik.$(".pageBreakInsideAvoid");

                var top = getOffsetTop(printPanel[0]);
                var width = printPanel[0].offsetWidth;

                for (var i = 0; i < blocks.length; i++) {
                    var blok = blocks[i];
                
                    if (((getOffsetTop(blok) + blok.offsetHeight - top) / width) > (392 / 277)) {//(470 / 374)) {
                        while (blok.classList.contains("pageBreakBeforeAvoid")) {
                            i -= 1;
                            blok = blocks[i];
                        }
                        blok.classList.add("pageBreak");
                        top = getOffsetTop(blok);
                    }
                }
                cem.exportPDF($telerik.$(".printPanel")); 
            }

            function setWidthOfAutosizeElements() {
                var els = $telerik.$(".scriptWidth");
                for(var i = 0; i < els.length; i++) {
                    var elm = els[i];
                    elm.style.width = window.getComputedStyle(elm).width;
                }
            }

            function tiskWindow(sender, args) {
                window.print();
            }

            function getOffsetTop(elm) {
                var ret = 0;
                if (elm.offsetParent) {
                    ret = getOffsetTop(elm.offsetParent);
                    ret += elm.offsetTop;
                }
                return ret;
            }
            //]]>
        </script>
    </telerik:RadCodeBlock>
    <telerik:RadClientExportManager ID="RadClientExportManager1" runat="server">
        <PdfSettings PageBreakSelector=".pageBreak" MarginRight="10mm"
            MarginBottom="15mm" MarginTop="15mm" MarginLeft="10mm" PaperSize="A3" />
    </telerik:RadClientExportManager>
    <telerik:RadButton ID="RB_Print" runat="server" Text="[%Tisk%]" CssClass="tiskHide"
        AutoPostBack="False" OnClientClicked="tiskWindow">
    </telerik:RadButton>
    <telerik:RadButton ID="RB_Pdf" runat="server" Text="[%Export do PDF%]" CssClass="tiskHide"
        AutoPostBack="False" OnClientClicked="exportToPdf">
    </telerik:RadButton>
    <asp:Panel ID="PanelPrint" runat="server" CssClass="printPanel " Width="20.75cm">
        <asp:ObjectDataSource ID="DS_hlavicka" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="Hlavicka" TypeName="KSProgram.Hodnoceni.Hodnoceni">
            <SelectParameters>
                <asp:Parameter Name="Id" Type="Int32" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <div class="pageBreakInsideAvoid">
            <asp:FormView ID="FV_hlavicka" runat="server" DataSourceID="DS_hlavicka" OnDataBinding="FV_hlavicka_DataBinding"
                DataKeyNames="os_cislo,datum_od,datum_do" OnDataBound="FV_hlavicka_DataBound"
                Width="100%">
                <ItemTemplate>
                    <table style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: 0px"
                        width="100%">
                        <tr style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: 1px">
                            <td style="padding: 5px; border-color: #000000; border-collapse: collapse; border-style: solid; border-width: 1px">
                                <asp:Image ID="I_logo" runat="server" />
                            </td>
                            <td style="padding: 5px; background-color: #C0C0C0; width: 100%;" align="center">
                                <asp:Label ID="LabelNazevAkce" runat="server" CssClass="nadpis-bold" Font-Size="Large"
                                    Text="[%Záznamový list hodnocení%]"></asp:Label><br />
                                <asp:Label ID="LabelDbNazevAkce" runat="server" CssClass="nadpis-bold" Font-Size="Larger"
                                    Text='<%# Bind("nazev_akce") %>'></asp:Label>
                            </td>
                        </tr>
                    </table>
                    <br />
                    <table style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: 1px"
                        width="100%" class="hla-table-body">
                        <tr style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: 1px">
                            <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                                <asp:Label ID="LabelJmeno" runat="server" Text="[%Hodnocený zaměstnanec%]: "></asp:Label>
                            </td>
                            <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                                <asp:Label ID="LabelDbJmeno" runat="server" CssClass="nadpis-bold" Font-Size="Larger" Text='<%# Bind("zamestnanec") %>'></asp:Label>
                            </td>
                            <td style="padding: 5px; border-left-style: solid; border-left-width: 1px; border-left-color: #000000; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                                <asp:Label ID="LabelOsCislo" runat="server" Text="[%Os. číslo%]: "></asp:Label>
                            </td>
                            <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                                <asp:Label ID="LabelDbOsCislo" runat="server" Text='<%# Bind("os_cislo") %>'></asp:Label>
                            </td>
                        </tr>
                        <tr style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: 1px">
                            <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                                <asp:Label ID="LabelNazevMista" runat="server" Text="[%Název pracovního místa%]: "></asp:Label>
                            </td>
                            <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                                <asp:Label ID="LabelDbNazevMista" runat="server" Text='<%# Bind("prac_misto") %>'></asp:Label>
                            </td>
                            <td style="padding: 5px; border-left-style: solid; border-left-width: 1px; border-left-color: #000000; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                                <asp:Label ID="LabelCisloMista" runat="server" Text="[%Číslo pr. místa%]: "></asp:Label>
                            </td>
                            <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                                <asp:Label ID="LabelDbCisloMista" runat="server" Text='<%# Bind("cislo_PM") %>'></asp:Label>
                            </td>
                        </tr>
                        <tr style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: thin">
                            <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                                <asp:Label ID="LabelOdbor" runat="server" Text="[%Středisko%]: "></asp:Label>
                            </td>
                            <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                                <asp:Label ID="LabelDbOdbor" runat="server" Text='<%# Bind("stredisko") %>'></asp:Label>
                            </td>
                            <td style="padding: 5px; border-left-style: solid; border-left-width: 1px; border-left-color: #000000; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                                <asp:Label ID="L_druh_pom" runat="server" Text="[%Druh poměru%]: "></asp:Label>
                            </td>
                            <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                                <asp:Label ID="L_druh_pom_val" runat="server" Text='<%# Bind("sluz_zakon_text") %>'></asp:Label>
                            </td>
                        </tr>
                        <tr style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: thin">
                            <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                                <asp:Label ID="LabelObdobi" runat="server" Text="[%Hodnocené období%]: "></asp:Label>
                            </td>
                            <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                                <asp:Label ID="LabelDbObdobiOd" runat="server" Text='<%# Eval("datum_od", "{0:d}") %>'></asp:Label>
                                -
                            <asp:Label ID="LabelDbObdobiDo" runat="server" Text='<%# Eval("datum_do", "{0:d}") %>'></asp:Label>
                            </td>
                            <td style="padding: 5px; border-left-style: solid; border-left-width: 1px; border-left-color: #000000; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                                <asp:Label ID="LabelVyjimka" runat="server" Text="[%Výjimka%]: " Visible="false"></asp:Label>
                            </td>
                            <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                                <asp:Label ID="LabelVyjimkaOdDo" runat="server" Visible="false"></asp:Label>
                            </td>
                        </tr>
                        <tr style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: thin">
                            <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;">
                                <asp:Label ID="Label20" runat="server" Text="[%Poznámka%]: "></asp:Label>
                            </td>
                            <td style="padding: 5px; border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #000000;" colspan="3">
                                <asp:Label ID="Label21" runat="server" Text='<%# Eval("jiny_duvod") %>'></asp:Label>
                            </td>
                        </tr>
                    </table>
                    <br />
                    <table style="border: 1px solid #000000; width: 100%; border-collapse: collapse;">
                        <tr>
                            <td>[%Obeznámen%]:
                            </td>
                            <td style="border-right-style: solid; border-right-width: 1px; border-right-color: #000000">
                                <wc:TLabel ID="TL_obeznamen" runat="server"></wc:TLabel>
                            </td>
                            <td>[%Hodnotil%]:
                            </td>
                            <td>
                                <wc:TLabel ID="TL_hodnotil" runat="server" Text='<%# Eval("hodnotil") %>'></wc:TLabel>
                            </td>
                        </tr>
                        <tr>
                            <td>[%Souhlasil%]:
                            </td>
                            <td style="border-right-style: solid; border-right-width: 1px; border-right-color: #000000">
                                <wc:TLabel ID="TL_souhlasil" runat="server"></wc:TLabel>
                            </td>
                            <td>[%Schválil%]:
                            </td>
                            <td>
                                <wc:TLabel ID="TL_schvalil" runat="server" Text='<%# Eval("schvalil") %>'></wc:TLabel>
                            </td>
                        </tr>
                        <tr>
                            <td>[%Zamknuto%]:
                            </td>
                            <td style="border-right-style: solid; border-right-width: 1px; border-right-color: #000000">
                                <wc:TLabel ID="TL_zamknuto" runat="server"></wc:TLabel>
                            </td>
                            <td>[%Datum%]:
                            </td>
                            <td>
                                <wc:TLabel ID="TL_datum" runat="server" Text='<%# Eval("datum", "{0:d}") %>'></wc:TLabel>
                            </td>
                        </tr>
                    </table>
                </ItemTemplate>
            </asp:FormView>
            <br />
        </div>
        <div runat="server" id="DIV_kom">
            <div class="pageBreakInsideAvoid">
                <table style="border-collapse: collapse; border-style: none;" width="100%">
                    <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                        <td style="background-color: #C0C0C0" align="left">
                            <asp:Label ID="LabelNadpisKompetence" runat="server" CssClass="nadpis-bold" Font-Size="Larger"
                                Text="[%Hodnocení kompetencí%]"></asp:Label><br />
                        </td>
                    </tr>
                </table>
                <br />
            </div>
            <asp:ObjectDataSource ID="ODS_typy_kompetenci" runat="server" OldValuesParameterFormatString="original_{0}"
                SelectMethod="Typy_kompetenci" TypeName="KSProgram.Hodnoceni.Hodnoceni">
                <SelectParameters>
                    <asp:Parameter Name="Id" Type="Int32" />
                    <asp:Parameter Name="sta_edt" Type="Int16" DefaultValue="2" />
                </SelectParameters>
            </asp:ObjectDataSource>
            <asp:Repeater ID="REP_typy_kompetenci" runat="server" OnDataBinding="REP_typy_kompetenci_DataBinding"
                OnItemDataBound="REP_typy_kompetenci_ItemDataBound">
                <ItemTemplate>
                    <div>
                        <asp:ObjectDataSource ID="ODS_kompetence" runat="server" SelectMethod="Kompetence"
                            TypeName="KSProgram.Hodnoceni.Hodnoceni">
                            <SelectParameters>
                                <asp:Parameter Name="Id" Type="Int32" />
                                <asp:Parameter Name="typ_kompetenci" Type="Int32" />
                                <asp:Parameter Name="sta_edt" Type="Int16" DefaultValue="2" />
                            </SelectParameters>
                        </asp:ObjectDataSource>
                        <table style="border-collapse: collapse; border-style: none;" width="100%" class="pageBreakInsideAvoid">
                            <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                                <td style="background-color: #C0C0C0; border: solid black; border-width: 1px 1px 0px 1px;" align="left">
                                    <asp:Label ID="LabelSkupinaKompetenci" runat="server" CssClass="nadpis-bold" Font-Size="13px"></asp:Label><br />
                                </td>
                            </tr>
                        </table>
                        <wc:TGridView ID="TGV_kompetence" runat="server" ShowTitleRow="False" DataKeyNames="idp,sta_edt,pozadavek"
                            Width="100%" AllowSorting="False" OnDataBinding="TGV_kompetence_DataBinding" CssClass="pageBreakBeforeAvoid"
                            OnRowDataBound="TGV_kompetence_RowDataBound">
                            <%--<TitleRowStyle BackColor="LightGray" BorderColor="Black" BorderWidth="1px" BorderStyle="Solid"
                                CssClass="nadpis-bold pageBreakInsideAvoid" Font-Size="13px" ForeColor="Black" />--%>
                            <HeaderStyle CssClass="pageBreakInsideAvoid pageBreakBeforeAvoid" />
                            <RowStyle CssClass="pageBreakInsideAvoid" />
                            <FooterStyle CssClass="pageBreakInsideAvoid pageBreakBeforeAvoid" BackColor="LightGray" />
                            <FooterStyle  />
                            <Columns>
                                <asp:BoundField DataField="vyznam" HeaderText="[%Kompetence%]" HeaderStyle-HorizontalAlign="Left"
                                    ItemStyle-BackColor="LightGray" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                                    ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                                    HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                                    FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                                    <FooterStyle BorderColor="Black" BorderWidth="1px" BorderStyle="Solid" ForeColor="Black"></FooterStyle>
                                    <HeaderStyle CssClass="nadpis-bold" BackColor="LightGray" HorizontalAlign="Left" BorderColor="Black" BorderWidth="1px"
                                        ForeColor="Black"></HeaderStyle>
                                    <ItemStyle BackColor="LightGray" BorderColor="Black" BorderWidth="1px" BorderStyle="Solid"
                                        ForeColor="Black"></ItemStyle>
                                </asp:BoundField>
                                <asp:TemplateField HeaderText="[%Popis%]" ItemStyle-HorizontalAlign="Left" HeaderStyle-HorizontalAlign="Left"
                                    ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                                    ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                                    HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                                    FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                                    <ItemTemplate>
                                        <wc:TLabel ID="LabelDbPopis" runat="server" Text='<%# Bind("popis") %>'></wc:TLabel>
                                    </ItemTemplate>
                                    <FooterStyle BorderColor="Black" BorderWidth="1px" BorderStyle="Solid" ForeColor="Black"
                                        CssClass="nadpis-bold"></FooterStyle>
                                    <HeaderStyle CssClass="nadpis-bold scriptWidth" HorizontalAlign="Left" BorderColor="Black" BorderWidth="1px" ForeColor="Black"></HeaderStyle>
                                    <ItemStyle HorizontalAlign="Left" BackColor="White" BorderColor="Black" BorderWidth="1px" CssClass="scriptWidth"
                                        BorderStyle="Solid" ForeColor="Black"></ItemStyle>
                                </asp:TemplateField>
                                <asp:BoundField DataField="vaha" HeaderText="[%Váha%]" ItemStyle-HorizontalAlign="Center"
                                    HeaderStyle-HorizontalAlign="Center" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                                    ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                                    HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                                    FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                                    FooterStyle-ForeColor="Black">
                                    <FooterStyle BorderColor="Black" BorderWidth="1px" BorderStyle="Solid" ForeColor="Black"
                                        CssClass="nadpis-bold"></FooterStyle>
                                    <HeaderStyle CssClass="nadpis-bold scriptWidth" HorizontalAlign="Center" BorderColor="Black" BorderWidth="1px" ForeColor="Black"></HeaderStyle>
                                    <ItemStyle HorizontalAlign="Center" BackColor="White" BorderColor="Black" BorderWidth="1px" CssClass="scriptWidth"
                                        BorderStyle="Solid" ForeColor="Black"></ItemStyle>
                                </asp:BoundField>
                                <asp:TemplateField HeaderText="[%Požadováno%]" ItemStyle-HorizontalAlign="Left" HeaderStyle-HorizontalAlign="Center"
                                    ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                                    ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                                    HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                                    FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                                    <ItemTemplate>
                                        <asp:Label ID="LabelDbPozadavek" runat="server"></asp:Label>
                                    </ItemTemplate>
                                    <FooterStyle BorderColor="Black" BorderWidth="1px" BorderStyle="Solid" ForeColor="Black"
                                        CssClass="nadpis-bold"></FooterStyle>
                                    <HeaderStyle CssClass="nadpis-bold scriptWidth" HorizontalAlign="Center" BorderColor="Black" BorderWidth="1px" ForeColor="Black"></HeaderStyle>
                                    <ItemStyle HorizontalAlign="Left" BackColor="White" BorderColor="Black" BorderWidth="1px" CssClass="scriptWidth"
                                        BorderStyle="Solid" ForeColor="Black"></ItemStyle>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="[%Sebehodnocení%]" ItemStyle-HorizontalAlign="Left"
                                    HeaderStyle-HorizontalAlign="Center" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                                    ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                                    HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                                    FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                                    FooterStyle-ForeColor="Black">
                                    <ItemTemplate>
                                        <asp:Table ID="Table1_s" runat="server" Style="margin: 0px; border-collapse: collapse; width: 100%; height: 100%;">
                                            <asp:TableRow>
                                                <asp:TableCell>
                                                    <asp:Label ID="LabelDbHodnoceni_s" runat="server"></asp:Label>
                                                </asp:TableCell>
                                            </asp:TableRow>
                                            <asp:TableRow>
                                                <asp:TableCell Style="margin: 0px; border-top-style: solid; border-top-width: 1px; border-top-color: #000000;">
                                                    <asp:Label ID="L_komp_poznamka_s" runat="server"></asp:Label>
                                                </asp:TableCell>
                                            </asp:TableRow>
                                        </asp:Table>
                                    </ItemTemplate>
                                    <FooterStyle BorderColor="Black" BorderWidth="1px" BorderStyle="Solid" ForeColor="Black"
                                        CssClass="nadpis-bold"></FooterStyle>
                                    <HeaderStyle CssClass="nadpis-bold scriptWidth" HorizontalAlign="Center" BorderColor="Black" BorderWidth="1px" ForeColor="Black"></HeaderStyle>
                                    <ItemStyle HorizontalAlign="Left" BackColor="White" BorderColor="Black" BorderWidth="1px" CssClass="scriptWidth"
                                        BorderStyle="Solid" ForeColor="Black" VerticalAlign="Top"></ItemStyle>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="[%Poznámka%]" HeaderStyle-HorizontalAlign="Left" ItemStyle-BackColor="White"
                                    ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                                    ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                                    HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                                    FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                                    <ItemTemplate>
                                        <asp:Label ID="L_komp_poznamka1_s" runat="server"></asp:Label>
                                    </ItemTemplate>
                                    <FooterStyle BorderColor="Black" BorderWidth="1px" BorderStyle="Solid" ForeColor="Black"
                                        CssClass="nadpis-bold"></FooterStyle>
                                    <HeaderStyle CssClass="nadpis-bold scriptWidth" HorizontalAlign="Left" BorderColor="Black" BorderWidth="1px" ForeColor="Black"></HeaderStyle>
                                    <ItemStyle BackColor="White" BorderColor="Black" BorderWidth="1px" BorderStyle="Solid" CssClass="scriptWidth"
                                        ForeColor="Black"></ItemStyle>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="[%Hodnocení%]" ItemStyle-HorizontalAlign="Left" HeaderStyle-HorizontalAlign="Center"
                                    ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                                    ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                                    HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                                    FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                                    <ItemTemplate>
                                        <asp:Table ID="Table1" runat="server" Style="margin: 0px; border-collapse: collapse; width: 100%; height: 100%;">
                                            <asp:TableRow>
                                                <asp:TableCell>
                                                    <asp:Label ID="LabelDbHodnoceni" runat="server"></asp:Label>
                                                </asp:TableCell>
                                            </asp:TableRow>
                                            <asp:TableRow>
                                                <asp:TableCell Style="margin: 0px; border-top-style: solid; border-top-width: 1px; border-top-color: #000000; height: 66%;">
                                                    <asp:Label ID="L_komp_poznamka" runat="server"></asp:Label>
                                                </asp:TableCell>
                                            </asp:TableRow>
                                        </asp:Table>
                                    </ItemTemplate>
                                    <FooterStyle BorderColor="Black" BorderWidth="1px" BorderStyle="Solid" ForeColor="Black"
                                        CssClass="nadpis-bold"></FooterStyle>
                                    <HeaderStyle CssClass="nadpis-bold scriptWidth" HorizontalAlign="Center" BorderColor="Black" BorderWidth="1px" ForeColor="Black"></HeaderStyle>
                                    <ItemStyle HorizontalAlign="Left" BackColor="White" BorderColor="Black" BorderWidth="1px" CssClass="scriptWidth"
                                        BorderStyle="Solid" ForeColor="Black" VerticalAlign="Top"></ItemStyle>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="[%Poznámka%]" HeaderStyle-HorizontalAlign="Left" ItemStyle-BackColor="White"
                                    ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                                    ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                                    HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                                    FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                                    <ItemTemplate>
                                        <asp:Label ID="L_komp_poznamka1" runat="server"></asp:Label>
                                    </ItemTemplate>
                                    <FooterStyle BorderColor="Black" BorderWidth="1px" BorderStyle="Solid" ForeColor="Black"
                                        CssClass="nadpis-bold"></FooterStyle>
                                    <HeaderStyle CssClass="nadpis-bold scriptWidth" HorizontalAlign="Left" BorderColor="Black" BorderWidth="1px" ForeColor="Black"></HeaderStyle>
                                    <ItemStyle BackColor="White" BorderColor="Black" BorderWidth="1px" BorderStyle="Solid" CssClass="scriptWidth"
                                        ForeColor="Black"></ItemStyle>
                                </asp:TemplateField>
                            </Columns>
                        </wc:TGridView>
                    </div>
                </ItemTemplate>
                <SeparatorTemplate>
                    <div class="pageBreakInsideAvoid">
                        <br />
                    </div>
                </SeparatorTemplate>
                <FooterTemplate>
                    <div class="pageBreakInsideAvoid pageBreakBeforeAvoid">
                        <div runat="server" id="DIV_seb_footer">
                            <asp:Label ID="L_seb_sum" runat="server" Text=""></asp:Label>
                            <br />
                            <br />
                        </div>
                        <div runat="server" id="DIV_kom_footer">
                            <asp:Label ID="L_komp_sum" runat="server" Text=""></asp:Label>
                            <br />
                            <br />
                        </div>
                    </div>
                    <div runat="server" id="DIV_chart_footer" class="pageBreakInsideAvoid">
                        <telerik:RadHtmlChart ID="RadChartKompetence" runat="server" Width="784" Height="600" CssClass="ksChart">
                            <ClientEvents OnSeriesHover="SeriesHower" />
                            <PlotArea>
                                <Series>
                                    <telerik:RadarLineSeries DataFieldY="body_poz" Name="[%Požadováno%]" ZIndex="101">
                                        <Appearance>
                                            <FillStyle BackgroundColor="Green" />
                                        </Appearance>
                                        <LineAppearance LineStyle="Smooth" />
                                        <MarkersAppearance Size="10" />
                                    </telerik:RadarLineSeries>
                                    <telerik:RadarLineSeries DataFieldY="body_obd_sebe" Name="[%Sebehodnocení%]" ZIndex="102">
                                        <Appearance>
                                            <FillStyle BackgroundColor="LightSkyBlue" />
                                        </Appearance>
                                        <LineAppearance LineStyle="Smooth" />
                                        <MarkersAppearance Size="10" />
                                    </telerik:RadarLineSeries>
                                    <telerik:RadarLineSeries DataFieldY="body_obd" Name="[%Hodnocení%]" ZIndex="103">
                                        <Appearance>
                                            <FillStyle BackgroundColor="Red" />
                                        </Appearance>
                                        <LineAppearance LineStyle="Smooth" />
                                        <MarkersAppearance Size="10" />
                                    </telerik:RadarLineSeries>
                                </Series>
                                <XAxis Name="kompetence">
                                    <MinorGridLines Visible="false" />
                                </XAxis>
                                <YAxis>
                                    <MinorGridLines Visible="false" />
                                </YAxis>
                            </PlotArea>
                            <Legend>
                                <Appearance Position="Bottom">
                                </Appearance>
                            </Legend>
                        </telerik:RadHtmlChart>
                        <asp:Panel ID="P_Legenda" runat="server" CssClass="ksLegendWrapper">
                            <div>
                                <div class="ksLegend">
                                    <asp:Repeater ID="R_TypyKomp" runat="server">
                                        <ItemTemplate>
                                            <div>
                                                <asp:Panel ID="Panel1" runat="server" BackColor='<%# Eval("color") %>'></asp:Panel>
                                                <%# Eval("text") %>
                                            </div>
                                        </ItemTemplate>
                                    </asp:Repeater>
                                </div>
                                <div class="ksLegendKomp">
                                    <div>
                                        <asp:Repeater ID="R_Komp" runat="server">
                                            <ItemTemplate>
                                                <div id='<%# "legenda_" + Eval("shortcut") %>' class="legenda">
                                                    <asp:Panel ID="Panel1" runat="server" BackColor='<%# Eval("color") %>'><%# Eval("shortcut") %></asp:Panel>
                                                    <%# Eval("text") %>
                                                </div>
                                            </ItemTemplate>
                                        </asp:Repeater>
                                    </div>
                                </div>
                            </div>
                        </asp:Panel>
                    </div>
                </FooterTemplate>
            </asp:Repeater>
        </div>
        <div runat="server" id="DIV_cil" class="pageBreakInsideAvoid">
            <table style="border-collapse: collapse; border-style: none;" width="100%">
                <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                    <td style="background-color: #C0C0C0" align="left">
                        <asp:Label ID="Label3" runat="server" CssClass="nadpis-bold" Font-Size="Larger" Text="[%Hodnocení cílů%]"></asp:Label><br />
                    </td>
                </tr>
            </table>
            <br />
            <asp:ObjectDataSource ID="ODS_cile" runat="server" OldValuesParameterFormatString="original_{0}"
                SelectMethod="Cile" TypeName="KSProgram.Hodnoceni.Hodnoceni">
                <SelectParameters>
                    <asp:Parameter Name="Id" Type="Int32" />
                    <asp:Parameter Name="Druh" Type="Int32" DefaultValue="1" />
                    <asp:Parameter Name="sta_edt" Type="Int16" DefaultValue="2" />
                </SelectParameters>
            </asp:ObjectDataSource>
            <wc:TGridView ID="TGV_cile" runat="server" DataKeyNames="idp,druh,cil" ShowFooterWhenEmpty="True"
                ShowTitleRow="False" OnRowDataBound="TGV_cile_RowDataBound" OnDataBinding="TGV_cile_DataBinding"
                AllowSorting="False" ShowFooter="True" Width="100%">
                <FooterStyle CssClass="pageBreakBeforeAvoid" />
                <Columns>
                    <asp:BoundField DataField="cil_nazev" HeaderText="[%Cíle%]" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle CssClass="nadpis-bold"/>
                        <HeaderStyle CssClass="nadpis-bold" />
                        <ItemStyle  CssClass=""/>
                    </asp:BoundField>
                    <asp:BoundField DataField="text" HeaderText="[%Cíle%]" HeaderStyle-HorizontalAlign="Left"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:BoundField>
                    <asp:BoundField DataField="popis" HeaderText="[%Popis%]" HeaderStyle-HorizontalAlign="Left"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:BoundField>
                    <asp:BoundField DataField="vaha" HeaderText="[%Váha%]" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="[%Váha%] %" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="L_vaha_cile" runat="server" Text='<%# Bind("vaha_proc", "{0:0.##}") %>'></asp:Label>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:TemplateField>
                    <asp:BoundField DataField="hodnota" HeaderText="[%Množství%]" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:BoundField>
                    <asp:BoundField DataField="termin" HeaderText="[%Termín%]" DataFormatString="{0:d/M/yyyy}"
                        HtmlEncode="False" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="[%Sebehodnocení%]" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="L_hodnoceni_cile_join" runat="server" Text='<%# Bind("hodnoceni_join") %>'></asp:Label>
                            <asp:Label ID="L_hodnoceni_cile_text_join" runat="server"></asp:Label>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Výsl. sebehodnocení%]" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="L_vyslhod_cile_join" runat="server" Text='<%# Bind("vysledne_hodnoceni_join", "{0:0.##}") %>'></asp:Label>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Poznámka%]" HeaderStyle-HorizontalAlign="Left" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <wc:TLabel ID="L_cil_poznamka_join" runat="server" FormatHtml="True" Text='<%# Bind("poznamka_join") %>'></wc:TLabel>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Hodnocení%]" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="L_hodnoceni_cile" runat="server" Text='<%# Bind("hodnoceni") %>'></asp:Label>
                            <asp:Label ID="L_hodnoceni_cile_text" runat="server"></asp:Label>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Plnění%]" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="L_plneni_cile" runat="server" Text='<%# Bind("plneni", "{0:0.##}") %>'></asp:Label>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:TemplateField>
                    <asp:BoundField DataField="nazev_krivky" HeaderText="[%Křivka%]" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="[%Výsl. hodnocení%]" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="L_vyslhod_cile" runat="server" Text='<%# Bind("vysledne_hodnoceni", "{0:0.##}") %>'></asp:Label>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Poznámka%]" HeaderStyle-HorizontalAlign="Left" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <wc:TLabel ID="L_cil_poznamka" runat="server" FormatHtml="True" Text='<%# Bind("poznamka") %>'></wc:TLabel>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Kroky k dosažení%]" HeaderStyle-HorizontalAlign="Left"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <wc:TLabel ID="L_cil_kroky" runat="server" FormatHtml="True" Text='<%# Bind("kroky") %>'></wc:TLabel>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Očekávaný výstup%]" HeaderStyle-HorizontalAlign="Left"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <wc:TLabel ID="L_cil_ocek" runat="server" FormatHtml="True" Text='<%# Bind("ocek_vystup") %>'></wc:TLabel>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:TemplateField>
                </Columns>
            </wc:TGridView>
            <br />
        </div>
        <div runat="server" id="DIV_rekapcil" class="pageBreakInsideAvoid pageBreakBeforeAvoid">
            <table style="border-collapse: collapse; border-style: none;" width="100%">
                <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                    <td style="background-color: #C0C0C0" align="left">
                        <asp:Label ID="Label17" runat="server" CssClass="nadpis-bold" Font-Size="Larger" Text="[%Rekapitulace cílů%]"></asp:Label><br />
                    </td>
                </tr>
            </table>
            <br />
            <wc:HodnCile runat="server" ID="HodnCile_rekapitulace_skupin_cilu" StatutEditora="2" />
            <br />
        </div>
        <div runat="server" id="DIV_ncil" class="pageBreakInsideAvoid">
            <table style="border-collapse: collapse; border-style: none;" width="100%">
                <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                    <td style="background-color: #C0C0C0" align="left">
                        <asp:Label ID="Label7" runat="server" CssClass="nadpis-bold" Font-Size="Larger" Text="[%Následné cíle%]"></asp:Label><br />
                    </td>
                </tr>
            </table>
            <br />
            <asp:ObjectDataSource ID="ODS_naslcile" runat="server" OldValuesParameterFormatString="original_{0}"
                SelectMethod="Cile" TypeName="KSProgram.Hodnoceni.Hodnoceni" UpdateMethod="Update_cile"
                DeleteMethod="Delete_cile">
                <SelectParameters>
                    <asp:Parameter Name="Id" Type="Int32" />
                    <asp:Parameter DefaultValue="2" Name="Druh" Type="Int32" />
                    <asp:Parameter Name="sta_edt" Type="Int16" DefaultValue="2" />
                </SelectParameters>
            </asp:ObjectDataSource>
            <wc:TGridView ID="TGV_naslcile" runat="server" DataKeyNames="idp,druh,cil" ShowFooterWhenEmpty="True"
                ShowTitleRow="False" OnRowDataBound="TGV_naslcile_RowDataBound" ShowFooter="True"
                OnDataBinding="TGV_naslcile_DataBinding" AllowSorting="False" Width="100%">
                <Columns>
                    <asp:BoundField DataField="cil_nazev" HeaderText="[%Následné cíle%]" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle CssClass="nadpis-bold" />
                        <HeaderStyle CssClass="nadpis-bold" />
                    </asp:BoundField>
                    <asp:BoundField DataField="text" HeaderText="[%Následné cíle%]" HeaderStyle-HorizontalAlign="Left"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:BoundField>
                    <asp:BoundField DataField="popis" HeaderText="[%Popis%]" HeaderStyle-HorizontalAlign="Left"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:BoundField>
                    <asp:BoundField DataField="vaha" HeaderText="[%Váha%]" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:BoundField>
                    <asp:BoundField DataField="hodnota" HeaderText="[%Množství%]" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:BoundField>
                    <asp:BoundField DataField="termin" HeaderText="[%Termín%]" DataFormatString="{0:d/M/yyyy}"
                        HtmlEncode="False" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="[%Poznámka%]" HeaderStyle-HorizontalAlign="Left" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <wc:TLabel ID="L_cil_poznamka" runat="server" FormatHtml="True" Text='<%# Bind("poznamka") %>'></wc:TLabel>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Kroky k dosažení%]" HeaderStyle-HorizontalAlign="Left"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <wc:TLabel ID="L_cil_kroky" runat="server" FormatHtml="True" Text='<%# Bind("kroky") %>'></wc:TLabel>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Očekávaný výstup%]" HeaderStyle-HorizontalAlign="Left"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <wc:TLabel ID="L_cil_ocek" runat="server" FormatHtml="True" Text='<%# Bind("ocek_vystup") %>'></wc:TLabel>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:TemplateField>
                </Columns>
            </wc:TGridView>
            <br />
        </div>
        <div runat="server" id="DIV_slo" class="pageBreakInsideAvoid">
            <div runat="server" id="DIV_slo_hod">
                <table style="border-collapse: collapse; border-style: none;" width="100%">
                    <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                        <td style="background-color: #C0C0C0" align="left">
                            <asp:Label ID="Label2" runat="server" CssClass="nadpis-bold" Font-Size="Larger" Text="[%Hodnocení slovní%]"></asp:Label><br />
                        </td>
                    </tr>
                </table>
                <br />
                <asp:ObjectDataSource ID="ODS_slovni" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="Slovni" TypeName="KSProgram.Hodnoceni.Hodnoceni">
                    <SelectParameters>
                        <asp:Parameter Name="Id" Type="Int32" />
                        <asp:Parameter Name="sta_edt" Type="Int16" DefaultValue="2" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <asp:Repeater ID="REP_slovni" runat="server" OnDataBinding="REP_slovni_DataBinding"
                    OnItemDataBound="REP_slovni_ItemDataBound">
                    <ItemTemplate>
                        <table style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: 1px"
                            width="100%">
                            <tr style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: 1px">
                                <td style="padding: 5px; height: 150px; vertical-align: top;">
                                    <asp:Label ID="Label1" runat="server" Text='<%# Bind("vyznam") %>' CssClass="nadpis-bold"></asp:Label><br />
                                    <asp:Label ID="L_slovni_popis" runat="server" Text='<%# Bind("popis") %>'></asp:Label><br />
                                    <asp:Label ID="TB_poznamka" runat="server" BackColor="White" Font-Size="Larger"></asp:Label>
                                </td>
                            </tr>
                        </table>
                        <br />
                    </ItemTemplate>
                </asp:Repeater>
            </div>
            <div runat="server" id="DIV_slo_seb">
                <table style="border-collapse: collapse; border-style: none;" width="100%">
                    <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                        <td style="background-color: #C0C0C0" align="left">
                            <asp:Label ID="Label9" runat="server" CssClass="nadpis-bold" Font-Size="Larger" Text="[%Sebehodnocení slovní%]"></asp:Label><br />
                        </td>
                    </tr>
                </table>
                <br />
                <asp:ObjectDataSource ID="ODS_slovni_s" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="Slovni" TypeName="KSProgram.Hodnoceni.Hodnoceni">
                    <SelectParameters>
                        <asp:Parameter Name="Id" Type="Int32" />
                        <asp:Parameter Name="sta_edt" Type="Int16" DefaultValue="1" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <asp:Repeater ID="REP_slovni_s" runat="server" OnDataBinding="REP_slovni_DataBinding"
                    OnItemDataBound="REP_slovni_ItemDataBound">
                    <ItemTemplate>
                        <table style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: 1px"
                            width="100%">
                            <tr style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: 1px">
                                <td style="padding: 5px; height: 150px; vertical-align: top;">
                                    <asp:Label ID="Label_s" runat="server" Text='<%# Bind("vyznam") %>' CssClass="nadpis-bold"></asp:Label><br />
                                    <asp:Label ID="L_slovni_popis_s" runat="server" Text='<%# Bind("popis") %>'></asp:Label><br />
                                    <asp:Label ID="TB_poznamka" runat="server" BackColor="White" Font-Size="Larger"></asp:Label>
                                </td>
                            </tr>
                        </table>
                        <br />
                    </ItemTemplate>
                </asp:Repeater>
            </div>
        </div>
        <div runat="server" id="DIV_mot" class="pageBreakInsideAvoid">
            <table style="border-collapse: collapse; border-style: none;" width="100%">
                <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                    <td style="background-color: #C0C0C0" align="left">
                        <asp:Label ID="Label4" runat="server" CssClass="nadpis-bold" Font-Size="Larger" Text="[%Osobní motivace%]"></asp:Label><br />
                    </td>
                </tr>
            </table>
            <br />
            <asp:ObjectDataSource ID="ODS_Motivace" runat="server" OldValuesParameterFormatString="original_{0}"
                TypeName="KSProgram.Hodnoceni.Hodnoceni" SelectMethod="Motivace">
                <SelectParameters>
                    <asp:Parameter Name="Id" Type="Int32" />
                </SelectParameters>
            </asp:ObjectDataSource>
            <wc:TGridView ID="TGV_Motivace" runat="server" DataKeyNames="idp,pozadavek" ShowTitleRow="False"
                Width="100%" OnRowDataBound="TGV_Motivace_RowDataBound" AllowSorting="False"
                OnDataBinding="TGV_Motivace_DataBinding">
                <Columns>
                    <asp:BoundField DataField="vyznam" HeaderText="[%Motivační faktor%]" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle CssClass="nadpis-bold"/>
                        <HeaderStyle CssClass="nadpis-bold" />
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="[%Stanovisko%]" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="L_stanovisko" runat="server"></asp:Label>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Zdůvodnění, připomínky, návrhy%]" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="L_mot_poznamka" runat="server"></asp:Label>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:TemplateField>
                    <asp:BoundField DataField="termin" HeaderText="[%Termín%]" DataFormatString="{0:d.M.yyyy}"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:BoundField>
                </Columns>
            </wc:TGridView>
            <br />
        </div>
        <div runat="server" id="DIV_sko" class="pageBreakInsideAvoid">
            <table style="border-collapse: collapse; border-style: none;" width="100%">
                <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                    <td style="background-color: #C0C0C0" align="left">
                        <asp:Label ID="Label5" runat="server" CssClass="nadpis-bold" Font-Size="Larger" Text="[%Hodnocení vzdělávacích akcí%]"></asp:Label><br />
                    </td>
                </tr>
            </table>
            <br />
            <asp:ObjectDataSource ID="ODS_Skoleni" runat="server" TypeName="KSProgram.Hodnoceni.Hodnoceni"
                SelectMethod="Skoleni">
                <SelectParameters>
                    <asp:Parameter Name="Id" Type="Int32" />
                </SelectParameters>
            </asp:ObjectDataSource>
            <wc:TGridView ID="TGV_Skoleni" runat="server" ShowTitleRow="False" Width="100%"
                AllowSorting="False" OnDataBinding="TGV_Skoleni_DataBinding" OnRowDataBound="TGV_Skoleni_RowDataBound">
                <Columns>
                    <asp:BoundField DataField="nazev" HeaderText="[%Název%]" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <HeaderStyle CssClass="nadpis-bold" />
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="[%Absolvováno%]" HeaderStyle-HorizontalAlign="Center"
                        ItemStyle-HorizontalAlign="Center" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="LabelDbSplneno" runat="server"></asp:Label>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:TemplateField>
                    <asp:BoundField DataField="naklady" HeaderText="[%Náklady%]" HeaderStyle-HorizontalAlign="Center"
                        ItemStyle-HorizontalAlign="Center" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:BoundField>
                    <asp:BoundField DataField="ziskal" HeaderText="[%Splněno%]" HeaderStyle-HorizontalAlign="Center"
                        ItemStyle-HorizontalAlign="Center" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="[%Splnilo očekávání%]" HeaderStyle-HorizontalAlign="Center"
                        ItemStyle-HorizontalAlign="Center" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="LabelDbSplnilo" runat="server"></asp:Label>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:TemplateField>
                    <asp:BoundField DataField="hodnoceni" HeaderText="[%Hodnocení%]" HeaderStyle-HorizontalAlign="Center"
                        ItemStyle-HorizontalAlign="Center" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="[%Poznámka%]" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="L_sko_poznamka" runat="server"></asp:Label>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:TemplateField>
                    <asp:BoundField DataField="zpusob" HeaderText="[%Způsob%]" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:BoundField>
                </Columns>
            </wc:TGridView>
            <br />
        </div>
        <div runat="server" id="DIV_roz" class="pageBreakInsideAvoid">
            <table style="border-collapse: collapse; border-style: none;" width="100%">
                <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                    <td style="background-color: #C0C0C0" align="left">
                        <asp:Label ID="Label6" runat="server" CssClass="nadpis-bold" Font-Size="Larger" Text="[%Doporučené vzdělávání%]"></asp:Label><br />
                    </td>
                </tr>
            </table>
            <br />
            <asp:ObjectDataSource ID="ODS_Vzdelavani" runat="server" TypeName="KSProgram.Hodnoceni.Hodnoceni"
                SelectMethod="Vzdelavani">
                <SelectParameters>
                    <asp:Parameter Name="Id" Type="Int32" />
                </SelectParameters>
            </asp:ObjectDataSource>
            <wc:TGridView ID="TGV_DopVzde" runat="server" ShowTitleRow="False" Width="100%"
                AllowSorting="False" OnDataBinding="TGV_DopVzde_DataBinding" OnRowDataBound="TGV_DopVzde_RowDataBound">
                <Columns>
                    <asp:BoundField DataField="nazev" HeaderText="[%Vzdělávací aktivita%]" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <HeaderStyle CssClass="nadpis-bold" />
                    </asp:BoundField>
                    <asp:BoundField DataField="termin" HeaderText="[%Splnit do%]" DataFormatString="{0:d/M/yyyy}"
                        HtmlEncode="False" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="[%Poznámka%]" HeaderStyle-HorizontalAlign="Left" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="L_vzde_poznamka" runat="server"></asp:Label>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="[%Typ vzd. aktivity%]" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <asp:Label ID="L_rozv_zpusob" runat="server"></asp:Label>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:TemplateField>
                </Columns>
            </wc:TGridView>
            <br />
        </div>
        <div runat="server" id="DIV_cel" class="pageBreakInsideAvoid">
            <table style="border-collapse: collapse; border-style: none;" width="100%">
                <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                    <td style="background-color: #C0C0C0" align="left">
                        <asp:Label ID="Label8" runat="server" CssClass="nadpis-bold" Font-Size="Larger" Text="[%Celkové hodnocení%]"></asp:Label><br />
                    </td>
                </tr>
            </table>
            <br />
            <asp:ObjectDataSource ID="ODS_celkove" runat="server" OldValuesParameterFormatString="original_{0}"
                SelectMethod="CelkoveHodnoceni" TypeName="KSProgram.Hodnoceni.Hodnoceni">
                <SelectParameters>
                    <asp:Parameter Name="Id" Type="Int32" />
                    <asp:Parameter Name="sta_edt" Type="Int16" />
                    <asp:Parameter Name="sloucit" Type="Boolean" />
                </SelectParameters>
            </asp:ObjectDataSource>
            <wc:TGridView ID="TGV_celkove" runat="server" ShowTitleRow="False" Width="100%"
                AllowSorting="False" OnRowDataBound="TGV_celkove_RowDataBound" OnDataBinding="TGV_celkove_DataBinding">
                <Columns>
                    <asp:BoundField DataField="vyznam" HeaderText="[%Význam%]" SortExpression="vyznam"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle CssClass="nadpis-bold"/>
                        <HeaderStyle CssClass="nadpis-bold" />
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="[%Popis%]" SortExpression="popis" Visible="False"
                        HeaderStyle-HorizontalAlign="Left" ItemStyle-BackColor="White" ItemStyle-BorderColor="Black"
                        ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black"
                        HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black"
                        FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px"
                        FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <wc:TLabel ID="L_celk_popis" runat="server" Text='<%# Bind("popis") %>' FormatHtml="True"></wc:TLabel>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:TemplateField>
                    <asp:BoundField DataField="popis_stupne_join" HeaderText="[%Sebehodnocení%]" SortExpression="popis_stupne_join"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="[%Poznámka%]" HeaderStyle-HorizontalAlign="Left" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <wc:TLabel ID="L_celk_poznamka_j" runat="server" FormatHtml="True" Text='<%# Bind("poznamka_join") %>'></wc:TLabel>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:TemplateField>
                    <asp:BoundField DataField="popis_stupne" HeaderText="[%Hodnocení%]" SortExpression="popis_stupne"
                        ItemStyle-BackColor="White" ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid"
                        ItemStyle-BorderWidth="1px" ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black"
                        HeaderStyle-BorderWidth="1px" HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black"
                        FooterStyle-BorderStyle="Solid" FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="[%Poznámka%]" HeaderStyle-HorizontalAlign="Left" ItemStyle-BackColor="White"
                        ItemStyle-BorderColor="Black" ItemStyle-BorderStyle="Solid" ItemStyle-BorderWidth="1px"
                        ItemStyle-ForeColor="Black" HeaderStyle-BorderColor="Black" HeaderStyle-BorderWidth="1px"
                        HeaderStyle-ForeColor="Black" FooterStyle-BorderColor="Black" FooterStyle-BorderStyle="Solid"
                        FooterStyle-BorderWidth="1px" FooterStyle-ForeColor="Black">
                        <ItemTemplate>
                            <wc:TLabel ID="L_celk_poznamka" runat="server" FormatHtml="True" Text='<%# Bind("poznamka") %>'></wc:TLabel>
                        </ItemTemplate>
                        <FooterStyle CssClass="nadpis-bold scriptWidth"/>
                        <HeaderStyle CssClass="nadpis-bold scriptWidth" />
                        <ItemStyle  CssClass="scriptWidth"/>
                    </asp:TemplateField>
                </Columns>
            </wc:TGridView>
            <br />
        </div>
        <div runat="server" id="DIV_sluz">
            <div runat="server" id="DIV_sluz_sumy" class="pageBreakInsideAvoid">
                <table style="border-collapse: collapse; border-style: none;" width="100%">
                    <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                        <td style="background-color: #C0C0C0" align="left">
                            <asp:Label ID="Label10" runat="server" CssClass="nadpis-bold" Font-Size="Larger" Text="[%Závěr hodnocení%]"></asp:Label><br />
                        </td>
                    </tr>
                </table>
                <br />
                <table style="border-style: solid; border-width: 1px" width="100%">
                    <tr>
                        <td style="padding: 4px">
                            <asp:Label ID="L_sluz_suma1" runat="server" Font-Size="Larger"></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 4px">
                            <asp:Label ID="L_sluz_suma2" runat="server" Font-Size="Larger"></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 4px">
                            <asp:Label ID="L_sluz_suma3" runat="server" Font-Size="Larger"></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 4px">
                            <asp:Label ID="L_sluz_suma4" runat="server" Font-Size="Larger"></asp:Label>
                        </td>
                    </tr>
                </table>
                <br />
            </div>
            <div class="pageBreakInsideAvoid">
                <table style="border-style: solid; border-width: 1px" width="100%">
                    <tr>
                        <td style="padding: 4px">
                            <asp:Label ID="Label11" runat="server" Font-Size="Larger">[%Státní zaměstnanec/zaměstnanec dosahoval v hodnoceném období ve službě/v práci%]<sup>1)</sup></asp:Label>
                        </td>
                        <td style="padding: 4px">
                            <kspwc:TRadioButtonList ID="TRadioButtonList2" runat="server" AutoPostBack="true" Enabled="true">
                                <asp:ListItem Value="0">[%Vynikající výsledky%]</asp:ListItem>
                                <asp:ListItem Value="1">[%Dobré výsledky%]</asp:ListItem>
                                <asp:ListItem Value="2">[%Dostačující výsledky%]</asp:ListItem>
                                <asp:ListItem Value="3">[%Nevyhovující výsledky%]</asp:ListItem>
                            </kspwc:TRadioButtonList>
                        </td>
                    </tr>
                </table>
                <br />
            </div>
            <div class="pageBreakInsideAvoid">
                <table style="border-style: solid solid none solid; border-width: 1px 1px 0px 1px"
                    width="100%">
                    <tr style="border-style: none; border-width: 0px">
                        <td style="padding: 4px">
                            <asp:Label ID="Label12" runat="server" Font-Size="Larger">[%S ohledem na dosažený výsledek hodnocení doporučuji státnímu zaměstnanci/zaměstnanci osobní příplatek%]<sup>1)</sup></asp:Label>
                        </td>
                        <td style="padding: 4px; width: 200px;">
                            <kspwc:TRadioButtonList ID="TRadioButtonList1" runat="server" AutoPostBack="true" Enabled="true">
                                <asp:ListItem Value="0">[%Přiznat%]</asp:ListItem>
                                <asp:ListItem Value="1">[%Zvýšit%]</asp:ListItem>
                                <asp:ListItem Value="2">[%Snížit%]</asp:ListItem>
                                <asp:ListItem Value="3">[%Odejmout%]</asp:ListItem>
                                <asp:ListItem Value="4">[%Ponechat v nezměněné výši%]</asp:ListItem>
                            </kspwc:TRadioButtonList>
                        </td>
                    </tr>
                </table>
            </div>
            <div class="pageBreakInsideAvoid">
                <table style="border-style: none solid solid solid; border-width: 0px 1px 1px 1px"
                    width="100%">
                    <tr style="border-style: none; border-width: 0px">
                        <td align="center" style="padding: 4px">
                            <telerik:RadNumericTextBox ID="RNTB_osob_pripl" runat="server" Width="160" ReadOnly="True" MinValue="0">
                            </telerik:RadNumericTextBox>
                        </td>
                        <td align="center" style="padding: 4px">
                            <telerik:RadNumericTextBox ID="RNTB_navrh_osob_pripl" runat="server" Width="160"
                                MinValue="0" AutoPostBack="True">
                            </telerik:RadNumericTextBox>
                        </td>
                    </tr>
                    <tr style="border-style: none; border-width: 0px">
                        <td align="center" style="padding: 4px">
                            <asp:Label ID="Label13" runat="server">[%Stávající osobní příplatek%]</asp:Label>
                        </td>
                        <td align="center" style="padding: 4px">
                            <asp:Label ID="Label14" runat="server">[%Navrhovaný osobní příplatek%]</asp:Label>
                        </td>
                    </tr>
                </table>
                <br />
            </div>
            <div class="pageBreakInsideAvoid">
                <table style="border-style: solid; border-width: 1px" width="100%">
                    <tr style="border-style: none; border-width: 0px">
                        <td style="padding: 4px" colspan="2">
                            <kspwc:TCheckBox ID="TCheckBox1" runat="server" AutoPostBack="True" />
                            <asp:Label ID="Label15" runat="server" Font-Size="Larger"><sup>1)</sup>- [%Pouze pro státní zaměstnance: S ohledem na níže uvedené důvody navrhuji státního zaměstnance považovat za vynikajícího, všeobecně uznávaného odborníka.%]</asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 4px" colspan="2">
                            <kspwc:TTextBox ID="TTextBox1" runat="server" Width="100%" TextMode="MultiLine" Rows="3"
                                Height="70px" AutoPostBack="True"></kspwc:TTextBox>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 4px; width: 50%;" align="center">
                            <br />
                            <br />
                            _________________________________________<br />
                            [%Podpis zaměstnance%]<br />
                            <br />
                            <wc:TLabel ID="TL_sluz_misto_zam" runat="server"></wc:TLabel>_____________________<wc:TLabel ID="TL_sluz_datum_zam" runat="server" Visible="false"></wc:TLabel>
                        </td>
                        <td style="padding: 4px; width: 50%;" align="center">
                            <br />
                            <br />
                            _________________________________________<br />
                            [%Podpis hodnotitele%]<br />
                            <br />
                            <wc:TLabel ID="TL_sluz_misto_hod" runat="server"></wc:TLabel>_____________________<wc:TRadDatePicker ID="TRDP_sluz_datum_hod" runat="server" CssClass="tiskHide" AutoPostBack="true" Visible="false"></wc:TRadDatePicker>
                            <wc:TLabel ID="TL_sluz_datum_hod" runat="server" CssClass="tiskShow" Visible="false"></wc:TLabel>
                        </td>
                    </tr>
                    <%--<tr>
                <td style="padding: 4px" colspan="2">
                    <br /><br />
                    <hr />
                    [%Jméno, popř. jména, příjmení, popř. akademický titul příslušného člena vlády nebo
                    vedoucího Úřadu vlády České republiky a podpis%]<sup>2)</sup>
                </td>
            </tr>
            <tr>
                <td style="padding: 4px; width: 50%;" align="center">
                </td>
                <td style="padding: 4px width: 50%;" align="center">
                    <br />
                    V________________________dne_____________
                </td>
            </tr>--%>
                </table>
                <br />
            </div>
            <div class="pageBreakInsideAvoid">
                <table style="border-style: solid; border-width: 1px" width="100%">
                    <tr style="border-style: none; border-width: 0px">
                        <td style="padding: 4px" colspan="2">
                            <kspwc:TCheckBox ID="TCheckBox2" runat="server" AutoPostBack="True" />
                            <asp:Label ID="Label16" runat="server" Font-Size="Larger"><sup>2)</sup>- [%Pouze pro státní zaměstnance: Státní zaměstnanec <b>je</b> vynikajícím, všeobecně uznávaným odborníkem.%]</asp:Label>
                        </td>
                    </tr>
                    <%--<tr style="border-style: none; border-width: 0px">
                    <td style="padding: 4px" colspan="2">
                        <br />
                        <br />
                        <hr />
                        [%Služební označení, jméno, popř. jména, příjmení, popř. akademický titul služebního
                        orgánu a podpis%]
                    </td>
                </tr>--%>
                    <tr>
                        <td style="padding: 4px; width: 50%;" align="center"></td>
                        <td style="padding: 4px; width: 50%;" align="center">
                            <br />
                            <br />
                            _________________________________________<br />
                            <wc:TLabel ID="TL_sluz_sub_org" runat="server"></wc:TLabel><br />
                            <br />
                            <wc:TLabel ID="TL_sluz_misto_org" runat="server"></wc:TLabel>_____________________<wc:TLabel ID="TL_sluz_datum_org" runat="server" Visible="false"></wc:TLabel>
                        </td>
                    </tr>
                </table>
                <br />
            </div>
            <div class="pageBreakInsideAvoid">
                <table style="border-style: solid; border-width: 1px" width="100%">
                    <tr style="border-style: none; border-width: 0px">
                        <td style="padding: 4px">[%Přílohy k hodnocení%]
                        <kspwc:TTextBox ID="TTextBox2" runat="server" Width="100%" TextMode="MultiLine" Rows="3"
                            Height="70px"></kspwc:TTextBox>
                        </td>
                    </tr>
                </table>
                <br />
                <hr />
                <sup>1)</sup> [%Hodící se vhodně zvýrazněte%]<br />
                <sup>2)</sup> [%Jsou-li splněny podmínky dle § 6 odst. 2 nařízení vlády, hodící se vhodně zvýrazněte%]<br />
                <br />
            </div>
        </div>
        <div runat="server" id="DIV_legenda">
            <div>
                <telerik:RadListView runat="server" ID="RLV_leg_typy_kompetenci" OnNeedDataSource="RLV_leg_typy_kompetenci_NeedDataSource" ItemPlaceholderID="PH_typy" Visible='<%# _params["komp_tiskdefstupne"] == "1"  %>'>
                    <LayoutTemplate>
                        <div class="pageBreakInsideAvoid">
                        <table style="border-collapse: collapse; border-style: none;" width="100%">
                            <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                                <td style="background-color: #C0C0C0" align="left">
                                    <asp:Label ID="Label18" runat="server" CssClass="nadpis-bold" Font-Size="Larger" Text="[%Legenda%]"></asp:Label><br />
                                </td>
                            </tr>
                        </table>
                        <br />
                        <asp:PlaceHolder ID="PH_typy" runat="server"></asp:PlaceHolder>
                    </LayoutTemplate>
                    <ItemSeparatorTemplate>
                        <div class="pageBreakInsideAvoid">
                    </ItemSeparatorTemplate>
                    <ItemTemplate>
                            <table style="border-collapse: collapse; border-style: none;" width="100%">
                                <tr style="border-collapse: collapse; border-style: none; border-width: 0px">
                                    <td style="background-color: #C0C0C0" align="left">
                                        <asp:Label ID="Label19" runat="server" CssClass="nadpis-bold" Text='<%# "[%Typ kompetence%]: " + Eval("nazev_typu") %>'></asp:Label><br />
                                    </td>
                                </tr>
                            </table>
                            <br />
                            <asp:HiddenField runat="server" ID="HF_leg_komp_typ" Value='<%# Eval("typ_kompetenci") %>' />
                            <kspwc:TRadGrid runat="server" ID="TRG_komp_legenda" OnNeedDataSource="TRG_komp_legenda_NeedDataSource" OnItemDataBound="TRG_komp_legenda_ItemDataBound" AutoMasterGridWidth="true" AutoGenerateColumns="false" CaptionVisible="false" CssClass="ksPrint" Width="100%">
                                <MasterTableView>
                                    <Columns>
                                        <telerik:GridBoundColumn UniqueName="kompetence_vyznam" DataField="kompetence_vyznam" DataType="System.String" HeaderText="[%Kompetence%]"></telerik:GridBoundColumn>
                                        <telerik:GridBoundColumn UniqueName="vyznam" DataField="vyznam" DataType="System.String" HeaderText="[%Stupeň%]"></telerik:GridBoundColumn>
                                        <telerik:GridNumericColumn UniqueName="poradi" DataField="poradi" DataType="System.Int32" HeaderText="[%Body%]"></telerik:GridNumericColumn>
                                        <telerik:GridBoundColumn UniqueName="popis" DataField="popis" DataType="System.String" HeaderText="[%Význam stupně%]"></telerik:GridBoundColumn>
                                    </Columns>
                                </MasterTableView>
                            </kspwc:TRadGrid>
                        </div>
                        <br />
                    </ItemTemplate>
                </telerik:RadListView>
            </div>
        </div>
        <div runat="server" id="DIV_podpis" class="pageBreakInsideAvoid">
            <table style="border: 1px solid #000000; border-collapse: collapse;" width="100%">
                <tr style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: thin">
                    <td style="padding: 5px">
                        <asp:Label ID="LabelPodpisHodnoceneho" runat="server" Text="[%Datum a podpis hodnoceného%]:"></asp:Label>
                    </td>
                </tr>
                <tr style="border-color: #000000; border-collapse: collapse; border-style: solid; border-width: thin">
                    <td style="padding: 5px">
                        <asp:Label ID="LabelPodpisHodnotitele" runat="server" Text="[%Datum a podpis hodnotitele%]:"></asp:Label>
                    </td>
                </tr>
            </table>
        </div>
    </asp:Panel>
</asp:Content>
