﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" Inherits="Manazer_Pomucky_PomuckyInventura"
    CodeBehind="PomuckyInventura.aspx.cs" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TDropDownSklad">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGridSklad" />
                    <telerik:AjaxUpdatedControl ControlID="Label1" />
                    <telerik:AjaxUpdatedControl ControlID="Label2" />
                    <telerik:AjaxUpdatedControl ControlID="Label3" />
                    <telerik:AjaxUpdatedControl ControlID="DIV_NaSklade" />
                    <%--<telerik:AjaxUpdatedControl ControlID="TRB_ZalozNovou" />
                    <telerik:AjaxUpdatedControl ControlID="TDD_VyberPomucku" />
                    <telerik:AjaxUpdatedControl ControlID="TDD_VyberVelikostPomucky" />--%>
                </UpdatedControls>
            </telerik:AjaxSetting>

            <telerik:AjaxSetting AjaxControlID="TDD_Sklad">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TDD_VyberPomucku" />
                </UpdatedControls>
            </telerik:AjaxSetting>

            <telerik:AjaxSetting AjaxControlID="TDD_VyberPomucku">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TDD_VyberVelikostPomucky" />
                </UpdatedControls>
            </telerik:AjaxSetting>


            <telerik:AjaxSetting AjaxControlID="TRadGridSklad">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="Label1" />
                    <telerik:AjaxUpdatedControl ControlID="Label2" />
                    <telerik:AjaxUpdatedControl ControlID="Label3" />
                    <telerik:AjaxUpdatedControl ControlID="DIV_NaSklade" />
                    <telerik:AjaxUpdatedControl ControlID="TRadGridPomucka" />
                    <telerik:AjaxUpdatedControl ControlID="HF_pomucka" />
                    <telerik:AjaxUpdatedControl ControlID="HF_sklad" />
                    <telerik:AjaxUpdatedControl ControlID="TRB_ZalozNovou" />
                    <telerik:AjaxUpdatedControl ControlID="TDD_VyberPomucku" />
                    <telerik:AjaxUpdatedControl ControlID="TDD_VyberVelikostPomucky" />
                    <telerik:AjaxUpdatedControl ControlID="RadWindow4" />
                    <telerik:AjaxUpdatedControl ControlID="TRG_Vydane" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="HiddenButtonSelectedRow">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGridSklad" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_UlozitZmeny">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadWindow2" />
                    <telerik:AjaxUpdatedControl ControlID="RadWindow2Field" />
                    <telerik:AjaxUpdatedControl ControlID="RadWindow1" />
                    <telerik:AjaxUpdatedControl ControlID="RadWindow1Field" />
                    <telerik:AjaxUpdatedControl ControlID="HF_IdNaSklade" />
                    <telerik:AjaxUpdatedControl ControlID="TRadGridPomucka" />
                    <telerik:AjaxUpdatedControl ControlID="TableEdit" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRadGridPomucka">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadWindow1" />
                    <telerik:AjaxUpdatedControl ControlID="RadWindow1Field" />
                    <telerik:AjaxUpdatedControl ControlID="TDropDownVelikost" />
                    <telerik:AjaxUpdatedControl ControlID="TableEdit" />
                    <telerik:AjaxUpdatedControl ControlID="RB_Zneplatnit" />
                    <telerik:AjaxUpdatedControl ControlID="TRadGridPrevod" />
                    <telerik:AjaxUpdatedControl ControlID="RadWindow4" />
                    <telerik:AjaxUpdatedControl ControlID="TRG_Vydane" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_Nespojovat">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadWindow2" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_Spojit">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadWindow1" />
                    <telerik:AjaxUpdatedControl ControlID="RadWindow1Field" />
                    <telerik:AjaxUpdatedControl ControlID="RadWindow2" />
                    <telerik:AjaxUpdatedControl ControlID="TRadGridPomucka" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="CHB_Zneplatnene">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGridPomucka" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRadGridPrevod">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGridPomucka" />
                    <telerik:AjaxUpdatedControl ControlID="TRadGridSklad" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="RB_Zneplatnit">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGridPomucka" />
                    <telerik:AjaxUpdatedControl ControlID="RadWindow1Field" />
                    <telerik:AjaxUpdatedControl ControlID="RadWindow1" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRadGridPrijem">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGridSklad" />
                    <telerik:AjaxUpdatedControl ControlID="TRadGridPomucka" />
                    <telerik:AjaxUpdatedControl ControlID="HF_VybranyPrevod" />
                    <telerik:AjaxUpdatedControl ControlID="RadWindow3" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_UlozitNovou">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="ErrorZalozeni" />
                    <telerik:AjaxUpdatedControl ControlID="RadWindow1" />
                    <telerik:AjaxUpdatedControl ControlID="TRadGridPomucka" />
                    <telerik:AjaxUpdatedControl ControlID="RadWindow1Field" />
                    <telerik:AjaxUpdatedControl ControlID="TableEdit" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_ZrusitPrevod">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="HF_VybranyPrevod" />
                    <telerik:AjaxUpdatedControl ControlID="TRadGridPrijem" />
                    <telerik:AjaxUpdatedControl ControlID="RadWindow3" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="RB_Prevezt">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="HF_VybranyPrevod" />
                    <telerik:AjaxUpdatedControl ControlID="TRadGridPrijem" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRadGridDetail">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGridDetail" />
                    <telerik:AjaxUpdatedControl ControlID="TRadGridPrijem" />
                    <telerik:AjaxUpdatedControl ControlID="HF_VybranyPrevod" />
                    <telerik:AjaxUpdatedControl ControlID="RadWindow3" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_Prijmout">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGridPrijem" />
                    <telerik:AjaxUpdatedControl ControlID="TRadGridSklad" />
                    <telerik:AjaxUpdatedControl ControlID="HF_VybranyPrevod" />
                    <telerik:AjaxUpdatedControl ControlID="RadWindow3" />
                    <telerik:AjaxUpdatedControl ControlID="DIV_NaSklade" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_Vratit">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGridPrijem" />
                    <telerik:AjaxUpdatedControl ControlID="HF_VybranyPrevod" />
                    <telerik:AjaxUpdatedControl ControlID="RadWindow3" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_ZalozNovou">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGridSklad" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRG_Vydane">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRG_Vydane" />
                </UpdatedControls>
            </telerik:AjaxSetting>   
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>

    <telerik:RadCodeBlock ID="RadScriptBlock1" runat="server">
        <script type="text/javascript" id="telerikClientEvents1">
            function Window1Close(sender, args) {
                $get("<%=RadWindow1Field.ClientID %>").value = "false";
            }

            function SelectPomucku(sender, args) {
                var index = args._itemIndexHierarchical;
                var grid = $find("<%=TRadGridSklad.ClientID %>");
                if (grid) {
                    var MasterTable = grid.get_masterTableView();
                    MasterTable.fireCommand("vybrat", index);
                }
            }

            function closeRadWindow() {
                var window = $find("<%= TRW_PridatNasklad.ClientID %>");
                if (window) {
                    window.close();
                }
            }

        </script>
    </telerik:RadCodeBlock>

    <asp:ObjectDataSource ID="ZdrojVyberSkladuGrid" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="GetSkladyGrid" TypeName="KSProgram.Personal.Pomucky"></asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ZdrojVyberSkladu" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="GetVsechnySklady" TypeName="KSProgram.Personal.Pomucky"></asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ZdrojVyberPomucky" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="GetVsechnyPomucky" TypeName="KSProgram.Personal.Pomucky"></asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ZdrojVelikostPomucky" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="GetVelikostiPomucky" TypeName="KSProgram.Personal.Pomucky">
          <SelectParameters>
              <%--<asp:ControlParameter Name="aIdPomucky" ControlID="TDD_VyberPomucku" PropertyName="Text" />--%>
              <asp:Parameter Name="aIdPomucky" Type="String" />
              <asp:Parameter Name="aPodlePohlavi" Type="Boolean" DefaultValue="false" />
          </SelectParameters>
    </asp:ObjectDataSource>

    

    <div style="display: flex; flex-direction: column; max-width: 100%; flex-wrap: wrap; padding: 25px; margin: 10px;" class="ksprvek">
        <div>
            <div style="display: flex; flex-direction: row; justify-content: space-between">
                <div style="margin: 10px" >
                    <asp:Label ID="Label17" runat="server" Text="[%Pomůcky na skladech%]" CssClass="nadpis1"></asp:Label>
                    <br />
                    <div style="display: grid; grid-template-columns: auto auto auto auto ; column-gap: 40px">
                        <%--<h4 class="pridejPomucku">Sklad: </h4>--%>
                        <kspwc:TDropDown ID="TDropDownSklad" Height="33" runat="server" AutoPostBack="true" DataSourceID="ZdrojVyberSkladuGrid" OnSelectedIndexChanged="TDropDown3_SelectedIndexChanged" OnDataBound="TDropDownSklad_DataBound" CssClass="fancyDropdown" ></kspwc:TDropDown>
                    <%--
                           <h4 class="pridejPomucku">Pomůcka: </h4>
                        <kspwc:TDropDown ID="TDD_VyberPomucku"  Height="33" runat="server"  DataSourceID="ZdrojVyberPomucky" DataValueField="id_pomucky" DataTextField="nazevCely" CssClass="fancyDropdown" Visible="true" AutoPostBack="false" OnDataBound="TDropDownSklad_DataBound" OnSelectedIndexChanged="TDD_VyberPomucku_SelectedIndexChanged"></kspwc:TDropDown>
                        <h4 class="pridejPomucku">Velikost: </h4>
                        <kspwc:TDropDown ID="TDD_VyberVelikostPomucky" Height="33" runat="server"  DataSourceID="ZdrojVelikostPomucky" DataValueField="id" DataTextField="Hodnota" CssClass="fancyDropdown" Visible="false"></kspwc:TDropDown>
                        <h4 class="pridejPomucku">Počet: </h4>
                        <kspwc:TTextBox ID="TTB_PocetKs" Height="33" runat="server" Visible="true" TextMode="Number" min="1"></kspwc:TTextBox>
                        <h4 class="pridejPomucku">Pořizovací cena: </h4>
                        <kspwc:TTextBox ID="TTB_PorizovaciCena" Height="33" runat="server" Visible="false" TextMode="Number" min="1"></kspwc:TTextBox>
                        <h4 class="pridejPomucku">Aktuální cena: </h4>
                        <kspwc:TTextBox ID="TTB_AktualniCena" Height="33" runat="server" Visible="false" TextMode="Number" min="1"></kspwc:TTextBox>
                        <h4 class="pridejPomucku">Poznámka: </h4>
                        <kspwc:TTextBox ID="TTB_Poznamka" Height="33" runat="server" Visible="false"></kspwc:TTextBox>
                        <kspwc:TRadButton runat="server" Height="33" ID="TRB_ZalozNovou" Text="[%Přidej na sklad%]" Icon-PrimaryIconCssClass="fi fi-add" Visible="false" OnClick="TRB_ZalozNovou_Click"></kspwc:TRadButton>
                    --%>
                         <kspwc:TRadButton runat="server" Height="33" ID="PridatNovouPolozku" Text="[%Přidej na sklad%]" Icon-PrimaryIconCssClass="fi fi-add" Visible="true" OnClick="TRB_PridatNovouPolozkuOkno_Click"></kspwc:TRadButton>
                    </div>
                </div>
                <%-- Vyskakovací okno pro přidání položky na sklad --%>
                <telerik:RadWindowManager ID="RadWindowManager1" runat="server">
                    <Windows>
                        <telerik:RadWindow ID="TRW_PridatNasklad" runat="server" Title="Přidej na sklad" Width="800px" Height="350px" Modal="true" VisibleStatusbar="false" KeepInScreenBounds="true" ReloadOnShow="true">
                            <ContentTemplate>
                                <div style="display: grid; grid-template-columns: auto auto auto auto ; column-gap: 40px; margin-top:3rem; justify-content:center; align-items:center">
                                    <h4 class="pridejPomucku">Sklad: </h4>
                                    <kspwc:TLabel ID="LabelSklad" runat="server">[%Sklad%]</kspwc:TLabel>
                                    <%--<kspwc:Label ID="TDD_Sklad" Height="33" runat="server" Visible="true" DataSourceID="ZdrojVyberSkladuGrid" CssClass="fancyDropdown" AutoPostBack="true" ></kspwc:Label>--%>

                                    <h4 class="pridejPomucku">Pomůcka: </h4>
                                    <kspwc:TDropDown ID="TDD_VyberPomucku" Height="33" runat="server"  Visible="true" DataSourceID="ZdrojVyberPomucky" DataValueField="id_pomucky" DataTextField="nazevCely" CssClass="fancyDropdown" AutoPostBack="true" OnSelectedIndexChanged="TDD_VyberPomucku_SelectedIndexChanged"></kspwc:TDropDown>
                                    
                                    <h4 class="pridejPomucku">Velikost: </h4>
                                    <kspwc:TDropDown ID="TDD_VyberVelikostPomucky" Height="33" runat="server" Visible="true" DataSourceID="ZdrojVelikostPomucky" DataValueField="id" DataTextField="Hodnota" CssClass="fancyDropdown"></kspwc:TDropDown>
                                    
                                    <h4 class="pridejPomucku">Počet: </h4>
                                    <kspwc:TTextBox ID="TTB_PocetKs" Height="33" runat="server" Visible="true" TextMode="Number" min="1"></kspwc:TTextBox>
                                    
                                    <h4 class="pridejPomucku">Pořizovací cena: </h4>
                                    <kspwc:TTextBox ID="TTB_PorizovaciCena" Height="33" runat="server" Visible="true" TextMode="Number" min="1" step="0.01" Culture="cs-CZ" ></kspwc:TTextBox>
                                    
                                    <h4 class="pridejPomucku">Aktuální cena: </h4>
                                    <kspwc:TTextBox ID="TTB_AktualniCena" Height="33" runat="server" Visible="true" TextMode="Number" min="1" step="0.01" Culture="cs-CZ"></kspwc:TTextBox>
                                    
                                    <h4 class="pridejPomucku">Poznámka: </h4>
                                    <kspwc:TTextBox ID="TTB_Poznamka" Height="33" runat="server" Visible="true"></kspwc:TTextBox>
                                </div>
                                <div style="display: flex; justify-content: center; margin-top: 2rem">
                                    <kspwc:TRadButton runat="server" Height="33" ID="TRB_ZalozNovou" Text="[%Uložit%]" AutoPostBack="true" Icon-PrimaryIconCssClass="fi fi-disk" Visible="true" OnClick="TRB_ZalozNovou_Click" OnClientClicking="closeRadWindow"></kspwc:TRadButton>
                                </div>
                            </ContentTemplate>
                        </telerik:RadWindow>
                    </Windows>
                </telerik:RadWindowManager>
   
                <div style="display: flex; flex-direction: row;">
                    <div class="statistika">
                        <asp:Label ID="Label1" runat="server" Text="0"></asp:Label>
                        <label>[%Přijato%]</label>
                    </div>
                    <div class="statistika">
                        <asp:Label ID="Label2" runat="server" Text="0"></asp:Label>
                        <label>[%Vydáno%]</label>
                    </div>
                    <div class="statistika">
                        <asp:Label ID="Label3" runat="server" Text="0"></asp:Label>
                        <label>[%Na skladě%]</label>
                    </div>
                </div>
            </div>
            <div>
        <ContentTemplate>
            </div>
            <kspwc:TRadGrid ID="TRadGridSklad" runat="server" AllowPaging="True" ShowGroupPanel="false" AllowMultiRowSelection="false" CssClass="revertShadow" OnItemCommand="TRadGridSklad_ItemCommand" ClientSettings-ClientEvents-OnRowDblClick="SelectPomucku"
                AllowSorting="true" AutoGenerateColumns="false" AutoFilterControlWidth="false" MasterTableView-ShowFooter="true" OnNeedDataSource="TRadGridSklad_NeedDataSource" CaptionVisible="false">
                <MasterTableView CommandItemDisplay="Top" PageSize="15" PagerStyle-Visible="true" EditMode="InPlace" AutoGenerateColumns="False">
                    <Columns>
                        <telerik:GridTemplateColumn ItemStyle-HorizontalAlign="Center" ItemStyle-Width="30px" AllowFiltering="false" AllowSorting="false" Exportable="false">
                            <ItemTemplate>
                                <kspwc:TRadButton runat="server" ID="TRB_Vybrat" AutoPostBack="true" CommandName="vybrat" Icon-PrimaryIconCssClass="fi fi-menu-burger"></kspwc:TRadButton>
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridBoundColumn DataField="id_pomucky" HeaderText="[%Pomůcka%]" SortExpression="id_pomucky" UniqueName="id_pomucky" />
                        <telerik:GridBoundColumn DataField="id_sklad" HeaderText="[%Sklad%]" SortExpression="id_sklad" UniqueName="id_sklad" DataType="System.String" />
                        <telerik:GridBoundColumn DataField="nazev" HeaderText="[%Název%]" SortExpression="nazev" UniqueName="nazev" />
                        <telerik:GridBoundColumn DataField="prij_mn" HeaderText="[%Přijato%]" SortExpression="prij_mn" UniqueName="prij_mn" />
                        <%--<telerik:GridBoundColumn DataField="vydano" HeaderText="[%Vydáno%]" SortExpression="vydano" UniqueName="vydano" Display="true" Exportable="true" />--%>
                        <telerik:GridTemplateColumn HeaderText="[%Vydáno%]" SortExpression="vydano" UniqueName="vydano" DataField="vydano" Exportable="false">
                            <ItemTemplate>
                                <kspwc:TRadButton runat="server" ID="TRB_Vydane" AutoPostBack="true" CommandName="zobrazVydane" Text='<%# Eval("vydano") %>'
                                    ToolTip="[%Zobrazit seznam zaměstnanců, kterým je tato pomůcka vydána%]">
                                </kspwc:TRadButton>
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridBoundColumn DataField="skladem" HeaderText="[%Skladem%]" SortExpression="skladem" UniqueName="skladem" />
                        <telerik:GridBoundColumn DataField="vyznam" HeaderText="[%Jednotka%]" SortExpression="vyznam" UniqueName="vyznam" Exportable="false" />
                    </Columns>
                    <CommandItemTemplate>
                        <kspwc:GridCommandItemControl ID="GcIc3" runat="server">
                            <ExportButton ID="ExportButton" runat="server" OnExporting="ExportButton_Exporting"></ExportButton>
                        </kspwc:GridCommandItemControl>
                    </CommandItemTemplate>
                </MasterTableView>
            </kspwc:TRadGrid>
        </div>

        <telerik:RadWindow ID="RadWindow4" Title="[%Vydané zaměstnancům%]" runat="server" Behaviors="Close,Move" Modal="true"
            Width="900" Height="600" VisibleOnPageLoad="false">
            <ContentTemplate>
                <kspwc:TRadGrid ID="TRG_Vydane" runat="server" AllowPaging="True" ShowGroupPanel="false" AllowMultiRowSelection="false" CssClass="revertShadow"
                    AllowSorting="true" AutoFilterControlWidth="false" MasterTableView-ShowFooter="true" AutoGenerateColumns="false" OnNeedDataSource="TRG_Vydane_NeedDataSource">
                    <MasterTableView CommandItemDisplay="Top" PagerStyle-Visible="true">
                        <Columns>
                            <telerik:GridBoundColumn DataField="os_cislo" HeaderText="[%Os. číslo%]" SortExpression="os_cislo" UniqueName="os_cislo" />
                            <telerik:GridBoundColumn DataField="cislo_pom" HeaderText="[%Číslo pom.%]" SortExpression="cislo_pom" UniqueName="cislo_pom" />
                            <kspwc:GridFotoZamColumn DataOsCisloField="os_cislo"></kspwc:GridFotoZamColumn>
                            <telerik:GridBoundColumn DataField="jmeno" HeaderText="[%Jméno%]" SortExpression="jmeno" UniqueName="jmeno" />
                            <telerik:GridBoundColumn DataField="mnozstvi" HeaderText="[%Množství%]" SortExpression="mnozstvi" UniqueName="mnozstvi" />
                            <telerik:GridBoundColumn DataField="dat_vydeje" HeaderText="[%Dat. výdeje%]" SortExpression="dat_vydeje" UniqueName="dat_vydeje" DataFormatString="{0:d.M.yyyy}" />
                            <telerik:GridBoundColumn DataField="vydal" HeaderText="[%Vydal%]" SortExpression="vydal" UniqueName="vydal" />
                            <telerik:GridBoundColumn DataField="vyd_pozn" HeaderText="[%Poznámka%]" SortExpression="vyd_pozn" UniqueName="vyd_pozn" />                            
                        </Columns>
                        <CommandItemTemplate>
                            <kspwc:GridCommandItemControl ID="GcIc6" runat="server"></kspwc:GridCommandItemControl>
                        </CommandItemTemplate>
                    </MasterTableView>
                </kspwc:TRadGrid>
            </ContentTemplate>
        </telerik:RadWindow>

        <asp:HiddenField ID="HF_sklad" Value="" runat="server" />
        <asp:HiddenField ID="HF_pomucka" Value="" runat="server" />
        <div style="margin-top: 10px;" runat="server" id="DIV_NaSklade" visible="false">
            <asp:CheckBox ID="CHB_Zneplatnene" runat="server" Text="[%Včetně zneplatněných%]" OnCheckedChanged="CHB_Zneplatnene_CheckedChanged" AutoPostBack="true" />
            <%--<kspwc:TRadGrid ID="TRadGrid1" runat="server" AllowPaging="True" ShowGroupPanel="false" AllowMultiRowSelection="true" CssClass="revertShadow" OnItemCommand="TRadGridPomucka_ItemCommand"
    AllowSorting="true" AutoGenerateColumns="false" AutoFilterControlWidth="false" MasterTableView-ShowFooter="true" OnNeedDataSource="TRadGridPomucka_NeedDataSource" OnRowDrop="TRadGridPomucka_RowDrop">   --%>
            <kspwc:TRadGrid ID="TRadGridPomucka" runat="server" AllowPaging="True" ShowGroupPanel="false" AllowMultiRowSelection="true" CssClass="revertShadow" OnItemDataBound="TRadGridPomucka_ItemDataBound" OnItemCommand="TRadGridPomucka_ItemCommand"
                AllowSorting="true" AutoGenerateColumns="false" AutoFilterControlWidth="false" MasterTableView-ShowFooter="true" OnNeedDataSource="TRadGridPomucka_NeedDataSource" OnRowDrop="TRadGridPomucka_RowDrop">
                <MasterTableView CommandItemDisplay="Top" Caption="[%Pomůcky na skladě%]" PageSize="15" PagerStyle-Visible="true" EditMode="InPlace" AutoGenerateColumns="False" DataKeyNames="cena_poriz">
                    <Columns>
                        <telerik:GridTemplateColumn ItemStyle-Width="30px" AllowFiltering="false" AllowSorting="false" Exportable="false">
                            <ItemTemplate>
                                <kspwc:TRadButton runat="server" ID="TRB_Edit" AutoPostBack="true" CommandName="editovat" Icon-PrimaryIconCssClass="fi fi-edit" ToolTip="Editovat"></kspwc:TRadButton>
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridTemplateColumn ItemStyle-Width="30px" AllowFiltering="false" AllowSorting="false" Exportable="false">
                            <ItemTemplate>
                                <kspwc:TRadButton runat="server" ID="TRB_Prevod" AutoPostBack="true" CommandName="Prevod" Icon-PrimaryIconCssClass="fi fi-truck-moving" ToolTip="Přidat do převodu"></kspwc:TRadButton>
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridBoundColumn DataField="id_na_sklade" HeaderText="ID" Display="true" SortExpression="id_na_sklade" UniqueName="id_na_sklade" ReadOnly="true" />
                        <telerik:GridBoundColumn DataField="prij_mn" HeaderText="[%Přijato%]" Display="true" SortExpression="prij_mn" UniqueName="prij_mn" ReadOnly="true" />
                        <%--<telerik:GridBoundColumn DataField="vydano" HeaderText="[%Vydáno%]" Display="true" SortExpression="vydano" UniqueName="vydano" ReadOnly="true" />--%>
                        <telerik:GridTemplateColumn HeaderText="[%Vydáno%]" SortExpression="vydano" UniqueName="vydano" DataField="vydano" ReadOnly="true" Exportable="false">
                            <ItemTemplate>
                                <kspwc:TRadButton runat="server" ID="TRB_Vydane" AutoPostBack="true" CommandName="zobrazVydane" Text='<%# Eval("vydano") %>'
                                    ToolTip="[%Zobrazit seznam zaměstnanců, kterým je tato pomůcka vydána%]">
                                </kspwc:TRadButton>
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridBoundColumn DataField="skladem" HeaderText="[%Skladem%]" Display="true" SortExpression="skladem" UniqueName="skladem" ReadOnly="true" />
                        <telerik:GridBoundColumn DataField="cena_poriz" HeaderText="[%Pořizovací cena%]" Display="true" SortExpression="cena_poriz" UniqueName="cena_poriz" />
                        <telerik:GridBoundColumn DataField="cena_akt" HeaderText="[%Aktuální cena%]" Display="true" SortExpression="cena_akt" UniqueName="cena_akt" />
                        <telerik:GridBoundColumn DataField="dat_znepl" HeaderText="[%Datum zneplatnění%]" Display="true" SortExpression="dat_znepl" UniqueName="dat_znepl" ReadOnly="true" DataFormatString="{0:d.M.yyyy}" />
                        <telerik:GridBoundColumn DataField="velikost" HeaderText="[%Velikost%]" Display="true" SortExpression="velikost" UniqueName="velikost" ReadOnly="true" />
                        <telerik:GridBoundColumn DataField="id_velikosti" HeaderText="[%Velikost%]" Display="false" SortExpression="id_velikosti" UniqueName="id_velikosti" ReadOnly="true" />
                        <%--<telerik:GridBoundColumn DataField="pohlavi" HeaderText="" Display="true" SortExpression="pohlavi" UniqueName="pohlavi" ReadOnly="true" />--%>
                        <telerik:GridBoundColumn DataField="pohlavi" HeaderText="[%Pohlaví%]" Display="true" SortExpression="pohlavi" UniqueName="pohlavi" ReadOnly="true" />
                        <telerik:GridBoundColumn DataField="pomu_pozn" HeaderText="[%Poznámka%]" Display="true" SortExpression="pomu_pozn" UniqueName="pomu_pozn" />
                        <%-- !! Nic nevkládat za pomu_pozn! Hledá se pomocí tohoto sloupce celkový počet sloupců. --%>
                    </Columns>
                    <CommandItemTemplate>
                        <kspwc:GridCommandItemControl ID="GcIc4" runat="server">
                            <ExportButton ID="ExportButton" runat="server" OnExporting="ExportButton_Exporting1"></ExportButton>
                        </kspwc:GridCommandItemControl>
                    </CommandItemTemplate>
                </MasterTableView>
                <ClientSettings AllowRowsDragDrop="true">
                    <Selecting AllowRowSelect="True" EnableDragToSelectRows="false" />
                </ClientSettings>
            </kspwc:TRadGrid>

            <asp:HiddenField ID="RadWindow1Field" Value="false" runat="server" />
            <telerik:RadWindow ID="RadWindow1" Title="[%Editace pomůcky%]" runat="server" Behaviors="Close,Move" Modal="true"
                Width="750" Height="650" Visible="true" VisibleOnPageLoad="true" OnClientClose="Window1Close">
                <ContentTemplate>
                    <div style="padding: 25px; margin: 10px;">
                        <asp:Table runat="server" ID="TableEdit" Width="650px">
                            <%--                            <asp:TableRow runat="server" ID="TableRow8">
                                <asp:TableCell runat="server" ID="TableCell15" HorizontalAlign="right" ColumnSpan="2">
                                    <div style="display: flex; flex-direction: row; width: fit-content;">
                                        
                                    </div>
                                </asp:TableCell>
                            </asp:TableRow>--%>
                            <asp:TableRow runat="server" ID="TableRow1">
                                <asp:TableCell runat="server" ID="TableCell13" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                                    <asp:Label ID="Label10" runat="server" Text="[%ID%]:"></asp:Label>
                                </asp:TableCell>
                                <asp:TableCell runat="server" ID="TableCell14" ColumnSpan="2" SkinID="DataFieldStyle">
                                    <telerik:RadTextBox ID="RTB_Id_na_sklade" runat="server" Text='' MaxLength="70" Width="100%" Enabled="false"></telerik:RadTextBox>
                                </asp:TableCell>
                            </asp:TableRow>
                            <asp:TableRow runat="server" ID="TableRow2">
                                <asp:TableCell runat="server" ID="TableCell3" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                                    <asp:Label ID="Label5" runat="server" Text="[%Přijato%]:"></asp:Label>
                                </asp:TableCell>
                                <asp:TableCell runat="server" ID="TableCell4" ColumnSpan="2" SkinID="DataFieldStyle">
                                    <%--<telerik:RadTextBox ID="RTB_Prijato" runat="server" Text='' MaxLength="70" Width="100%" InputType="Number" ></telerik:RadTextBox>--%>
                                    <telerik:RadNumericTextBox ID="RNTB_Prijato" runat="server" MaxLength="70" Width="100%" MinValue="0" NumberFormat-DecimalDigits="0" ></telerik:RadNumericTextBox>
                                </asp:TableCell>
                            </asp:TableRow>
                            <asp:TableRow runat="server" ID="TableRow3">
                                <asp:TableCell runat="server" ID="TableCell1" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                                    <asp:Label ID="Label4" runat="server" Text="[%Vydáno%]:"></asp:Label>
                                </asp:TableCell>
                                <asp:TableCell runat="server" ID="TableCell2" ColumnSpan="2" SkinID="DataFieldStyle">
                                    <telerik:RadTextBox ID="RTB_Vydano" runat="server" Text='' MaxLength="70" Width="100%" Enabled="false"></telerik:RadTextBox>
                                </asp:TableCell>
                            </asp:TableRow>
                            <asp:TableRow runat="server" ID="TableRow4">
                                <asp:TableCell runat="server" ID="TableCell5" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                                    <asp:Label ID="Label6" runat="server" Text="[%Pořizovací cena%]:"></asp:Label>
                                </asp:TableCell>
                                <asp:TableCell runat="server" ID="TableCell6" ColumnSpan="2" SkinID="DataFieldStyle">
                                    <telerik:RadNumericTextBox ID="RTB_CenaPoriz" runat="server" DisplayText="" NumberFormat-DecimalDigits="2" MaxLength="70" Width="100%"></telerik:RadNumericTextBox>
                                </asp:TableCell>
                            </asp:TableRow>
                            <asp:TableRow runat="server" ID="TableRow5">
                                <asp:TableCell runat="server" ID="TableCell7" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                                    <asp:Label ID="Label7" runat="server" Text="[%Aktuální cena%]:"></asp:Label>
                                </asp:TableCell>
                                <asp:TableCell runat="server" ID="TableCell8" ColumnSpan="2" SkinID="DataFieldStyle">
                                    <telerik:RadNumericTextBox ID="RTB_CenaAkt" runat="server" DisplayText="" NumberFormat-DecimalDigits="2" MaxLength="70" Width="100%"></telerik:RadNumericTextBox>
                                </asp:TableCell>
                            </asp:TableRow>
                            <asp:TableRow runat="server" ID="TableRow6">
                                <asp:TableCell runat="server" ID="TableCell9" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                                    <asp:Label ID="Label8" runat="server" Text="[%Velikost%]:"></asp:Label>
                                </asp:TableCell>
                                <asp:TableCell runat="server" ID="TableCell10" ColumnSpan="2" SkinID="DataFieldStyle">
                                    <kspwc:TDropDown ID="TDropDownVelikost" runat="server" AutoPostBack="false"></kspwc:TDropDown>
                                </asp:TableCell>
                            </asp:TableRow>
                            <asp:TableRow runat="server" ID="TableRow7">
                                <asp:TableCell runat="server" ID="TableCell11" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                                    <asp:Label ID="Label9" runat="server" Text="[%Poznámka%]:"></asp:Label>
                                </asp:TableCell>
                                <asp:TableCell runat="server" ID="TableCell12" ColumnSpan="2" SkinID="DataFieldStyle">
                                    <telerik:RadTextBox ID="RTB_Poznamka" runat="server" Text='' MaxLength="200" Width="100%" ></telerik:RadTextBox>
                                </asp:TableCell>
                            </asp:TableRow>
                        </asp:Table>
                        <center><asp:Label ID="ErrorZalozeni" Text="" runat="server" ForeColor="Red" Visible="false"></asp:Label></center>
                        <div style="display: flex; width: fit-content; margin: auto">
                            <telerik:RadButton ID="TRB_UlozitZmeny" runat="server" Text="[%Uložit%]" OnClick="TRB_UlozitZmeny_Click" AutoPostBack="true" CssClass="kstlacitko" Icon-PrimaryIconCssClass="fi fi-disk"></telerik:RadButton>
                            <telerik:RadButton ID="TRB_UlozitNovou" runat="server" Text="[%Rozdělit%]" OnClick="TRB_UlozitNovou_Click" AutoPostBack="true" CssClass="kstlacitko" Icon-PrimaryIconCssClass="fi fi-split"
                                ToolTip="[%Kliknutím na tlačítko rozdělit založíte nový záznam na skladě. Nový záznam bude vytvořen podle údajů zadaných výše.%]">
                            </telerik:RadButton>
                            <telerik:RadButton ID="RB_Zneplatnit" runat="server" Text="[%Zneplatnit%]" OnClick="RB_Zneplatnit_Click" AutoPostBack="true" CssClass="kstlacitko" Icon-PrimaryIconCssClass="fi fi-hammer-crash"></telerik:RadButton>
                        </div>
                    </div>

                </ContentTemplate>
            </telerik:RadWindow>
            <asp:HiddenField ID="HF_IdNaSklade" Value="" runat="server" />
            <telerik:RadWindow ID="RadWindow2" Title="[%Upozornění%]" runat="server" Behaviors="Close,Move" Modal="true"
                Width="300" Height="200" VisibleOnPageLoad="false">
                <ContentTemplate>
                    <div style="margin: auto; text-align: center;">
                        <asp:Label ID="Label13" Text="[%Pomůcka s těmito parametry již na skladě existuje%]." runat="server"></asp:Label><br />
                        <asp:Label ID="Label14" Text="[%Mají se tyto dva záznamy spojit do jednoho?%]" runat="server"></asp:Label><br />
                        <div style="margin: auto; width: fit-content; margin-top: 15px;">
                            <telerik:RadButton ID="TRB_Spojit" runat="server" Text="[%Ano%]" OnClick="TRB_Spojit_Click"></telerik:RadButton>
                            <telerik:RadButton ID="TRB_Nespojovat" runat="server" Text="[%Ne%]" OnClick="TRB_Nespojovat_Click"></telerik:RadButton>
                        </div>
                    </div>
                </ContentTemplate>
            </telerik:RadWindow>

        </div>
    </div>
    <div class="ksprvek" style="padding: 25px; margin: 10px; width: fit-content;">
        <asp:Label ID="Label15" runat="server" Text="[%Převod mezi sklady%]" CssClass="nadpis1"></asp:Label><br />

        <div style="display: flex; flex-direction: row; justify-content: space-between">
            <%--<asp:Label runat="server" ID="Label_popis" Text="[%Zde přetáhněte pomůcky na skladě, které chcete převést%]."></asp:Label>--%>
            <div style="margin-right: 20px;">
                <kspwc:TRadGrid ID="TRadGridPrevod" runat="server" AllowPaging="True" ShowGroupPanel="false" AllowMultiRowSelection="false" CssClass="revertShadow" OnItemCommand="TRadGridPrevod_ItemCommand"
                    AllowSorting="true" AutoFilterControlWidth="false" MasterTableView-ShowFooter="true" OnNeedDataSource="TRadGrid1_NeedDataSource" AutoGenerateColumns="false">
                    <MasterTableView CommandItemDisplay="Top" Caption="[%Převáděné pomůcky%]" PageSize="15" PagerStyle-Visible="true" EditMode="InPlace">
                        <Columns>
                            <telerik:GridBoundColumn DataField="id_sklad" HeaderText="[%Sklad%]" Display="true" SortExpression="id_sklad" UniqueName="id_sklad" ReadOnly="true" />
                            <telerik:GridBoundColumn DataField="id_pomucky" HeaderText="[%Pomůcka%]" Display="true" SortExpression="id_pomucky" UniqueName="id_pomucky" ReadOnly="true" />
                            <telerik:GridBoundColumn DataField="nazev" HeaderText="[%Název%]" Display="true" SortExpression="nazev" UniqueName="nazev" ReadOnly="true" />
                            <telerik:GridBoundColumn DataField="id_na_sklade" HeaderText="ID" Display="true" SortExpression="id_na_sklade" UniqueName="id_na_sklade" ReadOnly="true" />
                            <telerik:GridNumericColumn DataField="mnozstvi" HeaderText="[%Převést%]" Display="true" SortExpression="mnozstvi" UniqueName="mnozstvi" DataType="System.Int32" MinValue="1" />
                            <%--<telerik:GridBoundColumn DataField="cena_poriz" HeaderText="[%Pořizovací cena%]" Display="true" SortExpression="cena_poriz" UniqueName="cena_poriz" />
                        <telerik:GridBoundColumn DataField="cena_akt" HeaderText="[%Aktuální cena%]" Display="true" SortExpression="cena_akt" UniqueName="cena_akt" />
                        <telerik:GridBoundColumn DataField="velikost" HeaderText="[%Velikost%]" Display="true" SortExpression="velikost" UniqueName="velikost" ReadOnly="true" />
                        <telerik:GridBoundColumn DataField="pohlavi" HeaderText="" Display="true" SortExpression="pohlavi" UniqueName="pohlavi" ReadOnly="true" />
                        <telerik:GridBoundColumn DataField="pomu_pozn" HeaderText="[%Poznámka%]" Display="true" SortExpression="pomu_pozn" UniqueName="pomu_pozn" />--%>
                            <telerik:GridEditCommandColumn UpdateText="[%Uložit%]" />
                            <telerik:GridClientDeleteColumn />
                        </Columns>
                        <CommandItemTemplate>
                            <kspwc:GridCommandItemControl ID="GcIc5" runat="server"></kspwc:GridCommandItemControl>
                        </CommandItemTemplate>
                    </MasterTableView>
                    <%--                <ClientSettings AllowRowsDragDrop="true">
                    <Selecting AllowRowSelect="True" EnableDragToSelectRows="false" />
                </ClientSettings>--%>
                </kspwc:TRadGrid>
                <br />
                <%--<telerik:RadTextBox ID="RadTextBox1" runat="server" TextMode="MultiLine" Width="100%" Height="40px" DisplayText="[%Poznámka k převodu%]" Resize="Both" MaxLength="80"></telerik:RadTextBox>--%>
                <telerik:RadTextBox ID="RTB_PoznamkaPrevod" runat="server" TextMode="MultiLine" Width="100%" Height="40px" DisplayText="[%Poznámka k převodu%]" Resize="Both" MaxLength="45"></telerik:RadTextBox>
                <br />
                <br />
                <asp:Label runat="server" ID="Label16" Text="[%Převést na sklad%]:"></asp:Label>
                <kspwc:TDropDown ID="TDropDown1" runat="server" AutoPostBack="false" DataSourceID="ZdrojVyberSkladu" CssClass="fancyDropdown" DataValueField="sklad" DataTextField="nazevCely"></kspwc:TDropDown>
                <kspwc:TRadButton AutoPostBack="true" runat="server" ID="RB_Prevezt" Text="[%Převést pomůcky%]" OnClick="RB_Prevezt_Click" Icon-PrimaryIconCssClass="fi fi-truck-moving" />
            </div>
            <kspwc:TRadGrid ID="TRadGridPrijem" runat="server" AllowPaging="True" ShowGroupPanel="false" AllowMultiRowSelection="false" CssClass="revertShadow" OnItemCommand="TRadGridPrijem_ItemCommand"
                AllowSorting="true" AutoFilterControlWidth="false" MasterTableView-ShowFooter="true" AutoGenerateColumns="false" OnNeedDataSource="TRadGridPrijem_NeedDataSource">
                <MasterTableView CommandItemDisplay="Top" Caption="[%Příjem na sklad%]" PageSize="15" PagerStyle-Visible="true">
                    <Columns>
                        <telerik:GridBoundColumn DataField="uzivatel" HeaderText="[%Uživatel%]" Display="true" SortExpression="uzivatel" UniqueName="uzivatel" ReadOnly="true" />
                        <telerik:GridBoundColumn DataField="id_prevodu" Display="true" HeaderText="[%ID převodu%]" SortExpression="id_prevodu" UniqueName="id_prevodu" ReadOnly="true" />
                        <telerik:GridBoundColumn DataField="sklad_ze" HeaderText="[%Ze skladu%]" Display="true" SortExpression="sklad_ze" UniqueName="sklad_ze" ReadOnly="true" />
                        <telerik:GridBoundColumn DataField="sklad_na" HeaderText="[%Na sklad%]" Display="true" SortExpression="sklad_na" UniqueName="sklad_na" ReadOnly="true" />
                        <telerik:GridBoundColumn DataField="mnozstvi" HeaderText="[%Pomůcek%]" Display="true" SortExpression="mnozstvi" UniqueName="mnozstvi" ReadOnly="true" />
                        <telerik:GridBoundColumn DataField="datum_expedice" HeaderText="[%Expedováno%]" Display="true" SortExpression="datum_expedice" UniqueName="datum_expedice" ReadOnly="true" DataType="System.DateTime" DataFormatString="{0:d}" />
                        <telerik:GridBoundColumn DataField="poznamka" HeaderText="[%Poznámka%]" Display="true" SortExpression="poznamka" UniqueName="poznamka" ReadOnly="true" />
                        <telerik:GridTemplateColumn ItemStyle-HorizontalAlign="Center" AllowFiltering="false" AllowSorting="false">
                            <ItemTemplate>
                                <telerik:RadButton ID="RB_Detail" runat="server" AutoPostBack="true" ToolTip="Detail" CommandName="Detail" CssClass="kstlacitko" Icon-PrimaryIconCssClass="fi fi-eye"></telerik:RadButton>
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                        <telerik:GridTemplateColumn ItemStyle-HorizontalAlign="Center" AllowFiltering="false" AllowSorting="false">
                            <ItemTemplate>
                                <telerik:RadButton ID="RB_Prijmout" runat="server" AutoPostBack="true" ToolTip="[%Přijmout%]" CommandName="Prijmout" CssClass="kstlacitko" Icon-PrimaryIconCssClass="fi fi-check"></telerik:RadButton>
                            </ItemTemplate>
                        </telerik:GridTemplateColumn>
                    </Columns>
                    <CommandItemTemplate>
                        <kspwc:GridCommandItemControl ID="GcIc6" runat="server" ExportButton-Visible="false"></kspwc:GridCommandItemControl>
                    </CommandItemTemplate>
                </MasterTableView>
            </kspwc:TRadGrid>
            <asp:HiddenField ID="HF_VybranyPrevod" Value="" runat="server" />
            <telerik:RadWindow ID="RadWindow3" Title="[%Detail převodu%]" runat="server" Behaviors="Close,Move" Modal="true"
                Width="800" Height="600" VisibleOnPageLoad="false">
                <ContentTemplate>
                    <div style="margin: auto; text-align: center;">
                        <kspwc:TRadGrid ID="TRadGridDetail" runat="server" AllowPaging="True" ShowGroupPanel="false" AllowMultiRowSelection="false" CssClass="revertShadow" OnNeedDataSource="TRadGridDetail_NeedDataSource"
                            AllowSorting="true" AutoFilterControlWidth="false" MasterTableView-ShowFooter="true" AutoGenerateColumns="false" OnItemCommand="TRadGridDetail_ItemCommand">
                            <MasterTableView CommandItemDisplay="Top" PagerStyle-Visible="false" EditMode="InPlace">
                                <Columns>
                                    <telerik:GridEditCommandColumn UpdateText="[%Uložit%]" Exportable="false" UniqueName="editCol" />
                                    <telerik:GridBoundColumn DataField="id_pomucky" HeaderText="[%ID pomůcky%]" SortExpression="id_pomucky" UniqueName="id_pomucky" ReadOnly="true" ItemStyle-HorizontalAlign="Right" />
                                    <telerik:GridBoundColumn DataField="id_na_sklade" HeaderText="[%ID na skladě%]" SortExpression="id_na_sklade" UniqueName="id_na_sklade" ReadOnly="true" />
                                    <telerik:GridNumericColumn DataField="mnozstvi" HeaderText="[%Množství%]" SortExpression="mnozstvi" UniqueName="mnozstvi" DataType="System.Int32" MinValue="1" DecimalDigits="0" />
                                    <telerik:GridBoundColumn DataField="nazev" HeaderText="[%Název%]" SortExpression="nazev" UniqueName="nazev" ReadOnly="true" />
                                    <telerik:GridBoundColumn DataField="atributy" HeaderText="[%Atributy%]" SortExpression="atributy" UniqueName="atributy" ReadOnly="true" />
                                    <telerik:GridBoundColumn DataField="velikost" HeaderText="[%Velikost%]" SortExpression="velikost" UniqueName="velikost" ReadOnly="true" />
                                    <telerik:GridBoundColumn DataField="pomu_pozn" HeaderText="[%Poznámka%]" SortExpression="pomu_pozn" UniqueName="pomu_pozn" ReadOnly="true" />
                                    <telerik:GridTemplateColumn UniqueName="deleteCol">
                                        <ItemTemplate>
                                            <telerik:RadButton ID="RB_Delete" runat="server" AutoPostBack="true" ToolTip="Smazat" CommandName="Delete" CssClass="kstlacitko" Icon-PrimaryIconCssClass="fi fi-trash"
                                                ConfirmText="[%Opravdu si přejete tuto pomůcku z převodu odstranit?%]">
                                            </telerik:RadButton>
                                        </ItemTemplate>
                                    </telerik:GridTemplateColumn>
                                </Columns>
                                <CommandItemTemplate>
                                    <%-- PMEJ 16.09.2024 - Oprava generace exportu --%>
                                    <%--<kspwc:GridCommandItemControl ID="GcIc6" runat="server" ></kspwc:GridCommandItemControl>--%>
                                    <kspwc:GridCommandItemControl ID="GcIc7" runat="server"></kspwc:GridCommandItemControl>
                                </CommandItemTemplate>
                            </MasterTableView>
                        </kspwc:TRadGrid>
                        <asp:Label runat="server" ID="Label_poznamka" Text="[%Poznámka k převodu%]:" CssClass="nadpis2"></asp:Label><br />
                        <telerik:RadTextBox runat="server" ID="RTB_poznamka_detail" Width="60%" MaxLength="80"></telerik:RadTextBox>
                        <div class="prevodButtons">
                            <telerik:RadButton ID="TRB_Prijmout" runat="server" Text="[%Přijmout převod%]" AutoPostBack="true" CssClass="kstlacitko" Icon-PrimaryIconCssClass="fi fi-check" OnClick="TRB_Prijmout_Click"></telerik:RadButton>
                            <telerik:RadButton ID="TRB_Vratit" runat="server" Text="[%Vrátit převod%]" AutoPostBack="true" CssClass="kstlacitko" Icon-PrimaryIconCssClass="fi fi-undo" ToolTip="[%Převod bude vrácen na sklad, ze kterého byl odeslán%]."
                                ConfirmSettings-ConfirmText="[%Opravdu si přejete převáděné pomůcky vrátit na původní sklad? (Pokud byl převod vytvořen vytvořen vracením pomůcky na jiný sklad, bude pomůcka vrácena na původní sklad, ne zaměstnanci.)%]."
                                ConfirmSettings-Width="500" OnClick="TRB_Vratit_Click">
                            </telerik:RadButton>
                            <telerik:RadButton ID="TRB_ZrusitPrevod" runat="server" Text="[%Smazat převod%]" OnClick="TRB_ZrusitPrevod_Click" AutoPostBack="true" CssClass="kstlacitko" Icon-PrimaryIconCssClass="fi fi-ban"
                                ConfirmSettings-ConfirmText="[%Smazáním převodu budou ztraceny všechny pomůcky, které jsou jeho součástí%]." ConfirmSettings-Width="400">
                            </telerik:RadButton>
                        </div>
                            <asp:Label ID="ErrorPrijem" runat="server" Text="" Visible="false" ForeColor="Red"></asp:Label>
                    </div>
                </ContentTemplate>
            </telerik:RadWindow>
        </div>
    </div>

    <div class="ksprvek" style="padding: 25px; margin: 10px; display: flex; flex-direction: row;">
        <div style="flex: 2; margin-right: 20px;">
            <kspwc:TRadGrid ID="TRadGridPrijemSklad" runat="server" AllowPaging="True" ShowGroupPanel="false" AllowMultiRowSelection="false" CssClass="revertShadow" ClientSettings-DataBinding-ShowEmptyRowsOnLoad="true"
                AllowSorting="true" AutoFilterControlWidth="false" MasterTableView-ShowFooter="true" AutoGenerateColumns="false" OnNeedDataSource="TRadGridPrijemSklad_NeedDataSource">
                <MasterTableView CommandItemDisplay="Top" Caption="[%Změny množství na skladech%]" PageSize="10" PagerStyle-Visible="true">
                    <Columns>
                        <telerik:GridBoundColumn DataField="id_sklad" HeaderText="[%Sklad%]" SortExpression="id_sklad" UniqueName="id_sklad" />
                        <telerik:GridBoundColumn DataField="nazev" HeaderText="[%Pomůcka%]" SortExpression="nazev" UniqueName="nazev" />
                        <telerik:GridBoundColumn DataField="prij_mn" HeaderText="[%Množství%]" SortExpression="prij_mn" UniqueName="prij_mn" ItemStyle-HorizontalAlign="Right" />
                        <telerik:GridBoundColumn DataField="id_na_sklade" HeaderText="[%ID%]" SortExpression="id_na_sklade" UniqueName="id_na_sklade" />
                        <telerik:GridBoundColumn DataField="uzivatel" HeaderText="[%Uživatel%]" SortExpression="uzivatel" UniqueName="uzivatel" />
                        <telerik:GridBoundColumn DataField="datum" HeaderText="[%Datum%]" SortExpression="datum" UniqueName="datum" DataFormatString="{0:d}" />
                        <telerik:GridBoundColumn DataField="cena_poriz" HeaderText="[%Cena%]" SortExpression="cena_poriz" UniqueName="cena_poriz" />
                        <telerik:GridBoundColumn DataField="velikost" HeaderText="[%Velikost%]" SortExpression="velikost" UniqueName="velikost" />
                        <telerik:GridBoundColumn DataField="poznamka" HeaderText="[%Poznámka%]" SortExpression="poznamka" UniqueName="poznamka" />
                    </Columns>
                    <CommandItemTemplate>
                        <kspwc:GridCommandItemControl ID="GcIc5" runat="server"></kspwc:GridCommandItemControl>
                    </CommandItemTemplate>
                </MasterTableView>
            </kspwc:TRadGrid>
        </div>
        <div style="flex: 1; margin-top: 8px;">
            <asp:Label ID="Label12" runat="server" Text="[%Import na sklady%]" CssClass="nadpis1"></asp:Label>

            <asp:Label ID="FailureLabel" Text="" runat="server" ForeColor="Red"></asp:Label>
            <telerik:RadAsyncUpload runat="server" ID="RAU_ImportSklady" AllowedFileExtensions=".xlsx,.csv" MultipleFileSelection="Automatic" TemporaryFolder="~/Temp"></telerik:RadAsyncUpload>
            <br />
            <kspwc:TRadButton runat="server" ID="TRB_uploadFile" OnClick="TRB_uploadFile_Click" Text="[%Nahrát soubor%]" Icon-PrimaryIconCssClass="fi fi-file-import"></kspwc:TRadButton>
            <br />
            <br />
            <telerik:RadTextBox runat="server" ID="RTB_vystupniText" ReadOnly="true" Width="100%" Height="300px" TextMode="MultiLine" Resize="Both"></telerik:RadTextBox>
        </div>
    </div>

    <style type="text/css">
        .statistika {
            display: flex;
            flex-direction: column;
            text-align: center;
            margin: 10px;
            min-width: 50px;
        }

            .statistika span {
                font-size: 34px;
            }

        .hiddenButton {
            display: none;
        }

        #RadWindowWrapper_ctl00_HlavniOblast_RadWindow2 {
            z-index: 3050 !important;
        }

        .prevodButtons {
            display: block ruby;
        }

            .prevodButtons .kstlacitko {
                margin: auto;
                margin-top: 15px;
                display: block;
            }

        #ctl00_ctl00_HlavniOblast_TRadGridSkladPanel tbody .kstlacitko, #ctl00_ctl00_HlavniOblast_TRadGridPomuckaPanel tbody .kstlacitko {
            background: inherit !important;
            color: inherit !important;
        }
    </style>
</asp:Content>
