﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="ConfiguraceSchemat.aspx.cs" Inherits="KSPortal.Pis.ConfiguraceSchemat" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
<style type="text/css">   
    .wiz-container .inputWapper {
	display: inline-block;
	*display: inline;
	width: 320px;
	position: relative;
	margin-top:15px;
}

.wiz-container .inputWapper.first 
{
	display:block;
	margin-right: 35px;
}

.wiz-container .inputWapper label {
	display: block;
	margin: 5px 0 0;
}
</style>
    <div class="wiz-container">
        <telerik:RadCodeBlock runat="server" ID="code_block">
            <%--src="../Scripts/ConfiguraceSchemat.js"--%>
            <script type="text/javascript">
        //<![CDATA[
                var RadWizard1;
                var btnToggle_novy;
                var seznam_schema;
                var NazevTextBox;
                var RadekDropDownList;
                var val_seznam_schemat
                var btn_prava;
                var RadListBox_role_nabidka;
                var RadListBox_role_vybrano;
                var RadButtonPM;
                var SpecDatDropDown;
                (function () {
                    var oldPageLoad = KSMaster.onPageLoad;
                    KSMaster.onPageLoad = function () {
                        oldPageLoad.apply();

                        RadWizard1 = $find("<%=RadWizard1.ClientID %>");
                        btnToggle_novy = $find("<%=btnToggle_novy.ClientID %>");
                        seznam_schema = $find("<%=seznam_schemat.ClientID %>");

                        NazevTextBox = $find("<%=NazevTextBox.ClientID %>");
                        dat_od = $find("<%=dat_od.ClientID %>");
                        dat_do = $find("<%=dat_do.ClientID %>");

                        RadListBox_radky_nabidka = $find("<%=RadListBox_radky_nabidka.ClientID %>");
                        RadListBox_radky_vybrano = $find("<%=RadListBox_radky_vybrano.ClientID %>");
                        btn_prava = $find("<%=btn_prava.ClientID %>");
                        RadListBox_role_nabidka = $find("<%=RadListBox_role_nabidka.ClientID %>");
                        RadListBox_role_vybrano = $find("<%=RadListBox_role_vybrano.ClientID %>");
                        RadButtonPM = $find("<%=RadButtonPM.ClientID %>");
                        SpecDatDropDown = $find("<%=SpecDatDropDown.ClientID %>");
                    }
                    KSMaster.onPageLoad.prototype = oldPageLoad.prototype;

                    window.OnClientLoad = function (sender, args) {
                        //provedu inicializaci, tzn načtu seznam schémat, a vyčistím položky v datech
                        sender.set_activeIndex(0);
                        for (var i = 1; i < sender.get_wizardSteps().get_count(); i++) {
                            sender.get_wizardSteps().getWizardStep(i).set_enabled(false);
                        }
                        args.parm = "";
                        PageMethods.LoadSeznamSchemat(args.parm, loadInitSucces, loadInitFailed);
                    }

                    window.loadInitSucces = function (response) {
                        var r = $telerik.$.parseJSON(response);
                        var items = seznam_schema.get_items();
                        items.clear();
                        seznam_schema.trackChanges();
                        for (var i = 0; i < r.length; i++) {
                            var it = new Telerik.Web.UI.RadListBoxItem();
                            it.set_text(r[i].nazev);
                            it.set_value(r[i].id);
                            items.add(it);
                        };
                        seznam_schema.commitChanges();
                    }

                    window.loadInitFailed = function (response) {
                        alert(response);
                    }

                    window.OnClientButtonClicking = function (sender, args) {

                        if ((sender.get_activeIndex() == 0) && (args.get_command() == 1)) {
                            if (seznam_schema.get_visible()) {
                                if (seznam_schema.get_selectedItem() == null) {
                                    radalert('Nelze pokračovat, není vybrána žádná položka ze seznamu', 330, 180, 'Seznam schémat', null, null);
                                    args.set_cancel(true);
                                }
                            }
                        }
                        if (args.get_command() == 2) {
                            odeslatJSON();
                        } else if (!args.get_nextActiveStep().get_enabled()) {
                            args.get_nextActiveStep().set_enabled(true);
                        }
                    }                   

                    window.PopulateData = function (source, args) {

                        //inicializační načtení dat
                    }
                })();
                function btnToggle_novy_OnClientCheckedChanged(sender, args) {
                    var val = btnToggle_novy.get_selectedToggleState().get_value();
                    var schema = "";
                    if (val == "novy") {
                        schema = "novy";
                    } else if (val == "vyber") {
                        var item = seznam_schema.get_selectedItem();
                        if (item != null) {
                            schema = item.get_value();
                        } else { schema = "val"; }

                    }
                    args.schema = schema;
                    nactiSchema(sender, args);
                }

                function seznam_schemat_OnClientSelectedIndexChanged(sender, args) {
                    var item = args.get_item();
                    args.schema = item.get_value();
                    nactiSchema(sender, args);
                }
                function nactiSchema(sender, args) {
                    seznam_schema.set_visible((args.schema != "novy"));
                    for (var i = 1; i < RadWizard1.get_wizardSteps().get_count(); i++) {
                        RadWizard1.get_wizardSteps().getWizardStep(i).set_enabled(false);
                    }
                    PageMethods.LoadNovy(args.schema, loadNastaveniSucces, loadNastaveniFailed);
                }

                function loadNastaveniSucces(response) {
                    var r = $telerik.$.parseJSON(response);
                    NazevTextBox.set_value(r.schema.nazev);
                    var d_od = parseJsonDate(r.schema.datum_od);
                    var d_do = parseJsonDate(r.schema.datum_do);
                    dat_od.set_selectedDate(d_od);
                    dat_do.set_selectedDate(d_do);
                    if (SpecDatDropDown.findItemByValue(r.schema.spec_datum) != null) SpecDatDropDown.findItemByValue(r.schema.spec_datum).select(true);

                    var index = 0;
                    if (r.schema.prava) index = 1;
                    btn_prava.set_selectedToggleStateIndex(index);

                    index = 0;
                    if (!r.schema.pm_vse) index = 1;
                    RadButtonPM.set_selectedToggleStateIndex(index);

                    populateRadekdd(RadListBox_radky_nabidka, r.radky_nevybrane);
                    populateRadekdd(RadListBox_radky_vybrano, r.radky_vybrane);

                    populateRoledd(RadListBox_role_nabidka, r.role_nevybrane);
                    populateRoledd(RadListBox_role_vybrano, r.role_vybrane);
                }
                function loadNastaveniFailed(response) {
                    alert(response);
                }
                function parseJsonDate(dstr) {
                    if (dstr == null) return dstr;
                    return new Date(parseInt(dstr.replace('/Date(', '')));
                }
                function populateRadekdd(dd, arr_radky) {
                    var items = dd.get_items();
                    dd.get_items().clear();
                    if (arr_radky != null) {
                        for (var i = 0; i < arr_radky.length; i++) {
                            var item = new Telerik.Web.UI.RadListBoxItem();
                            item.set_text(arr_radky[i].polozka_popis);
                            item.set_value(arr_radky[i].polozka);
                            items.add(item);
                        }
                    }
                }
                function populateRoledd(dd, arr_role) {
                    var items = dd.get_items();
                    dd.get_items().clear();
                    if (arr_role != null) {
                        for (var i = 0; i < arr_role.length; i++) {
                            var item = new Telerik.Web.UI.RadListBoxItem();
                            item.set_text(arr_role[i].popisek_role);
                            item.set_value(arr_role[i].role_id);
                            items.add(item);
                        }
                    }
                }
                function populatePolozky(radky) {
                    for (var i = 0; i < RadekDropDownList.length; i++) {
                        RadekDropDownList[i].clearSelection();
                    }
                    for (var i = 0; i < radky.length; i++) {
                        if (radky[i] != null) {
                            if (radky[i].c_radku == (i + 1)) {
                                var it = RadekDropDownList[i].findItemByValue(radky[i].polozka);
                                RadekDropDownList[i].set_value(radky[i].polozka);
                                RadekDropDownList[i].set_text(it.get_text());
                                it.selected = true;
                            }
                        }
                    }
                }

                function createJSON() {
                    jsonObj = [];
                    var id_schema = 0;
                    if (btnToggle_novy.get_selectedToggleState().get_value() == "vyber") {
                        var item = seznam_schema.get_selectedItem();
                        id_schema = item.get_value();
                    }
                    var datum_od = dat_od.get_selectedDate();
                    var datum_do = dat_do.get_selectedDate();
                    var spec_dat = SpecDatDropDown._selectedValue;
                    //radky
                    var radky = new Array();
                    var r = RadListBox_radky_vybrano.get_items();
                    var citac = 0;
                    r.forEach(function (item) {
                        var val = item.get_value();
                        radky[citac] = { "polozka": val, "c_radku": citac };
                        citac++;
                    });

                    //role
                    var role = new Array();
                    var r = RadListBox_role_vybrano.get_items();
                    var citac = 0;
                    r.forEach(function (item) {
                        var val = item.get_value();
                        role[citac] = { "role_id": val };
                        citac++;
                    });

                    var pm_vse = (RadButtonPM.get_selectedToggleState().get_value()=="1");
                    

                    //seznam_schemat
                    var item = { "id": id_schema, "nazev": NazevTextBox.get_value(), "datum_od": datum_od, "datum_do": datum_do, "spec_datum": spec_dat, "pm_vse": pm_vse, "prava": btn_prava.get_selectedToggleState().get_value() };
                    var root = { "schema": item, "radky_vybrane": radky, "role_vybrane": role };
                    jsonObj.push(root);

                    return jsonObj;
                }

                function odeslatJSON() {
                    var d = createJSON();
                    var data_send = JSON.stringify(d);
                    $.ajax({
                        type: "POST",
                        url: "ConfiguraceSchemat.aspx/SaveDefinici",
                        data: "{data:'" + data_send + "'}",
                        contentType: "application/json",
                        dataType: "json",
                        error: function (xhr, ajaxOptions, thrownError) {
                            alert(xhr.status);
                            alert(xhr.responseText);
                            alert(thrownError);
                        },
                        success: function (msg) {
                            //radalert('Data byla úspěšně odeslána', 330, 180, 'Ukládání dat', null, null); //$dialogsDemo.imgUrl
                            KSMaster.NotifikaceInfoUlozeni();
                            var args = new Object();
                            OnClientLoad(RadWizard1, args);
                        }
                    });
                }
              //]]>
            </script>
        </telerik:RadCodeBlock>
        <div class="wizardHeader">
        <asp:Label runat="server" ID="lab_header"  Text="[%Konfigurace systemizačních schémat%]" CssClass="ksnadpis"></asp:Label>        
        </div>
        <telerik:RadWizard ID="RadWizard1" runat="server" Height="500px" OnClientLoad="OnClientLoad"
            OnClientButtonClicking="OnClientButtonClicking" Localization-Next="Následující" CssClass="ksprvek"
            Localization-Finish="Hotovo" Localization-Previous="Předchozí">
            <WizardSteps>
                <telerik:RadWizardStep ID="RadWizardStep0" Title="[%Výběr schématu%]" runat="server"
                    StepType="Start" CausesValidation="true" ValidationGroup="vyberSchematu">
                    <table style="margin-top:15px;">
                        <tr>
                            <td style="vertical-align:top">                               
                                    <telerik:RadButton ID="btnToggle_novy" runat="server" Value="vyber" ToggleType="CustomToggle"
                                        Width="150" ButtonType="StandardButton" GroupName="StandardButton" AutoPostBack="false"
                                        OnClientToggleStateChanged="btnToggle_novy_OnClientCheckedChanged">
                                        <%--OnClientClicked="OnClientClicked_btnToggle_novy"--%>
                                        <ToggleStates>
                                            <telerik:RadButtonToggleState Text="[%Nové%]" Value="novy" Selected="false" />
                                            <telerik:RadButtonToggleState Text="[%Výběr existujícího%]" Value="vyber" Selected="true"/>
                                        </ToggleStates>
                                    </telerik:RadButton>
                            </td>
                            <td style="vertical-align:top">                                                      
                                <telerik:RadListBox runat="server" ID="seznam_schemat" OnClientSelectedIndexChanged="seznam_schemat_OnClientSelectedIndexChanged" Height="300" Width="300">
                                    <HeaderTemplate>
                         <asp:Label runat="server" ID="lab_header_seznam_schemat" Text="[%Seznam schémat%]"></asp:Label>
                    </HeaderTemplate> 
                                </telerik:RadListBox>
                           
                            </td>                           
                        </tr>
                    </table>
                </telerik:RadWizardStep>
                <telerik:RadWizardStep ID="RadWizardStep1" Title="[%Název schématu%]" runat="server"
                    StepType="Step" ValidationGroup="nazev_schematu" CausesValidation="true" > <%--SpriteCssClass="accountInfo"--%>
                    <div class="inputWapper first">
                        <asp:Label ID="Label2" Text="[%Název schématu%]:" runat="server" AssociatedControlID="NazevTextBox" />
                        <telerik:RadTextBox ID="NazevTextBox" runat="server" ValidationGroup="nazev_schematu">
                        </telerik:RadTextBox>
                        <br />
                        <kspwc:TRequiredValidator ID="PasswordTextBoxRequiredFieldValidator" runat="server"
                            ControlToValidate="NazevTextBox" EnableClientScript="true" ValidationGroup="nazev_schematu"></kspwc:TRequiredValidator>
                    </div>
                    <div class="inputWapper first">
                        <asp:Label runat="server" ID="lab_od" Text="[%Platnost od%]:" AssociatedControlID="dat_od"></asp:Label>
                        <telerik:RadDatePicker runat="server" ID="dat_od">
                        </telerik:RadDatePicker>
                    </div>
                    <div class="inputWapper first">
                        <asp:Label runat="server" ID="Label1" Text="[%Platnost do%]:" AssociatedControlID="dat_do"></asp:Label>
                        <telerik:RadDatePicker runat="server" ID="dat_do">
                        </telerik:RadDatePicker>
                    </div>

                     <div class="inputWapper first">
                        <asp:Label runat="server" ID="Label3" Text="[%Pracovní místa%]:" AssociatedControlID="dat_do"></asp:Label>
                        
                        <telerik:RadButton ID="RadButtonPM" runat="server" Value="1" ToggleType="CheckBox"
                                Width="150" ButtonType="StandardButton" GroupName="StandardButton" AutoPostBack="false" >                                       
                                <ToggleStates>
                                    <telerik:RadButtonToggleState Text="[%Všechna%]" Value="1" Selected="false"  PrimaryIconCssClass="fi fi-checkbox" />
                                    <telerik:RadButtonToggleState Text="[%Jen obsazená%]" Value="0" Selected="true" PrimaryIconCssClass="fi fi-square" />
                                </ToggleStates>
                            </telerik:RadButton>
                    </div>
                    <div class="inputWapper first">
                        <asp:Label runat="server" ID="labSpecDat" Text="[%Zobrazené období%]" AssociatedControlID="dat_do"></asp:Label>

                        <telerik:RadDropDownList ID="SpecDatDropDown" runat="server" Width="150">
                         <Items>
                                <telerik:DropDownListItem Text="Aktuální" Value="a" />
                                <telerik:DropDownListItem Text="Poslední ukončené" Value="p" />
                            </Items>
                        </telerik:RadDropDownList>
                    </div>

                </telerik:RadWizardStep>
                <telerik:RadWizardStep ID="RadWizardStep2" Title="[%Výběr položek%]" runat="server" StepType="Step"
                    ValidationGroup="personalInfo" SpriteCssClass="personalInfo">
                   <div style="margin:15px; white-space:nowrap;">
                        <telerik:RadListBox ID="RadListBox_radky_nabidka" runat="server" Width="300px" Height="300px"
                            SelectionMode="Multiple" AllowTransfer="true" TransferToID="RadListBox_radky_vybrano"
                            EnableDragAndDrop="true">
                        </telerik:RadListBox>
                        <telerik:RadListBox ID="RadListBox_radky_vybrano" runat="server" Width="300px" Height="300px"
                            SelectionMode="Multiple" EnableDragAndDrop="true">
                        </telerik:RadListBox>
                    </div>
                </telerik:RadWizardStep>
                <telerik:RadWizardStep ID="RadWizardStep3" Title="[%Práva%], [%role%]" runat="server" StepType="Finish"
                    ValidationGroup="PravaDetails" SpriteCssClass="contactDetails">
                   <table style="margin:15px;">
                   <tr>
                   <td style="vertical-align:top;width:150px;">
                     <asp:Label ID="label_prava" Text="[%Aplikovat řádková práva%]" runat="server" AssociatedControlID="btn_prava"></asp:Label>
                        <telerik:RadButton ID="btn_prava" runat="server" ToggleType="CheckBox" Value="True"
                            ButtonType="LinkButton" AutoPostBack="false">
                            <ToggleStates>
                                <telerik:RadButtonToggleState Text="[%Ne%]" Value="False" PrimaryIconCssClass="fi fi-square" />
                                <telerik:RadButtonToggleState Text="[%Ano%]" Value="True" PrimaryIconCssClass="fi fi-checkbox" />
                            </ToggleStates>
                        </telerik:RadButton>
                   </td>
                   <td style="white-space:nowrap;">
                     <telerik:RadListBox ID="RadListBox_role_nabidka" runat="server" Width="300px" Height="300"
                            SelectionMode="Multiple" AllowTransfer="true" TransferToID="RadListBox_role_vybrano"
                            EnableDragAndDrop="true">
                        </telerik:RadListBox>
                        <telerik:RadListBox ID="RadListBox_role_vybrano" runat="server" Width="300px" Height="300px"
                            SelectionMode="Multiple" EnableDragAndDrop="true">
                        </telerik:RadListBox>
                   </td>
                   </tr>
                   </table>                    
                                    
                </telerik:RadWizardStep>
                <%--<telerik:RadWizardStep StepType="Finish" Title="Confirmation" ValidationGroup="Confirmation" SpriteCssClass="confirmation">
                    <p>Make sure you review our anti-spam, privacy and terms of use policies before you create an account. We take spam very seriously and have a strict permission policy you and your clients will need to abide by.</p>
                    <p class="anti-spam-policy">
                        <asp:Button runat="server" ID="but_odeslat"  OnClientClick="odeslatJSON();return false;" />
                        <asp:CheckBox ID="AcceptTermsCheckBox" runat="server" Text="I agree to the terms of use and will abide by the anti-spam policy." CausesValidation="true" ValidationGroup="Confirmation" />
                        <asp:CustomValidator ID="AcceptTermsCheckBoxCustomValidator" runat="server"
                            EnableClientScript="true" ClientValidationFunction="AcceptTermsCheckBoxValidation" ValidationGroup="Confirmation"
                            ErrorMessage="Please agree to the anti-spam policy" Display="Dynamic"
                            CssClass="checkbox-validator" ForeColor="Red" />
                    </p>
                </telerik:RadWizardStep>--%>
                <%-- <telerik:RadWizardStep ID="RadWizardStep4" runat="server" StepType="Complete" CssClass="complete">
                    <p>Konfirugare schématu úspěšně dokončena</p>                    
                </telerik:RadWizardStep>--%>
            </WizardSteps>
        </telerik:RadWizard>
    </div>
</asp:Content>
