﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="OborVzdelani.aspx.cs" Inherits="KSPortal.Pis.OborVzdelani" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <script type="text/javascript" >
        OborVzdel = {};        
        OborVzdel.btnCR = {};
        OborVzdel.btnZ = {};
        OborVzdel.ddl_rok_ukonc = {};
        OborVzdel.ddl_typ_skoly = {};
        OborVzdel.ddl_mesto = {};
        OborVzdel.ddl_skola = {};
        OborVzdel.ddl_obor = {};
        OborVzdel.vysledny_kod = {};

        function btn_misto_OnClientClicked(sender, eventArgs) {  
            clearDds([OborVzdel.ddl_typ_skoly, OborVzdel.ddl_mesto, OborVzdel.ddl_skola, OborVzdel.ddl_obor]);
            switchElements();
            disableDds();
            enableDds([OborVzdel.ddl_rok_ukonc]);
        }      

        function ddl_rok_ukonc_OnClientSelectedIndexChanged(sender, eventArgs) {          
            clearDds([OborVzdel.ddl_typ_skoly, OborVzdel.ddl_mesto, OborVzdel.ddl_skola, OborVzdel.ddl_obor]);
            switchElements();
            enableDds([OborVzdel.ddl_typ_skoly]);
        }
        function ddl_typ_skoly_OnClientSelectedIndexChanged(sender, eventArgs) {            
            clearDds([OborVzdel.ddl_mesto, OborVzdel.ddl_skola, OborVzdel.ddl_obor]);
            switchElements();
            if (pouzijBaso())
                enableDds([OborVzdel.ddl_obor]);
            else
                enableDds([OborVzdel.ddl_mesto]);
        }
        function ddl_mesto_OnClientSelectedIndexChanged(sender, eventArgs) {
            clearDds([OborVzdel.ddl_skola, OborVzdel.ddl_obor]);
            enableDds([OborVzdel.ddl_skola]);
        }
        function ddl_skola_OnClientSelectedIndexChanged(sender, eventArgs) {
            var arr = [OborVzdel.ddl_obor];
            clearDds(arr);
            enableDds([OborVzdel.ddl_obor]);
        }

        function ddl_rok_ukonc_OnClientItemsRequesting(sender, eventArgs) {
            var context = eventArgs.get_context();
            context["co"] = "roky";
        }

        function ddl_typ_skoly_OnClientItemsRequesting(sender, eventArgs) {
            var context = eventArgs.get_context();
            context["co"] = "typy_skol";
            context["rok"] = OborVzdel.ddl_rok_ukonc.get_selectedItem().get_value();
            context["misto_studia"] = misto_studia();
        }
        function ddl_mesto_OnClientItemsRequesting(sender, eventArgs) {
            var context = eventArgs.get_context(); 
            context["co"] = "mesto";
            context["rok"] = OborVzdel.ddl_rok_ukonc.get_selectedItem().get_value();;           
            context["misto_studia"] = misto_studia();
            context["typ"] = OborVzdel.ddl_typ_skoly.get_value();
        }

        function ddl_skola_OnClientItemsRequesting(sender, eventArgs) {
            var context = eventArgs.get_context();            
            context["co"] = "skola";
            context["rok"] = OborVzdel.ddl_rok_ukonc.get_selectedItem().get_value();; 
            context["misto_studia"] = misto_studia();
            context["typ"] = OborVzdel.ddl_typ_skoly.get_selectedItem().get_value();
            if (!pouzijBaso()) {
                context["obec"] = OborVzdel.ddl_mesto.get_selectedItem().get_value();
            }
            else {
                context["obec"] = "";
            }
        }

        function ddl_obor_OnClientItemsRequesting(sender, eventArgs) {
            var context = eventArgs.get_context();            
            context["co"] = "obor";
            context["rok"] = OborVzdel.ddl_rok_ukonc.get_selectedItem().get_value();;     
            context["misto_studia"] = misto_studia();
            context["typ"] = OborVzdel.ddl_typ_skoly.get_selectedItem().get_value();
            if (!pouzijBaso()) {
                context["obec"] = OborVzdel.ddl_mesto.get_selectedItem().get_value();
                context["skola"] = OborVzdel.ddl_skola.get_selectedItem().get_value();
            }
            else {
                context["obec"] = "";
                context["skola"] = "";
            }
        }

        function misto_studia() {
            if (OborVzdel.btnCR.get_checked()) return "CR";
            return "Z";
        }

        function clearDds(arr) {
            for (var i = 0; i < arr.length; i++) {
                arr[i].clearItems();
                arr[i].clearSelection();
            }
            OborVzdel.vysledny_kod.set_textBoxValue("");
        }

        function disableDds() {
            OborVzdel.ddl_typ_skoly.disable();
            OborVzdel.ddl_mesto.disable();
            OborVzdel.ddl_skola.disable();
            OborVzdel.ddl_obor.disable();

        }
        function enableDds(arr) {
          
            for (var i = 0; i < arr.length; i++) {
                arr[i].enable();              
            }
        }

        function switchElements() {
            var misto = misto_studia();
            if ((OborVzdel.ddl_rok_ukonc.get_selectedItem() == null) &&(misto==="Z")){
                applyShowHide(false);
                return;
            }
           
            var rok = OborVzdel.ddl_rok_ukonc.get_selectedItem().get_value();
            var it = OborVzdel.ddl_typ_skoly.get_selectedItem();
            var typ = "";
            if (it != null)
                typ=OborVzdel.ddl_typ_skoly.get_selectedItem().get_value();            
            if (!pouzijBaso(misto, rok, typ))
            {
                applyShowHide(true); //tohle je zjednodušené BASO
            }
            else {
                applyShowHide(false);//pro tento stav se zobrazuje obec a škola
            }           
        }
        function applyShowHide(prep) {
            if (prep) {
                $("#div_mesto").show();
                $("#div_skola").show();
            }
            else {
                $("#div_mesto").hide();
                $("#div_skola").hide();
            }
        }

        function ddl_obor_OnClientSelectedIndexChanged(sender, eventArgs) {
            var item = eventArgs.get_item();
            var kod = item.get_attributes().getAttribute("vysl_kod");
            OborVzdel.vysledny_kod.set_value(kod);
            OborVzdel.vysledny_kod.set_textBoxValue(kod);
        }

        function OnClientLoadHandler(sender) {
            sender.get_inputDomElement().readOnly = "readonly";
        }

        function pouzijBaso()
        {
            var misto = misto_studia();
            var rok = OborVzdel.ddl_rok_ukonc.get_selectedItem().get_value();
            if ((misto == "Z") || (rok < 1991))
                return true;

            if (OborVzdel.ddl_typ_skoly.get_selectedItem() == null) return false;
            var typ = OborVzdel.ddl_typ_skoly.get_selectedItem().get_value();
            
            if ((rok >= 1991) && (rok < 2006) && (typ.substring(0, 2) != "VS"))
                return true;

            return false;
        }

        function button_close_OnClientClicked(sender, args) {
            var wnd = GetRadWindow();            
            var parent = wnd.BrowserWindow;            
            wnd.BrowserWindow.populateOborVzdel(OborVzdel.vysledny_kod.get_value());
            wnd.close();
        }

        function button_only_close_OnClientClicked(sender, args) {          
            GetRadWindow().close();
        }

        function GetRadWindow() {
            var oWindow = null;
            if (window.radWindow) oWindow = window.radWindow;
            else if (window.frameElement.radWindow) oWindow = window.frameElement.radWindow;
            return oWindow;
        }


        function initFunction() {           
            OborVzdel.btnCR = $find("<%=btnCR.ClientID %>");
            OborVzdel.btnZ = $find("<%=btnZ.ClientID %>");
            OborVzdel.ddl_rok_ukonc = $find("<%=ddl_rok_ukonc.ClientID %>");
            OborVzdel.ddl_typ_skoly = $find("<%=ddl_typ_skoly.ClientID %>");
            OborVzdel.ddl_mesto = $find("<%=ddl_mesto.ClientID %>");
            OborVzdel.ddl_skola = $find("<%=ddl_skola.ClientID %>");
            OborVzdel.ddl_obor = $find("<%=ddl_obor.ClientID %>"); 
            OborVzdel.vysledny_kod = $find("<%=vysledny_kod.ClientID %>"); 

            disableDds();
            Sys.Application.remove_load(initFunction);
        }
        Sys.Application.add_load(initFunction);
</script>
<style type="text/css">
   .rdfLabel
   {
       
   }
   .labelContainer
   {
       width:150px !important;
   }
   .rdfRow
   {
       margin-top:15px;
   }
   .vyslKod
   {
       background-color:lightgray;
       color:white !important;
       text-align:center;
   }
    .panel-top {
        display: none !important;
    }

    .tiskHide {
        display: none !important;
    }

    .header {
        width: 100%;
        text-align: center !important;
    }

    .table-main {
        width: 100% !important;
        height: 100% !important;
    }

    .main_content_td {
        padding-top: 0px !important;
    }

    .content1, .content2 {
        height: calc(100% - 20px) !important;
    }
    
</style>
        <div>
         <div class="rdfRow">
             <telerik:RadButton OnClientClicked="btn_misto_OnClientClicked" AutoPostBack="false" Width="200" style="padding-left:80px;"   ID="btnCR" runat="server" Text="ČR" Value="CR" ToggleType="Radio" GroupName="misto" Checked="true"
                ButtonType="StandardButton"></telerik:RadButton>
            <telerik:RadButton OnClientClicked="btn_misto_OnClientClicked" AutoPostBack="false" Width="200" style="margin-left:100px;text-align:center;"  ID="btnZ" runat="server" Text="Zahranicí" Value="Z" ToggleType="Radio" GroupName="misto"
                ButtonType="LinkButton">
            </telerik:RadButton> 
        </div>
             <div class="rdfRow">
                 <div class="labelContainer">
                   <asp:Label ID="Label1" runat="server" CssClass="rdfLabel rdfBlock" Text="[%Rok ukončení studia%]"></asp:Label>
                </div>                
                   <kspwc:TRadComboBox ID="ddl_rok_ukonc" runat="server" DropDownAutoWidth="Enabled" AllowCustomText="false" EmptyMessage="[%Vyberte rok ukončení studia%]" OnClientItemsRequesting="ddl_rok_ukonc_OnClientItemsRequesting"
                        EnableLoadOnDemand="True" EnableVirtualScrolling="true" AutoPostBack="false" OnClientSelectedIndexChanged="ddl_rok_ukonc_OnClientSelectedIndexChanged"
                        ShowMoreResultsBox="True" Width="500px"  DropDownWidth="500" OnClientLoad="OnClientLoadHandler" >  
                        <WebServiceSettings Method="OboryVzdel_Ciselniky" Path="~/WebServices/AutoCompleteService.asmx" />
                    </kspwc:TRadComboBox>
             </div>
             <div class="rdfRow">
                 <div class="labelContainer">
                   <asp:Label ID="Label2" runat="server" CssClass="rdfLabel rdfBlock" Text="[%Typ školy%]"></asp:Label>                 
                   </div>
                   <kspwc:TRadComboBox ID="ddl_typ_skoly" runat="server" DropDownAutoWidth="Enabled" AllowCustomText="false" EmptyMessage="[%Vyberte typ školy%]" OnClientItemsRequesting="ddl_typ_skoly_OnClientItemsRequesting"
                        EnableLoadOnDemand="True" EnableVirtualScrolling="true" AutoPostBack="false"  OnClientSelectedIndexChanged="ddl_typ_skoly_OnClientSelectedIndexChanged"
                        ShowMoreResultsBox="True" Width="500px"  DropDownWidth="500" OnClientLoad="OnClientLoadHandler"> 
                        <WebServiceSettings Method="OboryVzdel_Ciselniky" Path="~/WebServices/AutoCompleteService.asmx" />
                    </kspwc:TRadComboBox>
             </div>
             <div class="rdfRow" id="div_mesto">
                 <div class="labelContainer">
                   <asp:Label ID="Label3" runat="server" CssClass="rdfLabel rdfBlock" Text="[%Město%] / [%obec%]"></asp:Label>                 
                  </div>
                   <kspwc:TRadComboBox ID="ddl_mesto" runat="server" DropDownAutoWidth="Enabled" AllowCustomText="false" EmptyMessage="[%Vyberte město / obec%]" OnClientItemsRequesting="ddl_mesto_OnClientItemsRequesting"
                        EnableLoadOnDemand="True" EnableVirtualScrolling="true" AutoPostBack="false"  OnClientSelectedIndexChanged="ddl_mesto_OnClientSelectedIndexChanged"
                        ShowMoreResultsBox="True" Width="500px"  DropDownWidth="500" OnClientLoad="OnClientLoadHandler"> 
                        <WebServiceSettings Method="OboryVzdel_Ciselniky" Path="~/WebServices/AutoCompleteService.asmx" />
                    </kspwc:TRadComboBox>
             </div>
            <div class="rdfRow"  id="div_skola">
                <div class="labelContainer">
                   <asp:Label ID="Label4" runat="server" CssClass="rdfLabel rdfBlock" Text="[%Škola%]"></asp:Label>                 
                </div>
                   <kspwc:TRadComboBox ID="ddl_skola" runat="server" DropDownAutoWidth="Enabled" AllowCustomText="false" EmptyMessage="[%Vyberte školu%]" OnClientItemsRequesting="ddl_skola_OnClientItemsRequesting"
                        EnableLoadOnDemand="True" EnableVirtualScrolling="true" AutoPostBack="false"  OnClientSelectedIndexChanged="ddl_skola_OnClientSelectedIndexChanged"
                        ShowMoreResultsBox="True" Width="500px"  DropDownWidth="500" OnClientLoad="OnClientLoadHandler"> 
                        <WebServiceSettings Method="OboryVzdel_Ciselniky" Path="~/WebServices/AutoCompleteService.asmx" />
                    </kspwc:TRadComboBox>
             </div>
             <div class="rdfRow">
                 <div class="labelContainer">
                   <asp:Label ID="Label5" runat="server" CssClass="rdfLabel rdfBlock" Text="[%Obor%]"></asp:Label>                 
                     </div>
                   <kspwc:TRadComboBox ID="ddl_obor" runat="server" DropDownAutoWidth="Enabled" AllowCustomText="false" EmptyMessage="[%Vyberte obor%]" OnClientItemsRequesting="ddl_obor_OnClientItemsRequesting"
                        EnableLoadOnDemand="True" EnableVirtualScrolling="true" AutoPostBack="false" OnClientSelectedIndexChanged="ddl_obor_OnClientSelectedIndexChanged"
                        ShowMoreResultsBox="True" Width="500px"  DropDownWidth="500" OnClientLoad="OnClientLoadHandler"> 
                        <WebServiceSettings Method="OboryVzdel_Ciselniky" Path="~/WebServices/AutoCompleteService.asmx" />
                    </kspwc:TRadComboBox>
             </div>
             <div class="rdfRow">
                 <div class="labelContainer">
                   <asp:Label ID="Label6" runat="server" CssClass="rdfLabel rdfBlock" Text="[%Výsledný kód%]"></asp:Label> 
                   </div>
                   <telerik:RadTextBox Font-Size="Large" CssClass="vyslKod" ReadOnly="true" Text=""  Width="500" runat="server" ID="vysledny_kod" BackColor="LightGray" >
                       
                   </telerik:RadTextBox>
             </div>
             <div class="rdfRow" style="text-align:right; width:500px;">                
                 <kspwc:TRadButton ID="button_close" runat="server" Text="[%OK%]" OnClientClicked="button_close_OnClientClicked" CommandName="Cancel" Icon-PrimaryIconCssClass="fi fi-check"
                                        CausesValidation="False" />                
                 <kspwc:TRadButton ID="button_only_close" runat="server" Text="[%Zpět%]" style="margin-left:10px;" OnClientClicked="button_only_close_OnClientClicked" CommandName="Cancel" Icon-PrimaryIconCssClass="fi fi-ban"
                                        CausesValidation="False" />
             </div>                     
           </div>       
</asp:Content>
