﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    Inherits="Pis_PopisyPM" CodeBehind="PopisyPM.aspx.cs" %>

<%@ Register Src="../Controls/PrMistoControl.ascx" TagName="PrMistoControl" TagPrefix="uc1" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls.SimpleDataSource"
    TagPrefix="cc1" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajx" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <script type="text/javascript">
        function onPopulated(sender, e) {
            var finds = sender.get_completionList().childNodes;
            finds[0].parentElement.style.whiteSpace = 'normal';
            finds[0].parentElement.style.maxHeight = '400px';
            finds[0].parentElement.style.padding = '2px';
            finds[0].parentElement.style.position = 'absolute';
            finds[0].parentElement.style.border = '1px solid #808080';
            finds[0].parentElement.style.overflow = 'auto';
            for (var i = 0; i < finds.length; i++) {
                var find = finds[i];
                find.style.backgroundColor = '#FFFFFF';
                find.style.padding = '2px';
                find.style.whiteSpace = 'normal';
                find.style.cursor = 'pointer';
                if (i != (finds.length - 1))
                    find.style.borderBottom = '1px dotted #808080';
            }
        }

        var stoprequesting = false;
        var requestfromopening = false;
        function dropDownOpening(sender, args) {
            requestfromopening = true;
            stoprequesting = false;
            sender.requestItems('', false);
            stoprequesting = true;
        }
        function dropDownItemsRequesting(sender, args) {
            if (requestfromopening) {
                if (stoprequesting) {
                    stoprequesting = false;
                    requestfromopening = false;
                    sender._filterText = '';
                    args.set_cancel(true);
                }
            }
        }
        function dropDownTextChange(sender, args) {
            requestfromopening = false;
        }
    </script>
    <style type="text/css">
        .radListBoxItem {
            text-align: center;
            padding-top: 5px;
            padding-bottom: 5px;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            user-select: none;
            -webkit-touch-callout: none;
        }
        tr.neplatne td,
        tr.neplatne input {
            color: red !important;
        }

        tr.budouci td,
        tr.budouci input {
            color: grey !important;
        }
    </style>

</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <telerik:RadPersistenceManagerProxy ID="RPMP_pmista" runat="server">
        <PersistenceSettings>
            <telerik:PersistenceSetting ControlID="TRCB_pracmist" />
            <telerik:PersistenceSetting ControlID="TRB_platnost" />
        </PersistenceSettings>
    </telerik:RadPersistenceManagerProxy>
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="RadAjaxPanel1">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadAjaxPanel1" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <kspwc:TLabel ID="TLabel1" runat="server" Text="[%Popisy pracovních míst%]" CssClass="nadpis1"></kspwc:TLabel>
    <asp:Panel ID="RadAjaxPanel1" runat="server">
        <kspwc:TRadButton ID="TRB_typ_poz" runat="server" ToggleType="Radio" GroupName="group_typ"
            Text="[%Pozice%]" AutoPostBack="true" OnClick="TRB_filter_Click">
        </kspwc:TRadButton>
        <kspwc:TRadButton ID="TRB_typ_mist" runat="server" ToggleType="Radio" GroupName="group_typ"
            Text="[%Místa%]" AutoPostBack="true" OnClick="TRB_filter_Click" Checked="True">
        </kspwc:TRadButton>
        <kspwc:TRadButton ID="TRB_platnost" runat="server" ToggleType="CheckBox" ButtonType="StandardButton"
            Checked="true" OnClick="TRB_filter_Click" Text="[%Pouze platné%]">
            <ToggleStates>
                <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-checkbox" />
                <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-square" />
            </ToggleStates>
        </kspwc:TRadButton>
        <asp:ObjectDataSource ID="ODS_PracMista" runat="server" SelectMethod="PracovniMista"
            TypeName="KSProgram.PracovniMista.PracMista" OldValuesParameterFormatString="original_{0}"
            OnSelecting="ODS_PracMista_Selecting">
            <SelectParameters>
                <asp:Parameter Name="id" Type="Int32" />
                <asp:Parameter Name="PlatnaKeDni" Type="DateTime" />
                <asp:Parameter DefaultValue="False" Name="addEmptyRow" Type="Boolean" />
                <asp:Parameter DefaultValue="True" Name="PlikujPrava" Type="Boolean" />
                <asp:Parameter DefaultValue="2,3" Name="typy" Type="String" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <kspwc:TRadComboBox ID="TRCB_pracmist" runat="server" DataTextField="cely_nazev"
            DataValueField="keys" DropDownAutoWidth="Enabled" EmptyMessage="[%Vyber%]"
            Height="300" DataSourceID="ODS_PracMista" Width="100%" OnClientDropDownOpening="dropDownOpening" OnClientItemsRequesting="dropDownItemsRequesting" OnClientKeyPressing="dropDownTextChange"
            EnableAutomaticLoadOnDemand="true" EnableVirtualScrolling="true" ShowMoreResultsBox="true" ItemsPerRequest="20" Filter="Contains"
            AutoPostBack="True" CausesValidation="False" OnSelectedIndexChanged="TRCB_pracmist_SelectedIndexChanged">
            <ItemTemplate>
                <span style="color: <%# Eval("html_color") %>;"><%# Eval("cely_nazev") %></span>
            </ItemTemplate>
        </kspwc:TRadComboBox>
        <table runat="server" id="HT_main" visible="False" style="margin-bottom: 30px;">
            <tr runat="server" id="row_main">
                <td>
                    <table>
                        <tr runat="server" id="row_menu">
                            <td runat="server">
                                <kspwc:TLinkButton ID="TLB_prac_misto" runat="server" OnCommand="TLB_prac_misto_Command" Text="[%Pracovní místo%]"></kspwc:TLinkButton>
                            </td>
                            <td runat="server">
                                <kspwc:TLinkButton ID="TLB_popis_PM" runat="server" OnCommand="TLB_popis_PM_Command" Text="[%Popis pracovního místa%]"></kspwc:TLinkButton>
                            </td>
                            <td runat="server">
                                <kspwc:TLinkButton ID="TLB_souhrn" runat="server" OnCommand="TLB_souhrn_Command" Text="[%Souhrn%]"></kspwc:TLinkButton>
                            </td>
                            <td runat="server">
                                <kspwc:TLinkButton ID="TLB_zamestnanci" runat="server" OnCommand="TLB_zamestnanci_Command" Text="[%Zaměstnanci%]"></kspwc:TLinkButton>
                            </td>
                            <td runat="server">
                                <kspwc:TLinkButton ID="TLB_uchazeci" runat="server" OnCommand="TLB_uchazeci_Command" Text="[%Uchazeči%]"></kspwc:TLinkButton>
                            </td>
                            <td runat="server">
                                <kspwc:TLinkButton ID="TLB_kopirovani" runat="server" OnCommand="TLB_kopirovani_Command" Text="[%Kopírování%]"></kspwc:TLinkButton>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr runat="server" id="row_prac_misto">
                <td>
                    <asp:ObjectDataSource ID="ODS_prac_misto" runat="server" OldValuesParameterFormatString="original_{0}"
                        SelectMethod="PracovniMista" TypeName="KSProgram.PracovniMista.PracMista" UpdateMethod="UpdatePracovniMisto"
                        InsertMethod="InsertPracovniMisto" DeleteMethod="DeletePracovniMisto" ConflictDetection="CompareAllValues"
                        OnSelecting="ODS_prac_misto_Selecting"
                        OnInserted="ODS_prac_misto_Inserted" OnUpdated="ODS_prac_misto_Updated"
                        OnDeleting="ODS_prac_misto_Deleting" OnInserting="ODS_prac_misto_Inserting"
                        OnUpdating="ODS_prac_misto_Updating">
                        <SelectParameters>
                            <asp:Parameter DefaultValue="" Name="id" Type="Int32" />
                            <asp:Parameter DefaultValue="" Name="PlatnaKeDni" Type="DateTime" />
                            <asp:Parameter DefaultValue="False" Name="addEmptyRow" Type="Boolean" />
                            <asp:Parameter DefaultValue="True" Name="PlikujPrava" Type="Boolean" />
                            <asp:Parameter DefaultValue="2,3" Name="typy" Type="String" />
                        </SelectParameters>
                        <DeleteParameters>
                            <asp:Parameter Name="original_polozka" Type="Boolean" />
                            <asp:Parameter Name="original_id" Type="Int32" />
                            <asp:Parameter Name="original_cislo" Type="String" />
                            <asp:Parameter Name="original_nazev" Type="String" />
                            <asp:Parameter Name="original_datumOd" Type="String" />
                            <asp:Parameter Name="original_datumDo" Type="String" />
                            <asp:Parameter Name="original_id_predka" Type="Int32" />
                            <asp:Parameter Name="original_systemovy_typ" Type="Int32" />
                        </DeleteParameters>
                        <UpdateParameters>
                            <asp:Parameter Name="original_polozka" Type="Boolean" />
                            <asp:Parameter Name="original_id" Type="Int32" />
                            <asp:Parameter Name="original_cislo" Type="String" />
                            <asp:Parameter Name="original_nazev" Type="String" />
                            <asp:Parameter Name="original_datumOd" Type="String" />
                            <asp:Parameter Name="original_datumDo" Type="String" />
                            <asp:Parameter Name="original_id_predka" Type="Int32" />
                            <asp:Parameter Name="original_systemovy_typ" Type="Int32" />
                            <asp:Parameter Name="cislo" Type="String" />
                            <asp:Parameter Name="nazev" Type="String" />
                            <asp:Parameter Name="datumOd" Type="String" />
                            <asp:Parameter Name="datumDo" Type="String" />
                            <asp:Parameter Name="id_predka" Type="Int32" />
                            <asp:Parameter Name="Message" Type="String" Direction="Output" />
                        </UpdateParameters>
                        <InsertParameters>
                            <asp:Parameter Name="polozka" Type="Boolean" />
                            <asp:Parameter Name="cislo" Type="String" />
                            <asp:Parameter Name="nazev" Type="String" />
                            <asp:Parameter Name="datumOd" Type="String" />
                            <asp:Parameter Name="datumDo" Type="String" />
                            <asp:Parameter Name="id_predka" Type="Int32" />
                            <asp:Parameter Name="systemovy_typ" Type="Int32" />
                            <asp:Parameter Name="id" Type="Int32" />
                            <asp:Parameter Name="Message" Type="String" Direction="Output" />
                        </InsertParameters>
                    </asp:ObjectDataSource>
                    <asp:ObjectDataSource ID="ODS_cisl_pracmista" runat="server" OldValuesParameterFormatString="original_{0}"
                        SelectMethod="PracovniMista" TypeName="KSProgram.PracovniMista.PracMista"
                        OnSelecting="ODS_cisl_pracmista_Selecting">
                        <SelectParameters>
                            <asp:Parameter Name="id" Type="Int32" />
                            <asp:Parameter Name="PlatnaKeDni" Type="DateTime" />
                            <asp:Parameter DefaultValue="True" Name="addEmptyRow" Type="Boolean" />
                            <asp:Parameter DefaultValue="False" Name="PlikujPrava" Type="Boolean" />
                            <asp:Parameter DefaultValue="0,1,2,3" Name="typy" Type="String" />
                        </SelectParameters>
                    </asp:ObjectDataSource>
                    <kspwc:TFormView ID="FV_prac_misto" runat="server" CellPadding="4" ForeColor="#333333"
                        DataKeyNames="polozka,id,cislo,nazev,datumOd,datumDo,id_predka" OnItemUpdating="FV_prac_misto_ItemUpdating"
                        OnItemDeleting="FV_prac_misto_ItemDeleting" OnItemDeleted="FV_prac_misto_ItemDeleted"
                        OnItemInserted="FV_prac_misto_ItemInserted" OnItemInserting="FV_prac_misto_ItemInserting"
                        OnItemUpdated="FV_prac_misto_ItemUpdated" OnModeChanging="FV_prac_misto_ModeChanging"
                        EmptyDataText="[%Nenalezen žádný záznam%]" IdPravaProhlizeni="156" IdPravaEditace="157"
                        OnDataBinding="FV_prac_misto_DataBinding" OnDataBound="FV_prac_misto_DataBound">
                        <ItemTemplate>
                            <table>
                                <colgroup>
                                    <col style="padding: 3px; border: 1px solid; background-color: var(--kscolor1); color: var(--kscolor1text);" />
                                    <col style="border: 1px solid;" />
                                    <col style="padding: 3px; border: 1px solid; background-color: var(--kscolor1); color: var(--kscolor1text);" />
                                    <col style="border: 1px solid;" />
                                </colgroup>
                                <%--<tr>
                                                <td>
                                                    [%Položka%]
                                                </td>
                                                <td colspan="3">
                                                    <kspwc:TDropDown ID="TDD_item_polozka" runat="server" Enabled="False" SelectedValue='<%# Bind("polozka") %>'>
                                                        <asp:ListItem Value="True" Text="Pracovní Místo"></asp:ListItem>
                                                        <asp:ListItem Value="False" Text="Šablona"></asp:ListItem>
                                                    </kspwc:TDropDown>
                                                </td>
                                            </tr>--%>
                                <tr>
                                    <td style="color: white;">[%Číslo%]
                                    </td>
                                    <td>
                                        <kspwc:TTextBox ID="TTB_item_cislo" runat="server" Text='<%# Bind("cislo") %>' Width="70px"
                                            ReadOnly="True"></kspwc:TTextBox>
                                    </td>
                                    <td style="color: white;">[%Interní ident%].
                                    </td>
                                    <td>
                                        <asp:Label ID="L_item_id" runat="server" Text='<%# Bind("id") %>'></asp:Label>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="color: white;">[%Název%]
                                    </td>
                                    <td colspan="3">
                                        <kspwc:TTextBox ID="TTB_item_nazev" runat="server" Text='<%# Bind("nazev") %>' MaxLength="60"
                                            Width="97%" ReadOnly="True"></kspwc:TTextBox>
                                    </td>
                                </tr>
                                <tr runat="Server" id="TR_item_date" visible='<%# Bind("polozka")%>'>
                                    <td style="color: white;">[%Vzniklo dne%]
                                    </td>
                                    <td>
                                        <kspwc:TTextBox ID="TTB_item_datum_od" runat="server" Text='<%# Bind("datumOd") %>'
                                            Width="70px" ReadOnly="True"></kspwc:TTextBox>
                                    </td>
                                    <td style="color: white;">[%Zaniklo dne%]
                                    </td>
                                    <td>
                                        <kspwc:TTextBox ID="TTB_item_datum_do" runat="server" Text='<%# Bind("datumDo") %>'
                                            Width="70px" ReadOnly="True"></kspwc:TTextBox>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="color: white;">[%Přebírá vlastnosti z předka%]
                                    </td>
                                    <td colspan="3">
                                        <kspwc:TImageButton ID="TIB_select_predek" runat="server" ImageUrl="~/Images/select_tel.png"
                                            OnClick="TIB_select_predek_Click" />
                                        <kspwc:TDropDown ID="TDD_edit_nazev_predka" runat="server" DataSourceID="ODS_cisl_pracmista"
                                            DataTextField="cely_nazev" DataValueField="id" SelectedValue='<%# Bind("id_predka") %>'
                                            Style="width: auto" Enabled="False">
                                        </kspwc:TDropDown>
                                        <%--<kspwc:TTextBox ID="TTB_item_nazev_predka" runat="server" Text='<%# Eval("nazev_predka") %>'
                                                    Width="97%" ReadOnly="True">
                                                </kspwc:TTextBox>--%>
                                    </td>
                                </tr>
                            </table>
                            <kspwc:TButton ID="btnEdit" runat="Server" CommandName="Edit" Text="[%Opravit%]"></kspwc:TButton>
                            <kspwc:TButton ID="btnInsert" runat="Server" CommandName="New" Text="[%Vložit nový%]"></kspwc:TButton>
                            <kspwc:TButton ID="btnDelete" runat="Server" CommandName="Delete" Text="[%Smazat%]"
                                OnLoad="btnDelete_Load">
                            </kspwc:TButton>
                            <br />
                            <asp:CustomValidator ID="CV_PM_deleteValidator" runat="server" ErrorMessage=""></asp:CustomValidator>
                            <br />
                            <cc1:SimpleDataSource ID="SDS_potomci" runat="server" SelectCommand="SELECT id_pracmist, cis_pracmist, naz_pracmist FROM prac_mist WHERE id_predka = @id_predka AND id_predka IS NOT NULL">
                                <SelectParameters>
                                    <asp:SessionParameter SessionField="mng_ppm_id_pm" Name="id_predka" Type="Int32" />
                                </SelectParameters>
                            </cc1:SimpleDataSource>
                            <%--<kspwc:TGridView ID="TGV_potomci" runat="server" DataSourceID="SDS_potomci" ShowTitleRow="True"
                                            TitleText="[%Potomci vlastností pracovního místa%]" OnSelectedIndexChanged="TGV_potomci_SelectedIndexChanged"
                                            DataKeyNames="id_pracmist">
                                            <Columns>
                                                <asp:CommandField ButtonType="Image" SelectImageUrl="~/Images/select_tel.png" SelectText="[%Vybrat%]"
                                                    ShowSelectButton="True"  />
                                                <asp:BoundField DataField="cis_pracmist" HeaderText="[%Číslo%]" />
                                                <asp:BoundField DataField="naz_pracmist" HeaderText="[%Název pracovního místa%]" />
                                            </Columns>
                                        </kspwc:TGridView>--%>

                            <kspwc:TRadGrid ID="TGridView1" runat="server" DataSourceID="SDS_potomci" ShowTitleRow="True" AutoGenerateColumns="false"
                                OnSelectedIndexChanged="TGV_potomci_SelectedIndexChanged">
                                <%--OnItemCommand="TGridView1_ItemCommand"--%>
                                <MasterTableView Caption="[%Potomci vlastností pracovního místa%]" DataKeyNames="id_pracmist">
                                    <Columns>
                                        <telerik:GridButtonColumn ButtonType="ImageButton" ImageUrl="~/Images/select_tel.png" Text="[%Vybrat%]" CommandName="Select">
                                            <HeaderStyle Width="30px" />

                                        </telerik:GridButtonColumn>
                                        <telerik:GridBoundColumn DataField="cis_pracmist" HeaderText="[%Číslo%]" />
                                        <telerik:GridBoundColumn DataField="naz_pracmist" HeaderText="[%Název pracovního místa%]" />
                                    </Columns>
                                </MasterTableView>

                            </kspwc:TRadGrid>

                            <br />
                            <cc1:SimpleDataSource ID="SDS_obsazenost" runat="server">
                                <SelectParameters>
                                    <asp:SessionParameter SessionField="mng_ppm_id_pm" Name="id_pracmist" Type="Int32" />
                                </SelectParameters>
                            </cc1:SimpleDataSource>
                            <%--<kspwc:TGridView ID="TGV_obsazenost" runat="server" DataSourceID="SDS_obsazenost" DataKeyNames="os_cislo"
                                            OnLoad="TGV_obsazenost_Load" PovolExport="True" TitleText="[%Zaměstnanci zařazení na pracovním místě%]"
                                            ShowTitleRow="True" AllowSorting="True">
                                            <Columns>
                                                <asp:BoundField DataField="os_cislo" HeaderText="[%Os. č.%]" />
                                                <asp:BoundField DataField="prijmeni" HeaderText="[%Příjmení%]" />
                                                <asp:BoundField DataField="jmeno" HeaderText="[%Jméno%]" />
                                                <asp:BoundField DataField="datum_nastupu" HeaderText="[%Datum nástupu%]" />
                                            </Columns>
                                        </kspwc:TGridView>--%>
                            <kspwc:TRadGrid ID="TGV_obsazenost" runat="server" DataSourceID="SDS_obsazenost" OnLoad="TGV_obsazenost_Load" AutoGenerateColumns="false"
                                ShowTitleRow="True" AllowSorting="True">
                                <MasterTableView Caption="[%Zaměstnanci zařazení na pracovním místě%]" DataKeyNames="os_cislo">
                                    <Columns>
                                        <telerik:GridBoundColumn DataField="os_cislo" HeaderText="[%Os. č.%]">
                                            <HeaderStyle Width="60px" />
                                        </telerik:GridBoundColumn>
                                        <telerik:GridBoundColumn DataField="prijmeni" HeaderText="[%Příjmení%]" />
                                        <telerik:GridBoundColumn DataField="jmeno" HeaderText="[%Jméno%]" />
                                        <telerik:GridBoundColumn DataField="datum_nastupu" HeaderText="[%Datum nástupu%]" />
                                    </Columns>
                                </MasterTableView>
                            </kspwc:TRadGrid>
                            <br />
                            <cc1:SimpleDataSource ID="SDS_minulost" runat="server" SelectCommand="SELECT p.os_cislo, z.jmeno, z.prijmeni, MIN(p.platnost_od) AS platnost_od, MAX(p.platnost_do) AS platnost_do FROM prac_postup p LEFT OUTER JOIN pracovnici z ON z.os_cislo = p.os_cislo WHERE p.id_pracmist = @id_pracmist AND p.os_cislo NOT IN ( SELECT h.os_cislo FROM prac_postup h WHERE h.id_pracmist = p.id_pracmist AND h.platnost_do IS NULL AND h.os_cislo NOT IN ( SELECT u.os_cislo FROM pracovnici u WHERE u.datum_vystupu IS NOT NULL ) ) GROUP BY p.os_cislo, z.jmeno, z.prijmeni">
                                <SelectParameters>
                                    <asp:SessionParameter SessionField="mng_ppm_id_pm" Name="id_pracmist" Type="Int32" />
                                </SelectParameters>
                            </cc1:SimpleDataSource>
                            <%--<kspwc:TGridView ID="TGV_minulost" runat="server" DataSourceID="SDS_minulost" DataKeyNames="os_cislo"
                                            PovolExport="True" TitleText="[%Zaměstnanci kteří dříve pracovali na prac. místě%]"
                                            ShowTitleRow="True" AllowSorting="True">
                                            <Columns>
                                                <asp:BoundField DataField="os_cislo" HeaderText="[%Os. č.%]" />
                                                <asp:BoundField DataField="prijmeni" HeaderText="[%Příjmení%]" />
                                                <asp:BoundField DataField="jmeno" HeaderText="[%Jméno%]" />
                                                <asp:BoundField DataField="platnost_od" HeaderText="[%Datum od%]" />
                                                <asp:BoundField DataField="platnost_do" HeaderText="[%Datum do%]" />
                                            </Columns>
                                        </kspwc:TGridView>--%>

                            <kspwc:TRadGrid ID="TGV_minulost" runat="server" DataSourceID="SDS_minulost" PovolExport="True" ShowTitleRow="True" AllowSorting="True" AutoGenerateColumns="false">
                                <MasterTableView Caption="[%Zaměstnanci kteří dříve pracovali na prac. místě%]" DataKeyNames="os_cislo">
                                    <Columns>
                                        <telerik:GridBoundColumn DataField="os_cislo" HeaderText="[%Os. č.%]">
                                            <HeaderStyle Width="60px" />
                                        </telerik:GridBoundColumn>
                                        <telerik:GridBoundColumn DataField="prijmeni" HeaderText="[%Příjmení%]" />
                                        <telerik:GridBoundColumn DataField="jmeno" HeaderText="[%Jméno%]" />
                                        <telerik:GridBoundColumn DataField="platnost_od" HeaderText="[%Datum od%]" />
                                        <telerik:GridBoundColumn DataField="platnost_do" HeaderText="[%Datum do%]" />
                                    </Columns>
                                </MasterTableView>
                            </kspwc:TRadGrid>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <table>
                                <colgroup>
                                    <col style="padding: 3px; border: 1px solid; background-color: var(--kscolor1); color: var(--kscolor1text);" />
                                    <col style="border: 1px solid;" />
                                    <col style="padding: 3px; border: 1px solid; background-color: var(--kscolor1); color: var(--kscolor1text);" />
                                    <col style="border: 1px solid;" />
                                </colgroup>
                                <tr>
                                    <td style="color: white;">[%Číslo%]
                                    </td>
                                    <td>
                                        <kspwc:TTextBox ID="TTB_edit_cislo" runat="server" Text='<%# Bind("cislo") %>' Width="70px"
                                            MaxLength="12"></kspwc:TTextBox>
                                    </td>
                                    <td style="color: white;">[%Interní ident%].
                                    </td>
                                    <td>
                                        <asp:Label ID="L_edit_id" runat="server" Text='<%# Eval("id") %>'></asp:Label>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="color: white;">[%Název%]
                                    </td>
                                    <td colspan="3">
                                        <kspwc:TTextBox ID="TTB_edit_nazev" runat="server" Text='<%# Bind("nazev") %>' MaxLength="60"
                                            Width="97%"></kspwc:TTextBox>
                                    </td>
                                </tr>
                                <tr>
                                    <%--runat="Server" ID="TR_edit_date" visible='<%# Eval("polozka")%>'--%>
                                    <td style="color: white;">[%Vzniklo dne%]
                                    </td>
                                    <td>
                                        <kspwc:TTextBox ID="TTB_edit_datum_od" runat="server" Text='<%# Bind("datumOd") %>'
                                            Width="70px"></kspwc:TTextBox>
                                        <asp:ImageButton ID="IB_edit_datum_od" runat="server" ImageUrl="~/Images/calendar.png"
                                            ToolTip="[%Kalendář%]" />
                                        <asp:CompareValidator ID="CVal_edit_datum_od" runat="server" ControlToValidate="TTB_edit_datum_od"
                                            Display="Dynamic" ErrorMessage="?" Operator="DataTypeCheck" Type="Date">
                                        </asp:CompareValidator>
                                        <ajx:CalendarExtender ID="CE_edit_datum_od" runat="server" Format="dd.MM.yyyy" PopupButtonID="IB_edit_datum_od"
                                            TargetControlID="TTB_edit_datum_od">
                                        </ajx:CalendarExtender>
                                    </td>
                                    <td style="color: white;">[%Zaniklo dne%]
                                    </td>
                                    <td>
                                        <kspwc:TTextBox ID="TTB_edit_datum_do" runat="server" Text='<%# Bind("datumDo") %>'
                                            Width="70px"></kspwc:TTextBox>
                                        <asp:ImageButton ID="IB_edit_datum_do" runat="server" ImageUrl="~/Images/calendar.png"
                                            ToolTip="[%Kalendář%]" />
                                        <asp:CompareValidator ID="CVal_edit_datum_do" runat="server" ControlToValidate="TTB_edit_datum_do"
                                            Display="Dynamic" ErrorMessage="?" Operator="DataTypeCheck" Type="Date">
                                        </asp:CompareValidator>
                                        <ajx:CalendarExtender ID="CE_edit_datum_do" runat="server" Format="dd.MM.yyyy" PopupButtonID="IB_edit_datum_do"
                                            TargetControlID="TTB_edit_datum_do">
                                        </ajx:CalendarExtender>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="color: white;">[%Přebírá vlastnosti z předka%]
                                    </td>
                                    <td colspan="3">
                                        <kspwc:TDropDown ID="TDD_edit_nazev_predka" runat="server" DataSourceID="ODS_cisl_pracmista"
                                            DataTextField="cely_nazev" DataValueField="id" SelectedValue='<%# Bind("id_predka") %>'
                                            Style="width: auto">
                                        </kspwc:TDropDown>
                                    </td>
                                </tr>
                            </table>
                            <kspwc:TButton ID="btnUpdate" runat="Server" CommandName="Update" Text="[%Uložit%]" Icon-PrimaryHoveredIconUrl="fi fi-disk"></kspwc:TButton>
                            <kspwc:TButton ID="Button1" runat="Server" CommandName="Cancel" Text="[%Zrušit změny%]" Icon-PrimaryHoveredIconUrl="fi fi-cancel"
                                CausesValidation="False">
                            </kspwc:TButton>
                            <br />
                            <asp:CustomValidator ID="CV_PM_editValidator" runat="server" ErrorMessage=""></asp:CustomValidator>
                        </EditItemTemplate>
                        <InsertItemTemplate>
                            <table>
                                <colgroup>
                                    <col style="padding: 3px; border: 1px solid; background-color: var(--kscolor1); color: var(--kscolor1text);" />
                                    <col style="border: 1px solid;" />
                                    <col style="padding: 3px; border: 1px solid; background-color: var(--kscolor1); color: var(--kscolor1text);" />
                                    <col style="border: 1px solid;" />
                                </colgroup>
                                <%--<tr>
                                                <td>
                                                    [%Položka%]
                                                </td>
                                                <td colspan="3">
                                                    <kspwc:TDropDown ID="TDD_insert_polozka" runat="server" SelectedValue='<%# Bind("polozka") %>'
                                                        OnSelectedIndexChanged="TDD_insert_polozka_SelectedIndexChanged" AutoPostBack="True">
                                                        <asp:ListItem Value="True" Text="Pracovní Místo"></asp:ListItem>
                                                        <asp:ListItem Value="False" Text="Šablona"></asp:ListItem>
                                                    </kspwc:TDropDown>
                                                </td>
                                            </tr>--%>
                                <tr>
                                    <td style="color: white;">[%Číslo%]
                                    </td>
                                    <td>
                                        <kspwc:TTextBox ID="TTB_insert_cislo" runat="server" Text='<%# Bind("cislo") %>' Width="70px"
                                            MaxLength="12" OnLoad="TTB_insert_cislo_Load"></kspwc:TTextBox>
                                    </td>
                                    <td style="color: white;">[%Interní ident%].
                                    </td>
                                    <td>
                                        <asp:Label ID="L_insert_id" runat="server" Text='<%# Bind("id") %>'></asp:Label>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="color: white;">[%Název%]
                                    </td>
                                    <td colspan="3">
                                        <kspwc:TTextBox ID="TTB_insert_nazev" runat="server" Text='<%# Bind("nazev") %>' MaxLength="60"
                                            Width="97%"></kspwc:TTextBox>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="color: white;">[%Vzniklo dne%]
                                    </td>
                                    <td>
                                        <kspwc:TTextBox ID="TTB_insert_datum_od" runat="server" Text='<%# Bind("datumOd") %>'
                                            Width="70px"></kspwc:TTextBox>
                                        <asp:ImageButton ID="IB_insert_datum_od" runat="server" ImageUrl="~/Images/calendar.png"
                                            ToolTip="[%Kalendář%]" />
                                        <asp:CompareValidator ID="CVal_insert_datum_od" runat="server" ControlToValidate="TTB_insert_datum_od"
                                            Display="Dynamic" ErrorMessage="?" Operator="DataTypeCheck" Type="Date">
                                        </asp:CompareValidator>
                                        <ajx:CalendarExtender ID="CE_insert_datum_od" runat="server" Format="dd.MM.yyyy" PopupButtonID="IB_insert_datum_od"
                                            TargetControlID="TTB_insert_datum_od">
                                        </ajx:CalendarExtender>
                                    </td>
                                    <td style="color: white;">[%Zaniklo dne%]
                                    </td>
                                    <td>
                                        <kspwc:TTextBox ID="TTB_insert_datum_do" runat="server" Text='<%# Bind("datumDo") %>'
                                            Width="70px"></kspwc:TTextBox>
                                        <asp:ImageButton ID="IB_insert_datum_do" runat="server" ImageUrl="~/Images/calendar.png"
                                            ToolTip="[%Kalendář%]" />
                                        <asp:CompareValidator ID="CVal_insert_datum_do" runat="server" ControlToValidate="TTB_insert_datum_do"
                                            Display="Dynamic" ErrorMessage="?" Operator="DataTypeCheck" Type="Date">
                                        </asp:CompareValidator>
                                        <ajx:CalendarExtender ID="CE_insert_datum_do" runat="server" Format="dd.MM.yyyy" PopupButtonID="IB_insert_datum_do"
                                            TargetControlID="TTB_insert_datum_do">
                                        </ajx:CalendarExtender>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="color: white;">[%Přebírá vlastnosti z předka%]
                                    </td>
                                    <td colspan="3">
                                        <kspwc:TDropDown ID="TDD_insert_nazev_predka" runat="server" DataSourceID="ODS_cisl_pracmista"
                                            DataTextField="cely_nazev" DataValueField="id" SelectedValue='<%# Bind("id_predka") %>'
                                            Style="width: auto">
                                        </kspwc:TDropDown>
                                    </td>
                                </tr>
                            </table>
                            <kspwc:TButton ID="btnSave" runat="Server" CommandName="insert" Text="[%Uložit%]" Icon-PrimaryHoveredIconUrl="fi fi-disk"></kspwc:TButton>
                            <kspwc:TButton ID="Button1" runat="Server" CommandName="Cancel" Text="[%Zrušit změny%]" Icon-PrimaryHoveredIconUrl="fi fi-cancel"
                                CausesValidation="False">
                            </kspwc:TButton>
                            <br />
                            <asp:CustomValidator ID="CV_PM_insertValidator" runat="server" ErrorMessage=""></asp:CustomValidator>
                        </InsertItemTemplate>
                        <FooterStyle BackColor="#5D7B9D" Font-Bold="True" ForeColor="White" />
                        <RowStyle BackColor="#F7F6F3" ForeColor="#333333" />
                        <PagerStyle BackColor="#284775" ForeColor="White" HorizontalAlign="Center" />
                        <HeaderStyle BackColor="#5D7B9D" Font-Bold="True" ForeColor="White" />
                        <EditRowStyle BackColor="#999999" />
                    </kspwc:TFormView>
                </td>
            </tr>
            <tr runat="server" id="row_popis_PM">
                <td>
                    <table>
                        <tr runat="server" id="TR_popis_list" visible="True">
                            <td width="75px" valign="top">
                                <cc1:SimpleDataSource ID="SDS_satrib_skup" runat="server" SelectCommand="select * from atrib_skup where poradi <> 0 or poradi is null order by poradi">
                                </cc1:SimpleDataSource>
                                <%--<kspwc:TDataList ID="TDL_outlook" runat="server" DataKeyField="cis_skup_atr" DataSourceID="SDS_satrib_skup"
                                                OnItemCommand="TDL_outlook_ItemCommand" OnItemDataBound="TDL_outlook_ItemDataBound"
                                                OnSelectedIndexChanged="TDL_outlook_SelectedIndexChanged" Width="120px" OnDataBinding="TDL_outlook_DataBinding">
                                                <SelectedItemStyle BackColor="Gray" />
                                                <ItemTemplate>
                                                    <div align="center">
                                                        <asp:ImageButton runat="server" ID="IB_outlook_item" CommandName="select" /><br />
                                                        <kspwc:TLinkButton runat="server" ID="TLB_outlook_item" Text='<%# Eval("naz_skup_atr") %>'
                                                            CommandName="select" Font-Size="Larger" Font-Bold="True"></kspwc:TLinkButton>
                                                    </div>
                                                </ItemTemplate>
                                                <ItemStyle />
                                            </kspwc:TDataList>--%>
                                <kspwc:TRadListBox ID="RLB_outlook" runat="server" DataKeyField="cis_skup_atr" DataSourceID="SDS_satrib_skup" OnSelectedIndexChanged="RLB_outlook_SelectedIndexChanged" AutoPostBack="true" OnItemDataBound="RLB_outlook_ItemDataBound" SelectedFirst="true">
                                    <ItemTemplate>
                                        <div class="radListBoxItem">
                                            <span style="display: block;">
                                                <asp:Image ID="img" runat="server" ImageUrl='<%# GetImgSkupAtr( Eval("cis_skup_atr") ) %>' />
                                            </span>
                                            <%--<span><%# Eval("naz_skup_atr") %></span>--%>
                                            <asp:Label ID="nadpis" runat="server" Text='<%# Eval("naz_skup_atr") %>'></asp:Label>
                                        </div>
                                    </ItemTemplate>
                                </kspwc:TRadListBox>
                            </td>
                            <td valign="top">
                                <asp:ObjectDataSource ID="ODS_VlastnostiPM" runat="server" OldValuesParameterFormatString="original_{0}"
                                    SelectMethod="AtributySetrizenePlatneABudouci" TypeName="KSProgram.Personal.PopisPM" UpdateMethod="UpdateAtribut" OnSelecting="ODS_VlastnostiPM_Selecting"
                                    OnUpdated="ODS_VlastnostiPM_Updated" DeleteMethod="DeleteAtribut" OnUpdating="ODS_VlastnostiPM_Updating">
                                    <SelectParameters>
                                        <asp:SessionParameter SessionField="mng_ppm_id_pm" Name="idPM" Type="Int32" />
                                        <asp:ControlParameter ControlID="RLB_outlook" Name="skupAtrib" PropertyName="SelectedItem.DataKey"
                                            Type="Int16" />
                                        <asp:Parameter Name="casovostAtr" Type="Boolean" DefaultValue="false" />
                                    </SelectParameters>
                                    <UpdateParameters>
                                        <asp:SessionParameter SessionField="mng_ppm_id_pm" Name="idPM" Type="Int32" />
                                        <asp:Parameter Name="original_cislo" Type="Int32" />
                                        <asp:Parameter Name="original_id_original" Type="Int32" />
                                        <asp:Parameter Name="hodnota" Type="String" />
                                        <asp:Parameter Name="hodnota_text" Type="String" />
                                        <asp:Parameter Name="platnost_od" Type="DateTime" />
                                        <asp:Parameter Name="platnost_do" Type="DateTime" />
                                        <asp:Parameter Name="original_dat_typ_atr" Type="Int16" />
                                        <asp:Parameter Name="ErrorMessage" Type="String" Direction="Output" />
                                    </UpdateParameters>
                                </asp:ObjectDataSource>
                                <kspwc:TGridViewBulk ID="TGV_VlastnostiPM" runat="server" AllowSorting="False" ShowTitleRow="True"
                                    OnDataBinding="TGV_VlastnostiPM_DataBinding" DataFields=",nazev,hodnota_text,platnost_od,platnost_do,dedeni,pripojit_b"
                                    OnRowDataBound="TGV_VlastnostiPM_RowDataBound" DataKeyNames="id,id_original,cislo,dat_typ_atr,platnost_do"
                                    ShowFooter="True" TeplateControls="HA_hodnota,DC_od,DC_do,TTB_zdedit,TCH_pripojit" OnRowUpdating="TGV_VlastnostiPM_RowUpdating"
                                    OnlyVisibledControls="false">
                                    <Columns>
                                        <asp:TemplateField>
                                            <ItemTemplate>
                                                <table style="padding: 0px; margin: 0px; border-width: 0px; border-collapse: collapse">
                                                    <tr>
                                                        <td>
                                                            <kspwc:TImageButton ID="TIB_delete_list_atr" runat="server" ImageUrl="~/Images/DeleteHS.png"
                                                                OnClick="TIB_delete_list_atr_Click" OnLoad="TIB_delete_list_atr_Load" />
                                                        </td>
                                                    </tr>
                                                </table>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="[%Vlastnost%]">
                                            <ItemTemplate>
                                                <table style="padding: 0px; margin: 0px; border-width: 0px; border-collapse: collapse">
                                                    <tr>
                                                        <td>
                                                            <asp:Image ID="I_odrazka1" runat="server" ImageUrl="~/Images/TransparentDot.png"
                                                                Width="20px" Height="1px" />
                                                        </td>
                                                        <td>
                                                            <asp:Label ID="L_nazev_list_atr" runat="server" Text='<%# Eval("nazev") %>'></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="[%Hodnota%]">
                                            <ItemTemplate>
                                                <table style="padding: 0px; margin: 0px; border-width: 0px; border-collapse: collapse">
                                                    <tr>
                                                        <td>
                                                            <asp:Image ID="I_odrazka2" runat="server" ImageUrl="~/Images/TransparentDot.png"
                                                                Width="20px" Height="1px" />
                                                        </td>
                                                        <td>
                                                            <kspwc:HodnAtribPM runat="server" Hodnota='<%# Bind("hodnota") %>' DDDW='<%# Eval("ciselnik") %>'
                                                                Dat_typ_atr='<%# Eval("dat_typ_atr") %>' Hodnota_text='<%# Bind("hodnota_text") %>'
                                                                Filtr='<%# Eval("filtr") %>' Filtr_portal='<%# Eval("filtr_portal") %>' ID="HA_hodnota" OnChanged="HA_hodnota_Changed"></kspwc:HodnAtribPM>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="[%Platí od%]">
                                            <ItemTemplate>
                                                <%--<kspwc:DateControl ID="DC_od" runat="server" Datum='<%# Bind("platnost_od") %>' OnTextChanged="DC_TextChanged" />--%>
                                                <kspwc:TRadDatePicker ID="DC_od" runat="server" DbSelectedDate='<%# Bind("platnost_od") %>'
                                                    Width="110px" OnSelectedDateChanged="DC_SelectedDateChanged">
                                                </kspwc:TRadDatePicker>
                                                <asp:RequiredFieldValidator runat="server" ID="RFV_od" ControlToValidate="DC_od" Enabled="False" Display="Dynamic"></asp:RequiredFieldValidator>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="[%Platí do%]">
                                            <ItemTemplate>
                                                <%--<kspwc:DateControl ID="DC_do" runat="server" Datum='<%# Bind("platnost_do") %>' OnTextChanged="DC_TextChanged" />--%>
                                                <kspwc:TRadDatePicker ID="DC_do" runat="server" DbSelectedDate='<%# Bind("platnost_do") %>'
                                                    Width="110px" OnSelectedDateChanged="DC_SelectedDateChanged">
                                                </kspwc:TRadDatePicker>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="[%Hodnota z předka%]">
                                            <ItemTemplate>
                                                <kspwc:TTextBox ID="TTB_zdedit" runat="server" Visible="false" Text='<%# Bind("dedeni") %>'></kspwc:TTextBox>
                                                <kspwc:TCheckBox ID="TCH_zdedit" runat="server" AutoPostBack="True" OnCheckedChanged="TCH_zdedit_CheckedChanged"
                                                    CausesValidation="True" />
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="[%Připojit k hodnětě předka%]">
                                            <ItemTemplate>
                                                <kspwc:TCheckBox ID="TCH_pripojit" runat="server" AutoPostBack="True" Checked='<%# Bind("pripojit_b") %>'
                                                    OnCheckedChanged="TCH_pripojit_CheckedChanged" CausesValidation="True" />
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                    </Columns>
                                </kspwc:TGridViewBulk>
                                <br />
                                <br />
                                <table style="padding: 0px; margin: 0px; border-width: 0px; border-collapse: collapse">
                                    <tr>
                                        <td>
                                            <%-- <cc1:SimpleDataSource SelectCommand="SELECT cis_atributu, naz_atributu FROM atributy WHERE cis_skup_atr = @cis_skup_atr AND propojeno_s IS NULL"
                                                            ID="SDS_insert_artibuty" runat="server">
                                                            <SelectParameters>
                                                                <asp:ControlParameter ControlID="TDL_outlook" Name="cis_skup_atr" PropertyName="SelectedValue"
                                                                    Type="Int16" />
                                                            </SelectParameters>
                                                        </cc1:SimpleDataSource>
                                            --%>
                                            <%-- KM 29.11.2016 Náhrada za SimpleDataSource, ktery neumi ControlParametr s vice stupni--%>
                                            <asp:ObjectDataSource ID="SDS_insert_artibuty" runat="server" SelectMethod="TDD_insert_artibuty" TypeName="KSProgram.Personal.PopisPM">
                                                <SelectParameters>
                                                    <asp:ControlParameter ControlID="RLB_outlook" Name="cis_skup_atr" PropertyName="SelectedItem.DataKey" Type="Int16" />
                                                    <asp:SessionParameter SessionField="mng_ppm_id_pm" Name="id_pracmist" Type="Int32" />
                                                </SelectParameters>
                                            </asp:ObjectDataSource>
                                            <kspwc:TDropDown ID="TDD_insert_artibuty" runat="server" DataTextField="naz_atributu"
                                                DataValueField="cis_atributu" AutoPostBack="False">
                                            </kspwc:TDropDown>
                                        </td>
                                        <td>
                                            <%--<kspwc:TButton ID="TB_Atr_insert" runat="server" Text="[%Vložit nový%] [%atribut%]" OnClick="TB_Atr_insert_Click" />--%>
                                            <kspwc:TRadButton ID="TB_Atr_insert" runat="server" Text="[%Vložit nový atribut%]" OnClick="TB_Atr_insert_Click" OnPreRender="TB_Atr_insert_PreRender" CausesValidation="false" />
                                        </td>
                                    </tr>
                                </table>
                                <br />
                                <br />
                                <%--<kspwc:TButton ID="TB_Atr_update" runat="server" Text="[%Uložit%]" OnClick="TB_Atr_update_Click" />--%>
                                <kspwc:TRadButton ID="TB_Atr_update" runat="server" Text="[%Uložit%]" OnClick="TB_Atr_update_Click" Icon-PrimaryHoveredIconUrl="fi fi-disk" />
                                &nbsp;
                                            <%--<kspwc:TButton ID="TB_Atr_cancel" runat="server" Text="[%Zrušit změny%]" CausesValidation="False" OnClick="TB_Atr_cancel_Click" />--%>
                                <kspwc:TRadButton ID="TB_Atr_cancel" runat="server" Text="[%Zrušit změny%]" CausesValidation="False" OnClick="TB_Atr_cancel_Click" Icon-PrimaryHoveredIconUrl="fi fi-cancel" />
                                <%--<asp:ObjectDataSource ID="ODS_VlastnostiPM1" runat="server" OldValuesParameterFormatString="original_{0}"
                                            SelectMethod="Atributy" TypeName="KSProgram.Personal.PopisPM">
                                            <SelectParameters>
                                                <asp:SessionParameter SessionField="mng_ppm_id_pm" Name="idPM" Type="Int32" />
                                                <asp:ControlParameter ControlID="TDL_outlook" Name="skupAtrib" PropertyName="SelectedValue"
                                                    Type="Int16" />
                                                <asp:Parameter Name="casovostAtr" Type="Boolean" DefaultValue="false" />
                                            </SelectParameters>
                                        </asp:ObjectDataSource>
                                        <kspwc:TGridViewBulk ID="TGV_VlastnostiPM1" runat="server" DataFields="id,dedeni,pripojit,pripojit_b,id_original,id_nadrizeneho,cislo,hodnota,hodnota_text,platnost_od,platnost_do,nazev,skupina,opakovani,cislenik,propojeno_s,dat_typ_atr">
                                            <Columns>
                                                <asp:BoundField DataField="id" HeaderText="id" />
                                                <asp:BoundField DataField="dedeni" HeaderText="dedeni" />
                                                <asp:BoundField DataField="pripojit" HeaderText="pripojit" />
                                                <asp:BoundField DataField="pripojit_b" HeaderText="pripojit_b" />
                                                <asp:BoundField DataField="id_original" HeaderText="id_original" />
                                                <asp:BoundField DataField="id_nadrizeneho" HeaderText="id_nadrizeneho" />
                                                <asp:BoundField DataField="cislo" HeaderText="cislo" />
                                                <asp:BoundField DataField="hodnota" HeaderText="hodnota" />
                                                <asp:BoundField DataField="hodnota_text" HeaderText="hodnota_text" />
                                                <asp:BoundField DataField="platnost_od" HeaderText="platnost_od" />
                                                <asp:BoundField DataField="platnost_do" HeaderText="platnost_do" />
                                                <asp:BoundField DataField="nazev" HeaderText="nazev" />
                                                <asp:BoundField DataField="skupina" HeaderText="skupina" />
                                                <asp:BoundField DataField="opakovani" HeaderText="opakovani" />
                                                <asp:BoundField DataField="ciselnik" HeaderText="ciselnik" />
                                                <asp:BoundField DataField="propojeno_s" HeaderText="propojeno_s" />
                                                <asp:BoundField DataField="dat_typ_atr" HeaderText="dat_typ_atr" />
                                            </Columns>
                                        </kspwc:TGridViewBulk>--%>
                            </td>
                        </tr>
                        <%--<tr runat="server" id="TR_popis_edit">
                                    <td colspan="2">
                                        <asp:ObjectDataSource ID="ODS_atribut" runat="server" OldValuesParameterFormatString="original_{0}"
                                            SelectMethod="Atribut" TypeName="KSProgram.Personal.PopisPM">
                                            <SelectParameters>
                                                <asp:SessionParameter SessionField="mng_ppm_id_pm" Name="idPm" Type="Int32" />
                                                <asp:ControlParameter ControlID="TDL_outlook" Name="skupinaAtr" PropertyName="SelectedValue"
                                                    Type="Int16" />
                                                <asp:ControlParameter ControlID="TGV_VlastnostiPM" Name="idAtr" PropertyName="SelectedValue"
                                                    Type="Int32" />
                                            </SelectParameters>
                                        </asp:ObjectDataSource>
                                        <asp:FormView ID="FV_atribut" runat="server" CellPadding="4" ForeColor="#333333">
                                            <ItemTemplate>
                                            </ItemTemplate>
                                            <EditItemTemplate>
                                            </EditItemTemplate>
                                            <InsertItemTemplate>
                                            </InsertItemTemplate>
                                        </asp:FormView>
                                    </td>
                                </tr>--%>
                    </table>
                </td>
            </tr>
            <tr runat="server" id="row_souhrn">
                <td>
                    <uc1:PrMistoControl ID="PrMistoControl1" runat="server" Visible="false" />
                </td>
            </tr>
            <tr runat="server" id="row_zamestnanci">
                <td>d
                </td>
            </tr>
            <tr runat="server" id="row_uchazeci">
                <td>e
                </td>
            </tr>
            <tr runat="server" id="row_kopirovani">
                <td>f
                </td>
            </tr>
        </table>
    </asp:Panel>
</asp:Content>
