﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="IndivPlanSouhrn.aspx.cs" Inherits="KSPortal.Sestavy.IndivPlanSouhrn" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Src="../Controls/ExportGridButtonC.ascx" TagName="ExportGridButtonC"
    TagPrefix="uc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRCB_plany">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRG_souhrn" UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRG_souhrn">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRG_souhrn" UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <telerik:RadPersistenceManagerProxy ID="RadPersistenceManagerProxy1" runat="server">
        <PersistenceSettings>
            <telerik:PersistenceSetting ControlID="TRCB_plany" />
            <telerik:PersistenceSetting ControlID="TRG_souhrn" />
        </PersistenceSettings>
    </telerik:RadPersistenceManagerProxy>

    

    <%--<asp:Label ID="label1" runat="server" Text="[%Souhrn individuálních plánů%]" CssClass="nadpis1"></asp:Label>--%>
    <div style="padding-bottom: 8px">
        <asp:ObjectDataSource ID="ODS_plany" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="FiremniPlany" TypeName="KSProgram.Vzdelavani.IndividualniPlan">
            <SelectParameters>
                <asp:Parameter DefaultValue="false" Name="jenAktualni" Type="Boolean" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <kspwc:TRadComboBox ID="TRCB_plany" runat="server" DataSourceID="ODS_plany" DataTextField="nazev_planu"
            DataValueField="kod_planu"  AutoPostBack="true" DropDownWidth="500px"
            MaxHeight="400px" HighlightTemplatedItems="true" Width="500px" Height="400px"
            OnSelectedIndexChanged="TRCB_plany_SelectedIndexChanged" OnDataBound="TRCB_plany_DataBound">
            <HeaderTemplate>
                <table>
                    <tr>
                        <td style="width: 70px">[%Kód plánu%]
                        </td>
                        <td style="width: 290px">[%Název plánu%]
                        </td>
                        <td style="width: 70px">[%Datum od%]
                        </td>
                        <td style="width: 70px">[%Datum Do%]
                        </td>
                    </tr>
                </table>
            </HeaderTemplate>
            <ItemTemplate>
                <table>
                    <tr>
                        <td style="width: 70px">
                            <%# DataBinder.Eval(Container.DataItem, "kod_planu") %>
                        </td>
                        <td style="width: 290px">
                            <%# DataBinder.Eval(Container.DataItem, "nazev_planu") %>
                        </td>
                        <td style="width: 70px">
                            <%# DataBinder.Eval(Container.DataItem, "datum_od", "{0:d}")%>
                        </td>
                        <td style="width: 70px">
                            <%# DataBinder.Eval(Container.DataItem, "datum_do", "{0:d}")%>
                        </td>
                    </tr>
                </table>
            </ItemTemplate>
        </kspwc:TRadComboBox>

    </div>
    <kspwc:TRadGrid ID="TRG_souhrn" runat="server" OnNeedDataSource="TRG_souhrn_NeedDataSource"
        AllowPaging="True" AllowSorting="True" AutoGenerateColumns="False" EnableHeaderContextMenu="True"
         ShowFooter="True" ShowGroupPanel="True" MasterTableView-Caption="[%Souhrn individuálních plánů%]"
        OnDataBinding="TRG_souhrn_DataBinding"
        OnItemDataBound="TRG_souhrn_ItemDataBound" AutoFilterControlWidth="False">
        <GroupingSettings ShowUnGroupButton="True" />
        <ExportSettings>
            <Pdf PageWidth="">
            </Pdf>
        </ExportSettings>
        <ClientSettings AllowDragToGroup="True">
        </ClientSettings>
        <MasterTableView ShowFooter="True" ShowGroupFooter="True" EnableGroupsExpandAll="True"
            CommandItemDisplay="Top" GroupLoadMode="Client" HierarchyLoadMode="Conditional">
            <RowIndicatorColumn Visible="False">
            </RowIndicatorColumn>
            <Columns>
                <telerik:GridBoundColumn DataField="kmen_str" FilterControlAltText="Filter kmen_str column"
                    HeaderText="[%Kmen. Stř.%]" UniqueName="kmen_str" FilterControlWidth="40px">
                </telerik:GridBoundColumn>
                <telerik:GridNumericColumn DataField="os_cislo" DataType="System.Decimal" DecimalDigits="0"
                    FilterControlAltText="Filter os_cislo column" HeaderText="[%Os. číslo%]" UniqueName="os_cislo"
                    Aggregate="Count" FooterText="[%Záznamů%]: " FilterControlWidth="40px">
                </telerik:GridNumericColumn>
                <kspwc:GridFotoZamColumn UniqueName="foto" DataOsCisloField="os_cislo"></kspwc:GridFotoZamColumn>
                <telerik:GridBoundColumn DataField="zamestnanec" FilterControlAltText="Filter zamestnanec column"
                    HeaderText="[%Zaměstnanec%]" UniqueName="zamestnanec" Aggregate="CountDistinct"
                    FooterText="[%Osob%]: ">
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="osvedceni" FilterControlAltText="Filter osvedceni column"
                    HeaderText="[%Vzdělávací aktivita%]" UniqueName="osvedceni">
                </telerik:GridBoundColumn>
                <telerik:GridDateTimeColumn DataField="termin" DataFormatString="{0:d.M.yyyy}" DataType="System.DateTime"
                    FilterControlAltText="Filter termin column" FilterDateFormat="d.M.yyyy" HeaderText="[%Termín%]"
                    UniqueName="termin" FilterControlWidth="90px">
                </telerik:GridDateTimeColumn>
                <telerik:GridBoundColumn DataField="zdroj" FilterControlAltText="Filter zdroj column"
                    HeaderText="[%Zdroj%]" UniqueName="zdroj">
                </telerik:GridBoundColumn>
                <telerik:GridCheckBoxColumn DataField="potlaceno" DataType="System.Boolean" FilterControlAltText="Filter potlaceno column"
                    HeaderText="[%Potl.%]" UniqueName="potlaceno">
                </telerik:GridCheckBoxColumn>
                <telerik:GridNumericColumn Aggregate="Sum" DataField="predpl_naklady" DataType="System.Decimal"
                    DecimalDigits="2" FilterControlAltText="Filter predpl_naklady column" Groupable="False"
                    HeaderText="[%Předpokl. náklady%]" UniqueName="predpl_naklady" FooterText="[%Celkem%]: " FilterControlWidth="40px">
                </telerik:GridNumericColumn>
                <telerik:GridBoundColumn DataField="cislo_fondu" FilterControlAltText="Filter cislo_fondu column"
                    HeaderText="[%Fond%]" UniqueName="cislo_fondu" FilterControlWidth="40px">
                </telerik:GridBoundColumn>
                <telerik:GridBoundColumn DataField="cislo_akce" FilterControlAltText="Filter cislo_akce column"
                    HeaderText="[%Číslo skup. akcí%]" UniqueName="cislo_akce" FilterControlWidth="40px">
                </telerik:GridBoundColumn>
                <telerik:GridDateTimeColumn DataField="dat_od" DataFormatString="{0:d.M.yyyy}" DataType="System.DateTime"
                    FilterControlAltText="Filter dat_od column" FilterDateFormat="d.M.yyyy"
                    HeaderText="[%Termín škol. akce%]" UniqueName="dat_od" FilterControlWidth="90px" Visible="false">
                </telerik:GridDateTimeColumn>
                <telerik:GridBoundColumn DataField="poznamka" FilterControlAltText="Filter poznamka column"
                    HeaderText="[%Poznámka%]" UniqueName="poznamka">
                </telerik:GridBoundColumn>
            </Columns>
            <PagerStyle AlwaysVisible="True" />
            <CommandItemTemplate>
                <kspwc:GridCommandItemControl ID="GCIC" runat="server">
                    <PrimiPodrizeniButton runat="server" Visible="true"></PrimiPodrizeniButton>
                    <ContentTemplate>
                        <div class="gridCommandButton">
                            <kspwc:TRadButton ID="TRB_Verze" runat="server" Text="[%Varianty sestavy%]" AutoPostBack="False" OnClientClicked="showVerzeMenu" ></kspwc:TRadButton> <%----%>
                        </div>
                    </ContentTemplate>
                </kspwc:GridCommandItemControl>
            </CommandItemTemplate>
        </MasterTableView>
        <PagerStyle AlwaysVisible="True" />
    </kspwc:TRadGrid>
    <telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">
        <script type="text/javascript" id="telerikClientEvents2">
            function showVerzeMenu(sender, args) {
                var contextMenu = $find('<%= RCM_Verze.ClientID %>');
                if (contextMenu) {
                    var currentLocation = $telerik.getBounds(sender.get_element());
                    contextMenu.showAt(currentLocation.x, currentLocation.y + currentLocation.height);
                }
            }
        </script>
    </telerik:RadScriptBlock>
    <telerik:RadContextMenu ID="RCM_Verze" runat="server" 
        OnItemClick="RCM_Verze_ItemClick">
        <Targets>
            <telerik:ContextMenuControlTarget ControlID="TRB_Verze" />
        </Targets>
        <Items>
            <telerik:RadMenuItem runat="server" Text="[%Termíny akcí a vzdělávacích aktivit%]" Value="term_osv">
            </telerik:RadMenuItem>
            <telerik:RadMenuItem runat="server" Text="[%Zaměstnanci a kmen. střediska%]" Value="zam_str">
            </telerik:RadMenuItem>
            <telerik:RadMenuItem runat="server" Text="[%Zaměstnanci a fondy%]" Value="zam_fond">
            </telerik:RadMenuItem>
            <telerik:RadMenuItem runat="server" Text="[%Vzdělávací aktivity a kmen. střediska%]" Value="osv_str">
            </telerik:RadMenuItem>
            <telerik:RadMenuItem runat="server" Text="[%Vzdělávací aktivity a fondy%]" Value="osv_fond">
            </telerik:RadMenuItem>
            <telerik:RadMenuItem runat="server" Text="[%Potlačené požadavky%]" Value="potl">
            </telerik:RadMenuItem>
        </Items>
    </telerik:RadContextMenu>
</asp:Content>
