﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="RozpadHodinChr.aspx.cs" Inherits="KSPortal.ZakSpec.Chropyne.RozpadHodinChr" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
     <script src= "../../kendo/js/kendo.all.min.js" type="text/javascript"></script>
     <script src="../../kendo/js/cultures/kendo.culture.cs-CZ.min.js" type="text/javascript" ></script>
    <script src="../../kendo/js/messages/kendo.messages.cs-CZ.min.js" type="text/javascript"></script>      
    <link rel="stylesheet" href="../../kendo/styles/kendo.default-main.min.css" />
    <style>
        .k-dirty
        {
            color:red;
        }       
        .k-grid .k-grid-content {
            overflow-y: hidden !important;
        }
        .k-grid-header
        { 
            padding-right:0px !important;
        }
        .ks-zaporne
        {
            color:red;
        }
        .wrap-but-potvrzeni
        {
            padding:50px;
            text-align:right;
        }
        #gridhlavicka th {            
            font-weight:bold !important;
            background-color:rgb(191,223,255)
        }
        .ks-hl-proj-1-sl
        {
             background-color:rgb(191,223,255);            
             border-width: 0.5px !important; 
        }
        .ks-proj-1-sl
        {
             background-color:rgb(214,173,173);
             border-width: 0.5px !important; 
        }
        .btn-potvrzeni
        {
            width:150px !important
        }
        .ks-schval-sl-d
        {
             background-color:rgb(255,145,145);
             border-width: 0.5px !important; 
        }
        .ks-schvalman-ano
        {
             background-color:rgb(157,189,108);           
        }
        .ks-schvalman-ne
        {
              background-color:rgb(255,145,145);   
        }
        .ks-validacechr-message
        {
            color:red;
            font-weight:bold;
            width:200px !important;
            height:50px;
            white-space:nowrap;
        }       
    </style>
    <telerik:RadCodeBlock runat="server" ID="rcb" >   
        <script type="text/javascript">            
            kendo.culture('<%= System.Globalization.CultureInfo.CurrentUICulture.Name %>');
            Sys.Application.add_load(function () {

                window.addEventListener("resize", function () {
                    const dv = document.getElementById("div_wrapper");
                    getRemainingWidth(dv);                    
                });


                let sirka = 120;
                let povol_edit = false;
                let zaporna_hodnota = false;

                $.ajax({
                    type: "POST",
                    url: "RozpadHodinChr.aspx/GetWeekCombo",
                    data: "{}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        var comboBox = $("#weekSelector").data("kendoComboBox");                       
                        if (comboBox) {                            
                            comboBox.setDataSource(response.d.Data);
                            comboBox.value(response.d.SelectedValue);
                            comboBox.text(response.d.SelectedText);
                            comboBox.trigger("change");
                        }
                    },
                    error: function (xhr, status, error) {
                        console.error("Error loading dropdown data: " + error);
                    }
                });

                $("#weekSelector").kendoComboBox({
                    dataTextField: "Item1",
                    dataValueField: "Item2",                        
                    placeholder: "Výběr týdne",
                    clearButton: false,
                    filter:"none",
                    change: function (e) {                       
                        var selectedWeek = this.value();
                            if (selectedWeek == undefined) {
                                radalert("Není vybrán žádný týden, nelze pokračovat", 0, 0, "", null, null);
                                return;
                            }
                            var oc = KSMaster.HF_sel_os_cislo.value;
                            var cp = KSMaster.HF_sel_cislo_pom.value;
                            var arr = selectedWeek.split("_");

                            ChropRozpad.selectedDatum[0] = parseInt(arr[0]);
                            ChropRozpad.selectedDatum[1] = parseInt(arr[1]);
                            ChropRozpad.selectedDatum[2] = parseInt(arr[2]);

                        ChropRozpad.getZamData(oc, cp, selectedWeek)
                        }
                });

                function editorTime(container, options) {
                    $('<input name="' + options.field + '"/>')
                        .appendTo(container)
                        .kendoTimePicker({
                            format: "HH:mm",                               
                            dateInput: true                               
                        });
                }

                var dshlavicka = new kendo.data.DataSource({
                    batch: false,
                    pageSize: 20,
                    schema: {
                        model: {
                            fields: {
                                Text: { type: "string" },
                                D1: { type: "string" },
                                D2: { type: "string" },
                                D3: { type: "string" },
                                D4: { type: "string" },
                                D5: { type: "string" },
                                D6: { type: "string" },
                                D7: { type: "string" }
                            }
                        }
                    }
                });
                $("#gridhlavicka").kendoGrid({
                    dataSource: dshlavicka,
                    navigatable: true,
                    pageable: false,                    
                    width: "100%",                   
                    columns: [                       
                        {
                            field: "Text", title: "",
                            attributes: {
                                "class": "ks-hl-proj-1-sl"
                            }
                        },
                        {
                            field: "D1S", title: "Pondělí", width:sirka
                        },
                        {
                            field: "D2S", title: "Úterý", width: sirka
                        },
                        {
                            field: "D3S", title: "Středa", width: sirka
                        },
                        {
                            field: "D4S", title: "Čtvrtek", width: sirka
                        },
                        {
                            field: "D5S", title: "Pátek", width: sirka
                        },
                        {
                            field: "D6S", title: "Sobota", width: sirka
                        },
                        {
                            field: "D7S", title: "Neděle", width: sirka
                        },
                        {
                            field: "", title: "", width: 100
                        },
                        {
                            field: "", title: "", width: sirka
                        }
                       
                    ],
                    editable: false,
                    dataBound: function (e) {                       
                        var rows = e.sender.tbody.children();
                        zaporna_hodnota = false;
                        for (var j = 1; j < rows.length; j++) {
                            var row = $(rows[j]);
                            var dataItem = e.sender.dataItem(row);
                            for (var x = 1; x <= 7; x++) {
                                var s = dataItem.get("D" + x + "S");
                                var columnIndex = this.wrapper.find(".k-grid-header [data-field=" + "D" + x + "S" + "]").index();
                                var cell = row.children().eq(columnIndex);
                                if (s!="00:00") {                                    
                                    cell.addClass("ks-zaporne");
                                    zaporna_hodnota = true;
                                } else  {
                                    cell.addClass("ks-schvalman-ano");
                                }
                            }
                        }
                    }
                });

                    var ds = new kendo.data.DataSource({
                        batch: false,                       
                        pageSize: 20,
                        schema: {
                            model: {
                                id: "Id",
                                fields: {
                                    Dim1: { type: "string" },
                                    Dim2: { type: "string", validation: { required: true } },
                                    Dim3: { type: "string", validation: { required: true } },
                                    Dim4: { type: "string", validation: { required: true } },
                                    D1: { type: "date", defaultValue: new Date(new Date().setHours(0, 0, 0, 0)) },
                                    D2: { type: "date", defaultValue: new Date(new Date().setHours(0, 0, 0, 0)) },
                                    D3: { type: "date", defaultValue: new Date(new Date().setHours(0, 0, 0, 0)) },
                                    D4: { type: "date", defaultValue: new Date(new Date().setHours(0, 0, 0, 0)) },
                                    D5: { type: "date", defaultValue: new Date(new Date().setHours(0, 0, 0, 0)) },
                                    D6: { type: "date", defaultValue: new Date(new Date().setHours(0, 0, 0, 0)) },
                                    D7: { type: "date", defaultValue: new Date(new Date().setHours(0, 0, 0, 0)) },
                                    SchvalenoText: { type: "string", editable: false }
                                }
                            }
                        }                       
                    });
                    $("#grid").kendoGrid({
                        dataSource: ds,
                        navigatable: true,
                        pageable: false,
                        width: "100%",
                        toolbar: [
                            { name: "create", text: "", iconClass: "fi-add" },
                            { name: "refreshGrid", text: "", iconClass: "fi-refresh" },
                            { name: "save", text: "", iconClass: "fi-disk" }
                        ],
                        columns: [
                            {
                                field: "Dim1", title: "Projekt",
                                editor: ChropRozpad.dim1DropDownEditor,
                                editorOptions: {
                                    dataTextField: "Text",
                                    dataValueField: "Value"
                                },
                                attributes: {
                                    "class": "ks-proj-1-sl"
                                },
                                template: function (dataItem) {                                   
                                    return ChropRozpad.getDimTextValue("dim1", dataItem.Dim1);                                   
                                }
                            },
                            {
                                field: "Dim2", title: "SPP Prvek",
                                editor: ChropRozpad.dim2DropDownEditor,
                                editorOptions: {
                                    dataTextField: "Text",
                                    dataValueField: "Value"
                                },
                                attributes: {
                                    "class": "ks-proj-1-sl"
                                },                            
                                template: function (dataItem) {
                                    return ChropRozpad.getDimTextValue("dim2", dataItem.Dim2);                                                                                 
                                }
                            },
                            {
                                field: "Dim3", title: "Síťový diagram",
                                editor: ChropRozpad.dim3DropDownEditor,
                                editorOptions: {
                                    dataTextField: "Text",
                                    dataValueField: "Value"
                                },
                                attributes: {
                                    "class": "ks-proj-1-sl"
                                }
                            },
                            {
                                field: "Dim4", title: "Operace",
                                editor: ChropRozpad.dim4DropDownEditor,
                                editorOptions: {
                                    dataTextField: "Text",
                                    dataValueField: "Value"
                                },
                                attributes: {
                                    "class": "ks-proj-1-sl"
                                },
                                template: function (dataItem) {
                                    return ChropRozpad.getDimTextValue("dim4", dataItem.Dim4, dataItem.Dim3);
                                }
                            },
                            {
                                field: "D1", title: " ", editor: editorTime, format: "{0:HH:mm}",  width: sirka
                            },
                            {
                                field: "D2", title: " ", editor: editorTime, format: "{0:HH:mm}", width: sirka
                            },
                            {
                                field: "D3", title: " ", editor: editorTime, format: "{0:HH:mm}", width: sirka
                            },
                            {
                                field: "D4", title: " ", editor: editorTime, format: "{0:HH:mm}", width: sirka
                            },
                            {
                                field: "D5", title: " ", editor: editorTime, format: "{0:HH:mm}", width: sirka
                            },
                            {
                                field: "D6", title: " ", editor: editorTime, format: "{0:HH:mm}", width: sirka
                            },
                            {
                                field: "D7", title: " ", editor: editorTime, format: "{0:HH:mm}", width: sirka
                            },                           
                            {
                                command: [
                                    {
                                        name: "destroy",                         
                                        confirm: "opravdu odstranit",
                                        text: "",
                                        iconClass: "fi-trash"                            
                                    }
                                ],
                                title: "&nbsp;",
                                width: "100px"
                            },
                            {
                                field: "SchvalenoText", title: " ", width: sirka
                            }
                        ],
                        editable: {
                            readonly: false,
                            confirmation: true
                        },
                        remove: function (e) {                           
                            if (e.model.isNew()) {
                                return;
                            }
                            var selectedWeek = $("#weekSelector").data("kendoComboBox").value();
                            ChropRozpad.delete2(ChropRozpad.selectedDatum, e);

                            var oc = KSMaster.HF_sel_os_cislo.value;
                            var cp = KSMaster.HF_sel_cislo_pom.value;
                            ChropRozpad.getZamData(oc, cp, selectedWeek);
                        },                       
                        dataBound: function (e) {                            
                            var rows = e.sender.tbody.children();
                            if (rows.length == 0)
                                povol_edit = true;
                            else
                                povol_edit = false;
                            for (var j = 0; j < rows.length; j++) {
                                var row = $(rows[j]);
                                var dataItem = e.sender.dataItem(row);
                                var s = dataItem.get("Schvaleno");
                                var p = dataItem.get("Potvrzeno");
                                var columnIndex = this.wrapper.find(".k-grid-header [data-field=Schvaleno]").index();
                                var cell = row.children().eq(columnIndex);
                                if (s == "z") {
                                    cell.addClass("ks-schvalman-ne");
                                    povol_edit = true;
                                }
                                else if (s == "a") {
                                    cell.addClass("ks-schvalman-ano");
                                    $(row).find(".k-grid-delete").remove();
                                } else if (p)
                                    $(row).find(".k-grid-delete").remove();
                                else
                                    povol_edit = true;
                            };
                            
                            setTimeout(() => {
                                $(".btn-potvrzeni").data("kendoButton").enable(povol_edit);                                                                                  
                                if (povol_edit || zaporna_hodnota) {
                                    $("#grid .k-grid-add").prop("disabled", false).removeClass("k-state-disabled");
                                    $("#grid .k-grid-save-changes").prop("disabled", false).removeClass("k-state-disabled");
                                }
                                else {
                                    $("#grid .k-grid-add").prop("disabled", true).addClass("k-state-disabled");
                                    $("#grid .k-grid-save-changes").prop("disabled", true).addClass("k-state-disabled");
                                }
                            }, "500");
                                           
                        },
                        beforeEdit: function (e) {                            
                            if (e.model.Schvaleno=="a" || e.model.Potvrzeno) {
                                e.preventDefault(); 
                            }
                        }                       
                    });
                var grid = $("#grid").data("kendoGrid");   
                var grid = $("#grid").data("kendoGrid");
                grid.bind("saveChanges", ChropRozpad.grid_save2);

                $("#grid .k-grid-refreshGrid").on("click", function () {                  
                    var oc = KSMaster.HF_sel_os_cislo.value;
                    var cp = KSMaster.HF_sel_cislo_pom.value;                    
                    var selectedWeek = $("#weekSelector").data("kendoComboBox").value();
                    ChropRozpad.getZamData(oc, cp, selectedWeek);
                });
                var dsschvaleni = new kendo.data.DataSource({
                    batch: false,
                    pageSize: 20,
                    schema: {
                        model: {
                            fields: {
                                Text: { type: "string" },
                                D1: { type: "string" },
                                D2: { type: "string" },
                                D3: { type: "string" },
                                D4: { type: "string" },
                                D5: { type: "string" },
                                D6: { type: "string" },
                                D7: { type: "string" },
                            }
                        }
                    }
                });
                $("#gridschvaleni").kendoGrid({
                    dataSource: dsschvaleni,
                    navigatable: true,
                    pageable: false,
                    width: "100%",
                    columns: [
                        {
                            field: "Text", title: "",
                            attributes: {
                                "class": "ks-hl-proj-1-sl"
                            }
                        },
                        {
                            field: "D1Stav", title: "", width: sirka
                        },
                        {
                            field: "D2Stav", title: "", width: sirka
                        },
                        {
                            field: "D3Stav", title: "", width: sirka
                        },
                        {
                            field: "D4Stav", title: "", width: sirka
                        },
                        {
                            field: "D5Stav", title: "", width: sirka
                        },
                        {
                            field: "D6Stav", title: "", width: sirka
                        },
                        {
                            field: "D7Stav", title: "", width: sirka
                        },
                        {
                            title: "", width: 100
                        },
                        {
                            title: "", width: sirka
                        }
                    ],
                    editable: false,
                    dataBound: function (e) {                      
                        var rows = e.sender.tbody.children();
                        for (var j = 0; j < rows.length; j++) {
                            var row = $(rows[j]);
                            var dataItem = e.sender.dataItem(row);
                            for (var x = 1; x <= 7; x++) {
                                var s = dataItem.get("D" + x + "Stav");
                                var columnIndex = this.wrapper.find(".k-grid-header [data-field=" + "D" + x + "Stav" + "]").index();
                                var cell = row.children().eq(columnIndex);
                                if (s?.startsWith("N")) {
                                    cell.addClass("ks-schvalman-ne");
                                } else if (s?.startsWith("S")) {
                                    cell.addClass("ks-schvalman-ano");
                                }
                            }
                        }
                    }                   
                });
                var grid = $("#gridschvaleni").data("kendoGrid");
                grid.thead.hide();            
                
                $(".btn-potvrzeni").kendoButton({                   
                    click: ChropRozpad.onPotvrzeni                                 
                }).hide();
            });

            function getRemainingWidth(div) {
                const divRect = div.getBoundingClientRect(); 
                const remainingWidth = window.innerWidth - divRect.left; 
                div.style.width = remainingWidth + "px";               
            }

        </script>
    </telerik:RadCodeBlock>
    <select id="weekSelector" style="width:300px"></select>
    <br />
    <div id="div_wrapper" style="overflow-x:scroll">
        <div style="min-width:1500px;">
            <div id="gridhlavicka" ></div>
            <div id="grid"> </div>
            <div id="gridschvaleni"></div>
        </div>
    </div>
    <div class="wrap-but-potvrzeni">
        <button class="btn-potvrzeni ks-schvalman-ano" id="btnPotvrzeni"><i class="fi-check"></i><asp:Label runat="server" ID="Label29" Text="[%Potvrzení%]"></asp:Label></button>
        <span class="ks-validacechr-message"></span>
     </div>
</asp:Content>
