﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="ProstredkyOddeleni.aspx.cs" Inherits="KSPortal.ZakSpec.UkolyOdmeny.ProstredkyOddeleni" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <asp:ObjectDataSource ID="ODS_Strediska" runat="server" SelectMethod="VsechnaStrediska"
        TypeName="KSProgram.Ciselniky.CisStredisko" OldValuesParameterFormatString="original_{0}"
        OnDataBinding="ODS_Strediska_DataBinding">
        <SelectParameters>
            <asp:Parameter Name="datumOd" Type="DateTime" />
            <asp:Parameter Name="datumDo" Type="DateTime" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ODS_Prostredky" runat="server" SelectMethod="SelectProstredkyPrideleni"
        TypeName="KSProgram.ZakSpec.UkolyOdmeny2" OldValuesParameterFormatString="original_{0}">
        <SelectParameters>
            <asp:Parameter Name="aKeDni" Type="DateTime" />
            <asp:Parameter Name="aRok" Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <telerik:RadAjaxManagerProxy runat="server" ID="ajax_manager">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRadGrid1">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGrid1"></telerik:AjaxUpdatedControl>
                    <telerik:AjaxUpdatedControl ControlID="L_LimitStrZbyva"></telerik:AjaxUpdatedControl>
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <table>
        <tr>
            <td>
                &nbsp;
            </td>
            <td>
                <kspwc:TRadComboBox ID="TRCB_Poradi" runat="server" AutoPostBack="True" DataSourceID="ODS_Prostredky"
                    DataTextField="por_prostredky" DataValueField="por_prostredky" Label="Rok / pořadí:"
                    OnPreRender="TRCB_Poradi_PreRender"  OnDataBound="TRCB_Poradi_DataBound"
                    OnSelectedIndexChanged="TRCB_Poradi_SelectedIndexChanged" 
                    ondatabinding="TRCB_Poradi_DataBinding">
                </kspwc:TRadComboBox>
                <asp:Label ID="L_ZdrojText" runat="server" Text="Zdroj:"></asp:Label>
                <asp:Label ID="L_Zdroj" runat="server" Text=""></asp:Label>
            </td>
        </tr>
    </table>
    <kspwc:TRadGrid ID="TRadGrid1" runat="server" AutoGenerateColumns="False" AutoGenerateDeleteColumn="false"
        ShowFooter="true" AutoGenerateEditColumn="false" OnNeedDataSource="TRadGrid1_NeedDataSource"
        OnInsertCommand="TRadGrid1_InsertCommand" OnPreRender="RadGrid1_PreRender" OnUpdateCommand="TRadGrid1_UpdateCommand"
        OnDeleteCommand="TRadGrid1_DeleteCommand" OnItemDataBound="TRadGrid1_ItemDataBound"
        OnDataBound="TRadGrid1_DataBound">
        <MasterTableView Caption="[%Prostředky pro vedoucí oddělení%]" AllowAutomaticInserts="false"
            CommandItemDisplay="Top" AllowAutomaticUpdates="False" DataKeyNames="por_prostredky, zdroj, skup_str, kmen_str, limit_kc, plati_od, plati_do">
            <Columns>
                <telerik:GridEditCommandColumn ButtonType="ImageButton" />
                <telerik:GridDropDownColumn UniqueName="kmen_str" HeaderText="Oddělení" DataField="kmen_str"
                    AllowAutomaticLoadOnDemand="False" DataSourceID="ODS_Strediska" ListTextField="cely_nazev"
                    ListValueField="str" Resizable="true">
                </telerik:GridDropDownColumn>
                <telerik:GridNumericColumn DecimalDigits="2" FilterControlAltText="Filter column1 column"
                    UniqueName="limit_kc" HeaderText="Limit Kč" DataField="limit_kc" DataFormatString="{0:#,##0}"
                    Aggregate="Sum" FooterText="Součet:">
                </telerik:GridNumericColumn>
                <telerik:GridDateTimeColumn FilterControlAltText="Filter column2 column" UniqueName="plati_od"
                    HeaderText="Platí od" DataField="plati_od" DataFormatString="{0:d}" ReadOnly="True"
                    Display="True">
                </telerik:GridDateTimeColumn>
                <telerik:GridDateTimeColumn FilterControlAltText="Filter column3 column" UniqueName="plati_do"
                    HeaderText="Platí do" DataField="plati_do" DataFormatString="{0:d}" ReadOnly="True">
                </telerik:GridDateTimeColumn>
                <telerik:GridButtonColumn ConfirmText="Chcete opravdu smazat tento záznam?" ConfirmDialogType="RadWindow"
                    ConfirmTitle="Delete" ButtonType="ImageButton" CommandName="Delete" />
            </Columns>
            <CommandItemTemplate>
                <div style="padding: 5px 5px;">
                    <kspwc:TRadButton ID="TRB_add" runat="server" Text="[%Vložit nový%]" CommandName="InitInsert">
                        <Icon PrimaryIconCssClass="fi fi-add"></Icon>
                    </kspwc:TRadButton>
                    &nbsp;&nbsp;
                    <kspwc:TRadButton ID="TRB_rebind" runat="server" Text="[%Obnovit%]" CommandName="RebindGrid">
                        <Icon PrimaryIconCssClass="fi fi-rotate-right"></Icon>
                    </kspwc:TRadButton>
                </div>
            </CommandItemTemplate>

            <%--<EditFormSettings>
                <FormTemplate>

                <kspwc:TRadButton ID="RadButton5" runat="server" Text="[%Uložit%]" CommandName='<%# (Container is GridEditFormInsertItem) ? "PerformInsert" : "Update" %>'>
                            <Icon PrimaryIconCssClass="fi fi-disk"></Icon>
                        </kspwc:TRadButton>
                        &nbsp;
                        <kspwc:TRadButton ID="RadButton7" runat="server" Text="[%Zrušit změny%]" CausesValidation="False"
                            CommandName="Cancel">
                            <Icon PrimaryIconCssClass="fi fi-ban"></Icon>
                        </kspwc:TRadButton>

                </FormTemplate>
            </EditFormSettings>--%>
            <EditFormSettings>
                <EditColumn ButtonType="ImageButton" />
            </EditFormSettings>
        </MasterTableView>
        <PagerStyle Mode="NextPrevNumericAndAdvanced" />
    </kspwc:TRadGrid>
    <table>
        <tr>
            <td>
                <asp:Label ID="L_LimitKCStrText" runat="server" Text="Limit pro rozdělení:" Font-Bold="False"></asp:Label>
            </td>
            <td>
                <asp:Label ID="L_LimitKCStr" runat="server" Font-Bold="True"></asp:Label>
            </td>
        </tr>
        <tr>
            <td>
                <%--<asp:Label ID="L_LimitStrZbyvaText" runat="server" Text='<%# DateTime.Now.ToString() %>' Font-Bold="True" 
        onprerender="L_LimitStrZbyvaText_PreRender" ></asp:Label>--%>
                <asp:Label ID="L_LimitStrZbyvaText" runat="server" Text="Zbývá rozdělit:" Font-Bold="False"></asp:Label>
            </td>
            <td>
                <asp:Label ID="L_LimitStrZbyva" runat="server" Font-Bold="True"></asp:Label>
            </td>
        </tr>
    </table>
</asp:Content>
