﻿<%@ Page Language="C#" MasterPageFile="~/Main.master" AutoEventWireup="true" Inherits="OsUdaje"
    CodeBehind="OsUdaje.aspx.cs" %>

<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="kspwc" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="asp" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="cc1" %>

<asp:Content ID="Content2" ContentPlaceHolderID="HeadContent" runat="server">
    <style type="text/css">
        @media only screen and (max-width: 940px) {
            .largeOnly {
                display: none;
            }
        }

        .OsUdaje {
            background: none !important;
            box-shadow: none !important;
            display: flex;
            flex-wrap: wrap;
        }

        .OsUdajePanel {
            width: 48%;
            margin-right: 2%;
            margin-bottom: 25px;
        }

            .OsUdajePanel:nth-child(1) {
                box-shadow: var(--stin);
                background: white;
                border-radius: var(--ksrohy);
            }

            .OsUdajePanel:nth-child(3) {
                width: 100%;
            }

        .OsUdajeSekcePanelu {
            width: 46%;
            margin: 2%;
            min-width: fit-content;
        }

        .OsUdajeTabulky {
            display: flex;
            flex-wrap: wrap;
            margin: auto;
        }

        .main_content_td {
            width: 100%;
        }

        .OsUdajeMarginBot {
            margin-bottom: 20px;
        }

        .OsUdajePrislusnik {
            width: 250px;
            border-right: 2px solid var(--kscolor1);
            padding: 5px;
            padding-right: 25px;
            margin: 10px;
            background: white;
            font-weight: bold !important;
        }

            .OsUdajePrislusnik:last-child {
                border: none;
            }

        @media only screen and (min-width: 1100px) {
            .gridWidth {
                min-width: 0px !important;
            }
        }


        @media only screen and (max-width: 1400px) {
            .OsUdajePanel {
                width: 100%;
                margin-right: 0;
                margin-bottom: 25px;
            }
        }

        @media only screen and (max-width: 610px) {
            .OsUdajePrislusnik {
                width: 95%;
                margin: 10px auto 10px auto;
            }
        }

        .RadGrid .RadGrid_Metro .KsUnderlineGrid .ksprvek .ksId_RGVzdelani {
            width: 100%;
        }
    </style>
</asp:Content>

<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="server">
    <%--<asp:Label ID="Label1" runat="server" Text="[%Osobní údaje zaměstnance%]" CssClass="nadpis1"></asp:Label>--%>
    <%--<br />--%>
    <telerik:RadAjaxManagerProxy ID="RAMP" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="div_main">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="div_main" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <div id="div_main" class="OsUdaje">

        <asp:Panel runat="server" ID="P_os" CssClass="OsUdajePanel">
            <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" SelectMethod="OsobniUdaje" TypeName="KSProgram.Personal.Zamestnanec"></asp:ObjectDataSource>
            <telerik:RadDataForm ID="OsUdajeZam" runat="server" DataSourceID="ObjectDataSource1">
                <LayoutTemplate>
                    <div>
                        <div class="rgCaption">[%Osobní údaje zaměstnance%]</div>
                        <div id="itemPlaceholder" runat="server"></div>
                    </div>
                </LayoutTemplate>
                <ItemTemplate>
                    <div class="OsUdajeTabulky">
                        <div class="OsUdajeSekcePanelu">
                            <kspwc:BindTable ID="BindTable1" runat="server" HeaderText="[%Osobní údaje%]" CssClass="KsUnderlineTable">
                                <Rows>
                                    <kspwc:BindRow DataField="os_cislo" Text="[%Osobní číslo%]" />
                                    <kspwc:BindRow DataField="prijmeni" Text="[%Příjmení%]" />
                                    <kspwc:BindRow DataField="jmeno" Text="[%Jméno%]" />
                                    <kspwc:BindRow DataField="titul" Text="[%Titul%]" />
                                    <kspwc:BindRow DataField="titul_za" Text="[%Titul za%]" />
                                    <kspwc:BindRow DataField="rodne_prijmeni" Text="[%Rodné příjmení%]" />
                                    <kspwc:BindRow DataField="datum_narozeni" Text="[%Datum narození%]" HtmlEncode="false" DataFormatString="{0:d}" />
                                    <kspwc:BindRow DataField="vek" Text="[%Věk%]" />
                                    <kspwc:BindRow DataField="misto_narozeni" Text="[%Místo narození%]" />
                                    <kspwc:BindRow DataField="rodinny_stav" Text="[%Rodinný stav%]" />
                                </Rows>
                            </kspwc:BindTable>
                        </div>
                        <div class="OsUdajeSekcePanelu" style="justify-content: space-between; display: flex; flex-direction: column">
                            <kspwc:BindTable ID="BindTable2" runat="server" HeaderText="[%Pracovní údaje%]" CssClass="KsUnderlineTable">
                                <Rows>
                                    <kspwc:BindRow DataField="kmen_str" Text="[%Kmenové středisko%]" />
                                    <kspwc:BindRow DataField="datum_nastupu" Text="[%Datum nástupu%]" HtmlEncode="false" DataFormatString="{0:d}" />
                                    <kspwc:BindRow DataField="datum_vystupu" Text="[%Datum výstupu%]" HtmlEncode="false" DataFormatString="{0:d}" />
                                </Rows>
                            </kspwc:BindTable>

                            <kspwc:BindTable ID="BindTable3" runat="server" HeaderText="[%Odpracovaná doba%]" CssClass="KsUnderlineTable">
                                <Rows>
                                    <kspwc:BindRow DataField="zam_roky" Text="[%Roky v současném zaměstnání%]" />
                                    <kspwc:BindRow DataField="zam_dny" Text="[%Dny v současném zaměstnání%]" />
                                    <kspwc:BindRow DataField="odpr_roky_dov" Text="[%Roky v předchozím zaměstnání%]" />
                                    <kspwc:BindRow DataField="odpr_dny_dov" Text="[%Dny v předchozím zaměstnání%]" />
                                </Rows>
                            </kspwc:BindTable>
                        </div>
                        <div class="OsUdajeSekcePanelu">
                            <kspwc:BindTable ID="BindTable4" runat="server" HeaderText="[%Trvalé bydliště%]" CssClass="KsUnderlineTable">
                                <Rows>
                                    <kspwc:BindRow DataField="tr_ulice" Text="[%Ulice%]" />
                                    <kspwc:BindRow DataField="tr_cislo" Text="[%Číslo%]" />
                                    <kspwc:BindRow DataField="misto_trv" Text="[%Místo%]" />
                                    <kspwc:BindRow DataField="psc_trv" Text="[%PSČ%]" />
                                    <kspwc:BindRow DataField="posta_trv" Text="[%Pošta%]" />
                                </Rows>
                            </kspwc:BindTable>
                        </div>
                        <div class="OsUdajeSekcePanelu">
                            <kspwc:BindTable ID="BindTable5" runat="server" HeaderText="[%Přechodné bydliště%]" CssClass="KsUnderlineTable">
                                <Rows>
                                    <kspwc:BindRow DataField="pr_ulice" Text="[%Ulice%]" />
                                    <kspwc:BindRow DataField="pr_cislo" Text="[%Číslo%]" />
                                    <kspwc:BindRow DataField="misto_prech" Text="[%Místo%]" />
                                    <kspwc:BindRow DataField="psc_prech" Text="[%PSČ%]" />
                                    <kspwc:BindRow DataField="posta_prech" Text="[%Pošta%]" />
                                </Rows>
                            </kspwc:BindTable>
                        </div>
                    </div>
                </ItemTemplate>
            </telerik:RadDataForm>
        </asp:Panel>

        <div class="OsUdajePanel">
            <asp:Panel runat="server" ID="P_vz" CssClass="OsUdajeMarginBot">
                <asp:ObjectDataSource ID="ObjectDataSource2" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="Vzdelani" TypeName="KSProgram.Personal.Zamestnanec"></asp:ObjectDataSource>
                <div id="div_vzdelani_">
                    <kspwc:TRadGrid ID="RGVzdelani" runat="server" DataSourceID="ObjectDataSource2" AutoGenerateColumns="false" AllowSorting="true" CssClass="KsUnderlineGrid ksprvek">
                        <MasterTableView Caption="[%Vzdělání%]">
                            <Columns>
                                <telerik:GridBoundColumn DataField="stupen" HeaderText="[%Stupeň%]" SortExpression="stupen"></telerik:GridBoundColumn>
                                <telerik:GridBoundColumn DataField="obor" HeaderText="[%Obor%]" SortExpression="obor"></telerik:GridBoundColumn>
                                <telerik:GridBoundColumn DataField="ved_kval" HeaderText="[%Vědecká kvalifikace%]" SortExpression="ved_kval"></telerik:GridBoundColumn>
                                <telerik:GridBoundColumn DataField="druh_zkousky" HeaderText="[%Druh zkoušky%]" SortExpression="druh_zkousky"></telerik:GridBoundColumn>
                                <telerik:GridBoundColumn DataField="rok_ukonc" HeaderText="[%Rok ukončení%]" SortExpression="rok_ukonc"></telerik:GridBoundColumn>
                                <telerik:GridBoundColumn DataField="titul" HeaderText="[%Titul%]" SortExpression="titul"></telerik:GridBoundColumn>
                                <telerik:GridBoundColumn DataField="skola" HeaderText="[%Škola%]" SortExpression="skola"></telerik:GridBoundColumn>
                                <telerik:GridBoundColumn DataField="zamereni" HeaderText="[%Zaměření%]" SortExpression="zamereni"></telerik:GridBoundColumn>
                            </Columns>
                        </MasterTableView>
                    </kspwc:TRadGrid>
                </div>
            </asp:Panel>

            <asp:Panel ID="P_ja" runat="server" CssClass="OsUdajeMarginBot">
                <asp:ObjectDataSource ID="ObjectDataSource3" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="JazykoveZnalosti" TypeName="KSProgram.Personal.Zamestnanec"></asp:ObjectDataSource>
                <div class="ksprvek">
                    <kspwc:TRadGrid ID="TRadGrid1" runat="server" DataSourceID="ObjectDataSource3" AutoMasterGridWidth="true" AutoGenerateColumns="false" AllowSorting="true" AllowPaging="false" CssClass="KsUnderlineGrid">
                        <MasterTableView Caption="[%Jazykové znalosti%]">
                            <Columns>
                                <telerik:GridBoundColumn DataField="jazyk" HeaderText="[%Jazyk%]" SortExpression="jazyk" />
                                <telerik:GridBoundColumn DataField="stupen" HeaderText="[%Stupeň%]" SortExpression="stupen" />
                                <telerik:GridBoundColumn DataField="druh_zkousky" HeaderText="[%Druh zkoušky%]" SortExpression="druh_zkousky" />
                            </Columns>
                        </MasterTableView>
                    </kspwc:TRadGrid>
                </div>
            </asp:Panel>

            <asp:Panel ID="P_ko" runat="server" CssClass="OsUdajeMarginBot">
                <asp:ObjectDataSource ID="ObjectDataSource5" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="Kontakty" TypeName="KSProgram.Personal.Zamestnanec"></asp:ObjectDataSource>
                <div class="ksprvek">
                    <kspwc:TRadGrid ID="TRadGrid2" runat="server" DataSourceID="ObjectDataSource5" AutoMasterGridWidth="true" AutoGenerateColumns="false" AllowSorting="true" AllowPaging="false" CssClass="KsUnderlineGrid">
                        <MasterTableView Caption="[%Kontakty%]">
                            <Columns>
                                <telerik:GridTemplateColumn HeaderText="[%Specifikace (kam)%]" SortExpression="kam">
                                    <ItemTemplate>
                                        <asp:Label ID="Label1" runat="server" Text='<%# _preloz(Eval("kam")) %>'></asp:Label>
                                    </ItemTemplate>
                                </telerik:GridTemplateColumn>
                                <telerik:GridBoundColumn DataField="kontakt" HeaderText="[%Kontakt%]" SortExpression="kontakt" />
                            </Columns>
                        </MasterTableView>
                    </kspwc:TRadGrid>
                </div>
            </asp:Panel>
        </div>

        <div class="OsUdajePanel">
            <asp:Panel ID="P_ro" runat="server" Visible="true">
                <asp:ObjectDataSource ID="ObjectDataSource4" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="RodinniPrislusnici" TypeName="KSProgram.Personal.Zamestnanec"></asp:ObjectDataSource>
                <div class="ksprvek">
                    <div class="rgCaption">[%Rodinní příslušníci%]</div>
                    <div style="display: flex; flex-wrap: wrap; background: white">
                        <asp:Repeater ID="RodPrislRepeat" runat="server" DataSourceID="ObjectDataSource4" OnPreRender="RodPrislRepeat_PreRender">
                            <ItemTemplate>
                                <div class="OsUdajePrislusnik">
                                    <kspwc:BindTable ID="BindTable6" runat="server" HeaderText="[%Osobní údaje%]" CssClass="KsUnderlineTable">
                                        <Rows>
                                            <kspwc:BindRow DataField="prijmeni" Text="[%Příjmení%]" />
                                            <kspwc:BindRow DataField="jmeno" Text="[%Jméno%]" />
                                            <kspwc:BindRow DataField="rodne_prijmeni" Text="[%Rodné příjmení%]" />
                                            <kspwc:BindRow DataField="vztah" Text="[%Vztah%]" />
                                            <kspwc:BindRow DataField="misto_narozeni" Text="[%Místo narození%]" />
                                            <kspwc:BindRow DataField="st_prisl" Text="[%Státní příslušnost%]" />
                                        </Rows>
                                    </kspwc:BindTable>
                                    <br />
                                    <kspwc:BindTable ID="BindTable7" runat="server" HeaderText="[%Trvalé bydliště%]" CssClass="KsUnderlineTable">
                                        <Rows>
                                            <kspwc:BindRow DataField="ulice_trv" Text="[%Ulice%]" />
                                            <kspwc:BindRow DataField="misto_trv" Text="[%Místo%]" />
                                            <kspwc:BindRow DataField="psc_trv" Text="[%PSČ%]" />
                                        </Rows>
                                    </kspwc:BindTable>
                                </div>
                            </ItemTemplate>
                        </asp:Repeater>
                    </div>
                </div>
            </asp:Panel>
        </div>

    </div>
</asp:Content>

<%--<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <asp:Panel runat="server" ID="P_os">
        <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" SelectMethod="OsobniUdaje"
            TypeName="KSProgram.Personal.Zamestnanec"></asp:ObjectDataSource>
        <kspwc:TDataList ID="TDataList1" runat="server" DataSourceID="ObjectDataSource1">
            <HeaderTemplate>
                <asp:Label ID="Label2" runat="server" Text="[%Osobní údaje zaměstnance%]"></asp:Label>
            </HeaderTemplate>
            <ItemTemplate> 
                <table border="0" cellpadding="3">
                    <tr>
                        <td valign="top">
                            <kspwc:BindTable ID="BindTable1" runat="server" HeaderText="[%Osobní údaje%]" Width="300px">
                                <TextFieldStyle Width="100px" />
                                <Rows>
                                    <kspwc:BindRow DataField="os_cislo" Text="[%Osobní číslo%]" />
                                    <kspwc:BindRow DataField="prijmeni" Text="[%Příjmení%]" />
                                    <kspwc:BindRow DataField="jmeno" Text="[%Jméno%]" />
                                    <kspwc:BindRow DataField="titul" Text="[%Titul%]" />
                                    <kspwc:BindRow DataField="titul_za" Text="[%Titul za%]" />
                                    <kspwc:BindRow DataField="rodne_prijmeni" Text="[%Rodné příjmení%]" />
                                    <kspwc:BindRow DataField="datum_narozeni" Text="[%Datum narození%]" HtmlEncode="false"
                                        DataFormatString="{0:d}" />
                                    <kspwc:BindRow DataField="vek" Text="[%Věk%]" />
                                    <kspwc:BindRow DataField="misto_narozeni" Text="[%Místo narození%]" />
                                    <kspwc:BindRow DataField="rodinny_stav" Text="[%Rodinný stav%]" />
                                </Rows>
                            </kspwc:BindTable>
                        </td>
                        <td valign="top">
                            <kspwc:BindTable ID="BindTable2" runat="server" HeaderText="[%Pracovní údaje%]" Width="300px">
                                <TextFieldStyle Width="100px" />
                                <Rows>
                                    <kspwc:BindRow DataField="kmen_str" Text="[%Kmenové středisko%]" />
                                    <kspwc:BindRow DataField="datum_nastupu" Text="[%Datum nástupu%]" HtmlEncode="false"
                                        DataFormatString="{0:d}" />
                                    <kspwc:BindRow DataField="datum_vystupu" Text="[%Datum výstupu%]" HtmlEncode="false"
                                        DataFormatString="{0:d}" />
                                </Rows>
                            </kspwc:BindTable>
                            <br />
                            <kspwc:BindTable ID="BindTable3" runat="server" HeaderText="[%Odpracovaná doba%]"
                                Width="300px">
                                <TextFieldStyle Width="190px" />
                                <Rows>
                                    <kspwc:BindRow DataField="zam_roky" Text="[%Roky v současném zaměstnání%]" />
                                    <kspwc:BindRow DataField="zam_dny" Text="[%Dny v současném zaměstnání%]" />
                                    <kspwc:BindRow DataField="odpr_roky_dov" Text="[%Roky v předchozím zaměstnání%]" />
                                    <kspwc:BindRow DataField="odpr_dny_dov" Text="[%Dny v předchozím zaměstnání%]" />
                                </Rows>
                            </kspwc:BindTable>
                        </td>
                    </tr>
                    <tr>
                        <td valign="top">
                            <kspwc:BindTable ID="BindTable4" runat="server" HeaderText="[%Trvalé bydliště%]"
                                Width="300px">
                                <TextFieldStyle Width="40px" />
                                <Rows>
                                    <kspwc:BindRow DataField="tr_ulice" Text="[%Ulice%]" />
                                    <kspwc:BindRow DataField="tr_cislo" Text="[%Číslo%]" />
                                    <kspwc:BindRow DataField="misto_trv" Text="[%Místo%]" />
                                    <kspwc:BindRow DataField="psc_trv" Text="[%PSČ%]" />
                                    <kspwc:BindRow DataField="posta_trv" Text="[%Pošta%]" />
                                </Rows>
                            </kspwc:BindTable>
                        </td>
                        <td valign="top">
                            <kspwc:BindTable ID="BindTable5" runat="server" HeaderText="[%Přechodné bydliště%]"
                                Width="300px">
                                <TextFieldStyle Width="40px" />
                                <Rows>
                                    <kspwc:BindRow DataField="pr_ulice" Text="[%Ulice%]" />
                                    <kspwc:BindRow DataField="pr_cislo" Text="[%Číslo%]" />
                                    <kspwc:BindRow DataField="misto_prech" Text="[%Místo%]" />
                                    <kspwc:BindRow DataField="psc_prech" Text="[%PSČ%]" />
                                    <kspwc:BindRow DataField="posta_prech" Text="[%Pošta%]" />
                                </Rows>
                            </kspwc:BindTable>
                        </td>
                    </tr>
                </table>
            </ItemTemplate>
        </kspwc:TDataList>
        <br />
    </asp:Panel>
    <asp:Panel runat="server" ID="P_vz">
        <asp:ObjectDataSource ID="ObjectDataSource2" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="Vzdelani" TypeName="KSProgram.Personal.Zamestnanec"></asp:ObjectDataSource>
        <kspwc:TGridView ID="TGridView3" runat="server" DataSourceID="ObjectDataSource2"
            HeaderText="[%Vzdělání%]" TitleText="[%Vzdělání%]" ShowTitleRow="true">
            <Columns>
                <asp:BoundField DataField="stupen" HeaderText="[%Stupeň%]" SortExpression="stupen" />
                <asp:BoundField DataField="obor" HeaderText="[%Obor%]" SortExpression="obor" />
                <asp:BoundField DataField="ved_kval" HeaderText="[%Vědecká kvalifikace%]" SortExpression="ved_kval" />
                <asp:BoundField DataField="druh_zkousky" HeaderText="[%Druh zkoušky%]" SortExpression="druh_zkousky" />
                <asp:BoundField DataField="rok_ukonc" HeaderText="[%Rok ukončení%]" SortExpression="rok_ukonc" />
                <asp:BoundField DataField="titul" HeaderText="[%Titul%]" SortExpression="titul" />
                <asp:BoundField DataField="skola" HeaderText="[%Škola%]" SortExpression="skola" />
                <asp:BoundField DataField="zamereni" HeaderText="[%Zaměření%]" SortExpression="zamereni" />
            </Columns>
        </kspwc:TGridView>
        <br />
    </asp:Panel>
    <asp:Panel ID="P_ja" runat="server">
        <asp:ObjectDataSource ID="ObjectDataSource3" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="JazykoveZnalosti" TypeName="KSProgram.Personal.Zamestnanec"></asp:ObjectDataSource>
        <cc1:TGridView ID="TGridView2" runat="server" AllowPaging="True" DataSourceID="ObjectDataSource3"
            IdSestavy="0" PovolFiltraci="False" PovolPoradiSloupcu="False" SortAscImageUrl=""
            SortDescImageUrl="" ShowTitleRow="True" TitleText="[%Jazykové znalosti%]">
            <Columns>
                <asp:BoundField DataField="jazyk" HeaderText="[%Jazyk%]" SortExpression="jazyk" />
                <asp:BoundField DataField="stupen" HeaderText="[%Stupeň%]" SortExpression="stupen" />
                <asp:BoundField DataField="druh_zkousky" HeaderText="[%Druh zkoušky%]" SortExpression="druh_zkousky" />
            </Columns>
        </cc1:TGridView>
        <br />
    </asp:Panel>
    <asp:Panel ID="P_ko" runat="server">
        <asp:ObjectDataSource ID="ObjectDataSource5" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="Kontakty" TypeName="KSProgram.Personal.Zamestnanec"></asp:ObjectDataSource>
        <cc1:TGridView ID="TGridView1" runat="server" AllowPaging="True" DataSourceID="ObjectDataSource5"
            IdSestavy="0" PovolFiltraci="False" PovolPoradiSloupcu="False" ShowTitleRow="True"
            SortAscImageUrl="" SortDescImageUrl="" TitleText="[%Kontakty%]">
            <Columns>
                <asp:BoundField DataField="kontakt" HeaderText="[%Kontakt%]" SortExpression="kontakt" />
                <asp:TemplateField HeaderText="[%Specifikace (kam)%]" SortExpression="kam">
                    <ItemTemplate>
                        <asp:Label ID="Label1" runat="server" Text='<%# _preloz(Eval("kam")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </cc1:TGridView>
        <br />
    </asp:Panel>
    <asp:Panel ID="P_ro" runat="server">
        <asp:ObjectDataSource ID="ObjectDataSource4" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="RodinniPrislusnici" TypeName="KSProgram.Personal.Zamestnanec">
        </asp:ObjectDataSource>
        <kspwc:TDataList ID="TDataList2" runat="server" DataSourceID="ObjectDataSource4">
            <HeaderTemplate>
                <asp:Label ID="Label3" runat="server" Text="[%Rodinní příslušníci%]"></asp:Label>
            </HeaderTemplate>
            <ItemTemplate>
                <kspwc:BindTable ID="BindTable6" runat="server" HeaderText="[%Osobní údaje%]" Width="300px">
                    <TextFieldStyle Width="100px" />
                    <Rows>
                        <kspwc:BindRow DataField="prijmeni" Text="[%Příjmení%]" />
                        <kspwc:BindRow DataField="jmeno" Text="[%Jméno%]" />
                        <kspwc:BindRow DataField="rodne_prijmeni" Text="[%Rodné příjmení%]" />
                        <kspwc:BindRow DataField="vztah" Text="[%Vztah%]" />
                        <kspwc:BindRow DataField="misto_narozeni" Text="[%Místo narození%]" />
                        <kspwc:BindRow DataField="st_prisl" Text="[%Státní příslušnost%]" />
                    </Rows>
                </kspwc:BindTable>
                <br />
                <kspwc:BindTable ID="BindTable7" runat="server" HeaderText="[%Trvalé bydliště%]"
                    Width="300px">
                    <TextFieldStyle Width="100px" />
                    <Rows>
                        <kspwc:BindRow DataField="ulice_trv" Text="[%Ulice%]" />
                        <kspwc:BindRow DataField="misto_trv" Text="[%Místo%]" />
                        <kspwc:BindRow DataField="psc_trv" Text="[%PSČ%]" />
                    </Rows>
                </kspwc:BindTable>
            </ItemTemplate>
        </kspwc:TDataList>
    </asp:Panel>
</asp:Content>--%>
