/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.datetimepicker.min",["kendo.datepicker.min","kendo.timepicker.min","kendo.html.button.min"],function(){var e={id:"datetimepicker",name:"DateTimePicker",category:"web",description:"The DateTimePicker allows the end user to select a value from a calendar or a time drop-down list.",depends:["datepicker","timepicker"]},v=window.kendo.jQuery,u=void 0,_=window.kendo,V=_.TimeView,n=_.html,g=_.parseDate,i=_.support,a=_._activeElement,o=_._extractFormat,t=_.calendar,y=t.isInRange,T=t.restrictValue,h=t.isEqualDatePart,s=V.getMilliseconds,l=_.ui,d=l.Widget,x="open",D="close",I="change",r=".kendoDateTimePicker",p="click"+r,m=i.mouseAndTouchPresent?_.applyEventMap("up",r.slice(1)):p,C="disabled",P="readonly",A="k-focus",S="k-hover",F="k-disabled",M="mouseenter"+r+" mouseleave"+r,R="mousedown"+r,z="month",H="<span/>",O="aria-activedescendant",E="aria-expanded",c="aria-hidden",B="aria-disabled",N="aria-readonly",f=Date,w=new f(1800,0,1),k=new f(2099,11,31),Y={view:"date"},q={view:"time"},b=v.extend,W='<div class="k-date-tab k-datetime-wrap">'+'<div class="k-datetime-buttongroup">'+'<div class="k-button-group k-button-group-stretched">'+'<button class="k-button #=buttonSize# k-rounded-md k-button-solid k-button-solid-base k-selected k-group-start">'+'<span class="k-button-text">#=messages.date#</span>'+"</button>"+'<button class="k-button #=buttonSize# k-rounded-md k-button-solid k-button-solid-base k-group-end">'+'<span class="k-button-text">#=messages.time#</span>'+"</button>"+"</div>"+"</div>"+'<div class="k-datetime-selector">'+'<div class="k-datetime-calendar-wrap">'+"</div>"+'<div class="k-datetime-time-wrap">'+"</div>"+"</div>"+'<div class="k-datetime-footer k-action-buttons">'+'<button class="k-button #=buttonSize# k-rounded-md k-button-solid k-button-solid-base k-time-cancel" title="Cancel" aria-label="Cancel">'+'<span class="k-button-text">#=messages.cancel#</span>'+"</button>"+'<button class="k-time-accept k-button #=buttonSize# k-rounded-md k-button-solid k-button-solid-primary" title="Set" aria-label="Set">'+'<span class="k-button-text">#=messages.set#</span>'+"</button>"+"</div>"+"</div>",j="k-selected",K=d.extend({init:function(t,e){var i=this,a,n;e=e||{};e.componentType=e.componentType||"classic";d.fn.init.call(i,t,e);t=i.element;e=i.options;e.disableDates=_.calendar.disabled(e.disableDates);e.min=g(t.attr("min"))||g(e.min);e.max=g(t.attr("max"))||g(e.max);if(+e.max!=+k||+e.min!=+w)this._specifiedRange=true;G(e);i._initialOptions=b({},e);i._wrapper();if(e.singlePopup)i._popup();i._views();i._icons();i._reset();i._template();try{t[0].setAttribute("type","text")}catch(e){t[0].type="text"}t.addClass("k-input-inner").attr({role:"combobox","aria-expanded":false,"aria-haspopup":"grid","aria-controls":i.dateView._dateViewID+" "+i.timeView._timeViewID,autocomplete:"off"});i._midnight=i._calculateMidnight(e.min,e.max);a=t.is("[disabled]")||v(i.element).parents("fieldset").is(":disabled");if(a)i.enable(false);else i.readonly(t.is("[readonly]"));n=g(e.value||i.element.val(),e.parseFormats,e.culture);i._createDateInput(e);i._old=i._update(n||i.element.val());i._oldText=t.val();i._applyCssClasses();_.notify(i)},options:{name:"DateTimePicker",value:null,format:"",timeFormat:"",culture:"",parseFormats:[],dates:[],disableDates:null,min:new f(w),max:new f(k),interval:30,height:200,footer:"",start:z,depth:z,animation:{},month:{},ARIATemplate:"Current focused #=data.valueType# is #=data.text#",dateButtonText:"Open the date view",timeButtonText:"Open the time view",dateInput:false,weekNumber:false,messages:{set:"Set",cancel:"Cancel",hour:"hour",minute:"minute",second:"second",millisecond:"millisecond",now:"Now",date:"Date",time:"Time",today:"Today",weekColumnHeader:""},componentType:"classic",size:"medium",fillMode:"solid",rounded:"medium"},events:[x,D,I],componentTypes:{classic:{singlePopup:false,timeView:{list:"list"}},modern:{singlePopup:true,timeView:{list:"scroll"}}},setOptions:function(e){var t=this,i=t._value,a,n,o;d.fn.setOptions.call(t,e);e=t.options;e.min=a=g(e.min);e.max=n=g(e.max);G(e);t._midnight=t._calculateMidnight(e.min,e.max);o=e.value||t._value||t.dateView._current;if(a&&!h(a,o))a=new f(w);if(n&&!h(n,o))n=new f(k);t._dateIcon.off(r);t._dateIcon.remove();t._timeIcon.off(r);t._timeIcon.remove();t.dateView.setOptions(e);t.timeView.setOptions(b({},e,{format:e.timeFormat,min:a,max:n}));t._icons();t._editable(e);t._createDateInput(e);if(!t._dateInput)t.element.val(_.toString(i,e.format,e.culture));if(i)t._updateARIA(i)},_editable:function(e){var t=this,i=t.element.off(r),a=t._dateIcon.off(r),n=t._timeIcon.off(r),o=t.wrapper.off(r),s=e.readonly,l=e.disable;if(!s&&!l){o.removeClass(F).on(M,t._toggleHover);if(i&&i.length){i[0].removeAttribute(C);i[0].removeAttribute(P,false);i[0].removeAttribute(B,false);i[0].removeAttribute(N,false)}i.on("keydown"+r,t._keydown.bind(t)).on("focus"+r,function(){t.wrapper.addClass(A)}).on("focusout"+r,function(){t.wrapper.removeClass(A);if(i.val()!==t._oldText){t._change(i.val());if(!i.val())t.dateView.current(_.calendar.getToday())}if(t.options.singlePopup)return;t.close("date");t.close("time")});a.on(R,Q).on(m,function(e){t.toggle("date");t._focusElement(e.type)});n.on(R,Q).on(m,function(e){t.toggle("time");t._focusElement(e.type)})}else{o.addClass(l?F:"").removeClass(l?"":F);i.attr(C,l).attr(P,s).attr(B,l).attr(N,s)}},_focusElement:function(e){var t=this.element;if((!i.touch||i.mouseAndTouchPresent&&!(e||"").match(/touch/i))&&t[0]!==a())t.trigger("focus")},readonly:function(e){this._editable({readonly:e===u?true:e,disable:false})},enable:function(e){this._editable({readonly:false,disable:!(e=e===u?true:e)})},destroy:function(){var e=this;d.fn.destroy.call(e);e.dateView.destroy();e.timeView.destroy();if(e.options.singlePopup){e.popup.element.off(r);e.popup.destroy()}e.element.off(r);e._dateIcon.off(r);e._timeIcon.off(r);e.wrapper.off(r);if(e._form)e._form.off("reset",e._resetHandler)},close:function(e){var t=this;if(t.options.singlePopup)t.popup.close();else{if(e!=="time")e="date";t[e+"View"].close()}setTimeout(function(){t.element.removeAttr("aria-activedescendant")})},open:function(e){var t=this;var i;if(t.options.singlePopup){t.dateView._calendar();if(t.timeView.ul.find("li").length<1)t.timeView.bind();i=t.popup._hovered;t.popup._hovered=true;t.popup.open();if(e==="time")t._switchToTimeView();else t._switchToDateView();this._dateIcon.toggle(e!=="time");this._timeIcon.toggle(e==="time");setTimeout(function(){t.popup._hovered=i},1)}else{if(e!=="time")e="date";this[e+"View"].open()}},min:function(e){return this._option("min",e)},max:function(e){return this._option("max",e)},toggle:function(e){if(this.options.singlePopup)if(this.popup.visible())this.close();else this.open(e);else{var t="timeView";if(e!=="time")e="date";else t="dateView";this[e+"View"].toggle();this[t].close()}},value:function(e){var t=this;if(e===u)return t._value;t._old=t._update(e);if(t._old===null)if(t._dateInput)t._dateInput.value(t._old);else t.element.val("");t._oldText=t.element.val()},_change:function(e){var t=this,i=t.element.val(),a;e=t._update(e);a=+t._old!=+e;var n=a&&!t._typing;var o=i!==t.element.val();if(n||o)t.element.trigger(I);if(a){t._old=e;t._oldText=t.element.val();t.trigger(I)}t._typing=false},_option:function(e,t){var i=this;var a=i.options;var n=i.timeView;var o=n.options;var s=i._value||i._old;var l;var r;if(t===u)return a[e];t=g(t,a.parseFormats,a.culture);o.maxSet=false;if(!t)return;if(a.min.getTime()===a.max.getTime())o.dates=[];a[e]=new f(t.getTime());i.dateView[e](t);i._midnight=i._calculateMidnight(a.min,a.max);if(s){l=h(a.min,s);r=h(a.max,s)}if(l||r){o[e]=t;if(l&&!r)o.max=L(a.interval);if(r)if(i._midnight){n.dataBind([k]);return}else if(!l){o.min=w;o.maxSet=true}}else{o.max=k;o.min=w}n.bind()},_toggleHover:function(e){v(e.currentTarget).toggleClass(S,e.type==="mouseenter")},_update:function(e){var t=this,i=t.options,a=i.min,n=i.max,o=i.dates,s=t.timeView,d=t._value,l=g(e,i.parseFormats,i.culture),p=l===null&&d===null||l instanceof Date&&d instanceof Date,r,u,m,c,f;if(i.disableDates&&i.disableDates(l)){l=null;if(!t._old&&!t.element.val())e=null}if(+l===+d&&p){f=_.toString(l,i.format,i.culture);if(f!==e){t.element.val(l===null?e:f);if(e instanceof String)t.element.trigger(I)}return l}if(l!==null&&h(l,a))l=T(l,a,n);else if(!y(l,a,n))l=null;t._value=l;s.value(l);t.dateView.value(l);if(l){m=t._old;u=s.options;u.maxSet=false;if(o[0]){o=v.grep(o,function(e){return h(l,e)});if(o[0]){s.dataBind(o);c=true}}if(!c){if(h(l,a)){u.min=a;u.max=L(i.interval);r=true}if(h(l,n))if(t._midnight){s.dataBind([k]);c=true}else{u.max=n;u.maxSet=true;if(!r)u.min=w;r=true}}if(!c&&(!m&&r||m&&!h(m,l))){if(!r){u.max=k;u.min=w}s.bind()}}if(t._dateInput){if(l)t._dateInput.value(l)}else t.element.val(_.toString(l||e,i.format,i.culture));t._updateARIA(l);return l},_keydown:function(e){var t=this,i=t.dateView,a=t.timeView,n=t.element.val(),o=t.options.singlePopup?t.popup.visible():i.popup.visible();var s=t._dateInput&&e.stopImmediatePropagation;if(e.altKey&&e.keyCode===_.keys.DOWN)t.toggle(o?"time":"date");else if(o){i.move(e);t._updateARIA(i._current);if(e.keyCode===_.keys.ENTER)t.toggle("time")}else if(!t.options.singlePopup&&a.popup.visible())a.move(e);else if(e.keyCode===_.keys.ENTER&&n!==t._oldText)t._change(n);else{t._typing=true;s=false}if(s)e.stopImmediatePropagation()},_views:function(){var i=this,a=i.element,n=i.options,e=a.attr("id"),o,t,s,l,r,u,d,p,m;if(n.singlePopup){n.dateDiv=i.popup.element.find(".k-datetime-calendar-wrap");d=i.popup.element.find(".k-datetime-time-wrap");n.omitPopup=p=true;m=n.timeView}i.dateView=o=new _.DateView(b({},n,{id:e,anchor:i.wrapper,change:function(){var e=i._applyDateValue();if(n.singlePopup){if(!i.timeView._currentlySelected)i.timeView._currentlySelected=new Date;i.timeView._currentlySelected.setFullYear(e.getFullYear());i.timeView._currentlySelected.setMonth(e.getMonth());i.timeView._currentlySelected.setDate(e.getDate());i._switchToTimeView();i._toggleIcons()}else{i._change(e);i.close("date")}},close:function(e){if(i.trigger(D,Y))e.preventDefault();else{a.attr(E,false);s.attr(c,true)}},open:function(e){if(i.trigger(x,Y))e.preventDefault();else{if(a.val()!==i._oldText){u=g(a.val(),n.parseFormats,n.culture);i.dateView[u?"current":"value"](u)}s.attr(c,false);a.attr(E,true);i._updateARIA(u)}}}));s=o.div;r=n.min.getTime();i.timeView=t=new V({id:e,value:n.value,size:n.size,anchor:i.wrapper,animation:n.animation,format:n.timeFormat,culture:n.culture,height:n.componentType==="modern"?null:n.height,interval:n.interval,min:n.componentType==="modern"?n.min:new f(w),max:n.componentType==="modern"?n.max:new f(k),dates:r===n.max.getTime()?[new Date(r)]:[],parseFormats:n.parseFormats,validateDate:true,change:function(e,t){e=i._applyTimeValue(e);if(t){i._timeSelected=true;i._change(e)}else{a.val(_.toString(e,n.format,n.culture));o.value(e);i._updateARIA(e)}},close:function(e){if(i.trigger(D,q))e.preventDefault();else{l.attr(c,true);a.attr(E,false)}},open:function(e){if(i.options.componentType!=="modern")t._adjustListWidth();else i.timeView._updateTitle();if(i.trigger(x,q))e.preventDefault();else{if(a.val()!==i._oldText){u=g(a.val(),n.parseFormats,n.culture);i.timeView.value(u)}l.attr(c,false);a.attr(E,true);t.options.active(t.current())}},active:function(e){if(a&&a.length)a[0].removeAttribute(O);if(e)a.attr(O,t._optionID)},popup:n.popup,useValueToRender:true,specifiedRange:i._specifiedRange,omitPopup:p,timeDiv:d,timeView:m,messages:i.options.messages});l=t.ul},_applyDateValue:function(){var e=this;var t=e.options;var i=e.dateView;var a=i.calendar.value();var n=+a;var o=+t.min;var s=+t.max;var l,r;if(n===o||n===s){l=n===o?o:s;l=new f(e._value||l);l.setFullYear(a.getFullYear(),a.getMonth(),a.getDate());if(y(l,o,s))a=l}if(e._value){r=_.date.setHours(new Date(a),e._value);if(y(r,o,s))a=r}return a},_applyTimeValue:function(e){var t=this.timeView;var i=this.options;e=t._parse(e);if(e<i.min){e=new f(+i.min);t.options.min=e}else if(e>i.max){e=new f(+i.max);t.options.max=e}return e},_icons:function(){var e=this;var t=e.element;var i=e.options;var a;a=e.wrapper.find("button.k-input-button");if(!a[0]){e._dateIcon=v(n.renderButton('<button unselectable="on" tabindex="-1" class="k-input-button" aria-label="'+i.dateButtonText+'"></button>',{icon:"calendar",size:i.size,fillMode:i.fillMode,shape:"none",rounded:"none"})).insertAfter(t);e._timeIcon=v(n.renderButton('<button unselectable="on" tabindex="-1" class="k-input-button" aria-label="'+i.timeButtonText+'"></button>',{icon:"clock",size:i.size,fillMode:i.fillMode,shape:"none",rounded:"none"})).insertAfter(t)}if(i.singlePopup)e._timeIcon.hide()},_wrapper:function(){var e=this,t=e.element,i;i=t.parents(".k-datetimepicker");if(!i[0])i=t.wrap(H).parent();i[0].style.cssText=t[0].style.cssText;t.css({width:"100%",height:t[0].style.height});e.wrapper=i.addClass("k-datetimepicker k-input").addClass(t[0].className).removeClass("input-validation-error")},_reset:function(){var e=this,t=e.element,i=t.attr("form"),a=i?v("#"+i):t.closest("form"),n=e.options,o=n.disableDates,s=n.parseFormats.length?n.parseFormats:null,l=e._initialOptions.value,r=t[0].defaultValue;if(l&&(o&&o(l)))l=null;if((!r||!_.parseDate(r,s,n.culture))&&l)t.attr("value",_.toString(l,n.format,n.culture));if(a[0]){e._resetHandler=function(){e.value(l||t[0].defaultValue);e.max(e._initialOptions.max);e.min(e._initialOptions.min)};e._form=a.on("reset",e._resetHandler)}},_template:function(){this._ariaTemplate=_.template(this.options.ARIATemplate).bind(this)},_createDateInput:function(e){if(this._dateInput){this._dateInput.destroy();this._dateInput=null}if(e.dateInput)this._dateInput=new l.DateInput(this.element,{culture:e.culture,format:e.format,size:e.size,fillMode:e.fillMode,rounded:e.rounded,min:e.min,max:e.max,interval:e.interval})},_calculateMidnight:function(e,t){return s(e)+s(t)===0},_updateARIA:function(e){var t=this;var i=t.dateView.calendar;if(t.element&&t.element.length)t.element[0].removeAttribute(O);if(i)t.element.attr(O,i._updateAria(t._ariaTemplate,e))},_popup:function(){var t=this;var e=t.options;var i=v("<div></div>").attr(c,"true").addClass("k-datetime-container k-group k-reset").appendTo(document.body);i.append(_.template(W)(b({},t.options,{buttonSize:_.getValidCssClass("k-button-","size",t.options.size)})));t.popup=new l.Popup(i,b(e.popup,e,{name:"Popup",isRtl:_.support.isRtl(t.wrapper),anchor:t.wrapper,activate:function(){if(t.options.timeView&&t.options.timeView.list==="scroll"){t.timeView.addTranslate();t.timeView.applyValue(t._value);t.timeView._updateRanges()}},open:function(e){if(t.trigger(x,{view:this.element.find(".k-date-tab").length?"date":"time",sender:t}))e.preventDefault();t.timeView._updateTitle()}}));i.on(p+r,".k-datetime-buttongroup .k-button",t._groupChangeClick.bind(t));i.on(p+r,".k-datetime-footer button.k-time-cancel",t._cancelClickHandler.bind(t));i.on(p+r,".k-datetime-footer button.k-time-accept",t._setClickHandler.bind(t))},_groupChangeClick:function(e){Q(e);var t=v(e.currentTarget);var i=t.index();if(i)this._switchToTimeView();else this._switchToDateView();this._toggleIcons()},_switchToDateView:function(){this.popup.element.find(".k-group-start, .k-group-end").removeClass(j).eq(0).addClass(j);this.popup.element.find(".k-datetime-wrap").removeClass("k-time-tab").addClass("k-date-tab")},_switchToTimeView:function(){this.timeView.addTranslate();this.timeView.applyValue(this._value);this.timeView._updateRanges();this.popup.element.find(".k-group-start, .k-group-end").removeClass(j).eq(1).addClass(j);this.popup.element.find(".k-datetime-wrap").removeClass("k-date-tab").addClass("k-time-tab")},_toggleIcons:function(){this._dateIcon.toggle();this._timeIcon.toggle()},_cancelClickHandler:function(e){Q(e);if(this._value){this.value(this._value);this.dateView.value(this._value)}this.popup.close()},_setClickHandler:function(e){Q(e);var t=this._applyDateValue();var i;t=t||new Date;i=this.timeView._currentlySelected||t;this.timeView._updateCurrentlySelected();t.setHours(i.getHours());t.setMinutes(i.getMinutes());t.setSeconds(i.getSeconds());t=this._applyTimeValue(t);this._change(t);this.popup.close()}});function L(e){var t=new Date(2100,0,1);t.setMinutes(-e);return t}function Q(e){e.preventDefault()}function G(e){var t=_.getCulture(e.culture).calendars.standard.patterns,i=!e.parseFormats.length,a;e.format=o(e.format||t.g);e.timeFormat=a=o(e.timeFormat||t.t);_.DateView.normalize(e);if(i)e.parseFormats.unshift("yyyy-MM-ddTHH:mm:ss");if(v.inArray(a,e.parseFormats)===-1)e.parseFormats.push(a)}return _.cssProperties.registerPrefix("DateTimePicker","k-input-"),_.cssProperties.registerValues("DateTimePicker",[{prop:"rounded",values:_.cssProperties.roundedValues.concat([["full","full"]])}]),l.plugin(K),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,i){(i||t)()});
//# sourceMappingURL=kendo.datetimepicker.min.js.map
