﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="BulletinListEditItem.ascx.cs" Inherits="KSPortal.Bulletin.BulletinListEditItem" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<style type="text/css">
    div.ksBlFotoE {
        height: 120px !important;
        margin-top: 6px;
        width: 95px !important;
    }

    .ksBlFotoERau {
        position: absolute;
    }

    .ksRau1 {
        top: 0px;
    }
    .ksRau2 {
        top: 65px;
    }

    .ksBlFotoERau:hover {
        width: fit-content !important;
        z-index: 100;
        background-color: white;
    }

    .ksBlFotoERau:hover > div {
        width: fit-content !important;
    }
</style>

<telerik:RadAjaxManagerProxy runat="server" ID="RAMP_BLEI_item">
    <AjaxSettings>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>
<div class="hidden">
    <asp:Label runat="server" ID="L_Title" Text="[%Chybí adresát%]"></asp:Label>
    <asp:Label runat="server" ID="L_Text" Text="[%Nebyl vybrán žádný adresát vývěsky. V takovém případě bude vývěska zobrazena všem.<br><br>Opravdu si přejete, aby tuto vývěsku viděli úplně všichni?%]"></asp:Label>
</div>
<telerik:RadScriptBlock runat="server" ID="RSB_blei_item">
    <script type="text/javascript">
        function RMS_adresats_OnChange(sender, args) {
            var HF = $get("<%=HF_adresati.ClientID %>");
            HF.value = sender.get_value()?.join(',');

        }

        function adresatCheck(sender, args) {
            var HF = $get("<%=HF_adresati.ClientID %>");
            var text = $get("<%=L_Text.ClientID %>")?.innerHTML;
            var title = $get("<%=L_Title.ClientID %>")?.innerHTML;

            if (HF.value.length == 0) {
                radconfirm(text, function (userConfirmed) {
                    if (userConfirmed) {
                        __doPostBack(sender.get_element().name, args.get_commandName());
                    }
                }, 0, 0, null, title);

                args.set_cancel(true);
            }
        }

    </script>
</telerik:RadScriptBlock>
<asp:HiddenField runat="server" ID="HF_adresati" />
<fieldset class="ksBlFs">
    <div class="ksBlBull">
        <div>
            <div>
                <div class="ksBlFotoE">
                    <fieldset class="ksBlFsEi ksBlFotoERau ksRau1">
                        <legend>[%Obrázek%]</legend>
                        <telerik:RadAsyncUpload runat="server" ID="RAU_e_image" HideFileInput="true" AllowedFileExtensions=".jpeg,.jpg,.png"
                            Width="80" MultipleFileSelection="Disabled" MaxFileInputsCount="1" OnFileUploaded="RAU_e_image_FileUploaded"
                            TemporaryFolder="~/Temp">
                            <FileFilters>
                                <telerik:FileFilter Extensions=".jpeg,.jpg,.png" />
                            </FileFilters>
                        </telerik:RadAsyncUpload>
                    </fieldset>
                    <fieldset class="ksBlFsEi ksBlFotoERau ksRau2">
                        <legend>[%Příloha%]</legend>
                        <telerik:RadAsyncUpload runat="server" ID="RadAsyncUpload1" HideFileInput="true" Width="80"
                            MultipleFileSelection="Disabled" MaxFileInputsCount="1" OnFileUploaded="RAU_e_attachment_FileUploaded"
                            OnInit="RadAsyncUpload1_Init"
                            TemporaryFolder="~/Temp">
                        </telerik:RadAsyncUpload>
                    </fieldset>
                </div>
            </div>
            <div>
                <fieldset class="ksBlFsEi">
                    <legend>[%Záhlaví%]</legend>
                    <p>
                        <telerik:RadTextBox runat="server" ID="RTB_e_nadpis" EmptyMessage="[%Nadpis%]" MaxLength="120" Text='<%# Bind("nadpis") %>' InputType="Text" Width="100%" TextMode="MultiLine" Rows="2" Wrap="true">
                            <ClientEvents OnKeyPress="RTB_e_text_KeyPress" />
                        </telerik:RadTextBox>
                        <asp:RequiredFieldValidator runat="server" ID="RFV_nadpis" Display="Dynamic" EnableClientScript="true" ControlToValidate="RTB_e_nadpis"></asp:RequiredFieldValidator>
                    </p>
                    <p>
                        <telerik:RadTextBox runat="server" ID="RTB_e_telo" EmptyMessage="[%Text%]" MaxLength="500" Text='<%# Bind("telo") %>' InputType="Text" Width="100%" TextMode="MultiLine" Rows="4" Wrap="true" OnKeyPress="RTB_e_text_KeyPress"></telerik:RadTextBox>
                    </p>
                </fieldset>
                <fieldset class="ksBlFsEi">
                    <legend>[%Adresáti%]</legend>
                    <telerik:RadMultiSelect runat="server" ID="RMS_e_adresats" Filter="Contains" Skin="Metro" CssClass="ksBlMultiSelect"
                        AutoClose="false" DataValueField="key" DataTextField="nazev" Width="100%" AutoWidth="true">
                        <ClientEvents OnChange="RMS_adresats_OnChange" OnDataBound="RMS_adresats_OnChange" />
                        <WebServiceClientDataSource runat="server" AutoSync="true">
                            <WebServiceSettings>
                                <Select Url="../WebServices/AutoCompleteService.asmx/GetAdresatsOfBulletins" RequestType="Post" DataType="JSON" ContentType="application/json; charset=utf-8" />
                            </WebServiceSettings>
                            <GroupExpressions>
                                <telerik:ClientDataSourceGroupExpression FieldName="nazev_typ" />
                            </GroupExpressions>
                            <Schema DataName="d">
                                <Model>
                                    <%-- ID neoznačuje id modelu ale sloupec obsahující klíč--%>
                                    <telerik:ClientDataSourceModelField FieldName="typ_org_j" DataType="Number" Editable="False" Nullable="false" />
                                    <telerik:ClientDataSourceModelField FieldName="org_j" DataType="String" Editable="False" />
                                    <telerik:ClientDataSourceModelField FieldName="nazev" DataType="String" Editable="False" />
                                    <telerik:ClientDataSourceModelField FieldName="nazev_typ" DataType="String" Editable="False" />
                                    <telerik:ClientDataSourceModelField FieldName="key" DataType="String" Editable="False" />
                                </Model>
                            </Schema>
                        </WebServiceClientDataSource>
                    </telerik:RadMultiSelect>
                </fieldset>
                 <fieldset class="ksBlFsEi">
                    <legend>[%Text tlačítka%]</legend>
                    <p>
                        <telerik:RadTextBox runat="server" ID="RTB_tlacitko_text" EmptyMessage="[%Text tlačítka%]" MaxLength="120" Text='<%# Bind("tlacitko") %>' InputType="Text" Width="100%" TextMode="MultiLine" Rows="2" Wrap="true"></telerik:RadTextBox>
                    </p>
                </fieldset>
            </div>
            <div>
                <fieldset class="ksBlFsEi">
                    <legend>[%Publikování%]</legend>
                    <kspwc:TRadDatePicker runat="server" ID="TRDP_e_od" SelectedDate='<%# Bind("datum_od") %>'>
                        <DateInput EmptyMessage="[%Publikovat od%]"></DateInput>
                    </kspwc:TRadDatePicker>
                    <kspwc:TRadDatePicker runat="server" ID="TRDP_e_do" SelectedDate='<%# Bind("datum_do") %>'>
                        <DateInput EmptyMessage="[%Publikovat do%]"></DateInput>
                    </kspwc:TRadDatePicker>
                    <div>
                        <kspwc:TRadButton runat="server" ID="TRB_e_publikovat" AutoPostBack="false" ButtonType="StandardButton" ToggleType="CheckBox" Checked='<%# Bind("Publikovano") %>'>
                            <ToggleStates>
                                <telerik:RadButtonToggleState Text="[%Je publikováno%]" />
                                <telerik:RadButtonToggleState Text="[%Není publikováno%]" />
                            </ToggleStates>
                        </kspwc:TRadButton>
                    </div>
                </fieldset>
            </div>
        </div>
        <div class="ksBlButtEdit">
            <kspwc:TRadButton runat="server" ID="TRB_update" ButtonType="StandardButton" CommandName="Update" ToolTip="[%Uloží změny%]" ConfirmText="[%Uložit změny?%]" Text="[%Uložit%]" Visible='<%# !IsInsert %>'
                OnClientClicked="adresatCheck">
                <Icon PrimaryIconCssClass="fi fi-disk" />
            </kspwc:TRadButton>
            <kspwc:TRadButton runat="server" ID="TRB_insert" ButtonType="StandardButton" CommandName="PerformInsert" ToolTip="[%Vloží nový záznam%]" ConfirmText="[%Vložit nový záznam%]?" Text="[%Vložit%]" Visible='<%# IsInsert %>'
                OnClientClicked="adresatCheck">
                <Icon PrimaryIconCssClass="fi fi-disk" />
            </kspwc:TRadButton>
            <kspwc:TRadButton runat="server" ID="TRB_e_cancel" CssClass="CancelEditSelector" ButtonType="StandardButton" CommandName="Cancel" ToolTip="[%Zpět%]" ConfirmText="[%Zahodit změny bez uložení%]?" Text="[%Zrušit%]" CausesValidation="false">
                <Icon PrimaryIconCssClass="fi fi-ban" />
            </kspwc:TRadButton>
        </div>
    </div>

</fieldset>
