﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="DanProhl_KS_2021.ascx.cs" Inherits="KSPortal.Controls.DanProhl_KS_2021" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="kspwc" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<telerik:RadScriptBlock ID="DanProh_RadScriptBlock1" runat="server">
    <script language="javascript" type="text/javascript">    
        function On_H_vyz_jin_popl_Clicked(sender, args) {
            console.info("On_H_vyz_jin_popl_Clicked");
            //var oldItem = sender.get_items()[args.get_oldSelectedIndex()];
            //var newItem = sender.get_items()[args.get_newSelectedIndex()];
            var value = args.get_item().get_value();
            console.info("On_H_vyz_jin_popl_Clicked - value = " + value);
            //alert(value);

            if (value == "X") {
                try {
                    //vybrání 2. řádku z DDL_manzelka, kde je 1. osoba, proběhne postback, který naplní pole
                    $find('<%=FormView1.FindControl("DDL_manzelka").ClientID%>').get_items().getItem(1).select();
            } catch (e) { }
        }
        else {//vyprázdnění polí
            //vybrání 1. prázdného řádku z DDL_manzelka, proběhne postback, který by měl vyprázdnit pole
            $find('<%=FormView1.FindControl("DDL_manzelka").ClientID%>').get_items().getItem(0).select();

            $find('<%=FormView1.FindControl("H_vyz_jin_upl").ClientID%>').get_items().getItem(0).select();
            $find('<%=FormView1.FindControl("H_vyz_jin_zam").ClientID%>').get_items().getItem(0).select();

            <%-- tohle se předvyplní na serveru DDL_manzelka_SelectedIndexChanged
            document.getElementById('<%=FormView1.FindControl("H_vyz_jin_jmeno").ClientID%>').value="";
            document.getElementById('<%=FormView1.FindControl("H_vyz_jin_prijmeni").ClientID%>').value="";
            document.getElementById('<%=FormView1.FindControl("H_vyz_jin_rc").ClientID%>').value="";
            // Adresa manželky
            document.getElementById('<%=FormView1.FindControl("H_obec_vyz_jin").ClientID%>').value="";
            document.getElementById('<%=FormView1.FindControl("H_ulice_vyz_jin").ClientID%>').value="";
            document.getElementById('<%=FormView1.FindControl("H_c_pop_vyz_jin").ClientID%>').value="";
            //document.getElementById('<%=FormView1.FindControl("H_c_orient_vyz_jin").ClientID%>').value="";
            document.getElementById('<%=FormView1.FindControl("H_psc_vyz_jin").ClientID%>').value="";--%>
            //----------------------------------------------
            // Název plátce daně manželky
            //----------------------------------------------
            document.getElementById('<%=FormView1.FindControl("H_vyz_jin_naz_platce").ClientID%>').value = "";
            //----------------------------------------------
            // Plátce daně manželky - adresa
            //----------------------------------------------
            document.getElementById('<%=FormView1.FindControl("H_obec_vyz_jin_pl").ClientID%>').value = "";
            document.getElementById('<%=FormView1.FindControl("H_ulice_vyz_jin_pl").ClientID%>').value = "";
            document.getElementById('<%=FormView1.FindControl("H_c_pop_vyz_jin_pl").ClientID%>').value = "";
            //document.getElementById('<%=FormView1.FindControl("H_c_orien_vyz_jin_pl").ClientID%>').value="";
            document.getElementById('<%=FormView1.FindControl("H_psc_vyz_jin_pl").ClientID%>').value = "";
            }
        }

        function confirm_upl_sleva_ne(args) {
            if (args) {
                var HF_sleva_opravdu_ne = document.getElementById('<%=FormView1.FindControl("HF_sleva_opravdu_ne").ClientID%>');
            HF_sleva_opravdu_ne.value = "1";
            var button = $get("<%=WebControlHelper.FindControl(Page, "img_save").ClientID %>");
                button.click(true);
            }
        }

        function H_upl_OnRadioClientClicked(sender, args) {
            var selectedvalue = sender.get_value();
            var id = sender.get_element().id;
            id = id.replace("_RB0_", "_H_");
            id = id.replace("_RBX_", "_H_");
            id = id.replace("_RBD_", "_H_");
            document.getElementById(id).value = selectedvalue;
            ShowHidePotvSleva(id);
        }

        function D_upl_por_SelectedIndexChanged(sender, args) {
            var id = sender.get_element().id;
            ShowHidePotvZvyhodneni(id);
        }

        var priloha_tx;
        function Zadost_OnClientFileUploaded(filename) {
            try {
                //alert("Zadost_OnClientFileUploaded: " + filename);
                priloha_tx.value = filename;
                //alert("priloha_tx.id=" + priloha_tx.id + ", priloha_tx.value=" + priloha_tx.value);
            } catch (e) {
                console.error(e.message);
            }
        }
        function Zadost_OnClientFileDeleted(filename) {
            alert("Zadost_OnClientFileDeleted: " + filename);
            
        }
        function PridatPrilohu(sender) {
            //alert("PridatPrilohu - sender.id = " + sender.id);
            priloha_tx = sender.previousElementSibling;
            //alert("priloha_tx.id=" + priloha_tx.id + ", priloha_tx.value=" + priloha_tx.value);
            showPrilohu();//funkce z PrilohyManager
        }
        function ShowHidePotvSleva(id) {
            var H_sleva;
            if (id.indexOf('FormView1') >= 0) {
                H_sleva = $get(id);
                id = id.substr(id.indexOf('H_upl_'));
            }
            else
                H_sleva = $("input:hidden[id$='" + id + "']")[0];
            var tx = $get(id + '_file');
            var btn = $get(id.replace('H_', 'B_'));
            if (H_sleva.value == '') {
                tx.style.display = 'none';
                btn.style.display = 'none';
            }
            else {
                tx.style.display = 'unset';
                btn.style.display = 'unset';
            }
        }

        function ShowHidePotvZvyhodneni(id) {
            var DDL;
            if (id.indexOf('FormView1') >= 0) {
                DDL = $find(id);
                id = id.substr(id.indexOf('_upl_por') - 2);
            }
            else
                DDL = $("[id$='" + id + "']")[0].control;
            id = id.substr(0, 2);
            var tx = $get(id + '_file');
            var btn = $get('B_' + id);
            var value = DDL._selectedValue;
            if (value == '' || value == '-' || value == 'N') {
                tx.style.display = 'none';
                btn.style.display = 'none';
            }
            else {
                tx.style.display = 'unset';
                btn.style.display = 'unset';
            }
        }
        var gi_rok = <%= WebControlHelper.SubCtrlGetValueString(FormView1, "H_obd_rok") %>;
        function PotvrzeniShowHide() {
            try {
                $("input:text.AddPril").prop("readonly", true);
                ShowHidePotvSleva("H_upl_inv");
                ShowHidePotvSleva("H_upl_inv_roz");
                ShowHidePotvSleva("H_upl_inv_ztp");
                if (gi_rok < 2024) ShowHidePotvSleva("H_upl_stud");                
                ShowHidePotvZvyhodneni("D1_upl_por");
                ShowHidePotvZvyhodneni("D2_upl_por");
                ShowHidePotvZvyhodneni("D3_upl_por");
                ShowHidePotvZvyhodneni("D4_upl_por");
                ShowHidePotvZvyhodneni("D5_upl_por");
            } catch (e) {
                console.error(e.message);
            }
        }
        Sys.Application.add_load(PotvrzeniShowHide);
    </script>
</telerik:RadScriptBlock>


<asp:ObjectDataSource ID="ods_st_prisl" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="Seznam" TypeName="KSProgram.Ciselniky.CisStatniPrisl" EnableCaching="True">
    <SelectParameters>
        <asp:Parameter Name="pridat_prazdny_radek" Type="Boolean" DefaultValue="true" />
        <asp:Parameter Name="nazev_format_string" Type="String" DefaultValue="{kod_znakovy2}&nbsp;&nbsp;{cesky}" />
        <asp:Parameter Name="clen_eu" Type="Boolean" DefaultValue="" />
        <asp:Parameter Name="order_by" Type="String" DefaultValue="kod_znakovy2" />
    </SelectParameters>
</asp:ObjectDataSource>

<asp:ObjectDataSource ID="ODS_manzelky" runat="server" TypeName="KSProgram.Pozadavky.pozadavekdanprohl" SelectMethod="GetManzelkyDruzky" EnableCaching="false">
    <SelectParameters>
        <asp:Parameter Name="osc" DbType="Decimal" />
        <asp:Parameter Name="keDni" DbType="DateTime" />
    </SelectParameters>
</asp:ObjectDataSource>

<style type="text/css">
    .HTMLpage input[type=button].AddPril {
        background-color: lightyellow;
        border: 1px solid silver;
    }

    .HTMLpage input[type=text].AddPril {
        width: 30mm;
        border: none;
    }

        .HTMLpage input[type=text].AddPril:focus {
            border: none !important;
        }

    /*div.RadToolTip_Metro .rtWrapperTopCenter div.rtTitlebar {
        text-transform: none !important;
        background-color: #FFFFCC !important;
    }

    div.RadToolTip_Metro .rtWrapper .rtWrapperContent {
        background-color: #FFFFCC !important;
    }*/

    .HTMLpage {
        direction: ltr;
        padding: 15px;
        margin: 0mm;
        width: 260mm;
        /*border: 1px solid red;*/
        font-family: Arial, Helvetica, sans-serif;
    }

        .HTMLpage > div {
            white-space: nowrap;
            overflow: hidden;
        }

        .HTMLpage > table {
            width: 100%;
            border-collapse: collapse;
            border-spacing: 0mm;
            text-align: left;
            vertical-align: middle;
        }

        .HTMLpage td {
            padding: 5px;
        }

    .Border {
        border: 1px solid silver;
    }

    .HTMLpage .input {
        box-sizing: border-box;
        -moz-box-sizing: border-box;
        -webkit-box-sizing: border-box;
        background: #fff;
        color: black;
        height: 22px;
        font-size: 11px;
        /*font-weight:bold;*/
        vertical-align: middle; /*tímto se srovná bottom-line s RadDropDown*/
        transition: 0.15s;
    }

        .HTMLpage .input:hover {
            border-color: var(--kscolor1);
            border-width: 1px;
        }

        .HTMLpage .input:focus {
            border-color: var(--kscolor1);
            border-width: 1px;
        }

        .HTMLpage .input:disabled {
            background-color: white;
            color: black;
            filter: alpha(opacity=50);
            opacity: 0.5;
        }


    .danprohlNadpis {
        color: var(--kscolor1text);
        background-color: var(--kscolor1);
        font-size: 14px;
        padding: 7px;
    }

    .RadDropDownList_Metro{
        width: fit-content;
        min-width: 50px;
    }

</style>
<span class="tiskHide">
    <asp:CustomValidator runat="server" ID="ValidPre" OnServerValidate="ValidPre_ServerValidate" ValidationGroup="PreValidace"></asp:CustomValidator>
</span>
<asp:FormView ID="FormView1" runat="server" CssClass="noclass" OnItemInserted="FormView1_ItemInserted"
    OnItemUpdated="FormView1_ItemUpdated" OnDataBound="FormView1_DataBound" DataSourceID="ObjectDataSource1">
    <ItemTemplate>

        <div class="HTMLpage">
            <asp:Label ID="TLabel3" runat="server" Text="[%PROHLÁŠENÍ poplatníka daně z příjmů fyzických osob ze závislé činnosti%]" CssClass="nadpis1"></asp:Label>

            <table>
                <tr>
                    <td style="width: 100mm">[%Pro zdaňovací období%] ([%pro část zdaňovacího období%]) 
                    </td>
                    <td style="width: 25mm">
                        <telerik:RadDropDownList ID="H_obd_mes" runat="server" SelectedValue='<%# Bind("H_obd_mes") %>' SkinID="povinne-pole">
                            <Items>
                                <telerik:DropDownListItem Value="" Text=""></telerik:DropDownListItem>
                                <telerik:DropDownListItem Value="1" Text="[%od ledna%]"></telerik:DropDownListItem>
                                <telerik:DropDownListItem Value="2" Text="[%od února%]"></telerik:DropDownListItem>
                                <telerik:DropDownListItem Value="3" Text="[%od března%]"></telerik:DropDownListItem>
                                <telerik:DropDownListItem Value="4" Text="[%od dubna%]"></telerik:DropDownListItem>
                                <telerik:DropDownListItem Value="5" Text="[%od května%]"></telerik:DropDownListItem>
                                <telerik:DropDownListItem Value="6" Text="[%od června%]"></telerik:DropDownListItem>
                                <telerik:DropDownListItem Value="7" Text="[%od července%]"></telerik:DropDownListItem>
                                <telerik:DropDownListItem Value="8" Text="[%od srpna%]"></telerik:DropDownListItem>
                                <telerik:DropDownListItem Value="9" Text="[%od září%]"></telerik:DropDownListItem>
                                <telerik:DropDownListItem Value="10" Text="[%od října%]"></telerik:DropDownListItem>
                                <telerik:DropDownListItem Value="11" Text="[%od listopadu%]"></telerik:DropDownListItem>
                                <telerik:DropDownListItem Value="12" Text="[%od prosince%]"></telerik:DropDownListItem>
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td>
                        <telerik:RadRadioButtonList ID="H_dod_priz" runat="server" SelectedValue='<%# Bind("H_dod_priz") %>' OnSelectedIndexChanged="H_dod_priz_SelectedIndexChanged"
                            SkinID="povinne-pole">
                            <Items>
                                <telerik:ButtonListItem Value="" Text="[%pro aktuální rok%]" ToolTip="[%Pro uplatňování slev každý měsíc při výpočtu mzdy%]"></telerik:ButtonListItem>
                                <telerik:ButtonListItem Value="XD" Text="[%dodatečně pro minulý rok (při RZ)%]" ToolTip="[%Pro uplatnění slev až při ročním zúčtování daně%]"></telerik:ButtonListItem>
                            </Items>
                        </telerik:RadRadioButtonList>
                    </td>
                    <td>
                        <kspwc:TTextBox ID="H_obd_rok" runat="server" Text='<%# Bind("H_obd_rok") %>' 
                            CssClass="input povinne-pole" Style="text-align: center; border: 1px solid silver" Width="15mm" MaxLength="4"
                            AutoPostBack="true" OnTextChanged="H_obd_rok_TextChanged" ></kspwc:TTextBox>
                    </td>
                </tr>
            </table>

            <span class="tiskHide">
                <asp:CustomValidator runat="server" ID="Val_obdobi"></asp:CustomValidator>
            </span>

            <table>
                <tr>
                    <td colspan="7" class="Border danprohlNadpis">[%Identifikace poplatníka%] ([%Kontrola osobních údajů zaměstnance%])
                        <asp:Image ID="Img_polatnik" runat="server" ImageUrl="~/Images/query.png" ImageAlign="Right" />
                        <telerik:RadToolTip ID="RadToolTip6" runat="server"
                            TargetControlID="Img_polatnik"
                            Text="[%Zkontrolujte své osobní údaje a pokud nesouhlasí, požádejte o změnu přes požadavek na změnu osobních údajů.%]"
                            Position="TopLeft" AutoCloseDelay="0" HideDelay="100" ShowDelay="100" Width="250px">
                        </telerik:RadToolTip>
                    </td>
                </tr>
                <tr>
                    <td class="Border">[%Příjmení%] </td>
                    <td class="Border">[%Jméno%] </td>
                    <td class="Border">[%Rodné číslo%] </td>
                    <td class="Border">[%Ulice / část obce%] </td>
                    <td class="Border">[%Číslo pop./orient.%] </td>
                    <td class="Border">[%Obec%] </td>
                    <td class="Border">[%PSČ%] </td>
                </tr>
                <tr>
                    <td class="Border">
                        <kspwc:TTextBox ID="H_prijmeni_pop" runat="server" Text='<%# Bind("H_prijmeni_pop") %>' Width="40mm" CssClass="input" ReadOnly="true"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="H_jmeno_pop" runat="server" Text='<%# Bind("H_jmeno_pop") %>' Width="20mm" CssClass="input" ReadOnly="true"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="H_rc_pop" runat="server" Text='<%# Bind("H_rc_pop") %>' Width="20mm" CssClass="input" ReadOnly="true"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="H_ulice_pop" runat="server" Text='<%# Bind("H_ulice_pop") %>' Width="40mm" CssClass="input" MaxLength="38" ReadOnly="true"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="H_c_pop_pop" runat="server" Text='<%# Bind("H_c_pop_pop") %>' Width="20mm" CssClass="input" MaxLength="6" ReadOnly="true"></kspwc:TTextBox>
                        <kspwc:TTextBox ID="H_c_orient_pop" runat="server" Text='<%# Bind("H_c_orient_pop") %>' Width="12mm" CssClass="input" MaxLength="4" ReadOnly="true" Visible="false"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="H_obec_pop" runat="server" Text='<%# Bind("H_obec_pop") %>' Width="40mm" CssClass="input" MaxLength="48" ReadOnly="true"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="H_psc_pop" runat="server" Text='<%# Bind("H_psc_pop") %>' Width="15mm" CssClass="input" MaxLength="10" ReadOnly="true"></kspwc:TTextBox>
                    </td>
                </tr>
            </table>

            <table>
                <tr>
                    <td colspan="7" class="Border danprohlNadpis">[%Daňový nerezident ČR%]
                        <asp:Image ID="Img_nerezident" runat="server" ImageUrl="~/Images/query.png" ImageAlign="Right" />
                        <telerik:RadToolTip ID="RadToolTip10" runat="server"
                            TargetControlID="Img_nerezident"
                            Text="[%Pokud jste daňový nerezident zkontrolujte následující údaje, které jste sdělil při nástupu%]"
                            Position="TopLeft" AutoCloseDelay="0" HideDelay="100" ShowDelay="100" Width="250px">
                        </telerik:RadToolTip>
                    </td>
                </tr>
                <tr>
                    <td class="Border">[%Datum narození%]</td>
                    <td class="Border">[%Číslo dokladu totožnosti%]</td>
                    <td class="Border">[%Typ dokladu totožnosti%]</td>
                    <td class="Border">[%Stát, který doklad vydal%]</td>
                    <td class="Border">[%Identifikace pro daňové účely%]</td>
                    <td class="Border">[%Stát daňového rezidentství%]</td>
                </tr>
                <tr>
                    <td class="Border">
                        <kspwc:TTextBox ID="H_datNar_pop" runat="server" Text='<%# Bind("H_datNar_pop","{0:d}") %>' Width="29mm" CssClass="input" MaxLength="10"></kspwc:TTextBox>
                    </td>

                    <td class="Border">
                        <kspwc:TTextBox ID="H_c_pasu_pop" runat="server" Text='<%# Bind("H_c_pasu_pop") %>' Width="25mm" CssClass="input" MaxLength="16"></kspwc:TTextBox>
                    </td>

                    <td class="Border">
                        <telerik:RadDropDownList ID="H_typ_dokl_pop" runat="server" SelectedValue='<%# Bind("H_typ_dokl_pop") %>' CssClass="bottomLine" >
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="I" Text="[%Průkaz totožnosti%]" />
                                <telerik:DropDownListItem Value="P" Text="[%Cestovní pas%]" />
                                <telerik:DropDownListItem Value="D" Text="[%Řidičský průkaz%]" />
                                <telerik:DropDownListItem Value="O" Text="[%Ostatní doklady%]" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>

                    <td class="Border">
                        <telerik:RadDropDownList ID="H_stat_pop" runat="server" CssClass="bottomLine" DataSourceID="ods_st_prisl" DataTextField="cely_nazev" DataValueField="kod_znakovy2"
                            SelectedValue='<%# Bind("H_stat_pop") %>'>
                        </telerik:RadDropDownList>
                    </td>

                    <td class="Border">
                        <kspwc:TTextBox ID="H_cis_dident" runat="server" Text='<%# Bind("H_cis_dident") %>' CssClass="input" Width="20mm" MaxLength="20"></kspwc:TTextBox>

                        <telerik:RadDropDownList ID="H_typ_dident" runat="server" CssClass="bottomLine" SelectedValue='<%# Bind("H_typ_dident") %>'>
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="D" Text="[%DIČ%]" />
                                <telerik:DropDownListItem Value="R" Text="[%Rodné číslo%]" />
                                <telerik:DropDownListItem Value="S" Text="[%Sociální pojištění%]" />
                                <telerik:DropDownListItem Value="J" Text="[%Jiné%]" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>

                    <td class="Border">
                        <telerik:RadDropDownList ID="H_stat_dident" runat="server" CssClass="bottomLine" DataSourceID="ods_st_prisl" DataTextField="cely_nazev" DataValueField="kod_znakovy2"
                            SelectedValue='<%# Bind("H_stat_dident") %>'>
                        </telerik:RadDropDownList>
                    </td>
                </tr>
            </table>


            <table>
                <tr>
                    <td colspan="6" class="Border danprohlNadpis">[%Slevy podle § 35ba odst. 1%] ([%Vyberte slevy, které chcete uplatnit. K vybrané slevě následně přiložte potvrzení v pdf, jpg a jn.%])                         
                    </td>
                </tr>
                <tr>
                    <td class="Border">[%Typ slevy%]</td>
                    <td class="Border">[%Neuplatňuji%]</td>
                    <td class="Border">[%Uplatňuji%]</td>
                    <td class="Border">[%Dodatečně uplatňuji%]
                        <asp:Image ID="Img_slevy" runat="server" ImageUrl="~/Images/query.png" ImageAlign="Right" />
                        <telerik:RadToolTip ID="RadToolTip7" runat="server"
                            TargetControlID="Img_slevy"
                            Text="[%Uplatňujete-li slevu na dani až dodatečně, tj. v rámci ročního zúčtování záloh a daňového zvýhodnění, označte volbu „Dodatečně uplatňuji“ a do následujícího políčka uveďte i kalendářní měsíce, za které příslušnou slevu na dani dodatečně uplatňujete (např. „9–12“)%]"
                            Position="TopLeft" AutoCloseDelay="0" HideDelay="100" ShowDelay="100" Width="250px">
                        </telerik:RadToolTip>
                    </td>
                    <td class="Border">[%Dodatečně za měsíce%]</td>
                    <td class="Border">[%Doložte potvrzení%]</td>
                </tr>
                <tr>
                    <td class="Border">[%Základní sleva na poplatníka%]
                        <asp:Image ID="Img_upl_sleva" runat="server" ImageUrl="~/Images/query.png" ImageAlign="Right" />
                        <telerik:RadToolTip ID="RadToolTip2" runat="server"
                            TargetControlID="Img_upl_sleva"
                            Text="[%Tuto slevu si může uplatnit každý poplatník daně%]"
                            Position="TopLeft" AutoCloseDelay="0" HideDelay="100" ShowDelay="100" Width="250px">
                        </telerik:RadToolTip>
                    </td>
                    <td class="Border" style="text-align: center;">
                        <asp:HiddenField ID="H_upl_sleva" runat="server" Value='<%# Eval("H_upl_sleva") %>' />

                        <telerik:RadButton ID="RB0_upl_sleva" AutoPostBack="false" runat="server" GroupName="upl_sleva"
                            OnClientClicked="H_upl_OnRadioClientClicked" ToggleType="Radio" ButtonType="ToggleButton"
                            Text="" Value="" Checked='<%# Eval("H_upl_sleva").ToString() == "" %>'>
                        </telerik:RadButton>
                    </td>
                    <td class="Border" style="text-align: center;">
                        <telerik:RadButton ID="RBX_upl_sleva" AutoPostBack="false" runat="server" GroupName="upl_sleva"
                            OnClientClicked="H_upl_OnRadioClientClicked" ToggleType="Radio" ButtonType="ToggleButton"
                            Text="" Value="X" Checked='<%# Eval("H_upl_sleva").ToString() == "X" %>'>
                        </telerik:RadButton>
                    </td>
                    <td class="Border" style="text-align: center;">
                        <telerik:RadButton ID="RBD_upl_sleva" AutoPostBack="false" runat="server" GroupName="upl_sleva"
                            OnClientClicked="H_upl_OnRadioClientClicked" ToggleType="Radio" ButtonType="ToggleButton"
                            Text="" Value="XD" Checked='<%# Eval("H_upl_sleva").ToString() == "XD" %>'>
                        </telerik:RadButton>
                    </td>
                    <td class="Border"></td>
                    <td class="Border"></td>
                </tr>
                <tr>
                    <td class="Border">[%Základní sleva na invaliditu I. nebo II. stupně%] - [%stupeň%]: 
                        <telerik:RadDropDownList ID="H_upl_inv_stupen" runat="server" SelectedValue='<%# (Eval("H_upl_inv").ToString()+"_").Substring(0, 1) %>' >
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="x" Text="I." />
                                <telerik:DropDownListItem Value="X" Text="II." />
                            </Items>
                        </telerik:RadDropDownList>
                        <asp:Image ID="Img_upl_inv" runat="server" ImageUrl="~/Images/query.png" ImageAlign="Right" />
                        <telerik:RadToolTip ID="RadToolTip1" runat="server"
                            TargetControlID="Img_upl_inv"
                            Text="[%Na tuto slevu máte nárok pokud vám byl přiznán invalidní důchod pro invaliditu I. nebo II. stupně z důchodového pojištění nebo vám tento důchod zanikl z důvodu nároku na starobní důchod%]"
                            Position="TopLeft" AutoCloseDelay="0" HideDelay="100" ShowDelay="100" Width="250px">
                        </telerik:RadToolTip>
                    </td>
                    <td class="Border" style="text-align: center;">
                        <asp:HiddenField ID="H_upl_inv" runat="server" Value='<%# Eval("H_upl_inv") %>' />

                        <telerik:RadButton ID="RB0_upl_inv" AutoPostBack="false" runat="server" GroupName="upl_inv"
                            OnClientClicked="H_upl_OnRadioClientClicked" ToggleType="Radio" ButtonType="ToggleButton"
                            Text="" Value="" Checked='<%# Eval("H_upl_inv").ToString() == "" %>'>
                        </telerik:RadButton>
                    </td>
                    <td class="Border" style="text-align: center;">
                        <telerik:RadButton ID="RBX_upl_inv" AutoPostBack="false" runat="server" GroupName="upl_inv"
                            OnClientClicked="H_upl_OnRadioClientClicked" ToggleType="Radio" ButtonType="ToggleButton"
                            Text="" Value="X" Checked='<%# Eval("H_upl_inv").ToString().ToUpper() == "X" %>'>
                        </telerik:RadButton>
                    </td>
                    <td class="Border" style="text-align: center;">
                        <telerik:RadButton ID="RBD_upl_inv" AutoPostBack="false" runat="server" GroupName="upl_inv"
                            OnClientClicked="H_upl_OnRadioClientClicked" ToggleType="Radio" ButtonType="ToggleButton"
                            Text="" Value="XD" Checked='<%# Eval("H_upl_inv").ToString().ToUpper() == "XD" %>'>
                        </telerik:RadButton>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="H_upl_inv_mes" runat="server" Text='<%# Eval("H_upl_inv_mes") %>' Width="16mm"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <asp:TextBox runat="server" ClientIDMode="Static" ID="H_upl_inv_file" class="AddPril input" />
                        <input type="button" id="B_upl_inv" class="AddPril" value=".." onclick="PridatPrilohu(this)" />
                    </td>
                </tr>
                <tr>
                    <td class="Border" style="text-align: left;">[%Rozšířená sleva na invaliditu III. stupně%]
                        <asp:Image ID="Img_upl_inv_roz" runat="server" ImageUrl="~/Images/query.png" ImageAlign="Right" />
                        <telerik:RadToolTip ID="RadToolTip3" runat="server"
                            TargetControlID="Img_upl_inv_roz"
                            Position="TopLeft" AutoCloseDelay="0" HideDelay="100" ShowDelay="100" Width="250px">
                            [%Na tuto slevu máte nárok pokud vám byl přiznán invalidní důchod pro invaliditu III. stupně nebo jiný důchod z důchodového pojištění, u něhož jednou z podmínek přiznání je, že jste invalidní ve III. stupni,%]
                            <br />
                            [%nebo vám zanikl nárok na invalidní důchod pro invaliditu III. stupně z důvodu přiznání starobního důchodu,%]
                            <br />
                            [%nebo že jste podle zvláštních předpisů invalidní ve III. stupni, avšak žádost o invalidní důchod pro invaliditu III. stupně vám byla zamítnuta z jiných důvodů než proto, že nejste invalidní ve III. stupni (nesplnění doby pojištění).%]"
                        </telerik:RadToolTip>
                    </td>
                    <td class="Border" style="text-align: center;">
                        <asp:HiddenField ID="H_upl_inv_roz" runat="server" Value='<%# Eval("H_upl_inv_roz") %>' />

                        <telerik:RadButton ID="RB0_upl_inv_roz" AutoPostBack="false" runat="server" GroupName="upl_inv_roz"
                            OnClientClicked="H_upl_OnRadioClientClicked" ToggleType="Radio" ButtonType="ToggleButton"
                            Text="" Value="" Checked='<%# Eval("H_upl_inv_roz").ToString() == "" %>'>
                        </telerik:RadButton>
                    </td>
                    <td class="Border" style="text-align: center;">
                        <telerik:RadButton ID="RBX_upl_inv_roz" AutoPostBack="false" runat="server" GroupName="upl_inv_roz"
                            OnClientClicked="H_upl_OnRadioClientClicked" ToggleType="Radio" ButtonType="ToggleButton"
                            Text="" Value="X" Checked='<%# Eval("H_upl_inv_roz").ToString() == "X" %>'>
                        </telerik:RadButton>
                    </td>
                    <td class="Border" style="text-align: center;">
                        <telerik:RadButton ID="RBD_upl_inv_roz" AutoPostBack="false" runat="server" GroupName="upl_inv_roz"
                            OnClientClicked="H_upl_OnRadioClientClicked" ToggleType="Radio" ButtonType="ToggleButton"
                            Text="" Value="XD" Checked='<%# Eval("H_upl_inv_roz").ToString() == "XD" %>'>
                        </telerik:RadButton>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="H_upl_inv_roz_mes" runat="server" Text='<%# Bind("H_upl_inv_roz_mes") %>' Width="16mm"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <asp:TextBox runat="server" ClientIDMode="Static" ID="H_upl_inv_roz_file" class="AddPril input" />
                        <input type="button" id="B_upl_inv_roz" class="AddPril" value=".." onclick="PridatPrilohu(this)" />
                    </td>
                </tr>
                <tr>
                    <td class="Border" style="text-align: left;">[%Sleva na držitele průkazu ZTP/P%]
                        <asp:Image ID="Img_upl_inv_ztp" runat="server" ImageUrl="~/Images/query.png" ImageAlign="Right" />
                        <telerik:RadToolTip ID="RadToolTip4" runat="server"
                            TargetControlID="Img_upl_inv_ztp"
                            Text="[%Na tuto slevu máte nárok pokud vám byl přiznán nárok na průkaz ZTP/P%]"
                            Position="TopLeft" AutoCloseDelay="0" HideDelay="100" ShowDelay="100" Width="250px">
                        </telerik:RadToolTip>
                    </td>
                    <td class="Border" style="text-align: center;">
                        <asp:HiddenField ID="H_upl_inv_ztp" runat="server" Value='<%# Eval("H_upl_inv_ztp") %>' />

                        <telerik:RadButton ID="RB0_upl_inv_ztp" AutoPostBack="false" runat="server" GroupName="upl_inv_ztp"
                            OnClientClicked="H_upl_OnRadioClientClicked" ToggleType="Radio" ButtonType="ToggleButton"
                            Text="" Value="" Checked='<%# Eval("H_upl_inv_ztp").ToString() == "" %>'>
                        </telerik:RadButton>
                    </td>
                    <td class="Border" style="text-align: center;">
                        <telerik:RadButton ID="RBX_upl_inv_ztp" AutoPostBack="false" runat="server" GroupName="upl_inv_ztp"
                            OnClientClicked="H_upl_OnRadioClientClicked" ToggleType="Radio" ButtonType="ToggleButton"
                            Text="" Value="X" Checked='<%# Eval("H_upl_inv_ztp").ToString() == "X" %>'>
                        </telerik:RadButton>
                    </td>
                    <td class="Border" style="text-align: center;">
                        <telerik:RadButton ID="RBD_upl_inv_ztp" AutoPostBack="false" runat="server" GroupName="upl_inv_ztp"
                            OnClientClicked="H_upl_OnRadioClientClicked" ToggleType="Radio" ButtonType="ToggleButton"
                            Text="" Value="XD" Checked='<%# Eval("H_upl_inv_ztp").ToString() == "XD" %>'>
                        </telerik:RadButton>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="H_upl_inv_ztp_mes" runat="server" Text='<%# Bind("H_upl_inv_ztp_mes") %>' Width="16mm"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <asp:TextBox runat="server" ClientIDMode="Static" ID="H_upl_inv_ztp_file" class="AddPril input" />
                        <input type="button" id="B_upl_inv_ztp" class="AddPril" value=".." onclick="PridatPrilohu(this)" />
                    </td>
                </tr>
                <tr runat="server" id="tr_upl_stud" visible='<%# Eval("H_obd_rok").ToString().CompareTo("2024")<0 %>'>
                    <td class="Border" style="text-align: left;">[%Sleva na studenta%] ([%studující zaměstnanec%])
                        <asp:Image ID="Img_upl_stud" runat="server" ImageUrl="~/Images/query.png" ImageAlign="Right" />
                        <telerik:RadToolTip ID="RadToolTip5" runat="server"
                            TargetControlID="Img_upl_stud"
                            Text="[%Na tuto slevu máte nárok pokud se soustavně připravujete na budoucí povolání studiem nebo předepsaným výcvikem (do 26 let) nebo po dobu prezenční formy studia v doktorském studijním programu, který poskytuje vysokoškolské vzdělání (do 28 let)%]"
                            Position="TopLeft" AutoCloseDelay="0" HideDelay="100" ShowDelay="100" Width="250px">
                        </telerik:RadToolTip>
                    </td>
                    <td class="Border" style="text-align: center;">
                        <asp:HiddenField ID="H_upl_stud" runat="server" Value='<%# Eval("H_upl_stud") %>' />

                        <telerik:RadButton ID="RB0_upl_stud" AutoPostBack="false" runat="server" GroupName="upl_stud"
                            OnClientClicked="H_upl_OnRadioClientClicked" ToggleType="Radio" ButtonType="ToggleButton"
                            Text="" Value="" Checked='<%# Eval("H_upl_stud").ToString() == "" %>'>
                        </telerik:RadButton>
                    </td>
                    <td class="Border" style="text-align: center;">
                        <telerik:RadButton ID="RBX_upl_stud" AutoPostBack="false" runat="server" GroupName="upl_stud"
                            OnClientClicked="H_upl_OnRadioClientClicked" ToggleType="Radio" ButtonType="ToggleButton"
                            Text="" Value="X" Checked='<%# Eval("H_upl_stud").ToString() == "X" %>'>
                        </telerik:RadButton>
                    </td>
                    <td class="Border" style="text-align: center;">
                        <telerik:RadButton ID="RBD_upl_stud" AutoPostBack="false" runat="server" GroupName="upl_stud"
                            OnClientClicked="H_upl_OnRadioClientClicked" ToggleType="Radio" ButtonType="ToggleButton"
                            Text="" Value="XD" Checked='<%# Eval("H_upl_stud").ToString() == "XD" %>'>
                        </telerik:RadButton>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="H_upl_stud_mes" runat="server" Text='<%# Bind("H_upl_stud_mes") %>' Width="16mm"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <asp:TextBox runat="server" ClientIDMode="Static" ID="H_upl_stud_file" class="AddPril input" />
                        <input type="button" id="B_upl_stud" class="AddPril" value=".." onclick="PridatPrilohu(this)" />
                    </td>
                </tr>
            </table>

            <span class="tiskHide">
                <asp:CustomValidator runat="server" ID="Val_slevy"></asp:CustomValidator>
            </span>


            <table>
                <tr>
                    <td colspan="8" class="Border danprohlNadpis" style="max-width: 210mm; white-space: normal">[%Daňové zvýhodnění na děti%] ([%Uplatňuji zvýhodnění na jedno dítě – označte 1, na 2 dítě – označte 2, na 3. a každé další označte 3, pokud slevu na dané dítě nechcete uplatnit – označte písmenem N.%])
                        <asp:Image ID="Img_deti" runat="server" ImageUrl="~/Images/query.png" ImageAlign="Right" />
                        <telerik:RadToolTip ID="RadToolTip8" runat="server"
                            TargetControlID="Img_deti"
                            Position="TopLeft" AutoCloseDelay="0" HideDelay="100" ShowDelay="100" Width="340px">
                            [%Daňové zvýhodnění si můžete uplatnit na vámi vyživované děti žijící ve vaší společně hospodařící domácnosti na území členského státu EU nebo EHP.%]
                        </telerik:RadToolTip>
                    </td>
                </tr>
                <tr>
                    <td colspan="8" class="Border">
                        <telerik:RadRadioButtonList ID="H_dod_upl" runat="server" SelectedValue='<%# Eval("D1_prijmeni").ToString().Length > 0 ? "X" : "-" %>' Columns="3" OnSelectedIndexChanged="H_dod_upl_SelectedIndexChanged">
                            <Items>
                                <telerik:ButtonListItem Value="-" Text="[%Neuplatňuji%]" />
                                <telerik:ButtonListItem Value="X" Text="[%Uplatňuji%]" />
                                <telerik:ButtonListItem Value="XD" Text="[%Dodatečně uplatňuji%]" />
                            </Items>
                        </telerik:RadRadioButtonList>
                    </td>
                </tr>
                <tr>
                    <td class="Border" style="width: 30mm; height: auto">[%Jméno%]</td>
                    <td class="Border" style="width: 42mm;">[%Příjmení%]</td>
                    <td class="Border" style="width: 26mm;">[%Rodné číslo%]</td>
                    <td class="Border" style="width: 30mm;">[%Uplatňuji/neuplatňuji nárok ve výši na%]</td>
                    <td class="Border" style="width: 15mm;">[%ZTP/P%]
                        <asp:Image ID="Img_D_ZTP" runat="server" ImageUrl="~/Images/query.png" ImageAlign="Right" />
                        <telerik:RadToolTip ID="RadToolTip11" runat="server"
                            TargetControlID="Img_D_ZTP"
                            Position="TopLeft" AutoCloseDelay="0" HideDelay="100" ShowDelay="100" Width="340px">
                            [%Vyznačte, kterému z dětí byl přiznán nárok na průkaz ZTP/P.%]
                        </telerik:RadToolTip>
                    </td>
                    <td class="Border" style="width: 15mm;">[%Zletilé dítě%]
                        <asp:Image ID="Img_D_Zle" runat="server" ImageUrl="~/Images/query.png" ImageAlign="Right" />
                        <telerik:RadToolTip ID="RadToolTip12" runat="server"
                            TargetControlID="Img_D_Zle"
                            Position="TopLeft" AutoCloseDelay="0" HideDelay="100" ShowDelay="100" Width="340px">
                            [%Označte, které z dětí je zletilé (do 26 let) a není mu přiznán invalidní důchod pro invaliditu III. stupně a soustavně se připravuje na budoucí povolání (nebo mu jeho zdravotní stav nedovoluje přípravu na budoucí povolání či výdělečnou činnost).%]
                        </telerik:RadToolTip>
                    </td>
                    <td class="Border" style="width: 25mm;">[%Dodatečně za měsíce%]
                        <asp:Image ID="Img_D_Dod" runat="server" ImageUrl="~/Images/query.png" ImageAlign="Right" />
                        <telerik:RadToolTip ID="RadToolTip13" runat="server"
                            TargetControlID="Img_D_Dod"
                            Position="TopLeft" AutoCloseDelay="0" HideDelay="100" ShowDelay="100" Width="340px">
                            [%Pokud uplatňujete daňové zvýhodnění až dodatečně v rámci žádosti o roční zúčtování záloh a daňového zvýhodnění, pak pod nadpisem této části označte „Uplatňuji dodatečně“, a zároveň vyplňte v posledním sloupci tabulky kalendářní měsíce, za které dodatečně uplatňujete daňové zvýhodnění ( např. 9–12)%]
                        </telerik:RadToolTip>
                    </td>
                    <td class="Border" style="white-space: nowrap;">[%Doložte potvrzení%]
                    </td>
                </tr>
                <tr>
                    <td class="Border">
                        <kspwc:TTextBox ID="D1_jmeno" runat="server" Text='<%# Bind("D1_jmeno") %>' MaxLength="40" Width="26mm"
                            ToolTip="[%Chybí dítě?%] [%Požádej o doplnění přes požadavek žádost o změnu osobních údajů.%]"></kspwc:TTextBox>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="D1_prijmeni" runat="server" Text='<%# Bind("D1_prijmeni") %>' MaxLength="40" Width="39mm"></kspwc:TTextBox></td>
                    <td class="Border">
                        <kspwc:TTextBox ID="D1_rc" runat="server" Text='<%# Bind("D1_rc") %>' MaxLength="10" Width="24mm"></kspwc:TTextBox></td>
                    <td class="Border" style="text-align: center">&nbsp;&nbsp;
                        <telerik:RadDropDownList ID="D1_upl_por" CssClass="Pad0" runat="server" SelectedValue='<%# Bind("D1_upl_por") %>'
                            OnClientSelectedIndexChanged="D_upl_por_SelectedIndexChanged">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="N" Text="N" />
                                <telerik:DropDownListItem Value="1" Text="1" />
                                <telerik:DropDownListItem Value="2" Text="2" />
                                <telerik:DropDownListItem Value="3" Text="3" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="Border" style="text-align: center">
                        <asp:CheckBox ID="D1_ztp" runat="server" Checked='<%# Bind("D1_ztp") %>'></asp:CheckBox>
                    </td>
                    <td class="Border" style="text-align: center">
                        <asp:CheckBox ID="D1_zletile" runat="server" Checked='<%# Bind("D1_zletile") %>'></asp:CheckBox>
                    </td>
                    <td class="Border" style="text-align: center">
                        <kspwc:TTextBox ID="D1_dod_mes" runat="server" Text='<%# Bind("D1_dod_mes") %>' MaxLength="10" Width="20mm"></kspwc:TTextBox></td>
                    <td class="Border" style="white-space: nowrap;">
                        <asp:TextBox runat="server" ClientIDMode="Static" ID="D1_file" class="AddPril input" />
                        <input type="button" id="B_D1" class="AddPril" value=".." onclick="PridatPrilohu(this)" />
                    </td>
                </tr>
                <tr>
                    <td class="Border">
                        <kspwc:TTextBox ID="D2_jmeno" runat="server" Text='<%# Bind("D2_jmeno") %>' MaxLength="40" Width="26mm"></kspwc:TTextBox></td>
                    <td class="Border">
                        <kspwc:TTextBox ID="D2_prijmeni" runat="server" Text='<%# Bind("D2_prijmeni") %>' MaxLength="40" Width="39mm"></kspwc:TTextBox></td>
                    <td class="Border">
                        <kspwc:TTextBox ID="D2_rc" runat="server" Text='<%# Bind("D2_rc") %>' MaxLength="10" Width="24mm"></kspwc:TTextBox></td>
                    <td class="Border" style="text-align: center">&nbsp;&nbsp;
                        <telerik:RadDropDownList ID="D2_upl_por" CssClass="Pad0" runat="server" SelectedValue='<%# Bind("D2_upl_por") %>'
                            OnClientSelectedIndexChanged="D_upl_por_SelectedIndexChanged">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="N" Text="N" />
                                <telerik:DropDownListItem Value="1" Text="1" />
                                <telerik:DropDownListItem Value="2" Text="2" />
                                <telerik:DropDownListItem Value="3" Text="3" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="Border" style="text-align: center">
                        <asp:CheckBox ID="D2_ztp" runat="server" Checked='<%# Bind("D2_ztp") %>' Width="20mm"></asp:CheckBox>
                    </td>
                    <td class="Border" style="text-align: center">
                        <asp:CheckBox ID="D2_zletile" runat="server" Checked='<%# Bind("D2_zletile") %>' Width="15mm"></asp:CheckBox>
                    </td>
                    <td class="Border" style="text-align: center">
                        <kspwc:TTextBox ID="D2_dod_mes" runat="server" Text='<%# Bind("D2_dod_mes") %>' MaxLength="10" Width="20mm"></kspwc:TTextBox></td>
                    <td class="Border" style="white-space: nowrap;">
                        <asp:TextBox runat="server" ClientIDMode="Static" ID="D2_file" class="AddPril input" />
                        <input type="button" id="B_D2" class="AddPril" value=".." onclick="PridatPrilohu(this)" />
                    </td>
                </tr>
                <tr>
                    <td class="Border">
                        <kspwc:TTextBox ID="D3_jmeno" runat="server" Text='<%# Bind("D3_jmeno") %>' MaxLength="40" Width="26mm"></kspwc:TTextBox></td>
                    <td class="Border">
                        <kspwc:TTextBox ID="D3_prijmeni" runat="server" Text='<%# Bind("D3_prijmeni") %>' MaxLength="40" Width="39mm"></kspwc:TTextBox></td>
                    <td class="Border">
                        <kspwc:TTextBox ID="D3_rc" runat="server" Text='<%# Bind("D3_rc") %>' MaxLength="10" Width="24mm"></kspwc:TTextBox></td>
                    <td class="Border" style="text-align: center">&nbsp;&nbsp;
                        <telerik:RadDropDownList ID="D3_upl_por" CssClass="Pad0" runat="server" SelectedValue='<%# Bind("D3_upl_por") %>'
                            OnClientSelectedIndexChanged="D_upl_por_SelectedIndexChanged">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="N" Text="N" />
                                <telerik:DropDownListItem Value="1" Text="1" />
                                <telerik:DropDownListItem Value="2" Text="2" />
                                <telerik:DropDownListItem Value="3" Text="3" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="Border" style="text-align: center">
                        <asp:CheckBox ID="D3_ztp" runat="server" Checked='<%# Bind("D3_ztp") %>'></asp:CheckBox>
                    </td>
                    <td class="Border" style="text-align: center">
                        <asp:CheckBox ID="D3_zletile" runat="server" Checked='<%# Bind("D3_zletile") %>'></asp:CheckBox>
                    </td>
                    <td class="Border" style="text-align: center">
                        <kspwc:TTextBox ID="D3_dod_mes" runat="server" Text='<%# Bind("D3_dod_mes") %>' MaxLength="10" Width="20mm"></kspwc:TTextBox></td>
                    <td class="Border" style="white-space: nowrap;">
                        <asp:TextBox runat="server" ClientIDMode="Static" ID="D3_file" class="AddPril input" />
                        <input type="button" id="B_D3" class="AddPril" value=".." onclick="PridatPrilohu(this)" />
                    </td>
                </tr>
                <tr>
                    <td class="Border">
                        <kspwc:TTextBox ID="D4_jmeno" runat="server" Text='<%# Bind("D4_jmeno") %>' MaxLength="40" Width="26mm"></kspwc:TTextBox></td>
                    <td class="Border">
                        <kspwc:TTextBox ID="D4_prijmeni" runat="server" Text='<%# Bind("D4_prijmeni") %>' MaxLength="40" Width="39mm"></kspwc:TTextBox></td>
                    <td class="Border">
                        <kspwc:TTextBox ID="D4_rc" runat="server" Text='<%# Bind("D4_rc") %>' MaxLength="10" Width="24mm"></kspwc:TTextBox></td>
                    <td class="Border" style="text-align: center">&nbsp;&nbsp;
                        <telerik:RadDropDownList ID="D4_upl_por" CssClass="Pad0" runat="server" SelectedValue='<%# Bind("D4_upl_por") %>'
                            OnClientSelectedIndexChanged="D_upl_por_SelectedIndexChanged">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="N" Text="N" />
                                <telerik:DropDownListItem Value="1" Text="1" />
                                <telerik:DropDownListItem Value="2" Text="2" />
                                <telerik:DropDownListItem Value="3" Text="3" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="Border" style="text-align: center">
                        <asp:CheckBox ID="D4_ztp" runat="server" Checked='<%# Bind("D4_ztp") %>' Width="20mm"></asp:CheckBox>
                    </td>
                    <td class="Border" style="text-align: center">
                        <asp:CheckBox ID="D4_zletile" runat="server" Checked='<%# Bind("D4_zletile") %>' Width="15mm"></asp:CheckBox>
                    </td>
                    <td class="Border" style="text-align: center">
                        <kspwc:TTextBox ID="D4_dod_mes" runat="server" Text='<%# Bind("D4_dod_mes") %>' MaxLength="10" Width="20mm"></kspwc:TTextBox></td>
                    <td class="Border" style="white-space: nowrap;">
                        <asp:TextBox runat="server" ClientIDMode="Static" ID="D4_file" class="AddPril input" />
                        <input type="button" id="B_D4" class="AddPril" value=".." onclick="PridatPrilohu(this)" />
                    </td>
                </tr>
                <tr>
                    <td class="Border">
                        <kspwc:TTextBox ID="D5_jmeno" runat="server" Text='<%# Bind("D5_jmeno") %>' MaxLength="40" Width="26mm"></kspwc:TTextBox></td>
                    <td class="Border">
                        <kspwc:TTextBox ID="D5_prijmeni" runat="server" Text='<%# Bind("D5_prijmeni") %>' MaxLength="40" Width="39mm"></kspwc:TTextBox></td>
                    <td class="Border">
                        <kspwc:TTextBox ID="D5_rc" runat="server" Text='<%# Bind("D5_rc") %>' MaxLength="10" Width="24mm"></kspwc:TTextBox></td>
                    <td class="Border" style="text-align: center">&nbsp;&nbsp;
                        <telerik:RadDropDownList ID="D5_upl_por" CssClass="Pad0" runat="server" SelectedValue='<%# Bind("D5_upl_por") %>'
                            OnClientSelectedIndexChanged="D_upl_por_SelectedIndexChanged">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="N" Text="N" />
                                <telerik:DropDownListItem Value="1" Text="1" />
                                <telerik:DropDownListItem Value="2" Text="2" />
                                <telerik:DropDownListItem Value="3" Text="3" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="Border" style="text-align: center">
                        <asp:CheckBox ID="D5_ztp" runat="server" Checked='<%# Bind("D5_ztp") %>'></asp:CheckBox>
                    </td>
                    <td class="Border" style="text-align: center">
                        <asp:CheckBox ID="D5_zletile" runat="server" Checked='<%# Bind("D5_zletile") %>'></asp:CheckBox>
                    </td>
                    <td class="Border " style="text-align: center">
                        <kspwc:TTextBox ID="D5_dod_mes" runat="server" Text='<%# Bind("D5_dod_mes") %>' MaxLength="10" Width="20mm"></kspwc:TTextBox></td>
                    <td class="Border" style="white-space: nowrap;">
                        <asp:TextBox runat="server" ClientIDMode="Static" ID="D5_file" class="AddPril input" />
                        <input type="button" id="B_D5" class="AddPril" value=".." onclick="PridatPrilohu(this)" />
                    </td>
                </tr>
            </table>

            <span class="tiskHide">
                <asp:CustomValidator runat="server" ID="Val_deti"></asp:CustomValidator>
            </span>


            <table>
                <tr>
                    <td colspan="6" class="Border danprohlNadpis" style="max-width: 210mm; white-space: normal">[%Osoby vyživující děti ve stejné domácnosti%] ([%Vyplňte pouze v případě, že uplatňujete daňové zvýhodnění na děti a tyto děti vyživuje i jiný poplatník ve stejné domácnosti - manžel-ka, partner-ka.%])
                       
                    </td>
                </tr>
                <tr>
                    <td colspan="6" class="Border">
                        <span>[%V téže společně hospodařící domácnosti vyživuje tytéž mnou vyživované děti i jiný poplatník%]</span>
                        <telerik:RadRadioButtonList ID="H_vyz_jin_popl" runat="server" SelectedValue='<%# Bind("H_vyz_jin_popl") %>' Columns="2" AutoPostBack="False">
                            <ClientEvents OnItemClicked="On_H_vyz_jin_popl_Clicked" />
                            <Items>
                                <telerik:ButtonListItem Value="X" Text="ANO" />
                                <telerik:ButtonListItem Value="-" Text="NE" />
                            </Items>
                        </telerik:RadRadioButtonList>
                    </td>
                </tr>
                <tr>
                    <th class="Border" style="width: 18%; height: auto">[%Jméno%]</th>
                    <th class="Border" style="width: 21%;">[%Příjmení%]</th>
                    <th class="Border" style="width: 14%;">[%Rodné číslo%]</th>
                    <th class="Border">[%Uplatňuje daňové zvýhodnění ANO/NE%]</th>
                    <th class="Border">[%Zaměstnání ANO/NE%] </th>
                    <th class="Border">[%Doložte potvrzení%] </th>
                </tr>
                <tr>
                    <td class="Border" style="height: 16.5%">
                        <asp:HiddenField runat="server" ID="H_vyz_jin_id" Value='<%# Bind("H_vyz_jin_id") %>'></asp:HiddenField>
                        <kspwc:TTextBox ID="H_vyz_jin_jmeno" runat="server" Text='<%# Bind("H_vyz_jin_jmeno") %>' MaxLength="40" Width="22mm" Height="5mm"></kspwc:TTextBox>
                        <telerik:RadDropDownList ID="DDL_manzelka" runat="server" CssClass="Pad0"
                            DataValueField="id_rod_prisl" DataTextField="cele_jmeno"
                            OnSelectedIndexChanged="DDL_manzelka_SelectedIndexChanged" AutoPostBack="true" ForeColor="White">
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="Border">
                        <kspwc:TTextBox ID="H_vyz_jin_prijmeni" runat="server" Text='<%# Bind("H_vyz_jin_prijmeni") %>' MaxLength="40" Width="38mm" Height="5mm"></kspwc:TTextBox></td>
                    <td class="Border">
                        <kspwc:TTextBox ID="H_vyz_jin_rc" runat="server" Text='<%# Bind("H_vyz_jin_rc") %>' MaxLength="10" Width="33mm" Height="5mm"></kspwc:TTextBox></td>
                    <td class="Border" style="text-align: center;">
                        <telerik:RadDropDownList ID="H_vyz_jin_upl" runat="server" SelectedValue='<%# Bind("H_vyz_jin_upl") %>'>
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="1" Text="[%ANO%]" />
                                <telerik:DropDownListItem Value="0" Text="[%NE%]" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="Border" style="text-align: center;">
                        <telerik:RadDropDownList ID="H_vyz_jin_zam" runat="server" SelectedValue='<%# Bind("H_vyz_jin_zam") %>'>
                            <Items>
                                <telerik:DropDownListItem Value="" Text="" />
                                <telerik:DropDownListItem Value="1" Text="[%ANO%]" />
                                <telerik:DropDownListItem Value="0" Text="[%NE%]" />
                            </Items>
                        </telerik:RadDropDownList>
                    </td>
                    <td class="Border" style="text-align: center;">
                        <asp:TextBox runat="server" ClientIDMode="Static" ID="H_vyz_jin_upl_file" class="AddPril input" />
                        <input type="button" runat="server" id="B_vyz_jin_upl" class="AddPril" value=".." onclick="PridatPrilohu(this)" />
                    </td>
                </tr>
                <tr>
                    <th class="Border" style="height: 16.5%">[%Adresa bydliště%] ([%místo trvalého pobytu%])</th>
                    <td colspan="5" class="Border" style="background-color: white;">[%Ulice%]
                        <kspwc:TTextBox ID="H_ulice_vyz_jin" runat="server" Text='<%# Bind("H_ulice_vyz_jin") %>' MaxLength="45" Width="30mm" Height="5mm"></kspwc:TTextBox>
                        [%Čís. pop./orient.%]
                        <kspwc:TTextBox ID="H_c_pop_vyz_jin" runat="server" Text='<%# Bind("H_c_pop_vyz_jin") %>' MaxLength="8" Width="20mm" Height="5mm"></kspwc:TTextBox>
                        <kspwc:TTextBox ID="H_c_orient_vyz_jin" runat="server" Text='<%# Bind("H_c_orient_vyz_jin") %>' MaxLength="10" Width="5mm" Height="5mm" Visible="false"></kspwc:TTextBox>
                        [%Obec%]
                        <kspwc:TTextBox ID="H_obec_vyz_jin" runat="server" Text='<%# Bind("H_obec_vyz_jin") %>' MaxLength="25" Width="48mm" Height="5mm"></kspwc:TTextBox>
                        [%PSČ%]
                        <kspwc:TTextBox ID="H_psc_vyz_jin" runat="server" Text='<%# Bind("H_psc_vyz_jin") %>' MaxLength="5" Width="12mm" Height="5mm"></kspwc:TTextBox>
                    </td>
                </tr>
                <tr>
                    <th class="Border" style="height: 16.5%">[%Název plátce daně%]</th>
                    <td colspan="5" class="Border" style="background-color: white;">
                        <kspwc:TTextBox ID="H_vyz_jin_naz_platce" runat="server" Text='<%# Bind("H_vyz_jin_naz_platce") %>' MaxLength="250" Width="100mm" Height="5mm"></kspwc:TTextBox>
                    </td>
                </tr>
                <tr>
                    <th class="Border" style="height: 16.5%">[%Adresa plátce daně%]</th>
                    <td colspan="5" class="Border" style="background-color: white;">[%Ulice%]
                        <kspwc:TTextBox ID="H_ulice_vyz_jin_pl" runat="server" Text='<%# Bind("H_ulice_vyz_jin_pl") %>' MaxLength="45" Width="30mm" Height="5mm"></kspwc:TTextBox>
                        [%Čís. pop./orient.%]
                        <kspwc:TTextBox ID="H_c_pop_vyz_jin_pl" runat="server" Text='<%# Bind("H_c_pop_vyz_jin_pl") %>' MaxLength="8" Width="20mm" Height="5mm"></kspwc:TTextBox>
                        <kspwc:TTextBox ID="H_c_orien_vyz_jin_pl" runat="server" Text='<%# Bind("H_c_orien_vyz_jin_pl") %>' MaxLength="5" Width="5mm" Height="5mm" Visible="false"></kspwc:TTextBox>
                        [%Obec%]
                        <kspwc:TTextBox ID="H_obec_vyz_jin_pl" runat="server" Text='<%# Bind("H_obec_vyz_jin_pl") %>' MaxLength="48" Width="45mm" Height="5mm"></kspwc:TTextBox>
                        [%PSČ%]
                        <kspwc:TTextBox ID="H_psc_vyz_jin_pl" runat="server" Text='<%# Bind("H_psc_vyz_jin_pl") %>' MaxLength="5" Width="12mm" Height="5mm"></kspwc:TTextBox>
                    </td>
                </tr>
            </table>

            <span class="tiskHide">
                <asp:CustomValidator runat="server" ID="Val_manzelka"></asp:CustomValidator>
                <div style="margin-top: 5px">
                    <asp:CustomValidator runat="server" ID="ValidPg1" OnServerValidate="ValidPg1_ServerValidate"></asp:CustomValidator>
                </div>
            </span>

            <table style="width: 260mm">
                <tr>
                    <td>[%Osobní údaje již nejsou aktuální? Požádejte o jejich změnu.%]
                        <br />
                        [%K prohlášení se vraťte, až bude změna schválena.%]
                    </td>
                    <td>
                        <telerik:RadButton runat="server" ID="RB_zm_os_udaj" Text="[%Změna osob. údajů%]" CausesValidation="false" AutoPostBack="true" ButtonType="LinkButton" 
                            OnClick="RB_zm_os_udaj_Click"
                            CssClass="kstlacitko" Icon-PrimaryIconCssClass="fi fi-portrait"></telerik:RadButton>
                    </td>
                    <td style="text-align: right">[%Osobní i daňové údaje jsou správné, přejít k podpisu%]
                    </td>
                    <td>
                        <telerik:RadButton runat="server" ID="RB_k_podpisu" Text="[%Přejít k podpisu%]" CausesValidation="true" AutoPostBack="true" OnClick="RB_k_podpisu_Click"
                            CssClass="kstlacitko" Icon-PrimaryIconCssClass="fi fi-attribution-pen">
                        </telerik:RadButton>
                    </td>
                </tr>
            </table>


        </div>
        <span class="tiskHide">

            <asp:HiddenField runat="server" ID="HF_sleva_opravdu_ne" Value="0"></asp:HiddenField>
        </span>
    </ItemTemplate>
</asp:FormView>
