﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="GridSkoliciAkce.ascx.cs" Inherits="KSPortal.Controls.GridSkoliciAkce" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<telerik:RadAjaxManagerProxy runat="server" ID="RAMP_uc_sa">
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="TradGridSkolAkceZam">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="TradGridSkolAkceZam" />
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>

<telerik:RadPersistenceManagerProxy runat="server" ID="rpmp_gsa">
    <PersistenceSettings>
        <telerik:PersistenceSetting ControlID="TradGridSkolAkceZam" />
    </PersistenceSettings>
</telerik:RadPersistenceManagerProxy>

<kspwc:TRadGrid ID="TradGridSkolAkceZam" runat="server" MasterTableView-Caption="[%Školící akce zaměstnanců%]"
    ShowGroupPanel="True" AllowPaging="True" ShowFooter="true"
    AllowSorting="true" AutoGenerateColumns="false" CssClass="ksprvek"
    AutoFilterWidth="true" AutoFilterControlWidth="false"
    OnNeedDataSource="TradGridSkolAkceZam_NeedDataSource"
    OnItemDataBound="TradGridSkolAkceZam_ItemDataBound">
    <ClientSettings AllowDragToGroup="true"></ClientSettings>
    <GroupingSettings ShowUnGroupButton="true" />
    <PagerStyle Mode="NextPrevNumericAndAdvanced" />
    <ExportSettings HideStructureColumns="true" OpenInNewWindow="true"></ExportSettings>
    <MasterTableView CommandItemDisplay="Top" ShowGroupFooter="true" EnableHeaderContextMenu="true" EnableHeaderContextAggregatesMenu="true" EnableGroupsExpandAll="true">
        <Columns>
            <telerik:GridNumericColumn DataField="os_cislo" HeaderText="[%Os. číslo%]" SortExpression="os_cislo"></telerik:GridNumericColumn>
            <kspwc:GridFotoZamColumn UniqueName="foto" DataOsCisloField="os_cislo"></kspwc:GridFotoZamColumn>
            <telerik:GridBoundColumn DataField="jmeno" HeaderText="[%Jméno%]" SortExpression="jmeno" />
            <telerik:GridBoundColumn DataField="prijmeni" HeaderText="[%Příjmení%]" SortExpression="prijmeni" />
            <telerik:GridBoundColumn DataField="str_nazev" HeaderText="[%Kmenové středisko%]" SortExpression="str_nazev" />
            <telerik:GridBoundColumn DataField="cislo_akce" HeaderText="[%Číslo%]" SortExpression="cislo_akce" />
            <telerik:GridBoundColumn DataField="nazev" HeaderText="[%Název%]" SortExpression="nazev" />
            <telerik:GridDateTimeColumn DataField="dat_od" FilterControlAltText="Filter dat_od column"
                HeaderText="[%Datum od%]" UniqueName="dat_od" DataType="System.DateTime" DataFormatString="{0:d.M.yyyy}"
                FilterDateFormat="d.M.yyyy" />
            <telerik:GridDateTimeColumn DataField="dat_do" FilterControlAltText="Filter dat_do column"
                HeaderText="[%Datum do%]" UniqueName="dat_do" DataType="System.DateTime" DataFormatString="{0:d.M.yyyy}"
                FilterDateFormat="d.M.yyyy" />
            <telerik:GridBoundColumn DataField="lektor" HeaderText="[%Lektor%]" SortExpression="lektor" />
            <telerik:GridBoundColumn DataField="osv_nazev" HeaderText="[%Vzdělávací aktivita%]" SortExpression="osv_nazev" />
            <telerik:GridNumericColumn DataField="celkem_dnu" HeaderText="[%Počet dnů%]" SortExpression="celkem_dnu"
                ItemStyle-HorizontalAlign="Right" Visible="False" Aggregate="Sum" />
            <telerik:GridNumericColumn DataField="suma_hodin" HeaderText="[%Počet hodin%]" SortExpression="suma_hodin"
                ItemStyle-HorizontalAlign="Right" Aggregate="Sum" />
            <telerik:GridNumericColumn DataField="naklady" HeaderText="[%Náklady%]" SortExpression="naklady"
                DataFormatString="{0:N}" HtmlEncode="False" ItemStyle-HorizontalAlign="Right" Aggregate="Sum" />
            <telerik:GridBoundColumn DataField="plneni" HeaderText="[%Plnění%]" SortExpression="plneni" />
            <telerik:GridBoundColumn DataField="typ_akreditace" HeaderText="[%Typ akreditace%]" SortExpression="typ_akreditace" />
            <telerik:GridRowIndicatorColumn></telerik:GridRowIndicatorColumn>
        </Columns>
        <CommandItemTemplate>
            <kspwc:GridCommandItemControl runat="server" ID="GCIC_gsa"
                ExportButton-ShowExportToExcelBIFFItem="true"
                ExportButton-ShowExportToExcelMLItem="true"
                ExportButton-ShowExportToExcelXlsxItem="true"
                BezMESButton-Visible="true"
                PrimiPodrizeniButton-Visible="true">
            </kspwc:GridCommandItemControl>
        </CommandItemTemplate>
    </MasterTableView>
</kspwc:TRadGrid>



