﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="KalendarAdvancedForm.ascx.cs"
    Inherits="KSPortal.Controls.RadSchedulerAdvancedFormAdvancedForm" %>
<%@ Register TagPrefix="telerik" Namespace="Telerik.Web.UI" Assembly="Telerik.Web.UI" %>
<%@ Register TagPrefix="scheduler" TagName="ResourceControl" Src="KalendarResourceControl.ascx" %>
<%@ Register TagPrefix="scheduler" TagName="MultipleValuesResourceControl" Src="KalendarAutoResourceControl.ascx" %>
<style type="text/css">
    html:first-child .RadWindow .rsAdvOptionsScroll ul {
        float: none !important;
        border: none !important;
    }
    .rsAdvInnerTitle {
        margin: 5px;
    }
    .rsAdvContentWrapper {
        margin: 10px;
    }
    .rsAdvButtonWrapper{
        margin-top: 5px;
    }
    .rsAdvancedEdit .kstlacitko, .rsAdvButtonWrapper {
        display: flex;
    }
</style>
<div class="rsAdvancedEdit rsAdvancedModal ksprvek" style="position: relative">
    <div class="rsModalBgTopLeft">
    </div>
    <div class="rsModalBgTopRight">
    </div>
    <div class="rsModalBgBottomLeft">
    </div>
    <div class="rsModalBgBottomRight">
    </div>
    <%-- Title bar. --%>
    <div class="rsAdvTitle">
        <%-- The rsAdvInnerTitle element is used as a drag handle when the form is modal. --%>
        <h1 class="rsAdvInnerTitle">
            <%= (this.Mode.ToString() == "Edit") ? PageScheduler.Localization.AdvancedEditAppointment : PageScheduler.Localization.AdvancedNewAppointment%></h1>
    </div>
    <div class="rsAdvContentWrapper">
        <%-- Scroll container - when the form height exceeds MaximumHeight scrollbars will appear on this element--%>
        <div class="rsAdvOptionsScroll">
            <asp:Panel runat="server" ID="AdvancedEditOptionsPanel" CssClass="rsAdvOptions">
                <asp:Panel runat="server" ID="BasicControlsPanel" CssClass="rsAdvBasicControls" OnDataBinding="BasicControlsPanel_DataBinding">
                    <ul class="rfbGroup">
                        <li class="rfbRow">
                            <telerik:RadTextBox runat="server" ID="SubjectText" Width="100%" LabelCssClass="rfbLabel"
                                Label='<%# PageScheduler.Localization.AdvancedSubject + ":" %>' />
                            <asp:RequiredFieldValidator runat="server" ID="SubjectValidator" ControlToValidate="SubjectText"
                                EnableClientScript="true" Display="None" CssClass="rsValidatorMsg" Enabled="false" />
                        </li>
                        <li class="rfbRow rfbCompactRow rsAllDayWrapper">
                            <asp:CheckBox runat="server" ID="AllDayEvent" CssClass="rsAdvChkWrap" Checked="false" />
                        </li>
                        <li class="rfbRow rfbCompactRow">
                            <label class="rfbLabel" for='<%= StartDate.ClientID %>_dateInput_text'>
                                <%= PageScheduler.Localization.AdvancedFrom%></label>
                            <kspwc:TRadDatePicker runat="server" ID="StartDate" CssClass="rsAdvDatePicker"
                                Width="83px" SharedCalendarID="SharedCalendar" Culture='<%# PageScheduler.Culture %>'
                                MinDate="1900-01-01">
                                <DatePopupButton Visible="True" />
                                <DateInput ID="DateInput2" runat="server" DateFormat='<%# PageScheduler.AdvancedForm.DateFormat %>'
                                    EmptyMessageStyle-CssClass="riError" EmptyMessage=" " />
                            </kspwc:TRadDatePicker>
                            <telerik:RadTimePicker runat="server" ID="StartTime" CssClass="rsAdvTimePicker"
                                Width="65px" Culture='<%# PageScheduler.Culture %>'>
                                <DateInput ID="DateInput3" runat="server" EmptyMessageStyle-CssClass="riError" EmptyMessage=" " />
                                <TimePopupButton Visible="true" />
                                <TimeView ID="TimeView1" runat="server" Columns="2" ShowHeader="false" StartTime="08:00"
                                    EndTime="18:00" Interval="00:30" />
                            </telerik:RadTimePicker>
                        </li>
                        <li class="rfbRow rfbCompactRow rsTimeZonesWrapper hidden">
                            <telerik:RadComboBox runat="server" ID="TimeZonesDropDown" Width="230"
                                LabelCssClass="rfbLabel" Label="<%# PageScheduler.Localization.AdvancedTimeZone %>">
                            </telerik:RadComboBox>
                        </li>
                        <li class="rfbRow rsTimePick rsEndTimePick">
                            <label class="rfbLabel" for='<%= EndDate.ClientID %>_dateInput_text'>
                                <%= PageScheduler.Localization.AdvancedTo%></label>
                            <kspwc:TRadDatePicker runat="server" ID="EndDate" CssClass="rsAdvDatePicker"
                                Width="83px" SharedCalendarID="SharedCalendar" Culture='<%# PageScheduler.Culture %>'
                                MinDate="1900-01-01">
                                <DatePopupButton Visible="True" />
                                <DateInput ID="DateInput4" runat="server" DateFormat='<%# PageScheduler.AdvancedForm.DateFormat %>'
                                    EmptyMessageStyle-CssClass="riError" EmptyMessage=" " />
                            </kspwc:TRadDatePicker>
                            <telerik:RadTimePicker runat="server" ID="EndTime" CssClass="rsAdvTimePicker"
                                Width="65px" Culture='<%# PageScheduler.Culture %>'>
                                <DateInput ID="DateInput5" runat="server" EmptyMessageStyle-CssClass="riError" EmptyMessage=" " />
                                <TimePopupButton Visible="true" />
                                <TimeView ID="TimeView2" runat="server" Columns="2" ShowHeader="false" StartTime="08:00"
                                    EndTime="18:00" Interval="00:30" />
                            </telerik:RadTimePicker>
                        </li>
                    </ul>
                    <div id="divReminderWrapper" class="rfbRow rfbCompactRow rsReminderWrapper">
                        <telerik:RadComboBox runat="server" ID="ReminderDropDown" Width="120px" Label="<%# PageScheduler.Localization.Reminder %>"
                            LabelCssClass="rfbLabel" Height="250">
                            <Items>
                                <telerik:RadComboBoxItem Text='<%# PageScheduler.Localization.ReminderNone %>' Value="" />
                                <telerik:RadComboBoxItem Text='<%# "0 " + PageScheduler.Localization.ReminderMinutes %>'
                                    Value="0" />
                                <telerik:RadComboBoxItem Text='<%# "5 " + PageScheduler.Localization.ReminderMinutes %>'
                                    Value="5" />
                                <telerik:RadComboBoxItem Text='<%# "10 " + PageScheduler.Localization.ReminderMinutes %>'
                                    Value="10" />
                                <telerik:RadComboBoxItem Text='<%# "15 " + PageScheduler.Localization.ReminderMinutes %>'
                                    Value="15" />
                                <telerik:RadComboBoxItem Text='<%# "30 " + PageScheduler.Localization.ReminderMinutes %>'
                                    Value="30" />
                                <telerik:RadComboBoxItem Text='<%# "1 " + PageScheduler.Localization.ReminderHour %>' Value="60" />
                                <telerik:RadComboBoxItem Text='<%# "2 " + PageScheduler.Localization.ReminderHours %>' Value="120" />
                                <telerik:RadComboBoxItem Text='<%# "3 " + PageScheduler.Localization.ReminderHours %>' Value="180" />
                                <telerik:RadComboBoxItem Text='<%# "4 " + PageScheduler.Localization.ReminderHours %>' Value="240" />
                                <telerik:RadComboBoxItem Text='<%# "5 " + PageScheduler.Localization.ReminderHours %>' Value="300" />
                                <telerik:RadComboBoxItem Text='<%# "6 " + PageScheduler.Localization.ReminderHours %>' Value="360" />
                                <telerik:RadComboBoxItem Text='<%# "7 " + PageScheduler.Localization.ReminderHours %>' Value="420" />
                                <telerik:RadComboBoxItem Text='<%# "8 " + PageScheduler.Localization.ReminderHours %>' Value="480" />
                                <telerik:RadComboBoxItem Text='<%# "9 " + PageScheduler.Localization.ReminderHours %>' Value="540" />
                                <telerik:RadComboBoxItem Text='<%# "10 " + PageScheduler.Localization.ReminderHours %>' Value="600" />
                                <telerik:RadComboBoxItem Text='<%# "11 " + PageScheduler.Localization.ReminderHours %>' Value="660" />
                                <telerik:RadComboBoxItem Text='<%# "12 " + PageScheduler.Localization.ReminderHours %>' Value="720" />
                                <telerik:RadComboBoxItem Text='<%# "18 " + PageScheduler.Localization.ReminderHours %>' Value="1080" />
                                <telerik:RadComboBoxItem Text='<%# "1 " + PageScheduler.Localization.ReminderDays %>' Value="1440" />
                                <telerik:RadComboBoxItem Text='<%# "2 " + PageScheduler.Localization.ReminderDays %>' Value="2880" />
                                <telerik:RadComboBoxItem Text='<%# "3 " + PageScheduler.Localization.ReminderDays %>' Value="4320" />
                                <telerik:RadComboBoxItem Text='<%# "4 " + PageScheduler.Localization.ReminderDays %>' Value="5760" />
                                <telerik:RadComboBoxItem Text='<%# "1 " + PageScheduler.Localization.ReminderWeek %>' Value="10080" />
                                <telerik:RadComboBoxItem Text='<%# "2 " + PageScheduler.Localization.ReminderWeeks %>' Value="20160" />
                            </Items>
                        </telerik:RadComboBox>
                    </div>
                    <asp:RequiredFieldValidator runat="server" ID="StartDateValidator" ControlToValidate="StartDate"
                        EnableClientScript="true" Display="None" CssClass="rsValidatorMsg" Enabled="false" />
                    <asp:RequiredFieldValidator runat="server" ID="StartTimeValidator" ControlToValidate="StartTime"
                        EnableClientScript="true" Display="None" CssClass="rsValidatorMsg" Enabled="false" />
                    <asp:RequiredFieldValidator runat="server" ID="EndDateValidator" ControlToValidate="EndDate"
                        EnableClientScript="true" Display="None" CssClass="rsValidatorMsg" Enabled="false" />
                    <asp:RequiredFieldValidator runat="server" ID="EndTimeValidator" ControlToValidate="EndTime"
                        EnableClientScript="true" Display="None" CssClass="rsValidatorMsg" Enabled="false" />
                    <asp:CustomValidator runat="server" ID="DurationValidator" ControlToValidate="StartDate"
                        EnableClientScript="false" Display="Dynamic" CssClass="rsValidatorMsg rsInvalid"
                        OnServerValidate="DurationValidator_OnServerValidate" Enabled="false" />
                </asp:Panel>
                <asp:Panel runat="server" ID="AdvancedControlsPanel" CssClass="rsAdvMoreControls">
                    <ul class="rfbGroup">
                        <li class="rfbRow rfbCompactRow">
                            <label class="rfbLabel">
                                [%Barva%]:
                            </label>
                            <telerik:RadColorPicker ID="AppointmentColorPicker" runat="server" CssClass="rsAdvResourceValue"
                                ShowIcon="true" PaletteModes="All" KeepInScreenBounds="true" Width="250">
                            </telerik:RadColorPicker>
                        </li>
                        <li class="rfbRow rfbCompactRow">
                            <label class="rfbLabel">
                                [%Kalendáře%]:
                            </label>
                            <scheduler:ResourceControl runat="server" ID="ResKalendare" Type="Kalendare"  />
                        </li>
                        <li class="rfbRow rfbCompactRow">
                            <label class="rfbLabel">
                                [%Zaměstnanci%]:
                            </label>
                            <scheduler:MultipleValuesResourceControl runat="server" ID="ResZamestnanci" Type="Zamestnanci"/>
                        </li>
                        <!-- Optionally add more ResourceControl instances here -->
                    </ul>
                </asp:Panel>
                <ul class="rfbGroup">
                    <li class="rfbRow">
                        <telerik:RadTextBox runat="server" ID="DescriptionText" TextMode="MultiLine" Columns="50"
                            LabelCssClass="rfbLabel" Rows="5" Width="100%" Label='<%# PageScheduler.Localization.AdvancedDescription + ":" %>'
                            Text='<%# Eval("Description") %>' />
                    </li>
                </ul>
                <span class="rsAdvResetExceptions">
                    <asp:LinkButton runat="server" ID="ResetExceptions" OnClick="ResetExceptions_OnClick" />
                </span>
                <telerik:RadSchedulerRecurrenceEditor runat="server"
                    ID="AppointmentRecurrenceEditor" />
                <asp:HiddenField runat="server" ID="OriginalRecurrenceRule" />
                <telerik:RadCalendar runat="server" ID="SharedCalendar" CultureInfo='<%# PageScheduler.Culture %>'
                    ShowRowHeaders="false" RangeMinDate="1900-01-01" />
            </asp:Panel>
        </div>
        <asp:Panel runat="server" ID="ButtonsPanel" CssClass="rsAdvancedSubmitArea">
            <div class="rsAdvButtonWrapper">
                <telerik:RadButton runat="server" ID="UpdateButton" CssClass="rsAdvEditSave kstlacitko" Icon-PrimaryIconCssClass="fi fi-disk" Text='<%# PageScheduler.Localization.Save %>'>
                </telerik:RadButton>
                <telerik:RadButton runat="server" ID="CancelButton" CssClass="rsAdvEditCancel kstlacitko" Icon-PrimaryIconCssClass="fi fi-ban" CommandName="Cancel" Text='<%# PageScheduler.Localization.Cancel %>'
                    CausesValidation="false">
                </telerik:RadButton>
                <telerik:RadButton runat="server" ID="AdvancedEditCloseButton" CssClass="rsAdvEditClose hidden kstlacitko"
                    CommandName="Cancel" CausesValidation="false" ToolTip='<%# PageScheduler.Localization.AdvancedClose %>'
                    Text='<%# PageScheduler.Localization.AdvancedClose %>'>
                </telerik:RadButton>
            </div>
        </asp:Panel>
    </div>
</div>
