﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="PremieCerpaniSchvalovani.ascx.cs" Inherits="KSPortal.Controls.PremieCerpaniSchvalovani" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<style type="text/css">
    div.rgBatchContainer > span, div.rgBatchContainer > input {
        width: 100% !important;
    }

    .ksGridCommandTemplateControl {
        margin-top: 2px !important;
    }

    .tbZustatek {
        margin-left: 15px !important;
    }
</style>
<telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy354" runat="server">
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="TRG_premie">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="TRG_premie" />
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>
<telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">
    <script type="text/javascript" id="telerikClientEvents1">
        function TRG_premie_BatchEditOpening(sender, args) {
            sender.get_masterTableView().get_dataItems();
            var item = $find(args.get_row().id);
            if (item.getDataKeyValue("editable") == "False")
                args.set_cancel(true);
        }

        function RNTB_OnKeyPress(sender, args) {
            var c = args.get_keyCode();
            if ((c == 13)) {
                args.set_cancel(true);
                sender.blur();
                var grid = $find("<%=TRG_premie.ClientID %>");
                    var batchManager = grid.get_batchEditingManager();
                    var tableView = grid.get_masterTableView();
                    setTimeout(function () {
                        batchManager._tryCloseEdits(tableView);
                        setTimeout(function () {
                            batchManager.saveChanges(grid.get_masterTableView());
                        });
                    });
                }
            }

            function TRG_premie_OnBatchEditGetCellValue(sender, args) {
                if (args.get_columnUniqueName() === "castka") {
                    var cell = args.get_cell();
                    if (cell.getElementsByClassName("rlb").length > 0) {
                        var RLB = $get(cell.getElementsByClassName("rlb")[0].id);
                        var value = RLB.innerText;
                        args.set_cancel(true);
                        args.set_value(parseFloat(value).toFixed(2).replace('.', ','));
                    }
                }
            }

            function TRG_premie_OnBatchEditSetCellValue(sender, args) {
                if (args.get_columnUniqueName() === "castka") {
                    var value = args.get_value();
                    value = value ? value : 0;
                    var cell = args.get_cell();
                    if (cell.getElementsByClassName("rlb").length > 0) {
                        var RLB = $get(cell.getElementsByClassName("rlb")[0].id);
                        args.set_cancel(true);
                        RLB.innerText = value;
                    }
                }
            }

            function TRG_premie_OnBatchEditGetEditorValue(sender, args) {
                if (args.get_columnUniqueName() === "castka") {
                    var cell = args.get_cell();
                    var RNTB;
                    if (cell.getElementsByClassName("rntb").length > 0) {
                        args.set_cancel(true);
                        RNTB = $find(cell.getElementsByClassName("rntb")[0].id);
                        var curval = RNTB.get_value();
                        curval = curval.replace ? 0 : curval;
                        args.set_value(parseFloat(curval).toFixed(2).replace('.', ','));
                    }
                }
            }

            function TRG_premie_OnBatchEditSetEditorValue(sender, args) {
                if (args.get_columnUniqueName() === "castka") {
                    var value = args.get_value();
                    value = value ? value : 0;
                    var cell = args.get_cell();
                    if (cell.getElementsByClassName("rntb").length > 0) {
                        var RNTB = $find(cell.getElementsByClassName("rntb")[0].id);
                        args.set_cancel(true);
                        RNTB.set_value(value);
                    }
                }
            }

            function RCB_zmena_stavu_ItemsRequesting(sender, args) {
                sender.clearItems();
                var context = args.get_context();
                var row = getParentRow(sender);
                if (row) {
                    context["id_pozadavku"] = row.getDataKeyValue("id_pozadavku");
                }
            }

            function RCB_zmena_stavu_DropDownClosed(sender, args) {
                sender.clearItems();
            }

            function RCB_zmena_stavu_SelectedIndexChanged(sender, args) {
                var tableView = $find("<%=TRG_premie.ClientID %>").get_masterTableView();
                var stav = args.get_item().get_value();
                var row = getParentRow(sender);
                if (row) {
                    var id_poz = row.getDataKeyValue("id_pozadavku");
                    var popis = row.getDataKeyValue("popis")
                    PageMethods.ZmenaStavu(id_poz, stav, popis, function () { tableView.rebind(); });
                }
            }

            function getParentRow(sender) {
                var ret;
                var ownerGridElement = sender.get_element();
                var parentRowId = $(ownerGridElement).parents("tr").first()[0].id;
                var masterViewId = $(ownerGridElement).parents("table")[0].id
                if (parentRowId != "" && masterViewId != "") {
                    var tv = $find(masterViewId);
                    tv.get_dataItems();
                    ret = $find(parentRowId);
                }
                return ret;
            }
    </script>
</telerik:RadScriptBlock>
<kspwc:TRadGrid runat="server" ID="TRG_premie" AutoFilterControlWidth="false" AutoFilterWidth="true" AutoGenerateColumns="false" AllowSorting="true" AllowPaging="true"
    EnableGroupsExpandAll="true" GroupingEnabled="true" EnableHeaderContextMenu="true" EnableHeaderContextAggregatesMenu="true" AutoMasterGridWidth="true" OnItemCreated="TRG_premie_ItemCreated"
    ShowGroupPanel="true" MasterTableView-Caption="[%Odměny%]"
    OnNeedDataSource="TRG_premie_NeedDataSource" OnBatchEditCommand="TRG_premie_BatchEditCommand" OnItemDataBound="TRG_premie_ItemDataBound" OnItemCommand="TRG_premie_ItemCommand">
    <GroupingSettings ShowUnGroupButton="true" />
    <ClientSettings AllowDragToGroup="true">
        <ClientEvents OnBatchEditOpening="TRG_premie_BatchEditOpening" />
    </ClientSettings>
    <MasterTableView CommandItemDisplay="Top" ClientDataKeyNames="id_pozadavku,editable,popis" DataKeyNames="os_cislo,cislo_pom,id,id_zdroj,id_pozadavku,id_pracmist,castka,popis,editable" ShowFooter="true" ShowGroupFooter="true" EditMode="Batch">
        <BatchEditingSettings EditType="Row" />
        <CommandItemTemplate>
            <kspwc:GridCommandItemControl runat="server" ID="GCIC" SaveButton-Visible="true" DateControl="TRadObdobi">
            </kspwc:GridCommandItemControl>
            <kspwc:TRadButton runat="server" ID="TRB_InsertPozadavky" Text="[%Založit požadavky%]" CssClass="ksGridCommandTemplateControl kstlacitko" OnClick="TRB_InsertPozadavky_Click" Icon-PrimaryIconCssClass="fi fi-add"></kspwc:TRadButton>
                    <telerik:RadNumericTextBox runat="server" ID="RNTB_zustatek" Type="Currency" LabelCssClass="ksGridCommandTemplateControl tbZustatek" CssClass="ksGridCommandTemplateControl"
                        Label="[%Zůstatek rozpočtu%]" ReadOnly="true" LabelWidth="100" Width="210">
                    </telerik:RadNumericTextBox>
        </CommandItemTemplate>
        <ColumnGroups>
            <telerik:GridColumnGroup Name="ev" HeaderText="[%Evidenční údaje%]">
                <HeaderStyle CssClass="ks-gradient" />
            </telerik:GridColumnGroup>
            <telerik:GridColumnGroup Name="od" HeaderText="[%Odměny%]">
                <HeaderStyle CssClass="ks-gradient" />
            </telerik:GridColumnGroup>
            <telerik:GridColumnGroup Name="wf" HeaderText="[%Schvalování%]">
                <HeaderStyle CssClass="ks-gradient" />
            </telerik:GridColumnGroup>
        </ColumnGroups>
        <Columns>
            <telerik:GridBoundColumn UniqueName="prijmeni" DataField="prijmeni" DataType="System.String" HeaderText="[%Příjmení%]" ReadOnly="true" ColumnGroupName="ev"></telerik:GridBoundColumn>
            <telerik:GridBoundColumn UniqueName="jmeno" DataField="jmeno" DataType="System.String" HeaderText="[%Jméno%]" ReadOnly="true" ColumnGroupName="ev"></telerik:GridBoundColumn>
            <telerik:GridNumericColumn UniqueName="os_cislo" DataField="os_cislo" DataType="System.Decimal" HeaderText="[%Os. číslo%]" NumericType="Number" HeaderStyle-Width="70" ReadOnly="true" ColumnGroupName="ev"></telerik:GridNumericColumn>
            <telerik:GridNumericColumn UniqueName="cislo_pom" DataField="cislo_pom" DataType="System.Int16" HeaderText="[%Č. p.%]" NumericType="Number" HeaderStyle-Width="60" ReadOnly="true" ColumnGroupName="ev"></telerik:GridNumericColumn>
            <telerik:GridNumericColumn UniqueName="prac_kateg" DataField="prac_kateg" DataType="System.Int16" HeaderText="[%P. kat.%]" NumericType="Number" Display="false" HeaderStyle-Width="70" ReadOnly="true" ColumnGroupName="ev"></telerik:GridNumericColumn>
            <telerik:GridBoundColumn UniqueName="naz_kat" DataField="naz_kat" DataType="System.String" HeaderText="[%Prac. kategorie%]" ReadOnly="true" ColumnGroupName="ev"></telerik:GridBoundColumn>
            <telerik:GridBoundColumn UniqueName="skup_prac" DataField="skup_prac" DataType="System.String" HeaderText="[%Skup. p.%]" Display="false" HeaderStyle-Width="70" ReadOnly="true" ColumnGroupName="ev"></telerik:GridBoundColumn>
            <telerik:GridBoundColumn UniqueName="skup_prac_nazev" DataField="skup_prac_nazev" DataType="System.String" HeaderText="[%Skupina pracujících%]" Display="false" ReadOnly="true" ColumnGroupName="ev"></telerik:GridBoundColumn>
            <telerik:GridBoundColumn UniqueName="prac_str" DataField="prac_str" DataType="System.String" HeaderText="[%Prac. stř.%]" Display="false" HeaderStyle-Width="70" ReadOnly="true" ColumnGroupName="ev"></telerik:GridBoundColumn>
            <telerik:GridBoundColumn UniqueName="str_nazev" DataField="str_nazev" DataType="System.String" HeaderText="[%Prac. středisko%]" ReadOnly="true" ColumnGroupName="ev"></telerik:GridBoundColumn>
            <telerik:GridNumericColumn UniqueName="skup_str" DataField="skup_str" DataType="System.Int32" HeaderText="[%Č. skup.%]" NumericType="Number" Display="false" HeaderStyle-Width="60" ReadOnly="true" ColumnGroupName="ev"></telerik:GridNumericColumn>
            <telerik:GridBoundColumn UniqueName="skup_nazev" DataField="skup_nazev" DataType="System.String" HeaderText="[%Skupina středisek%]" ReadOnly="true" ColumnGroupName="ev"></telerik:GridBoundColumn>
            <telerik:GridNumericColumn UniqueName="cis_divize" DataField="cis_divize" DataType="System.Int32" HeaderText="[%Č. div.%]" NumericType="Number" Display="false" HeaderStyle-Width="60" ReadOnly="true" ColumnGroupName="ev"></telerik:GridNumericColumn>
            <telerik:GridBoundColumn UniqueName="naz_divize" DataField="naz_divize" DataType="System.String" HeaderText="[%Divize%]" ReadOnly="true" ColumnGroupName="ev"></telerik:GridBoundColumn>
            <%--<telerik:GridNumericColumn UniqueName="castka" DataField="castka" DataType="System.Decimal" HeaderText="[%Částka%]" NumericType="Currency" Aggregate="Sum"></telerik:GridNumericColumn>--%>
            <telerik:GridTemplateColumn FilterControlAltText="Filter castka column" UniqueName="castka"
                DataField="castka" DataType="System.Decimal" HeaderText="[%Prémie%]" Aggregate="Sum" ColumnGroupName="od">
                <EditItemTemplate>
                    <telerik:RadNumericTextBox ID="RNTB_Castka" runat="server" DbValue='<%# Bind("castka") %>'
                        MinValue="0" ShowSpinButtons="True" Width="100%" CssClass="rntb">
                        <IncrementSettings Step="100" InterceptMouseWheel="False" />
                        <ClientEvents OnKeyPress="RNTB_OnKeyPress" />
                    </telerik:RadNumericTextBox>
                </EditItemTemplate>
                <ItemTemplate>
                    <telerik:RadLabel ID="RL_Castka" runat="server" Text='<%# Eval("castka") %>' CssClass="rlb">
                    </telerik:RadLabel>
                </ItemTemplate>
                <ItemStyle Font-Bold="True" />
            </telerik:GridTemplateColumn>
            <telerik:GridTemplateColumn FilterControlAltText="Filter popis column" UniqueName="popis"
                DataField="popis" DataType="System.String" HeaderText="[%Popis%]" ColumnGroupName="od">
                <EditItemTemplate>
                    <telerik:RadTextBox ID="RTB_Popis" runat="server" Text='<%# Bind("popis") %>'
                        Width="100%" MaxLength="100" CssClass="rntb">
                        <ClientEvents OnKeyPress="RNTB_OnKeyPress" />
                    </telerik:RadTextBox>
                </EditItemTemplate>
                <ItemTemplate>
                    <telerik:RadLabel ID="RL_Popis" runat="server" Text='<%# Eval("popis") %>' CssClass="rlb">
                    </telerik:RadLabel>
                </ItemTemplate>
                <ItemStyle Font-Bold="True" />
            </telerik:GridTemplateColumn>
            <telerik:GridNumericColumn UniqueName="zustatek" DataField="zustatek" DataType="System.Decimal" HeaderText="[%Zůstatek%]" NumericType="Currency" ReadOnly="true" Display="false" ColumnGroupName="od"></telerik:GridNumericColumn>
            <telerik:GridTemplateColumn UniqueName="stav_pozadavku" DataField="stav_pozadavku" DataType="System.String" ReadOnly="true" HeaderText="[%Stav%]" ColumnGroupName="wf">
                <ItemTemplate>
                    <telerik:RadComboBox ID="RCB_zmena_stavu" runat="server" Text='<%# Eval("stav_pozadavku") %>'
                        EnableLoadOnDemand="true" OnItemsRequested="RCB_zmena_stavu_ItemsRequested" OnClientItemsRequesting="RCB_zmena_stavu_ItemsRequesting" OnClientSelectedIndexChanged="RCB_zmena_stavu_SelectedIndexChanged"
                        OnClientDropDownClosed="RCB_zmena_stavu_DropDownClosed" AutoPostBack="False" Width="110px" DropDownAutoWidth="Enabled" ShowMoreResultsBox="true">
                    </telerik:RadComboBox>
                </ItemTemplate>
            </telerik:GridTemplateColumn>
            <telerik:GridBoundColumn UniqueName="sys_stav_t" DataField="sys_stav_t" DataType="System.String" HeaderText="[%Sys. stav%]" ReadOnly="true" ColumnGroupName="wf"></telerik:GridBoundColumn>
            <telerik:GridBoundColumn UniqueName="faze_pozadavku" DataField="faze_pozadavku" DataType="System.String" HeaderText="[%Fáze%]" ReadOnly="true" ColumnGroupName="wf"></telerik:GridBoundColumn>
            <telerik:GridTemplateColumn UniqueName="id_pozadavku" DataField="id_pozadavku" DataType="System.Int32" HeaderText="[%Požadavek%]" ReadOnly="true" ColumnGroupName="wf">
                <ItemTemplate>
                    <kspwc:TRadButton runat="server" ID="TRB_pozadavek" ButtonType="LinkButton" Text='<%# Eval("id_pozadavku") %>' CommandName="pozadavek" CommandArgument='<%# Eval("id_pozadavku") %>'></kspwc:TRadButton>
                </ItemTemplate>
            </telerik:GridTemplateColumn>
            <telerik:GridCheckBoxColumn UniqueName="editable" DataField="editable" DataType="System.Boolean" HeaderText="[%Editační%]" ReadOnly="true" Display="false" ColumnGroupName="wf"></telerik:GridCheckBoxColumn>
        </Columns>
    </MasterTableView>
</kspwc:TRadGrid>