﻿<%@ Control Language="C#" AutoEventWireup="true" Inherits="Controls_ZadostOsluzc" CodeBehind="ZadostOsluzc.ascx.cs" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<%@ Register TagPrefix="uc" TagName="CestovniPrikaz" Src="~/Controls/CestovniPrikaz.ascx" %>

    <style type="text/css">
        .noborder {
            margin-bottom: 15px;
            width: 100%;
        }

        .noborder table{
            width: 100%;
        }
    </style>

<!-- ZadostOSluzc BEG -->
<asp:ObjectDataSource ID="ObjectDataSource1" runat="server"
    OldValuesParameterFormatString="original_{0}" SelectMethod="Retrieve" TypeName="KSProgram.Pozadavky.Pozadaveksluzc"
    InsertMethod="Insert" UpdateMethod="Update"
    OnUpdated="ObjectDataSource1_Updated" OnUpdating="ObjectDataSource1_Updating"
    OnInserting="ObjectDataSource1_Inserting"
    OnInserted="ObjectDataSource1_Inserted">
    <SelectParameters>
        <asp:Parameter Name="id_pozadavku" Type="Int32" DefaultValue="" />
    </SelectParameters>
    <InsertParameters>
        <asp:Parameter DefaultValue="0" Name="id_poz" Type="Int32" Direction="InputOutput" />
        <asp:Parameter Name="cislo_pom" Type="Int16" /> <%--//PR 05.09.2024 plní se z CP při ODS Inserting--%> 
        <asp:Parameter Name="datum_od" Type="DateTime" />
        <asp:Parameter Name="datum_do" Type="DateTime" />
        <asp:Parameter Name="cil" Type="String" />
        <asp:Parameter Name="ucel" Type="String" />
        <asp:Parameter Name="druh_dopr" Type="String" />
        <asp:Parameter Name="tabulka" Type="String" />
        <asp:Parameter Name="ev_cislo" Type="Int32" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
        <asp:Parameter Name="adresat" Type="Decimal" />
        <asp:Parameter Name="novy_stav" Type="String" DefaultValue="" />
        <asp:Parameter Name="duvod" Type="String" DefaultValue="" />
        <asp:Parameter Name="vydavatel" Type="Decimal" DefaultValue="0" />
        <%--//PR 19.9.2016--%>
    </InsertParameters>
    <UpdateParameters>
        <asp:Parameter Name="id_poz" Type="Int32" />
        <asp:Parameter Name="datum_od" Type="DateTime" />
        <asp:Parameter Name="datum_do" Type="DateTime" />
        <asp:Parameter Name="cil" Type="String" />
        <asp:Parameter Name="ucel" Type="String" />
        <asp:Parameter Name="druh_dopr" Type="String" />
        <asp:Parameter Name="tabulka" Type="String" />
        <asp:Parameter Name="ev_cislo" Type="Int32" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
    </UpdateParameters>
</asp:ObjectDataSource>
<asp:FormView ID="FormView1" runat="server" OnItemInserted="FormView1_ItemInserted" OnItemUpdated="FormView1_ItemUpdated" OnDataBound="FormView1_DataBound" CssClass="noborder">
    <%--PR 11.5.2018 fiktivní css aby tam telerik necpal rfdTable--%>
    <ItemTemplate>
        <asp:Table runat="server" ID="TableItem" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowItem">
                <asp:TableCell runat="server" ColumnSpan="4" ID="TableCellItem14x" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7x" runat="server" Text="[%Požadavek na služební cestu%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>

            <asp:TableRow runat="server" ID="TableRow7">
                <asp:TableCell runat="server" ID="TableCell11" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label13" runat="server" SkinID="DataFieldHeaderStyle" Text="[%ID požadavku%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell12">
                    <asp:Label ID="Label16" runat="server" Text='<%# DataBinder.Eval(Container.DataItem, "id_poz") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow1">
                <asp:TableCell runat="server" ID="TableCell1a" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label8a" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell2">
                    <asp:Label ID="Label9" runat="server" Text='<%# ( KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(Convert.ToDecimal(DataBinder.Eval(Container.DataItem, "os_cislo")))) %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRowItem2" Visible='<%# (int)Eval("ev_cislo")==0 %>'>
                <asp:TableCell runat="server" ID="TableCellItem3" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label1x" SkinID="DataFieldHeaderStyle" runat="server" Text="[%Od%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellItem4" SkinID="DataFieldStyle">
                    <asp:Label ID="LabelOd" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"datum_od"), "d") %>'></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellItem5" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label2x" runat="server" Text="[%Do%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellItem6" SkinID="DataFieldStyle">
                    <asp:Label ID="LabelDo" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"datum_do"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow2" Visible='<%# (int)Eval("ev_cislo")==0 %>'>
                <asp:TableCell runat="server" ID="TableCell7" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label14" runat="server" Text="[%Cíl%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCell8" SkinID="DataFieldStyle">
                    <asp:Label ID="Label15" runat="server" Text='<%# Bind("cil") %>' Height="39px" Width="200px"></asp:Label>
                </asp:TableCell>
            </asp:TableRow>


            <asp:TableRow runat="server" ID="TableRowItem3" Visible='<%# (int)Eval("ev_cislo")==0 %>'>
                <asp:TableCell runat="server" ID="TableCellItem7" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label3x" runat="server" Text="[%Účel%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCellItem8" SkinID="DataFieldStyle">
                    <asp:Label ID="LabelDuvodx" runat="server" Text='<%# Bind("ucel") %>' Height="39px" Width="200px"></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow5" Visible='<%# (int)Eval("ev_cislo")==0 %>'>
                <asp:TableCell runat="server" ID="TableCell13" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label5" runat="server" Text="[%Dopravní prostředek%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCell14" SkinID="DataFieldStyle">
                    <asp:Label ID="Label6" runat="server" Text='<%# Bind("druh_dopr") %>' Width="200px"></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRowItem4">
                <asp:TableCell runat="server" ID="TableCellItem9" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label4x" runat="server" Text="[%Vyřešit do%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCellItem10" SkinID="DataFieldStyle">
                    <asp:Label ID="LabelDatvyrizeni" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyridit_do"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow6">
                <asp:TableCell runat="server" ID="TableCell1" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label8" runat="server" Text="[%Aktuální stav a datum změny stavu%]:"></asp:Label>
                </asp:TableCell>

                <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell4" SkinID="DataFieldStyle">
                    <asp:Label ID="Label11" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"faze_stav_posl") %>'></asp:Label>
                </asp:TableCell>

                <asp:TableCell runat="server" ID="TableCell3" SkinID="DataFieldStyle">
                    <asp:Label ID="Label10" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyriz_datum"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow3">
                <asp:TableCell runat="server" ID="TableCell5" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label1" runat="server" Text="[%Aktuální krok k řešení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCell6" SkinID="DataFieldStyle">
                    <asp:Label ID="Label2" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"faze_akt_text") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <%--<asp:TableRow  runat="server" ID="TableRow4">
    <asp:TableCell  runat="server" ID="TableCell9" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
        <asp:Label ID="Label3" runat="server" Text="[%Aktuální%] [%adresát%]:"></asp:Label>
    </asp:TableCell>
    <asp:TableCell  ColumnSpan="3" runat="server" ID="TableCell10" SkinID="DataFieldStyle">
        <asp:Label ID="Label12" runat="server" Text='<%# string.Join(", ", KSProgram.Pozadavky.WorkflAdresat.GetJmenaAdresatu((string)DataBinder.Eval(Container.DataItem,"akt_adresat"), (decimal)DataBinder.Eval(Container.DataItem,"os_cislo"), (int)DataBinder.Eval(Container.DataItem,"id_os")).ToArray()) %>'></asp:Label>
    </asp:TableCell>
    </asp:TableRow>--%>

            <asp:TableRow runat="server" ID="TableRowItem5">
                <asp:TableCell ColumnSpan="4" runat="server" ID="TableCellItem11">
                </asp:TableCell>
            </asp:TableRow>
        </asp:Table>
    </ItemTemplate>

    <EditItemTemplate>
        <asp:Table runat="server" ID="TableEdit" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowEidt">
                <asp:TableCell runat="server" ColumnSpan="4" ID="TableCellItem14" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7" runat="server" Text="[%Úprava požadavku na služební cestu%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>

            <asp:TableRow runat="server" ID="TableRow7">
                <asp:TableCell runat="server" ID="TableCell11" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label13" runat="server" SkinID="DataFieldHeaderStyle" Text="[%ID požadavku%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell12">
                    <asp:Label ID="Label16" runat="server" Text='<%# DataBinder.Eval(Container.DataItem, "id_poz") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRowEdit1a">
                <asp:TableCell runat="server" ID="TableCell1aedit" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label8aedit" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell2">
                    <asp:Label ID="Label9" runat="server" Text='<%# ( KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(Convert.ToDecimal(DataBinder.Eval(Container.DataItem, "os_cislo")))) %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow6">
                <asp:TableCell runat="server" ID="TableCell1" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label8" runat="server" Text="[%Aktuální stav a datum změny stavu%]:"></asp:Label>
                </asp:TableCell>

                <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell4" SkinID="DataFieldStyle">
                    <asp:Label ID="Label11" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"faze_stav_posl") %>'></asp:Label>
                </asp:TableCell>

                <asp:TableCell runat="server" ID="TableCell3" SkinID="DataFieldStyle">
                    <asp:Label ID="Label10" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyriz_datum"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow3">
                <asp:TableCell runat="server" ID="TableCell5" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label1" runat="server" Text="[%Aktuální krok k řešení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCell6" SkinID="DataFieldStyle">
                    <asp:Label ID="Label2" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"faze_akt_text") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <%--<asp:TableRow  runat="server" ID="TableRow4">
    <asp:TableCell  runat="server" ID="TableCell9" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
        <asp:Label ID="Label3" runat="server" Text="[%Aktuální%] [%adresát%]:"></asp:Label>
    </asp:TableCell>
    <asp:TableCell  ColumnSpan="3" runat="server" ID="TableCell10" SkinID="DataFieldStyle">
        <asp:Label ID="Label12" runat="server" Text='<%# string.Join(", ", KSProgram.Pozadavky.WorkflAdresat.GetJmenaAdresatu((string)DataBinder.Eval(Container.DataItem,"akt_adresat"), (decimal)DataBinder.Eval(Container.DataItem,"os_cislo"), (int)DataBinder.Eval(Container.DataItem,"id_os")).ToArray()) %>'></asp:Label>
    </asp:TableCell>
    </asp:TableRow>--%>

            <asp:TableRow runat="server" ID="TableRowEdit4">
                <asp:TableCell runat="server" ID="TableCellEdit10" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label4" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCellEdit11" SkinID="DataFieldStyle">
                    <%--<wc:DateControl runat="server" ID="TextBoxDatVyrizeniEdit" SelectedDateTime='<%# Bind("vyridit_do") %>' />--%>
                    <wc:TRadDatePicker runat="server" ID="TextBoxDatVyrizeniEdit" DbSelectedDate='<%# Bind("vyridit_do") %>' Width="95px" />
                    <%--<asp:TextBox ID="TextBoxDatVyrizeniEdit" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyridit_do"), "d") %>' Width="95px"></asp:TextBox>
        <wc:TCalendarExtender runat="server" ID="CalendarDatVyrizeniEdit" TargetControlID="TextBoxDatVyrizeniEdit" PopupButtonID="ImageButton3"></wc:TCalendarExtender>
        <asp:ImageButton ID="ImageButton3" runat="server" ImageUrl="~/Images/calendar.png" />--%>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowEdit5">
                <asp:TableCell runat="server" ID="TableCellEdit12" ColumnSpan="4">
                </asp:TableCell>
            </asp:TableRow>
        </asp:Table>
    </EditItemTemplate>

    <InsertItemTemplate>
        <asp:Table runat="server" ID="TableInsert" SkinID="RamAPozadi ksprvek">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowInsert">
                <asp:TableCell runat="server" ColumnSpan="4" ID="TableCellItem14" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7" runat="server" Text="[%Nový požadavek na služební cestu%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>

            <asp:TableRow runat="server" ID="TableRowInsert5">
                <asp:TableCell runat="server" ID="TCInsert9" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label4" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert10" ColumnSpan="3" SkinID="DataFieldStyle">
                    <wc:TRadDatePicker runat="server" ID="TextBoxDatVyrizeniInsert" DbSelectedDate='<%# Bind("vyridit_do") %>' Width="95px" />
                    <%--<asp:TextBox ID="TextBoxDatVyrizeniInsert" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyridit_do"), "d") %>' Width="95px"></asp:TextBox>
        <wc:TCalendarExtender runat="server" ID="CalendarDatVyrizeni" TargetControlID="TextBoxDatVyrizeniInsert" PopupButtonID="ImageButton3i"></wc:TCalendarExtender>
        <asp:ImageButton ID="ImageButton3i" runat="server" ImageUrl="~/Images/calendar.png" />--%>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowInsert6">
                <asp:TableCell runat="server" ID="TCInsert11" ColumnSpan="4">
                    <asp:CustomValidator ID="PrekrytiIntervaluValidator" runat="server" OnServerValidate="PrekrytiIntervaluValidator_validate" ErrorMessage="[%Překrývající požadavky, nelze pokračovat%]"></asp:CustomValidator>
                    <asp:CheckBox ID="cbx_IgnorujPrekryti" runat="server" Text="[%Ignorovat překrytí%]" Visible="false" />
                </asp:TableCell>
            </asp:TableRow>
        </asp:Table>
    </InsertItemTemplate>
</asp:FormView>

<uc:CestovniPrikaz ID="CP" runat="server" />
<!-- ZadostOSluzc END -->
