﻿<%@ Control Language="C#" AutoEventWireup="true" Inherits="Controls_ZadostOstabs" CodeBehind="ZadostOstabs.ascx.cs" %>
<%--<%@ Register assembly="AjaxControlToolkit" namespace="AjaxControlToolkit" tagprefix="ajax" %>--%>
<%--<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>--%>
<asp:ObjectDataSource ID="ObjectDataSource1" runat="server"
    OldValuesParameterFormatString="original_{0}" SelectMethod="Retrieve" TypeName="KSProgram.Pozadavky.Pozadavekstabs"
    InsertMethod="Insert"
    OnUpdated="ObjectDataSource1_Updated" OnUpdating="ObjectDataSource1_Updating"
    OnInserting="ObjectDataSource1_Inserting"
    OnInserted="ObjectDataSource1_Inserted">
    <SelectParameters>
        <asp:Parameter Name="id_pozadavku" Type="Int32" DefaultValue="0" />
    </SelectParameters>
    <InsertParameters>
        <asp:Parameter DefaultValue="0" Name="id_poz" Type="Int32"
            Direction="InputOutput" />
        <asp:Parameter Name="id_poz_storno" Type="Int32" />
        <asp:Parameter Name="duvod" Type="String" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
        <asp:Parameter Name="adresat" Type="Decimal" />
    </InsertParameters>
</asp:ObjectDataSource>
<asp:ObjectDataSource ID="ds_absence" runat="server"
    OldValuesParameterFormatString="original_{0}" SelectMethod="GetAbsence"
    TypeName="KSProgram.Pozadavky.Pozadavekstabs">
    <SelectParameters>
        <asp:Parameter Name="id_poz" Type="Int32" />
        <asp:Parameter Name="id_abs" Type="Int32" DefaultValue="0" />
    </SelectParameters>
</asp:ObjectDataSource>
<asp:FormView ID="FormView1" runat="server"
    OnItemInserted="FormView1_ItemInserted" OnItemUpdated="FormView1_ItemUpdated"
    OnDataBound="FormView1_DataBound" DataKeyNames="os_cislo"
    OnLoad="FormView1_Load">
    <ItemTemplate>
        <asp:Table runat="server" ID="TableItem" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowItem">
                <asp:TableCell runat="server" ColumnSpan="2" ID="TableCellItem14x" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7x" runat="server" Text="[%Storno nepřítomnosti%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>

            <asp:TableRow runat="server" ID="TableRow1">
                <asp:TableCell runat="server" ID="TableCell1a" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label8a" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" SkinID="DataFieldStyle" ID="TableCell2">
                    <asp:Label ID="Label9" runat="server" Text='<%# ( KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(Convert.ToDecimal(DataBinder.Eval(Container.DataItem, "os_cislo")))) %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowItem2">
                <asp:TableCell runat="server" ID="TableCellItem3" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label1x" SkinID="DataFieldHeaderStyle" runat="server" Text="[%Druh nepřítomnosti na pracovišti%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellItem4" SkinID="DataFieldStyle">
                    <asp:Label ID="LabelOd" runat="server" Text='<%# Bind("absence_text") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowItem3">
                <asp:TableCell runat="server" ID="TableCellItem7" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label3x" runat="server" Text="[%Poznámka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellItem8" SkinID="DataFieldStyle">
                    <asp:Label ID="LabelDuvodx" runat="server" Text='<%# Bind("duvod") %>' Width="200px"></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowItem4">
                <asp:TableCell runat="server" ID="TableCellItem9" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label4x" runat="server" Text="[%Vyřešit do%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCellItem10" SkinID="DataFieldStyle">
                    <asp:Label ID="LabelDatvyrizeni" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyridit_do"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow6">
                <asp:TableCell runat="server" ID="TableCell1" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label8" runat="server" Text="[%Aktuální stav a datum změny stavu%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell4" SkinID="DataFieldStyle">
                    <asp:Label ID="Label11" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"stav") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
        </asp:Table>
    </ItemTemplate>
    <%--
<EditItemTemplate>
<asp:Table runat="server" ID="TableEdit"  SkinID="RamAPozadi">
<asp:TableHeaderRow runat="server" ID="TableHeaderRowEidt">
<asp:TableCell runat="server" ColumnSpan="2" ID="TableCellItem14" SkinID="TitleRowStyle">
    <asp:Label ID="Label7" runat="server" Text="[%Úprava stornování absence%]"></asp:Label>
</asp:TableCell>
</asp:TableHeaderRow>

<asp:TableRow runat="server" ID="TableRowEdit1a">
    <asp:TableCell  runat="server" ID="TableCell1aedit" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
        <asp:Label ID="Label8aedit" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
    </asp:TableCell>
    <asp:TableCell  runat="server" SkinID="DataFieldStyle" ID="TableCell2">
        <asp:Label ID="Label9" runat="server" Text='<%# ( KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(Convert.ToDecimal(DataBinder.Eval(Container.DataItem, "os_cislo")))) %>'></asp:Label>
    </asp:TableCell>
</asp:TableRow>

<asp:TableRow runat="server" ID="TableRowEdit1">
    <asp:TableCell runat="server" ID="TableCellEdit2" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
        <asp:Label ID="Label6x" runat="server" Text="[%Půl dne%]:"></asp:Label>
    </asp:TableCell>
    <asp:TableCell  runat="server" ID="TableCellEdit3" SkinID="DataFieldStyle">
        <asp:CheckBox ID="CheckBoxPuldenEdit" runat="server" Checked='<%# Bind("pul_dne") %>' AutoPostBack="True" oncheckedchanged="BoxPulden_CheckedChanged"></asp:CheckBox>
    </asp:TableCell>
</asp:TableRow>
<asp:TableRow runat="server" ID="TableRowEdit2">
<asp:TableCell  runat="server" ID="TableCellEdit4" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
    <asp:Label ID="Label1x" runat="server" Text="[%Od%]:"></asp:Label>
</asp:TableCell>
<asp:TableCell  runat="server" ID="TableCellEdit5" SkinID="DataFieldStyle" >
    <asp:TextBox ID="TextBoxOdEdit" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"datum_od"), "d") %>' Width="95px"></asp:TextBox>
    <ajax:CalendarExtender runat="server" ID="Calendar_dat_od" TargetControlID="TextBoxOdEdit" PopupButtonID="ImageButton1"></ajax:CalendarExtender>
    <asp:ImageButton ID="ImageButton1" runat="server" ImageUrl="~/Images/calendar.png" />
</asp:TableCell>
<asp:TableCell  runat="server" ID="TableCellEdit6" SkinID="DataFieldHeaderStyle" >
    <asp:Label ID="Label2x" runat="server" Text="[%Do%]:"></asp:Label>
</asp:TableCell>
<asp:TableCell  runat="server" ID="TableCellEdit7" SkinID="DataFieldStyle" >
    <asp:TextBox ID="TextBoxDoEdit" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"datum_do"), "d") %>' Width="95px"></asp:TextBox>
    <ajax:CalendarExtender runat="server" ID="Calendar_dat_do" TargetControlID="TextBoxDoEdit" PopupButtonID="ImageButtonDoEdit"></ajax:CalendarExtender>
    <asp:ImageButton ID="ImageButtonDoEdit" runat="server" ImageUrl="~/Images/calendar.png" />
</asp:TableCell>
</asp:TableRow>
<asp:TableRow  runat="server" ID="TableRowEdit3">
<asp:TableCell  runat="server" ID="TableCellEdit8"  HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
    <asp:Label ID="Label3x" runat="server" Text="[%Poznámka%]:"></asp:Label>
</asp:TableCell>
<asp:TableCell  runat="server" ID="TableCellEdit9"   SkinID="DataFieldStyle">
    <asp:TextBox ID="LabelDuvodx" runat="server" Text='<%# Bind("duvod") %>' MaxLength="999" TextMode="MultiLine" Width="284px"></asp:TextBox>
</asp:TableCell>
</asp:TableRow>
<asp:TableRow  runat="server" ID="TableRowEdit4">
<asp:TableCell  runat="server" ID="TableCellEdit10" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
    <asp:Label ID="Label4" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
</asp:TableCell>
<asp:TableCell  runat="server" ID="TableCellEdit11"  ColumnSpan="2" SkinID="DataFieldStyle">
    <asp:TextBox ID="TextBoxDatVyrizeniEdit" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyridit_do"), "d") %>' Width="95px"></asp:TextBox>
    <ajax:CalendarExtender runat="server" ID="CalendarDatVyrizeniEdit" TargetControlID="TextBoxDatVyrizeniEdit" PopupButtonID="ImageButton3"></ajax:CalendarExtender>
    <asp:ImageButton ID="ImageButton3" runat="server" ImageUrl="~/Images/calendar.png" />
</asp:TableCell>
</asp:TableRow>
<asp:TableRow  runat="server" ID="TableRowEdit5">
    <asp:TableCell  runat="server" ID="TableCellEdit12"  ColumnSpan="2">
    </asp:TableCell>
</asp:TableRow>
</asp:Table>
</EditItemTemplate>
    --%>
    <InsertItemTemplate>
        <asp:Table runat="server" ID="TableInsert" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowInsert">
                <asp:TableCell runat="server" ColumnSpan="2" ID="TableCellItem14" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7" runat="server" Text="[%Storno nepřítomnosti%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>

            <asp:TableRow runat="server" ID="TableRow1">
                <asp:TableCell runat="server" ID="TableCell1a" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label8a" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" SkinID="DataFieldStyle" ID="TableCell2">
                    <asp:Label ID="Label_zam" runat="server" Text=""></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowInsert2">
                <asp:TableCell runat="server" ID="TCInsert1" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label6" runat="server" Text="[%Druh nepřítomnosti na pracovišti%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert2" SkinID="DataFieldStyle">
                    <asp:DropDownList ID="ddl_absence_i" runat="server" DataSourceID="ds_absence" DataTextField="popis" DataValueField="id_abs" style="width:100%"></asp:DropDownList>
                    <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="RequiredFieldValidator" Text="[%Povinná položka%]" Display="Dynamic" ControlToValidate="ddl_absence_i"></asp:RequiredFieldValidator>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowInsert4">
                <asp:TableCell runat="server" ID="TCInsert7" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label3" runat="server" Text="[%Poznámka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert8" SkinID="DataFieldStyle">
                    <asp:TextBox ID="LabelDuvod" runat="server" Text='<%# Bind("duvod") %>' MaxLength="999" TextMode="MultiLine" Width="283px" Height="200"></asp:TextBox><br />
                    <kspwc:TextValidator runat="server" ID="val1" ControlToValidate="LabelDuvod"></kspwc:TextValidator>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRowInsert5">
                <asp:TableCell runat="server" ID="TCInsert9" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label4" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert10" SkinID="DataFieldStyle">
                    <%--<asp:TextBox ID="TextBoxDatVyrizeniInsert" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyridit_do"), "d") %>' Width="95px"></asp:TextBox>
    <ajax:CalendarExtender runat="server" ID="CalendarDatVyrizeni" TargetControlID="TextBoxDatVyrizeniInsert" PopupButtonID="ImageButton3i"></ajax:CalendarExtender>
    <asp:ImageButton ID="ImageButton3i" runat="server" ImageUrl="~/Images/calendar.png" />--%>
                    <kspwc:TRadDatePicker runat="server" ID="dat_vyriz"></kspwc:TRadDatePicker>
                    <%-- <kspwc:TRequiredValidator ID="TRequiredValidator1" runat="server" ControlToValidate="dat_vyriz" >
        </kspwc:TRequiredValidator> --%>
                </asp:TableCell>
            </asp:TableRow>
        </asp:Table>
    </InsertItemTemplate>
    <FooterTemplate>
        <%--<asp:CustomValidator ID="PrekrytiIntervaluValidator" runat="server" OnServerValidate="PrekrytiIntervaluValidator_validate" ErrorMessage="Překrývající požadavky, nelze pokračovat"></asp:CustomValidator>--%>
        <asp:CustomValidator ID="UzavrenaDochazkaValidator" runat="server" OnServerValidate="UzavrenaDochazkaValidator_validate" ErrorMessage="Docházka již byla potvrzena, nelze pokračovat"></asp:CustomValidator>
    </FooterTemplate>
</asp:FormView>
