﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ZadostOvozidlo.ascx.cs" Inherits="KSPortal.Controls.ZadostOvozidlo" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="kspwc" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<style type="text/css">
    .ZOVForm {
        min-width: 500px;
    }

        .ZOVForm td {
            min-width: 150px;
            min-height: 35px;
        }

        .ZOVForm tr {
            height: 30px;
        }
</style>

<asp:ObjectDataSource ID="ODS_phm" runat="server"
    OldValuesParameterFormatString="original_{0}" SelectMethod="Select"
    TypeName="KSProgram.Sluzebky.SlcCisPhm" EnableCaching="True" CacheDuration="60"></asp:ObjectDataSource>
<asp:ObjectDataSource ID="ODS_druh" runat="server"
    OldValuesParameterFormatString="original_{0}" SelectMethod="Select"
    TypeName="KSProgram.Sluzebky.SlcCisDruhDopr" EnableCaching="True" CacheDuration="60"></asp:ObjectDataSource>

<asp:ObjectDataSource ID="ObjectDataSource1" runat="server" OldValuesParameterFormatString="original_{0}"
    SelectMethod="Retrieve" TypeName="KSProgram.Pozadavky.Pozadavekvozidlo" InsertMethod="Insert"
    UpdateMethod="Update" OnInserted="ObjectDataSource1_Inserted">
    <InsertParameters>
        <asp:Parameter DefaultValue="0" Name="id_poz" Type="Int32" Direction="InputOutput" />

        <asp:Parameter Name="adresat" Type="Decimal" />
        <asp:Parameter Name="novy_stav" Type="String" />
        <asp:Parameter Name="duvod" Type="String" />
    </InsertParameters>
    <UpdateParameters>
        <asp:Parameter Name="id_poz" Type="Int32" />
    </UpdateParameters>
    <SelectParameters>
        <asp:Parameter Name="id_pozadavku" Type="Int32" DefaultValue="0" />
    </SelectParameters>
</asp:ObjectDataSource>

<asp:FormView ID="FormView1" runat="server" CssClass="ZOVForm ksprvek" OnItemInserted="FormView1_ItemInserted"
    OnItemUpdated="FormView1_ItemUpdated" OnDataBound="FormView1_DataBound" DataSourceID="ObjectDataSource1">
    <EditItemTemplate>
        <asp:Table runat="server" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server">
                <asp:TableCell runat="server" ColumnSpan="4" SkinID="TitleRowStyle">
                    <asp:Label ID="Label1" runat="server" Text="[%Žádost o přidání vozidla%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>

            <asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="spz_L" runat="server" Text="[%Registrační značka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle">
                    <kspwc:TTextBox ID="spz" runat="server" Text='<%# Bind("spz") %>' MaxLength="9" Width="9em" CssClass="input povinne-pole"
                        onchange="this.value=value.toUpperCase().replace(/[^A-Z 0-9]+/g,'')"></kspwc:TTextBox>

                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="nazev_L" runat="server" Text="[%Název%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle">
                    <kspwc:TTextBox ID="nazev" runat="server" Text='<%# Bind("nazev") %>' MaxLength="40" Width="30em" CssClass="input povinne-pole"></kspwc:TTextBox>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="druh_L" runat="server" Text="[%Druh%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle">
                    <telerik:RadDropDownList ID="druh" runat="server" Width="15em" CssClass="povinne-pole" SelectedValue='<%# Bind("druh") %>'
                        AutoPostBack="false">
                        <Items>
                            <telerik:DropDownListItem Value="AUV" Text="AUV - Automobil vlastní" />
                        </Items>
                    </telerik:RadDropDownList>
                    <%--DataSourceID="ODS_druh" DataValueField="kod" DataTextField="cely_nazev"--%>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="phm_L" runat="server" Text="[%Pohonná hmota%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle">
                    <telerik:RadDropDownList ID="phm" runat="server" Width="15em" CssClass="povinne-pole"
                        DataSourceID="ODS_phm" DataValueField="id" DataTextField="nazev" SelectedValue='<%# Bind("phm") %>'
                        AutoPostBack="false">
                    </telerik:RadDropDownList>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="prum_spotreba_L" runat="server" Text="[%Kombinovaná spotřeba%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle">
                    <kspwc:TTextBox ID="prum_spotreba" runat="server" Text='<%# Bind("prum_spotreba") %>' MaxLength="6" Width="4em" CssClass="input povinne-pole"></kspwc:TTextBox>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="hav_poj_L" runat="server" Text="[%Číslo havarijního pojištění%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" SkinID="DataFieldStyle">
                    <kspwc:TTextBox ID="hav_poj" runat="server" Text='<%# Bind("hav_poj") %>' MaxLength="15" Width="15em" CssClass="input"></kspwc:TTextBox>
                </asp:TableCell>
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="hav_poj_do_L" runat="server" Text="[%Platí do%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" SkinID="DataFieldStyle">
                    <kspwc:TRadDatePicker runat="server" ID="hav_poj_do" DbSelectedDate='<%# Bind("hav_poj_do") %>' Width="10em" />
                </asp:TableCell>
            </asp:TableRow>
            <%--<asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> <asp:Label ID="vyridit_do_L" runat="server" Text="[%Vyřídit do%]:"></asp:Label> </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> <kspwc:TRadDatePicker runat="server" ID="vyridit_do" DbSelectedDate='<%# Bind("vyridit_do") %>' Width="15em"/> </asp:TableCell>
            </asp:TableRow>--%>
        </asp:Table>
    </EditItemTemplate>
    <ItemTemplate>
        <asp:Table runat="server" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server">
                <asp:TableCell runat="server" ColumnSpan="4" SkinID="TitleRowStyle">
                    <asp:Label ID="Label1" runat="server" Text="[%Žádost o přidání vozidla%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>
            <asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="spz_L" runat="server" Text="[%Registrační značka%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> <%# Eval("spz") %> </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="nazev_L" runat="server" Text="[%Název%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> <%# Eval("nazev") %> </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="druh_L" runat="server" Text="[%Druh%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle">
                     <%# Eval("druh") %>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="phm_L" runat="server" Text="[%Pohonná hmota%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle">
                    <%# Eval("phm") %>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="prum_spotreba_L" runat="server" Text="[%Kombinovaná spotřeba%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> <%# Eval("prum_spotreba") %> </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="hav_poj_L" runat="server" Text="[%Číslo havarijního pojištění%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" SkinID="DataFieldStyle"> <%# Eval("hav_poj") %> </asp:TableCell>
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="hav_poj_do_L" runat="server" Text="[%Platí do%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" SkinID="DataFieldStyle"> <%# Eval("hav_poj_do") %> </asp:TableCell>
            </asp:TableRow>
            <%--<asp:TableRow runat="server">
                <asp:TableCell runat="server" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle"> <asp:Label ID="vyridit_do_L" runat="server" Text="[%Vyřídit do%]:"></asp:Label> </asp:TableCell>
                <asp:TableCell runat="server" ColumnSpan="3" SkinID="DataFieldStyle"> <%# Eval("vyridit_do") %> </asp:TableCell>
            </asp:TableRow>--%>
        </asp:Table>
    </ItemTemplate>
</asp:FormView>
<span class="tiskHide">
    <asp:CustomValidator runat="server" ID="Validator" OnServerValidate="Validator_ServerValidate"></asp:CustomValidator>
</span>