﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ZadostOvydaje.ascx.cs" Inherits="KSPortal.Controls.ZadostOvydaje" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="tel" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>

<asp:ObjectDataSource ID="ObjectDataSource1" runat="server"
    OldValuesParameterFormatString="original_{0}" SelectMethod="Retrieve" TypeName="KSProgram.Pozadavky.Pozadavekvydaje"
    InsertMethod="Insert" UpdateMethod="Update"
    OnUpdating="ObjectDataSource1_Updating"
    OnInserting="ObjectDataSource1_Inserting"
    OnInserted="ObjectDataSource1_Inserted">
    <SelectParameters>
        <asp:Parameter Name="id_poz" Type="Int32" DefaultValue="" />
    </SelectParameters>
    <InsertParameters>
        <asp:Parameter DefaultValue="0" Name="id_poz" Type="Int32" Direction="InputOutput" />
        <asp:Parameter Name="os_cislo" Type="Decimal" />
        <asp:Parameter Name="cislo_pom" Type="Int16" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
        <asp:Parameter Name="obdobi" Type="DateTime" />
        <%--//PR 25.9.2017 HID=38123 ruším nastavování stavu, neboť ještě nejsou uloženy výdaje a exe:akce tedy nemají data
        <asp:Parameter Name="adresat" Type="Decimal" />
        <asp:Parameter Name="novy_stav" Type="String" DefaultValue="" />     
        <asp:Parameter Name="duvod" Type="String" DefaultValue="" />  --%>
    </InsertParameters>
    <UpdateParameters>
        <asp:Parameter Name="id_poz" Type="Int32" />
        <asp:Parameter Name="obdobi" Type="DateTime" />
        <asp:Parameter Name="vyridit_do" Type="DateTime" />
    </UpdateParameters>
</asp:ObjectDataSource>

<asp:FormView ID="FormView1" runat="server" OnItemInserted="FormView1_ItemInserted" OnItemUpdated="FormView1_ItemUpdated" OnDataBound="FormView1_DataBound">
    <ItemTemplate>
        <asp:Table runat="server" ID="TableItem" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowItem">
                <asp:TableCell runat="server" ColumnSpan="4" ID="TableCellItem14x" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7x" runat="server" Text="[%Požadavek na běžné výdaje%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>

            <asp:TableRow runat="server" ID="TableRow7">
                <asp:TableCell runat="server" ID="TableCell11" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label13" runat="server" SkinID="DataFieldHeaderStyle" Text="[%ID požadavku%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell12">
                    <asp:Label ID="Label16" runat="server" Text='<%# DataBinder.Eval(Container.DataItem, "id_poz") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow1">
                <asp:TableCell runat="server" ID="TableCell1a" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label8a" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell2">
                    <asp:Label ID="Label9" runat="server" Text='<%# ( KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(Convert.ToDecimal(DataBinder.Eval(Container.DataItem, "os_cislo")))) %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow2">
                <asp:TableCell runat="server" ID="TableCell7" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label5" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Prac. středisko%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell8">
                    <asp:Label ID="Label6" runat="server" Text='<%# DataBinder.Eval(Container.DataItem, "prac_str") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow5">
                <asp:TableCell runat="server" ID="TableCell13" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label14" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Divize%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell14">
                    <asp:Label ID="Label15" runat="server" Text='<%# DataBinder.Eval(Container.DataItem, "divize") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="bank_ucet_Row">
                <asp:TableCell runat="server" ID="TableCell9" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="bu_t_Lab" runat="server" SkinID="DataFieldHeaderStyle" Text="[%BÚ%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell10">
                    <asp:Label ID="bu_Lab" runat="server" Text='<%# KSProgram.Personal.Platby.GetUcet(Convert.ToDecimal(DataBinder.Eval(Container.DataItem, "os_cislo")), DateTime.Today) %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow9">
                <asp:TableCell runat="server" ID="TableCell17" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label19" runat="server" Text="[%Období%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCell18" SkinID="DataFieldStyle">
                    <asp:HiddenField runat="server" ID="HF_obdobi" Value='<%# Bind("obdobi") %>' />
                    <asp:Label ID="Label20" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"obdobi"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRowItem4">
                <asp:TableCell runat="server" ID="TableCellItem9" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label4x" runat="server" Text="[%Vyřešit do%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCellItem10" SkinID="DataFieldStyle">
                    <asp:Label ID="LabelDatvyrizeni" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"vyridit_do"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow6">
                <asp:TableCell runat="server" ID="TableCell1" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label8" runat="server" Text="[%Aktuální stav a datum změny stavu%]:"></asp:Label>
                </asp:TableCell>

                <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell4" SkinID="DataFieldStyle">
                    <asp:Label ID="Label11" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"faze_stav_posl") %>'></asp:Label>
                </asp:TableCell>

                <asp:TableCell runat="server" ID="TableCell3" SkinID="DataFieldStyle">
                    <asp:Label ID="Label10" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"datum_zmeny"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow3">
                <asp:TableCell runat="server" ID="TableCell5" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label1" runat="server" Text="[%Aktuální krok k řešení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCell6" SkinID="DataFieldStyle">
                    <asp:Label ID="Label2" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"faze_akt_text") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <%-- //PR 16.04.2020 zakomentováno, ta informace je dole v PozadavekDetail.aspx
    <asp:TableRow  runat="server" ID="TableRow4">
    <asp:TableCell  runat="server" ID="TableCell9" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
        <asp:Label ID="Label3" runat="server" Text="[%Aktuální%] [%adresát%]:"></asp:Label>
    </asp:TableCell>
    <asp:TableCell  ColumnSpan="3" runat="server" ID="TableCell10" SkinID="DataFieldStyle">
        <asp:Label ID="Label12" runat="server" Text='<%# string.Join(", ", KSProgram.Pozadavky.WorkflAdresat.GetJmenaAdresatu((string)DataBinder.Eval(Container.DataItem,"akt_adresat"), (decimal)DataBinder.Eval(Container.DataItem,"os_cislo"), (int)DataBinder.Eval(Container.DataItem,"id_os")).ToArray()) %>'></asp:Label>
    </asp:TableCell>
    </asp:TableRow>--%>
        </asp:Table>
    </ItemTemplate>
    <EditItemTemplate>
        <asp:Table runat="server" ID="TableEdit" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowEidt">
                <asp:TableCell runat="server" ColumnSpan="4" ID="TableCellItem14" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7" runat="server" Text="[%Požadavek na běžné výdaje%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>

            <asp:TableRow runat="server" ID="TableRow7">
                <asp:TableCell runat="server" ID="TableCell11" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label13" runat="server" SkinID="DataFieldHeaderStyle" Text="[%ID požadavku%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell12">
                    <asp:Label ID="Label16" runat="server" Text='<%# DataBinder.Eval(Container.DataItem, "id_poz") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRowEdit1a">
                <asp:TableCell runat="server" ID="TableCell1aedit" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label8aedit" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell2">
                    <asp:Label ID="Label9" runat="server" Text='<%# ( KSProgram.Funkce.Pracovnik.OsCisloPrijmeniJmeno(Convert.ToDecimal(DataBinder.Eval(Container.DataItem, "os_cislo")))) %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow2">
                <asp:TableCell runat="server" ID="TableCell7" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label5" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Prac. středisko%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell8">
                    <asp:Label ID="Lab_prac_str" runat="server" Text='<%# DataBinder.Eval(Container.DataItem, "prac_str") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow5">
                <asp:TableCell runat="server" ID="TableCell13" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label14" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Divize%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell14">
                    <asp:Label ID="Label15" runat="server" Text='<%# DataBinder.Eval(Container.DataItem, "divize") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="bank_ucet_Row">
                <asp:TableCell runat="server" ID="TableCell9" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="bu_t_Lab" runat="server" SkinID="DataFieldHeaderStyle" Text="[%BÚ%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell10">
                    <asp:Label ID="bu_Lab" runat="server" Text='<%# KSProgram.Personal.Platby.GetUcet(Convert.ToDecimal(DataBinder.Eval(Container.DataItem, "os_cislo")), DateTime.Today) %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow6">
                <asp:TableCell runat="server" ID="TableCell1" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label8" runat="server" Text="[%Aktuální stav a datum změny stavu%]:"></asp:Label>
                </asp:TableCell>

                <asp:TableCell ColumnSpan="2" runat="server" ID="TableCell4" SkinID="DataFieldStyle">
                    <asp:Label ID="Label11" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"faze_stav_posl") %>'></asp:Label>
                </asp:TableCell>

                <asp:TableCell runat="server" ID="TableCell3" SkinID="DataFieldStyle">
                    <asp:Label ID="Label10" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"datum_zmeny"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow3">
                <asp:TableCell runat="server" ID="TableCell5" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
                    <asp:Label ID="Label1" runat="server" Text="[%Aktuální krok k řešení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCell6" SkinID="DataFieldStyle">
                    <asp:Label ID="Label2" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"faze_akt_text") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <%-- //PR 16.04.2020 zakomentováno, ta informace je dole v PozadavekDetail.aspx
    <asp:TableRow  runat="server" ID="TableRow4">
    <asp:TableCell  runat="server" ID="TableCell9" SkinID="DataFieldHeaderStyle" HorizontalAlign="Right">
        <asp:Label ID="Label3" runat="server" Text="[%Aktuální%] [%adresát%]:"></asp:Label>
    </asp:TableCell>
    <asp:TableCell  ColumnSpan="3" runat="server" ID="TableCell10" SkinID="DataFieldStyle">
        <asp:Label ID="Label12" runat="server" Text='<%# string.Join(", ", KSProgram.Pozadavky.WorkflAdresat.GetJmenaAdresatu((string)DataBinder.Eval(Container.DataItem,"akt_adresat"), (decimal)DataBinder.Eval(Container.DataItem,"os_cislo"), (int)DataBinder.Eval(Container.DataItem,"id_os")).ToArray()) %>'></asp:Label>
    </asp:TableCell>
    </asp:TableRow>--%>

            <asp:TableRow runat="server" ID="TableRow10">
                <asp:TableCell runat="server" ID="TableCell19" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label21" runat="server" Text="[%Období%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCell20" SkinID="DataFieldStyle">
                    <asp:HiddenField runat="server" ID="HF_obdobi" Value='<%# Bind("obdobi") %>' />
                    <asp:Label ID="Label22" runat="server" Text='<%# KSProgram.Funkce.F_DateTime.DateTimeToString(DataBinder.Eval(Container.DataItem,"obdobi"), "d") %>'></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRowEdit4">
                <asp:TableCell runat="server" ID="TableCellEdit10" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label4" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" ID="TableCellEdit11" SkinID="DataFieldStyle">
                    <wc:TRadDatePicker runat="server" ID="TextBoxDatVyrizeniEdit" DbSelectedDate='<%# Bind("vyridit_do") %>' Width="95px" />
                </asp:TableCell>
            </asp:TableRow>

        </asp:Table>
    </EditItemTemplate>
    <InsertItemTemplate>
        <asp:Table runat="server" ID="TableInsert" SkinID="RamAPozadi">
            <asp:TableHeaderRow runat="server" ID="TableHeaderRowInsert">
                <asp:TableCell runat="server" ColumnSpan="4" ID="TableCellItem14" SkinID="TitleRowStyle">
                    <asp:Label ID="Label7" runat="server" Text="[%Požadavek na běžné výdaje%]"></asp:Label>
                </asp:TableCell>
            </asp:TableHeaderRow>

            <asp:TableRow runat="server" ID="TableRow2">
                <asp:TableCell runat="server" ID="TableCell7" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label5" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Žadatel%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell8">
                    <asp:Label ID="zamestnanec_Lab" runat="server" Text=''></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow8">
                <asp:TableCell runat="server" ID="TableCell15" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label17" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Pracovní středisko%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell16">
                    <asp:Label ID="prac_str_Lab" runat="server" Text=''></asp:Label>
                </asp:TableCell>
            </asp:TableRow>
            <asp:TableRow runat="server" ID="TableRow5">
                <asp:TableCell runat="server" ID="TableCell13" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label14" runat="server" SkinID="DataFieldHeaderStyle" Text="[%Divize%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell14">
                    <asp:Label ID="divize_Lab" runat="server" Text=''></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="bank_ucet_Row">
                <asp:TableCell runat="server" ID="TableCell9" HorizontalAlign="Right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="bu_t_Lab" runat="server" SkinID="DataFieldHeaderStyle" Text="[%BÚ%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell ColumnSpan="3" runat="server" SkinID="DataFieldStyle" ID="TableCell10">
                    <asp:Label ID="bu_Lab" runat="server" Text=''></asp:Label>
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRow11">
                <asp:TableCell runat="server" ID="TableCell21" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label23" runat="server" Text="[%Období%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TableCell22" ColumnSpan="3" SkinID="DataFieldStyle">
                    <wc:TRadDatePicker runat="server" ID="RDP_obdobi" DbSelectedDate='<%# Bind("obdobi") %>' Width="95px" />
                    <asp:RequiredFieldValidator runat="server" ControlToValidate="RDP_obdobi" ErrorMessage="není vyplněno" />
                </asp:TableCell>
            </asp:TableRow>

            <asp:TableRow runat="server" ID="TableRowInsert5">
                <asp:TableCell runat="server" ID="TCInsert9" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                    <asp:Label ID="Label4" runat="server" Text="[%Požadované datum vyřízení%]:"></asp:Label>
                </asp:TableCell>
                <asp:TableCell runat="server" ID="TCInsert10" ColumnSpan="3" SkinID="DataFieldStyle">
                    <wc:TRadDatePicker runat="server" ID="TextBoxDatVyrizeniInsert" DbSelectedDate='<%# Bind("vyridit_do") %>' Width="95px" />

                </asp:TableCell>
            </asp:TableRow>

        </asp:Table>
    </InsertItemTemplate>
</asp:FormView>


<tel:RadScriptBlock ID="RadScriptBlock1" runat="server">
    <script type="text/javascript" id="telRSBsluzc">
        //<![CDATA[
        var gi_sk = "<%= KSProgram.Zakaznik.IsSR() ? 1 : 0 %>";

        function AddRemoveCssClass(selector, cssclass, add) {
            if (add == true) {
                $(selector).addClass(cssclass);
            }
            else {
                $(selector).removeClass(cssclass);
            }
            //alert(selector + ".className=" + $(selector).get(0).className);
        }

        function SetPovinneRadDatePicker(dp, ano) {
            var di = dp.get_dateInput();

            if (ano == true) {
                di.get_styles().EnabledStyle[0] += "background-color: #ffffcc;";
                di.get_styles().HoveredStyle[0] += "background-color: #ffffcc;";
                di.get_styles().FocusedStyle[0] += "background-color: #ffffcc;";
            }
            else {
                di.get_styles().EnabledStyle[0] += "background-color: white;";
                di.get_styles().HoveredStyle[0] += "background-color: white;";
                di.get_styles().FocusedStyle[0] += "background-color: white;";
            }
            di.updateCssClass();
        }

        function OnRadUploadClientValidationFailed(sender, args) {
            var fileExtention = args.get_fileName().substring(args.get_fileName().lastIndexOf('.') + 1, args.get_fileName().length);
            if (args.get_fileName().lastIndexOf('.') != -1) {//this checks if the extension is correct
                if ((',' + sender.get_allowedFileExtensions() + ',').indexOf(',' + fileExtention.toLowerCase() + ',') == -1) {
                    alert("Nepovolená přípona souboru, povoleny jsou " + sender.get_allowedFileExtensions() + "!");
                }
                else {
                    alert("Příliš velký soubor, max. velikost souboru je " + <%= KSProgram.Parametry.PovinnyParametrCti<int>("PřílohyMaxVelikost") %> + " MB!");
                }
            }
            else {
                alert("Nepovolená přípona souboru, povoleny jsou " + sender.get_allowedFileExtensions() + "!");
            }
        }

        function DDLSetValue(ddl, value) {
            var item = ddl.findItemByValue(value);
            if (item == null) item = ddl.get_items().getItem(0);
            item.select();
        }

        function parseSenderId(SenderId) {
            var p = SenderId.lastIndexOf("ctrl");
            pref = SenderId.substring(0, p + 4);
            var row_str = SenderId.substring(p + 4);
            senderSrvId = row_str.substring(row_str.indexOf("_") + 1);
            row_str = row_str.substring(0, row_str.indexOf("_"));
            var r = parseInt(row_str);
            var result = { row: r, prefix: pref, senderServerId: senderSrvId };
            return result;
        }

        function VyplJakOnChange(sender, eventArgs) {
            var vypl_jak_DDL = sender;
            var SenderId = sender.get_element().id;

            var res = parseSenderId(SenderId);
            var row = res.row;
            var prefix = res.prefix;

            var cis_bk_DDL = $find(prefix + row + "_cis_bk_DDL");
            var platby_bk = "|<%=string.Join<string>("|", KSProgram.Sluzebky.SlcCisZpusPlat.ZpusobyPlatbyFirKartou()) %>|";
            <%--
            //if (vypl_jak_DDL._selectedValue == "F" || vypl_jak_DDL._selectedValue == "V") //fir. plat. kartou nebo vyber hotovosti kartou
            //PR 11.12.2020 HID=53633
            --%>
            if (platby_bk.indexOf("|" + vypl_jak_DDL._selectedValue, "|") >= 0) {
                AddRemoveCssClass("#" + prefix + row + "_" + "cis_bk_DDL", "hidden", false);
                if (cis_bk_DDL.get_items().get_count() == 2)//PR 01.08.2022 
                    cis_bk_DDL.getItem(1).select();
            }
            else {
                DDLSetValue(cis_bk_DDL, "");
                AddRemoveCssClass("#" + prefix + row + "_" + "cis_bk_DDL", "hidden", true);
            }
        }

        function MenaOnChange(sender, eventArgs) {
            var SenderId = sender.get_element().id;

            var res = parseSenderId(SenderId);
            var row = res.row;
            var prefix = res.prefix;

            var mena = sender._selectedValue;
            var mena_app = "<%=KSProgram.Globals.KodMeny%>";
            var kurz = "";
            if (mena == mena_app)
                kurz = "1";
            else
                kurz = "<%=KSProgram.Zakaznik.IsSR() ? "dle ECB" : "dle ČNB" %>";
            document.getElementById(prefix + row + "_kurz_TB").value = kurz;
        }

        function DateSelected(sender, eventArgs) {
            var SenderId = sender.get_element().id;

            var res = parseSenderId(SenderId);
            var row = res.row;
            var prefix = res.prefix;

            var kurz = "<%=KSProgram.Zakaznik.IsSR() ? "dle ECB" : "dle ČNB" %>";
            document.getElementById(prefix + row + "_kurz_TB").value = kurz;
        }
    //]]>
    </script>
</tel:RadScriptBlock>

<wc:TObjectDataSource ID="ODS_CisCn" runat="server"
    OldValuesParameterFormatString="original_{0}"
    TypeName="KSProgram.Sluzebky.SlcCisCn"
    SelectMethod="SelectBV" EnableCaching="True" CacheExpirationPolicy="Absolute" CacheDuration="6000">
</wc:TObjectDataSource>
<wc:TObjectDataSource ID="ODS_CisKodMeny" runat="server"
    OldValuesParameterFormatString="original_{0}"
    TypeName="KSProgram.Sluzebky.CisKodMeny"
    SelectMethod="Select" EnableCaching="True"></wc:TObjectDataSource>
<%--//PR 27.10.2020 Způsob platby pro zálohy--%>
<wc:TObjectDataSource ID="ODS_ZpusPlatZal" runat="server"
    OldValuesParameterFormatString="original_{0}"
    TypeName="KSProgram.Sluzebky.SlcCisZpusPlat"
    SelectMethod="SelectProZalohy" EnableCaching="True" CacheExpirationPolicy="Absolute" CacheDuration="6000">
    <%--//PR 19.09.2024 caching prodloužen a přidán parametr CultureName, protože by nefungoval uživatelský překlad dat
        //PR 11.10.2024 CultureName zabudováno do kešování v TObjectDataSource--%>
    <%--<SelectParameters>
        <asp:SessionParameter Name="CultureName" SessionField="CultureName" Type="String" />
    </SelectParameters>--%>
</wc:TObjectDataSource>
<wc:TObjectDataSource ID="ODS_CisZpusPlat" runat="server"
    OldValuesParameterFormatString="original_{0}"
    TypeName="KSProgram.Sluzebky.SlcCisZpusPlat"
    SelectMethod="Select" EnableCaching="True" CacheExpirationPolicy="Absolute" CacheDuration="6000">
    <%--//PR 19.09.2024 caching prodloužen a přidán parametr CultureName, protože by nefungoval uživatelský překlad dat
        //PR 11.10.2024 CultureName zabudováno do kešování v TObjectDataSource--%>
    <SelectParameters>
        <asp:Parameter Name="agenda" Type="String" DefaultValue="BV" />
    </SelectParameters>
</wc:TObjectDataSource>
<wc:TObjectDataSource ID="ODS_CisStredisko" runat="server"
    TypeName="KSProgram.Ciselniky.CisStredisko"
    SelectMethod="StrediskaProSluzebniCesty" EnableCaching="True" CacheExpirationPolicy="Absolute" CacheDuration="6000">
    <SelectParameters>
        <asp:Parameter Name="datum" Type="DateTime" />
        <asp:Parameter Name="os_cislo" Type="Decimal" />
        <asp:Parameter Name="ab_prazdny" Type="Boolean" DefaultValue="True" />
    </SelectParameters>
</wc:TObjectDataSource>
<wc:TObjectDataSource ID="ODS_CisProjekty" runat="server"
    TypeName="KSProgram.Ciselniky.CisProjekty"
    SelectMethod="Select" EnableCaching="True" CacheExpirationPolicy="Absolute" CacheDuration="600">
    <SelectParameters>
        <asp:Parameter Name="datum" Type="DateTime" />
        <asp:Parameter Name="os_cislo" Type="Decimal" />
    </SelectParameters>
</wc:TObjectDataSource>
<wc:TObjectDataSource ID="ODS_cis_bk" runat="server"
    OldValuesParameterFormatString="original_{0}"
    TypeName="KSProgram.Sluzebky.SlcCisZpusPlat"
    SelectMethod="SelectKarty" EnableCaching="True" CacheExpirationPolicy="Sliding" CacheDuration="600">
    <SelectParameters>
        <asp:Parameter Name="os_cislo" Type="Decimal" />
    </SelectParameters>
</wc:TObjectDataSource>

<asp:ObjectDataSource ID="ODS_zalohy" runat="server"
    OldValuesParameterFormatString="original_{0}"
    TypeName="KSProgram.Pozadavky.vdj_polozky"
    SelectMethod="Select"
    UpdateMethod="Update">
    <SelectParameters>
        <asp:Parameter Name="id_poz" Type="Int32" />
        <asp:Parameter Name="typ" Type="String" DefaultValue="z" />
        <asp:Parameter Name="pocetPrazdnychRadku" Type="Int32" DefaultValue="0" />
    </SelectParameters>
    <UpdateParameters>
        <asp:Parameter Name="original_radek" Type="Int32" />
        <asp:Parameter Name="original_id_poz" Type="Int32" />
        <asp:Parameter Name="radek" Type="Int32" />
        <asp:Parameter Name="id_poz" Type="Int32" />
        <asp:Parameter Name="typ" Type="String" DefaultValue="z" />
        <asp:Parameter Name="druh" Type="String" DefaultValue="" />
        <asp:Parameter Name="pozn" Type="String" DefaultValue="" />
        <asp:Parameter Name="castka" Type="Decimal" />
        <asp:Parameter Name="mena" Type="String" />
        <asp:Parameter Name="pl" Type="String" />
        <asp:Parameter Name="cis_bk" Type="String" DefaultValue="" />
        <asp:Parameter Name="str" Type="String" DefaultValue="" />
        <asp:Parameter Name="id_proj" Type="Int32" DefaultValue="" />
        <asp:Parameter Name="kurz" Type="Decimal" />
        <asp:Parameter Name="blobid1" Type="Int32" DefaultValue="" />
        <asp:Parameter Name="blobid1n" Type="String" DefaultValue="" />
        <asp:Parameter Name="datum" Type="DateTime" />
    </UpdateParameters>
</asp:ObjectDataSource>

<asp:ListView ID="LV_zalohy" runat="server" DataKeyNames="radek,id_poz" OnItemCommand="LV_zalohy_ItemCommand" OnPreRender="LV_zalohy_PreRender">
    <LayoutTemplate>
        <table id="itemPlaceholderContainer" runat="server" border="1" class="border1px"
            style="background-color: #FFFFFF; border-collapse: collapse;" width="800">
            <tr>
                <td colspan="7" class="theme_header border1px">
                    <wc:TLabel ID="Lab_titulek" runat="server" Text="[%Zálohy%]" />
                </td>
            </tr>
            <tr>
                <td class="border1px tiskHide" width="28px"></td>
                <td class="border1px" width="30px">
                    <wc:TLabel ID="radek_t_Lab" runat="server" Text="[%ID dokladu%]" Font-Bold="True" /></td>
                <td class="border1px" width="140px">
                    <wc:TLabel ID="zcastka_t_Lab" runat="server" Text="[%Částka%]" Font-Bold="True" /></td>
                <td class="border1px">
                    <wc:TLabel ID="TLabel8" runat="server" Text="[%Měna%]" Font-Bold="True" /></td>
                <td class="border1px">
                    <wc:TLabel ID="druh_t_Lab" runat="server" Text="[%Schválil%]" Font-Bold="True" /></td>
                <td class="border1px">
                    <wc:TLabel ID="pozn_t_Lab" runat="server" Text="[%Vyplatil%]" Font-Bold="True" /></td>
                <td class="border1px">
                    <wc:TLabel ID="pl_t_Lab" runat="server" Text="[%Způsob platby%]" Font-Bold="True" /></td>
            </tr>
            <tr id="itemPlaceholder" runat="server">
            </tr>
            <tr class="tiskHide">
                <td class="border1px" align="center">
                    <wc:TRadButton ID="AddBtn" runat="server" CommandName="AddRadek" IdPrava="262"
                        CausesValidation="False" Icon-PrimaryIconCssClass="fi fi-add" Visible='<%# ZalohyEditMode %>' ToolTip="[%Nový řádek%]" />
                </td>
                <td colspan="6" class="border1px" align="center">
                    <asp:CustomValidator ID="ListValidator" runat="server" OnServerValidate="LV_zalohy_validate" ErrorMessage="[%Chybně vyplněné údaje, nelze pokračovat%]" Display="Dynamic"></asp:CustomValidator>
                </td>
            </tr>
        </table>
    </LayoutTemplate>
    <ItemTemplate>
        <tr style="white-space: nowrap;">
            <td class="tiskHide border1px" align="center">
                <wc:TRadButton ID="DelBtn" runat="server" CommandName="DelRadek" IdPrava="262"
                    CausesValidation="False" Icon-PrimaryIconCssClass="fi fi-ban" Visible='<%# ZalohyEditMode %>' ToolTip="[%Smazat%]" />
            </td>
            <td class="border1px">
                <asp:HiddenField ID="id_poz_HF" runat="server" Value='<%# Bind("id_poz") %>' />
                <asp:Label ID="radek_Lab" runat="server" Text='<%# Eval("radek") %>' Visible='<%# !ZalohyEditMode %>' />
                <wc:TTextBox ID="radek_TB" runat="server" Text='<%# Bind("radek") %>' ReadOnly="true" Visible='<%# ZalohyEditMode %>' Width="25px" />
            </td>
            <td class="border1px">
                <asp:Label ID="castka_Lab" runat="server" Text='<%# Bind("castka") %>' Visible='<%# !ZalohyEditMode %>' Width="50px" />
                <wc:TTextBox ID="castka_TB" runat="server" Text='<%# Bind("castka") %>' Visible='<%# ZalohyEditMode %>' Width="60px" TabIndex='<%# 6 + (100*Container.DataItemIndex) %>'></wc:TTextBox>
            </td>
            <td class="border1px">
                <asp:Label ID="mena_Lab" runat="server" Text='<%# Bind("mena") %>' Visible='<%# !ZalohyEditMode %>' Width="15px" />
                <tel:RadDropDownList ID="mena_DDL" runat="server" SelectedValue='<%# Bind("mena") %>' Visible='<%# ZalohyEditMode %>'
                    DataSourceID="ODS_CisKodMeny" DataTextField="kod" DataValueField="kod" Width="60px" DropDownHeight="300px" TabIndex='<%# 7 + (100*Container.DataItemIndex) %>'>
                </tel:RadDropDownList>

                <asp:HiddenField ID="HiddenField1" runat="server" Value='<%# Bind("kurz") %>' />
            </td>
            <td class="border1px">
                <asp:HiddenField ID="schv_osc_HF" runat="server" Value='<%# Eval("schv_osc") %>' />
                <asp:Label ID="schv_osc_display_Lab" runat="server" Text='<%# Eval("schv_osc_display") %>' Visible="true"></asp:Label>
                <asp:HiddenField ID="schv_dne_HF" runat="server" Value='<%# Eval("schv_dne", "{0:d}") %>' />
                <asp:Label ID="Label18" runat="server" Text='<%# Eval("schv_dne", "{0:d}") %>' Visible="true"></asp:Label>
            </td>
            <td class="border1px">
                <asp:HiddenField ID="vypl_osc_HF" runat="server" Value='<%# Eval("vypl_osc") %>' />
                <asp:Label ID="vypl_osc_display_Lab" runat="server" Text='<%# Eval("vypl_osc_display") %>' Visible="true"></asp:Label>
                <asp:HiddenField ID="datum_HF" runat="server" Value='<%# Bind("datum", "{0:d}") %>' />
                <asp:Label ID="datum_Lab" runat="server" Text='<%# Eval("datum", "{0:d}") %>' Visible="true"></asp:Label>
            </td>
            <td class="border1px">
                <tel:RadDropDownList ID="pl_DDL" runat="server" SelectedValue='<%# Bind("pl") %>'
                    DataSourceID="ODS_ZpusPlatZal" DataTextField="nazev" DataValueField="pl" Visible='<%# ZalohyEditMode%>'
                    TabIndex='<%# 8 + (100*Container.DataItemIndex) %>' OnClientSelectedIndexChanged="VyplJakOnChange">
                </tel:RadDropDownList>
                <asp:Label ID="pl_display_Label" runat="server" Text='<%# Eval("pl_display") %>' Visible='<%# !ZalohyEditMode%>'></asp:Label>

                <tel:RadDropDownList ID="cis_bk_DDL" runat="server" SelectedValue='<%# Bind("cis_bk") %>' Width="120px" DropDownWidth="200px"
                    DataSourceID="ODS_cis_bk" DataTextField="naz_prukazu" DataValueField="cis_prukazu" Visible='<%# ZalohyEditMode %>'
                    TabIndex='<%# 9 + (100*Container.DataItemIndex) %>' ToolTip="[%Platební karta%]">
                </tel:RadDropDownList>
                <asp:Label ID="cis_bk_Label" runat="server" Text='<%# DBNull.Value.Equals(Eval("cis_bk")) ? "" : "<br/>" + Eval("cis_bk") %>' Visible='<%# !ZalohyEditMode %>'></asp:Label>

            </td>
        </tr>
    </ItemTemplate>
</asp:ListView>



<asp:ObjectDataSource ID="ODS_vydaje" runat="server"
    OldValuesParameterFormatString="original_{0}"
    TypeName="KSProgram.Pozadavky.vdj_polozky"
    SelectMethod="Select"
    UpdateMethod="Update">
    <SelectParameters>
        <asp:Parameter Name="id_poz" Type="Int32" />
        <asp:Parameter Name="typ" Type="String" DefaultValue="v" />
        <asp:Parameter Name="pocetPrazdnychRadku" Type="Int32" DefaultValue="0" />
    </SelectParameters>
    <UpdateParameters>
        <asp:Parameter Name="original_radek" Type="Int32" />
        <asp:Parameter Name="original_id_poz" Type="Int32" />
        <asp:Parameter Name="radek" Type="Int32" />
        <asp:Parameter Name="id_poz" Type="Int32" />
        <asp:Parameter Name="typ" Type="String" DefaultValue="v" />
        <asp:Parameter Name="druh" Type="String" />
        <asp:Parameter Name="pozn" Type="String" />
        <asp:Parameter Name="castka" Type="Decimal" />
        <asp:Parameter Name="mena" Type="String" />
        <asp:Parameter Name="pl" Type="String" />
        <asp:Parameter Name="cis_bk" Type="String" />
        <asp:Parameter Name="str" Type="String" />
        <asp:Parameter Name="id_proj" Type="Int32" />
        <asp:Parameter Name="kurz" Type="Decimal" />
        <asp:Parameter Name="blobid1" Type="Int32" />
        <asp:Parameter Name="blobid1n" Type="String" />
        <asp:Parameter Name="datum" Type="DateTime" />
    </UpdateParameters>
</asp:ObjectDataSource>

<asp:ListView ID="LV_vydaje" runat="server" DataKeyNames="radek,id_poz" OnItemUpdating="LV_vydaje_ItemUpdating" OnItemCommand="LV_vydaje_ItemCommand" OnPreRender="LV_vydaje_PreRender">
    <LayoutTemplate>
        <table id="itemPlaceholderContainer" runat="server" border="1" class="border1px"
            style="background-color: #FFFFFF; border-collapse: collapse;" width="800">
            <tr>
                <td colspan="12" class="theme_header border1px">
                    <wc:TLabel ID="Lab_titulek" runat="server" Text="[%Seznam výdajů%]" />
                </td>
            </tr>
            <tr>
                <td class="border1px tiskHide" width="28px"></td>
                <td class="border1px" width="30px">
                    <wc:TLabel ID="radek_t_Lab" runat="server" Text="[%ID dokladu%]" Font-Bold="True" /></td>
                <td class="border1px" width="30px">
                    <wc:TLabel ID="datum_t_Lab" runat="server" Text="[%Datum%]" Font-Bold="True" /></td>
                <td class="border1px">
                    <wc:TLabel ID="druh_t_Lab" runat="server" Text="[%Druh výdaje%]" Font-Bold="True" /></td>
                <td class="border1px">
                    <wc:TLabel ID="pozn_t_Lab" runat="server" Text="[%Popis výdaje/na co byl použit%]" Font-Bold="True" /></td>
                <td class="border1px" width="140px">
                    <wc:TLabel ID="castka_t_Lab" runat="server" Text="[%Částka%]" Font-Bold="True" /></td>
                <td class="border1px">
                    <wc:TLabel ID="TLabel7" runat="server" Text="[%Měna%]" Font-Bold="True" /></td>
                <td class="border1px">
                    <wc:TLabel ID="pl_t_Lab" runat="server" Text="[%Způsob platby%]" Font-Bold="True" /></td>
                <td class="border1px">
                    <wc:TLabel ID="str_t_Lab" runat="server" Text="[%Středisko%]" Font-Bold="True" /></td>
                <td class="border1px" runat="server" id="td_id_proj_t">
                    <wc:TLabel ID="id_proj_t_Lab" runat="server" Text="[%Projekt%]" Font-Bold="True" /></td>
                <td class="border1px" runat="server" id="td_id_kurz_t">
                    <wc:TLabel ID="kurz_t_Lab" runat="server" Text="[%Kurz%]" Font-Bold="True" /></td>
                <td class="border1px" runat="server" id="td_id_blobid1_t">
                    <wc:TLabel ID="blobid1_t_Lab" runat="server" Text="[%Skeny dokladů%]" Font-Bold="True" /></td>
            </tr>
            <tr id="itemPlaceholder" runat="server">
            </tr>

            <tr class="tiskHide">
                <td class="border1px" align="center">
                    <wc:TRadButton ID="AddBtn" runat="server" CommandName="AddRadek" IdPrava="262"
                        CausesValidation="False" Icon-PrimaryIconCssClass="fi fi-add" Visible='<%# VydajeEditMode %>' ToolTip="[%Nový řádek%]" />
                </td>
                <td colspan="11" class="border1px" align="center">
                    <asp:CustomValidator ID="ListValidator" runat="server" OnServerValidate="LV_vydaje_validate" ErrorMessage="[%Chybně vyplněné údaje, nelze pokračovat%]" Display="Dynamic"></asp:CustomValidator>
                </td>
            </tr>
        </table>
    </LayoutTemplate>
    <ItemTemplate>
        <tr style="white-space: nowrap;">
            <td class="tiskHide border1px" align="center">
                <wc:TRadButton ID="DelBtn" runat="server" CommandName="DelRadek" IdPrava="262"
                    CausesValidation="False" Icon-PrimaryIconCssClass="fi fi-ban" Visible='<%# VydajeEditMode %>' ToolTip="[%Smazat%]" />
            </td>
            <td class="border1px">
                <asp:HiddenField ID="id_poz_HF" runat="server" Value='<%# Bind("id_poz") %>' />
                <asp:Label ID="radek_Lab" runat="server" Text='<%# Eval("radek") %>' Visible='<%# !VydajeEditMode %>' />
                <wc:TTextBox ID="radek_TB" runat="server" Text='<%# Bind("radek") %>' ReadOnly="true" Visible='<%# VydajeEditMode %>' Width="25px" />
            </td>
            <td class="border1px">
                <asp:Label ID="datum_Lab" runat="server" Text='<%# Eval("datum","{0:d}") %>' Visible='<%# !VydajeEditMode %>' />
                <wc:TRadDatePicker ID="datum_DP" runat="server" DbSelectedDate='<%# Bind("datum") %>' Width="100px" Visible='<%# VydajeEditMode %>'
                    DateInput-MaxLength="10" TabIndex='<%# 15 + (100*Container.DataItemIndex) %>' DateInput-CssClass="povinne-pole" >
                    <ClientEvents OnDateSelected="DateSelected" />
                </wc:TRadDatePicker>
                <%-- OnSelectedDateChanged="LV_vydaje_nastav_kurz" AutoPostBack="true"--%>

            </td>
            <td class="border1px">
                <asp:Label ID="druh_display_Lab" runat="server" Text='<%# Eval("druh_display") %>' Visible='<%# !VydajeEditMode %>' />
                <tel:RadDropDownList ID="druh_DDL" runat="server" SelectedValue='<%# Bind("druh") %>' Visible='<%# VydajeEditMode %>' Width="180px"
                    DataSourceID="ODS_CisCn" DataTextField="nazev" DataValueField="druh" TabIndex='<%# 4 + (100*Container.DataItemIndex) %>' CssClass="povinne-pole">
                </tel:RadDropDownList>
            </td>
            <td class="border1px">
                <asp:Label ID="pozn_Lab" runat="server" Text='<%# Eval("pozn") %>' Visible='<%# !VydajeEditMode %>' />
                <wc:TTextBox ID="pozn_TB" runat="server" Text='<%# Bind("pozn") %>' Visible='<%# VydajeEditMode %>' MaxLength="45" Width="250px" TabIndex='<%# 5 + (100*Container.DataItemIndex) %>'></wc:TTextBox>
            </td>
            <td class="border1px">
                <asp:Label ID="castka_Lab" runat="server" Text='<%# Eval("castka") %>' Visible='<%# !VydajeEditMode %>' Width="50px" />
                <wc:TTextBox ID="castka_TB" runat="server" Text='<%# Bind("castka") %>' Visible='<%# VydajeEditMode %>' Width="60px" TabIndex='<%# 6 + (100*Container.DataItemIndex) %>'
                    CssClass="input povinne-pole"></wc:TTextBox>
                <%--OnTextChanged="LV_vydaje_nastav_kurz" AutoPostBack="true"--%>
            </td>
            <td class="border1px">
                <asp:Label ID="mena_Lab" runat="server" Text='<%# Eval("mena") %>' Visible='<%# !VydajeEditMode %>' />
                <tel:RadDropDownList ID="mena_DDL" runat="server" SelectedValue='<%# Bind("mena") %>' Visible='<%# VydajeEditMode %>'
                    DataSourceID="ODS_CisKodMeny" DataTextField="kod" DataValueField="kod" TabIndex='<%# 7 + (100*Container.DataItemIndex) %>'
                    Width="60px" DropDownHeight="300px" CssClass="povinne-pole" 
                    OnClientSelectedIndexChanged="MenaOnChange">
                </tel:RadDropDownList>
                
            </td>
            <td class="border1px">
                <asp:Label ID="pl_Lab" runat="server" Text='<%# Eval("pl_display") %>' Visible='<%# !VydajeEditMode %>' />
                <tel:RadDropDownList ID="pl_DDL" runat="server" SelectedValue='<%# Bind("pl") %>' Visible='<%# VydajeEditMode %>'
                    DataSourceID="ODS_CisZpusPlat" DataTextField="nazev" DataValueField="pl" Width="100px" DropDownWidth="150px"
                    TabIndex='<%# 8 + (100*Container.DataItemIndex) %>' CssClass="povinne-pole"
                    OnClientSelectedIndexChanged="VyplJakOnChange">
                </tel:RadDropDownList>
                <tel:RadDropDownList ID="cis_bk_DDL" runat="server" SelectedValue='<%# Bind("cis_bk") %>' Width="120px" DropDownWidth="200px"
                    DataSourceID="ODS_cis_bk" DataTextField="naz_prukazu" DataValueField="cis_prukazu" Visible='<%# VydajeEditMode %>'
                    TabIndex='<%# 9 + (100*Container.DataItemIndex) %>' ToolTip="[%Platební karta%]">
                </tel:RadDropDownList>
                <asp:Label ID="cis_bk_Label" runat="server" Text='<%# DBNull.Value.Equals(Eval("cis_bk")) ? "" : "<br/>" + Eval("cis_bk") %>' Visible='<%# !VydajeEditMode %>'></asp:Label>

            </td>
            <td class="border1px">
                <asp:Label ID="str_display_Lab" runat="server" Text='<%# Eval("str") %>' Visible='<%# !VydajeEditMode %>' />
                <tel:RadDropDownList ID="str_DDL" runat="server" SelectedValue='<%# Bind("str") %>' Visible='<%# VydajeEditMode %>'
                    DataSourceID="ODS_CisStredisko" DataTextField="cely_nazev" DataValueField="str" TabIndex='<%# 10 + (100*Container.DataItemIndex) %>' CssClass="povinne-pole">
                </tel:RadDropDownList>
            </td>
            <td class="border1px" style='<%# ProjektMode=="hidden" ? "display:none": "" %>'>
                <asp:Label ID="id_proj_display_Lab" runat="server" Text='<%# Eval("proj_cislo") %>' Visible='<%# !VydajeEditMode %>' />
                <tel:RadDropDownList ID="id_proj_DDL" runat="server" SelectedValue='<%# Bind("id_proj") %>' Visible='<%# VydajeEditMode %>'
                    DataSourceID="ODS_CisProjekty" DataTextField="cely_nazev" DataValueField="id" TabIndex='<%# 11 + (100*Container.DataItemIndex) %>'
                    CssClass='<%# ProjektMode=="required" ? "povinne-pole" : "" %>'>
                </tel:RadDropDownList>
            </td>
            <td class="border1px" style='<%# KurzMode=="hidden" ? "display:none": "" %>'>
                <asp:Label ID="kurz_Lab" runat="server" Text='<%# Eval("kurz") %>' Visible='<%# !VydajeEditMode %>' />
                <wc:TTextBox ID="kurz_TB" runat="server" Text='<%# Bind("kurz") %>' Visible='<%# VydajeEditMode %>' TabIndex='<%# 12 + (100*Container.DataItemIndex) %>' CssClass="input povinne-pole"></wc:TTextBox>
            </td>

            <td class="border1px" style='<%# ScanMode=="hidden" ? "display:none": "" %>'>
                <asp:HiddenField ID="blobid1_HF" runat="server" Value='<%# Bind("blobid1") %>' />
                <asp:HiddenField ID="blobid1n_HF" runat="server" Value='<%# Bind("blobid1n") %>' />


                <asp:HyperLink ID="HyperLink1" runat="server" Target="_blank" NavigateUrl='<%# genOpenDoklCode(Eval("blobid1"), Eval("blobid1n")) %>'
                    Visible='<%# ( !Eval("blobid1").Equals(DBNull.Value))?true:false %>'
                    ToolTip='<%# "Otevři " + Eval("blobid1n") %>'>
                    <asp:Image ID="ExportToFileB1_ImgBtn" runat="server"
                        ImageUrl="~/Images/DocumentHS.png" />
                </asp:HyperLink>
                <%--<asp:CheckBox ID="SmazB1_CBX" runat="server" Text="Smazat" 
                             Visible='<%# (VydajeEditMode && !Eval("blobid1").Equals(DBNull.Value))?true:false %>' />--%>
                <wc:TRadButton ID="SmazB1_RB" runat="server" IdPrava="262"
                    CausesValidation="False" CommandName="DelDoklad" CommandArgument='<%# Eval("blobid1") %>'
                    Visible='<%# (VydajeEditMode && !Eval("blobid1").Equals(DBNull.Value))?true:false %>' Text="[%Smazat%]" />

                <tel:RadAsyncUpload runat="server" ID="RadAsyncUpload1" MaxFileSize='<%# KSProgram.Parametry.PovinnyParametrCti<int>("PřílohyMaxVelikost") * 1048576 %>'
                    HideFileInput="True" TemporaryFolder="~/Temp" AllowedFileExtensions="bmp,jpg,jpeg,png,tif,gif,pdf"
                    Visible='<%# (VydajeEditMode && Eval("blobid1").Equals(DBNull.Value))?true:false %>' AutoAddFileInputs="False" MaxFileInputsCount="1"
                    Localization-Cancel="Zrušit" Localization-DropZone="Přetáhni soubor sem" Localization-Remove="Odstraň" Localization-Select="Vyber" Width="180px"
                    OnClientValidationFailed="OnRadUploadClientValidationFailed" PostbackTriggers="img_save"
                    BackColor='<%# ScanMode=="required" ? System.Drawing.ColorTranslator.FromHtml("#FFFFCC") : System.Drawing.ColorTranslator.FromHtml("#FFFFFF") %>' />
            </td>

            <%--<td>
                        <asp:Label ID="schv_dne_Lab" runat="server" Text='<%# Bind("schv_dne""{0:d}") %>' />                        
                    </td>
                    <td>
                        <asp:Label ID="schv_osc_Lab" runat="server" Text='<%# Bind("schv_osc") %>' />
                    </td>
                    <td>
                        <asp:Label ID="vypl_osc_Lab" runat="server" Text='<%# Bind("vypl_osc") %>' />
                    </td>--%>
        </tr>
    </ItemTemplate>
</asp:ListView>


<asp:ObjectDataSource ID="ODS_obedy" runat="server"
    OldValuesParameterFormatString="original_{0}"
    TypeName="KSProgram.Pozadavky.vdj_obedy"
    SelectMethod="Select"
    UpdateMethod="Update">
    <SelectParameters>
        <asp:Parameter Name="id_poz" Type="Int32" />
        <asp:Parameter Name="pocetPrazdnychRadku" Type="Int32" DefaultValue="0" />
    </SelectParameters>
    <UpdateParameters>
        <asp:Parameter Name="original_id" Type="Int32" />
        <asp:Parameter Name="radek" Type="Int32" />
        <asp:Parameter Name="id_poz" Type="Int32" />
        <asp:Parameter Name="datum" Type="DateTime" />
        <asp:Parameter Name="os_cislo" Type="Decimal" />
        <asp:Parameter Name="jmeno" Type="String" />
        <asp:Parameter Name="ext_os" Type="Boolean" />
    </UpdateParameters>
</asp:ObjectDataSource>

<asp:ListView ID="LV_obedy" runat="server" DataKeyNames="id" OnItemCommand="LV_obedy_ItemCommand" OnPreRender="LV_obedy_PreRender">
    <LayoutTemplate>
        <table id="itemPlaceholderContainer" runat="server" border="1" class="border1px"
            style="background-color: #FFFFFF; border-collapse: collapse;" width="800">
            <tr>
                <td colspan="7" class="theme_header border1px">
                    <wc:TLabel ID="Lab_titulek" runat="server" Text="[%Zaměstnanci a osoby spoluúčastnící se na obědě%]" />
                </td>
            </tr>
            <tr>
                <td class="border1px tiskHide" width="28px"></td>
                <td class="border1px" width="30px">
                    <wc:TLabel ID="radek_t_Lab" runat="server" Text="[%ID dokladu%]" Font-Bold="True" /></td>
                <td class="border1px" width="30px">
                    <wc:TLabel ID="datum_t_Lab" runat="server" Text="[%Datum%]" Font-Bold="True" /></td>
                <td class="border1px" width="60px">
                    <wc:TLabel ID="TLabel6" runat="server" Text="[%Externí osoba%]" Font-Bold="True" /></td>
                <td class="border1px" width="200px">
                    <wc:TLabel ID="obedy_jmeno_t_Lab" runat="server" Text="[%Příjmení a jméno%]" Font-Bold="True" /></td>
                <td class="border1px">
                    <wc:TLabel ID="str_t_Lab" runat="server" Text="[%Středisko%]" Font-Bold="True" /></td>
                <td class="border1px">
                    <wc:TLabel ID="divize_t_Lab" runat="server" Text="[%Divize%]" Font-Bold="True" /></td>
            </tr>
            <tr id="itemPlaceholder" runat="server">
            </tr>

            <tr class="tiskHide">
                <td class="border1px" align="center">
                    <wc:TRadButton ID="AddBtn" runat="server" CommandName="AddRadek" IdPrava="262"
                        CausesValidation="False" Icon-PrimaryIconCssClass="fi fi-add" Visible='<%# ObedyEditMode %>' ToolTip="[%Nový řádek%]" />
                </td>
                <td colspan="11" class="border1px" align="center">
                    <asp:CustomValidator ID="ListValidator" runat="server" OnServerValidate="LV_obedy_validate" ErrorMessage="[%Chybně vyplněné údaje, nelze pokračovat%]" Display="Dynamic"></asp:CustomValidator>
                </td>
            </tr>
        </table>
    </LayoutTemplate>
    <ItemTemplate>
        <tr style="white-space: nowrap;">
            <td class="tiskHide border1px" align="center">
                <wc:TRadButton ID="DelBtn" runat="server" CommandName="DelRadek" IdPrava="262"
                    CausesValidation="False" Icon-PrimaryIconCssClass="fi fi-ban" Visible='<%# ObedyEditMode %>' ToolTip="[%Smazat%]" />
            </td>
            <td class="border1px">
                <asp:HiddenField ID="id_poz_HF" runat="server" Value='<%# Bind("id_poz") %>' />
                <asp:Label ID="radek_Lab" runat="server" Text='<%# Eval("radek") %>' Visible='<%# !ObedyEditMode %>' />
                <wc:TTextBox ID="radek_TB" runat="server" Text='<%# Bind("radek") %>' ReadOnly="false" Visible='<%# ObedyEditMode %>' Width="25px" />
            </td>
            <td class="border1px">
                <asp:Label ID="datum_Lab" runat="server" Text='<%# Eval("datum","{0:d}") %>' Visible='<%# !ObedyEditMode %>' />
                <wc:TRadDatePicker ID="datum_DP" runat="server" DbSelectedDate='<%# Bind("datum") %>' Width="100px" Visible='<%# ObedyEditMode %>'
                    DateInput-MaxLength="10" TabIndex='<%# 15 + (100*Container.DataItemIndex) %>' />
            </td>
            <td class="border1px">
                <asp:CheckBox ID="ext_os_ChB" runat="server" Checked='<%# Bind("ext_os") %>' Text="" Enabled='<%# ObedyEditMode %>'></asp:CheckBox>
            </td>
            <td class="border1px">
                <asp:Label ID="obedy_jmeno_Lab" runat="server" Text='<%# Eval("jmeno") %>' Visible='<%# !ObedyEditMode %>' />
                <asp:HiddenField ID="obedy_os_cislo_HF" runat="server" Value='<%# Bind("os_cislo") %>' />
                <wc:TTextBox ID="obedy_jmeno_TB" runat="server" OnTextChanged="LV_obedy_jmeno_TB_Changed" AutoPostBack="True"
                    Text='<%# Bind("jmeno") %>' Width="200px" Visible='<%# ObedyEditMode %>' MaxLength="80" />
                <cc1:AutoCompleteExtender ID="ACExt_obedy_jmeno_TB"
                    runat="server" DelimiterCharacters="" Enabled="True" MinimumPrefixLength="1"
                    ServiceMethod="CompleteJmeno" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                    TargetControlID="obedy_jmeno_TB" UseContextKey="True">
                </cc1:AutoCompleteExtender>
            </td>
            <td class="border1px">
                <asp:Label ID="str_Lab" runat="server" Text='<%# Eval("str") %>' Visible='<%# !ObedyEditMode %>' />
                <wc:TTextBox ID="str_TB" runat="server" Text='<%# Eval("str") %>' Visible='<%# ObedyEditMode %>' ReadOnly="true"></wc:TTextBox>
            </td>

            <td class="border1px">
                <asp:Label ID="divize_Lab" runat="server" Text='<%# Eval("divize") %>' Visible='<%# !ObedyEditMode %>' />
                <wc:TTextBox ID="divize_TB" runat="server" Text='<%# Eval("divize") %>' Visible='<%# ObedyEditMode %>' ReadOnly="true"></wc:TTextBox>
            </td>
        </tr>
    </ItemTemplate>
</asp:ListView>


<asp:ObjectDataSource ID="ODS_doplatek" runat="server"
    OldValuesParameterFormatString="original_{0}"
    TypeName="KSProgram.Pozadavky.vdj_polozky"
    SelectMethod="Select">
    <SelectParameters>
        <asp:Parameter Name="id_poz" Type="Int32" />
        <asp:Parameter Name="typ" Type="String" DefaultValue="d" />
        <asp:Parameter Name="pocetPrazdnychRadku" Type="Int32" DefaultValue="0" />
    </SelectParameters>
</asp:ObjectDataSource>

<asp:ListView ID="LV_doplatek" runat="server">
    <LayoutTemplate>
        <table id="itemPlaceholderContainer" runat="server" border="1" class="border1px"
            style="background-color: #FFFFFF; border-collapse: collapse;" width="800">
            <tr>
                <td colspan="5" class="theme_header border1px">
                    <wc:TLabel ID="Lab_titulek" runat="server" Text="[%Doplatek%]" />
                </td>
            </tr>
            <tr id="itemPlaceholder" runat="server">
            </tr>
        </table>
    </LayoutTemplate>
    <ItemTemplate>
        <tr>
            <td class="border1px">
                <wc:TTextBox ID="radek_TB" runat="server" Text='<%# Eval("radek") %>' ReadOnly="true" Visible="false" Width="25px" />
                <wc:TLabel ID="TLabel2" runat="server" Text="[%Celkové náklady%]:" Font-Bold="True" />
                <br />
                <wc:TLabel ID="naklady_Lab" runat="server" Text='<%# Eval("celk_naklady") %>' Font-Bold="True" />
            </td>
            <td class="border1px">
                <wc:TLabel ID="TLabel1" runat="server" Text="[%K výplatě (+) / k inkasu (-)%]:" Font-Bold="True" />
                <br />
                <wc:TLabel ID="doplatek_Lab" runat="server" Text='<%# Eval("castka") %>' Font-Bold="True" />
            </td>
            <td class="border1px">
                <wc:TLabel ID="pl_Lab" runat="server" Text="[%Způsob platby%]:" Font-Bold="True" />
                <br />
                <asp:Label ID="pl_display_Label" runat="server" Text='<%# Eval("pl_display") %>' Visible="true"></asp:Label>
            </td>
            <td class="border1px">
                <wc:TLabel ID="TLabel4" runat="server" Text="[%Zkontroloval%]:" Font-Bold="True" />
                <br />
                <asp:Label ID="Label25" runat="server" Text='<%# Eval("schv_osc_display") %>' Visible="true"></asp:Label>
                &nbsp;
                    <asp:Label ID="Label24" runat="server" Text='<%# Eval("schv_dne", "{0:d}") %>' Visible="true"></asp:Label>
            </td>
            <td class="border1px">
                <wc:TLabel ID="TLabel3" runat="server" Text="[%Vyplatil%]:" Font-Bold="True" />
                <br />
                <asp:Label ID="vypl_osc_display_Lab" runat="server" Text='<%# Eval("vypl_osc_display") %>' Visible="true"></asp:Label>
                &nbsp; 
                    <asp:Label ID="datum_Lab" runat="server" Text='<%# Eval("datum", "{0:d}") %>' Visible="true"></asp:Label>
            </td>
        </tr>
    </ItemTemplate>
</asp:ListView>

<asp:CustomValidator ID="BankUcetValidator" runat="server" OnServerValidate="BankUcetValidator_ServerValidate" ErrorMessage="[%Zaměstnanec nemá naveden bankovní účet%]" Display="Dynamic"></asp:CustomValidator>


<style type="text/css">
    .RadAjaxPanel .rfdTable {
        padding: 10px;
        margin-bottom: 15px;
    }

    .border1px {
        border: thin solid #e5e5e5;
        padding: 1px 4px;
    }

    .border1pxL {
        border-left-style: solid;
        border-left-width: thin;
        border-left-color: #e5e5e5;
        padding: 1px 4px;
    }

    .border1pxR {
        border-right-style: solid;
        border-right-width: thin;
        border-right-color: #e5e5e5;
        padding: 1px 4px;
    }

    .border1pxT {
        border-top-style: solid;
        border-top-width: thin;
        border-top-color: #e5e5e5;
        padding: 1px 4px;
    }

    .border1pxB {
        border-bottom-style: solid;
        border-bottom-width: thin;
        border-bottom-color: #e5e5e5;
        padding: 1px 4px;
    }

    .style1 {
    }

    .style7 {
        text-align: left;
    }

    .style10 {
        text-align: right;
    }

    .style11 {
        width: 134px;
    }

    .style13 {
    }

    .style14 {
        width: 90px;
    }

    .style16 {
        width: 226px;
        text-align: left;
    }

    .style26 {
        width: 75px;
    }

    .style29 {
        width: 226px;
    }

    .style32 {
        width: 105px;
    }

    .style33 {
        width: 72px;
    }

    .style34 {
        width: 220px;
    }

    .style35 {
        text-align: left;
        width: 220px;
    }
</style>
<style type="text/css" media="print">
    .theme_header {
        color: Black;
        background-color: transparent;
        font-size: 14px;
    }

    .tiskHide {
        display: none;
    }

    .tiskShow {
        display: block;
    }

    .border1px {
        border: 1px solid #000000;
        padding: 1px 4px;
    }

    .border1pxL {
        border-left-style: solid;
        border-left-width: 1px;
        border-left-color: #000000;
        padding: 1px 4px;
    }

    .border1pxR {
        border-right-style: solid;
        border-right-width: 1px;
        border-right-color: #000000;
        padding: 1px 4px;
    }

    .border1pxT {
        border-top-style: solid;
        border-top-width: 1px;
        border-top-color: #000000;
        padding: 1px 4px;
    }

    .border1pxB {
        border-bottom-style: solid;
        border-bottom-width: 1px;
        border-bottom-color: #000000;
        padding: 1px 4px;
    }
</style>
