﻿<%@ Control Language="C#" AutoEventWireup="true"
    Inherits="Controls_workfl_settings" Codebehind="workfl_settings.ascx.cs" ValidateRequestMode="Disabled" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<%@ Register Assembly="WebControlsAlone" Namespace="KSProgram.WebControlsAlone" TagPrefix="wca" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register TagPrefix="uc" TagName="sablony_prilohy" Src="~/Controls/PrilohyManager.ascx" %>
<style type="text/css">  
    /*RadToolTip*/ 
    div.RadToolTip
    {
        background-color: #EAEAEA;
    }
    .ruBrowse
    {
        width:160px !important;
    }   
    .DropZone, .DropZone2
    {
        background-color:lightblue !important;
        padding:10px;
    }
    .ruFakeInput
    {
        display:none;
        visibility:hidden;
    }
    #ctl00_HlavniOblast_wizm_WfSet_titled_panel_gv_stavy > tbody > tr:nth-child(4n) > td{
        padding-bottom: 20px !important;
        border-bottom: 3px solid var(--kscolor1);
    }
    #ctl00_HlavniOblast_wizm_WfSet_titled_panel_gv_stavy > tbody > tr > td table{
        border: solid 1px #cdcdcd;
    }
</style>
<wca:TitledPanel runat="server" ID="titled_panel" >
<TitleTemplate>
 <asp:Label runat="server" ID="step_title"></asp:Label>
</TitleTemplate>
<ContentTemplate>
    <telerik:RadScriptBlock ID="RSBWFS" runat="server">
        <script type="text/javascript">
            //<![CDATA[

            var htmlEntities = [
                { char: 'á', entity: /&aacute;/g },
                { char: 'é', entity: /&eacute;/g },
                { char: 'í', entity: /&iacute;/g },
                { char: 'ý', entity: /&yacute;/g },
                { char: 'ó', entity: /&oacute;/g },
                { char: 'ú', entity: /&uacute;/g },
                { char: 'ů', entity: /&uring;/g },
                { char: 'ě', entity: /&ecaron;/g },
                { char: 'š', entity: /&scaron;/g },
                { char: 'č', entity: /&ccaron;/g },
                { char: 'ř', entity: /&rcaron;/g },
                { char: 'ž', entity: /&zcaron;/g },
                { char: 'ď', entity: /&dcaron;/g },
                { char: 'ť', entity: /&tcaron;/g },
                { char: 'ň', entity: /&ncaron;/g },
                { char: 'Á', entity: /&Aacute;/g },
                { char: 'É', entity: /&Eacute;/g },
                { char: 'Í', entity: /&Iacute;/g },
                { char: 'Ý', entity: /&Yacute;/g },
                { char: 'Ó', entity: /&Oacute;/g },
                { char: 'Ú', entity: /&Uacute;/g },
                { char: 'Ů', entity: /&Uring;/g },
                { char: 'Ě', entity: /&Ecaron;/g },
                { char: 'Š', entity: /&Scaron;/g },
                { char: 'Č', entity: /&Ccaron;/g },
                { char: 'Ř', entity: /&Rcaron;/g },
                { char: 'Ž', entity: /&Zcaron;/g },
                { char: 'Ď', entity: /&Dcaron;/g },
                { char: 'Ť', entity: /&Tcaron;/g },
                { char: 'Ň', entity: /&Ncaron;/g }
            ];

            function decodeCzech(value) {
                //české znaky hodím zpátky na znaky
                for (v in htmlEntities) {
                    value = value.replace(htmlEntities[v].entity, htmlEntities[v].char);
                }
                return value;
            }

            /**
             * Encode HTML
             */
            String.prototype.htmlEncode = function () {                
                var value = $("<textarea/>").text(this).html();                
                return value;
            };

            /**
             * Decode HTML
             */
            String.prototype.htmlDecode = function () {                
                var value = $("<textarea/>").html(this).text();
                return value;
            };

            var gs_hf_hodnota;
            var gs_vlastnost;
            var go_editWindow;
            var go_kendoEditor;

            function openEditor(hf_hodnota, vlastnost, arg1, arg2, arg3, arg4, arg5, arg6) {

                gs_hf_hodnota = hf_hodnota;
                gs_vlastnost = vlastnost;
                var value = document.getElementById(gs_hf_hodnota).value;

                if (vlastnost == 'Text')
                    openTextEditor(value, arg1, arg2, arg3, arg4, arg5, arg6);
                else if (vlastnost == 'Html')
                    openHtmlEditor(value, arg1, arg2, arg3, arg4, arg5, arg6);
            }

            var TextOnButtonApplyClick = function () {
                console.log("button_apply.click: " + $("#editor").val());
                document.getElementById(gs_hf_hodnota).value = $("#editor").val();
                go_editWindow.close();
            }

            var TextOnButtonCloseClick = function () {                
                go_editWindow.close();
            }

            function openTextEditor(value, maxLen, arg2, arg3, arg4, arg5, arg6) {
                $('#textarea_div').empty();
                $('#textarea_div').html('<textarea id="editor" style="width:610px; height: 360px" maxlength="' + maxLen + '"></textarea>');
                                
                $("#editor").val(value);

                $("#ed_button_apply").unbind('click');
                $("#ed_button_close").unbind('click');
                $("#ed_button_clear").unbind('click');

                $("#ed_button_apply").bind('click', TextOnButtonApplyClick);
                $("#ed_button_close").bind('click', TextOnButtonCloseClick);
                $("#ed_button_clear").bind('click', OnButtonClearClick);

                go_editWindow = $('#editorWindow').kendoWindow({
                    title: "Text",
                    resizable: true,
                    modal: true,
                    width: 650,
                    draggable: true,

                }).data("kendoWindow");
                go_editWindow.center().open();
            }

            var HtmlOnButtonApplyClick = function () {
                //var value = $("#editor").val();
                var value = go_kendoEditor.value();
                console.log("button_apply.click: Value Raw : " + value);
                //editor vrací české znaky encodované, i když je encoded:false. To řeší serialization.entities;
                //value = decodeCzech(value);
                //console.log("button_apply.click: Value DecodeCzech: " + value);
                //nastavení vlastnosti encode:false nefunguje, pokud je serialization.entities:false;
                value = value.htmlEncode();
                console.log("button_apply.click: Value Encoded: " + value);
                document.getElementById(gs_hf_hodnota).value = value;
                var test = document.getElementById(gs_hf_hodnota).value;
                console.log("button_apply.click: test: " + test);
                go_kendoEditor.destroy();
                go_editWindow.close();
            }

            var OnButtonClearClick = function () {
                document.getElementById(gs_hf_hodnota).value = "";
                go_kendoEditor.destroy();
                go_editWindow.close();
            }

            var HtmlOnButtonCloseClick = function () {
                go_kendoEditor.destroy();
                go_editWindow.close();
            }

            function openHtmlEditor(value, maxLen, arg2, arg3, arg4, arg5, arg6) {
                console.log("openHtmlEditor: Raw value: " + value);
                value = value.htmlDecode();
                console.log("openHtmlEditor: Decoded value: " + value);

                $('#textarea_div').empty();
                $('#textarea_div').html('<textarea id="editor" style="width:610px; height: 360px" maxlength="' + maxLen + '"></textarea>');
                                
                $("#editor").kendoEditor({
                    value: value,
                    encoded: false,
                    serialization: {
                        entities: false //Indicates whether the characters outside the ASCII range will be encoded as HTML entities.
                    },
                    tools: [
                        "bold",
                        "italic",
                        "underline",
                        "justifyLeft",
                        "justifyCenter",
                        "justifyRight",
                        "insertUnorderedList",
                        "createLink",
                        "unlink",
                        "insertImage",
                        "tableWizard",
                        "createTable",
                        "addRowAbove",
                        "addRowBelow",
                        "addColumnLeft",
                        "addColumnRight",
                        "deleteRow",
                        "deleteColumn",
                        "mergeCellsHorizontally",
                        "mergeCellsVertically",
                        "splitCellHorizontally",
                        "splitCellVertically",
                        "tableAlignLeft",
                        "tableAlignCenter",
                        "tableAlignRight",
                        "formatting", "cleanFormatting",
                        {
                            name: "fontName",
                            items: [
                                { text: "Andale Mono", value: "\"Andale Mono\"" },
                                { text: "Arial", value: "Arial" },
                                { text: "Arial Black", value: "\"Arial Black\"" },
                                { text: "Book Antiqua", value: "\"Book Antiqua\"" },
                                { text: "Comic Sans MS", value: "\"Comic Sans MS\"" },
                                { text: "Courier New", value: "\"Courier New\"" },
                                { text: "Georgia", value: "Georgia" },
                                { text: "Helvetica", value: "Helvetica" },
                                { text: "Impact", value: "Impact" },
                                { text: "Symbol", value: "Symbol" },
                                { text: "Tahoma", value: "Tahoma" },
                                { text: "Terminal", value: "Terminal" },
                                { text: "Times New Roman", value: "\"Times New Roman\"" },
                                { text: "Trebuchet MS", value: "\"Trebuchet MS\"" },
                                { text: "Verdana", value: "Verdana" }
                            ]
                        },
                        "fontSize",
                        "foreColor",
                        "backColor",
                        "viewHtml"
                    ],
                    messages: {
                        fontNameInherit: "(výchozí font)",
                        fontSizeInherit: "(výchozí velikost)"
                    }
                });
                go_kendoEditor = $("#editor").data('kendoEditor');

                $("#ed_button_apply").unbind('click');
                $("#ed_button_close").unbind('click');
                $("#ed_button_clear").unbind('click');

                $("#ed_button_apply").bind('click', HtmlOnButtonApplyClick);
                $("#ed_button_close").bind('click', HtmlOnButtonCloseClick);
                $("#ed_button_clear").bind('click', OnButtonClearClick);

                go_editWindow = $('#editorWindow').kendoWindow({
                    title: "Text",
                    resizable: true,
                    modal: true,
                    width: 650,
                    draggable: true,

                }).data("kendoWindow");//.center().open();
                go_editWindow.center().open();
            }

            function DDLAkce_OnClientLoad(sender) {
                var input = sender.get_inputDomElement();
                input.onkeydown = DDLAkce_OnKeyDown;
            }

            function DDLAkce_OnKeyDown(evt) {
                if (evt.target.value.indexOf("prop:") == -1) {
                    evt.returnValue = false;
                    if (evt.preventDefault) {
                        evt.preventDefault();
                    }
                }
            }

            function DDLAkce_OnClientSelectedIndexChanged(sender, eventArgs) {
                if (sender.get_text().indexOf("prop:") == 0) 
                    sender.set_allowCustomText(true);
                else 
                    sender.set_allowCustomText(false);
            }            
                        
            //]]>
        </script>
    </telerik:RadScriptBlock>

    <div id="editorWindow" style="display: none;">
        <div id="textarea_div">
            <textarea id="editor" rows="10" cols="40" style="height: 360px" ></textarea>
        </div>
        <div class='formButtons' style="float: right;margin-top: 5px;">
            <button id='ed_button_apply' class="k-button">Použít</button>
            <button id='ed_button_clear' class="k-button">Smazat</button>
            <button id='ed_button_close' class="k-button">Storno</button>
        </div>
    </div>


    <asp:HiddenField ID="HF_faze" runat="server" />   
    
    <%--<asp:ObjectDataSource ID="ds_faze" runat="server" TypeName="KSProgram.Workflow.WorkflowSettings"
        SelectMethod="GetFaze" OldValuesParameterFormatString="original_{0}">
        <SelectParameters>
            <asp:Parameter Name="typ" Type="string" />
            <asp:Parameter Name="faze" Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>--%>
    <%--<asp:ObjectDataSource ID="ds_un" runat="server" TypeName="KSProgram.Workflow.WorkflowSettings"
        SelectMethod="GetFazeUN" OldValuesParameterFormatString="original_{0}">
        <SelectParameters>
            <asp:Parameter Name="typ" Type="string" />
            <asp:Parameter Name="faze" Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>--%>
    <%--<asp:ObjectDataSource ID="ds_stavy" runat="server" TypeName="KSProgram.Workflow.WorkflowSettings"
        SelectMethod="GetStavy" OldValuesParameterFormatString="original_{0}">
        <SelectParameters>
            <asp:Parameter Name="typ" Type="string" />
            <asp:Parameter Name="faze" Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>--%>
    <asp:ObjectDataSource ID="ds_sys_stav" runat="server" TypeName="KSProgram.Workflow.WorkflowSettings"
        SelectMethod="GetSysStavy">
    </asp:ObjectDataSource>
    <asp:ObjectDataSource runat="server" ID="ds_akce" TypeName="KSProgram.Workflow.WorkflowSettings"
        SelectMethod="GetAkce" OnDataBinding="ds_akce_OnDataBinding">
        <SelectParameters>
            <asp:Parameter Name="typ" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource runat="server" ID="ds_adresati" TypeName="KSProgram.Workflow.WorkflowSettings"
        SelectMethod="GetAllAdresat" EnableCaching="True" >
    </asp:ObjectDataSource>
    <asp:ObjectDataSource runat="server" ID="ds_oznamkomu" TypeName="KSProgram.Workflow.WorkflowSettings"
        SelectMethod="GetAllOznameniKomu" EnableCaching="True" >
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ds_WfProp" runat="server" TypeName="KSProgram.Workflow.WorkflowSettings"
        SelectMethod="GetWFProperties" EnableCaching="True" CacheDuration="60">
        <SelectParameters>
            <asp:ControlParameter Name="typ" Type="String" ControlID="ddl_typ" PropertyName="SelectedValue"/>           
        </SelectParameters>
    </asp:ObjectDataSource>

<div style="padding-left:10px;">
    <br />
      
    
    <%--DataSourceID="ds_faze"--%>
    <asp:DetailsView ID="dv_faze" runat="server"  OnDataBinding="dv_faze_DataBinding" AutoGenerateRows="False" >
        <Fields> 
            <asp:TemplateField HeaderText="[%Název kroku%]"  >
                <ItemTemplate>                   
                     <wc:TTextBox runat="server" ID="text_popis_kroku" Text='<%# Bind("popis") %>' Width="220" MaxLength="30" ></wc:TTextBox>                   
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="[%Šablona emailu%]" >
                <ItemTemplate>
                     <asp:HiddenField ID="HF_IdSablony" runat="server" Value='<%# Eval("id_sablony") %>' /> 
                <asp:Panel runat="server" id="pan_upload"   class="DropZone" style="white-space:nowrap" Visible='<%# !pan_sablona_comm_visible() %>'>                      
                        <telerik:RadAsyncUpload  MaxFileSize='<%# 10 * 1048576 %>'  PostbackTriggers="btn_odeslat_sablonu" DropZones=".DropZone,.DropZone2" TemporaryFolder="~/Temp"  runat="server" ID="RadAsyncUpload1" MultipleFileSelection="Disabled" AllowedMimeTypes="zip" AllowedFileExtensions="zip" AutoAddFileInputs="true" ManualUpload="false" OnFileUploaded="RadAsyncUpload1_FileUploaded">
                            <Localization Select="[%Výběr zip souboru šablony%]"  DropZone="[%Zde pusťte soubor%]"  Remove="[%Odstranit%]"/>
                        </telerik:RadAsyncUpload>                    
                    
                    <kspwc:TRadButton runat="server" ID="btn_odeslat_sablonu" Text="[%Import%]" ></kspwc:TRadButton>
                  </asp:Panel>
                 <asp:Panel runat="server" id="pan_sablona_comm" Visible='<%# pan_sablona_comm_visible() %>'>
                    <kspwc:TRadButton runat="server" Icon-PrimaryIconCssClass="fi fi-trash" ToolTip="[%Odstranit%]" ID="rb_delete"  Width="15" Height="15" OnCommand="rb_delete_Command" ></kspwc:TRadButton>
                  
                     <asp:HyperLink ID="HyperLink1" runat="server" Target="_blank" ToolTip='<%# "Stáhnout šablonu"  %>'
                        NavigateUrl='<%# genOpenDoklCode(Eval("id_sablony"), "sablona.zip") %>'>               
                        <span class="rbDownload16 rbPredefinedIcons"></span>
                    </asp:HyperLink>

                 </asp:Panel> 

                </ItemTemplate>
            </asp:TemplateField>
        </Fields>
    </asp:DetailsView>

    
    <br />
    <asp:Label runat="server" ID="nadpis" Text="Nastavení uživatelského rozhraní" Font-Bold="true" CssClass="nadpis1" ></asp:Label>
    <kspwc:TRadButton Text="[%Kopírovat%]" runat="server" ID="rb_do_schranky" OnCommand="rb_do_schranky_Command" style="float: right" Icon-PrimaryIconCssClass="fi fi-copy">       
    </kspwc:TRadButton>    
    <kspwc:TRadButton Text="Vložit" runat="server" ID="rb_ze_schranky" OnCommand="rb_ze_schranky_Command" style="margin-bottom:3px;"></kspwc:TRadButton>
    <%--PR 18.4.2017 seznam položek a vlastností uveden jen jednou. Hodnoty pro Adresáta,Správce,Vydavatele,Ostatní jsou ve sloupcích vedle sebe.
        zabere to na výšku míň místa a nemusí se tolik scrollovat na stavy --%>
    

    <%--DataSourceID="ds_un"--%>
    <wc:TGridViewBulk ID="gv_un" runat="server"  
        DataFields="polozka,vlastnost,hodnota_adr,hodnota_spr,hodnota_vyd,hodnota_ost" 
        DataKeyNames="polozka,vlastnost" OnRowDataBound="gv_un_onRowDataBound" Width="100%" >
            <Columns>                                
                <asp:TemplateField HeaderText="[%Položka%]" ItemStyle-Height="30">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="lab_polozka" Text='<%# Bind("polozka") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField >                                                      
                <asp:TemplateField HeaderText="[%Vlastnost%]" ItemStyle-Height="30">
                    <ItemTemplate>
                        <asp:Label runat="server" ID="lab_vlastnost" Text='<%# Bind("vlastnost") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField >
                <asp:TemplateField HeaderText="[%Řešitel%]" ControlStyle-Width="100" ItemStyle-Height="30">
                    <ItemTemplate>
                        <asp:DropDownList ID="ddl_hodnota_adr" CssClass="input"
                            runat="server">
                        </asp:DropDownList> 
                        <asp:HiddenField ID="hf_hodnota_adr" runat="server" ValidateRequestMode="Disabled"></asp:HiddenField>
                        <asp:Button ID="btn_hodnota_adr" runat="server" Text=".." ></asp:Button>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="[%Správce%]" ControlStyle-Width="100" ItemStyle-Height="30">
                    <ItemTemplate>
                        <asp:DropDownList ID="ddl_hodnota_spr" CssClass="input"
                            runat="server">
                        </asp:DropDownList>
                        <asp:HiddenField ID="hf_hodnota_spr" runat="server" ValidateRequestMode="Disabled" ></asp:HiddenField>
                        <asp:Button ID="btn_hodnota_spr" runat="server" Text=".." ></asp:Button>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="[%Vydavatel%]" ControlStyle-Width="100" ItemStyle-Height="30">
                    <ItemTemplate>
                        <asp:DropDownList ID="ddl_hodnota_vyd" CssClass="input"
                            runat="server">
                        </asp:DropDownList>
                        <asp:HiddenField ID="hf_hodnota_vyd" runat="server" ValidateRequestMode="Disabled" ></asp:HiddenField>
                        <asp:Button ID="btn_hodnota_vyd" runat="server" Text=".." ></asp:Button>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="[%Ostatní%]" ControlStyle-Width="100" ItemStyle-Height="30">
                    <ItemTemplate>
                        <asp:DropDownList ID="ddl_hodnota_ost" CssClass="input"
                            runat="server">
                        </asp:DropDownList>
                        <asp:HiddenField ID="hf_hodnota_ost" runat="server" ValidateRequestMode="Disabled" ></asp:HiddenField>
                        <asp:Button ID="btn_hodnota_ost" runat="server" Text=".." ></asp:Button>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
    </wc:TGridViewBulk>

    

    <br />


    <asp:Label runat="server" ID="Label2" Text="Nastavení stavů a akcí" Font-Bold="true" CssClass="nadpis1" ></asp:Label>
    

    <%--DataSourceID="ds_stavy"--%>
    <wc:TGridViewBulk ID="gv_stavy" runat="server" ShowFooter="True" ShowFooterWhenEmpty="True"  
        ShowHeader="false" ShowHeaderWhenEmpty="False" TitleText="Definice stavů" DataFields="stav,popis,sys_stav2,pristup"
         Width="100%" OnRowDataBound="gv_stavy_RowDataBound"
        onrowcreated="TGridView_stavy_RowCreated" OnPreRender="gv_stavy_PreRender" RowStyle-Wrap="False" > 
        <Columns>
            <asp:TemplateField HeaderText="Stav" ItemStyle-VerticalAlign="Top" >
                <ItemTemplate>
                    <asp:Label Text="Stav:" runat="server" Font-Bold="True" />
                    <wc:TTextBox ID="tx_stav" runat="server" Text='<%# Bind("stav") %>' Enabled='<%# Bind("nepouzit") %>' Width="100px" MaxLength="10" ></wc:TTextBox>
                </ItemTemplate>
                <ItemStyle VerticalAlign="Top" />
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Popis" ItemStyle-VerticalAlign="Top">
                <ItemTemplate>
                    <asp:Label Text="Popis:" runat="server" Font-Bold="True" />
                    <wc:TTextBox ID="tx_popis" runat="server" Text='<%# Bind("popis") %>' Width="200px" MaxLength="50"></wc:TTextBox>
                </ItemTemplate>
                <ItemStyle VerticalAlign="Top" />
            </asp:TemplateField>            

            <asp:TemplateField HeaderText="Sys. stav2" ItemStyle-VerticalAlign="Top">
                <ItemTemplate>
                    <table>
                        <tr>
                            <td>
                                <asp:Label Text="Implicitní stav" runat="server" Font-Bold="True" />
                            </td>
                            <td>
                                 <asp:Label Text="-uživatel:" runat="server"  />
                            </td>
                            <td>
                                 <asp:CheckBox runat="server" ID="check_sys_stav2"   Checked='<%# Bind("sys_stav2") %>'  />                               
                            </td>
                        </tr>
                        <tr>
                            <td></td>
                            <td>
                                 <asp:Label Text="-aplikační server:" runat="server"  />
                            </td>
                            <td>                               
                                <asp:CheckBox runat="server" ID="check_sys_stav_as" Checked='<%# Bind("sys_stav_as") %>'    />
                            </td>
                        </tr>
                    </table>
                   <%-- <asp:Label Text="Implicitní stav:" runat="server" Font-Bold="True" />
                   <asp:CheckBox runat="server" ID="check_sys_stav2" 
                        Checked='<%# Bind("sys_stav2") %>' />  
                    <br />
                    <asp:Label Text="Implicitní stav AS:" runat="server" Font-Bold="True" />
                   <asp:CheckBox runat="server" ID="check_sys_stav_as"   Checked='<%# Bind("sys_stav2") %>' /> --%>
                </ItemTemplate>
                <ItemStyle VerticalAlign="Top" HorizontalAlign="Center" />
            </asp:TemplateField>
            
             <asp:TemplateField HeaderText="Přístup (kdo může nastavit stav)" ItemStyle-VerticalAlign="Top">
            <ItemTemplate>
                    <asp:Label Text="Přístup (kdo může nastavit stav):" runat="server" Font-Bold="True" />

                    <asp:CheckBox ID="check_adresat" runat="server" Text="Řešitel" Checked='<%# Bind("pristup_a") %>' />
                       
                    <asp:CheckBox ID="check_vydavatel" runat="server" Text="Vydavatel" Checked='<%# Bind("pristup_v") %>' />
                        
                    <asp:CheckBox ID="check_spravce" runat="server" Text="Správce" Checked='<%# Bind("pristup_s") %>'/>
                       
                    <asp:CheckBox ID="check_ostatni" runat="server" Text="Ostatní" Checked='<%# Bind("pristup_o") %>' />
                        
                    
                    <tr  style="border:1px solid #e5e5e5">
                        <%--<td>&nbsp;</td>--%>
                        <td colspan="10" style="padding:0px;">
                            <table style="border-collapse:collapse;  padding:0px;" cellpadding="3">
                                <tr>
                                    <td style="min-width:21px; border-right:1px solid #e5e5e5; font-weight: bold;">
                                        <asp:Label ID="L_poradi" runat="server" Text="#" />
                                        <br/>
                                        <asp:Image ID="HelpImage" runat="server" ImageUrl="~/Images/query.png" ToolTip="[%Pořadí, ve kterém se podmínky procházejí%]"/>
                                    </td>
                                    <td style="min-width:356px;border-right:1px solid #e5e5e5; font-weight: bold;">
                                        <asp:Label ID="Label11" runat="server" Text="[%Podmínka%]" />
                                        <asp:Image ID="Image1" runat="server" ImageUrl="~/Images/query.png" ToolTip="[%Pokud je podmínka splněna, hodnoty řádku se použijí a další řádky s podmínkami se již neprocházejí%]"/>
                                    </td>
                                    <td style="min-width:190px;border-right:1px solid #e5e5e5; font-weight: bold;">
                                        <asp:Label ID="Label12" runat="server" Text="[%Validace%]" />
                                        <asp:Image ID="Image2" runat="server" ImageUrl="~/Images/query.png" ToolTip="[%Validační podmínka, která musí platit, jinak systém nedovolí uživateli stav nastavit. Za svislítkem je text, který se zobrazí uživateli při nesplnění.%]"/>
                                    </td>
                                    <td style="min-width:110px;border-right:1px solid #e5e5e5; font-weight: bold;">
                                        <asp:Label ID="Label13" runat="server" Text="[%Systémový stav%]" />
                                    </td>
                                    <td runat="server" id="akce_label" style="min-width:300px;border-right:1px solid #e5e5e5; font-weight: bold;">
                                        <asp:Label ID="Label14" runat="server" Text="[%Akce%]" />
                                    </td>
                                    <td style="max-width:30px;border-right:1px solid #e5e5e5; font-weight: bold;">
                                        <asp:Label ID="Label15" runat="server" Text="[%Násl. krok%]" ToolTip="[%Následující krok, který má být řešen%]"/>
                                    </td>
                                    <td style="min-width:170px;border-right:1px solid #e5e5e5; font-weight: bold;">
                                        <asp:Label ID="Label16" runat="server" Text="[%Řešitel pro násl. krok%]" />
                                        <br/>
                                        <asp:Image ID="ImgAdr" runat="server" ImageUrl="~/Images/query.png" />
                                        <telerik:RadToolTip ID="RadToolTip1" runat="server" TargetControlID="ImgAdr" Text="[%Řešitel pro následující krok%] - [%význam zkratek%]:<br/>vyd - [%vydavatel požadavku%],<br/>!vyd - [%kdokoliv s výjimkou vydavatele požadavku samotného%],<br/>pvyd - [%kdokoliv (kdo má přístup na vydavatele požadavku) s výjimkou vydavatele požadavku samotného%],<br/>id - [%id pracovního místa%],<br/>vd - [%nadřízený vydavatele požadavku%],<br/>vd_res - [%nadřízený aktuálního řešitele (tj. aktuálně přihlášeného)%],<br/>pstr - [%zaměstnanci s pracovním střediskem%],<br/>atribut - [%zaměstnanci s určitou hodnotou ve vlastnosti pracovního místa, zadává se číslo vlastnosti a číslo hodnoty (např: 1019:1)%],<br/>vd_atr - [%nejbližší nadřízený vydavatele jež má (nebo nemá) určitou hodnotu vlastnosti pracovního místa%]1019:ano (1019!přeskočit),<br/>oc - [%osobní číslo zaměstnance%],<br/>vyd_atrib_oc - [%číslo atributu pracovního místa vydavatele obsahující os. číslo řešitele%],<br/>vyd_atrib_pm - [%číslo atributu pracovního místa vydavatele obsahující pracovní místa řešitelů%],<br/>zpet - [%řešitel předchozího kroku%]<br/>vd_IdPracmista - [%Nadřízený prac. místa k místu ve vlastnosti IdPracMista%]<br/>NP_res - [%Aktuální řešitel v nadřízeném požadavku%]<br/>oc_pr - [%Os. číslo, které je předmětem požadavku%]" 
                                            Position="TopLeft"  AutoCloseDelay="0" HideDelay="100" ShowDelay="100" ></telerik:RadToolTip>
                                    </td>
                                    <td style="width:auto; font-weight: bold;width:170px;">
                                        <asp:Label ID="Label17" runat="server" Text="[%Oznámení komu%]" />
                                        <br/>
                                        <asp:Image ID="ImgOznam" runat="server" ImageUrl="~/Images/query.png" />
                                        <telerik:RadToolTip ID="RadToolTip2" runat="server" TargetControlID="ImgOznam" Text="[%E-mailové oznámení komu%]- [%význam zkratek%]:<br/>vyd - [%vydavatel požadavku%],<br/>id - [%id pracovního místa%],<br/>vd - [%nadřízený vydavatele požadavku%],<br/>vd_res - [%nadřízený aktuálního řešitele (tj. aktuálně přihlášeného)%],<br/>pstr - [%zaměstnanci s pracovním střediskem%],<br/>atribut - [%zaměstnanci s určitou hodnotou ve vlastnosti pracovního místa, zadává se číslo vlastnosti a číslo hodnoty (např: 1019:1)%],<br/>vd_atr - [%nejbližší nadřízený vydavatele s určitou hodnotou vlastnosti pracovního místa%],<br/>oc - [%osobní číslo zaměstnance%],<br/>vyd_atrib_oc - [%číslo atributu pracovního místa vydavatele obsahující os. číslo řešitele%],<br/>vyd_atrib_pm - [%číslo atributu pracovního místa vydavatele obsahující pracovní místa řešitelů%],<br/>zpet - [%řešitel předchozího kroku%]<br/>vd_IdPracMista - [%Nadřízený prac. místa k místu ve vlastnosti IdPracMista%]<br/>NP_res - [%Aktuální řešitel v nadřízeném požadavku%]<br/>oc_pr - [%Os. číslo, které je předmětem požadavku%]<br/>mail - [%e-mailová adresa%]"  
                                            Position="TopLeft"  AutoCloseDelay="0" HideDelay="100" ShowDelay="100" ></telerik:RadToolTip>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr  style="border:1px solid #e5e5e5;">  
                         <%--<td>&nbsp;</td>--%>     
                         <td colspan="10" style="padding:0px;">
                            <asp:Panel runat="server" ID="Pnl_pdm"  Height="220px" ScrollBars="Vertical" >
                            
                                <%--<asp:ObjectDataSource ID="ds_podminky" runat="server" TypeName="KSProgram.Workflow.WorkflowSettings"
                                    SelectMethod="GetPodminkyAvychozi" OnDataBinding="ds_podminky_DataBinding" OldValuesParameterFormatString="original_{0}">
                                    <SelectParameters>
                                        <asp:ControlParameter Name="typ" Type="string" ControlID="ddl_typ" PropertyName="SelectedValue" />
                                        <asp:ControlParameter Name="faze" Type="Int32" ControlID="HF_faze" PropertyName="Value" />
                                        <asp:ControlParameter Name="stav" Type="string" ControlID="tx_stav" PropertyName="Text" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>--%>
                                <%--DataSourceID="ds_podminky"--%>
                                <wc:TGridViewBulk ID="gv_pdm" runat="server"
                                    ShowHeader="False" ShowHeaderWhenEmpty="False" TitleText="Nastavení stavu" DataFields="poradi,vyraz,validace,sys_stav,akce,next_faze,adresat,oznam"
                                     PageSize="100" OnDataBinding="gv_pdm_DataBinding" OnPreRender="gv_pdm_PreRender"
                                    BorderStyle="None" BorderWidth="0px" BorderColor="#e5e5e5" RowStyle-BorderStyle="Solid" RowStyle-BorderWidth="1px" RowStyle-BorderColor="#E5E5E5"> 
                                    <Columns>
                                        <asp:TemplateField HeaderText="Pořadí" ItemStyle-VerticalAlign="Top">
                                            <ItemTemplate>
                                                <wc:TTextBox ID="tx_poradi" runat="server" Text='<%# Bind("poradi") %>' Width="20px" MaxLength="3"></wc:TTextBox>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Podmínka" ItemStyle-VerticalAlign="Top">
                                            <ItemTemplate>                                                
                                                <wc:TRadComboBox ID="rcmb_vyraz" runat="server" Text='<%# Bind("vyraz") %>' Width="356px" MaxLength="100" AllowCustomText="True"
                                                    DataSourceID="ds_WfProp" DataTextField="vyraz" DataValueField="vyraz" DropDownAutoWidth="Enabled"></wc:TRadComboBox>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Validace" ItemStyle-VerticalAlign="Top">
                                            <ItemTemplate>
                                                <asp:Table runat="server" ID="table_validace" CellPadding="0" CellSpacing="0">
                                                    <asp:TableRow runat="server" ID="table_validace_row1">
                                                        <asp:TableCell runat="server" ID="table_validace_row1_cell1">
                                                            <wc:TRadComboBox ID="rcmb_validace1" runat="server" Text='<%# Bind("validace1") %>' Width="190px" MaxLength="150" AllowCustomText="True"
                                                                DataSourceID="ds_WfProp" DataTextField="vyraz_validace" DataValueField="vyraz_validace" DropDownAutoWidth="Enabled">
                                                            </wc:TRadComboBox>
                                                        </asp:TableCell>
                                                    </asp:TableRow>

                                                    <asp:TableRow runat="server" ID="table_validace_row2">
                                                        <asp:TableCell runat="server" ID="table_validace_row2_cell1">
                                                            <wc:TRadComboBox ID="rcmb_validace2" runat="server" Text='<%# Bind("validace2") %>' Width="190px" MaxLength="150" AllowCustomText="True"
                                                                DataSourceID="ds_WfProp" DataTextField="vyraz_validace" DataValueField="vyraz_validace" DropDownAutoWidth="Enabled">
                                                            </wc:TRadComboBox>
                                                        </asp:TableCell>
                                                    </asp:TableRow>

                                                    <asp:TableRow runat="server" ID="table_validace_row3">
                                                        <asp:TableCell runat="server" ID="TableCell19">
                                                            <wc:TRadComboBox ID="rcmb_validace3" runat="server" Text='<%# Bind("validace3") %>' Width="190px" MaxLength="150" AllowCustomText="True"
                                                                DataSourceID="ds_WfProp" DataTextField="vyraz_validace" DataValueField="vyraz_validace" DropDownAutoWidth="Enabled">
                                                            </wc:TRadComboBox>
                                                        </asp:TableCell>
                                                    </asp:TableRow>
                                                </asp:Table>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" HorizontalAlign="Center" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Sys. stav" ItemStyle-VerticalAlign="Top">
                                            <ItemTemplate>
                                                <asp:DropDownList ID="ddl_sys_stav" runat="server" Width="110px"        CssClass="input"
                                                    DataSourceID="ds_sys_stav"  DataTextField="text" DataValueField="hodnota" SelectedValue='<%# Bind("sys_stav") %>' ></asp:DropDownList>
                                                
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Akce" ItemStyle-VerticalAlign="Top" >
                                            <ItemTemplate>                                                
                                                <asp:Table runat="server" ID="table1" CellPadding="0" CellSpacing="0">
                                                    <asp:TableRow runat="server" ID="table1_row1"  Visible='<%# Bind("akcevisible1") %>'>
                                                        <asp:TableCell runat="server" ID="table1_row1_cell1">                                                        
                                                            <%--<wc:TDropDown ID="ddlb_1" runat="server" SelectedValue='<%# Bind("akce1") %>' CssClass="input"
                                                                Width="140" DataSourceID="ds_akce" Visible='<%# Bind("akcevisible1") %>'  DataTextField="hodnota"
                                                                DataValueField="hodnota" AppendDataBoundItems="True">
                                                            </wc:TDropDown>--%>
                                                            <wc:TRadComboBox ID="ddlb_1" runat="server" Text='<%# Bind("akce1") %>' Width="300px" MaxLength="200" 
                                                                AllowCustomText="True" OnClientLoad="DDLAkce_OnClientLoad" OnClientSelectedIndexChanged="DDLAkce_OnClientSelectedIndexChanged"
                                                                DataSourceID="ds_akce" DataTextField="hodnota" DataValueField="hodnota" DropDownAutoWidth="Enabled" ValidateRequestMode="Disabled" CausesValidation="false">
                                                            </wc:TRadComboBox>
                                                        </asp:TableCell>
                                                    </asp:TableRow>
                                                    <asp:TableRow runat="server" ID="table1_row2"  Visible='<%# Bind("akcevisible2") %>'>
                                                        <asp:TableCell runat="server" ID="table1_row2_cell1">
                                                            <%--<wc:TDropDown ID="ddlb_2" runat="server" SelectedValue='<%# Bind("akce2") %>' CssClass="input"
                                                                Width="140" DataSourceID="ds_akce" Visible='<%# Bind("akcevisible2") %>' DataTextField="hodnota"
                                                                DataValueField="hodnota" AppendDataBoundItems="True">
                                                            </wc:TDropDown>--%>
                                                            <wc:TRadComboBox ID="ddlb_2" runat="server" Text='<%# Bind("akce2") %>' Width="300px" MaxLength="200" 
                                                                AllowCustomText="True" OnClientLoad="DDLAkce_OnClientLoad"  OnClientSelectedIndexChanged="DDLAkce_OnClientSelectedIndexChanged"
                                                                DataSourceID="ds_akce" DataTextField="hodnota" DataValueField="hodnota" DropDownAutoWidth="Enabled" ValidateRequestMode="Disabled"  CausesValidation="false">
                                                            </wc:TRadComboBox>
                                                        </asp:TableCell>
                                                    </asp:TableRow>
                                                    <asp:TableRow runat="server" ID="table1_row3"  Visible='<%# Bind("akcevisible3") %>'>
                                                        <asp:TableCell runat="server" ID="table1_row3_cell1">
                                                            <%--<wc:TDropDown ID="ddlb_3" runat="server" SelectedValue='<%# Bind("akce3") %>' CssClass="input"
                                                                Width="140" DataSourceID="ds_akce" Visible='<%# Bind("akcevisible3") %>' DataTextField="hodnota"
                                                                DataValueField="hodnota" AppendDataBoundItems="True">
                                                            </wc:TDropDown>--%>
                                                            <wc:TRadComboBox ID="ddlb_3" runat="server" Text='<%# Bind("akce3") %>' Width="300px" MaxLength="200" 
                                                                AllowCustomText="True" OnClientLoad="DDLAkce_OnClientLoad"  OnClientSelectedIndexChanged="DDLAkce_OnClientSelectedIndexChanged"
                                                                DataSourceID="ds_akce" DataTextField="hodnota" DataValueField="hodnota" DropDownAutoWidth="Enabled" ValidateRequestMode="Disabled"  CausesValidation="false">
                                                            </wc:TRadComboBox>
                                                        </asp:TableCell>
                                                    </asp:TableRow>
                                                    <asp:TableRow runat="server" ID="table1_row4"  Visible='<%# Bind("akcevisible4") %>'>
                                                        <asp:TableCell runat="server" ID="table1_row4_cell1">
                                                            <%--<wc:TDropDown ID="ddlb_4" runat="server" SelectedValue='<%# Bind("akce4") %>' CssClass="input"
                                                                Width="140" DataSourceID="ds_akce" Visible='<%# Bind("akcevisible4") %>' DataTextField="hodnota"
                                                                DataValueField="hodnota" AppendDataBoundItems="True">
                                                            </wc:TDropDown>--%>
                                                           <wc:TRadComboBox ID="ddlb_4" runat="server" Text='<%# Bind("akce4") %>' Width="300px" MaxLength="200" 
                                                               AllowCustomText="True" OnClientLoad="DDLAkce_OnClientLoad"  OnClientSelectedIndexChanged="DDLAkce_OnClientSelectedIndexChanged"
                                                                DataSourceID="ds_akce" DataTextField="hodnota" DataValueField="hodnota" DropDownAutoWidth="Enabled" ValidateRequestMode="Disabled"  CausesValidation="false">
                                                            </wc:TRadComboBox>
                                                        </asp:TableCell>
                                                    </asp:TableRow>
                                                    <asp:TableRow runat="server" ID="table1_row5"  Visible='<%# Bind("akcevisible5") %>'>
                                                        <asp:TableCell runat="server" ID="table1_row5_cell1">
                                                            <%--<wc:TDropDown ID="ddlb_5" runat="server" SelectedValue='<%# Bind("akce5") %>' CssClass="input"
                                                                Width="140" DataSourceID="ds_akce" Visible='<%# Bind("akcevisible5") %>' DataTextField="hodnota"
                                                                DataValueField="hodnota" AppendDataBoundItems="True">
                                                            </wc:TDropDown> --%>  
                                                            <wc:TRadComboBox ID="ddlb_5" runat="server" Text='<%# Bind("akce5") %>' Width="300px" MaxLength="200" 
                                                                AllowCustomText="True" OnClientLoad="DDLAkce_OnClientLoad"  OnClientSelectedIndexChanged="DDLAkce_OnClientSelectedIndexChanged"
                                                                DataSourceID="ds_akce" DataTextField="hodnota" DataValueField="hodnota" DropDownAutoWidth="Enabled" ValidateRequestMode="Disabled"  CausesValidation="false">
                                                            </wc:TRadComboBox>
                                                        </asp:TableCell>
                                                    </asp:TableRow>                                                    
                                                </asp:Table>
                                                 <asp:Label runat="server" ID="lab_fake" Text="[%Žádná akce k výběru%]" Visible='<%# Bind("akcevisible") %>' Width="140"></asp:Label>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Násl. krok" ItemStyle-VerticalAlign="Top">
                                            <ItemTemplate>
                                                <wc:TTextBox ID="tx_next_faze" runat="server" Text='<%# Bind("next_faze") %>' Width="30"></wc:TTextBox>
                    
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Řešitel pro násl. krok" ItemStyle-VerticalAlign="Top">
                                            <ItemTemplate>
                                                
                                                <asp:Table runat="server" ID="table2" CellPadding="0" CellSpacing="0">
                                                    <asp:TableRow runat="server" ID="table2_row4">
                                                        <asp:TableCell runat="server" ID="table2_row1_cell1">
                                                            <asp:DropDownList  runat="server" ID="ddlbadr_1" DataSourceID="ds_adresati"  CssClass="input"                                                                 
                                                                SelectedValue='<%# Bind("adresat1") %>' DataTextField="hodnota" DataValueField="hodnota">
                                                            </asp:DropDownList> <%--AutoPostBack="true" OnDataBound="ddlbadr_OnSelectedIndexChanged" OnSelectedIndexChanged="ddlbadr_OnSelectedIndexChanged"--%>
                                                        </asp:TableCell>
                                                        <asp:TableCell runat="server" ID="table2_row1_cell2">
                                                            <asp:Label runat="server" ID="label1" Text="="></asp:Label>
                                                        </asp:TableCell>
                                                        <asp:TableCell runat="server" ID="table2_row1_cell3">
                                                            <wc:TTextBox runat="server" ID="textBox_adresathodn1" Width="50" Text='<%# Bind("adresathodn1") %>' MaxLength="25"></wc:TTextBox>
                                                            <%--OnTextChanged="textBox_adresathodn_Changed" AutoPostBack="true"--%>
                                                        </asp:TableCell>
                                                    </asp:TableRow>
                                                    <asp:TableRow runat="server" ID="TableRow1">
                                                        <asp:TableCell runat="server" ID="TableCell1">
                                                            <asp:DropDownList  runat="server" ID="ddlbadr_2" DataSourceID="ds_adresati" CssClass="input"                                                                 
                                                                SelectedValue='<%# Bind("adresat2") %>' DataTextField="hodnota" DataValueField="hodnota">
                                                            </asp:DropDownList> <%--AutoPostBack="true" OnDataBound="ddlbadr_OnSelectedIndexChanged" OnSelectedIndexChanged="ddlbadr_OnSelectedIndexChanged"--%>
                                                        </asp:TableCell>
                                                        <asp:TableCell runat="server" ID="TableCell2">
                                                            <asp:Label runat="server" ID="label5" Text="="></asp:Label>
                                                        </asp:TableCell>
                                                        <asp:TableCell runat="server" ID="TableCell3">
                                                            <wc:TTextBox runat="server" ID="textBox_adresathodn2" Width="50" Text='<%# Bind("adresathodn2") %>' MaxLength="25"></wc:TTextBox>
                                                            <%--OnTextChanged="textBox_adresathodn_Changed" AutoPostBack="true"--%>
                                                        </asp:TableCell>
                                                    </asp:TableRow>
                                                    <asp:TableRow runat="server" ID="TableRow2">
                                                        <asp:TableCell runat="server" ID="TableCell4">
                                                            <asp:DropDownList runat="server" ID="ddlbadr_3" DataSourceID="ds_adresati" CssClass="input"                                                                 
                                                                SelectedValue='<%# Bind("adresat3") %>' DataTextField="hodnota" DataValueField="hodnota">
                                                            </asp:DropDownList> <%--AutoPostBack="true" OnDataBound="ddlbadr_OnSelectedIndexChanged" OnSelectedIndexChanged="ddlbadr_OnSelectedIndexChanged"--%>
                                                        </asp:TableCell>
                                                        <asp:TableCell runat="server" ID="TableCell5">
                                                            <asp:Label runat="server" ID="label6" Text="="></asp:Label>
                                                        </asp:TableCell>
                                                        <asp:TableCell runat="server" ID="TableCell6">
                                                            <wc:TTextBox runat="server" ID="textBox_adresathodn3" Width="50" Text='<%# Bind("adresathodn3") %>' MaxLength="25"></wc:TTextBox>
                                                            <%--OnTextChanged="textBox_adresathodn_Changed" AutoPostBack="true"--%>
                                                        </asp:TableCell>
                                                    </asp:TableRow>
                                                    <asp:TableRow runat="server" ID="TableRow5">
                                                        <asp:TableCell runat="server" ID="TableCell13">
                                                            <asp:DropDownList runat="server" ID="ddlbadr_4" DataSourceID="ds_adresati" CssClass="input"                                                                 
                                                                SelectedValue='<%# Bind("adresat4") %>' DataTextField="hodnota" DataValueField="hodnota">
                                                            </asp:DropDownList> 
                                                        </asp:TableCell>
                                                        <asp:TableCell runat="server" ID="TableCell14">
                                                            <asp:Label runat="server" ID="label9" Text="="></asp:Label>
                                                        </asp:TableCell>
                                                        <asp:TableCell runat="server" ID="TableCell15">
                                                            <wc:TTextBox runat="server" ID="textBox_adresathodn4" Width="50" Text='<%# Bind("adresathodn4") %>' MaxLength="25"></wc:TTextBox>
                                                        </asp:TableCell>
                                                    </asp:TableRow>
                                                    <asp:TableRow runat="server" ID="TableRow6">
                                                        <asp:TableCell runat="server" ID="TableCell16">
                                                            <asp:DropDownList runat="server" ID="ddlbadr_5" DataSourceID="ds_adresati" CssClass="input"                                                                 
                                                                SelectedValue='<%# Bind("adresat5") %>' DataTextField="hodnota" DataValueField="hodnota">
                                                            </asp:DropDownList> 
                                                        </asp:TableCell>
                                                        <asp:TableCell runat="server" ID="TableCell17">
                                                            <asp:Label runat="server" ID="label10" Text="="></asp:Label>
                                                        </asp:TableCell>
                                                        <asp:TableCell runat="server" ID="TableCell18">
                                                            <wc:TTextBox runat="server" ID="textBox_adresathodn5" Width="50" Text='<%# Bind("adresathodn5") %>' MaxLength="25"></wc:TTextBox>
                                                        </asp:TableCell>
                                                    </asp:TableRow>
                                                </asp:Table>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Oznámení komu" ItemStyle-VerticalAlign="Top">
                                            <ItemTemplate>
                                                
                                                <asp:Table runat="server" ID="table3" CellPadding="0" CellSpacing="0">
                                                    <asp:TableRow runat="server" ID="table3_row4">
                                                        <asp:TableCell runat="server" ID="table3_row1_cell1">
                                                            <asp:DropDownList  runat="server" ID="ddlboznam_1" DataSourceID="ds_oznamkomu" CssClass="input"                                                                 
                                                                SelectedValue='<%# Bind("oznam1") %>' DataTextField="hodnota" DataValueField="hodnota">
                                                            </asp:DropDownList> <%--AutoPostBack="true" OnDataBound="ddlboznam_OnSelectedIndexChanged" OnSelectedIndexChanged="ddlboznam_OnSelectedIndexChanged"--%>
                                                        </asp:TableCell>
                                                        <asp:TableCell runat="server" ID="table3_row1_cell2">
                                                            <asp:Label runat="server" ID="label2" Text="="></asp:Label>
                                                        </asp:TableCell>
                                                        <asp:TableCell runat="server" ID="table3_row1_cell3">
                                                            <wc:TTextBox runat="server" ID="textBox_oznamhodn1" Width="50" Text='<%# Bind("oznamhodn1") %>' MaxLength="35"></wc:TTextBox>
                                                        </asp:TableCell>
                                                    </asp:TableRow>
                                                    <asp:TableRow runat="server" ID="table3_row5">
                                                        <asp:TableCell runat="server" ID="table3_row5_cell1">
                                                            <asp:DropDownList runat="server" ID="ddlboznam_2" DataSourceID="ds_oznamkomu" CssClass="input"                                                                 
                                                                SelectedValue='<%# Bind("oznam2") %>' DataTextField="hodnota" DataValueField="hodnota">
                                                            </asp:DropDownList> <%--AutoPostBack="true" OnDataBound="ddlboznam_OnSelectedIndexChanged" OnSelectedIndexChanged="ddlboznam_OnSelectedIndexChanged"--%>
                                                        </asp:TableCell>
                                                        <asp:TableCell runat="server" ID="table3_row5_cell2">
                                                            <asp:Label runat="server" ID="label3" Text="="></asp:Label>
                                                        </asp:TableCell>
                                                        <asp:TableCell runat="server" ID="table3_row5_cell3">
                                                            <wc:TTextBox runat="server" ID="textBox_oznamhodn2" Width="50" Text='<%# Bind("oznamhodn2") %>' MaxLength="35"></wc:TTextBox>
                                                        </asp:TableCell>
                                                    </asp:TableRow>
                                                    <asp:TableRow runat="server" ID="table3_row6">
                                                        <asp:TableCell runat="server" ID="table3_row6_cell1">
                                                            <asp:DropDownList runat="server" ID="ddlboznam_3" DataSourceID="ds_oznamkomu" CssClass="input"                                                                 
                                                                SelectedValue='<%# Bind("oznam3") %>' DataTextField="hodnota" DataValueField="hodnota">
                                                            </asp:DropDownList> <%--AutoPostBack="true" OnDataBound="ddlboznam_OnSelectedIndexChanged" OnSelectedIndexChanged="ddlboznam_OnSelectedIndexChanged"--%>
                                                        </asp:TableCell>
                                                        <asp:TableCell runat="server" ID="table3_row6_cell2">
                                                            <asp:Label runat="server" ID="label4" Text="="></asp:Label>
                                                        </asp:TableCell>
                                                        <asp:TableCell runat="server" ID="table3_row6_cell3">
                                                            <wc:TTextBox runat="server" ID="textBox_oznamhodn3" Width="50" Text='<%# Bind("oznamhodn3") %>' MaxLength="35"></wc:TTextBox>
                                                        </asp:TableCell>
                                                    </asp:TableRow>
                                                    <asp:TableRow runat="server" ID="TableRow3">
                                                        <asp:TableCell runat="server" ID="TableCell7">
                                                            <asp:DropDownList runat="server" ID="ddlboznam_4" DataSourceID="ds_oznamkomu" CssClass="input"                                                                 
                                                                SelectedValue='<%# Bind("oznam4") %>' DataTextField="hodnota" DataValueField="hodnota">
                                                            </asp:DropDownList> 
                                                        </asp:TableCell>
                                                        <asp:TableCell runat="server" ID="TableCell8">
                                                            <asp:Label runat="server" ID="label7" Text="="></asp:Label>
                                                        </asp:TableCell>
                                                        <asp:TableCell runat="server" ID="TableCell9">
                                                            <wc:TTextBox runat="server" ID="textBox_oznamhodn4" Width="50" Text='<%# Bind("oznamhodn4") %>' MaxLength="35"></wc:TTextBox>
                                                        </asp:TableCell>
                                                    </asp:TableRow>
                                                    <asp:TableRow runat="server" ID="TableRow4">
                                                        <asp:TableCell runat="server" ID="TableCell10">
                                                            <asp:DropDownList runat="server" ID="ddlboznam_5" DataSourceID="ds_oznamkomu" CssClass="input"                                                                 
                                                                SelectedValue='<%# Bind("oznam5") %>' DataTextField="hodnota" DataValueField="hodnota">
                                                            </asp:DropDownList>
                                                        </asp:TableCell>
                                                        <asp:TableCell runat="server" ID="TableCell11">
                                                            <asp:Label runat="server" ID="label8" Text="="></asp:Label>
                                                        </asp:TableCell>
                                                        <asp:TableCell runat="server" ID="TableCell12">
                                                            <wc:TTextBox runat="server" ID="textBox_oznamhodn5" Width="50" Text='<%# Bind("oznamhodn5") %>' MaxLength="35"></wc:TTextBox>
                                                        </asp:TableCell>
                                                    </asp:TableRow>
                                                </asp:Table>
		                                    </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" />
                                        </asp:TemplateField>
                                    </Columns>
                                </wc:TGridViewBulk>

                            </asp:Panel>
                            <%--<asp:CustomValidator runat="server" ID="CustValidator" OnServerValidate="CustValidator_ServerValidate" ></asp:CustomValidator>--%>
                             
                        </td>
                    </tr>
                    <asp:Panel runat="server" ID="pan_email"  >
                        <tr  style="border-bottom:1px solid black">
                        <td colspan="10" style="padding-left:20px; padding-top:0px; padding-bottom:5px">
                            <table style="border-collapse:collapse">
                                <tr>
                                    <td>
                                        <asp:Label runat="server" ID="lab_pokyn_key" Text="Popisek"></asp:Label>
                                    </td>
                                    <td>
                                        <wc:TTextBox ID="tx_email_hlavicka" runat="server" Text='<%# Bind("email_hlavicka") %>' Width="50"></wc:TTextBox>
                                    </td>
                                    <td>
                                        <asp:Label runat="server" ID="lab_pokyn_data" Text="Text"></asp:Label>
                                    </td>
                                    <td>
                                         <wc:TTextBox ID="tx_email_text" runat="server" Text='<%# Bind("email_text") %>' Width="450"></wc:TTextBox>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:Label ID="LabelZprava" runat="server" Text="Zprava"></asp:Label>
                                    </td>
                                    <td colspan="3">
                                       <wc:TTextBox ID="TextBoxZprava" runat="server" Text='<%# Bind("zprava") %>' Width="650" MaxLength="200"></wc:TTextBox>
                                    </td>
                                </tr>
                            </table>
                            
                        </td>
                    </tr>
                    </asp:Panel>
                    
                </ItemTemplate>
                <ItemStyle VerticalAlign="Top" />
            </asp:TemplateField>           
        </Columns>
    </wc:TGridViewBulk>
    

    
</div>
</ContentTemplate>
</wca:TitledPanel>
