﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="DashBoardPanel_Bulletin.ascx.cs" Inherits="KSPortal.DashBoard.DashBoardPanel_Bulletin" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<%@ Register Src="~/Dokumenty/PdfViewer.ascx" TagName="PdfViewer" TagPrefix="pdf" %>


<style type="text/css">
    .ksBullEditorWindow {
    }

        .ksBullEditorWindow td.rwBodyLeft, .ksBullEditorWindow td.rwBodyRight,
        .ksBullEditorWindow td.rwFooterLeft, .ksBullEditorWindow td.rwFooterCenter, .ksBullEditorWindow td.rwFooterRight {
            background-color: lightgray !important;
        }

    div.ksBullEditorContainer {
        height: 100%;
        width: 100%;
    }

    div.ksBullEditorContainerE {
        height: calc(100% - 74px);
    }

    div.ksPdfInner {
        height: 100%;
        width: 100%;
    }

    div.ksEditorInner {
        height: 100%;
        width: 100%;
        overflow: auto;
    }

    div.ksBullEditorCommand {
        width: 100%;
    }

    fieldset.ksBlFsEmpty {
        margin: 2px 0 2px 0;
        border-color: lightgray;
        border-style: solid;
        border-width: 1px;
        padding: 4px 4px 4px 8px;
    }

        fieldset.ksBlFsEmpty > div {
            width: 100%;
            position: relative;
        }

            fieldset.ksBlFsEmpty > div > p {
                font-size: 16px !important;
                /*color: #294C7E !important;*/
            }

    .buttonDok {
        background: var(--kscolor1) !important;
        border: 1px var(--kscolor1) !important;
        color: var(--kscolor1text) !important;
        height: 50px;
        text-align: center !important;
        font-size: 16px !important;
        margin: 20px 0px 0px 100px;
        cursor: pointer;
        width: calc(100% - 200px);
        transition: 0.5s;
    }

    .button1 {
        background-color: var(--kscolor1);
        border: none;
        color: var(--kscolor1text);
        text-align: center;
        text-decoration: none;
        font-size: 16px;
        margin: 4px 2px;
        cursor: pointer;
    }

    .floatRight {
        float: right;
        margin-right: 10px;
    }

    div.ksBlLv {
        border-top: 1px var(--kscolor1) solid;
    }
</style>
<telerik:RadScriptBlock ID="RSB2" runat="server">
    <script type="text/javascript">
        //<![CDATA[

        function RD_Bulletin_ClientDockPositionChanged(sender, args) {

        }

        function ParseBull(sender, args) {
            var response = args.get_response().d;
            if (response) {
                args.set_parsedData(response.Data);
            }
        }

        function RW_editor_BeforeShow(sender, args) {
            var poz = $get('<%=P_hidden_holder.ClientID%>').getBoundingClientRect();
            sender.moveTo(poz.left, poz.top);
        }

        function _emptyText() {
            return '<%=KSProgram.Obecne.ReadGlobalResource.ZmenaTextu("[%Žádné oznámení%]")%>';
        }

        function ksShowEditor(id) {
            $.ajax({
                type: "POST",
                url: KSMaster.baseUrl + "/DashBoard/WebMethods.aspx/GetBulletinHtml",
                data: "{id: " + id + "}",
                async: false,
                contentType: "application/json",
                dataType: "json",
                failure: function (response) {
                    radalert("Chyba: " + $telerik.$.parseJSON(response.responseText).Message, 0, 0, "Služba GetBulletinHtml");
                },
                error: function (response) {
                    radalert("Chyba: " + $telerik.$.parseJSON(response.responseText).Message, 0, 0, "Služba GetBulletinHtml");
                },
                success: function (msg) {
                    if (msg.d != null) {
                        if (msg.d == 'neni telo') {
                            // pokud neni telo nic se nezobrazi
                        }
                        else {
                            var button = document.getElementById("<%=Btn_kontrola.ClientID %>");
                            button.style.display = "none";
                            var window = $find("<%=RW_editor.ClientID%>");
                            var editor = $get("<%=RE_editor.ClientID%>");
                            var pdfViewer = $get("<%=PdfViewer2.ViewerClientID%>");
                            
                            if (msg.d.substring(0, 3) == "PDF") {
                                editor.innerHTML = '';
                                editor.style.display = "none";
                                pdfViewer.style.display = "block";

                                window.setSize(750, 810);
                                window.show();
                                
                                if (KSMaster.PdfViewer.isRendered && KSMaster.PdfViewer.element.innerHTML != '')
                                    KSMaster.PdfViewer.load('fromSession', null);
                                
                            }
                            else {
                                window.show();
                                if (KSMaster && KSMaster.PdfViewer && KSMaster.PdfViewer.isRendered)
                                    KSMaster.PdfViewer.destroy();
                                pdfViewer.style.display = "none";

                                editor.innerHTML = msg.d;
                                editor.style.display = "block";
                               
                                window.setSize(750, 810);
                            }

                            window.Center();
                            setButtonText(id);
                            button.style.display = "inline";
                            id_bull = id;
                        }
                    }
                    else {
                        radalert("Chyba: nepodařilo se načíst tělo vývěsky.", 0, 0, "Služba GetBulletinHtml");
                    }
                }
            });
        }

        function setButtonText(id) {
            var button = $find("<%=Btn_kontrola.ClientID %>");
            $.ajax({
                type: "POST",
                url: KSMaster.baseUrl + "/DashBoard/WebMethods.aspx/GetTextTlacitko",
                data: "{id: " + id + "}",
                async: false,
                contentType: "application/json",
                dataType: "json",
                failure: function (response) {
                    button.innerText = "[%Dokument zkontrolován%]";
                },
                error: function (response) {
                    button.innerText = "[%Dokument zkontrolován%]";
                },
                success: function (msg) {

                    button.set_text(msg.d);

                }
            });
        }

        function PdfControled() {
            $.ajax({
                type: "POST",
                url: KSMaster.baseUrl + "/DashBoard/WebMethods.aspx/CallPdfUpdate",
                data: "{id: " + id_bull + "}",
                async: false,
                contentType: "application/json",
                dataType: "json",
                failure: function (response) {
                    //alert("Chyba: " + JSON.parse(response.responseText).Message);
                    radalert("Chyba: " + $telerik.$.parseJSON(response.responseText).Message, 0, 0, "Služba CallPdfUpdate");
                },
                error: function (response) {
                    //alert("Chyba: ", JSON.parse(response.responseText).Message);
                    radalert("Chyba: " + $telerik.$.parseJSON(response.responseText).Message, 0, 0, "Služba CallPdfUpdate");
                },
                success: function (msg) {
                    var window = $find("<%=RW_editor.ClientID%>");
                    window.close();

                    showLoadingAnimation();
                    location.reload();

                }
            });

        }
        var id_bull = 0;

        function _base64ToArrayBuffer(base64) {
            var binary_string = window.atob(base64);
            var len = binary_string.length;
            var bytes = new Uint8Array(len);
            for (var i = 0; i < len; i++) {
                bytes[i] = binary_string.charCodeAt(i);
            }
            return bytes.buffer;
        }

        function readBulletin(el) {
            el.children[0].style.border = "1px solid var(--kscolor2)";
        };

        function precteneRedirect() {
            location.replace("./Bulletin/BulletinPrectene.aspx");
        }

        pdfDataByte = null;
        numberofpage = 1;
    </script>

</telerik:RadScriptBlock>
<asp:HiddenField runat="server" ID="id_zpr" Value="" />

<div style="width: 100%;">
    <kspwc:TRadButton ID="TRadButton1" runat="server" Text="[%Přečtené%]" AutoPostBack="False" OnClientClicked="precteneRedirect" CssClass="floatRight kstlacitko">
        <Icon PrimaryIconCssClass="fi fi-list"></Icon>
    </kspwc:TRadButton>
</div>


<table style="width: 100%">
    <tr>
        <td style="width: 100%">
            <telerik:RadListView runat="server" ID="RLV_bull" ItemPlaceholderID="ItemsPlaceHolder" ClientDataSourceID="RCDS_bulls"
                DataKeyNames="id" ClientDataKeyNames="id">
                <LayoutTemplate>
                    <div id="ItemsPlaceHolder" runat="server" class="ksBlLv">
                    </div>
                </LayoutTemplate>
                <ClientSettings>
                    <ClientEvents />
                    <DataBinding>
                        <ItemTemplate>
                            <a href="javascript:ksShowEditor ? ksShowEditor(#= id #) : ''" onclick="readBulletin(this)" style="text-decoration: none;">
                                <fieldset class="ksBlFs revertShadow" style=" border:  #= Stats[0] ? 'solid 1px lightgrey' : 'solid 2px lightgrey' #;">
                                    <div class="ksBlBullItem">
                                        <div>
                                            <div class="ksBlFoto" style="display: #= id_image ? 'block' : 'none' #; #= id_image ? '' : 'max-height:unset;' #" >
                                                <img style="max-height: 107px; width:auto;" src="#= ImageUrl #" />
                                            </div>
                                            <div>
                                                <p>
                                                    #= nadpis #
                                                </p>
                                                <p>
                                                    #= telo #
                                                </p>
                                                <i class="fi fi-bell-ring" style="font-size: 20px; position: absolute; right: 15px; top: 0; display: #= Stats[0] ? 'none' : 'block' #;"></i>
                                            </div>
                                        </div>
                                    </div>
                                </fieldset>
                             </a>
                        </ItemTemplate>
                        <EmptyDataTemplate>
                            <fieldset class="ksDbLiFs" style="border:none;">
                                <div>
                                    <p class="zadneBull">
                                        <i class="fi fi-comment-alt"></i>
                                        <label>#=_emptyText()#</label>
                                    </p>
                                </div>
                            </fieldset>
                        </EmptyDataTemplate>
                    </DataBinding>
                </ClientSettings>
            </telerik:RadListView>
        </td>
        <td valign="top">
            <asp:Panel runat="server" ID="P_hidden_holder" CssClass="hidden">
            </asp:Panel>
        </td>
    </tr>
</table>

<telerik:RadWindow runat="server" ID="RW_editor" AutoSize="false" KeepInScreenBounds="true" MinWidth="720" MinHeight="625" CssClass="ksBullEditorWindow"
    AutoSizeBehaviors="Height,Width" Behaviors="Close,Maximize,Minimize,Move,Resize" OnClientBeforeShow="RW_editor_BeforeShow"
    ShowContentDuringLoad="false">
    <ContentTemplate>
        <div class="ksBullEditorContainer">
            <div class="ksBullEditorContainerE">
                <pdf:PdfViewer runat="server" ID="PdfViewer2" Height="100%" Width="100%" CssClass="ksPdfInner" AutoApppend="False"></pdf:PdfViewer>
                <div runat="server" id="RE_editor" class="ksEditorInner">
                </div>
            </div>
            <kspwc:TRadButton runat="server" AutoPostBack="false" ID="Btn_kontrola" Visible="true" CssClass="buttonDok" OnClientClicked="PdfControled"></kspwc:TRadButton>
        </div>
    </ContentTemplate>
</telerik:RadWindow>

<telerik:RadClientDataSource ID="RCDS_bulls" runat="server" AllowBatchOperations="false" AllowPaging="true">
    <ClientEvents OnDataParse="ParseBull" />
    <DataSource>
        <WebServiceDataSourceSettings>
            <Select Url="DashBoard/WebMethods.aspx/GetBulletins" DataType="JSON" RequestType="Post" ContentType="application/json; charset=utf-8" />
        </WebServiceDataSourceSettings>
    </DataSource>
    <Schema>
        <Model ID="id">
            <telerik:ClientDataSourceModelField FieldName="id" DataType="Number" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="nadpis" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="telo" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="ImageUrl" DataType="String" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="id_image" DataType="Number" Editable="False" />
            <telerik:ClientDataSourceModelField FieldName="tlacitko" DataType="String" Editable="False" />
        </Model>
    </Schema>
</telerik:RadClientDataSource>
