﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" Inherits="Dochazka_DenniPoriz" CodeBehind="DenniPoriz.aspx.cs" %>

<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls.Ciselniky" TagPrefix="cc1" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajax" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <script type="text/javascript">
        function onPopulated(sender, e) {
            var finds = sender.get_completionList().childNodes;
            finds[0].parentElement.style.whiteSpace = 'normal';
            finds[0].parentElement.style.maxHeight = '120px';
            finds[0].parentElement.style.padding = '2px';
            finds[0].parentElement.style.position = 'absolute';
            finds[0].parentElement.style.border = '1px solid #808080';
            finds[0].parentElement.style.overflow = 'auto';
            for (var i = 0; i < finds.length; i++) {
                var find = finds[i];
                find.style.backgroundColor = '#FFFFFF';
                find.style.padding = '2px';
                find.style.whiteSpace = 'normal';
                find.style.cursor = 'pointer';
                if (i != (finds.length - 1))
                    find.style.borderBottom = '1px dotted #808080';
            }
        }

        function Change(obj, evt) {
            if (evt.type == "focus") {
                obj.style.borderColor = "red";
                obj.borderWidth = "5px";
                obj.backgroundColor = "red";
            }
            else if (evt.type == "blur") {
                obj.style.borderColor = "black";
                obj.borderWidth = "thin";
                obj.backgroundColor = "black";
            }
        }

        function OnKeyPressOsCisla(sender, eventArgs) {
            var char = eventArgs.get_keyCode();
            //backspace      sipka        sipka         carka      tabulator           cisla
            if (char == 8 || char == 37 || char == 39 || char == 44 || char == 9 || (char >= 48 && char <= 57)) {
                eventArgs.set_cancel(false);
            }
            else {
                eventArgs.set_cancel(true);
            }
        }

        function OnClientItemsRequesting(sender, eventArgs) {
            var context = eventArgs.get_context();
            context["os_cislo"] = KSMaster.HF_sel_os_cislo.value;
            context["cislo_pom"] = KSMaster.HF_sel_cislo_pom.value;
        }
    </script>
    <%-- Slouží pro správnou funkčnost validátorů --%>
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="panel">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="panel" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="lb_poriz">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="panel" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="radDropDownList">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="FormPoriz" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="lb_prehled">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="panel" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <asp:Label ID="nadpis" CssClass="nadpis1" runat="server" Text="[%Denní pořizování%]"></asp:Label>
    <div class="ksprvek" style="padding: 10px; margin-bottom: 30px">
        <table style="border-collapse: collapse;">
            <tr>
                <td>
                    <table style="border-collapse: collapse;">
                        <tr>
                            <td>
                                <wc:TLinkButton ID="lb_poriz" runat="server" Text="[%Pořizování%]" SkinID="button" CausesValidation="false"
                                    OnCommand="lb_poriz_Command"></wc:TLinkButton>
                                <wc:TLinkButton ID="lb_prehled" runat="server" Text="[%Sumární přehled%]" CausesValidation="false"
                                    SkinID="button" OnCommand="lb_prehled_Command"></wc:TLinkButton>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Panel ID="panel" runat="server">
                        <%-- pridání panelu pro jednoduší aaktualizaci --%>
                        <asp:MultiView runat="server" ID="mv" ActiveViewIndex="1">
                            <asp:View runat="server" ID="v_poriz">
                                <asp:Panel runat="server" ID="P_view" DefaultButton="lb_ulozit2">
                                    <table style="border-collapse: collapse; margin-bottom: 10px;">
                                        <tr>
                                            <td style="vertical-align: top">
                                                <asp:Label ID="Label12" runat="server" Text="[%Datum%]:"></asp:Label>
                                            </td>
                                            <td style="vertical-align: top">
                                                <%--<wc:DateControl ID="DateControl1" runat="server" BackColor="Yellow" />--%>
                                                <wc:TRadDatePicker ID="DateControl1" runat="server" Validace="true" ValidatorMessage="*" DateInput-BackColor="#ffffcc"></wc:TRadDatePicker>

                                            </td>
                                            <td style="vertical-align: top">
                                                <asp:Label ID="Label13" runat="server" Text="[%Dávka%]:"></asp:Label>
                                            </td>
                                            <td style="vertical-align: top">
                                                <asp:TextBox ID="text_davka" runat="server" BackColor="#ffffcc" MaxLength="12" Width="80px"></asp:TextBox>
                                                <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="text_davka"
                                                    ErrorMessage="RequiredFieldValidator"></asp:RequiredFieldValidator>
                                            </td>
                                            <td style="vertical-align: top">
                                                <asp:Label runat="server" ID="Label1" Text="[%Udržovat hodnoty u následujících položek%]:" ></asp:Label>
                                            </td>
                                            <td style="vertical-align: top">
                                                <asp:CheckBox ID="check_os_cislo" runat="server" Text="[%Os. číslo%]"  />
                                            </td>
                                            <td style="vertical-align: top">
                                                <asp:CheckBox ID="check_stred" runat="server" Text="[%Středisko%]"  />
                                            </td>
                                            <td style="vertical-align: top">
                                                <asp:CheckBox ID="check_kod" runat="server" Text="[%Kód%]"  />
                                            </td>
                                            <td style="vertical-align: top">
                                                <asp:CheckBox ID="check_doba" runat="server" Text="[%Doba%]"  />
                                            </td>
                                        </tr>
                                    </table>
                                    <table style="border-collapse: collapse">
                                        <tr>
                                            <td>
                                                <asp:FormView ID="FormPoriz" runat="server" DefaultMode="Insert" DataSourceID="ds_FormPoriz"
                                                    OnPreRender="FormPoriz_PreRender">
                                                    <InsertItemTemplate>
                                                        <asp:Panel runat="server" ID="P_insert_template_panel" DefaultButton="lb_ulozit">
                                                            <asp:Table runat="server" ID="TableItem" SkinID="RamAPozadi">
                                                                <asp:TableHeaderRow runat="server" ID="TableHeaderRowItem">
                                                                    <asp:TableCell runat="server" ColumnSpan="4" ID="TableCellItem14x" SkinID="TitleRowStyle">
                                                                        <asp:Label ID="Label7x" runat="server" Text="[%Pořizování%]"></asp:Label>
                                                                    </asp:TableCell>
                                                                </asp:TableHeaderRow>
                                                                <asp:TableRow runat="server" ID="TableRow9">
                                                                    <asp:TableCell runat="server" ID="tablecell1">
                                                                        <asp:Table runat="server" ID="table1" Style="border-collapse: collapse;">
                                                                            <asp:TableRow runat="server" ID="row1">
                                                                                <asp:TableCell runat="server" ID="tablecell1_">
                                                                                    <asp:Table runat="server" ID="table2" Style="border-collapse: collapse;">
                                                                                        <asp:TableRow runat="server" ID="TableRow1">
                                                                                            <asp:TableCell runat="server" ID="tablecell102" SkinID="DataFieldHeaderStyle">
                                                                                                <asp:Label ID="Label1" runat="server" Text="[%Os. číslo%]"></asp:Label>
                                                                                            </asp:TableCell>
                                                                                            <asp:TableCell runat="server" ID="tablecell103" ColumnSpan="7" SkinID="DataFieldStyle">
                                                                                                <%--<asp:TextBox ID="tx_os_cislo" runat="server" AutoPostBack="True" BackColor="Yellow"
                                                                                        OnTextChanged="tx_os_cislo_TextChanged" Text='<%# Bind("os_cislo") %>'></asp:TextBox>--%>
                                                                                                <telerik:RadNumericTextBox ID="tx_os_cislo" runat="server" AutoPostBack="True" BackColor="#ffffcc" NumberFormat-DecimalDigits="0" DataType="System.Decimal"
                                                                                                    OnTextChanged="tx_os_cislo_TextChanged" Text='<%# Bind("os_cislo") %>' Width="187" ValidateRequestMode="Enabled">
                                                                                                </telerik:RadNumericTextBox>
                                                                                                <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="tx_os_cislo"
                                                                                                    ErrorMessage="RequiredFieldValidator"></asp:RequiredFieldValidator>
                                                                                                <asp:CustomValidator runat="server" ID="cv_os_cislo" ControlToValidate="tx_os_cislo" Display="Dynamic" OnServerValidate="cv_os_cislo_ServerValidate" Text="[%Neplatný poměr%]" ErrorMessage="[%Neplatný poměr%]"></asp:CustomValidator>
                                                                                            </asp:TableCell>
                                                                                        </asp:TableRow>
                                                                                        <asp:TableRow runat="server" ID="TableRow2">
                                                                                            <asp:TableCell runat="server" ID="tablecell2" SkinID="DataFieldHeaderStyle">
                                                                                                <asp:Label ID="lab_jmeno" runat="server" Text="[%Jméno%]"></asp:Label>
                                                                                            </asp:TableCell>
                                                                                            <asp:TableCell runat="server" ID="tablecell3" ColumnSpan="7" SkinID="DataFieldStyle">
                                                                                                <asp:TextBox ID="tx_jmeno" runat="server" BackColor="#ffffcc" AutoCompleteType="DisplayName" Width="182  "
                                                                                                    AutoPostBack="True" OnTextChanged="tx_jmeno_TextChanged"></asp:TextBox>
                                                                                                <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ControlToValidate="tx_jmeno"
                                                                                                    ErrorMessage="RequiredFieldValidator"></asp:RequiredFieldValidator>
                                                                                                <div runat="server" id="div_zam">
                                                                                                </div>
                                                                                                <ajax:AutoCompleteExtender ID="ac_jmeno" runat="server" TargetControlID="tx_jmeno"
                                                                                                    ServiceMethod="JmenoZam" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                                                                                    MinimumPrefixLength="1" FirstRowSelected="True" UseContextKey="True" CompletionListElementID="div_zam"
                                                                                                    OnClientPopulated="onPopulated" CompletionInterval="500">
                                                                                                </ajax:AutoCompleteExtender>
                                                                                            </asp:TableCell>
                                                                                        </asp:TableRow>
                                                                                        <asp:TableRow runat="server" ID="TableRow3">
                                                                                            <asp:TableCell runat="server" ID="tablecell4" SkinID="DataFieldHeaderStyle">
                                                                                                <asp:Label ID="Label3" runat="server" Text="[%Středisko%]"></asp:Label>
                                                                                            </asp:TableCell>
                                                                                            <asp:TableCell runat="server" ID="tablecell5" ColumnSpan="7" SkinID="DataFieldStyle">
                                                                                                <asp:TextBox runat="server" ID="tx_stred" Text='<%# Bind("stred") %>' BackColor="#ffffcc" OnTextChanged="tx_stred_text_changed" Width="182"></asp:TextBox>
                                                                                                <ajax:AutoCompleteExtender ID="AutoCompleteExtender1" runat="server" TargetControlID="tx_stred"
                                                                                                    ServiceMethod="Stredisko" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                                                                                    MinimumPrefixLength="1" FirstRowSelected="True" UseContextKey="True" CompletionListElementID="div_zam"
                                                                                                    OnClientPopulated="onPopulated" CompletionInterval="500">
                                                                                                </ajax:AutoCompleteExtender>
                                                                                                <asp:RequiredFieldValidator ID="RequiredFieldValidator4" runat="server" ControlToValidate="tx_stred"
                                                                                                    ErrorMessage="RequiredFieldValidator"></asp:RequiredFieldValidator>
                                                                                                <%--<asp:CustomValidator ID="cv" runat="server" ControlToValidate="tx_stred" ValidationGroup="stred_group" OnServerValidate="validate_tx_stred" ErrorMessage="Neplatné středisko"></asp:CustomValidator>--%>
                                                                                            </asp:TableCell>
                                                                                        </asp:TableRow>
                                                                                        <asp:TableRow runat="server" ID="TableRow4">
                                                                                            <asp:TableCell runat="server" ID="tablecell6" SkinID="DataFieldHeaderStyle">
                                                                                                <asp:Label ID="Label4" runat="server" Text="[%Kód%]"></asp:Label>
                                                                                            </asp:TableCell>
                                                                                            <asp:TableCell runat="server" ID="tablecell7" ColumnSpan="7" SkinID="DataFieldStyle">
                                                                                                <%--<asp:DropDownList runat="server" ID="ddl_kod"  DataSourceID="ds_kod" OnTextChanged="ddl_kod_SelectedIndexChanged"
                                                                                        DataTextField="cely_nazev" DataValueField="vyr_kod" SelectedValue='<%# Bind("kod") %>' AutoPostBack="True"> 
                                                                                    </asp:DropDownList>--%>

                                                                                                <%--<telerik:RadComboBox ID="radDropDownList" runat="server" SelectedValue='<%# Bind("kod") %>' AutoPostBack="True" OnTextChanged="radDropDownList_TextChanged"
                                                                                        Width="186" DataTextField="cely_nazev" MarkFirstMatch="True" EnableTextSelection="true" DataValueField="vyr_kod" DataSourceID="ds_kod" OnDataBinding="radDropDownList_DataBinding">
                                                                                    </telerik:RadComboBox>
                                                                                    <asp:ObjectDataSource ID="ds_kod" runat="server" SelectMethod="DbSelect2" TypeName="KSProgram.Ciselniky.CisDchKody">
                                                                                        <SelectParameters>
                                                                                            <asp:Parameter DbType="Decimal"  Name="os_cislo" DefaultValue="0"/>
                                                                                         </SelectParameters>
                                                                                    </asp:ObjectDataSource>--%>
                                                                                                <%-- OnItemsRequested="radDropDownList_ItemsRequested"--%>
                                                                                                <telerik:RadComboBox runat="server" ID="radDropDownList" CssClass="povinne-pole" OnClientItemsRequesting="OnClientItemsRequesting"
                                                                                                    AutoPostBack="true" Width="186px" DropDownCssClass="povinne-pole" EnableLoadOnDemand="True"
                                                                                                    ShowMoreResultsBox="true" MarkFirstMatch="true" DataTextField="cely_nazev" DataValueField="kod" DropDownHeight="50px"
                                                                                                    OnSelectedIndexChanged="ddl_kod_SelectedIndexChanged"
                                                                                                    ValidationGroup="edit" BackColor="#ffffcc" ForeColor="black"
                                                                                                    EnableVirtualScrolling="false" SelectedValue='<%# Bind("vyr_kod") %>'>
                                                                                                    <WebServiceSettings Method="GetKodyDochazka2" Path="../PrivateWebServices/AutoCompleteService.asmx" />
                                                                                                </telerik:RadComboBox>
                                                                                                <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="radDropDownList"
                                                                                                    ValidationGroup="edit" ErrorMessage="RequiredFieldValidator"></asp:RequiredFieldValidator>
                                                                                                <br />
                                                                                                <asp:CustomValidator runat="server" ID="cv_kod" ControlToValidate="radDropDownList"
                                                                                                    OnServerValidate="cv_kod_ServerValidate" ErrorMessage="[%Neplatný kód%]"></asp:CustomValidator>
                                                                                            </asp:TableCell>
                                                                                        </asp:TableRow>
                                                                                        <%-- <asp:TableRow runat="server" ID="TableRow5">
                                                                                <asp:TableCell runat="server" ID="tablecell8" SkinID="DataFieldHeaderStyle">
                                                                                    <asp:Label ID="Label5" runat="server" Text="Sazba"></asp:Label>
                                                                                </asp:TableCell>
                                                                                <asp:TableCell runat="server" ID="tablecell9" ColumnSpan="7" SkinID="DataFieldStyle">
                                                                                    <asp:TextBox runat="server" ID="tx_sazba" Text='<%# Bind("sazba") %>'></asp:TextBox>
                                                                                </asp:TableCell>
                                                                            </asp:TableRow>--%>
                                                                                        <asp:TableRow runat="server" ID="TableRow6">
                                                                                            <asp:TableCell runat="server" ID="tablecell10" SkinID="DataFieldHeaderStyle">
                                                                                                <asp:Label ID="Label2" runat="server" Text="[%Částka%]"></asp:Label>
                                                                                            </asp:TableCell>
                                                                                            <asp:TableCell runat="server" ID="tablecell23" ColumnSpan="7" SkinID="DataFieldStyle">
                                                                                                <%--<asp:TextBox runat="server" ID="tx_castka" Text='<%# Bind("castka") %>' Width="182"></asp:TextBox>
                                                                                    <kspwc:NumericValidator runat="server" ID="val_castka" ControlToValidate="tx_castka" ></kspwc:NumericValidator>--%>
                                                                                                <telerik:RadNumericTextBox runat="server" ID="tx_castka" Text='<%# Bind("castka") %>' Width="187" MaxValue="214748364" MinValue="-2147483648"></telerik:RadNumericTextBox>
                                                                                            </asp:TableCell>
                                                                                        </asp:TableRow>
                                                                                        <asp:TableRow runat="server" ID="TableRow7">
                                                                                            <asp:TableCell runat="server" ID="tablecell11" SkinID="DataFieldHeaderStyle">
                                                                                                <asp:Label ID="Label6" runat="server" Text="[%Čas od - do%]"></asp:Label>
                                                                                            </asp:TableCell>
                                                                                            <asp:TableCell runat="server" ID="tablecell22" SkinID="DataFieldStyle">
                                                                                                <asp:TextBox runat="server" ID="tx_hod_od" Width="30px" Text='<%# Bind("hod_od") %>'></asp:TextBox>
                                                                                                <%--<telerik:RadNumericTextBox runat="server" ID="tx_hod_od" Width="30px" Text='<%# Bind("hod_od") %>' MaxValue="2147483647"></telerik:RadNumericTextBox>--%>
                                                                                                <asp:CustomValidator ID="CustomValidator3" runat="server" ErrorMessage="*" ControlToValidate="tx_hod_od" OnServerValidate="ValHod"></asp:CustomValidator>
                                                                                            </asp:TableCell>
                                                                                            <asp:TableCell runat="server" ID="tablecell12" SkinID="DataFieldStyle">
                                                                                                <asp:Label runat="server" ID="label7" Text=":"></asp:Label>
                                                                                            </asp:TableCell>
                                                                                            <asp:TableCell runat="server" ID="tablecell13" SkinID="DataFieldStyle">
                                                                                                <asp:TextBox runat="server" ID="tx_min_od" Width="30px" Text='<%# Bind("min_od") %>'></asp:TextBox>
                                                                                                <asp:CustomValidator ID="CustomValidator1" runat="server" ErrorMessage="*" ControlToValidate="tx_min_od" OnServerValidate="ValMin"></asp:CustomValidator>
                                                                                            </asp:TableCell>
                                                                                            <asp:TableCell runat="server" ID="tablecell14" SkinID="DataFieldStyle">
                                                                                                <asp:Label ID="Label10" runat="server" Text="-"></asp:Label>
                                                                                            </asp:TableCell>
                                                                                            <asp:TableCell runat="server" ID="tablecell15" SkinID="DataFieldStyle">
                                                                                                <asp:TextBox runat="server" ID="tx_hod_do" Width="30px" Text='<%# Bind("hod_do") %>'></asp:TextBox>
                                                                                                <asp:CustomValidator ID="CustomValidator4" runat="server" ErrorMessage="*" ControlToValidate="tx_hod_do" OnServerValidate="ValHod"></asp:CustomValidator>
                                                                                            </asp:TableCell>
                                                                                            <asp:TableCell runat="server" ID="tablecell16" SkinID="DataFieldStyle">
                                                                                                <asp:Label runat="server" ID="label9" Text=":"></asp:Label>
                                                                                            </asp:TableCell>
                                                                                            <asp:TableCell runat="server" ID="tablecell17" SkinID="DataFieldStyle">
                                                                                                <asp:TextBox runat="server" ID="tx_min_do" Width="30px" Text='<%# Bind("min_do") %>'></asp:TextBox>
                                                                                                <asp:CustomValidator ID="CustomValidator2" runat="server" ErrorMessage="*" ControlToValidate="tx_min_do" OnServerValidate="ValMin"></asp:CustomValidator>
                                                                                            </asp:TableCell>
                                                                                        </asp:TableRow>
                                                                                        <asp:TableRow runat="server" ID="TableRow8">
                                                                                            <asp:TableCell runat="server" ID="tablecell18" SkinID="DataFieldHeaderStyle">
                                                                                                <asp:Label ID="Label8" runat="server" Text="[%Doba%]"></asp:Label>
                                                                                            </asp:TableCell>
                                                                                            <asp:TableCell runat="server" ID="tablecell19" SkinID="DataFieldStyle">
                                                                                                <asp:TextBox runat="server" ID="tx_hod_doba" Width="30px" Text='<%# Bind("doba_hod") %>' OnTextChanged="tx_hod_doba_TextChanged"></asp:TextBox>
                                                                                                <asp:CustomValidator ID="cv_hod_doba" runat="server" ErrorMessage="*" ControlToValidate="tx_hod_doba" OnServerValidate="ValHodDoba"></asp:CustomValidator>
                                                                                            </asp:TableCell>
                                                                                            <asp:TableCell runat="server" ID="tablecell20" SkinID="DataFieldStyle">
                                                                                                <asp:Label runat="server" ID="label11" Text=":"></asp:Label>
                                                                                            </asp:TableCell>
                                                                                            <asp:TableCell runat="server" ID="tablecell21" ColumnSpan="5" SkinID="DataFieldStyle">
                                                                                                <asp:TextBox runat="server" ID="tx_min_doba" Width="30px" Text='<%# Bind("doba_min") %>' OnTextChanged="tx_min_doba_TextChanged"></asp:TextBox>
                                                                                                <asp:CustomValidator ID="cv_min_doba" runat="server" ErrorMessage="*" ControlToValidate="tx_min_doba" OnServerValidate="ValMin"></asp:CustomValidator>
                                                                                            </asp:TableCell>
                                                                                        </asp:TableRow>
                                                                                    </asp:Table>
                                                                                </asp:TableCell>
                                                                            </asp:TableRow>
                                                                        </asp:Table>
                                                                    </asp:TableCell>
                                                                </asp:TableRow>
                                                                <asp:TableHeaderRow runat="server" ID="rowulozit">
                                                                    <asp:TableCell runat="server" ID="tablecell24" ColumnSpan="8">
                                                                        <div style="padding: 5px;">
                                                                            <wc:TLinkButton runat="server" ID="lb_ulozit" Text="[%Uložit%]" SkinID="button" OnCommand="lb_ulozit_Command"
                                                                                onfocus="Change(this, event)" onblur="Change(this, event)"></wc:TLinkButton>
                                                                        </div>
                                                                    </asp:TableCell>
                                                                </asp:TableHeaderRow>
                                                            </asp:Table>
                                                        </asp:Panel>
                                                    </InsertItemTemplate>
                                                </asp:FormView>
                                            </td>
                                            <td style="vertical-align: top; padding-left: 20px;">
                                                <table>
                                                    <tr>
                                                        <td>
                                                            <asp:Label runat="server" ID="popisek1" Text="[%Ovládání je pomocí kláves%]" ></asp:Label>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <asp:Label runat="server" ID="Label22" Text="[%„Tab“ - přesun mezi položkami%]" ></asp:Label>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <asp:Label runat="server" ID="Label23" Text="[%„Enter“ - uložení záznamu%]" ></asp:Label>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                    <asp:Label ID="lab_oznameni" runat="server" EnableViewState="False" ForeColor="Red"></asp:Label>
                                    <asp:ObjectDataSource ID="ds_FormPoriz" runat="server" InsertMethod="Insert" OldValuesParameterFormatString="original_{0}"
                                        SelectMethod="Dummy" TypeName="KSProgram.Dochazka.DenniPoriz"
                                        OnInserting="ds_FormPoriz_Inserting">
                                        <InsertParameters>
                                            <asp:Parameter Name="den" Type="DateTime" />
                                            <asp:Parameter Name="davka" Type="String" />
                                            <asp:Parameter Name="os_cislo" Type="Decimal" />
                                            <asp:Parameter Name="stred" Type="String" />
                                            <asp:Parameter Name="kod" Type="Int32" />
                                            <asp:Parameter Name="sazba" Type="Decimal" />
                                            <asp:Parameter Name="castka" Type="Decimal" />
                                            <asp:Parameter Name="hod_od" Type="Int32" />
                                            <asp:Parameter Name="min_od" Type="Int32" />
                                            <asp:Parameter Name="hod_do" Type="Int32" />
                                            <asp:Parameter Name="min_do" Type="Int32" />
                                            <asp:Parameter Name="doba_hod" Type="Int32" />
                                            <asp:Parameter Name="doba_min" Type="Int32" />
                                        </InsertParameters>
                                    </asp:ObjectDataSource>
                                    <wc:TLinkButton runat="server" ID="lb_ulozit2" Text="[%Uložit%]" SkinID="button" OnCommand="lb_ulozit_Command" CssClass="hidden"></wc:TLinkButton>
                                </asp:Panel>
                            </asp:View>
                            <asp:View runat="server" ID="v_prehled" OnPreRender="v_prehled_PreRender">
                                <table style="border-collapse: collapse;">
                                    <tr>
                                        <td>
                                            <table style="border-collapse: collapse;">
                                                <tr style="vertical-align: middle;">
                                                    <td style="vertical-align: top; padding-top: 10px;">
                                                        <asp:Label ID="Label101" runat="server" Text="[%Datum od%]:"></asp:Label>
                                                    </td>
                                                    <td style="vertical-align: top; white-space: nowrap;">
                                                        <wc:TRadDatePicker runat="server" ID="dat_od" Validace="true" ValidatorMessage="*"></wc:TRadDatePicker>
                                                    </td>
                                                    <td style="vertical-align: top; padding-top: 10px; padding-left: 4px;">
                                                        <asp:Label ID="Label15" runat="server" Text="[%Dávka%]:" ></asp:Label>
                                                    </td>
                                                    <td style="vertical-align: top;">
                                                        <%--<asp:TextBox runat="server" ID="tx_davka" Width="100"></asp:TextBox>--%>
                                                        <telerik:RadTextBox runat="server" ID="rtx_davka" Width="100px" ClientEvents-OnKeyPress="OnKeyPressOsCisla" ToolTip="[%Čísla oddělena čárkou%]"></telerik:RadTextBox>
                                                    </td>
                                                    <%--
                                             <td style="vertical-align: top;padding-top:10px;padding-left:4px;">
                                               --------------
                                            </td>
                                            <td style="vertical-align: top;">

                                                <asp:DropDownList ID="ddl_kod" runat="server" DataTextField="kod_nazev" DataValueField="kod" DataSourceID="dsDdlKody" >
                                                </asp:DropDownList> 
                                                   <asp:ObjectDataSource runat="server" ID="dsDdlKody" TypeName="KSProgram.Ciselniky.CisDchKody" SelectMethod="KodZkratkaNazev" ></asp:ObjectDataSource>
                                                ---------------                               
                                            </td>  --%>
                                                    <td rowspan="2" style="vertical-align: top; padding-left: 4px;">
                                                        <wc:StrSkupDiv ID="StrSkupDiv1" runat="server"></wc:StrSkupDiv>
                                                    </td>
                                                    <%--<td style="vertical-align: top; padding-left:6px;">
                                                <wc:TLinkButton runat="server" ID="lb_vytvorit" Text="[%Načíst%]" SkinID="button" OnCommand="lb_vytvorit_Command" />
                                            </td>--%>
                                                </tr>
                                                <tr>
                                                    <td style="vertical-align: top;">
                                                        <asp:Label ID="Label14" runat="server" Text="[%Datum do%]:" ></asp:Label>
                                                    </td>
                                                    <td style="vertical-align: top; white-space: nowrap;">
                                                        <wc:TRadDatePicker runat="server" ID="dat_do" Validace="true" ValidatorMessage="*"></wc:TRadDatePicker>
                                                    </td>
                                                    <%--  <td>
                                                <asp:CustomValidator runat="server" ID="val_do" OnServerValidate="validace_dat_do" 
                                                    ErrorMessage="*" ControlToValidate="dat_do" />
                                            </td>--%>
                                                    <td style="vertical-align: top; padding-left: 4px;">
                                                        <asp:Label ID="Label20" runat="server" Text="[%Os. čísla%]:" ></asp:Label>
                                                    </td>
                                                    <td style="vertical-align: top;">
                                                        <%--<asp:TextBox runat="server" ID="tx_os_cisla" Width="100"></asp:TextBox>--%>
                                                        <telerik:RadTextBox runat="server" ID="rtx_os_cisla" Width="100px" ClientEvents-OnKeyPress="OnKeyPressOsCisla" ToolTip="[%Čísla oddělena čárkou%]"></telerik:RadTextBox>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <asp:Label ID="Label21" runat="server" Text="[%Kód%]:" ></asp:Label>
                                                    </td>
                                                    <td colspan="3">
                                                        <cc1:DdlDochazkoveKody ID="ddl_kod" runat="server"></cc1:DdlDochazkoveKody>
                                                    </td>
                                                    <td style="text-align: right;">
                                                        <kspwc:TRadButton runat="server" ID="trb_vytvorit" Text="[%Načíst%]" OnClick="trb_vytvorit_Click"></kspwc:TRadButton>
                                                    </td>

                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <wc:TGridView runat="server" ID="gv_prehled" DataSourceID="ds_prehled" OnRowDataBound="gv_prehled_RowDataBound"
                                                DataKeyNames="id,os_cislo,cislo_pom,den" OnRowDeleting="gv_prehled_RowDeleting"
                                                OnRowUpdating="gv_prehled_RowUpdating" AllowMultiColumnSorting="True" OnRowEditing="gv_prehled_RowEditing"
                                                PovolExport="True" ShowTitleRow="True" TitleText="[%Sumární přehled%]"
                                                ShowFooter="True" OnRowCreated="gv_prehled_RowCreated">
                                                <Columns>

                                                    <asp:BoundField DataField="id" HeaderText="Id" SortExpression="id" ReadOnly="True" />
                                                    <asp:TemplateField HeaderText="[%Datum%]" SortExpression="den">
                                                        <EditItemTemplate>
                                                            <asp:Label ID="Label5x" runat="server" Text='<%# Bind("den", "{0:d}") %>'></asp:Label>
                                                        </EditItemTemplate>
                                                        <ItemTemplate>
                                                            <asp:Label ID="Label5y" runat="server" Text='<%# Bind("den", "{0:d}") %>'></asp:Label>
                                                        </ItemTemplate>
                                                    </asp:TemplateField>
                                                    <asp:TemplateField HeaderText="[%Os. číslo%]" SortExpression="os_cislo">
                                                        <EditItemTemplate>
                                                            <asp:Label ID="Label19" runat="server" Text='<%# Bind("os_cislo") %>'></asp:Label>
                                                        </EditItemTemplate>
                                                        <ItemTemplate>
                                                            <asp:Label ID="Label17" runat="server" Text='<%# Bind("os_cislo") %>'></asp:Label>
                                                        </ItemTemplate>
                                                    </asp:TemplateField>
                                                    <asp:TemplateField HeaderText="[%Jméno%]" SortExpression="jmeno">
                                                        <EditItemTemplate>
                                                            <asp:Label ID="Label16" runat="server" Text='<%# Bind("jmeno") %>'></asp:Label>
                                                        </EditItemTemplate>
                                                        <ItemTemplate>
                                                            <asp:Label ID="Label6" runat="server" Text='<%# Bind("jmeno") %>'></asp:Label>
                                                        </ItemTemplate>
                                                    </asp:TemplateField>
                                                    <asp:TemplateField HeaderText="[%Středisko%]" SortExpression="prac_str">
                                                        <EditItemTemplate>
                                                            <asp:TextBox ID="tx_stred_edit" runat="server" Text='<%# Bind("prac_str") %>' Width="70px" MaxLength="10"></asp:TextBox>
                                                            <ajax:AutoCompleteExtender ID="AutoCompleteExtender1" runat="server" CompletionInterval="500"
                                                                CompletionListElementID="div_stred" FirstRowSelected="True" MinimumPrefixLength="1"
                                                                OnClientPopulated="onPopulated" ServiceMethod="Stredisko" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                                                TargetControlID="tx_stred_edit" UseContextKey="True">
                                                            </ajax:AutoCompleteExtender>
                                                            <div id="div_stred" runat="server">
                                                            </div>
                                                            <kspwc:TextValidator runat="server" ID="id_val_stred" ControlToValidate="tx_stred_edit"></kspwc:TextValidator>
                                                        </EditItemTemplate>
                                                        <ItemTemplate>
                                                            <asp:Label ID="Label8" runat="server" Text='<%# Bind("prac_str") %>'></asp:Label>
                                                        </ItemTemplate>
                                                    </asp:TemplateField>
                                                    <asp:BoundField DataField="kmen_str" HeaderText="[%Kmen. stř.%]" SortExpression="kmen_str"
                                                        ReadOnly="True" />
                                                    <asp:TemplateField HeaderText="[%Dávka%]" SortExpression="c_pole1">
                                                        <EditItemTemplate>
                                                            <asp:TextBox ID="c_pole1" runat="server" MaxLength="12" Text='<%# Bind("c_pole1") %>'
                                                                Width="70px"></asp:TextBox>
                                                            <kspwc:TextValidator runat="server" ID="id_val_c_pole1" ControlToValidate="c_pole1"></kspwc:TextValidator>
                                                        </EditItemTemplate>
                                                        <ItemTemplate>
                                                            <asp:Label ID="Label18" runat="server" Text='<%# Bind("c_pole1") %>'></asp:Label>
                                                        </ItemTemplate>
                                                        <FooterStyle HorizontalAlign="Center" />
                                                        <ItemStyle HorizontalAlign="Right" />
                                                    </asp:TemplateField>
                                                    <asp:TemplateField HeaderText="[%Kód%]" SortExpression="kod">
                                                        <EditItemTemplate>
                                                            <asp:DropDownList ID="ddl_kod_prehled" runat="server" AutoPostBack="True" DataSourceID="ds_kod_prehled"
                                                                DataTextField="vyr_kod" DataValueField="vyr_kod" OnSelectedIndexChanged="ddl_kod_prehled_SelectedIndexChanged"
                                                                SelectedValue='<%# Bind("kod") %>'>
                                                            </asp:DropDownList>
                                                            <asp:ObjectDataSource ID="ds_kod_prehled" runat="server" SelectMethod="DbSelect"
                                                                TypeName="KSProgram.Ciselniky.CisDchKody">
                                                                <SelectParameters>
                                                                    <asp:Parameter DbType="String" Name="sender" DefaultValue="D" />
                                                                    <asp:SessionParameter DbType="Decimal" Name="os_cislo" SessionField="denni_poriz_vybr_os_cislo" />
                                                                    <asp:SessionParameter DbType="Int16" Name="cislo_pom" SessionField="denni_poriz_vybr_cislo_pom" />
                                                                    <%-- <asp:ControlParameter ControlID="gv_prehled" PropertyName="dat"--%>
                                                                    <%--<asp:ControlParameter ControlID="gv_prehled" Name="os_cislo" PropertyName="SelectedDataKey[1]" Type="Int16" />--%>
                                                                </SelectParameters>
                                                            </asp:ObjectDataSource>
                                                        </EditItemTemplate>
                                                        <ItemTemplate>
                                                            <asp:Label ID="Label9" runat="server" Text='<%# Bind("kod") %>'></asp:Label>
                                                        </ItemTemplate>
                                                    </asp:TemplateField>
                                                    <asp:TemplateField HeaderText="[%Částka%]" SortExpression="castka">
                                                        <EditItemTemplate>
                                                            <asp:TextBox ID="TextBox2" runat="server" Text='<%# Bind("castka") %>' Width="80px"></asp:TextBox>
                                                            <kspwc:NumericValidatorWithDecimal runat="server" ID="val_castka" ControlToValidate="TextBox2"></kspwc:NumericValidatorWithDecimal>
                                                        </EditItemTemplate>
                                                        <ItemTemplate>
                                                            <asp:Label ID="Label4" runat="server" Text='<%# Bind("castka") %>'></asp:Label>
                                                        </ItemTemplate>
                                                        <FooterStyle HorizontalAlign="Right" />
                                                        <HeaderStyle HorizontalAlign="Right" />
                                                        <ItemStyle HorizontalAlign="Right" />
                                                    </asp:TemplateField>
                                                    <asp:TemplateField HeaderText="[%Čas od%]" SortExpression="cas_od">
                                                        <EditItemTemplate>
                                                            <asp:TextBox runat="server" ID="hod_od" Text='<%# Bind("hod_od") %>' Width="20"></asp:TextBox>
                                                            <asp:CustomValidator ID="cv_hod_od" runat="server" ErrorMessage="*" ControlToValidate="hod_od" OnServerValidate="ValHod"></asp:CustomValidator>
                                                            <asp:Label runat="server" ID="lab_min_od" Text=":"></asp:Label>
                                                            <asp:TextBox runat="server" ID="min_od" Text='<%# Bind("min_od") %>' Width="20"></asp:TextBox>
                                                            <asp:CustomValidator ID="cv_min_od" runat="server" ErrorMessage="*" ControlToValidate="min_od" OnServerValidate="ValMin"></asp:CustomValidator>
                                                        </EditItemTemplate>
                                                        <ItemTemplate>
                                                            <asp:Label ID="Label1x" runat="server" Text='<%# VyplnCas(Container.DataItem,"cas_od") %>'></asp:Label>
                                                        </ItemTemplate>
                                                    </asp:TemplateField>
                                                    <asp:TemplateField HeaderText="[%Čas do%]" SortExpression="cas_do">
                                                        <EditItemTemplate>
                                                            <asp:TextBox runat="server" ID="hod_do" Text='<%# Bind("hod_do") %>' Width="20"></asp:TextBox>
                                                            <asp:CustomValidator ID="cv_hod_do" runat="server" ErrorMessage="*" ControlToValidate="hod_do" OnServerValidate="ValHod"></asp:CustomValidator>
                                                            <asp:Label runat="server" ID="lab_min_do" Text=":"></asp:Label>
                                                            <asp:TextBox runat="server" ID="min_do" Text='<%# Bind("min_do") %>' Width="20"></asp:TextBox>
                                                            <asp:CustomValidator ID="cv_min_do" runat="server" ErrorMessage="*" ControlToValidate="min_do" OnServerValidate="ValMin"></asp:CustomValidator>
                                                        </EditItemTemplate>
                                                        <ItemTemplate>
                                                            <asp:Label ID="Label2x" runat="server" Text='<%# VyplnCas(Container.DataItem,"cas_do") %>'></asp:Label>
                                                        </ItemTemplate>
                                                    </asp:TemplateField>
                                                    <asp:TemplateField HeaderText="[%Doba%]" SortExpression="doba">
                                                        <EditItemTemplate>
                                                            <div style="white-space: nowrap;">
                                                                <asp:TextBox runat="server" ID="hod_doba" Text='<%# Bind("hod_doba") %>' Width="20"></asp:TextBox>
                                                                <asp:CustomValidator ID="cv_hod_doba" runat="server" ErrorMessage="*" ControlToValidate="hod_doba" OnServerValidate="ValHodDoba"></asp:CustomValidator>
                                                                <asp:Label runat="server" ID="Label2" Text=":"></asp:Label>
                                                                <asp:TextBox runat="server" ID="min_doba" Text='<%# Bind("min_doba") %>' Width="20"></asp:TextBox>
                                                                <asp:CustomValidator ID="cv_min_doba" runat="server" ErrorMessage="*" ControlToValidate="min_doba" OnServerValidate="ValMin"></asp:CustomValidator>
                                                            </div>
                                                        </EditItemTemplate>
                                                        <ItemTemplate>
                                                            <asp:Label runat="server" ID="item_doba" Text='<%# KSProgram.Funkce.Cas_na_min.GetCasString(DataBinder.Eval(Container.DataItem, "doba")) %>'></asp:Label>
                                                        </ItemTemplate>
                                                        <FooterStyle HorizontalAlign="Right" />
                                                        <HeaderStyle HorizontalAlign="Right" />
                                                        <ItemStyle HorizontalAlign="Right" />
                                                    </asp:TemplateField>
                                                    <asp:CommandField ButtonType="Image" DeleteImageUrl="~/Images/DeleteHS.png" EditImageUrl="~/Images/EditInformationHS.png"
                                                        ShowDeleteButton="True" ShowEditButton="True" CancelImageUrl="~/Images/Edit_UndoHS.png"
                                                        UpdateImageUrl="~/Images/saveHS.png" />
                                                </Columns>
                                            </wc:TGridView>
                                            <asp:ObjectDataSource ID="ds_prehled" runat="server" OldValuesParameterFormatString="original_{0}"
                                                SelectMethod="NacistDen" TypeName="KSProgram.Dochazka.PorizeniDen" DeleteMethod="DeleteZaznam"
                                                UpdateMethod="UpdateDen">
                                                <DeleteParameters>
                                                    <asp:Parameter Name="os_cislo" Type="Decimal" />
                                                    <asp:Parameter Name="cislo_pom" Type="Int16" />
                                                    <asp:Parameter Name="den" Type="DateTime" />
                                                    <asp:Parameter Name="id" Type="String" />
                                                    <asp:Parameter Name="original_id" Type="String" />
                                                </DeleteParameters>
                                                <SelectParameters>
                                                    <asp:Parameter Name="os_cislo" Type="Decimal" />
                                                    <asp:Parameter Name="cislo_pom" Type="Int16" />
                                                    <asp:Parameter Name="den_od" Type="DateTime" />
                                                    <asp:Parameter Name="den_do" Type="DateTime" />
                                                    <asp:Parameter Name="c_pole1" Type="String" />
                                                    <asp:Parameter Name="vcetneJmena" Type="Boolean" DefaultValue="true" />
                                                    <asp:Parameter Name="podminka" Type="String" />
                                                </SelectParameters>
                                                <UpdateParameters>
                                                    <asp:Parameter Name="os_cislo" Type="Decimal" />
                                                    <asp:Parameter Name="cislo_pom" Type="Int16" />
                                                    <asp:Parameter Name="den" Type="DateTime" />
                                                    <asp:Parameter Name="kod" Type="Int32" />
                                                    <asp:Parameter Name="hod_od" Type="Int32" />
                                                    <asp:Parameter Name="min_od" Type="Int32" />
                                                    <asp:Parameter Name="hod_do" Type="Int32" />
                                                    <asp:Parameter Name="min_do" Type="Int32" />
                                                    <asp:Parameter Name="hod_doba" Type="Int32" />
                                                    <asp:Parameter Name="min_doba" Type="Int32" />
                                                    <asp:Parameter Name="prac_str" Type="String" />
                                                    <asp:Parameter Name="c_pole1" Type="String" />
                                                    <asp:Parameter Name="sazba" Type="Decimal" />
                                                    <asp:Parameter Name="castka" Type="Decimal" />
                                                    <asp:Parameter Name="id" Type="String" />
                                                    <asp:Parameter Name="original_id" Type="String" />
                                                </UpdateParameters>
                                            </asp:ObjectDataSource>
                                        </td>
                                    </tr>
                                </table>
                            </asp:View>
                        </asp:MultiView>
                    </asp:Panel>
                </td>
            </tr>
        </table>
    </div>
</asp:Content>
