﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="UC_SumVacations.ascx.cs" Inherits="KSPortal.Dochazka.UC_SumVacations" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<style type="text/css">
    .RadWindow.ksRWSumar {
        <%=Enabled ? "z-index: 9 !important;" : ""%>
    }

        .RadWindow.ksRWSumar .rwContent {
            padding: 0px;
        }

    div.ksId_TRG_SumVac {
        border: none !important;
    }
</style>
<script type="text/javascript">
    (function () {
        KSMaster.SumarDovoleneWindow = {};
        setTimeout(function () {
            KSMaster.SumarDovoleneWindow.Window = $find('<%=RW_Sumar.ClientID%>');
            KSMaster.SumarDovoleneWindow.Grid = $find('<%=TRG_SumVac.ClientID%>');
        }, 500);

        KSMaster.SumarDovoleneWindow.Rebind = function () {
            $.ajax({
                type: "POST",
                url: KSMaster.baseUrl + "/Zamestnanec/ZamKalendar.aspx/GetSumarVolen",
                //data: "{jsonSeznam: '" + JSON.stringify(os_cisla) + "'}",
                async: true,
                contentType: "application/json",
                dataType: "json",
                failure: function (response) {
                    KSMaster.showError(response.responseText, response.statusText);
                },
                error: function (response) {
                    KSMaster.showError(response.responseText, response.statusText);
                },
                success: function (data) {
                    ret = data.d;
                    if (KSMaster.SumarDovoleneWindow && KSMaster.SumarDovoleneWindow.Grid) {
                        var tableView = KSMaster.SumarDovoleneWindow.Grid.get_masterTableView();
                        tableView.set_dataSource(ret.rows);
                        tableView.dataBind();
                    }
                }
            });
        };
    }());

</script>
<telerik:RadAjaxManagerProxy ID="RAMP_SumVac" runat="server">
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="B_sel_oc">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="TRG_SumVac" />
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>
<telerik:RadWindow ID="RW_Sumar" runat="server" VisibleOnPageLoad="true" CssClass="ksRWSumar" Title="[%Zůstatky volna%]"
    AutoSize="true" Behaviors="Minimize,Move" InitialBehaviors="Minimize" AutoSizeBehaviors="Height,Width" KeepInScreenBounds="True"
    VisibleStatusbar="False" VisibleTitlebar="True"
    Left="450px" Top="148px">
    <ContentTemplate>
        <kspwc:TRadGrid runat="server" ID="TRG_SumVac" Width="500"
            OnNeedDataSource="TRG_SumVac_NeedDataSource"
            OnItemDataBound="TRG_SumVac_ItemDataBound"
            CaptionVisible="false" AutoGenerateColumns="false" CssClass="KsUnderlineGrid">
            <MasterTableView>
                <Columns>
                    <telerik:GridBoundColumn UniqueName="title" DataField="title" DataType="System.String"></telerik:GridBoundColumn>
                    <telerik:GridBoundColumn UniqueName="vacation" DataField="vacation_t" DataType="System.String">
                        <HeaderStyle HorizontalAlign="Right" />
                        <ItemStyle HorizontalAlign="Right" />
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn UniqueName="bv0" DataField="bv0_t" DataType="System.String">
                        <HeaderStyle HorizontalAlign="Right" />
                        <ItemStyle HorizontalAlign="Right" />
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn UniqueName="bv1" DataField="bv1_t" DataType="System.String">
                        <HeaderStyle HorizontalAlign="Right" />
                        <ItemStyle HorizontalAlign="Right" />
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn UniqueName="bv2" DataField="bv2_t" DataType="System.String">
                        <HeaderStyle HorizontalAlign="Right" />
                        <ItemStyle HorizontalAlign="Right" />
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn UniqueName="bv3" DataField="bv3_t" DataType="System.String">
                        <HeaderStyle HorizontalAlign="Right" />
                        <ItemStyle HorizontalAlign="Right" />
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn UniqueName="bv4" DataField="bv4_t" DataType="System.String">
                        <HeaderStyle HorizontalAlign="Right" />
                        <ItemStyle HorizontalAlign="Right" />
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn UniqueName="bv5" DataField="bv5_t" DataType="System.String">
                        <HeaderStyle HorizontalAlign="Right" />
                        <ItemStyle HorizontalAlign="Right" />
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn UniqueName="bv6" DataField="bv6_t" DataType="System.String">
                        <HeaderStyle HorizontalAlign="Right" />
                        <ItemStyle HorizontalAlign="Right" />
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn UniqueName="bv7" DataField="bv7_t" DataType="System.String">
                        <HeaderStyle HorizontalAlign="Right" />
                        <ItemStyle HorizontalAlign="Right" />
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn UniqueName="bv8" DataField="bv8_t" DataType="System.String">
                        <HeaderStyle HorizontalAlign="Right" />
                        <ItemStyle HorizontalAlign="Right" />
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn UniqueName="bv9" DataField="bv9_t" DataType="System.String">
                        <HeaderStyle HorizontalAlign="Right" />
                        <ItemStyle HorizontalAlign="Right" />
                    </telerik:GridBoundColumn>
                </Columns>
            </MasterTableView>
        </kspwc:TRadGrid>
    </ContentTemplate>
</telerik:RadWindow>
