﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="Navigace.ascx.cs" Inherits="KSPortal.Controls.Navigace" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
 <style type="text/css">
        .gridInPanelbar {
            margin-right: 25px !important;
        }
    </style>
<telerik:RadAjaxManagerProxy runat="server" ID="RAMP_H_nav">
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="TRG_akce">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="TRG_akce" />
                <telerik:AjaxUpdatedControl ControlID="TRG_hlavicky" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="TRG_hlavicky">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="TRG_hlavicky" />
                <telerik:AjaxUpdatedControl ControlID="Img_photo" />
            </UpdatedControls>
        </telerik:AjaxSetting>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>
<telerik:RadPanelBar runat="server" ID="RPB_nav" AllowCollapseAllItems="true" ExpandMode="SingleExpandedItem" Width="100%" CssClass="ksprvek">
    <Items>
        <telerik:RadPanelItem Text="[%Výběr hodnocení%]" Expanded="true" Selected="true" Font-Size="14px">
            <ContentTemplate>
                <kspwc:TRadGrid runat="server" ID="TRG_akce" OnNeedDataSource="TRG_akce_NeedDataSource" AllowPaging="true" AllowSorting="true" CaptionVisible="false"
                    AutoGenerateColumns="false" AutoFilterWidth="true" 
                    OnDataBound="TRG_akce_DataBound" 
                    OnItemDataBound="TRG_akce_ItemDataBound" 
                    OnItemCommand="TRG_akce_ItemCommand" 
                    OnSelectedIndexChanged="TRG_akce_SelectedIndexChanged"
                    OnPreRender="TRG_akce_PreRender" >
                    <MasterTableView CommandItemDisplay="Top" DataKeyNames="id_akce,bcolor">
                        <PagerStyle AlwaysVisible="false" />
                        <CommandItemTemplate>
                            <kspwc:GridCommandItemControl runat="server" ID="GCIC_akce">
                                <RebindButton runat="server" Visible="false"></RebindButton>
                                <ExportButton runat="server" Visible="false"></ExportButton>
                                <FilterButton runat="server" Visible="false"></FilterButton>
                                <ContentTemplate>
                                    <div class="gridCommandButton">
                                        <kspwc:TRadButton runat="server" ID="TRB_zamknuto" ButtonType="StandardButton" ToggleType="CustomToggle" OnToggleStateChanged="TRB_zamknuto_ToggleStateChanged" OnPreRender="TRB_zamknuto_PreRender">
                                            <ToggleStates>
                                                <telerik:RadButtonToggleState Text="[%Aktivní hodnocení%]" Value="0" PrimaryIconCssClass="fi fi-edit-alt" />
                                                <telerik:RadButtonToggleState Text="[%Zamknutá hodnocení%]" Value="1" PrimaryIconCssClass="fi fi-lock" />
                                            </ToggleStates>
                                        </kspwc:TRadButton>
                                    </div>
                                </ContentTemplate>
                            </kspwc:GridCommandItemControl>
                        </CommandItemTemplate>
                        <Columns>
                            <telerik:GridButtonColumn CommandName="Select" ButtonType="ImageButton" ButtonCssClass="kstlacitko kstlacitkoImgSvg16" ImageUrl="~/Skins/ikony/uicons-regular-rounded/svg/fi-rr-angle-right.svg"></telerik:GridButtonColumn>
                            <telerik:GridNumericColumn UniqueName="cislo" DataField="cislo" DataType="System.Int32" HeaderText="[%Číslo%]"></telerik:GridNumericColumn>
                            <telerik:GridBoundColumn UniqueName="nazev_akce" DataField="nazev_akce" DataType="System.String" HeaderText="[%Hodnotící akce%]"></telerik:GridBoundColumn>
                            <telerik:GridBoundColumn UniqueName="nazev_typu" DataField="nazev_typu" DataType="System.String" HeaderText="[%Typ akce%]"></telerik:GridBoundColumn>
                            <telerik:GridDateTimeColumn UniqueName="obdobi_od" DataField="a_obdobi_od" DataType="System.DateTime" HeaderText="[%Období od%]" DataFormatString="{0:dd.MM.yyyy}"></telerik:GridDateTimeColumn>
                            <telerik:GridDateTimeColumn UniqueName="obdobi_do" DataField="a_obdobi_do" DataType="System.DateTime" HeaderText="[%Období do%]" DataFormatString="{0:dd.MM.yyyy}"></telerik:GridDateTimeColumn>
                            <telerik:GridDateTimeColumn UniqueName="termin_do" DataField="termin_do" DataType="System.DateTime" HeaderText="[%Termín do%]" DataFormatString="{0:dd.MM.yyyy}"></telerik:GridDateTimeColumn>
                            <telerik:GridButtonColumn UniqueName="odmeny" CommandName="odmeny" ButtonType="ImageButton" HeaderText="[%Odměny%]"
                                ButtonCssClass="kstlacitko kstlacitkoImgSvg16" ImageUrl="~/Skins/ikony/uicons-regular-rounded/svg/fi-rr-address-card.svg"
                                ConfirmText="[%Bude založen požadavek na přenos do mezd pro všechna hodnocení zaměstnanců v této akci, kde figurujete jako hodnotitel. Opravdu chcete takový požadavek založit?%]" 
                                ConfirmTitle="[%Založení požadavku%]"></telerik:GridButtonColumn>
                        </Columns>
                    </MasterTableView>
                </kspwc:TRadGrid>
                <kspwc:TRadGrid runat="server" ID="TRG_hlavicky" OnNeedDataSource="TRG_hlavicky_NeedDataSource" AllowPaging="true" AllowSorting="true" OnItemCreated="TRG_hlavicky_ItemCreated"
                    AutoGenerateColumns="false" AutoFilterWidth="true" 
                    OnItemCommand="TRG_hlavicky_ItemCommand" 
                    OnItemDataBound="TRG_hlavicky_ItemDataBound" 
                    OnDataBound="TRG_hlavicky_DataBound"
                    OnSelectedIndexChanged="TRG_hlavicky_SelectedIndexChanged" 
                    OnPreRender="TRG_hlavicky_PreRender" >
                    <MasterTableView CommandItemDisplay="Top" DataKeyNames="id,zamknuto,os_cislo,stav,zv_kom,zv_cil,zv_ncil,zv_slo,zv_mot,zv_sko,zv_roz,bcolor,stav_app" Caption="[%Výběr účastníků%]">
                        <CommandItemTemplate>
                            <kspwc:GridCommandItemControl runat="server" ID="GCIC_hlavicky">
                                <RebindButton runat="server" Visible="false"></RebindButton>
                                <PrimiPodrizeniButton runat="server" Visible="true"></PrimiPodrizeniButton>
                                <ContentTemplate>
                                    <div class="gridCommandButton">
                                        <kspwc:TRadButton runat="server" ID="TRB_zamknuto2" ButtonType="StandardButton" ToggleType="CustomToggle" OnToggleStateChanged="TRB_zamknuto_ToggleStateChanged" OnPreRender="TRB_zamknuto_PreRender">
                                            <ToggleStates>
                                                <telerik:RadButtonToggleState Text="[%Aktivní hodnocení%]" Value="0" PrimaryIconCssClass="fi fi-edit-alt" />
                                                <telerik:RadButtonToggleState Text="[%Zamknutá hodnocení%]" Value="1" PrimaryIconCssClass="fi fi-lock" />
                                            </ToggleStates>
                                        </kspwc:TRadButton>
                                    </div>
                                </ContentTemplate>
                            </kspwc:GridCommandItemControl>
                        </CommandItemTemplate>
                        <Columns>
                            <telerik:GridButtonColumn CommandName="Select" ButtonType="ImageButton" ButtonCssClass="kstlacitko kstlacitkoImgSvg16" ImageUrl="~/Skins/ikony/uicons-regular-rounded/svg/fi-rr-angle-right.svg"></telerik:GridButtonColumn>
                            <telerik:GridBoundColumn UniqueName="nazev_akce" DataField="nazev_akce" DataType="System.String" HeaderText="[%Hodnotící akce%]"></telerik:GridBoundColumn>
                            <kspwc:GridFotoZamColumn UniqueName="foto" DataOsCisloField="os_cislo"></kspwc:GridFotoZamColumn>
                            <telerik:GridNumericColumn UniqueName="os_cislo" DataField="os_cislo" DataType="System.Decimal" HeaderText="[%Os. číslo%]"></telerik:GridNumericColumn>
                            <telerik:GridBoundColumn UniqueName="jmeno" DataField="jmeno" DataType="System.String" HeaderText="[%Jméno účastníka%]"></telerik:GridBoundColumn>
                            <telerik:GridBoundColumn UniqueName="prac_str" DataField="prac_str" DataType="System.String" HeaderText="[%Středisko%]"></telerik:GridBoundColumn>
                            <telerik:GridNumericColumn UniqueName="cislo_pom" DataField="cislo_pom" DataType="System.int16" HeaderText="[%Č.p.%]"></telerik:GridNumericColumn>
                            <telerik:GridBoundColumn UniqueName="prac_misto" DataField="prac_misto" DataType="System.String" HeaderText="[%Prac. místo%]"></telerik:GridBoundColumn>
                            <telerik:GridBoundColumn UniqueName="stav_app_text" DataField="stav_app_text" DataType="System.String" HeaderText="[%Stav%]"></telerik:GridBoundColumn>
                            <telerik:GridDateTimeColumn UniqueName="obdobi_od" DataField="obdobi_od" DataType="System.DateTime" HeaderText="[%Období od%]" DataFormatString="{0:dd.MM.yyyy}"></telerik:GridDateTimeColumn>
                            <telerik:GridDateTimeColumn UniqueName="obdobi_do" DataField="obdobi_do" DataType="System.DateTime" HeaderText="[%Období do%]" DataFormatString="{0:dd.MM.yyyy}"></telerik:GridDateTimeColumn>
                            <telerik:GridBoundColumn UniqueName="hodnotil" DataField="hodnotil" DataType="System.String" HeaderText="[%Hodnotil%]"></telerik:GridBoundColumn>
                            <telerik:GridDateTimeColumn UniqueName="datum" DataField="datum" DataType="System.DateTime" HeaderText="[%Datum%]" DataFormatString="{0:dd.MM.yyyy}"></telerik:GridDateTimeColumn>
                        </Columns>
                    </MasterTableView>
                </kspwc:TRadGrid>
            </ContentTemplate>
        </telerik:RadPanelItem>
    </Items>
</telerik:RadPanelBar>
