﻿<%@ Page Title="Sestava hodnocení kompetencí" Language="C#" MasterPageFile="~/Main.Master"
    AutoEventWireup="true" Inherits="Sestavy_HodnoceniKompetence" Codebehind="HodnoceniKompetence.aspx.cs" %>

<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls.Ciselniky" TagPrefix="cc1" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content2" ContentPlaceHolderID="HeadContent" runat="server">
    <style type="text/css">

    </style>
</asp:Content>
<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRadGrid_sestava">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGrid_sestava" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <asp:Label ID="Label1" runat="server" Text="[%Hodnocení kompetencí%]" CssClass="nadpis1"></asp:Label>
    <div>
        <table style="border-collapse: collapse; border: 1px solid #808080;" class="ksprvek HodnoceniToolbar">
            <tr>
                <td style="border-bottom-style: solid; border-width: 1px; border-color: #808080">
                    <asp:Label ID="Label3" runat="server" Text="[%Hodnotící akce%]:"></asp:Label>
                </td>
                <td colspan="2" style="border-bottom-style: solid; border-width: 1px; border-color: #808080">
                    <asp:ObjectDataSource ID="ODS_akce" runat="server" OldValuesParameterFormatString="original_{0}"
                        SelectMethod="HodnoticiAkce" TypeName="KSProgram.Hodnoceni.Hodnoceni">
                        <SelectParameters>
                            <asp:Parameter Name="zamceno" DbType="Int16" />
                            <asp:Parameter Name="jen_primi" Type="Boolean" DefaultValue="false" />
                            <asp:Parameter Name="existujeOdkazDo" Type="String" DefaultValue="hz_hod_pol.idp;" />
                        </SelectParameters>
                    </asp:ObjectDataSource>
                    <wc:TDropDown ID="TDD_akce" runat="server" DataSourceID="ODS_akce" DataTextField="nazev"
                        DataValueField="id" OnDataBound="TDD_akce_DataBound" AutoPostBack="True">
                    </wc:TDropDown>
                </td>
                <td style="border-bottom-style: solid; border-width: 1px; border-color: #808080;
                    border-left-style: solid; border-right-style: solid;">
                    <asp:RadioButtonList ID="RBL_zamceno" runat="server" RepeatDirection="Horizontal"
                        AutoPostBack="True">
                        <asp:ListItem Selected="True" Value="2">[%Všechny%]</asp:ListItem>
                        <asp:ListItem Selected="False" Value="0">[%Neuzavřeno%]</asp:ListItem>
                        <asp:ListItem Selected="False" Value="1">[%Uzavřeno%]</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
                <td style="border-bottom-style: solid; border-width: 1px; border-color: #808080">
                    <asp:RadioButtonList ID="RBL_procenta" runat="server" RepeatDirection="Horizontal"
                        AutoPostBack="True">
                        <asp:ListItem Selected="False" Value="0">[%Body%]</asp:ListItem>
                        <asp:ListItem Selected="True" Value="1">[%Procenta%]</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td colspan="2" style="font-weight: bold">
                    [%Filtr zaměstnanců%]:
                </td>
                <td style="border-width: 1px; border-color: #808080; font-weight: bold; border-right-style: solid;
                    border-left-style: solid;">
                    [%Sčítat zaměstnance%]:
                </td>
                <td style="font-weight: bold">
                    [%Filtr kompetencí%]:
                </td>
                <td style="border-width: 1px; border-color: #808080; font-weight: bold; border-left-style: solid;">
                    [%Sčítat kompetence%]:
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label ID="L_divize" runat="server" Text="[%Divize%]:"></asp:Label><br />
                    <asp:ObjectDataSource ID="ODS_divize" runat="server" OldValuesParameterFormatString="original_{0}"
                        SelectMethod="cislDivize" TypeName="KSProgram.Sestavy.DefSestavy_HodnKompetence">
                        <SelectParameters>
                            <asp:ControlParameter ControlID="TDD_akce" Name="Id_ha" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="RBL_zamceno" Name="zamceno" PropertyName="SelectedValue"
                                Type="Int16" />
                        </SelectParameters>
                    </asp:ObjectDataSource>
                    <wc:TDropDown ID="TDD_divize" runat="server" DataSourceID="ODS_divize" DataTextField="naz_divize"
                        DataValueField="cis_divize" AutoPostBack="True">
                    </wc:TDropDown>
                </td>
                <td>
                    <asp:Label ID="L_stredisko" runat="server" Text="[%Středisko%]:"></asp:Label>
                    <br />
                    <asp:ObjectDataSource ID="ODS_Stredisko" runat="server" OldValuesParameterFormatString="original_{0}"
                        SelectMethod="cislStredisko" TypeName="KSProgram.Sestavy.DefSestavy_HodnKompetence">
                        <SelectParameters>
                            <asp:ControlParameter ControlID="TDD_akce" Name="Id_ha" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_divize" Name="cis_divize" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_skupinaStred" Name="skup_str" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="RBL_zamceno" Name="zamceno" PropertyName="SelectedValue"
                                Type="Int16" />
                        </SelectParameters>
                    </asp:ObjectDataSource>
                    <wc:TDropDown ID="TDD_stredisko" runat="server" DataSourceID="ODS_Stredisko" DataTextField="nazev"
                        DataValueField="str" AutoPostBack="True">
                    </wc:TDropDown>
                </td>
                <td rowspan="2" style="border-right-style: solid; border-left-style: solid; border-width: 1px;
                    border-color: #808080">
                    <asp:RadioButtonList ID="RBL_group_zam" runat="server" RepeatColumns="2" AutoPostBack="True">
                        <asp:ListItem Value="4">[%Za všechny%]</asp:ListItem>
                        <asp:ListItem Value="1">[%Po divizích%]</asp:ListItem>
                        <asp:ListItem Value="2">[%Po skupinách středisek%]</asp:ListItem>
                        <asp:ListItem Value="3">[%Po střediscích%]</asp:ListItem>
                        <asp:ListItem Selected="True" Value="0">[%Po zaměstnancích%]</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
                <td>
                    <asp:Label ID="L_stredisko0" runat="server" Text="[%Typ kompetencí%]:"></asp:Label><br />
                    <asp:ObjectDataSource ID="ODS_typyKompetenci" runat="server" OldValuesParameterFormatString="original_{0}"
                        SelectMethod="cislTypyKompetenci" TypeName="KSProgram.Sestavy.DefSestavy_HodnKompetence">
                        <SelectParameters>
                            <asp:ControlParameter ControlID="TDD_akce" Name="Id_ha" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_divize" Name="cis_divize" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_skupinaStred" Name="skup_str" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_stredisko" Name="str" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_zamestnanec" Name="os_cislo" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="RBL_zamceno" Name="zamceno" PropertyName="SelectedValue"
                                Type="Int16" />
                        </SelectParameters>
                    </asp:ObjectDataSource>
                    <wc:TDropDown ID="TDD_typyKompetenci" runat="server" AutoPostBack="True" DataSourceID="ODS_typyKompetenci"
                        DataTextField="nazev_typu" DataValueField="typ_kompetenci">
                    </wc:TDropDown>
                </td>
                <td rowspan="2" style="border-left-style: solid; border-width: 1px; border-color: #808080">
                    <asp:RadioButtonList ID="RBL_group_komp" runat="server" AutoPostBack="True">
                        <asp:ListItem Value="2">[%Za hodnocení%]</asp:ListItem>
                        <asp:ListItem Value="1">[%Po typech kompetencí%]</asp:ListItem>
                        <asp:ListItem Selected="True" Value="0">[%Po kompetencích%]</asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Label ID="L_skupinaStred" runat="server" Text="[%Skup. středisek%]:"></asp:Label><br />
                    <asp:ObjectDataSource ID="ODS_SkupinaStred" runat="server" OldValuesParameterFormatString="original_{0}"
                        SelectMethod="cislSkupinaStred" TypeName="KSProgram.Sestavy.DefSestavy_HodnKompetence">
                        <SelectParameters>
                            <asp:ControlParameter ControlID="TDD_akce" Name="Id_ha" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="RBL_zamceno" Name="zamceno" PropertyName="SelectedValue"
                                Type="Int16" />
                        </SelectParameters>
                    </asp:ObjectDataSource>
                    <wc:TDropDown ID="TDD_skupinaStred" runat="server" DataSourceID="ODS_SkupinaStred"
                        DataTextField="skup_nazev" DataValueField="skup_str" AutoPostBack="True">
                    </wc:TDropDown>
                </td>
                <td>
                    <asp:Label ID="L_zamestnanec" runat="server" Text="[%Zaměstnanec%]:"></asp:Label><br />
                    <asp:ObjectDataSource ID="ODS_Zamestnanec" runat="server" OldValuesParameterFormatString="original_{0}"
                        SelectMethod="cislZamestnanec" TypeName="KSProgram.Sestavy.DefSestavy_HodnKompetence">
                        <SelectParameters>
                            <asp:ControlParameter ControlID="TDD_akce" Name="Id_ha" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_divize" Name="cis_divize" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_skupinaStred" Name="skup_str" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_stredisko" Name="str" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="RBL_zamceno" Name="zamceno" PropertyName="SelectedValue"
                                Type="Int16" />
                        </SelectParameters>
                    </asp:ObjectDataSource>
                    <wc:TDropDown ID="TDD_zamestnanec" runat="server" DataSourceID="ODS_Zamestnanec"
                        DataTextField="jmeno" DataValueField="os_cislo" AutoPostBack="True">
                    </wc:TDropDown>
                </td>
                <td>
                    <asp:Label ID="L_stredisko1" runat="server" Text="[%Kompetence%]:"></asp:Label><br />
                    <asp:ObjectDataSource ID="ODS_kompetence" runat="server" OldValuesParameterFormatString="original_{0}"
                        SelectMethod="cislKompetence" TypeName="KSProgram.Sestavy.DefSestavy_HodnKompetence">
                        <SelectParameters>
                            <asp:ControlParameter ControlID="TDD_akce" Name="Id_ha" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_divize" Name="cis_divize" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_skupinaStred" Name="skup_str" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_stredisko" Name="str" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_zamestnanec" Name="os_cislo" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="TDD_typyKompetenci" Name="typ_kompetenci" PropertyName="SelectedValue"
                                Type="String" />
                            <asp:ControlParameter ControlID="RBL_zamceno" Name="zamceno" PropertyName="SelectedValue"
                                Type="Int16" />
                        </SelectParameters>
                    </asp:ObjectDataSource>
                    <wc:TDropDown ID="TDD_kompetence" runat="server" DataSourceID="ODS_kompetence" DataTextField="vyznam"
                        DataValueField="cislo" AutoPostBack="True">
                    </wc:TDropDown>
                </td>
            </tr>
            <tr>
                <td style="border-top-style: solid; border-width: 1px; border-color: #808080" colspan="5">
                    <asp:Label ID="Label4" runat="server" Text="[%Sloupce%]:"></asp:Label>
                    <wc:TCheckBoxList ID="CBL_show" runat="server" RepeatDirection="Horizontal" OnPreRender="CBL_show_PreRender"
                        UseSaveSetting="False">
                    </wc:TCheckBoxList>
                </td>
            </tr>
        </table>
        <br />
        <wc:TLinkButton runat="server" ID="lb_nacist" Text="[%Vytvořit%]" SkinID="button" OnCommand="lb_nacist_Command" CssClass="kstlacitko"></wc:TLinkButton>
        <br />
        <br />
        <asp:ObjectDataSource ID="ODS_sestava" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="Retrieve" TypeName="KSProgram.Sestavy.DefSestavy_HodnKompetence">
            <SelectParameters>
                <asp:Parameter Name="Id_ha" Type="String" />
                <asp:Parameter Name="cis_divize" Type="Int32" />
                <asp:Parameter Name="skup_str" Type="Int32" />
                <asp:Parameter Name="str" Type="String" />
                <asp:Parameter Name="os_cislo" Type="String" />
                <asp:Parameter Name="typ_kompetenci" Type="String" />
                <asp:Parameter Name="kompetence" Type="String" />
                <asp:Parameter Name="groupZam" Type="String" />
                <asp:Parameter Name="groupKom" Type="String" />
                <asp:Parameter Name="zamceno" Type="Int16" />
                <asp:Parameter Name="procenta" Type="Boolean" />
                <asp:Parameter Name="columns" Type="String" />
                <asp:Parameter Name="use_casch" Type="Boolean" DefaultValue="True" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <%--
        <wc:TGridView ID="TGV_sestava" runat="server" AllowMultiColumnSorting="True" PovolFiltraci="True"
            ShowTitleRow="True" TitleText="[%Hodnocení kompetencí%]" ControlPanelPosition="TitleRow"
            PovolExport="True" AllowPaging="true" >
            <Columns>
                <asp:BoundField DataField="os_cislo" HeaderText="[%Os. číslo%]" SortExpression="os_cislo" />
                <asp:BoundField DataField="jmeno" HeaderText="[%Jméno%]" SortExpression="jmeno" />
                <asp:BoundField DataField="prac_misto" HeaderText="[%Prac. místo%]" SortExpression="prac_misto" />
                <asp:BoundField DataField="divize" HeaderText="[%Divize%]" SortExpression="divize" />
                <asp:BoundField DataField="skup_str" HeaderText="[%Skup. středisek%]" SortExpression="skup_str" />
                <asp:BoundField DataField="str" HeaderText="[%Středisko%]" SortExpression="str" />
                <asp:BoundField DataField="typ_kompetenci" HeaderText="[%Typ kompetencí%]" SortExpression="typ_kompetenci" />
                <asp:BoundField DataField="kompetence" HeaderText="[%Kompetence%]" SortExpression="kompetence" />
                <asp:BoundField DataField="vaha" HeaderText="[%Váha%]" SortExpression="vaha" />
                <asp:BoundField DataField="body_poz" HeaderText="[%Požadováno%]" SortExpression="body_poz"
                    DataFormatString="{0:N2}" />
                <asp:BoundField DataField="body_obd_sebe" HeaderText="[%Sebehodnocení%]" SortExpression="body_obd_sebe"
                    DataFormatString="{0:N2}" />
                <asp:BoundField DataField="dokonceno_seb" HeaderText="[%hotovo %%]" SortExpression="dokonceno_seb" />
                <asp:BoundField DataField="body_obd" HeaderText="[%Hodnocení%]" SortExpression="body_obd"
                    DataFormatString="{0:N2}" />
                <asp:BoundField DataField="dokonceno_obd" HeaderText="[%hotovo %%]" SortExpression="dokonceno_obd" />
            </Columns>
            <PagerTemplate>
                <wc:PagerNavigationBar runat="server" ID="page_nastaveni" />
            </PagerTemplate>
        </wc:TGridView> --%>
        <%-- New --%>

        <kspwc:TRadGrid ID="TRadGrid_sestava" runat="server"
                        ShowGroupPanel="True" AllowPaging="True" 
                         AllowSorting="true" AutoGenerateColumns="false"
                        AutoFilterControlWidth="false">
            <ClientSettings AllowDragToGroup="True">
            </ClientSettings>
            <GroupingSettings ShowUnGroupButton="true"></GroupingSettings>
            <PagerStyle Mode="NextPrevNumericAndAdvanced"></PagerStyle>
            <ExportSettings HideStructureColumns="true" OpenInNewWindow="true">
            </ExportSettings>
            <MasterTableView CommandItemDisplay="Top">
                <Columns>
                    <telerik:GridNumericColumn DataType="System.Decimal" DataField="os_cislo" HeaderText="[%Os. číslo%]" SortExpression="os_cislo" FilterControlWidth="45"/>
                    <kspwc:GridFotoZamColumn UniqueName="foto" DataOsCisloField="os_cislo"></kspwc:GridFotoZamColumn>
                    <telerik:GridBoundColumn DataField="jmeno" HeaderText="[%Jméno%]" SortExpression="jmeno" />                    
                    <telerik:GridNumericColumn DataType="System.Int16" DataField="cislo_pom" HeaderText="[%Č.p.%]" SortExpression="cislo_pom" FilterControlWidth="45"/>
                    <telerik:GridBoundColumn DataField="prac_misto" HeaderText="[%Prac. místo%]" SortExpression="prac_misto" />
                    <telerik:GridBoundColumn DataField="profese" HeaderText="[%Profese%]" SortExpression="profese" />
                    <telerik:GridBoundColumn DataField="divize" HeaderText="[%Divize%]" SortExpression="divize" />
                    <telerik:GridBoundColumn DataField="skup_str" HeaderText="[%Skup. středisek%]" SortExpression="skup_str" />
                    <telerik:GridBoundColumn DataField="str" HeaderText="[%Středisko%]" SortExpression="str" />
                    <telerik:GridBoundColumn DataField="typ_kompetenci" HeaderText="[%Typ kompetencí%]" SortExpression="typ_kompetenci" />
                    <telerik:GridBoundColumn DataField="kompetence" HeaderText="[%Kompetence%]" SortExpression="kompetence" />
                    <telerik:GridBoundColumn DataField="vaha" HeaderText="[%Váha%]" SortExpression="vaha" />
                    <telerik:GridBoundColumn DataField="body_poz" HeaderText="[%Požadováno%]" SortExpression="body_poz"
                        DataFormatString="{0:N2}" />
                    <telerik:GridBoundColumn DataField="body_obd_sebe" HeaderText="[%Sebehodnocení%]" SortExpression="body_obd_sebe"
                        DataFormatString="{0:N2}" />
                    <telerik:GridBoundColumn DataField="dokonceno_seb" HeaderText="[%hotovo %%]" SortExpression="dokonceno_seb" />
                    <telerik:GridBoundColumn DataField="body_obd" HeaderText="[%Hodnocení%]" SortExpression="body_obd"
                        DataFormatString="{0:N2}" />
                    <telerik:GridBoundColumn DataField="dokonceno_obd" HeaderText="[%hotovo %%]" SortExpression="dokonceno_obd" />
                </Columns>
                <CommandItemTemplate>
                    <kspwc:GridCommandItemControl ID="GridCommandItemControl1" runat="server" RebindButton-Enabled="False" RebindButton-Visible="False">
                    </kspwc:GridCommandItemControl>
                </CommandItemTemplate>
            </MasterTableView>
        </kspwc:TRadGrid>

        <%-- End new --%>

        <asp:Chart ID="ChartKompetence" runat="server" DataSourceID="" Height="800px" 
            Width="800px" ondatabound="ChartKompetence_DataBound">
            <Series>
                <asp:Series ChartType="Radar" Name="SeriesIDTypKompetenci" ChartArea="ChartArea1" 
                    CustomProperties="AreaDrawingStyle=Polygon" XValueMember="kompetence" 
                    YValueMembers="id_typ_kompetenci" Legend="LegendUroven" 
                    IsVisibleInLegend="False">
                </asp:Series>
                <asp:Series ChartType="Radar" Name="SeriesBodyPoz" ChartArea="ChartArea1" 
                    BorderWidth="4" Color="Transparent" 
                    BorderColor="Green"
                    CustomProperties="AreaDrawingStyle=Polygon" XValueMember="kompetence" 
                    YValueMembers="body_poz" Legend="LegendUroven" 
                    LegendText="Požadovaná úroveň">
                </asp:Series>
                <asp:Series ChartType="Radar" Name="SeriesBodyObd" ChartArea="ChartArea1" 
                    BorderWidth="4" Color="Transparent"
                    BorderColor="Red"
                    CustomProperties="AreaDrawingStyle=Polygon" XValueMember="kompetence" 
                    YValueMembers="body_obd" Legend="LegendUroven" 
                    LegendText="Dosažená úroveň">
                </asp:Series>
                <asp:Series ChartType="Radar" Name="SeriesVaha" ChartArea="ChartArea1" 
                    BorderWidth="3" Color="Transparent" 
                    BorderColor="Green" Enabled="false"
                    CustomProperties="AreaDrawingStyle=Polygon" XValueMember="kompetence" 
                    YValueMembers="vaha" Legend="LegendUroven">
                </asp:Series>
            </Series>
            <ChartAreas>
                <asp:ChartArea Name="ChartArea1">
                <AxisY Interval="1">
                <MajorTickMark Enabled="false" />
                </AxisY>
                </asp:ChartArea>
            </ChartAreas>
            <Legends>
                <asp:Legend Name="LegendUroven" Enabled="false" Title="Úrovně" 
                    BorderColor="Transparent" Docking="Bottom" TitleAlignment="Near">
                </asp:Legend>
                <asp:Legend Name="LegendTypKompetenci" Enabled="false" Title="Typy kompetencí" 
                    BorderColor="Transparent" Docking="Bottom" TitleAlignment="Near">
                </asp:Legend>
            </Legends>
        </asp:Chart>
        <br />
    </div>
</asp:Content>
