﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="HodnoceniMzdy.aspx.cs" Inherits="KSPortal.Sestavy.Sestavy_HodnoceniMzdy" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRadGrid_sestava">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGrid_sestava" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <asp:Label ID="Label1" runat="server" Text="[%Převod do mezd%]" CssClass="nadpis1"></asp:Label>
    <table style="border-collapse: collapse; border: 1px solid #808080" class="ksprvek HodnoceniToolbar">
        <tr>
            <td style="border-bottom-style: solid; border-width: 1px; border-color: #808080">
                <asp:Label ID="Label3" runat="server" Text="[%Hodnotící akce%]:"></asp:Label>
            </td>
            <td colspan="2" style="border-bottom-style: solid; border-width: 1px; border-color: #808080">
                <asp:ObjectDataSource ID="ODS_akce" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="HodnoticiAkce" TypeName="KSProgram.Hodnoceni.Hodnoceni">
                    <SelectParameters>
                        <asp:Parameter Name="zamceno" DbType="Int16" />
                        <asp:Parameter Name="jen_primi" Type="Boolean" DefaultValue="false" />
                        <asp:Parameter Name="existujeOdkazDo" Type="String" DefaultValue="hz_h2m.idh;" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <wc:TDropDown ID="TDD_akce" runat="server" DataSourceID="ODS_akce" DataTextField="nazev"
                    DataValueField="id" OnDataBound="TDD_akce_DataBound" AutoPostBack="True">
                </wc:TDropDown>
            </td>
        </tr>
        <tr>
            <td colspan="2" style="font-weight: bold">
                [%Filtr zaměstnanců%]:
            </td>
            <td style="border-width: 1px; border-color: #808080; font-weight: bold; border-right-style: solid;
                border-left-style: solid;">
                [%Sčítat zaměstnance%]:
            </td>
        </tr>
        <tr>
            <td>
                <asp:Label ID="L_divize" runat="server" Text="[%Divize%]:"></asp:Label><br />
                <asp:ObjectDataSource ID="ODS_divize" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="cislDivize" TypeName="KSProgram.Sestavy.DefSestavy_HodnMzdy">
                    <SelectParameters>
                        <asp:ControlParameter ControlID="TDD_akce" Name="Id_ha" PropertyName="SelectedValue"
                            Type="String" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <wc:TDropDown ID="TDD_divize" runat="server" DataSourceID="ODS_divize" DataTextField="naz_divize"
                    DataValueField="cis_divize" AutoPostBack="True">
                </wc:TDropDown>
            </td>
            <td>
                <asp:Label ID="L_stredisko" runat="server" Text="[%Středisko%]:"></asp:Label>
                <br />
                <asp:ObjectDataSource ID="ODS_Stredisko" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="cislStredisko" TypeName="KSProgram.Sestavy.DefSestavy_HodnMzdy">
                    <SelectParameters>
                        <asp:ControlParameter ControlID="TDD_akce" Name="Id_ha" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="TDD_divize" Name="cis_divize" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="TDD_skupinaStred" Name="skup_str" PropertyName="SelectedValue"
                            Type="String" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <wc:TDropDown ID="TDD_stredisko" runat="server" DataSourceID="ODS_Stredisko" DataTextField="nazev"
                    DataValueField="str" AutoPostBack="True">
                </wc:TDropDown>
            </td>
            <td rowspan="2" style="border-right-style: solid; border-left-style: solid; border-width: 1px;
                border-color: #808080">
                <asp:RadioButtonList ID="RBL_group_zam" runat="server" RepeatColumns="2" AutoPostBack="True"
                    OnPreRender="RBL_group_zam_PreRender">
                    <asp:ListItem Value="4">[%Za všechny%]</asp:ListItem>
                    <asp:ListItem Value="1">[%Po divizích%]</asp:ListItem>
                    <asp:ListItem Value="2">[%Po skupinách středisek%]</asp:ListItem>
                    <asp:ListItem Value="3">[%Po střediscích%]</asp:ListItem>
                    <asp:ListItem Selected="True" Value="0">[%Po zaměstnancích%]</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr>
            <td>
                <asp:Label ID="L_skupinaStred" runat="server" Text="[%Skup. středisek%]:"></asp:Label><br />
                <asp:ObjectDataSource ID="ODS_SkupinaStred" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="cislSkupinaStred" TypeName="KSProgram.Sestavy.DefSestavy_HodnMzdy">
                    <SelectParameters>
                        <asp:ControlParameter ControlID="TDD_akce" Name="Id_ha" PropertyName="SelectedValue"
                            Type="String" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <wc:TDropDown ID="TDD_skupinaStred" runat="server" DataSourceID="ODS_SkupinaStred"
                    DataTextField="skup_nazev" DataValueField="skup_str" AutoPostBack="True">
                </wc:TDropDown>
            </td>
            <td>
                <asp:Label ID="L_zamestnanec" runat="server" Text="[%Zaměstnanec%]:"></asp:Label><br />
                <asp:ObjectDataSource ID="ODS_Zamestnanec" runat="server" OldValuesParameterFormatString="original_{0}"
                    SelectMethod="cislZamestnanec" TypeName="KSProgram.Sestavy.DefSestavy_HodnMzdy">
                    <SelectParameters>
                        <asp:ControlParameter ControlID="TDD_akce" Name="Id_ha" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="TDD_divize" Name="cis_divize" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="TDD_skupinaStred" Name="skup_str" PropertyName="SelectedValue"
                            Type="String" />
                        <asp:ControlParameter ControlID="TDD_stredisko" Name="str" PropertyName="SelectedValue"
                            Type="String" />
                    </SelectParameters>
                </asp:ObjectDataSource>
                <wc:TDropDown ID="TDD_zamestnanec" runat="server" DataSourceID="ODS_Zamestnanec"
                    DataTextField="jmeno" DataValueField="os_cislo" AutoPostBack="True">
                </wc:TDropDown>
            </td>
        </tr>
        <tr>
            <td style="border-top-style: solid; border-width: 1px; border-color: #808080" 
                colspan="3">
                <asp:Label ID="Label4" runat="server" Text="[%Sloupce%]:"></asp:Label>
                <wc:TCheckBoxList ID="CBL_show" runat="server" RepeatDirection="Horizontal" OnPreRender="CBL_show_PreRender"
                    UseSaveSetting="False">
                </wc:TCheckBoxList>
            </td>
        </tr>
    </table>
    <br />
    <wc:TLinkButton runat="server" ID="lb_nacist" Text="[%Vytvořit%]" CssClass="kstlacitko"
        SkinID="button" OnCommand="lb_nacist_Command"></wc:TLinkButton>
    <br />
    <br />
    <asp:ObjectDataSource ID="ODS_sestava" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="Retrieve" TypeName="KSProgram.Sestavy.DefSestavy_HodnMzdy">
        <SelectParameters>
            <asp:Parameter Name="Id_ha" Type="String" />
            <asp:Parameter Name="cis_divize" Type="Int32" />
            <asp:Parameter Name="skup_str" Type="Int32" />
            <asp:Parameter Name="str" Type="String" />
            <asp:Parameter Name="os_cislo" Type="String" />
            <asp:Parameter Name="groupZam" Type="String" />
            <asp:Parameter Name="columns" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <%-- 
    <wc:TGridView ID="TGV_sestava" runat="server" AllowMultiColumnSorting="True" PovolFiltraci="True"
        ShowTitleRow="True" TitleText="[%Převod do mezd%]" ControlPanelPosition="TitleRow"
        PovolExport="True" AllowPaging="true">
        <Columns>
            <asp:BoundField DataField="os_cislo" HeaderText="[%Os. číslo%]" SortExpression="os_cislo" />
            <asp:BoundField DataField="jmeno" HeaderText="[%Jméno%]" SortExpression="jmeno" />
            <asp:BoundField DataField="prac_misto" HeaderText="[%Prac. místo%]" SortExpression="prac_misto" />
            <%--<asp:BoundField DataField="cislo_pom" HeaderText="[%Číslo pom.%]" SortExpression="prac_misto" />--%
            <asp:BoundField DataField="divize" HeaderText="[%Divize%]" SortExpression="divize" />
            <asp:BoundField DataField="skup_str" HeaderText="[%Skup. středisek%]" SortExpression="skup_str" />
            <asp:BoundField DataField="str" HeaderText="[%Středisko%]" SortExpression="str" />
            <asp:BoundField DataField="kod" HeaderText="[%Kód%]" SortExpression="kod" />
            <asp:BoundField DataField="koeficient" HeaderText="[%Koeficient%]" SortExpression="koeficient" />
            <asp:BoundField DataField="suma" HeaderText="[%Suma%]" SortExpression="suma" />
            <asp:BoundField DataField="prumer" HeaderText="[%Průměr%]" SortExpression="prumer" />
            <asp:BoundField DataField="datum" HeaderText="[%Datum%]" SortExpression="datum"
                DataFormatString="{0:d}" HtmlEncode="False" />
            <%--<asp:TemplateField>
                <ItemTemplate>
                    <wc:TLabel ID="L_poznamka" runat="server" FormatHtml="True" Text='<%# Bind("poznamka") %>'></wc:TLabel>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField>
                <ItemTemplate>
                    <wc:TLabel ID="L_ocek" runat="server" FormatHtml="True" Text='<%# Bind("ocek_vystup") %>'></wc:TLabel>
                </ItemTemplate>
            </asp:TemplateField>--%
        </Columns>
        <PagerTemplate>
            <wc:PagerNavigationBar runat="server" ID="page_nastaveni" />
        </PagerTemplate>
    </wc:TGridView>
    --%>

    <%-- NEW --%>
    <kspwc:TRadGrid ID="TRadGrid_sestava" runat="server" ShowGroupPanel="True" AllowPaging="True" 
                     AllowSorting="true" AutoGenerateColumns="false"
                    AutoFilterControlWidth="false">
        <ClientSettings AllowDragToGroup="True">
        </ClientSettings>
        <GroupingSettings ShowUnGroupButton="true"></GroupingSettings>
        <PagerStyle Mode="NextPrevNumericAndAdvanced"></PagerStyle>
        <ExportSettings HideStructureColumns="true" OpenInNewWindow="true">
        </ExportSettings>
        <MasterTableView CommandItemDisplay="Top">
            <Columns>
                <telerik:GridNumericColumn DataType="System.Decimal" DataField="os_cislo" HeaderText="[%Os. číslo%]" SortExpression="os_cislo" />
                <kspwc:GridFotoZamColumn UniqueName="foto" DataOsCisloField="os_cislo"></kspwc:GridFotoZamColumn>
                <telerik:GridBoundColumn DataField="jmeno" HeaderText="[%Jméno%]" SortExpression="jmeno" />
                <telerik:GridBoundColumn DataField="prac_misto" HeaderText="[%Prac. místo%]" SortExpression="prac_misto" />
                <telerik:GridBoundColumn DataField="divize" HeaderText="[%Divize%]" SortExpression="divize" />
                <telerik:GridBoundColumn DataField="skup_str" HeaderText="[%Skup. středisek%]" SortExpression="skup_str" />
                <telerik:GridBoundColumn DataField="str" HeaderText="[%Středisko%]" SortExpression="str" />
                <telerik:GridBoundColumn DataField="kod" HeaderText="[%Kód%]" SortExpression="kod" />
                <telerik:GridBoundColumn DataField="koeficient" HeaderText="[%Koeficient%]" SortExpression="koeficient" />
                <telerik:GridBoundColumn DataField="suma" HeaderText="[%Suma%]" SortExpression="suma" />
                <telerik:GridBoundColumn DataField="prumer" HeaderText="[%Průměr%]" SortExpression="prumer" />
                <telerik:GridDateTimeColumn DataField="datum" HeaderText="[%Datum%]" SortExpression="datum"
                DataFormatString="{0:d.M.yyyy}" FilterControlAltText="Filter datum column" />
            </Columns>
            <CommandItemTemplate>
                <kspwc:GridCommandItemControl ID="GridCommandItemControl1" runat="server" RebindButton-Enabled="False" RebindButton-Visible="False">
            </kspwc:GridCommandItemControl> 
            </CommandItemTemplate>
        </MasterTableView>
    </kspwc:TRadGrid>
    <%-- NEW END --%>
</asp:Content>
