﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Unlogged.Master" AutoEventWireup="true"
    CodeBehind="Login.aspx.cs" Inherits="KSPortal.Login" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajax" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
    <style type="text/css">
        div.KScert {
            overflow: scroll;
            height: 150px;
            width: 450px;
            border-top: 1px solid lightgray;
            border-left: 1px solid lightgray;
            color: black;
            font-weight: normal;
        }

        #div_mob {
            padding-top: 30px;
            font-style: italic;
        }

        .bigErr {
            font-size: 18px;
        }

        div.panel-unlogged-holder-innerdiv {
            background-color: transparent !important;
        }

        .loginLinkButton {
            text-decoration: none;
            display: flex;
            flex-direction: column;
            margin: auto;
            padding: 5px;
            align-items: center;
            text-align: center;
            transition: 0.75s;
            width: 80%;
            height: 57px;
            color: var(--kscolor2text);
        }

            .loginLinkButton:hover {
                background: #f0f0f0;
                box-shadow: rgba(0, 0, 0, 0.1) 0px 5px 5px;
                color: #4f4f4f;
            }

            .RadButton.kstlacitko, .panel-login .kstlacitko{
                background: var(--kscolor1) !important;
                color: var(--kscolor1text) !important;
            }

            .RadButton.kstlacitko:hover{
                box-shadow: var(--stin);
            }

            .RadButton.kstlacitko:focus{
                box-shadow: none;
            }


        .kstlacitko .fi::before {
            font-size: 25px !important;
        }
        div.loginDiv {
            width: min-content;
            min-width: 320px;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <telerik:RadFormDecorator ID="RadFormDecorator1" runat="server" DecoratedControls="All"
        DecorationZoneID="decor" EnableRoundedCorners="False" Font-Names="Arial" />
    <div id="decor" class="loginDiv">
        <asp:Label ID="BrowserLabel" runat="server" ForeColor="Red"></asp:Label>
        <asp:Panel ID="LoginPanel" runat="server" DefaultButton="LoginButton" HorizontalAlign="Left"
            CssClass="panel-login hidden">
            <table runat="server" id="loginTable" style="padding: 0px; margin: 0px; border-style: none; border-collapse: collapse; width: 100%">
                <tr>
                    <td style="padding: 0px; margin: 0px; height: 19px; vertical-align: top; color: var(--kscolor2text)" colspan="2">
                        <asp:Label ID="UserNameLabel" runat="server" Text="[%Přihlašovací jméno%]:"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 0px 0px 12px 0px; margin: 0px">
                        <telerik:RadTextBox ID="UserName" runat="server" Width="350px" Font-Size="18px" Height="33px"
                            AutoCompleteType="Disabled">
                            <ClientEvents OnKeyPress="OnKeyPressLogin" />
                        </telerik:RadTextBox><br />
                        <kspwc:PasswordValidator runat="server" ID="PasswordValidator_UserName" ControlToValidate="UserName" ValidationGroup="Login1"></kspwc:PasswordValidator>
                    </td>
                    <td>
                        <asp:RequiredFieldValidator ID="UserNameRequired" runat="server" ControlToValidate="UserName"
                            ValidationGroup="Login1" Display="Dynamic" ErrorMessage="[%Jméno je povinný údaj%]"></asp:RequiredFieldValidator>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 0px; margin: 0px; height: 19px; vertical-align: top; color: var(--kscolor2text)" colspan="2">
                        <asp:Label ID="PasswordLabel" runat="server" Text="[%Heslo%]:"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 0px 0px 12px 0px; margin: 0px;">
                        <telerik:RadTextBox ID="Password" runat="server" Width="350px" Font-Size="18px" Height="33px"
                            TextMode="Password" AutoCompleteType="Disabled">
                            <ClientEvents OnKeyPress="OnKeyPressPass" OnLoad="OnClientLoad" />
                        </telerik:RadTextBox><br />
                        <kspwc:PasswordValidator runat="server" ID="PasswordValidator_Password" ControlToValidate="Password" ValidationGroup="Login1"></kspwc:PasswordValidator>
                    </td>
                    <td>
                        <asp:RequiredFieldValidator ID="PasswordRequired" runat="server" ControlToValidate="Password"
                            ValidationGroup="Login1" Display="Dynamic" ErrorMessage="[%Heslo je povinný údaj%]">
                        </asp:RequiredFieldValidator>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 0px; margin: 0px; height: 19px; vertical-align: top; color: var(--kscolor2text)" colspan="2">
                        <asp:Label ID="Label4" runat="server" Text="[%Databáze%]:"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="padding: 0px 0px 12px 0px; margin: 0px;" colspan="2">
                        <telerik:RadDropDownList ID="ddl_databaze" runat="server" Width="350px">
                        </telerik:RadDropDownList>
                    </td>
                </tr>
                <tr>
                    <td align="center" style="padding-top: 10px; margin: 0px;" colspan="2">
                        <telerik:RadButton ID="LoginButton" runat="server" Text="[%Přihlásit se%]" OnClick="LoginButton_Click" CssClass="kstlacitko" Font-Size="18px"
                            ValidationGroup="Login1" Width="150px" Height="50px" Enabled="false" OnClientClicked="loginAnimace">
                        </telerik:RadButton>
                        <%--<div id="LoginAnimace" class="lds-ellipsis" style="display: none; color: var(--kscolor2text)" runat="server">
                            <div></div>
                            <div></div>
                            <div></div>
                            <div></div>
                        </div>--%>
                        <div class="loader" id="LoginAnimace" runat="server" style="width: 50px; height: 50px; display: none; position: relative; left: unset">
                            <div class="inner one"></div>
                            <div class="inner two"></div>
                            <div class="inner three"></div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td align="left" colspan="2" style="color: red; padding-top: 10px; margin: 0px;">
                        <asp:CustomValidator ID="FailureText" runat="server" ErrorMessage="" ValidationGroup="Login1" Visible="false">
                        </asp:CustomValidator>
                        <asp:ValidationSummary ID="ValidationSummary1" runat="server" ValidationGroup="Login1" />
                    </td>
                </tr>
                <tr>
                    <td style="padding: 15px 0px 0px 0px; margin: 0px; height: 22px; vertical-align: top;"
                        colspan="2">
                        <table width="100%" style="padding: 0px; margin: 0px; border-style: none; border-collapse: collapse;">
                            <tr>
                                <td align="left" style="padding: 0px; margin: 0px; width: 33%;">
                                    <asp:LinkButton ID="LB_Registrace" runat="server" Visible="False" PostBackUrl="~/Public/RegistraceForm.aspx" CssClass="loginLinkButton"><i class="fi fi-user-add"></i><div>[%Registrace nového uživatele%]</div></asp:LinkButton>
                                </td>
                                <td align="center" style="padding: 0px; margin: 0px; width: 33%;">
                                    <asp:LinkButton ID="ChangePasswordButton" runat="server" Visible="False" OnClick="ChangePasswordButton_Click" CssClass="loginLinkButton"><i class="fi fi-lock"></i><div>[%Změna hesla%]</div></asp:LinkButton>
                                    <asp:LinkButton ID="LB_ResetPassword" runat="server" Visible="False" PostBackUrl="~/Public/ResetPassword.aspx" CssClass="loginLinkButton"><i class="fi fi-lock"></i><div>[%Zapomněl jsem heslo%]</div></asp:LinkButton>
                                </td>
                                <td align="right" style="padding: 0px; margin: 0px; width: 33%;">
                                    <asp:LinkButton ID="LB_ExternalUser" runat="server" PostBackUrl="~/Public/ExternalUserLogin.aspx" CssClass="loginLinkButton"><i class="fi fi-sign-in-alt"></i><div>[%Externí uživatel%]</div></asp:LinkButton>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
            <div class="div4" runat="server" id="mail_Sms" visible="false" style="text-align: center">
                <img src="Images/securityLogo.png" width="150px" height="auto" />
                <br />
                <p style="font-size: medium;">[%Bezpečnostní kód byl odeslán%]</p>

                <telerik:RadTextBox runat="server" ID="securityCode" InputType="Text" MaxLength="6" Style="letter-spacing: 0.5em; height: 30px; font-size: large; text-align: center;"></telerik:RadTextBox>
                <br />
                <asp:Label ID="platnostKodu" runat="server" Text=""></asp:Label>
                <br />
                <%--<div>[%Platnost kódu vyprší za %] <span id="time">02:30</span></div>--%>
                <br />
                <asp:Button ID="ButtonSecurityCode" runat="server" Text="[%Potvrdit%]" Width="150px" Height="50px" OnClick="ButtonSecurityCode_Click" CssClass="kstlacitko" Font-Size="18px" />

                <br />
                <asp:Label ID="FailureLabel2" Text="" runat="server" ForeColor="Red"></asp:Label>
                <br />
                <asp:LinkButton ID="LinkButton1" runat="server" OnClick="LinkButton1_Click" CssClass="loginLinkButton" Width="150px"><i class="fi fi-sign-in-alt"></i><div>[%Zpět na přihlášení%]</div></asp:LinkButton>

            </div>

            <div class="div4" runat="server" id="Authenticator" visible="false" style="text-align: center">
                <img src="Images/googleAuthPic.png" width="150px" height="auto" />
                <br />
                <div id="AuthenticationPrihlaseniFail" visible="false" runat="server">
                    <br />
                    <asp:Label ID="Label3" runat="server" Text="[%Nemáte zadáný e-mail do práce, není tedy možné se pomocí authentikátoru přihlásit.%]"></asp:Label>
                    <br />
                    <br />
                </div>
                <div id="AuthenticationPrihlaseni" visible="false" runat="server">
                    <p style="font-size: medium;">[%Zadejte kód z Authenticatoru%]</p>


                    <telerik:RadTextBox runat="server" ID="AuthenticatorPin" InputType="Text" MaxLength="6" Style="letter-spacing: 0.5em; height: 30px; font-size: large; text-align: center;"></telerik:RadTextBox>
                    <br />
                    <asp:Label ID="Label1" runat="server" Text=""></asp:Label>
                    <br />
                    <asp:Button ID="Button1" runat="server" Text="[%Potvrdit%]" Width="150px" Height="50px"  Font-Size="18px" OnClick="ButtonAuthenticatorValidateClick" CssClass="kstlacitko" />
                    <br />

                    <asp:Label ID="Label2" Text="" runat="server" ForeColor="Red"></asp:Label>
                    <br />
                    <div class="div4" runat="server" id="AuthenticatorMailSent" visible="false">
                        <asp:Label Style="color: red" runat="server">[%Na email do práce Vám byly zaslány další instrukce%]</asp:Label>
                    </div>
                    <div class="div4" runat="server" id="SendMailAuthenticator" visible="true" style="display: flex; flex-direction: row;">

                            <asp:LinkButton ID="LinkButton3" runat="server" OnClick="LinkButton1_Click" CssClass="loginLinkButton"><i class="fi fi-sign-in-alt"></i><div>[%Zpět na přihlášení%]</div></asp:LinkButton>

                    </div>
                </div>
            </div>

            <div class="twoFactor" runat="server" id="twoFactor" visible="false" style="text-align: center">
                <p style="font-size: medium;">[%Vyberte možnost ověření%]</p>
                <asp:LinkButton runat="server" class="twofactor-btn" OnClick="SecurityCode_SendSMS" ID="SMSButton">
                    <div class="twofactor-btn-icon">
                        <img src="Images/outline_phone_android_black_36dp.png" width="40px" height="40px" />
                    </div>
                    <div class="twofactor-btn-text">
                        <h3>SMS</h3>
                    </div>
                </asp:LinkButton>
                <asp:LinkButton runat="server" class="twofactor-btn" OnClick="SecurityCode_SendMail">
                    <div class="twofactor-btn-icon">
                        <img src="Images/mail_two_factor.png" width="40px" height="40px" />
                    </div>
                    <div class="twofactor-btn-text">
                        <h3>E-mail</h3>
                    </div>
                </asp:LinkButton>
                <asp:LinkButton runat="server" class="twofactor-btn" OnClick="LogWithAuthenticator">
                    <div class="twofactor-btn-icon">
                        <img src="Images/googleAuthPic.png" width="40px" height="40px" />
                    </div>
                    <div class="twofactor-btn-text">
                        <h3>Authenticator</h3>
                    </div>
                </asp:LinkButton>
                <asp:LinkButton ID="LinkButton2" runat="server" OnClick="LinkButton1_Click" CssClass="loginLinkButton"><i class="fi fi-sign-in-alt"></i><div>[%Zpět na přihlášení%]</div></asp:LinkButton>
            </div>
            <div id="div_mob" style="width: fit-content; margin: auto;">
                <asp:Label runat="server" ID="mob" Text="[%Přihlašovací údaje jsou platné i pro mobilní aplikaci%]."></asp:Label>
            </div>
        </asp:Panel>
        <asp:HiddenField ID="HF_cookieError" runat="server" Value="[%Ve vašem prohlížeči nejsou povoleny soubory cookie!%]" />
        <asp:HiddenField ID="HF_jsonError" runat="server" Value="[%Ve vašem prohlížeči není podporován JSON! Některá funkcionalita nebude dostupná nebo nebude fungovat správně.%]" />
        <asp:HiddenField runat="server" ID="hashVal" Value="" />
        <asp:HiddenField runat="server" ID="HF_NotSupBrowser" Value="" />
    </div>

    <script type="text/javascript">
        window.JSON || document.write('<script src="//cdn.jsdelivr.net/json3/latest/json3.min.js"><\/scr' + 'ipt>');

        function showCaution(errText) {
            $("body .alert").remove();
            $("body").prepend($("<div class='alert caution' style='margin-top: 27px;' >" + errText + "</div>"));
        }

        Sys.Application.add_load(function () {
            loginPageLoad();
        });

        function loginPageLoad() {
            document.cookie = "testcookie";
            var cookiesEnabled = (document.cookie.indexOf("testcookie") != -1) ? true : false;
            var errorText = "";
            if (!cookiesEnabled) {
                errorText += $get("<%=HF_cookieError.ClientID %>").value; //text chyby se načítá z kontrolky, která je přeložená
            }

            if (!(window.JSON && window.JSON.stringify)) {
                if (errorText != "") {
                    errorText += "<br /><br />";
                }
                errorText += $get("<%=HF_jsonError.ClientID %>").value;
            }

            if (errorText != "") {
                showCaution(errorText);
            }

            var json = KSMaster.getPlatformJson();
            $.ajax({
                type: "POST",
                url: "WebServices/AutoCompleteService.asmx/GetCompatibility",
                data: "{jsonData: '" + json + "'}",
                async: true,
                contentType: "application/json",
                dataType: "json",
                failure: function (response) {
                    CompatibilityCallBackFailed(response);
                },
                error: function (response) {
                    CompatibilityCallBackFailed(response);
                },
                success: CompatibilityCallBack
            });
        }

        function CompatibilityCallBack(data) {
            if (data && data.d) {
                var errorlabel = $get("<%=BrowserLabel.ClientID %>");
                if (data.d.Message != null) errorlabel.innerText = data.d.Message;
                else errorlabel.innerText = "";
                if (!data.d.IsSupported) {
                    if (data.d.ParNotSupBrowser == '1') {
                        if (data.d.ErrorMessage != null)
                            errorlabel.innerText = data.d.ErrorMessage;
                        else errorlabel.innerText = "";
                        errorlabel.classList.add('bigErr');
                        return;
                    }
                    if (data.d.ErrorMessage != null)
                        errorlabel.innerText += " " + data.d.ErrorMessage;
                }
                $('div.panel-login').removeClass('hidden');
                $find('<%=LoginButton.ClientID %>').set_enabled(true);
                $find('<%=UserName.ClientID %>').focus();
            }
        }

        function CompatibilityCallBackFailed(response) {
            var errorlabel = $get("<%=BrowserLabel.ClientID %>");
            errorlabel.innerText = "Selhalo volání webové metody zjišťijící kompatibilitu prohlížeče: " + response.statusText + ": " + response.responseText;

            var parSup = $get("<%=HF_NotSupBrowser.ClientID %>").value;
            if (parSup != "1") {
                $('div.panel-login').removeClass('hidden');
                $find('<%=LoginButton.ClientID %>').set_enabled(true);
                $find('<%=UserName.ClientID %>').focus();
            }
        }

        function OnKeyPressLogin(sender, eventArgs) {
            var c = eventArgs.get_keyCode();
            if (c == 13) {
                var passTxt = $get("<%=Password.ClientID %>");
                if (passTxt) {
                    passTxt.focus();
                    eventArgs.set_cancel(true);
                }
            }
        }
        function OnKeyPressPass(sender, eventArgs) {
            var c = eventArgs.get_keyCode();
            if (c == 13) {
                var btn = $get("<%=LoginButton.ClientID %>");
                if (btn) {
                    btn.click();
                }
            }
        }
        function OnClientLoad(sender, args) {
            KSMaster.passwordNotSaving(sender, args);
        }

        function timeout() {
            setTimeout(function () {
                document.getElementById('<%= hashVal.ClientID %>').value = "";
            }, timeForTimeout);

        }

        function setTimeoutTime(time) {
            timeForTimeout = Number(time) * 60000;

        }

        function loginAnimace() {
            var button = document.getElementById("<%=LoginButton.ClientID%>");
            var anim = document.getElementById("<%=LoginAnimace.ClientID%>");
            var val = document.getElementById("<%=ValidationSummary1.ClientID%>");

            if (val.style.display == "none") {

                button.style.display = "none";
                anim.style.display = "block";
            }
        }

        timeForTimeout = 150000;
        //function startTimer(duration, display) {
        //    var timer = duration, minutes, seconds;
        //    setInterval(function () {
        //        minutes = parseInt(timer / 60, 10)
        //        seconds = parseInt(timer % 60, 10);

        //        minutes = minutes < 10 ? "0" + minutes : minutes;
        //        seconds = seconds < 10 ? "0" + seconds : seconds;

        //        display.textContent = minutes + ":" + seconds;

        //        if (--timer < 0) {
        //            timer = duration;
        //        }
        //    }, 1000);
        //}

        //function countDownTimer() {
        //    var fiveMinutes = 60 * 2.5,
        //        display = document.querySelector('#time');
        //    startTimer(fiveMinutes, display);
        //};

    </script>
</asp:Content>
