﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" Inherits="Manazer_Budgety"
    CodeBehind="Budgety.aspx.cs" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <style>
        .RadGrid_Metro .rgFooter>td, .RadGrid_Metro .rgFooterWrapper
        {
            font-size:14px !important;
        }
    </style>

    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRadGridBudgety">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGridBudgety"></telerik:AjaxUpdatedControl>
                    <telerik:AjaxUpdatedControl ControlID="RadWindow1"></telerik:AjaxUpdatedControl>
                    <telerik:AjaxUpdatedControl ControlID="RadWindow2"></telerik:AjaxUpdatedControl>
                    <telerik:AjaxUpdatedControl ControlID="RadWindow3"></telerik:AjaxUpdatedControl>
                    <telerik:AjaxUpdatedControl ControlID="LabelError"></telerik:AjaxUpdatedControl>
                    <telerik:AjaxUpdatedControl ControlID="RadWindow1Field"></telerik:AjaxUpdatedControl>
                    <telerik:AjaxUpdatedControl ControlID="RadWindow2Field"></telerik:AjaxUpdatedControl>
                    <telerik:AjaxUpdatedControl ControlID="RadWindow3Field"></telerik:AjaxUpdatedControl>
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRadGridPohyby">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGridPohyby"></telerik:AjaxUpdatedControl>
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="RadWindow2">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="LabelError"></telerik:AjaxUpdatedControl>
                    <telerik:AjaxUpdatedControl ControlID="TDropDownTyp"></telerik:AjaxUpdatedControl>
                    <telerik:AjaxUpdatedControl ControlID="TDropDownKod"></telerik:AjaxUpdatedControl>
                    <telerik:AjaxUpdatedControl ControlID="TDropDownNazev"></telerik:AjaxUpdatedControl>
                    <telerik:AjaxUpdatedControl ControlID="TDropDownPodr"></telerik:AjaxUpdatedControl>
                    <telerik:AjaxUpdatedControl ControlID="TDropDownNadriz1"></telerik:AjaxUpdatedControl>
                    <telerik:AjaxUpdatedControl ControlID="TDropDownNadriz2"></telerik:AjaxUpdatedControl>
                    <telerik:AjaxUpdatedControl ControlID="TRadGridBudgety"></telerik:AjaxUpdatedControl>
                    <telerik:AjaxUpdatedControl ControlID="RadWindow2"></telerik:AjaxUpdatedControl>
                    <telerik:AjaxUpdatedControl ControlID="RadWindow2Field"></telerik:AjaxUpdatedControl>
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="RadWindow3">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TDropDown2"></telerik:AjaxUpdatedControl>
                    <telerik:AjaxUpdatedControl ControlID="LabelError2"></telerik:AjaxUpdatedControl>
                    <telerik:AjaxUpdatedControl ControlID="RadWindow3"></telerik:AjaxUpdatedControl>
                    <telerik:AjaxUpdatedControl ControlID="TRadGridBudgety"></telerik:AjaxUpdatedControl>
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_Generuj">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadWindow3"></telerik:AjaxUpdatedControl>
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>

    <telerik:RadCodeBlock ID="RadScriptBlock1" runat="server">
        <%-- MoKo odstranuji, je jiz pridano v TPrePage --%>
        <%--<script type="text/javascript" src="../Scripts/jquery-3.6.1.min.js"></script>--%>

        <script type="text/javascript" src="../kendo/js/kendo.all.min.js"></script>
        <script type="text/javascript" id="telerikClientEvents1">

            var uskutecneno;
            var rezervace;
            var datumy;

            function createChart(name) {
                var chart = $("#chart");
                chart.kendoChart({
                    title: {
                        text: "[%Graf prostředků%]" + " " + name
                    },
                    legend: {
                        position: "top"
                    },
                    chartArea: {
                        background: ""
                    },
                    seriesDefaults: {
                        type: "line",
                    },
                    series: [{
                        name: "[%Aktuální stav%]",
                        data: uskutecneno,
                        style: "step"
                    },
                        {
                            name: "[%Rezervace%]",
                            data: rezervace,
                            style: "step"
                        }],
                    valueAxis: {
                        labels: {
                            format: "{0}"
                        },
                        line: {
                            visible: false
                        }
                    },
                    categoryAxis: {
                        majorGridLines: {
                            visible: false
                        },
                        categories: datumy,
                        labels: {
                            rotation: "auto"
                        },
                        crosshair: {
                            visible: true
                        }
                    },
                    tooltip: {
                        visible: true,
                        shared: true,
                        format: "N0",
                    },
                    chartArea: {
                        width: 1000,
                    },
                });

            }
        </script>
    </telerik:RadCodeBlock>
    <%--<asp:Label ID="Label1" runat="server" Text="[%Budgety%]" CssClass="nadpis1"></asp:Label>--%>

        <style type="text/css">

        input.kstlacitko{
            height: 20px;
            background: inherit !important;
        }
    </style>

    <kspwc:TRadGrid ID="TRadGridBudgety" runat="server" AutoFilterControlWidth="false" AutoFilterWidth="true"
        AllowSorting="True" AutoGenerateColumns="False" OnItemCommand="TRadGridBudgety_ItemCommand" ShowGroupPanel="true"
        AllowPaging="true" OnNeedDataSource="TRadGridBudgety_NeedDataSource" CssClass="ksprvek marginBottom" AllowMultiRowSelection="true"  >
        <GroupingSettings CaseSensitive="False" CollapseAllTooltip="Collapse all groups" ShowUnGroupButton="true"></GroupingSettings>
        <ClientSettings AllowDragToGroup="True">
            <ClientEvents  OnRowSelected="TRadGridBudgety_OnRowSelected" OnRowDeselected="TRadGridBudgety_OnRowDeselected" OnMasterTableViewCreated="TRadGridBudgety_OnMasterTableViewCreated" />
            <Selecting AllowRowSelect="true" />
            <%--Dovolí vybrat položku z tabulky --%>
        </ClientSettings>
        <MasterTableView CommandItemDisplay="Top" DataKeyNames="id_budgetu, nazev_budgetu"  ShowFooter="true" ClientDataKeyNames="zust_zacatek,prijmy,vydaje,rezervPrij,rezervVyd,zust_konec"
            Caption="[%Budgety%]">
          
            <CommandItemTemplate>
                <%--klasický control v radgridu--%>
                <kspwc:GridCommandItemControl runat="server" ID="GCIC1" DateControl="TRadObdobiInterval">
                    <%-- Výběr datumového období --%>
                </kspwc:GridCommandItemControl>
                <kspwc:TRadButton AutoPostBack="true" runat="server" ID="TRB_Novy" Text="[%Nový budget%]" OnClick="TRB_Novy_Click" Style="margin-top: 2px;" Icon-PrimaryIconCssClass="fi fi-add" Visible="<%# PristupPovolen(449) %>"  />
                <kspwc:TRadButton AutoPostBack="true" runat="server" ID="TRB_Generuj" Text="[%Generuj budgety%]" OnClick="TRB_Generuj_Open" Style="margin-top: 2px;" Icon-PrimaryIconCssClass="fi fi-settings" Visible="<%# PristupPovolen(450) %>" />
                <kspwc:TRadButton AutoPostBack="true" runat="server" ID="TRB_Pozadavek" Text="[%Požadavek na převod prostředků%]" OnClick="TRB_Pozadavek_Click" Style="margin-top: 2px;" Icon-SecondaryIconCssClass="fi-arrow-up-right-from-square" ToolTip="[%Přesměrování na požadavky%]" />
                <%--<kspwc:TRadButton AutoPostBack="false" Enabled="false" runat="server" ID="TRB_Souhrn" Text="[%Souhrn pohybů%]" Style="margin-top: 2px;" ToolTip="[%Souhrn pohybů%]" OnClientClicked="TRB_Souhrn_OnClientClicked" OnClientLoad="TRB_Souhrn_OnClientLoad" />--%>

            </CommandItemTemplate>
            <Columns>
                <telerik:GridClientSelectColumn UniqueName="vyber_zaznamu"  HeaderText=""></telerik:GridClientSelectColumn>
                <telerik:GridBoundColumn UniqueName="id_budgetu" DataField="id_budgetu" SortExpression="id_budgetu" HeaderText="[%ID budgetu%]"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="kod_budgetu" DataField="kod_budgetu" SortExpression="kod_budgetu" HeaderText="[%Kód budgetu%]" ></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="nazev_budgetu" DataField="nazev_budgetu" SortExpression="nazev_budgetu" HeaderText="[%Název budgetu%]" FooterText="[%Celkem%]:"></telerik:GridBoundColumn>
                <telerik:GridButtonColumn UniqueName="nahled" ImageUrl="../Skins/ikony/uicons-regular-rounded/svg/fi-rr-chart-line-up.svg" ButtonType="ImageButton" Text="[%Detail pohybů%]" CommandName="showDetail" HeaderText="[%Pohyby%]" ItemStyle-HorizontalAlign="Center" ButtonCssClass="kstlacitko"></telerik:GridButtonColumn>
                <telerik:GridBoundColumn UniqueName="zust_zacatek" DataField="zust_zacatek" SortExpression="zust_zacatek" HeaderText="[%Zůstatek na začátku období%]" Aggregate="Sum" FooterText=" "></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="prijmy" DataField="prijmy" SortExpression="prijmy" HeaderText="[%Příjmy%]" ItemStyle-ForeColor="Green"  Aggregate="Sum"  FooterText=" "></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="vydaje" DataField="vydaje" SortExpression="vydaje" HeaderText="[%Výdaje%]" ItemStyle-ForeColor="Red"  Aggregate="Sum"  FooterText=" "></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="rezervPrij" DataField="rezervPrij" SortExpression="rezervPrij" HeaderText="[%Rezervované příjmy%]" ItemStyle-ForeColor="#00cc66"  Aggregate="Sum"  FooterText=" "></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="rezervVyd" DataField="rezervVyd" SortExpression="rezervVyd" HeaderText="[%Rezervované výdaje%]" ItemStyle-ForeColor="Orange"  Aggregate="Sum"  FooterText=" "></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="zust_konec" DataField="zust_konec" SortExpression="zust_konec" HeaderText="[%Zůstatek na konci období%]"  Aggregate="Sum"  FooterText=" "></telerik:GridBoundColumn>

                <telerik:GridDateTimeColumn FilterControlAltText="Filter dat_vystaveni column" UniqueName="obdobi_od"
                    PickerType="DatePicker" HeaderText="[%Platnost od%]" DataField="obdobi_od"
                    DataFormatString="{0:d.M.yyyy}" EditDataFormatString="d.M.yyyy">
                </telerik:GridDateTimeColumn>
                <telerik:GridDateTimeColumn FilterControlAltText="Filter dat_vystaveni column" UniqueName="obdobi_do"
                    PickerType="DatePicker" HeaderText="[%Platnost do%]" DataField="obdobi_do"
                    DataFormatString="{0:d.M.yyyy}" EditDataFormatString="d.M.yyyy">
                </telerik:GridDateTimeColumn>

                <telerik:GridBoundColumn UniqueName="typ_jednotky" DataField="typ_jednotky" SortExpression="typ_jednotky" HeaderText="[%Typ jednotky%]"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="kod_jednotky" DataField="kod_jednotky" SortExpression="kod_jednotky" HeaderText="[%Kód jednotky%]"></telerik:GridBoundColumn>
                <%--<telerik:GridBoundColumn UniqueName="typ_podriz_jedn" DataField="typ_podriz_jedn" SortExpression="typ_podriz_jedn" HeaderText="[%Typ podřízené jednotky%]"></telerik:GridBoundColumn>--%>
                <telerik:GridBoundColumn UniqueName="id_nadriz_budgetu" DataField="id_nadriz_budgetu" SortExpression="id_nadriz_budgetu" HeaderText="[%ID nadřízeného budgetu%]"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="id_podniku" DataField="id_podniku" SortExpression="id_podniku" HeaderText="[%ID podniku%]"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="aktivita" DataField="aktivita" SortExpression="aktivita" HeaderText="[%Aktivní k čerpání%]"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="ucel" DataField="ucel" SortExpression="ucel" HeaderText="[%Účel%]"></telerik:GridBoundColumn>
                <telerik:GridBoundColumn UniqueName="kod_mzdpol" DataField="kod_mzdpol" SortExpression="kod_mzdpol" HeaderText="[%Kódy mzdových pol.%]"></telerik:GridBoundColumn>

            </Columns>

        </MasterTableView>

    </kspwc:TRadGrid>

    <asp:HiddenField ID="RadWindow1Field" Value="false" runat="server" />
    <telerik:RadWindow ID="RadWindow1" Title="Budget detail" runat="server" Behaviors="Close,Move,Resize" Modal="true"
        Width="1200" Height="650" Visible="true" VisibleOnPageLoad="true" OnClientClose="Window1Close" KeepInScreenBounds="true">
        <ContentTemplate>
            <kspwc:TRadGrid ID="TRadGridPohyby" runat="server" AutoFilterControlWidth="false" AutoFilterWidth="true"
                AllowSorting="false" AutoGenerateColumns="False" CssClass="revertShadow"
                OnNeedDataSource="TRadGridPohyby_NeedDataSource">
                <GroupingSettings CaseSensitive="False" CollapseAllTooltip="Collapse all groups"></GroupingSettings>
                <MasterTableView CommandItemDisplay="Top" DataKeyNames="id_pohybu" EnableNoRecordsTemplate="true" 
                    Caption="[%Pohyby v budgetu za období%]">
                    <NoRecordsTemplate>
                        <div class="NoRecordsTemplate">
                            <i class="fi fi-eye-crossed"></i>
                            <label>[%Žádná data k zobrazení%]</label>
                        </div>                       
                    </NoRecordsTemplate>
                    <CommandItemTemplate>
                        <%--klasický control v radgridu--%>
                    </CommandItemTemplate>
                    <Columns>
                        <telerik:GridBoundColumn UniqueName="id_pohybu" DataField="id_pohybu" SortExpression="id_pohybu" HeaderText="[%ID pohybu%]"></telerik:GridBoundColumn>
                        <%--<telerik:GridBoundColumn UniqueName="guid" DataField="guid" SortExpression="guid" HeaderText="[%GUID%]"></telerik:GridBoundColumn>--%>
                        <telerik:GridBoundColumn UniqueName="agenda" DataField="agenda" SortExpression="agenda" HeaderText="[%Agenda%]"></telerik:GridBoundColumn>
                        <telerik:GridBoundColumn UniqueName="id_budgetu" DataField="id_budgetu" SortExpression="id_budgetu" HeaderText="[%ID budgetu%]" Display="false"></telerik:GridBoundColumn>
                        <telerik:GridBoundColumn UniqueName="nazev" DataField="nazev" SortExpression="nazev" HeaderText="[%Budget%]"></telerik:GridBoundColumn>
                        <telerik:GridBoundColumn UniqueName="druh_pohybu" DataField="druh_pohybu" SortExpression="druh_pohybu" HeaderText="[%Druh pohybu%]"></telerik:GridBoundColumn>
                        <telerik:GridBoundColumn UniqueName="nazev_proti" DataField="nazev_proti" SortExpression="nazev_proti" HeaderText="[%Protibudgetu%]"></telerik:GridBoundColumn>
                        <telerik:GridBoundColumn UniqueName="rezervace" DataField="rezervace" SortExpression="rezervace" HeaderText="[%Rezervace%]"></telerik:GridBoundColumn>
                        <telerik:GridBoundColumn UniqueName="id_pozadavku" DataField="id_pozadavku" SortExpression="id_pozadavku" HeaderText="[%ID požadavku%]"></telerik:GridBoundColumn>
                        <telerik:GridBoundColumn UniqueName="castka" DataField="castka" SortExpression="castka" HeaderText="[%Částka%]"></telerik:GridBoundColumn>
                        <telerik:GridDateTimeColumn UniqueName="datum_zapisu" HeaderText="[%Datum zápisu%]" DataField="datum_zapisu" DataFormatString="{0:d.M.yyyy}" EditDataFormatString="d.M.yyyy"></telerik:GridDateTimeColumn>
                        <telerik:GridDateTimeColumn UniqueName="obdobi" HeaderText="[%Období%]" DataField="obdobi" DataFormatString="{0:d.M.yyyy}" EditDataFormatString="d.M.yyyy"></telerik:GridDateTimeColumn>
                        <telerik:GridBoundColumn UniqueName="os_cislo" DataField="os_cislo" SortExpression="os_cislo" HeaderText="[%Os.čís.%]"></telerik:GridBoundColumn>
                        <%--<telerik:GridBoundColumn UniqueName="cislo_pom" DataField="cislo_pom" SortExpression="cislo_pom" HeaderText="[%Číslo poměru%]"></telerik:GridBoundColumn>--%>
                        <telerik:GridBoundColumn UniqueName="popis" DataField="popis" SortExpression="popis" HeaderText="[%Popis%]"></telerik:GridBoundColumn>
                    </Columns>
                </MasterTableView>
            </kspwc:TRadGrid>
            <div id="chart" style="margin: auto; width: 1000px; height: 350px; border: lightgray solid 1px; padding: 20px; margin-top: 25px;"></div>
        </ContentTemplate>
    </telerik:RadWindow>
    <asp:HiddenField ID="RadWindow2Field" Value="false" runat="server" />
    <telerik:RadWindow ID="RadWindow2" Title="[%Nový budget%]" runat="server" Visible="false"  KeepInScreenBounds="true"
        VisibleOnPageLoad="true" Behaviors="Close,Move" Width="520px" Height="550px" OnClientClose="Window2Close">
        <ContentTemplate>
            <asp:Table runat="server" ID="TableInsert" SkinID="RamAPozadi" Width="480px">

                <asp:TableRow runat="server" ID="TableRowInsert4">
                    <asp:TableCell runat="server" ID="TCInsert7" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                        <asp:Label ID="Label3" runat="server" Text="[%Název%]:"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell runat="server" ID="TCInsert8" ColumnSpan="2" SkinID="DataFieldStyle">

                        <telerik:RadTextBox ID="RTB_NovyNazev" runat="server" Text='' MaxLength="999"
                            Width="100%">
                        </telerik:RadTextBox>
                    </asp:TableCell>
                </asp:TableRow>
                <asp:TableRow runat="server" ID="TableRow3">
                    <asp:TableCell runat="server" ID="TableCell5" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                        <asp:Label ID="Label6" runat="server" Text="[%Kód budgetu%]:" Width="80px"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell runat="server" ID="TableCell6" ColumnSpan="2" SkinID="DataFieldStyle">

                        <telerik:RadTextBox ID="RTB_NovyKod" runat="server" Text='' MaxLength="12"
                            Width="100%">
                        </telerik:RadTextBox>
                    </asp:TableCell>
                </asp:TableRow>
                <asp:TableRow runat="server" ID="TableRowInsert5">
                    <asp:TableCell runat="server" ID="TCInsert9" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                        <asp:Label ID="Label4" runat="server" Text="[%Platnost od%]:"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell runat="server" ID="TCInsert10" ColumnSpan="2" SkinID="DataFieldStyle">

                        <kspwc:TRadDatePicker runat="server" ID="TRDP_NovyDatOd"></kspwc:TRadDatePicker>
                        <asp:Image ID="Img1" runat="server" ImageUrl="~/ImagesN/info.png" Height="20px" Width="20px" ImageAlign="Right" ToolTip="Pokud není datum zvoleno doplní se dnešní datum." />
                    </asp:TableCell>
                </asp:TableRow>
                <asp:TableRow runat="server" ID="TableRow1">
                    <asp:TableCell runat="server" ID="TableCell1" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                        <asp:Label ID="Label2" runat="server" Text="[%Platnost do%]:"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell runat="server" ID="TableCell2" ColumnSpan="2" SkinID="DataFieldStyle">

                        <kspwc:TRadDatePicker runat="server" ID="TRDP_NovyDatDo"></kspwc:TRadDatePicker>
                        <asp:Image ID="Image1" runat="server" ImageUrl="~/ImagesN/info.png" Height="20px" Width="20px" ImageAlign="Right" ToolTip="Pokud není datum zvoleno nastaví se platnost na rok." />
                    </asp:TableCell>
                </asp:TableRow>
                <asp:TableRow runat="server" ID="TableRow2">
                    <asp:TableCell runat="server" ID="TableCell3" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                        <asp:Label ID="Label5" runat="server" Text="[%Počáteční zůstatek%]:"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell runat="server" ID="TableCell4" ColumnSpan="2" SkinID="DataFieldStyle">

                        <telerik:RadTextBox ID="RTB_NovyZustatek" runat="server" Width="90%">
                        </telerik:RadTextBox>
                        <asp:Label ID="Label8" runat="server" Text=" Kč"></asp:Label>
                    </asp:TableCell>
                </asp:TableRow>
                <asp:TableRow runat="server" ID="TableRow4">
                    <asp:TableCell runat="server" ID="TableCell7" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                        <asp:Label ID="Label9" runat="server" Text="[%Typ jednotky%]:" Width="80px"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell runat="server" ID="TableCell8" ColumnSpan="2" SkinID="DataFieldStyle">

                        <kspwc:TDropDown ID="TDropDownTyp" runat="server" AutoPostBack="true" OnSelectedIndexChanged="TDropDownTyp_SelectedIndexChanged">
                        </kspwc:TDropDown>
                    </asp:TableCell>
                </asp:TableRow>
                <asp:TableRow runat="server" ID="TableRow5">
                    <asp:TableCell runat="server" ID="TableCell9" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                        <asp:Label ID="Label11" runat="server" Text="[%Kód a název jednotky%]:" Width="80px"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell runat="server" ID="TableCell10" ColumnSpan="2" SkinID="DataFieldStyle">
                        <div style="width: 100%; display: flex; flex-direction: row;">
                            <div style="min-width: 25%">
                                <kspwc:TDropDown ID="TDropDownKod" runat="server" AutoPostBack="true" OnSelectedIndexChanged="TDropDownKod_SelectedIndexChanged" Width="100%">
                                </kspwc:TDropDown>
                            </div>
                            <div style="min-width: 55%;">
                                <kspwc:TDropDown ID="TDropDownNazev" runat="server" AutoPostBack="true" OnSelectedIndexChanged="TDropDownNazev_SelectedIndexChanged" Width="100%">
                                </kspwc:TDropDown>
                            </div>
                        </div>
                    </asp:TableCell>
                </asp:TableRow>
                <asp:TableRow runat="server" ID="TableRow6">
                    <asp:TableCell runat="server" ID="TableCell11" HorizontalAlign="right" SkinID="DataFieldHeaderStyle" ColumnSpan="2" Width="70px">
                        <asp:Label ID="Label10" runat="server" Text="[%Jedná se o podřízený budget%]:"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell runat="server" ID="TableCell12" ColumnSpan="1" SkinID="DataFieldStyle">

                        <kspwc:TDropDown ID="TDropDownPodr" runat="server" AutoPostBack="true" Width="40%" OnSelectedIndexChanged="TDropDownPodr_SelectedIndexChanged">
                            <asp:ListItem Text="[%ne%]" />
                            <asp:ListItem Text="[%ano%]" />

                        </kspwc:TDropDown>
                    </asp:TableCell>
                </asp:TableRow>
                <asp:TableRow runat="server" ID="TableRow11">
                    <asp:TableCell runat="server" ID="TableCell22" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                        <asp:Label ID="Label17" runat="server" Text="[%Nadřízený budget%]:" Width="150px"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell runat="server" ID="TableCell23" ColumnSpan="2" SkinID="DataFieldStyle">
                        <div style="width: 100%; display: flex; flex-direction: row;">
                            <div style="min-width: 25%">
                                <kspwc:TDropDown ID="TDropDownNadriz1" runat="server" AutoPostBack="true" OnSelectedIndexChanged="TDropDownNadriz1_SelectedIndexChanged" Width="100%">
                                </kspwc:TDropDown>
                            </div>
                            <div style="min-width: 75%">
                                <kspwc:TDropDown ID="TDropDownNadriz2" runat="server" AutoPostBack="true" OnSelectedIndexChanged="TDropDownNadriz2_SelectedIndexChanged" Width="100%">
                                </kspwc:TDropDown>
                            </div>
                        </div>
                    </asp:TableCell>
                </asp:TableRow>
                <asp:TableRow runat="server" ID="TableRow10">
                    <asp:TableCell runat="server" ID="TableCell13" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                        <asp:Label ID="Label7" runat="server" Text="[%Účel%]:" Width="80px"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell runat="server" ID="TableCell20" ColumnSpan="2" SkinID="DataFieldStyle">

                        <telerik:RadTextBox ID="RTB_ucel" runat="server" Text="1" MaxLength="12" Enabled="false" Width="100%">
                        </telerik:RadTextBox>
                    </asp:TableCell>
                </asp:TableRow>
                <asp:TableRow runat="server" ID="TableRow12">
                    <asp:TableCell runat="server" ID="TableCell21" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                        <asp:Label ID="Label12" runat="server" Text="[%Kódy mzdových položek%]:"></asp:Label><br />
                        <asp:Label ID="Label16" runat="server" Text="[%(odděleny čárkou)%]"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell runat="server" ID="TableCell24" ColumnSpan="2" SkinID="DataFieldStyle">

                        <telerik:RadTextBox ID="RTB_kod_mzdpol" runat="server" Text='' Width="100%">
                        </telerik:RadTextBox>
                    </asp:TableCell>
                </asp:TableRow>
            </asp:Table>
            <asp:Label ID="LabelError" runat="server" Text="" ForeColor="Red" BackColor="White"></asp:Label>
            <br />
            <div style="float: right; margin-right: 10px">
                <kspwc:TRadButton Text="[%Založit%]" runat="server" OnClick="UlozitNovy_Click" AutoPostBack="true" Icon-PrimaryIconCssClass="fi fi-add"></kspwc:TRadButton>
            </div>
        </ContentTemplate>
    </telerik:RadWindow>
    <asp:HiddenField ID="RadWindow3Field" Value="false" runat="server" />
    <telerik:RadWindow ID="RadWindow3" Title="[%Generovat budgety%]" runat="server" Modal="true"  KeepInScreenBounds="true"
        VisibleOnPageLoad="true" Behaviors="Close,Move" Width="270px" Height="290px" OnClientClose="Window3Close">
        <ContentTemplate>
            <asp:Table runat="server" ID="Table1" SkinID="RamAPozadi">
                <asp:TableRow runat="server" ID="TableRow7">
                    <asp:TableCell runat="server" ID="TableCell14" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                        <asp:Label ID="Label13" runat="server" Text="[%Generovat pro%]:" Width="80px"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell runat="server" ID="TableCell15" ColumnSpan="2" SkinID="DataFieldStyle">

                        <kspwc:TDropDown ID="TDropDown2" runat="server" AutoPostBack="true" Width="80%" OnSelectedIndexChanged="TDropDown2_SelectedIndexChanged">
                            <asp:ListItem Text="[%Divize%]" />
                            <asp:ListItem Text="[%Střediska%]" />
                        </kspwc:TDropDown>
                    </asp:TableCell>
                </asp:TableRow>
                <asp:TableRow runat="server" ID="TableRow8">
                    <asp:TableCell runat="server" ID="TableCell16" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                        <asp:Label ID="Label14" runat="server" Text="[%Platnost od%]:"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell runat="server" ID="TableCell17" ColumnSpan="2" SkinID="DataFieldStyle">

                        <kspwc:TRadDatePicker runat="server" ID="TRadDatePicker1">
                        </kspwc:TRadDatePicker>
                    </asp:TableCell>
                </asp:TableRow>
                <asp:TableRow runat="server" ID="TableRow9">
                    <asp:TableCell runat="server" ID="TableCell18" HorizontalAlign="right" SkinID="DataFieldHeaderStyle">
                        <asp:Label ID="Label15" runat="server" Text="[%Platnost do%]:"></asp:Label>
                    </asp:TableCell>
                    <asp:TableCell runat="server" ID="TableCell19" ColumnSpan="2" SkinID="DataFieldStyle">

                        <kspwc:TRadDatePicker runat="server" ID="TRadDatePicker2">
                        </kspwc:TRadDatePicker>
                    </asp:TableCell>
                </asp:TableRow>

            </asp:Table>
            <asp:Label ID="LabelError2" runat="server" Text="" ForeColor="Red" BackColor="White"></asp:Label>
            <br />
            <div style="float: right; margin-right: 10px">
                <kspwc:TRadButton ID="TRB_Generuj" Text="[%Generovat%]" runat="server" OnClick="Generuj_Click" AutoPostBack="true" Icon-PrimaryIconCssClass="fi fi-settings"></kspwc:TRadButton>
            </div>
        </ContentTemplate>
    </telerik:RadWindow>
    <telerik:RadScriptBlock runat="server" ID="RadScript">       
        <script type="text/javascript">          
            function Window1Close(sender, args) {
                $get("<%=RadWindow1Field.ClientID %>").value = "false";
                Budgety_aspx_prep();
            }
            function Window2Close(sender, args) {
                $get("<%=RadWindow2Field.ClientID %>").value = "false";
                Budgety_aspx_prep();
            }
            function Window3Close(sender, args) {
                $get("<%=RadWindow3Field.ClientID %>").value = "false";
                Budgety_aspx_prep();
            }
            function Budgety_aspx_prep() {
                Budgety_aspx_prepocet($find("<%=TRadGridBudgety.ClientID %>"));
            }
         
            function TRadGridBudgety_OnRowSelected(sender, args) {                           
                $(".FGenFRow").remove();
                Budgety_aspx_prepocet(sender, args);
            }                
            function TRadGridBudgety_OnRowDeselected(sender, args) {               
                Budgety_aspx_prepocet(sender, args);
            }
            function Budgety_aspx_prepocet(sender, args) {
                var el = $("#ctl00_HlavniOblast_TRadGridBudgety .rgFooter");
                $(".FGenFRow").remove();
                var zust_zacatek = 0;
                var prijmy = 0;
                var vydaje = 0;
                var rezervPrij = 0;
                var rezervVyd = 0;
                var zust_konec = 0;
                var selRows = sender.get_masterTableView().get_selectedItems();
                if (selRows.length == 0) return;
                for (var i = 0; i < selRows.length; i++) {                   
                    zust_zacatek += Budgety_aspx_readValue(selRows[i], "zust_zacatek");
                    prijmy += Budgety_aspx_readValue(selRows[i], "prijmy");
                    vydaje += Budgety_aspx_readValue(selRows[i], "vydaje");
                    rezervPrij += Budgety_aspx_readValue(selRows[i], "rezervPrij");
                    rezervVyd += Budgety_aspx_readValue(selRows[i], "rezervVyd");
                    zust_konec += Budgety_aspx_readValue(selRows[i], "zust_konec");
                }

                $("<tr class='FGenFRow rgFooter'>" +
                    "<td colspan=2></td>" +
                    "<td align='right' colspan=3>" + KSMaster.dict.get('Celkem za označené')+":</td>" +
                    "<td align='right'>" + zust_zacatek + "</td>" +
                    "<td align='right'>" + prijmy + "</td>" +
                    "<td align='right'>" + vydaje + "</td>" +
                    "<td align='right'>" + rezervPrij + "</td>" +
                    "<td align='right'>" + rezervVyd + "</td>" +
                    "<td align='right'>" + zust_konec + "</td>" +
                    "<td colspan=9></td>" +
                    "</tr> ").insertBefore(el);
            }
            function TRadGridBudgety_OnMasterTableViewCreated(sender, args) {            
                $("#ctl00_HlavniOblast_TRadGridBudgety_ctl00_ctl02_ctl02_vyber_zaznamuSelectCheckBox").hide();                    
            }
            function Budgety_aspx_readValue(rItem, name) {
                var num = parseFloat(rItem.getDataKeyValue(name));
                if (num == NaN)
                    return 0;
                else
                    return num;
            }
        </script>
    </telerik:RadScriptBlock>
</asp:Content>
