﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" Inherits="Manazer_StatJazykStrukt"
    EnableSessionState="True" CodeBehind="StatJazykStrukt.aspx.cs" %>

<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls.Ciselniky" TagPrefix="cc2" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="cc1" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Charting" TagPrefix="telerik" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRB_CelaFirma">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="Jednotka" UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_Jednotka">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="Jednotka" UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRG_Data">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RChart" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_Jednotka">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RChart" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_Vytvorit">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RChart" />
                    <telerik:AjaxUpdatedControl ControlID="TRG_Data" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRG_Data">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRG_Data" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>

    <%--<asp:Label ID="nadpis" runat="server" Text="[%Evidenční graf jazykový%]" CssClass="nadpis1"></asp:Label>--%>

    <asp:ObjectDataSource ID="ODS_Jazyky" runat="server" SelectMethod="JazykySeznam"
        TypeName="KSProgram.Ciselniky.CisJazyku" OldValuesParameterFormatString="original_{0}">
        <SelectParameters>
            <asp:Parameter DefaultValue="ORDER BY nazev" Name="expression_OrderBy" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>

    <table>
        <tr>
            <td class="ksprvek">
                <kspwc:StrSkupDiv ID="Jednotka" runat="server" />
            </td>
            <td>
                <kspwc:TRadButton ID="TRB_CelaFirma" runat="server" ToggleType="Radio" ButtonType="ToggleButton"
                    Text="[%Celá firma%]" GroupName="GN_Jednotka" Value="f" CssClass="pozadiText">
                </kspwc:TRadButton>
                <br />
                <kspwc:TRadButton ID="TRB_Jednotka" runat="server" ToggleType="Radio" ButtonType="ToggleButton"
                    Text="[%Vybraná jednotka%]" GroupName="GN_Jednotka" Value="j" Checked="true"
                    OnCheckedChanged="TRB_Jednotka_CheckedChanged" CssClass="pozadiText">
                </kspwc:TRadButton>
            </td>

        </tr>
    </table>
    <div class="EvidGrafy">
        <div>
            <kspwc:TRadGrid ID="TRG_Data" runat="server" OnNeedDataSource="TRG_Data_NeedDataSource" MasterTableView-Caption="[%Data grafu%]"
                ShowFooter="true">
                <MasterTableView AutoGenerateColumns="false" AllowSorting="true" CommandItemDisplay="Top">
                    <Columns>
                        <telerik:GridBoundColumn DataField="stup_znal" HeaderText="[%Stupeň znalosti%]" />
                        <telerik:GridNumericColumn DataField="muzi" HeaderText="[%Muži%]" Aggregate="Sum"
                            FooterText=" " />
                        <telerik:GridNumericColumn DataField="zeny" HeaderText="[%Ženy%]" Aggregate="Sum"
                            FooterText=" " />
                        <telerik:GridNumericColumn DataField="celkem" HeaderText="[%Celkem%]" Aggregate="Sum"
                            FooterText=" " />
                        <telerik:GridNumericColumn DataField="podil" HeaderText="[%Podíl%]" />
                    </Columns>
                    <CommandItemTemplate>
                        <kspwc:GridCommandItemControl ID="GridCommandItemControl1" runat="server" FilterButton-Visible="false" DateControl="TRadDatePicker" BezMESButton-Visible="true">
                            <ContentTemplate>
                                <div class="gridCommandButton">
                                    <kspwc:TRadButton ID="hlPracPom" runat="server" Text="[%Hl. prac. pom.%]" ToolTip="[%Jen hlavní pracovní poměr%]" ToggleType="CheckBox" ButtonType="StandardButton" OnDataBinding="hlPracPom_DataBinding" OnClick="hlPracPom_Click"></kspwc:TRadButton>
                                </div>
                                <div class="gridCommandButton">
                                    <kspwc:TRadComboBox runat="server" ID="TRCB_Jazyk2" DataSourceID="ODS_Jazyky" DataTextField="nazev" OnItemDataBound="TRCB_Jazyk2_ItemDataBound" Width="130" DataValueField="jazyk">
                                        <ItemTemplate>
                                            <%# DataBinder.Eval(Container.DataItem, "nazev") %>
                                        </ItemTemplate>
                                    </kspwc:TRadComboBox>
                                </div>

                            </ContentTemplate>
                        </kspwc:GridCommandItemControl>
                    </CommandItemTemplate>
                </MasterTableView>
            </kspwc:TRadGrid>
        </div>

        <div class="ksprvek">
            <telerik:RadHtmlChart ID="RChart" runat="server" Transitions="false" Legend-Appearance-Position="Bottom" CssClass="whiteBack"
                OnPreRender="RChart_PreRender">
                <ChartTitle>
                    <Appearance Visible="true">
                        <TextStyle FontSize="16px"></TextStyle>
                    </Appearance>
                </ChartTitle>
                <Legend>
                    <Appearance Visible="true">
                    </Appearance>
                </Legend>
                <PlotArea>
                    <XAxis Visible="true" DataLabelsField="stup_znal">
                        <TitleAppearance Text="Stupeň znalosti">
                            <TextStyle FontSize="12px"></TextStyle>
                        </TitleAppearance>
                    </XAxis>
                    <YAxis Visible="true">
                        <TitleAppearance Text="Počet zaměstnanců">
                            <TextStyle FontSize="12px"></TextStyle>
                        </TitleAppearance>
                    </YAxis>
                    <Series>
                        <telerik:ColumnSeries DataFieldY="muzi" Name="Muži">
                        </telerik:ColumnSeries>
                        <telerik:ColumnSeries DataFieldY="zeny" Name="Ženy">
                        </telerik:ColumnSeries>
                    </Series>
                </PlotArea>
                <Navigator>
                    <XAxis Visible="true">
                        <TitleAppearance>
                            <TextStyle FontSize="16px"></TextStyle>
                        </TitleAppearance>
                    </XAxis>
                </Navigator>
            </telerik:RadHtmlChart>
        </div>
    </div>

    <%--    <asp:ObjectDataSource ID="dsSestava" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="Retrieve" TypeName="KSProgram.Sestavy.DefSestavy_SI011">
        <SelectParameters>
            <asp:Parameter Name="kmen_str" Type="String" />
            <asp:Parameter Name="jazyk" Type="String" />
            <asp:Parameter Name="keDni" Type="DateTime" />
            <asp:Parameter Name="hlavniPP" Type="Boolean" />
            <asp:Parameter Name="mimoEvid" Type="Boolean" />
        </SelectParameters>
    </asp:ObjectDataSource>--%>
</asp:Content>
