﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" Inherits="Manazer_StatVzdelStrukt"
    CodeBehind="StatVzdelStrukt.aspx.cs" %>

<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="cc1" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HlavniOblast" runat="Server">
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="TRB_CelaFirma">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="Jednotka" UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_Jednotka">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="Jednotka" UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRB_Vytvorit">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RChart" UpdatePanelCssClass="" />
                    <telerik:AjaxUpdatedControl ControlID="TRG_Data" UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRG_Data">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRG_Data" UpdatePanelCssClass="" />
                    <telerik:AjaxUpdatedControl ControlID="RChart" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>

    <%--<asp:Label ID="nadpis" runat="server" Text="[%Evidenční graf vzdělanostní%]" CssClass="nadpis1"></asp:Label>--%>
    <table>
        <tr>
            <td class="ksprvek">
                <kspwc:StrSkupDiv ID="Jednotka" runat="server"></kspwc:StrSkupDiv>
            </td>
            <td>
                <kspwc:TRadButton ID="TRB_CelaFirma" runat="server" ToggleType="Radio" ButtonType="ToggleButton"
                    Text="[%Celá firma%]" GroupName="GN_Jednotka" Value="f" CssClass="pozadiText">
                </kspwc:TRadButton>
                <br />
                <kspwc:TRadButton ID="TRB_Jednotka" runat="server" ToggleType="Radio" ButtonType="ToggleButton"
                    Text="[%Vybraná jednotka%]" GroupName="GN_Jednotka" Value="j" Checked="true"
                    OnCheckedChanged="TRB_Jednotka_CheckedChanged" CssClass="pozadiText">
                </kspwc:TRadButton>
            </td>
        </tr>
    </table>
    <div class="EvidGrafy">
        <div>
            <kspwc:TRadGrid runat="server" ID="TRG_Data" OnNeedDataSource="TRG_Data_NeedDataSource" MasterTableView-Caption="[%Data grafu%]">
                <MasterTableView AutoGenerateColumns="false" AllowSorting="true" CommandItemDisplay="Top" ShowFooter="true">
                    <Columns>
                        <telerik:GridBoundColumn DataField="stup_vzdel" HeaderText="[%Stupeň vzdělání%]" />
                        <telerik:GridNumericColumn DataField="muzi" HeaderText="[%Muži%]" Aggregate="Sum" FooterText=" " />
                        <telerik:GridNumericColumn DataField="zeny" HeaderText="[%Ženy%]" Aggregate="Sum" FooterText=" " />
                        <telerik:GridNumericColumn DataField="celkem" HeaderText="[%Celkem%]" Aggregate="Sum" FooterText=" " />
                        <telerik:GridNumericColumn DataField="podil" HeaderText="[%Podíl%]" />
                    </Columns>
                    <CommandItemTemplate>
                        <kspwc:GridCommandItemControl ID="GridCommandItemControl1" runat="server" DateControl="TRadDatePicker" FilterButton-Visible="false" BezMESButton-Visible="true">
                            <ContentTemplate>
                                <div class="gridCommandButton">
                                    <kspwc:TRadButton ID="hlPracPom" runat="server" Text="[%Hl. prac. pom.%]" ToolTip="[%Jen hlavní pracovní poměr%]" ToggleType="CheckBox" ButtonType="StandardButton" OnDataBinding="hlPracPom_DataBinding" OnClick="hlPracPom_Click"></kspwc:TRadButton>
                                </div>
                            </ContentTemplate>
                        </kspwc:GridCommandItemControl>
                    </CommandItemTemplate>
                </MasterTableView>
            </kspwc:TRadGrid>
        </div>
        <div class="ksprvek">
            <telerik:RadHtmlChart ID="RChart" runat="server" OnPreRender="RChart_PreRender" Transitions="false" Height="400" Width="800" Legend-Appearance-Position="Bottom" CssClass="whiteBack">
                <ChartTitle>
                    <Appearance Visible="true">
                        <TextStyle FontSize="16px"></TextStyle>
                    </Appearance>
                </ChartTitle>
                <Legend>
                    <Appearance Visible="true">
                    </Appearance>
                </Legend>
                <PlotArea>
                    <YAxis Visible="true">
                        <TitleAppearance Text="Počet zaměstnanců">
                            <TextStyle FontSize="12px"></TextStyle>
                        </TitleAppearance>
                    </YAxis>
                    <XAxis Visible="true" DataLabelsField="stup_vzdel">
                        <TitleAppearance Text="Vzdělání">
                            <TextStyle FontSize="12px"></TextStyle>
                        </TitleAppearance>
                    </XAxis>
                    <Series>
                        <telerik:BarSeries DataFieldY="muzi" Name="Muži">
                        </telerik:BarSeries>
                        <telerik:BarSeries DataFieldY="zeny" Name="Ženy">
                        </telerik:BarSeries>
                    </Series>
                </PlotArea>
                <Navigator>
                    <XAxis Visible="true">
                        <TitleAppearance>
                            <TextStyle FontSize="16px"></TextStyle>
                        </TitleAppearance>
                    </XAxis>
                </Navigator>
            </telerik:RadHtmlChart>
        </div>
    </div>
</asp:Content>
