﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="Pozadavky2.aspx.cs" Inherits="KSPortal.Pozadavky.Pozadavky_Pozadavky2" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<%--<%@ Register Src="../Controls/KalendarControl.ascx" TagName="KalendarControl" TagPrefix="uc1" %>--%>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <style type="text/css">
        div.fullFrame > table > tbody > tr:first-child + tr > td:first-child + td > div, div.fullFrame > table > tbody > tr:first-child + tr > td:first-child + td > div > div, div.fullFrame > table > tbody > tr:first-child + tr > td:first-child + td > div > div > div {
            height: calc(100% - 15px);
            width: 100%;
        }

        div.ksCollPoz {
            display: flex;
        }

            div.ksCollPoz > div {
                height: 20px;
                width: 20px;
                background: url(../Images/staple.png) no-repeat center;
                background-size: 15px 15px;
                font-size: 75%;
                font-weight: bold;
                position: relative;
                line-height: 100%;
                padding-left: 4px;
                cursor: pointer;
            }

                div.ksCollPoz > div > label {
                    position: absolute;
                    bottom: 0;
                    right: 0;
                    cursor: pointer;
                }

        .rgCaption {
            text-align: left !important;
        }

        .ksDisabled, .ksDisabled span {
            color: grey !important;
        }

        .ksNotDisabled {
            opacity: 1 !important;
        }

        form > .RadWindow_Metro, form > .RadWindow_Metro > .rwContent {
            height: fit-content !important;
        }

        .RadGrid_Metro .rgSelectedRow, .rgSelectedRow > td {
            color: var(--kscolor1text) !important;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <script type="text/javascript">
        function onPopulated(sender, e) {
            var finds = sender.get_completionList().childNodes;
            finds[0].parentElement.style.whiteSpace = 'normal';
            finds[0].parentElement.style.maxHeight = '120px';
            finds[0].parentElement.style.padding = '2px';
            finds[0].parentElement.style.position = 'absolute';
            finds[0].parentElement.style.border = '1px solid #808080';
            finds[0].parentElement.style.overflow = 'auto';
            for (var i = 0; i < finds.length; i++) {
                var find = finds[i];
                find.style.backgroundColor = '#FFFFFF';
                find.style.padding = '2px';
                find.style.whiteSpace = 'normal';
                find.style.cursor = 'pointer';
                if (i != (finds.length - 1))
                    find.style.borderBottom = '1px dotted #808080';
            }
        }

        function Change(obj, evt) {
            if (evt.type == "focus") {
                obj.style.borderColor = "red";
                obj.borderWidth = "5px";
                obj.backgroundColor = "red";
            }
            else if (evt.type == "blur") {
                obj.style.borderColor = "black";
                obj.borderWidth = "thin";
                obj.backgroundColor = "black";
            }
        }
    </script>
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            <%--            <telerik:AjaxSetting AjaxControlID="TRadGrid1">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="P_Seznam"  />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="RCM_new_typy">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="P_Seznam" />
                </UpdatedControls>
            </telerik:AjaxSetting>--%>
            <telerik:AjaxSetting AjaxControlID="P_Seznam">
                <UpdatedControls>
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <telerik:RadPersistenceManagerProxy ID="RadPersistenceManagerProxy1" runat="server">
    </telerik:RadPersistenceManagerProxy>
    <telerik:RadAjaxLoadingPanel runat="server" ID="RALP_pozadavky" BackgroundTransparency="70">
    </telerik:RadAjaxLoadingPanel>
    <telerik:RadCodeBlock ID="RadScriptBlockxxx" runat="server">
        <script type="text/javascript" id="telerikClientEvents1">
            //<![CDATA[ 
            var minDate = new Date(1900, 0, 1);
            var maxDate = new Date(2900, 0, 1);
            var performrebind;
            var rebindclicked = false;
            var dataAlreadyLoaded;
            var performevent = true;
            var updateStateOnShow = true;
            var updateStateOnReorder = true;
            var writeSelected = true;
            var stavselected;
            var saveStateTimeOut;
            var lastCommand = "";

            var oldonOsCisloPomChanged = !oldonOsCisloPomChanged ? KSMaster.onOsCisloPomChanged : oldonOsCisloPomChanged;
            KSMaster.onOsCisloPomChanged = function () {
                oldonOsCisloPomChanged.apply();
                $find("<%=TRadGrid1.ClientID %>").get_masterTableView().rebind();
            };
            KSMaster.onOsCisloPomChanged.prototype = oldonOsCisloPomChanged.prototype;

            function GetGridServerElement(serverID, tagName, getMetot) {
                if (!tagName)
                    tagName = "*"; //* means all elements 

                var grid = document.getElementById("<%=TRadGrid1.ClientID %>");
                var elements = grid.getElementsByTagName(tagName);
                for (var i = 0; i < elements.length; i++) {
                    var element = elements[i];
                    if (element.id.indexOf(serverID) >= 0) {
                        var ret = null;
                        if (!getMetot || getMetot == "find") {

                            ret = $find(element.id);
                        }
                        else {
                            ret = $get(element.id);
                        }
                        if (ret) {
                            return ret;
                        }
                    }
                }
                return null;
            }
            function TRadGrid1_OnDataBinding(sender, args) {
                var grid = $find("<%=TRadGrid1.ClientID %>");
                var tableView = grid.get_masterTableView();

                var HF_Filter = GetGridServerElement("HF_Filter", "input", "get");
                var HF_Sort = GetGridServerElement("HF_Sort", "input", "get");
                if (HF_Filter && HF_Sort) {
                    HF_Sort.value = tableView.get_sortExpressions().toString();
                    HF_Filter.value = tableView._filterExpressions.toDynamicLinq();
                }
                var HF_view_id = $get("<%=HF_view_id.ClientID %>");
                var id = HF_view_id.value;

                var TRB_auto_rebind = GetGridServerElement("TRB_auto_rebind", null, null);

                if (!(id == "1" && performrebind && stavselected && (TRB_auto_rebind.get_checked() || rebindclicked || (dataAlreadyLoaded && (lastCommand == "Page" || lastCommand == "PageSize" || lastCommand == "Sort"))))) {
                    args.set_cancel(true);
                }
                rebindclicked = false;

                if (!args._cancel) {
                    updateStatePoz();
                    var loadingPanel = $find("<%= RALP_pozadavky.ClientID %>");
                    if (loadingPanel) {
                        var element = sender.get_masterTableView().get_element();
                        loadingPanel.show("<%= TRadGrid1.ClientID %>");

                        var HF_BackFromDetail = $get("<%=HF_BackFromDetail.ClientID %>");
                        if (HF_BackFromDetail.value == "true") {
                            if (element.classList)
                                element.classList.add('hidden');
                            HF_BackFromDetail.value = "false";
                        }
                    }
                    poz_ids = [];
                }
                //kalClose();
            }
            function _setHF_FilterState(grid) {

                var gridFilterState = {
                    filter: grid.get_masterTableView()._filterExpressions,
                    sort: grid.get_masterTableView().get_sortExpressions()
                }

                if (window.JSON && window.JSON.stringify) {
                    var container = $get("<%= HF_FilterState.ClientID %>");
                    container.value = JSON.stringify(gridFilterState);
                }
            }

            function adresatiLoaded(data) {
                var dataItems = $find('<%=TRadGrid1.ClientID%>').get_masterTableView().get_dataItems();
                for (var i = 0; i < dataItems.length; i++) {
                    var item = dataItems[i];
                    var p_id = item.getDataKeyValue("id_poz");
                    var l = $('#' + item._element.id + ' label#l_adr_text')[0];

                    l.innerHTML = "";
                    l.setAttribute("style", "cursor: default;");
                    l.data = null;
                    l.removeEventListener("mouseenter", showAdresati, false);

                    if (data && data[p_id] && data[p_id].length > 0) {
                        if (data[p_id].length == 1) {
                            l.innerHTML = data[p_id][0];
                        }
                        else {
                            var t = data[p_id][0] + " <b>... " + (data[p_id].length - 1) + "</b>";
                            l.innerHTML = t;
                            l.setAttribute("style", "cursor: pointer;");
                            l.data = data[p_id];
                            l.addEventListener("mouseenter", showAdresati, false);
                        }
                    }
                }
            }
            function showAdresati(evn) {
                var RTT = $find("<%= RTT_adresati.ClientID %>");
                var l = $('label#rtt_l_adresati')[0];

                l.innerHTML = evn.currentTarget.data.join('<br />');
                RTT.set_targetControl(evn.currentTarget);

                setTimeout(function () {
                    RTT.show();
                }, 20);
            }

            function adresatiError(err) {
                adresatiLoaded(null);
                onPageMethodError(err);
            }

            function prilohyIdentLoaded(data) {
                if (data) {
                    var dataItems = $find('<%=TRadGrid1.ClientID%>').get_masterTableView().get_dataItems();
                    for (var i = 0; i < dataItems.length; i++) {
                        var item = dataItems[i];
                        var p_id = item.getDataKeyValue("id_poz");
                        if (data[p_id]) {
                            $('#' + item._element.id + ' div.priloha').removeClass("hidden");
                            $('#' + item._element.id + ' label#l_priloha').text(data[p_id]);
                        }
                        else {
                            $('#' + item._element.id + ' div.priloha').addClass("hidden");
                            $('#' + item._element.id + ' label#l_priloha').text("");
                        }

                    }
                }
            }
            function onPageMethodError(err) {
                if (err) {
                    var title = err.get_exceptionType();
                    var text = err.get_message();
                    if (title)
                        KSMaster.showError(text, title);
                }
            }
            var event;
            function ShowPrilohy(sender, evt) {
                var id_poz = $find($('#' + sender.id).closest('tr.rgRow, tr.rgAltRow')[0].id).getDataKeyValue("id_poz");
                event = evt;
                PageMethods.getPrilohyNames(id_poz, prilohyNamesLoaded, onPageMethodError);
            }

            function prilohyNamesLoaded(data) {
                if (data && data[0]) {
                    var RCM = $find('<%=RCM_prilohy.ClientID%>');
                    var menuItemClass = Telerik.Web.UI.RadMenuItem || Telerik.Web.UI.MobileMenuItem;
                    RCM.trackChanges();
                    RCM.get_items().clear();
                    for (i in data) {
                        var d = data[i];
                        var childItem = new menuItemClass();
                        childItem.set_value([d.Id_vlastnik, d.Id_info_blob]);
                        childItem.set_text(d.Nazev_soubor);
                        childItem.set_enableImageSprite(true);
                        RCM.get_items().insert(i, childItem);
                    }
                    if (data[1]) {
                        var childItemf = new menuItemClass();
                        childItemf.set_value([data[0].Id_vlastnik, '']);
                        childItemf.set_text('<%=KSProgram.Obecne.ReadGlobalResource.ZmenaTextu("[%Všechny přílohy%] ")%>' + data[0].Id_vlastnik + '.zip');
                        childItemf.set_enableImageSprite(true);
                        RCM.get_items().insert(i + 1, childItemf);
                    }
                    RCM.show(event);
                    RCM.commitChanges();

                    $('#' + RCM.get_element().id + '_detached span.rmLeftImage').addClass("rbDownload16 rbPredefinedIcons");
                }
            }

            function RCM_prilohy_ItemClicked(sender, args) {
                PageMethods.getPrilohy(args.get_item().get_value()[0], args.get_item().get_value()[1], args.get_item().get_text(), onPrilohyLoaded);
            }

            function onPrilohyLoaded(data) {
                var byteArray = new Uint8Array(data.d);
                var a = window.document.createElement('a');

                a.href = window.URL.createObjectURL(new Blob([byteArray]));

                a.download = data.nazev;

                document.body.appendChild(a)
                a.click();
                document.body.removeChild(a)
            }

            var poz_ids = [];
            function TRadGrid1_OnRowDataBound(sender, args) {
                var item = args.get_item();
                var data = args.get_dataItem();
                if (data.error) {
                    radalert(data.error, 800, 600, 'Web Service Error', null, null);
                    return;
                }

                poz_ids.push(data.id_poz);

                var TRB_nazev = item.findControl("TRB_nazev");
                TRB_nazev.set_text(data.text);
                TRB_nazev.set_commandArgument(data.id_poz.toString());

                // nastavení viditelnosti tlačítka delete
                var TRB_delete = item.findControl("TRB_delete");
                if (TRB_delete) {
                    TRB_delete.set_visible(data.can_delete);
                    TRB_delete.set_commandArgument(item.get_itemIndex() + ";" + data.id_poz.toString() + ";" + data.typ.toString());
                }

                // nastavení barvy stavu
                args.get_item().get_cell("stav").style.color = data.stav_color;

                // nastavení barvy systémového stavu
                sstavcolor = "";
                switch (data.sys_stav) {
                    case "n":
                        sstavcolor = "#0000ff";
                        break;
                    case "r":
                        sstavcolor = "#ff00ff";
                        break;
                    case "s":
                        sstavcolor = "#ff0000";
                        break;
                    case "o":
                        sstavcolor = "#008000";
                        break;
                    default: sstavcolor = "#000000";
                }

                if (data.expiroval || data.storno) {
                    sstavcolor = "grey";
                    args.get_item().get_cell("stav").style.color = "grey";
                    $('#' + args.get_item()._element.id).addClass("ksDisabled");
                }
                else {
                    $('#' + args.get_item()._element.id).removeClass("ksDisabled");
                }

                args.get_item().get_cell("sys_stav_t").style.color = sstavcolor;

                $('#' + args.get_item()._element.id + ' div.priloha').addClass("hidden");

                // označení řádků
                var sels = getStateJsonData("<%=HF_sel.ClientID %>");
                writeSelected = false;
                if (contains(sels, data.id_poz)) {
                    if (!item.get_selected())
                        item.set_selected(true);
                }
                else {
                    if (item.get_selected())
                        item.set_selected(false);
                }
                writeSelected = true;
            }

            function TRadGrid1_OnDataBound(sender, args) {
                var loadingPanel = $find("<%= RALP_pozadavky.ClientID %>");
                if (loadingPanel) {
                    var element = sender.get_masterTableView().get_element();
                    loadingPanel.hide("<%= TRadGrid1.ClientID %>");
                    if (element.classList)
                        element.classList.remove('hidden');
                }
                //KSMaster.prekladDat(sender.get_element());
                dataAlreadyLoaded = true;

                //deselect pozadavku mimo filter
                var sels = getStateJsonData("<%=HF_sel.ClientID %>");
                if (sels) {
                    sels = sels.filter(x => poz_ids.includes(x));
                    setSelJsonData("<%=HF_sel.ClientID %>", sels);
                }
                setTimeout(function () {
                    PageMethods.getPrilohyIdent(poz_ids, prilohyIdentLoaded, onPageMethodError);
                }, 20);

                PageMethods.getAdresati(poz_ids, adresatiLoaded, adresatiError);
            }

            function contains(a, obj) {
                for (var i in a) {
                    if (a[i] === obj) {
                        return true;
                    }
                }
                return false;
            }
            function TRadGrid1_OnCommand(sender, args) {
                var radGrid = $find('<%= TRadGrid1.ClientID %>');
                var table = radGrid.get_masterTableView();
                lastCommand = args.get_commandName();
                if (lastCommand == "PageSize") {
                    var page_size = args.get_commandArgument();
                    if (page_size)
                        if (page_size > 150) {
                            table.set_pageSize(150);
                            args.set_cancel(true);
                            return;
                        }
                    updateStatePoz();
                    args.set_cancel(true);
                }
                if (lastCommand == "Filter" || lastCommand == "Sort") {
                    _setHF_FilterState(sender);
                    //updateStatePoz();
                }
            }
            function TRadGrid1_OnRowSelecting(sender, args) {
                var expiroval = args.getDataKeyValue("expiroval");
                var storno = args.getDataKeyValue("storno");

                if (expiroval || storno) {
                    args.set_cancel(true);
                }
            }
            function TRadGrid1_OnRowSelected(sender, args) {
                if (writeSelected) {
                    var sels = getStateJsonData("<%=HF_sel.ClientID %>");
                    if (!sels)
                        sels = [];
                    var cur_id = args.getDataKeyValue("id_poz");
                    if (!contains(sels, cur_id)) {
                        sels.push(cur_id);
                    }
                    setSelJsonData("<%=HF_sel.ClientID %>", sels);
                }
            }
            function TRadGrid1_OnRowDeselected(sender, args) {
                if (writeSelected) {
                    var u = args.get_domEvent();
                    if (u.currentTarget) {
                        var hf_sel = $get("<%=HF_sel.ClientID %>");
                        hf_sel.value = "[]";
                        return;
                    }
                    var sels = getStateJsonData("<%=HF_sel.ClientID %>");
                    if (!sels)
                        sels = [];
                    var cur_id = args.getDataKeyValue("id_poz");
                    if (contains(sels, cur_id)) {
                        sels.splice(sels.indexOf(cur_id), 1);
                    }
                    setSelJsonData("<%=HF_sel.ClientID %>", sels);
                }
            }

            function TRadGrid1_OnGridCreated(sender, args) {
                var stateFilter = getStateJsonData("<%= HF_FilterState.ClientID %>");
                var data = getStateJsonData("<%=HF_seznam_state.ClientID %>");
                _setFilters(sender, stateFilter);
                columnsVisibility(sender);
                if (data && data.collorder)
                    columnsOrder(sender, data.collorder);
            }
            function TRB_postback_Clicking(sender, args) {
                restoreOrder();
            }
            function restoreOrder() {
                var table = $find("<%=TRadGrid1.ClientID %>");
                columnsOrder(table, ["smazat", "oznac", "os_cislo", "jmeno", "druh_pom_j", "kmen_str", "id_poz", "text", "typ", "stav", "sys_stav_t", "storno", "adresati", "dat_od", "dat_do", "datum", "vyridit_do", "obdobi", "obdobi_do", "expiroval", "vyriz_datum", "vyriz_user", "skup_str", "cis_divize"]);
            }
            function _setFilters(grid, stateFilter) {
                var TRCB_typ_f = GetGridServerElement("TRCB_typ_f", null, null);
                var TRCB_stav_f = GetGridServerElement("TRCB_stav_f", null, null);
                var TRCB_sys_stav_f = GetGridServerElement("TRCB_sys_stav_f", null, null);
                var TRCB_zadatel_f = GetGridServerElement("TRCB_zadatel_f", null, null);
                var TRMYP_datum_od_f = GetGridServerElement("TRMYP_datum_od_f_dateInput", null, null);
                var TRMYP_datum_do_f = GetGridServerElement("TRMYP_datum_do_f_dateInput", null, null);
                var TRMYP_obdobi_od_f = GetGridServerElement("TRMYP_obdobi_od_f_dateInput", null, null);
                var TRMYP_obdobi_do_f = GetGridServerElement("TRMYP_obdobi_do_f_dateInput", null, null);
                var TRMYP_vyresit_od_f = GetGridServerElement("TRMYP_vyresit_od_f_dateInput", null, null);
                var TRMYP_vyresit_do_f = GetGridServerElement("TRMYP_vyresit_do_f_dateInput", null, null);

                var HF_id_poz = $get("<%=HF_id_poz.ClientID %>");
                var id_poz = HF_id_poz.value;
                if (id_poz != 0) {
                    AddFilterExpression(grid, "id_poz", "id_poz", Telerik.Web.UI.GridFilterFunction.EqualTo, "System.Int32", id_poz);
                }
                if (!stateFilter) {
                    var stdata = getStateJsonData("<%=HF_seznam_state.ClientID %>");
                    if (stdata && stdata.filter) {
                        stateFilter = stdata.filter;
                        if (stateFilter && stateFilter.filter) {
                            if (stateFilter.filter._array.length < 7) {
                                stateFilter = null;
                            }
                        }
                    }
                }
                if (stateFilter && stateFilter.filter) {
                    performrebind = false;
                    performevent = false;
                    for (var i in stateFilter.filter._array) {
                        var fexpr = stateFilter.filter._array[i];
                        if (fexpr.FieldName == "typ") {
                            var zitem = TRCB_typ_f.findItemByValue(fexpr.FieldValue);
                            if (zitem) {
                                zitem.select();
                            }
                        }
                        if (fexpr.FieldName == "stav") {
                            TRCB_stav_f.set_value(fexpr.FieldValue);
                        }
                        if (fexpr.FieldName == "sys_stav_t") {
                            var itemsch = TRCB_sys_stav_f.get_items();
                            for (var ich = 0; ich < itemsch.get_count(); ich++) {
                                itemsch.getItem(ich).set_checked(fexpr.FieldValue.indexOf(itemsch.getItem(ich).get_value()) > -1);
                            }
                        }
                        if (fexpr.FieldName == "zadatel") {
                            var zitem = TRCB_zadatel_f.findItemByValue(fexpr.FieldValue);
                            if (zitem) {
                                zitem.select();
                            }
                        }
                        if (fexpr.FieldName == "datum") {
                            TRMYP_datum_od_f.set_selectedDate(_setDbSelectedDate(fexpr.FieldValue.split(" ")[0]));
                            TRMYP_datum_do_f.set_selectedDate(_setDbSelectedDate(fexpr.FieldValue.split(" ")[1]));
                        }
                        if (fexpr.FieldName == "obdobi") {
                            TRMYP_obdobi_od_f.set_selectedDate(_setDbSelectedDate(fexpr.FieldValue.split(" ")[0], true));
                            TRMYP_obdobi_do_f.set_selectedDate(_setDbSelectedDate(fexpr.FieldValue.split(" ")[1], true));
                        }
                        if (fexpr.FieldName == "vyridit_do") {
                            TRMYP_vyresit_od_f.set_selectedDate(_setDbSelectedDate(fexpr.FieldValue.split(" ")[0]));
                            TRMYP_vyresit_do_f.set_selectedDate(_setDbSelectedDate(fexpr.FieldValue.split(" ")[1]));
                        }
                        AddFilterExpression(grid, fexpr.ColumnUniqueName, fexpr.FieldName, fexpr.FilterFunction, fexpr.DataTypeName, fexpr.FieldValue);
                    }
                    performevent = true;
                    performrebind = true;
                }
                else {
                    //nastavení filtrů podle kontrolek
                    AddFilterExpression(grid, "typ", "typ", Telerik.Web.UI.GridFilterFunction.EqualTo, "System.String", TRCB_typ_f.get_value());

                    var stav = TRCB_stav_f.get_value();
                    if (stav == "")
                        stav = "vse";
                    AddFilterExpression(grid, "stav", "stav", Telerik.Web.UI.GridFilterFunction.EqualTo, "System.String", stav);

                    var valuech = "";
                    var itemsch = TRCB_sys_stav_f.get_checkedItems();
                    if (itemsch.length == 0 || itemsch.length == 4) {
                        valuech = "";
                    }
                    else {
                        for (var i in itemsch) {
                            valuech += itemsch[i].get_value() + ",";
                        }
                    }
                    valuech = valuech.length > 0 ? valuech.substring(0, valuech.length - 1) : valuech;
                    AddFilterExpression(grid, "sys_stav_t", "sys_stav_t", Telerik.Web.UI.GridFilterFunction.EqualTo, "System.String", valuech);

                    AddFilterExpression(grid, "zadatel", "zadatel", Telerik.Web.UI.GridFilterFunction.EqualTo, "System.String", TRCB_zadatel_f.get_value());

                    var TRMYP_datum_od_f = getNotNullDate(TRMYP_datum_od_f.get_selectedDate(), minDate);
                    var TRMYP_datum_do_f = getNotNullDate(TRMYP_datum_do_f.get_selectedDate(), maxDate);
                    AddFilterExpression(grid, "datum", "datum", Telerik.Web.UI.GridFilterFunction.Between, "System.DateTime", (getObdobiFirst(TRMYP_datum_od_f).format("yyyy-MM-dd") + " " + getObdobiLast(TRMYP_datum_do_f).format("yyyy-MM-dd")));

                    var TRMYP_obdobi_od_f = getNotNullDate(TRMYP_obdobi_od_f.get_selectedDate(), minDate);
                    var TRMYP_obdobi_do_f = getNotNullDate(TRMYP_obdobi_do_f.get_selectedDate(), maxDate);
                    AddFilterExpression(grid, "obdobi", "obdobi", Telerik.Web.UI.GridFilterFunction.Between, "System.DateTime", (getObdobiFirst(TRMYP_obdobi_od_f).format("yyyy-MM-dd") + " " + getObdobiLast(TRMYP_obdobi_do_f).format("yyyy-MM-dd")));

                    var TRMYP_vyresit_od_f = getNotNullDate(TRMYP_vyresit_od_f.get_selectedDate(), minDate);
                    var TRMYP_vyresit_do_f = getNotNullDate(TRMYP_vyresit_do_f.get_selectedDate(), maxDate);
                    AddFilterExpression(grid, "vyridit_do", "vyridit_do", Telerik.Web.UI.GridFilterFunction.Between, "System.DateTime", (getObdobiFirst(TRMYP_vyresit_od_f).format("yyyy-MM-dd") + " " + getObdobiLast(TRMYP_vyresit_do_f).format("yyyy-MM-dd")));

                    stavselected = true;
                    performrebind = true;
                }
                if (stateFilter && stateFilter.sort) {
                    for (var i in stateFilter.sort._array) {
                        var sortexpr = stateFilter.sort._array[i];
                        AddSortExpression(grid, sortexpr.FieldName, sortexpr.SortOrder);
                    }
                }
            }
            function _setDbSelectedDate(datetext, notnull) {
                var y = datetext.split("-")[0];
                var m = datetext.split("-")[1] - 1;
                var d = datetext.split("-")[2];
                var date = new Date(y, m, d);
                if (date >= maxDate || date <= minDate) {
                    if (notnull) {
                        return new Date(new Date().getFullYear(), new Date().getMonth(), new Date().getDay());
                    }
                    else {
                        return null;
                    }
                }
                else
                    return date;
            }

            function AddSortExpression(grid, fieldName, sortOrder) {
                var sortExpression = new Telerik.Web.UI.GridSortExpression();
                sortExpression.set_fieldName(fieldName);
                sortExpression.set_sortOrder(sortOrder);
                grid.get_masterTableView()._sortExpressions.add(sortExpression);
                grid.get_masterTableView()._showSortIconForField(fieldName, sortOrder);
            }

            function AddFilterExpression(grid, columnUniqueName, dataField, filterFunction, filterDataType, filterValue) {
                var filterExpression = new Telerik.Web.UI.GridFilterExpression();
                var founded = 0;
                //if (dataField == "zadatel" || dataField == "") {
                var foundExp = $.grep(grid.get_masterTableView()._filterExpressions._array, function (e) { return e.FieldName == dataField; });
                founded = foundExp.length;
                if (founded != 0) {
                    filterExpression = foundExp[0];
                }
                //}

                var column = grid.get_masterTableView().getColumnByUniqueName(columnUniqueName);
                if (column != null)
                    column.set_filterFunction("Contains");
                filterExpression.set_fieldName(dataField);
                filterExpression.set_fieldValue(filterValue);
                filterExpression.set_dataTypeName(filterDataType);
                filterExpression.set_filterFunction(filterFunction);
                filterExpression.set_columnUniqueName(columnUniqueName);
                if (column != null &&
                    columnUniqueName != "typ" &&
                    columnUniqueName != "sys_stav_t" &&
                    columnUniqueName != "datum" &&
                    columnUniqueName != "obdobi" &&
                    columnUniqueName != "vyridit_do") {
                    if (filterDataType === "System.DateTime") {
                        var input = $get("ctl00_HlavniOblast_TRadGrid1_ctl00_ctl02_ctl04_RDIPF" + columnUniqueName + "_dateInput");
                        if (input)
                            input.value = filterValue;
                    }
                    else {
                        grid.get_masterTableView()._updateFilterControlValue(filterValue, columnUniqueName, filterFunction);
                    }
                }
                if (founded == 0) {
                    grid.get_masterTableView()._filterExpressions.add(filterExpression);
                }
            }
            function TRB_rebind_Clicked(sender, args) {
                rebindclicked = true;
                $find("<%=TRadGrid1.ClientID %>").get_masterTableView().rebind();
                rebindclicked = false;
            }
            function TRB_auto_rebind_Clicked(sender, args) {
                $find("<%=TRadGrid1.ClientID %>").get_masterTableView().rebind();
            }
            function TRB_auto_rebind_CheckedChanged(sender, args) {
                PageMethods.TRB_auto_rebind_SaveState(args.get_checked());
            }

            function TRB_clear_filters_Clicked(sender, args) {
                var grid = $find("<%=TRadGrid1.ClientID %>");
                var columns = grid.get_masterTableView().get_columns();
                performrebind = false;
                for (var i = 0; i < columns.length; i++) {
                    grid.get_masterTableView().clearFilter(columns[i].get_uniqueName());
                }

                var obdobi = $get("<%=HF_obdobi.ClientID %>");
                var res = obdobi.value.split(",");
                var obdobiDT = new Date(parseInt(res[0]), parseInt(res[1]) - 1, parseInt(res[2]));
                var filtercollection = grid.get_masterTableView()._filterExpressions;
                filtercollection.clear();
                filtercollection.add(_createFilterExpressionToCollection("zadatel", "zadatel", Telerik.Web.UI.GridFilterFunction.EqualTo, "System.String", "mekvyrizeni"));
                filtercollection.add(_createFilterExpressionToCollection("typ", "typ", Telerik.Web.UI.GridFilterFunction.EqualTo, "System.String", "vse"));
                filtercollection.add(_createFilterExpressionToCollection("stav", "stav", Telerik.Web.UI.GridFilterFunction.EqualTo, "System.String", "vse"));
                filtercollection.add(_createFilterExpressionToCollection("sys_stav_t", "sys_stav_t", Telerik.Web.UI.GridFilterFunction.EqualTo, "System.String", ""));
                filtercollection.add(_createFilterExpressionToCollection("datum", "datum", Telerik.Web.UI.GridFilterFunction.Between, "System.DateTime", minDate.toMysqlFormat() + " " + maxDate.toMysqlFormat()));
                filtercollection.add(_createFilterExpressionToCollection("vyridit_do", "vyridit_do", Telerik.Web.UI.GridFilterFunction.Between, "System.DateTime", minDate.toMysqlFormat() + " " + maxDate.toMysqlFormat()));
                filtercollection.add(_createFilterExpressionToCollection("obdobi", "obdobi", Telerik.Web.UI.GridFilterFunction.Between, "System.DateTime", getObdobiFirst(obdobiDT).toMysqlFormat() + " " + maxDate.toMysqlFormat())); //getObdobiFirst(new Date()).toMysqlFormat() + " " + maxDate.toMysqlFormat())); //getObdobiFirst(new Date(new Date().getFullYear(), new Date().getMonth() + 4, 1)).toMysqlFormat()
                var gridFilterState = {
                    filter: filtercollection,
                    sort: []
                }
                performrebind = true;
                _setFilters(grid, gridFilterState);
            }

            Date.prototype.toMysqlFormat = function () {
                return this.getFullYear() + "-" + twoDigits(1 + this.getMonth()) + "-" + twoDigits(this.getDate());
                function twoDigits(d) {
                    if (0 <= d && d < 10) return "0" + d.toString();
                    if (-10 < d && d < 0) return "-0" + (-1 * d).toString();
                    return d.toString();
                }
            };
            function _createFilterExpressionToCollection(columnUniqueName, dataField, filterFunction, filterDataType, filterValue) {
                var filterExpression = new Telerik.Web.UI.GridFilterExpression();
                filterExpression.set_fieldName(dataField);
                filterExpression.set_fieldValue(filterValue);
                filterExpression.set_filterFunction(filterFunction);
                filterExpression.set_columnUniqueName(columnUniqueName);
                filterExpression.set_dataTypeName(filterDataType);
                return filterExpression;
            }
            function RCB_zmena_stavu_ItemsRequesting(sender, args) {
                var context = args.get_context();
                var grid = $find("<%=TRadGrid1.ClientID %>");
                var tableView = grid.get_masterTableView();
                context["FilterString"] = tableView._filterExpressions.toDynamicLinq();

                var ids = getStateJsonData("<%=HF_sel.ClientID %>");
                if (!ids)
                    ids = [];
                context["Ids"] = ids;
            }
            function RCB_zmena_stavu_DropDownClosed(sender, args) {
                sender.clearItems();
            }
            function RCB_zmena_stavu_SelectedIndexChanged(sender, args) {
                var stav = args.get_item().get_value();
                var duvod = GetGridServerElement("RTB_duvod", "", "find").get_value();

                if (stav != "" && stav != "error") {
                    var grid = $find("<%=TRadGrid1.ClientID %>");
                    var tableView = grid.get_masterTableView();
                    var filterExpession = tableView._filterExpressions.toDynamicLinq();

                    var HF_selValue = $get("<%=HF_sel.ClientID %>").value;

                    PageMethods.HromadnaZmenaStavu(stav, duvod, filterExpession, HF_selValue, function () { tableView.rebind(); });
                }
                sender.clearItems();
                sender.clearSelection();
            }
            function CheckDates(sender, d_od, d_do, maxinterval) {
                if (d_od.get_selectedDate() != null && d_do.get_selectedDate() != null) {
                    if (sender._clientID.indexOf("_od_f_") >= 0) {
                        if (getObdobiFirst(d_od.get_selectedDate()) > getObdobiLast(d_do.get_selectedDate())) {
                            performrebind = false;
                            d_do.set_selectedDate(d_od.get_selectedDate(), false);
                            performrebind = true;
                        }
                        if (maxinterval) {
                            if (addMonth(getObdobiFirst(d_od.get_selectedDate()), maxinterval) < getObdobiLast(d_do.get_selectedDate())) {
                                performrebind = false;
                                d_do.set_selectedDate(addMonth(d_od.get_selectedDate(), maxinterval), false);
                                performrebind = true;
                            }
                        }
                    }
                    if (sender._clientID.indexOf("_do_f_") >= 0) {
                        if (getObdobiLast(d_do.get_selectedDate()) < getObdobiFirst(d_od.get_selectedDate())) {
                            performrebind = false;
                            d_od.set_selectedDate(d_do.get_selectedDate(), false);
                            performrebind = true;
                        }
                        if (maxinterval) {
                            if (addMonth(getObdobiLast(d_do.get_selectedDate()), -maxinterval) > getObdobiFirst(d_od.get_selectedDate())) {
                                performrebind = false;
                                d_od.set_selectedDate(addMonth(d_do.get_selectedDate(), -maxinterval), false);
                                performrebind = true;
                            }
                        }
                    }
                }
            }
            function addMonth(date, months) {
                return new Date(date.setMonth(date.getMonth() + months))
            }
            function NextMonth(e, button) {
                var monthyearPicker = getMYPicker(button);
                var selectedDate = monthyearPicker.get_selectedDate();
                if (selectedDate == null) {
                    return false;
                }
                var year = (selectedDate.getFullYear());
                var month = (selectedDate.getMonth() + 1);
                var date = selectedDate.getDate();
                monthyearPicker.set_selectedDate(new Date(year, month, date));
            }

            function PrevMonth(e, button) {
                var monthyearPicker = getMYPicker(button);
                var selectedDate = monthyearPicker.get_selectedDate();
                if (selectedDate == null) {
                    return false;
                }
                var year = (selectedDate.getFullYear());
                var month = (selectedDate.getMonth() - 1);
                var date = selectedDate.getDate();
                monthyearPicker.set_selectedDate(new Date(year, month, date));
            }
            function getMYPicker(button) {
                if (button.id.indexOf("TIB_datum_od") >= 0) {
                    return GetGridServerElement("TRMYP_datum_od_f", null, null);
                }
                if (button.id.indexOf("TIB_datum_do") >= 0) {
                    return GetGridServerElement("TRMYP_datum_do_f", null, null);
                }
                if (button.id.indexOf("TIB_vyresit_od") >= 0) {
                    return GetGridServerElement("TRMYP_vyresit_od_f", null, null);
                }
                if (button.id.indexOf("TIB_vyresit_do") >= 0) {
                    return GetGridServerElement("TRMYP_vyresit_do_f", null, null);
                }
                if (button.id.indexOf("TIB_obdobi_od") >= 0) {
                    return GetGridServerElement("TRMYP_obdobi_od_f", null, null);
                }
                if (button.id.indexOf("TIB_obdobi_do") >= 0) {
                    return GetGridServerElement("TRMYP_obdobi_do_f", null, null);
                }
            }
            function getNotNullDate(date, value) {
                if (date)
                    return date;
                else
                    return value;
            }
            function getObdobiFirst(date) {
                var year = date.getFullYear();
                var month = date.getMonth();
                var date = 1;

                return new Date(year, month, date);
            }
            function getObdobiLast(date) {
                var year = date.getFullYear();
                var month = date.getMonth();
                var date = 1;

                int_d = new Date(year, month + 1, date);
                return new Date(int_d - 1);
            }

            function TRadGrid1_OnColumnShown(sender, args) {
                updateStatePoz();
            }

            function TRadGrid1_OnColumnHidden(sender, args) {
                updateStatePoz();
            }
            function TRadGrid1_OnColumnSwapped(sender, args) {
                if (updateStateOnReorder)
                    updateStatePoz();
            }
            function updateStatePoz() {
                if (updateStateOnShow) {
                    var container = $get("<%=HF_seznam_state.ClientID %>")
                    var radGrid = $find('<%= TRadGrid1.ClientID %>');
                    var table = radGrid.get_masterTableView();
                    var wndStateColls =
                    {
                        smazat: table.getColumnByUniqueName("smazat").get_visible(),
                        oznac: table.getColumnByUniqueName("oznac").get_visible(),
                        id_poz: table.getColumnByUniqueName("id_poz").get_visible(),
                        text: table.getColumnByUniqueName("text").get_visible(),
                        typ: table.getColumnByUniqueName("typ").get_visible(),
                        dat_od: table.getColumnByUniqueName("dat_od").get_visible(),
                        dat_do: table.getColumnByUniqueName("dat_do").get_visible(),
                        datum: table.getColumnByUniqueName("datum").get_visible(),
                        vyridit_do: table.getColumnByUniqueName("vyridit_do").get_visible(),
                        obdobi: table.getColumnByUniqueName("obdobi").get_visible(),
                        obdobi_do: table.getColumnByUniqueName("obdobi_do").get_visible(),
                        os_cislo: table.getColumnByUniqueName("os_cislo").get_visible(),
                        jmeno: table.getColumnByUniqueName("jmeno").get_visible(),
                        kmen_str: table.getColumnByUniqueName("kmen_str").get_visible(),
                        druh_pom_j: table.getColumnByUniqueName("druh_pom_j").get_visible(),
                        stav: table.getColumnByUniqueName("stav").get_visible(),
                        sys_stav_t: table.getColumnByUniqueName("sys_stav_t").get_visible(),
                        vyriz_datum: table.getColumnByUniqueName("vyriz_datum").get_visible(),
                        vyriz_user: table.getColumnByUniqueName("vyriz_user").get_visible(),
                        skup_str: table.getColumnByUniqueName("skup_str").get_visible(),
                        cis_divize: table.getColumnByUniqueName("cis_divize").get_visible(),
                        adresati: table.getColumnByUniqueName("adresati").get_visible(),
                        expiroval: table.getColumnByUniqueName("expiroval").get_visible(),
                        storno: table.getColumnByUniqueName("storno").get_visible()
                    }

                    var columns = table.get_columns();
                    var poradi = [];
                    for (var i = 0; i < columns.length; i++) {
                        poradi.push(columns[i].get_uniqueName());
                    }

                    //odstraneni datumu z pole pro ukladani
                    <%--var objekt_filtru = getStateJsonData("<%= HF_FilterState.ClientID %>")
                    var objekt_filtru_new = getStateJsonData("<%= HF_FilterState.ClientID %>")
                    if (objekt_filtru != null){
                        for (i =  objekt_filtru.filter._array.length -1; i >= 0; i--) {
                            var field = objekt_filtru.filter._array[i]._fieldName;
                            if (field == 'datum' || field == 'vyridit_do' || field == 'obdobi')
                            {
                                objekt_filtru_new.filter._array.splice(i,1);
                            }

                        }
                    }--%>





                    var wndState =
                    {
                        pageSize: table.get_pageSize(),
                        collvisible: wndStateColls,
                        filter: getStateJsonData("<%= HF_FilterState.ClientID %>"),
                        collorder: poradi
                    }
                    if (window.JSON && window.JSON.stringify) //in case the browser supports JSON natively (modern browsers, IE8 and above)
                    {
                        container.value = JSON.stringify(wndState);
                        if (saveStateTimeOut)
                            clearTimeout(saveStateTimeOut);
                        saveStateTimeOut = setTimeout(function () { PageMethods.SaveStateSeznam(container.value); }, 500);
                    }
                    //                    else //the browser does not support JSON natively, create the string manually or use an external library
                    //                    {
                    //                        container.value = "{\"can_delete\":" + wndState.can_delete + ",\"id_poz\":" + wndState.id_poz + ",\"text\":" + wndState.text + ",\"typ\":" + wndState.typ + ",\"dat_od\":" + wndState.dat_od + ",\"dat_do\":" + wndState.dat_do + ",\"datum\":" + wndState.datum + ",\"vyridit_do\":" + wndState.vyridit_do + ",\"obdobi\":" + wndState.obdobi + ",\"os_cislo\":" + wndState.os_cislo + ",\"prijmeni\":" + wndState.prijmeni + ",\"jmeno\":" + wndState.jmeno + ", \"kmen_str\":" + wndState.kmen_str + ",\"stav\":" + wndState.stav + ",\"vyriz_datum\":" + wndState.vyriz_datum + ",\"vyriz_user\":" + wndState.vyriz_user + "}";
                    //                    }
                }
            }
            function getStateJsonData(hf_id) {
                var stateStr = $get(hf_id).value;
                if (stateStr)
                    try {
                        return $telerik.$.parseJSON(stateStr);
                    }
                    catch (err) {
                        return null;
                    }
                else
                    return null;
            }
            function setSelJsonData(hf_id, obj) {
                var hf_sel = $get(hf_id);
                if (window.JSON && window.JSON.stringify) //in case the browser supports JSON natively (modern browsers, IE8 and above)
                {
                    hf_sel.value = JSON.stringify(obj);
                }
                else //the browser does not support JSON natively, create the string manually or use an external library
                {
                    var ser = "[";
                    for (var i in obj)
                        ser += obj[i].toString() + ",";
                    ser = ser.substring(0, ser.length - 1);
                    ser += "]";
                    hf_sel.value = ser;
                }
            }
            function columnsOrder(grid, collorder) {
                var tableView = grid.get_masterTableView();
                if (tableView) {
                    var columns = tableView.get_columns();
                    updateStateOnReorder = false;
                    if (collorder)
                        for (var i in collorder) {
                            var from = collorder[i];
                            if (columns[i]) {
                                var to = columns[i].get_uniqueName();
                                if (to && from != to) {
                                    tableView.reorderColumns(from, to);
                                    columns = tableView.get_columns();
                                }
                            }
                        }
                    updateStateOnReorder = true;
                }
            }
            function columnsVisibility(grid) {
                var tableView = grid.get_masterTableView();
                var data = getStateJsonData("<%=HF_seznam_state.ClientID %>");
                updateStateOnShow = false;

                if (tableView) {
                    if (data) {
                        if (data.pageSize) {
                            if (tableView.get_pageSize() != data.pageSize)
                                tableView.set_pageSize(data.pageSize);
                        }
                        else {
                            tableView.set_pageSize(20);
                        }
                    }
                    else {
                        tableView.set_pageSize(20);
                    }
                }
                if (data) {
                    var cols = tableView.get_columns();
                    for (var key in data.collvisible) {
                        if (data.collvisible.hasOwnProperty(key)) {
                            var colum = tableView.getColumnByUniqueName(key);
                            if (colum) {
                                var index = getCollIndex(key, cols);
                                if (colum.get_visible() != data.collvisible[key]) {
                                    if (data.collvisible[key]) {
                                        tableView.showColumn(index);
                                    }
                                    else {
                                        tableView.hideColumn(index);
                                    }
                                }
                            }
                        }
                    }
                }
                updateStateOnShow = true;
            }
            function getCollIndex(key, cols) {
                for (var i = 0; i < cols.length; i++) {
                    if (cols[i].get_uniqueName() == key) {
                        return i;
                    }
                }
                return 0;
            }
            function TRadGrid1_OnRowDblClick(sender, args) {
                var radGrid = $find('<%= TRadGrid1.ClientID %>');
                var table = radGrid.get_masterTableView();
                var button = GetGridServerElement("RB_row_command", "", "find");
                button.set_commandName("detail");
                button.set_commandArgument(args.getDataKeyValue("id_poz").toString());
                button.click(true);
            }

            function TRB_delete_ClientClicked(sender, args) {
                var arg = args.get_commandArgument().split(';');
                var radGrid = $find('<%= TRadGrid1.ClientID %>');
                var table = radGrid.get_masterTableView();
                PageMethods.SmazatPozadavek(arg[1], arg[2], DeleteSucces, DeleteFailed);

            }

            function DeleteSucces(args) {
                var radGrid = $find('<%= TRadGrid1.ClientID %>');
                var table = radGrid.get_masterTableView();
                rebindclicked = true;
                table.rebind();
                rebindclicked = false;
            }
            function DeleteFailed(args) {

            }
            /*
            function TRCB_AdresatJmeno_ItemsRequesting(sender, args) {
                var context = args.get_context();
                context["contextKey"] = "poz_adresat";
            }
            */
            function showTypyPozMenu(sender, args) {
                var contextMenu = $find('<%= RCM_new_typy.ClientID %>');
                if (contextMenu) {
                    var currentLocation = $telerik.getBounds(sender.get_element());
                    contextMenu.showAt(currentLocation.x, currentLocation.y + currentLocation.height);
                }
            }
            function TRMYP_datum_keyPress(sender, args) {//enter na datumech s sipkama
                var c = args.get_keyCode();
                if (c == 13) {
                    args.set_cancel(true);
                    sender.blur();
                    sender.Owner.hidePopup();
                }
            }

            function TRMYP_datum_Blur(sender, args) {
                if (sender.get_value() == "" && (sender.get_textBoxValue() == "" || sender.get_textBoxValue() == "od" || sender.get_textBoxValue() == "do")) {
                    sender.set_value(new Date());
                }
            }

            function TRadGrid1_DataBindingFailed(sender, args) {
                var loadingPanel = $find("<%= RALP_pozadavky.ClientID %>");
                if (loadingPanel) {
                    var element = sender.get_masterTableView().get_element();
                    loadingPanel.hide("<%= TRadGrid1.ClientID %>");
                    if (element.classList)
                        element.classList.remove('hidden');
                }
                KSMaster.showError("Message: <b>" + args.get_message() + "</b><br /><br />Stack trace: " + args.get_stackTrace(), args.get_exceptionType());
            }

            //]]>
        </script>
    </telerik:RadCodeBlock>
    <telerik:RadFormDecorator ID="RadFormDecorator2" runat="server" DecorationZoneID="P_Seznam" />
    <telerik:RadCodeBlock ID="RadScriptBlock2" runat="server">
        <script type="text/javascript">
            //Workaround:
            var removeCssClass = Sys.UI.DomElement.removeCssClass;
            Telerik.Web.UI.RadFormDecorator.prototype.set_elementDisabled = function (element, val) {
                var actor = element;
                var nextSibling = element.nextSibling;
                var type = element.type;

                if ((type == "checkbox" || type == "radio") && nextSibling && nextSibling.tagName == "LABEL") {
                    actor = nextSibling;
                }
                else if (type == "button" || type == "reset" || type == "submit" || element.tagName == "BUTTON") {
                    var parent = element.parentNode;
                    if (parent && parent.tagName == "A") {
                        actor = parent;
                        parent.disabled = val;
                    }
                }
                if (val) addCssClass(actor, "rfdInputDisabled");
                else removeCssClass(actor, "rfdInputDisabled");
                try {
                    if (!val && $telerik.isIE && actor.parentNode.disabled) {
                        actor.parentNode.disabled = val;
                    }
                } catch (e) {
                }
            }
        </script>
    </telerik:RadCodeBlock>
    <asp:HiddenField ID="HF_seznam_state" runat="server" />
    <asp:HiddenField ID="HF_id_poz" runat="server" />
    <asp:HiddenField ID="HF_view_id" runat="server" />
    <asp:HiddenField ID="HF_sel" runat="server" />
    <asp:HiddenField ID="HF_FilterState" runat="server" />
    <asp:HiddenField ID="HF_obdobi" runat="server" />
    <asp:ObjectDataSource runat="server" ID="dsStavyPozadavku" OldValuesParameterFormatString="original_{0}"
        SelectMethod="StavyPozadavku" TypeName="KSProgram.Pozadavky.WorkflowProces"></asp:ObjectDataSource>
    <asp:ObjectDataSource runat="server" ID="dsSysStavyPozadavku" OldValuesParameterFormatString="original_{0}"
        SelectMethod="SysStavyPozadavku" TypeName="KSProgram.Pozadavky.WorkflowProces">
        <SelectParameters>
            <asp:Parameter DefaultValue="false" Name="vcetne_vse" Type="Boolean" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="dsTypyPozadavku" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="GetTypy" TypeName="KSProgram.Pozadavky.PozadavkyTypy">
        <SelectParameters>
            <asp:Parameter DefaultValue="true" Name="vcetne_vse" Type="Boolean" />
            <asp:Parameter DefaultValue="true" Name="vcetne_dochazka" Type="Boolean" />
            <asp:Parameter DefaultValue="false" Name="emptyRow" Type="Boolean" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="dsZadatele" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="Zadatele" TypeName="KSProgram.Pozadavky.PozadavekSeznam"></asp:ObjectDataSource>
    <%--<asp:Label ID="nadpis" runat="server" CssClass="nadpis1" Text="[%Požadavky%]"></asp:Label>--%>
    <%--SEZNAM POŽADAVKŮ--%>
    <asp:Panel ID="P_Seznam" runat="server">
        <asp:HiddenField ID="HF_BackFromDetail" Value="false" runat="server" />
        <asp:ObjectDataSource runat="server" ID="ODS_new_typy" SelectMethod="GetTypyNabidkaZalozeni"
            OldValuesParameterFormatString="original_{0}" TypeName="KSProgram.Pozadavky.PozadavkyTypy">
        </asp:ObjectDataSource>
        <telerik:RadContextMenu ID="RCM_new_typy" runat="server"
            DataSourceID="ODS_new_typy"
            DataTextField="typ_text" DataValueField="typ"
            OnItemClick="RCM_new_typy_ItemClick"
            OnClientItemClicking="TRB_postback_Clicking">
            <Targets>
                <telerik:ContextMenuControlTarget ControlID="TRadButton1" />
            </Targets>
        </telerik:RadContextMenu>
        <telerik:RadContextMenu runat="server" ID="RCM_prilohy" OnClientItemClicked="RCM_prilohy_ItemClicked">
        </telerik:RadContextMenu>
        <telerik:RadToolTip runat="server" ID="RTT_adresati" Position="TopRight" HideEvent="LeaveTargetAndToolTip"
            ShowEvent="FromCode" RelativeTo="Element">
            <label id="rtt_l_adresati"></label>
        </telerik:RadToolTip>
        <wc:TRadGrid ID="TRadGrid1" runat="server" AllowFilteringByColumn="True" AutoGenerateColumns="False" AutoFilterWidth="false"
            AllowSorting="True" OnItemDataBound="TRadGrid1_ItemDataBound" PageSize="150" OnItemCreated="TRadGrid1_ItemCreated"
            OnItemCommand="TRadGrid1_ItemCommand" EnableHeaderContextMenu="True" DefaultFilter="true"
            AllowMultiRowSelection="True" AutoFilterControlWidth="false" OnExportCellFormatting="TRadGrid1_ExportCellFormatting">
            <GroupingSettings CaseSensitive="False"
                CollapseAllTooltip="Collapse all groups" />
            <ExportSettings>
                <Pdf PageWidth="">
                </Pdf>
            </ExportSettings>
            <ClientSettings AllowColumnsReorder="True" ReorderColumnsOnClient="true" ColumnsReorderMethod="Reorder">
                <DataBinding Location="../PrivateWebServices/AutoCompleteService.asmx" SelectMethod="GetPozadavky"
                    SortParameterType="Linq" FilterParameterType="Linq" ShowEmptyRowsOnLoad="False">
                </DataBinding>
                <Selecting AllowRowSelect="True" UseClientSelectColumnOnly="True" />
                <ClientEvents OnRowDataBound="TRadGrid1_OnRowDataBound" OnGridCreated="TRadGrid1_OnGridCreated"
                    OnDataBinding="TRadGrid1_OnDataBinding" OnColumnHidden="TRadGrid1_OnColumnHidden"
                    OnColumnShown="TRadGrid1_OnColumnShown" OnCommand="TRadGrid1_OnCommand" OnRowDblClick="TRadGrid1_OnRowDblClick"
                    OnRowDeselected="TRadGrid1_OnRowDeselected"
                    OnRowSelecting="TRadGrid1_OnRowSelecting"
                    OnRowSelected="TRadGrid1_OnRowSelected" OnDataBindingFailed="TRadGrid1_DataBindingFailed"
                    OnDataBound="TRadGrid1_OnDataBound"
                    OnColumnSwapped="TRadGrid1_OnColumnSwapped" />
            </ClientSettings>
            <MasterTableView Caption="[%Požadavky%]" CommandItemDisplay="Top" AllowMultiColumnSorting="False"
                ClientDataKeyNames="id_poz,expiroval,storno" DataKeyNames="id_poz" AllowPaging="True" PageSize="150">
                <%--<PagerStyle AlwaysVisible="True" Mode="NextPrevNumericAndAdvanced" />--%>
                <PagerStyle PageSizes="10;20;50;100;150" AlwaysVisible="True" Mode="NextPrevAndNumeric" />
                <CommandItemTemplate>
                    <table style="padding: 0px; margin: 0px; border-collapse: collapse">
                        <tr>
                            <td>
                                <kspwc:TRadButton ID="TRadButton1" runat="server" Text="[%Vložit nový%]"
                                    AutoPostBack="False" OnClientClicked="showTypyPozMenu" Width="150px">
                                    <Icon PrimaryIconCssClass="fi fi-add"></Icon>
                                </kspwc:TRadButton>
                            </td>
                            <td>
                                <kspwc:TRadButton ID="TRB_rebind" runat="server" Text="[%Načíst%]" AutoPostBack="False" Width="90px"
                                    OnClientClicked="TRB_rebind_Clicked">
                                    <Icon PrimaryIconCssClass="fi fi-rotate-right"></Icon>
                                </kspwc:TRadButton>
                            </td>
                            <td>
                                <kspwc:TRadButton runat="server" ID="TRB_auto_rebind" ToggleType="CheckBox" ButtonType="StandardButton" Text="[%Načítat automaticky%]" AutoPostBack="false"
                                    OnClientClicked="TRB_auto_rebind_Clicked" OnClientCheckedChanged="TRB_auto_rebind_CheckedChanged" OnInit="TRB_auto_rebind_Init" Width="180px">
                                    <ToggleStates>
                                        <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-checkbox" />
                                        <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-square" />
                                    </ToggleStates>
                                </kspwc:TRadButton>
                            </td>
                            <td>
                                <wc:TRadComboBox ID="TRCB_zadatel_f" runat="server" DataSourceID="dsZadatele" DataTextField="zadatel_text"
                                    DataValueField="zadatel" Width="200px" OnClientSelectedIndexChanged="TRCB_zadatel_f_SelectedIndexChanged"
                                    DropDownAutoWidth="Enabled">
                                </wc:TRadComboBox>
                                <telerik:RadScriptBlock ID="RadScriptBlock7" runat="server">
                                    <script type="text/javascript" id="telerikClientEvents3">
                                        function TRCB_zadatel_f_SelectedIndexChanged(sender, args) {
                                            if (performevent) {
                                                var table = $find("<%# TRadGrid1.ClientID %>");
                                                var tableView = $find("<%# TRadGrid1.MasterTableView.ClientID %>");
                                                //tableView.filter("zadatel", args.get_item().get_value(), "EqualTo");
                                                AddFilterExpression(table, "zadatel", "zadatel", Telerik.Web.UI.GridFilterFunction.EqualTo, "System.String", sender.get_value());
                                                _setHF_FilterState(table);
                                                updateStatePoz();
                                                tableView.rebind();
                                            }
                                        }
                                    </script>
                                </telerik:RadScriptBlock>
                            </td>
                            <td style="min-width: 10px"></td>
                            <td>
                                <telerik:RadComboBox ID="RCB_zmena_stavu" runat="server" EmptyMessage="[%Hromadná změna stavu%]"
                                    EnableLoadOnDemand="true" ToolTip="[%Zobrazené požadavky musí být stejného typu, ve stejném stavu a musíte být jejich adresátem%]"
                                    OnItemsRequested="RCB_zmena_stavu_ItemsRequested" OnClientItemsRequesting="RCB_zmena_stavu_ItemsRequesting"
                                    AutoPostBack="False"
                                    Width="200px" DropDownAutoWidth="Enabled"
                                    OnClientDropDownClosed="RCB_zmena_stavu_DropDownClosed"
                                    OnClientSelectedIndexChanged="RCB_zmena_stavu_SelectedIndexChanged">
                                </telerik:RadComboBox>
                            </td>
                            <td>
                                <telerik:RadTextBox runat="server" ID="RTB_duvod" Width="300px" EmptyMessage="[%Důvod%]"></telerik:RadTextBox>
                            </td>
                            <td>
                                <wc:TRadButton ID="RB_row_command" runat="server" CssClass="hidden">
                                </wc:TRadButton>
                            </td>
                            <td>
                                <wc:TRadButton ID="TRB_clear_filters" runat="server" Text="[%Smazat filtry%]" AutoPostBack="False" OnClientClicked="TRB_clear_filters_Clicked">
                                </wc:TRadButton>
                            </td>
                            <td>
                                <wc:TRadButton ID="TRB_clear_nast" runat="server" Text="[%Smazat nastavení%]"
                                    AutoPostBack="True" OnClick="TRB_clear_nast_Click">
                                </wc:TRadButton>
                            </td>
                            <td>
                                <kspwc:ExportGridButton ID="ExportGridButton1" runat="server" TargetControl="TRadGrid1" ShowExportToExcelHtmlItem="false" ShowExportToExcelMLItem="true" ShowExportToWordItem="false" ShowExportToExcelBIFFItem="false" ShowExportToExcelXlsxItem="false" ShowExportToWordDocxItem="False" ShowExportToCsvItem="false" RegistreWithAjaxManager="False" />
                            </td>
                        </tr>
                    </table>
                </CommandItemTemplate>
                <ColumnGroups>
                    <telerik:GridColumnGroup HeaderText="[%Žadatel%]" Name="zad">
                    </telerik:GridColumnGroup>
                    <telerik:GridColumnGroup HeaderText="[%Aktuální stav procesu%]" Name="stav">
                    </telerik:GridColumnGroup>
                </ColumnGroups>
                <Columns>
                    <telerik:GridTemplateColumn UniqueName="smazat" AllowFiltering="False" Groupable="False" Reorderable="False" AllowSorting="false">
                        <ItemTemplate>
                            <wc:TRadButton ID="TRB_delete" runat="server" ConfirmText="[%Opravdu si přejete smazat vybraný záznam?%]" Style="background-color: transparent; border: none !important;"
                                ConfirmTitle="[%Mazání požadavku%]" NotifikaceText="[%Data byla smazána%]" ToolTip="[%Smazat%]" ButtonType="LinkButton" AutoPostBack="false" OnClientClicked="TRB_delete_ClientClicked">
                                <Icon PrimaryIconCssClass="fi fi-trash" PrimaryIconLeft="5px"></Icon>
                            </wc:TRadButton>
                        </ItemTemplate>
                    </telerik:GridTemplateColumn>
                    <telerik:GridClientSelectColumn UniqueName="oznac" Reorderable="False">
                    </telerik:GridClientSelectColumn>
                    <telerik:GridNumericColumn DataField="os_cislo" DataType="System.Decimal" DecimalDigits="0"
                        FilterControlAltText="Filter os_cislo column" HeaderText="[%Os. číslo%]" UniqueName="os_cislo"
                        FilterControlWidth="80px" Groupable="False">
                    </telerik:GridNumericColumn>
                    <telerik:GridBoundColumn DataField="jmeno" FilterControlAltText="Filter jmeno column" SortExpression="prijmeni" DataType="System.String"
                        HeaderText="[%Jméno%]" UniqueName="jmeno" FilterControlWidth="50px" Groupable="False">
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn DataField="druh_pom_j" FilterControlAltText="Filter druh_pom_j column" Display="false"
                        HeaderText="[%Druh pom.%]" UniqueName="druh_pom_j" FilterControlWidth="30px" Groupable="False">
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn DataField="kmen_str" FilterControlAltText="Filter kmen_str column" Display="false"
                        HeaderText="[%Kmen. stř.%]" UniqueName="kmen_str" FilterControlWidth="80px" Groupable="False">
                    </telerik:GridBoundColumn>
                    <%--KM 12.4.2016 Nastavení maximální hodnoty pro sloupec kvůli filtrování --%>
                    <telerik:GridNumericColumn DataField="id_poz" DataType="System.Int32" DecimalDigits="0" MaxValue="2147483647" MinValue="-2147483648"
                        FilterControlAltText="Filter id_poz column" HeaderText="[%Id%]" UniqueName="id_poz" Display="false"
                        AllowFiltering="True" FilterControlWidth="70px" Groupable="False">
                    </telerik:GridNumericColumn>
                    <%--<telerik:GridBoundColumn DataField="text" FilterControlAltText="Filter text column"
                                    HeaderText="[%Požadavek%]" UniqueName="text" FilterControlWidth="50px">
                                </telerik:GridBoundColumn>--%>
                    <%--<telerik:GridButtonColumn UniqueName="text" SortExpression="text" FilterControlAltText="Filter text column"
                                    HeaderText="[%Požadavek%]" CommandName="detail_link" DataTextField="text" 
                                    Text="text">
                                </telerik:GridButtonColumn>--%>
                    <telerik:GridTemplateColumn DataField="text" FilterControlAltText="Filter text column"
                        HeaderText="[%Požadavek%]" UniqueName="text" SortExpression="text" Groupable="False">
                        <ItemTemplate>
                            <div class="ksCollPoz">
                                <wc:TRadButton ID="TRB_nazev" runat="server" ButtonType="LinkButton" CommandName="detail"
                                    OnClientClicking="TRB_postback_Clicking" HoveredCssClass="ksHoverPoz" Icon-PrimaryIconCssClass="fi fi-eye">
                                </wc:TRadButton>
                                <div id="div_priloha" runat="server" class="priloha hidden" onclick="ShowPrilohy(this, event);">
                                    <label id="l_priloha" onclick="ShowPrilohy(this, event);"></label>
                                </div>
                            </div>
                        </ItemTemplate>
                    </telerik:GridTemplateColumn>
                    <telerik:GridBoundColumn CurrentFilterFunction="EqualTo" CurrentFilterValue="vse"
                        DataField="typ" FilterControlAltText="Filter typ column" HeaderText="[%Typ%]"
                        UniqueName="typ" Groupable="False">
                        <FilterTemplate>
                            <wc:TRadComboBox ID="TRCB_typ_f" runat="server" DataSourceID="dsTypyPozadavku" DataTextField="typ_text"
                                DataValueField="typ" DropDownAutoWidth="Enabled" OnClientSelectedIndexChanged="TRCB_typ_f_SelectedIndexChanged"
                                Width="100px">
                            </wc:TRadComboBox>
                            <telerik:RadScriptBlock ID="RadScriptBlock3" runat="server">
                                <script id="telerikClientEvents2" type="text/javascript">
                                    function TRCB_typ_f_SelectedIndexChanged(sender, args) {
                                        if (performevent) {
                                            stavselected = false;
                                            var value = args.get_item().get_value();
                                            var tableView = $find("<%# ((GridItem)Container).OwnerTableView.ClientID %>");
                                            tableView.filter("typ", value, "EqualTo");
                                            if (value == 'vse') {
                                                var TRMYP_obdobi_od_f = GetGridServerElement("TRMYP_obdobi_od_f_dateInput", null, null);
                                                TRMYP_obdobi_f_OnDateSelected(TRMYP_obdobi_od_f, args)
                                            }

                                        }
                                        var TRCB_stav_f = $find('<%# ((GridItem)Container).FindControl("TRCB_stav_f").ClientID %>');
                                        TRCB_stav_f.requestItems("vse", false);
                                    }
                                </script>
                            </telerik:RadScriptBlock>
                        </FilterTemplate>
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn DataField="stav" FilterControlAltText="Filter stav column"
                        HeaderText="[%Stav%]" UniqueName="stav" CurrentFilterFunction="EqualTo" CurrentFilterValue="vse"
                        Groupable="False">
                        <FilterTemplate>
                            <wc:TRadComboBox ID="TRCB_stav_f" runat="server" Width="100" OnClientSelectedIndexChanged="TRCB_stav_f_SelectedIndexChanged"
                                EnableLoadOnDemand="false" EnableVirtualScrolling="true" Height="150" ShowMoreResultsBox="true"
                                DropDownAutoWidth="Enabled" OnClientItemsRequesting="TRCB_stav_f_ItemsRequesting"
                                OnClientItemsRequested="TRCB_stav_f_ItemsRequested">
                                <WebServiceSettings Method="GetStavyPoz" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                            </wc:TRadComboBox>
                            <telerik:RadScriptBlock ID="RadScriptBlock8" runat="server">
                                <script type="text/javascript" id="telerikClientEvents3">
                                    function TRCB_stav_f_SelectedIndexChanged(sender, args) {
                                        if (performevent) {
                                            var tableView = $find("<%# ((GridItem)Container).OwnerTableView.ClientID %>");
                                            tableView.filter("stav", args.get_item().get_value(), "EqualTo");
                                        }
                                    }
                                    function TRCB_stav_f_ItemsRequesting(sender, args) {
                                        var context = args.get_context();
                                        var TRCB_typ_f = $find('<%# ((GridItem)Container).FindControl("TRCB_typ_f").ClientID %>');
                                        var val = TRCB_typ_f.get_value();
                                        context["typ"] = val;
                                    }
                                    function TRCB_stav_f_ItemsRequested(sender, args) {
                                        var value = sender.get_value();
                                        var zitem = sender.findItemByValue(value);
                                        stavselected = true;
                                        if (zitem) {
                                            zitem.select();
                                        }
                                        else {
                                            var vseitem = sender.findItemByValue("vse");
                                            if (vseitem) {
                                                vseitem.select();
                                            }
                                        }
                                    }
                                </script>
                            </telerik:RadScriptBlock>
                        </FilterTemplate>
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn DataField="sys_stav_t" FilterControlAltText="Filter sys_stav_t column"
                        HeaderText="[%Sys. stav%]" UniqueName="sys_stav_t" Groupable="False">
                        <FilterTemplate>
                            <wc:TRadComboBox ID="TRCB_sys_stav_f" runat="server" DropDownAutoWidth="Enabled"
                                Width="100" DataSourceID="dsSysStavyPozadavku" DataTextField="text_stavu" DataValueField="stav"
                                CheckBoxes="True" EnableCheckAllItemsCheckBox="True" OnClientDropDownClosing="TRCB_sys_stav_f_DropDownClosing">
                            </wc:TRadComboBox>
                            <telerik:RadScriptBlock ID="RadScriptBlock66" runat="server">
                                <script type="text/javascript" id="telerikClientEvents3">
                                    function TRCB_sys_stav_f_DropDownClosing(sender, args) {
                                        var tableView = $find("<%# ((GridItem)Container).OwnerTableView.ClientID %>");
                                        var valuech = "";
                                        var itemsch = sender.get_checkedItems();
                                        if (itemsch.length == 0 || itemsch.length == 4) {
                                            valuech = "";
                                        }
                                        else {
                                            for (var i in itemsch) {
                                                valuech += itemsch[i].get_value() + ",";
                                            }
                                        }
                                        valuech = valuech.length > 0 ? valuech.substring(0, valuech.length - 1) : valuech;
                                        tableView.filter("sys_stav_t", valuech, "EqualTo");
                                    }
                                </script>
                            </telerik:RadScriptBlock>
                        </FilterTemplate>
                    </telerik:GridBoundColumn>
                    <telerik:GridCheckBoxColumn UniqueName="storno" AllowFiltering="true" AllowSorting="true" DataField="storno" DataType="System.Boolean" HeaderText="[%Storno%]">
                    </telerik:GridCheckBoxColumn>
                    <telerik:GridTemplateColumn UniqueName="adresati" AllowFiltering="false" AllowSorting="false" HeaderText="[%Aktuální řešitel%]" DataType="System.String" FilterControlWidth="70px">
                        <ItemTemplate>
                            <div id="div_adresati" runat="server">
                                <label id="l_adr_text"></label>
                            </div>
                        </ItemTemplate>
                        <HeaderStyle Width="140px" />
                    </telerik:GridTemplateColumn>
                    <telerik:GridDateTimeColumn DataField="dat_od" DataFormatString="{0:d.M.yyyy}" DataType="System.DateTime" Display="false"
                        FilterControlAltText="Filter dat_od column" HeaderText="[%Dat. od%]" UniqueName="dat_od"
                        FilterControlWidth="98px" Groupable="False">
                    </telerik:GridDateTimeColumn>
                    <telerik:GridDateTimeColumn DataField="dat_do" DataFormatString="{0:d.M.yyyy}" DataType="System.DateTime" Display="false"
                        FilterControlAltText="Filter dat_do column" HeaderText="[%Dat. do%]" UniqueName="dat_do"
                        FilterControlWidth="98px" Groupable="False">
                    </telerik:GridDateTimeColumn>
                    <telerik:GridDateTimeColumn DataField="datum" DataFormatString="{0:d.M.yyyy}" DataType="System.DateTime" Display="false"
                        FilterControlAltText="Filter datum column" HeaderText="[%Ze dne%]" UniqueName="datum" Groupable="False">
                        <FilterTemplate>
                            <table class="colapsedTable">
                                <tr>
                                    <td>
                                        <kspwc:TImageButton ID="TIB_datum_od_prev" runat="server" CssClass="rbPrevious16 rbPredefinedIcons"
                                            OnClientClick="PrevMonth(event, this);return false;" ImageUrl="~/Images/TransparentDot.png" />
                                    </td>
                                    <td>
                                        <wc:TRadMonthYearPicker ID="TRMYP_datum_od_f" runat="server" Width="55px" ShowPopupOnFocus="True">
                                            <DateInput DisplayDateFormat="M.yyyy" DateFormat="M.yyyy" EmptyMessage="[%od%]">
                                                <ClientEvents OnValueChanged="TRMYP_datum_f_OnDateSelected" OnKeyPress="TRMYP_datum_keyPress" />
                                            </DateInput>
                                            <DatePopupButton Visible="False" />
                                        </wc:TRadMonthYearPicker>
                                    </td>
                                    <td>
                                        <kspwc:TImageButton ID="TIB_datum_od_next" runat="server" CssClass="rbNext16 rbPredefinedIcons"
                                            OnClientClick="NextMonth(event, this);return false;" ImageUrl="~/Images/TransparentDot.png" />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <kspwc:TImageButton ID="TIB_datum_do_prev" runat="server" CssClass="rbPrevious16 rbPredefinedIcons"
                                            OnClientClick="PrevMonth(event, this);return false;" ImageUrl="~/Images/TransparentDot.png" />
                                    </td>
                                    <td>
                                        <wc:TRadMonthYearPicker ID="TRMYP_datum_do_f" runat="server" Width="55px" ShowPopupOnFocus="True">
                                            <DateInput DisplayDateFormat="M.yyyy" DateFormat="M.yyyy" EmptyMessage="[%do%]">
                                                <ClientEvents OnValueChanged="TRMYP_datum_f_OnDateSelected" OnKeyPress="TRMYP_datum_keyPress" />
                                            </DateInput>
                                            <DatePopupButton Visible="False" />
                                        </wc:TRadMonthYearPicker>
                                    </td>
                                    <td>
                                        <kspwc:TImageButton ID="TIB_datum_do_next" runat="server" CssClass="rbNext16 rbPredefinedIcons"
                                            OnClientClick="NextMonth(event, this);return false;" ImageUrl="~/Images/TransparentDot.png" />
                                    </td>
                                </tr>
                            </table>
                            <telerik:RadScriptBlock ID="RadScriptBlock4" runat="server">
                                <script type="text/javascript" id="telerikClientEvents2">
                                    function TRMYP_datum_f_OnDateSelected(sender, args) {
                                        if (performevent) {
                                            var tableView = $find("<%# ((GridItem)Container).OwnerTableView.ClientID %>");
                                            var TRMYP_datum_od = $find('<%# ((GridItem)Container).FindControl("TRMYP_datum_od_f").ClientID %>');
                                            var TRMYP_datum_do = $find('<%# ((GridItem)Container).FindControl("TRMYP_datum_do_f").ClientID %>');
                                            var perpom = performrebind;
                                            performrebind = false;
                                            CheckDates(sender, TRMYP_datum_od, TRMYP_datum_do);
                                            performrebind = perpom;
                                            var date = getObdobiFirst(getNotNullDate(TRMYP_datum_od.get_selectedDate(), minDate)).format("yyyy-MM-dd") + " " + getObdobiLast(getNotNullDate(TRMYP_datum_do.get_selectedDate(), maxDate)).format("yyyy-MM-dd");
                                            tableView.filter("datum", date, "Between");
                                        }
                                    }
                                </script>
                            </telerik:RadScriptBlock>
                        </FilterTemplate>
                    </telerik:GridDateTimeColumn>
                    <telerik:GridDateTimeColumn DataField="vyridit_do" DataFormatString="{0:d.M.yyyy}" Display="false"
                        DataType="System.DateTime" FilterControlAltText="Filter vyridit_do column" HeaderText="[%Vyřešit do%]"
                        UniqueName="vyridit_do" Groupable="False">
                        <FilterTemplate>
                            <table class="colapsedTable">
                                <tr>
                                    <td>
                                        <kspwc:TImageButton ID="TIB_vyresit_od_prev" runat="server" CssClass="rbPrevious16 rbPredefinedIcons"
                                            OnClientClick="PrevMonth(event, this);return false;" ImageUrl="~/Images/TransparentDot.png" />
                                    </td>
                                    <td>
                                        <wc:TRadMonthYearPicker ID="TRMYP_vyresit_od_f" runat="server" Width="55px" ShowPopupOnFocus="True">
                                            <DateInput DisplayDateFormat="M.yyyy" DateFormat="M.yyyy" EmptyMessage="[%od%]">
                                                <ClientEvents OnValueChanged="TRMYP_vyresit_f_OnDateSelected" OnKeyPress="TRMYP_datum_keyPress" />
                                            </DateInput>
                                            <DatePopupButton Visible="False" />
                                        </wc:TRadMonthYearPicker>
                                    </td>
                                    <td>
                                        <kspwc:TImageButton ID="TIB_vyresit_od_next" runat="server" CssClass="rbNext16 rbPredefinedIcons"
                                            OnClientClick="NextMonth(event, this);return false;" ImageUrl="~/Images/TransparentDot.png" />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <kspwc:TImageButton ID="TIB_vyresit_do_prev" runat="server" CssClass="rbPrevious16 rbPredefinedIcons"
                                            OnClientClick="PrevMonth(event, this);return false;" ImageUrl="~/Images/TransparentDot.png" />
                                    </td>
                                    <td>
                                        <wc:TRadMonthYearPicker ID="TRMYP_vyresit_do_f" runat="server" Width="55px" ShowPopupOnFocus="True">
                                            <DateInput DisplayDateFormat="M.yyyy" DateFormat="M.yyyy" EmptyMessage="[%do%]">
                                                <ClientEvents OnValueChanged="TRMYP_vyresit_f_OnDateSelected" OnKeyPress="TRMYP_datum_keyPress" />
                                            </DateInput>
                                            <DatePopupButton Visible="False" />
                                        </wc:TRadMonthYearPicker>
                                    </td>
                                    <td>
                                        <kspwc:TImageButton ID="TIB_vyresit_do_next" runat="server" CssClass="rbNext16 rbPredefinedIcons"
                                            OnClientClick="NextMonth(event, this);return false;" ImageUrl="~/Images/TransparentDot.png" />
                                    </td>
                                </tr>
                            </table>
                            <telerik:RadScriptBlock ID="RadScriptBlock5" runat="server">
                                <script type="text/javascript" id="telerikClientEvents2">
                                    function TRMYP_vyresit_f_OnDateSelected(sender, args) {
                                        if (performevent) {
                                            var tableView = $find("<%# ((GridItem)Container).OwnerTableView.ClientID %>");
                                            var TRMYP_vyresit_od = $find('<%# ((GridItem)Container).FindControl("TRMYP_vyresit_od_f").ClientID %>');
                                            var TRMYP_vyresit_do = $find('<%# ((GridItem)Container).FindControl("TRMYP_vyresit_do_f").ClientID %>');
                                            var perpom = performrebind;
                                            performrebind = false;
                                            CheckDates(sender, TRMYP_vyresit_od, TRMYP_vyresit_do);
                                            performrebind = perpom;
                                            var date = getObdobiFirst(getNotNullDate(TRMYP_vyresit_od.get_selectedDate(), minDate)).format("yyyy-MM-dd") + " " + getObdobiLast(getNotNullDate(TRMYP_vyresit_do.get_selectedDate(), maxDate)).format("yyyy-MM-dd");
                                            tableView.filter("vyridit_do", date, "Between");
                                        }
                                    }
                                </script>
                            </telerik:RadScriptBlock>
                        </FilterTemplate>
                    </telerik:GridDateTimeColumn>
                    <telerik:GridDateTimeColumn DataField="obdobi" DataFormatString="{0:M.yyyy}" DataType="System.DateTime"
                        FilterControlAltText="Filter obdobi column" HeaderText="[%Období%]" UniqueName="obdobi" Groupable="False">
                        <FilterTemplate>
                            <table class="colapsedTable">
                                <tr>
                                    <td>
                                        <kspwc:TImageButton ID="TIB_obdobi_od_prev" runat="server" CssClass="rbPrevious16 rbPredefinedIcons"
                                            OnClientClick="PrevMonth(event, this);return false;" ImageUrl="~/Images/TransparentDot.png" />
                                    </td>
                                    <td>
                                        <wc:TRadMonthYearPicker ID="TRMYP_obdobi_od_f" runat="server" Width="55px" ShowPopupOnFocus="True">
                                            <DateInput DisplayDateFormat="M.yyyy" DateFormat="M.yyyy" EmptyMessage="[%od%]">
                                                <ClientEvents OnValueChanged="TRMYP_obdobi_f_OnDateSelected" OnKeyPress="TRMYP_datum_keyPress" OnBlur="TRMYP_datum_Blur" />
                                            </DateInput>
                                            <DatePopupButton Visible="False" />
                                        </wc:TRadMonthYearPicker>
                                    </td>
                                    <td>
                                        <kspwc:TImageButton ID="TIB_obdobi_od_next" runat="server" CssClass="rbNext16 rbPredefinedIcons"
                                            OnClientClick="NextMonth(event, this);return false;" ImageUrl="~/Images/TransparentDot.png" />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <kspwc:TImageButton ID="TIB_obdobi_do_prev" runat="server" CssClass="rbPrevious16 rbPredefinedIcons"
                                            OnClientClick="PrevMonth(event, this);return false;" ImageUrl="~/Images/TransparentDot.png" />
                                    </td>
                                    <td>
                                        <wc:TRadMonthYearPicker ID="TRMYP_obdobi_do_f" runat="server" Width="55px" ShowPopupOnFocus="True">
                                            <DateInput DisplayDateFormat="M.yyyy" DateFormat="M.yyyy" EmptyMessage="[%do%]">
                                                <ClientEvents OnValueChanged="TRMYP_obdobi_f_OnDateSelected" OnKeyPress="TRMYP_datum_keyPress" OnBlur="TRMYP_datum_Blur" />
                                            </DateInput>
                                            <DatePopupButton Visible="False" />
                                        </wc:TRadMonthYearPicker>
                                    </td>
                                    <td>
                                        <kspwc:TImageButton ID="TIB_obdobi_do_next" runat="server" CssClass="rbNext16 rbPredefinedIcons"
                                            OnClientClick="NextMonth(event, this);return false;" ImageUrl="~/Images/TransparentDot.png" />
                                    </td>
                                </tr>
                            </table>
                            <telerik:RadScriptBlock ID="RadScriptBlock6" runat="server">
                                <script type="text/javascript" id="telerikClientEvents2">
                                    function TRMYP_obdobi_f_OnDateSelected(sender, args) {
                                        if (performevent) {
                                            var tableView = $find("<%# ((GridItem)Container).OwnerTableView.ClientID %>");
                                            var TRMYP_obdobi_od = $find('<%# ((GridItem)Container).FindControl("TRMYP_obdobi_od_f").ClientID %>');
                                            var TRMYP_obdobi_do = $find('<%# ((GridItem)Container).FindControl("TRMYP_obdobi_do_f").ClientID %>');
                                            var TRCB_typ_f = GetGridServerElement("TRCB_typ_f", null, null);
                                            var typ_value = TRCB_typ_f.get_value();
                                            var perpom = performrebind;
                                            performrebind = false;
                                            CheckDates(sender, TRMYP_obdobi_od, TRMYP_obdobi_do, typ_value == 'vse' ? 11 : 23);
                                            performrebind = perpom;
                                            var date = getObdobiFirst(getNotNullDate(TRMYP_obdobi_od.get_selectedDate(), minDate)).format("yyyy-MM-dd") + " " + getObdobiLast(getNotNullDate(TRMYP_obdobi_do.get_selectedDate(), maxDate)).format("yyyy-MM-dd");
                                            tableView.filter("obdobi", date, "Between");
                                        }
                                    }
                                </script>
                            </telerik:RadScriptBlock>
                        </FilterTemplate>
                    </telerik:GridDateTimeColumn>
                    <telerik:GridDateTimeColumn DataField="obdobi_do" DataFormatString="{0:M.yyyy}" DataType="System.DateTime" Display="false"
                        FilterControlAltText="Filter obdobi_do column" HeaderText="[%Období do%]" UniqueName="obdobi_do" Groupable="False">
                        <FilterTemplate></FilterTemplate>
                        <HeaderStyle Wrap="false" />
                    </telerik:GridDateTimeColumn>
                    <telerik:GridTemplateColumn UniqueName="expiroval" AllowFiltering="false" AllowSorting="false" DataType="System.Boolean" DataField="expiroval" HeaderText="[%Exp.%]">
                        <ClientItemTemplate>
                            <span><input type="checkbox" disabled="disabled" #=expiroval ? "checked" : ""# title="#=expirovalMsg#"></span>
                        </ClientItemTemplate>
                    </telerik:GridTemplateColumn>
                    <telerik:GridDateTimeColumn DataType="System.DateTime" DataField="vyriz_datum" DataFormatString="{0:d.M.yyyy H:mm:ss}" FilterControlAltText="Filter vyriz_datum column" Display="false"
                        HeaderText="[%Změněno%]" UniqueName="vyriz_datum" FilterControlWidth="98px" Groupable="False">
                    </telerik:GridDateTimeColumn>
                    <telerik:GridBoundColumn DataField="vyriz_user" FilterControlAltText="Filter vyriz_user column" Display="false"
                        HeaderText="[%Uživatel%]" UniqueName="vyriz_user" FilterControlWidth="50px" Groupable="False">
                    </telerik:GridBoundColumn>
                    <telerik:GridNumericColumn DataField="skup_str" DataType="System.Int32" DecimalDigits="0" MaxValue="2147483647" MinValue="-2147483648" Display="false"
                        FilterControlAltText="Filter skup_str column" HeaderText="[%Skup. střed.%]" UniqueName="skup_str"
                        AllowFiltering="True" FilterControlWidth="70px" Groupable="False">
                    </telerik:GridNumericColumn>
                    <telerik:GridNumericColumn DataField="cis_divize" DataType="System.Int32" DecimalDigits="0" MaxValue="2147483647" MinValue="-2147483648" Display="false"
                        FilterControlAltText="Filter skup_str column" HeaderText="[%Divize%]" UniqueName="cis_divize"
                        AllowFiltering="True" Groupable="False">
                    </telerik:GridNumericColumn>
                </Columns>
            </MasterTableView>
        </wc:TRadGrid>
    </asp:Panel>
</asp:Content>
