﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="ModulOdmenovani.aspx.cs" Inherits="KSPortal.ZakSpec.ModulOdmenovani" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <script src= "../kendo/js/kendo.all.min.js" type="text/javascript"></script>
    <script src="../kendo/js/cultures/kendo.culture.cs-CZ.min.js" type="text/javascript" ></script>
    <script src="../kendo/js/messages/kendo.messages.cs-CZ.min.js" type="text/javascript"></script> 
    <link rel="stylesheet" href=  "../kendo/styles/kendo.common.min.css" />
    <link rel="stylesheet" href="../kendo/styles/kendo.default-main.css" />
     
    <div id="div_check_all"></div>
    <telerik:RadCodeBlock runat="server" ID="rcb" >  
      
    <script type="text/javascript">      
        kendo.culture('cs-CZ');      

        var sablona_id_poz;
        var sablona_potvrzeno;
        var sablona_vybrsablona="";
        var sablona_polozka;
        var data_editace = [];
        var data_combo = [];
        var sablona_rok = 0;
        var sablona_mes = 0;
        var sablona_typ_polozky = "";
        var dataItemIndex = -1
        var formularReadOnly = false;
        var window_edit = {};
        var window_pozn = {};
        var DuvodValidation = {};
        var NumericValidation = {};
        var MaxTextLength = null;
        var EditWindowHeight = null;
        var saveStateTimeOut;
        var vybranasablona = "";
        var visibleChange = false;
        var sablona_arrCol = "";
        var sablona_col_check_arr = [];
        var sablona_visible_settings = [];
        var formularPoznamkyReadOnly = false;
        var gardetail = false;

        function retrieveOdmenyGrid() {
            getOdmenyData(sablona_id);
        }
        function getOdmenyData(sablona_id) {
            $find('<%= TRG_odmeny.ClientID %>').show('<%= RALP_TRadGrid.ClientID %>');
            var grid = $find('<%= TRG_odmeny.ClientID %>');
            if (grid) {
                var tableView = grid.get_masterTableView();
                if (tableView != null) {
                    PageMethods.GetDataOdmeny(sablona_id, updateOdmenyGrid);
                }
            }
        }
        function updateOdmenyGrid(result) {
            var tableView = $find('<%= TRG_odmeny.ClientID %>').get_masterTableView();
            tableView.set_dataSource(result.Data);
            tableView.dataBind();

            $find('<%= TRG_odmeny.ClientID %>').hide('<%= RALP_TRadGrid.ClientID %>');

            resetSessionTimeout();
        }     
        function confirmCallBackFn(args) {
            if (args == true) {               
                PageMethods.UplatnitGaranci(sablona_vybrsablona, sablona_id_poz, sablona_rok, sablona_mes, dataItemIndex, garanceVyslZprac, onPageMethodError);
            }           
        }
        function garanceVyslZprac(result) {
            resetSessionTimeout();           
            if (result.Provedeno) {
                getDataRadek(result.Data);
            }
            else {
                var alertWnd=radalert(result.Message);
                alertWnd.get_popupElement().style.zIndex = 10100;
                return;
            }
        }
        function grid_pozn_saveChanges(e) {
            PageMethods.SavePoznamku(e.model.Poznamka, e.model.Trvala, sablona_id_poz, sablona_vybrsablona, sablona_potvrzeno, sablona_rok, sablona_mes, dataItemIndex, updatePoznGrid, onPageMethodError);
        }
        function getPoznamky(readonly) {          
            PageMethods.GetPoznamky(sablona_id_poz, sablona_vybrsablona, (formularPoznamkyReadOnly ? 1 : 0), sablona_rok, sablona_mes, dataItemIndex, readonly, updatePoznGrid, onPageMethodError);
        }
        function updatePoznGrid(data) {            
            let grid = $("#grid_pozn").data("kendoGrid");
            $("#wnd_pozn").data("kendoWindow").title(data.OsCislPrijmeniJmeno);
            grid.dataSource.data(data.Poznamky);            
            getDataRadek();
            resetSessionTimeout();
        }

        function multilineEditor(container, options) {
            var maxLength = 150; 
            var textarea = $('<textarea class="k-textbox" rows="4" style="width: 100%; height:150px;"></textarea>')
                .attr("name", options.field)
                .on("input", function () {
                    var text = $(this).val();
                    if (text.length > maxLength) {
                        $(this).val(text.substring(0, maxLength));
                    }                   
                    var remaining = maxLength - $(this).val().length;
                    $("#charCount").text(remaining + " znaků zbývá");
                    
                    if (remaining <= 10) {
                        $("#charCount").css("color", "red");
                    } else {
                        $("#charCount").css("color", "gray");
                    }
                });
          
            var counter = $('<div id="charCount" style="text-align:right; font-size:12px; color:gray;">' + maxLength + ' znaků zbývá</div>');
            $(container).append(textarea).append(counter);
        }


        function createWindowPoznamky() {
           window_pozn= $("#wnd_pozn").kendoWindow({
                height: 620,
                width: 1100,
                visible: false,
                appendTo: "#aspnetForm",
                open: function (e) {
                    getPoznamky(false);
                    this.center();
                }               
            }).data("kendoWindow");

            var dspozn = new kendo.data.DataSource({
                batch: false,
                pageSize: 20,
                schema: {
                    model: {
                        fields: {
                            Poznamka: { type: "string" },
                            Trvala: { type: "boolean" },
                            ResitelJmeno: { type: "string", editable: false },
                            DatumCasS: { type: "date", editable: false },
                            ZneplatnenoCele: { type: "string", editable: false }                            
                        }
                    }
                }
            });
           
            $("#grid_pozn").kendoGrid({
                dataSource: dspozn,
                navigatable: true,
                pageable: false,
                toolbar: ["create"],
                editable: {
                    mode: "popup",
                    window: {
                        title: "Nová poznámka"
                    }
                },
                width: "100%",
                height:"100%",
                columns: [
                    {
                        field: "Poznamka", title: "Poznámka", width: 500, editor: multilineEditor
                    },
                    {
                        field: "Trvala", title: "Trvalá", editor: function (container, options) {
                            $('<input class="k-checkbox" type="checkbox" name="' + options.field + '" data-type="boolean" data-bind="checked:' + options.field + '">')
                                .appendTo(container);
                        },
                        template: '<input type="checkbox" #= Trvala ? "checked=checked" : "" # disabled="disabled" />'
                    },
                    {                       
                        field: "UzivatelDatumCas", title: "Zapsáno", width: 150
                    },
                    {
                        field: "ZneplatnenoCele", title: "Zneplatněno", width: 150
                    },
                    {
                        command: [
                            {
                                name: "destroy",  
                                text: ""
                            }
                        ],
                        width: 50
                    }
                ],
                dataBound: function (e) {
                    var rows = e.sender.tbody.children();       
                    for (var j = 0; j < rows.length; j++) {
                        var row = $(rows[j]);
                        var dataItem = e.sender.dataItem(row);
                        var znepl = dataItem.get("Zneplatneno");                        
                        if (formularPoznamkyReadOnly) {
                            var cell = row.children().eq(row.children().length - 1);
                           cell.addClass("dispay_none");
                        }
                        if (znepl) {
                            row.addClass("zneplatneno");
                            var cell = row.children().eq(row.children().length - 1);
                            cell.addClass("dispay_none");
                        }
                    }                   
                    setTimeout(() => {
                        if (formularPoznamkyReadOnly)
                            $("#grid_pozn .k-grid-toolbar").hide();
                        else
                            $("#grid_pozn .k-grid-toolbar").show();
                    }, 200);                   
                },
                save: function (e) {
                    grid_pozn_saveChanges(e);
                },
                remove: function (e) {                    
                    PageMethods.ZneplatnitPoznamku(JSON.stringify(e.model), sablona_potvrzeno, updatePoznGrid, onPageMethodError);
                },
                edit: function (e) {
                    setTimeout(function () {                         
                        var popupEditor = e.container; 
                        var fi = popupEditor.find("textarea").first();                        
                        fi.focus(); 
                    }, 200);
                }
            });
        
            var toolb = new Array();           
            toolb.push({ name: "create", text: "Vložit nový" });           

            var  edit = {
                "confirmation": true,
                "mode": "popup",
                "createAt": "bottom"
            }    
            $("#grid_pozn").data("kendoGrid").setOptions({ editable: edit, toolbar: toolb }); 
            $("#grid_pozn").find(".k-grid-toolbar").insertAfter($("#grid_pozn .k-grid-content"));
        }

        function onClientClick(par) {           
            parsParams(par);
            if (sablona_polozka == "garancecastka") {              
                radconfirm('Opravdu si přejete uplatni garanci? ', confirmCallBackFn, 330, 150, null, 'Garance mzdy');
                return false;
            }
            formularReadOnly = false;
            window_edit.center();
            window_edit.open();
            gardetail = false;
            rw_edit_OnClientBeforeShow();            
            return false;
        }

        function onClientClickPozn(par) {
            parsParams(par);
            formularPoznamkyReadOnly = false;
            openWindowPozn(false);            
            return false;
        }

        function parsParams(par) {            
            var arr = par.split("|");
            sablona_id_poz = arr[0];
            sablona_vybrsablona = arr[1];
            sablona_polozka = arr[2];
            sablona_potvrzeno = arr[3];
            sablona_rok = arr[4];
            sablona_mes = arr[5];
            sablona_typ_polozky = arr[6];
            dataItemIndex = arr[7];
        }
       
        function rw_edit_OnClientBeforeShow(sender, args) {           
            data_editace = [];           
            if (formularReadOnly == false)
                nacist_edit_form();
            else
                nacist_readOnly_form();          
        }

        function nacist_edit_form() {            
            resetSessionTimeout();
            PageMethods.GetEditacniData(sablona_id_poz, sablona_potvrzeno, sablona_vybrsablona, sablona_polozka, sablona_rok, sablona_mes, "P", updateEditGrid, onPageMethodError);
        }

        function nacist_readOnly_form() {
            resetSessionTimeout();
            if (sablona_polozka == "poznamkapt") {                
                openWindowPozn(true);
            }
            else
                PageMethods.GetPotvrzenaData(sablona_id_poz, sablona_potvrzeno, sablona_vybrsablona, sablona_polozka, sablona_rok, sablona_mes, "P", updateEditGridReadOnly, onPageMethodError);
        }

        function openWindowPozn(readOnly) {
            formularPoznamkyReadOnly = readOnly;
            window_pozn.center();
            window_pozn.open();            
        }

        function hideCommands() {
            $("#grid_pozn .k-grid-edit,#grid_pozn .k-grid-delete").hide(); 
        }

        function showCommands() {
            $("#grid_pozn .k-grid-edit,#grid_pozn .k-grid-delete").show(); 
        }

        function getDataRadek() {
            //musím zpomalit načtení, jinak dostanu data před změnou
            setTimeout(() => {               
                PageMethods.GetDataRadek(sablona_id_poz, sablona_vybrsablona, aktualizujRadek, onPageMethodError);               
            }, 500);           
        }

        function aktualizujRadek(data) {          
            var oData = JSON.parse(data);
            var mtv = $find('<%= TRG_odmeny.ClientID %>').get_masterTableView();
            var row = mtv.get_dataItems()[dataItemIndex];            
            var zmeny=oData.Item2;
            Object.keys(oData.Item1[0]).forEach(function (key, index) {
                var k = key;
                var val = oData.Item1[0][k];
                var cc = row.get_cell(k);
                if (cc) {
                    var sp = cc.getElementsByTagName("span");
                    if (sp) {
                        var c1 = sp[0];
                        if (c1) {
                            if (isNaN(val))
                                c1.innerHTML = (val == null ? "" : val);
                            else
                                c1.innerHTML = (val == null ? "" : val.toFixed(2));                          
                        }
                    }
                    if (zmeny.findIndex(element => element == k) > -1)
                        $(cc).addClass("ks-zm");
                }
            });
            aktualizaceSouctu();
        }

        function aktualizaceSouctu() {      
            if (sablona_vybrsablona != "" && sablona_vybrsablona != null) {
                setTimeout(() => {
                    PageMethods.GetSoucty(sablona_vybrsablona, sablona_rok, sablona_mes, soucty_zobraz, onPageMethodError);
                }, 50);
            }
        }
       
        function soucty_zobraz(data) {                
            if (data.Varianta == "LOM"){
                let grid = $("#grid_lom").data("kendoGrid");
                grid.dataSource.data(data.Data);
                var wnd = $("#wnd_lom").data("kendoWindow");
                if (!wnd.wrapper.is(":visible")) {
                    wnd.open();

                }
            }
            else if (data.Varianta=="CZ_LOKO") {
                let grid = $("#grid_loko").data("kendoGrid");
                grid.dataSource.data(data.Data);              
                var wnd= $("#wnd_loko").data("kendoWindow");
                if (!wnd.wrapper.is(":visible")) {
                    wnd.open();
                }
            }
           <%-- else if (data.Varianta=="LOM") {               
                $("#pan_suma_naroku").css("display", "block");
                $find("<%=lab_suma_castek.ClientID%>").set_value(data.Data[0].SumaCastek.toString());
                $find("<%=lab_suma_naroku.ClientID%>").set_value(data.Data[0].SumaNaroku.toString());
                $find("<%=lab_rozdil.ClientID%>").set_value(data.Data[0].Rozdil.toString());
            }--%>
        }

        function onPageMethodError(err) {
            if (err) {
                var title = err.get_exceptionType();
                var text = err.get_message();
                if (title)
                    KSMaster.showError(text, title);
            }
        }

        function getSelectedIndexes() {           
            var grid = $find("<%=TRG_odmeny.ClientID %>");
            var gridSelectedItems = grid.get_selectedItems();
            return gridSelectedItems;
        }

        function getSelectedIdPoz() {           
            var ids = new Array();
            if (getSelectedIndexes().length > 0) {
                var mtv = $find("<%= TRG_odmeny.ClientID %>").get_masterTableView();
                var its = mtv.get_selectedItems();
                for (var j = 0; j < its.length; j++) {
                    var id_poz = its[j].getDataKeyValue("id_poz");
                    ids.push(id_poz);
                }
            }
            else
                ids.push(sablona_id_poz);

            return ids;
        }

        function bHromZmena() {
            var hromZmena = false;
            var check_box = $('#check_all');
            if (check_box != undefined && check_box[0] != undefined) {
                var checked = check_box[0].checked;
                if (checked) {
                    hromZmena = true;
                }
            }
            return hromZmena;
        }

        function hromValidaceMaxValue(castka) {          
            var arr = getSelectedIdPoz();
            var res = "";


            //---------------------------------------------------------------
            var d = [];
            var item = { "id_pozs": arr.join() }; d.push(item);
            item = { "rok": sablona_rok }; d.push(item);
            item = { "mes": sablona_mes }; d.push(item);
            item = { "sablona": sablona_vybrsablona }; d.push(item);
            item = { "castka": castka }; d.push(item);
            item = { "polozka": sablona_polozka }; d.push(item);            
            var data_send = JSON.stringify(d);
            $.ajax({
                type: "POST",
                url: KSMaster.baseUrl + "/ZakSpec/ModulOdmenovani.aspx/HromValidaceMaxCastky",                
                 data: "{data:'" + data_send + "'}",
                 async: false,
                 contentType: "application/json",
                 dataType: "json",
                 error: function (xhr, ajaxOptions, thrownError) {
                     alert(xhr.status);
                     alert(xhr.responseText);
                     alert(thrownError);
                 },
                 success: function (msg) {
                     res= msg.d;
                 }
             });
            //---------------------------------------------------------------

            return res;
        }

        //function validaceMaxColumnValue(castka) {
        //    var arr = getSelectedIdPoz();
        //    var res = "";


        //    //---------------------------------------------------------------
        //    var d = [];
        //    var item = { "id_pozs": arr.join() }; d.push(item);
        //    item = { "rok": sablona_rok }; d.push(item);
        //    item = { "mes": sablona_mes }; d.push(item);
        //    item = { "sablona": sablona_vybrsablona }; d.push(item);
        //    item = { "castka": castka }; d.push(item);
        //    item = { "polozka": sablona_polozka }; d.push(item);
        //    var data_send = JSON.stringify(d);
        //    $.ajax({
        //        type: "POST",
        //        url: KSMaster.baseUrl + "/ZakSpec/ModulOdmenovani.aspx/ValidaceMaxColumnValue",
        //        data: "{data:'" + data_send + "'}",
        //        async: false,
        //        contentType: "application/json",
        //        dataType: "json",
        //        error: function (xhr, ajaxOptions, thrownError) {
        //            alert(xhr.status);
        //            alert(xhr.responseText);
        //            alert(thrownError);
        //        },
        //        success: function (msg) {
        //            res = msg.d;
        //        }
        //    });
        //    //---------------------------------------------------------------

        //    return res;
        //}

        function repaintGrid(readOnly) {

            var sirka_text = "80px";
            if (DuvodValidation.Hidden)
                sirka_text = "380px";

            var cols = new Array();
            if (sablona_typ_polozky == "CASTKA" || sablona_typ_polozky=="PROCENTO") {
                cols.push({ field: "castka", title: (sablona_typ_polozky == "PROCENTO" ? "Procento" :"Částka"), format: "{0:n2}", width: "80px"});
            }
            else if (sablona_typ_polozky == "HODINY") {                
                cols.push({ field: "hodiny", title: "Hodiny", format: "{0:n2}", width: "80px"});
            }
            else if (sablona_typ_polozky == "TEXT") {
                cols.push({ field: "text", title: "Text", width: sirka_text });
            }
            if (!DuvodValidation.Hidden)
                cols.push({ field: "duvod", title: "Důvod", editor: kendoComboBoxEditor, width: "300px" });

            cols.push({ field: "uz", title: "Zapsáno", width: "150px" });
            cols.push({ field: "zn", title: "Zneplatněno", width: "100px" });
            if (!readOnly)
                cols.push({ command: "destroy", title: "&nbsp;", width: 40, Text:"dflja" });
            var grid = $("#grid_editace").data("kendoGrid");
            grid.setOptions({ columns: cols });           
          
            var edit = {};
            var toolb = new Array();
            toolb.push({ name: "create", text: "Vložit nový" }, { name: "save", text: "Uložit" });           
            toolb.push({ name: "cancel", text: "Neuložit" });

            if (readOnly) {
                edit = false;
                toolb = false;
            }
            else {
                edit = {
                    "confirmation": false,
                    "mode": "inline",
                    "createAt": "bottom"
                }
                //toolb = [{ name: "create", text: "Vložit nový" }, { name: "save", text: "Uložit" }, { name: "cancel", text: "Neuložit" }];
            }
            grid.setOptions({ editable: edit, toolbar: toolb });
           
            var ds = {
                data: data_editace,
                schema: {
                    model: {
                        fields: {
                            id: { type: "number" },
                            castka: {
                                type: "number",
                                validation: {                                    
                                    castkavalidation: function (input) {                                       
                                        var number = KSMaster.parseFloat($(input).val());                                        
                                        if ((number == 0 || number < 0) && NumericValidation.MinValue == null) {
                                            input.attr("data-castkavalidation-msg", "Lze zadat jen kladnou nenulovou hodnotu");
                                            return false;
                                        }                                      

                                        if (NumericValidation.MinValue != null) {
                                            if (number < NumericValidation.MinValue) {
                                                input.attr("data-castkavalidation-msg", "Minimální hodnota částky musí být " + NumericValidation.MinValue.toString());
                                                return false;
                                            }
                                        }
                                        if (NumericValidation.MaxValue != null) {
                                            if (NumericValidation.Budgeterie)
                                                suma_castek = 0;

                                            if (bHromZmena()) {
                                                var res = hromValidaceMaxValue(number, sablona_polozka);                                               
                                                if (res != null && res.length > 0) {
                                                    var alertWnd=radalert(res, 480, 445, "", null, null);
                                                    alertWnd.get_popupElement().style.zIndex = 10100;
                                                    return false;
                                                }
                                            }
                                            else if (((NumericValidation.Budgeterie ? 0 : suma_castek) + number) > NumericValidation.MaxValue) {
                                                input.attr("data-castkavalidation-msg", "Suma hodnot musí být maximálně " + NumericValidation.MaxValue.toString());
                                                return false;
                                            }
                                        }                                      
                                        return true;
                                    }
                                },
                                defaultValue:null
                            },
                            hodiny: {
                                type: "number",
                                validation: {
                                    required: true,
                                    hodinyvalidation: function (input) {
                                        var number = parseFloat($(input).val());
                                        if (number == 0 || number < 0) {
                                            input.attr("data-hodinyvalidation-msg", "Lze zadat jen kladnou nenulovou hodnotu");
                                            return false;
                                        }
                                        if (NumericValidation.MinValue != null) {
                                            if (number < NumericValidation.MinValue) {
                                                input.attr("data-hodinyvalidation-msg", "Minimální hodnota hodin musí být " + NumericValidation.MinValue.toString());
                                                return false;
                                            }
                                        }
                                        if (NumericValidation.MaxValue != null) {
                                            if (number > NumericValidation.MaxValue) {
                                                input.attr("data-hodinyvalidation-msg", "Maximální hodnota hodin musí být " + NumericValidation.MaxValue.toString());
                                                return false;
                                            }
                                        }
                                        return true;
                                    }
                                }
                            },                            
                            text: {                             
                                type: "string", validation: {
                                    textValidation: function (input) {                                        
                                        if (MaxTextLength > 0) {
                                            if ($(input).val().length > MaxTextLength) {
                                                $(input).attr("data-textvalidation-msg", "Maximální délka je " + MaxTextLength+" znaků");
                                                return false;
                                            }
                                        }
                                        return true;
                                    }
                                }
                            },
                            //duvod: { type: "string" },
                            duvod: {
                                type: "string", validation: {                                   
                                    duvodvalidation: function (input) {                                      
                                        if ($(input).val().length > 100) {
                                            $(input).attr("data-duvodvalidation-msg", "Maximální délka je 100 znaků");
                                            return false;
                                        }
                                        return true;
                                    }
                                }
                            },

                            zneplatneno: { type: "boolean" },
                            uz: { type: "string", editable: false, nullable: true },
                            zn: { type: "string", editable: false, nullable: true }
                        }
                    }
                },
                requestStart: function (e) {                   
                    if (e.type == "destroy") {                     
                        var el = e.sender._destroyed;
                        if (el.length > 0) {
                            if (el[0].id > 0 && el[0].delete_enabled) {
                                PageMethods.DestroyFormData(el[0].id, UpdateFormDataSucces, onPageMethodError);
                            }
                        }
                    }
                    else if (e.type == "update") {                       
                        if (e.sender._data.length > 0) {
                            var el = e.sender._data.find(aa => aa.dirty === true);
                            if (el != undefined && el != null) {
                                var hodnota = "";
                                if (sablona_typ_polozky == "CASTKA" || sablona_typ_polozky == "PROCENTO") {
                                    hodnota = el.castka;
                                } else if (sablona_typ_polozky == "HODINY") {
                                    hodnota = el.hodiny;
                                } else if (sablona_typ_polozky == "TEXT") {
                                    hodnota = el.text;
                                }
                               
                                var ids = new Array();                                
                                if (bHromZmena()) 
                                    ids = getSelectedIdPoz();                                
                                else
                                    ids.push(sablona_id_poz);
                            
                                if (ids.length == 0)
                                    ids.push(sablona_id_poz);
                                
                                PageMethods.CreateFormData(ids, sablona_vybrsablona, sablona_polozka, sablona_rok, sablona_mes, hodnota, el.duvod, UpdateFormDataSucces, onPageMethodError);
                            }
                        }
                    }
                    if (e.type != "read")
                        e.preventDefault();
                }
            };         
            grid.setOptions({ dataSource: ds });          
            if (gardetail) {
                $("#grid_editace").find(".k-grid-toolbar").hide();
            }
            else {
                $("#grid_editace").data("kendoGrid").setOptions({ height: (EditWindowHeight).toString() + "px" });
                $("#grid_editace").find(".k-grid-toolbar").show();
                $("#grid_editace").find(".k-grid-toolbar").insertAfter($("#grid_editace .k-grid-content"));
                if (getSelectedIndexes().length > 0 && !readOnly) {
                    $("<div id='div_check_all'/>").appendTo("#grid_editace");
                    $('<input/>').attr({ type: 'checkbox', id: 'check_all', name: 'test' }).appendTo('#div_check_all');
                    $("#check_all").kendoCheckBox({ label: "Uložit také všem označeným", checked: false, enabled: true });

                    $("#div_check_all").insertAfter($("#grid_editace .k-grid-toolbar .k-grid-add"));
                }
            }
        }

        function updateEditGrid(result) {
            resetSessionTimeout();

            data_editace = result.Data;
            data_combo = [];

            for (var i = 0; i < result.Duvody.length; i++) {
                data_combo.push({ text: result.Duvody[i], value: result.Duvody[i]})
            }            
            DuvodValidation = result.DuvodValidation;
            NumericValidation = result.NumericValidation;
            MaxTextLength = result.MaxTextLength;
            EditWindowHeight = result.EditWindowHeight;
            repaintGrid(false);
            //window_edit.center();
            $("#wnd_wnd_title").text(result.OsCislPrijmeniJmeno + "          " + result.PolozkaPopisek);
            window_edit.open();
        }
            
        function updateEditGridReadOnly(result) {
            resetSessionTimeout();
            data_editace = result.Data;
            if (data_editace.length > 0) {
                repaintGrid(true);
                $("#wnd_wnd_title").text(result.OsCislPrijmeniJmeno + "          " + result.PolozkaPopisek);
                window_edit.open();
            }
            else {                           
                var alertWnd=radalert("žádná potvrzená data k zobrazení", 280, 145, "", null, null);
                alertWnd.get_popupElement().style.zIndex = 10100;
            }
        }       
        function load() {
            resetSessionTimeout();            
            setTimeout(() => {
                $find('<%= button_zmena_stavu.ClientID %>').set_visible(false);
            }, 300);
            
            $("td[context='show']").dblclick(function (sender) {            
                var par = $(this).attr('data_d');
                gardetail = false;
                if (par != undefined && par != null) {                   
                    parsParams(par);
                    formularReadOnly = true;                    
                    rw_edit_OnClientBeforeShow();                   
                }               
            });

            $("td[context='gardetail']").dblclick(function (sender) {
                var par = $(this).attr('data_d');
                gardetail = true;
                if (par != undefined && par != null) {
                    parsParams(par);
                    formularReadOnly = false;
                    rw_edit_OnClientBeforeShow();
                }
            });
           
            aktualizaceSouctu();          

            //$("#div_grid").width($(window).width() - 30);
            //heightOfGrid();
            //$(window).resize(function () {
            //    $("#div_grid").width($(window).width() - 30);              
            //    heightOfGrid();
            //}); 
        }
       
        Sys.Application.add_load(load);

        function heightOfGrid() {           
            var grid = $find('<%= TRG_odmeny.ClientID %>');
            var pageheight = $(window).height();
            var scrollArea = grid.GridDataDiv;
            var mtv = grid.get_masterTableView();
            if (mtv != null) {
                var dataHeight = mtv.get_element().clientHeight;
                var height = pageheight + (KSMaster.isFullScreen() ? 55 : 0) - 330;
                height = (height > dataHeight ? dataHeight : height) + 20;
                scrollArea.style.height = (height + "px");
                grid.repaint();
            }
        }
       
        function UpdateFormDataSucces(sender, args) {            
            nacist_edit_form();
            if (bHromZmena())
                //načtu celý grid
                upravUIPoZmeneStavu();
            else
                getDataRadek();
        }

        function DestroyFormDataSucces(sender, args) {
            nacist_edit_form();
        }

        var suma_hodin = 0;
        var suma_castek = 0;
        function createGridEditace() {           
            $("#grid_editace").kendoGrid({
                messages: {
                    commands: {
                        destroy: ""
                    }
                },
                dataSource: {
                    data: data_editace,
                    schema: {
                        model: {
                            fields: {
                                id: { type: "number" },
                                castka: {
                                    type: "number", format: "{0:c}", validation: {
                                        required: true                                       
                                    }},
                                hodiny: {
                                    type: "number", validation: {
                                        required: true
                                    }
                                },
                                text: { type: "string" },
                                duvod: {
                                    type: "string" //,// required:false,
                                   // validation: { required: DuvodValidation.Required}
                                },
                                zneplatneno: { type: "boolean" },
                                uz: { type: "string", editable: false, nullable: true },
                                zn: { type: "string", editable: false, nullable: true }
                            }
                        }
                    },
                    requestStart: function (e) {                      
                    }
                },
                scrollable: true,
                navigatable: true,
                //height: EditWindowHeight,
                pageable: false,               
                dataBound: function (e) {
                    suma_castek = 0;
                    suma_hodin = 0;
                    var rows = e.sender.tbody.children();
                    for (var j = 0; j < rows.length; j++) {
                        var row = $(rows[j]);
                        var dataItem = e.sender.dataItem(row);
                        var znepl = dataItem.get("zneplatneno");
                        var de = dataItem.get("delete_enabled");
                        if (!de) {
                            var cell = row.children().eq(row.children().length - 1);
                            cell.addClass("dispay_none");
                        }
                        if (znepl) {
                            row.addClass("zneplatneno");
                            var cell = row.children().eq(row.children().length - 1);
                            cell.addClass("dispay_none");
                        }
                        else {                          
                            if (dataItem.get("hodiny") != null)
                                suma_hodin += dataItem.get("hodiny");
                            if(dataItem.get("castka") != null)
                                suma_castek += dataItem.get("castka");
                        }
                        
                    }
                }
            }).data("kendoGrid");          
        }
       
        function kendoComboBoxEditor(container, options) {
            var required = (DuvodValidation.Required ? "required = 'required'" : "");
            if (DuvodValidation.EditByKey && data_combo!=null && data_combo.length>0) {
                $('<input data-text-field="text" ' + required + ' data-value-field="value" data-bind="value:' + options.field + '"/>')
                    .appendTo(container)
                    .kendoComboBox({
                        dataSource: data_combo
                    });
            }
            else if (!DuvodValidation.EditByKey && data_combo != null && data_combo.length > 0) {
                $('<input data-text-field="text" ' + required + ' data-value-field="value" data-bind="value:' + options.field + '"/>')
                    .appendTo(container)
                    .kendoDropDownList({
                        dataSource: data_combo
                    });
            }
            else                
                $("<input class='k-input' "+required+" name='" + options.field + "'></input>")
                    .appendTo(container);               
        }

        function editNumber(container, options) {
            $('<input data-bind="value:' + options.field + '"/>')
                .appendTo(container)
                .kendoNumericTextBox({
                    spinners: false
                });
        }

        function TRG_odmeny_OnRowSelected(sender, args) {         
            var id_poz = args.getDataKeyValue("id_poz");
            var index=args.get_gridDataItem().get_itemIndex();
            PageMethods.GetStavy(id_poz, index, refreshStavy, onPageMethodError);            
        }
        function TRG_odmeny_OnRowSelecting(sender, args) {            
            var stav = args.getDataKeyValue("stav");
            var its = sender.get_selectedItems();
            for (var j = 0; j < its.length; j++) {
                var val = its[j].getDataKeyValue("stav");
                if (stav.trim() != val.trim()) {
                    sender.clearSelectedItems();
                    args.set_cancel(true);
                    nelzeVybirat();
                    return;
                }
            }
        }

        function RG_odmeny_OnRowDeselecting(sender, args) {          
            setTimeout(() => {               
                if (sender.get_selectedItems().length == 0) {
                    var combo=$find('<%= combo_zmena_stavu.ClientID %>')
                    combo.clearItems();
                    combo.set_text("");
                    combo.set_value("");
                    $find('<%= button_zmena_stavu.ClientID %>').set_visible(false);
                }
            }, 200);            
        }

        function nelzeVybirat() {
            var alertWnd=radalert("Nelze vybírat požadavky v různých stavech");
            alertWnd.get_popupElement().style.zIndex = 10100;
        }

        function refreshStavy(args) {
            resetSessionTimeout();
            var combo = $find('<%= combo_zmena_stavu.ClientID %>');
            if (combo.get_items().get_count() > 0)
                combo.clearItems();           
            var btn = $find('<%= button_zmena_stavu.ClientID %>');
            btn.set_visible(false);           
            var index = args.Data.findIndex(item => item.sys_stav2 === true);           
            if (index > -1) {
                btn.set_visible(true);
                btn.set_text(args.Data[index].popis.trim());
                btn.set_value(args.Data[index].stav.trim());
                btn_visible = true;
            }           
            combo.trackChanges();
            for (var j = 0; j < args.Data.length; j++) {
                if (args.Data[j].sys_stav2 !== true) {
                    var item = new Telerik.Web.UI.RadComboBoxItem();
                    item.set_text(args.Data[j].popis);
                    item.set_value(args.Data[j].stav);
                    combo.get_items().add(item);                    
                }
            }
            combo.commitChanges();           
        }

        function combo_zmena_stavu_OnClientSelectedIndexChanged(sender, args) {          
        }

        function butt_provest_OnClientClicked(sender, args) {
            var combo = $find("<%= combo_zmena_stavu.ClientID %>");
            if (combo != null) {
                var stav = combo.get_value();
                if (stav === "") {
                    var alertWnd = radalert("Není vybrán stav, nelze pokračovat");
                    alertWnd.get_popupElement().style.zIndex = 10100;
                    return;
                }

               <%-- $find('<%= RALP_TRadGrid.ClientID %>').show('<%= TRG_odmeny.ClientID %>');
                var poznamka = $find("<%= txt_poznamka.ClientID %>").get_value();
                var ids = [];
                var mtv = $find("<%= TRG_odmeny.ClientID %>").get_masterTableView();
                var its = mtv.get_selectedItems();
                for (var j = 0; j < its.length; j++) {
                    var id_poz = its[j].getDataKeyValue("id_poz");
                    var index = its[j]._itemIndex;
                    ids.push(
                        {
                            "id_poz": id_poz,
                            "index": index,
                            "poznamka": poznamka                            
                        }
                    )
                }
                var data = {};
                data.rok = sablona_rok;
                data.mes = sablona_mes;
                data.sablona = sablona_vybrsablona;
                data.pozadavky = ids;
                //var data_send = JSON.stringify(ids);                  
                var data_send = JSON.stringify(data);
                PageMethods.ZmenaStavu(data_send, stav, upravUIPoZmeneStavu, onPageMethodError);--%>
                zm_stavu(stav);
            }
        }

        function zm_stavu(stav) {
            $find('<%= RALP_TRadGrid.ClientID %>').show('<%= TRG_odmeny.ClientID %>');
                var poznamka = $find("<%= txt_poznamka.ClientID %>").get_value();
                var ids = [];
            var mtv = $find("<%= TRG_odmeny.ClientID %>").get_masterTableView();
            var its = mtv.get_selectedItems();
            for (var j = 0; j < its.length; j++) {
                var id_poz = its[j].getDataKeyValue("id_poz");
                var index = its[j]._itemIndex;
                ids.push(
                    {
                        "id_poz": id_poz,
                        "index": index,
                        "poznamka": poznamka
                    }
                )
            }
            var data = {};
            data.rok = sablona_rok;
            data.mes = sablona_mes;
            data.sablona = sablona_vybrsablona;
            data.pozadavky = ids;                       
            var data_send = JSON.stringify(data);
            PageMethods.ZmenaStavu(data_send, stav, upravUIPoZmeneStavu, onPageMethodError);
        }

        function button_zmena_stavu_OnClientClicked(sender, args) {
           <%-- $find('<%= RALP_TRadGrid.ClientID %>').show('<%= TRG_odmeny.ClientID %>');
                var poznamka = $find("<%= txt_poznamka.ClientID %>").get_value();
                var ids = [];
            var mtv = $find("<%= TRG_odmeny.ClientID %>").get_masterTableView();
            var its = mtv.get_selectedItems();
            for (var j = 0; j < its.length; j++) {
                var id_poz = its[j].getDataKeyValue("id_poz");
                var index = its[j]._itemIndex;
                ids.push(
                    {
                        "id_poz": id_poz,
                        "index": index,
                        "poznamka": poznamka
                    }
                )
            }
            var data = {};
            data.rok = sablona_rok;
            data.mes = sablona_mes;
            data.sablona = sablona_vybrsablona;
            data.pozadavky = ids;
            //var data_send = JSON.stringify(ids);                  
            var data_send = JSON.stringify(data);           
            PageMethods.ZmenaStavu(data_send, sender.get_value(), upravUIPoZmeneStavu, onPageMethodError);--%>
            zm_stavu(sender.get_value());
        }
       
        function upravUIPoZmeneStavu(args) {
            resetSessionTimeout();
            if (args != undefined && !args.Validace.IsValid)
            {
                $find('<%= RALP_TRadGrid.ClientID %>').hide('<%= TRG_odmeny.ClientID %>');
                var alertWnd=radalert(args.Validace.ErrorsAll);
                alertWnd.get_popupElement().style.zIndex = 10100;
                return;
            }

            var grid = $find("<%= TRG_odmeny.ClientID %>");
             <%--
            for (var i = 0; i < args.length; i++) {
                var itemIndex = args[i].Item2;
                disableRowsIndexes.push(itemIndex);               
                var mtv = grid.get_masterTableView();
                var row = mtv.get_dataItems()[itemIndex];              
                var count = mtv.get_columns().length;
                var c = row.get_cell("stav_text");
                c.innerHTML = args[i].Item3;
                c.style.color = "Black";

                var colls = mtv.get_columns();
                for (var j = 0; j < count; j++) {
                    var un = colls[j].get_uniqueName();
                    var cc = row.get_cell(un);                   
                    $(cc).css({ backgroundColor: "" });                      
                    $(cc).children("input").remove();
                }              
            }--%>
            //načítám celý grid
            $find("<%= rb_nacist.ClientID %>").click();

            grid.clearSelectedItems();

            resetCombo();

            $find("<%= txt_poznamka.ClientID %>").set_value("");
            
            $find('<%= RALP_TRadGrid.ClientID %>').hide('<%= TRG_odmeny.ClientID %>');
        }
        function resetCombo() {
            resetSessionTimeout();
            var combo = $find("<%= combo_zmena_stavu.ClientID %>");
            combo.trackChanges();            
            combo.get_items().clear();
            combo.set_text("");          
            combo.commitChanges();
        }

        function TRG_odmeny_OnRowCreated(sender, args) {

        }
        function rcb_sablony_OnClientSelectedIndexChanged(sender, args) {           
            PageMethods.NastavSablonu(sender.get_value());
            PageMethods.RemoveFilterPrizn();
            //loadStateWindow();
        }

        function TRB_filtrace_CheckedChanged(sender, args) {
            PageMethods.NastavFiltraci(args.get_checked(), afterFiltr);            
        }

        function Sablony_Disabled(prep) {           
            setTimeout(() =>
            {
                var rcb_s = $find("<%= rcb_sablony.ClientID %>");
                if(prep)
                    rcb_s.disable();
                else
                    rcb_s.enable();
            }, 500);
        }

        function afterFiltr() {           
            $find("<%= rb_nacist.ClientID %>").click();                 
        }
        
       <%-- function TRG_odmeny_OnColumnHidden(sender, args) {
            $find("<%= TRG_odmeny.ClientID %>").repaint();          
            if (visibleChange) return;
            saveStateWindow();
        }
        function TRG_odmeny_OnColumnShown(sender, args) {
            $find("<%= TRG_odmeny.ClientID %>").repaint();
            if (visibleChange) return;
            saveStateWindow();
        }--%>

        function loadStateWindow() {          
            PageMethods.LoadStateSeznam(loadStateOk, onPageMethodError);
        }

        function loadStateOk(res) {           
            resetSessionTimeout();
            sablona_visible_settings = [];
            if (res === "") return;
            sablona_visible_settings = JSON.parse(res);
            
            if (vybranasablona == "") return;
           
            var grid = $find("<%= TRG_odmeny.ClientID %>");
            var mtv =grid.get_masterTableView();
            var cols = mtv.get_columns();           
            for (var i = 0; i < sablona_visible_settings.collvisible.length; i++) {
                var sl = sablona_visible_settings.collvisible[i];
                var result = cols.find(item => item.get_uniqueName() === sl.name);
                if (result != undefined && result != null) {                  
                   
                    var element = result.get_element();
                    var width = element.clientWidth;
                    if (!sl.visible)
                    {
                        mtv.hideColumn(i + 1);
                        grid.get_element().offsetWidth = (grid.get_element().offsetWidth - width);
                    }
                    else
                    {
                        mtv.showColumn(i + 1);
                        grid.get_element().offsetWidth = (grid.get_element().offsetWidth + width);
                    }                                   
                }
            }
            grid.repaint();
        }       

        function saveStateWindow() {                           
            wndStateColls = [];          
            for (var c of sablona_col_check_arr) {                
                var vis = $('#' + c.id).is(':checked');
                var obj =
                {
                    name: c.column,
                    visible: vis
                }
                wndStateColls.push(obj);
            }
            var wndState =
            {
                collvisible: wndStateColls,
                sablona: vybranasablona
            }
            if (window.JSON && window.JSON.stringify) {               
                if (saveStateTimeOut)
                    clearTimeout(saveStateTimeOut);
                saveStateTimeOut = setTimeout(function () { PageMethods.SaveStateSeznam(JSON.stringify(wndState)); }, 500);
            }
        }

        function TRG_odmeny_OnColumnShowing(sender, args) {

        }

        function TRG_odmeny_OnColumnContextMenu(sender, args) {           
        }

        function TRG_odmeny_OnGridCreated(sender, args) {
            loadStateWindow();
           
            if (sablona_arrCol.length > 0) {
                sablona_col_check_arr = JSON.parse(sablona_arrCol);
                sablona_col_check_arr.forEach(checkColumn);
            }           
        }        

        function TRB_export_OnClientClicked(sender, args) {          
            var grid = $find("<%= TRG_odmeny.ClientID %>");
            var filterVisible = grid.get_masterTableView().get_isFilterItemVisible(); // object s nastavením menu            
            if (filterVisible) {  
                let alertWnd = radalert("Při zapnuté filtraci není dostupný export");
                alertWnd.get_popupElement().style.zIndex = 10100;
                return;
            }          
            grid.repaint();            
            grid.get_masterTableView().exportToExcel();
        }
       
        function setWidthAria(width) {
            var dataDiv = $telerik.findElement(grid.get_element(), grid.get_id() + "_GridData");
            $(dataDiv).width(width);
        }

        function showItemMenu(item) {
            var visible = false;
            if (sablona_visible_settings.collvisible == undefined) {
                visible = true;
                sablona_visible_settings.collvisible = [];
                //pokud dosud nebylo uloženo tak zde implicitně plním
                var masterTableView = $find("<%=TRG_odmeny.ClientID %>").get_masterTableView();
                var columns = masterTableView.get_columns();               
                for (var c of columns) {
                    var uniqName = c.get_uniqueName();
                    if (uniqName != "ClientSelectColumn") {
                        var obj =
                        {
                            name: uniqName,
                            visible: true
                        }
                        sablona_visible_settings.collvisible.push(obj);
                    }
                }
            }
            if (sablona_visible_settings.collvisible.find(it => it.name == item.column) != undefined &&
                sablona_visible_settings.collvisible.find(it => it.name == item.column) != null)
                visible = sablona_visible_settings.collvisible.find(it => it.name == item.column).visible;           

            $("#" + item.id).prop("checked", visible);

        }
        function TRG_odmeny_OnHeaderMenuShowing(sender, args) {
            sablona_col_check_arr.forEach(showItemMenu);
        }        

        function selectAllRows(checkBox) {           
            var checked = false;
            if ($(checkBox).is(':checked'))
                checked = true;

            var grid = $find("<%=TRG_odmeny.ClientID %>");
            var mtv = grid.get_masterTableView();
            grid.clearSelectedItems();                    
            if (!checked) return;
            var stav_old = "";
            var di = mtv.get_dataItems();
            for (var i = 0; i < di.length; i++) {
                var cc = di[i].get_cell("ClientSelectColumn");
                if (cc) {
                    var cl = $(cc.children[0]).attr("class");
                    if (cl == "aspNetDisabled") {
                        continue;
                    }
                    else {
                        var st = di[i].getDataKeyValue("stav");
                        if (st == stav_old || stav_old == "") {
                            stav_old = st;                           
                            di[i].set_selected(true);
                        }
                        else {
                            nelzeVybirat();
                            return;
                        }
                    }
                }
            }         
        }

        function StavFilterChanged(sender, args) {             
            var tableView = $find("<%=TRG_odmeny.ClientID %>").get_masterTableView();
            var val = args.get_item().get_value();
            if (val == "Vše" || val=="")
                tableView.filter("stav_text", "", "NoFilter");
            else
                tableView.filter("stav_text", val, "EqualTo");
        }        

        function disableCheckBox() {
            $("#ctl00_HlavniOblast_TRG_odmeny_ctl00_ctl02_ctl00_ClientSelectColumnSelectCheckBox").attr('disabled', 'true');
        }

        function TRG_odmeny_OnMasterTableViewCreated(sender, args) {                      
            setTimeout(upravvVyskyRadku(sender), 500);
        }

        function upravvVyskyRadku(sender) {
            var trs = $("#ctl00_HlavniOblast_TRG_odmeny_ctl00 .rgAltRow, #ctl00_HlavniOblast_TRG_odmeny_ctl00 .rgRow");
            for (var i = 0; i < trs.length; i++) {
                var rh = $(trs[i]).height();
                $("#" + trs[i].id + " td:first-child").css("height", rh + "px");
            }
            var tr = $("#ctl00_HlavniOblast_TRG_odmeny_ctl00_Header> thead");
            var rh = $(tr).height();
            $(tr).css("height", rh + 15 + "px");
        }

        function checkColumn(item) {            
            var element = $("#" + item.id);
            var col = item.column;            
            element.click(function () { checkedChanged(element, col) });
        }

        function setScrollAr(sender, width) {
            var scrollArea = sender.GridDataDiv;
            var dataWidth = sender.get_masterTableView().get_element().clientWidth;
            // if (dataHeight < 350) {
            scrollArea.style.width = dataWidth + width + "px";
        }

        function checkedChanged(el, col) {
            var grid = $find("<%=TRG_odmeny.ClientID %>");
            var visible = $(el).prop("checked");
            sablona_visible_settings.collvisible.find(it => it.name == col).visible = visible;
            var index = sablona_visible_settings.collvisible.findIndex(it => it.name == col) + 1;           

            var tableView = grid.get_masterTableView();
            var column = tableView.getColumnByUniqueName(col);
            var element = column.get_element();
            var width=element.clientWidth;
            if (visible)
                tableView.showColumn(index);                          
            else
                tableView.hideColumn(index);                         
            saveStateWindow();              
        }

        function rbtJenPrimePodrizene_OnClientCheckedChanged(sender, args) {
            let checked = args.get_checked();
            PageMethods.PrimePodrizeneCheckeChanged(checked, afterJenPrimePodrizene);           
        }
        function afterJenPrimePodrizene() {
            $find("<%= rb_nacist.ClientID %>").click();
        }
    </script>   
        
   <style type="text/css">
       td[role=gridcell]
       {
           vertical-align:top;
       }      

       .ks-zm {
            position: relative;
       }
       .ks-zm:after { 
            content: "";
            position: absolute;
            top: 0;
            right: 0;
            width: 0; 
            height: 0; 
            display: block;
            border-left: 10px solid transparent;
            border-bottom: 10px solid transparent;

            border-top: 10px solid #f00;
       }
       .zneplatneno
       {
           text-decoration: line-through;
       }
       .dispay_none *{
           display:none;
       }
       .ks-pen {
           margin-left:3px;
       }
       #div_grid{
           min-height:200px !important;
       }
      /* #grid_pozn .k-grid-content{
           height:calc(100% - 400px);
           overflow-y:auto;
           background-color:red;
       }

       #wnd_pozn .k-window-content
       {
           height:600px;
           overflow-y:hidden !important;
           display:flex;
       }*/

       /*.k-window:not([data-window="wnd_budgety"]){
           z-index:3000 !important;
       }*/
       .k-window-titlebar
       {
           background-color:var(--kscolor1);
           color:var(--kscolor1text);
       }
       .k-grid
       {
           line-height:16px !important;
           font-size: 13px !important;
       }       
       .k-combobox {
		    width: 100% !important;
	    }
       /*.k-grid-content .k-invalid-msg {
            position: absolute;
            margin: 0;
            padding: 0;
            color: red;
        }*/
       .RadGrid .rgFilterRow>td {
            padding-left: 2px;
            padding-right: 2px;
        }
       .ks-nowrap{
           white-space:nowrap;
       }
       .ks-pt-pozn-item
       {
           display:inline-block;
           width:calc(100% - 20px);
       }
       .ks-castka
       {
           text-align:right !important;
       }        

   </style>
         </telerik:RadCodeBlock>   

    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">               
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="rb_nacist">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRG_odmeny" UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="TRG_odmeny">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRG_odmeny" UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
             <telerik:AjaxSetting AjaxControlID="rb_nacist">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="rb_nacist" UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
             <telerik:AjaxSetting AjaxControlID="TRB_filtrace">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRB_filtrace" UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
           <telerik:AjaxSetting AjaxControlID="TRB_export">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRB_export" UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            
           

            <telerik:AjaxSetting AjaxControlID="rb_nacist">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="combo_zmena_stavu" UpdatePanelCssClass="" />
                </UpdatedControls>
            </telerik:AjaxSetting>            
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>

     <div style="white-space:nowrap;">
          <table>
             <tr>
                 <td>
                      <kspwc:TRadMonthYearPicker runat="server" ID="rmyp_obdobi" Width="160px" AutoPostBack="true"  >
        <DateInput runat="server" DateFormat="MMMM yyyy" DisplayDateFormat="MMMM yyyy" EmptyMessage="[%Období%]">
        </DateInput>
    </kspwc:TRadMonthYearPicker>
                 </td>
                 <td>                    
                      <kspwc:TRadComboBox runat="server" ID="rcb_sablony" ToolTip="Šablonu lze vybrat jen při vypnuté filtraci"  AutoPostBack="false" EmptyMessage="Šablona" OnClientSelectedIndexChanged="rcb_sablony_OnClientSelectedIndexChanged" Width="150"  >                         
                      </kspwc:TRadComboBox>
                 </td>
                 <td>
                     <kspwc:TRadButton runat="server" Text="Načíst" ID="rb_nacist" OnClick="rb_nacist_Click" AutoPostBack="true">                       
                         <Icon PrimaryIconCssClass="fi fi-rotate-right"></Icon>
                     </kspwc:TRadButton>
                 </td>
                  <td style="padding-left:30px">                   
                      <kspwc:TRadButton ID="TRB_filtrace" runat="server" AutoPostBack="true" OnClick="TRB_filtrace_Click" OnClientCheckedChanged="TRB_filtrace_CheckedChanged" Icon-PrimaryIconCssClass="fi fi-filter"
                            Text="[%Filtr%]" ToggleType="CheckBox">
                        </kspwc:TRadButton>                    
                 </td>
                 <td> 
                    <kspwc:TRadButton runat="server" Text="Export" ID="TRB_export" AutoPostBack="false" OnClientClicked="TRB_export_OnClientClicked"></kspwc:TRadButton>
                 </td>
                 <td style="padding-left:30px">
                      <telerik:RadLabel runat="server" ID="lab_hrom_zmena" Text="" ></telerik:RadLabel>
                      <%--OnClick="button_zmena_stavu_Click"--%>
                     <kspwc:TRadButton runat="server" Text="&nbsp;" ID="button_zmena_stavu"  AutoPostBack="false" CssClass="kstlacitko" OnClientClicked="button_zmena_stavu_OnClientClicked"  >
                         <Icon PrimaryIconCssClass="fi fi-assept-document" />
                     </kspwc:TRadButton>
                 </td>
                 <td>
                     <kspwc:TRadComboBox runat="server" ID="combo_zmena_stavu" AutoPostBack="false" EmptyMessage="Výběr stavu" Width="250"  >    
        </kspwc:TRadComboBox>
                 </td>
                 <td>
                      <telerik:RadTextBox runat="server" ID="txt_poznamka" EmptyMessage="Poznámka" AutoPostBack="false" ></telerik:RadTextBox>
                 </td>
                 <td>                     
                     <%--<telerik:RadButton runat="server" ID="butt_provest" Text="Provést" AutoPostBack="false" OnClientClicked="butt_provest_OnClientClicked" ></telerik:RadButton>--%>
                     <kspwc:TRadButton runat="server" ID="butt_provest" Text="Provést" AutoPostBack="false" OnClientClicked="butt_provest_OnClientClicked" ></kspwc:TRadButton>
                 </td>
                 <td>
                     <%--OnCheckedChanged="rbtJenPrimePodrizene_CheckedChanged"--%>
                     <telerik:RadButton ID="rbtJenPrimePodrizene" runat="server" ToggleType="CheckBox" CssClass="popupCheck"
                        ButtonType="ToggleButton" Text="[%Omezit přístup jen na přímé podřízené%]" AutoPostBack="false"
                         OnLoad="rbtJenPrimePodrizene_Load" OnClientCheckedChanged="rbtJenPrimePodrizene_OnClientCheckedChanged">
                        <ToggleStates>
                            <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-checkbox"></telerik:RadButtonToggleState>
                            <telerik:RadButtonToggleState PrimaryIconCssClass="fi fi-square"></telerik:RadButtonToggleState>
                        </ToggleStates>
                    </telerik:RadButton>
                 </td>
                 <td>
                     <div id="pan_suma_naroku" style="display:none" >
                         <div>
                             <asp:Label runat="server" ID="lab_suma_popisek" Text="Suma Nároků za zadavatele:" style="display: inline-block; width:190px"></asp:Label>
                             <telerik:RadTextBox runat="server" id="lab_suma_naroku" ReadOnly="true" Width="80" Height="20" HoveredStyle-HorizontalAlign="Right" ReadOnlyStyle-HorizontalAlign="Right"></telerik:RadTextBox>
                         </div>
                         <div>
                             <asp:Label runat="server" ID="Label1" Text="Suma částek:" style="display: inline-block; width:190px"></asp:Label>
                             <telerik:RadTextBox runat="server" id="lab_suma_castek" ReadOnly="true" Width="80"  Height="20" HoveredStyle-HorizontalAlign="Right"  ReadOnlyStyle-HorizontalAlign="Right"></telerik:RadTextBox>
                         </div>
                          <div>
                             <asp:Label runat="server" ID="Label2" Text="Rozdíl:" style="display: inline-block; width:190px"></asp:Label>
                             <telerik:RadTextBox runat="server" id="lab_rozdil" ReadOnly="true" Width="80"  Height="20" HoveredStyle-HorizontalAlign="Right"  ReadOnlyStyle-HorizontalAlign="Right"></telerik:RadTextBox>
                         </div>
                      </div>
                 </td>
             </tr>
         </table>
    <%-- <kspwc:TRadMonthYearPicker ID="rmyp_obdobi" runat="server" AutoPostBack="true" OnSelectedDateChanged="rmyp_obdobi_SelectedDateChanged" ShowPopupOnFocus="True">
       
       
    </kspwc:TRadMonthYearPicker>--%>
    <%--DateInput-ClientEvents-OnValueChanged="rmyp_obdobi_OnValueChanged"--%>
   
  
 
   
    <%--OnClientSelectedIndexChanged="combo_zmena_stavu_OnClientSelectedIndexChanged"--%> 
       
    </div>
    <%-- <telerik:RadPersistenceManagerProxy ID="RadPersistenceManagerProxy1" runat="server">
         <PersistenceSettings>
             <telerik:PersistenceSetting ControlID="TRG_odmeny" />
         </PersistenceSettings>
    </telerik:RadPersistenceManagerProxy>--%>
    <div id="div_grid">
    <kspwc:TRadGrid ID="TRG_odmeny" runat="server"  AutoGenerateColumns="false" EnableViewState="false" CaptionVisible="false" Width="100%"  AutoMasterGridWidth="true" OnInit="TRG_odmeny_Init" AllowSorting="true" KSAutoFit="true"
        OnNeedDataSource="TRG_odmeny_NeedDataSource" OnItemCreated="TRG_odmeny_ItemCreated" OnItemDataBound="TRG_odmeny_ItemDataBound" AllowPaging="false" AllowCustomPaging="false"  AllowMultiRowSelection="True"  >
        <ExportSettings IgnorePaging="true" ExportOnlyData="true" OpenInNewWindow="true">
        </ExportSettings>
        <MasterTableView  DataKeyNames="id_poz,potvrzeno,stav" ClientDataKeyNames="id_poz,potvrzeno,stav" Width="100%" EnableHeaderContextMenu="True" AllowSorting="true" TableLayout="Fixed" EnableHeaderContextAggregatesMenu="false" PageSize="3000"  >
            <Columns>             
            </Columns>
            <CommandItemTemplate>
                <kspwc:GridCommandItemControl ID="gcic" runat="server" DateControl="TRadObdobi" ExportButton-ShowExportToExcelBIFFItem="true" ExportButton-ShowExportToCsvItem="false" ExportButton-ShowExportToExcelHtmlItem="false">
                </kspwc:GridCommandItemControl>
            </CommandItemTemplate>
        </MasterTableView>

        <ClientSettings EnableRowHoverStyle="true" AllowColumnHide="true" >
            <%--<Resizing ResizeGridOnColumnResize="true" />--%>
            <Selecting AllowRowSelect="True" UseClientSelectColumnOnly="true"  ></Selecting>  
          <%-- OnColumnHidden="TRG_odmeny_OnColumnHidden" OnColumnShown="TRG_odmeny_OnColumnShown"--%>
            <ClientEvents OnHeaderMenuShowing="TRG_odmeny_OnHeaderMenuShowing" OnRowSelected="TRG_odmeny_OnRowSelected" OnRowDeselecting="RG_odmeny_OnRowDeselecting" OnGridCreated="TRG_odmeny_OnGridCreated" OnRowSelecting="TRG_odmeny_OnRowSelecting"  OnRowCreated="TRG_odmeny_OnRowCreated"   OnMasterTableViewCreated="TRG_odmeny_OnMasterTableViewCreated" OnColumnShowing="TRG_odmeny_OnColumnShowing"  />
           <%-- <ClientEvents OnCommand="function(){}" />--%>
           <%--  FrozenColumnsCount="6" --%>
            <Scrolling AllowScroll="True" EnableVirtualScrollPaging="false" UseStaticHeaders="True" SaveScrollPosition="true">

            </Scrolling>
        </ClientSettings>
         <PagerStyle Mode="NumericPages" />        
    </kspwc:TRadGrid>
    <telerik:RadAjaxLoadingPanel runat="server" ID="RALP_TRadGrid"></telerik:RadAjaxLoadingPanel>
        </div>

    <asp:HiddenField runat="server" ID="hf_sablona" /> 
    <asp:HiddenField runat="server" ID="hf_grid" />
    <div id="wnd" class="ksprvek" style="z-index:3001">
        <div id="grid_editace"></div>          
    </div>
    <div id="wnd_pozn" class="ksprvek" style="z-index:3001">
        <div id="grid_pozn"></div>          
    </div>
    <div id="wnd_loko" class="ksprvek" data-window="wnd_budgety" style="z-index:3002">
        <div id="grid_loko"></div>          
    </div>    
    <div id="wnd_lom" class="ksprvek" style="z-index:3002">
        <div id="grid_lom"></div>          
    </div>    
    <script type="text/javascript">
        
        $(document).ready(function () {
            var odmeny_pt_selAllElem = $("#ctl00_HlavniOblast_TRG_odmeny_ctl00_ctl02_ctl00_ClientSelectColumnSelectCheckBox")
            odmeny_pt_selAllElem.removeAttr("onclick");
            odmeny_pt_selAllElem.on("click", function () {
                selectAllRows(odmeny_pt_selAllElem);
            }); 

            createGridEditace();

            window_edit = $("#wnd").kendoWindow({
                height: 620,
                width: 900,
                visible: false,
                appendTo: "#aspnetForm",               
                open: function (e) {                   
                    setTimeout(function () {                       
                        if (EditWindowHeight != null) {                           
                            $("#wnd").data("kendoWindow").setOptions({ height: (EditWindowHeight + 120).toString() + "px" });
                            $("#wnd").data("kendoWindow").center();
                        }
                    })
                }
            }).data("kendoWindow");

            window_edit.one("activate", function () { // can use also 'bind' method as Kendo widgets support the "one" and "bind"               
                $("#grid_editace").resize();
            });
            window_edit.one("close", function () {
                $('#div_check_all').remove();
                data_editace = [];
                repaintGrid();                         
            });

            createWindowPoznamky();

            $("#wnd_loko").kendoWindow({
                height: 500,
                width: 750,
                visible: false,
                actions: ["Minimize", "Maximize", "Pin", "Resize"],
                title:"Rekapitulace rozdělení",
                appendTo: "#aspnetForm",
                modal:false,
                open: function (e) {
                    this.center();                    
                }                
            }).data("kendoWindow");

            var dsloko = new kendo.data.DataSource({
                batch: false,
                pageSize: 20,
                schema: {
                    model: {
                        fields: {                           
                            Vedouci: { type: "string", editable: false, locked: true },
                            PremieZadana: { type: "number", editable: false },
                            PremieSchvalena: { type: "number", editable: false },
                            PremieNeSchvalena: { type: "number", editable: false },
                            PrevedenoSem: { type: "number", editable: false },
                            PrevedenoPryc: { type: "number", editable: false },
                            UpravenyNarok: { type: "number", editable: false }
                        }
                    }
                }
            });

            $("#grid_loko").kendoGrid({
                dataSource: dsloko,
                navigatable: true,
                pageable: false,
                editable: false,
                width: "100%",
                height: "100%",
                columns: [                    
                    {
                        field: "Vedouci", title: "Vedoucí", width: 150
                    },
                    {
                        field: "PremieZadana", title: "K rozdělení", width: 90, attributes: { class: "ks-castka"}
                    },
                    {
                        field: "PremieSchvalena", title: "Schváleno", width: 90, attributes: { class: "ks-castka" }
                    },
                    {
                        field: "PremieNeSchvalena", title: "Nepřiznáno", width: 90, attributes: { class: "ks-castka" }
                    },
                    {
                        field: "PrevedenoSem", title: "Přijato", width: 90, attributes: { class: "ks-castka" }
                    },
                    {
                        field: "PrevedenoPryc", title: "Odesláno", width: 90, attributes: { class: "ks-castka" }
                    },
                    {
                        field: "UpravenyNarok", title: "Upravený nárok", width: 90, attributes: { class: "ks-castka" }
                    }
                ]
            });

            //////////////////////////////////////////////////////////
            $("#wnd_lom").kendoWindow({
                height: 500,
                width: 750,
                visible: false,
                actions: ["Minimize", "Maximize", "Pin"],
                title: "Rekapitulace rozdělení",
                appendTo: "#aspnetForm",
                open: function (e) {                                               
                    this.center();
                }
            }).data("kendoWindow");

            var dslom = new kendo.data.DataSource({
                batch: false,
                pageSize: 20,
                schema: {
                    model: {
                        fields: {                           
                            VedouciCele: { type: "string", editable: false, locked: true },
                            SumaNaroku: { type: "number", editable: false },
                            SumaCastek: { type: "number", editable: false },
                            Rozdil: { type: "number", editable: false }                           
                        }
                    }
                }
            });

            $("#grid_lom").kendoGrid({
                dataSource: dslom,
                navigatable: true,
                pageable: false,
                editable: false,
                width: "100%",
                height: "100%",
                columns: [                   
                    {
                        field: "VedouciCele", title: "Vedoucí", width: 150
                    },
                    {
                        field: "SumaNaroku", title: "Suma nároků", width: 90, attributes: { class: "ks-castka" }
                    },
                    {
                        field: "SumaCastek", title: "Suma částek", width: 90, attributes: { class: "ks-castka" }
                    },
                    {
                        field: "Rozdil", title: "Rozdíl", width: 90, attributes: { class: "ks-castka" }
                    }                   
                ]
            });
            /////////////////////////////////////////////////////////
        });       
    </script>
</asp:Content>
