﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="PrijateZpravy.aspx.cs" Inherits="KSPortal.Zamestnanec.PrijateZpravy" %>

<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="asp" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <style type="text/css">
        .linkButton {
            background-color: transparent !important;
            border: none !important;
        }

        .setButtons { 
            float: right;
            margin-left: 10px;
        }

        div.RadWindow .rwControlButtons li a.customprintbutton {
            background: url(../Images/print_title_bar.png) no-repeat;
        }

        div.RadWindow .rwControlButtons li a.customprintbutton:hover {
            background: url(../Images/print_title_bar.png) 0 -21px no-repeat;
        }
       
        /* ensure the before pseudoelement is not visible. If you will be using custom font icons, tweak this accordingly */
        div.RadWindow .rwCommandButton.customprintbutton::before {
            display: none;
            content: ""; /* this is where you can set your own custom font icon. You will also need to set the appropriate font name */
        }

    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HlavniOblast" runat="server">
    <script type="text/javascript">  
    </script>
    <telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server" >
        <AjaxSettings>
            <telerik:AjaxSetting AjaxControlID="MarkMsgAsRead">
                <UpdatedControls >
                    <telerik:AjaxUpdatedControl ControlID="GridPanel" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="GridPanel">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGrid1" />
                    <telerik:AjaxUpdatedControl ControlID="RTS_menu" />
                    <telerik:AjaxUpdatedControl ControlID="RadEditor1" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="RadAjaxManager1">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="RadImageEditor1" />
                    <telerik:AjaxUpdatedControl ControlID="AsyncUpload1" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="ReSendPanel">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="ReSendPanel" />
                </UpdatedControls>
            </telerik:AjaxSetting>
            <telerik:AjaxSetting AjaxControlID="BTNSendNewMsg">
                <UpdatedControls>
                    <telerik:AjaxUpdatedControl ControlID="TRadGrid1" />
                    <telerik:AjaxUpdatedControl ControlID="PanelNM" />
                    <telerik:AjaxUpdatedControl ControlID="BTNCloseNewMsg" />
                </UpdatedControls>
            </telerik:AjaxSetting>
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
    <asp:Label ID="nadpis" runat="server" CssClass="nadpis1" Text="[%Zprávy%]"></asp:Label>
    <telerik:RadScriptBlock ID="RSBlock1" runat="server" >
        <script type="text/javascript">
            function GetMessage(arg) {
                VymazatObsahZpravy();

                PageMethods.GetMessage(arg, onSucceed, onError);

                var WRMess = $find("<%= RadWindowRead.ClientID %>");
                if (WRMess) {
                    if (WRMess.isClosed()) {
                        WRMess.show();
                    }
                }
                return false;
            }
            function onSucceed(result) {
                var json;
                try {
                    json = JSON.parse(result);
                } catch (e) {
                    document.getElementById("id_telo").innerHTML = result;
                    return;
                }
                document.getElementById("id_msg").innerHTML = json.message.id;
                document.getElementById("id_predmet").innerHTML = json.message.predmet;
                document.getElementById("id_odesilatel").innerHTML = json.message.odesilatel;
                document.getElementById("id_odeslano").innerHTML = json.message.odeslano;
                document.getElementById("id_prijemce").innerHTML = json.message.prijemce;
                document.getElementById("id_prijato").innerHTML = json.message.prijato;
                document.getElementById("id_telo").innerHTML = json.message.telo;
                document.getElementById("id_prilohy").innerHTML = "";
                var index, len;
                for (index = 0, len = json.message.prilohy.length; index < len; ++index) {
                    $("<a>", { OnClick: "Download('" + json.message.prilohy[index].argument + "')", text: json.message.prilohy[index].nazev, cssclass: "no-block-ui", style:"cursor: pointer;" }).appendTo("#id_prilohy");
                    $("<span style='padding-left:10px'>" + json.message.prilohy[index].size + "</span>").appendTo("#id_prilohy");
                    $("<br/>").appendTo("#id_prilohy");
                }

                

                if (json.message.odesilatel == json.message.prijemce || json.message.user == json.message.odesilatel) {
                    var but = $find("<%= odpovedRedMsg.ClientID %>");
                    but.set_visible(false);
                }

                ResizeReadWin();
            }
            function onError(result) {
                document.getElementById("id_telo").innerHTML = result;
            }

            function ResizeReadWin()
            {
                var WRMess = $find("<%= RadWindowRead.ClientID %>");
                if ( WRMess != undefined)
                    WRMess.autoSize(true);
            }

            function VymazatObsahZpravy() {
                document.getElementById("id_predmet").innerHTML = "";
                document.getElementById("id_odesilatel").innerHTML = "";
                document.getElementById("id_odeslano").innerHTML = "";
                document.getElementById("id_prijemce").innerHTML = "";
                document.getElementById("id_prijato").innerHTML = "";
                document.getElementById("id_telo").innerHTML = "";
                document.getElementById("id_prilohy").innerHTML = "";
                document.getElementById("id_msg").innerHTML = "";
                var but = $find("<%= odpovedRedMsg.ClientID %>");
                but.set_visible(true);
                var autoCompleteBox = $find("<%= RadAutoCompleteBox2.ClientID %>");
                autoCompleteBox.get_entries().clear();
                $find("<%= TB_Predmet.ClientID %>").set_value("");
                $find("<%= RadEditor1.ClientID %>").set_html("");
                var upload = $find("<%= RadAsyncUpload1.ClientID %>");
                var inputs = upload.getUploadedFiles().length;
                for (i = 0; i <= inputs; i++) {
                    upload.deleteFileInputAt(0);
                }
                //skryji obsah zpravy
                document.getElementById('div_readwin_read').style.display = 'block';
                //odkryji odpoved
                document.getElementById('div_readwin_send').style.display = 'none';
            }

            function Download(arg) {
                var button = $find("<%= TRBDownload.ClientID %>");
                button._commandArgument = arg;
                var but = document.getElementById("<%= TRBDownload.ClientID %>");
                but.click();
            }

            function OnClientShowReadWin(sender, args)
            {
                AddPrintButton(sender, 'read');
                fixEditor(sender, args);
            }

            function AddPrintButton(sender, args) {
                var TitleBar = sender.GetTitlebar();
                var parent = TitleBar.parentNode;
                var oUL = parent.getElementsByTagName('UL')[0];
                if (!(oUL.firstChild.id == "customprintbuttonID")) // Check if the element is already added 
                {
                    // If not - create and add the custom button 
                    var oLI = document.createElement("LI");
                    oLI.id = "customprintbuttonID"

                    //create the actual button
                    var customBtn;
                    //set the proper custom button class for decoration
                    var customBtnClass = "customprintbutton";
                    //choose the handler for the button
                    var desiredHandler = printWin;

                    switch (sender._renderMode) {
                        case Telerik.Web.UI.RenderMode.Lite: {//lightweight
                            customBtn = document.createElement("span");
                            customBtn.className = "rwCommandButton ";
                            oLI.className = "rwListItem";
                            break;
                        }
                        case Telerik.Web.UI.RenderMode.Classic: {//classic
                            customBtn = document.createElement("a");
                            customBtn.href = "javascript:void(0)";
                            //if the titlebar does not appear OK you may need to tweak its width
                            //oUL.style.width = "192px";
                            break;
                        }
                        default: {
                            if (console && console.log)
                                console.log("Unknown render mode. Examine the HTML to see what elements to use");
                        }
                    }

                    customBtn.className = customBtn.className + customBtnClass;
                    customBtn.title = "Print Content";
                    switch(args)
                    {
                        case 'new':
                            customBtn.type = "newMsg";
                            break;
                        case 'read':
                            customBtn.type = "reMsg";
                            break;
                    }
                    
                    //add the required handler for your custom functionality
                    if (Telerik.Web.UI.EventType) { //Q3 2015 versions and later - modern IE versions supported (e.g., Edge, 11)
                        var NS = ".wndCustomButton";
                        var DOWN_NS = Telerik.Web.UI.EventType.Down + NS;
                        $telerik.$(customBtn).onEvent(DOWN_NS, desiredHandler);
                    }
                    else { //old Telerik.Web.UI (pre Q2 2015)
                        customBtn.onmousedown = desiredHandler;
                    }

                    //add the custom button to the RadWindow
                    oLI.appendChild(customBtn);
                    oUL.insertBefore(oLI, oUL.firstChild);

                    //if RadWindow does not display its titlebar properly after being modified, uncomment this code:
                    //sender._updateTitleWidth();
                }
            }

            function printWin(e) {
                switch(e.currentTarget.attributes.type.value)
                {
                    case "newMsg":
                        var mywindow = window.open('', 'PRINT', 'height=400,width=600');
                        mywindow.document.write('<html><head><title>' + document.title + '</title>');
                        mywindow.document.write('</head><body >');
                        mywindow.document.write(document.getElementById('div_newwin_send').innerHTML);
                        mywindow.document.write('</body></html>');
                        mywindow.document.close(); // necessary for IE >= 10
                        mywindow.focus(); // necessary for IE >= 10*/
                        mywindow.print();
                        mywindow.close();
                        var WRMess = $find("<%= RadWindowNew.ClientID %>");
                        WRMess.autoSize(true);
                        break;
                        break;

                    case "reMsg":
                        var mywindow = window.open('', 'PRINT', 'height=400,width=600');
                        mywindow.document.write('<html><head><title>' + document.title + '</title>');
                        mywindow.document.write('</head><body >');
                        mywindow.document.write(document.getElementById('print_div_read').innerHTML);
                        mywindow.document.write('</body></html>');
                        mywindow.document.close(); // necessary for IE >= 10
                        mywindow.focus(); // necessary for IE >= 10*/
                        mywindow.print();
                        mywindow.close();
                        ResizeReadWin();
                        break;
                }
                
                //Cancel event
                if (!e)
                    e = window.event;

                return $telerik.cancelRawEvent(e);
            }




            //oznacit zpravu jako prectenou
            function MarkMessegeAsRead(sender, argument) {
                var button = $find("<%= MarkMsgAsRead.ClientID %>");
                button._commandArgument = argument._commandArgument;
                var but = document.getElementById("<%= MarkMsgAsRead.ClientID %>");
                but.click();
                OpenReadWin(sender, argument);
            }

            //zobrazit okno s novou zprávou
            function ShowNewMessageWindow(sender, eventArgs) {
                var WMess = $find("<%= RadWindowNew.ClientID %>");
                if (WMess) {
                    if (WMess.isClosed()) {
                        WMess.show();
                    }
                }
            }

            function OnClientCloseWinRead(sender, args) {
                if (document.getElementById('div_readwin_send').style.display = 'none') {
                    var WRMess = $find("<%= RadWindowRead.ClientID %>");
                    WRMess.hide();
                    VymazatObsahZpravy();
                }
            }

            function OnClientCloseWinNew(sender, args) {
                //pokud je zavření vyvoláno křížkem na okně
                if (args._cancel != undefined)
                    args._cancel = true;
                //zjistí jestli není rozepsaná zpráva
                var editor = $find('<%= RadEditorNewMSG.ClientID %>');
                var cnt = editor._contentArea.childNodes.length;
                //if (editor._contentArea.childNodes.length > 1) {
                //if (editor.get_html().length > 1) {
                    if (!window.confirm('<%= WebControlHelper.ZmenaTextu("[%Rozepsaná zpráva bude zrušena. Pokračovat?%]")  %>')) {
                        return;
                    }
                //}
                VymazNewMsg();
                var WMess = $find("<%= RadWindowNew.ClientID %>");
                WMess.hide();
            }

            function VymazNewMsg() {
                document.getElementById("NewMsgPredpetSpan").style.display = 'none';
                document.getElementById("NewMsgAdressSpan").style.display = 'none';
                //smaze zadaná data
                //smaze prijemce
                var autoComplete = $find("<%= RadAutoCompleteBoxNewMsg.ClientID %>");
                autoComplete.get_entries().clear();

                //smaze predmet
                var predmetBox = $find("<%= RadTextBoxPredmetNew.ClientID %>");
                predmetBox.clear();

                //smazu obsah zpravy
                var editor = $find("<%= RadEditorNewMSG.ClientID %>");
                editor.set_html('');

                //smazu prilohy
                var upload = $find("<%= RadAsyncUpload2.ClientID %>");
                var inputs = upload.getUploadedFiles().length;
                for (i = 0; i <= inputs; i++) {
                    upload.deleteFileInputAt(0);
                }
                
            }

            function OnClientShowWinNew(sender, args) {
                //VymazNewMsg();
                //AddPrintButton(sender, 'new');
                ResizeNW(null, null);
                fixEditor(sender, args);
            }

            //změní velikost okna
            function ResizeNW(sender, atgs) {
                var Win = $find("<%= RadWindowNew.ClientID %>");
                Win.autoSize(true);
            }

            <%--function SendNewMSG(sender, args) {
                var btnsend = document.getElementById(" <%= BTNSendNewMsg.ClientID %>");
                btnsend.click();
            }--%>

            function OdpovedetNaMSG(sender, args) {
                var pocet_priloh = Math.ceil(document.getElementById('id_prilohy').clientHeight / 17);
                //skryji obsah zpravy
                document.getElementById('div_readwin_read').style.display = 'none';
                //odkryji odpoved
                document.getElementById('div_readwin_send').style.display = 'block';
                //pridam prilohy
                ///
                var odesilatel = document.getElementById("id_odesilatel").innerHTML;
                //odpoved nebo preposlat
                if (args._commandArgument == 'true') //odpověd
                {
                    //vlozim príjemce
                    
                    var autoComplete = $find("<%= RadAutoCompleteBox2.ClientID %>");
                    var entry = new Telerik.Web.UI.AutoCompleteBoxEntry();
                    entry.set_text(odesilatel);
                    autoComplete.get_entries().add(entry);

                    //vlozim predmet
                    var predmet = document.getElementById("id_predmet").innerHTML;
                    var predmetBox = $find("<%= TB_Predmet.ClientID %>");
                    if (predmet.trim().indexOf('Re:') != 0) {
                        predmet = "Re: " + predmet;
                    }
                    predmetBox.set_value(predmet);

                    //vložím zprávu
                    var editor = $find("<%= RadEditor1.ClientID %>");
                    var zprava = document.getElementById("id_telo").innerHTML;
                    var datum = document.getElementById("id_odeslano").innerHTML;
                    editor.set_html("<br>--- " + odesilatel + " - " + datum + " ---<br>" + zprava);

                }
                else //preposlat
                {
                    //vlozim predmet
                    var predmet = document.getElementById("id_predmet").innerHTML;
                    var predmetBox = $find("<%= TB_Predmet.ClientID %>");
                    if (predmet.trim().indexOf('Fe:') != 0) {
                        predmet = "Fe: " + predmet;
                    }
                    predmetBox.set_value(predmet);

                    //vložím zprávu
                    var editor = $find("<%= RadEditor1.ClientID %>");
                    var zprava = document.getElementById("id_telo").innerHTML;
                    var datum = document.getElementById("id_odeslano").innerHTML;
                    editor.set_html("<br>--- " + odesilatel + " - " + datum + " ---<br>" + zprava);

                    //upravím višku
                    var div_pr = document.getElementById('repeat_prilohy');
                    if( div_pr != undefined)
                        div_pr.style.height = pocet_priloh * 23 +  23 + 'px';


                    //vložím přílohy pokud jsou
                    //nastavím id pro button
                    var but = $find("<%= nacist_prilohy.ClientID %>");
                    but._commandArgument = document.getElementById("id_msg").innerHTML;
                    but.click();
                }
                ResizeReadWin();
            }

            


            function OdeslatReSend(sender, args)
            {
                var predmetBox = $find("<%= TB_Predmet.ClientID %>");
                var autoComplete = $find("<%= RadAutoCompleteBox2.ClientID %>");
                var neco = autoComplete.get_text();
                var neco2 = predmetBox.get_textBoxValue();
                var cancel = false;
                //zobrazi se upozornění že není vyplněno
                if (neco == "") {
                    document.getElementById("ReSendMsgAdressSpan").style.display = 'block';
                    cancel = true;
                }
                else {
                    document.getElementById("ReSendMsgAdressSpan").style.display = 'none';
                }
                if (neco2 == "") {
                    document.getElementById("ReSendMsgPredmetSpan").style.display = 'block'
                    cancel = true;
                }
                else {
                    document.getElementById("ReSendMsgPredmetSpan").style.display = 'none';
                }
                if (cancel != true) {
                    var WRMess = $find("<%= RadWindowRead.ClientID %>");
                    WRMess.hide();
                    var but = $find("<%= odesla_zpravu.ClientID %>");
                    but.click();
                }
                
                // PMEJ 23.06.2025 - opraveno načítání další opovědi HID: 72825
                //skryji obsah zpravy
                document.getElementById('div_readwin_read').style.display = 'block';
                //odkryji odpoved
                document.getElementById('div_readwin_send').style.display = 'none';
            }

            function BTNSendNewMsg_ClientClick(sender, args) {
                var predmetBox = $find("<%= RadTextBoxPredmetNew.ClientID %>");
                var autoComplete = $find("<%= RadAutoCompleteBoxNewMsg.ClientID %>");
                var neco = autoComplete.get_text();
                var neco2 = predmetBox.get_textBoxValue();

                //zobrazi se upozornění že není vyplněno
                if (neco == "") {
                    document.getElementById("NewMsgAdressSpan").style.display = 'block';
                    args._cancel = true;
                }
                else {
                    document.getElementById("NewMsgAdressSpan").style.display = 'none';
                }
                if (neco2 == "") {
                    document.getElementById("NewMsgPredpetSpan").style.display = 'block'
                    args._cancel = true;
                }
                else {
                    document.getElementById("NewMsgPredpetSpan").style.display = 'none';
                }

                if (typeof (Page_ClientValidate) == 'function') {
                    Page_ClientValidate();
                }
                if (typeof (Page_IsValid) != 'undefined' && !Page_IsValid) {
                    args._cancel = true;
                    ResizeNW();
                }

                if (!args._cancel) {
                    var Win = $find("<%= RadWindowNew.ClientID %>");
                    Win.close();
                }

            }

            //otevreni okna pro precteni zpravy
            function OpenReadWin(sender, args) {
                GetMessage(args._commandArgument)
            }

            function OnClientCloseReadWin(sender, arg) {
                VymazatObsahZpravy();
            }

            
            function ZrusitZpravuReSend(sender, args) {
                if(confirm('<%= WebControlHelper.ZmenaTextu("Chcete zrušit zprávu?") %>'))
                {
                    OnClientCloseWinRead(null, null);
                    var but = $find("<%= smazat_prilohy.ClientID %>");
                    but.click();
                }
            }

            function RedWin_OnClientBeforeClose(sender, args) {
                if (document.getElementById('div_readwin_send').style.display == 'block') {
                    ZrusitZpravuReSend(null, null);
                    args._cancel(true);
                }
                
            }

            //zakazani drag and drop v editoru
            function OnClientLoadEditor(editor, args) {
                var element = document.all ? editor.get_document().body : editor.get_document();
                var eventHandler = document.all ? "drop" : "dragstart";
                var selElem = editor.getSelectedElement();
                $telerik.addExternalHandler(element, eventHandler, function (e) {
                    $telerik.cancelRawEvent(e);
                    return false;
                });
            }
            // Oprava editoru ve Window
            function fixEditor(sender, args) {
                $telerik.$(".RadEditor", sender.get_contentElement()).each(function (index, elem) {
                    if (elem.control && elem.control.onParentNodeChanged) elem.control.onParentNodeChanged();
                });
            }
        </script>

    </telerik:RadScriptBlock>
           
    <asp:Panel ID="GridPanel" runat="server">
        <telerik:RadTabStrip runat="server" ID="RTS_menu" SelectedIndex="0" OnTabClick="RTS_menu_TabClick" OnPreRender="RTS_menu_PreRender" CssClass="revertShadow">
            <Tabs>
                <telerik:RadTab ImageUrl="../Images/mailIncoming.png" Text="[%Přijaté zprávy%]"></telerik:RadTab>
                <telerik:RadTab ImageUrl="../Images/mailSend.png" Text="[%Odeslané zprávy%]"></telerik:RadTab>
                <%--<telerik:RadTab Enabled="false" Text="[%Koncepty%]"></telerik:RadTab>--%>
            </Tabs>
        </telerik:RadTabStrip>
         <%--<asp:Timer ID="Timer1" runat="server" Interval="60000" OnTick="Timer1_Tick"></asp:Timer>--%>
        <kspwc:TRadButton ID="MarkMsgAsRead" runat="server" OnClick="MarkMsgAsRead_Click" Style="display: none"></kspwc:TRadButton>
        <kspwc:TRadButton ID="TRBDownload" runat="server" OnClick="TRBDownload_Click" Style="display: none" CssClass="no-block-ui"></kspwc:TRadButton>
        <kspwc:TRadGrid ID="TRadGrid1" runat="server"
            ShowGroupPanel="True" AllowPaging="True" OnItemDataBound="TRadGrid1_ItemDataBound"
             AllowSorting="true" AutoGenerateColumns="false"
            DataSourceID="" AutoFilterControlWidth="false" GroupingEnabled="false"
            OnDataBound="TRadGrid1_DataBound" AllowMultiRowSelection="true" OnNeedDataSource="TRadGrid1_NeedDataSource">
            <MasterTableView CommandItemDisplay="top">
                <Columns>
                    <telerik:GridNumericColumn DataType="System.Int32" UniqueName="id" DataField="id" Display="false"></telerik:GridNumericColumn>
                    <telerik:GridClientSelectColumn UniqueName="ClientSelectColumn">
                    </telerik:GridClientSelectColumn>
                    <telerik:GridTemplateColumn UniqueName="detail" HeaderStyle-Width="40" ShowFilterIcon="false" FilterControlWidth="0" AllowFiltering="false">
                        <ItemTemplate>
                            <table align="left" style="border-collapse: collapse; padding: 0px; margin: 0px">
                                <tr>
                                    <td valign="bottom">
                                        <kspwc:TRadButton ID="TIB_detail" runat="server" ToolTip="[%Otevřít detail zprávy%]" CssClass="revertButton"
                                            AutoPostBack="false" Icon-PrimaryIconCssClass="fi fi-envelope-open-text">
                                        </kspwc:TRadButton>
                                    </td>
                                    <td valign="middle" style="padding-left: 5px">
                                        <kspwc:TImageButton ID="TIB_delete" runat="server" ImageUrl="~/Skins/ikony/uicons-regular-rounded/svg/fi-rr-trash.svg" ToolTip="[%Smazat zprávu%]" OnCommand="TIB_delete_Command" Height="18px" />
                                    </td>
                                    <td valign="middle">
                                        <asp:Image ID="priority" runat="server" Visible="false" />
                                    </td>
                                </tr>
                            </table>
                        </ItemTemplate>
                    </telerik:GridTemplateColumn>
                    <telerik:GridBoundColumn DataField="jmeno" UniqueName="jmeno" DataType="System.String" HeaderText="[%Odesílatel%]" FilterControlAltText="Filter jmeno column"></telerik:GridBoundColumn>

                    <telerik:GridBoundColumn DataField="jmeno" UniqueName="prijemce" DataType="System.String" HeaderText="[%Příjemce%]" FilterControlAltText="Filter jmeno column" Visible="false">
                    </telerik:GridBoundColumn>

                    <telerik:GridTemplateColumn HeaderText="[%Předmět%]" DataField="predmet" UniqueName="predmet" SortExpression="predmet" FilterControlAltText="Filter predmet column">
                        <ItemTemplate>
                            <kspwc:TRadButton ID="TLinkButton1" AutoPostBack="false" runat="server" ButtonType="LinkButton" CssClass="linkButton"></kspwc:TRadButton>
                        </ItemTemplate>
                    </telerik:GridTemplateColumn>
                    <telerik:GridDateTimeColumn DataField="vlozeno" FilterControlAltText="Filter vlozeno column"
                        HeaderText="[%Datum%]" HeaderStyle-HorizontalAlign="Left" UniqueName="vlozeno" DataType="System.DateTime" DataFormatString="{0:d.M.yyyy HH:mm}"
                        FilterDateFormat="d.M.yyyy" FilterControlWidth="100px" EnableTimeIndependentFiltering="true" />

                    <telerik:GridTemplateColumn UniqueName="priloha" HeaderStyle-Width="30px">
                        <ItemTemplate>
                            <asp:Image ID="priloha" runat="server" Visible='<%# (Int16)Eval("pocet_priloh") == 0 ? false : true %>' ImageUrl="~/Images/priloha.png" ToolTip='<%#Eval("pocet_priloh") %>' />
                        </ItemTemplate>
                    </telerik:GridTemplateColumn>

                </Columns>
                <CommandItemTemplate>

                    <kspwc:GridCommandItemControl ID="GridCommandItemControl1" runat="server" RebindButton-Visible="true" FilterButton-Enabled="True" ExportButton-Visible="False" ExportButton-Enabled="False">
                        <ContentTemplate>
                            <div class="gridCommandButton">
                                <telerik:RadScriptBlock ID="scriptBlockDeleteButton" runat="server">
                                    <script id="javaButtDel" type="text/javascript">
                                        function ShowHideDeleteButton(sender, arg) {

                                            var but2 = $find('<%# ((MyTemplateContainer)Container).FindControl("DeleteBut").ClientID  %>');
                                            if (sender._selectedIndexes.length > 0) {
                                                //but2.style.display = 'block';
                                                but2.set_enabled(true);
                                            }
                                            else {
                                                //but2.style.display = 'none';
                                                but2.set_enabled(false);
                                            }
                                        }

                                        function StandardConfirm(sender, args) {
                                            args.set_cancel(!window.confirm('<%# WebControlHelper.ZmenaTextu(this.Page, "[%Opravdu si přejete smazat tyto zprávy?%]")  %>'));
                                        }

                                    </script>
                                </telerik:RadScriptBlock>
                                <kspwc:TRadButton ID="DeleteBut" runat="server" Text="[%Smazat%]" AutoPostBack="true" Enabled="false"
                                    OnClientClicking="StandardConfirm" OnClick="DeleteBut_Click">
                                </kspwc:TRadButton>
                            </div>
                            <div class="gridCommandButton" style="float: right">
                                <kspwc:TRadButton ID="TLB_nova2" runat="server" OnClientClicked="ShowNewMessageWindow" AutoPostBack="false" Text="[%Nová zpráva%]">
                                    <Icon PrimaryIconUrl="../Images/mailNew.png" />
                                </kspwc:TRadButton>
                            </div>
                        </ContentTemplate>
                    </kspwc:GridCommandItemControl>



                </CommandItemTemplate>
            </MasterTableView>
            <ClientSettings EnableRowHoverStyle="true" Selecting-AllowRowSelect="true">
                <Selecting AllowRowSelect="True"></Selecting>

                <ClientEvents OnRowSelected="ShowHideDeleteButton" OnRowDeselected="ShowHideDeleteButton" />
            </ClientSettings>
        </kspwc:TRadGrid>

    </asp:Panel>
    <telerik:RadWindow ID="RadWindowNew" CssClass="tiskHide" Title="Nová zpráva" NavigateUrl="~/zamestnanec/NovaZprava.aspx"
        runat="server" VisibleStatusbar="false"  OnClientShow="OnClientShowWinNew"
        AutoSize="true" AutoSizeBehaviors="Height, Width" Behaviors="Move" Left="600px" MaxHeight="900px" MinHeight="200px" MinWidth="460px" Top="100px" >
        <ContentTemplate>
            <asp:Panel ID="PanelNM" runat="server">
                <div id="div_newwin_send" style="display: block; min-width: 420px">

                    <table style="width: 100%; border-style: none">
                        <tr style="font-size: inherit">
                            <td>
                                <asp:Label ID="Label5" runat="server" Text="[%Příjemce%]"></asp:Label>
                            </td>
                            <td>
                                <telerik:RadAutoCompleteBox runat="server" ID="RadAutoCompleteBoxNewMsg" 
                                    DataTextField="FirstName" InputType="Token" Width="100%" DropDownWidth="250px" OnClientEntryAdded="ResizeNW" OnClientEntryRemoved="ResizeNW" OnClientTextChanged="ResizeNW" > 
                                    <WebServiceSettings Method="CompleteJmeno" Path="PrijateZpravy.aspx" />
                                </telerik:RadAutoCompleteBox>

                            </td>
                            <td>
                                <span id="NewMsgAdressSpan" style="color: red; display: none">*</span>
                            </td>
                        </tr>
                        <tr style="font-size: inherit">

                            <td style="width: 80px">
                                <asp:Label ID="Label10" runat="server" Text="[%Předmět%]:"></asp:Label>
                            </td>
                            <td>
                                <telerik:RadTextBox ID="RadTextBoxPredmetNew" MaxLength="45" runat="server">
                                    <ClientEvents OnValueChanged="ResizeNW" />
                                </telerik:RadTextBox><br />
                                <kspwc:TextValidator runat="server" ID="val2" ControlToValidate="RadTextBoxPredmetNew"></kspwc:TextValidator>
                            </td>
                            <td>
                                <span id="NewMsgPredpetSpan" style="color: red; display: none">*</span>
                            </td>
                        </tr>
                        <tr style="font-size: inherit" id="tr_typ_odeslani">
                            <td>
                                <asp:Label ID="Label11" runat="server" Text="[%Způsob%]" Font-Size="10"></asp:Label>
                            </td>
                            <td>
                                <asp:RadioButtonList ID="RadioButtonList2" runat="server" RepeatDirection="Horizontal" Font-Size="10">
                                    <asp:ListItem Selected="True" Value="0">[%Portál%]</asp:ListItem>
                                    <asp:ListItem Value="1">[%E-mail%]</asp:ListItem>
                                </asp:RadioButtonList>
                            </td>
                            <td></td>
                        </tr>

                    </table>
                    <br />
                    <div id="RadEditorDiv_new">
                        <telerik:RadEditor runat="server" ID="RadEditorNewMSG" EditModes="Design" Height="380px" Width="450px" Enabled="true" OnClientLoad="OnClientLoadEditor"
                            ContentFilters="DefaultFilters,RemoveScripts,EncodeScripts,StripCssExpressions,StripDomEventAttributes">
                            <Tools>
                                <telerik:EditorToolGroup>
                                    <telerik:EditorTool Name="FindAndReplace" />
                                    <telerik:EditorSeparator Visible="true" />
                                    <telerik:EditorTool Name="Undo" />
                                    <telerik:EditorTool Name="Redo" />
                                </telerik:EditorToolGroup>
                                <telerik:EditorToolGroup>
                                    <telerik:EditorTool Name="FormatBlock" />
                                    <telerik:EditorSeparator Visible="true" />
                                    <telerik:EditorTool Name="Bold" />
                                    <telerik:EditorTool Name="Italic" />
                                    <telerik:EditorTool Name="Underline" />
                                    <telerik:EditorTool Name="StrikeThrough"/>
                                </telerik:EditorToolGroup>
                                <telerik:EditorToolGroup>
                                    <telerik:EditorTool Name="InsertParagraph" />
                                    <telerik:EditorSeparator Visible="true" />
                                    <telerik:EditorTool Name="Indent" />
                                    <telerik:EditorTool Name="Outdent" />
                                    <telerik:EditorSeparator Visible="true" />
                                    <telerik:EditorTool Name="JustifyLeft" />
                                    <telerik:EditorTool Name="JustifyRight" />
                                    <telerik:EditorTool Name="JustifyCenter" />
                                    <telerik:EditorTool Name="JustifyFull" />
                                    <telerik:EditorTool Name="JustifyNone" />
                                    <telerik:EditorSeparator Visible="true" />
                                    <telerik:EditorTool Name="InsertUnorderedList" />
                                    <telerik:EditorTool Name="InsertOrderedList" />
                                    <telerik:EditorTool Name="InsertHorizontalRule" />
                                </telerik:EditorToolGroup>
                                <telerik:EditorToolGroup>
                                    <telerik:EditorTool Name="FontName"/>
                                    <telerik:EditorTool Name="RealFontSize" />
                                    <telerik:EditorTool Name="ForeColor" />
                                    <telerik:EditorTool Name="BackColor" />
                                    <telerik:EditorSeparator Visible="true" />
                                    <telerik:EditorTool Name="InsertTable" />
                                </telerik:EditorToolGroup>
                            </Tools>
                        </telerik:RadEditor>
                    </div>
                    <br />
                    <asp:Label Text="[%Přílohy%]:" runat="server" Font-Bold="true"></asp:Label>
                    <%--<asp:Panel ID="NewMsgPanel" runat="server"> --%>
                    <telerik:RadAsyncUpload runat="server" ID="RadAsyncUpload2" MaxFileSize="2097152" Width="200px" OnClientFileSelected="ResizeNW"
                        OnFileUploaded="RadAsyncUpload2_FileUploaded" MultipleFileSelection="Automatic" 
                        HideFileInput="false" TemporaryFolder="~/Temp" AllowedFileExtensions="txt,bmp,jpg,png,doc,docx,xml,csv,xls,xlsx,ods,pdf" Font-Bold="False" />
                    <%--</asp:Panel>--%>
                </div>
            </asp:Panel>
            <div style="padding-top: 15px; min-width: 320px">
                <kspwc:TRadButton ID="BTNCloseNewMsg" runat="server" Text="[%Zrušit%]" CssClass="setButtons" AutoPostBack="false" OnClientClicked="OnClientCloseWinNew"></kspwc:TRadButton>
                <kspwc:TRadButton ID="BTNSendNewMsg" runat="server" Text="[%Odeslat%]" CssClass="setButtons" OnClientClicking="BTNSendNewMsg_ClientClick" OnClick="BTNSendNewMsg_Click" AutoPostBack="true"></kspwc:TRadButton>
            </div>

        </ContentTemplate>
    </telerik:RadWindow>

    <telerik:RadWindow ID="RadWindowRead" VisibleOnPageLoad="false" OnClientShow="OnClientShowReadWin" VisibleStatusbar="false" runat="server" 
        AutoSize="true" AutoSizeBehaviors="Height, Width" Behaviors="Close, Move" Left="600px" MaxHeight="900px" MinHeight="200px" MinWidth="490px" Top="100px"
        OnClientClose="OnClientCloseReadWin" OnClientBeforeClose="RedWin_OnClientBeforeClose" >
        <ContentTemplate>
            <%--<asp:Panel ID="ReadWinPanel" runat="server">--%>
            <div id="read_div" style="max-width:460px">
                <span id="id_msg" style="display: none"></span>
                <div id="div_readwin_read" style="min-width: 320px; display: block;">
                    <div id="print_div_read">
                        <table style="width: 100%; border-style: none">
                            <tr style="font-size: large">
                                <td style="width: 120px">
                                    <asp:Label ID="Label2" runat="server" Text="[%Předmět%]:"></asp:Label>
                                </td>
                                <td>
                                    <span id="id_predmet"></span>
                                </td>
                            </tr>
                            <tr style="font-size: inherit">
                                <td>
                                    <asp:Label ID="Label9" runat="server" Text="[%Odesílatel%]"></asp:Label>
                                </td>
                                <td>
                                    <span id="id_odesilatel"></span>
                                </td>
                            </tr>
                            <tr style="font-size: inherit">
                                <td>
                                    <asp:Label ID="Label4" runat="server" Text="[%Odesláno%]"></asp:Label>
                                </td>
                                <td>
                                    <span id="id_odeslano"></span>
                                </td>
                            </tr>
                            <tr style="font-size: inherit">
                                <td>
                                    <asp:Label ID="Label8" runat="server" Text="[%Příjemce%]"></asp:Label>
                                </td>
                                <td>
                                    <span id="id_prijemce"></span>
                                </td>
                            </tr>
                            <tr style="font-size: inherit">
                                <td>
                                    <asp:Label ID="Label6" runat="server" Text="[%Přijato%]"></asp:Label>
                                </td>
                                <td>
                                    <span id="id_prijato"></span>
                                </td>
                            </tr>
                        </table>
                        <br />
                        <div id="RadEditorDiv">
                            <p id="id_telo"></p>
                        </div>
                        <br />
                        <asp:Label Text="[%Přílohy%]:" runat="server" Font-Bold="true"></asp:Label>
                        <div id="id_prilohy" style="padding-left: 15px">
                        </div>
                    </div>
                    <div style="padding-top: 15px; min-width: 320px">
                        <kspwc:TRadButton ID="zavritRedMsg" runat="server" Text="[%Zavřít%]" CssClass="setButtons" AutoPostBack="false" OnClientClicked="OnClientCloseWinRead"></kspwc:TRadButton>
                        <kspwc:TRadButton ID="odpovedRedMsg" runat="server" Text="[%Odpovědět%]" CssClass="setButtons" AutoPostBack="false" OnClientClicked="OdpovedetNaMSG" CommandArgument="true"></kspwc:TRadButton>
                        <kspwc:TRadButton ID="preposlatRedMsg" runat="server" Text="[%Přeposlat%]" CssClass="setButtons" AutoPostBack="false" OnClientClicked="OdpovedetNaMSG" CommandArgument="false"></kspwc:TRadButton>
                    </div>
                </div>
                <div id="div_readwin_send" style="display: none; min-width: 320px; max-width:360px"">

                    <table style="width: 100%; border-style: none">
                        <tr style="font-size: inherit">
                            <td>
                                <asp:Label ID="Label7" runat="server" Text="[%Příjemce%]"></asp:Label>
                            </td>
                            <td>
                                <telerik:RadAutoCompleteBox runat="server" ID="RadAutoCompleteBox2" 
                                    DataTextField="FirstName" InputType="Token" Width="100%" DropDownWidth="250px" OnClientEntryAdded="ResizeReadWin" OnClientEntryRemoved="ResizeReadWin">
                                    <WebServiceSettings Method="CompleteJmeno" Path="PrijateZpravy.aspx" />
                                </telerik:RadAutoCompleteBox>
                            </td>
                            <td>
                                <span id="ReSendMsgAdressSpan" style="color: red; display: none">*</span>
                            </td>
                        </tr>
                        <tr style="font-size: inherit">

                            <td style="width: 80px">
                                <asp:Label ID="Label1" runat="server" Text="[%Předmět%]:"></asp:Label>
                            </td>
                            <td>
                                <telerik:RadTextBox ID="TB_Predmet" MaxLength="45" runat="server"></telerik:RadTextBox>
                            </td>
                            <td>
                                <span id="ReSendMsgPredmetSpan" style="color: red; display: none">*</span>
                            </td>
                        </tr>
                    </table>
                    <br />
                    <div id="RadEditorDiv_send">
                        <telerik:RadEditor runat="server" ID="RadEditor1" EditModes="Design" Height="380px" Width="450px" Enabled="true" OnClientLoad="OnClientLoadEditor"
                            ContentFilters="DefaultFilters,RemoveScripts,EncodeScripts,StripCssExpressions,StripDomEventAttributes">
                            <Tools>
                                <telerik:EditorToolGroup>
                                    <telerik:EditorTool Name="FindAndReplace" />
                                    <telerik:EditorSeparator Visible="true" />
                                    <telerik:EditorTool Name="Undo" />
                                    <telerik:EditorTool Name="Redo" />
                                </telerik:EditorToolGroup>
                                <telerik:EditorToolGroup>
                                    <telerik:EditorTool Name="FormatBlock" />
                                    <telerik:EditorSeparator Visible="true" />
                                    <telerik:EditorTool Name="Bold" />
                                    <telerik:EditorTool Name="Italic" />
                                    <telerik:EditorTool Name="Underline" />
                                    <telerik:EditorTool Name="StrikeThrough"/>
                                </telerik:EditorToolGroup>
                                <telerik:EditorToolGroup>
                                    <telerik:EditorTool Name="InsertParagraph" />
                                    <telerik:EditorSeparator Visible="true" />
                                    <telerik:EditorTool Name="Indent" />
                                    <telerik:EditorTool Name="Outdent" />
                                    <telerik:EditorSeparator Visible="true" />
                                    <telerik:EditorTool Name="JustifyLeft" />
                                    <telerik:EditorTool Name="JustifyRight" />
                                    <telerik:EditorTool Name="JustifyCenter" />
                                    <telerik:EditorTool Name="JustifyFull" />
                                    <telerik:EditorTool Name="JustifyNone" />
                                    <telerik:EditorSeparator Visible="true" />
                                    <telerik:EditorTool Name="InsertUnorderedList" />
                                    <telerik:EditorTool Name="InsertOrderedList" />
                                    <telerik:EditorTool Name="InsertHorizontalRule" />
                                </telerik:EditorToolGroup>
                                <telerik:EditorToolGroup>
                                    <telerik:EditorTool Name="FontName"/>
                                    <telerik:EditorTool Name="RealFontSize" />
                                    <telerik:EditorTool Name="ForeColor" />
                                    <telerik:EditorTool Name="BackColor" />
                                    <telerik:EditorSeparator Visible="true" />
                                    <telerik:EditorTool Name="InsertTable" />
                                </telerik:EditorToolGroup>
                            </Tools>
                        </telerik:RadEditor>
                    </div>
                    <br />
                    <asp:Panel ID="ReSendPanel" runat="server" >
                        <asp:Label Text="[%Přílohy%]:" runat="server" Font-Bold="true"></asp:Label>
                        <div id="repeat_prilohy">
                            <asp:Repeater ID="Repeater1" runat="server" OnDataBinding="Repeater1_DataBinding" OnItemDataBound="Repeater1_ItemDataBound">
                                <ItemTemplate>
                                    <table>
                                        <tr>
                                            <td>
                                                <wc:TLinkButton ID="TLinkButton2" runat="server" Text='<%# Bind("nazev") %>' DisableProgressBar="true" OnCommand="TLinkButton2_Command"></wc:TLinkButton>
                                            </td>
                                            <td>
                                                <asp:Label ID="Label1" runat="server" Text='<%# Bind("size") %>'></asp:Label>
                                            </td>
                                            <td>
                                                <wc:TLinkButton ID="TB_rem" runat="server" Text="[%Odebrat přílohu%]" OnCommand="TB_rem_Command"/>
                                            </td>
                                        </tr>
                                    </table>
                                </ItemTemplate>
                                <FooterTemplate>
                                    <br />
                                </FooterTemplate>
                            </asp:Repeater>
                        </div>
                        <div>
                            <telerik:RadAsyncUpload runat="server" ID="RadAsyncUpload1" MaxFileSize="2097152" Width="200px" 
                                OnFileUploaded="RadAsyncUpload1_FileUploaded" MultipleFileSelection="Automatic" HideFileInput="false" 
                                TemporaryFolder="~/Temp" AllowedFileExtensions="txt,bmp,jpg,png,doc,docx,xml,csv,xls,xlsx,ods,pdf" Font-Bold="False" />
                        </div>
                        <kspwc:TRadButton ID="nacist_prilohy" runat="server" OnClick="nacist_prilohy_Click" Style="display: none" CommandArgument=""></kspwc:TRadButton>
                        <kspwc:TRadButton ID="smazat_prilohy" runat="server" OnClick="smazat_prilohy_Click" Style="display: none" ></kspwc:TRadButton>
                        <kspwc:TRadButton ID="odesla_zpravu" runat="server" OnClick="odesla_zpravu_Click" Style="display: none" ></kspwc:TRadButton>
                    </asp:Panel>
                    <div style="padding-top: 15px; min-width: 320px">
                        <kspwc:TRadButton ID="zrusinOdpoved" runat="server" Text="[%Zrušit%]" CssClass="setButtons" AutoPostBack="false" OnClientClicked="ZrusitZpravuReSend"></kspwc:TRadButton>
                        <kspwc:TRadButton ID="odeslatodpoved" runat="server" Text="[%Odeslat%]" CssClass="setButtons" AutoPostBack="false" OnClientClicked="OdeslatReSend" CommandArgument="true"></kspwc:TRadButton>
                    </div>
                </div>
            </div>
        
        </ContentTemplate>
    </telerik:RadWindow>


</asp:Content>
