/**
 * Kendo UI v2022.3.913 (http://www.telerik.com/kendo-ui)
 * Copyright 2022 Progress Software Corporation and/or one of its subsidiaries or affiliates. All rights reserved.
 *
 * Kendo UI commercial licenses may be obtained at
 * http://www.telerik.com/purchase/license-agreement/kendo-ui-complete
 * If you do not own a commercial license, this file shall be governed by the trial license terms.
 */
!function(define){define("kendo.mobile.listview.min",["kendo.data.min","kendo.userevents.min","kendo.mobile.button.min"],function(){var e={id:"mobile.listview",name:"ListView",category:"mobile",description:"The Kendo Mobile ListView widget is used to display flat or grouped list of items.",depends:["data","userevents","mobile.button"]},f=window.kendo.jQuery,t=void 0,u=window.kendo,i=window.Node,s=u.mobile,g=s.ui,n=u._outerHeight,d=u.data.DataSource,r=g.DataBoundWidget,c=".km-list > li, > li:not(.km-group-container)",p=".km-listview-link, .km-listview-label",m="["+u.attr("icon")+"]",l=u.attrValue,o="km-group-title",v="km-state-active",_='<div class="'+o+'"><div class="km-text"></div></div>',b=u.template('<li><div class="'+o+'"><div class="km-text">#= this.headerTemplate(data) #</div></div><ul>#= kendo.render(this.template, data.items)#</ul></li>'),w='<div class="km-listview-wrapper"></div>',k=u.template('<form class="km-filter-form"><div class="km-filter-wrap"><input type="search" placeholder="#=placeholder#"/><a href="\\#" class="km-filter-reset" title="Clear"><span class="km-icon km-clear"></span><span class="km-text">Clear</span></a></div></form>'),a=".kendoMobileListView",S="styled",y="dataBound",T="dataBinding",x="itemChange",C="click",I="change",H="progress",B="function",D=/^\s+$/,z=/button/;function V(){return this.nodeType===i.TEXT_NODE&&this.nodeValue.match(D)}function h(e,t){if(t&&!e[0].querySelector(".km-icon"))e.prepend('<span class="km-icon km-'+t+'"/>')}function F(e){h(e,l(e,"icon"));h(e,l(e.children(m),"icon"))}function L(e){var t=e.parent(),i=e.add(t.children(u.roleSelector("detailbutton"))),s=t.contents().not(i).not(V);if(s.length)return;e.addClass("km-listview-link").attr(u.attr("role"),"listview-link");h(e,l(t,"icon"));h(e,l(e,"icon"))}function R(e){if(!e[0].querySelector("input[type=checkbox],input[type=radio]"))return;var t=e.parent();if(t.contents().not(e).not(function(){return this.nodeType==3})[0])return;e.addClass("km-listview-label");e.children("[type=checkbox],[type=radio]").addClass("km-widget km-icon km-check")}function E(e,t){f(e).css("transform","translate3d(0px, "+t+"px, 0px)")}var M=u.Class.extend({init:function(e){var t=e.scroller();if(!t)return;this.options=e.options;this.element=e.element;this.scroller=e.scroller();this._shouldFixHeaders();var i=this;var s=function(){i._cacheHeaders()};e.bind("resize",s);e.bind(S,s);e.bind(y,s);this._scrollHandler=function(e){i._fixHeader(e)};t.bind("scroll",this._scrollHandler)},destroy:function(){var e=this;if(e.scroller)e.scroller.unbind("scroll",e._scrollHandler)},_fixHeader:function(e){if(!this.fixedHeaders)return;var t=0,i=this.scroller,s=this.headers,n=e.scrollTop,r,o,l;do{r=s[t++];if(!r){l=f("<div />");break}o=r.offset;l=r.header}while(o+1>n);if(this.currentHeader!=t){i.fixedContainer.html(l.clone());this.currentHeader=t}},_shouldFixHeaders:function(){this.fixedHeaders=this.options.type==="group"&&this.options.fixedHeaders},_cacheHeaders:function(){this._shouldFixHeaders();if(!this.fixedHeaders)return;var i=[],s=this.scroller.scrollTop;this.element.find("."+o).each(function(e,t){t=f(t);i.unshift({offset:t.position().top+s,header:t})});this.headers=i;this._fixHeader({scrollTop:s})}}),O=function(){return{page:1}},P=u.Class.extend({init:function(e){var t=this,i=e.options,s=e.scroller(),n=i.pullParameters||O;this.listView=e;this.scroller=s;e.bind("_dataSource",function(e){t.setDataSource(e.dataSource)});s.setOptions({pullToRefresh:true,pull:function(){if(!t._pulled){t._pulled=true;t.dataSource.read(n.call(e,t._first))}},messages:{pullTemplate:i.messages.pullTemplate,releaseTemplate:i.messages.releaseTemplate,refreshTemplate:i.messages.refreshTemplate}})},setDataSource:function(e){var t=this;this._first=e.view()[0];this.dataSource=e;e.bind("change",function(){t._change()});e.bind("error",function(){t._change()})},_change:function(){var e=this.scroller,t=this.dataSource;if(this._pulled)e.pullHandled();if(this._pulled||!this._first){var i=t.view();if(i[0])this._first=i[0]}this._pulled=false}}),A=u.Observable.extend({init:function(e){var t=this;u.Observable.fn.init.call(t);t.buffer=e.buffer;t.height=e.height;t.item=e.item;t.items=[];t.footer=e.footer;t.buffer.bind("reset",function(){t.refresh()})},refresh:function(){var e=this.buffer,t=this.items,i=false;while(t.length)t.pop().destroy();this.offset=e.offset;var s=this.item,n,r;for(var o=0;o<e.viewSize;o++){if(o===e.total()){i=true;break}r=s(this.content(this.offset+t.length));r.below(n);n=r;t.push(r)}this.itemCount=t.length;this.trigger("reset");this._resize();if(i)this.trigger("endReached")},totalHeight:function(){if(!this.items[0])return 0;var e=this,t=e.items,i=t[0].top,s=t[t.length-1].bottom,n=(s-i)/e.itemCount,r=e.buffer.length-e.offset-e.itemCount;return(this.footer?this.footer.height:0)+s+r*n},batchUpdate:function(e){var t=this.height(),i=this.items,s,n=this.offset;if(!i[0])return;if(this.lastDirection)while(i[i.length-1].bottom>e+t*2){if(this.offset===0)break;this.offset--;s=i.pop();s.update(this.content(this.offset));s.above(i[0]);i.unshift(s)}else while(i[0].top<e-t){var r=this.offset+this.itemCount;if(r===this.buffer.total()){this.trigger("endReached");break}if(r===this.buffer.length)break;s=i.shift();s.update(this.content(this.offset+this.itemCount));s.below(i[i.length-1]);i.push(s);this.offset++}if(n!==this.offset)this._resize()},update:function(e){var t=this,i=this.items,s,n,r,o=this.height(),d=this.itemCount,l=o/2,a=(this.lastTop||0)>e,h=e-l,f=e+o+l;if(!i[0])return;this.lastTop=e;this.lastDirection=a;if(a){if(i[0].top>h&&i[i.length-1].bottom>f+l&&this.offset>0){this.offset--;s=i.pop();n=i[0];s.update(this.content(this.offset));i.unshift(s);s.above(n);t._resize()}}else if(i[i.length-1].bottom<f&&i[0].top<h-l){var u=this.offset+d;if(u===this.buffer.total())this.trigger("endReached");else if(u!==this.buffer.length){s=i.shift();r=i[i.length-1];i.push(s);s.update(this.content(this.offset+this.itemCount));t.offset++;s.below(r);t._resize()}}},content:function(e){return this.buffer.at(e)},destroy:function(){this.unbind()},_resize:function(){var e=this.items,t=0,i=0,s=e[0],n=e[e.length-1];if(s){t=s.top;i=n.bottom}this.trigger("resize",{top:t,bottom:i});if(this.footer)this.footer.below(n)}}),U=(u.mobile.ui.VirtualList=A,u.Class.extend({init:function(e,t){var i=e.append([t],true)[0],s=i.offsetHeight;f.extend(this,{top:0,element:i,listView:e,height:s,bottom:s})},update:function(e){this.element=this.listView.setDataItem(this.element,e)},above:function(e){if(e){this.height=this.element.offsetHeight;this.top=e.top-this.height;this.bottom=e.top;E(this.element,this.top)}},below:function(e){if(e){this.height=this.element.offsetHeight;this.top=e.bottom;this.bottom=this.top+this.height;E(this.element,this.top)}},destroy:function(){u.destroy(this.element);f(this.element).remove()}})),q='<div><span class="km-icon"></span><span class="km-loading-left"></span><span class="km-loading-right"></span></div>',G=u.Class.extend({init:function(e){this.element=f('<li class="km-load-more km-scroller-refresh" style="display: none"></li>').appendTo(e.element);this._loadIcon=f(q).appendTo(this.element)},enable:function(){this.element.show();this.height=n(this.element,true)},disable:function(){this.element.hide();this.height=0},below:function(e){if(e){this.top=e.bottom;this.bottom=this.height+this.top;E(this.element,this.top)}}}),j=G.extend({init:function(e,t){this._loadIcon=f(q).hide();this._loadButton=f('<a class="km-load">'+e.options.messages.loadMoreText+"</a>").hide();this.element=f('<li class="km-load-more" style="display: none"></li>').append(this._loadIcon).append(this._loadButton).appendTo(e.element);var i=this;this._loadButton.kendoMobileButton().data("kendoMobileButton").bind("click",function(){i._hideShowButton();t.next()});t.bind("resize",function(){i._showLoadButton()});this.height=n(this.element,true);this.disable()},_hideShowButton:function(){this._loadButton.hide();this.element.addClass("km-scroller-refresh");this._loadIcon.css("display","block")},_showLoadButton:function(){this._loadButton.show();this.element.removeClass("km-scroller-refresh");this._loadIcon.hide()}}),N=u.Class.extend({init:function(e){var t=this;this.chromeHeight=n(e.wrapper.children().not(e.element));this.listView=e;this.scroller=e.scroller();this.options=e.options;e.bind("_dataSource",function(e){t.setDataSource(e.dataSource,e.empty)});e.bind("resize",function(){if(!t.list.items.length)return;t.scroller.reset();t.buffer.range(0);t.list.refresh()});this.scroller.makeVirtual();this._scroll=function(e){t.list.update(e.scrollTop)};this.scroller.bind("scroll",this._scroll);this._scrollEnd=function(e){t.list.batchUpdate(e.scrollTop)};this.scroller.bind("scrollEnd",this._scrollEnd)},destroy:function(){this.list.unbind();this.buffer.unbind();this.scroller.unbind("scroll",this._scroll);this.scroller.unbind("scrollEnd",this._scrollEnd)},setDataSource:function(e,d){var t=this,i=this.options,s=this.listView,n=s.scroller(),r=i.loadMore,o,l,a;this.dataSource=e;o=e.pageSize()||i.virtualViewSize;if(!o&&!d)throw new Error("the DataSource does not have page size configured. Page Size setting is mandatory for the mobile listview virtual scrolling to work as expected.");if(this.buffer)this.buffer.destroy();l=new u.data.Buffer(e,Math.floor(o/2),r);if(r)a=new j(s,l);else a=new G(s);if(this.list)this.list.destroy();var h=new A({buffer:l,footer:a,item:function(e){return new U(s,e)},height:function(){return n.height()}});h.bind("resize",function(){t.updateScrollerSize();s.updateSize()});h.bind("reset",function(){t.footer.enable()});h.bind("endReached",function(){a.disable();t.updateScrollerSize()});l.bind("expand",function(){h.lastDirection=false;h.batchUpdate(n.scrollTop)});f.extend(this,{buffer:l,scroller:n,list:h,footer:a})},updateScrollerSize:function(){this.scroller.virtualSize(0,this.list.totalHeight()+this.chromeHeight)},refresh:function(){this.list.refresh()},reset:function(){this.buffer.range(0);this.list.refresh()}}),W=u.Class.extend({init:function(e){var t=this;this.listView=e;this.options=e.options;var i=this;this._refreshHandler=function(e){i.refresh(e)};this._progressHandler=function(){e.showLoading()};e.bind("_dataSource",function(e){t.setDataSource(e.dataSource)})},destroy:function(){this._unbindDataSource()},reset:function(){},refresh:function(e){var t=e&&e.action,i=e&&e.items,s=this.listView,d=this.dataSource,f=this.options.appendOnRefresh,n=d.view(),u=d.group(),r=u&&u[0],o;if(t==="itemchange"){if(!s._hasBindingTarget()){o=s.findByDataItem(i)[0];if(o)s.setDataItem(o,i[0])}return}var l,a,h;var c=t==="add"&&!r||f&&!s._filter;var p=t==="remove"&&!r;if(c)l=[];else if(p)l=s.findByDataItem(i);if(s.trigger(T,{action:t||"rebind",items:i,removedItems:l,index:e&&e.index})){if(this._shouldShowLoading())s.hideLoading();return}if(t==="add"&&!r){var m=n.indexOf(i[0]);if(m>-1){a=s.insertAt(i,m);h=i}}else if(t==="remove"&&!r){a=[];s.remove(i)}else if(r)s.replaceGrouped(n);else if(f&&!s._filter){a=s.prepend(n);h=n}else s.replace(n);if(this._shouldShowLoading())s.hideLoading();s.trigger(y,{ns:g,addedItems:a,addedDataItems:h})},setDataSource:function(e){if(this.dataSource)this._unbindDataSource();this.dataSource=e;e.bind(I,this._refreshHandler);if(this._shouldShowLoading())this.dataSource.bind(H,this._progressHandler)},_unbindDataSource:function(){this.dataSource.unbind(I,this._refreshHandler).unbind(H,this._progressHandler)},_shouldShowLoading:function(){var e=this.options;return!e.pullToRefresh&&!e.loadMore&&!e.endlessScroll}}),$=u.Class.extend({init:function(e){var t=this,i=e.options.filterable,s="change paste",n=this;this.listView=e;this.options=i;e.element.before(k({placeholder:i.placeholder||"Search..."}));if(i.autoFilter!==false)s+=" keyup";this.element=e.wrapper.find(".km-search-form");this.searchInput=e.wrapper.find("input[type=search]").closest("form").on("submit"+a,function(e){e.preventDefault()}).end().on("focus"+a,function(){t._oldFilter=t.searchInput.val()}).on(s.split(" ").join(a+" ")+a,this._filterChange.bind(this));this.clearButton=e.wrapper.find(".km-filter-reset").on(C,this._clearFilter.bind(this)).hide();this._dataSourceChange=this._refreshInput.bind(this);e.bind("_dataSource",function(e){e.dataSource.bind("change",n._dataSourceChange)})},_refreshInput:function(){var e=this.listView.dataSource.filter();var t=this.listView._filter.searchInput;if(!e||e.filters[0].field!==this.listView.options.filterable.field)t.val("");else t.val(e.filters[0].value)},_search:function(e){this._filter=true;this.clearButton[e?"show":"hide"]();this.listView.dataSource.filter(e)},_filterChange:function(e){var t=this;if(e.type=="paste"&&this.options.autoFilter!==false)setTimeout(function(){t._applyFilter()},1);else this._applyFilter()},_applyFilter:function(){var e=this.options,t=this.searchInput.val(),i=t.length?{field:e.field,operator:e.operator||"startswith",ignoreCase:e.ignoreCase,value:t}:null;if(t===this._oldFilter)return;this._oldFilter=t;this._search(i)},_clearFilter:function(e){this.searchInput.val("");this._search(null);e.preventDefault()}}),K=r.extend({init:function(e,t){var i=this;r.fn.init.call(this,e,t);e=this.element;t=this.options;if(t.scrollTreshold)t.scrollThreshold=t.scrollTreshold;e.on("down",p,"_highlight").on("move up cancel",p,"_dim");this._userEvents=new u.UserEvents(e,{fastTap:true,filter:c,allowSelection:true,tap:function(e){i._click(e)}});e.css("-ms-touch-action","auto");e.wrap(w);this.wrapper=this.element.parent();this._headerFixer=new M(this);this._itemsCache={};this._templates();this.virtual=t.endlessScroll||t.loadMore;this._style();if(this.options.$angular&&(this.virtual||this.options.pullToRefresh))setTimeout(this._start.bind(this));else this._start()},_start:function(){var e=this.options;if(this.options.filterable)this._filter=new $(this);if(this.virtual)this._itemBinder=new N(this);else this._itemBinder=new W(this);if(this.options.pullToRefresh)this._pullToRefreshHandler=new P(this);this.setDataSource(e.dataSource);this._enhanceItems(this.items());u.notify(this,g)},events:[C,T,y,x],options:{name:"ListView",style:"",type:"flat",autoBind:true,fixedHeaders:false,template:"#:data#",headerTemplate:'<span class="km-text">#:value#</span>',appendOnRefresh:false,loadMore:false,endlessScroll:false,scrollThreshold:30,pullToRefresh:false,messages:{loadMoreText:"Press to load more",pullTemplate:"Pull to refresh",releaseTemplate:"Release to refresh",refreshTemplate:"Refreshing"},pullOffset:140,filterable:false,virtualViewSize:null},refresh:function(){this._itemBinder.refresh()},reset:function(){this._itemBinder.reset()},setDataSource:function(e){var t=!e;this.dataSource=d.create(e);this.trigger("_dataSource",{dataSource:this.dataSource,empty:t});if(this.options.autoBind&&!t){this.items().remove();this.dataSource.fetch()}},destroy:function(){r.fn.destroy.call(this);u.destroy(this.element);this._userEvents.destroy();if(this._itemBinder)this._itemBinder.destroy();if(this._headerFixer)this._headerFixer.destroy();this.element.unwrap();delete this.element;delete this.wrapper;delete this._userEvents},items:function(){if(this.options.type==="group")return this.element.find(".km-list").children();else return this.element.children().not(".km-load-more")},scroller:function(){if(!this._scrollerInstance)this._scrollerInstance=this.element.closest(".km-scroll-wrapper").data("kendoMobileScroller");return this._scrollerInstance},showLoading:function(){var e=this.view();if(e&&e.loader)e.loader.show()},hideLoading:function(){var e=this.view();if(e&&e.loader)e.loader.hide()},insertAt:function(i,s,n){var r=this;return r._renderItems(i,function(e){if(s===0)r.element.prepend(e);else if(s===-1)r.element.append(e);else r.items().eq(s-1).after(e);if(n)for(var t=0;t<e.length;t++)r.trigger(x,{item:e.eq(t),data:i[t],ns:g})})},append:function(e,t){return this.insertAt(e,-1,t)},prepend:function(e,t){return this.insertAt(e,0,t)},replace:function(e){this.options.type="flat";this._angularItems("cleanup");u.destroy(this.element.children());this.element.empty();this._userEvents.cancel();this._style();return this.insertAt(e,0)},replaceGrouped:function(e){this.options.type="group";this._angularItems("cleanup");this.element.empty();var t=f(u.render(this.groupTemplate,e));this._enhanceItems(t.children("ul").children("li"));this.element.append(t);s.init(t);this._style();this._angularItems("compile")},remove:function(e){var t=this.findByDataItem(e);this.angular("cleanup",function(){return{elements:t}});u.destroy(t);t.remove()},findByDataItem:function(e){var t=[];for(var i=0,s=e.length;i<s;i++)t[i]="[data-"+u.ns+"uid="+e[i].uid+"]";return this.element.find(t.join(","))},setDataItem:function(i,s){var n=this,e=function(e){var t=f(e[0]);u.destroy(i);n.angular("cleanup",function(){return{elements:[f(i)]}});f(i).replaceWith(t);n.trigger(x,{item:t,data:s,ns:g})};return this._renderItems([s],e)[0]},updateSize:function(){this._size=this.getSize()},_renderItems:function(e,t){var i=f(u.render(this.template,e));t(i);this.angular("compile",function(){return{elements:i,data:e.map(function(e){return{dataItem:e}})}});s.init(i);this._enhanceItems(i);return i},_dim:function(e){this._toggle(e,false)},_highlight:function(e){this._toggle(e,true)},_toggle:function(e,t){if(e.which>1)return;var i=f(e.currentTarget),s=i.parent(),n=l(i,"role")||"",r=!n.match(z),o=e.isDefaultPrevented();if(r)s.toggleClass(v,t&&!o)},_templates:function(){var e=this.options.template,t=this.options.headerTemplate,i=' data-uid="#=arguments[0].uid || ""#"',s={},n={};if(typeof e===B){s.template=e;e="#=this.template(data)#"}this.template=u.template("<li"+i+">"+e+"</li>").bind(s);n.template=this.template;if(typeof t===B){n._headerTemplate=t;t="#=this._headerTemplate(data)#"}n.headerTemplate=u.template(t);this.groupTemplate=b.bind(n)},_click:function(e){if(e.event.which>1||e.event.isDefaultPrevented())return;var t,i=e.target,s=f(e.event.target),n=s.closest(u.roleSelector("button","detailbutton","backbutton")),r=u.widgetInstance(n,g),o=i.attr(u.attr("uid"));if(o)t=this.dataSource.getByUid(o);if(this.trigger(C,{target:s,item:i,dataItem:t,button:r}))e.preventDefault()},_styleGroups:function(){var e=this.element.children();e.children("ul").addClass("km-list");e.each(function(){var e=f(this),t=e.contents().first();e.addClass("km-group-container");if(!t.is("ul")&&!t.is("div."+o))t.wrap(_)})},_style:function(){var e=this.options,t=e.type==="group",i=this.element,s=e.style==="inset";i.addClass("km-listview").toggleClass("km-list",!t).toggleClass("km-virtual-list",this.virtual).toggleClass("km-listinset",!t&&s).toggleClass("km-listgroup",t&&!s).toggleClass("km-listgroupinset",t&&s);if(!i.parents(".km-listview")[0])i.closest(".km-content").toggleClass("km-insetcontent",s);if(t)this._styleGroups();this.trigger(S)},_enhanceItems:function(e){e.each(function(){var e=f(this),t,i=false;e.children().each(function(){t=f(this);if(t.is("a")){L(t);i=true}else if(t.is("label")){R(t);i=true}});if(!i)F(e)})}});return g.plugin(K),window.kendo})}("function"==typeof define&&define.amd?define:function(e,t,i){(i||t)()});
//# sourceMappingURL=kendo.mobile.listview.min.js.map
