﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="BulletinList.ascx.cs" Inherits="KSPortal.Bulletin.BulletinList" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Src="BulletinListEditItem.ascx" TagName="BulletinListEditItem" TagPrefix="bc" %>

<telerik:RadAjaxManagerProxy runat="server" ID="RAMP_bulllist">
    <AjaxSettings>
        <telerik:AjaxSetting AjaxControlID="P_bull">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="P_bull" />
            </UpdatedControls>
        </telerik:AjaxSetting>
<%--        <telerik:AjaxSetting AjaxControlID="TRB_add_new">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="P_bull" />
                <telerik:AjaxUpdatedControl ControlID="BLEI_insert" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="TRB_set_edit">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="P_bull" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="TRB_end_edit">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="P_bull" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="TRB_edit">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="P_bull" />
                <telerik:AjaxUpdatedControl ControlID="BLEI_edit" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="TRB_delete">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="P_bull" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="TRB_insert">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="P_bull" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="TRB_i_cancel">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="P_bull" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="TRB_update">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="P_bull" />
            </UpdatedControls>
        </telerik:AjaxSetting>
        <telerik:AjaxSetting AjaxControlID="TRB_e_cancel">
            <UpdatedControls>
                <telerik:AjaxUpdatedControl ControlID="P_bull" />
            </UpdatedControls>
        </telerik:AjaxSetting>--%>
    </AjaxSettings>
</telerik:RadAjaxManagerProxy>

<telerik:RadScriptBlock runat="server" ID="RSB_bull">
    <script type="text/javascript">
        function RTB_e_text_KeyPress(sender, args) {
            if (sender.get_maxLength() <= sender.get_value().length) {
                args.set_cancel(true);
            }
        }
        function TRCB_F_oscislo_ItemsRequesting(sender, args) {
            var context = args.get_context();
            context["UsePrava"] = true;
        }
        function TRCB_F_oscislo_DropDownClosed(sender, args) {
            sender.clearItems();
        }
    </script>
</telerik:RadScriptBlock>
<asp:Panel ID="P_bull" runat="server" CssClass="ksBlLv">
    <telerik:RadListView runat="server" ID="RLV_bull" AllowPaging="true" AllowMultiItemEdit="false"
        OnNeedDataSource="RLV_bull_NeedDataSource" ItemPlaceholderID="ItemsPlaceHolder"
        OnItemUpdating="RLV_bull_ItemUpdating" OnItemInserting="RLV_bull_ItemInserting"
        OnItemDeleting="RLV_bull_ItemDeleting" OnItemDataBound="RLV_bull_ItemDataBound" DataKeyNames="id"
        InsertItemPosition="FirstItem">
        <LayoutTemplate>
            <asp:Panel ID="P_edit_style" runat="server" Visible='<%# Editacni %>'>
                <style type="text/css">
                    div.ksBlBullItem {
                        min-height: 150px;
                    }
                </style>
            </asp:Panel>

            <%--<asp:Panel runat="server" ID="Panel1" Visible='<%# Editacni %>'>
                <telerik:RadFilter runat="server" ID="RF_filter" FilterContainerID="RLV_bull" ExpressionPreviewPosition="Bottom"
                    OnLoad="RF_filter_Load">
                    <FieldEditors>
                        <telerik:RadFilterTextFieldEditor FieldName="nadpis" DataType="System.String" DisplayName="[%Nadpis%]" DefaultFilterFunction="Contains" />
                        <telerik:RadFilterTextFieldEditor FieldName="telo" DataType="System.String" DisplayName="[%Tělo%]" DefaultFilterFunction="Contains" />
                        <telerik:RadFilterDateFieldEditor FieldName="datum_od" DataType="System.DateTime" DisplayName="[%Publikovat od%]" DefaultFilterFunction="GreaterThanOrEqualTo" />
                        <telerik:RadFilterDateFieldEditor FieldName="datum_do" DataType="System.DateTime" DisplayName="[%Publikovat do%]" DefaultFilterFunction="LessThanOrEqualTo" />
                        <telerik:RadFilterBooleanFieldEditor FieldName="Publikovano" DataType="System.Boolean" DisplayName="[%Publikováno%]" DefaultFilterFunction="EqualTo" />
                    </FieldEditors>
                </telerik:RadFilter>
            </asp:Panel>--%>
            <asp:Panel runat="server" ID="P_i_buttons" CssClass="ksBlButtInsert" BackColor="white">
                <div>
                    <div>
                        <kspwc:TRadButton runat="server" ID="TRB_add_new" ButtonType="StandardButton" CommandName="InitInsert" Text="[%Přidat%]" ToolTip="[%Přidat nový záznam%]" Visible='<%# Editacni %>'>
                            <Icon PrimaryIconCssClass="fi fi-add" />
                        </kspwc:TRadButton>
                        <kspwc:TRadButton runat="server" ID="TRB_set_edit" ButtonType="StandardButton" Text="[%Režim editace%]" ToolTip="[%Přepne do editačního pohledu%]" OnClick="TRB_set_edit_Click" Visible='<%# !Editacni &&  LzeZapnoutEditaci %>' Enabled=" <%# !KSProgram.Prava.ZamykaniAgend.GeneralZamekIsLocked() %>">
                            <Icon PrimaryIconCssClass="fi fi-edit" />
                        </kspwc:TRadButton>
                        <kspwc:TRadButton runat="server" ID="TRB_end_edit" ButtonType="StandardButton" Text="[%Konec úprav%]" ToolTip="[%Přepne do needitačního pohledu%]" OnClick="TRB_end_edit_Click" Visible='<%# Editacni %>'>
                            <Icon PrimaryIconCssClass="fi fi-ban" />
                        </kspwc:TRadButton>
                    </div>
                    <telerik:RadDataPager ID="RDP_page" runat="server" PagedControlID="RLV_bull" CssClass="ksBlPager"
                        PageSize="5">
                        <Fields>
                            <%--<telerik:RadDataPagerButtonField FieldType="FirstPrev"></telerik:RadDataPagerButtonField>--%>
                            <%--<telerik:RadDataPagerButtonField FieldType="Numeric" PageButtonCount="4"></telerik:RadDataPagerButtonField>--%>
                            <%-- <telerik:RadDataPagerButtonField FieldType="NextLast"></telerik:RadDataPagerButtonField>--%>
                            <telerik:RadDataPagerSliderField />
                            <telerik:RadDataPagerPageSizeField PageSizes="2,5,10,15,20"></telerik:RadDataPagerPageSizeField>
                            <%--<telerik:RadDataPagerGoToPageField></telerik:RadDataPagerGoToPageField>--%>
                        </Fields>
                    </telerik:RadDataPager>
                </div>
                <asp:Panel runat="server" ID="P_filtry" Visible='<%# Editacni %>'>
                    <kspwc:TRadButton ID="TRB_F_generated" runat="server" ToggleType="CheckBox" ButtonType="StandardButton" OnCheckedChanged="TRB_F_generated_CheckedChanged"
                        OnInit="TRB_F_generated_Init">
                        <ToggleStates>
                            <telerik:RadButtonToggleState Text="[%Včetně generovaných%]" PrimaryIconCssClass="fi fi-file" Value="false"></telerik:RadButtonToggleState>
                            <telerik:RadButtonToggleState Text="[%Bez generovaných%]" PrimaryIconCssClass="fi fi-file-excel" Value="true"></telerik:RadButtonToggleState>
                        </ToggleStates>
                    </kspwc:TRadButton>
                    <kspwc:TRadComboBox ID="TRCB_F_oscislo" runat="server" EnableLoadOnDemand="True"
                        EnableVirtualScrolling="True" Height="150px" ShowMoreResultsBox="True" DropDownAutoWidth="Enabled" MarkFirstMatch="true"
                        EmptyMessage="[%Adresát%]" AutoPostBack="True"
                        OnTextChanged="TRCB_F_oscislo_TextChanged"
                        OnClientItemsRequesting="TRCB_F_oscislo_ItemsRequesting"
                        OnClientDropDownClosed="TRCB_F_oscislo_DropDownClosed">
                        <WebServiceSettings Method="GetZamestnanci" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                    </kspwc:TRadComboBox>
                    <telerik:RadTextBox runat="server" ID="TTB_googleSearch" EmptyMessage="[%Obsahuje text%]" OnTextChanged="TTB_googleSearch_TextChanged" AutoPostBack="true">
                    </telerik:RadTextBox>
                    <kspwc:TRadDatePicker runat="server" ID="TRDP_F_den" DateInput-EmptyMessage="[%Viditelný dne%]" OnSelectedDateChanged="TRDP_F_den_SelectedDateChanged" AutoPostBack="true">
                    </kspwc:TRadDatePicker>
                </asp:Panel>
            </asp:Panel>
            <asp:PlaceHolder runat="server" ID="ItemsPlaceHolder"></asp:PlaceHolder>
            <%--<asp:Panel runat="server" ID="P_buttons_f" Visible='<%# Editacni %>' CssClass="ksBlButtFooter">
                <fieldset class="ksBlFs">
                    <asp:Label ID="lblSort1" runat="server" Text="[%Třídit%]"></asp:Label>
                    <telerik:RadComboBox ID="RCB_sort" Width="100px" runat="server" AutoPostBack="true" OnSelectedIndexChanged="RCB_sort_SelectedIndexChanged" CausesValidation="false">
                        <Items>
                            <telerik:RadComboBoxItem Text="[%Netřídit%]" Value="ClearSort"></telerik:RadComboBoxItem>
                            <telerik:RadComboBoxItem Text="[%Nadpis%]" Value="nadpis"></telerik:RadComboBoxItem>
                            <telerik:RadComboBoxItem Text="[%Tělo%]" Value="telo"></telerik:RadComboBoxItem>
                            <telerik:RadComboBoxItem Text="[%Publikovat od%]" Value="datum_od"></telerik:RadComboBoxItem>
                            <telerik:RadComboBoxItem Text="[%Publikovat do%]" Value="datum_do"></telerik:RadComboBoxItem>
                            <telerik:RadComboBoxItem Text="[%Publikováno%]" Value="Publikovano"></telerik:RadComboBoxItem>
                        </Items>
                    </telerik:RadComboBox>
                    <telerik:RadComboBox ID="RCB_order" Width="100px" runat="server" AutoPostBack="true" CausesValidation="false">
                        <Items>
                            <telerik:RadComboBoxItem Text="[%Vzestupně%]" Value="ClearSort"></telerik:RadComboBoxItem>
                            <telerik:RadComboBoxItem Text="[%Sestupně%]" Value="nadpis"></telerik:RadComboBoxItem>
                        </Items>
                    </telerik:RadComboBox>
                </fieldset>
            </asp:Panel>--%>
        </LayoutTemplate>
        <ItemTemplate>
            <fieldset class="ksBlFs">
                <div class="ksBlBullItem">
                    <div>
                        <div class="ksBlFoto" style="display: <%# Eval("id_image") != null ? "block" : "none"%>;">
                            <img style="max-height: 107px; width:auto;" src="<%# Eval("ImageUrl") %>" />
                            <%--<kspwc:TRadButton runat="server" ID="TRB_image" Width="160" Height="107" Image-ImageUrl='<%# Eval("ImageUrl") %>' Visible='<%# Eval("id_image") != null %>'>
                            <Image EnableImageButton="true"  />
                        </kspwc:TRadButton>--%>
                        </div>
                        <div>
                            <p>
                                
 							<asp:LinkButton runat="server" ID="LB_nadpis" Text='<%# Eval("nadpis") %>' OnClick="LB_nadpis_Click" Enabled=" <%# !KSProgram.Prava.ZamykaniAgend.GeneralZamekIsLocked() %>" CssClass="color2text"></asp:LinkButton>
                           
                            </p>
                            <p>
                                <%# Eval("telo") %>
                            </p>
                            <p>
                                <asp:Label runat="server" ID="L_adr" Text="[%Adresáti%]: " Visible='<%# Editacni %>'><%# Eval("s_Adresats") %></asp:Label>
                            </p>
                        </div>
                        <asp:Panel runat="server" ID="P_pub" CssClass="ksBlBub" Visible='<%# Editacni %>'>
                            <style type="text/css">
                                div.ksBlFoto {
                                    height: 120px !important;
                                    margin-top: 6px;
                                }
                            </style>
                            <kspwc:TRadDatePicker runat="server" ID="TRDP_od" SelectedDate='<%# Eval("datum_od") %>' Enabled="false">
                                <DateInput EmptyMessage="[%Publikovat od%]"></DateInput>
                            </kspwc:TRadDatePicker>
                            <kspwc:TRadDatePicker runat="server" ID="TRDP_do" SelectedDate='<%# Eval("datum_do") %>' Enabled="false">
                                <DateInput EmptyMessage="[%Publikovat do%]"></DateInput>
                            </kspwc:TRadDatePicker>
                            <div>
                                <kspwc:TRadButton runat="server" ID="TRB_publikovat" AutoPostBack="false" ButtonType="StandardButton" ToggleType="CheckBox" Checked='<%# Eval("Publikovano") %>' Enabled="false">
                                    <ToggleStates>
                                        <telerik:RadButtonToggleState Text="[%Je publikováno%]" />
                                        <telerik:RadButtonToggleState Text="[%Není publikováno%]" />
                                    </ToggleStates>
                                </kspwc:TRadButton>
                            </div>
                        </asp:Panel>
                    </div>
                    <asp:Panel runat="server" ID="P_e_butt" CssClass="ksBlButtEdit" Visible='<%# Editacni %>'>
                        <kspwc:TRadButton runat="server" ID="TRB_edit" ButtonType="StandardButton" CommandName="Edit" Text="[%Upravit%]" ToolTip="[%Upravit záznam%]">
                            <Icon PrimaryIconCssClass="fi fi-edit" />
                        </kspwc:TRadButton>
                        <kspwc:TRadButton runat="server" ID="TRB_delete" ButtonType="StandardButton" CommandName="Delete" Text="[%Smazat%]" ToolTip="[%Smazat záznam%]" ConfirmText="[%Smazat záznam?%]">
                            <Icon PrimaryIconCssClass="fi fi-trash" />
                        </kspwc:TRadButton>
                    </asp:Panel>
                </div>
            </fieldset>
        </ItemTemplate>
        <InsertItemTemplate>
            <bc:BulletinListEditItem runat="server" ID="BLEI_insert" IsInsert="true"></bc:BulletinListEditItem>
        </InsertItemTemplate>
        <EditItemTemplate>
            <bc:BulletinListEditItem runat="server" ID="BLEI_edit" IsInsert="false"></bc:BulletinListEditItem>
        </EditItemTemplate>
    </telerik:RadListView>
</asp:Panel>
