﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="CestovniPrikaz.ascx.cs" Inherits="KSPortal.Controls.CestovniPrikaz" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls" TagPrefix="wc" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>
<%@ Register Assembly="WebControls" Namespace="KSProgram.WebControls.Ciselniky" TagPrefix="cis" %>
<%@ Register Assembly="WebControlsAlone" Namespace="KSProgram.WebControlsAlone" TagPrefix="cc2" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<%--při změně módu z editace do readonly se Pnl_vozidlo oběvovalo úplně na konci stránky
<telerik:RadAjaxManagerProxy ID="RadAjaxManagerProxy1" runat="server">
        <AjaxSettings>
            
            <telerik:AjaxSetting AjaxControlID="RG_cesty">
                <UpdatedControls>  
                    <telerik:AjaxUpdatedControl ControlID="Pnl_vozidlo" />                    
                    <telerik:AjaxUpdatedControl ControlID="FV_SlcHlavicka" />   a toto zase generuje chybu kvůli inline kódu              
                </UpdatedControls>
            </telerik:AjaxSetting>            
            
        </AjaxSettings>
    </telerik:RadAjaxManagerProxy>
--%>

<telerik:RadScriptBlock ID="CP_RadScriptBlock1" runat="server">
    <script type="text/javascript" id="telRSBsluzc">
        //<![CDATA[
        var gdc_os_cislo = <%= OsCislo %>;
        var gi_sk = <%= KSProgram.Zakaznik.IsSR() ? 1 : 0 %>;
        var gi_ZPC = <%= CPjeZahranicni ? 1 : 0 %>;
        var gs_KodMenyApl = "<%= KSProgram.Globals.KodMeny %>";
        var gas_cn_druhy = '<%=getNastaveni("cn_druhy")%>'.split("|");
        var gas_cn_jvn = '<%=getNastaveni("cn_jvn")%>'.split("|");
        var gas_cn_dphkod = '<%=getNastaveni("cn_dphkod")%>'.split("|");
        var gas_ZPbezNahr = '<%=getNastaveni("ZPbezNahr")%>'.split("|");
        var gas_dph_kody = '<%=getNastaveni("dph_kody")%>'.split("|");
        var gas_dph_sazby = '<%=getNastaveni("dph_sazby")%>'.split("|");
        var gas_dopr_letOrPlav = '<%=getNastaveni("dopr_letOrPlav")%>'.split("|");
        var gas_dopr_kmPov = '<%=getNastaveni("dopr_kmPov")%>'.split("|");
        var gs_VyplnHlavDle_Btn = '<%=WebControlHelper.FindControl(FV_SlcHlavicka, "VyplnHlavDle_Btn")==null ? "xxx" : WebControlHelper.FindControl(FV_SlcHlavicka, "VyplnHlavDle_Btn").ClientID%>';
        var gi_MaxRows = 150;
        var gs_DecSeparSrv = '<%=System.Globalization.CultureInfo.CurrentCulture.NumberFormat.NumberDecimalSeparator%>';

        function new_vozidlo() {
            window.open('../Pozadavky/PozadavekDetail.aspx?typ=vozidlo', 'newvozidlo');
        }

        function reloadRadWinCesty() {
            //v InsertModu nefungoval postback přímo z tlačítka, proto toto řešení
            __doPostBack('reloadRadWinCesty', 'open');
        }

        <%--function RG_cesty_vyber(sender, args) {
            var SenderId = sender.get_element().id;
            
            var res = parseSenderId(SenderId);
            var row = res.row;
            var prefix = res.prefix;
            var SenderServerId = res.senderServerId;
            alert("RG_cesty_vyber");
            alert("RG_cesty_vyber args: "+args.get_commandArgument());
            var spz = args.get_commandArgument();
            var spzv_id = '<%=FV_SlcHlavicka.FindControl("spz_vlast_DDL")==null ? "" : FV_SlcHlavicka.FindControl("spz_vlast_DDL").ClientID%>';
            var spzs_id = '<%=FV_SlcHlavicka.FindControl("spz_sluz_DDL")==null ? "" : FV_SlcHlavicka.FindControl("spz_sluz_DDL").ClientID%>';
            if (spzv_id != "") DDLSetValue($find(spzv_id), spz);
            if (spzs_id != "") DDLSetValue($find(spzs_id), spz);

            //var tr = document.getElementById(prefix + row + "_ItemRow");
            //if (tr != null) {
                //
                //$find(prefix + row + "_datum_TB").set_selectedDate(null);
            //    DDLSetValue($find(prefix + row + "_druh_DDL"), "");
            //    document.getElementById(prefix + row + "_pozn_TB").value = "";
            //}  


        }--%>

        function Hl_dat_od_DateSelected(sender, e) {
            if (e.get_newDate() != null) {
                //alert("Hl_dat_od_DateSelected: " + e.get_newDate().toDateString() + " selected in " + sender.get_id());
                //alert("Hl_dat_od_DateSelected: " + e.get_newDate().format("dd.MM.yyyy") + " selected in " + sender.get_id());

                $.ajax({
                    type: "POST",
                    url: "../Zamestnanec/SluzebniCesty.aspx/GetEvCisloSpolucestujiciho",
                    data: "{os_cislo:" + gdc_os_cislo + ", dat_od:'" + e.get_newDate().format("dd.MM.yyyy") + "'}",
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: onSuccess,
                    failure: function (response) {
                        //alert("Chyba: " + JSON.parse(response.responseText).Message);
                        alert("Chyba: " + $telerik.$.parseJSON(response.responseText).Message);
                    },
                    error: function (response) {
                        //alert("Chyba: ", JSON.parse(response.responseText).Message);
                        alert("Chyba: " + $telerik.$.parseJSON(response.responseText).Message);
                    }
                });

                function onSuccess(response) {
                    //alert(response.d.value);
                    //alert($telerik.$.parseJSON(response.responseText).value);                    
                    var HF_VyplnHlavDle = document.getElementById('<%=HF_VyplnHlavDle.ClientID%>');
                    HF_VyplnHlavDle.value = response.d.value;
                    var VyplnHlavDle_Btn = document.getElementById(gs_VyplnHlavDle_Btn);
                    if (VyplnHlavDle_Btn != null) {
                        VyplnHlavDle_Btn.innerHTML = response.d.info;
                        AddRemoveCssClass('#' + gs_VyplnHlavDle_Btn, "hidden", (response.d.value == 0));
                    }
                }

            }
            else {
                //alert("Hl_dat_od_DateSelected: Date cleared in " + sender.get_id());
            }
        }

        function OnPocMistoTextChange(sender, eventArgs) {
            var p = sender.get_text();
            var k = $find(sender.get_element().id.replace("poc_misto", "kon_misto"));
            if (p != k.get_text())
                if (confirm('<%= KSProgram.Obecne.ReadGlobalResource.ZmenaTextu("[%Končí cesta ve stejném místě kde začíná?%]")%>')) {
                    k.set_text(p);
                }
        }

        function OnCilZemeDDLChanged(sender, eventArgs) {
            var cil_zeme_DDL = sender;
            var SenderId = sender.get_element().id;
            var typ_DDL = $find(SenderId.replace("cil_zeme_DDL", "typ_DDL"));
            if (cil_zeme_DDL._selectedIndex == 1) {//ČR (or SR)                
                DDLSetValue(typ_DDL, "t"); //t - tuzemská
            }
            else if (cil_zeme_DDL._selectedIndex > 1) {//cizi země                
                DDLSetValue(typ_DDL, "z"); //z - zahraniční
            }
        }

        function ZalVyplJakOnChange(sender, eventArgs) {
            var vypl_jak_DDL = sender;
            var SenderId = sender.get_element().id;

            var res = parseSenderId(SenderId);
            var row = res.row;
            var prefix = res.prefix;

            var cis_bk_DDL = $find(prefix + row + "_cis_bk_DDL");
            if (vypl_jak_DDL._selectedValue == "V") //vyber hotovosti kartou
            {
                AddRemoveCssClass("#" + prefix + row + "_" + "cis_bk_DDL", "hidden", false);
                var cis_bk_DDL = $find(prefix + row + "_cis_bk_DDL");
                if (cis_bk_DDL.get_items().get_count() == 2)//PR 20.05.2022 
                    cis_bk_DDL.getItem(1).select();
            }
            else {
                DDLSetValue(cis_bk_DDL, "");
                AddRemoveCssClass("#" + prefix + row + "_" + "cis_bk_DDL", "hidden", true);
            }
        }

        function OnZemeOdDDLChanged(sender, eventArgs) {
            var zeme_od_DDL = sender;
            var SenderId = sender.get_element().id;

            var res = parseSenderId(SenderId);
            var row = res.row;
            var prefix = res.prefix;

            var udalost_DDL = $find(prefix + row + "_udalost_DDL");
            var dopr_prost_DDL = $find(prefix + row + "_dopr_prost_DDL");
            var udalost = udalost_DDL._selectedValue;
            var dopr = dopr_prost_DDL._selectedValue;

            var zeme_do_DDL = $find(SenderId.replace("zeme_od_DDL", "zeme_do_DDL"));
            //var zeme_do_visible = zeme_do_DDL.get_element().getAttribute("class").indexOf("hidden") < 0 || udalost == "H" || (gi_ZPC == 1 && udalost == "O" && dopr == "L");
            var zeme_do_visible = zeme_do_DDL.get_element().getAttribute("class").indexOf("hidden") < 0 || udalost == "H" || (gi_ZPC == 1 && udalost == "O" && gas_dopr_letOrPlav.indexOf(dopr) >= 0);

            if (gi_ZPC == 0 || zeme_do_visible == false) {
                var item = zeme_do_DDL.findItemByValue(zeme_od_DDL._selectedValue);
                if (item == null) item = zeme_do_DDL.get_items().getItem(0);
                item.select();
            }
        }

        function getRouteURL(map) {
            //alert("getRouteURL");
            var ll_row;
            var ls_url, ls_mista = [], ls_udalost, ls_misto = "", ls_misto_prev = "", ls_zeme = "";

            if (map == "google")
                ls_url = "http://www.google.com/maps/dir"; //ls_url = "http://maps.google.com/maps?f=d&source=s_d";
            else
                ls_url = "http://mapy.cz/zakladni?planovani-trasy&z=9";

            //alert("getRouteURL-basic url="+ls_url);

            var prefix = "<%= LV_Prubeh.ClientID %>" + "_ctrl";
            var lastRow = LVLastVisibleRow(prefix);
            //alert("getRouteURL-lastRow=" + lastRow);
            if (lastRow == null) return "";
            for (ll_row = 0; ll_row <= lastRow; ll_row++) {
                var prub_vals = Prubeh_GetValues(ll_row);
                ls_udalost = prub_vals.udalost;
                ls_misto = prub_vals.misto;
                if (ls_misto == "hraniční přechod") continue;
                ls_zeme = prub_vals.zeme_od;
                if (ls_zeme.length > 0) ls_misto = ls_misto + ", " + ls_zeme;
                //alert(ll_row + " " + ls_misto);
                if ("OPH".indexOf(ls_udalost) >= 0 && ls_misto.length > 0 && ls_misto != ls_misto_prev) {
                    ls_mista.push(ls_misto);
                    ls_misto_prev = ls_misto;
                }
            }
            //alert("getRouteURL-ls_mista=" + ls_mista.toString());
            for (ll_row = 0; ll_row < ls_mista.length; ll_row++) {
                if (ls_url.indexOf("mapy.cz") > 0)
                    ls_url += '&rl=' + encodeURI(ls_mista[ll_row]);
                else {
                    ls_url += '/' + encodeURI(ls_mista[ll_row]);
                    //				    if (ll_row == 0)
                    //					    ls_url += '&saddr=' + encodeURI(ls_mista[ll_row]);
                    //				    else if (ll_row == 1)
                    //					    ls_url += '&daddr=' + encodeURI(ls_mista[ll_row]);
                    //				    else
                    //					    ls_url += '+to:' + encodeURI(ls_mista[ll_row]); 
                }
            }
            if (ls_url.indexOf("mapy.cz") > 0)
                ls_url += '&rp={"criterion"%3A"fast"}&ri=0';
            else
                ls_url += '/?hl=cs&ie=UTF8';
            ls_url = ls_url.replace(/ /g, "+");
            //alert(ls_url);
            return ls_url;
        }

        function CasKeyPress(sender, event) {
            var charval;
            if (event.which == null) {
                charval = String.fromCharCode(event.keyCode); // IE
            } else if (event.which != 0 && event.charCode != 0) {
                charval = String.fromCharCode(event.which);   // the rest
            } else {
                return true; // special key
            }
            if (event.ctrlKey) return true; //ctrl+A
            if (charval.match(/[0-9]/g) == null) {
                if (event.preventDefault)
                    event.preventDefault();
                else
                    event.returnValue = false;
            }
            return true;
        }
        function CasKeyUp(sender, event) {
            var oldval = "";
            if (sender.oldvalue != null) oldval = sender.oldvalue;
            if (parseInt(sender.value.charAt(0)) > 2)
                sender.value = "0" + sender.value;
            if (sender.value.length == 2 && oldval.length != 3) {
                sender.value = sender.value + ":";
            }
            sender.oldvalue = sender.value;
            return true;
        }

        function CasChange(sender, event) {
            if (sender.value.length == 1 && parseInt(sender.value.charAt(0)) > 2)
                sender.value = "0" + sender.value;
            if (sender.value.length == 2) {
                sender.value = sender.value + ":00";
            }
            else if (sender.value.length == 3 && sender.value.charAt(2) == ":") {
                sender.value = sender.value + "00";
            }
            return true;
        }

        function NahradaOnChange(sender, args) {
            var obj;
            try {
                obj = sender.get_element();
            } catch (e) {
                obj = sender;
            }
            try {
                var SenderId = obj.id;

                var res = parseSenderId(SenderId);
                var row = res.row;
                var prefix = res.prefix;
                var SenderServerId = res.senderServerId;

                //alert("NahradaOnChange SenderServerId=" + SenderServerId);

                //controls
                var druh_DDL = $find(prefix + row + "_druh_DDL");
                var vydaj_TB = document.getElementById(prefix + row + "_vydaj_TB");
                var mena_DDL = $find(prefix + row + "_mena_DDL");
                var pl_DDL = $find(prefix + row + "_pl_DDL");
                var dphkod_DDL = $find(prefix + row + "_dphkod_DDL");
                var nahrada_TB = document.getElementById(prefix + row + "_nahrada_TB");
                var nahrada_zvys_TB = document.getElementById(prefix + row + "_nahrada_zvys_TB");
                var naklad_TB = document.getElementById(prefix + row + "_naklad_TB");
                var dph_TB = document.getElementById(prefix + row + "_dph_TB");
                var cis_bk_DDL = $find(prefix + row + "_cis_bk_DDL");

                //values
                var ls_druh, ldc_vydaj, ldc_nahrada, ldc_dph, ls_VydajMena, ls_pl, ls_dphkod, ldc_dphsazba;
                ls_druh = druh_DDL._selectedValue;
                try {
                    ldc_vydaj = parseFloat(vydaj_TB.value.replace(",", ".")); //PR 12.5.2016 JS si neporadí s cz čárkou
                    if (isNaN(ldc_vydaj)) ldc_vydaj = 0;
                }
                catch (e) { ldc_vydaj = 0; }
                ls_VydajMena = mena_DDL._selectedValue;
                ls_pl = pl_DDL._selectedValue;
                ls_dphkod = dphkod_DDL._selectedValue;

                //alert("druh=" + ls_druh + ", castka=" + ldc_vydaj + " " + ls_VydajMena + ", pl=" + ls_pl + ", dphkod=" + ls_dphkod);

                var ls_jvn, ls_dphkodprodruh;
                for (i = 0; i < gas_cn_druhy.length; i++) {
                    if (gas_cn_druhy[i] == ls_druh) {
                        ls_jvn = gas_cn_jvn[i];
                        ls_dphkodprodruh = gas_cn_dphkod[i];
                        break;
                    }
                }

                if (SenderServerId == "druh_DDL") {
                    if (ls_druh == "0st" || ls_druh == "0kp" || ls_druh == "0jz" || ls_druh == "0jp") {
                        jAlert('<%= WebControlHelper.ZmenaTextu("[%Nelze zadávat výdaje, které automaticky generuje systém%]!")%>');
                        DDLSetValue(druh_DDL, "");
                        return;
                    }
                }

                if (SenderServerId == "druh_DDL" || SenderServerId == "vydaj_TB" || SenderServerId == "mena_DDL") {
                    if (ls_VydajMena == gs_KodMenyApl)
                        ls_dphkod = ls_dphkodprodruh;
                    else
                        ls_dphkod = "";
                    DDLSetValue(dphkod_DDL, ls_dphkod);
                }
                //PR 22.4.2015 HID=28202 trochu poměněno, aby se při změně z pl=F,V,U na pl=H,B,K zpátky nastavila náhrada z 0 na výdaj
                if (SenderServerId == "vydaj_TB" || SenderServerId == "pl_DDL") {
                    nahrada_TB.value = "";//PR 17.5.2017 
                    nahrada_zvys_TB.value = "";//PR 17.5.2017                      
                    if (ldc_vydaj != null) {
                        ldc_nahrada = ldc_vydaj;
                        if (ls_pl != null && ls_pl == "V") //PR 22.6.2015 v číselníku Zp.pl. je to přednastaveno blbě
                        {   //V ale validaci neprojde, patri to do zaloh
                            ldc_vydaj = -1 * Math.abs(ldc_vydaj);
                            vydaj_TB.value = ldc_vydaj.toString().replace(".", gs_DecSeparSrv);
                            ldc_nahrada = ldc_vydaj;
                        }
                        else if (gas_ZPbezNahr.indexOf(ls_pl) >= 0) {
                            ldc_nahrada = 0;
                        }
                        nahrada_TB.value = ldc_nahrada.toString().replace(".", gs_DecSeparSrv);

                        if (ls_jvn == "a") {
                            nahrada_zvys_TB.value = ldc_nahrada.toString().replace(".", gs_DecSeparSrv);
                        }
                        else {
                            nahrada_zvys_TB.value = 0;
                        }
                    }
                    else {
                        nahrada_TB.value = "";
                        nahrada_zvys_TB.value = "";
                    }
                }

                if (SenderServerId == "vydaj_TB") {

                }

                if (SenderServerId == "druh_DDL" || SenderServerId == "vydaj_TB" || SenderServerId == "mena_DDL" || SenderServerId == "dphkod_DDL") {
                    naklad_TB.value = "";//PR 17.5.2017 
                    dph_TB.value = "";//PR 17.5.2017
                    if (ldc_vydaj != null) {
                        ldc_dphsazba = 0;
                        for (i = 0; i < gas_dph_kody.length; i++) {
                            if (gas_dph_kody[i] == ls_dphkod) {
                                try {
                                    ldc_dphsazba = parseFloat(gas_dph_sazby[i]);
                                } catch (e) { }
                            }
                        }

                        if (ldc_dphsazba > 0) {
                            //var ldc_k = ldc_dphsazba / (100 + ldc_dphsazba);
                            //ldc_k = parseFloat(ldc_k.toFixed(4));
                            //ldc_dph = ldc_vydaj * ldc_k;
                            ldc_dph = ldc_vydaj * (ldc_dphsazba / (100 + ldc_dphsazba));//PR 01.07.2019 zrušeno zaokrouhlování koeficientu
                            ldc_dph = parseFloat(ldc_dph.toFixed(2));
                        }
                        else {
                            ldc_dph = 0;
                        }

                        ldc_vydaj = ldc_vydaj - ldc_dph;

                        naklad_TB.value = ldc_vydaj.toFixed(2).replace(".", gs_DecSeparSrv);
                        dph_TB.value = ldc_dph.toFixed(2).replace(".", gs_DecSeparSrv);
                    }
                }
                if (SenderServerId == "pl_DDL") {
                    if (ls_pl == "F") {
                        AddRemoveCssClass("#" + prefix + row + "_" + "cis_bk_DDL", "hidden", false);
                        if (cis_bk_DDL.get_items().get_count() == 2)//PR 20.05.2022 
                            cis_bk_DDL.getItem(1).select();
                    }
                    else {
                        DDLSetValue(cis_bk_DDL, "");
                        AddRemoveCssClass("#" + prefix + row + "_" + "cis_bk_DDL", "hidden", true);
                    }

                }
            } catch (e) {//PR 17.5.2017
                alert("Javascript error:NahradaOnChange:" + e.message);
                nahrada_TB.value = "";
                nahrada_zvys_TB.value = "";
                naklad_TB.value = "";
                dph_TB.value = "";
            }
        }

        //function Hl_PrintButtonOnClientClicked(button, args) {
        //    window.print();
        //}

        function AddRemoveCssClass(selector, cssclass, add) {
            if (add == true)
                $(selector).addClass(cssclass);
            else
                $(selector).removeClass(cssclass);
        }

        function DDLSetValue(ddl, value) {
            var item = ddl.findItemByValue(value);
            if (item == null) item = ddl.get_items().getItem(0);
            if (item != null) item.select();
        }

        function parseSenderId(SenderId) {
            var p = SenderId.lastIndexOf("ctrl");
            pref = SenderId.substring(0, p + 4);
            var row_str = SenderId.substring(p + 4);
            senderSrvId = row_str.substring(row_str.indexOf("_") + 1);
            row_str = row_str.substring(0, row_str.indexOf("_"));
            var r = parseInt(row_str);
            var result = { row: r, prefix: pref, senderServerId: senderSrvId };
            return result;
        }


        function LVMaxHFValue(prefix, HF_name) {
            var maxVal = 0;
            var val = null;
            var HF = null;
            for (row = 0; row < gi_MaxRows; row++) {
                HF = document.getElementById(prefix + row + "_" + HF_name);
                if (HF != null) {
                    val = parseInt(HF.value);
                    if (val > maxVal) maxVal = val;
                } else {
                    //alert("break on row " + row + ", " + HF_name + ".maxVal=" + maxVal);
                    break;
                }
            }
            return maxVal;
        }

        function LVLastVisibleRow(prefix) {
            var find_row = null;
            var tr = null;
            for (row = gi_MaxRows - 1; row >= 0; row--) {
                tr = document.getElementById(prefix + row + "_ItemRow");
                if (tr != null) {
                    if (tr.getAttribute("class") != "hidden") {
                        find_row = row;
                        break;
                    }
                }
            }
            return find_row;
        }

        function LVFirstHiddenRow(prefix, startrow) {
            if (startrow == null) startrow = 0;
            var find_row = null;
            var tr = null;
            for (var row = startrow; row < gi_MaxRows; row++) {
                tr = document.getElementById(prefix + row + "_ItemRow");
                if (tr != null) {
                    if (tr.getAttribute("class") == "hidden") {
                        find_row = row;
                        break;
                    }
                }
            }
            return find_row;
        }

        function NahradyAddRow(sender, args) {
            //alert("NahradyAddRow");
            var prefix = "<%= LV_Nahrady.ClientID %>" + "_ctrl";
            var row = LVLastVisibleRow(prefix);
            row = LVFirstHiddenRow(prefix, row);
            var tr = null;
            if (row != null) {
                tr = document.getElementById(prefix + row + "_ItemRow");
                if (tr != null) {
                    tr.removeAttribute("class");
                    var datum;
                    var datum_TB = $find(prefix + (row - 1) + "_datum_TB");
                    if (datum_TB != null)
                        datum = datum_TB.get_selectedDate();
                    else
                        datum = '<%= Dat_od %>';
                    datum_TB = $find(prefix + row + "_datum_TB");
                    var mena_DDL = $find(prefix + row + "_mena_DDL");
                    datum_TB.set_selectedDate(datum);
                    DDLSetValue(mena_DDL, gs_KodMenyApl);

                }
            }
            if (row == null || tr == null)
                jAlert("Další řádky lze přidat až po uložení aktuálně zadaných !");
        }

        function NahradyDeleteRow(sender, args) {
            var SenderId = sender.get_element().id;

            var res = parseSenderId(SenderId);
            var row = res.row;
            var prefix = res.prefix;
            var SenderServerId = res.senderServerId;

            var tr = document.getElementById(prefix + row + "_ItemRow");
            if (tr != null) {
                //"datum_TB", "druh_DDL", "pozn_TB", "vydaj_TB", "mena_DDL", "pl_DDL", "nahrada_TB", "dphkod_DDL", "naklad_TB", "dph_TB"
                $find(prefix + row + "_datum_TB").set_selectedDate(null);
                DDLSetValue($find(prefix + row + "_druh_DDL"), "");
                document.getElementById(prefix + row + "_pozn_TB").value = "";
                document.getElementById(prefix + row + "_vydaj_TB").value = "";
                DDLSetValue($find(prefix + row + "_mena_DDL"), "");
                DDLSetValue($find(prefix + row + "_pl_DDL"), "");
                document.getElementById(prefix + row + "_nahrada_TB").value = "";
                document.getElementById(prefix + row + "_nahrada_zvys_TB").value = "";
                DDLSetValue($find(prefix + row + "_dphkod_DDL"), "");
                document.getElementById(prefix + row + "_naklad_TB").value = "";
                document.getElementById(prefix + row + "_dph_TB").value = "";

                tr.setAttribute("class", "hidden");
            }
        }

        function PrubehAddRow(sender, args) {
            //alert("PrubehAddRow");
            var prefix = "<%= LV_Prubeh.ClientID %>" + "_ctrl";
            var row = LVLastVisibleRow(prefix);
            if (row >= gi_MaxRows - 1) {
                jAlert("Dosaženo maximálního počtu řádků !");
                return;
            }
            row = LVFirstHiddenRow(prefix, row);
            var tr = null;
            if (row != null) {
                tr = document.getElementById(prefix + row + "_ItemRow");
                if (tr != null) {
                    tr.removeAttribute("class");
                    Prubeh_Predvypln_Radek(prefix, row);
                    radek_HF = document.getElementById(prefix + row + "_radek_HF");
                    var maxRowId = LVMaxHFValue(prefix, "radek_HF");
                    var delMaxRowId = LVMaxHFValue(prefix, "orig_radek_HF");
                    if (delMaxRowId > maxRowId) maxRowId = delMaxRowId;
                    radek_HF.value = maxRowId + 1;
                    PrubehFixValuesAndCss(prefix);
                }
            }
            if (row == null || tr == null)
                jAlert("Další řádky lze přidat až po uložení aktuálně zadaných !");
        }

        function PrubehInsertRow(sender, args) {
            var SenderId = sender.get_element().id;

            var res = parseSenderId(SenderId);
            var row = res.row;
            var prefix = res.prefix;
            var SenderServerId = res.senderServerId;

            var k = LVLastVisibleRow(prefix) + 1;
            if (k - 1 >= gi_MaxRows - 1) {
                jAlert("Dosaženo maximálního počtu řádků !");
                return;
            }
            var tr = document.getElementById(prefix + k + "_ItemRow");
            if (tr != null) {
                tr.removeAttribute("class");
                k = gi_MaxRows - 1; //PR 12.4.2016 musim posunout i data radků ke smazani
                for (i = k; i > row; i--) {
                    tr = document.getElementById(prefix + i + "_ItemRow");
                    if (tr != null) {
                        var prub_vals = Prubeh_GetValues(i - 1);
                        Prubeh_SetValues(i, prub_vals);
                    }
                }
                tr = document.getElementById(prefix + row + "_ItemRow");
                if (tr != null) {
                    orig_radek_HF = document.getElementById(prefix + row + "_orig_radek_HF");
                    orig_radek_HF.value = "0";
                    radek_HF = document.getElementById(prefix + row + "_radek_HF");
                    var maxRowId = LVMaxHFValue(prefix, "radek_HF");
                    //alert("maxRowId = " + maxRowId);
                    var delMaxRowId = LVMaxHFValue(prefix, "orig_radek_HF");
                    //alert("delMaxRowId = " + delMaxRowId);
                    if (delMaxRowId > maxRowId) maxRowId = delMaxRowId;
                    radek_HF.value = maxRowId + 1;
                    Prubeh_Predvypln_Radek(prefix, row);
                }
                PrubehFixValuesAndCss(prefix);
            }
            else
                jAlert("Další řádky lze přidat až po uložení aktuálně zadaných !");
        }

        function PrubehDeleteRow(sender, args) {
            var SenderId = sender.get_element().id;

            var res = parseSenderId(SenderId);
            var row = res.row;
            var prefix = res.prefix;
            var SenderServerId = res.senderServerId;

            var tr = document.getElementById(prefix + row + "_ItemRow");
            if (tr != null) {
                radek_HF = document.getElementById(prefix + row + "_radek_HF");
                radek_HF.value = "0";
                tr.setAttribute("class", "hidden");
                PrubehFixValuesAndCss(prefix);
            }

        }

        //    function hideOrShowRowItem(prefix, row, hide) {
        //        var tr = document.getElementById(prefix + row + "_ItemRow");
        //        if (tr != null) {
        //            if (hide)
        //                tr.class = "hidden";
        //            else
        //                tr.class = "";
        //        }
        //    }

        function Prubeh_GetValues(row) {
            var prefix = "<%= LV_Prubeh.ClientID %>" + "_ctrl";
            //====== controls ======
            var orig_radek_HF = document.getElementById(prefix + row + "_orig_radek_HF");
            var radek_HF = document.getElementById(prefix + row + "_radek_HF");
            var udalost_DDL = $find(prefix + row + "_udalost_DDL");
            var datum_TB = $find(prefix + row + "_datum_TB");
            var cas_TB = document.getElementById(prefix + row + "_cas_TB");
            var misto_TB = document.getElementById(prefix + row + "_misto_TB");
            var zeme_od_DDL = $find(prefix + row + "_zeme_od_DDL");
            var zeme_do_DDL = $find(prefix + row + "_zeme_do_DDL");
            var dopr_prost_DDL = $find(prefix + row + "_dopr_prost_DDL");
            var km_mesto_TB = document.getElementById(prefix + row + "_km_mesto_TB");
            var km_mimo_TB = document.getElementById(prefix + row + "_km_mimo_TB");
            var km_komb_TB = document.getElementById(prefix + row + "_km_komb_TB");
            var vzdalenost_TB = document.getElementById(prefix + row + "_vzdalenost_TB");

            //====== values ======
            var orgr = (orig_radek_HF != null) ? orig_radek_HF.value : "";
            var r = (radek_HF != null) ? radek_HF.value : "";
            var u = (udalost_DDL != null) ? udalost_DDL._selectedValue : "";
            var d = (datum_TB != null) ? datum_TB.get_selectedDate() : null;
            var c = (cas_TB != null) ? cas_TB.value : "";
            var m = (misto_TB != null) ? misto_TB.value : "";
            var z_od = (zeme_od_DDL != null) ? zeme_od_DDL._selectedValue : "";
            var z_do = (zeme_do_DDL != null) ? zeme_do_DDL._selectedValue : "";
            var dopr = (dopr_prost_DDL != null) ? dopr_prost_DDL._selectedValue : "";
            var km_mes = (km_mesto_TB != null) ? km_mesto_TB.value : "";
            var km_mim = (km_mimo_TB != null) ? km_mimo_TB.value : "";
            var km_kom = (km_komb_TB != null) ? km_komb_TB.value : "";
            var vzdal = (vzdalenost_TB != null) ? vzdalenost_TB.value : "";

            if (udalost_DDL == null && r != null && r != "") {
                try {
                    u = document.getElementById(prefix + row + "_udalost_HF").value;
                    m = document.getElementById(prefix + row + "_misto_Lab").innerHTML;
                    z_od = document.getElementById(prefix + row + "_zeme_od_Lab").innerHTML;
                    z_do = document.getElementById(prefix + row + "_zeme_do_Lab").innerHTML;
                } catch (e) {

                }
            }

            var prub_vals = { orig_radek: orgr, radek: r, udalost: u, datum: d, cas: c, misto: m, zeme_od: z_od, zeme_do: z_do, dopr_prost: dopr, km_mesto: km_mes, km_mimo: km_mim, km_komb: km_kom, vzdalenost: vzdal };
            return prub_vals;
        }

        function Prubeh_SetValues(row, prub_vals) {
            var prefix = "<%= LV_Prubeh.ClientID %>" + "_ctrl";
            //====== controls ======
            var orig_radek_HF = document.getElementById(prefix + row + "_orig_radek_HF");
            var radek_HF = document.getElementById(prefix + row + "_radek_HF");
            var udalost_DDL = $find(prefix + row + "_udalost_DDL");
            var datum_TB = $find(prefix + row + "_datum_TB");
            var cas_TB = document.getElementById(prefix + row + "_cas_TB");
            var misto_TB = document.getElementById(prefix + row + "_misto_TB");
            var zeme_od_DDL = $find(prefix + row + "_zeme_od_DDL");
            var zeme_do_DDL = $find(prefix + row + "_zeme_do_DDL");
            var dopr_prost_DDL = $find(prefix + row + "_dopr_prost_DDL");
            var km_mesto_TB = document.getElementById(prefix + row + "_km_mesto_TB");
            var km_mimo_TB = document.getElementById(prefix + row + "_km_mimo_TB");
            var km_komb_TB = document.getElementById(prefix + row + "_km_komb_TB");
            var vzdalenost_TB = document.getElementById(prefix + row + "_vzdalenost_TB");

            //alert(prefix + row + "_orig_radek_HF");
            if (orig_radek_HF == null) alert("orig_radek_HF == null");

            //====== seting values ======
            orig_radek_HF.value = prub_vals.orig_radek;
            radek_HF.value = prub_vals.radek;
            DDLSetValue(udalost_DDL, prub_vals.udalost);
            datum_TB.set_selectedDate(prub_vals.datum);
            cas_TB.value = prub_vals.cas;
            misto_TB.value = prub_vals.misto;
            if (zeme_do_DDL != null) {
                DDLSetValue(zeme_od_DDL, prub_vals.zeme_od);
                DDLSetValue(zeme_do_DDL, prub_vals.zeme_do);
            }
            DDLSetValue(dopr_prost_DDL, prub_vals.dopr_prost);
            if (gi_sk == 1) {
                km_mesto_TB.value = prub_vals.km_mesto;
                km_mimo_TB.value = prub_vals.km_mimo;
                km_komb_TB.value = prub_vals.km_komb;
            }
            else
                vzdalenost_TB.value = prub_vals.vzdalenost;
        }

        function Prubeh_Predvypln_Radek(prefix, row) {
            var prev_row = row - 1;
            if (row >= 0) {
                var prub_vals = Prubeh_GetValues(prev_row);

                prub_vals.zeme_od = prub_vals.zeme_do;

                if (prub_vals.udalost == "O" || prub_vals.udalost == "H") prub_vals.udalost = "P";
                else if (prub_vals.udalost == "P") prub_vals.udalost = "O";
                else if (prub_vals.udalost == "V") prub_vals.udalost = "K";
                else if (prub_vals.udalost == "R") prub_vals.udalost = "U";

                if (!(prub_vals.udalost == "O" || prub_vals.udalost == "H" || prub_vals.udalost == "P")) prub_vals.dopr_prost = "";

                orig_radek_HF = document.getElementById(prefix + row + "_orig_radek_HF");
                radek_HF = document.getElementById(prefix + row + "_radek_HF");
                prub_vals.orig_radek = orig_radek_HF.value;
                prub_vals.radek = radek_HF.value;
                prub_vals.cas = "";
                if (prub_vals.udalost != "O") prub_vals.misto = "";
                prub_vals.km_mesto = "";
                prub_vals.km_mimo = "";
                prub_vals.km_komb = "";
                prub_vals.vzdalenost = "";

                Prubeh_SetValues(row, prub_vals);
            }
        }

        function PrubehFixValuesAndCss(prefix) {
            var row = 0;
            var udalost_prev = "";
            var zeme_do_prev = "";
            var dopr_prev = "";
            var prev_color = "#F0F0F0";
            var item;

            for (row = 0; row < gi_MaxRows; row++) {
                //====== controls ======
                var udalost_DDL = $find(prefix + row + "_udalost_DDL");
                if (udalost_DDL == undefined || udalost_DDL == null) continue; //smazany nevyrendrovany radek
                var zeme_od_DDL = $find(prefix + row + "_zeme_od_DDL");
                var zeme_do_DDL = $find(prefix + row + "_zeme_do_DDL");
                var dopr_prost_DDL = $find(prefix + row + "_dopr_prost_DDL");

                //====== values ======
                var udalost = udalost_DDL._selectedValue;
                var zeme_od = (zeme_od_DDL != null) ? zeme_od_DDL._selectedValue : "";
                var zeme_do = (zeme_do_DDL != null) ? zeme_do_DDL._selectedValue : "";
                var dopr = dopr_prost_DDL._selectedValue;

                //====== fix values ======
                //DOPRAVA - pokud je udalost P nebo H, tak doprava musi byt stejna jako u radku s udalosti O
                if ((udalost == "H" || udalost == "P") && dopr != dopr_prev) {
                    dopr = dopr_prev;
                    item = dopr_prost_DDL.findItemByValue(dopr);
                    if (item == null) item = dopr_prost_DDL.get_items().getItem(0);
                    item.select();
                }
                //ZEME_DO - pokud zeme_do neni visible (visible je u hranice nebo odlet+letadlo), tak musi mit stejnou hodnotu jako zeme_od
                if (zeme_od_DDL != null) {
                    if ((!(udalost == "H" || (udalost == "O" && gas_dopr_letOrPlav.indexOf(dopr) >= 0))) && zeme_do != zeme_od) {
                        zeme_do = zeme_od;
                        item = zeme_do_DDL.findItemByValue(zeme_do);
                        if (item == null) item = zeme_do_DDL.get_items().getItem(0);
                        item.select();
                    }
                }
                if (!(udalost == "O" || udalost == "H" || udalost == "P")) {
                    var misto_TB = document.getElementById(prefix + row + "_misto_TB");
                    misto_TB.value = "";
                    if (zeme_od_DDL != null) {
                        item = zeme_od_DDL.get_items().getItem(0);
                        item.select();
                    }
                    if (zeme_do_DDL != null) {
                        item = zeme_do_DDL.get_items().getItem(0);
                        item.select();
                    }
                    item = dopr_prost_DDL.get_items().getItem(0);
                    item.select();
                }
                //PR 18.10.2018 do km dali MHD a zmenili P na O, hodnota zustala
                if (!(udalost == "H" || udalost == "P")) {
                    if (gi_sk == 1) {
                        var km_mesto_TB = document.getElementById(prefix + row + "_km_mesto_TB");
                        km_mesto_TB.value = "";
                        var km_mimo_TB = document.getElementById(prefix + row + "_km_mimo_TB");
                        km_mimo_TB.value = "";
                        var km_komb_TB = document.getElementById(prefix + row + "_km_komb_TB");
                        km_komb_TB.value = "";
                    }
                    else {
                        var vzdalenost_TB = document.getElementById(prefix + row + "_vzdalenost_TB");
                        vzdalenost_TB.value = "";
                    }
                }

                //====== fix CSS ======
                var tr = document.getElementById(prefix + row + "_ItemRow"); //$find(prefix + row + "_ItemRow");
                if (udalost == "O" || udalost == "V" || udalost == "R") {
                    if (prev_color == "#F0F0F0")
                        prev_color = "#FFFFFF";
                    else
                        prev_color = "#F0F0F0";
                }
                tr.bgColor = prev_color;

                //misto
                AddRemoveCssClass("#" + prefix + row + "_" + "misto_TB", "hidden", !(udalost == "O" || udalost == "H" || udalost == "P"));
                //zeme z - do
                if (gi_ZPC == 1) {
                    AddRemoveCssClass("#" + prefix + row + "_" + "zeme_od_DDL", "hidden", !(udalost == "O" || udalost == "H" || udalost == "P"));
                    AddRemoveCssClass("#" + prefix + row + "_" + "zeme_sipka_Lab", "hidden", !(udalost == "H" || (udalost == "O" && gas_dopr_letOrPlav.indexOf(dopr) >= 0)));
                    AddRemoveCssClass("#" + prefix + row + "_" + "zeme_do_DDL", "hidden", !(udalost == "H" || (udalost == "O" && gas_dopr_letOrPlav.indexOf(dopr) >= 0)));
                }
                //doprav. prostredek
                AddRemoveCssClass("#" + prefix + row + "_" + "dopr_prost_DDL", "hidden", !(udalost == "O"));
                //ujete km - viditelnost      
                if (gi_sk == 0)
                    AddRemoveCssClass("#" + prefix + row + "_" + "vzdalenost_TB", "hidden", !(gi_sk == 0 && (udalost == "H" || udalost == "P")));
                if (gi_sk == 1) {
                    AddRemoveCssClass("#" + prefix + row + "_" + "km_mesto_TB", "hidden", !(gi_sk == 1 && (udalost == "H" || udalost == "P")));
                    AddRemoveCssClass("#" + prefix + row + "_" + "km_mimo_TB", "hidden", !(gi_sk == 1 && (udalost == "H" || udalost == "P")));
                    AddRemoveCssClass("#" + prefix + row + "_" + "km_komb_TB", "hidden", !(gi_sk == 1 && (udalost == "H" || udalost == "P")));
                }

                //ujete km - povinnost 
                if (udalost == "H" || udalost == "P") {
                    var spolucestujiciAno = <%= SpolucestujiciAno ? "true" : "false" %>;
                    var hlavniOsoba = <%= HlavniOsoba() ? "true" : "false" %>;
                    var ESG_SC = <%= KSProgram.Globals.RAActive("ESG_SC") ? "true" : "false" %>;
                    var kmPov = (gas_dopr_kmPov.indexOf(dopr_prev) >= 0);
                    var kmReadOnly = false;
                    if (ESG_SC == true) {
                        if (spolucestujiciAno) {
                            if (hlavniOsoba == false) {
                                kmPov = false;
                                kmReadOnly = true;
                            }
                        }
                    }

                    console.info("row=" + row);
                    console.info("spolucestujiciAno=" + spolucestujiciAno);
                    console.info("hlavniOsoba=" + hlavniOsoba);
                    console.info("ESG_SC=" + ESG_SC);
                    console.info("dopr_prev=" + dopr_prev);
                    console.info("kmPov=" + kmPov);
                    console.info("kmReadOnly=" + kmReadOnly);

                    if (gi_sk == 0) {
                        AddRemoveCssClass("#" + prefix + row + "_vzdalenost_TB", "povinne-pole", kmPov);
                        if (ESG_SC == true) setReadOnly("#" + prefix + row + "_vzdalenost_TB", kmReadOnly);
                    }
                    else if (gi_sk == 1) {
                        AddRemoveCssClass("#" + prefix + row + "_km_mesto_TB", "povinne-pole", kmPov);
                        AddRemoveCssClass("#" + prefix + row + "_km_mimo_TB", "povinne-pole", kmPov);
                        AddRemoveCssClass("#" + prefix + row + "_km_komb_TB", "povinne-pole", kmPov);
                        if (ESG_SC == true) {
                            setReadOnly("#" + prefix + row + "_km_mesto_TB", kmReadOnly);
                            setReadOnly("#" + prefix + row + "_km_mimo_TB", kmReadOnly);
                            setReadOnly("#" + prefix + row + "_km_komb_TB", kmReadOnly);
                        }
                    }
                }

                udalost_prev = udalost;
                if (udalost == "O" || udalost == "H" || udalost == "P") {
                    zeme_do_prev = zeme_do;
                    dopr_prev = dopr;
                }
            }
        }

        function setReadOnly(selector, nastav) {
            $(selector).attr("readonly", nastav);
            AddRemoveCssClass(selector, "read-only", nastav);
            if (nastav) $(selector).val("");
        }


        function OnUdalostChanged(sender, eventArgs) {
            var udalost = sender._selectedValue;
            var SenderId = sender.get_element().id;

            var res = parseSenderId(SenderId);
            var row = res.row;
            var prefix = res.prefix;
            var SenderServerId = res.senderServerId;

            PrubehFixValuesAndCss(prefix);
        }

        function OnZemeOdDDLChanged(sender, eventArgs) {
            var zeme_od_DDL = sender;
            var SenderId = sender.get_element().id;

            var res = parseSenderId(SenderId);
            var row = res.row;
            var prefix = res.prefix;

            var udalost_DDL = $find(prefix + row + "_udalost_DDL");
            var dopr_prost_DDL = $find(prefix + row + "_dopr_prost_DDL");
            var udalost = udalost_DDL._selectedValue;
            var dopr = dopr_prost_DDL._selectedValue;

            var zeme_do_DDL = $find(SenderId.replace("zeme_od_DDL", "zeme_do_DDL"));
            var zeme_do_visible = zeme_do_DDL.get_element().getAttribute("class").indexOf("hidden") < 0 || udalost == "H" || (gi_ZPC == 1 && udalost == "O" && gas_dopr_letOrPlav.indexOf(dopr) >= 0);

            if (gi_ZPC == 0 || zeme_do_visible == false) {
                var item = zeme_do_DDL.findItemByValue(zeme_od_DDL._selectedValue);
                if (item == null) item = zeme_do_DDL.get_items().getItem(0);
                item.select();
            }
        }

        function OnDoprProstChanged(sender, eventArgs) {
            var doprava = sender._selectedValue;
            var SenderId = sender.get_element().id;

            var res = parseSenderId(SenderId);
            var startRow = res.row;
            var prefix = res.prefix;
            var SenderServerId = res.senderServerId;

            PrubehFixValuesAndCss(prefix);
        }

        function SetPovinneRadDatePicker(dp, ano) {
            var di = dp.get_dateInput();

            if (ano == true) {
                di.get_styles().EnabledStyle[0] += "background-color: #ffffcc;";
                di.get_styles().HoveredStyle[0] += "background-color: #ffffcc;";
                di.get_styles().FocusedStyle[0] += "background-color: #ffffcc;";
            }
            else {
                di.get_styles().EnabledStyle[0] += "background-color: white;";
                di.get_styles().HoveredStyle[0] += "background-color: white;";
                di.get_styles().FocusedStyle[0] += "background-color: white;";
            }
            di.updateCssClass();
        }


        function OnRadUploadClientValidationFailed(sender, args) {
            var fileExtention = args.get_fileName().substring(args.get_fileName().lastIndexOf('.') + 1, args.get_fileName().length);
            if (args.get_fileName().lastIndexOf('.') != -1) {//this checks if the extension is correct
                if ((',' + sender.get_allowedFileExtensions() + ',').indexOf(',' + fileExtention.toLowerCase() + ',') == -1) {
                    jAlert("Nepovolená přípona souboru, povoleny jsou " + sender.get_allowedFileExtensions() + "!");
                }
                else {
                    jAlert("Příliš velký soubor, max. velikost souboru je " + <%= KSProgram.Parametry.PovinnyParametrCti<int>("PřílohyMaxVelikost") %> + " MB!");
                }
            }
            else {
                jAlert("Nepovolená přípona souboru, povoleny jsou " + sender.get_allowedFileExtensions() + "!");
            }
        }

        function calendarOpening(sender, eventArgs) {
            if (sender.isEmpty()) {
                eventArgs.set_cancelCalendarSynchronization(true);

                var popup = eventArgs.get_popupControl();

                if (popup.get_selectedDates().length == 0) {
                    var rok = <%= Dat_od.HasValue ? Dat_od.Value.Year : DateTime.Today.Year %>;
                    var mesic = <%= Dat_od.HasValue ? Dat_od.Value.Month : DateTime.Today.Month %>;
                    var den = <%= Dat_od.HasValue ? Dat_od.Value.Day : DateTime.Today.Day %>;
                    var DayTriplet = [rok, mesic, den];
                    //popup.selectDate(DayTriplet, true);
                    popup.navigateToDate(DayTriplet);
                }
            }
        }

        //function OnClientFileUploaded(sender, args) {
        //    alert(args.get_fileName());
        //}

        function confirmNoScan(args) {
            var HF_confirmNoScan = document.getElementById("HF_confirmNoScan");
            if (args) {
                HF_confirmNoScan.value = "1";
                var button = document.getElementsByClassName("tlacitko_Vdj_UpdateBtn");
                if (button != null)
                    if (button.length == 1)
                        button[0].click(true);
            }
            else
                HF_confirmNoScan.value = "0";
        }
    //]]>
    </script>
</telerik:RadScriptBlock>

<%--<telerik:RadCalendar runat="server" ID="SharedCalendarCP"></telerik:RadCalendar>--%>


<%--<telerik:RadFormDecorator ID="RFD_cp" runat="server" DecoratedControls="All" DecorationZoneID="cp_table" EnableRoundedCorners="False" />--%>
<table id="cp_table" class="widthA4" style="height: auto; background-color:transparent" cellspacing="0">
    <%--<tr>
      <td style="text-align: center">       
      <wc:TLabel ID="Label_CP" runat="server" style="font-size: x-large" 
          Text="[%Cestovní příkaz%]" CssClass="tiskShow"  />        
      </td>
  </tr>--%>
    <tr>
        <td>

            <asp:HiddenField ID="HF_confirmNoScan" ClientIDMode="Static" runat="server" EnableViewState="True" Value="0"  />
            <asp:HiddenField ID="HF_VyplnHlavDle" runat="server" EnableViewState="True" Value="0" />
            <asp:HiddenField ID="HF_tabulka" runat="server" EnableViewState="True" Value="sluz_cesty" />
            <asp:HiddenField ID="HF_EvCislo" runat="server" EnableViewState="True" Value="0" />
            <asp:HiddenField ID="HF_PozId" runat="server" EnableViewState="True" Value="0" />
            <asp:HiddenField ID="HF_CpOsc" runat="server" EnableViewState="True" Value="0" />
            <asp:ObjectDataSource ID="ODS_SlcHlavicka" runat="server"
                OldValuesParameterFormatString="original_{0}"
                TypeName="KSProgram.Sluzebky.SlcHlavicka"
                SelectMethod="Select"
                InsertMethod="Insert"
                UpdateMethod="UpdateFull"
                OnInserting="ODS_SlcHlavicka_Inserting"
                OnInserted="ODS_SlcHlavicka_Inserted"
                OnUpdated="ODS_SlcHlavicka_Updated">
                <SelectParameters>
                    <asp:ControlParameter Name="tabulka" Type="String" DefaultValue="sluz_cesty" ControlID="HF_tabulka" PropertyName="Value" />
                    <asp:ControlParameter Name="ev_cislo" Type="Int32" DefaultValue="0" ControlID="HF_EvCislo" PropertyName="Value" />
                </SelectParameters>
                <InsertParameters>
                    <asp:ControlParameter Name="tabulka" Type="String" DefaultValue="sluz_cesty" ControlID="HF_tabulka" PropertyName="Value" />
                    <asp:Parameter Name="ev_cislo" Type="Int32" Direction="Output" DefaultValue="0" />
                    <asp:Parameter Name="par_ev_cislo" Type="Int32" />
                    <asp:Parameter Name="os_cislo" Type="Decimal" />
                    <asp:Parameter Name="zdroj" Type="String" DefaultValue="S" />
                    <asp:Parameter Name="typ" Type="String" />
                    <asp:Parameter Name="poc_misto" Type="String" />
                    <asp:Parameter Name="dat_od" Type="DateTime" />
                    <asp:Parameter Name="cas_od" Type="String" />
                    <asp:Parameter Name="kon_misto" Type="String" />
                    <asp:Parameter Name="dat_do" Type="DateTime" />
                    <asp:Parameter Name="cas_do" Type="String" />
                    <asp:Parameter Name="cil" Type="String" />
                    <asp:Parameter Name="cil_zeme" Type="String" />
                    <asp:Parameter Name="ucel" Type="String" />
                    <asp:Parameter Name="spolucestujici" Type="String" />
                    <asp:Parameter Name="spolu1" Type="Decimal" />
                    <asp:Parameter Name="spolu2" Type="Decimal" />
                    <asp:Parameter Name="spolu3" Type="Decimal" />
                    <asp:Parameter Name="spolu4" Type="Decimal" />
                    <asp:Parameter Name="spolu5" Type="Decimal" />
                    <asp:Parameter Name="spolu6" Type="Decimal" />
                    <asp:Parameter Name="spolu7" Type="Decimal" />
                    <asp:Parameter Name="spolu8" Type="Decimal" />
                    <asp:Parameter Name="spolu9" Type="Decimal" />
                    <asp:Parameter Name="spolu10" Type="Decimal" />
                    <asp:Parameter Name="druh_dopr" Type="String" />
                    <asp:Parameter Name="spz" Type="String" />
                    <%--<asp:Parameter Name="spz_sluz" Type="String" />
          <asp:Parameter Name="spz_vlast" Type="String" />--%>
                    <%--<asp:Parameter Name="sazba_zn" Type="Decimal" />--%>
                    <asp:Parameter Name="pohonna_hmota" Type="String" />
                    <%--<asp:Parameter Name="cena_1l_ph" Type="Decimal" />--%>
                    <asp:Parameter Name="prum_spotreba" Type="Decimal" />
                    <asp:Parameter Name="spotreba_mesto" Type="Decimal" />
                    <asp:Parameter Name="spotreba_mimo" Type="Decimal" />
                    <asp:Parameter Name="cislo_poj" Type="String" />
                    <asp:Parameter Name="souhl_dne" Type="DateTime" />
                    <asp:Parameter Name="povolil_dne" Type="DateTime" />
                    <asp:Parameter Name="povolil_osc" Type="Decimal" />
                    <asp:Parameter Name="pzn" Type="String" />
                    <asp:Parameter Name="kapes_proc" Type="Int32" />
                    <asp:Parameter Name="kapes_t_proc" Type="Int32" />
                    <asp:Parameter Name="druh" Type="String" />
                    <asp:Parameter Name="predp_nakl" Type="Decimal" />
                    <asp:Parameter Name="predp_nakl_mena" Type="String" />
                    <asp:Parameter Name="id_proj" Type="Int32" />
                    <asp:Parameter Name="cislo_pom" Type="Int16" />
                    <asp:Parameter Name="platne_poj" Type="Boolean" DefaultValue="" />
                    <asp:Parameter Name="let" Type="Boolean" DefaultValue="" />
                    <asp:Parameter Name="let_o" Type="DateTime" DefaultValue="" /> 
                    <asp:Parameter Name="let_p" Type="DateTime" DefaultValue="" /> 
                    <asp:Parameter Name="let_oti" Type="String" DefaultValue="" /> 
                    <asp:Parameter Name="let_pti" Type="String" DefaultValue="" /> 
                    <asp:Parameter Name="ubyt" Type="Boolean" DefaultValue="" /> 
                    <asp:Parameter Name="aut_puj" Type="Boolean" DefaultValue="" /> 
                    <asp:Parameter Name="mdata" Type="Boolean" DefaultValue="" /> 
                    <asp:Parameter Name="vizum" Type="Boolean" DefaultValue="" /> 
                    <asp:Parameter Name="ost" Type="String" DefaultValue="" />
                </InsertParameters>
                <UpdateParameters>
                    <asp:ControlParameter Name="tabulka" Type="String" DefaultValue="sluz_cesty" ControlID="HF_tabulka" PropertyName="Value" />
                    <asp:Parameter Name="original_ev_cislo" Type="Int32" />
                    <asp:Parameter Name="ev_cislo" Type="Int32" />
                    <asp:Parameter Name="par_ev_cislo" Type="Int32" />
                    <asp:Parameter Name="os_cislo" Type="Decimal" />
                    <asp:Parameter Name="typ" Type="String" />
                    <asp:Parameter Name="poc_misto" Type="String" />
                    <asp:Parameter Name="dat_od" Type="DateTime" />
                    <asp:Parameter Name="cas_od" Type="String" />
                    <asp:Parameter Name="kon_misto" Type="String" />
                    <asp:Parameter Name="dat_do" Type="DateTime" />
                    <asp:Parameter Name="cas_do" Type="String" />
                    <asp:Parameter Name="cil" Type="String" />
                    <asp:Parameter Name="cil_zeme" Type="String" />
                    <asp:Parameter Name="ucel" Type="String" />
                    <asp:Parameter Name="spolucestujici" Type="String" />
                    <asp:Parameter Name="spolu1" Type="Decimal" />
                    <asp:Parameter Name="spolu2" Type="Decimal" />
                    <asp:Parameter Name="spolu3" Type="Decimal" />
                    <asp:Parameter Name="spolu4" Type="Decimal" />
                    <asp:Parameter Name="spolu5" Type="Decimal" />
                    <asp:Parameter Name="spolu6" Type="Decimal" />
                    <asp:Parameter Name="spolu7" Type="Decimal" />
                    <asp:Parameter Name="spolu8" Type="Decimal" />
                    <asp:Parameter Name="spolu9" Type="Decimal" />
                    <asp:Parameter Name="spolu10" Type="Decimal" />
                    <asp:Parameter Name="druh_dopr" Type="String" />
                    <asp:Parameter Name="spz" Type="String" />
                    <%--<asp:Parameter Name="spz_sluz" Type="String" />
          <asp:Parameter Name="spz_vlast" Type="String" />--%>
                    <%--<asp:Parameter Name="sazba_zn" Type="Decimal" />--%>
                    <asp:Parameter Name="pohonna_hmota" Type="String" />
                    <%--<asp:Parameter Name="cena_1l_ph" Type="Decimal" />--%>
                    <asp:Parameter Name="prum_spotreba" Type="Decimal" />
                    <asp:Parameter Name="spotreba_mesto" Type="Decimal" />
                    <asp:Parameter Name="spotreba_mimo" Type="Decimal" />
                    <asp:Parameter Name="cislo_poj" Type="String" />
                    <asp:Parameter Name="pzn" Type="String" />
                    <asp:Parameter Name="kapes_proc" Type="Int32" />
                    <asp:Parameter Name="kapes_t_proc" Type="Int32" />
                    <asp:Parameter Name="druh" Type="String" />
                    <asp:Parameter Name="predp_nakl" Type="Decimal" />
                    <asp:Parameter Name="predp_nakl_mena" Type="String" />
                    <asp:Parameter Name="id_proj" Type="Int32" />
                    <asp:Parameter Name="platne_poj" Type="Boolean" DefaultValue="" />
                    <asp:Parameter Name="let" Type="Boolean" DefaultValue="" />
                    <asp:Parameter Name="let_o" Type="DateTime" DefaultValue="" /> 
                    <asp:Parameter Name="let_p" Type="DateTime" DefaultValue="" /> 
                    <asp:Parameter Name="let_oti" Type="String" DefaultValue="" /> 
                    <asp:Parameter Name="let_pti" Type="String" DefaultValue="" /> 
                    <asp:Parameter Name="ubyt" Type="Boolean" DefaultValue="" /> 
                    <asp:Parameter Name="aut_puj" Type="Boolean" DefaultValue="" /> 
                    <asp:Parameter Name="mdata" Type="Boolean" DefaultValue="" /> 
                    <asp:Parameter Name="vizum" Type="Boolean" DefaultValue="" /> 
                    <asp:Parameter Name="ost" Type="String" DefaultValue="" />
                </UpdateParameters>
                <%--<DeleteParameters>
          <asp:Parameter Name="original_ev_cislo" Type="Int32" />
       </DeleteParameters>--%>
            </asp:ObjectDataSource>

            <wc:TObjectDataSource runat="server" ID="ds_pomery" 
                OldValuesParameterFormatString="original_{0}" SelectMethod="GetPomery" 
                TypeName="KSProgram.Funkce.Prac_pom" EnableCaching="True" CacheDuration="600" CacheExpirationPolicy="Sliding">
                <SelectParameters>
                    <asp:Parameter Name="co" Type="String" DefaultValue="o" />
                    <asp:Parameter DefaultValue="0" Name="os_cislo" Type="Decimal" />
                </SelectParameters>
            </wc:TObjectDataSource>

            <wc:TObjectDataSource ID="ODS_PHM" runat="server"
                OldValuesParameterFormatString="original_{0}" SelectMethod="Select"
                TypeName="KSProgram.Sluzebky.SlcCisPhm" EnableCaching="True" CacheDuration="600" CacheExpirationPolicy="Sliding">                
            </wc:TObjectDataSource>
            <wc:TObjectDataSource ID="ODS_druhDopr" runat="server"
                OldValuesParameterFormatString="original_{0}" SelectMethod="Select"
                TypeName="KSProgram.Sluzebky.SlcCisDruhDopr" EnableCaching="True" CacheDuration="600">
                <%--//PR 30.08.2024 caching prodloužen a přidán parametr CultureName, protože by nefungoval uživatelský překlad dat
                    //PR 11.10.2024 CultureName zabudováno do kešování v TObjectDataSource
                --%>
                <%--<SelectParameters>
                    <asp:SessionParameter Name="CultureName" SessionField="CultureName" Type="String" />
                </SelectParameters>--%>
            </wc:TObjectDataSource>
            <%--Pro promazání cache bych mohl mohl nastavit ChacheKeyDependency="SluzebniCesty.Ciselniky" Page_Load:Cache["SluzebniCesty.Ciselniky"]="1" 
        Místo selectparametru bych mohl pouzit FilterExpression a Filterparameters
            --%>
            <%--PR 29.9.2015 sníšil jsem cache-ování z 600 s na 60 s--%>
            <%--<asp:ObjectDataSource ID="ODS_spzSluz" runat="server" 
        OldValuesParameterFormatString="original_{0}" SelectMethod="SelectSluzebni" 
        TypeName="KSProgram.Sluzebky.SlcVozidla" EnableCaching="True" CacheExpirationPolicy="Sliding" CacheDuration="60">
        <SelectParameters>
            //asp:ControlParameter Name="os_cislo" Type="Decimal" ControlID="CP" PropertyName="OsCislo" 
            <asp:ControlParameter Name="os_cislo" Type="Decimal" ControlID="HF_CpOsc" PropertyName="Value" />  //PR 24.10.2017
            <asp:ControlParameter Name="druhy" Type="String" ControlID="CP" PropertyName="Druh_dopr" />  //PR 30.10.2018
        </SelectParameters>
    </asp:ObjectDataSource>--%>
            <%--//PR 20.02.2019 HID=43778 omezeno na dostupná vozidla --%>
            <%--<asp:ObjectDataSource ID="ODS_spzSluz" runat="server" 
        OldValuesParameterFormatString="original_{0}" SelectMethod="SelectSluzebniDostupna" 
        TypeName="KSProgram.Sluzebky.SlcVozidla" EnableCaching="True" CacheExpirationPolicy="Sliding" CacheDuration="60" >
        <SelectParameters>
            <asp:ControlParameter Name="os_cislo" Type="Decimal" ControlID="HF_CpOsc" PropertyName="Value" /> 
            <asp:ControlParameter Name="ev_cislo" Type="Int32" ControlID="HF_EvCislo" PropertyName="Value" /> 
            <asp:ControlParameter Name="druhy" Type="String" ControlID="CP" PropertyName="Druh_dopr" />  
            <asp:ControlParameter Name="dat_od" Type="DateTime" ControlID="CP" PropertyName="Dat_od" />
            <asp:ControlParameter Name="cas_od" Type="String" ControlID="CP" PropertyName="Cas_od" />
            <asp:ControlParameter Name="dat_do" Type="DateTime" ControlID="CP" PropertyName="Dat_do" />
            <asp:ControlParameter Name="cas_do" Type="String" ControlID="CP" PropertyName="Cas_do" />
        </SelectParameters>
    </asp:ObjectDataSource>--%>
            <%--PR 29.9.2015 zrušil jsem cache-ování kvůli SlcVuzImport--%>
            <%--<asp:ObjectDataSource ID="ODS_spzVlast" runat="server" 
        OldValuesParameterFormatString="original_{0}" SelectMethod="SelectVlastni" 
        TypeName="KSProgram.Sluzebky.SlcVozidla" EnableCaching="False">
        <SelectParameters>
            <asp:Parameter Name="os_cisla" Type="String" DefaultValue="-1" />
            <asp:ControlParameter Name="druhy" Type="String" ControlID="CP" PropertyName="Druh_dopr" />  //PR 30.10.2018 
        </SelectParameters>
    </asp:ObjectDataSource>--%>
            <%--//PR 15.05.2019 HID=44981 --%>
            <wc:TObjectDataSource ID="ODS_spz" runat="server"
                OldValuesParameterFormatString="original_{0}" SelectMethod="Select"
                TypeName="KSProgram.Sluzebky.SlcVozidla" EnableCaching="True" CacheExpirationPolicy="Sliding" CacheDuration="120">
                <SelectParameters>
                    <asp:Parameter Name="os_cisla" Type="String" DefaultValue="-1" />
                    <asp:ControlParameter Name="ev_cislo" Type="Int32" ControlID="HF_EvCislo" PropertyName="Value" />
                    <asp:ControlParameter Name="druhy" Type="String" ControlID="CP" PropertyName="Druh_dopr" />
                    <%--<asp:Parameter Name="jen_dostupna" Type="Boolean" DefaultValue="true" />--%>
                    <asp:ControlParameter Name="jen_dostupna" Type="Boolean" ControlID="CP" PropertyName="jen_dostupne_vozy" />
                    <asp:ControlParameter Name="dat_od" Type="DateTime" ControlID="CP" PropertyName="Dat_od" />
                    <asp:ControlParameter Name="cas_od" Type="String" ControlID="CP" PropertyName="Cas_od" />
                    <asp:ControlParameter Name="dat_do" Type="DateTime" ControlID="CP" PropertyName="Dat_do" />
                    <asp:ControlParameter Name="cas_do" Type="String" ControlID="CP" PropertyName="Cas_do" />
                </SelectParameters>
            </wc:TObjectDataSource>

            <wc:TObjectDataSource ID="ODS_kapes_t_proc" runat="server"
                OldValuesParameterFormatString="original_{0}" SelectMethod="of_getKapesneTuzSeznam"
                TypeName="KSProgram.Sluzebky.SlcFunkce" EnableCaching="True" CacheExpirationPolicy="Sliding" CacheDuration="6000"></wc:TObjectDataSource>
            <wc:TObjectDataSource ID="ODS_kapes_proc" runat="server"
                OldValuesParameterFormatString="original_{0}" SelectMethod="of_getKapesneZahrSeznam"
                TypeName="KSProgram.Sluzebky.SlcFunkce" EnableCaching="True" CacheExpirationPolicy="Sliding" CacheDuration="6000"></wc:TObjectDataSource>

            <wc:TObjectDataSource runat="server" ID="ODS_vychoziMisto" TypeName="KSProgram.Sluzebky.SlcHlavicka" SelectMethod="VychoziMistaOdjezdu" 
                EnableCaching="True" CacheExpirationPolicy="Sliding" CacheDuration="120">
                <SelectParameters>
                    <asp:ControlParameter Name="os_cislo" Type="Decimal" ControlID="HF_CpOsc" PropertyName="Value" />
                    <asp:Parameter Name="vratPrvni" Type="Boolean" DefaultValue="false" />
                </SelectParameters>
            </wc:TObjectDataSource>

            <asp:FormView ID="FV_SlcHlavicka" runat="server" DataSourceID="ODS_SlcHlavicka"
                DataKeyNames="ev_cislo" EmptyDataText="[%Není vybrán žádný záznam%]"
                GridLines="Horizontal"
                OnDataBinding="FV_SlcHlavicka_DataBinding"
                OnDataBound="FV_SlcHlavicka_DataBound"
                OnModeChanged="FV_SlcHlavicka_ModeChanged"
                OnModeChanging="FV_SlcHlavicka_ModeChanging"
                OnItemInserting="FV_SlcHlavicka_ItemInserting"
                OnItemUpdating="FV_SlcHlavicka_ItemUpdating"
                OnItemCommand="FV_SlcHlavicka_ItemCommand"
                OnInit="FV_SlcHlavicka_Init"
                CellPadding="0" CssClass="widthA4 border1px" BackColor="White">
                <EmptyDataTemplate>
                    <%--<wc:TRadButton ID="Hl_NewButton2" runat="server" CausesValidation="False" 
                    CommandName="Novy" Text="[%Nový%]" IdPrava="148" Visible='<%# ShowNewButton %>'/>--%>
                </EmptyDataTemplate>
                <HeaderStyle CssClass="theme_header CP_header border1px" />
                <HeaderTemplate>
                    <div class="styled-header">
                        <div class="header-logo">
                            <asp:Image ID="Logo" runat="server" ImageUrl='<%# KSProgram.Zakaznik.GetLogoUrl(true) %>' CssClass="CP_Logo" />
                        </div>
                        <div class="header-title">
                            <wc:TLabel ID="Lab_prubeh" runat="server" Text="[%CESTOVNÍ PŘÍKAZ%]" />
                        </div>
                    </div>
                </HeaderTemplate>
                <%--ForeColor="White" CssClass="BackColor" Font-Bold="True"--%>
                <RowStyle CssClass="border1px" />
                <ItemTemplate>
                    <table class="celpad4" style="margin: 0px; width: 100%; border-collapse: collapse; empty-cells: hide">
                        <tr>
                            <td style="text-align: left; width: 12%;">
                                <asp:HiddenField ID="par_ev_cislo_HF" runat="server" Value='<%# Bind("par_ev_cislo") %>' />
                                <asp:HiddenField ID="os_cislo_HF" runat="server" Value='<%# Bind("os_cislo") %>' />
                                <asp:HiddenField ID="HF_CisloPom" runat="server" Value='<%# Eval("cislo_pom") %>' />
                                <wc:TLabel ID="zamestnanec_t_Lab" runat="server" Text="[%Zaměstnanec%]:" Font-Bold="True" />
                            </td>
                            <td>
                                <wc:TLabel ID="zamestnanec_Lab" runat="server" Text='<%# Eval("zamestnanec") %>' Font-Bold="True" />
                            </td>
                            <td>
                                <wc:TLabel ID="bu_t_Lab" runat="server" Text="[%BÚ%]:" />
                                <wc:TLabel ID="bu_Lab" runat="server" Text='<%# Eval("bu") %>' />
                            </td>
                            <td style="width: 13%">
                                <wc:TLabel ID="ev_cislo_t_Lab" runat="server" Text="[%Číslo SC%]:" Font-Bold="True" /></td>
                            <td>
                                <wc:TLabel ID="ev_cislo_Lab" runat="server" Text='<%# Eval("cislo") %>' /></td>
                        </tr>
                        <tr>
                            <td style="width: 12%; text-align: left">
                                <wc:TLabel ID="bydliste_t_Lab" runat="server" Text="[%Bydliště%]:"  />
                            </td>
                            <td colspan="2">
                                <wc:TLabel ID="bydliste_Lab" runat="server" Text='<%# Eval("bydliste") %>' />
                            </td>
                            <td style="width: 13%">
                                <wc:TLabel ID="typ_t_Lab" runat="server" Text="[%Typ prac. cesty%]:" /></td>
                            <td>
                                <wc:TLabel ID="typ_Lab" runat="server" Text='<%# Eval("typ_vyznam") %>' /></td>
                        </tr>
                        <tr>
                            <td style="width: 12%; text-align: left">
                                <wc:TLabel ID="kmen_str_nazev_t_Lab" runat="server" Text="[%Kmen. středisko%]:"  />
                            </td>
                            <td colspan="2">
                                <wc:TLabel ID="kmen_str_nazev_Lab" runat="server" Text='<%# Eval("kmen_str_nazev") %>' />
                            </td>
                            <td style="width: 13%">
                                <wc:TLabel ID="TLabel19" runat="server" Text="[%Druh nákladu%]:" Visible='<%# _DruhNaklVisible %>' /></td>
                            <td>
                                <wc:TLabel ID="TLabel20" runat="server" Text='<%# Eval("druh_display") %>' Visible='<%# _DruhNaklVisible %>' />
                                <asp:HiddenField ID="druh_HF" runat="server" Value='<%# Bind("druh") %>' />
                            </td>
                        </tr>
                        <asp:TableRow runat="server" ID="row_pomer" Visible='<%# !DBNull.Value.Equals(Eval("cislo_pom")) %>'>
                            <asp:TableCell runat="server" ID="TableCell5" >
                                <asp:Label ID="Label12" runat="server"  Text="[%Číslo poměru%]:"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell ColumnSpan="4" runat="server"  ID="TableCell6">  
                                <wc:TLabel ID="TLabel25" runat="server" Text='<%# Eval("cislo_pom") %>' />
                            </asp:TableCell>
                        </asp:TableRow>
                        <tr runat="server" id="tr_projekt" visible='<%# _HlProjektVisible %>'>
                            <td style="width: 12%; text-align: left">
                                <wc:TLabel ID="TLabel11" runat="server" Text="[%Projekt%]:" />
                            </td>
                            <td colspan="2">
                                <wc:TLabel ID="TLabel23" runat="server" Text='<%# Eval("id_proj_display") %>' />
                            </td>
                            <td style="width: 13%"></td>
                            <td></td>
                        </tr>
                    </table>
                    <table class="celpad4" style="margin: 0px; width: 100%; border-collapse: collapse;">
                        <tr>
                            <td style="width: 30%; text-align: center;" class="border1pxR border1pxT">
                                <wc:TLabel ID="pocatek_cesty_t_Lab" runat="server" Text="[%Počátek cesty%]:"  Font-Bold="True" />
                            </td>
                            <td style="width: 40%; text-align: center;" class="border1pxR border1pxT">
                                <wc:TLabel ID="cil_t_Lab" runat="server" Text="[%Místo jednání, účel cesty%]:"  Font-Bold="True" />
                            </td>
                            <td style="width: 30%; text-align: center;" class="border1pxT">
                                <wc:TLabel ID="konec_cesty_t_Lab" runat="server" Text="[%Konec cesty%]:"  Font-Bold="True" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 30%; text-align: center;" class="border1pxR border1pxB">
                                <wc:TLabel ID="poc_misto_Lab" runat="server" Text='<%# Bind("poc_misto") %>' />
                                <br />
                                <wc:TLabel ID="dat_od_Lab" runat="server" Text='<%# Eval("dat_od", "{0:d.M.yyyy}") %>' />
                                <wc:TLabel ID="cas_od_Lab" runat="server" Text='<%# Bind("cas_od") %>' />
                            </td>
                            <td style="width: 40%; text-align: center;" class="border1pxR border1pxB">
                                <wc:TLabel ID="cil_Lab" runat="server" Text='<%# Bind("cil") %>' />
                                <br />
                                <wc:TLabel ID="cil_zeme_Lab" runat="server" Text='<%# Bind("cil_zeme") %>' Visible="false" />
                                <wc:TLabel ID="cil_zeme_display_Lab" runat="server" Text='<%# Bind("cil_zeme_display") %>' Visible='<%# KSProgram.Zakaznik.HasModul(KSProgram.AppModul.SluzebniCesty) %>' />
                                <br />
                                <wc:TLabel ID="ucel_Lab" runat="server" Text='<%# Bind("ucel") %>' />
                            </td>
                            <td style="width: 30%; text-align: center;" class="border1pxB">
                                <wc:TLabel ID="kon_misto_Lab" runat="server" Text='<%# Bind("kon_misto") %>' />
                                <br />
                                <wc:TLabel ID="dat_do_Lab" runat="server" Text='<%# Eval("dat_do", "{0:d.M.yyyy}") %>' />
                                <wc:TLabel ID="cas_do_Lab" runat="server" Text='<%# Bind("cas_do") %>' />
                            </td>
                        </tr>
                    </table>
                    <table class="celpad4" style="margin: 0px; width: 100%; border-collapse: collapse;">
                        <tr>
                            <td style="text-align: left; width: 105px">
                                <wc:TLabel ID="spolucestujici_t_Lab" runat="server" Text="[%Spolucestující%]:"  /></td>
                            <td colspan="6">
                                <wc:TLabel ID="spolucestujici_Lab" runat="server" Text='<%# Bind("spolucestujici") %>' />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2" style="text-align: left;">
                                <wc:TLabel ID="druh_dopr_t_Lab" runat="server" Text="[%Určený dopravní prostředek%]:"  />
                            </td>
                            <td colspan="5">
                                <asp:HiddenField ID="druh_dopr_HF" runat="server" Value='<%# Eval("druh_dopr") %>' />
                                <wc:TLabel ID="druh_dopr_Lab" runat="server" Text='<%# KSProgram.Sluzebky.SlcCisDruhDopr.KodyNaNazvy(Eval("druh_dopr").ToString()) %>' />
                            </td>
                        </tr>
                        <tr>
                            <td style="text-align: left; width: 105px">
                                <wc:TLabel ID="udaje_o_voz_t_Lab" runat="server"
                                    Text="[%Údaje o vozidle%]:"  Font-Bold="True" />
                            </td>
                            <td colspan="3" style="text-align: left">
                                <wc:TLabel ID="voz_nazev_t_Lab" runat="server" Text="[%Vozidlo%]:"></wc:TLabel>
                                <wc:TLabel ID="voz_nazev_Lab" runat="server"
                                    Text='<%# Bind("voz_nazev") %>' />
                            </td>
                            <td style="text-align: right;">
                                <wc:TLabel ID="spz_t_Lab" runat="server" Text="[%SPZ%]:"  />
                                <wc:TLabel ID="spz_Lab" runat="server" Text='<%# Bind("spz") %>' />
                                <%--PR 15.3.2016 spz_lab rename to spz_Lab--%>
                            </td>
                            <td style="text-align: right">
                                <wc:TLabel ID="cislo_poj_t_Lab" runat="server" Text="[%Číslo pojistky%]:" />
                            </td>
                            <td>
                                <wc:TLabel ID="cislo_poj_Lab" runat="server" Text='<%# Bind("cislo_poj") %>' />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 105px">
                                <wc:TLabel ID="pohonna_hmota_t_Lab" runat="server" Text="[%Pohonná hmota%]:" />
                            </td>
                            <td style="text-align: left">
                                <wc:TLabel ID="pohonna_hmota_Lab" runat="server" Text='<%# Bind("pohonna_hmota") %>' />
                            </td>
                            <td style="text-align: right" colspan="1">
                                <wc:TLabel ID="spotreba_t_Lab" runat="server" Text="[%Spotřeba%]:" />
                            </td>
                            <td colspan="4">
                                <wc:TLabel ID="spotreba_mesto_t_Lab" runat="server" Text="-[%město%]:"  />
                                <wc:TLabel ID="spotreba_mesto_Lab" runat="server" Text='<%# Bind("spotreba_mesto") %>' />
                                <wc:TLabel ID="spotreba_mimo_t_Lab" runat="server" Text="&nbsp;-[%mimo město%]:" />
                                <wc:TLabel ID="spotreba_mimo_Lab" runat="server" Text='<%# Bind("spotreba_mimo") %>' />
                                <wc:TLabel ID="prum_spotreba_t_Lab" runat="server" Text="&nbsp;-[%kombinovaná%]:" />
                                <wc:TLabel ID="prum_spotreba_Lab" runat="server" Text='<%# Bind("prum_spotreba") %>' />
                            </td>
                        </tr>
                        <tr>
                            <td style="text-align: left;" colspan="7">
                                <asp:CheckBox ID="cbx_platne_poj" runat="server" Checked='<%# Bind("platne_poj") %>' 
                                    Text="[%Potvrzuji, že vozidlo má platné povinné ručení a havarijní pojištění%]" Enabled="False" Visible="false" />
                            </td>
                        </tr>
                        <tr>
                            <td style="text-align: left; width: 105px">
                                <wc:TLabel ID="TLabel8" runat="server" Text="[%Kapesné%]:" Visible='<%# !Eval("kapes_t_proc").Equals(DBNull.Value) || !Eval("kapes_proc").Equals(DBNull.Value) %>' />
                            </td>
                            <td colspan="2">
                                <wc:TLabel ID="TLabel9" runat="server" Text="[%tuzemsko%]:" Visible='<%# !Eval("kapes_t_proc").Equals(DBNull.Value) %>' />
                                <wc:TLabel ID="TLabel12" runat="server" Text='<%# Eval("kapes_t_proc") %>' />
                                <wc:TLabel ID="TLabel13" runat="server" Text="%" Visible='<%# !Eval("kapes_t_proc").Equals(DBNull.Value) %>' />
                            </td>
                            <td colspan="2">
                                <wc:TLabel ID="TLabel10" runat="server" Text="[%zahraničí%]:" Visible='<%# !Eval("kapes_proc").Equals(DBNull.Value) %>' />
                                <wc:TLabel ID="TLabel14" runat="server" Text='<%# Eval("kapes_proc") %>' />
                                <wc:TLabel ID="TLabel15" runat="server" Text="%" Visible='<%# !Eval("kapes_proc").Equals(DBNull.Value) %>' />
                            </td>
                            <td colspan="2"></td>
                        </tr>
                        <tr>
                            <td colspan="7">
                                <wc:TLabel ID="TLabel22" runat="server" Text="[%Předpokládané náklady%]:" Visible='<%# !Eval("predp_nakl").Equals(DBNull.Value) && Eval("predp_nakl").ToString().Length>0 %>' />
                                <wc:TLabel ID="predp_nakl_Lab" runat="server" Text='<%# Eval("predp_nakl") %>' />
                                <wc:TLabel ID="predp_nakl_mena_Lab" runat="server" Text='<%# Eval("predp_nakl_mena") %>' />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="7">
                                <wc:TLabel ID="pzn_t_Lab" runat="server" Visible='<%# !Eval("pzn").Equals(DBNull.Value) && Eval("pzn").ToString().Length>0 %>'
                                    Text="[%Poznámka%]:" />
                                <wc:TLabel ID="pzn_Lab" runat="server" Text='<%# Eval("pzn") %>' />
                            </td>
                        </tr>

                                <asp:TableRow runat="server" CssClass="noborder" Visible='<%# KSProgram.Zakaznik.IsCurrent("ACO")%>'>
                                    <asp:TableCell runat="server" ColumnSpan="7">
                                        <br />
                                        <wc:TLabel ID="tit_L" runat="server" Text="[%Je nutné zařídit%]:" Font-Bold="True" />
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow runat="server" CssClass="noborder" Visible='<%# KSProgram.Zakaznik.IsCurrent("ACO")%>'>
                                    <asp:TableCell runat="server" ColumnSpan="7">
                                        <asp:CheckBox ID="let_ChB" runat="server" Checked='<%# Bind("let") %>' Text="[%Letenka%]" Visible='<%# true.Equals(Eval("let")) %>' Enabled="false"></asp:CheckBox>
                                        
                                        &nbsp;&nbsp;<wc:TLabel ID="let_odj_L" runat="server" Text="[%Odlet%]:" Visible='<%# !DBNull.Value.Equals(Eval("let_o")) %>' />
                                        
                                        &nbsp;<wc:TLabel ID="let_o_L" runat="server" Text='<%# Eval("let_o", "{0:d.M.yyyy}") %>' Visible='<%# !DBNull.Value.Equals(Eval("let_o")) %>' />
                                        &nbsp;<wc:TLabel ID="let_oti_L" runat="server" Text='<%# Eval("let_oti") %>' Visible='<%# !DBNull.Value.Equals(Eval("let_oti")) %>' />
                                                                                
                                        &nbsp;&nbsp;<wc:TLabel ID="let_prj_L" runat="server" Text="[%Přílet%]:" Visible='<%# !DBNull.Value.Equals(Eval("let_p")) %>' />
                                        
                                        &nbsp;<wc:TLabel ID="let_p_L" runat="server" Text='<%# Eval("let_p", "{0:d.M.yyyy}") %>' Visible='<%# !DBNull.Value.Equals(Eval("let_p")) %>' />
                                        &nbsp;<wc:TLabel ID="let_pti_L" runat="server" Text='<%# Eval("let_pti") %>' Visible='<%# !DBNull.Value.Equals(Eval("let_pti")) %>' />
                                                                                
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow runat="server" CssClass="noborder" Visible='<%# KSProgram.Zakaznik.IsCurrent("ACO")%>'>
                                    <asp:TableCell runat="server" ColumnSpan="7">
                            			<asp:CheckBox ID="ubyt_ChB" runat="server" Checked='<%# Bind("ubyt") %>' Text="[%Ubytování%]&nbsp;" Visible='<%# true.Equals(Eval("ubyt")) %>' Enabled="false"></asp:CheckBox>
                            			<asp:CheckBox ID="aut_puj_ChB" runat="server" Checked='<%# Bind("aut_puj") %>' Text="[%Zapůjčení auta%]&nbsp;" Visible='<%# true.Equals(Eval("aut_puj")) %>' Enabled="false"></asp:CheckBox>
							            <asp:CheckBox ID="mdata_ChB" runat="server" Checked='<%# Bind("mdata") %>' Text="[%Mobilní data v zahraniční%]&nbsp;" Visible='<%# true.Equals(Eval("mdata")) %>' Enabled="false"></asp:CheckBox>
                            			<asp:CheckBox ID="vizum_ChB" runat="server" Checked='<%# Bind("vizum") %>' Text="[%Vízum%]" Visible='<%# true.Equals(Eval("vizum")) %>' Enabled="false"></asp:CheckBox>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow runat="server" CssClass="noborder" Visible='<%# KSProgram.Zakaznik.IsCurrent("ACO")%>'>
                                    <asp:TableCell runat="server" ColumnSpan="7">
                                        <wc:TLabel ID="TLabel24" runat="server" Text="[%Ostatní požadavky%]:" Visible='<%# !DBNull.Value.Equals(Eval("ost")) %>' />
                                        <wc:TLabel ID="ost_L" runat="server" Text='<%# Eval("ost") %>' Visible='<%# !DBNull.Value.Equals(Eval("ost")) %>' />
                                    </asp:TableCell>
                                </asp:TableRow>

                        <tr>
                            <td colspan="3" style="text-align: center">

                                <wc:TLabel ID="TLabel1" runat="server" Text='<%# Eval("souhlasil") %>' />
                                <br />
                                <span style="border-top-style: dotted; border-top-width: thin; border-top-color: #000000">&nbsp;&nbsp;&nbsp;
                                <wc:TLabel ID="Label_podpisZam" runat="server"
                                    Text="[%Souhlas zaměstnance%]"  />
                                    &nbsp;&nbsp;&nbsp;
                                </span>
                            </td>
                            <td colspan="4" style="text-align: center">


                                <wc:TLabel ID="TLabel2" runat="server" Text='<%# Eval("povolil") %>' />
                                <br />
                                <span style="border-top-style: dotted; border-top-width: thin; border-top-color: #000000">
                                    <wc:TLabel ID="Label_PCschvalil" runat="server"
                                        Text="[%Souhlas zaměstnance oprávněného k povolení cesty%]" />
                                </span>
                            </td>

                        </tr>
                        <tr class="tiskHide">
                            <td>
                                <wc:TRadButton ID="Hl_EditButton" runat="server" CausesValidation="False"
                                    CommandName="Edit" Text="[%Editovat%]" IdPrava='<%# KSProgram.Zakaznik.HasModul(KSProgram.AppModul.SluzebniCesty)?149:0 %>' Icon-PrimaryIconCssClass="fi fi-edit" CssClass="editovatButton" />
                            </td>
                            <td colspan="5" style="text-align: center">
                                <%--<wc:TRadButton ID="Hl_NewButton" runat="server" CausesValidation="False" 
                               CommandName="Novy" IdPrava="148" Text="[%Nový%]"  
                               Visible='<%# ShowNewButton %>' />--%>
                            </td>
                            <td style="text-align: right">
                                <%--<wc:TRadButton ID="Hl_PrintButton" runat="server" CausesValidation="False" 
                                Text="[%Tisk%]"  OnClientClicked="Hl_PrintButtonOnClientClicked" 
                                Visible='<%# ShowNewButton %>' AutoPostBack="False" />--%>
                                <%--<wc:TRadButton ID="Hl_PrintButton" runat="server" CausesValidation="False"
                                    Text="[%Tisk%]" CommandName="Tisk" Icon-PrimaryIconCssClass="fi fi-print" />--%>
                                
                                <wc:TRadButton ID="Hl_PrintButton" runat="server" AutoPostBack="False" CausesValidation="False"
                                    Text="[%Tisk%]" Icon-PrimaryIconCssClass="fi fi-print" ButtonType="LinkButton" CssClass="tiskButton"
                                    NavigateUrl='<%# @"~/Zamestnanec/CestPrikazPrint.aspx" + KSProgram.QueryStringCrypto.EncryptQuery("?ev_cislo=" + Eval("ev_cislo")) %>' Target="_blank" />

                            </td>
                        </tr>
                    </table>
                </ItemTemplate>
                <EditItemTemplate>
                    <table class="celpad4 widthA4" style="margin: 0px; border-collapse: collapse">
                        <tr>
                            <td style="text-align: left" class="style14">
                                <asp:HiddenField ID="par_ev_cislo_HF" runat="server" Value='<%# Bind("par_ev_cislo") %>' />
                                <asp:HiddenField ID="os_cislo_HF" runat="server" Value='<%# Bind("os_cislo") %>' />
                                <asp:HiddenField ID="HF_CisloPom" runat="server" Value='<%# Eval("cislo_pom") %>' />
                                <wc:TLabel ID="zamestnanec_t_Lab" runat="server" Text="[%Zaměstnanec%]:"  />
                            </td>
                            <td>
                                <wc:TLabel ID="zamestnanec_Lab" runat="server" Text='<%# Eval("zamestnanec") %>' Style="font-weight: 700" />
                            </td>
                            <td>
                                <wc:TLabel ID="bu_t_Lab" runat="server" Text="[%BÚ%]:" />
                                <wc:TLabel ID="bu_Lab" runat="server" Text='<%# Eval("bu") %>' />
                            </td>
                            <td>
                                <wc:TLabel ID="ev_cislo_t_Lab" runat="server" Text="[%Číslo SC%]:" />
                            </td>
                            <td class="style11">
                                <asp:HiddenField ID="ev_cislo_HF" runat="server" Value='<%# Bind("ev_cislo") %>' />
                                <wc:TLabel ID="cislo_Lab" runat="server" Text='<%# Bind("cislo") %>' />
                            </td>
                        </tr>
                        <tr>
                            <td style="text-align: left" class="style14">
                                <wc:TLabel ID="bydliste_t_Lab" runat="server" Text="[%Bydliště%]:"  />
                            </td>
                            <td colspan="2">
                                <wc:TLabel ID="bydliste_Lab" runat="server" Text='<%# Eval("bydliste") %>' />
                            </td>
                            <td>
                                <wc:TLabel ID="typ_t_Lab" runat="server" Text="[%Typ%]:" />
                            </td>
                            <td class="style11">
                                <telerik:RadDropDownList CssClass="povinne-pole" ID="typ_DDL" runat="server" AppendDataBoundItems="True"
                                    SelectedValue='<%# Bind("typ") %>' AutoPostBack="true" OnSelectedIndexChanged="FV_SlcHlavicka_typ_DDL_SelectedIndexChanged">
                                    <Items>
                                        <telerik:DropDownListItem Value="" Text="" />
                                        <telerik:DropDownListItem Value="t" Text="[%Tuzemská%]" />
                                        <telerik:DropDownListItem Value="z" Text="[%Zahraniční%]" />
                                    </Items>
                                </telerik:RadDropDownList>
                            </td>
                        </tr>
                        <tr runat="server" id="tr_proj_druh_nakl" visible='<%# _DruhNaklVisible || _HlProjektVisible %>'>
                            <td style="text-align: left" class="style14">
                                <wc:TLabel ID="proj_Lb" runat="server" Text="[%Projekt%]" Visible='<%# _HlProjektVisible %>' />
                            </td>
                            <td colspan="2">
                                <wc:TRadComboBox ID="id_proj_RCmb" runat="server"  AllowCustomText="False" Width="250px"
                                    DataSourceID="ODS_Projekty" DataTextField="cely_nazev" DataValueField="id" DropDownWidth="250px" MaxHeight="200px"
                                    EnableLoadOnDemand="True" EnableAutomaticLoadOnDemand="True" LoadingMessage="Nahrávám..."
                                    MarkFirstMatch="True" Filter="Contains" ItemsPerRequest="20" EnableVirtualScrolling="True" MinFilterLength="1" EmptyMessage="piš pro nabídku"
                                    CausesValidation="False" />
                                <%-- Visible='<%# _HlProjektVisible %>' SelectedValue='<%# Bind("id_proj") %>'  --%>
                                <%--<asp:HiddenField runat="server" ID="id_proj_HF" Value='<%# Bind("id_proj") %>' />--%>
                            </td>
                            <td>
                                <wc:TLabel ID="TLabel19" runat="server" Text="[%Druh nákladu%]:" Visible='<%# _DruhNaklVisible %>' /></td>
                            <td class="style11">
                                <wc:TObjectDataSource runat="server" ID="ODS_UnivCis105" TypeName="KSProgram.Ciselniky.CisUniv" SelectMethod="Seznam" EnableCaching="True" CacheDuration="600">
                                    <SelectParameters>
                                        <asp:Parameter Name="id" Type="Int16" DefaultValue="105" />
                                        <asp:Parameter Name="pridatPrazdnyRadek" Type="Boolean" DefaultValue="True" />
                                    </SelectParameters>
                                </wc:TObjectDataSource>
                                <telerik:RadDropDownList CssClass="povinne-pole" ID="druh_DDL" runat="server"
                                    Visible='<%# _DruhNaklVisible %>'
                                    SelectedValue='<%# Bind("druh") %>' DataSourceID="ODS_UnivCis105" DataValueField="cislo" DataTextField="vyznam" />
                            </td>
                        </tr>
                    </table>
                    <table class="celpad4 widthA4" style="margin: 0px; border-collapse: collapse;">
                        <tr>
                            <td class="border1pxT border1pxR" style="width: 30%;">
                                <b>
                                    <wc:TLabel ID="pocatek_cesty_t_Lab" runat="server" Text="[%Počátek cesty%]:" /></b>
                            </td>
                            <td class="border1pxT border1pxR" style="width: 40%;">
                                <b>
                                    <wc:TLabel ID="cil_t_Lab" runat="server" Text="[%Místo jednání, účel cesty%]:" /></b>
                            </td>
                            <td class="border1pxT" style="width: 30%;">
                                <b>
                                    <wc:TLabel ID="konec_cesty_t_Lab" runat="server" Text="[%Konec cesty%]:" /></b>
                            </td>
                        </tr>
                        <tr>
                            <td class="style1 border1pxR" style="width: 30%;">
                                <wc:TLabel ID="Label2" runat="server" Text="[%Místo%]:" />
                                &nbsp;

                            <%--<telerik:RadAutoCompleteBox runat="server" ID="poc_misto_TB" Text='<%# Eval("poc_misto") %>'  Width="170px" MaxLength="40"
                              ontextchanged="FV_SlcHlavicka_poc_misto_TB_TextChanged"
                              InputType="Token" >
                              <WebServiceSettings Method="GetObecCompletionList" Path="~/PrivateWebServices/AutoCompleteService.asmx" />
                              <TokensSettings AllowTokenEditing="true" />
                            </telerik:RadAutoCompleteBox >--%>

                                <%--<wc:TTextBox ID="poc_misto_TB" CssClass="input povinne-pole" runat="server"  
                                Text='<%# Bind("poc_misto") %>' Width="170px" MaxLength="40" 
                                ontextchanged="FV_SlcHlavicka_poc_misto_TB_TextChanged" />
                            <cc1:AutoCompleteExtender ID="poc_mistoTextBox_AutoCompleteExtender" 
                                runat="server" DelimiterCharacters="" Enabled="True" MinimumPrefixLength="2" 
                                ServiceMethod="GetObecCompletionList" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx" 
                                TargetControlID="poc_misto_TB" UseContextKey="True">
                            </cc1:AutoCompleteExtender>--%>
                                <telerik:RadComboBox ID="poc_misto_TB" SkinID="povinne-pole" runat="server" Text='<%# Bind("poc_misto") %>' Width="170px" MaxLength="40"
                                    AllowCustomText="True" OnClientTextChange="OnPocMistoTextChange" OnClientSelectedIndexChanged="OnPocMistoTextChange"
                                    DataSourceID="ODS_vychoziMisto" >
                                </telerik:RadComboBox>
                            </td>
                            <td class="border1pxR" style="width: 40%;" rowspan="2">
                                <wc:TLabel ID="Label5" runat="server" Text="[%Místo%]:" />
                                <wc:TTextBox ID="cil_TB" CssClass="input povinne-pole" runat="server" Text='<%# Bind("cil") %>'
                                    Width="220px" MaxLength="80" />
                                <br />
                                <wc:TLabel ID="TLabel21" runat="server" Text="[%Země%]:" Visible='<%# KSProgram.Zakaznik.HasModul(KSProgram.AppModul.SluzebniCesty) %>' />
                                <telerik:RadDropDownList ID="cil_zeme_DDL" SkinID="povinne-pole" runat="server" SelectedValue='<%# Bind("cil_zeme") %>' Visible='<%# KSProgram.Zakaznik.HasModul(KSProgram.AppModul.SluzebniCesty) %>'
                                    DataSourceID="ODS_CisZemi" DataTextField="zeme_display" DataValueField="zeme" Width="120px" DropDownHeight="300px" DropDownWidth="200px"
                                    OnClientSelectedIndexChanged="OnCilZemeDDLChanged">
                                </telerik:RadDropDownList>
                            </td>
                            <td style="width: 30%;">
                                <wc:TLabel ID="Label7" runat="server" Text="[%Místo%]:" />
                                &nbsp;
                            <%--<wc:TTextBox ID="kon_misto_TB" CssClass="input povinne-pole" runat="server" 
                               Text='<%# Bind("kon_misto") %>' Width="170px"  MaxLength="40" />--%>
                                <telerik:RadComboBox ID="kon_misto_TB" SkinID="povinne-pole" runat="server" Text='<%# Bind("kon_misto") %>' Width="170px" MaxLength="40"
                                    AllowCustomText="True"
                                    DataSourceID="ODS_vychoziMisto" >
                                </telerik:RadComboBox>
                            </td>
                        </tr>
                        <tr>
                            <td class="border1pxR" style="width: 30%;">
                                <wc:TLabel ID="Label3" runat="server" Text="[%Datum%]:" />
                                <wc:TRadDatePicker ID="dat_od_TB" SkinID="povinne-pole" runat="server"
                                    DbSelectedDate='<%# Bind("dat_od") %>' Width="100px" DateInput-MaxLength="10" />
                                <%--OnSelectedDateChanged="FV_SlcHlavicka_dat_od_TB_TextChanged"  AutoPostBack="True"--%>
                                <%--<wc:TTextBox ID="dat_od_TB" runat="server"  
                                Text='<%# Bind("dat_od", "{0:d.M.yyyy}") %>' Width="70px" MaxLength="10"
                                ontextchanged="FV_SlcHlavicka_dat_od_TB_TextChanged" />--%>
                                <%--<wc:TCalendarExtender ID="dat_odTextBox_CalendarExtender" runat="server" 
                                Enabled="True" TargetControlID="dat_od_TB">
                            </wc:TCalendarExtender>--%>
                            </td>
                            <td style="width: 30%;">
                                <wc:TLabel ID="Label8" runat="server" Text="[%Datum%]:" />
                                <wc:TRadDatePicker ID="dat_do_TB" SkinID="povinne-pole" runat="server"
                                    DbSelectedDate='<%# Bind("dat_do") %>' Width="100px" DateInput-MaxLength="10" />
                                <%--<wc:TTextBox ID="dat_do_TB" runat="server"  
                                Text='<%# Bind("dat_do", "{0:d.M.yyyy}") %>' Width="70px" MaxLength="10" />
                            <wc:TCalendarExtender ID="dat_doTextBox_CalendarExtender" runat="server" 
                                Enabled="True" TargetControlID="dat_do_TB">
                            </wc:TCalendarExtender>          --%>                  
                            </td>
                        </tr>
                        <tr>
                            <td class="border1pxR border1pxB" style="width: 30%;">
                                <wc:TLabel ID="Label4" runat="server" Text="[%Čas%]:" />
                                &nbsp;&nbsp;&nbsp;
                            <wc:TTextBox ID="cas_od_TB" CssClass="input povinne-pole" runat="server"
                                Text='<%# Bind("cas_od") %>' Width="45px" onkeypress="CasKeyPress(this, event)" onkeyup="CasKeyUp(this, event)" onblur="CasChange(this, event)" ToolTip="hh:mm" />
                                <%--<cc1:MaskedEditExtender ID="cas_odTextBox_MEExt" runat="server" 
                               CultureAMPMPlaceholder="" CultureCurrencySymbolPlaceholder="" 
                               CultureDateFormat="" CultureDatePlaceholder="" CultureDecimalPlaceholder="" 
                               CultureThousandsPlaceholder="" CultureTimePlaceholder="" Enabled="True" 
                               Mask="99:99" MaskType="Time" EnableViewState="False" TargetControlID="cas_od_TB">
                            </cc1:MaskedEditExtender>--%>
                            </td>
                            <td class="border1pxR border1pxB" style="width: 40%;">
                                <wc:TLabel ID="Label6" runat="server" Text="[%Účel%]:" />
                                &nbsp;<wc:TTextBox ID="ucel_TB" CssClass="input povinne-pole" runat="server"
                                    Text='<%# Bind("ucel") %>' Width="220px" MaxLength="80" />
                            </td>
                            <td class="border1pxB" style="width: 30%;">
                                <wc:TLabel ID="Label10" runat="server" Text="[%Čas%] ([%pesimistický odhad%]):" />
                                &nbsp;&nbsp;&nbsp;
                            <wc:TTextBox ID="cas_do_TB" CssClass="input povinne-pole" runat="server" Text='<%# Bind("cas_do") %>' Width="45px" onkeypress="CasKeyPress(this, event)" onkeyup="CasKeyUp(this, event)" onblur="CasChange(this, event)" ToolTip="hh:mm" />
                                <%--<cc1:MaskedEditExtender ID="cas_do_MEExt" runat="server" 
                               CultureAMPMPlaceholder="" CultureCurrencySymbolPlaceholder="" 
                               CultureDateFormat="" CultureDatePlaceholder="" CultureDecimalPlaceholder="" 
                               CultureThousandsPlaceholder="" CultureTimePlaceholder="" Enabled="True" 
                               Mask="99:99" MaskType="Time" EnableViewState="False" TargetControlID="cas_do_TB">
                            </cc1:MaskedEditExtender>--%>
                            </td>
                        </tr>
                    </table>
                    <table class="celpad4 widthA4" style="margin: 0px; border-collapse: collapse;">
                        <tr>
                            <td style="text-align: left" class="style32">
                                <wc:TLabel ID="spolucestující_t_Lab" runat="server" Text="[%Spolucestující%]:" />
                                <wc:TLabel ID="TLabel6" runat="server" Text="([%zadávejte jméno ve tvaru příjmení mezera jméno%]):" Font-Italic="True" />
                            </td>
                            <td colspan="6">
                                <asp:HiddenField ID="spolucestujici_HF" runat="server" Value='<%# Bind("spolucestujici") %>' />

                                <asp:HiddenField ID="spolu1_HF" runat="server" Value='<%# Bind("spolu1") %>' />
                                <asp:HiddenField ID="spolu2_HF" runat="server" Value='<%# Bind("spolu2") %>' />
                                <asp:HiddenField ID="spolu3_HF" runat="server" Value='<%# Bind("spolu3") %>' />
                                <asp:HiddenField ID="spolu4_HF" runat="server" Value='<%# Bind("spolu4") %>' />
                                <asp:HiddenField ID="spolu5_HF" runat="server" Value='<%# Bind("spolu5") %>' />
                                <asp:HiddenField ID="spolu6_HF" runat="server" Value='<%# Bind("spolu6") %>' />
                                <asp:HiddenField ID="spolu7_HF" runat="server" Value='<%# Bind("spolu7") %>' />
                                <asp:HiddenField ID="spolu8_HF" runat="server" Value='<%# Bind("spolu8") %>' />
                                <asp:HiddenField ID="spolu9_HF" runat="server" Value='<%# Bind("spolu9") %>' />
                                <asp:HiddenField ID="spolu10_HF" runat="server" Value='<%# Bind("spolu10") %>' />

                                <wc:TTextBox ID="spolu1_TB" runat="server" OnTextChanged="FV_SlcHlavicka_spoluX_TB_Changed" Text='<%# (Eval("spolu1") is Decimal)?KSProgram.Funkce.Pracovnik.PrijmeniJmeno((decimal)Eval("spolu1")):"" %>' Width="10em" AutoPostBack="True" />
                                <cc1:AutoCompleteExtender ID="ACExt_spolu1_TB"
                                    runat="server" DelimiterCharacters="" Enabled="True" MinimumPrefixLength="1"
                                    ServiceMethod="CompleteJmeno" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                    TargetControlID="spolu1_TB" UseContextKey="True">
                                </cc1:AutoCompleteExtender>

                                <wc:TTextBox ID="spolu2_TB" runat="server" OnTextChanged="FV_SlcHlavicka_spoluX_TB_Changed" Text='<%# (Eval("spolu2") is Decimal)?KSProgram.Funkce.Pracovnik.PrijmeniJmeno((decimal)Eval("spolu2")):"" %>' Width="10em" AutoPostBack="True" />
                                <cc1:AutoCompleteExtender ID="ACExt_spolu2_TB"
                                    runat="server" DelimiterCharacters="" Enabled="True" MinimumPrefixLength="1"
                                    ServiceMethod="CompleteJmeno" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                    TargetControlID="spolu2_TB" UseContextKey="True">
                                </cc1:AutoCompleteExtender>

                                <wc:TTextBox ID="spolu3_TB" runat="server" OnTextChanged="FV_SlcHlavicka_spoluX_TB_Changed" Text='<%# (Eval("spolu3") is Decimal)?KSProgram.Funkce.Pracovnik.PrijmeniJmeno((decimal)Eval("spolu3")):"" %>' Width="10em" AutoPostBack="True" />
                                <cc1:AutoCompleteExtender ID="ACExt_spolu3_TB"
                                    runat="server" DelimiterCharacters="" Enabled="True" MinimumPrefixLength="1"
                                    ServiceMethod="CompleteJmeno" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                    TargetControlID="spolu3_TB" UseContextKey="True">
                                </cc1:AutoCompleteExtender>

                                <wc:TTextBox ID="spolu4_TB" runat="server" OnTextChanged="FV_SlcHlavicka_spoluX_TB_Changed" Text='<%# (Eval("spolu4") is Decimal)?KSProgram.Funkce.Pracovnik.PrijmeniJmeno((decimal)Eval("spolu4")):"" %>' Width="10em" AutoPostBack="True" />
                                <cc1:AutoCompleteExtender ID="AutoCompleteExtender1"
                                    runat="server" DelimiterCharacters="" Enabled="True" MinimumPrefixLength="1"
                                    ServiceMethod="CompleteJmeno" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                    TargetControlID="spolu4_TB" UseContextKey="True">
                                </cc1:AutoCompleteExtender>

                                <wc:TTextBox ID="spolu5_TB" runat="server" OnTextChanged="FV_SlcHlavicka_spoluX_TB_Changed" Text='<%# (Eval("spolu5") is Decimal)?KSProgram.Funkce.Pracovnik.PrijmeniJmeno((decimal)Eval("spolu5")):"" %>' Width="10em" AutoPostBack="True" />
                                <cc1:AutoCompleteExtender ID="AutoCompleteExtender2"
                                    runat="server" DelimiterCharacters="" Enabled="True" MinimumPrefixLength="1"
                                    ServiceMethod="CompleteJmeno" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                    TargetControlID="spolu5_TB" UseContextKey="True">
                                </cc1:AutoCompleteExtender>

                                <wc:TTextBox ID="spolu6_TB" runat="server" OnTextChanged="FV_SlcHlavicka_spoluX_TB_Changed" Text='<%# (Eval("spolu6") is Decimal)?KSProgram.Funkce.Pracovnik.PrijmeniJmeno((decimal)Eval("spolu6")):"" %>' Width="10em" AutoPostBack="True" />
                                <cc1:AutoCompleteExtender ID="AutoCompleteExtender3"
                                    runat="server" DelimiterCharacters="" Enabled="True" MinimumPrefixLength="1"
                                    ServiceMethod="CompleteJmeno" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                    TargetControlID="spolu6_TB" UseContextKey="True">
                                </cc1:AutoCompleteExtender>

                                <wc:TTextBox ID="spolu7_TB" runat="server" OnTextChanged="FV_SlcHlavicka_spoluX_TB_Changed" Text='<%# (Eval("spolu7") is Decimal)?KSProgram.Funkce.Pracovnik.PrijmeniJmeno((decimal)Eval("spolu7")):"" %>' Width="10em" AutoPostBack="True" />
                                <cc1:AutoCompleteExtender ID="AutoCompleteExtender4"
                                    runat="server" DelimiterCharacters="" Enabled="True" MinimumPrefixLength="1"
                                    ServiceMethod="CompleteJmeno" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                    TargetControlID="spolu7_TB" UseContextKey="True">
                                </cc1:AutoCompleteExtender>

                                <wc:TTextBox ID="spolu8_TB" runat="server" OnTextChanged="FV_SlcHlavicka_spoluX_TB_Changed" Text='<%# (Eval("spolu8") is Decimal)?KSProgram.Funkce.Pracovnik.PrijmeniJmeno((decimal)Eval("spolu8")):"" %>' Width="10em" AutoPostBack="True" />
                                <cc1:AutoCompleteExtender ID="AutoCompleteExtender5"
                                    runat="server" DelimiterCharacters="" Enabled="True" MinimumPrefixLength="1"
                                    ServiceMethod="CompleteJmeno" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                    TargetControlID="spolu8_TB" UseContextKey="True">
                                </cc1:AutoCompleteExtender>

                                <wc:TTextBox ID="spolu9_TB" runat="server" OnTextChanged="FV_SlcHlavicka_spoluX_TB_Changed" Text='<%# (Eval("spolu9") is Decimal)?KSProgram.Funkce.Pracovnik.PrijmeniJmeno((decimal)Eval("spolu9")):"" %>' Width="10em" AutoPostBack="True" />
                                <cc1:AutoCompleteExtender ID="AutoCompleteExtender6"
                                    runat="server" DelimiterCharacters="" Enabled="True" MinimumPrefixLength="1"
                                    ServiceMethod="CompleteJmeno" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                    TargetControlID="spolu9_TB" UseContextKey="True">
                                </cc1:AutoCompleteExtender>

                                <wc:TTextBox ID="spolu10_TB" runat="server" OnTextChanged="FV_SlcHlavicka_spoluX_TB_Changed" Text='<%# (Eval("spolu10") is Decimal)?KSProgram.Funkce.Pracovnik.PrijmeniJmeno((decimal)Eval("spolu10")):"" %>' Width="10em" AutoPostBack="True" />
                                <cc1:AutoCompleteExtender ID="AutoCompleteExtender7"
                                    runat="server" DelimiterCharacters="" Enabled="True" MinimumPrefixLength="1"
                                    ServiceMethod="CompleteJmeno" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                    TargetControlID="spolu10_TB" UseContextKey="True">
                                </cc1:AutoCompleteExtender>

                            </td>
                        </tr>
                        <tr>
                            <td style="text-align: left" class="style32">
                                <wc:TLabel ID="druh_dopr_t_Lab" runat="server" Text="[%Určený dopravní prostředek%]:" />
                            </td>
                            <td class="style13" colspan="6">
                                <wc:TCheckBoxList ID="druh_dopr_ChBL" CssClass="povinne-pole" runat="server"
                                    DataSourceID="ODS_druhDopr" DataTextField="cely_nazev" DataValueField="kod"
                                    SelectedValues='<%# Bind("druh_dopr") %>' RepeatColumns="3"
                                    AutoPostBack="True"
                                    OnSelectedIndexChanged="FV_SlcHlavicka_druh_dopr_ChBL_SelectedIndexChanged">
                                </wc:TCheckBoxList>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="7">

                                <%--<asp:Panel ID="Pnl_vozidlo" runat="server">--%>
                                <table style="width: 100%">
                                    <tr>
                                        <td style="text-align: left">
                                            <b>
                                                <wc:TLabel ID="udaje_o_voz_t_Lab" runat="server" Text="[%Údaje o vozidle%]:" /></b>
                                        </td>
                                        <td style="text-align: left;" colspan="3">
                                            <asp:CheckBox ID="cbx_jen_dostupne" runat="server" Text="[%Omezit seznam na dostupná vozidla v daném termínu%]" AutoPostBack="True" /></td>
                                        <td>&nbsp;</td>
                                        <td style="text-align: right">&nbsp;</td>
                                        <td>&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td style="text-align: right">
                                            <wc:TLabel ID="voz_nazev_Lab" runat="server" Text="[%Vozidlo%]:" />
                                        </td>
                                        <td colspan="2">
                                            <%--<telerik:RadDropDownList ID="spz_sluz_DDL" runat="server" AutoPostBack="True"  
                                            DataSourceID="ODS_spzSluz" DataTextField="cely_nazev" DataValueField="spz" 
                                             Width="24em" SelectedValue='<%# DataBinder.Eval(Container.DataItem, "spz_sluz") %>'
                                            onselectedindexchanged="FV_SlcHlavicka_Vuz_DDL_SelectedIndexChanged" 
                                            ToolTip="[%Seznam je omezen na dostupná vozidla v daném termínu%]" >
                                        </telerik:RadDropDownList>
                                        <wc:TRadButton ID="RB_sluzDDL_refresh" runat="server" Text="" ToolTip="[%Obnovit%]"
                                             CausesValidation="False" AutoPostBack="True" CommandName="sluzDDL_refresh" CssClass="rbRefresh">
                                        </wc:TRadButton>
                                        <telerik:RadDropDownList ID="spz_vlast_DDL" runat="server" AutoPostBack="True" 
                                            DataSourceID="ODS_spzVlast" DataTextField="cely_nazev" DataValueField="spz"
                                             Width="24em" SelectedValue='<%# DataBinder.Eval(Container.DataItem, "spz_vlast") %>'
                                            onselectedindexchanged="FV_SlcHlavicka_Vuz_DDL_SelectedIndexChanged">                                            
                                        </telerik:RadDropDownList>--%>
                                            <telerik:RadDropDownList ID="spz_DDL" runat="server" AutoPostBack="True"
                                                DataSourceID="ODS_spz" DataTextField="cely_nazev" DataValueField="spz"
                                                Width="24em" SelectedValue='<%# DataBinder.Eval(Container.DataItem, "spz") %>'
                                                OnSelectedIndexChanged="FV_SlcHlavicka_Vuz_DDL_SelectedIndexChanged">
                                            </telerik:RadDropDownList>
                                            <wc:TRadButton ID="RB_spzDDL_refresh" runat="server" Text="" ToolTip="[%Obnovit%]" Icon-PrimaryIconCssClass="fi fi-rotate-right"
                                                CausesValidation="False" AutoPostBack="True" CommandName="spzDDL_refresh">
                                            </wc:TRadButton>
                                            <wc:TRadButton ID="RB_najdi_auto" runat="server" Icon-PrimaryIconCssClass="fi fi-car-building" ToolTip="[%Přehled cest vozidel%]"
                                                AutoPostBack="False" CausesValidation="False" OnClientClicked="reloadRadWinCesty" IdPrava="304">
                                            </wc:TRadButton>
                                            <wc:TRadButton ID="RB_new_vozidlo" runat="server" Text="+" ToolTip="[%Žádost o přidání vozidla%]" Width="2em"
                                                CausesValidation="False" AutoPostBack="False" IdPrava="377" OnClientClicked="new_vozidlo">
                                            </wc:TRadButton>
                                        </td>
                                        <td style="text-align: right;">
                                            <wc:TLabel ID="spz_t_Lab" runat="server" Text="[%SPZ%]:" />
                                        </td>
                                        <td>
                                            <wc:TTextBox ID="spz_TB" runat="server" MaxLength="9" Text='<%# Bind("spz") %>' Width="8em" OnTextChanged="FV_SlcHlavicka_spz_TextChanged" AutoPostBack="True"
                                                onchange="this.value=value.toUpperCase().replace(/[^A-Z 0-9]+/g,'')" />
                                            <%--PR 22.05.2019 ruším onkeyup="this.value=value.toUpperCase().replace(/[^A-Z 0-9]+/g,'')"
                                            protože MS EDGE následně neprovede onchange a ani tedy postback--%> 
                                        </td>
                                        <td>
                                            <wc:TLabel ID="cislo_poj_t_Lab" runat="server" Text="[%Číslo pojistky%]:" ToolTip="[%Číslo havarijního pojištění%]" />
                                        </td>
                                        <td>
                                            <wc:TTextBox ID="cislo_poj_TB" runat="server" MaxLength="15" Text='<%# Bind("cislo_poj") %>' Width="8em" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="text-align: right">
                                            <wc:TLabel ID="pohonna_hmota_t_Lab" runat="server" Text="[%Pohonná hmota%]:" />
                                        </td>
                                        <td>
                                            <%--AutoPostBack="True" onselectedindexchanged="FV_SlcHlavicka_pohonna_hmota_DDL_SelectedIndexChanged"--%>
                                            <telerik:RadDropDownList ID="pohonna_hmota_DDL" runat="server" AppendDataBoundItems="True"
                                                DataSourceID="ODS_PHM" DataTextField="nazev"
                                                DataValueField="nazev"
                                                SelectedValue='<%# Bind("pohonna_hmota") %>'>
                                            </telerik:RadDropDownList>
                                        </td>
                                        <td>
                                            <wc:TLabel ID="spotreba_t_Lab" runat="server" Text="[%Spotřeba%]:" />
                                        </td>
                                        <td style="text-align: left;" colspan="4">
                                            <wc:TLabel ID="spotreba_mesto_t_Lab" runat="server" Text="-[%město%]:" />
                                            <wc:TTextBox ID="spotreba_mesto_TB" runat="server"
                                                Text='<%# Bind("spotreba_mesto") %>' Width="4em" MaxLength="5" />
                                            &nbsp;&nbsp;<wc:TLabel ID="spotreba_mimo_t_Lab" runat="server" Text="-[%mimo město%]:" />
                                            <wc:TTextBox ID="spotreba_mimo_TB" runat="server"
                                                Text='<%# Bind("spotreba_mimo") %>' Width="4em" MaxLength="5" />
                                            &nbsp;&nbsp;<wc:TLabel ID="prum_spotreba_t_Lab" runat="server" Text="-[%kombinovaná%]:" />
                                            <wc:TTextBox ID="prum_spotreba_TB" runat="server"
                                                Text='<%# Bind("prum_spotreba") %>' Width="4em" MaxLength="5" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="text-align: left;" colspan="7">
                                            <asp:CheckBox ID="cbx_platne_poj" runat="server" Checked='<%# Bind("platne_poj") %>' 
                                                Text="[%Potvrzuji, že vozidlo má platné povinné ručení a havarijní pojištění%]" Font-Bold="True" Visible="false" />
                                        </td>
                                    </tr>
                                </table>
                                <%--</asp:Panel>--%>
                            </td>
                        </tr>
                        <tr>
                            <td style="text-align: left; width: 105px">
                                <wc:TLabel ID="TLabel8" runat="server" Text="[%Kapesné%]:" Visible='<%# of_KapesneZahrSeznamVyplneno() || of_KapesneTuzSeznamVyplneno() %>' />
                            </td>
                            <td colspan="2">
                                <wc:TLabel ID="TLabel9" runat="server" Text="[%tuzemsko%]:" Visible='<%# of_KapesneTuzSeznamVyplneno() %>' />
                                <telerik:RadDropDownList ID="kapes_t_proc_DDL" runat="server" Width="4em" Visible='<%# of_KapesneTuzSeznamVyplneno() %>'
                                    DataSourceID="ODS_kapes_t_proc" DataTextField="value" DataValueField="value"
                                    SelectedValue='<%# Bind("kapes_t_proc") %>'>
                                </telerik:RadDropDownList>
                                <wc:TLabel ID="TLabel13" runat="server" Text="%" Visible='<%# of_KapesneTuzSeznamVyplneno() %>' />
                            </td>
                            <td colspan="2">
                                <wc:TLabel ID="kapes_proc_Lab1" runat="server" Text="[%zahraničí%]:" Visible='<%# of_KapesneZahrSeznamVyplneno() && CPjeZahranicni %>' />
                                <telerik:RadDropDownList ID="kapes_proc_DDL" runat="server" Width="4em" Visible='<%# of_KapesneZahrSeznamVyplneno() && CPjeZahranicni %>'
                                    DataSourceID="ODS_kapes_proc" DataTextField="value" DataValueField="value"
                                    SelectedValue='<%# Bind("kapes_proc") %>'>
                                </telerik:RadDropDownList>
                                <wc:TLabel ID="kapes_proc_Lab2" runat="server" Text="%" Visible='<%# of_KapesneZahrSeznamVyplneno() && CPjeZahranicni %>' />
                            </td>
                            <td colspan="2"></td>
                        </tr>
                        <tr>
                            <td colspan="7">
                                <wc:TLabel ID="TLabel22" runat="server" Text="[%Předpokládané náklady%]:" />
                                <div style="vertical-align: middle; display: inline-block">
                                    <wc:TTextBox ID="predp_nakl_TB" runat="server" Text='<%# Bind("predp_nakl") %>' Width="5em" />
                                </div>
                                <telerik:RadDropDownList ID="predp_nakl_mena_DDL" runat="server" SelectedValue='<%# Bind("predp_nakl_mena") %>' DropDownHeight="300px" DropDownWidth="250px"
                                    DataSourceID="ODS_CisKodMeny" DataTextField="kod_a_nazev" DataValueField="kod" Width="60px">
                                </telerik:RadDropDownList>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="7">
                                <wc:TLabel ID="pzn_Lab" runat="server"
                                    Text="[%Poznámka%]:" />
                                <wc:TTextBox ID="pzn_TB" runat="server"
                                    Text='<%# Bind("pzn") %>' Width="780px" MaxLength="120" />
                            </td>
                        </tr>
                                
                                <asp:TableRow runat="server" CssClass="noborder" Visible='<%# KSProgram.Zakaznik.IsCurrent("ACO")%>'>
                                    <asp:TableCell runat="server" ColumnSpan="7">
                                        <br />
                                        <wc:TLabel ID="tit_L" runat="server" Text="[%Je nutné zařídit%]:" Font-Bold="True" />
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow runat="server" CssClass="noborder" Visible='<%# KSProgram.Zakaznik.IsCurrent("ACO")%>'>
                                    <asp:TableCell runat="server" ColumnSpan="7" >
                                        <asp:CheckBox ID="let_ChB" runat="server" Checked='<%# Bind("let") %>' Text="[%Letenka%]" Visible='<%# (","+Druh_dopr+",").Contains(",L,") || true.Equals(Eval("let")) %>' ></asp:CheckBox>
                                        
                                        <wc:TLabel ID="let_odj_L" runat="server" Text="&nbsp;[%Odlet%]:&nbsp;" Visible='<%# (","+Druh_dopr+",").Contains(",L,") || !DBNull.Value.Equals(Eval("let_o")) %>' />
                                                                                
                                        <wc:TRadDatePicker ID="let_o_RDP" runat="server" Visible='<%# (","+Druh_dopr+",").Contains(",L,") || !DBNull.Value.Equals(Eval("let_o")) %>'
                                            DbSelectedDate='<%# Bind("let_o") %>' Width="100px" DateInput-MaxLength="10" />
                                        <wc:TTextBox ID="let_oti_TB" runat="server" Text='<%# Bind("let_oti") %>' Visible='<%# (","+Druh_dopr+",").Contains(",L,") || !DBNull.Value.Equals(Eval("let_oti")) %>' Width="80px" MaxLength="13" />

                                        <wc:TLabel ID="let_prj_L" runat="server" Text="&nbsp;[%Přílet%]:&nbsp;" Visible='<%# (","+Druh_dopr+",").Contains(",L,") ||  !DBNull.Value.Equals(Eval("let_p")) %>' />
                                        
                                        <wc:TRadDatePicker ID="let_p_RDP" runat="server" Visible='<%# (","+Druh_dopr+",").Contains(",L,") || !DBNull.Value.Equals(Eval("let_p")) %>'
                                            DbSelectedDate='<%# Bind("let_p") %>' Width="100px" DateInput-MaxLength="10" />
                                        <wc:TTextBox ID="let_pti_TB" runat="server" Text='<%# Bind("let_pti") %>' Visible='<%# (","+Druh_dopr+",").Contains(",L,") || !DBNull.Value.Equals(Eval("let_pti")) %>' Width="80px" MaxLength="13" />
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow runat="server" CssClass="noborder" Visible='<%# KSProgram.Zakaznik.IsCurrent("ACO")%>'>
                                    <asp:TableCell runat="server" ColumnSpan="7">
                            			<asp:CheckBox ID="ubyt_ChB" runat="server" Checked='<%# Bind("ubyt") %>' Text="[%Ubytování%]&nbsp;" Visible="true" ></asp:CheckBox>
                            			<asp:CheckBox ID="aut_puj_ChB" runat="server" Checked='<%# Bind("aut_puj") %>' Text="[%Zapůjčení auta%]&nbsp;" Visible='<%# CPjeZahranicni || true.Equals(Eval("aut_puj")) %>' ></asp:CheckBox>
							            <asp:CheckBox ID="mdata_ChB" runat="server" Checked='<%# Bind("mdata") %>' Text="[%Mobilní data v zahraniční%]&nbsp;" Visible='<%# CPjeZahranicni || true.Equals(Eval("mdata")) %>' ></asp:CheckBox>
                            			<asp:CheckBox ID="vizum_ChB" runat="server" Checked='<%# Bind("vizum") %>' Text="[%Vízum%]" Visible='<%# CPjeZahranicni || true.Equals(Eval("vizum")) %>' ></asp:CheckBox>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow runat="server" CssClass="noborder" Visible='<%# KSProgram.Zakaznik.IsCurrent("ACO")%>'>
                                    <asp:TableCell runat="server" ColumnSpan="7">
                                        <wc:TLabel ID="TLabel24" runat="server" Text="[%Ostatní požadavky%]:" />
                                        <wc:TTextBox ID="ost_TB" runat="server" Text='<%# Bind("ost") %>' Width="780px" Height="50px" MaxLength="512" TextMode="MultiLine" />
                                    </asp:TableCell>
                                </asp:TableRow>

                        <tr>
                            <td colspan="7">
                                <asp:CustomValidator ID="HlavickaValidator" runat="server" OnServerValidate="FV_SlcHlavicka_validate" ErrorMessage="[%Chybně vyplněné údaje, nelze pokračovat%]" ValidationGroup="Hlavicka"></asp:CustomValidator>
                            </td>
                        </tr>
                        <tr>
                            <td class="style32">
                                <wc:TRadButton ID="Hl_UpdateButton" runat="server" CausesValidation="True" CommandName="Update" Text="[%Uložit%]" IdPrava='<%# KSProgram.Zakaznik.HasModul(KSProgram.AppModul.SluzebniCesty)?149:0 %>' ValidationGroup="Hlavicka" CssClass="ulozitButton" />
                            </td>
                            <td class="style26" colspan="2">
                                <wc:TRadButton ID="Hl_UpdateCancelButton" runat="server" CausesValidation="False" CommandName="Cancel" Text="[%Neuložit%]" />
                            </td>
                        </tr>
                    </table>
                </EditItemTemplate>
                <InsertItemTemplate>
                    <table class="celpad4 widthA4" style="margin: 1px; border-collapse: collapse">
                        <tr>
                            <td style="text-align: left">
                                <asp:HiddenField ID="par_ev_cislo_HF" runat="server" Value='<%# Bind("par_ev_cislo") %>' />
                                <asp:HiddenField ID="os_cislo_HF" runat="server" Value='<%# Bind("os_cislo") %>' />
                                <wc:TLabel ID="zamestnanec_t_Lab" runat="server" Text="[%Zaměstnanec%]:" />
                            </td>
                            <td>
                                <wc:TLabel ID="zamestnanec_Lab" runat="server" Text='' Style="font-weight: 700" />
                            </td>
                            <td>
                                <wc:TLabel ID="bu_t_Lab" runat="server" Text="[%BÚ%]:" />
                                <wc:TLabel ID="bu_Lab" runat="server" Text="" />
                            </td>
                            <td>
                                <wc:TLabel ID="cislo_t_Lab" runat="server" Text="[%Číslo SC%]:" />
                            </td>
                            <td>
                                <wc:TLabel ID="Label1" runat="server" Text="[%Nové%]" />
                            </td>
                        </tr>
                        <tr>
                            <td style="text-align: left">
                                <wc:TLabel ID="bydliste_t_Lab" runat="server" Text="[%Bydliště%]:" />
                            </td>
                            <td colspan="2">
                                <wc:TLabel ID="bydliste_Lab" runat="server" Text='' />
                            </td>
                            <td>
                                <wc:TLabel ID="typ_t_Lab" runat="server" Text="[%Typ%]:" />
                            </td>
                            <td>
                                <telerik:RadDropDownList ID="typ_DDL" SkinID="povinne-pole" runat="server" AppendDataBoundItems="True"
                                    SelectedValue='<%# Bind("typ") %>' AutoPostBack="true" OnSelectedIndexChanged="FV_SlcHlavicka_typ_DDL_SelectedIndexChanged">
                                    <Items>
                                        <telerik:DropDownListItem Value="" Text="" />
                                        <%--//PR 16.6.2016 ÚJV --%>
                                        <telerik:DropDownListItem Value="t" Text="[%Tuzemská%]" />
                                        <telerik:DropDownListItem Value="z" Text="[%Zahraniční%]" />
                                    </Items>
                                </telerik:RadDropDownList>
                            </td>
                        </tr>

                        <asp:TableRow runat="server" ID="row_pomer" Visible="false">
                            <asp:TableCell runat="server" ID="TableCell5" >
                                <asp:Label ID="Label12" runat="server"  Text="[%Číslo poměru%]:"></asp:Label>
                            </asp:TableCell>
                            <asp:TableCell ColumnSpan="4" runat="server"  ID="TableCell6">                    
                                <telerik:RadDropDownList runat="server" ID="ddl_pomery" SelectedValue='<%# Bind("cislo_pom") %>'
                                    DataSourceID="ds_pomery" DataValueField="cislo_pom" DataTextField="cislo_druh_nazev"  Width="280px">
                                </telerik:RadDropDownList>
                            </asp:TableCell>
                        </asp:TableRow>

                        <tr runat="server" id="tr_proj_druh_nakl" visible='<%# _DruhNaklVisible || _HlProjektVisible %>'>
                            <td style="text-align: left" class="style14">
                                <wc:TLabel ID="proj_Lb" runat="server" Text="[%Projekt%]:" Visible='<%# _HlProjektVisible %>' />
                            </td>
                            <td colspan="2">
                                <wc:TRadComboBox ID="id_proj_RCmb" runat="server"  AllowCustomText="False" Width="160px"
                                    DataSourceID="ODS_Projekty" DataTextField="cely_nazev" DataValueField="id" DropDownWidth="200px" MaxHeight="200px"
                                    EnableAutomaticLoadOnDemand="True" EnableLoadOnDemand="True" LoadingMessage="Nahrávám..."
                                    MarkFirstMatch="True" Filter="Contains" ItemsPerRequest="20" EnableVirtualScrolling="True" MinFilterLength="1"
                                    CausesValidation="False" EmptyMessage="piš pro nabídku" />
                                <%-- Visible='<%# _HlProjektVisible %> 'SelectedValue='<%# Bind("id_proj") %>'--%>
                                <%--<asp:HiddenField runat="server" ID="id_proj_HF" Value='<%# Bind("id_proj") %>' />--%>
                            </td>
                            <td>
                                <wc:TLabel ID="TLabel19" runat="server" Text="[%Druh nákladu%]:" Visible='<%# _DruhNaklVisible %>' />
                            </td>
                            <td>
                                <wc:TObjectDataSource runat="server" ID="ODS_UnivCis105" TypeName="KSProgram.Ciselniky.CisUniv" SelectMethod="Seznam" EnableCaching="True" CacheDuration="600">
                                    <SelectParameters>
                                        <asp:Parameter Name="id" Type="Int16" DefaultValue="105" />
                                        <asp:Parameter Name="pridatPrazdnyRadek" Type="Boolean" DefaultValue="True" />
                                    </SelectParameters>
                                </wc:TObjectDataSource>
                                <telerik:RadDropDownList CssClass="povinne-pole" ID="druh_DDL" runat="server"
                                    Visible='<%# _DruhNaklVisible %>'
                                    SelectedValue='<%# Bind("druh") %>' DataSourceID="ODS_UnivCis105" DataValueField="cislo" DataTextField="vyznam" />
                            </td>
                        </tr>
                    </table>
                    <table class="celpad4 widthA4" style="margin: 0px; border-collapse: collapse;">
                        <tr>
                            <td style="text-align: center" colspan="3">
                                <asp:LinkButton ID="VyplnHlavDle_Btn" runat="server" Visible="True" CssClass="hidden" Text="" CommandName="VyplnHlavDle" CommandArgument="0" CausesValidation="False"></asp:LinkButton>
                            </td>
                        </tr>
                        <tr>
                            <td class="border1pxT border1pxR" style="width: 30%;">
                                <b>
                                    <wc:TLabel ID="pocatek_cesty_t_Lab" runat="server" Text="[%Počátek cesty%]:" /></b>
                            </td>
                            <td class="border1pxT border1pxR" style="width: 40%;">
                                <b>
                                    <wc:TLabel ID="cil_t_Lab" runat="server" Text="[%Místo jednání, účel cesty%]:" /></b>
                            </td>
                            <td class="border1pxT">
                                <b>
                                    <wc:TLabel ID="konec_cesty_t_Lab" runat="server" Text="[%Konec cesty%]:" /></b>
                            </td>
                        </tr>
                        <tr>
                            <td class="style1 border1pxR" style="width: 30%;">
                                <wc:TLabel ID="Label2" runat="server" Text="[%Místo%]:" />
                                &nbsp;
                            
                                <telerik:RadComboBox ID="poc_misto_TB" runat="server" SkinID="povinne-pole" Text='<%# Bind("poc_misto") %>' Width="170px" MaxLength="40"
                                    AllowCustomText="True" OnClientTextChange="OnPocMistoTextChange" OnClientSelectedIndexChanged="OnPocMistoTextChange"
                                    DataSourceID="ODS_vychoziMisto" >
                                </telerik:RadComboBox>
                                
                            </td>
                            <td class="border1pxR" style="width: 40%;"
                                rowspan="2">
                                <wc:TLabel ID="Label5" runat="server" Text="[%Místo%]:" />
                                <wc:TTextBox ID="cil_TB" CssClass="input povinne-pole" runat="server" Text='<%# Bind("cil") %>' Width="220px" MaxLength="80" />
                                <br />
                                <wc:TLabel ID="TLabel21" runat="server" Text="[%Země%]:" Visible='<%# KSProgram.Zakaznik.HasModul(KSProgram.AppModul.SluzebniCesty) %>' />
                                <telerik:RadDropDownList ID="cil_zeme_DDL" SkinID="povinne-pole" runat="server" SelectedValue='<%# Bind("cil_zeme") %>' Visible='<%# KSProgram.Zakaznik.HasModul(KSProgram.AppModul.SluzebniCesty) %>'
                                    DataSourceID="ODS_CisZemi" DataTextField="zeme_display" DataValueField="zeme" Width="120px" DropDownHeight="300px" DropDownWidth="200px"
                                    OnClientSelectedIndexChanged="OnCilZemeDDLChanged">
                                </telerik:RadDropDownList>
                            </td>
                            <td>
                                <wc:TLabel ID="Label7" runat="server" Text="[%Místo%]:" />
                                &nbsp;
                            <%--<wc:TTextBox ID="kon_misto_TB" CssClass="input povinne-pole" runat="server" 
                               Text='<%# Bind("kon_misto") %>' Width="170px"   MaxLength="40" />--%>

                                <telerik:RadComboBox ID="kon_misto_TB" runat="server" SkinID="povinne-pole" Text='<%# Bind("kon_misto") %>' Width="170px" MaxLength="40"
                                    AllowCustomText="True"
                                    DataSourceID="ODS_vychoziMisto" >
                                </telerik:RadComboBox>
                            </td>
                        </tr>
                        <tr>
                            <td class="border1pxR" style="width: 30%;">
                                <wc:TLabel ID="Label3" runat="server" Text="[%Datum%]:" />
                                <wc:TRadDatePicker ID="dat_od_TB" SkinID="povinne-pole" runat="server"
                                    DbSelectedDate='<%# Bind("dat_od") %>' Width="100px" DateInput-MaxLength="10"
                                    ClientEvents-OnDateSelected="Hl_dat_od_DateSelected" />
                                <%--OnSelectedDateChanged="FV_SlcHlavicka_dat_od_TB_TextChanged" DateInput-AutoPostBack="True"--%>
                            
                            </td>
                            <td>
                                <wc:TLabel ID="Label8" runat="server" Text="[%Datum%]:" />
                                <wc:TRadDatePicker ID="dat_do_TB" SkinID="povinne-pole" runat="server"
                                    DbSelectedDate='<%# Bind("dat_do") %>' Width="100px" DateInput-MaxLength="10" />

                            </td>
                        </tr>
                        <tr>
                            <td class="border1pxR border1pxB" style="width: 30%;">
                                <wc:TLabel ID="Label4" runat="server" Text="[%Čas%]:" />
                                &nbsp;&nbsp;&nbsp;
                            <wc:TTextBox ID="cas_od_TB" CssClass="input povinne-pole" runat="server" MaxLength="5"
                                Text='<%# Bind("cas_od") %>' Width="45px" onkeypress="CasKeyPress(this, event)" onkeyup="CasKeyUp(this, event)" onblur="CasChange(this, event)" ToolTip="hh:mm" />
                            </td>
                            <td class="border1pxR border1pxB" style="width: 40%;">
                                <wc:TLabel ID="Label6" runat="server" Text="[%Účel%]:" />&nbsp;
                            <wc:TTextBox ID="ucel_TB" CssClass="input povinne-pole" runat="server"
                                Text='<%# Bind("ucel") %>' Width="220px" MaxLength="80" />
                            </td>
                            <td class="border1pxB">
                                <wc:TLabel ID="Label11" runat="server" Text="[%Čas%] ([%pesimistický odhad%]):" />
                                &nbsp;&nbsp;&nbsp;
                            <wc:TTextBox ID="cas_do_TB" CssClass="input povinne-pole" runat="server" MaxLength="5"
                                Text='<%# Bind("cas_do") %>' Width="45px" onkeypress="CasKeyPress(this, event)" onkeyup="CasKeyUp(this, event)" onblur="CasChange(this, event)" ToolTip="hh:mm" />
                            </td>
                        </tr>
                    </table>
                    <table class="celpad4 widthA4" style="margin: 0px; border-collapse: collapse;">
                        <tr>
                            <td style="text-align: left">
                                <wc:TLabel ID="spolucestující_t_Lab" runat="server" Text="[%Spolucestující%]:" />
                                <wc:TLabel ID="TLabel6" runat="server" Text="([%zadávejte jméno ve tvaru příjmení mezera jméno%]):" Font-Italic="True" />
                            </td>
                            <td colspan="6">

                                <asp:HiddenField ID="spolucestujici_HF" runat="server" Value='<%# Bind("spolucestujici") %>' />

                                <asp:HiddenField ID="spolu1_HF" runat="server" Value='<%# Bind("spolu1") %>' />
                                <asp:HiddenField ID="spolu2_HF" runat="server" Value='<%# Bind("spolu2") %>' />
                                <asp:HiddenField ID="spolu3_HF" runat="server" Value='<%# Bind("spolu3") %>' />
                                <asp:HiddenField ID="spolu4_HF" runat="server" Value='<%# Bind("spolu4") %>' />
                                <asp:HiddenField ID="spolu5_HF" runat="server" Value='<%# Bind("spolu5") %>' />
                                <asp:HiddenField ID="spolu6_HF" runat="server" Value='<%# Bind("spolu6") %>' />
                                <asp:HiddenField ID="spolu7_HF" runat="server" Value='<%# Bind("spolu7") %>' />
                                <asp:HiddenField ID="spolu8_HF" runat="server" Value='<%# Bind("spolu8") %>' />
                                <asp:HiddenField ID="spolu9_HF" runat="server" Value='<%# Bind("spolu9") %>' />
                                <asp:HiddenField ID="spolu10_HF" runat="server" Value='<%# Bind("spolu10") %>' />

                                <wc:TTextBox ID="spolu1_TB" runat="server"
                                    OnTextChanged="FV_SlcHlavicka_spoluX_TB_Changed"
                                    Text='<%# (Eval("spolu1") is Decimal)?KSProgram.Funkce.Pracovnik.PrijmeniJmeno((decimal)Eval("spolu1")):"" %>'
                                    Width="10em" AutoPostBack="True" />
                                <cc1:AutoCompleteExtender ID="ACExt_spolu1_TB"
                                    runat="server" DelimiterCharacters="" Enabled="True" MinimumPrefixLength="1"
                                    ServiceMethod="CompleteJmeno" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                    TargetControlID="spolu1_TB" UseContextKey="True">
                                </cc1:AutoCompleteExtender>

                                <wc:TTextBox ID="spolu2_TB" runat="server" OnTextChanged="FV_SlcHlavicka_spoluX_TB_Changed" Text='<%# (Eval("spolu2") is Decimal)?KSProgram.Funkce.Pracovnik.PrijmeniJmeno((decimal)Eval("spolu2")):"" %>' Width="10em" AutoPostBack="True" />
                                <cc1:AutoCompleteExtender ID="ACExt_spolu2_TB"
                                    runat="server" DelimiterCharacters="" Enabled="True" MinimumPrefixLength="1"
                                    ServiceMethod="CompleteJmeno" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                    TargetControlID="spolu2_TB" UseContextKey="True">
                                </cc1:AutoCompleteExtender>

                                <wc:TTextBox ID="spolu3_TB" runat="server" OnTextChanged="FV_SlcHlavicka_spoluX_TB_Changed" Text='<%# (Eval("spolu3") is Decimal)?KSProgram.Funkce.Pracovnik.PrijmeniJmeno((decimal)Eval("spolu3")):"" %>' Width="10em" AutoPostBack="True" />
                                <cc1:AutoCompleteExtender ID="ACExt_spolu3_TB"
                                    runat="server" DelimiterCharacters="" Enabled="True" MinimumPrefixLength="1"
                                    ServiceMethod="CompleteJmeno" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                    TargetControlID="spolu3_TB" UseContextKey="True">
                                </cc1:AutoCompleteExtender>
                                <wc:TTextBox ID="spolu4_TB" runat="server" OnTextChanged="FV_SlcHlavicka_spoluX_TB_Changed" Text='<%# (Eval("spolu4") is Decimal)?KSProgram.Funkce.Pracovnik.PrijmeniJmeno((decimal)Eval("spolu4")):"" %>' Width="10em" AutoPostBack="True" />
                                <cc1:AutoCompleteExtender ID="AutoCompleteExtender1"
                                    runat="server" DelimiterCharacters="" Enabled="True" MinimumPrefixLength="1"
                                    ServiceMethod="CompleteJmeno" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                    TargetControlID="spolu4_TB" UseContextKey="True">
                                </cc1:AutoCompleteExtender>

                                <wc:TTextBox ID="spolu5_TB" runat="server" OnTextChanged="FV_SlcHlavicka_spoluX_TB_Changed" Text='<%# (Eval("spolu5") is Decimal)?KSProgram.Funkce.Pracovnik.PrijmeniJmeno((decimal)Eval("spolu5")):"" %>' Width="10em" AutoPostBack="True" />
                                <cc1:AutoCompleteExtender ID="AutoCompleteExtender2"
                                    runat="server" DelimiterCharacters="" Enabled="True" MinimumPrefixLength="1"
                                    ServiceMethod="CompleteJmeno" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                    TargetControlID="spolu5_TB" UseContextKey="True">
                                </cc1:AutoCompleteExtender>

                                <wc:TTextBox ID="spolu6_TB" runat="server" OnTextChanged="FV_SlcHlavicka_spoluX_TB_Changed" Text='<%# (Eval("spolu6") is Decimal)?KSProgram.Funkce.Pracovnik.PrijmeniJmeno((decimal)Eval("spolu6")):"" %>' Width="10em" AutoPostBack="True" />
                                <cc1:AutoCompleteExtender ID="AutoCompleteExtender3"
                                    runat="server" DelimiterCharacters="" Enabled="True" MinimumPrefixLength="1"
                                    ServiceMethod="CompleteJmeno" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                    TargetControlID="spolu6_TB" UseContextKey="True">
                                </cc1:AutoCompleteExtender>

                                <wc:TTextBox ID="spolu7_TB" runat="server" OnTextChanged="FV_SlcHlavicka_spoluX_TB_Changed" Text='<%# (Eval("spolu7") is Decimal)?KSProgram.Funkce.Pracovnik.PrijmeniJmeno((decimal)Eval("spolu7")):"" %>' Width="10em" AutoPostBack="True" />
                                <cc1:AutoCompleteExtender ID="AutoCompleteExtender4"
                                    runat="server" DelimiterCharacters="" Enabled="True" MinimumPrefixLength="1"
                                    ServiceMethod="CompleteJmeno" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                    TargetControlID="spolu7_TB" UseContextKey="True">
                                </cc1:AutoCompleteExtender>

                                <wc:TTextBox ID="spolu8_TB" runat="server" OnTextChanged="FV_SlcHlavicka_spoluX_TB_Changed" Text='<%# (Eval("spolu8") is Decimal)?KSProgram.Funkce.Pracovnik.PrijmeniJmeno((decimal)Eval("spolu8")):"" %>' Width="10em" AutoPostBack="True" />
                                <cc1:AutoCompleteExtender ID="AutoCompleteExtender5"
                                    runat="server" DelimiterCharacters="" Enabled="True" MinimumPrefixLength="1"
                                    ServiceMethod="CompleteJmeno" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                    TargetControlID="spolu8_TB" UseContextKey="True">
                                </cc1:AutoCompleteExtender>

                                <wc:TTextBox ID="spolu9_TB" runat="server" OnTextChanged="FV_SlcHlavicka_spoluX_TB_Changed" Text='<%# (Eval("spolu9") is Decimal)?KSProgram.Funkce.Pracovnik.PrijmeniJmeno((decimal)Eval("spolu9")):"" %>' Width="10em" AutoPostBack="True" />
                                <cc1:AutoCompleteExtender ID="AutoCompleteExtender6"
                                    runat="server" DelimiterCharacters="" Enabled="True" MinimumPrefixLength="1"
                                    ServiceMethod="CompleteJmeno" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                    TargetControlID="spolu9_TB" UseContextKey="True">
                                </cc1:AutoCompleteExtender>

                                <wc:TTextBox ID="spolu10_TB" runat="server" OnTextChanged="FV_SlcHlavicka_spoluX_TB_Changed" Text='<%# (Eval("spolu10") is Decimal)?KSProgram.Funkce.Pracovnik.PrijmeniJmeno((decimal)Eval("spolu10")):"" %>' Width="10em" AutoPostBack="True" />
                                <cc1:AutoCompleteExtender ID="AutoCompleteExtender7"
                                    runat="server" DelimiterCharacters="" Enabled="True" MinimumPrefixLength="1"
                                    ServiceMethod="CompleteJmeno" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                    TargetControlID="spolu10_TB" UseContextKey="True">
                                </cc1:AutoCompleteExtender>
                            </td>
                        </tr>
                        <tr>
                            <td style="text-align: left">
                                <wc:TLabel ID="druh_dopr_t_Lab" runat="server" Text="[%Určený dopravní prostředek%]:" />
                            </td>
                            <td class="style13" colspan="6">
                                <wc:TCheckBoxList ID="druh_dopr_ChBL" CssClass="povinne-pole" runat="server"
                                    DataSourceID="ODS_druhDopr" DataTextField="cely_nazev" DataValueField="kod"
                                    SelectedValues='<%# Bind("druh_dopr") %>' RepeatColumns="3"
                                    AutoPostBack="True"
                                    OnSelectedIndexChanged="FV_SlcHlavicka_druh_dopr_ChBL_SelectedIndexChanged">
                                </wc:TCheckBoxList>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="7">

                                <%--<asp:Panel ID="Pnl_vozidlo" runat="server">--%>
                                <table style="width: 100%">
                                    <tr>
                                        <td style="text-align: left">
                                            <b>
                                                <wc:TLabel ID="udaje_o_voz_t_Lab" runat="server" Text="[%Údaje o vozidle%]:" /></b>
                                        </td>
                                        <td style="text-align: left;" colspan="3">
                                            <asp:CheckBox ID="cbx_jen_dostupne" runat="server" Text="[%Omezit seznam na dostupná vozidla v daném termínu%]" AutoPostBack="True" />
                                        </td>
                                        <td>&nbsp;</td>
                                        <td style="text-align: right">&nbsp;</td>
                                        <td>&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td style="text-align: right">
                                            <wc:TLabel ID="voz_nazev_Lab" runat="server" Text="[%Vozidlo%]:" />
                                        </td>
                                        <td colspan="2">
                                            <%--<telerik:RadDropDownList ID="spz_sluz_DDL" runat="server" DataSourceID="ODS_spzSluz" DataTextField="cely_nazev" DataValueField="spz" 
                                             AutoPostBack="True" 
                                             Width="24em" SelectedValue='<%# DataBinder.Eval(Container.DataItem, "spz_sluz") %>'
                                            onselectedindexchanged="FV_SlcHlavicka_Vuz_DDL_SelectedIndexChanged" 
                                            ToolTip="[%Seznam je omezen na dostupná vozidla v daném termínu%]" >
                                        </telerik:RadDropDownList>
                                        <wc:TRadButton ID="RB_sluzDDL_refresh" runat="server" Text="" ToolTip="[%Obnovit%]"
                                             CausesValidation="False" AutoPostBack="True" CommandName="sluzDDL_refresh" CssClass="rbRefresh">
                                        </wc:TRadButton>
                                        <telerik:RadDropDownList ID="spz_vlast_DDL" runat="server" AutoPostBack="True" 
                                            DataSourceID="ODS_spzVlast" DataTextField="cely_nazev" DataValueField="spz" 
                                            Width="24em" SelectedValue='<%# DataBinder.Eval(Container.DataItem, "spz_vlast") %>'
                                            onselectedindexchanged="FV_SlcHlavicka_Vuz_DDL_SelectedIndexChanged" >
                                        </telerik:RadDropDownList>--%>
                                            <telerik:RadDropDownList ID="spz_DDL" runat="server" DataSourceID="ODS_spz" DataTextField="cely_nazev" DataValueField="spz"
                                                AutoPostBack="True"
                                                Width="24em" SelectedValue='<%# DataBinder.Eval(Container.DataItem, "spz") %>'
                                                OnSelectedIndexChanged="FV_SlcHlavicka_Vuz_DDL_SelectedIndexChanged">
                                            </telerik:RadDropDownList>
                                            <wc:TRadButton ID="RB_spzDDL_refresh" runat="server" Text="" ToolTip="[%Obnovit%]"
                                                CausesValidation="False" AutoPostBack="True" CommandName="spzDDL_refresh" Icon-PrimaryIconCssClass="fi fi-rotate-right">
                                            </wc:TRadButton>
                                            <wc:TRadButton ID="RB_najdi_auto" runat="server" Icon-PrimaryIconCssClass="fi fi-car-building" ToolTip="[%Přehled cest vozidel%]"
                                                CausesValidation="False" AutoPostBack="False" IdPrava="304" OnClientClicked="reloadRadWinCesty">
                                            </wc:TRadButton>
                                            <wc:TRadButton ID="RB_new_vozidlo" runat="server" Text="+" ToolTip="[%Žádost o přidání vozidla%]" Width="2em"
                                                CausesValidation="False" AutoPostBack="False" IdPrava="377" OnClientClicked="new_vozidlo">
                                            </wc:TRadButton>
                                        </td>
                                        <td style="text-align: right;">
                                            <wc:TLabel ID="spz_t_Lab" runat="server" Text="[%SPZ%]:" />
                                        </td>
                                        <td>
                                            <wc:TTextBox ID="spz_TB" runat="server" MaxLength="9" Text='<%# Bind("spz") %>' Width="8em" OnTextChanged="FV_SlcHlavicka_spz_TextChanged" AutoPostBack="True"
                                                onchange="this.value=value.toUpperCase().replace(/[^A-Z 0-9]+/g,'')" />
                                            <%--PR 22.05.2019 ruším onkeyup="this.value=value.toUpperCase().replace(/[^A-Z 0-9]+/g,'')"
                                            protože MS EDGE následně neprovede onchange a ani tedy postback--%>                                   
                                        </td>
                                        <td>
                                            <wc:TLabel ID="cislo_poj_t_Lab" runat="server" Text="[%Číslo pojistky%]:" ToolTip="[%Číslo havarijního pojištění%]" />
                                        </td>
                                        <td>
                                            <wc:TTextBox ID="cislo_poj_TB" runat="server" MaxLength="15" Text='<%# Bind("cislo_poj") %>' Width="8em" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="text-align: right">
                                            <wc:TLabel ID="pohonna_hmota_t_Lab" runat="server" Text="[%Pohonná hmota%]:" />
                                        </td>
                                        <td>
                                            <%--AutoPostBack="True" onselectedindexchanged="FV_SlcHlavicka_pohonna_hmota_DDL_SelectedIndexChanged"--%>
                                            <telerik:RadDropDownList ID="pohonna_hmota_DDL" runat="server" AppendDataBoundItems="True"
                                                DataSourceID="ODS_PHM" DataTextField="nazev"
                                                DataValueField="nazev"
                                                SelectedValue='<%# Bind("pohonna_hmota") %>'>
                                            </telerik:RadDropDownList>
                                        </td>
                                        <td>
                                            <wc:TLabel ID="spotreba_t_Lab" runat="server" Text="[%Spotřeba%]:" />
                                        </td>
                                        <td style="text-align: left;" colspan="4">&nbsp;<wc:TLabel ID="spotreba_mesto_t_Lab" runat="server" Text="-[%město%]:" />
                                            <wc:TTextBox ID="spotreba_mesto_TB" runat="server"
                                                Text='<%# Bind("spotreba_mesto") %>' Width="4em" MaxLength="5" />
                                            &nbsp;&nbsp;<wc:TLabel ID="spotreba_mimo_t_Lab" runat="server" Text="-[%mimo město%]:" />
                                            <wc:TTextBox ID="spotreba_mimo_TB" runat="server"
                                                Text='<%# Bind("spotreba_mimo") %>' Width="4em" MaxLength="5" />
                                            &nbsp;&nbsp;
                                        <wc:TLabel ID="prum_spotreba_t_Lab" runat="server" Text="-[%kombinovaná%]:" />
                                            <wc:TTextBox ID="prum_spotreba_TB" runat="server"
                                                Text='<%# Bind("prum_spotreba") %>' Width="4em" MaxLength="5" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="text-align: left;" colspan="7">
                                            <asp:CheckBox ID="cbx_platne_poj" runat="server" Checked='<%# Bind("platne_poj") %>' Text="[%Potvrzuji, že vozidlo má platné povinné ručení a havarijní pojištění%]" Font-Bold="True" />
                                        </td>
                                    </tr>
                                </table>
                                <%--</asp:Panel>--%>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 105px; text-align: left">
                                <wc:TLabel ID="TLabel8" runat="server" Text="[%Kapesné%]:" Visible='<%# of_KapesneZahrSeznamVyplneno() || of_KapesneTuzSeznamVyplneno() %>' />
                            </td>
                            <td colspan="2">
                                <wc:TLabel ID="TLabel9" runat="server" Text="[%tuzemsko%]:" Visible='<%# of_KapesneTuzSeznamVyplneno() %>' />
                                <telerik:RadDropDownList ID="kapes_t_proc_DDL" runat="server" Width="4em" Visible='<%# of_KapesneTuzSeznamVyplneno() %>'
                                    DataSourceID="ODS_kapes_t_proc" DataTextField="value" DataValueField="value"
                                    SelectedValue='<%# Bind("kapes_t_proc") %>'>
                                </telerik:RadDropDownList>
                                <wc:TLabel ID="TLabel13" runat="server" Text="%" Visible='<%# of_KapesneTuzSeznamVyplneno() %>' />
                            </td>
                            <td colspan="2">
                                <wc:TLabel ID="kapes_proc_Lab1" runat="server" Text="[%zahraničí%]:" Visible='<%# of_KapesneZahrSeznamVyplneno() && CPjeZahranicni %>' />
                                <telerik:RadDropDownList ID="kapes_proc_DDL" runat="server" Width="4em" Visible='<%# of_KapesneZahrSeznamVyplneno() && CPjeZahranicni %>'
                                    DataSourceID="ODS_kapes_proc" DataTextField="value" DataValueField="value"
                                    SelectedValue='<%# Bind("kapes_proc") %>'>
                                </telerik:RadDropDownList>
                                <wc:TLabel ID="kapes_proc_Lab2" runat="server" Text="%" Visible='<%# of_KapesneZahrSeznamVyplneno() && CPjeZahranicni %>' />
                            </td>
                            <td colspan="2"></td>
                        </tr>
                        <tr>
                            <td colspan="7">
                                <wc:TLabel ID="TLabel22" runat="server" Text="[%Předpokládané náklady%]:" TextSK="Predpokladané náklady" />
                                <div style="vertical-align: middle; display: inline-block">
                                    <wc:TTextBox ID="predp_nakl_TB" runat="server" Text='<%# Bind("predp_nakl") %>' Width="5em" />
                                </div>
                                <telerik:RadDropDownList ID="predp_nakl_mena_DDL" runat="server" SelectedValue='<%# Bind("predp_nakl_mena") %>' DropDownHeight="300px" DropDownWidth="250px"
                                    DataSourceID="ODS_CisKodMeny" DataTextField="kod_a_nazev" DataValueField="kod" Width="60px">
                                </telerik:RadDropDownList>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="7">
                                <wc:TLabel ID="pzn_Lab" runat="server"
                                    Text="[%Poznámka%]:" />
                                <wc:TTextBox ID="pzn_TB" runat="server"
                                    Text='<%# Bind("pzn") %>' Width="780px" MaxLength="120" />

                                <asp:HiddenField ID="souhl_dne_HF" runat="server" Value='<%# Bind("souhl_dne") %>' />
                                <asp:HiddenField ID="povolil_dne_HF" runat="server" Value='<%# Bind("povolil_dne") %>' />
                                <asp:HiddenField ID="povolil_osc_HF" runat="server" Value='<%# Bind("povolil_osc") %>' />
                            </td>
                        </tr>

                                <asp:TableRow runat="server" CssClass="noborder" Visible='<%# KSProgram.Zakaznik.IsCurrent("ACO")%>'>
                                    <asp:TableCell runat="server" ColumnSpan="7">
                                        <br />
                                        <wc:TLabel ID="tit_L" runat="server" Text="[%Je nutné zařídit%]:" Font-Bold="True" />
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow runat="server" CssClass="noborder" Visible='<%# KSProgram.Zakaznik.IsCurrent("ACO")%>'>
                                    <asp:TableCell runat="server" ColumnSpan="7" >
                                        <asp:CheckBox ID="let_ChB" runat="server" Checked='<%# Bind("let") %>' Text="[%Letenka%]" Visible="false" ></asp:CheckBox>
                                        
                                        <wc:TLabel ID="let_odj_L" runat="server" Text="&nbsp;[%Odlet%]:&nbsp;" Visible="false" />
                                                                                
                                        <wc:TRadDatePicker ID="let_o_RDP" runat="server" Visible="false"
                                            DbSelectedDate='<%# Bind("let_o") %>' Width="100px" DateInput-MaxLength="10" />
                                        <wc:TTextBox ID="let_oti_TB" runat="server" Text='<%# Bind("let_oti") %>' Visible="false" Width="80px" MaxLength="13" />

                                        <wc:TLabel ID="let_prj_L" runat="server" Text="&nbsp;[%Přílet%]:&nbsp;" Visible="false" />
                                        
                                        <wc:TRadDatePicker ID="let_p_RDP" runat="server" Visible="false"
                                            DbSelectedDate='<%# Bind("let_p") %>' Width="100px" DateInput-MaxLength="10" />
                                        <wc:TTextBox ID="let_pti_TB" runat="server" Text='<%# Bind("let_pti") %>' Visible="false" Width="80px" MaxLength="13" />
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow runat="server" CssClass="noborder" Visible='<%# KSProgram.Zakaznik.IsCurrent("ACO")%>'>
                                    <asp:TableCell runat="server" ColumnSpan="7">
                            			<asp:CheckBox ID="ubyt_ChB" runat="server" Checked='<%# Bind("ubyt") %>' Text="[%Ubytování%]&nbsp;" Visible="true" ></asp:CheckBox>
                            			<asp:CheckBox ID="aut_puj_ChB" runat="server" Checked='<%# Bind("aut_puj") %>' Text="[%Zapůjčení auta%]&nbsp;" Visible="false" ></asp:CheckBox>
							            <asp:CheckBox ID="mdata_ChB" runat="server" Checked='<%# Bind("mdata") %>' Text="[%Mobilní data v zahraniční%]&nbsp;" Visible="false" ></asp:CheckBox>
                            			<asp:CheckBox ID="vizum_ChB" runat="server" Checked='<%# Bind("vizum") %>' Text="[%Vízum%]" Visible="false" ></asp:CheckBox>
                                    </asp:TableCell>
                                </asp:TableRow>
                                <asp:TableRow runat="server" CssClass="noborder" Visible='<%# KSProgram.Zakaznik.IsCurrent("ACO")%>'>
                                    <asp:TableCell runat="server" ColumnSpan="7">
                                        <wc:TLabel ID="TLabel24" runat="server" Text="[%Ostatní požadavky%]:" />
                                        <wc:TTextBox ID="ost_TB" runat="server" Text='<%# Bind("ost") %>' Width="780px" Height="50px" MaxLength="512" TextMode="MultiLine" />
                                    </asp:TableCell>
                                </asp:TableRow>

                        <tr>
                            <td colspan="7">
                                <asp:CustomValidator ID="HlavickaValidator" runat="server" OnServerValidate="FV_SlcHlavicka_validate" ErrorMessage="[%Chybně vyplněné údaje, nelze pokračovat%]" ValidationGroup="Hlavicka"></asp:CustomValidator>
                            </td>
                        </tr>
                        <%--<tr>   Úplně ruším, protože při novém CP (ať už přes požadavky nebo přes SC) se musí volat metoda CP.Uloz, jinak se neuloží zálohy
                        <td>
                            <wc:TRadButton ID="Hl_InsertButton" runat="server" CausesValidation="True" 
                                Visible='<%# (ShowNewButton || (PozId!=null && PozId>0)) %>'
                                CommandName="Insert" Text="[%Uložit%]" IdPrava='<%# KSProgram.Zakaznik.HasModul(KSProgram.AppModul.SluzebniCesty)?148:0 %>'  ValidationGroup="Hlavicka" />
                        </td>
                        <td class="style33" colspan="2">
                            <wc:TRadButton ID="Hl_InsertCancelButton" runat="server" CausesValidation="False" 
                                Visible='<%# (ShowNewButton || (PozId!=null && PozId>0)) %>'
                                CommandName="Cancel" Text="[%Neuložit%]"   />
                        </td>
                    </tr>--%>
                    </table>
                </InsertItemTemplate>

            </asp:FormView>
        </td>
    </tr>
    <tr>
        <td>
            <asp:ObjectDataSource ID="ODS_SlcZalohy" runat="server"
                OldValuesParameterFormatString="original_{0}"
                TypeName="KSProgram.Sluzebky.SlcZalohy"
                SelectMethod="Select"
                InsertMethod="Insert"
                UpdateMethod="Update"
                DeleteMethod="Delete">
                <SelectParameters>
                    <asp:ControlParameter Name="tabulka" Type="String" DefaultValue="sluz_cesty" ControlID="HF_tabulka" PropertyName="Value" />
                    <asp:ControlParameter ControlID="HF_EvCislo" Name="ev_cislo" PropertyName="Value" Type="Int32" DefaultValue="0" />
                    <asp:Parameter Name="pocetPrazdnychRadku" Type="Int32" DefaultValue="1" />
                </SelectParameters>
                <%--<InsertParameters>
          <asp:ControlParameter Name="tabulka" Type="String" DefaultValue="sluz_cesty" ControlID="HF_tabulka" PropertyName="Value" />
          <asp:ControlParameter ControlID="HF_EvCislo" Name="ev_cislo" PropertyName="Value" Type="Int32" DefaultValue="0"/>
          <asp:Parameter Name="id" Type="Int32" Direction="Output" />
          <asp:Parameter Name="druh" Type="String" />
          <asp:Parameter Name="castka" Type="Decimal" />
          <asp:Parameter Name="mena" Type="String" />
          <asp:Parameter Name="poz_dne" Type="DateTime" />
          <asp:Parameter Name="poz_osc" Type="Decimal" />
          <asp:Parameter Name="schv_dne" Type="DateTime" />
          <asp:Parameter Name="schv_osc" Type="Decimal" />
          <asp:Parameter Name="vypl_dne" Type="DateTime" />
          <asp:Parameter Name="vypl_osc" Type="Decimal" />
          <asp:Parameter Name="vypl_jak" Type="String" />
          <asp:Parameter Name="vypl_doklad" Type="String" />
       </InsertParameters>--%>
                <UpdateParameters>
                    <asp:ControlParameter Name="tabulka" Type="String" DefaultValue="sluz_cesty" ControlID="HF_tabulka" PropertyName="Value" />
                    <asp:ControlParameter ControlID="HF_EvCislo" Name="ev_cislo" PropertyName="Value" Type="Int32" DefaultValue="0" />
                    <asp:Parameter Name="original_id" Type="Int32" />
                    <asp:Parameter Name="id" Type="Int32" />
                    <asp:Parameter Name="druh" Type="String" />
                    <asp:Parameter Name="castka" Type="Decimal" />
                    <asp:Parameter Name="mena" Type="String" />
                    <asp:Parameter Name="poz_dne" Type="DateTime" />
                    <asp:Parameter Name="poz_osc" Type="Decimal" />
                    <asp:Parameter Name="schv_dne" Type="DateTime" />
                    <asp:Parameter Name="schv_osc" Type="Decimal" />
                    <asp:Parameter Name="vypl_dne" Type="DateTime" />
                    <asp:Parameter Name="vypl_osc" Type="Decimal" />
                    <asp:Parameter Name="vypl_jak" Type="String" />
                    <asp:Parameter Name="vypl_doklad" Type="String" />
                    <asp:Parameter Name="cis_bk" Type="String" />
                </UpdateParameters>
                <%--<DeleteParameters>
            <asp:ControlParameter Name="tabulka" Type="String" DefaultValue="sluz_cesty" ControlID="HF_tabulka" PropertyName="Value" />
            <asp:Parameter Name="original_id" Type="Int32" />
       </DeleteParameters>--%>
            </asp:ObjectDataSource>

            <wc:TObjectDataSource ID="ODS_cis_bk" runat="server"
                OldValuesParameterFormatString="original_{0}"
                TypeName="KSProgram.Sluzebky.SlcCisZpusPlat"
                SelectMethod="SelectKarty" EnableCaching="True" CacheExpirationPolicy="Sliding" CacheDuration="600"><%-- --%>
                <SelectParameters>
                    <asp:ControlParameter Name="os_cislo" Type="Decimal" ControlID="HF_CpOsc" PropertyName="Value" DefaultValue="0" />
                    <%--<asp:Parameter Name="os_cislo" Type="Decimal" DefaultValue="0"/>--%> <%--TEST--%>
                </SelectParameters>
            </wc:TObjectDataSource>

            <asp:ListView ID="LV_Zalohy" runat="server" DataSourceID="ODS_SlcZalohy" DataKeyNames="id"
                OnItemCommand="LV_Zalohy_ItemCommand" OnPreRender="LV_Zalohy_PreRender" Visible="false">
                <%--OnDataBinding="LV_Zalohy_DataBinding"--%>
                <LayoutTemplate>
                    <table id="itemPlaceholderContainer" runat="server" border="1" class="border1px celpad4 widthA4"
                        style="background-color: #FFFFFF; border-collapse: collapse;">
                        <tr>
                            <td class="theme_header border1px" colspan="9">
                                <wc:TLabel ID="Lab_zalohy" runat="server" CssClass="cp_nadpis" Text="[%ZÁLOHY a výběry hotovosti kartou%]" Width="100%" />
                            </td>
                        </tr>
                        <tr>
                            <td class="border1px tiskHide"></td>
                            <td class="border1px">
                                <wc:TLabel ID="Label28" runat="server" Text="[%Částka%]" Font-Bold="True" /></td>
                            <td class="border1px">
                                <wc:TLabel ID="Label29" runat="server" Text="[%Měna%]" Font-Bold="True" /></td>
                            <td class="border1px">
                                <wc:TLabel ID="Label30" runat="server" Text="[%Účel%]" Font-Bold="True" /></td>
                            <td class="border1px">
                                <wc:TLabel ID="Label31" runat="server" Text="[%Požádal%]" Font-Bold="True" /></td>
                            <td class="border1px">
                                <wc:TLabel ID="Label32" runat="server" Text="[%Schválil%]" Font-Bold="True" /></td>
                            <td class="border1px">
                                <wc:TLabel ID="Label33" runat="server" Text="[%Vyplatil%]" Font-Bold="True" /></td>
                            <td class="border1px">
                                <wc:TLabel ID="Label34" runat="server" Text="[%Způsob vyplacení%]" Font-Bold="True" /></td>
                            <td class="border1px">
                                <wc:TLabel ID="Label35" runat="server" Text="[%Čís. dokladu%]" Font-Bold="True" /></td>
                        </tr>
                        <tr id="itemPlaceholder" runat="server">
                        </tr>
                        <tr class="tiskHide">
                            <td class="border1px" style="text-align: center">
                                <wc:TRadButton ID="Zal_AddBtn" runat="server" CommandName="AddRadek" IdPrava="100"
                                    CausesValidation="False" Icon-PrimaryIconCssClass="fi fi-add" Visible="false" ToolTip="[%Nový řádek%]" />
                            </td>
                            <td colspan="9" class="border1px" style="text-align: center">
                                <asp:CustomValidator ID="ZalohyValidator" runat="server" OnServerValidate="LV_Zalohy_validate" ErrorMessage="[%Chybně vyplněné údaje, nelze pokračovat%]" Display="Dynamic" ValidationGroup="Zalohy"></asp:CustomValidator>
                            </td>
                        </tr>
                        <tr class="tiskHide">
                            <td colspan="9" class="border1px">
                                <%--<wc:TRadButton ID="Zal_EditBtn" runat="server" Text="[%Editovat%]" CommandName="EditAll"  IdPrava="100" 
                                 CausesValidation="False" Visible='<%# ((ShowNewButton || (PozId!=null && PozId>0))) %>' />
                                &nbsp;                                
                                <wc:TRadButton ID="Zal_UpdateBtn" runat="server" Text="[%Uložit%]" CommandName="UpdateAll" IdPrava="100" 
                                 CausesValidation="True" Visible="false" ValidationGroup="Zalohy" />
                                &nbsp;
                                <wc:TRadButton ID="Zal_CancelBtn" runat="server" Text="[%Neuložit%]" CommandName="CancelAll" IdPrava="100" 
                                 CausesValidation="False" Visible="false" />--%>
                                <%-- //PR 10.3.2017 při novém CP (ať už přes požadavky nebo přes SC) se musí volat metoda CP.Uloz, jinak se při uložení hlavičky neuloží zálohy--%>
                                <wc:TRadButton ID="Zal_EditBtn" runat="server" Text="[%Editovat%]" CommandName="EditAll" IdPrava="100"
                                    CausesValidation="False" Visible='<%# (EvCislo>0) %>' Icon-PrimaryIconCssClass="fi fi-edit" CssClass="editovatButton" />
                                &nbsp;                                
                                <wc:TRadButton ID="Zal_UpdateBtn" runat="server" Text="[%Uložit%]" CommandName="UpdateAll" IdPrava="100"
                                    CausesValidation="True" Visible="false" ValidationGroup="Zalohy" Icon-PrimaryIconCssClass="fi fi-disk" CssClass="ulozitButton" />
                                &nbsp;
                                <wc:TRadButton ID="Zal_CancelBtn" runat="server" Text="[%Neuložit%]" CommandName="CancelAll" IdPrava="100"
                                    CausesValidation="False" Visible="false" Icon-PrimaryIconCssClass="fi fi-floppy-disk-circle-xmark" />
                            </td>
                        </tr>
                    </table>
                </LayoutTemplate>
                <ItemTemplate>
                    <tr>
                        <td class="border1px tiskHide" style="text-align: center">
                            <wc:TRadButton ID="Zal_DelBtn" runat="server" CommandName="DelRadek" IdPrava="100"
                                CausesValidation="False" Icon-PrimaryIconCssClass="fi fi-ban" Visible='<%# IsInEditMode(LV_Zalohy)%>' ToolTip="[%Smazat%]" />
                        </td>
                        <td class="border1px">
                            <asp:HiddenField ID="id_HF" runat="server" Value='<%# Bind("id") %>' />
                            <asp:HiddenField ID="zauct_dne_HF" runat="server" Value='<%# Eval("zauct_dne") %>' />
                            <wc:TTextBox ID="castka_TB" CssClass="input povinne-pole" runat="server" Text='<%# Bind("castka") %>' Width="60px" Visible='<%# IsInEditMode(LV_Zalohy)%>'></wc:TTextBox>
                            <asp:Label ID="castka_Lab" runat="server" Text='<%# Eval("castka") %>' Visible='<%# !IsInEditMode(LV_Zalohy)%>'></asp:Label>
                        </td>
                        <td class="border1px">
                            <telerik:RadDropDownList ID="mena_DDL" SkinID="povinne-pole" runat="server" SelectedValue='<%# Bind("mena") %>' DropDownHeight="300px" DropDownWidth="250px"
                                DataSourceID="ODS_CisKodMeny" DataTextField="kod_a_nazev" DataValueField="kod" Width="60px" Visible='<%# IsInEditMode(LV_Zalohy)%>'>
                            </telerik:RadDropDownList>
                            <asp:Label ID="mena_Lab" runat="server" Text='<%# Eval("mena") %>' Visible='<%# !IsInEditMode(LV_Zalohy)%>'></asp:Label>
                        </td>
                        <td class="border1px">
                            <telerik:RadDropDownList ID="druh_DDL" runat="server" SelectedValue='<%# Bind("druh") %>'
                                DataSourceID="ODS_SlcCisCnSAutGen" DataTextField="nazev" DataValueField="druh" Visible='<%# IsInEditMode(LV_Zalohy)%>'>
                            </telerik:RadDropDownList>
                            <asp:Label ID="druh_display_Lab" runat="server" Text='<%# Eval("druh_display") %>' Visible='<%# !IsInEditMode(LV_Zalohy)%>'></asp:Label>
                        </td>
                        <td class="border1px">
                            <asp:HiddenField ID="poz_osc_HF" runat="server" Value='<%# Bind("poz_osc") %>' Visible='<%# IsInEditMode(LV_Zalohy)%>' />
                            <asp:Label ID="poz_osc_display_Lab" runat="server" Text='<%# Eval("poz_osc_display") %>' Visible='<%# !IsInEditMode(LV_Zalohy)%>'></asp:Label>
                            <asp:HiddenField ID="poz_dne_HF" runat="server" Value='<%# Bind("poz_dne", "{0:d}") %>' Visible='<%# IsInEditMode(LV_Zalohy)%>' />
                            <asp:Label ID="poz_dne_Lab" runat="server" Text='<%# Eval("poz_dne", "{0:d.M.yyyy}") %>' Visible='<%# !IsInEditMode(LV_Zalohy)%>'></asp:Label>
                        </td>
                        <td class="border1px">
                            <asp:HiddenField ID="schv_osc_HF" runat="server" Value='<%# Bind("schv_osc") %>' Visible='<%# IsInEditMode(LV_Zalohy)%>' />
                            <asp:Label ID="schv_osc_display_Lab" runat="server" Text='<%# Eval("schv_osc_display") %>' Visible='<%# !IsInEditMode(LV_Zalohy)%>'></asp:Label>
                            <asp:HiddenField ID="schv_dne_HF" runat="server" Value='<%# Bind("schv_dne", "{0:d}") %>' Visible='<%# IsInEditMode(LV_Zalohy)%>' />
                            <asp:Label ID="schv_dne_Lab" runat="server" Text='<%# Eval("schv_dne", "{0:d.M.yyyy}") %>' Visible='<%# !IsInEditMode(LV_Zalohy)%>'></asp:Label>
                        </td>
                        <td class="border1px">
                            <asp:HiddenField ID="vypl_dne_HF" runat="server" Value='<%# Bind("vypl_dne", "{0:d}") %>' Visible='<%# IsInEditMode(LV_Zalohy)%>' />
                            <asp:Label ID="vypl_dne_Lab" runat="server" Text='<%# Eval("vypl_dne", "{0:d.M.yyyy}") %>' Visible='<%# !IsInEditMode(LV_Zalohy)%>'></asp:Label>
                            <asp:HiddenField ID="vypl_osc_HF" runat="server" Value='<%# Bind("vypl_osc") %>' Visible='<%# IsInEditMode(LV_Zalohy)%>' />
                            <asp:Label ID="vypl_osc_display_Lab" runat="server" Text='<%# Eval("vypl_osc_display") %>' Visible='<%# !IsInEditMode(LV_Zalohy)%>'></asp:Label>
                        </td>
                        <td class="border1px">
                            <telerik:RadDropDownList ID="vypl_jak_DDL" runat="server" SelectedValue='<%# Bind("vypl_jak") %>' OnClientSelectedIndexChanged="ZalVyplJakOnChange"
                                DataSourceID="ODS_ZpusPlatZal" DataTextField="nazev" DataValueField="pl" Visible='<%# IsInEditMode(LV_Zalohy)%>' Width="120px">
                            </telerik:RadDropDownList>
                            <asp:Label ID="vypl_jak_display_Label" runat="server" Text='<%# Eval("vypl_jak_display") %>' Visible='<%# !IsInEditMode(LV_Zalohy)%>'></asp:Label>
                            <%----%>
                            <telerik:RadDropDownList ID="cis_bk_DDL" runat="server" SelectedValue='<%# Bind("cis_bk") %>' ToolTip="[%Platební karta%]" Width="120px" DropDownWidth="200px"
                                DataSourceID="ODS_cis_bk" DataTextField="naz_prukazu" DataValueField="cis_prukazu" Visible='<%# IsInEditMode(LV_Zalohy)%>'>
                            </telerik:RadDropDownList>
                            <asp:Label ID="cis_bk_Label" runat="server" Text='<%# Eval("cis_bk") %>' Visible='<%# !IsInEditMode(LV_Zalohy)%>'></asp:Label>
                        </td>
                        <td class="border1px">
                            <wc:TTextBox ID="vypl_doklad_TB" runat="server" Text='<%# Bind("vypl_doklad") %>' Visible='<%# IsInEditMode(LV_Zalohy)%>' MaxLength="20"></wc:TTextBox>
                            <asp:Label ID="vypl_doklad_Lab" runat="server" Text='<%# Eval("vypl_doklad") %>' Visible='<%# !IsInEditMode(LV_Zalohy)%>'></asp:Label>
                        </td>
                    </tr>
                </ItemTemplate>
            </asp:ListView>
        </td>

    </tr>
    <tr>
        <td>


            <wc:TObjectDataSource ID="ODS_CisZemi" runat="server"
                OldValuesParameterFormatString="original_{0}"
                TypeName="KSProgram.Sluzebky.SlcCisZemi"
                SelectMethod="Select" EnableCaching="True" CacheDuration="6000">
                <%--//PR 30.08.2024 caching prodloužen a přidán parametr CultureName, protože by nefungoval uživatelský překlad dat--%>
                <%--<SelectParameters>
                    <asp:SessionParameter Name="CultureName" SessionField="CultureName" Type="String" />
                </SelectParameters>--%>
            </wc:TObjectDataSource>
            <asp:ObjectDataSource ID="ODS_SlcPrubeh" runat="server"
                OldValuesParameterFormatString="original_{0}"
                TypeName="KSProgram.Sluzebky.SlcPrubeh"
                SelectMethod="Select"
                UpdateMethod="Update">
                <SelectParameters>
                    <asp:ControlParameter ControlID="HF_EvCislo" Name="ev_cislo" PropertyName="Value" Type="Int32" DefaultValue="0" />
                    <asp:Parameter Name="pocetPrazdnychRadku" Type="Int32" DefaultValue="1" />
                </SelectParameters>
                <UpdateParameters>
                    <asp:ControlParameter Name="ev_cislo" ControlID="HF_EvCislo" PropertyName="Value" Type="Int32" DefaultValue="0" />
                    <asp:Parameter Name="orig_radek" Type="Int32" />
                    <asp:Parameter Name="radek" Type="Int32" />
                    <asp:Parameter Name="poradi" Type="Int32" />
                    <asp:Parameter Name="udalost" Type="String" />
                    <asp:Parameter Name="datum" Type="DateTime" />
                    <asp:Parameter Name="cas" Type="String" />
                    <asp:Parameter Name="misto" Type="String" />
                    <asp:Parameter Name="zeme_od" Type="String" />
                    <asp:Parameter Name="zeme_do" Type="String" />
                    <asp:Parameter Name="dopr_prost" Type="String" />
                    <asp:Parameter Name="km_mesto" Type="Decimal" />
                    <asp:Parameter Name="km_mimo" Type="Decimal" />
                    <asp:Parameter Name="km_komb" Type="Decimal" />
                    <asp:Parameter Name="vzdalenost" Type="Decimal" />
                </UpdateParameters>

            </asp:ObjectDataSource>

            <asp:ListView ID="LV_Prubeh" runat="server"
                OnItemCommand="LV_Prubeh_ItemCommand" OnDataBound="LV_Prubeh_DataBound"
                OnPreRender="LV_Prubeh_PreRender">
                <%-- DataSourceID="ODS_SlcPrubeh"--%>

                <LayoutTemplate>
                    <table id="itemPlaceholderContainer" runat="server" border="1" class="border1px celpad4 widthA4"
                        style="background-color: #FFFFFF; border-collapse: collapse;">
                        <tr>
                            <td colspan="6" class="theme_header">
                                <table style="border-collapse: collapse; border-width:0px; width:100%">
                                    <tr>
                                        <td style="width:33%">

                                        </td>
                                        <td style="width:33%">
                                            <wc:TLabel ID="Lab_prubeh" runat="server" CssClass="cp_nadpis" Text="[%PRŮBĚH%]" />
                                        </td>
                                        <td  style="text-align: right" >
                                            <wc:TLabel ID="Lab_schvalil" runat="server" CssClass="cp_podpis" Text="" />
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td class="tiskHide border1px" style="text-align: center"></td>
                            <td class="border1px" style="width: 100px;">
                                <wc:TLabel ID="udalost_Lab" runat="server" Text="[%Událost%]" Font-Bold="True" />
                            </td>
                            <td class="border1px" style="width: 70px;">
                                <wc:TLabel ID="datum_Lab" runat="server" Text="[%Datum%]" Font-Bold="True" />
                            </td>
                            <td class="border1px" style="width: 30px;">
                                <wc:TLabel ID="cas_Lab" runat="server" Text="[%Místní čas%]" Font-Bold="True" />
                            </td>
                            <td class="border1px" style="width: 475px;">
                                <wc:TLabel ID="misto_Lab" runat="server" Text="[%Místo%]" Font-Bold="True" />
                            </td>
                            <td class="border1px" style="width: 75px;">
                                <wc:TLabel ID="dopr_prost_Lab" runat="server" Text="[%Použitý dopr. prostř.%]" Font-Bold="True" />
                                <hr />
                                <wc:TLabel ID="vzdalenost_lab" runat="server" Text="[%Ujeté km%]" Font-Bold="True" />
                            </td>
                        </tr>
                        <tr id="itemPlaceholder" runat="server" />

                        <tr class="tiskHide">
                            <td class="border1px" style="text-align: right">
                                <%--<wc:TRadButton ID="Prb_AddBtn" runat="server"  CommandName="AddRadek"  IdPrava="100" 
                                 CausesValidation="False" Icon-PrimaryIconCssClass="fi fi-plus" Width="22px" Visible="false" ToolTip="[%Nový řádek%]"/>--%>

                                <wc:TRadButton ID="Prb_AddBtn" runat="server" CommandName="" IdPrava="100"
                                    CausesValidation="False" Icon-PrimaryIconCssClass="fi fi-add" Visible="false" ToolTip="[%Nový řádek%]" AutoPostBack="False" OnClientClicked="PrubehAddRow" />
                            </td>
                            <td colspan="5" class="border1px" style="text-align: center">
                                <asp:CustomValidator ID="PrubehValidator" runat="server" OnServerValidate="LV_Prubeh_validate" ErrorMessage="[%Chybně vyplněné údaje, nelze pokračovat%]" Display="Dynamic"></asp:CustomValidator>
                                <asp:Label ID="Prb_TipLabel" runat="server" Text="[%Poznámka%]: [%Přechod hranic, začátek a konec přerušení nebo pracovní výkonu se zadává pomocí pole událost%]." Visible="false" />

                            </td>
                        </tr>
                        <tr class="tiskHide" bgcolor="#F0F0F0">
                            <td colspan="6" class="border1pxT border1pxR border1pxL">
                                <div style="padding: 4px">
                                    <asp:Label ID="dupl_L" runat="server" Text="[%Duplikovat označené řádky%]:" Visible="false" />
                                    <wc:TTextBox ID="dupl_TB" runat="server" Text="5" Visible="false" Width="25px" />
                                    <asp:Label ID="dupl2_L" runat="server" Text="[%krát%]" Visible="false" />
                                    <wc:TRadButton ID="Prb_DuplBtn" runat="server" CommandName="DuplRows" IdPrava="100"
                                        CausesValidation="False" Visible="false" Text="[%Proveď%]" />
                                </div>
                                <div style="padding: 4px">
                                    <div style="float: left; padding-right:8px">
                                        <asp:Label ID="import_L" runat="server" Text="Import XLSX, CSV:" Visible="false" />
                                    </div>
                                    <div style="float: left">
                                        <telerik:RadAsyncUpload runat="server" ID="RAUploadXLS" MaxFileSize="2097152" MultipleFileSelection="Disabled"
                                            HideFileInput="False" TemporaryFolder="~/Temp" AllowedFileExtensions="csv,xlsx"
                                            Visible="false" AutoAddFileInputs="False" MaxFileInputsCount="1"
                                            Localization-Cancel="Zrušit" Localization-DropZone="Přetáhni soubor sem" Localization-Remove="Odstraň" Localization-Select="Vyber" Width="400px"
                                            OnClientValidationFailed="OnRadUploadClientValidationFailed" InputSize="120" />
                                        <%--OnFileUploaded="RAUploadXLS_FileUploaded" OnClientFileUploaded="OnClientFileUploaded"--%>
                                    </div>
                                    <div style="float: left">
                                        <wc:TRadButton ID="Prb_ImportBtn" runat="server" CommandName="ImportFile" IdPrava="100"
                                            CausesValidation="False" Width="60px" Visible="false" Text="[%Import%]" />
                                    </div>
                                </div>
                                <div style="padding: 4px; float: right">
                                    <wc:TRadButton ID="Prb_TCars" runat="server" CommandName="ImportTCars" IdPrava="100"
                                            CausesValidation="False" Width="120px" Visible="false" Text="[%Import jízd z T-Cars%]" />
                                </div>
                            </td>
                        </tr>
                        <tr class="tiskHide">
                            <td colspan="5" class="border1px">
                                <wc:TRadButton ID="Prb_EditBtn" runat="server" Text="[%Editovat%]" CommandName="EditAll" IdPrava="100" Icon-PrimaryIconCssClass="fi fi-edit"
                                    CausesValidation="False" CssClass="editovatButton" />
                                &nbsp;
                                <wc:TRadButton ID="Prb_UpdateBtn" runat="server" Text="[%Uložit%]" CommandName="UpdateAll" Visible="false" IdPrava="100" Icon-PrimaryIconCssClass="fi fi-disk"
                                    CausesValidation="True" CssClass="ulozitButton" />
                                &nbsp;
                                <wc:TRadButton ID="Prb_CancelBtn" runat="server" Text="[%Neuložit%]" CommandName="CancelAll" Visible="false" IdPrava="100" Icon-PrimaryIconCssClass="fi fi-floppy-disk-circle-xmark"
                                    CausesValidation="False" />
                            </td>
                            <td class="border1px" style="width: 100px; text-align: center">
                                <a onclick="window.open(getRouteURL('google'),'scroutegg');return false;" title='<%= WebControlHelper.ZmenaTextu("[%Zobrazit trasu na mapě%]") %>' 
                                    style="text-decoration: underline; cursor: pointer">Google Mapy</a>
                            </td>
                        </tr>
                    </table>
                </LayoutTemplate>
                <ItemTemplate>
                    <tr id="ItemRow" runat="server">
                        <%-- funguje bgcolor='<%# Convert.ToBoolean(Container.DataItemIndex % 2) ? "Red" : "Blue" %>'--%>
                        <td class="tiskHide border1px" style="text-align: center">
                            <table>
                                <tr>
                                    <td style="padding: 0px">
                                        <asp:Label ID="cisrad_Lab" runat="server" Text="" Visible='<%# IsInEditMode(LV_Prubeh)%>' />
                                        <asp:CheckBox ID="cbx_sel" runat="server" Visible='<%# IsInEditMode(LV_Prubeh)%>' />
                                    </td>
                                    <td style="padding: 0px">
                                        <%--<wc:TRadButton ID="Prb_InsBtn" runat="server"  CommandName="InsRadek"  IdPrava="100" 
                                        CausesValidation="False" Icon-PrimaryIconCssClass="fi fi-plus" Width="22px" Visible='<%# IsInEditMode(LV_Prubeh)%>' ToolTip="[%Vložit řádek před%]"/>--%>
                                        <wc:TRadButton ID="Prb_InsBtn" runat="server" CommandName="InsRadek" IdPrava="100" AutoPostBack="False" OnClientClicked="PrubehInsertRow"
                                            CausesValidation="False" Icon-PrimaryIconCssClass="fi fi-add" Visible='<%# IsInEditMode(LV_Prubeh)%>' ToolTip="[%Vložit řádek před%]" />
                                        <%--<wc:TRadButton ID="Prb_DelBtn" runat="server"  CommandName="DelRadek"  IdPrava="100" 
                                        CausesValidation="False" Icon-PrimaryIconCssClass="fi fi-ban" Width="22px" Visible='<%# IsInEditMode(LV_Prubeh)%>' ToolTip="[%Smazat%]"/>--%>
                                        <wc:TRadButton ID="Prb_DelBtn" runat="server" CommandName="DelRadek" IdPrava="100" AutoPostBack="False" OnClientClicked="PrubehDeleteRow"
                                            CausesValidation="False" Icon-PrimaryIconCssClass="fi fi-ban" Visible='<%# IsInEditMode(LV_Prubeh)%>' ToolTip="[%Smazat%]" />
                                    </td>
                                </tr>
                            </table>
                        </td>
                        <td class="border1px">
                            <asp:HiddenField ID="orig_radek_HF" runat="server" Value='<%# Bind("orig_radek") %>' />
                            <asp:HiddenField ID="radek_HF" runat="server" Value='<%# Bind("radek") %>' />
                            <asp:HiddenField ID="poradi_HF" runat="server" Value='<%# Bind("poradi") %>' />
                            <asp:HiddenField ID="udalost_HF" runat="server" Value='<%# Eval("udalost") %>' />
                            <telerik:RadDropDownList CssClass="povinne-pole" ID="udalost_DDL" runat="server" Width="100px" AppendDataBoundItems="True" TabIndex='<%# 1 + (100*Container.DataItemIndex) %>'
                                SelectedValue='<%# Bind("udalost") %>' AutoPostBack="false" OnClientSelectedIndexChanged="OnUdalostChanged"
                                Visible='<%# IsInEditMode(LV_Prubeh)%>'>
                                <%--OnSelectedIndexChanged="LV_Prubeh_udalost_DDL_SelectedIndexChanged"--%>
                                <Items>
                                    <telerik:DropDownListItem Value="O" Text="[%Odjezd%]" />
                                    <telerik:DropDownListItem Value="H" Text="[%Přech. hranice%]" Enabled='<%# CPjeZahranicni %>' />
                                    <telerik:DropDownListItem Value="P" Text="[%Příjezd%]" />
                                    <telerik:DropDownListItem Value="V" Text="[%Zač. prac. výk.%]" />
                                    <telerik:DropDownListItem Value="K" Text="[%Kon. prac. výk.%]" />
                                    <telerik:DropDownListItem Value="R" Text="[%Zač. přerušení%]" />
                                    <telerik:DropDownListItem Value="U" Text="[%Kon. přerušení%]" />
                                </Items>
                            </telerik:RadDropDownList>
                            <asp:Label ID="udalost_Lab" runat="server" Text='<%# Eval("udalost_display") %>' Visible='<%# !IsInEditMode(LV_Prubeh)%>' />
                        </td>
                        <td class="border1px">
                            <wc:TRadDatePicker ID="datum_TB" SkinID="povinne-pole" runat="server" DbSelectedDate='<%# Bind("datum") %>' Width="100px"
                                DateInput-MaxLength="10" TabIndex='<%# 2 + (100*Container.DataItemIndex) %>' DateInput-MinDate="1.1.0001 0:00:00"
                                Visible='<%# IsInEditMode(LV_Prubeh)%>' />
                            <asp:Label ID="datum_Lab" runat="server" Text='<%# Eval("datum", "{0:d.M.yyyy}") %>' Width="65px"
                                Visible='<%# !IsInEditMode(LV_Prubeh)%>' />
                        </td>
                        <td class="border1px">
                            <wc:TTextBox ID="cas_TB" CssClass="input povinne-pole" runat="server" Text='<%# Bind("cas") %>' Width="40px" MaxLength="5" TabIndex='<%# 1 + (3+100*Container.DataItemIndex) %>'
                                Visible='<%# IsInEditMode(LV_Prubeh)%>' onkeypress="CasKeyPress(this, event)" onkeyup="CasKeyUp(this, event)" onblur="CasChange(this, event)" ToolTip="hh:mm"></wc:TTextBox>


                            <asp:Label ID="cas_Lab" runat="server" Text='<%# Eval("cas") %>' Width="40px" Visible='<%# !IsInEditMode(LV_Prubeh)%>' />
                        </td>
                        <td class="border1px" style="white-space: nowrap;">
                            <div style="vertical-align: middle; display: inline-block">
                                <wc:TTextBox ID="misto_TB" CssClass="input povinne-pole" runat="server"
                                    Text='<%# Bind("misto") %>' Width="255px" MaxLength="40" TabIndex='<%# 4 + (100*Container.DataItemIndex) %>'
                                    Visible='<%# IsInEditMode(LV_Prubeh)%>'></wc:TTextBox>
                                <cc1:AutoCompleteExtender ID="misto_TB_AutoCompleteExtender"
                                    runat="server" DelimiterCharacters="" Enabled="True"
                                    ServiceMethod="GetObecCompletionList" ServicePath="~/PrivateWebServices/AutoCompleteService.asmx"
                                    TargetControlID="misto_TB" UseContextKey="True" MinimumPrefixLength="2">
                                </cc1:AutoCompleteExtender>
                            </div>
                            <asp:Label ID="misto_Lab" runat="server" Text='<%# Eval("misto") %>' Width="255px" Visible='<%# !IsInEditMode(LV_Prubeh)%>' />

                            <asp:Label ID="zeme_od_Lab" runat="server" Text='<%# Eval("zeme_od") %>' Visible="false" /><%--nepřeložená země--%>
                            <asp:Label ID="zeme_od_display_Lab" runat="server" Text='<%# Eval("zeme_od_display") %>' Width="85px"
                                Visible='<%# !IsInEditMode(LV_Prubeh) && (Eval("udalost").Equals("O") || Eval("udalost").Equals("H") || Eval("udalost").Equals("P")) %>' />

                            <telerik:RadDropDownList ID="zeme_od_DDL" SkinID="povinne-pole" runat="server" SelectedValue='<%# Bind("zeme_od") %>'
                                DataSourceID="ODS_CisZemi" DataTextField="zeme_display" DataValueField="zeme" Width="120px" DropDownHeight="300px" DropDownWidth="200px"
                                TabIndex='<%# 5 + (100*Container.DataItemIndex) %>'
                                Visible='<%# IsInEditMode(LV_Prubeh) %>' CssClass='<%# CPjeZahranicni ? "povinne-pole" : "hidden" %>' OnClientSelectedIndexChanged="OnZemeOdDDLChanged">
                            </telerik:RadDropDownList>
                            <%--Visible='<%# IsInEditMode(LV_Prubeh) && CPjeZahranicni %>'--%>
                            &nbsp; 

                            <asp:Label ID="zeme_sipka_Lab" runat="server" Text=">" Width="13px" Font-Bold="True" />

                            <asp:Label ID="zeme_do_Lab" runat="server" Text='<%# Eval("zeme_do") %>' Visible="false" /><%--nepřeložená země--%>
                            <asp:Label ID="zeme_do_display_Lab" runat="server" Text='<%# Eval("zeme_do_display") %>' Visible='<%# !IsInEditMode(LV_Prubeh) && !Eval("zeme_do").Equals(Eval("zeme_od")) %>' Width="85px" />

                            <telerik:RadDropDownList ID="zeme_do_DDL" SkinID="povinne-pole" runat="server" SelectedValue='<%# Bind("zeme_do") %>'
                                DataSourceID="ODS_CisZemi" DataTextField="zeme_display" DataValueField="zeme" Width="120px" DropDownHeight="300px" DropDownWidth="200px"
                                Visible='<%# IsInEditMode(LV_Prubeh) %>' CssClass='<%# CPjeZahranicni ? "povinne-pole" : "hidden" %>' TabIndex='<%# 12 + (100*Container.DataItemIndex) %>'>
                            </telerik:RadDropDownList>
                            <%--Visible='<%# IsInEditMode(LV_Prubeh) && CPjeZahranicni %>'--%> 
                        </td>

                        <td class="border1px" style="text-align: right">

                            <asp:Label ID="dopr_prost_Lab" runat="server" Text='<%# Eval("dopr_prost") %>' Width="40px" Visible='<%# !IsInEditMode(LV_Prubeh) && Eval("udalost").Equals("O") %>' />
                            <%--<cis:DdlDoprProstredky ID="dopr_prost_DDL" CssClass="povinne-pole" runat="server" AppendDataBoundItems="True" Visible='<%# IsInEditMode(LV_Prubeh)%>'
                                SelectedValue='<%# Bind("dopr_prost") %>' Width="60px" TabIndex='<%# 13 + (100*Container.DataItemIndex) %>'
                                AutoPostBack="false" DropDownWidth="220px" OnClientSelectedIndexChanged="OnDoprProstChanged" >                            
                            </cis:DdlDoprProstredky>--%>
                            <telerik:RadDropDownList ID="dopr_prost_DDL" CssClass="povinne-pole" runat="server" AppendDataBoundItems="True" Visible='<%# IsInEditMode(LV_Prubeh)%>'
                                DataSourceID="ODS_druhDopr" DataTextField="cely_nazev" DataValueField="kod"
                                SelectedValue='<%# Bind("dopr_prost") %>' Width="80px" TabIndex='<%# 13 + (100*Container.DataItemIndex) %>'
                                AutoPostBack="false" DropDownWidth="220px" OnClientSelectedIndexChanged="OnDoprProstChanged">
                            </telerik:RadDropDownList>

                            <asp:Label ID="km_mesto_Lab" runat="server" Text='<%# Eval("km_mesto") %>' Visible='<%# !IsInEditMode(LV_Prubeh) && KSProgram.Zakaznik.IsSR() && (Eval("udalost").Equals("H") || Eval("udalost").Equals("P")) %>' Width="30px" />
                            <wc:TTextBox ID="km_mesto_TB" runat="server" Text='<%# Bind("km_mesto") %>' Visible='<%# IsInEditMode(LV_Prubeh) && KSProgram.Zakaznik.IsSR() %>' CssClass="input" Width="30px" ToolTip="ve městě" TabIndex='<%# 14 + (100*Container.DataItemIndex) %>'></wc:TTextBox>
                            <asp:Label ID="breakkm1" runat="server" Text='<%# (KSProgram.Zakaznik.IsSR() )?"<br/>":"" %>'></asp:Label>

                            <asp:Label ID="km_mimo_Lab" runat="server" Text='<%# Eval("km_mimo") %>' Visible='<%# !IsInEditMode(LV_Prubeh) && KSProgram.Zakaznik.IsSR() && (Eval("udalost").Equals("H") || Eval("udalost").Equals("P")) %>' Width="30px" />
                            <wc:TTextBox ID="km_mimo_TB" runat="server" Text='<%# Bind("km_mimo") %>' Visible='<%# IsInEditMode(LV_Prubeh) && KSProgram.Zakaznik.IsSR() %>' CssClass="input" Width="30px" ToolTip="mimo město" TabIndex='<%# 15 + (100*Container.DataItemIndex) %>'></wc:TTextBox>
                            <asp:Label ID="breakkm2" runat="server" Text='<%# (KSProgram.Zakaznik.IsSR() )?"<br/>":"" %>'></asp:Label>

                            <asp:Label ID="km_komb_Lab" runat="server" Text='<%# Eval("km_komb") %>' Visible='<%# !IsInEditMode(LV_Prubeh) && KSProgram.Zakaznik.IsSR() && (Eval("udalost").Equals("H") || Eval("udalost").Equals("P")) %>' Width="30px" />
                            <wc:TTextBox ID="km_komb_TB" runat="server" Text='<%# Bind("km_komb") %>' Visible='<%# IsInEditMode(LV_Prubeh) && KSProgram.Zakaznik.IsSR() %>' CssClass="input" Width="30px" ToolTip="v kombinovaném režimu" TabIndex='<%# 16 + (100*Container.DataItemIndex) %>'></wc:TTextBox>
                            <asp:Label ID="breakkm3" runat="server" Text='<%# (KSProgram.Zakaznik.IsSR() )?"<br/>":"" %>'></asp:Label>

                            <asp:Label ID="vzdalenost_Lab" runat="server" Text='<%# Eval("vzdalenost") %>' Visible='<%# !IsInEditMode(LV_Prubeh) && !KSProgram.Zakaznik.IsSR() && (Eval("udalost").Equals("H") || Eval("udalost").Equals("P")) %>' Width="40px" />
                            <wc:TTextBox ID="vzdalenost_TB" runat="server" Text='<%# Bind("vzdalenost") %>' Visible='<%# IsInEditMode(LV_Prubeh) && !KSProgram.Zakaznik.IsSR() %>' CssClass="input" Width="40px" TabIndex='<%# 17 + (100*Container.DataItemIndex) %>'></wc:TTextBox>

                        </td>

                    </tr>
                </ItemTemplate>
            </asp:ListView>
            <asp:CustomValidator ID="VarrocPrubehValidator" runat="server" OnServerValidate="Varroc_Prubeh_validate" ErrorMessage="[%Chybně vyplněné údaje, nelze pokračovat%]" Display="Dynamic"></asp:CustomValidator>
        </td>
    </tr>
    <tr>
        <td>
            <asp:ObjectDataSource ID="ODS_SlcStravne" runat="server"
                OldValuesParameterFormatString="original_{0}"
                TypeName="KSProgram.Sluzebky.SlcStravne"
                SelectMethod="Select"
                UpdateMethod="UpdateKraceni">
                <SelectParameters>
                    <asp:ControlParameter ControlID="HF_EvCislo" Name="ev_cislo" PropertyName="Value" Type="Int32" DefaultValue="0" />
                </SelectParameters>
                <UpdateParameters>
                    <asp:Parameter Name="original_ev_cislo" Type="Int32" />
                    <asp:Parameter Name="original_datum" Type="DateTime" />
                    <asp:Parameter Name="datum" Type="DateTime" />
                    <asp:Parameter Name="original_zeme" Type="String" />
                    <asp:Parameter Name="zeme" Type="String" />
                    <asp:Parameter Name="kraceni_s" Type="Boolean" />
                    <asp:Parameter Name="kraceni_o" Type="Boolean" />
                    <asp:Parameter Name="kraceni_v" Type="Boolean" />
                </UpdateParameters>
            </asp:ObjectDataSource>

            <asp:ListView ID="LV_Stravne" runat="server"
                DataKeyNames="ev_cislo,datum,zeme"
                Visible="false"
                OnItemCommand="LV_Stravne_ItemCommand" OnPreRender="LV_Stravne_PreRender">
                <%--DataSourceID="ODS_SlcStravne"--%>
                <LayoutTemplate>
                    <table id="itemPlaceholderContainer" runat="server" border="1" class="border1px celpad4 widthA4"
                        style="background-color: #FFFFFF; border-collapse: collapse;">
                        <tr>
                            <td colspan="9" class="theme_header border1px">
                                <wc:TLabel ID="Lab_stravne" runat="server" CssClass="cp_nadpis" Text="[%STRAVNÉ%] - [%Zadejte%] [%bezplatně poskytnuté jídlo S,O,V%]" />
                            </td>
                        </tr>
                        <tr>
                            <td class="border1px">
                                <wc:TLabel ID="Label28" runat="server" Text="[%Datum%]" Font-Bold="True" /></td>
                            <td class="border1px">
                                <wc:TLabel ID="Label29" runat="server" Text="[%Počet hodin%]" Font-Bold="True" /></td>
                            <td class="border1px">
                                <wc:TLabel ID="Label30" runat="server" Text="[%Země%]" Font-Bold="True" /></td>
                            <td class="border1px">
                                <wc:TLabel ID="Label31" runat="server" Text="[%Měna%]" Font-Bold="True" /></td>
                            <td class="border1px">
                                <wc:TLabel ID="Label32" runat="server" Text="[%Stravné%]" Font-Bold="True" /></td>
                            <td class="border1px">
                                <wc:TLabel ID="TLabel5" runat="server" Text="[%Bezplatně poskytnuté jídlo S,O,V%]" Font-Bold="True" /></td>
                            <td class="border1px">
                                <wc:TLabel ID="TLabel3" runat="server" Text="[%Stravné po krácení%]" Font-Bold="True" /></td>
                            <td class="border1px">
                                <wc:TLabel ID="TLabel4" runat="server" Text="[%Kapesné%]" Font-Bold="True" /></td>
                            <td class="border1px">
                                <wc:TLabel ID="TLabel7" runat="server" Text="[%Poznámka%]" Font-Bold="True" /></td>
                        </tr>
                        <tr id="itemPlaceholder" runat="server">
                        </tr>
                        <tr class="tiskHide">
                            <td colspan="5" class="border1px">
                                <wc:TRadButton ID="Str_EditBtn" runat="server" Text="[%Editovat%]" CommandName="EditAll" IdPrava="100" Icon-PrimaryIconCssClass="fi fi-edit"
                                    CausesValidation="False" Visible="true" CssClass="editovatButton" />
                                &nbsp;
                                <wc:TRadButton ID="Str_PrepoctiBtn" runat="server" Text="[%Přepočíst%]" CommandName="Prepocti" IdPrava="100" Icon-PrimaryIconCssClass="fi fi-refresh"
                                    CausesValidation="False" Visible="true" />
                                &nbsp;
                                <wc:TRadButton ID="Str_UpdateBtn" runat="server" Text="[%Uložit%]" CommandName="UpdateAll" IdPrava="100" Icon-PrimaryIconCssClass="fi fi-disk"
                                    CausesValidation="True" Visible="false" CssClass="ulozitButton" />
                                &nbsp;
                                <wc:TRadButton ID="Str_CancelBtn" runat="server" Text="[%Neuložit%]" CommandName="CancelAll" IdPrava="100" Icon-PrimaryIconCssClass="fi fi-floppy-disk-circle-xmark"
                                    CausesValidation="False" Visible="false" />
                            </td>
                            <td class="border1px">
                                <asp:CheckBox ID="kracAll_s_ChB" runat="server" Text="S" Visible="false" OnCheckedChanged="kracAll_X_ChB_CheckedChanged" AutoPostBack="true"></asp:CheckBox>
                                <asp:CheckBox ID="kracAll_o_ChB" runat="server" Text="O" Visible="false" OnCheckedChanged="kracAll_X_ChB_CheckedChanged" AutoPostBack="true"></asp:CheckBox>
                                <asp:CheckBox ID="kracAll_v_ChB" runat="server" Text="V" Visible="false" OnCheckedChanged="kracAll_X_ChB_CheckedChanged" AutoPostBack="true"></asp:CheckBox>
                                <wc:TLabel ID="kracAll_Lab" runat="server" Text="<br/>[%zatrhnout vše%]" Visible="false" />
                            </td>
                            <td colspan="3" class="border1px"></td>
                        </tr>
                    </table>
                </LayoutTemplate>
                <ItemTemplate>
                    <tr>
                        <td class="border1px">
                            <asp:HiddenField ID="datum_HF" runat="server" Value='<%# Bind("datum") %>' />
                            <wc:TLabel ID="datum_Label" runat="server" Text='<%# Eval("datum", "{0:d.M.yyyy}") %>'></wc:TLabel>
                        </td>
                        <td class="border1px">
                            <wc:TLabel ID="hodin_Label" runat="server" Text='<%# Eval("hodin") %>'></wc:TLabel>
                        </td>
                        <td class="border1px">
                            <wc:TTextBox ID="zeme_TB" runat="server" Text='<%# Bind("zeme") %>' MaxLength="40" Visible="false"></wc:TTextBox>
                            <wc:TLabel ID="zeme_display_Label" runat="server" Text='<%# Eval("zeme_display") %>'></wc:TLabel>
                        </td>
                        <td class="border1px">
                            <wc:TLabel ID="mena_display_Label" runat="server" Text='<%# Eval("mena_display") %>'></wc:TLabel>
                        </td>
                        <td class="border1px">
                            <wc:TLabel ID="strav_pred_krac_Label" runat="server" Text='<%# Eval("strav_pred_krac") %>'></wc:TLabel>
                        </td>
                        <td class="border1px">
                            <asp:CheckBox ID="kraceni_s_ChB" runat="server" Checked='<%# Bind("kraceni_s") %>' Text="S" Enabled='<%# IsInEditMode(LV_Stravne)%>'></asp:CheckBox>
                            <asp:CheckBox ID="kraceni_o_ChB" runat="server" Checked='<%# Bind("kraceni_o") %>' Text="O" Enabled='<%# IsInEditMode(LV_Stravne)%>'></asp:CheckBox>
                            <asp:CheckBox ID="kraceni_v_ChB" runat="server" Checked='<%# Bind("kraceni_v") %>' Text="V" Enabled='<%# IsInEditMode(LV_Stravne)%>'></asp:CheckBox>
                        </td>
                        <td class="border1px">
                            <wc:TLabel ID="strav_po_krac_Label" runat="server" Text='<%# Eval("strav_po_krac") %>' Visible='<%# !IsInEditMode(LV_Stravne)%>'></wc:TLabel>
                        </td>
                        <td class="border1px">
                            <wc:TLabel ID="kapesne_Label" runat="server" Text='<%# Eval("kapesne") %>'></wc:TLabel>
                        </td>
                        <td class="border1px">
                            <wc:TLabel ID="pozn_Label" runat="server" Text='<%# Eval("pozn") %>'></wc:TLabel>
                        </td>
                    </tr>
                </ItemTemplate>
                <EmptyDataTemplate>
                    <table id="LV_stravne_empty" runat="server" border="1" class="border1px celpad4 widthA4"
                        style="background-color: #FFFFFF; border-collapse: collapse;">
                        <tr>
                            <td class="theme_header border1px">
                                <wc:TLabel ID="Lab_stravne" runat="server" Text="[%STRAVNÉ%] - [%Zadejte%] [%bezplatně poskytnuté jídlo S,O,V%]" />
                            </td>
                        </tr>
                        <tr class="tiskHide">
                            <td class="border1px">
                                <wc:TRadButton ID="Str_PrepoctiBtn" runat="server" Text="[%Přepočíst%]" CommandName="Prepocti" IdPrava="100" Icon-PrimaryIconCssClass="fi fi-refresh"
                                    CausesValidation="False" Visible="true" />
                            </td>
                        </tr>
                    </table>
                </EmptyDataTemplate>
            </asp:ListView>

        </td>
    </tr>
    <tr>
        <td>
            <wc:TObjectDataSource ID="ODS_SlcCisCn" runat="server"
                OldValuesParameterFormatString="original_{0}"
                TypeName="KSProgram.Sluzebky.SlcCisCn"
                SelectMethod="SelectCNBezAutGen" EnableCaching="True" CacheDuration="6000"><%--//PR 21.6.2017 snížen caching kvůli Překladu přes slovník--%>
                <%--//PR 30.08.2024 caching prodloužen a přidán parametr CultureName, protože by nefungoval uživatelský překlad dat--%>
                <%--<SelectParameters>
                    <asp:SessionParameter Name="CultureName" SessionField="CultureName" Type="String" />
                </SelectParameters>--%>
            </wc:TObjectDataSource>
            <wc:TObjectDataSource ID="ODS_SlcCisCnSAutGen" runat="server"
                OldValuesParameterFormatString="original_{0}"
                TypeName="KSProgram.Sluzebky.SlcCisCn"
                SelectMethod="SelectCN" EnableCaching="True" CacheDuration="6000"><%--//PR 21.6.2017 snížen caching kvůli Překladu přes slovník--%>
                <%--//PR 30.08.2024 caching prodloužen a přidán parametr CultureName, protože by nefungoval uživatelský překlad dat--%>
                <%--<SelectParameters>
                    <asp:SessionParameter Name="CultureName" SessionField="CultureName" Type="String" />
                </SelectParameters>--%>
            </wc:TObjectDataSource>
            <wc:TObjectDataSource ID="ODS_CisKodMeny" runat="server"
                OldValuesParameterFormatString="original_{0}"
                TypeName="KSProgram.Sluzebky.CisKodMeny"
                SelectMethod="Select" EnableCaching="True"></wc:TObjectDataSource>
            <%--//PR 27.10.2020 Způsob platby pro zálohy--%>
            <wc:TObjectDataSource ID="ODS_ZpusPlatZal" runat="server"
                OldValuesParameterFormatString="original_{0}"
                TypeName="KSProgram.Sluzebky.SlcCisZpusPlat"
                SelectMethod="SelectProZalohy" EnableCaching="True" CacheDuration="6000">
                <%--//PR 30.08.2024 caching prodloužen a přidán parametr CultureName, protože by nefungoval uživatelský překlad dat--%>
                <%--<SelectParameters>
                    <asp:SessionParameter Name="CultureName" SessionField="CultureName" Type="String" />
                </SelectParameters>--%>
            </wc:TObjectDataSource>
            <wc:TObjectDataSource ID="ODS_SlcCisZpusPlat" runat="server"
                OldValuesParameterFormatString="original_{0}"
                TypeName="KSProgram.Sluzebky.SlcCisZpusPlat"
                SelectMethod="Select" EnableCaching="True" CacheDuration="6000"><%--//PR 21.6.2017 snížen caching kvůli Překladu přes slovník--%>
                <%--//PR 30.08.2024 caching prodloužen a přidán parametr CultureName, protože by nefungoval uživatelský překlad dat--%>
                <SelectParameters>
                    <asp:Parameter Name="agenda" Type="String" DefaultValue="SC" />
                    
                </SelectParameters>
            </wc:TObjectDataSource>
            <wc:TObjectDataSource ID="ODS_CisDPH" runat="server"
                OldValuesParameterFormatString="original_{0}"
                TypeName="KSProgram.Ciselniky.CisDPH"
                SelectMethod="Select" EnableCaching="True" CacheExpirationPolicy="Sliding" CacheDuration="600">
                <SelectParameters>
                    <asp:ControlParameter Name="datum" Type="DateTime" PropertyName="Dat_od" ControlID="CP" />
                </SelectParameters>
            </wc:TObjectDataSource>
            

            <asp:ObjectDataSource ID="ODS_SlcNahrady" runat="server"
                OldValuesParameterFormatString="original_{0}"
                TypeName="KSProgram.Sluzebky.SlcNahrady"
                SelectMethod="Select"
                UpdateMethod="Update"
                OnUpdated="ODS_SlcNahrady_Updated">
                <SelectParameters>
                    <asp:ControlParameter ControlID="HF_EvCislo" Name="ev_cislo" PropertyName="Value" Type="Int32" DefaultValue="0" />
                    <asp:Parameter Name="pocetPrazdnychRadku" Type="Int32" DefaultValue="1" />
                </SelectParameters>
                <UpdateParameters>
                    <asp:Parameter Name="original_id" Type="Int32" />
                    <asp:Parameter Name="id" Type="Int32" />
                    <asp:ControlParameter ControlID="HF_EvCislo" Name="ev_cislo" PropertyName="Value" Type="Int32" DefaultValue="0" />
                    <asp:Parameter Name="datum" Type="DateTime" />
                    <asp:Parameter Name="druh" Type="String" />
                    <asp:Parameter Name="druh_display" Type="String" />
                    <asp:Parameter Name="pl" Type="String" />
                    <asp:Parameter Name="pl_display" Type="String" />
                    <asp:Parameter Name="pozn" Type="String" />
                    <asp:Parameter Name="vydaj" Type="Decimal" />
                    <asp:Parameter Name="vydaj_mena" Type="String" />
                    <asp:Parameter Name="nahrada" Type="Decimal" />
                    <asp:Parameter Name="nahrada_zvys" Type="Decimal" />
                    <asp:Parameter Name="dphkod" Type="String" />
                    <asp:Parameter Name="naklad" Type="Decimal" />
                    <asp:Parameter Name="dph" Type="Decimal" />
                    <asp:Parameter Name="blobid1" Type="Int32" />
                    <asp:Parameter Name="blobid2" Type="Int32" />
                    <asp:Parameter Name="blobid1n" Type="String" />
                    <asp:Parameter Name="blobid2n" Type="String" />
                    <asp:Parameter Name="cis_bk" Type="String" />
                </UpdateParameters>
            </asp:ObjectDataSource>

        </td>
    </tr>
    <tr>
        <!-- vydaje -->
        <td>

            <asp:ListView ID="LV_Nahrady" runat="server"
                DataKeyNames="id"
                OnItemCommand="LV_Nahrady_ItemCommand"
                OnDataBound="LV_Nahrady_DataBound"
                OnItemUpdating="LV_Nahrady_ItemUpdating"
                OnPreRender="LV_Nahrady_PreRender">
                <%--DataSourceID="ODS_Slcnahrady"--%>
                <LayoutTemplate>
                    <table id="itemPlaceholderContainer" runat="server" border="1" class="border1px celpad4 widthA4"
                        style="background-color: #FFFFFF; border-collapse: collapse;">
                        <tr>
                            <td colspan="11" class="theme_header">
                                <table style="border-collapse: collapse; border-width:0px; width:100%">
                                    <tr>
                                        <td style="width:33%">

                                        </td>
                                        <td style="width:33%">
                                            <wc:TLabel ID="Lab_nahrady" runat="server" CssClass="cp_nadpis" Text="[%CESTOVNÍ VÝDAJE%]" />
                                        </td>
                                        <td  style="text-align: right" >
                                            <wc:TLabel ID="Lab_schvalil" runat="server" CssClass="cp_podpis" Text="" />
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td class="border1px tiskHide"></td>
                            <td class="border1px"><%--style="width: 70px;"--%>
                                <wc:TLabel ID="datum_Lab_t" runat="server" Text="[%Datum%]" Font-Bold="True" />
                            </td>
                            <td class="border1px">
                                <wc:TLabel ID="druh_Lab_t" runat="server" Text="[%Druh výdaje%]" Font-Bold="True" />
                            </td>
                            <td class="border1px">
                                <wc:TLabel ID="castka_Lab_t" runat="server" Text="[%Částka%]" Font-Bold="True" />
                            </td>
                            <td class="border1px">
                                <wc:TLabel ID="pl_Lab_t" runat="server" Text="[%Zp.pl.%]" Font-Bold="True" ToolTip="[%Způsob platby%]" />
                            </td>
                            <td class="border1px">
                                <wc:TLabel ID="poznamka_Lab_t" runat="server" Text="[%Poznámka%]" Font-Bold="True" />
                            </td>
                            <td class="border1px">
                                <wc:TLabel ID="nahrada_Lab_t" runat="server" Text="[%Náhrada%]" Font-Bold="True" />

                                <wc:TLabel ID="nahrada_zvys_t" runat="server" Text="([%Z toho nadlimit%])" Font-Bold="True" ToolTip="[%Pokud je náhrada vyšší než stanovuje zákoník práce, je v závorce nadlimit ke zdanění%]" />
                            </td>
                            <td class="border1px">
                                <wc:TLabel ID="dphkod_Lab_t" runat="server" Text="[%Kód DPH%]" Font-Bold="True" />
                            </td>
                            <td class="border1px">
                                <wc:TLabel ID="naklad_Lab_t" runat="server" Text="[%Náklad (bez DPH)%]" Font-Bold="True" />
                            </td>
                            <td class="border1px">
                                <wc:TLabel ID="dph_Lab_t" runat="server" Text="[%DPH%]" Font-Bold="True" />
                            </td>
                            <td class="border1px">
                                <wc:TLabel ID="doklady_Lab_t" runat="server" Text="[%Doklady%]" Font-Bold="True" />
                            </td>
                        </tr>

                        <tr id="itemPlaceholder" runat="server">
                        </tr>

                        <tr class="tiskHide">
                            <td class="border1px tiskHide" style="text-align: center">
                                <%--<wc:TRadButton ID="Vdj_AddBtn" runat="server"  CommandName="AddRadek"  IdPrava="100" 
                                 CausesValidation="False" Icon-PrimaryIconCssClass="rbAdd" Width="22px" Visible="false" ToolTip="[%Nový řádek%]" />--%>
                                <wc:TRadButton ID="Vdj_AddBtn" runat="server" AutoPostBack="False" OnClientClicked="NahradyAddRow" IdPrava="100"
                                    CausesValidation="False" Icon-PrimaryIconCssClass="fi fi-add" Visible="false" ToolTip="[%Nový řádek%]" />
                            </td>
                            <td colspan="10" class="border1px" style="text-align: center">

                                <asp:CustomValidator ID="NahradyValidator" runat="server" OnServerValidate="LV_Nahrady_validate" ErrorMessage="[%Chybně vyplněné údaje, nelze pokračovat%]" Display="Static" ValidateEmptyText="True"></asp:CustomValidator>

                                <%--<wc:TRadButton ID="Vdj_DelBtn" runat="server"  CommandName="DelRadek"  IdPrava="100" 
                                 CausesValidation="False" Icon-PrimaryIconCssClass="fi fi-ban" Width="22px" Visible="false" ToolTip="[%Smazat%]"/>--%>
                            </td>
                        </tr>
                        <tr>
                            <%--<td class="border1px tiskHide">
                            </td>--%>
                            <td colspan="11" class="border1px">
                                <asp:ObjectDataSource ID="ODS_SlcNahradyDalsiUdaje" runat="server"
                                    OldValuesParameterFormatString="original_{0}"
                                    TypeName="KSProgram.Sluzebky.SlcNahradyDalsiUdaje"
                                    SelectMethod="Select"
                                    UpdateMethod="Update">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HF_EvCislo" Name="ev_cislo" PropertyName="Value" Type="Int32" DefaultValue="0" />
                                    </SelectParameters>
                                    <UpdateParameters>
                                        <asp:ControlParameter ControlID="HF_EvCislo" Name="ev_cislo" PropertyName="Value" Type="Int32" DefaultValue="0" />
                                        <asp:Parameter Name="zp_vypl" Type="String" />
                                        <asp:Parameter Name="nakl_str" Type="String" />
                                        <asp:Parameter Name="cena_1l_ph" Type="Decimal" />
                                        <asp:Parameter Name="cena1lphz" Type="Decimal" />
                                        <asp:Parameter Name="cena1lphz_m" Type="String" />
                                        <asp:Parameter Name="sazba_zn" Type="Decimal" />
                                    </UpdateParameters>
                                </asp:ObjectDataSource>
                                <asp:FormView ID="FV_DalsiUdaje" runat="server" DataSourceID="ODS_SlcNahradyDalsiUdaje" Width="100%" CssClass="noborder">
                                    <%--PR 11.5.2018 fiktivní css aby tam telerik necpal rfdTable--%>
                                    <ItemTemplate>
                                        <table style="width: 100%">
                                            <tr>
                                                <td style="width: 40%">
                                                    <wc:TLabel ID="cena_1l_ph_t_Lab" runat="server" Text="[%Cena 1l PH%]:" Font-Bold="True" Visible='<%# ZobrazitCenuPHM() %>' />
                                                    <wc:TLabel ID="cena_1l_ph_Lab" runat="server" Text='<%# (!DBNull.Value.Equals(Eval("cena_1l_ph_zakon")) && (decimal)Eval("cena_1l_ph_zakon")!=0 && (decimal)Eval("cena_1l_ph") == (decimal)Eval("cena_1l_ph_zakon")) ? (Eval("cena_1l_ph") + " [%dle vyhlášky%]") : ("") %>' Visible='<%# ZobrazitCenuPHM() %>' />
                                                    <wc:TLabel ID="cena_dle_dokl_Lab" runat="server" Text='<%# (!DBNull.Value.Equals(Eval("cena_1l_ph_zakon")) && (decimal)Eval("cena_1l_ph_zakon")!=0 && (decimal)Eval("cena_1l_ph") != (decimal)Eval("cena_1l_ph_zakon")) ? (Eval("cena_1l_ph") + " [%dle dokladu%] ([%dle vyhlášky%] " + Eval("cena_1l_ph_zakon").ToString() + ")") : ("") %>' Visible='<%# ZobrazitCenuPHM() %>' ForeColor="#009933" />
                                                    <wc:TLabel ID="cena_dle_dokl_sk_Lab" runat="server" Text='<%# (!DBNull.Value.Equals(Eval("cena_1l_ph_zakon")) && (decimal)Eval("cena_1l_ph_zakon")==0) ? (Eval("cena_1l_ph") + " [%dle dokladu%]") : ("") %>' Visible='<%# ZobrazitCenuPHM() %>' />
                                                </td>
                                                <td style="width: 26%">
                                                    <wc:TLabel ID="TLabel16" runat="server" Text="[%Cena 1l PH - zahraničí%]:" Font-Bold="True" Visible='<%# ZobrazitCenuPHM() && Typ=="Z" %>' />
                                                    <wc:TLabel ID="TLabel17" runat="server" Text='<%# Eval("cena1lphz") %>' Visible='<%# ZobrazitCenuPHM() && Typ=="Z" %>' />
                                                    <wc:TLabel ID="TLabel18" runat="server" Text='<%# Eval("cena1lphz_m") %>' Visible='<%# ZobrazitCenuPHM() && Typ=="Z" %>' />
                                                </td>
                                                <td>
                                                    <wc:TLabel ID="sazba_zn_t_Lab" runat="server" Text="[%Sazba zákl. náhrady%]:" Font-Bold="True" Visible='<%# ZobrazitCenuPHM() %>' />
                                                    <wc:TLabel ID="sazba_zn_Lab" runat="server" Text='<%# Eval("sazba_zn") %>' Visible='<%# ZobrazitCenuPHM() %>' />

                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="2" style='<%# WF_UN_IS("Vydaje","NaklStr","Visible","false") ? "display:none;width: 66%": "width: 66%" %>'>
                                                    <wc:TLabel ID="Label39" runat="server" Text="[%Nákladové středisko%]:" Font-Bold="True" />
                                                    <br />
                                                    <asp:Label ID="nakl_str_Lab" runat="server" Text='<%# Bind("nakl_str_display") %>' />
                                                </td>
                                                <td style='<%# KSProgram.Zakaznik.IsCurrent("UJV_REZ_GROUP") || WF_UN_IS("Vydaje","ZpusVyrovnani","Visible","false") ? "display:none": "" %>'>
                                                    <wc:TLabel ID="Label38" runat="server" Text="[%Prosím o vyplacení výdajů%]:" Font-Bold="True" />
                                                    <asp:Label ID="zp_vypl_Lab" runat="server" Text='<%# Eval("zp_vypl_display") %>' />
                                                </td>
                                            </tr>
                                        </table>
                                    </ItemTemplate>
                                    <EditItemTemplate>
                                        <table style="width: 100%">
                                            <tr>
                                                <td style="width: 25%">
                                                    <wc:TLabel ID="cena_1l_ph_t_Lab" runat="server" Text="[%Cena 1l PH%]:" Font-Bold="True" Visible='<%# ZobrazitCenuPHM() %>' />
                                                    <wc:TTextBox ID="cena_1l_ph_TB" runat="server" Text='<%# Bind("cena_1l_ph") %>' Width="4em" MaxLength="7" Visible='<%# ZobrazitCenuPHM() %>' />
                                                </td>
                                                <td style="width: 30%">
                                                    <wc:TLabel ID="cena_1lphz_t_Lab" runat="server" Text="[%Cena 1l PH - zahraničí%]:" Font-Bold="True" Visible='<%# CPjeZahranicni && ZobrazitCenuPHM() %>' />
                                                    <wc:TTextBox ID="cena1lphz_TB" runat="server" Text='<%# Bind("cena1lphz") %>' Width="4em" MaxLength="7" Visible='<%# CPjeZahranicni && ZobrazitCenuPHM() %>' />
                                                    <telerik:RadDropDownList ID="cena1lphz_m_DDL" runat="server" SelectedValue='<%# Bind("cena1lphz_m") %>' Visible='<%# CPjeZahranicni && ZobrazitCenuPHM() %>'
                                                        DataSourceID="ODS_CisKodMeny" DataTextField="kod_a_nazev" DataValueField="kod" Width="60px" DropDownHeight="300px" DropDownWidth="250px" />
                                                </td>
                                                <td>
                                                    <wc:TLabel ID="sazba_zn_t_Lab" runat="server" Text="[%Sazba zákl. náhrady%]:"  Visible='<%# ZobrazitCenuPHM() %>' />
                                                    <wc:TTextBox ID="sazba_zn_TB" runat="server" ReadOnly="True" Enabled="false" Text='<%# Bind("sazba_zn") %>' Visible='<%# ZobrazitCenuPHM() %>' Width="4em" MaxLength="7" />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="2" style='<%# WF_UN_IS("Vydaje","NaklStr","Visible","false") ? "display:none;width: 55%": "width: 55%" %>'>
                                                    <wc:TLabel ID="Label40" runat="server" Text="[%Nákladové středisko%]:" Font-Bold="True" />
                                                    <wc:TRadComboBox ID="nakl_str_RCmb" runat="server" AllowCustomText="False" Width="250px"
                                                        DataSourceID="ODS_str" DataTextField="cely_nazev" DataValueField="str" SelectedValue='<%# Bind("nakl_str") %>' MaxHeight="300px" EnableAutomaticLoadOnDemand="False" EnableLoadOnDemand="False" LoadingMessage="Nahrávám..." MarkFirstMatch="True" Filter="Contains" ItemsPerRequest="20" EnableVirtualScrolling="True" MinFilterLength="1" CausesValidation="False"
                                                        EmptyMessage="" ToolTip="[%Vyplňte, pokud mají být náklady účtovány na jiné středisko%]"/>
                                                </td>
                                                <td style='<%# KSProgram.Zakaznik.IsCurrent("UJV_REZ_GROUP") || WF_UN_IS("Vydaje","ZpusVyrovnani","Visible","false") ? "display:none": "" %>'>
                                                    <wc:TLabel ID="Label38" runat="server" Text="[%Prosím o vyplacení výdajů%]:" Font-Bold="True" />
                                                    <telerik:RadDropDownList runat="server" ID="zp_vypl_DDL" SelectedValue='<%# Bind("zp_vypl") %>' AppendDataBoundItems="True">
                                                        <Items>
                                                            <telerik:DropDownListItem Value="" Text="" />
                                                            <telerik:DropDownListItem Value="h" Text="[%v hotovosti%]" />
                                                            <telerik:DropDownListItem Value="m" Text="[%ve mzdě%]" CssClass='<%# KSProgram.Zakaznik.IsCurrent("PHOENIX GROUP")? "hidden":"" %>' />
                                                            <telerik:DropDownListItem Value="u" Text="[%na účet%]" />
                                                        </Items>
                                                    </telerik:RadDropDownList>
                                                </td>
                                            </tr>
                                        </table>
                                    </EditItemTemplate>
                                </asp:FormView>
                            </td>
                        </tr>
                        <tr class="tiskHide">
                            <td colspan="11" class="border1px" style="vertical-align: bottom">
                                <wc:TRadButton ID="Vdj_EditBtn" runat="server" Text="[%Editovat%]" CommandName="EditAll" IdPrava="100" Icon-PrimaryIconCssClass="fi fi-edit"
                                    CausesValidation="False" CssClass="editovatButton" />
                                &nbsp;
                                <wc:TRadButton ID="Vdj_UpdateBtn" CssClass="tlacitko_Vdj_UpdateBtn kstlacitko ulozitButton" runat="server" Text="[%Uložit%]" CommandName="UpdateAll" Visible="false" IdPrava="100"
                                    CausesValidation="True" Icon-PrimaryIconCssClass="fi fi-disk"  /> <%-- ClientIDMode="Static"--%>
                                &nbsp;
                                <wc:TRadButton ID="Vdj_CancelBtn" runat="server" Text="[%Neuložit%]" CommandName="CancelAll" Visible="false" IdPrava="100"
                                    CausesValidation="False" Icon-PrimaryIconCssClass="fi fi-floppy-disk-circle-xmark" />
                                <asp:Label ID="Vdj_TipLabel" runat="server" Text="[%Poznámka%]: [%Řádky, které automaticky generuje systém (např. stravné), nelze editovat.%]" Visible="false" />
                            </td>
                        </tr>
                    </table>
                </LayoutTemplate>
                <ItemTemplate>
                    <tr id="ItemRow" runat="server" style="white-space: nowrap;">
                        <td class="border1px tiskHide" style="text-align: center">
                            
                            <wc:TRadButton ID="Vdj_DelBtn" runat="server" AutoPostBack="False" OnClientClicked="NahradyDeleteRow" Visible='<%# IsInEditMode(LV_Nahrady) %>'
                                CausesValidation="False" Icon-PrimaryIconCssClass="fi fi-ban" ToolTip="[%Smazat%]"
                                Enabled='<%# !KSProgram.Sluzebky.SlcCisCn.AutGenNahrada(Eval("druh").ToString()) %>' />

                            <asp:HiddenField ID="id_HF" runat="server" Value='<%# Bind("id") %>' />
                        </td>
                        <td class="border1px">
                            <asp:Label ID="datum_Lab" runat="server" Text='<%# Eval("datum", "{0:d.M.yyyy}") %>' Width="60px"
                                Visible='<%# !IsInEditMode(LV_Nahrady) || KSProgram.Sluzebky.SlcCisCn.AutGenNahrada(Eval("druh").ToString()) %>' />
                            <wc:TRadDatePicker ID="datum_TB" SkinID="povinne-pole" runat="server" DbSelectedDate='<%# Bind("datum") %>' DateInput-MaxLength="10" Width="100px"
                                DateInput-MinDate="1.1.0001 0:00:00"
                                Visible='<%# IsInEditMode(LV_Nahrady) && !KSProgram.Sluzebky.SlcCisCn.AutGenNahrada(Eval("druh").ToString()) %>'>
                                <ClientEvents OnPopupOpening="calendarOpening" />
                            </wc:TRadDatePicker>
                        </td>
                        <td class="border1px">
                            <asp:Label ID="druh_Lab" runat="server" Text='<%# Eval("druh_display") %>' Visible='<%# !IsInEditMode(LV_Nahrady) || KSProgram.Sluzebky.SlcCisCn.AutGenNahrada(Eval("druh").ToString()) %>' />
                            <asp:HiddenField ID="druh_old_HF" runat="server" Value='<%# Eval("druh") %>' />
                            <telerik:RadDropDownList ID="druh_DDL" SkinID="povinne-pole" runat="server" Visible='<%# IsInEditMode(LV_Nahrady) && !KSProgram.Sluzebky.SlcCisCn.AutGenNahrada(Eval("druh").ToString()) %>' SelectedValue='<%# Bind("druh") %>'
                                DataSourceID="ODS_SlcCisCn" DataTextField="nazev" DataValueField="druh" Width="180px"
                                OnClientSelectedIndexChanged="NahradaOnChange" AppendDataBoundItems="True" />
                        </td>
                        <td class="border1px" style="vertical-align: middle">
                            <asp:Label ID="vydaj_Lab" runat="server" Text='<%# Eval("vydaj") %>' Visible='<%# !IsInEditMode(LV_Nahrady) || KSProgram.Sluzebky.SlcCisCn.AutGenNahrada(Eval("druh").ToString()) %>' Width="43px" />
                            <div id="div_vpkor" runat="server" visible='<%# IsInEditMode(LV_Nahrady) %>' style="vertical-align: middle; display: inline-block">
                                <wc:TTextBox ID="vydaj_TB" runat="server" Text='<%# Bind("vydaj") %>' CssClass="input povinne-pole" Width="60px"
                                    Visible='<%# IsInEditMode(LV_Nahrady) && !KSProgram.Sluzebky.SlcCisCn.AutGenNahrada(Eval("druh").ToString()) %>'
                                    onchange="NahradaOnChange(this)" />
                            </div>
                            <asp:Label ID="mena_Lab" runat="server" Text='<%# Eval("vydaj_mena") %>' Visible='<%# !IsInEditMode(LV_Nahrady) || KSProgram.Sluzebky.SlcCisCn.AutGenNahrada(Eval("druh").ToString()) %>' />
                            <telerik:RadDropDownList ID="mena_DDL" SkinID="povinne-pole" runat="server" Visible='<%# IsInEditMode(LV_Nahrady) && !KSProgram.Sluzebky.SlcCisCn.AutGenNahrada(Eval("druh").ToString()) %>'
                                SelectedValue='<%# Bind("vydaj_mena") %>' DataSourceID="ODS_CisKodMeny" DataTextField="kod_a_nazev" DataValueField="kod" Width="53px" DropDownHeight="300px" DropDownWidth="250px"
                                OnClientSelectedIndexChanged="NahradaOnChange">
                                <ItemTemplate>
                                    <table>
                                        <tr>
                                            <td style="width: 40px">
                                                <%# DataBinder.Eval(Container, "Value") %>
                                            </td>
                                            <td>
                                                <%# DataBinder.Eval(Container, "Text").ToString().Length>4 ? DataBinder.Eval(Container, "Text").ToString().Substring(4) : "" %>
                                            </td>
                                        </tr>
                                    </table>
                                </ItemTemplate>
                            </telerik:RadDropDownList>
                        </td>
                        <td class="border1px">
                            <asp:Label ID="pl_Lab" runat="server" Text='<%# Eval("pl") %>' Visible='<%# !IsInEditMode(LV_Nahrady) || KSProgram.Sluzebky.SlcCisCn.AutGenNahrada(Eval("druh").ToString()) %>' />
                            <telerik:RadDropDownList ID="pl_DDL" SkinID="povinne-pole" runat="server" Visible='<%# IsInEditMode(LV_Nahrady) && !KSProgram.Sluzebky.SlcCisCn.AutGenNahrada(Eval("druh").ToString()) %>'
                                AppendDataBoundItems="True" SelectedValue='<%# Bind("pl") %>'
                                DataSourceID="ODS_SlcCisZpusPlat" DataTextField="nazev" DataValueField="pl" Width="120px" DropDownWidth="150px"
                                OnClientSelectedIndexChanged="NahradaOnChange" />
                            <telerik:RadDropDownList ID="cis_bk_DDL" runat="server" SelectedValue='<%# Bind("cis_bk") %>' Width="120px" DropDownWidth="200px"
                                DataSourceID="ODS_cis_bk" DataTextField="naz_prukazu" DataValueField="cis_prukazu" Visible='<%# IsInEditMode(LV_Nahrady)%>'
                                ToolTip="[%Platební karta%]">
                            </telerik:RadDropDownList>
                            <asp:Label ID="cis_bk_Label" runat="server" Text='<%# DBNull.Value.Equals(Eval("cis_bk")) ? "" : "<br/>" + Eval("cis_bk") %>' Visible='<%# !IsInEditMode(LV_Nahrady)%>'></asp:Label>
                        </td>
                        <td class="border1px">
                            <asp:Label ID="pozn_Lab" runat="server" Text='<%# Eval("pozn") %>' Visible='<%# !IsInEditMode(LV_Nahrady) || KSProgram.Sluzebky.SlcCisCn.AutGenNahrada(Eval("druh").ToString()) %>' />
                            <wc:TTextBox ID="pozn_TB" runat="server" Text='<%# Bind("pozn") %>' Visible='<%# IsInEditMode(LV_Nahrady) && !KSProgram.Sluzebky.SlcCisCn.AutGenNahrada(Eval("druh").ToString()) %>' MaxLength="45" Width="250px"></wc:TTextBox>
                        </td>
                        <td class="border1px">
                            <wc:TLabel ID="nahrada_Lab" runat="server" Text='<%# Eval("nahrada") %>' Visible='<%# !IsInEditMode(LV_Nahrady) || KSProgram.Sluzebky.SlcCisCn.AutGenNahrada(Eval("druh").ToString()) %>' />
                            <wc:TTextBox ID="nahrada_TB" runat="server" Text='<%# Bind("nahrada") %>' Visible='<%# IsInEditMode(LV_Nahrady) && !KSProgram.Sluzebky.SlcCisCn.AutGenNahrada(Eval("druh").ToString()) %>'
                                Width="60px" />

                            <wc:TLabel ID="nahrada_zvys_Lab" runat="server" Text='<%# "("+Eval("nahrada_zvys")+")" %>' Visible='<%# (!IsInEditMode(LV_Nahrady) || KSProgram.Sluzebky.SlcCisCn.AutGenNahrada(Eval("druh").ToString())) && Eval("nahrada_zvys").ToString()!="0,00" %>' />
                            <wc:TTextBox ID="nahrada_zvys_TB" runat="server" Text='<%# Bind("nahrada_zvys") %>' Visible='<%# IsInEditMode(LV_Nahrady) && !KSProgram.Sluzebky.SlcCisCn.AutGenNahrada(Eval("druh").ToString()) %>'
                                Width="60px" />
                        </td>
                        <td class="border1px">
                            <wc:TLabel ID="dphkod_Lab" runat="server" Text='<%# Eval("dphkod") %>' Visible='<%# !IsInEditMode(LV_Nahrady) || KSProgram.Sluzebky.SlcCisCn.AutGenNahrada(Eval("druh").ToString()) %>' />
                            <telerik:RadDropDownList ID="dphkod_DDL" runat="server" Visible='<%# IsInEditMode(LV_Nahrady) && !KSProgram.Sluzebky.SlcCisCn.AutGenNahrada(Eval("druh").ToString()) %>'
                                AppendDataBoundItems="True" SelectedValue='<%# Bind("dphkod") %>'
                                DataSourceID="ODS_CisDPH" DataTextField="cely_nazev" DataValueField="kod" Width="100px" DropDownWidth="180px"
                                OnClientSelectedIndexChanged="NahradaOnChange" />
                        </td>
                        <td class="border1px">
                            <wc:TLabel ID="naklad_Lab" runat="server" Text='<%# Eval("naklad") %>' Visible='<%# !IsInEditMode(LV_Nahrady) || KSProgram.Sluzebky.SlcCisCn.AutGenNahrada(Eval("druh").ToString()) %>' />
                            <wc:TTextBox ID="naklad_TB" runat="server" Text='<%# Bind("naklad") %>' Visible='<%# IsInEditMode(LV_Nahrady) && !KSProgram.Sluzebky.SlcCisCn.AutGenNahrada(Eval("druh").ToString()) %>'
                                Width="60px" />
                        </td>
                        <td class="border1px">
                            <wc:TLabel ID="dph_Lab" runat="server" Text='<%# Eval("dph") %>' Visible='<%# !IsInEditMode(LV_Nahrady) || KSProgram.Sluzebky.SlcCisCn.AutGenNahrada(Eval("druh").ToString()) %>' />
                            <wc:TTextBox ID="dph_TB" runat="server" Text='<%# Bind("dph") %>' Visible='<%# IsInEditMode(LV_Nahrady) && !KSProgram.Sluzebky.SlcCisCn.AutGenNahrada(Eval("druh").ToString()) %>'
                                Width="60px" />
                        </td>
                        <td class="border1px">
                            <asp:HiddenField ID="blobid1_HF" runat="server" Value='<%# Bind("blobid1") %>' />
                            <asp:HiddenField ID="blobid2_HF" runat="server" Value='<%# Bind("blobid2") %>' />
                            <asp:HiddenField ID="blobid1n_HF" runat="server" Value='<%# Bind("blobid1n") %>' />
                            <asp:HiddenField ID="blobid2n_HF" runat="server" Value='<%# Bind("blobid2n") %>' />

                            <asp:HyperLink ID="HyperLink1" runat="server" Target="_blank" NavigateUrl='<%# genOpenDoklUrl(Eval("blobid1"), Eval("blobid1n")) %>'
                                Visible='<%# (!IsInEditMode(LV_Nahrady) && !Eval("blobid1").Equals(DBNull.Value))?true:false %>'
                                ToolTip='<%# "Otevři " + Eval("blobid1n") %>'>
                                <asp:Image ID="ExportToFileB1_ImgBtn" runat="server"
                                    ImageUrl="~/Images/DocumentHS.png" />
                            </asp:HyperLink>
                            <asp:CheckBox ID="SmazB1_CBX" runat="server" Text='<%# "Smazat " + Eval("blobid1n") %>'
                                Visible='<%# (IsInEditMode(LV_Nahrady) && !Eval("blobid1").Equals(DBNull.Value))?true:false %>' />

                            <%--AllowedFileExtensions="txt,bmp,jpg,png,tif,doc,docx,xml,csv,xls,xlsx,ods,pdf"--%>
                            <telerik:RadAsyncUpload runat="server" ID="RadAsyncUpload1" MaxFileSize='<%# KSProgram.Parametry.PovinnyParametrCti<int>("PřílohyMaxVelikost") * 1048576 %>'
                                HideFileInput="True" TemporaryFolder="~/Temp" AllowedFileExtensions="bmp,jpg,jpeg,png,tif,gif,pdf"
                                Visible='<%# (IsInEditMode(LV_Nahrady) && Eval("blobid1").Equals(DBNull.Value))?true:false %>' AutoAddFileInputs="False" MaxFileInputsCount="1"
                                Localization-Cancel="Zrušit" Localization-DropZone="Přetáhni soubor sem" Localization-Remove="Odstraň" Localization-Select="Vyber" Width="180px"
                                OnClientValidationFailed="OnRadUploadClientValidationFailed" PostbackTriggers="Vdj_UpdateBtn,img_save" />

                            <asp:Label ID="pril_break" runat="server" Text='<%# (IsInEditMode(LV_Nahrady) && !Eval("blobid1").Equals(DBNull.Value)) ? "<"+"br/>" : "" %>'></asp:Label>

                            <asp:HyperLink ID="HyperLink2" runat="server" Target="_blank" NavigateUrl='<%# genOpenDoklUrl(Eval("blobid2"), Eval("blobid2n")) %>'
                                Visible='<%# (!IsInEditMode(LV_Nahrady) && !Eval("blobid2").Equals(DBNull.Value))?true:false %>'
                                ToolTip='<%# "Otevři " + Eval("blobid2n") %>'>
                                <asp:Image ID="Image1" runat="server"
                                    ImageUrl="~/Images/DocumentHS.png" />
                            </asp:HyperLink>
                            <asp:CheckBox ID="SmazB2_CBX" runat="server" Text='<%# "Smazat " + Eval("blobid2n") %>'
                                Visible='<%# (IsInEditMode(LV_Nahrady) && !Eval("blobid2").Equals(DBNull.Value))?true:false %>' />

                            <telerik:RadAsyncUpload runat="server" ID="RadAsyncUpload2" MaxFileSize='<%# KSProgram.Parametry.PovinnyParametrCti<int>("PřílohyMaxVelikost") * 1048576 %>'
                                HideFileInput="True" TemporaryFolder="~/Temp" AllowedFileExtensions="bmp,jpg,jpeg,png,tif,gif,pdf"
                                Visible='<%# (IsInEditMode(LV_Nahrady) && Eval("blobid2").Equals(DBNull.Value))?true:false %>' AutoAddFileInputs="False" MaxFileInputsCount="1"
                                Localization-Cancel="Zrušit" Localization-DropZone="Přetáhni soubor sem" Localization-Remove="Odstraň" Localization-Select="Vyber" Width="180px"
                                OnClientValidationFailed="OnRadUploadClientValidationFailed" PostbackTriggers="Vdj_UpdateBtn,img_save" />
                        </td>
                    </tr>
                </ItemTemplate>
            </asp:ListView>
        </td>
    </tr>


    <tr>
        <!-- rozpad -->
        <td>
            <wc:TObjectDataSource ID="ODS_str" runat="server"
                TypeName="KSProgram.Ciselniky.CisStredisko"
                SelectMethod="StrediskaProSluzebniCesty" EnableCaching="True">
                <SelectParameters>
                    <asp:ControlParameter Name="datum" Type="DateTime" PropertyName="Dat_od" ControlID="CP" />
                    <asp:ControlParameter Name="os_cislo" Type="Decimal" DefaultValue="0" PropertyName="OsCislo" ControlID="CP" />
                    <asp:Parameter Name="ab_prazdny" Type="Boolean" DefaultValue="True" />
                </SelectParameters>
            </wc:TObjectDataSource>
            <wc:TObjectDataSource ID="ODS_Zakazky" runat="server"
                TypeName="KSProgram.Ciselniky.CisZakazky"
                SelectMethod="Select" EnableCaching="True" CacheExpirationPolicy="Sliding" CacheDuration="600">
                <SelectParameters>
                    <asp:ControlParameter Name="datum" Type="DateTime" PropertyName="Dat_od" ControlID="CP" />
                    <asp:ControlParameter Name="typ" Type="String" PropertyName="Typ" ControlID="CP" />
                </SelectParameters>
            </wc:TObjectDataSource>
            <wc:TObjectDataSource ID="ODS_Reklamace" runat="server"
                TypeName="KSProgram.Ciselniky.CisReklamace"
                SelectMethod="Select" EnableCaching="True" CacheExpirationPolicy="Sliding" CacheDuration="600">
                <SelectParameters>
                    <asp:ControlParameter Name="datum" Type="DateTime" PropertyName="Dat_od" ControlID="CP" />
                </SelectParameters>
            </wc:TObjectDataSource>
            <wc:TObjectDataSource ID="ODS_Projekty" runat="server"
                TypeName="KSProgram.Ciselniky.CisProjekty"
                SelectMethod="Select" EnableCaching="True" CacheExpirationPolicy="Sliding" CacheDuration="600">
                <SelectParameters>
                    <asp:ControlParameter Name="datum" Type="DateTime" PropertyName="Dat_od" ControlID="CP" />
                    <asp:ControlParameter Name="os_cislo" Type="Decimal" DefaultValue="0" PropertyName="OsCislo" ControlID="CP" />
                </SelectParameters>
            </wc:TObjectDataSource>

            <asp:ListView ID="LV_NahrRozp" runat="server" DataKeyNames="id"
                OnPreRender="LV_NahrRozp_PreRender" OnItemCommand="LV_NahrRozp_ItemCommand" OnItemEditing="LV_NahrRozp_ItemEditing"
                Visible="False">
                <%--DataSourceID="ODS_Slcnahrady"--%>
                <LayoutTemplate>
                    <table id="itemPlaceholderContainer" runat="server" class="border1px celpad4"
                        style="table-layout: fixed; background-color: #FFFFFF; border-collapse: collapse;">
                        <tr>
                            <td colspan="9" class="theme_header border1px">
                                <wc:TLabel ID="Lab_rozp" runat="server" CssClass="cp_nadpis" Text="[%ROZPAD NÁKLADŮ%]" />
                            </td>

                        </tr>
                        <tr>
                            <td class="border1px" style="width: 67px;"></td>
                            <td class="border1px" style="width: 56px;">
                                <wc:TLabel ID="datum_Lab" runat="server" Text="[%Datum%]" Font-Bold="True" />
                            </td>
                            <td class="border1px" style="width: 142px;">
                                <wc:TLabel ID="druh_Lab" runat="server" Text="[%Druh výdaje%]" Font-Bold="True" />
                            </td>
                            <td class="border1px" style="width: 82px;">
                                <wc:TLabel ID="castka_Lab" runat="server" Text="[%Částka%]" Font-Bold="True" />
                            </td>

                            <td class="border1px" style="width: 42px">
                                <wc:TLabel ID="proc_Lb" runat="server" Text="[%Podíl%]" Font-Bold="True" />
                            </td>
                            <td class="border1px" style="width: 52px">
                                <wc:TLabel ID="str_Lb" runat="server" Text="[%Středisko%]" Font-Bold="True" />

                            </td>
                            <td class="border1px" style="width: 82px">
                                <wc:TLabel ID="zak_Lb" runat="server" Text="[%Zakázka%]" Font-Bold="True" />

                            </td>
                            <td class="border1px" style="width: 82px">
                                <wc:TLabel ID="rekl_Lb" runat="server" Text="[%Reklamace%]" Font-Bold="True" />

                            </td>
                            <td class="border1px" style="width: 102px">
                                <wc:TLabel ID="proj_Lb" runat="server" Text="[%Projekt%]" Font-Bold="True" />

                            </td>

                        </tr>

                        <tr id="itemPlaceholder" runat="server">
                        </tr>

                    </table>
                </LayoutTemplate>
                <ItemTemplate>
                    <tr>
                        <td class="border1px" style="width: 67px">
                            <span class="tiskHide">
                                <wc:TRadButton ID="NahrRozp_EditBtn" runat="server" Text="[%Editovat%]" CommandName="Edit" IdPrava="100" Icon-PrimaryIconCssClass="fi fi-edit"
                                    CausesValidation="False" CssClass="editovatButton" />
                            </span>
                        </td>
                        <td class="border1px" style="width: 56px">
                            <asp:HiddenField ID="id_HF" runat="server" Value='<%# Bind("id") %>' />
                            <asp:Label ID="datum_Lab" runat="server" Text='<%# Eval("datum", "{0:d.M.yyyy}") %>' Width="60px" />
                        </td>
                        <td class="border1px" style="width: 142px">
                            <asp:Label ID="druh_Lab" runat="server" Text='<%# Eval("druh_display") %>' />
                        </td>
                        <td class="border1px" style="width: 92px">
                            <asp:Label ID="vydaj_Lab" runat="server" Text='<%# Eval("vydaj") %>' Width="50px" />
                            <asp:Label ID="mena_Lab" runat="server" Text='<%# Eval("vydaj_mena") %>' />
                        </td>

                        <td colspan="5" class="border1px" style="padding: 0px">
                            <asp:ObjectDataSource ID="ODS_SlcNahradyRozp" runat="server"
                                OldValuesParameterFormatString="original_{0}"
                                TypeName="KSProgram.Sluzebky.SlcNahradyRozp"
                                SelectMethod="Select"
                                UpdateMethod="Update">
                                <SelectParameters>
                                    <asp:ControlParameter Name="ev_cislo" Type="Int32" DefaultValue="0" ControlID="HF_EvCislo" PropertyName="Value" />
                                    <asp:ControlParameter Name="id_par" Type="Int32" DefaultValue="0" ControlID="id_HF" PropertyName="Value" />
                                    <asp:Parameter Name="pocetPrazdnychRadku" Type="Int32" DefaultValue="1" />
                                </SelectParameters>
                            </asp:ObjectDataSource>

                            <asp:ListView ID="LV_Rozp" runat="server" DataSourceID="ODS_SlcNahradyRozp" DataKeyNames="id_rozp" OnPreRender="LV_Rozp_PreRender">
                                <LayoutTemplate>
                                    <table id="itemPlaceholderContainer" runat="server" class="celpad4" style="table-layout: fixed; border-collapse: collapse;">
                                        <tr id="itemPlaceholder" runat="server" />
                                    </table>
                                </LayoutTemplate>
                                <ItemTemplate>
                                    <tr>
                                        <td class="border1pxR" style="width: 42px; display: inline-block;">
                                            <asp:HiddenField ID="id_rozp_HF" runat="server" Value='<%# Bind("id_rozp") %>' />
                                            <asp:HiddenField ID="id_par_HF" runat="server" Value='<%# Bind("id_par") %>' />

                                            <asp:Label ID="procento_Lab" runat="server" Text='<%# Eval("procento", "{0:#0.0#}") + " %" %>' />
                                            <asp:Label ID="proc_castka_Lab" runat="server" Text='<%# Eval("castka", "{0:#0.0#}") %>' Visible="false"/>
                                                    
                                        </td>
                                        <td class="border1pxR" style="width: 52px">
                                            <asp:Label ID="str_Lab" runat="server" Text='<%# Eval("str") %>' />
                                        </td>
                                        <td class="border1pxR" style="width: 82px">
                                            <asp:Label ID="zakazka_Lab" runat="server" Text='<%# Eval("zakazka") %>' />
                                        </td>
                                        <td class="border1pxR" style="width: 82px">
                                            <asp:Label ID="reklamace_Lab" runat="server" Text='<%# Eval("reklamace") %>' />
                                        </td>
                                        <td class="" style="width: 102px; white-space: normal">
                                            <asp:Label ID="projekt_Lab" runat="server" Text='<%# Eval("projekt_display") %>' />
                                        </td>
                                    </tr>
                                </ItemTemplate>
                            </asp:ListView>
                        </td>
                    </tr>
                </ItemTemplate>
                <EditItemTemplate>
                    <tr>
                        <td class="border1px" style="white-space: normal">
                            <wc:TRadButton ID="NahrRozp_UpdateBtn" runat="server" Text="[%Uložit%]" CommandName="UpdateRozp" IdPrava="100"
                                CausesValidation="True" ValidationGroup="Rozpad" Icon-PrimaryIconCssClass="fi fi-disk" CssClass="ulozitButton" />
                            &nbsp;
                                <wc:TRadButton ID="NahrRozp_CancelBtn" runat="server" Text="[%Neuložit%]" CommandName="Cancel" IdPrava="100"
                                    CausesValidation="False" Icon-PrimaryIconCssClass="fi fi-floppy-disk-circle-xmark" />
                        </td>
                        <td class="border1px">
                            <asp:HiddenField ID="id_HF" runat="server" Value='<%# Bind("id") %>' />
                            <asp:Label ID="datum_Lab" runat="server" Text='<%# Eval("datum", "{0:d.M.yyyy}") %>' Width="65px" />
                        </td>
                        <td class="border1px">
                            <asp:Label ID="druh_Lab" runat="server" Text='<%# Eval("druh_display") %>' />
                        </td>
                        <td class="border1px">
                            <asp:Label ID="vydaj_Lab" runat="server" Text='<%# Eval("vydaj") %>' Width="50px" />
                            <asp:Label ID="mena_Lab" runat="server" Text='<%# Eval("vydaj_mena") %>' />
                        </td>

                        <td colspan="5" class="border1px" style="padding: 0px">
                            <asp:ObjectDataSource ID="ODS_SlcNahradyRozp" runat="server"
                                OldValuesParameterFormatString="original_{0}"
                                TypeName="KSProgram.Sluzebky.SlcNahradyRozp"
                                SelectMethod="Select"
                                UpdateMethod="Update">
                                <SelectParameters>
                                    <asp:ControlParameter Name="ev_cislo" Type="Int32" DefaultValue="0" ControlID="HF_EvCislo" PropertyName="Value" />
                                    <asp:ControlParameter Name="id_par" Type="Int32" DefaultValue="0" ControlID="id_HF" PropertyName="Value" />
                                    <asp:Parameter Name="pocetPrazdnychRadku" Type="Int32" DefaultValue="20" />
                                </SelectParameters>
                                <UpdateParameters>
                                    <asp:Parameter Name="original_id_rozp" Type="Int32" />
                                    <asp:Parameter Name="id_rozp" Type="Int32" />
                                    <asp:Parameter Name="id_par" Type="Int32" />
                                    <asp:Parameter Name="procento" Type="Decimal" />
                                    <asp:Parameter Name="str" Type="String" />
                                    <asp:Parameter Name="zakazka" Type="String" DefaultValue=" " />
                                    <asp:Parameter Name="reklamace" Type="String" DefaultValue=" " />
                                    <asp:Parameter Name="projekt" Type="String" />
                                </UpdateParameters>
                            </asp:ObjectDataSource>

                            <asp:ListView ID="LV_Rozp" runat="server" DataSourceID="ODS_SlcNahradyRozp" DataKeyNames="id_rozp"
                                OnItemDataBound="LV_Rozp_ItemDataBound" OnPreRender="LV_Rozp_PreRender">
                                <LayoutTemplate>
                                    <table id="itemPlaceholderContainer" runat="server" class="celpad4" style="margin: 0px; width: 100%;">
                                        <tr id="itemPlaceholder" runat="server" />
                                    </table>
                                </LayoutTemplate>
                                <ItemTemplate>
                                    <tr>
                                        <td class="border1pxR">
                                            <asp:HiddenField ID="id_rozp_HF" runat="server" Value='<%# Bind("id_rozp") %>' />
                                            <asp:HiddenField ID="id_par_HF" runat="server" Value='<%# Bind("id_par") %>' />
                                            <span style="display: inline-block; width: 65px">

                                                <wc:TTextBox ID="procento_TB" CssClass="input povinne-pole" runat="server" Text='<%# Bind("procento") %>' Width="35px" AutoPostBack="True" CausesValidation="False"
                                                    TabIndex='<%# 1 + (100*Container.DataItemIndex) %>' />
                                                %
                                            </span>
                                        </td>
                                        <td class="border1pxR"><%--SelectedValue='<%# Bind("str") %>'--%>
                                            <wc:TRadComboBox ID="str_RCmb" InputCssClass="povinne-pole" runat="server" AllowCustomText="False" Width="92px"
                                                DataSourceID="ODS_str" DataTextField="cely_nazev" DataValueField="str" DropDownWidth="200px" MaxHeight="200px" EnableAutomaticLoadOnDemand="True" EnableLoadOnDemand="True" LoadingMessage="Nahrávám..." MarkFirstMatch="True" Filter="Contains" ItemsPerRequest="20" EnableVirtualScrolling="True" MinFilterLength="1" CausesValidation="False"
                                                TabIndex='<%# 2 + (100*Container.DataItemIndex) %>' EmptyMessage="piš pro nabídku" />
                                        </td>
                                        <td class="border1pxR"><%--SelectedValue='<%# Bind("zakazka") %>'--%>
                                            <wc:TRadComboBox ID="zakazka_RCmb" runat="server" AllowCustomText="False" Width="130px"
                                                DataSourceID="ODS_Zakazky" DataTextField="cely_nazev" DataValueField="cis_zakazky" DropDownWidth="200px" MaxHeight="200px" EnableAutomaticLoadOnDemand="True" EnableLoadOnDemand='<%# !KSProgram.Zakaznik.IsCurrent("SKODA PRAHA") %>' LoadingMessage="Nahrávám..." MarkFirstMatch="True" Filter="Contains" ItemsPerRequest="20" EnableVirtualScrolling="True" MinFilterLength="1" CausesValidation="False"
                                                TabIndex='<%# 3 + (100*Container.DataItemIndex) %>' EmptyMessage="piš pro nabídku" />
                                        </td>
                                        <td class="border1pxR"><%--SelectedValue='<%# Bind("reklamace") %>'--%>
                                            <wc:TRadComboBox ID="reklamace_RCmb" runat="server" AllowCustomText="False" Width="130px"
                                                DataSourceID="ODS_Reklamace" DataTextField="cely_nazev" DataValueField="cislo" DropDownWidth="200px" MaxHeight="200px" EnableAutomaticLoadOnDemand="True" EnableLoadOnDemand="True" LoadingMessage="Nahrávám..." MarkFirstMatch="True" Filter="Contains" ItemsPerRequest="20" EnableVirtualScrolling="True" MinFilterLength="1" CausesValidation="False"
                                                TabIndex='<%# 4 + (100*Container.DataItemIndex) %>' EmptyMessage="piš pro nabídku" />
                                        </td>
                                        <td class=""><%--SelectedValue='<%# Bind("projekt") %>'--%>
                                            <wc:TRadComboBox ID="projekt_RCmb" runat="server" AllowCustomText="False" Width="160px"
                                                DataSourceID="ODS_Projekty" DataTextField="cely_nazev" DataValueField="cislo" DropDownWidth="200px" MaxHeight="200px" EnableAutomaticLoadOnDemand="True" EnableLoadOnDemand="True" LoadingMessage="Nahrávám..." MarkFirstMatch="True" Filter="Contains" ItemsPerRequest="20" EnableVirtualScrolling="True" MinFilterLength="1" CausesValidation="False"
                                                TabIndex='<%# 5 + (100*Container.DataItemIndex) %>' EmptyMessage="piš pro nabídku"
                                                OnSelectedIndexChanged="LV_NahrRozp_proj_SelIndexChanged" AutoPostBack="true" />
                                        </td>
                                    </tr>
                                </ItemTemplate>
                            </asp:ListView>
                            <asp:CustomValidator ID="NahrRozpValidator" runat="server" OnServerValidate="LV_NahrRozp_validate"
                                ErrorMessage="[%Chybně vyplněné údaje, nelze pokračovat%]" ValidationGroup="Rozpad"></asp:CustomValidator>
                        </td>
                    </tr>
                </EditItemTemplate>
            </asp:ListView>
        </td>
    </tr>


    <tr>
        <td>
            <asp:ObjectDataSource ID="ODS_SlcVyuct" runat="server"
                OldValuesParameterFormatString="original_{0}"
                TypeName="KSProgram.Sluzebky.SlcVyuct"
                SelectMethod="Select">
                <SelectParameters>
                    <asp:ControlParameter ControlID="HF_EvCislo" Name="ev_cislo" PropertyName="Value" Type="Int32" DefaultValue="0" />
                    <asp:Parameter Name="generuj" Type="String" DefaultValue="a" />
                    <asp:Parameter Name="predvolba_meny" Type="String" DefaultValue="tuz" />
                </SelectParameters>
                <UpdateParameters>
                    <asp:ControlParameter ControlID="HF_EvCislo" Name="ev_cislo" PropertyName="Value" Type="Int32" DefaultValue="0" />
                    <asp:Parameter Name="original_radek" Type="Int32" />
                    <asp:Parameter Name="radek" Type="Int32" />
                    <asp:Parameter Name="mena_z" Type="String" />
                    <asp:Parameter Name="zal_castka" Type="Decimal" />
                    <asp:Parameter Name="zal_vraceno" Type="Decimal" />
                    <asp:Parameter Name="nahrady" Type="Decimal" />
                    <asp:Parameter Name="nahrady_zvys" Type="Decimal" />
                    <asp:Parameter Name="nahrady_zvys_prep" Type="Decimal" />
                    <asp:Parameter Name="rozdil" Type="Decimal" />
                    <asp:Parameter Name="rozdil_prepoc" Type="Decimal" />
                    <asp:Parameter Name="mena_na" Type="String" />
                    <asp:Parameter Name="kurz_typ" Type="String" />
                    <asp:Parameter Name="kurz_dne" Type="DateTime" />
                    <asp:Parameter Name="kurz1" Type="String" />
                    <asp:Parameter Name="kurz2" Type="String" />
                    <asp:Parameter Name="vyuct_castka" Type="Decimal" />
                    <asp:Parameter Name="vyuct_zvys" Type="Decimal" />
                    <asp:Parameter Name="zp_vypl" Type="String" />
                </UpdateParameters>
            </asp:ObjectDataSource>
            <%-- VYUCTOVANI --%>
            <asp:ListView ID="LV_Vyuct" runat="server" DataKeyNames="radek"
                OnItemCommand="LV_Vyuct_ItemCommand">
                <%--DataSourceID="ODS_SlcVyuct"--%>
                <LayoutTemplate>
                    <table id="itemPlaceholderContainer" runat="server" class="celpad4 widthA4 border1px"
                        style="background-color: #FFFFFF; border-collapse: collapse; empty-cells: hide">
                        <%--TITULEK--%>
                        <tr>
                            <td colspan="7" class="theme_header border1px">
                                <wc:TLabel ID="Lab_vyuct" runat="server" CssClass="cp_nadpis" Text="[%VYÚČTOVÁNÍ%]" />
                            </td>
                        </tr>
                        <tr id="itemPlaceholder" runat="server">
                        </tr>
                        <%--TLACITKA v dolnim radku--%>
                        <%--<tr class="tiskHide" > 
                        <td colspan="7" class="border1px" >
                            <wc:TRadButton ID="Vyuct_EditBtn" runat="server" Text="[%Editovat%]" CommandName="EditAll" IdPrava="100" nove pravo
                                CausesValidation="False" />
                            &nbsp;
                            <wc:TRadButton ID="Vyuct_UpdateBtn" runat="server" Text="[%Uložit%]" CommandName="UpdateAll" Visible="false" IdPrava="100" 
                                CausesValidation="True"  />
                            &nbsp;
                            <wc:TRadButton ID="Vyuct_CancelBtn" runat="server" Text="[%Neuložit%]" CommandName="CancelAll" Visible="false" IdPrava="100"
                                CausesValidation="False" />                    
                        </td>
                    </tr>--%>
                    </table>
                </LayoutTemplate>
                <ItemTemplate>
                    <asp:TableRow ID="TR_prvni" runat="server" Visible='<%# IsInEditMode(LV_Vyuct) %>'>
                        <asp:TableCell ID="TableCell6" runat="server" ColumnSpan="7" CssClass="border1pxL border1pxR">
                            <%-- HIDEN FIELDS - polozky, ktere uzivatel nemeni --%>
                            <asp:HiddenField ID="radek_HF" runat="server" Value='<%# Bind("radek") %>' />
                            <asp:HiddenField ID="mena_z_HF" runat="server" Value='<%# Bind("mena_z") %>' Visible='<%# IsInEditMode(LV_Vyuct)%>' />

                            <asp:HiddenField ID="zal_castka_HF" runat="server" Value='<%# Bind("zal_castka") %>' />
                            <asp:HiddenField ID="zal_vraceno_HF" runat="server" Value='<%# Bind("zal_vraceno") %>' />
                            <asp:HiddenField ID="nahrady_HF" runat="server" Value='<%# Bind("nahrady") %>' />
                            <asp:HiddenField ID="nahrady_zvys_HF" runat="server" Value='<%# Bind("nahrady_zvys") %>' />
                            <asp:HiddenField ID="rozdil_HF" runat="server" Value='<%# Bind("rozdil") %>' />

                            <asp:HiddenField ID="mena_na_HF" runat="server" Value='<%# Bind("mena_na") %>' Visible='<%# IsInEditMode(LV_Vyuct)%>' />
                            <asp:HiddenField ID="rozdil_prepoc_HF" runat="server" Value='<%# Bind("rozdil_prepoc") %>' />
                            <asp:HiddenField ID="nahrady_zvys_prep_HF" runat="server" Value='<%# Bind("nahrady_zvys_prep") %>' />

                            <asp:HiddenField ID="vyuct_castka_HF" runat="server" Value='<%# Bind("vyuct_castka") %>' />
                            <asp:HiddenField ID="vyuct_zvys_HF" runat="server" Value='<%# Bind("vyuct_zvys") %>' />
                            <%--VOLBA Vyrovnání v měně--%>
                            <wc:TLabel ID="Label27" runat="server" Text="[%Vyrovnání v měně%]:" Visible='<%# IsInEditMode(LV_Vyuct) && Container.DataItemIndex==0 %>' />

                            <telerik:RadDropDownList runat="server" ID="predvolba_meny_DDL" Visible='<%# IsInEditMode(LV_Vyuct) && Container.DataItemIndex==0%>'
                                SelectedValue="aut" OnSelectedIndexChanged="LV_Vyuct_ValueChanged" AutoPostBack="true" AppendDataBoundItems="True" Width="300px">
                                <Items>
                                    <telerik:DropDownListItem Value="tuz" Text='<%# KSProgram.Globals.KodMeny %>' />
                                    <telerik:DropDownListItem Value="aut" Text='<%# "[%doplatek v%] " + KSProgram.Globals.KodMeny + ", [%přeplatek v měně zálohy%]" %>' />
                                    <telerik:DropDownListItem Value="nep" Text="[%Nepřepočítávat na jiné měny%]" />
                                </Items>
                            </telerik:RadDropDownList>
                        </asp:TableCell>
                    </asp:TableRow>
                    <%-- TITULKY SLOUPCU --%>
                    <asp:TableRow ID="TR_titulky" runat="server">
                        <asp:TableCell ID="TableCell1x" runat="server" CssClass="border1px" Width="35px">
                            <wc:TLabel ID="Label17" runat="server" Text="[%Měna%]" />
                        </asp:TableCell>
                        <asp:TableCell ID="TableCell2x" runat="server" CssClass="border1px" Width="55px" HorizontalAlign="Right">
                            <wc:TLabel ID="Label9" runat="server" Text="[%Záloha%]" />
                        </asp:TableCell>
                        <asp:TableCell ID="TableCell3x" runat="server" CssClass="border1px" Width="55px" HorizontalAlign="Right">
                            <wc:TLabel ID="Label12" runat="server" Text="[%Vratka%]" />
                        </asp:TableCell>
                        <asp:TableCell ID="TableCell4x" runat="server" CssClass="border1px" Width="55px" HorizontalAlign="Right">
                            <wc:TLabel ID="Label13" runat="server" Text="[%Náhrady%]" />
                        </asp:TableCell>
                        <asp:TableCell ID="TableCell5x" runat="server" CssClass="border1px" Width="165px" HorizontalAlign="Right">
                            <wc:TLabel ID="Label14" runat="server" Text="[%Rozdíl%]" />
                        </asp:TableCell>
                        <%--<asp:TableCell ID="TableCell6x" runat="server" Width="40px"><asp:Label ID="Label15" runat="server" Text="[%Měna%]" /></asp:TableCell>--%>
                        <asp:TableCell ID="TableCell7x" runat="server" CssClass="border1px" Width="140px" HorizontalAlign="Right">
                            <wc:TLabel ID="Label16" runat="server" Text="[%Nadlimit%]" />
                        </asp:TableCell>
                        <asp:TableCell ID="TableCell9x" runat="server" CssClass="border1px">
                            <asp:Label ID="Label15" runat="server" Text="[%Kurz%]" />&nbsp;
                        <asp:Label ID="kurz_typ_Lab" runat="server" Text='<%# Bind("kurz_typ_display") %>' Visible='<%# !IsInEditMode(LV_Vyuct) %>' />
                            <telerik:RadDropDownList runat="server" ID="kurz_typ_DDL" SelectedValue='<%# Bind("kurz_typ") %>' Visible='<%# IsInEditMode(LV_Vyuct) %>' Width="80px" AppendDataBoundItems="True">
                                <Items>
                                    <telerik:DropDownListItem Value="c" Text='<%# KSProgram.Zakaznik.IsSR() ? "ECB" : "ČNB" %>' />
                                    <telerik:DropDownListItem Value="s" Text="[%dle směny%]" />
                                </Items>
                            </telerik:RadDropDownList>
                            &nbsp;<asp:Label ID="Label3" runat="server" Text="[%z%]" Visible='<%# !Eval("mena_na").Equals(Eval("mena_z")) %>' Font-Size="11px" />&nbsp;
                        <asp:Label ID="kurz_dne_Lab" runat="server" Text='<%# Eval("kurz_dne", "{0:d.M.yyyy}") %>' Visible='<%# !IsInEditMode(LV_Vyuct) %>' />
                            <wc:TRadDatePicker ID="kurz_dne_DP" runat="server" DbSelectedDate='<%# Bind("kurz_dne") %>' DateInput-MaxLength="10" Width="100px"
                                DateInput-MinDate="1.1.0001 0:00:00" Visible='<%# IsInEditMode(LV_Vyuct) && !Eval("mena_na").Equals(Eval("mena_z")) %>' />
                        </asp:TableCell>
                    </asp:TableRow>
                    <%-- HODNOTY - nahrady, zalohy, rozdil --%>
                    <asp:TableRow ID="TR_hodnoty" runat="server">
                        <asp:TableCell ID="TableCell10x" runat="server" CssClass="border1px">
                            <asp:Label ID="mena_z_Label" runat="server" Text='<%# Eval("mena_z") %>' />
                        </asp:TableCell>
                        <asp:TableCell ID="TableCell11x" runat="server" CssClass="border1px" HorizontalAlign="Right">
                            <asp:Label ID="zal_castka_Lab" runat="server" Text='<%# Eval("zal_castka") %>' />
                        </asp:TableCell>
                        <asp:TableCell ID="TableCell12x" runat="server" CssClass="border1px" HorizontalAlign="Right">
                            <asp:Label ID="zal_vraceno_Lab" runat="server" Text='<%# Eval("zal_vraceno") %>' />
                        </asp:TableCell>
                        <asp:TableCell ID="TableCell13x" runat="server" CssClass="border1px" HorizontalAlign="Right">
                            <asp:Label ID="nahrady_Lab" runat="server" Text='<%# Eval("nahrady") %>' />
                        </asp:TableCell>
                        <asp:TableCell ID="TableCell14x" runat="server" CssClass="border1px" HorizontalAlign="Right">
                            <asp:Label ID="rozdil_Lab" runat="server" Text='<%# Eval("rozdil") + " " + Eval("mena_z") %>' />
                            <asp:Label ID="rozdil_prepoc_Lab" runat="server" Text='<%# " = " + Eval("rozdil_prepoc", "{0:#0.00###}") + " " + Eval("mena_na") %>' Visible='<%# !IsInEditMode(LV_Vyuct) && !Eval("mena_na").Equals(Eval("mena_z")) %>' />

                            <wc:TTextBox ID="rozdil_prepoc_TB" runat="server" Text='<%# Eval("rozdil_prepoc") %>' Visible='<%# IsInEditMode(LV_Vyuct) && !Eval("mena_na").Equals(Eval("mena_z")) %>'
                                ReadOnly="True" MaxLength="0" Width="80px"></wc:TTextBox>
                            <telerik:RadDropDownList ID="mena_na_DDL" runat="server" Visible='<%# IsInEditMode(LV_Vyuct) %>' SelectedValue='<%# Eval("mena_na") %>'
                                DataSourceID="ODS_CisKodMeny" DataTextField="kod_a_nazev" DataValueField="kod" Width="60px" DropDownHeight="300px" DropDownWidth="250px"
                                OnSelectedIndexChanged="LV_Vyuct_ValueChanged" AutoPostBack="True" />
                        </asp:TableCell>
                        <asp:TableCell ID="TableCell16x" runat="server" CssClass="border1px" HorizontalAlign="Right">
                            <asp:Label ID="nahrady_zvys_Lab" runat="server" Text='<%# Eval("nahrady_zvys") + " " + Eval("mena_z") %>' />
                            <asp:Label ID="nahrady_zvys_prep_Lab" runat="server" Text='<%# " = " + Eval("nahrady_zvys_prep", "{0:#0.00###}") + " " + Eval("mena_na") %>' Visible='<%# !IsInEditMode(LV_Vyuct) && !Eval("mena_na").Equals(Eval("mena_z")) %>' />
                        </asp:TableCell>
                        <asp:TableCell ID="TableCell17x" runat="server" CssClass="border1px">
                            <asp:Label ID="kurz1_Lab" runat="server" Text='<%# Eval("kurz1") %>' Visible='<%# !IsInEditMode(LV_Vyuct) %>' Font-Size="11px" />
                            <wc:TTextBox ID="kurz1_TB" runat="server" Text='<%# Bind("kurz1") %>' Visible='<%# IsInEditMode(LV_Vyuct) %>' MaxLength="25" Width="120px"></wc:TTextBox>
                            &nbsp;
                        <asp:Label ID="kurz2_Lab" runat="server" Text='<%# Eval("kurz2") %>' Visible='<%# !IsInEditMode(LV_Vyuct) %>' Font-Size="11px" />
                            <wc:TTextBox ID="kurz2_TB" runat="server" Text='<%# Bind("kurz2") %>' Visible='<%# IsInEditMode(LV_Vyuct) %>' MaxLength="25" Width="120px"></wc:TTextBox>

                        </asp:TableCell>
                    </asp:TableRow>
                    <%-- PREPOCTENY ROZDIL pokud mena_na!=mena_z --%>
                    <%--<asp:TableRow ID="TR_prepocet" runat="server" Visible='<%# !Eval("mena_na").Equals(Eval("mena_z")) %>' >                    
                    <asp:TableCell ID="TableCell19x" runat="server" Width="40px" CssClass="border1pxL"></asp:TableCell>
                    <asp:TableCell ID="TableCell20x" runat="server" Width="80px"></asp:TableCell>
                    <asp:TableCell ID="TableCell21x" runat="server" Width="80px"></asp:TableCell>
                    <asp:TableCell ID="TableCell22x" runat="server" Width="80px">
                        <asp:Label ID="Label1" runat="server" Text="[%Přepočet na%]:" />
                    </asp:TableCell>
                    <asp:TableCell ID="TableCell23x" runat="server" Width="80px">
                        
                    </asp:TableCell>
                    <asp:TableCell ID="TableCell24x" runat="server" Width="40px">
                        
                    </asp:TableCell>
                    <asp:TableCell ID="TableCell25x" runat="server" Width="30px"></asp:TableCell>
                    <asp:TableCell ID="TableCell26x" runat="server" Width="80px"></asp:TableCell>
                    <asp:TableCell ID="TableCell27x" runat="server" CssClass="border1pxR"></asp:TableCell>
                  </asp:TableRow>   --%>
                    <%-- KURZ POUZITY PRO PREPOCET --%>
                    <%--<asp:TableRow ID="TR_kurz" runat="server" Visible='<%# !Eval("mena_na").Equals(Eval("mena_z")) %>'>                    
                    <asp:TableCell ID="TableCell28x" runat="server" Width="40px" CssClass="border1pxL"></asp:TableCell>
                    <asp:TableCell ID="TableCell29x" runat="server" Width="80px"></asp:TableCell>
                    <asp:TableCell ID="TableCell30x" runat="server" Width="80px"></asp:TableCell>
                    <asp:TableCell ID="TableCell31x" runat="server" Width="80px"></asp:TableCell>
                    <asp:TableCell ID="TableCell32x" runat="server" ColumnSpan="5" CssClass="border1pxR">
                        
                        &nbsp;                 
                        
                    </asp:TableCell>
                    
                  </asp:TableRow>--%>
                  <%--CHYBA PRI AKTUALIZACI KURZŮ MĚN--%>
                  <asp:TableRow ID="TableRow6" runat="server" Visible='<%# Eval("error").ToString().Length>0 %>'>
                    <asp:TableCell ID="TableCell33x" runat="server" ColumnSpan="7" CssClass="border1pxL border1pxR" HorizontalAlign="Center">
                        <asp:Label ID="Label36" runat="server" Text='<%# Bind("error") %>' ForeColor="Red" />
                    </asp:TableCell>
                  </asp:TableRow>
                  <%-- K výplatě (+) / k inkasu (-) a Způsob proplacení --%>
                  <asp:TableRow ID="TR_vyuct_castka" runat="server" Visible='<%# !DBNull.Value.Equals(Eval("vyuct_castka")) %>'>
                    <asp:TableCell ID="TableCell34x" runat="server" ColumnSpan="4" CssClass="border1pxL" HorizontalAlign="Right">
                        <b><wc:TLabel ID="Label4" runat="server" Text="[%K výplatě (+) / k inkasu (-)%]:" /></b>
                    </asp:TableCell>
                    <asp:TableCell ID="TableCell35x" runat="server" HorizontalAlign="Right">
                        <asp:Label ID="vyuct_castka_Lab" runat="server" Text='<%# Eval("vyuct_castka") + " " + Eval("mena_na") %>' Font-Bold="True" Visible='<%# !IsInEditMode(LV_Vyuct) %>'/>
                        <wc:TTextBox ID="vyuct_castka_TB" runat="server" Text='<%# Bind("vyuct_castka") %>' Font-Bold="True"
                        ReadOnly="True" Visible='<%# IsInEditMode(LV_Vyuct) %>' MaxLength="0" Width="80px" ></wc:TTextBox>
                    </asp:TableCell>                    
                    <asp:TableCell ID="TableCell36x" runat="server" HorizontalAlign="Right">
                        <asp:Label ID="vyuct_zvys_Lab" runat="server" Text='<%# Eval("vyuct_zvys") %>' Visible='<%# !IsInEditMode(LV_Vyuct) %>' />
                        <wc:TTextBox ID="vyuct_zvys_TB" runat="server" Text='<%# Bind("vyuct_zvys") %>' 
                        ReadOnly="True" Visible='<%# IsInEditMode(LV_Vyuct) %>' MaxLength="0" Width="80px" ></wc:TTextBox>
                    </asp:TableCell>                    
                    <asp:TableCell ID="TableCell37x" runat="server" CssClass="border1pxR">
                        <b><wc:TLabel ID="Label5" runat="server" Text="[%Proplacení%]:" /></b>
                        <asp:Label ID="zp_vypl_Lab" runat="server" Text='<%# Eval("zp_vypl_display") %>' Visible='<%# !IsInEditMode(LV_Vyuct) %>'/>
                        <telerik:RadDropDownList runat="server" ID="zp_vypl_DDL" SelectedValue='<%# Bind("zp_vypl") %>' Visible='<%# IsInEditMode(LV_Vyuct) %>' AppendDataBoundItems="True">
                            <Items>
                                <telerik:DropDownListItem Value="h" Text="[%v hotovosti%]" />
                                <telerik:DropDownListItem Value="m" Text="[%ve mzdě%]" />
                                <telerik:DropDownListItem Value="u" Text="[%na účet%]" />
                            </Items>
                        </telerik:RadDropDownList> 
                        &nbsp;<br />
                        <asp:Label ID="hp_dne_Lab" runat="server" Text='<%# "([%vyplaceno%] " + Eval("hp_dne", "{0:d.M.yyyy}") + ")" %>' Visible='<%# !DBNull.Value.Equals(Eval("hp_dne")) %>'/>
                    </asp:TableCell>                    
                  </asp:TableRow>   
                  <%-- celkové náklady --%>
                  <asp:TableRow ID="TableRow1" runat="server" Visible='<%# "A".Equals(Eval("posl_radek")) %>'>
                    <asp:TableCell ID="TableCell2" runat="server" ColumnSpan="4" CssClass="border1pxL" HorizontalAlign="Right">
                        <b><asp:Label ID="Label45" runat="server" Text="[%Náklady%] + [%DPH%]:" Visible='<%# !IsInEditMode(LV_Vyuct) && !KSProgram.Zakaznik.IsCurrent("RAIFFEISENBANK") %>'/></b>
                    </asp:TableCell>
                    <asp:TableCell ID="TableCell3" runat="server" HorizontalAlign="Right">
                        <asp:Label ID="Label48" runat="server" 
                            Text='<%# Eval("naklady").ToString() + "+" + Eval("dph").ToString() + "=" + Eval("nakladysdph").ToString() + " " + KSProgram.Globals.KodMeny %>'  
                            Visible='<%# !IsInEditMode(LV_Vyuct) && !KSProgram.Zakaznik.IsCurrent("RAIFFEISENBANK") %>'/>
                    </asp:TableCell>
                    <asp:TableCell runat="server"  HorizontalAlign="Right">
                    </asp:TableCell>
                    <asp:TableCell ID="TableCell5" runat="server" RowSpan="2" CssClass="border1pxR" HorizontalAlign="Center">
                        <asp:Label ID="Label19" runat="server" Text='<%# Eval("vyuct_dne", "{0:d.M.yyyy}") %>'/>
                        &nbsp;<asp:Label ID="Label25" runat="server" Text='<%# Bind("vyuct_provedl") %>'/> <br />
                        <span style="border-top-style: dotted; border-top-width: thin; border-top-color: #000000">
                            <wc:TLabel ID="Label18" runat="server" Text="[%Vyúčtování provedl%]" />
                        </span>
                    </asp:TableCell>
                  </asp:TableRow>               
                  <%-- Nákladové středisko --%>
                  <asp:TableRow ID="TableRow1x" runat="server" Visible='<%# "A".Equals(Eval("posl_radek")) %>'>
                    <asp:TableCell ID="TableCell44x" runat="server" ColumnSpan="4" CssClass="border1pxL" HorizontalAlign="Right">
                        <b><wc:TLabel ID="Label6" runat="server" Text="[%Nákladové středisko%]:" /></b>
                    </asp:TableCell>
                    <asp:TableCell runat="server" ColumnSpan="5" CssClass="border1pxR">
                        <asp:Label ID="nakl_str_Lab" runat="server" Text='<%# Bind("nakl_str_display") %>' Visible='<%# !IsInEditMode(LV_Vyuct) %>'/>
                        <wc:TRadComboBox ID="nakl_str_RCmb" CssClass="povinne-pole" runat="server"  AllowCustomText="False" Visible='<%# IsInEditMode(LV_Vyuct) %>' Width="200px" 
                        DataSourceID="ODS_str" DataTextField="cely_nazev" DataValueField="str" SelectedValue='<%# Bind("nakl_str") %>' DropDownWidth="200px" MaxHeight="200px" EnableAutomaticLoadOnDemand="False" EnableLoadOnDemand="False" LoadingMessage="Nahrávám..." MarkFirstMatch="True" Filter="Contains" ItemsPerRequest="20" EnableVirtualScrolling="True" MinFilterLength="1" CausesValidation="False" 
                        EmptyMessage="piš pro nabídku" />
                    </asp:TableCell>                   
                  </asp:TableRow>
                  <%-- podpisy --%>
                  <%--<asp:TableRow ID="TableRow3q" runat="server" Visible='<%# "A".Equals(Eval("posl_radek")) %>'>
                    <asp:TableCell ID="TableCell1q" runat="server" Width="40px" CssClass="border1pxL"></asp:TableCell>
                    <asp:TableCell ID="TableCell2q" runat="server" Width="80px"></asp:TableCell>
                    <asp:TableCell ID="TableCell3q" runat="server" ColumnSpan="2">
                        <b></b>
                    </asp:TableCell>
                    <asp:TableCell ID="TableCell4" runat="server" ColumnSpan="5" CssClass="border1pxR">
                        
                    </asp:TableCell>
                  </asp:TableRow>--%>
                    <asp:TableRow ID="TableRow4q" runat="server" Visible='<%# "A".Equals(Eval("posl_radek")) %>'>
                        <asp:TableCell ID="TableCell5q" runat="server" ColumnSpan="4" CssClass="border1pxL">
                            <asp:Label ID="Label24" runat="server" Text='<%# Eval("zadovyuct_dne", "{0:d.M.yyyy}") %>' />&nbsp;
                        </asp:TableCell>
                        <asp:TableCell ID="TableCell7q" runat="server" ColumnSpan="2" HorizontalAlign="Center">
                            <asp:Label ID="Label20" runat="server" Text='<%# Bind("vyuct_souhl") %>' />
                        </asp:TableCell>
                        <asp:TableCell ID="TableCell8q" runat="server" HorizontalAlign="Center" CssClass="border1pxR">
                            <asp:Label ID="Label21" runat="server" Text='<%# Bind("vyuct_schval") %>' />
                        </asp:TableCell>
                    </asp:TableRow>
                    <asp:TableRow ID="TableRow5q" runat="server" Visible='<%# "A".Equals(Eval("posl_radek")) %>'>
                        <asp:TableCell ID="TableCell9q" runat="server" ColumnSpan="4" CssClass="border1pxL border1pxB">
                            <span style="border-top-style: dotted; border-top-width: thin; border-top-color: #000000">
                                <wc:TLabel ID="Label26" runat="server" Text="[%Zažádáno dne%]" /><%--Visible='<%# !DBNull.Value.Equals(Eval("zadovyuct_dne")) %>'--%>
                            </span>
                        </asp:TableCell>
                        <asp:TableCell ID="TableCell11q" runat="server" ColumnSpan="2" HorizontalAlign="Center" CssClass="border1pxB">
                            <span style="border-top-style: dotted; border-top-width: thin; border-top-color: #000000">
                                <wc:TLabel ID="Label22" runat="server" Text="[%Datum a podpis zaměstnance%]" />
                            </span>
                        </asp:TableCell>
                        <asp:TableCell ID="TableCell12q" runat="server" HorizontalAlign="Center" CssClass="border1pxR border1pxB">
                            <span style="border-top-style: dotted; border-top-width: thin; border-top-color: #000000">
                                <wc:TLabel ID="Label23" runat="server" Text="[%Vyúčtování schválil%]" />
                            </span>
                        </asp:TableCell>
                    </asp:TableRow>
                </ItemTemplate>
            </asp:ListView>
            <asp:CustomValidator ID="VyuctValidator" runat="server" OnServerValidate="LV_Vyuct_validate" ErrorMessage="[%Chybně vyplněné údaje, nelze pokračovat%]" Display="Dynamic"></asp:CustomValidator>
        </td>
    </tr>
    <tr class="tiskShow">
        <td>
            <table class="celpad4 widthA4" style="margin: 0px; border-collapse: collapse;">
                <tr>
                    <td style="text-align: left; font-weight: bold;" class="border1pxL border1pxT border1pxB">
                        <%= KSProgram.Ciselniky.CisPodniky.Nazev(KSProgram.Funkce.Pracovnik.IdPodniku((OsCislo > 0) ? OsCislo : KSProgram.Globals.OsCislo))%>
                    </td>
                    <td style="text-align: right; font-weight: bold;" class="border1pxR border1pxT border1pxB">KS - portál, <%= KSProgram.Globals.Verze %>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
</table>
<!-- cp_table end -->

<telerik:RadWindow KeepInScreenBounds="true" ID="RadWinCesty" runat="server" AutoSize="False"
    Height="600" Width="1000" InitialBehaviors="Resize" VisibleStatusbar="False"
    Behaviors="Resize, Close, Maximize, Move, Reload" DestroyOnClose="False">
    <ContentTemplate>
        <asp:ObjectDataSource ID="ODS_Cesty" runat="server"
            SelectMethod="CestyAblokaceVozidel" TypeName="KSProgram.Sluzebky.SlcVozidla">
            <SelectParameters>
                <asp:ControlParameter Name="os_cislo" Type="Decimal" ControlID="CP" PropertyName="OsCislo" />
                <%--<asp:ControlParameter Name="druhy" Type="String" ControlID="CP" PropertyName="Druh_dopr" />
                        nastavuji scriptem, protože měním AUC na AUV,AUS --%>
                <asp:Parameter Name="druhy" Type="String" DefaultValue="" />
                <asp:ControlParameter Name="dat_od" Type="DateTime" ControlID="CP" PropertyName="Dat_od" />
                <%--<asp:ControlParameter Name="cas_od" Type="String" ControlID="CP" PropertyName="Cas_od" />
                        nastavuji na 00:00, aby viděl, že vozidlo se má vrátit např. minutu před tím, než chci vyjet--%>
                <asp:Parameter Name="cas_od" Type="String" DefaultValue="00:00" />
                <asp:ControlParameter Name="dat_do" Type="DateTime" ControlID="CP" PropertyName="Dat_do" />
                <%--<asp:ControlParameter Name="cas_do" Type="String" ControlID="CP" PropertyName="Cas_do" />--%>
                <asp:Parameter Name="cas_do" Type="String" DefaultValue="23:59" />
            </SelectParameters>
        </asp:ObjectDataSource>

        <telerik:RadGrid ID="RG_cesty" runat="server" AutoGenerateColumns="false" OnItemCreated="RG_cesty_ItemCreated">
            <MasterTableView AutoGenerateColumns="False" DataKeyNames="spz">
                <GroupByExpressions>
                    <telerik:GridGroupByExpression>
                        <SelectFields>
                            <telerik:GridGroupByField FieldName="cely_nazev" HeaderText="[%Vozidlo%]" />
                        </SelectFields>
                        <GroupByFields>
                            <telerik:GridGroupByField FieldName="spz" SortOrder="Descending" />
                        </GroupByFields>
                    </telerik:GridGroupByExpression>
                </GroupByExpressions>
                <Columns>
                    <%--<telerik:GridButtonColumn UniqueName="SelectButton" Groupable="False" Reorderable="False" CommandName="vyber" Text="[%Vyber vozidlo%]">
                        </telerik:GridButtonColumn>--%>
                    <telerik:GridTemplateColumn UniqueName="SelectButton">
                        <ItemTemplate>
                            <telerik:RadButton runat="server" ID="btn_vyberspz" Text="[%Vyber vozidlo%]" AutoPostBack="False"></telerik:RadButton>
                        </ItemTemplate>
                    </telerik:GridTemplateColumn>

                    <telerik:GridBoundColumn UniqueName="spz" HeaderText="[%SPZ%]" DataField="spz" Visible="false">
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn UniqueName="nazev" HeaderText="[%Název vozidla%]" DataField="nazev" Visible="false">
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn UniqueName="typ_zaznamu" HeaderText="[%Typ záznamu%]" DataField="typ_zaznamu">
                    </telerik:GridBoundColumn>
                    <telerik:GridBoundColumn UniqueName="cil" HeaderText="[%Cíl cesty%]" DataField="cil">
                    </telerik:GridBoundColumn>
                    <telerik:GridDateTimeColumn UniqueName="dat_od" HeaderText="[%Datum počátku%]"
                        DataField="dat_od" DataFormatString="{0:dd.MM.yyyy HH:mm}">
                    </telerik:GridDateTimeColumn>
                    <telerik:GridDateTimeColumn UniqueName="dat_do" HeaderText="[%Datum konce%]"
                        DataField="dat_do" DataFormatString="{0:dd.MM.yyyy HH:mm}">
                    </telerik:GridDateTimeColumn>
                    <telerik:GridBoundColumn UniqueName="cestujici" HeaderText="[%Spolucestující%]" DataField="cestujici">
                    </telerik:GridBoundColumn>
                </Columns>
            </MasterTableView>
        </telerik:RadGrid>

    </ContentTemplate>
</telerik:RadWindow>

<style type="text/css">
    table {
        /*font-size: 12px;*/
        border-width: 0px;
    }

    .widthA4 {
        width: 800px;
    }

    div.ksPozZmenaStavu {
        width: 800px;
    }

    div.ksPozProces {
        width: 800px;
    }

    table.celpad4 > tbody > tr > th, table.celpad4 > tbody > tr > td {
        padding: 4px;
    }

    .border1px {
        border: thin solid #e5e5e5;
        /*padding: 1px 4px;*/
    }

    .border1pxL {
        border-left-style: solid;
        border-left-width: thin;
        border-left-color: #e5e5e5;
        /*padding: 1px 4px;*/
    }

    .border1pxR {
        border-right-style: solid;
        border-right-width: thin;
        border-right-color: #e5e5e5;
        /*padding: 1px 4px;*/
    }

    .border1pxT {
        border-top-style: solid;
        border-top-width: thin;
        border-top-color: #e5e5e5;
        /*padding: 1px 4px;*/
    }

    .border1pxB {
        border-bottom-style: solid;
        border-bottom-width: thin;
        border-bottom-color: #e5e5e5;
        /*padding: 1px 4px;*/
    }

    .theme_header {
        text-align: center;
    }

    .cp_nadpis {
        color: var(--kszahlavitext);
        font-size: 16px !important;
    }

    .cp_podpis {
        font-size: 11px;
        color: var(--kszahlavitext);
    }

    .style1 {
    }

    .style7 {
        text-align: left;
    }

    .style10 {
        text-align: right;
    }

    .style11 {
        width: 134px;
    }

    .style13 {
    }

    .style14 {
        width: 90px;
    }

    .style16 {
        width: 226px;
        text-align: left;
    }

    .style26 {
        width: 75px;
    }

    .style29 {
        width: 226px;
    }

    .style32 {
        width: 105px;
    }

    .style33 {
        width: 72px;
    }

    .style34 {
        width: 220px;
    }

    .style35 {
        text-align: left;
        width: 220px;
    }

    .CP_header {
        text-align: center !important;
        height: 35px;
    }

    .CP_Logo {
        display: none;
        height: 35px;
        width: auto;
        position: absolute;
        margin-left: -320px;
        margin-top: -3px;
    }

    .RadUpload .ruFakeInput {
         width: 250px;
    }

    .read-only {
        background: #e5e5e5;
        color: #767676;
    }

    /* PMEJ 2.09.2025 HID:76635*/
    .tiskButton {
        background-color: #92d050 !important;
    }

    .editovatButton, .ulozitButton{
        background-color: var(--kscolor1) !important;
        color: var(--kscolor1text) !important;
    }


</style>
<style type="text/css" media='<%= (PrintPreview==false)?"print":"all" %>'>
    table {
        font-size: 10px;
    }

    .widthA4 {
        width: 702px;
    }

    table.celpad4 > tbody > tr > th, table.celpad4 > tbody > tr > td {
        padding: 1px 4px;
    }

    .theme_header {
        color: Black;
        background-color: transparent;
        font-weight: bold;
        border-radius: 0px 0px !important;
        border: 1px solid #000000 !important;
        padding: 2px !important;
    }

    .styled-header {
        display: flex;
        width: 100%;
        min-height: 65px;
    }

    .header-logo {
        background: #fff;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        width: 250px;
        max-height: 65px;
        border-right: 1px solid #000;
    }

    .CP_Logo {
        height: 35px;
        width: auto;
        max-width: 200px;
        display: block;
        margin: 0;
    }

    .header-title {
        background: #ccc;
        flex: 1;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
    }

    .cp_nadpis {
        color: Black;
        font-size: 16px !important;
    }

    .cp_podpis {
        font-size: 11px;
        color: Black;
    }

    .tiskHide {
        display: none;
    }

    tr.tiskShow {
        display: table-row;
    }

    .tiskShow {
        display: inherit;
    }

    .border1px {
        border: 1px solid #000000;
        /*padding: 1px 4px;*/
    }

    .border1pxL {
        border-left-style: solid;
        border-left-width: 1px;
        border-left-color: #000000;
        /*padding: 1px 4px;*/
    }

    .border1pxR {
        border-right-style: solid;
        border-right-width: 1px;
        border-right-color: #000000;
        /*padding: 1px 4px;*/
    }

    .border1pxT {
        border-top-style: solid;
        border-top-width: 1px;
        border-top-color: #000000;
        /*padding: 1px 4px;*/
    }

    .border1pxB {
        border-bottom-style: solid;
        border-bottom-width: 1px;
        border-bottom-color: #000000;
        /*padding: 1px 4px;*/
    }
</style>
